package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-09-29'; # DATE
our $VERSION = '0.11'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
        # force minimum version
        'Perl::Examples::Accessors' => {version=>0.05},

        # include the generator modules here so we can show their versions in
        # sample benchmark results produced by PWP:Bencher::Scenario
        (map { $_=>0 } grep {defined} map { $classes->{$_}{generator} }
             keys %$classes),
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.11 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-09-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::Tiny> 1.004

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Mo> 0.40

L<Mojo::Base>

L<Mojo::Base::XS> 0.07

L<Moo> 2.002004

L<Moose> 2.1805

L<Mouse> v2.4.5

L<Object::Simple> 3.1703

L<Perl::Examples::Accessors> 0.08

L<Perl::Examples::Accessors::Array> 0.08

L<Perl::Examples::Accessors::ClassAccessor> 0.08

L<Perl::Examples::Accessors::ClassAccessorArray> 0.08

L<Perl::Examples::Accessors::ClassInsideOut> 0.08

L<Perl::Examples::Accessors::ClassTiny> 0.08

L<Perl::Examples::Accessors::ClassXSAccessor> 0.08

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.08

L<Perl::Examples::Accessors::Hash> 0.08

L<Perl::Examples::Accessors::Mo> 0.08

L<Perl::Examples::Accessors::MojoBase> 0.08

L<Perl::Examples::Accessors::MojoBaseXS> 0.08

L<Perl::Examples::Accessors::Moo> 0.08

L<Perl::Examples::Accessors::Moose> 0.08

L<Perl::Examples::Accessors::Mouse> 0.08

L<Perl::Examples::Accessors::ObjectSimple> 0.08

L<Perl::Examples::Accessors::Scalar> 0.08

L<Perl::Examples::Accessors::SimpleAccessor> 0.08

L<Simple::Accessor> 1.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::Tiny (perl_code)

Code template:

 Perl::Examples::Accessors::ClassTiny->new



=item * Object::Simple (perl_code)

Code template:

 Perl::Examples::Accessors::ObjectSimple->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * Mojo::Base::XS (perl_code)

Code template:

 Perl::Examples::Accessors::MojoBaseXS->new



=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * no generator (array-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * no generator (scalar-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Class::InsideOut (perl_code)

Code template:

 Perl::Examples::Accessors::ClassInsideOut->new



=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Mojo::Base (perl_code)

Code template:

 Perl::Examples::Accessors::MojoBase->new



=item * Simple::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::SimpleAccessor->new



=item * no generator (hash-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 #table1#
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | Class::InsideOut            |    188000 |    5.32   |      1     | 1.6e-09 |      22 |
 | Simple::Accessor            |    330000 |    3.1    |      1.7   | 6.1e-09 |      24 |
 | Class::Tiny                 |    370000 |    2.7    |      2     | 3.3e-09 |      20 |
 | Moose                       |    520000 |    1.9    |      2.8   | 3.3e-09 |      20 |
 | Mo                          |    770000 |    1.3    |      4.1   | 2.1e-09 |      20 |
 | Moo                         |   1019000 |    0.9818 |      5.416 | 1.1e-11 |      20 |
 | Class::Accessor             |   1100000 |    0.92   |      5.8   | 1.7e-09 |      20 |
 | Mouse                       |   1400000 |    0.7    |      7.6   |   1e-09 |      20 |
 | no generator (array-based)  |   1700000 |    0.58   |      9.1   | 8.3e-10 |      20 |
 | Object::Simple              |   2100000 |    0.48   |     11     | 8.3e-10 |      20 |
 | no generator (hash-based)   |   2152000 |    0.4646 |     11.45  | 1.1e-11 |      20 |
 | Mojo::Base                  |   2200000 |    0.455  |     11.7   | 2.1e-10 |      20 |
 | Class::Accessor::Array      |   2360000 |    0.4238 |     12.55  | 1.1e-11 |      20 |
 | no generator (scalar-based) |   2400000 |    0.416  |     12.8   | 2.1e-10 |      20 |
 | Class::XSAccessor           |   3200000 |    0.31   |     17     | 4.5e-10 |      20 |
 | Mojo::Base::XS              |   3200000 |    0.31   |     17     | 3.9e-10 |      23 |
 | Class::XSAccessor::Array    |   3500000 |    0.29   |     18     | 8.7e-10 |      20 |
 +-----------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
