package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-03-31'; # DATE
our $VERSION = '0.04'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.03

L<Perl::Examples::Accessors::ClassAccessor> 0.03

L<Perl::Examples::Accessors::ClassAccessorArray> 0.03

L<Perl::Examples::Accessors::ClassXSAccessor> 0.03

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.03

L<Perl::Examples::Accessors::Hash> 0.03

L<Perl::Examples::Accessors::Mo> 0.03

L<Perl::Examples::Accessors::Moo> 0.03

L<Perl::Examples::Accessors::Moose> 0.03

L<Perl::Examples::Accessors::Mouse> 0.03

L<Perl::Examples::Accessors::Scalar> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * no generator (scalar-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * no generator (hash-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * no generator (array-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest | result_size (b) | errors  | samples |
 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+
 | Moose                       | 4.6e+05   | 2.2       | 1          | 120             | 4.2e-09 | 20      |
 | Mo                          | 7.35e+05  | 1.36      | 1.58       | 120             | 1.3e-09 | 20      |
 | Moo                         | 9.22e+05  | 1.08      | 1.98       | 120             | 4e-10   | 23      |
 | Class::Accessor             | 1.1e+06   | 0.95      | 2.3        | 120             | 1.7e-09 | 20      |
 | Mouse                       | 1.29e+06  | 0.776     | 2.77       | 120             | 4.1e-10 | 21      |
 | no generator (array-based)  | 1.65e+06  | 0.608     | 3.54       | 64              | 2.9e-10 | 20      |
 | no generator (hash-based)   | 2e+06     | 0.51      | 4.2        | 120             | 9.9e-10 | 22      |
 | no generator (scalar-based) | 2.02e+06  | 0.496     | 4.34       | 72              | 2.1e-10 | 20      |
 | Class::Accessor::Array      | 2.08e+06  | 0.482     | 4.46       | 64              | 2.1e-10 | 20      |
 | Class::XSAccessor::Array    | 3.2e+06   | 0.312     | 6.89       | 64              | 8.3e-11 | 20      |
 | Class::XSAccessor           | 3.21e+06  | 0.311     | 6.91       | 120             | 9.2e-11 | 22      |
 +-----------------------------+-----------+-----------+------------+-----------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
