package Bencher::Scenario::StartupExporters;

our $DATE = '2015-12-20'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    module_startup => 1,

    participants => [
        {module=>'Exporter'},
        {module=>'Exporter::Tiny'},
        {module=>'Exporter::Tidy'},
        {module=>'Exporter::Rinci'},
        {module=>'Sub::Exporter'},
    ],
};

1;
# ABSTRACT: Benchmark startup time of some popular Perl Getopt modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::StartupExporters - Benchmark startup time of some popular Perl Getopt modules

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::StartupExporters (from Perl distribution Bencher-Scenario-StartupExporters), released on 2015-12-20.

=head1 SYNOPSIS

 % bencher -m StartupGetoptModules [other option]...

=head1 BENCHMARKED MODULES

L<Exporter>

L<Exporter::Tiny>

L<Exporter::Tidy>

L<Exporter::Rinci>

L<Sub::Exporter>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-StartupExporters>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-StartupExporters>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-StartupExporters>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
