use 5.006;
use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::Compile 2.054

use Test::More;

plan tests => 54 + ($ENV{AUTHOR_TESTING} ? 1 : 0);

my @module_files = (
    'App/lcpan.pm',
    'App/lcpan/Cmd/author_dists.pm',
    'App/lcpan/Cmd/author_mods.pm',
    'App/lcpan/Cmd/author_rdeps.pm',
    'App/lcpan/Cmd/author_rels.pm',
    'App/lcpan/Cmd/author_scripts.pm',
    'App/lcpan/Cmd/authors.pm',
    'App/lcpan/Cmd/authors_by_dist_count.pm',
    'App/lcpan/Cmd/authors_by_filesize.pm',
    'App/lcpan/Cmd/authors_by_mod_count.pm',
    'App/lcpan/Cmd/authors_by_mod_mention_count.pm',
    'App/lcpan/Cmd/authors_by_rdep_count.pm',
    'App/lcpan/Cmd/authors_by_rel_count.pm',
    'App/lcpan/Cmd/authors_by_script_count.pm',
    'App/lcpan/Cmd/contents.pm',
    'App/lcpan/Cmd/copy_mod.pm',
    'App/lcpan/Cmd/copy_rel.pm',
    'App/lcpan/Cmd/copy_script.pm',
    'App/lcpan/Cmd/deps.pm',
    'App/lcpan/Cmd/dist2rel.pm',
    'App/lcpan/Cmd/distmods.pm',
    'App/lcpan/Cmd/dists.pm',
    'App/lcpan/Cmd/dists_by_dep_count.pm',
    'App/lcpan/Cmd/distscripts.pm',
    'App/lcpan/Cmd/doc.pm',
    'App/lcpan/Cmd/extract_mod.pm',
    'App/lcpan/Cmd/extract_rel.pm',
    'App/lcpan/Cmd/extract_script.pm',
    'App/lcpan/Cmd/mentions.pm',
    'App/lcpan/Cmd/mod2dist.pm',
    'App/lcpan/Cmd/mod2rel.pm',
    'App/lcpan/Cmd/mods.pm',
    'App/lcpan/Cmd/mods_by_mention_count.pm',
    'App/lcpan/Cmd/mods_by_rdep_count.pm',
    'App/lcpan/Cmd/mods_from_same_dist.pm',
    'App/lcpan/Cmd/modules.pm',
    'App/lcpan/Cmd/namespaces.pm',
    'App/lcpan/Cmd/rdeps.pm',
    'App/lcpan/Cmd/releases.pm',
    'App/lcpan/Cmd/rels.pm',
    'App/lcpan/Cmd/reset.pm',
    'App/lcpan/Cmd/script2dist.pm',
    'App/lcpan/Cmd/script2mod.pm',
    'App/lcpan/Cmd/script2rel.pm',
    'App/lcpan/Cmd/scripts.pm',
    'App/lcpan/Cmd/scripts_by_mention_count.pm',
    'App/lcpan/Cmd/scripts_from_same_dist.pm',
    'App/lcpan/Cmd/stats.pm',
    'App/lcpan/Cmd/stats_last_index_time.pm',
    'App/lcpan/Cmd/update.pm',
    'App/lcpan/PodParser.pm',
    'LWP/UserAgent/Patch/FilterLcpan.pm'
);

my @scripts = (
    'bin/lcpan',
    'bin/lcpanm'
);

# no fake home requested

my $inc_switch = -d 'blib' ? '-Mblib' : '-Ilib';

use File::Spec;
use IPC::Open3;
use IO::Handle;

open my $stdin, '<', File::Spec->devnull or die "can't open devnull: $!";

my @warnings;
for my $lib (@module_files)
{
    # see L<perlfaq8/How can I capture STDERR from an external command?>
    my $stderr = IO::Handle->new;

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, $inc_switch, '-e', "require q[$lib]");
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$lib loaded ok");

    shift @_warnings if @_warnings and $_warnings[0] =~ /^Using .*\bblib/
        and not eval { require blib; blib->VERSION('1.01') };

    if (@_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
}

foreach my $file (@scripts)
{ SKIP: {
    open my $fh, '<', $file or warn("Unable to open $file: $!"), next;
    my $line = <$fh>;

    close $fh and skip("$file isn't perl", 1) unless $line =~ /^#!\s*(?:\S*perl\S*)((?:\s+-\w*)*)(?:\s*#.*)?$/;
    my @flags = $1 ? split(' ', $1) : ();

    my $stderr = IO::Handle->new;

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, $inc_switch, @flags, '-c', $file);
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$file compiled ok");

    shift @_warnings if @_warnings and $_warnings[0] =~ /^Using .*\bblib/
        and not eval { require blib; blib->VERSION('1.01') };

    # in older perls, -c output is simply the file portion of the path being tested
    if (@_warnings = grep { !/\bsyntax OK$/ }
        grep { chomp; $_ ne (File::Spec->splitpath($file))[2] } @_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
} }



is(scalar(@warnings), 0, 'no warnings found')
    or diag 'got warnings: ', ( Test::More->can('explain') ? Test::More::explain(\@warnings) : join("\n", '', @warnings) ) if $ENV{AUTHOR_TESTING};


