# This Makefile.PL for JSON-Any was generated by
# inc::MakeMaker <self>.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use 5.008;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Wrapper Class for the various JSON classes.",
  "AUTHOR" => "Chris Thompson <cthom\@cpan.org>, Chris Prather <chris\@prather.org>, Robin Berjon <robin\@berjon.com>, Marc Mims <marc\@questright.com>, Tomas Doran <bobtfish\@bobtfish.net>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "JSON-Any",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "JSON::Any",
  "PREREQ_PM" => {},
  "TEST_REQUIRES" => {
    "Test::Without::Module" => "0.17"
  },
  "VERSION" => "1.31",
  "test" => {
    "TESTS" => "t/*.t"
  }
);
;

  
    sub has_json () {
        our @order = qw(CPANEL XS PP JSON DWIW);
        foreach my $testmod (@order) {
            $testmod = "JSON::$testmod" unless $testmod eq "JSON";
            $testmod = "Cpanel::JSON::XS" if $testmod eq "JSON::CPANEL";
            eval "require $testmod";
            return 1 unless $@;
        }
        return 0;
    }

    if (has_json) {
        # we have some kind of supported JSON module, we're good
    }
    else {

        # we need to have a version of JSON, go with JSON.pm as a sane default
        $WriteMakefileArgs{PREREQ_PM}{JSON} = '2.90';
    }
    
  


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



