# 
# Helper routines for the Slurm::Sshare *-parse.t tests
#
# Basically, this is the data output from fake_sshare in Perlish format
#
# Any changes here need to be reflected in fake_sshare and vica versa, otherwise
# tests will fail.

my @sshare_test_data = 
(
  #Cluster yottascale
     #yottascale/root 

	{	account => 'root',
		cluster => 'yottascale',
		normalized_shares => 1.000000,
		raw_usage => 42000000,
		effective_usage => 0.000000,
		fairshare => 1.000000,
		cpurunmins => 5700070,
	},

     #yottascale/abc124
	{	account => 'abc124',
		cluster => 'yottascale',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 20000000,
		normalized_usage => 0.476190,
		effective_usage => 0.476190,
		fairshare => 0.321144,
		grpcpumins => 12321153,
		cpurunmins => 3156000,
	},

       #yottascale/abc124/george
	{	account => 'abc124',
		cluster => 'yottascale',
		user => 'george',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 5049600,
		normalized_usage => 0.120226,
		effective_usage => 0.120226,
		grpcpumins => 0.000000,
		cpurunmins => 315520,
	},

       #yottascale/abc124/kevin
	{	account => 'abc124',
		cluster => 'yottascale',
		user => 'kevin',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 11960320,
		normalized_usage => 0.284770,
		effective_usage => 0.284770,
		grpcpumins => 0.000000,
		cpurunmins => 1420240,
	},

       #yottascale/abc124/payerle: 3 records
	{	account => 'abc124',
		cluster => 'yottascale',
		user => 'payerle',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 1495040,
		normalized_usage => 0.035596,
		effective_usage => 0.035596,
		grpcpumins => 0.000000,
		cpurunmins => 236707,
	},
	{	account => 'abc124',
		cluster => 'yottascale',
		user => 'payerle',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 996693,
		normalized_usage => 0.023737,
		effective_usage => 0.023737,
		grpcpumins => 0.000000,
		cpurunmins => 473413,
	},
	{	account => 'abc124',
		cluster => 'yottascale',
		user => 'payerle',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 498347,
		normalized_usage => 0.011865,
		effective_usage =>  0.011865,
		grpcpumins => 0.000000,
		cpurunmins => 710120,
	},

     #yottascale/fbi
	{	account => 'fbi',
		cluster => 'yottascale',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 16500000,
		normalized_usage => 0.392857,
		effective_usage => 0.392857,
		fairshare => 0.500000,
		grpcpumins => 30000000,
		cpurunmins => 1234000,
	},

       #yottascale/fbi/george
	{	account => 'fbi',
		cluster => 'yottascale',
		user => 'george',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 4125000,
		normalized_usage => 0.098214,
		effective_usage => 0.098214,
		grpcpumins => 0.000000,
		cpurunmins => 308500,
	},

       #yottascale/fbi/payerle: 3 records
	{	account => 'fbi',
		cluster => 'yottascale',
		user => 'payerle',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 4125000,
		normalized_usage => 0.098214,
		effective_usage => 0.098214,
		grpcpumins => 0.000000,
		cpurunmins => 308500,
	},
	{	account => 'fbi',
		cluster => 'yottascale',
		user => 'payerle',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 4125000,
		normalized_usage => 0.098214,
		effective_usage => 0.098214,
		grpcpumins => 0.000000,
		cpurunmins => 308500,
	},
	{	account => 'fbi',
		cluster => 'yottascale',
		user => 'payerle',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 4125000,
		normalized_usage => 0.098214,
		effective_usage => 0.098214,
		grpcpumins => 0.000000,
		cpurunmins => 308500,
	},

     #yottascale/nsa
	{	account => 'nsa',
		cluster => 'yottascale',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 5500000,
		normalized_usage => 0.130952,
		effective_usage => 0.130952,
		fairshare => 0.500000,
		grpcpumins => 90000000,
		cpurunmins => 1111111,
	},

       #yottascale/nsa/george
	{	account => 'nsa',
		cluster => 'yottascale',
		user => 'george',
		raw_shares => 1,
		normalized_shares => 0.333333,
		raw_usage => 5500000,
		normalized_usage => 0.130952,
		effective_usage => 0.130952,
		grpcpumins => 0.000000,
		cpurunmins => 1111111,
	},

  #Cluster test
     #test/root 
	{	account => 'root',
		cluster => 'test',
		normalized_shares => 1.000000,
		raw_usage => 12400,
		effective_usage => 0.000000,
		fairshare => 1.000000,
		cpurunmins => 248,
	},

     #test/abc124
	{	account => 'abc124',
		cluster => 'test',
		raw_shares => 1,
		normalized_shares => 1.000000,
		raw_usage => 12400,
		normalized_usage => 1.000000,
		effective_usage => 1.000000,
		fairshare => 0.321144,
		grpcpumins => 98765432,
		cpurunmins => 248,
	},

       #test/abc124/george
	{	account => 'abc124',
		cluster => 'test',
		user => 'george',
		raw_shares => 1,
		normalized_shares => 0.500000,
		raw_usage => 0,
		normalized_usage => 0.000000,
		effective_usage => 0.000000,
		grpcpumins => 0.000000,
		cpurunmins => 0,
	},
			    
       #test/abc124/payerle
	{	account => 'abc124',
		cluster => 'test',
		user => 'payerle',
		raw_shares => 1,
		normalized_shares => 0.500000,
		raw_usage => 1240,
		normalized_usage => 1.000000,
		effective_usage => 1.000000,
		grpcpumins => 0.000000,
		cpurunmins => 248,
	},
);


sub filter_data_list($$$)
#Takes list ref of hash refs, plus a key and value to filter on.
#Returns a list ref of hash refs; the subset of the original list (in same order)
#for which the filter matches.
#
#The filter matches when ($href is the hash ref being tested)
#If value is:
#	undef: the $href has no key $key, or it has an undef value
#	non-ref scalar: $href->{$key} eq $val
#	empty list ref: same as undef
#	non-empty list ref: $href->{$key} eq one of the values of the list ref
# The non-empty list can contain an undef value, which matches similar to an undef scalar.
{	my $list = shift;
	my $key = shift;
	my $val = shift;
	my $me = 'filter_data';

	die "$me: Invalid list $list; expecting a list ref at " 
		unless $list && ref($list) eq 'ARRAY';

	my $filtered = [];

	#Convert $val to list ref or undef
	if ( defined $val )
	{	if ( ref($val) eq 'ARRAY' )
		{	if ( scalar(@$val) == 0 )
			{	$val = undef;
			}
		} elsif ( ref($val) )
		{	die "$me: Invalid value $val: expecting scalar or list ref at "
		} else
		{	$val = [ $val ];
		}
	} 


	HREF: foreach my $href (@$list)
	{	my $hval = $href->{$key};
		if ( defined $val )
		{	#next HREF unless defined $hval;
			foreach my $tmpval (@$val)
			{	if ( defined $tmpval )
				{	if ( defined $hval && $hval eq $tmpval )
					{	push @$filtered, $href;
						next HREF;
					}
				} else
				{	#tmpval not defined, match if hval also undef
					unless ( defined $hval )
					{	push @$filtered, $href;
						next HREF;
					}
				}
			}
			next HREF;
		} else
		{	push @$filtered, $href unless defined $hval;
			next HREF;
		}
	}

	return $filtered;
}

sub filtered_test_data(@)
#Takes a hash of key => val pairs as filter, and returns subset of @sshare_test_data which
#matches filter.  The filter is applied for each key separately, with results ANDed
#If val is undef or empty list ref, filter only matches if key is missing or undef value in
#the hash ref being tested.  For a non-ref scalar value, matches if value matches (string
#comparison).  For non-empty list ref, matches if value of key in hash ref being tested
#matches any element of the list.
{	my %where = @_;

	my $list = [ @sshare_test_data ];
	foreach my $key (keys %where)
	{	my $val = $where{$key};

		$list = filter_data_list($list,$key, $val);
	}
	return $list;
}

sub compare_href_results($$;$)
#Compares expected/got hash refs for a single sshare line
#
{       my $got = shift || {};
	my $expected = shift || {};
        my $name = shift || 'compare_href_results';

	my @text_fields = qw( 
		account 
		user 
		cluster
	);
	my @num_fields = qw( 
		raw_shares 
		normalized_shares
		raw_usage
		normalized_usage
		effective_usage
		fairshare
		grpcpumins
		cpurunmins
	);
	my $numtests = scalar(@text_fields)  + scalar(@num_fields);

        subtest $name => sub {
                plan tests => $numtests;

		my $fld;
		foreach $fld (@text_fields)
		{	is( $got->{$fld}, $expected->{$fld}, "${name}: $fld");
		}
		NUMFLD: foreach $fld (@num_fields)
		{	my $gval = $got->{$fld};
			my $xval = $expected->{$fld};
			if ( ! defined $gval && ! defined $xval )
			{	#Neither defined, guess that's a pass
				pass("${name}: $fld (neither defined)");
				next NUMFLD;
			}
			unless ( defined $gval )
			{	fail("${name}: $fld (got value undef)");
				next NUMFLD;
			}
			unless ( defined $xval )
			{	fail("${name}: $fld (expected value undef)");
				next NUMFLD;
			}
			cmp_ok( $gval, '==', $xval, "${name}: $fld");
		}
        };
}

sub compare_lref_results($$;$)
#Compares two list refs of hash refs
#
{       my $got = shift || [];
	my $expected = shift || [];
        my $name = shift || 'compare_lref_results';

	$num_tests_run++;

	my $numtests = scalar(@$expected);
	$numtests = scalar(@$got) if scalar(@$got) > $numtests;
	unless ( $numtests )
	{	pass("${name}: both lists empty");
		return;
	}

        subtest $name => sub {
                plan tests => $numtests;

		my $index;
		INDEX: foreach $index ( 0 .. ($numtests-1) )
		{	my $gothref = $got->[$index];
			my $exphref = $expected->[$index];
			
			if ( ! defined $gothref && ! defined $exphref )
			{	#Neither defined, guess that's a pass
				pass("${name} [element $index] --- neither href defined");
				next INDEX;
			}
			unless ( defined $gothref )
			{	fail("${name} [element $index] --- got href not defined");
				next INDEX;
			}
			unless ( defined $exphref )
			{	fail("${name} [element $index] --- exp href not defined");
				next INDEX;
			}
		
			compare_href_results($gothref, $exphref, "${name} [element $index]");
		}
			
        };
}


1;

