package Chart::Plotly::Trace::Splom::Dimension::Axis;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

our $VERSION = '0.035';    # VERSION

# ABSTRACT: This attribute is one of the possible options for the trace splom.

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has matches => (
    is  => "rw",
    isa => "Bool",
    documentation =>
      "Determines whether or not the x & y axes generated by this dimension match. Equivalent to setting the `matches` axis attribute in the layout with the correct axis id.",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Splom::Dimension::Axis - This attribute is one of the possible options for the trace splom.

=head1 VERSION

version 0.035

=head1 SYNOPSIS

 use Chart::Plotly qw(show_plot);
 use Chart::Plotly::Trace::Splom;
 
 use Data::Dataset::Classic::Iris;
 
 my $convert_array_to_arrayref = sub {[@_]};
 my $iris = Data::Dataset::Classic::Iris::get(as => 'Data::Table');
 my $data = $iris->group(['species'],[$iris->header], [$convert_array_to_arrayref, $convert_array_to_arrayref, $convert_array_to_arrayref, $convert_array_to_arrayref, $convert_array_to_arrayref], [map { join "", map {ucfirst} split /_/, $_ } $iris->header], 0 );
 
 my @data_to_plot;
 my $iterator = $data->iterator();
 while (my $row = $iterator->()) {
     my $dimensions = [
         map { { label => $_, values => $row->{$_} } } qw(SepalLength SepalWidth PetalLength PetalWidth)
     ];
     push @data_to_plot, Chart::Plotly::Trace::Splom->new(
         name => $row->{species},
         dimensions => $dimensions
     );
 }
 
 show_plot([@data_to_plot]);

=head1 DESCRIPTION

This attribute is part of the possible options for the trace splom.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#splom>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * matches

Determines whether or not the x & y axes generated by this dimension match. Equivalent to setting the `matches` axis attribute in the layout with the correct axis id.

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
