'\"
'\" Copyright (c) 1996, Expert Interface Technologies
'\"
'\" See the file "license.terms" for information on usage and
'\" redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
.TH Tk::tixGrid n 4.1 Tk "Tk Widget Classes"
.BS
.SH NAME
Tk::Grid \- Create and manipulate Tix Grid widgets
.SH SYNOPSIS
\fI$tixgrid\fR = \fI$parent\fR->\fBtixGrid\fR(\fR?\fIoptions\fR?\fR);
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5c 11c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBfont\fR	\fBforeground\fR	\fBheight\fR
\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBrelief\fR
\fBselectBackground\fR	\fBselectForeground\fR	\fBwidth\fR
\fBxScrollCommand\fR	\fByScrollCommand\fR	\fB\fR
.fi
.LP
See the \fBoptions(n)\fR manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 5c
.LP
.nf
Name:	\fBeditDoneCmd\fR
Class:	\fBEditDoneCmd\fR
Switch:	\fB\-editdonecmd\fR
.fi
.IP
If non-empty, gives a perl/Tk \fBcallback\fR to be executed when the user has edited grid cell. When this command is called, it is passed with two additional parameters: \fIx\fR \fIy\fR, where (\fIx\fR,\fIy\fR) is the location of the cell that has just been edited.
.LP
.nf
Name:	\fBeditNotifyCmd\fR
Class:	\fBEditNotifyCmd\fR
Switch:	\fB\-editnotifycmd\fR
.fi
.IP
If non-empty, gives a Tcl command to be executed when the user tries to edit a grid cell. When this command is called, it is passed with two additional parameters: \fIx\fR \fIy\fR, where (\fIx\fR,\fIy\fR,) is the location of the cell. This command should return a boolean value: \fBtrue\fR indicates that the cells is editable and \fBfalse\fR otherwise.
.LP
.nf
Name:	\fBformatCmd\fR
Class:	\fBFormatCmd\fR
Switch:	\fB\-formatcmd\fR
.fi
.IP
If non-empty, gives a perl/Tk \fBcallback\fR to be executed when the grid cells need to be formatted on the screen. Normally, this command calls the \fBformat\fR method (see below). When this command is called, it is passed with five additional parameters: \fItype\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR. \fItype\fR gives the logical type of the region in the grid. It may be one of the following. \fBx-region\fR: the horizontal margin; \fBy-region\fR: the vertical margin; \fBs-region\fR, the area where the the horizontal and vertical margins are joined; \fBmain\fR: all the cells that do not fall into the above three types.  \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR gives the extent of the region that needs formatting.
.LP
.nf
Name:	\fBleftMargin\fR
Class:	\fBLeftMargin\fR
Switch:	\fB\-leftmargin\fR
.fi
.IP
In the number of cells, gives the width of vertical margin. A zero indicates that no vertical should be drawn.
.LP
.nf
Name:	\fBselectMode\fR
Class:	\fBSelectMode\fR
Switch:	\fB\-selectmode\fR
.fi
.IP
Specifies one of several styles for manipulating the selection. The value of the option may be arbitrary, but the default bindings expect it to be either \fBsingle\fR, \fBbrowse\fR, \fBmultiple\fR, or \fBextended\fR; the default value is \fBsingle\fR.
.LP
.nf
Name:	\fBselectUnit\fR
Class:	\fBSelectUnit\fR
Switch:	\fB\-selectunit\fR
.fi
.IP
Specifies the selection unit. Valid values are \fBcell\fR, \fBcolumn\fR or \fBrow\fR.
.LP
.nf
Name:	\fBtopMargin\fR
Class:	\fBTopMargin\fR
Switch:	\fB\-topmargin\fR
.fi
.IP
In the number of cells, gives the height of horizontal margin. A zero indicates that no horizontal should be drawn.
.BE
.SH DESCRIPTION
The \fBTixGrid\fR method creates a new window (given by the $widget\fR argument) and makes it into a \fBtixGrid\fR widget.  Additional options, described above, may be specified on the command line or in the option database to configure aspects of the \fBtixGrid\fR widget such as its cursor and relief.
.PP
A Grid widget displays its contents in a two dimensional grid of cells. Each cell may contain one Tix \fBdisplay\fR \fBitem\fR, which may be in text, graphics or other formats. See the \fBtixItemType(n)\fR manual page for more information about Tix display items. Individual cells, or groups of cells, can be formatted with a wide range of attributes, such as its color, relief and border.
.SH "WIDGET METHODS"
.PP
The \fBTixGrid\fR method creates a widget object whose name is the same as the path name of the \fBtixGrid\fR widget's window. This command may be used to invoke various operations on the widget. It has the following general form:
.DS C
\fI$tixgrid\fR->\fBmethod\fR(?\fIarg arg ...\fR?)
.PP
.DE
\fIPathName\fR is the name of the command, which is the same as the \fBtixGrid\fR widget's path name. \fIOption\fR and the \fIarg\fRs determine the exact behavior of the command. The following commands are possible for \fBtixGrid\fR widgets:
.TP
$widget\fR \fBanchor\fR \fIoption\fR \fR?\fIargs\fR \fI...\fR\fR?
Manipulates the \fBanchor cell\fR of the \fBtixGrid\fR widget. The anchor cell is the end of the selection that is fixed while the user is dragging out a selection with the mouse.
.TP
$widget\fR \fBbdtype\fR
.TP
$widget\fR \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given by \fIoption\fR. \fIOption\fR may have any of the values accepted by the \fBtixGrid\fR command.
.TP
$widget\fR \fBconfigure\fR \fR?\fIoption\fR\fR? \fR?\fIvalue\fR \fIoption\fR \fIvalue\fR \fI...\fR\fR?
Query or modify the configuration options of the widget.  If no \fIoption\fR is specified, returns a list describing all of the available options for $widget\fR (see \fBTk_ConfigureInfo(n)\fR for information on the format of this list.) If \fIoption\fR is specified with no \fIvalue\fR, then the command returns a list describing the one named option (this list will be identical to the corresponding sublist of the value returned if no \fIoption\fR is specified). If one or more \fIoption\-value\fR pairs are specified, then the command modifies the given widget option(s) to have the given value(s); in this case the command returns an empty string. \fIOption\fR may have any of the values accepted by the \fBtixGrid\fR command.
.TP
$widget\fR \fBdelete\fR \fIdim\fR \fIfrom\fR \fR?\fIto\fR\fR?
\fIDim\fR may be \fBrow\fR or \fBcolumn\fR. If \fIto\fR is not given, deletes a single row (or column) at the position \fIfrom\fR. If \fIto\fR is given, deletes the range of rows (or columns) from position \fIfrom\fR through \fIto\fR.
.TP
$widget\fR \fBedit apply\fR
If any cell is being edited, de-highlight the cell and applies the changes.
.TP
$widget\fR \fBedit set\fR \fIx\fR \fIy\fR
Highlights the cell at (\fIx\fR,\fIy\fR) for editing, if the \fB-editnotify\fR command returns true for this cell.
.TP
$widget\fR \fBentrycget\fR \fIx\fR \fIy\fR \fIoption\fR
Returns the current value of the configuration option given by \fIoption\fR of the cell at (\fIx\fR,\fIy\fR). \fIOption\fR may have any of the values accepted by the \fBset\fR method.
.TP
$widget\fR \fBentryconfigure\fR \fIx\fR \fIy\fR \fR?\fIoption\fR\fR? \fR?\fIvalue\fR \fIoption\fR \fIvalue\fR \fI...\fR\fR?
Query or modify the configuration options of the cell at (\fIx\fR,\fIy\fR).  If no \fIoption\fR is specified, returns a list describing all of the available options for the cell (see \fBTk_ConfigureInfo(n)\fR for information on the format of this list.)  If \fIoption\fR is specified with no \fIvalue\fR, then the command returns a list describing the one named option (this list will be identical to the corresponding sublist of the value returned if no \fIoption\fR is specified.) If one or more \fIoption\-value\fR pairs are specified, then the command modifies the given widget option(s) to have the given value(s); in this case the command returns an empty string.  \fIOption\fR may have any of the values accepted by the \fBset\fR method.
.TP
$widget\fR \fBformat\fR
.TP
$widget\fR \fBindex\fR
.TP
$widget\fR \fBmove\fR \fIdim\fR \fIfrom\fR \fIto\fR \fIoffset\fR
\fIDim\fR may be \fBrow\fR or \fBcolumn\fR. Moves the the range of rows (or columns) from position \fIfrom\fR through \fIto\fR by the distance indicated by \fIoffset\fR. For example, \fBmove\fR \fBrow\fR \fB2\fR \fB4\fR \fB1\fR moves the rows 2,3,4 to rows 3,4,5.
.TP
$widget\fR \fBset\fR \fIx\fR \fIy\fR \fR?\fI\fB-itemtype\fR\fR \fItype\fR\fR? \fR?\fIoption\fR \fIvalue...\fR\fR?
Creates a new display item at the cell at (\fIx\fR,\fIy\fR). The optional \fB-itemtype\fR parameter gives the type of the display item. An additional list of \fIoption-value\fR pairs specify options of the display item. If a display item already exists at this cell, the old item will be deleted automatically.
.TP
$widget\fR \fBsize\fR \fIdim\fR \fIindex\fR \fR?\fIoption\fR \fIvalue\fR \fI...\fR\fR?
Queries or sets the size of the row or column given by \fIdim\fR and \fIindex\fR. \fIDim\fR may be \fBrow\fR or \fBcolumn\fR.  \fIIndex\fR may be any non-negative integer that gives the position of a given row (or column). \fIIndex\fR can also be the string \fBdefault\fR; in this case, this command queries or sets the default size of all rows (or columns).

When no \fIoption\fR-\fIvalue\fR pair is given, this command returns a list containing the current size setting of the given row (or column). When \fIoption\fR-\fIvalue\fR pairs are given, the corresponding options of the size setting of the given row are changed. \fIOption\fR may be one of the follwing:
.RS
.TP
\fB-pad0\fR \fIpixels\fR
Specifies the paddings to the left or a column or the top of a row.
.TP
\fB-pad1\fR \fIpixels\fR
Specifies the paddings to the right or a column or the bottom of a row.
.TP
\fB-size\fR \fIval\fR
Specifies the width of a column or the height of a row. \fIVal\fR may be: \fBauto\fR -- the width of the column is set the the widest cell in the column; a valid Tk screen distance unit (see \fBTk_GetPixels(n)\fR); or a real number following by the word \fBchars\fR (e.g. \fB3.4chars\fR) that sets the width of the column to the given number of characters.
.RE
.TP
$widget\fR \fBunset\fR \fIx\fR \fIy\fR
Clears the cell at (\fIx\fR,\fIy\fR) by removing its display item.
.TP
$widget\fR \fBxview\fR
.TP
$widget\fR \fByview\fR
.DE

