use ExtUtils::MakeMaker;
use Config;

my $pkg = 'Net::DNSBL::Monitor';
$pkg =~ /[^:]+$/;
my $module = $& .'.pm';

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

WriteMakefile(
    'NAME'		=> $pkg,
    'VERSION_FROM'	=> $module, # finds $VERSION
    'PREREQ_PM'		=> {	Net::DNS::Codes		=> 0.09,
				Net::DNS::ToolKit	=> 0.41,
				Net::DNSBL::MultiDaemon	=> 0.22,
				NetAddr::IP	=> 4.003,
			},
    'clean'		=> { FILES    => "*~ tmp*"},
    'dist'		=> {COMPRESS=>'gzip', SUFFIX=>'gz'}
);

eval {
	require Net::DNS::ToolKit;
};
die "prerequisite Net::DNS::ToolKit not found\n"
	if $@;
@_ = &Net::DNS::ToolKit::get_ns();
if (@_) {
  foreach(@_) {
    print 'found nameserver ',&Net::DNS::ToolKit::inet_ntoa($_),"\n";
  }
} else {
  die "resolver not configured, $pkg will not run\n";
}

sub MY::top_targets {
  package MY;
  my $inherited = shift->SUPER::top_targets(@_);
  $inherited =~ s/(pure_all\s+::.+)/$1 README/;
  $inherited;
}

sub MY::post_constants {
  my $post_constants = q|
MY_POD2TEXT = |. $Config{scriptdirexp} .'/pod2text' .q|   
|;
} 

sub MY::postamble {
  package MY;
  my $postamble = q|
README  : |. $module .q|
	@$(MY_POD2TEXT) |. $module .q| > README

|;
}
