use strict;
use warnings;
use Data::Dump qw/dd ddx pp/;
use Test::More;
use DBI;
BEGIN {
  # --- monkey patching
  # check if package exists

  # store old sub
  my $old = \&DBI::connect;

  my $new = sub {
    dd "connect() patched", \@_;
    goto &$old;
  };
no warnings qw/redefine/;
  *DBI::connect = $new;

}
my $dbh = DBI->connect("dbi:SQLite:dbname=/tmp/dbfile");#,"","",{ RaiseError => 1});

$dbh->do("DROP TABLE IF EXISTS test_table;"); #TODO ERR

$dbh->do("CREATE TABLE test_table (f1,f2,f3);");
#--- populate test data
my $sth = $dbh->prepare("INSERT INTO test_table VALUES (?,?,?);");

for my $i (1,4,7) {
  $sth->execute($i..$i+2);
}



pp my $table_a = $dbh->selectall_arrayref("SELECT * FROM test_table");

is_deeply ($table_a, [[1, 2, 3], [4, 5, 6], [7, 8, 9]], "check_content");

done_testing();
