package # hide from PAUSE
App::YTDL::Arguments;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( from_arguments_to_choices );

use Term::ANSIScreen       qw( :cursor :screen );
use Term::Choose           qw( choose );
use URI                    qw();
use URI::Escape            qw( uri_unescape );

use App::YTDL::Get_Data      qw( get_yt_download_info_as_h_ref get_download_info_as_json );
use App::YTDL::Data_Extract  qw( add_entry_to_info_hash json_to_hash );
use App::YTDL::Choose_Videos qw( choose_videos );



sub from_arguments_to_choices {
    my ( $opt, @ids ) = @_;
    my $info = {};
    my $invalid_char = $opt->{invalid_char};
    my $more = 0;
    for my $id ( @ids ) {
        $opt->{length_view_count} = 0;
        if ( my $channel_id = _user_id( $opt, $id ) ) {
            my $tmp = _id_to_tmp_info_hash( $opt, 'CL', $channel_id );
            my $ex = 'youtube';
            my ( $vi ) = keys %{$tmp->{$ex}};
            my $prompt = $tmp->{$ex}{$vi}{uploader};
            choose_videos( $opt, $info, $tmp, $ex, $prompt );
        }
        elsif ( my $playlist_id = _playlist_id( $opt, $id ) ) {
            my $tmp = _id_to_tmp_info_hash( $opt, 'PL', $playlist_id );
            my $ex = 'youtube';
            my $prompt = $playlist_id;
            choose_videos( $opt, $info, $tmp, $ex, $prompt );
        }
        elsif ( my $more_ids = _more_ids( $opt, $id ) ) {
            my $tmp = _more_url_to_tmp_info_hash( $opt, $more_ids );
             my $ex = 'youtube';
             my $prompt = $more_ids;
            choose_videos( $opt, $info, $tmp, $ex, $prompt );
        }
        elsif ( my $video_id = _video_id( $opt, $id )  ) {
            my $ex = 'youtube';
            $info->{$ex}{$video_id}{extractor} = 'youtube';
        }
        else {
            my $tmp = _non_yt_id_to_tmp_info_hash( $opt, $id );
            my ( $ex ) = keys %$tmp;
            my @keys = keys %{$tmp->{$ex}};
            if ( @keys == 1 ) {
                my $video_id = $keys[0];
                $info->{$ex}{$video_id} = $tmp->{$ex}{$video_id};
            }
            else {
                my $prompt = $id;
                choose_videos( $opt, $info, $tmp, $ex, $prompt );
            }
        }
    }
    return $info;
}


sub _video_id {
    my ( $opt, $id ) = @_;
    my $invalid_char = $opt->{invalid_char};
    if ( ! $id ) {
        return;
    }
    if ( $id =~ m{^[\p{PerlWord}-]{11}\z} ) {
        return $id;
    }
    if ( $id !~ $opt->{yt_regexp} ) {
        return;
    }
    elsif ( $id =~ m{/.*?[?&;!](?:v|video_id)=([^$invalid_char]+)} ) {
        return $1;
    }
    elsif ( $id =~ m{/(?:e|v|embed)/([^$invalid_char]+)} ) {
        return $1;
    }
    elsif ( $id =~ m{#p/(?:u|search)/\d+/([^&?/]+)} ) {
        return $1;
    }
    elsif ( $id =~ m{youtu.be/([^$invalid_char]+)} ) {
        return $1;
    }
    return;
}

sub _playlist_id {
    my ( $opt, $id ) = @_;
    my $invalid_char = $opt->{invalid_char};
    if ( ! $id )                                        {
        return;
    }
    if ( $id =~ m{^p#(?:[FP]L)?([^$invalid_char]+)\z} ) {
        return $1;
    }
    if ( $id !~ $opt->{yt_regexp} ) {
        return;
    }
    elsif ( $id =~ m{/.*?[?&;!]list=([^$invalid_char]+)} ) {
        return $1;
    }
    elsif ( $id =~ m{^\s*([FP]L[\w\-]+)\s*\z} ) {
        return $1;
    }
    return;
}

sub _user_id {
    my ( $opt, $id ) = @_;
    my $invalid_char = $opt->{invalid_char};
    if ( ! $id ) {
        return;
    }
    if ( $id =~ m{^c#([^$invalid_char]+)\z} ) {
        return $1;
    }
    if ( $id !~ $opt->{yt_regexp} ) {
        return;
    }
    elsif ( $id =~ m{/user/([^$invalid_char]+)} ) {
        return $1;
    }
    elsif ( $id =~ m{/channel/([^$invalid_char]+)} ) { # ?
        return $1;
    }
    return;
}

sub _more_ids {
    my ( $opt, $id ) = @_;
    my $invalid_char = $opt->{invalid_char};
    if ( ! $id ) {
        return;
    }
    elsif ( $id !~ $opt->{yt_regexp} ) {
        return;
    }
    elsif ( uri_unescape( $id ) =~ m{youtu\.?be.*video_ids=([^$invalid_char]+(?:,[^$invalid_char]+)*)} ) {
        return $1;
    }
    return;
}


sub _id_to_tmp_info_hash {
    my( $opt, $type, $list_id ) = @_;
    printf "Fetching %s info ... \n", $type eq 'PL' ? 'playlist' : 'channel';
    my $url = URI->new( $type eq 'PL'
        ? 'https://gdata.youtube.com/feeds/api/playlists/' . $list_id
        : 'https://gdata.youtube.com/feeds/api/users/'     . $list_id . '/uploads'
    );
    my $ex = 'youtube';
    my $tmp = {};
    my $start_index = 1;
    my $max_results = 50;
    my $count_entries = $max_results;
    while ( $count_entries == $max_results ) {  # or <link rel='next'>
        $url->query_form( 'start-index' => $start_index, 'max-results' => $max_results, 'v' => $opt->{yt_api_v}, 'alt' => 'json' );
        $start_index += $max_results;
        my $h_ref = get_yt_download_info_as_h_ref( $opt, $url->as_string );
        if ( ! defined $h_ref ) {
            my $err_msg = $type . ': ' . $list_id . '   ' . ( $start_index - $max_results ) . '-' . $start_index;
            push @{$opt->{error_get_download_infos}}, $err_msg;
            next;
        }
        my $entries = $h_ref->{feed}{entry};
        if ( ! defined $entries ) {
            last; #
        }
        $count_entries = @$entries;
        if ( ! $count_entries ) {
            last;
        }
        for my $entry ( @$entries ) {
            add_entry_to_info_hash( $opt, $tmp, $entry, $type, $list_id );
        }
        if ( $opt->{nr_of_latest_videos} && $start_index > $opt->{nr_of_latest_videos} ) {
            last;
        }
    }
    if ( ! keys %{$tmp->{$ex}} ) {
        my $prompt = "No videos found: $type - $url";
        choose( [ 'Print ENTER' ], { prompt => $prompt } );
    }
    my $up = keys %{$tmp->{$ex}};
    print up( $up + 2 ), cldown;
    return $tmp;
}


sub _more_url_to_tmp_info_hash {
    my ( $opt, $more_ids ) = @_;
    my $tmp = {};
    for my $video_id ( split /,/, $more_ids ) {
        my $url = URI->new( 'https://gdata.youtube.com/feeds/api/videos/' . $video_id );
        $url->query_form( 'v' => $opt->{yt_api_v}, 'alt' => 'json' );
        my $h_ref = get_yt_download_info_as_h_ref( $opt, $url );
        if ( ! defined $h_ref ) {
            my $err_msg = 'Video group: ' . $more_ids . ' - ' . $video_id . '   ' . $url;
            push @{$opt->{error_get_download_infos}}, $err_msg;
            next;
        }
        my $entry = $h_ref->{feed}{entry};
        add_entry_to_info_hash( $opt, $tmp, $entry );
    }
    return $tmp;
}


sub _non_yt_id_to_tmp_info_hash {
    my ( $opt, $id ) = @_;
    my $message = "Fetching download info: ";
    my $json_all = get_download_info_as_json( $opt, $id, $message );
    my $tmp = {};
    return $tmp if ! $json_all;
    for my $json ( split /\n+/, $json_all ) {
        json_to_hash( $opt, $tmp, $json );
    }
    return $tmp;
}



1;


__END__
