# Copyright 2015 Kevin Ryde
#
# This file is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# This file is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this file.  See the file COPYING.  If not, see
# <http://www.gnu.org/licenses/>.

use strict;
use 5.004;
use Test;
# before warnings checking since Graph.pm 0.96 is not safe to non-numeric
# version number from Storable.pm
use Graph;

use lib 't';
use MyTestHelpers;
BEGIN { MyTestHelpers::nowarnings() }

# uncomment this to run the ### lines
# use Smart::Comments;

plan tests => 7;


use lib
  'devel/lib';
require Graph::Maker::Beineke;

#------------------------------------------------------------------------------
{
  my $want_version = 1;
  ok ($Graph::Maker::Beineke::VERSION, $want_version, 'VERSION variable');
  ok (Graph::Maker::Beineke->VERSION,  $want_version, 'VERSION class method');
  ok (eval { Graph::Maker::Beineke->VERSION($want_version); 1 }, 1,
      "VERSION class check $want_version");
  my $check_version = $want_version + 1000;
  ok (! eval { Graph::Maker::Beineke->VERSION($check_version); 1 }, 1,
      "VERSION class check $check_version");
}

#------------------------------------------------------------------------------
# Beineke G1 is claw
{
  require Graph::Maker::Star;
  my $claw = Graph::Maker->new('star', N=>4, undirected=>1);
  my $G1 = Graph::Maker->new('Beineke', G=>1, undirected=>1);
  ok ($G1 eq $claw, 1);
}

#------------------------------------------------------------------------------
# Beineke G3 is K5-e, complete less one edge
{
  require Graph::Maker::Complete;
  my $K5e = Graph::Maker->new('complete', N=>5, undirected=>1);
  $K5e->delete_edge(1,3);
  my $G3 = Graph::Maker->new('Beineke', G=>3, undirected=>1);
  # print "G3  = $G3\n";
  # print "K5e = $K5e\n";
  ok ($G3 eq $K5e, 1);
}

#------------------------------------------------------------------------------
# Beineke G9 is wheel
{
  require Graph::Maker::Wheel;
  my $claw = Graph::Maker->new('wheel', N=>6, undirected=>1);
  my $G9 = Graph::Maker->new('Beineke', G=>9, undirected=>1);
  ok ($G9 eq $claw, 1);
}

#------------------------------------------------------------------------------
exit 0;
