package Paws::DS::DirectoryVpcSettingsDescription;
  use Moose;
  has AvailabilityZones => (is => 'ro', isa => 'ArrayRef[Str]');
  has SecurityGroupId => (is => 'ro', isa => 'Str');
  has SubnetIds => (is => 'ro', isa => 'ArrayRef[Str]');
  has VpcId => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::DS::DirectoryVpcSettingsDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DS::DirectoryVpcSettingsDescription object:

  $service_obj->Method(Att1 => { AvailabilityZones => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DS::DirectoryVpcSettingsDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->AvailabilityZones

=head1 DESCRIPTION

Contains information about the directory.

=head1 ATTRIBUTES


=head2 AvailabilityZones => ArrayRef[Str]

  The list of Availability Zones that the directory is in.


=head2 SecurityGroupId => Str

  The security group identifier for the directory. If the directory was
created before 8/1/2014, this is the identifier of the directory
members security group that was created when the directory was created.
If the directory was created after this date, this value is null.


=head2 SubnetIds => ArrayRef[Str]

  The identifiers of the subnets for the directory servers.


=head2 VpcId => Str

  The identifier of the VPC that the directory is in.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

