package Locale::CLDR::Ml v0.25.1;
# This file auto generated from Data\common\main\ml.xml
#	on Sat 10 May 11:46:03 pm GMT
# XML file generated 2014-03-05 23:14:25 -0600 (Wed, 05 Mar 2014)

use v5.10;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'അഫാർ',
 				'ab' => 'അബ്‌ഖാസിയൻ',
 				'ace' => 'അചിനീസ്',
 				'ach' => 'അകോലി',
 				'ada' => 'അഡാങ്ഗമി',
 				'ady' => 'അഡൈഗേ',
 				'ae' => 'അവസ്റ്റാൻ',
 				'af' => 'ആഫ്രിക്കാൻസ്',
 				'afh' => 'ആഫ്രിഹിലി',
 				'agq' => 'ആഘേം',
 				'ain' => 'അയിനു',
 				'ak' => 'അകാൻ',
 				'akk' => 'അക്കാഡിയൻ',
 				'ale' => 'അലൈട്ട്',
 				'alt' => 'തെക്കൻ അൾത്തായി',
 				'am' => 'അമാറിക്',
 				'an' => 'അരഗോണീസ്',
 				'ang' => 'പഴയ ഇംഗ്ലീഷ്',
 				'anp' => 'ആൻഗിക',
 				'ar' => 'അറബിക്',
 				'ar_001' => 'ആധുനിക സ്റ്റാൻഡേർഡ് അറബിക്',
 				'arc' => 'അരമായഭാഷ',
 				'arn' => 'ആരൗകാനിയൻ',
 				'arp' => 'അരപാഹോ',
 				'arw' => 'അറാവക്',
 				'as' => 'ആസ്സാമീസ്',
 				'asa' => 'ആസു',
 				'ast' => 'ഓസ്‌ട്രിയൻ',
 				'av' => 'അവാരിക്',
 				'awa' => 'അവധി',
 				'ay' => 'അയ്മാറ',
 				'az' => 'അസർബൈജാനി',
 				'az@alt=short' => 'അസേരി',
 				'ba' => 'ബഷ്ഖിർ',
 				'bal' => 'ബലൂചി',
 				'ban' => 'ബാലിനീസ്',
 				'bas' => 'ബസ',
 				'bax' => 'ബാമുൻ',
 				'bbj' => 'ഘോമാല',
 				'be' => 'ബൈലോറഷ്യൻ',
 				'bej' => 'ബേജ',
 				'bem' => 'ബെംബ',
 				'bez' => 'ബെനാ',
 				'bfd' => 'ബാഫട്ട്',
 				'bg' => 'ബൾഗേറിയൻ',
 				'bho' => 'ഭോജ്‌പൂരി',
 				'bi' => 'ബിസ്‌ലാമ',
 				'bik' => 'ബികോൽ',
 				'bin' => 'ബിനി',
 				'bkm' => 'കോം',
 				'bla' => 'സിക്സിക',
 				'bm' => 'ബംബാറ',
 				'bn' => 'ബംഗാളി',
 				'bo' => 'തിബറ്റൻ',
 				'br' => 'ബ്രറ്റൺ',
 				'bra' => 'ബ്രജ്',
 				'brx' => 'ബോഡോ',
 				'bs' => 'ബോസ്നിയൻ',
 				'bss' => 'അക്കൂസ്',
 				'bua' => 'ബുറിയത്ത്',
 				'bug' => 'ബുഗിനീസ്',
 				'bum' => 'ബുളു',
 				'byn' => 'ബ്ലിൻ',
 				'byv' => 'മെഡുംബ',
 				'ca' => 'കറ്റാലൻ',
 				'cad' => 'കാഡോ',
 				'car' => 'കാരിബ്',
 				'cay' => 'കയൂഗ',
 				'cch' => 'അറ്റ്സാം',
 				'ce' => 'ചെചൻ',
 				'ceb' => 'സെബുവാനോ',
 				'cgg' => 'ചിഗ',
 				'ch' => 'കമോറോ',
 				'chb' => 'ചിബ്ച',
 				'chg' => 'ചഗതൈ',
 				'chk' => 'ചൂകീസ്',
 				'chm' => 'മാരി',
 				'chn' => 'ചിനൂഗ്-ജാർഗൺ',
 				'cho' => 'ചോക്റ്റാവ്',
 				'chp' => 'ചിപേവ്യൻ',
 				'chr' => 'ചെരോകീ',
 				'chy' => 'ചിയേന്നേ',
 				'ckb' => 'സൊറാനി കുർദിഷ്',
 				'co' => 'കോഴ്സിക്കൺ',
 				'cop' => 'കോപ്റ്റിക്',
 				'cr' => 'ക്രീ',
 				'crh' => 'ക്രിമിയൻ ടർക്കിഷ്',
 				'cs' => 'ചെക്ക്',
 				'csb' => 'കാഷുബിയാൻ',
 				'cu' => 'ചർച്ച് സ്ലാവിക്',
 				'cv' => 'ചുവാഷ്',
 				'cy' => 'വെൽഷ്',
 				'da' => 'ഡാനിഷ്',
 				'dak' => 'ഡകോട്ട',
 				'dar' => 'ഡർഗ്വാ',
 				'dav' => 'തൈത',
 				'de' => 'ജർമ്മൻ',
 				'de_AT' => 'ഓസ്‌ട്രിയൻ ജർമൻ',
 				'de_CH' => 'സ്വിസ് ഹൈ ജർമൻ',
 				'del' => 'ദലവാരെ',
 				'den' => 'സ്ലേവ്',
 				'dgr' => 'ഡോഗ്രിബ്',
 				'din' => 'ദിൻക',
 				'dje' => 'സാർമ്മ',
 				'doi' => 'ഡോഗ്രി',
 				'dsb' => 'ലോവർ സോർബിയൻ',
 				'dua' => 'ദ്വാല',
 				'dum' => 'മദ്ധ്യ ഡച്ച്',
 				'dv' => 'ദിവെഹി',
 				'dyo' => 'യോല-ഫോന്യി',
 				'dyu' => 'ദ്വൈല',
 				'dz' => 'ഭൂട്ടാനി',
 				'dzg' => 'ഡാസാഗ',
 				'ebu' => 'എംബു',
 				'ee' => 'എവ്',
 				'efi' => 'എഫിക്',
 				'egy' => 'പ്രാചീന ഈജിപ്ഷ്യൻ',
 				'eka' => 'എകാജുക്',
 				'el' => 'ഗ്രീക്ക്',
 				'elx' => 'എലാമൈറ്റ്',
 				'en' => 'ഇംഗ്ലീഷ്',
 				'en_AU' => 'ഓസ്‌ട്രേലിയൻ ഇംഗ്ലീഷ്',
 				'en_CA' => 'കനേഡിയൻ ഇംഗ്ലീഷ്',
 				'en_GB' => 'ബ്രിട്ടീഷ് ഇംഗ്ലീഷ്',
 				'en_GB@alt=short' => 'യു.കെ. ഇംഗ്ലീഷ്',
 				'en_US' => 'അമേരിക്കൻ ഇംഗ്ലീഷ്',
 				'en_US@alt=short' => 'യു.എസ്. ഇംഗ്ലീഷ്',
 				'enm' => 'മദ്ധ്യ ഇംഗ്ലീഷ്',
 				'eo' => 'എസ്‌പരാന്റോ',
 				'es' => 'സ്‌പാനിഷ്',
 				'es_419' => 'ലാറ്റിൻ അമേരിക്കൻ സ്‌പാനിഷ്',
 				'es_ES' => 'ഇബേറിയൻ സ്‌പാനിഷ്',
 				'es_MX' => 'മെക്സിക്കൻ സ്പാനിഷ്',
 				'et' => 'എസ്റ്റോണിയൻ',
 				'eu' => 'ബാസ്‌ക്',
 				'ewo' => 'എവോൻഡോ',
 				'fa' => 'പേർഷ്യൻ',
 				'fan' => 'ഫങ്',
 				'fat' => 'ഫിലിപ്പീനോ',
 				'ff' => 'ഫുല',
 				'fi' => 'ഫിന്നിഷ്',
 				'fil' => 'ഫിലിപ്പിനോ',
 				'fj' => 'ഫിജിയൻ',
 				'fo' => 'ഫാറോസ്',
 				'fon' => 'ഫോൻ',
 				'fr' => 'ഫ്രഞ്ച്',
 				'fr_CA' => 'കനേഡിയൻ ഫ്രഞ്ച്',
 				'fr_CH' => 'സ്വിസ് ഫ്രഞ്ച്',
 				'frm' => 'മദ്ധ്യ ഫ്രഞ്ച്',
 				'fro' => 'പഴയ ഫ്രഞ്ച്',
 				'frr' => 'നോർത്തേൻ ഫ്രിഷ്യൻ',
 				'frs' => 'ഈസ്റ്റേൺ ഫ്രിഷ്യൻ',
 				'fur' => 'ഫ്രിയുലിയാൻ',
 				'fy' => 'പശ്ചിമ ഫ്രിഷിയൻ',
 				'ga' => 'ഐറിഷ്',
 				'gaa' => 'ഗാ',
 				'gay' => 'ഗയൊ',
 				'gba' => 'ഗബ്യ',
 				'gd' => 'സ്കോട്ടിഷ് ഗൈലിക്',
 				'gez' => 'ഗീസ്',
 				'gil' => 'ഗിൽബർസേ',
 				'gl' => 'ഗലീഷ്യൻ',
 				'gmh' => 'മദ്ധ്യ ഉച്ച ജർമൻ',
 				'gn' => 'ഗ്വാറാനി',
 				'goh' => 'പ്രാചീന ഉച്ച ജർമൻ',
 				'gon' => 'ഗോണ്ഡി',
 				'gor' => 'ഗൊറോൻറാലോ',
 				'got' => 'ഗോഥിക്ക്',
 				'grb' => 'ഗ്രബൊ',
 				'grc' => 'പുരാതന യവന ഭാഷ',
 				'gsw' => 'സ്വിസ് ജർമൻ',
 				'gu' => 'ഗുജറാത്തി',
 				'guz' => 'ഗുസീ',
 				'gv' => 'മാൻസ്',
 				'gwi' => 'ഗ്വിച്ച് ഇൻ',
 				'ha' => 'ഹൗസ',
 				'hai' => 'ഹൈഡ',
 				'haw' => 'ഹവായിയൻ',
 				'he' => 'ഹീബ്രു',
 				'hi' => 'ഹിന്ദി',
 				'hil' => 'ഹിലിഗയ്നോൺ',
 				'hit' => 'ഹിറ്റൈറ്റേ',
 				'hmn' => 'മോങ്',
 				'ho' => 'ഹിരി മോതു',
 				'hr' => 'ക്രൊയേഷ്യൻ',
 				'hsb' => 'അപ്പർ സോർബിയൻ',
 				'ht' => 'ഹെയ്‌തിയൻ',
 				'hu' => 'ഹംഗേറിയൻ',
 				'hup' => 'ഹൂപ',
 				'hy' => 'അർമേനിയൻ',
 				'hz' => 'ഹെരേരൊ',
 				'ia' => 'ഇൻറർലിംഗ്വാ',
 				'iba' => 'ഇബാൻ',
 				'ibb' => 'ഇബീബിയോ',
 				'id' => 'ഇൻഡോനേഷ്യൻ',
 				'ie' => 'ഇന്റർലിംഗ്വ',
 				'ig' => 'ഇഗ്ബോ',
 				'ii' => 'ഷുവാൻയി',
 				'ik' => 'ഇനുപിയാക്',
 				'ilo' => 'ഇലോകോ',
 				'inh' => 'ഇംഗ്വിഷ്',
 				'io' => 'ഇഡോ',
 				'is' => 'ഐസ്‌ലാൻഡിക്',
 				'it' => 'ഇറ്റാലിയൻ',
 				'iu' => 'ഇനുക്റ്റിറ്റട്ട്',
 				'ja' => 'ജപ്പാനീസ്',
 				'jbo' => 'ലോജ്ബാൻ',
 				'jmc' => 'മചേം',
 				'jpr' => 'ജൂഡിയോ-പേർഷ്യൻ',
 				'jrb' => 'ജൂഡിയോ-അറബിക്',
 				'jv' => 'ജാവാനീസ്',
 				'ka' => 'ജോർജിയൻ',
 				'kaa' => 'കര-കാൽപ്പക്',
 				'kab' => 'കബൈൽ',
 				'kac' => 'കാചിൻ',
 				'kaj' => 'ജ്ജു',
 				'kam' => 'കംബ',
 				'kaw' => 'കാവി',
 				'kbd' => 'കബർഡിയാൻ',
 				'kbl' => 'കനെംബു',
 				'kcg' => 'ട്യാപ്',
 				'kde' => 'മക്കോണ്ടെ',
 				'kea' => 'കബുവെർദിയാനു',
 				'kfo' => 'കോറോ',
 				'kg' => 'കോംഗോ',
 				'kha' => 'ഘാസി',
 				'kho' => 'ഘോറ്റാനേസേ',
 				'khq' => 'കൊയ്റ ചീനി',
 				'ki' => 'കികൂയു',
 				'kj' => 'ക്വാന്യമ',
 				'kk' => 'കസാഖ്',
 				'kkj' => 'കക്കോ',
 				'kl' => 'കലാല്ലിസട്ട്',
 				'kln' => 'കലെഞ്ഞിൻ',
 				'km' => 'കംബോഡിയൻ',
 				'kmb' => 'ക്ലിംഗൻ',
 				'kn' => 'കന്നഡ',
 				'ko' => 'കൊറിയൻ',
 				'kok' => 'കൊങ്കണി',
 				'kos' => 'കൊസറേയൻ',
 				'kpe' => 'കപെല്ലേ',
 				'kr' => 'കനൂറി',
 				'krc' => 'കരചൈ-ബാൽകർ',
 				'krl' => 'കരീലിയൻ',
 				'kru' => 'കുരുഖ്',
 				'ks' => 'കാശ്‌മീരി',
 				'ksb' => 'ഷംഭാള',
 				'ksf' => 'ഭാഫിയ',
 				'ksh' => 'കൊളോഞ്ഞിയൻ',
 				'ku' => 'കുർദ്ദിഷ്',
 				'kum' => 'കുമൈക്',
 				'kut' => 'കുതേനൈ',
 				'kv' => 'കോമി',
 				'kw' => 'കോർണിഷ്',
 				'ky' => 'കിർഗിസ്',
 				'la' => 'ലാറ്റിൻ',
 				'lad' => 'ലാഡിനോ',
 				'lag' => 'ലാംഗി',
 				'lah' => 'ലഹ്‌ൻഡ',
 				'lam' => 'ലംബ',
 				'lb' => 'ലക്‌സംബർഗിഷ്',
 				'lez' => 'ലഹ്ഗിയാൻ',
 				'lg' => 'ഗാൻഡ',
 				'li' => 'ലിംബർഗിഷ്',
 				'ln' => 'ലിംഗാല',
 				'lo' => 'ലാവോ',
 				'lol' => 'മോങ്കോ',
 				'loz' => 'ലോസി',
 				'lt' => 'ലിത്വേനിയൻ',
 				'lu' => 'ലുബ-കറ്റംഗ',
 				'lua' => 'ലൂബ-ലുലുവ',
 				'lui' => 'ലൂയിസെനോ',
 				'lun' => 'ലുൻഡ',
 				'luo' => 'ലവോ',
 				'lus' => 'മിസോ',
 				'luy' => 'ലുയിയ',
 				'lv' => 'ലാത്വിയൻ',
 				'mad' => 'മദുരേസേ',
 				'maf' => 'മാഫ',
 				'mag' => 'മഗാഹി',
 				'mai' => 'മൈഥിലി',
 				'mak' => 'മകാസർ',
 				'man' => 'മണ്ഡിൻഗോ',
 				'mas' => 'മസൈ',
 				'mde' => 'മാബ',
 				'mdf' => 'മോക്ഷ',
 				'mdr' => 'മണ്ഡാർ',
 				'men' => 'മെൻഡെ',
 				'mer' => 'മേരു',
 				'mfe' => 'മൊറിസിൻ',
 				'mg' => 'മലഗാസി',
 				'mga' => 'മദ്ധ്യ ഐറിഷ്',
 				'mgh' => 'മാഖുവാ-മീത്തോ',
 				'mh' => 'മാർഷല്ലീസ്',
 				'mi' => 'മൗറി',
 				'mic' => 'മിക്മാക്',
 				'min' => 'മിനാങ്കബൗ',
 				'mk' => 'മാസിഡോണിയൻ',
 				'ml' => 'മലയാളം',
 				'mn' => 'മംഗോളിയൻ',
 				'mnc' => 'മൻചു',
 				'mni' => 'മണിപ്പൂരി',
 				'moh' => 'മോഹാക്',
 				'mos' => 'മൊസ്സി',
 				'mr' => 'മറാഠി',
 				'ms' => 'മലയ',
 				'mt' => 'മാൾട്ടീസ്',
 				'mua' => 'മുന്ദാംഗ്',
 				'mul' => 'പലഭാഷകൾ',
 				'mus' => 'ക്രീക്ക്',
 				'mwl' => 'മിരാൻറസേ',
 				'mwr' => 'മർവാരി',
 				'my' => 'ബർമീസ്',
 				'mye' => 'മയീൻ',
 				'myv' => 'ഏഴ്സ്യ',
 				'na' => 'നൗറു',
 				'nap' => 'നെപ്പോളിറ്റാൻ',
 				'naq' => 'നാമ',
 				'nb' => 'നോർവീജിയൻ ബുക്‌മൽ',
 				'nd' => 'നോർത്ത് ഡെബിൾ',
 				'nds' => 'ലോ ജർമൻ',
 				'ne' => 'നേപ്പാളി',
 				'new' => 'നേവാരി',
 				'ng' => 'ഡോങ്ക',
 				'nia' => 'നിയാസ്',
 				'niu' => 'ന്യുവാൻ',
 				'nl' => 'ഡച്ച്',
 				'nl_BE' => 'ഫ്ലമിഷ്',
 				'nmg' => 'ക്വാസിയോ',
 				'nn' => 'നോർവീജിയൻ നൈനോർക്‌സ്',
 				'nnh' => 'ഗീംബൂൺ',
 				'no' => 'നോർവീജിയൻ',
 				'nog' => 'നോഗൈ',
 				'non' => 'പഴയ പേർഷ്യൻ',
 				'nqo' => 'ഇൻകോ',
 				'nr' => 'ദക്ഷിണ നെഡിബിൾ',
 				'nso' => 'നോർത്തേൻ സോതോ',
 				'nus' => 'നുവേർ',
 				'nv' => 'നവാഹൊ',
 				'nwc' => 'ക്ലാസിക്കൽ നേവാരി',
 				'ny' => 'ന്യൻജ',
 				'nym' => 'ന്യാംവേസി',
 				'nyn' => 'ന്യാൻകലേ',
 				'nyo' => 'ന്യോറോ',
 				'nzi' => 'സിമ',
 				'oc' => 'ഒക്സിററൻ',
 				'oj' => 'ഓജിബ്വാ',
 				'om' => 'ഒറോമൂ',
 				'or' => 'ഒറിയ',
 				'os' => 'ഒസ്സെറ്റിക്',
 				'osa' => 'ഒസേജ്',
 				'ota' => 'ഓട്ടോമൻ തുർക്കിഷ്',
 				'pa' => 'പഞ്ചാബി',
 				'pag' => 'പങ്കാസിനൻ',
 				'pal' => 'പാഹ്ലവി',
 				'pam' => 'പാംപൻഗ',
 				'pap' => 'പാപിയാമെൻറൊ',
 				'pau' => 'പലാവുൻ',
 				'peo' => 'പ്രാചീന പേർഷ്യൻ',
 				'phn' => 'ഫീനിഷ്യൻ',
 				'pi' => 'പാലി',
 				'pl' => 'പോളിഷ്',
 				'pon' => 'പൊൻപിയൻ',
 				'pro' => 'പ്രൊവൻഷ്ൽ',
 				'ps' => 'പഷ്തു',
 				'ps@alt=variant' => 'പുഷ്തോ',
 				'pt' => 'പോർച്ചുഗീസ്',
 				'pt_BR' => 'ബ്രസീലിയൻ പോർച്ചുഗീസ്',
 				'pt_PT' => 'ഇബേറിയൻ പോർച്ചുഗീസ്',
 				'qu' => 'ക്വെച്ചുവ',
 				'raj' => 'രാജസ്ഥാനി',
 				'rap' => 'രാപനൂയി',
 				'rar' => 'രാരോടോങ്കൻ',
 				'rm' => 'റെയ്‌തോ-റോമൻസ്',
 				'rn' => 'റുണ്ടി',
 				'ro' => 'റുമേനിയൻ',
 				'ro_MD' => 'മോൾഡാവിയൻ',
 				'rof' => 'റോംബോ',
 				'rom' => 'റോമനി',
 				'root' => 'മൂലഭാഷ',
 				'ru' => 'റഷ്യൻ',
 				'rup' => 'ആരോമാനിയൻ',
 				'rw' => 'കിന്യർവണ്ട',
 				'rwk' => 'റുവാ',
 				'sa' => 'സംസ്‌കൃതം',
 				'sad' => 'സാൻഡവേ',
 				'sah' => 'സാഖ',
 				'sam' => 'സമരിയാക്കാരുടെ അരമായ',
 				'saq' => 'സംബുരു',
 				'sas' => 'സസാക്',
 				'sat' => 'സന്താലി',
 				'sba' => 'ഗംബായ്',
 				'sbp' => 'സംഗു',
 				'sc' => 'സർഡിനിയാൻ',
 				'scn' => 'സിസിലിയൻ',
 				'sco' => 'സ്കോട്സ്',
 				'sd' => 'സിന്ധി',
 				'se' => 'വടക്കൻ സമി',
 				'see' => 'സെനേക',
 				'seh' => 'സേന',
 				'sel' => 'സെൽകപ്',
 				'ses' => 'കൊയ്റാബൊറോ സെന്നി',
 				'sg' => 'സാങ്കോ',
 				'sga' => 'പ്രാചീന ഐറിഷ്',
 				'sh' => 'സെർബോ-ക്രൊയേഷ്യൻ',
 				'shi' => 'താച്ചലിറ്റ്',
 				'shn' => 'ഷാൻ',
 				'shu' => 'ചാഡ് അറബി',
 				'si' => 'സിംഹള',
 				'sid' => 'സിഡാമോ',
 				'sk' => 'സ്ലോവാക്ക്',
 				'sl' => 'സ്ലോവേനിയൻ',
 				'sm' => 'സമോവൻ',
 				'sma' => 'തെക്കൻ സാമി',
 				'smj' => 'ലൂലീ സമി',
 				'smn' => 'ഇനാരി സാമി',
 				'sms' => 'സ്കോൾട്ട് സമി',
 				'sn' => 'ഷോണാ',
 				'snk' => 'സോണിൻകെ',
 				'so' => 'സോമാലി',
 				'sog' => 'സോജിഡിയൻ',
 				'sq' => 'അൽബേനിയൻ',
 				'sr' => 'സെർബിയൻ',
 				'srn' => 'ശ്രാനൻ ഡോങ്കോ',
 				'srr' => 'സെറർ',
 				'ss' => 'സ്വാറ്റി',
 				'ssy' => 'സാഹോ',
 				'st' => 'തെക്കൻ സോതോ',
 				'su' => 'സുഡാനീസ്',
 				'suk' => 'സുകുമ',
 				'sus' => 'സുസു',
 				'sux' => 'സുമേരിയൻ',
 				'sv' => 'സ്വീഡിഷ്',
 				'sw' => 'സ്വാഹിലി',
 				'swb' => 'കൊമോറിയൻ',
 				'swc' => 'കോംഗോ സ്വാഹിലി',
 				'syc' => 'പുരാതന സുറിയാനിഭാഷ',
 				'syr' => 'സുറിയാനി',
 				'ta' => 'തമിഴ്',
 				'te' => 'തെലുങ്ക്',
 				'tem' => 'ടിംനേ',
 				'teo' => 'ടെസോ',
 				'ter' => 'ടെറേനോ',
 				'tet' => 'ടെറ്റും',
 				'tg' => 'താജിക്',
 				'th' => 'തായ്',
 				'ti' => 'ടൈഗ്രിന്യ',
 				'tig' => 'ടൈഗ്രി',
 				'tiv' => 'ടിവ്',
 				'tk' => 'തുർക്‌മെൻ',
 				'tkl' => 'ടൊക്കേലൗ',
 				'tl' => 'തഗാലോഗ്',
 				'tlh' => 'ക്ലിംഗോൺ',
 				'tli' => 'ലിംഗ്വിറ്റ്',
 				'tmh' => 'ടമഷേക്',
 				'tn' => 'ത്സ്വാന',
 				'to' => 'ടോംഗൻ',
 				'tog' => 'ന്യാസാ ഡോങ്ക',
 				'tpi' => 'ടോക് പിസിൻ',
 				'tr' => 'തുർക്കി',
 				'trv' => 'തരോക്കോ',
 				'ts' => 'ത്സോംഗ',
 				'tsi' => 'സിംഷ്യൻ',
 				'tt' => 'ടാട്ടാർ',
 				'tum' => 'തുംബുക',
 				'tvl' => 'തുവാലു',
 				'tw' => 'ട്വി',
 				'twq' => 'ടസവാക്ക്',
 				'ty' => 'താഹിതിയൻ',
 				'tyv' => 'തുവിനിയൻ',
 				'tzm' => 'മധ്യ അറ്റ്‌ലസ് ടമാസൈറ്റ്',
 				'udm' => 'ഉഡ്മുർട്ട്',
 				'ug' => 'ഉയ്ഘുർ',
 				'ug@alt=variant' => 'വിഗോർ',
 				'uga' => 'ഉഗറിട്ടിക്',
 				'uk' => 'ഉക്രേനിയൻ',
 				'umb' => 'ഉംബുന്ദു',
 				'und' => 'നിലവിലില്ലാത്ത ഭാഷ',
 				'ur' => 'ഉറുദു',
 				'uz' => 'ഉസ്‌ബെക്ക്',
 				'vai' => 'വൈ',
 				've' => 'വെന്ദ',
 				'vi' => 'വിയറ്റ്നാമീസ്',
 				'vo' => 'വോളാപുക്',
 				'vot' => 'വോട്ടിക്',
 				'vun' => 'വുഞ്ജോ',
 				'wa' => 'വല്ലൂൺ',
 				'wae' => 'വാൾസർ',
 				'wal' => 'വലമൊ',
 				'war' => 'വാരേയ്',
 				'was' => 'വാഷൊ',
 				'wo' => 'വൊളോഫ്',
 				'xal' => 'കൽമൈക്',
 				'xh' => 'ഖോസാ',
 				'xog' => 'സോഗോ',
 				'yao' => 'യാവോ',
 				'yap' => 'യെപ്പീസ്',
 				'yav' => 'യാംഗ്ബെൻ',
 				'ybb' => 'യംബ',
 				'yi' => 'യിദ്ദിഷ്',
 				'yo' => 'യൊറൂബാ',
 				'yue' => 'കാന്റണീസ്',
 				'za' => 'സ്വാംഗ്',
 				'zap' => 'സാപ്പോടെക്',
 				'zbl' => 'ബ്ലിസ്സിംബൽസ്',
 				'zen' => 'സെനഗ',
 				'zgh' => 'മൊറോക്കൻ സാധാരണ താമസൈറ്റ്',
 				'zh' => 'ചൈനീസ്',
 				'zh_Hans' => 'ചീനഭാഷ-ലളിതലിപി',
 				'zh_Hant' => 'ചീനഭാഷ-പരമ്പരാഗതലിപി',
 				'zu' => 'സുലു',
 				'zun' => 'സുനി',
 				'zxx' => 'ഭാഷേതരം',
 				'zza' => 'സാസാ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'അറബി',
 			'Arab@alt=variant' => 'പേഴ്‌സോ-അറബിക്',
 			'Armi' => 'അർമി',
 			'Armn' => 'അർമേനിയൻ',
 			'Avst' => 'അവെസ്ഥൻ',
 			'Bali' => 'ബാലിനീസ്',
 			'Batk' => 'ബട്ടക്',
 			'Beng' => 'ബംഗാളി',
 			'Blis' => 'ബ്ലിസ് ചിത്ര ലിപി',
 			'Bopo' => 'ബോപ്പോമോഫോ',
 			'Brah' => 'ബ്രാഹ്മി',
 			'Brai' => 'ബ്രെയ്‌ലി',
 			'Bugi' => 'ബുഗിനീസ്',
 			'Buhd' => 'ബുഹിഡ്',
 			'Cakm' => 'ചകം',
 			'Cans' => 'ഏകീകൃത കനേഡിയൻ ഗോത്രലിപി',
 			'Cari' => 'ചരിയൻ',
 			'Cham' => 'ഛം',
 			'Cher' => 'ചെറോക്കി',
 			'Cirt' => 'ചിർത്ത്',
 			'Copt' => 'കോപ്റ്റിക്',
 			'Cprt' => 'സൈപ്രിയോട്ട്',
 			'Cyrl' => 'സിറിലിക്',
 			'Cyrs' => 'പുരാതന ചർച്ച് സ്ലവോണിക് സിറിലിക്',
 			'Deva' => 'ദേവനാഗരി',
 			'Dsrt' => 'ഡെസെർട്ട്',
 			'Egyd' => 'ഈജിപ്ഷ്യൻ ഡിമോട്ടിക്',
 			'Egyh' => 'ഈജിപ്ഷ്യൻ ഹിരാറ്റിക്',
 			'Egyp' => 'ഈജിപ്ഷ്യൻ ചിത്രലിപി',
 			'Ethi' => 'എത്യോപിക്',
 			'Geok' => 'ജോർജ്ജിയൻ ഖുട്സുരി',
 			'Geor' => 'ജോർജ്ജിയൻ',
 			'Glag' => 'ഗ്ലഗോലിറ്റിക്',
 			'Goth' => 'ഗോഥിക്',
 			'Grek' => 'ഗ്രീക്ക്',
 			'Gujr' => 'ഗുജറാത്തി',
 			'Guru' => 'ഗുരുമുഖി',
 			'Hang' => 'ഹാംഗുൾ',
 			'Hani' => 'ഹാൻ',
 			'Hano' => 'ഹനുനൂ',
 			'Hans' => 'പരിഷ്കൃത ഹാൻ',
 			'Hans@alt=stand-alone' => 'ലളിതവൽക്കരിച്ച ഹാൻ',
 			'Hant' => 'പരമ്പരാഗത ഹാൻ',
 			'Hant@alt=stand-alone' => 'പരമ്പരാഗത ഹാൻ',
 			'Hebr' => 'ഹീബ്രു',
 			'Hira' => 'ഹിരാഗാന',
 			'Hmng' => 'പഹ്വാ ഹമോംഗ്',
 			'Hrkt' => 'കടകാനയോ ഹിരാഗാനയോ',
 			'Hung' => 'പുരാതന ഹംഗേറിയൻ',
 			'Inds' => 'സിന്ധു',
 			'Ital' => 'പഴയ ഇറ്റാലിയൻ',
 			'Java' => 'ജാവനീസ്',
 			'Jpan' => 'ജാപ്പനീസ്',
 			'Kali' => 'കയാ ലി',
 			'Kana' => 'കടകാന',
 			'Khar' => 'ഖരോഷ്ടി',
 			'Khmr' => 'ഖമർ',
 			'Knda' => 'കന്നഡ',
 			'Kore' => 'കൊറിയൻ',
 			'Kthi' => 'ക്തി',
 			'Lana' => 'ലന്ന',
 			'Laoo' => 'ലാവോ',
 			'Latf' => 'ഫ്രാക്ടുർ ലാറ്റിൻ',
 			'Latg' => 'ഗെയ്‌ലിക് ലാറ്റിൻ',
 			'Latn' => 'ലാറ്റിൻ',
 			'Lepc' => 'ലെപ്ച',
 			'Limb' => 'ലിംബു',
 			'Lina' => 'സമരേഖയിലുള്ള എ',
 			'Linb' => 'ലീനിയർ ബി',
 			'Lyci' => 'ലൈസിൻ',
 			'Lydi' => 'ലൈഡിയൻ',
 			'Mand' => 'മൻഡേയൻ',
 			'Mani' => 'മണിചേയൻ',
 			'Maya' => 'മായൻ ചിത്രലിപി',
 			'Mero' => 'മെറോയിറ്റിക്',
 			'Mlym' => 'മലയാളം',
 			'Mong' => 'മംഗോളിയൻ',
 			'Moon' => 'മൂൺ',
 			'Mtei' => 'മേറ്റി മായക്',
 			'Mymr' => 'മ്യാൻമാർ',
 			'Nkoo' => 'എൻകോ',
 			'Ogam' => 'ഒഖാം',
 			'Olck' => 'ഒൽ ചിക്കി',
 			'Orkh' => 'ഒർഖോൺ',
 			'Orya' => 'ഒഡിയ',
 			'Osma' => 'ഒസ്‌മാനിയ',
 			'Perm' => 'പുരാതന പെർമിക്',
 			'Phag' => 'ഫഗസ് പ',
 			'Phli' => 'എഴുത്തു പഹൽവി',
 			'Phlp' => 'സാൾട്ടർ പഹൽവി',
 			'Phlv' => 'പഹൽവി ലിപി',
 			'Phnx' => 'ഫിനീഷ്യൻ',
 			'Plrd' => 'പൊള്ളാർഡ് ശബ്ദലിപി',
 			'Prti' => 'പൃതി',
 			'Rjng' => 'റെജാംഗ്',
 			'Roro' => 'റൊംഗോറൊംഗോ',
 			'Runr' => 'റുണിക്',
 			'Samr' => 'സമരിയ',
 			'Sara' => 'സരതി',
 			'Saur' => 'സൗരാഷ്ട്ര',
 			'Sgnw' => 'ചിഹ്നലിപി',
 			'Shaw' => 'ഷാവിയൻ',
 			'Sinh' => 'സിംഹള',
 			'Sund' => 'സന്താനീസ്',
 			'Sylo' => 'സൈലോതി നാഗരി',
 			'Syrc' => 'സിറിയക്ക്',
 			'Syre' => 'എസ്റ്റ്രാംഗ്ലോ സിറിയക്',
 			'Syrj' => 'പശ്ചിമസുറിയാനി',
 			'Syrn' => 'കിഴക്കൻ സിറിയക്',
 			'Tagb' => 'തഗ്ബൻവാ',
 			'Tale' => 'തായ് ലേ',
 			'Talu' => 'പുതിയ തായ് ല്യൂ',
 			'Taml' => 'തമിഴ്',
 			'Tavt' => 'ത്വട്',
 			'Telu' => 'തെലുങ്ക്',
 			'Teng' => 'തെംഗ്വർ',
 			'Tfng' => 'തിഫിനാഗ്',
 			'Tglg' => 'തഗലോഗ്',
 			'Thaa' => 'ഥാന',
 			'Thai' => 'തായ്',
 			'Tibt' => 'ടിബറ്റൻ',
 			'Ugar' => 'ഉഗ്രൈറ്റിക്',
 			'Vaii' => 'വൈ',
 			'Visp' => 'ദൃശ്യഭാഷ',
 			'Xpeo' => 'പഴയ പേർഷ്യൻ',
 			'Xsux' => 'സുമേറോ അക്കാഡിയൻ ക്യുണിഫോം',
 			'Yiii' => 'യി',
 			'Zinh' => 'പാരമ്പര്യമായ',
 			'Zmth' => 'ഗണിത രൂപം',
 			'Zsym' => 'ചിഹ്നങ്ങൾ',
 			'Zxxx' => 'എഴുതപ്പെടാത്തത്',
 			'Zyyy' => 'സാധാരണ',
 			'Zzzz' => 'അറിയപ്പെടാത്തതോ നിലവിലില്ലാത്തതോ ആയ ലിപി',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ലോകം',
 			'002' => 'ആഫ്രിക്ക',
 			'003' => 'വടക്കേ അമേരിക്കൻ ഭൂഖണ്ഡം',
 			'005' => 'തെക്കേ അമേരിക്കൻ ഭൂഖണ്ഡം',
 			'009' => 'ഓഷ്യാനിയ',
 			'011' => 'പശ്ചിമ ആഫ്രിക്ക',
 			'013' => 'മദ്ധ്യഅമേരിക്ക',
 			'014' => 'കിഴക്കൻ ആഫ്രിക്ക',
 			'015' => 'വടക്കേ ആഫ്രിക്ക',
 			'017' => 'മദ്ധ്യആഫ്രിക്ക',
 			'018' => 'തെക്കേ ആഫ്രിക്ക',
 			'019' => 'അമേരിക്കൻ ഭൂഖണ്ഡം',
 			'021' => 'വടക്കേ അമേരിക്ക',
 			'029' => 'കരീബിയൻ',
 			'030' => 'കിഴക്കൻ ഏഷ്യ',
 			'034' => 'തെക്കേ ഏഷ്യ',
 			'035' => 'തെക്ക്-കിഴക്കൻ ഏഷ്യ',
 			'039' => 'തെക്കേ യൂറോപ്പ്',
 			'053' => 'ഓസ്‌ട്രേലിയയും ന്യൂസിലാൻഡും',
 			'054' => 'മെലനേഷ്യ',
 			'057' => 'മൈക്രോനേഷ്യൻ പ്രദേശം',
 			'061' => 'പോളിനേഷ്യ',
 			'142' => 'ഏഷ്യ',
 			'143' => 'മദ്ധ്യേഷ്യ',
 			'145' => 'പശ്ചിമേഷ്യ',
 			'150' => 'യൂറോപ്പ്',
 			'151' => 'കിഴക്കൻ യൂറോപ്പ്',
 			'154' => 'വടക്കേ യൂറോപ്പ്',
 			'155' => 'പശ്ചിമ യൂറോപ്പ്',
 			'419' => 'ലാറ്റിനമേരിക്ക',
 			'AC' => 'അസൻഷൻ ദ്വീപ്',
 			'AD' => 'അന്റോറ',
 			'AE' => 'യുണൈറ്റഡ് അറബ് എമിറൈറ്റ്‌സ്',
 			'AF' => 'അഫ്‌ഗാനിസ്ഥാൻ',
 			'AG' => 'ആൻറിഗ്വയും ബർബുഡയും',
 			'AI' => 'ആൻഗ്വില്ല',
 			'AL' => 'അൽബേനിയ',
 			'AM' => 'അർമേനിയ',
 			'AN' => 'നെതർലൻഡ്സ് ആൻറിലിസ്',
 			'AO' => 'അംഗോള',
 			'AQ' => 'അൻറാർട്ടിക്ക',
 			'AR' => 'അർജൻറീന',
 			'AS' => 'അമേരിക്കൻ സാമോവ',
 			'AT' => 'ഓസ്ട്രിയ',
 			'AU' => 'ഓസ്‌ട്രേലിയ',
 			'AW' => 'അറുബ',
 			'AX' => 'അലൻഡ് ദ്വീപുകൾ',
 			'AZ' => 'അസർബൈജാൻ',
 			'BA' => 'ബോസ്നിയയും ഹെർസഗോവിനയും',
 			'BB' => 'ബാർബഡോസ്',
 			'BD' => 'ബംഗ്ലാദേശ്',
 			'BE' => 'ബെൽജിയം',
 			'BF' => 'ബുർക്കിനാ ഫാസോ',
 			'BG' => 'ബൾഗേറിയ',
 			'BH' => 'ബഹ്റൈൻ',
 			'BI' => 'ബുറുണ്ടി',
 			'BJ' => 'ബെനിൻ',
 			'BL' => 'സെൻറ് ബാർത്തെൽമി',
 			'BM' => 'ബർമുഡ',
 			'BN' => 'ബ്രൂണൈ',
 			'BO' => 'ബൊളീവിയ',
 			'BQ' => 'ബൊണെയ്ർ, സിന്റ് യുസ്റ്റേഷ്യസ്, സാബ എന്നിവ',
 			'BR' => 'ബ്രസീൽ',
 			'BS' => 'ബഹാമാസ്',
 			'BT' => 'ഭൂട്ടാൻ',
 			'BV' => 'ബൗവെറ്റ് ദ്വീപ്',
 			'BW' => 'ബോട്സ്വാന',
 			'BY' => 'ബെലറൂസ്',
 			'BZ' => 'ബെലീസ്',
 			'CA' => 'കാനഡ',
 			'CC' => 'കോക്കസ് ദ്വീപുകൾ',
 			'CD' => 'കോംഗോ - കിൻഷാസ',
 			'CD@alt=variant' => 'കോംഗോ (DRC)',
 			'CF' => 'സെൻട്രൽ ആഫ്രിക്കൻ റിപ്പബ്ലിക്',
 			'CG' => 'കോംഗോ - ബ്രാസാവിൽ',
 			'CG@alt=variant' => 'കോംഗോ (റിപ്പബ്ലിക്ക്)',
 			'CH' => 'സ്വിറ്റ്സർലാൻഡ്',
 			'CI' => 'കോട്ട് ഡി വാർ',
 			'CI@alt=variant' => 'ഐവറി കോസ്റ്റ്',
 			'CK' => 'കൂക്ക് ദ്വീപുകൾ',
 			'CL' => 'ചിലി',
 			'CM' => 'കാമറൂൺ',
 			'CN' => 'ചൈന',
 			'CO' => 'കൊളംബിയ',
 			'CP' => 'ക്ലിപ്പെർട്ടൻ ദ്വീപ്',
 			'CR' => 'കോസ്റ്ററിക്ക',
 			'CU' => 'ക്യൂബ',
 			'CV' => 'കേപ്പ് വെർഡെ',
 			'CW' => 'കുറാകാവോ',
 			'CX' => 'ക്രിസ്മസ് ദ്വീപ്',
 			'CY' => 'സൈപ്രസ്സ്',
 			'CZ' => 'ചെക്ക് റിപ്പബ്ലിക്',
 			'DE' => 'ജർമനി',
 			'DG' => 'ഡീഗോ ഗ്രാഷ്യ',
 			'DJ' => 'ജിബൂട്ടി',
 			'DK' => 'ഡെൻമാർക്ക്',
 			'DM' => 'ഡൊമിനിക്ക',
 			'DO' => 'ഡൊമിനിക്കൻ റിപ്പബ്ലിക്',
 			'DZ' => 'അൾജീരിയ',
 			'EA' => 'സെയൂത്ത ആൻഡ് മെലിയ',
 			'EC' => 'ഇക്വഡോർ',
 			'EE' => 'എസ്റ്റോണിയ‍',
 			'EG' => 'ഈജിപ്ത്',
 			'EH' => 'പശ്ചിമ സഹാറ',
 			'ER' => 'എറിത്രിയ',
 			'ES' => 'സ്‌പെയിൻ',
 			'ET' => 'എത്യോപ്യ',
 			'EU' => 'യൂറോപ്യൻ യൂണിയൻ',
 			'FI' => 'ഫിൻലാൻഡ്',
 			'FJ' => 'ഫിജി',
 			'FK' => 'ഫാക്ക്‌ലാന്റ് ദ്വീപുകൾ',
 			'FK@alt=variant' => 'ഫാക്ക്‌ലാൻഡ് ദ്വീപുകൾ (മൽവിനാസ്)',
 			'FM' => 'മൈക്രോനേഷ്യ',
 			'FO' => 'ഫറോയി ദ്വീപുകൾ',
 			'FR' => 'ഫ്രാൻസ്',
 			'GA' => 'ഗാബോൺ',
 			'GB' => 'ബ്രിട്ടൻ',
 			'GB@alt=short' => 'യു.കെ.',
 			'GD' => 'ഗ്രനേഡ',
 			'GE' => 'ജോർജിയ',
 			'GF' => 'ഫ്രഞ്ച് ഗയാന',
 			'GG' => 'ഗേൺസി',
 			'GH' => 'ഘാന',
 			'GI' => 'ജിബ്രാൾട്ടർ',
 			'GL' => 'ഗ്രീൻലാൻറ്',
 			'GM' => 'ഗാംബിയ',
 			'GN' => 'ഗ്വിനിയ',
 			'GP' => 'ഗുവാഡെലോപ്',
 			'GQ' => 'ഇക്വിറ്റോറിയൽ ഗ്വിനിയ',
 			'GR' => 'ഗ്രീസ്',
 			'GS' => 'ദക്ഷിണ ജോർജ്ജിയയും ദക്ഷിണ സാൻഡ്‌വിച്ച് ദ്വീപുകളും',
 			'GT' => 'ഗ്വാട്ടിമാലാ',
 			'GU' => 'ഗ്വാം',
 			'GW' => 'ഗിനി-ബിസോ',
 			'GY' => 'ഗയാന',
 			'HK' => 'ഹോങ് കോങ് എസ്.ഏ.ആർ. ചൈന',
 			'HK@alt=short' => 'ഹോങ് കോങ്',
 			'HM' => 'ഹിയേർഡ് ദ്വീപും മക്ഡൊണാള്ഡ് ദ്വീപുകളും',
 			'HN' => 'ഹോണ്ടുറാസ്',
 			'HR' => 'ക്രൊയേഷ്യ',
 			'HT' => 'ഹെയ്തി',
 			'HU' => 'ഹംഗറി',
 			'IC' => 'കാനറി ദ്വീപുകൾ',
 			'ID' => 'ഇൻഡോനേഷ്യ',
 			'IE' => 'അയർലാൻഡ്',
 			'IL' => 'ഇസ്രായേൽ',
 			'IM' => 'ഐൽ ഓഫ് മാൻ',
 			'IN' => 'ഇന്ത്യ',
 			'IO' => 'ബ്രിട്ടീഷ് ഇന്ത്യൻ മഹാസമുദ്ര പ്രദേശം',
 			'IQ' => 'ഇറാക്ക്',
 			'IR' => 'ഇറാൻ',
 			'IS' => 'ഐസ്‌ലാന്റ്',
 			'IT' => 'ഇറ്റലി',
 			'JE' => 'ജേഴ്സി',
 			'JM' => 'ജമൈക്ക',
 			'JO' => 'ജോർദ്ദാൻ',
 			'JP' => 'ജപ്പാൻ',
 			'KE' => 'കെനിയ',
 			'KG' => 'കിർഗിസ്ഥാൻ',
 			'KH' => 'കംബോഡിയ',
 			'KI' => 'കിരിബാത്തി',
 			'KM' => 'കോമറോസ്',
 			'KN' => 'സെയ്ൻറ് കിറ്റ്സും നെവിസും',
 			'KP' => 'ഉത്തരകൊറിയ',
 			'KR' => 'ദക്ഷിണകൊറിയ',
 			'KW' => 'കുവൈറ്റ്',
 			'KY' => 'കേമാൻ ദ്വീപുകൾ',
 			'KZ' => 'കസാഖിസ്ഥാൻ',
 			'LA' => 'ലാവോസ്',
 			'LB' => 'ലബനോൺ',
 			'LC' => 'സെൻറ് ലൂസിയ',
 			'LI' => 'ലിച്ചൺസ്റ്റൈൻ',
 			'LK' => 'ശ്രീലങ്ക',
 			'LR' => 'ലൈബീരിയ',
 			'LS' => 'ലെസോത്തോ',
 			'LT' => 'ലിത്വാനിയ',
 			'LU' => 'ലക്സംബർഗ്',
 			'LV' => 'ലാത്വിയ',
 			'LY' => 'ലിബിയ',
 			'MA' => 'മൊറോക്കൊ',
 			'MC' => 'മൊണോക്കൊ',
 			'MD' => 'മൾഡോവ',
 			'ME' => 'മോണ്ടേനേഗ്രോ',
 			'MF' => 'സെൻറ് മാർട്ടിൻ',
 			'MG' => 'മഡഗാസ്കർ',
 			'MH' => 'മാർഷൽ‍‍ ദ്വീപുകൾ',
 			'MK' => 'മാസിഡോണിയ',
 			'MK@alt=variant' => 'മാസിഡോണിയ (FYROM)',
 			'ML' => 'മാലി',
 			'MM' => 'മ്യാൻമാർ (ബർമ്മ)',
 			'MN' => 'മംഗോളിയ',
 			'MO' => 'മക്കാവോ SAR ചൈന',
 			'MO@alt=short' => 'മക്കാവോ',
 			'MP' => 'ഉത്തര മറിയാനാ ദ്വീപുകൾ',
 			'MQ' => 'മാർട്ടീനിക്',
 			'MR' => 'മൗറിറ്റാനിയ',
 			'MS' => 'മോണ്ട്സെറാറ്റ്',
 			'MT' => 'മാൾട്ട',
 			'MU' => 'മൗറീഷ്യസ്',
 			'MV' => 'മാലിദ്വീപ്',
 			'MW' => 'മലാവി',
 			'MX' => 'മെക്സിക്കോ',
 			'MY' => 'മലേഷ്യ',
 			'MZ' => 'മൊസാംബിക്ക്',
 			'NA' => 'നമീബിയ',
 			'NC' => 'പുതിയ കാലിഡോണിയ',
 			'NE' => 'നൈജർ',
 			'NF' => 'നോർഫോക് ദ്വീപ്',
 			'NG' => 'നൈജീരിയ',
 			'NI' => 'നിക്കാരഗ്വ',
 			'NL' => 'നെതർലൻഡ്സ്',
 			'NO' => 'നോർവെ',
 			'NP' => 'നേപ്പാൾ',
 			'NR' => 'നൗറൂ',
 			'NU' => 'ന്യൂവേ',
 			'NZ' => 'ന്യൂസിലാൻറ്',
 			'OM' => 'ഒമാൻ',
 			'PA' => 'പനാമ',
 			'PE' => 'പെറു',
 			'PF' => 'ഫ്രഞ്ച് പോളിനേഷ്യ',
 			'PG' => 'പപ്പുവ ന്യൂ ഗ്വിനി',
 			'PH' => 'ഫിലിപ്പൈൻസ്',
 			'PK' => 'പാക്കിസ്ഥാൻ',
 			'PL' => 'പോളണ്ട്',
 			'PM' => 'സെൻറ് പിയാറും മിക്വലണും',
 			'PN' => 'പിറ്റ്കെയ്ൻ',
 			'PR' => 'പോർട്ടോ റിക്കോ',
 			'PS' => 'പാലസ്‌തീൻ പ്രദേശങ്ങൾ',
 			'PS@alt=short' => 'പാലസ്‌തീൻ',
 			'PT' => 'പോർച്ചുഗൽ',
 			'PW' => 'പലാവു',
 			'PY' => 'പരാഗ്വേ',
 			'QA' => 'ഖത്തർ',
 			'QO' => 'പുറംദ്വീപുകൾ',
 			'RE' => 'റീയൂണിയൻ',
 			'RO' => 'റുമേനിയ',
 			'RS' => 'സെർബിയ',
 			'RU' => 'റഷ്യ',
 			'RW' => 'റുവാണ്ട',
 			'SA' => 'സൗദി അറേബ്യ',
 			'SB' => 'സോളമൻ‍ ദ്വീപുകൾ',
 			'SC' => 'സെയ്‌ഷെൽസ്',
 			'SD' => 'സുഡാൻ',
 			'SE' => 'സ്വീഡൻ',
 			'SG' => 'സിംഗപ്പുർ',
 			'SH' => 'സെൻറ് ഹെലീന',
 			'SI' => 'സ്ലോവേനിയ',
 			'SJ' => 'സ്വാൽബാഡും ജാൻ മായേനും',
 			'SK' => 'സ്ലോവാക്യ',
 			'SL' => 'സിയേറാ ലിയോൺ',
 			'SM' => 'സാൻ മറിനോ',
 			'SN' => 'സെനഗൽ',
 			'SO' => 'സോമാലിയ',
 			'SR' => 'സുറിനാം',
 			'SS' => 'ദക്ഷിണ സുഡാൻ',
 			'ST' => 'സാവോ റ്റമെ ആൻഡ് പ്രിൻസിപ്പി',
 			'SV' => 'എൽ സാൽവദോർ',
 			'SX' => 'സിന്റ് മാർട്ടെൻ',
 			'SY' => 'സിറിയ',
 			'SZ' => 'സ്വാസിലാൻറ്',
 			'TA' => 'ട്രസ്റ്റൻ ഡ കൂന',
 			'TC' => 'ടർക്ക്സും കൈക്കോ ദ്വീപുകളും',
 			'TD' => 'ചാഡ്',
 			'TF' => 'ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം',
 			'TG' => 'ടോഗോ',
 			'TH' => 'തായ്‌ലാൻഡ്',
 			'TJ' => 'താജിക്കിസ്ഥാൻ',
 			'TK' => 'ടൊകെലാവു',
 			'TL' => 'കിഴക്കൻ തിമൂർ',
 			'TL@alt=variant' => 'കിഴക്കൻ തിമോർ',
 			'TM' => 'തുർക്ക്മെനിസ്ഥാൻ',
 			'TN' => 'ടുണീഷ്യ',
 			'TO' => 'ടോംഗ',
 			'TR' => 'തുർക്കി',
 			'TT' => 'ട്രിനിഡാഡും റ്റൊബാഗോയും',
 			'TV' => 'തുവാലു',
 			'TW' => 'തായ്‌വാൻ',
 			'TZ' => 'ടാൻസാനിയ',
 			'UA' => 'ഉക്രൈൻ',
 			'UG' => 'ഉഗാണ്ട',
 			'UM' => 'യു.എസ് ചെറിയ പുറംദ്വീപുകളും',
 			'US' => 'അമേരിക്കൻ ഐക്യനാടുകൾ',
 			'US@alt=short' => 'യു.എസ്',
 			'UY' => 'ഉറുഗ്വേ',
 			'UZ' => 'ഉസ്‌ബെക്കിസ്ഥാൻ',
 			'VA' => 'വത്തിക്കാൻ',
 			'VC' => 'സെൻറ് വിൻസൻറും ഗ്രനഡൈൻസും',
 			'VE' => 'വെനിസ്വേല',
 			'VG' => 'ബ്രിട്ടീഷ് വെർജിൻ ദ്വീപുകൾ',
 			'VI' => 'യു.എസ്. വെർജിൻ ദ്വീപുകൾ',
 			'VN' => 'വിയറ്റ്നാം',
 			'VU' => 'വന്വാത്തു',
 			'WF' => 'വാലിസ് ആൻഡ് ഫ്യുചൂന',
 			'WS' => 'സാമോവ',
 			'XK' => 'കൊസോവൊ',
 			'YE' => 'യമൻ',
 			'YT' => 'മയോട്ട്',
 			'ZA' => 'ദക്ഷിണാഫ്രിക്ക',
 			'ZM' => 'സാംബിയ',
 			'ZW' => 'സിംബാബ്‌വേ',
 			'ZZ' => 'അജ്ഞാത പ്രദേശം',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1996' => '1996-ലെ ജർമൻ ലിപി',
 			'1606NICT' => '1606 വരെയുള്ള ആധുനികമദ്ധ്യകാല ഫ്രഞ്ച്',
 			'AREVELA' => 'കിഴക്കൻ അർമീനിയൻ',
 			'BOONT' => 'ബൂണ്ട്‌ലിങ്ങ്',
 			'FONIPA' => 'ഐപി‌എ സ്വനവ്യവസ്ഥ',
 			'MONOTON' => 'മോണോറ്റോണിക്',
 			'NEDIS' => 'നേറ്റിസോൺ പ്രാദേശികരൂപം',
 			'NJIVA' => 'ഗ്നിവ/നിജിവ പ്രാദേശികരൂപം',
 			'PINYIN' => 'പിൻയിൻ റോമനൈസേഷൻ',
 			'POSIX' => 'കമ്പ്യൂട്ടർ',
 			'REVISED' => 'പരിഷ്ക്കരിച്ച ലിപി',
 			'WADEGILE' => 'വേഡ്-ഗൈൽസ് റോമനൈസേഷൻ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'കലണ്ടർ',
 			'colalternate' => 'ചിഹ്നങ്ങൾ പ്രകാരം അടുക്കുന്നത് അവഗണിക്കുക',
 			'colbackwards' => 'വിപരീതക്രമ ആക്‌സന്റ് പ്രകാരമുള്ള അടുക്കൽ',
 			'colcasefirst' => 'വലിയക്ഷര/ചെറിയക്ഷര പ്രകാരമുള്ള അടുക്കൽ',
 			'colcaselevel' => 'കേസ് സെൻസിറ്റീവ് അടുക്കൽ',
 			'colhiraganaquaternary' => 'Kana അടുക്കൽ',
 			'collation' => 'അകാരാദിക്രമം',
 			'colnormalization' => 'സാധാരണ അടുക്കൽ',
 			'colnumeric' => 'അക്കങ്ങൾ പ്രകാരമുള്ള അടുക്കൽ',
 			'colstrength' => 'അടുക്കൽ ദൃഢത',
 			'currency' => 'നാണയം',
 			'numbers' => 'അക്കങ്ങൾ‌',
 			'timezone' => 'സമയ മേഖല',
 			'va' => 'ഭാഷാ ഭേദം',
 			'variabletop' => 'ചിഹ്നങ്ങളായി അടുക്കുക',
 			'x' => 'സ്വകാര്യ ഉപയോഗം',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ബുദ്ധമതകലണ്ടർ},
 				'chinese' => q{ചൈനീസ് കലണ്ടർ},
 				'coptic' => q{കോപ്റ്റിക് കലണ്ടർ},
 				'ethiopic' => q{എത്യോപിക് കലണ്ടർ},
 				'ethiopic-amete-alem' => q{എത്യോപിക് അമെതെ അലെം കലണ്ടർ},
 				'gregorian' => q{ഇംഗ്ലീഷ് കലണ്ടർ},
 				'hebrew' => q{ഹീബ്രൂ കലണ്ടർ},
 				'indian' => q{ശകവർഷ കലണ്ടർ},
 				'islamic' => q{ഇസ്ലാം കലണ്ടർ},
 				'islamic-civil' => q{ഇസ്ലാം-സിവിൽ കലണ്ടർ},
 				'japanese' => q{ജാപ്പനീസ് കലണ്ടർ},
 				'persian' => q{പേർഷ്യൻ കലണ്ടർ},
 				'roc' => q{ചൈനീസ് കലണ്ടർ},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{ചിഹ്നങ്ങൾ അടുക്കുക},
 				'shifted' => q{അവഗണിക്കൽ ചിഹ്നങ്ങൾ അടുക്കുക},
 			},
 			'colbackwards' => {
 				'no' => q{സാധാരണ ആക്‌സന്റുകൾ പ്രകാരം അടുക്കുക},
 				'yes' => q{ആക്‌സന്റുകളെ വിപരീതക്രമത്തിൽ അടുക്കുക},
 			},
 			'colcasefirst' => {
 				'lower' => q{ആദ്യം ചെറിയക്ഷര പ്രകാരം അടുക്കുക},
 				'no' => q{സാധാരണ കേസ് ക്രമത്തിൽ അടുക്കുക},
 				'upper' => q{ആദ്യം വലിയക്ഷരപ്രകാരം അടുക്കുക},
 			},
 			'colcaselevel' => {
 				'no' => q{കേസ് സെൻസിറ്റീവ് പ്രകാരം അടുക്കുക},
 				'yes' => q{കേസ് സെൻസിറ്റീവ് അടുക്കുക},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{Kana പ്രത്യേകം അടുക്കുക},
 				'yes' => q{Kana വ്യത്യസ്‌തമായി അടുക്കുക},
 			},
 			'collation' => {
 				'big5han' => q{പരമ്പരാഗത ചൈനീസ് ക്രമീകരണം - ബിഗ്5},
 				'dictionary' => q{നിഘണ്ടു അടുക്കൽ ക്രമം},
 				'ducet' => q{സ്ഥിരസ്ഥിതി യൂണീകോഡ് അടുക്കൽ ക്രമം},
 				'gb2312han' => q{ലളിതമായ ചൈനീസ് ക്രമീകരണം - ജീബി2312},
 				'phonebook' => q{ഫോൺബുക്കിലെ ക്രമീകരണം},
 				'phonetic' => q{സ്വരസൂചക അടുക്കൽ ക്രമം},
 				'pinyin' => q{പിൻ‌യിൻ ക്രമീകരണം},
 				'reformed' => q{നവീകരിച്ച അടുക്കൽ ക്രമം},
 				'search' => q{പൊതുലക്ഷ്യത്തിനുള്ള തിരയൽ},
 				'searchjl' => q{ഹാംഗൽ പ്രാരംഭ വ്യഞ്ജനാക്ഷരം പ്രകാരം തിരയുക},
 				'standard' => q{സാധാരണ ക്രമം},
 				'stroke' => q{സ്റ്റ്രോക്ക് ക്രമീകരണം},
 				'traditional' => q{പരമ്പരാഗത ക്രമീകരണം},
 				'unihan' => q{റാഡിക്കൽ-സ്ട്രോക്ക് അടുക്കൽ ക്രമം},
 			},
 			'colnormalization' => {
 				'no' => q{സാധാരണരീതി ഇല്ലാതെ അടുക്കുക},
 				'yes' => q{സാധാരണ യൂണിക്കോഡ് അടുക്കുക},
 			},
 			'colnumeric' => {
 				'no' => q{ഓരോ ഡിജിറ്റുകൾ പ്രകാരം അടുക്കുക},
 				'yes' => q{ഡിജിറ്റുകളെ സംഖ്യാപരമായി അടുക്കുക},
 			},
 			'colstrength' => {
 				'identical' => q{എല്ലാം അടുക്കുക},
 				'primary' => q{അടിസ്ഥാന അക്ഷരങ്ങൾ മാത്രം അടുക്കുക},
 				'quaternary' => q{ആക്‌സന്റുകൾ/കേസ്/വീതി/Kana അടുക്കുക},
 				'secondary' => q{ആക്‌സന്റുകൾ അടുക്കുക},
 				'tertiary' => q{ആക്‌സന്റുകൾ/കേസ്/വീതി അടുക്കുക},
 			},
 			'numbers' => {
 				'arab' => q{അറബിക്-ഇന്ത്യ അക്കങ്ങൾ},
 				'arabext' => q{വിപുലീകൃത അറബി-ഭാരതീയ അക്കങ്ങൾ},
 				'armn' => q{അർമേനിയൻ സംഖ്യകൾ},
 				'armnlow' => q{അർമേനിയൻ ചെറിയ സംഖ്യകൾ},
 				'beng' => q{ബംഗാളി അക്കങ്ങൾ},
 				'deva' => q{ദേവനാഗരി അക്കങ്ങൾ},
 				'ethi' => q{എത്യോപിക് സംഖ്യകൾ},
 				'finance' => q{സാമ്പത്തിക സംഖ്യകൾ},
 				'fullwide' => q{പൂർണ വലുപ്പമുള്ള സംഖ്യകൾ},
 				'geor' => q{ജോർജിയൻ സംഖ്യകൾ},
 				'grek' => q{ഗ്രീക്ക് സംഖ്യകൾ},
 				'greklow' => q{ഗ്രീക്ക് ചെറിയക്ഷര സംഖ്യകൾ},
 				'gujr' => q{ഗുജറാത്തി അക്കങ്ങൾ},
 				'guru' => q{ഗുരുമുഖി അക്കങ്ങൾ},
 				'hanidec' => q{ചൈനീസ്},
 				'hans' => q{ലളിതവൽക്കരിച്ച ചൈനീസ് സംഖ്യകൾ},
 				'hansfin' => q{ലളിതവൽക്കരിച്ച ചൈനീസ് ധനകാര്യ സംഖ്യകൾ},
 				'hant' => q{പരമ്പരാഗത ചൈനീസ് സംഖ്യകൾ},
 				'hantfin' => q{പരമ്പരാഗത ചൈനീസ് ധനകാര്യ സംഖ്യകൾ},
 				'hebr' => q{ഹീബ്രു സംഖ്യകൾ},
 				'jpan' => q{ജപ്പാനീസ് സംഖ്യകൾ},
 				'jpanfin' => q{ജപ്പാനീസ് ധനകാര്യ സംഖ്യകൾ},
 				'khmr' => q{ഖമേർ അക്കങ്ങൾ},
 				'knda' => q{കന്നഡ സംഖ്യകൾ},
 				'laoo' => q{ലാവോ അക്കങ്ങൾ},
 				'latn' => q{പടിഞ്ഞാറൻ അക്കങ്ങൾ},
 				'mlym' => q{മലയാളം അക്കങ്ങൾ},
 				'mong' => q{മംഗോളിയൻ സംഖ്യകൾ},
 				'mymr' => q{മ്യാൻമാർ അക്കങ്ങൾ},
 				'native' => q{സ്വാഭാവിക ഡിജിറ്റുകൾ},
 				'orya' => q{ഒഡിയ അക്കങ്ങൾ},
 				'roman' => q{റോമൻ സംഖ്യകൾ},
 				'romanlow' => q{റോമൻ ചെറിയ സംഖ്യകൾ},
 				'taml' => q{പഴയ തമിഴ് സംഖ്യകൾ},
 				'tamldec' => q{തമിഴ് അക്കങ്ങൾ},
 				'telu' => q{തെലുങ്ക് സംഖ്യകൾ},
 				'thai' => q{തായി അക്കങ്ങൾ},
 				'tibt' => q{തിബത്തൻ അക്കങ്ങൾ},
 				'traditional' => q{സാധാരണയായി ഉപയോഗിച്ചുവരുന്ന സംഖ്യകൾ},
 				'vaii' => q{വായ് സംഖ്യകൾ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{മെട്രിക്ക്},
 			'UK' => q{യുകെ},
 			'US' => q{യുഎസ്സ്},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'സംഖ്യാപരമായ',
 			'tone' => 'ശബ്ദം',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'ആൿസൻറുകൾ‌',
 			'x-fullwidth' => 'പൂർണവീതി',
 			'x-halfwidth' => 'ഹാഫ്‍വിഡ്ത്ത്',
 			'x-jamo' => 'ജാമോ',
 			'x-pinyin' => 'പിൻയിൻ',
 			'x-publishing' => 'പ്രസിദ്ധീകരിക്കുന്നു',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ഭാഷ: {0}',
 			'script' => 'ലിപി: {0}',
 			'territory' => 'പ്രദേശം: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍])},
			index => ['അ', 'ആ', 'ഇ', 'ഈ', 'ഉ', 'ഊ', 'ഋ', 'എ', 'ഏ', 'ഐ', 'ഒ', 'ഓ', 'ഔ', 'ക', 'ഖ', 'ഗ', 'ഘ', 'ങ', 'ച', 'ഛ', 'ജ', 'ഝ', 'ഞ', 'ട', 'ഠ', 'ഡ', 'ഢ', 'ണ', 'ത', 'ഥ', 'ദ', 'ധ', 'ന', 'പ', 'ഫ', 'ബ', 'ഭ', 'മ', 'യ', 'ര', 'ല', 'വ', 'ശ', 'ഷ', 'സ', 'ഹ', 'ള', 'ഴ', 'റ'],
			main => qr{(?^u:[‌‍ ഃ അ ആ ഇ ഈ ഉ ഊ ഋ ൠ ഌ ൡ എ ഏ ഐ ഒ ഓ ഔ ക ൿ ഖ ഗ ഘ ങ ച ഛ ജ ഝ ഞ ട ഠ ഡ ഢ ണ ൺ ത ഥ ദ ധ ന ൻ പ ഫ ബ ഭ മ ം യ ര ർ ല ൽ വ ശ ഷ സ ഹ ള ൾ ഴ റ ാ ി ീ ു ൂ ൃ െ േ ൈ ൊ ോ ൗ ൌ ്])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} ഏക്കർ),
						'other' => q({0} ഏക്കർ),
					},
					'arc-minute' => {
						'one' => q({0} മിനിറ്റ്),
						'other' => q({0} മിനിറ്റ്),
					},
					'arc-second' => {
						'one' => q({0} സെക്കന്റ്),
						'other' => q({0} സെക്കന്റ്),
					},
					'celsius' => {
						'one' => q({0} ഡിഗ്രി സെൽഷ്യൽസ്),
						'other' => q({0} ഡിഗ്രി സെൽഷ്യസ്),
					},
					'centimeter' => {
						'one' => q({0} സെന്റീമീറ്റർ),
						'other' => q({0} സെന്റീമീറ്റർ),
					},
					'cubic-kilometer' => {
						'one' => q({0} ക്യൂബിക്ക് കിലോമീറ്റർ),
						'other' => q({0} ക്യൂബിക്ക് കിലോമീറ്റർ),
					},
					'cubic-mile' => {
						'one' => q({0} ക്യൂബിക്ക് മൈൽ),
						'other' => q({0} ക്യൂബിക്ക് മൈൽ),
					},
					'day' => {
						'one' => q({0} ദിവസം),
						'other' => q({0} ദിവസം),
					},
					'degree' => {
						'one' => q({0} ഡിഗ്രി),
						'other' => q({0} ഡിഗ്രി),
					},
					'fahrenheit' => {
						'one' => q({0} ഡിഗ്രി ഫാരൻഹീറ്റ്),
						'other' => q({0} ഡിഗ്രി ഫാരൻഹീറ്റ്),
					},
					'foot' => {
						'one' => q({0} അടി),
						'other' => q({0} അടി),
					},
					'g-force' => {
						'one' => q({0} ജി-ഫോഴ്‌സ്),
						'other' => q({0} ജി-ഫോഴ്‌സ്),
					},
					'gram' => {
						'one' => q({0} ഗ്രാം),
						'other' => q({0} ഗ്രാം),
					},
					'hectare' => {
						'one' => q({0} ഹെക്‌ടർ),
						'other' => q({0} ഹെക്‌ടർ),
					},
					'hectopascal' => {
						'one' => q({0} ഹെക്‌ടോപാസ്‌ക്കൽ),
						'other' => q({0} ഹെക്‌ടോപാസ്‌ക്കൽ),
					},
					'horsepower' => {
						'one' => q({0} കുതിരശക്തി),
						'other' => q({0} കുതിരശക്തി),
					},
					'hour' => {
						'one' => q({0} മണിക്കൂർ),
						'other' => q({0} മണിക്കൂർ),
					},
					'inch' => {
						'one' => q({0} ഇഞ്ച്),
						'other' => q({0} ഇഞ്ച്),
					},
					'inch-hg' => {
						'one' => q({0} ഇഞ്ച് ഓഫ് മെർക്കുറി),
						'other' => q({0} ഇഞ്ച് ഓഫ് മെർക്കുറി),
					},
					'kilogram' => {
						'one' => q({0} കിലോഗ്രാം),
						'other' => q({0} കിലോഗ്രാം),
					},
					'kilometer' => {
						'one' => q({0} കിലോമീറ്റർ),
						'other' => q({0} കിലോമീറ്റർ),
					},
					'kilometer-per-hour' => {
						'one' => q(മണിക്കൂറിൽ {0} കിലോമീറ്റർ),
						'other' => q(മണിക്കൂറിൽ {0} കിലോമീറ്റർ),
					},
					'kilowatt' => {
						'one' => q({0} കിലോവാട്ട്),
						'other' => q({0} കിലോവാട്ട്),
					},
					'light-year' => {
						'one' => q({0} പ്രകാശവർഷം),
						'other' => q({0} പ്രകാശവർഷം),
					},
					'liter' => {
						'one' => q({0} ലിറ്റർ),
						'other' => q({0} ലിറ്റർ),
					},
					'meter' => {
						'one' => q({0} മീറ്റർ),
						'other' => q({0} മീറ്റർ),
					},
					'meter-per-second' => {
						'one' => q(സെക്കന്റിൽ {0} മീറ്റർ),
						'other' => q(സെക്കന്റിൽ {0} മീറ്റർ),
					},
					'mile' => {
						'one' => q({0} മൈൽ),
						'other' => q({0} മൈൽ),
					},
					'mile-per-hour' => {
						'one' => q(മണിക്കൂറിൽ {0} മൈൽ),
						'other' => q(മണിക്കൂറിൽ {0} മൈൽ),
					},
					'millibar' => {
						'one' => q({0} മില്ലിബാർ),
						'other' => q({0} മില്ലിബാർ),
					},
					'millimeter' => {
						'one' => q({0} മില്ലീമീറ്റർ),
						'other' => q({0} മില്ലീമീറ്റർ),
					},
					'millisecond' => {
						'one' => q({0} മില്ലിസെക്കന്റ്),
						'other' => q({0} മില്ലിസെക്കന്റ്),
					},
					'minute' => {
						'one' => q({0} മിനിട്ട്),
						'other' => q({0} മിനിട്ട്),
					},
					'month' => {
						'one' => q({0} മാസം),
						'other' => q({0} മാസം),
					},
					'ounce' => {
						'one' => q({0} ഔൺസ്),
						'other' => q({0} ഔൺസ്),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} പൈക്കോമീറ്റർ),
						'other' => q({0} പൈക്കോമീറ്റർ),
					},
					'pound' => {
						'one' => q({0} പൗണ്ട്),
						'other' => q({0} പൗണ്ട്),
					},
					'second' => {
						'one' => q({0} സെക്കന്റ്),
						'other' => q({0} സെക്കന്റ്),
					},
					'square-foot' => {
						'one' => q({0} ചതുരശ്ര അടി),
						'other' => q({0} ചതുരശ്ര അടി),
					},
					'square-kilometer' => {
						'one' => q({0} ചതുരശ്ര കിലോമീറ്റർ),
						'other' => q({0} ചതുരശ്ര കിലോമീറ്റർ),
					},
					'square-meter' => {
						'one' => q({0} ചതുരശ്ര മീറ്റർ),
						'other' => q({0} ചതുരശ്ര മീറ്റർ),
					},
					'square-mile' => {
						'one' => q({0} ചതുരശ്ര മൈൽ),
						'other' => q({0} ചതുരശ്ര മൈൽ),
					},
					'watt' => {
						'one' => q({0} വാട്ട്),
						'other' => q({0} വാട്ട്),
					},
					'week' => {
						'one' => q({0} ആഴ്ച),
						'other' => q({0} ആഴ്ച),
					},
					'yard' => {
						'one' => q({0} യാർഡ്),
						'other' => q({0} യാർഡ്),
					},
					'year' => {
						'one' => q({0} വർഷം),
						'other' => q({0} വർഷം),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} ഏ),
						'other' => q({0} ഏക്ക),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} സെമി),
						'other' => q({0} സെമി),
					},
					'cubic-kilometer' => {
						'one' => q({0} കിമീ³),
						'other' => q({0} കിമീ³),
					},
					'cubic-mile' => {
						'one' => q({0} മൈ³),
						'other' => q({0} മൈ³),
					},
					'day' => {
						'one' => q({0} ദി),
						'other' => q({0} ദി),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°ഫാ),
						'other' => q({0}°ഫാ),
					},
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'g-force' => {
						'one' => q({0} ജി),
						'other' => q({0} ജി),
					},
					'gram' => {
						'one' => q({0} ഗ്രാം),
						'other' => q({0} ഗ്രാം),
					},
					'hectare' => {
						'one' => q({0} ഹെ),
						'other' => q({0} ഹെ),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'one' => q({0} മ),
						'other' => q({0} മ),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
					},
					'kilometer' => {
						'one' => q({0} കിമി),
						'other' => q({0} കിമി),
					},
					'kilometer-per-hour' => {
						'one' => q({0}കിമീ/മ),
						'other' => q({0}കിമീ/മ),
					},
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					'light-year' => {
						'one' => q({0} പ്ര.വ),
						'other' => q({0} പ്ര.വ),
					},
					'liter' => {
						'one' => q({0} ലി),
						'other' => q({0} ലി),
					},
					'meter' => {
						'one' => q({0} മീ),
						'other' => q({0} മീ),
					},
					'meter-per-second' => {
						'one' => q({0} മീ/സെ),
						'other' => q({0} മീ/സെ),
					},
					'mile' => {
						'one' => q({0} മൈ),
						'other' => q({0} മൈ),
					},
					'mile-per-hour' => {
						'one' => q({0} മൈ/മ),
						'other' => q({0} മൈ/മ),
					},
					'millibar' => {
						'one' => q({0} മിബാ),
						'other' => q({0} മിബാ),
					},
					'millimeter' => {
						'one' => q({0} മിമീ),
						'other' => q({0} മിമീ),
					},
					'millisecond' => {
						'one' => q({0} മിസെ),
						'other' => q({0} മിസെ),
					},
					'minute' => {
						'one' => q({0} മി),
						'other' => q({0} മി),
					},
					'month' => {
						'one' => q({0} മാ),
						'other' => q({0} മാ),
					},
					'ounce' => {
						'one' => q({0} ഔ),
						'other' => q({0} ഔ),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} പൈ.മീ),
						'other' => q({0} പൈ.മീ),
					},
					'pound' => {
						'one' => q({0} പൗ),
						'other' => q({0} പൗ),
					},
					'second' => {
						'one' => q({0} സെ),
						'other' => q({0} സെ),
					},
					'square-foot' => {
						'one' => q({0} ച. അടി),
						'other' => q({0} ച.അടി),
					},
					'square-kilometer' => {
						'one' => q({0} ച.കിമീ),
						'other' => q({0} ച.കിമീ),
					},
					'square-meter' => {
						'one' => q({0} ച.മീ),
						'other' => q({0} ച.മീ),
					},
					'square-mile' => {
						'one' => q({0} ച.മൈ),
						'other' => q({0} ച.മൈ),
					},
					'watt' => {
						'one' => q({0} വാ),
						'other' => q({0} വാ),
					},
					'week' => {
						'one' => q({0} ആ),
						'other' => q({0} ആ),
					},
					'yard' => {
						'one' => q({0} യാ),
						'other' => q({0} യാ),
					},
					'year' => {
						'one' => q({0} വ),
						'other' => q({0} വ),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} ഏക്ക),
						'other' => q({0} ഏക്ക),
					},
					'arc-minute' => {
						'one' => q({0} മി),
						'other' => q({0} മി),
					},
					'arc-second' => {
						'one' => q({0} സെ),
						'other' => q({0} സെ),
					},
					'celsius' => {
						'one' => q({0}°സെ),
						'other' => q({0}°സെ),
					},
					'centimeter' => {
						'one' => q({0} സെമി),
						'other' => q({0} സെമി),
					},
					'cubic-kilometer' => {
						'one' => q({0} കി.മീ³),
						'other' => q({0} കി.മീ³),
					},
					'cubic-mile' => {
						'one' => q({0} മൈ³),
						'other' => q({0} മൈ³),
					},
					'day' => {
						'one' => q({0} ദിവസം‌),
						'other' => q({0} ദിവസം‌),
					},
					'degree' => {
						'one' => q({0} ഡിഗ്രി),
						'other' => q({0} ഡിഗ്രി),
					},
					'fahrenheit' => {
						'one' => q({0}° ഫാ),
						'other' => q({0}°ഫാ),
					},
					'foot' => {
						'one' => q({0} അടി),
						'other' => q({0} അടി),
					},
					'g-force' => {
						'one' => q({0} ജി),
						'other' => q({0} ജി),
					},
					'gram' => {
						'one' => q({0} ഗ്രാം),
						'other' => q({0} ഗ്രാം),
					},
					'hectare' => {
						'one' => q({0} ഹെക്),
						'other' => q({0} ഹെക്),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} എച്ച്‌പി),
						'other' => q({0} എച്ച്‌പി),
					},
					'hour' => {
						'one' => q({0} മണിക്കൂർ‌),
						'other' => q({0} മണിക്കൂർ),
					},
					'inch' => {
						'one' => q({0} ഇഞ്ച്),
						'other' => q({0} ഇഞ്ച്),
					},
					'inch-hg' => {
						'one' => q(Hg ൽ {0}),
						'other' => q(Hg ൽ {0}),
					},
					'kilogram' => {
						'one' => q({0} കി.ഗ്രാം),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'one' => q({0} കിമി),
						'other' => q({0} കിമി),
					},
					'kilometer-per-hour' => {
						'one' => q({0} കിമീ/മ),
						'other' => q({0} കിമീ/മ),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0} പ്രകാ.വർ),
						'other' => q({0} പ്രക.വർ),
					},
					'liter' => {
						'one' => q({0} ലിറ്റ.),
						'other' => q({0} ലിറ്റ.),
					},
					'meter' => {
						'one' => q({0} മീ),
						'other' => q({0} മീ),
					},
					'meter-per-second' => {
						'one' => q({0} മീ/സെ),
						'other' => q({0} മീ/സെ),
					},
					'mile' => {
						'one' => q({0} മൈൽ),
						'other' => q({0} മൈ),
					},
					'mile-per-hour' => {
						'one' => q({0} മൈ/മ),
						'other' => q({0} മൈ/മ),
					},
					'millibar' => {
						'one' => q({0} മി.ബാ),
						'other' => q({0} മി.ബാ),
					},
					'millimeter' => {
						'one' => q({0} മിമീ),
						'other' => q({0} മിമീ),
					},
					'millisecond' => {
						'one' => q({0} മി.സെ),
						'other' => q({0} മി.സെ),
					},
					'minute' => {
						'one' => q({0} മിനിറ്റ്),
						'other' => q({0} മിനിറ്റ്),
					},
					'month' => {
						'one' => q({0} മാസം),
						'other' => q({0} മാസം),
					},
					'ounce' => {
						'one' => q({0} ഔ),
						'other' => q({0} ഔ),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} പൈ.മീ),
						'other' => q({0} പൈ.മീ),
					},
					'pound' => {
						'one' => q({0} പൗ),
						'other' => q({0} പൗ),
					},
					'second' => {
						'one' => q({0} സെക്കൻറ്),
						'other' => q({0} സെക്കൻറ്),
					},
					'square-foot' => {
						'one' => q({0} ചതുര.അടി),
						'other' => q({0} ചതുര.അടി),
					},
					'square-kilometer' => {
						'one' => q({0} ചതു. കിമീ),
						'other' => q({0} ചതു.കിമീ),
					},
					'square-meter' => {
						'one' => q({0} ചതു.മീ),
						'other' => q({0} ചതു.മീ),
					},
					'square-mile' => {
						'one' => q({0} ചതു.മൈ),
						'other' => q({0} ചതു.മൈ),
					},
					'watt' => {
						'one' => q({0} വാ),
						'other' => q({0} വാ),
					},
					'week' => {
						'one' => q({0} ആഴ്‌ച),
						'other' => q({0} ആഴ്‌ച),
					},
					'yard' => {
						'one' => q({0} യാ),
						'other' => q({0} യാ),
					},
					'year' => {
						'one' => q({0} വർ‌ഷം),
						'other' => q({0} വർ‌ഷം),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:അതെ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:അല്ല|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0} കൂടാതെ {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'mlym',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'mlym' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(സംഖ്യയല്ല),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0.###',
				},
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ആയിരം',
					'other' => '0 ആയിരം',
				},
				'10000' => {
					'one' => '00 ആയിരം',
					'other' => '00 ആയിരം',
				},
				'100000' => {
					'one' => '000 ആയിരം',
					'other' => '000 ആയിരം',
				},
				'1000000' => {
					'one' => '0 ദശലക്ഷം',
					'other' => '0 ദശലക്ഷം',
				},
				'10000000' => {
					'one' => '00 ദശലക്ഷം',
					'other' => '00 ദശലക്ഷം',
				},
				'100000000' => {
					'one' => '000 ദശലക്ഷം',
					'other' => '000 ദശലക്ഷം',
				},
				'1000000000' => {
					'one' => '0 ലക്ഷം കോടി',
					'other' => '0 ലക്ഷം കോടി',
				},
				'10000000000' => {
					'one' => '00 ലക്ഷം കോടി',
					'other' => '00 ലക്ഷം കോടി',
				},
				'100000000000' => {
					'one' => '000 ലക്ഷം കോടി',
					'other' => '000 ലക്ഷം കോടി',
				},
				'1000000000000' => {
					'one' => '0 ട്രില്യൺ',
					'other' => '0 ട്രില്യൺ',
				},
				'10000000000000' => {
					'one' => '00 ട്രില്യൺ',
					'other' => '00 ട്രില്യൺ',
				},
				'100000000000000' => {
					'one' => '000 ട്രില്യൺ',
					'other' => '000 ട്രില്യൺ',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '#,##,##0.00¤',
						'positive' => '#,##,##0.00¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(അൻഡോറൻ പെസെയ്റ്റ),
				'one' => q(അൻഡോറൻ പെസെയ്റ്റ),
				'other' => q(അൻഡോറൻ പെസെയ്റ്റാസ്),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(യു.എ.ഇ. ദിർഹം),
				'one' => q(യു.എ.ഇ. ദിർഹം),
				'other' => q(യു.എ.ഇ. ദിർഹംസ്),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(അഫ്ഘാനി \(1927–2002\)),
				'one' => q(അഫ്ഘാനി \(AFA\)),
				'other' => q(അഫ്ഘാനിസ് \(AFA\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(അഫ്‌ഗാൻ അഫ്‌‌ഗാനി),
				'one' => q(അഫ്‌ഗാൻ അഫ്‌‌ഗാനി),
				'other' => q(അഫ്‌ഗാൻ അഫ്‌‌ഗാനിസ്),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(അൽബേനിയൻ ലെക്),
				'one' => q(അൽബേനിയൻ ലെക്),
				'other' => q(അൽബേനിയൻ ലെക്സ്),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(അർമേനിയൻ ഡ്രാം),
				'one' => q(അർമേനിയൻ ഡ്രാം),
				'other' => q(അർമേനിയൻ ഡ്രാംസ്),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(നെതർലൻഡ്സ് ആൻറിലൻ ഗിൽഡർ),
				'one' => q(നെതർലൻഡ്സ് ആൻഡിലൻ ഗിൽഡർ),
				'other' => q(നെതർലൻഡ്സ് ആൻഡിലൻ ഗിൽഡേഴ്സ്),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ക്വാൻസ),
				'one' => q(അംഗോളൻ ക്വാൻസ),
				'other' => q(അംഗോളൻ ക്വാൻസാസ്),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ക്വാൻസ \(1977–1990\)),
				'one' => q(അംഗോളൻ ക്വാൻസാ \(AOK\)),
				'other' => q(അംഗോളൻ ക്വാൻസാസ് \(AOK),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ന്യൂ ക്വാൻസ \(1990–2000\)),
				'one' => q(അംഗോളൻ ന്യൂ ക്വാൻസാ \(AON\)),
				'other' => q(അംഗോളൻ ന്യൂ ക്വാൻസാസ് \(AON\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ക്വാൻസ റിയാജസ്റ്റാഡോ \(1995–1999\)),
				'one' => q(അംഗോളൻ ക്വാൻസ റീഅഡ്ജസ്റ്റാഡോ \(AOR\)),
				'other' => q(അംഗോളൻ ക്വാൻസാസ് റീഅഡ്ജസ്റ്റാഡോ \(AOR\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(അർജൻറീൻ ഓസ്ട്രൽ),
				'one' => q(അർജൻറീൻ ഓസ്ട്രൽ),
				'other' => q(അർജൻറീൻ ഓസ്ട്രൽസ്),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(അർജൻറീൻ പെയ്സോ \(1983–1985\)),
				'one' => q(അർജൻറീൻ പെയ്സോ \(ARP\)),
				'other' => q(അർജൻറീൻ പെയ്സോസ് \(ARP\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(അർജൻറീൻ പെസോ),
				'one' => q(അർജൻറീൻ പെസോ),
				'other' => q(അർജൻറീൻ പെസോ),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ഓസ്ട്രേലിയൻ ഷില്ലിംഗ്),
				'one' => q(ഓസ്ട്രിയൻ ഷില്ലിംഗ്),
				'other' => q(ഓസ്ട്രിയൻ ഷില്ലിംഗ്സ്),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ആസ്ട്രേലിയൻ ഡോളർ),
				'one' => q(ഓസ്ട്രേലിയൻ ഡോളർ),
				'other' => q(ഓസ്ട്രേലിയൻ ഡോളേഴ്സ്),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(അറൂബൻ ഗിൽഡർ),
				'one' => q(അറൂബൻ ഗിൽഡർ),
				'other' => q(അറൂബൻ ഗിൽഡേഴ്സ്),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(അസർബയ്ജാനിയൻ മനത് \(1993–2006\)),
				'one' => q(അസർബയ്ജാൻ മനത്‌ \(AZM\)),
				'other' => q(അസർബയ്ജാൻ മനത്‌സ് \(AZM\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(അസർബയ്ജാനിയൻ മനത്),
				'one' => q(അസർബയ്ജാൻ മനത്),
				'other' => q(അസർബയ്ജാൻ മനത്‌സ്),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(ബോസ്നിയ-ഹെർസഗോവിന ദിനാർ),
				'one' => q(ബോസ്നിയ ഹെർസഗോവിന ദിനാർ),
				'other' => q(ബോസ്നിയ ഹെർസഗോവിന ദിനാർസ്),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(ബോസ്നിയ-ഹെർസഗോവിന കൺവേർട്ടിബിൾ മാർക്ക്),
				'one' => q(ബോസ്നിയ ഹെർസഗോവിന കൺവേർട്ടിബിൾ മാർക്ക്),
				'other' => q(ബോസ്നിയ ഹെർസഗോവിന കൺവേർട്ടിബിൾ മാർക്സ്),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ബാർബഡോസ് ഡോളർ),
				'one' => q(ബാർബഡോസ് ഡോളർ),
				'other' => q(ബാർബഡോസ് ഡോളർ),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(ബംഗ്ലാദേശി ടാക്ക),
				'one' => q(ബംഗ്ലാദേശ് താക്കാ),
				'other' => q(ബംഗ്ലാദേശ് താക്കാസ്),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(ബെൽജിയൻ ഫ്രാങ്ക് \(കൈമാറ്റം ചെയ്യാവുന്നത്\)),
				'one' => q(ബെൽജിയൻ ഫ്രാങ്ക് \(കൈമാറ്റം ചെയ്യാവുന്നത്\)),
				'other' => q(ബെൽജിയൻ ഫ്രാങ്ക്സ് \(കൈമാറ്റം ചെയ്യാവുന്നത്\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ബെൽജിയൻ ഫ്രാങ്ക്),
				'one' => q(ബെൽജിയൻ ഫ്രാങ്ക്),
				'other' => q(ബെൽജിയൻ ഫ്രാങ്ക്സ്),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(ബൽജിയൻ ഫ്രാങ്ക്),
				'one' => q(ബെൽജിയൻ ഫ്രാങ്ക് \(ഫിനാൻഷ്യൽ\)),
				'other' => q(ബെൽജിയൻ ഫ്രാങ്ക്സ്\(ഫിനാൻഷ്യൽ\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(ബൾഗേറിയൻ ഹാർഡ് ലെവ്),
				'one' => q(ബൾഗേറിയൻ ഹാർഡ് ലെവ്),
				'other' => q(ബൾഗേറിയൻ ഹാർഡ് ലെവ്സ്),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(ബൾഗേറിയൻ ന്യൂലവ്),
				'one' => q(ബൾഗേറിയൻ ന്യൂ ലെവ്),
				'other' => q(ബൾഗേറിയൻ ന്യൂ ലെവ്സ്),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ബഹറിൻ ദിനാർ),
				'one' => q(ബഹ്റൈൻ ദിനാർ),
				'other' => q(ബഹ്റൈൻ ദിനാർസ്),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ബുറുണ്ടിയൻ ഫ്രാങ്ക്),
				'one' => q(ബുറുണ്ടിയൻ ഫ്രാങ്ക്),
				'other' => q(ബുറുണ്ടിയൻ ഫ്രാങ്ക്),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(ബെർമുഡൻ ഡോളർ),
				'one' => q(ബെർമുഡൻ ഡോളർ),
				'other' => q(ബെർമുഡൻ ഡോളർ),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ബ്രൂണെ ഡോളർ),
				'one' => q(ബ്രൂണെ ഡോളർ),
				'other' => q(ബ്രൂണെ ഡോളറുകൾ),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(ബൊളീവിയൻ ബൊളിവിയാനോ),
				'one' => q(ബൊളീവിയൻ ബൊളിവിയാനോ),
				'other' => q(ബൊളീവിയൻ ബൊളീവിയാനോസ്),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ബൊളീവിയൻ പെയ്സോ),
				'one' => q(ബൊളീവിയൻ പെയ്സോ),
				'other' => q(ബൊളീവിയൻ പെയ്സോസ്),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(ബൊളീവിയൻ എംവിഡോൾ),
				'one' => q(ബൊളീവിയൻ എംവിഡോ),
				'other' => q(ബൊളീവിയൻ എംവിഡോസ്),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ നോവോ \(1967–1986\)),
				'one' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ നോവോ \(BRB\)),
				'other' => q(ബ്രസീലിയൻ ക്രുസെയ്റോസ് നോവോ \(BRB\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസാഡോ),
				'one' => q(ബ്രസീലിയൻ ക്രുസാഡോ),
				'other' => q(ബ്രസീലിയൻ ക്രുസാഡോസ്),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ \(1990–1993\)),
				'one' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ \(BRE\)),
				'other' => q(ബ്രസീലിയൻ ക്രുസെയ്റോസ് \(BRE\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ റിയാൽ),
				'one' => q(ബ്രസീലിയൻ റിയാൽ),
				'other' => q(ബ്രസീലിയൻ റിയാൽ),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസാഡോ നോവോ),
				'one' => q(ബ്രസീലിയൻ ക്രുസാഡോ നോവോ),
				'other' => q(ബ്രസീലിയൻ ക്രുസാഡോ നോവോസ്),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ),
				'one' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ),
				'other' => q(ബ്രസീലിയൻ ക്രുസെയ്റോസ്),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ബഹാമിയൻ ഡോളർ),
				'one' => q(ബഹാമിയൻ ഡോളർ),
				'other' => q(ബഹാമിയൻ ഡോളർ),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ഭൂട്ടാൻ എൻഗൾട്രം),
				'one' => q(ഭൂട്ടാൻ എൻഗൾട്രം),
				'other' => q(ഭൂട്ടാൻ എൻഗൾട്രംസ്),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(ബർമീസ് ചാറ്റ്),
				'one' => q(ബർമീസ് ചാറ്റ്),
				'other' => q(ബർമീസ് ചാറ്റ്സ്),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ബോട്സ്വാനൻ പ്യൂല),
				'one' => q(ബോട്സ്വാനൻ പ്യൂല),
				'other' => q(ബോട്സ്വാനൻ പ്യൂലാസ്),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ബെലാറഷ്യൻ ന്യൂ റൂബിൾ \(1994–1999\)),
				'one' => q(ബെലാറഷ്യൻ ന്യൂ റൂബിൾ \(BYB\)),
				'other' => q(ബെലാറഷ്യൻ ന്യൂ റൂബിൾസ് \(BYB\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(ബെലാറഷ്യൻ റൂബിൾ),
				'one' => q(ബെലാറഷ്യൻ റൂബിൾ),
				'other' => q(ബെലാറഷ്യൻ റൂബിൾസ്),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(ബെലീസ് ഡോളർ),
				'one' => q(ബെലീസ് ഡോളർ),
				'other' => q(ബെലീസ് ഡോളർ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(കനേഡിയൻ ഡോളർ),
				'one' => q(കനേഡിയൻ ഡോളർ),
				'other' => q(കനേഡിയൻ ഡോളർ),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(കോംഗോളീസ് ഫ്രാങ്ക്),
				'one' => q(കോംഗോളീസ് ഫ്രാങ്ക്),
				'other' => q(കോംഗോളീസ് ഫ്രാങ്ക്),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR യൂറോ),
				'one' => q(WIR യൂറോ),
				'other' => q(WIR യൂറോസ്),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(സ്വിസ് ഫ്രാങ്ക്),
				'one' => q(സ്വിസ് ഫ്രാങ്ക്),
				'other' => q(സ്വിസ് ഫ്രാങ്ക്സ്),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR ഫ്രാങ്ക്),
				'one' => q(WIR ഫ്രാങ്ക്),
				'other' => q(WIR ഫ്രാങ്ക്സ്),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(ചിലിയൻ യൂണിഡാഡ്സ് ഡി ഫോമെൻറോ),
				'one' => q(ചിലിയൻ യൂണിഡാഡ്സ് ഡി ഫോമെൻറോ),
				'other' => q(ചിലിയൻ യൂണിഡാഡ്സ് ഡി ഫോമെൻറോസ്),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ചിലിയൻ പെസോ),
				'one' => q(ചിലിയൻ പെസോ),
				'other' => q(ചിലിയൻ പെസോ),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ചൈനീസ് യുവാൻ),
				'one' => q(ചൈനീസ് യുവാൻ),
				'other' => q(ചൈനീസ് യുവാൻ),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(കൊളംബിയൻ പെസോ),
				'one' => q(കൊളംബിയൻ പെസോ),
				'other' => q(കൊളംബിയൻ പെസോ),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(യൂണിഡാഡ് ഡി വാലർ റിയൽ),
				'one' => q(യൂണിഡാഡ് ഡി വാലർ റിയൽ),
				'other' => q(യൂണിഡാഡ് ഡി വാലർ റിയൽസ്),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(കോസ്റ്റാ റിക്കൻ കോളൻ),
				'one' => q(കോസ്റ്റാ റിക്കൻ കോളൻ),
				'other' => q(കോസ്റ്റാ റിക്കൻ കോളൻ),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(പ്രാചീന സെർബിയൻ ദിനാർ),
				'one' => q(പ്രാചീന സെർബിയൻ ദിനാർ),
				'other' => q(പ്രാചീന സെർബിയൻ ദിനാർസ്),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(ചെക്കോസ്ലൊവാക്ക് ഹാർഡ് കൊരൂന),
				'one' => q(ചെക്കോസ്ലൊവാക്ക് ഹാർഡ് കൊരൂന),
				'other' => q(ചെക്കോസ്ലൊവാക്ക് ഹാർഡ് കൊരൂനാസ്),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(ക്യൂബൻ പരിവർത്തിത പെസോ),
				'one' => q(ക്യൂബൻ പരിവർത്തിത പെയ്‍സോ),
				'other' => q(ക്യൂബൻ പരിവർത്തിത പെസോ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ക്യൂബൻ പെസോ),
				'one' => q(ക്യൂബൻ പെസോ),
				'other' => q(ക്യൂബൻ പെസോ),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(കെയ്പ് വെർഡെ എസ്ക്യുഡോ),
				'one' => q(കെയ്പ് വെർഡെ എസ്ക്യുഡോ),
				'other' => q(കെയ്പ് വെർഡെ എസ്ക്യുഡോസ്),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(സൈപ്രസ് പൌണ്ട്),
				'one' => q(സൈപ്രസ് പൌണ്ട്),
				'other' => q(സൈപ്രസ് പൌണ്ട്സ്),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ചെക്ക് റിപ്പബ്ലിക് കൊരൂന),
				'one' => q(ചെക്ക് റിപ്പബ്ലിക് കൊരൂന),
				'other' => q(ചെക്ക് റിപ്പബ്ലിക് കൊരൂനാസ്),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(കിഴക്കൻ ജർമൻ ഓസ്റ്റ്മാർക്ക്),
				'one' => q(കിഴക്കൻ ജർമൻ ഓസ്റ്റ്മാർക്ക്),
				'other' => q(കിഴക്കൻ ജർമൻ ഓസ്റ്റ്മാർക്ക്സ്),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ജർമൻ മാർക്ക്),
				'one' => q(ജർമൻ മാർക്ക്),
				'other' => q(ജർമൻ മാർക്ക്സ്),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ജീബൂട്ടിയൻ ഫ്രാങ്ക്),
				'one' => q(ജീബൂട്ടിയൻ ഫ്രാങ്ക്),
				'other' => q(ജീബൂട്ടിയൻ ഫ്രാങ്ക്),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ഡാനിഷ് ക്രോണെ),
				'one' => q(ഡാനിഷ് ക്രോൺ),
				'other' => q(ഡാനിഷ് ക്രോൺസ്),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ഡൊമിനിക്കൻ പെസോ),
				'one' => q(ഡൊമിനിക്കൻ പെസോ),
				'other' => q(ഡൊമിനിക്കൻ പെസോ),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(അൾജീരിയൻ ദിനാർ),
				'one' => q(അൾജീരിയൻ ദിനാർ),
				'other' => q(അൾജീരിയൻ ദിനാർ),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ഇക്വഡോർ സൂക്രേ),
				'one' => q(ഇക്വഡോർ സൂക്രേ),
				'other' => q(ഇക്വഡോർ സൂക്രേസ്),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(ഇക്വഡോർ യൂണിഡാഡ് വാലർ കോൺസ്റ്റൻറെ \(UVC\)),
				'one' => q(ഇക്വഡോർ യൂണിഡാഡ് ഡി വാലർ കോൺസ്റ്റൻറെ \(UVC\)),
				'other' => q(ഇക്വഡോർ യൂണിഡാഡ്സ് ഡി വാലർ കോൺസ്റ്റൻറെ \(UVC\)),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(എസ്റ്റൌനിയൻ ക്രൂൺ),
				'one' => q(എസ്റ്റൌനിയൻ ക്രൂൺ),
				'other' => q(എസ്റ്റൌനിയൻ ക്രൂൺസ്),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ഈജിപ്ഷ്യൻ പൌണ്ട്),
				'one' => q(ഈജിപ്ഷ്യൻ പൌണ്ട്),
				'other' => q(ഈജിപ്ഷ്യൻ പൌണ്ട്),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(എറിത്രിയൻ നക്ഫ),
				'one' => q(എറിത്രിയൻ നക്ഫ),
				'other' => q(എറിത്രിയൻ നക്ഫാസ്),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(സ്പാനിഷ് പസെയ്റ്റ \(A അക്കൌണ്ട്\)),
				'one' => q(സ്പാനിഷ് പസെയ്റ്റ \(A അക്കൌണ്ട്\)),
				'other' => q(സ്പാനിഷ് പസെയ്റ്റാസ് \(A അക്കൌണ്ട്\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(സ്പാനിഷ് പസെയ്റ്റ \(കൈമാറ്റം ചെയ്യാവുന്ന അക്കൌണ്ട്\)),
				'one' => q(സ്പാനിഷ് പസെയ്റ്റ \(കൈമാറ്റം ചെയ്യാവുന്ന അക്കൌണ്ട്\)),
				'other' => q(സ്പാനിഷ് പസെയ്റ്റാസ് \(കൈമാറ്റം ചെയ്യാവുന്ന അക്കൌണ്ട്\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(സ്പാനിഷ് പസെയ്റ്റ),
				'one' => q(സ്പാനിഷ് പസെയ്റ്റ),
				'other' => q(സ്പാനിഷ് പസെയ്റ്റാസ്),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(എത്യോപ്പിയൻ ബിർ),
				'one' => q(എത്യോപ്പിയൻ ബിർ),
				'other' => q(എത്യോപ്പിയൻ ബിർസ്),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(യൂറോ),
				'one' => q(യൂറോ),
				'other' => q(യൂറോ),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ഫിന്നിഷ് മാർക്ക),
				'one' => q(ഫിന്നിഷ് മാർക്ക),
				'other' => q(ഫിന്നിഷ് മാർക്കാസ്),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ഫിജിയൻ ഡോളർ),
				'one' => q(ഫിജിയൻ ഡോളർ),
				'other' => q(ഫിജിയൻ ഡോളേഴ്സ്),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ഫോക്‌ലാൻഡ് ദ്വീപുകളുടെ പൌണ്ട്),
				'one' => q(ഫോക്‌ലാൻഡ് ദ്വീപുകളുടെ പൌണ്ട്),
				'other' => q(ഫോക്‌ലാൻഡ് ദ്വീപുകളുടെ പൌണ്ട്സ്),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ഫ്രാങ്ക്),
				'one' => q(ഫ്രെഞ്ച് ഫ്രാങ്ക്),
				'other' => q(ഫ്രെഞ്ച് ഫ്രാങ്ക്സ്),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ബ്രിട്ടീഷ് പൌണ്ട് സ്റ്റെർലിംങ്),
				'one' => q(ബ്രിട്ടീഷ് പൌണ്ട് സ്റ്റെർലിംഗ്),
				'other' => q(ബ്രിട്ടീഷ് പൌണ്ട് സ്റ്റെർലിംഗ്സ്),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(ജോർ‍ജ്ജിയൻ ക്യൂപോൺ ലാരിറ്റ്),
				'one' => q(ജോർ‍ജ്ജിയൻ ക്യൂപോൺ ലാരിറ്റ്),
				'other' => q(ജോർ‍ജ്ജിയൻ ക്യൂപോൺ ലാരിറ്റ്സ്),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ജോർ‍ജ്ജിയൻ ലാരി),
				'one' => q(ജോർ‍ജ്ജിയൻ ലാരി),
				'other' => q(ജോർ‍ജ്ജിയൻ ലാരിസ്),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ഘാന കെഡി \(1979–2007\)),
				'one' => q(ഘാന കെഡി \(GHC\)),
				'other' => q(ഘാന കെഡിസ് \(GHC\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ഘാന കെഡി),
				'one' => q(ഘാന കെഡി),
				'other' => q(ഘാന കെഡിസ്),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ഗിബ്രാൽട്ടർ പൌണ്ട്),
				'one' => q(ഗിബ്രാൽട്ടർ പൌണ്ട്),
				'other' => q(ഗിബ്രാൽട്ടർ പൌണ്ട്സ്),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ഗാമ്പിയൻ ദലാസി),
				'one' => q(ഗാമ്പിയൻ ദലാസി),
				'other' => q(ഗാമ്പിയൻ ദലാസി),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ഗിനിയൻ ഫ്രാങ്ക്),
				'one' => q(ഗിനിയൻ ഫ്രാങ്ക്),
				'other' => q(ഗിനിയൻ ഫ്രാങ്ക്),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(ഗിനിയ സൈലി),
				'one' => q(ഗിനിയ സൈലി),
				'other' => q(ഗിനിയ സൈലിസ്),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ഇക്വിറ്റോറിയൽ ഗിനിയ എക്വീലെ ഗിനിയാന),
				'one' => q(ഇക്വിറ്റോറിയൽ ഗിനി എക്വീലെ),
				'other' => q(ഇക്വിറ്റോറിയൽ ഗിനി എക്വീലെ),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(ഗ്രീക്ക് ഡ്രാക്ക്മ),
				'one' => q(ഗ്രീക്ക് ഡ്രാക്ക്മ),
				'other' => q(ഗ്രീക്ക് ഡ്രാക്ക്മാസ്),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ഗ്വാട്ടിമാല ക്വെറ്റ്സൽ),
				'one' => q(ഗ്വാട്ടിമാല ക്വെറ്റ്സൽ),
				'other' => q(ഗ്വാട്ടിമാല ക്വെറ്റ്സൽസ്),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(പോർച്ചുഗീസ് ഗിനി എസ്ക്യൂഡോ),
				'one' => q(പോർച്ചുഗീസ് ഗിനി എസ്ക്യൂഡോ),
				'other' => q(പോർച്ചുഗീസ് ഗിനി എസ്ക്യൂഡോസ്),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(ഗിനിയ-ബിസാവു പെയ്സോ),
				'one' => q(ഗിനി-ബിസാവു പെയ്സോ),
				'other' => q(ഗിനി-ബിസാവു പെയ്സോസ്),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ഗയാന ഡോളർ),
				'one' => q(ഗയാന ഡോളർ),
				'other' => q(ഗയാന ഡോളർ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ഹോങ് കോങ് ഡോളർ),
				'one' => q(ഹോങ് കോങ് ഡോളർ),
				'other' => q(ഹോങ് കോങ് ഡോളേഴ്സ്),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ഹോൻഡ്യുറാസ് ലെംപീര),
				'one' => q(ഹോൻഡ്യുറാസ് ലെംപീര),
				'other' => q(ഹോൻഡ്യുറാസ് ലെംപീരാസ്),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ക്രൊയേഷ്യൻ ദിനാർ),
				'one' => q(ക്രൊയേഷ്യൻ ദിനാർ),
				'other' => q(ക്രൊയേഷ്യൻ ദിനാർസ്),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ക്രൊയേഷ്യൻ ക്യൂന),
				'one' => q(ക്രൊയേഷ്യൻ ക്യൂന),
				'other' => q(ക്രൊയേഷ്യൻ ക്യൂനാസ്),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ഹെയ്ഷ്യൻ ഗൂർഡ്),
				'one' => q(ഹെയ്ഷ്യൻ ഗൂർഡ്),
				'other' => q(ഹെയ്ഷ്യൻ ഗൂർഡ്സ്),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ഹംഗേറിയൻ ഫോറിൻറ്),
				'one' => q(ഹംഗേറിയൻ ഫോറിൻറ്),
				'other' => q(ഹംഗേറിയൻ ഫോറിൻറ്സ്),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ഇന്തോനേഷ്യൻ രൂപ),
				'one' => q(ഇന്തോനേഷ്യൻ രൂപ),
				'other' => q(ഇന്തോനേഷ്യൻ രൂപ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ഐറിഷ് പൌണ്ട്),
				'one' => q(ഐറിഷ് പൌണ്ട്),
				'other' => q(ഐറിഷ് പൌണ്ട്സ്),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ഇസ്രയേലി പൌണ്ട്),
				'one' => q(ഇസ്രയേലി പൌണ്ട്),
				'other' => q(ഇസ്രയേലി പൌണ്ട്സ്),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ഇസ്രായേലി ഷക്കേൽ),
				'one' => q(ഇസ്രായേലി ന്യൂ ഷെക്കൽ),
				'other' => q(ഇസ്രായേലി ന്യൂ ഷെക്കൽസ്),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ഇന്ത്യൻ രൂപ),
				'one' => q(ഇന്ത്യൻ രൂപ),
				'other' => q(ഇന്ത്യൻ രൂപ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ഇറാക്കി ദിനാർ),
				'one' => q(ഇറാക്കി ദിനാർ),
				'other' => q(ഇറാക്കി ദിനാർസ്),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ഇറാനിയൻ റിയാൽ),
				'one' => q(ഇറാനിയൻ റിയാൽ),
				'other' => q(ഇറാനിയൻ റിയാൽസ്),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ഐസ്‌ലാൻഡിക് ക്രോണ),
				'one' => q(ഐസ്‌ലാൻഡിക് ക്രോണ),
				'other' => q(ഐസ്‌ലാൻഡിക് ക്രോണാസ്),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ഇറ്റാലിയൻ ലിറ),
				'one' => q(ഇറ്റാലിയൻ ലിറ),
				'other' => q(ഇറ്റാലിയൻ ലിറാസ്),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ജമൈക്കൻ ഡോളർ),
				'one' => q(ജമൈക്കൻ ഡോളർ),
				'other' => q(ജമൈക്കൻ ഡോളർ),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ജോർദ്ദാൻ ദിനാർ),
				'one' => q(ജോർദ്ദാൻ ദിനാർ),
				'other' => q(ജോർദ്ദാൻ ദിനാർസ്),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ജപ്പാനീസ് യെൻ),
				'one' => q(ജാപ്പനീസ് യെൻ),
				'other' => q(ജാപ്പനീസ് യെൻ),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(കെനിയൻ ഷില്ലിംഗ്),
				'one' => q(കെനിയൻ ഷില്ലിംഗ്),
				'other' => q(കെനിയൻ ഷില്ലിംഗ്),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(കിർഗിസ്ഥാൻ സോം),
				'one' => q(കിർഗിസ്ഥാൻ സോം),
				'other' => q(കിർഗിസ്ഥാൻ സോംസ്),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(കംബോഡിയൻ റീൽ),
				'one' => q(കംബോഡിയൻ റീൽ),
				'other' => q(കംബോഡിയൻ റീൽസ്),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(കൊമോറിയൻ ഫ്രാങ്ക്),
				'one' => q(കൊമോറിയൻ ഫ്രാങ്ക്),
				'other' => q(കൊമോറിയൻ ഫ്രാങ്ക്),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(നോർത്ത് കൊറിയൻ വോൺ),
				'one' => q(ഉത്തര കൊറിയൻ വോൺ),
				'other' => q(ഉത്തര കൊറിയൻ വോൺസ്),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ദക്ഷിണ കൊറിയൻ വോൺ),
				'one' => q(ദക്ഷിണ കൊറിയൻ വോൺ),
				'other' => q(ദക്ഷിണ കൊറിയൻ വോൺസ്),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(കുവൈറ്റി ദിനാർ),
				'one' => q(കുവൈറ്റ് ദിനാർ),
				'other' => q(കുവൈറ്റി ദിനാർസ്‌),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(കെയ്മൻദ്വീപുകളുടെ ഡോളർ‌),
				'one' => q(കെയ്മൻദ്വീപുകളുടെ ഡോളർ‌),
				'other' => q(കെയ്മൻദ്വീപുകളുടെ ഡോളർ),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(കസാഖ്സ്ഥാൻ റ്റെംഗെ),
				'one' => q(കസാഖ്സ്ഥാൻ റ്റെംഗെ),
				'other' => q(കസാഖ്സ്ഥാൻ റ്റെംഗെസ്‌),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(ലാവോഷിയൻ കിപ്),
				'one' => q(ലാവോഷ്യൻ കിപ്‌),
				'other' => q(ലാവോഷ്യൻ കിപ്‌സ്‌),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ലെബനീസ് പൌണ്ട്),
				'one' => q(ലെബനീസ് പൌണ്ട്),
				'other' => q(ലെബനീസ് പൌണ്ട്സ്),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(ശ്രീലങ്കൻ രൂപ),
				'one' => q(ശ്രീലങ്കൻ രൂപ),
				'other' => q(ശ്രീലങ്കൻ രൂപ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ലൈബീരിയൻ ഡോളർ),
				'one' => q(ലൈബീരിയൻ ഡോളർ),
				'other' => q(ലൈബീരിയൻ ഡോളർ),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(ലെസോതോ ലോത്തി),
				'one' => q(ലെസോതോ ലോത്തി),
				'other' => q(ലെസോതോ ലോത്തിസ്‌),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(ലിത്വാനിയൻ ലിത),
				'one' => q(ലിത്വാനിയൻ ലിത),
				'other' => q(ലിത്വാനിയൻ ലിതാസ്‌),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(ലിത്വാനിയൻ തലോനാസ്),
				'one' => q(ലിത്വാനിയൻ തലോനാസ്),
				'other' => q(ലിത്വാനിയൻ തലോനാസെസ്‌),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(ലക്സംബർഗ് കൺവേർട്ടിബിൾ ഫ്രാങ്ക്),
				'one' => q(ലക്സംബർഗ് കൈമാറ്റം ചെയ്യാവുന്ന ഫ്രാങ്ക്‌),
				'other' => q(ലക്സംബർഗ് കൈമാറ്റം ചെയ്യാവുന്ന ഫ്രാങ്ക്‌സ്‌),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ലക്സംബർഗ് ഫ്രാങ്ക്),
				'one' => q(ലക്സംബർഗ് ഫ്രാങ്ക്),
				'other' => q(ലക്സംബർഗ് ഫ്രാങ്ക്‌സ്‌),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(ലക്സംബർഗ് ഫിനാൻഷ്യൽ ഫ്രാങ്ക്),
				'one' => q(ലക്സംബർഗ് ഫിനാൻഷ്യൽ ഫ്രാങ്ക്),
				'other' => q(ലക്സംബർഗ് ഫിനാൻഷ്യൽ ഫ്രാങ്ക്‌സ്‌),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ലാറ്റ്വിയൻ ലാറ്റ്സ്),
				'one' => q(ലാറ്റ്വിയൻ ലാറ്റ്സ്),
				'other' => q(ലാറ്റ്വിയൻ ലാറ്റ്സെസ്‌),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ലാറ്റ്വിയൻ റൂബിൾ),
				'one' => q(ലാറ്റ്വിയൻ റൂബിൾ),
				'other' => q(ലാറ്റ്വിയൻ റൂബിൾ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ലിബിയൻ ദിനാർ),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(മൊറോക്കൻ ദിർഹം),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(മൊറോക്കൻ ഫ്രാങ്ക്),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(മൊൽഡോവൻ ലിയൂ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(മഡഗാസ്കർ ഏരിയറി),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(മഡഗാസ്കർ ഫ്രാങ്ക്),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(മാസിഡോണിയൻ ദിനാർ),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(മാലി ഫ്രാങ്ക്),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(മ്യാൻമാർ ചാറ്റ്),
				'one' => q(മ്യാൻമാർ ചാറ്റ്),
				'other' => q(മ്യാൻമാർ ചാറ്റ്),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(മംഗോളിയൻ തുഗ്രിക്),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(മക്കാനീസ് പതാക്ക),
				'one' => q(മക്കാനീസ് പതാക്ക),
				'other' => q(മക്കാനീസ് പതാക്കാസ്),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(മൌറിറ്റേനിയൻ ഔഗിയ),
				'one' => q(മൌറിറ്റേനിയൻ ഔഗിയ),
				'other' => q(മൌറിറ്റേനിയൻ ഔഗിയ),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(മൽത്തീസ് ലിറ),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(മൽത്തീസ് പൌണ്ട്),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(മൌറീഷ്യൻ രൂപ),
				'one' => q(മൌറീഷ്യൻ രൂപ),
				'other' => q(മൌറീഷ്യൻ രൂപ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(മാലദ്വീപ് രൂപ),
				'one' => q(മാലദ്വീപ് രൂപ),
				'other' => q(മാലദ്വീപ് രൂപ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(മലാവിയൻ ക്വാച),
				'one' => q(മലാവിയൻ ക്വാച),
				'other' => q(മലാവിയൻ ക്വാച),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(മെക്സിക്കൻ പെസോ),
				'one' => q(മെക്സിക്കൻ പെസോ),
				'other' => q(മെക്സിക്കൻ പെസോ),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(മെക്സിക്കൻ സിൽവർ പെയ്സോ \(1861–1992\)),
				'one' => q(മെക്സിക്കൻ സിൽവർ പെയ്സോ \(MXP\)),
				'other' => q(മെക്സിക്കൻ സിൽവർ പെയ്സോസ് \(MXP\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(മെക്സിക്കൻ യൂണിഡാഡ് ഡി ഇൻവെർഷൻ \(UDI\)),
				'one' => q(മെക്സിക്കൻ യൂണിഡാഡ് ഡി ഇൻവെർഷൻ \(UDI\)),
				'other' => q(മെക്സിക്കൻ യൂണിഡാഡ്സ് ഡി ഇൻവെർഷൻ \(UDI\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(മലേഷ്യൻ റിംഗിറ്റ്),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(മൊസാന്പിക്ക് എസ്ക്യുഡോ),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(ഓൾഡ് മൊസാന്പിക്ക് മെറ്റിക്കൽ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(മൊസാമ്പിക്ക് മെറ്റിക്കൽ),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(നമീബിയൻ ഡോളർ),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(നൈജീരിയൻ നൈറ),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(നികരാഗ്വൻ കൊർഡോബ),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(നികരാഗ്വൻ കൊർഡോബ ഒരോ),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(നെതർലൻഡ്സ് ഗിൽഡർ),
				'one' => q(നെതർലൻഡ്സ് ഗിൽഡർ),
				'other' => q(നെതർലൻഡ്സ് ഗിൽഡേഴ്സ്),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(നോർവീജിയൻ ക്രോണെ),
				'one' => q(നോർവീജിയൻ ക്രോൺ),
				'other' => q(നോർവീജിയൻ ക്രോൺസ്),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(നേപ്പാളി രൂപ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ന്യൂസിലാൻഡ് ഡോളർ),
				'one' => q(ന്യൂസിലൻഡ് ഡോളർ),
				'other' => q(ന്യൂസിലൻഡ് ഡോളേഴ്സ്),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ഒമാൻ റിയാൽ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(പനാമെയ്നിയൻ ബാൽബോവ),
				'one' => q(പനാമെയ്നിയൻ ബാൽബോവ),
				'other' => q(പനാമെയ്നിയൻ ബാൽബോവാസ്),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(പെറൂവിയൻ ഇൻറി),
				'one' => q(പെറൂവിയൻ ഇൻറി),
				'other' => q(പെറൂവിയൻ ഇൻറിസ്),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(പെറൂവിയൻ സോൾ ന്യൂവോ),
				'one' => q(പെറൂവിയൻ സോൾ ന്യൂവോ),
				'other' => q(പെറൂവിയൻ സോൾ ന്യൂവോസ്),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(പെറൂവിയൻ സോൾ),
				'one' => q(പെറൂവിയൻ സോൾ),
				'other' => q(പെറൂവിയൻ സോൾസ്),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(പാപുവ ന്യൂ ഗിനിയൻ കിന),
				'one' => q(പാപുവ ന്യൂ ഗിനിയൻ കിന),
				'other' => q(പാപുവ ന്യൂ ഗിനിയൻ കിനാസ്),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ഫിലിപ്പൈൻ പെസോ),
				'one' => q(ഫിലിപ്പൈൻ പെസോ),
				'other' => q(ഫിലിപ്പൈൻ പെസോ),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(പാക്കിസ്ഥാനി രൂപ),
				'one' => q(പാക്കിസ്ഥാനി രൂപ),
				'other' => q(പാക്കിസ്ഥാനി രൂപ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(പോളിഷ് സ്ലോട്ടി),
				'one' => q(പോളിഷ് സ്ലോട്ടി),
				'other' => q(പോളിഷ് സ്ലോട്ടിസ്),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(പോളിഷ് സ്ലോട്ടി \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(പോർച്ചുഗീസ് എസ്ക്യുഡോ),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(പരാഗ്വേയൻ ഗ്വരനീ),
				'one' => q(പരാഗ്വേയൻ ഗ്വരനീ),
				'other' => q(പരാഗ്വേയൻ ഗ്വരനീ),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ഖത്തർ റിയാൽ),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(റൊഡേഷ്യൻ ഡോളർ),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(പ്രാചീന റൊമേനിയൻ ലിയു),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(റൊമേനിയൻ ലിയു),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(സെർബിയൻ ദിനാർ),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(റഷ്യൻ റൂബിൾ),
				'one' => q(റഷ്യൻ റൂബിൾ),
				'other' => q(റഷ്യൻ റൂബിൾസ്),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(റഷ്യൻ റൂബിൾ \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(റുവാണ്ടൻ ഫ്രാങ്ക്),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(സൌദി റിയാൽ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(സോളമൻ ദ്വീപുകളുടെ ഡോളർ),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(സെയ്ഷെൽസ് രൂപ),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(പ്രാചീന സുഡാനീസ് ദിനാർ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(സുഡാനീസ് പൌണ്ട്),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(പ്രാചീന സുഡാനീസ് പൌണ്ട്),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(സ്വീഡിഷ് ക്രോണ),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(സിംഗപ്പൂർ ഡോളർ),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(സെയ്ൻറ് ഹെലെന പൌണ്ട്),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(സ്ലൊവേനിയ റ്റോളർ),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(സ്ലോവാക് കൊരൂന),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(സിയറാ ലിയോൺ ലിയോൺ),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(സൊമാലി ഷില്ലിംഗ്),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(സൂരിനാം ഡോളർ),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(സൂരിനാം ഗിൽഡർ),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(ദക്ഷിണ സുഡാനീസ് പൗണ്ട്),
				'one' => q(ദക്ഷിണ സുഡാനീസ് പൗണ്ട്),
				'other' => q(ദക്ഷിണ സുഡാനീസ് പൗണ്ട്),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(സാവോ റ്റോമി ആൻഡ് പ്രിൻസിപ്പി ഡോബ്ര),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(സോവിയറ്റ് റൂബിൾ),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(എൽ സാൽവഡോർ കോളൻ),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(സിറിയൻ പൌണ്ട്),
				'one' => q(സിറിയൻ പൌണ്ട്),
				'other' => q(സിറിയൻ പൌണ്ട്),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(സ്വാസിലാൻഡ് ലിലാംഗനി),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(തായ് ബാത്ത്),
				'one' => q(തായ് ബാത്ത്),
				'other' => q(തായ് ബാത്ത്),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(താജിക്കിസ്ഥാൻ റൂബിൾ),
				'one' => q(തജിക്സ്ഥാൻ റൂബിൾ),
				'other' => q(തജിക്സ്ഥാൻ റൂബിൾസ്),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(താജിക്കിസ്ഥാൻ സൊമോനി),
				'one' => q(തജികിസ്ഥാൻ സൊമോനി),
				'other' => q(തജികിസ്ഥാൻ സൊമോനിസ്),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(തുർക്മെനിസ്ഥാൻ മനത്),
				'one' => q(തുർക്മെനിസ്ഥാൻ മനത്),
				'other' => q(തുർക്മെനിസ്ഥാൻ മനത്‌സ്),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(തുർക്കമനിസ്ഥാനി മനാത്ത്),
				'one' => q(തുർക്കമനിസ്ഥാനി മനാത്ത്),
				'other' => q(തുർക്കമനിസ്ഥാനി മനാത്ത്),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(തുനീസിയൻ ദിനാർ),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(റ്റോംഗൻ പാംഗ),
				'one' => q(റ്റോംഗൻ പാംഗ),
				'other' => q(റ്റോംഗൻ പാംഗാസ്),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(തിമോർ എസ്ക്യൂഡോ),
				'one' => q(തിമോർ എസ്ക്യൂഡോ),
				'other' => q(തിമോർ എസ്ക്യൂഡോസ്),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(പ്രാചീന തുർക്കിഷ് ലിറ),
				'one' => q(പ്രാചീന തുർക്കിഷ് ലിറ),
				'other' => q(പ്രാചീന തുർക്കിഷ് ലിറാസ്),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(തുർക്കിഷ് ലിറ),
				'one' => q(തുർക്കിഷ് ലിറ),
				'other' => q(തുർക്കിഷ് ലിറാസ്),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ട്രിനിഡാഡ് ആൻഡ് റ്റൊബാഗോ ഡോളർ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(തായ്‌വാൻ ഡോളർ),
				'one' => q(തായ്‌വാൻ ഡോളർ),
				'other' => q(തായ്‌വാൻ ഡോളേഴ്സ്),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ടാൻസാനിയൻ ഷില്ലിംഗ്),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(യുക്രേനിയൻ ഹ്രിവ്നിയ),
				'one' => q(ഉക്രേനിയൻ ഹ്രിവ്നിയ),
				'other' => q(ഉക്രേനിയൻ ഹ്രിവ്നിയാസ്),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(യുക്രേനിയൻ കാർബോവാനെസ്),
				'one' => q(ഉക്രേനിയൻ കാർബോവാനെസ്),
				'other' => q(ഉക്രേനിയൻ കാർബോവാനെസ്),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(ഉഗാണ്ടൻ ഷില്ലിംഗ് \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ഉഗാണ്ടൻ ഷില്ലിംഗ്),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(യു.എസ്. ഡോളർ),
				'one' => q(യു.എസ് ഡോളർ),
				'other' => q(യു.എസ് ഡോളർ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(യുഎസ് ഡോളർ \(അടുത്ത ദിവസം\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(യുഎസ് ഡോളർ \(അതേ ദിവസം\)),
				'one' => q(യുഎസ് ഡോളർ \(അതേ ദിവസം\)),
				'other' => q(യുഎസ് ഡോളേഴ്സ് \(അതേ ദിവസം\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(ഉറുഗ്വേ പെയ്സോ എൻ യൂണിഡാഡ്സ്),
				'one' => q(ഉറുഗ്വേ പെയ്സോ എൻ യൂണിഡാഡ്സ് ഇൻഡെക്സാഡാസ്),
				'other' => q(ഉറുഗ്വേ പെയ്സോസ് എൻ യൂണിഡാഡ്സ് ഇൻഡെക്സാഡാസ്),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ഉറുഗ്വേ പെയ്സോ \(1975–1993\)),
				'one' => q(ഉറുഗ്വേ പെയ്സോ \(UYP\)),
				'other' => q(ഉറുഗ്വേ പെയ്സോസ് \(UYP\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ഉറുഗ്വേൻ പെസോ),
				'one' => q(ഉറുഗ്വേൻ പെസോ),
				'other' => q(ഉറുഗ്വേൻ പെസോ),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ഉസ്ബക്കിസ്ഥാൻ സം),
				'one' => q(ഉസ്ബക്കിസ്ഥാൻ സം),
				'other' => q(ഉസ്ബക്കിസ്ഥാൻ സംസ്),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(വെനസ്വേലൻ ബോലിവർ \(1871–2008\)),
				'one' => q(വെനസ്വേലൻ ബോലിവർ \(1871–2008\)),
				'other' => q(വെനസ്വേലൻ ബോലിവർസ് \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(വെനസ്വേലൻ ബോലിവർ),
				'one' => q(വെനസ്വേലൻ ബോലിവർ),
				'other' => q(വെനസ്വേലൻ ബോലിവർ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(വിയറ്റ്നാമീസ് ഡോങ്),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(വനുവാതു വാതു),
				'one' => q(വനുവാതു വാതു),
				'other' => q(വനുവാതു വാതൂസ്),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(സമോവൻ താല),
				'one' => q(സമോവൻ താല),
				'other' => q(സമോവൻ താല),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(CFA ഫ്രാങ്ക് BEAC),
				'one' => q(CFA ഫ്രാങ്ക് BEAC),
				'other' => q(CFA ഫ്രാങ്ക്സ് BEAC),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(വെള്ളി),
				'one' => q(വെള്ളി),
				'other' => q(വെള്ളി),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(സ്വർണ്ണം),
				'one' => q(സ്വർണ്ണം),
				'other' => q(സ്വർണ്ണം),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ കോന്പസിറ്റ് യൂണിറ്റ്),
				'one' => q(യൂറോപ്യൻ കോന്പസിറ്റ് യൂണിറ്റ്),
				'other' => q(യൂറോപ്യൻ കോന്പസിറ്റ് യൂണിറ്റ്സ്),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ മോണിറ്ററി യൂണിറ്റ്),
				'one' => q(യൂറോപ്യൻ മോണിറ്ററി യൂണിറ്റ്),
				'other' => q(യൂറോപ്യൻ മോണിറ്ററി യൂണിറ്റ്സ്),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBC\)),
				'one' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBC\)),
				'other' => q(യൂറോപ്യൻ യൂണിറ്റ്സ് ഓഫ് അക്കൌണ്ട് \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBD\)),
				'one' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBD\)),
				'other' => q(യൂറോപ്യൻ യൂണിറ്റ്സ് ഓഫ് അക്കൌണ്ട് \(XBD\)),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(കിഴക്കൻ കരീബിയൻ ഡോളർ),
				'one' => q(കിഴക്കൻ കരീബിയൻ ഡോളർ),
				'other' => q(കിഴക്കൻ കരീബിയൻ ഡോളർ),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(സ്പെഷ്യൽ ഡ്രോയിംഗ് റൈറ്റ്സ്),
				'one' => q(സ്പെഷ്യൽ ഡ്രോയിംഗ് റൈറ്റ്സ്),
				'other' => q(സ്പെഷ്യൽ ഡ്രോയിംഗ് റൈറ്റ്സ്),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ നാണയ യൂണിറ്റ്),
				'one' => q(യൂറോപ്യൻ നാണയ യൂണിറ്റ്),
				'other' => q(യൂറോപ്യൻ നാണയ യൂണിറ്റ്സ്),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ഫ്രെഞ്ച് ഗോൾഡ് ഫ്രാങ്ക്),
				'one' => q(ഫ്രെഞ്ച് ഗോൾഡ് ഫ്രാങ്ക്),
				'other' => q(ഫ്രെഞ്ച് ഗോൾഡ് ഫ്രാങ്ക്സ്),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(ഫ്രെഞ്ച് UIC-ഫ്രാങ്ക്),
				'one' => q(ഫ്രെഞ്ച് UIC-ഫ്രാങ്ക്),
				'other' => q(ഫ്രെഞ്ച് UIC-ഫ്രാങ്ക്സ്),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(CFA ഫ്രാങ്ക് BCEAO),
				'one' => q(CFA ഫ്രാങ്ക് BCEAO),
				'other' => q(CFA ഫ്രാങ്ക്സ് BCEAO),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(പലാഡിയം),
				'one' => q(പലാഡിയം),
				'other' => q(പലാഡിയം),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ഫ്രാങ്ക്),
				'one' => q(CFP ഫ്രാങ്ക്),
				'other' => q(CFP ഫ്രാങ്ക്സ്),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(പ്ലാറ്റിനം),
				'one' => q(പ്ലാറ്റിനം),
				'other' => q(പ്ലാറ്റിനം),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET ഫണ്ട്സ്),
				'one' => q(RINET ഫണ്ട്സ്),
				'other' => q(RINET ഫണ്ട്സ്),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(ടെസ്റ്റിംഗിനുള്ള കറൻസി കോഡ്),
				'one' => q(റ്റെസ്റ്റിംഗ് കറൻസി കോഡ്),
				'other' => q(റ്റെസ്റ്റിംഗ് കറൻസി കോഡ്),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(അജ്ഞാത നാണയം),
				'one' => q(\(അജ്ഞാത നാണയം‌\)),
				'other' => q(\(അജ്ഞാത നാണയം\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(യമനി ദിനാർ),
				'one' => q(യമനി ദിനാർ),
				'other' => q(യമനി ദിനാർസ്),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(യമനി റിയാൽ),
				'one' => q(യമനി റിയാൽ),
				'other' => q(യമനി റിയാൽസ്),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(യൂഗോസ്ലേവിയൻ ഹാർഡ് ദിനാർ),
				'one' => q(യൂഗോസ്ലേവിയൻ ഹാർഡ് ദിനാർ),
				'other' => q(യൂഗോസ്ലേവിയൻ ഹാർഡ് ദിനാർസ്),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(യൂഗോസ്ലേവിയൻ നോവി ദിനാർ),
				'one' => q(യൂഗോസ്ലേവിയൻ നോവി ദിനാർ),
				'other' => q(യൂഗോസ്ലേവിയൻ നോവി ദിനാർസ്),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(യൂഗോസ്ലേവിയൻ കൺവേർട്ടിബിൾ ദിനാർ),
				'one' => q(യൂഗോസ്ലേവിയൻ കൺവേർട്ടിബിൾ ദിനാർ),
				'other' => q(യൂഗോസ്ലേവിയൻ കൺവേർട്ടിബിൾ ദിനാർസ്),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ് \(ഫിനാൻഷ്യൽ\)),
				'one' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ് \(ഫിനാൻഷ്യൽ\)),
				'other' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ്സ് \(ഫിനാൻഷ്യൽ\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(ദക്ഷിണ ആഫ്രിക്കൻ റാൻഡ്),
				'one' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ്),
				'other' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ്സ്),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(സാംബിയൻ ക്വാച \(1968–2012\)),
				'one' => q(സാംബിയൻ ക്വാച \(1968–2012\)),
				'other' => q(സാംബിയൻ ക്വാചാസ് \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(സാംബിയൻ ക്വാച),
				'one' => q(സാംബിയൻ ക്വാച),
				'other' => q(സാംബിയൻ ക്വാചാസ്),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(സൈറിയൻ ന്യൂ സൈർ),
				'one' => q(സൈറിയൻ ന്യൂ സൈർ),
				'other' => q(സൈറിയൻ ന്യൂ സൈർസ്),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(സൈറിയൻ സൈർ),
				'one' => q(സൈറിയൻ സൈർ),
				'other' => q(സൈറിയൻ സൈർസ്),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(സിംബാബ്‌വെ ഡോളർ),
				'one' => q(സിംബാബ്‌വെ ഡോളർ),
				'other' => q(സിംബാബ്‌വെ ഡോളേഴ്സ്),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ജനു',
							'ഫെബ്രു',
							'മാർ',
							'ഏപ്രി',
							'മേയ്',
							'ജൂൺ',
							'ജൂലൈ',
							'ഓഗ',
							'സെപ്റ്റം',
							'ഒക്ടോ',
							'നവം',
							'ഡിസം'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ജനുവരി',
							'ഫെബ്രുവരി',
							'മാർച്ച്',
							'ഏപ്രിൽ',
							'മേയ്',
							'ജൂൺ',
							'ജൂലൈ',
							'ആഗസ്റ്റ്',
							'സെപ്റ്റംബർ',
							'ഒക്‌ടോബർ',
							'നവംബർ',
							'ഡിസംബർ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ജനു',
							'ഫെബ്രു',
							'മാർ',
							'ഏപ്രി',
							'മേയ്',
							'ജൂൺ',
							'ജൂലൈ',
							'ഓഗ',
							'സെപ്റ്റം',
							'ഒക്ടോ',
							'നവം',
							'ഡിസം'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ജ',
							'ഫെ',
							'മാ',
							'ഏ',
							'മേ',
							'ജൂ',
							'ജൂ',
							'ഓ',
							'സെ',
							'ഒ',
							'ന',
							'ഡി'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ജനുവരി',
							'ഫെബ്രുവരി',
							'മാർച്ച്',
							'ഏപ്രിൽ',
							'മേയ്',
							'ജൂൺ',
							'ജൂലൈ',
							'ആഗസ്റ്റ്',
							'സെപ്റ്റംബർ',
							'ഒക്‌ടോബർ',
							'നവംബർ',
							'ഡിസംബർ'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'ചൈത്രം',
							'വൈശാഖം',
							'ജ്യേഷ്ഠം',
							'ആഷാഢം',
							'ശ്രാവണം',
							'ഭാദ്രപാദം',
							'ആശ്വിനം',
							'കാർത്തികം',
							'മാർഗശീർഷം',
							'പൗഷം',
							'മാഘം',
							'ഫൽഗുനം'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ചൈ',
							'വൈ',
							'ജ്യേ',
							'ആ',
							'ശ്രാ',
							'ഭാ',
							'ആ',
							'കാ',
							'മാ',
							'പൗ',
							'മാ',
							'ഫ'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'മുഹറം',
							'സഫർ',
							'റബീഹുൽ അവ്വൽ',
							'റബീഹുൽ ആഖിർ',
							'ജമാദുൽ അവ്വൽ',
							'ജമാദുൽ ആഖിർ',
							'റജബ്',
							'ശഹബാൻ',
							'റമളാൻ',
							'ശവ്വാൽ',
							'ദുൽ ഖഹദ്',
							'ദുൽ ഹിജ്ജ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'മു',
							'സ',
							'റ',
							'റ',
							'ജ',
							'ജ',
							'റ',
							'ശ',
							'റ',
							'ശ',
							'ദു',
							'ദു'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'തിങ്കൾ',
						tue => 'ചൊവ്വ',
						wed => 'ബുധൻ',
						thu => 'വ്യാഴം',
						fri => 'വെള്ളി',
						sat => 'ശനി',
						sun => 'ഞായർ'
					},
					short => {
						mon => 'തി',
						tue => 'ചൊ',
						wed => 'ബു',
						thu => 'വ്യാ',
						fri => 'വെ',
						sat => 'ശ',
						sun => 'ഞാ'
					},
					wide => {
						mon => 'തിങ്കളാഴ്‌ച',
						tue => 'ചൊവ്വാഴ്ച',
						wed => 'ബുധനാഴ്‌ച',
						thu => 'വ്യാഴാഴ്‌ച',
						fri => 'വെള്ളിയാഴ്‌ച',
						sat => 'ശനിയാഴ്‌ച',
						sun => 'ഞായറാഴ്‌ച'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'തിങ്കൾ',
						tue => 'ചൊവ്വ',
						wed => 'ബുധൻ',
						thu => 'വ്യാഴം',
						fri => 'വെള്ളി',
						sat => 'ശനി',
						sun => 'ഞായർ'
					},
					narrow => {
						mon => 'തി',
						tue => 'ചൊ',
						wed => 'ബു',
						thu => 'വ്യാ',
						fri => 'വെ',
						sat => 'ശ',
						sun => 'ഞാ'
					},
					short => {
						mon => 'തി',
						tue => 'ചൊ',
						wed => 'ബു',
						thu => 'വ്യാ',
						fri => 'വെ',
						sat => 'ശ',
						sun => 'ഞാ'
					},
					wide => {
						mon => 'തിങ്കളാഴ്‌ച',
						tue => 'ചൊവ്വാഴ്‌ച',
						wed => 'ബുധനാഴ്‌ച',
						thu => 'വ്യാഴാഴ്‌ച',
						fri => 'വെള്ളിയാഴ്‌ച',
						sat => 'ശനിയാഴ്‌ച',
						sun => 'ഞായറാഴ്‌ച'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ഒന്നാം പാദം',
						1 => 'രണ്ടാം പാദം',
						2 => 'മൂന്നാം പാദം',
						3 => 'നാലാം പാദം'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ഒന്നാം പാദം',
						1 => 'രണ്ടാം പാദം',
						2 => 'മൂന്നാം പാദം',
						3 => 'നാലാം പാദം'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ഒന്നാം പാദം',
						1 => 'രണ്ടാം പാദം',
						2 => 'മൂന്നാം പാദം',
						3 => 'നാലാം പാദം'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ഒന്നാം പാദം',
						1 => 'രണ്ടാം പാദം',
						2 => 'മൂന്നാം പാദം',
						3 => 'നാലാം പാദം'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'narrow' => {
					'pm' => q{PM},
					'am' => q{AM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ക്രി.മൂ',
				'1' => 'എഡി'
			},
			wide => {
				'0' => 'ക്രിസ്തുവിനു് മുമ്പ്‌',
				'1' => 'ക്രിസ്തുവിന് പിൻപ്'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ശക'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ഹിജറ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G y, MMMM d, EEEE},
			'long' => q{G y, MMMM d},
			'medium' => q{G y, MMM d},
			'short' => q{dd/MM/y GGGGG},
		},
		'gregorian' => {
			'full' => q{y, MMMM d, EEEE},
			'long' => q{y, MMMM d},
			'medium' => q{y, MMM d},
			'short' => q{dd/MM/yy},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{M/d, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMEd => q{MMMM d, E},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{M-y G},
			yyyyMEd => q{d-M-y G, E},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{M/d, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMEd => q{MMMM d, E},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M-y},
			yMEd => q{d-M-y, E},
			yMM => q{MM-y},
			yMMM => q{y MMM},
			yMMMEd => q{y MMM d, E},
			yMMMM => q{y MMMM},
			yMMMd => q{y MMM d},
			yMd => q{d/M/y},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{d/M, E - d/M, E},
				d => q{d/M, E - d/M, E},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{MMM d, E - MMM d, E},
				d => q{MMM d, E - MMM d, E},
			},
			MMMM => {
				M => q{LLLL-LLLL},
			},
			MMMd => {
				M => q{MMM d - MMM d},
				d => q{MMM d-d},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y-y},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{d/M/y, E - d/M/y, E},
				d => q{d/M/y, E - d/M/y, E},
				y => q{d/M/y, E - d/M/y, E},
			},
			yMMM => {
				M => q{G y MMM-MMM},
				y => q{G y MMM - y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E - MMM d, E},
				d => q{G y, MMM d, E - d, E},
				y => q{G y MMM d, E - y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM-MMMM},
				y => q{G y MMMM - y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d - MMM d},
				d => q{G y MMM d-d},
				y => q{G y MMM d - y MMM d},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{d/M, E - d/M, E},
				d => q{d/M, E - d/M, E},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{MMM d, E - MMM d, E},
				d => q{MMM d, E - MMM d, E},
			},
			MMMM => {
				M => q{LLLL-LLLL},
			},
			MMMd => {
				M => q{MMM d - MMM d},
				d => q{MMM d-d},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{d/M/y, E - d/M/y, E},
				d => q{d/M/y, E - d/M/y, E},
				y => q{d/M/y, E - d/M/y, E},
			},
			yMMM => {
				M => q{y MMM-MMM},
				y => q{y MMM - y MMM},
			},
			yMMMEd => {
				M => q{y MMM d, E - MMM d, E},
				d => q{y MMM d, E – MMM d, E},
				y => q{y MMM d, E - y MMM d, E},
			},
			yMMMM => {
				M => q{y MMMM–MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y MMM d - MMM d},
				d => q{y MMM d-d},
				y => q{y MMM d - y MMM d},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} സമയം),
		regionFormat => q({0} ഡേലൈറ്റ് സമയം),
		regionFormat => q({0} സ്റ്റാന്റേഡ് സമയം),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(എയ്ക്കർ വേനൽക്കാല സമയം),
				'generic' => q(എയ്ക്കർ സമയം),
				'standard' => q(എയ്ക്കർ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(അഫ്ഗാനിസ്ഥാൻ സമയം),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#അബിദ്‌ജാൻ‌#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ആക്ര#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#അഡിസ് അബാബ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#അൾജിയേഴ്‌സ്#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#അസ്‍മാര#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ബമാകോ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ബംഗുയി#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ബഞ്ചുൽ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ബിസ്സാവു#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ബ്ലാണ്ടെയർ‌#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ബ്രാസവിൽ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ബുജും‌ബുര#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#കെയ്‌റോ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#കാസബ്ലാങ്ക#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ക്യൂട്ട#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#കൊണാക്രി#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ഡാക്കർ‌#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ദാർ എസ് സലാം#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ദിബൌട്ടി#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ഡൌല#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#എൽ‌ ഐയുൻ‌#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ഫ്രീടൌൺ‌#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ഗാബൊറോൺ‌#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ഹരാരെ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ജോഹന്നാസ്ബർ‌ഗ്#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ജുബ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#കമ്പാല#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ഖാർ‌തൌം#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#കിഗാലി#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#കിൻഷാസ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ലാഗോസ്#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ലിബ്രെവില്ല#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ലോം#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ലുവാൻഡ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ലൂബുംബാഷി#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ലുസാക#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#മലാബോ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#മാപ്യുട്ടോ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#മസേറു#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#മബാബെയ്‌ൻ‌#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#മൊഗാദിഷു#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#മൺ‌റോവിയ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#നയ്‌റോബി#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ജമെന#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#നിയാമി#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#നൌവാൿഷോട്ട്#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ഔഗാദൌഗൌ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#പോർ‌ട്ടോ-നോവോ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#സാവോ ടോം‌#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ട്രിപൊളി#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ട്യൂണിസ്#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#വിൻഡ്‌ഹോക്#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(മദ്ധ്യ ആഫ്രിക്കൻ സമയം),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(കിഴക്കേ ആഫ്രിക്കൻ സമയം),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(ദക്ഷിണാഫ്രിക്കൻ സമയം),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(പശ്ചിമാഫ്രിക്കൻ വേനൽക്കാല സമയം),
				'generic' => q(പശ്ചിമാഫ്രിക്കൻ സമയം),
				'standard' => q(പശ്ചിമാഫ്രിക്കൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(അലാസ്ക പകൽ സമയം),
				'generic' => q(അലാസ്ക്ക സമയം),
				'standard' => q(അലാസ്ക സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(അൽമതി വേനൽക്കാല സമയം),
				'generic' => q(അൽമതി സമയം),
				'standard' => q(അൽമതി സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(ആമസോൺ വേനൽക്കാല സമയം),
				'generic' => q(ആമസോൺ സമയം),
				'standard' => q(ആമസോൺ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'America/Adak' => {
			exemplarCity => q#അഡാക്#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ആങ്കറേജ്#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ആൻഗ്വില്ല#,
		},
		'America/Antigua' => {
			exemplarCity => q#ആൻറിഗ്വ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#അറഗ്വൈന#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ലാ റിയോജ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#റിയോ ഗ്യാലഗോസ്#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#സാൽട്ട#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#സാൻ ജുവാൻ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#സാൻ ലൂയിസ്#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#റ്റുകുമാൻ#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ഉഷിയ#,
		},
		'America/Aruba' => {
			exemplarCity => q#അറൂബ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#അസൻ‌ഷ്യൻ‌#,
		},
		'America/Bahia' => {
			exemplarCity => q#ബഹിയ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ബഹിയ ബൻഡാരസ്#,
		},
		'America/Barbados' => {
			exemplarCity => q#ബാർബഡോസ്#,
		},
		'America/Belem' => {
			exemplarCity => q#ബെലം#,
		},
		'America/Belize' => {
			exemplarCity => q#ബെലീസ്#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ബ്ലാങ്ക് സാബ്ലോൺ#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ബോവ വിസ്റ്റ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ബൊഗോട്ട#,
		},
		'America/Boise' => {
			exemplarCity => q#ബൊയ്സി#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ബ്യൂനസ് ഐറിസ്#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#കേംബ്രിഡ്‌ജ് ബേ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ക്യാന്പോ ഗ്രാൻഡെ#,
		},
		'America/Cancun' => {
			exemplarCity => q#കാൻകൂൺ#,
		},
		'America/Caracas' => {
			exemplarCity => q#കരാക്കസ്#,
		},
		'America/Catamarca' => {
			exemplarCity => q#‍ക്യാറ്റമാർക്ക#,
		},
		'America/Cayenne' => {
			exemplarCity => q#കയീൻ‌#,
		},
		'America/Cayman' => {
			exemplarCity => q#കേമാൻ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ചിക്കാഗോ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ചിവാവു#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#കോറൽ ഹാർബർ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#കൊർദോവ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#കോസ്റ്റ റിക്ക#,
		},
		'America/Creston' => {
			exemplarCity => q#ക്രെസ്റ്റൺ#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#കുയ്‌ബ#,
		},
		'America/Curacao' => {
			exemplarCity => q#കുറാക്കാവോ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ഡാൻമാർക്ക്ഷാവ്ൻ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ഡോവ്സൺ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ഡോവ്സൺ ക്രീക്ക്#,
		},
		'America/Denver' => {
			exemplarCity => q#ഡെൻ‌വർ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ഡെട്രോയിറ്റ്#,
		},
		'America/Dominica' => {
			exemplarCity => q#ഡൊമിനിക്ക#,
		},
		'America/Edmonton' => {
			exemplarCity => q#എഡ്മോൺടൺ#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#യെറുനീപ്പെ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#എൽ സാൽ‌വദോർ#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ഫോർട്ടലീസ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ഗ്ലെയ്സ് ബേ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ഗോഡ്‌താബ്#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ഗൂസ് ബേ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ഗ്രാൻഡ് ടർക്ക്#,
		},
		'America/Grenada' => {
			exemplarCity => q#ഗ്രനേഡ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ഗ്വാഡലൂപ്പ്#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ഗ്വോട്ടിമാല#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ഗുവായക്വിൽ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ഗയാന#,
		},
		'America/Halifax' => {
			exemplarCity => q#ഹാലിഫാക്സ്#,
		},
		'America/Havana' => {
			exemplarCity => q#ഹവാന#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ഹെർമോസില്ലോ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#നോക്സ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#മരെങ്കോ, ഇൻഡ്യാനാ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#പീറ്റേഴ്സ്ബർഗ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#റ്റെൽ സിറ്റി, ഇൻഡ്യാന#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#വിവെയ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#വിൻസെൻസ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#വിനാമാക്, ഇൻഡ്യാന#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ഇൻഡ്യാനാപോലീസ്#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ഇനുവിക്#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ഇഖാലിത്#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ജമൈക്ക#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ജുജുയ്#,
		},
		'America/Juneau' => {
			exemplarCity => q#ജൂനോ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#മോണ്ടിസെല്ലോ, കെൻറക്കി#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#കാർലൻഡിജെക്ക്#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ലാ പാസ്#,
		},
		'America/Lima' => {
			exemplarCity => q#ലിമ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ലോസ് എയ്ഞ്ചലസ്#,
		},
		'America/Louisville' => {
			exemplarCity => q#ലൂയിവിൽ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ലോവർ പ്രിൻസസ് ക്വാർട്ടർ#,
		},
		'America/Maceio' => {
			exemplarCity => q#മാസിയോ#,
		},
		'America/Managua' => {
			exemplarCity => q#മനാഗ്വ#,
		},
		'America/Manaus' => {
			exemplarCity => q#മനൌസ്#,
		},
		'America/Marigot' => {
			exemplarCity => q#മാരിഗോ#,
		},
		'America/Martinique' => {
			exemplarCity => q#മാർട്ടിനിക്#,
		},
		'America/Matamoros' => {
			exemplarCity => q#മറ്റാമൊറോസ്#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#മാസറ്റ്ലാൻ#,
		},
		'America/Mendoza' => {
			exemplarCity => q#മെൻഡോസ#,
		},
		'America/Menominee' => {
			exemplarCity => q#മെനോമിനീ#,
		},
		'America/Merida' => {
			exemplarCity => q#മെരിഡ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#മെറ്റ്‌ലാകാറ്റ്‌ല#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#മെക്സിക്കോ സിറ്റി#,
		},
		'America/Miquelon' => {
			exemplarCity => q#മൈക്വെലൻ‌#,
		},
		'America/Moncton' => {
			exemplarCity => q#മോങ്റ്റൺ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#മോണ്ടർ‌റേ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#മൊണ്ടെ‌വീഡിയോ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#മൊണ്ടെസരത്ത്#,
		},
		'America/Nassau' => {
			exemplarCity => q#നസ്സാവു#,
		},
		'America/New_York' => {
			exemplarCity => q#ന്യൂയോർക്ക്#,
		},
		'America/Nipigon' => {
			exemplarCity => q#നിപ്പിഗോൺ#,
		},
		'America/Nome' => {
			exemplarCity => q#നൌം#,
		},
		'America/Noronha' => {
			exemplarCity => q#നൊറോന#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ബ്യൂല, വടക്കൻ ഡെക്കോട്ട#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#സെൻറർ, നോർത്ത് ഡക്കോട്ട#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ന്യൂ സെയ്‌ലം, നോർത്ത് ഡക്കോട്ട#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ഒജിൻഗ#,
		},
		'America/Panama' => {
			exemplarCity => q#പനാമ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#പാൻഗ്‌നിറ്റങ്#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#പരാമാരിബോ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ഫീനിക്സ്#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#പോർട്ട്-ഓവ്-പ്രിൻസ്#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#പോർ‌ട്ട് ഓഫ് സ്‌പെയിൻ‌#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#പോർട്ടോ വെല്ലോ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#പ്യൂർട്ടറിക്കോ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#റെയ്നി റിവർ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#റാങ്കിൻ ഇൻലെറ്റ്#,
		},
		'America/Recife' => {
			exemplarCity => q#റെസീഫെ#,
		},
		'America/Regina' => {
			exemplarCity => q#റിജീന#,
		},
		'America/Resolute' => {
			exemplarCity => q#റെസല്യൂട്ട്#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#റിയോ ബ്രാങ്കോ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#സാന്ത ഇസബേൽ#,
		},
		'America/Santarem' => {
			exemplarCity => q#സാൻററെം#,
		},
		'America/Santiago' => {
			exemplarCity => q#സാൻറിയാഗോ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#സാന്തോ ഡോമിംഗോ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#സാവോ പോലോ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#സ്കോർസ്ബൈസണ്ട്#,
		},
		'America/Sitka' => {
			exemplarCity => q#സിറ്റ്‌കാ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#സെൻറ് ബർത്തലെമി#,
		},
		'America/St_Johns' => {
			exemplarCity => q#സെയ്ൻറ് ജോൺസ്#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#സെൻറ് കിറ്റസ്#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#സെൻറ് ലൂസിയ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#സെൻറ്. തോമസ്#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#സെൻറ് വിൻ‌സെൻറ്#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#സ്വിഫ്റ്റ് കറൻറ്#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#റ്റെഗുസി‍ഗാൽപ്പ#,
		},
		'America/Thule' => {
			exemplarCity => q#തൂളി#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#തണ്ടർ ബേ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#തിയുവാന#,
		},
		'America/Toronto' => {
			exemplarCity => q#ടൊറണ്ടോ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ടോർ‌ട്ടോള#,
		},
		'America/Vancouver' => {
			exemplarCity => q#വാൻ‌കൂവർ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#വൈറ്റ്ഹോഴ്സ്#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#വിന്നിപെഗ്#,
		},
		'America/Yakutat' => {
			exemplarCity => q#യാകുറ്റാറ്റ്#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#യെല്ലോനൈഫ്#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(സെൻട്രൽ പകൽ സമയം),
				'generic' => q(സെൻട്രൽ സമയം),
				'standard' => q(സെൻട്രൽ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(കിഴക്കൻ പകൽ സമയം),
				'generic' => q(കിഴക്കൻ സമയം),
				'standard' => q(കിഴക്കൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(മൌണ്ടൻ പകൽ സമയം),
				'generic' => q(മൌണ്ടൻ സമയം),
				'standard' => q(മൌണ്ടൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(പസഫിക് പകൽ സമയം),
				'generic' => q(പസഫിക് സമയം),
				'standard' => q(പസഫിക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(അനാഡിർ വേനൽക്കാല സമയം),
				'generic' => q(അനാഡിർ സമയം),
				'standard' => q(അനാഡിർ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#കാസെ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ഡെയ്‌വിസ്#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ഡ്യൂമണ്ട് ഡി യുർവിൽ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#മക്വയറി#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#മാവ്സൺ#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#മാക്മർഡോ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#പാമർ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#റൊതീറ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#സ്യോവ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#വോസ്റ്റോക്#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(അഖ്തൌ വേനൽക്കാല സമയം),
				'generic' => q(അഖ്തൌ സമയം),
				'standard' => q(അഖ്തൌ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(അഖ്തോബ് വേനൽക്കാല സമയം),
				'generic' => q(അഖ്തോബ് സമയം),
				'standard' => q(അഖ്തോബ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(അറേബ്യൻ പകൽ സമയം),
				'generic' => q(അറേബ്യൻ സമയം),
				'standard' => q(അറേബ്യൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ലംഗ്‍യെർബിൻ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(അർജൻറീന വേനൽക്കാല സമയം),
				'generic' => q(അർജൻറീന സമയം),
				'standard' => q(അർജൻറീന സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(പശ്ചിമ അർജൻറീന വേനൽക്കാല സമയം),
				'generic' => q(പശ്ചിമ അർജൻറീന സമയം),
				'standard' => q(പശ്ചിമ അർജൻറീന സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(അർമേനിയ വേനൽക്കാല സമയം),
				'generic' => q(അർമേനിയ സമയം),
				'standard' => q(അർമേനിയ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ഏദെൻ#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#അൽമതി#,
		},
		'Asia/Amman' => {
			exemplarCity => q#അമ്മാൻ‌#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#അനാഡിർ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#അഖ്തൌ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#അഖ്‌തോബ്#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ആഷ്‌ഗാബട്ട്#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ബാഗ്‌ദാദ്#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ബഹ്റിൻ#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ബാക്കു#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ബാങ്കോക്ക്#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ബെയ്‌റൂട്ട്#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ബിഷ്‌കേക്#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ബ്രൂണൈ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#കൊൽ‌ക്കത്ത#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ചൊയ്ബൽസൻ#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#ചോങ്ഖിങ്#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#കൊളം‌ബോ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ദമാസ്കസ്#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ധാക്ക#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ദിലി#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ദുബായ്#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ദുഷൻ‌ബെ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ഗാസ#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#ഹാർബിൻ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ഹെബ്‌റോൺ#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ഹോങ്കോംഗ്#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ഹൌഡ്#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ഇർകസ്ക്#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ജക്കാർത്ത#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ജയപുര#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ജെറുസലേം#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#കാബൂൾ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#കാംചട്ക#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#കറാച്ചി#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#കാഷ്ഗർ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#കാഠ്‌മണ്ഡു#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#കച്ചൻഗ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ക്രാസ്നോയാസ്ക്#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ക്വാലലം‌പൂർ‌‌#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#കുചിങ്#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#കുവൈത്ത്#,
		},
		'Asia/Macau' => {
			exemplarCity => q#മക്കാ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#മഗഡാൻ#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#മകസ്സർ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#മനില#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#മസ്കറ്റ്#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#നിക്കോഷ്യ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#നോവോകുസെൻസ്‌ക്#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#നൊവോസിബിർസ്ക്#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ഒംസ്ക്#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ഓറൽ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#നാം പെൻ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#പൊൻറിയാനക്#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#പ്യോംഗ്‌യാംഗ്#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ഖത്തർ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ഖിസിലോർഡ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#റങ്കൂൺ‌#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#റിയാദ്#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ഹോ ചി മിൻ സിറ്റി#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#സഖാലിൻ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#സമർക്കന്ദ്#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#സിയൂൾ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ഷാങ്‌ഹായി#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#സിംഗപ്പൂർ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#തായ്‌പെയ്#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#താഷ്‌ക്കൻറ്#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#തിബിലിസി#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ടെഹ്‌റാൻ‌#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#തിംഫു#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ടോക്കിയോ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ഉലാൻബട്ടൂർ#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ഉറുംഖി#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#യുസ്-നേര#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#വെന്റിയാൻ#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#വ്ളാഡിവോസ്റ്റോക്#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#യാകസ്ക്#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#യാകാറ്റെറിൻബർഗ്#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#യേരവൻ‌#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(അറ്റ്ലാൻറിക് പകൽ സമയം),
				'generic' => q(അറ്റ്ലാൻറിക് സമയം),
				'standard' => q(അറ്റ്ലാൻറിക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#എയ്സോർസ്#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ബർമുഡ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ക്യാനറി#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#കേപ് വെർദെ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ഫെറോ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#മഡെയ്റ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#റേയ്‌ജാവിക്#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ദക്ഷിണ ജോർജിയ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#സെൻറ് ഹെലെന#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#സ്റ്റാൻ‌ലി#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#അഡലെയ്ഡ്#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ബ്രിസ്‌ബേയ്ൻ#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ബ്രോക്കൺ ഹിൽ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ക്യൂറി#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ഡാർവിൻ#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#യൂക്ല#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ഹൊബാർട്ട്#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ലിൻഡെമാൻ#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ലോഡ് ഹോവ്#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#മെൽബൺ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#പെർത്ത്#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#സിഡ്നി#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ഓസ്ട്രേലിയൻ സെൻട്രൽ പകൽ സമയം),
				'generic' => q(സെൻട്രൽ ഓസ്ട്രേലിയ സമയം),
				'standard' => q(ഓസ്ട്രേലിയൻ സെൻട്രൽ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ഓസ്ട്രേലിയൻ സെൻട്രൽ വെസ്റ്റേൺ പകൽ സമയം),
				'generic' => q(ഓസ്ട്രേലിയൻ സെൻട്രൽ വെസ്റ്റേൺ സമയം),
				'standard' => q(ഓസ്ട്രേലിയൻ സെൻട്രൽ വെസ്റ്റേൺ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ഓസ്ട്രേലിയൻ ഈസ്റ്റേൺ പകൽ സമയം),
				'generic' => q(ഈസ്റ്റേൺ ഓസ്ട്രേലിയ സമയം),
				'standard' => q(ഓസ്ട്രേലിയൻ ഈസ്റ്റേൺ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ഓസ്ട്രേലിയൻ ‍വെസ്റ്റേൺ പകൽ സമയം),
				'generic' => q(വെസ്റ്റേൺ ഓസ്ട്രേലിയ സമയം),
				'standard' => q(ഓസ്ട്രേലിയൻ ‍വെസ്റ്റേൺ സ്റ്റാൻഡേർഡ്),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(അസർബയ്ജാൻ വേനൽക്കാല സമയം),
				'generic' => q(അസർബയ്ജാൻ സമയം),
				'standard' => q(അസർബയ്ജാൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(എയ്സോർസ് വേനൽക്കാല സമയം),
				'generic' => q(എയ്സോർസ് സമയം),
				'standard' => q(എയ്സോർസ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(ബംഗ്ലാദേശ് വേനൽക്കാല സമയം),
				'generic' => q(ബംഗ്ലാദേശ് സമയം),
				'standard' => q(ബംഗ്ലാദേശ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ഭൂട്ടാൻ സമയം),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(ബൊളീവിയ സമയം),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ബ്രസീലിയ വേനൽക്കാല സമയം),
				'generic' => q(ബ്രാസിലിയ സമയം),
				'standard' => q(ബ്രസീലിയ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ബ്രൂണെ ഡാറുസ്സലാം സമയം),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(കെയ്പ് വെർഡെ വേനൽക്കാല സമയം),
				'generic' => q(കെയ്പ് വെർഡെ സമയം),
				'standard' => q(കെയ്പ് വെർഡെ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(കമോറോ സമയം),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ചാതം വേനൽക്കാല സമയം),
				'generic' => q(ചാതം സമയം),
				'standard' => q(ചാതം സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ചിലി വേനൽക്കാല സമയം),
				'generic' => q(ചിലി സമയം),
				'standard' => q(ചിലി സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'China' => {
			long => {
				'daylight' => q(ചൈന പകൽ സമയം),
				'generic' => q(ചൈന സമയം),
				'standard' => q(ചൈനാ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ചോയ്ബൽസൻ വേനൽക്കാല സമയം),
				'generic' => q(ചോയി‍ബൽസാൻ സമയം),
				'standard' => q(ചോയ്ബൽസൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ക്രിസ്മസ് ദ്വീപ് സമയം),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(കൊക്കോസ് ദ്വീപുകൾ സമയം),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(കൊളംബിയ വേനൽക്കാല സമയം),
				'generic' => q(കൊളംബിയ സമയം),
				'standard' => q(കൊളംബിയ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(കുക്ക് ദ്വീപുകൾ അർദ്ധ വേനൽക്കാല സമയം),
				'generic' => q(കുക്ക് ദ്വീപുകൾ സമയം),
				'standard' => q(കുക്ക് ദ്വീപുകൾ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(ക്യൂബ പകൽ സമയം),
				'generic' => q(ക്യൂബ സമയം),
				'standard' => q(ക്യൂബ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ഡെയ്‌വിസ് സമയം),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ഡ്യൂമണ്ട് ഡി യൂർവിൽ സമയം),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(കിഴക്കൻ തിമൂർ സമയം),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ഈസ്റ്റർ ദ്വീപ് വേനൽക്കാല സമയം),
				'generic' => q(ഈസ്റ്റർ ദ്വീപ് സമയം),
				'standard' => q(ഈസ്റ്റർ ദ്വീപ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ഇക്വഡോർ സമയം),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#അജ്ഞാത നഗരം#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ആം‌സ്റ്റർ‌ഡാം#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#അണ്ടോറ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ഏതൻ‌സ്#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ബെൽഗ്രേഡ്#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ബെർ‌ലിൻ‌#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ബ്രാട്ടിസ്‍ലാവ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ബ്രസ്സൽ‌സ്#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ബുച്ചാറെസ്റ്റ്#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ബുഡാപെസ്റ്റ്#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ബുസിൻജൻ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ചിസിനാവു#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#കോപ്പൻ‌ഹേഗൻ‌#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ഡബ്ലിൻ#,
			long => {
				'daylight' => q(ഐറിഷ് വേനൽക്കാലം),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ജിബ്രാൾട്ടർ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ഗേൺസേ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ഹെൽ‌സിങ്കി#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ഐൽ‌ ഓഫ് മാൻ‌#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ഇസ്താം‌ബുൾ‌#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ജേഴ്‌സി#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ക്യാലിനിൻഗ്രാഡ്#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#കീവ്#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ലിസ്‌ബൺ‌#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ലുബ്‍ലിയാന#,
		},
		'Europe/London' => {
			exemplarCity => q#ലണ്ടൻ‌#,
			long => {
				'daylight' => q(ബ്രിട്ടീഷ് വേനൽക്കാലം),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ലക്‌സംബർഗ്#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#മാഡ്രിഡ്#,
		},
		'Europe/Malta' => {
			exemplarCity => q#മാൾട്ട#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#മരിയാഹാമൻ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#മിൻ‌സ്ക്#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#മൊണാക്കോ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#മോസ്കോ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ഓസ്ലോ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#പാരീസ്#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#പൊഡ്‍ഗൊറിസ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#പ്രാഗ്#,
		},
		'Europe/Riga' => {
			exemplarCity => q#റിഗ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#റോം#,
		},
		'Europe/Samara' => {
			exemplarCity => q#സമാറ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#സാൻ മാരിനോ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#സരയേവോ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#സിംഫെറോപോൾ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#സ്കോപ്പിയെ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#സോഫിയ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#സ്റ്റോക്ൿഹോം#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ടാലിൻ‌#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ടിരാനെ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ഉസ്ഗൊറോഡ്#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#വാദുസ്#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#വത്തിക്കാൻ#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#വിയന്ന#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#വിൽ‌നിയസ്#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#വോൾഗോഗ്രാഡ്#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#വാർസോ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#സാക്രെബ്#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#സാപ്പറോസൈ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#സൂറിച്ച്#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(സെൻട്രൽ യൂറോപ്യൻ വേനൽക്കാല സമയം),
				'generic' => q(സെൻട്രൽ യൂറോപ്യൻ സമയം),
				'standard' => q(സെൻട്രൽ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(കിഴക്കൻ യൂറോപ്യൻ വേനൽക്കാല സമയം),
				'generic' => q(കിഴക്കൻ യൂറോപ്യൻ സമയം),
				'standard' => q(കിഴക്കൻ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(പടിഞ്ഞാറൻ യൂറോപ്യൻ ഗ്രീഷ്‌മകാല സമയം),
				'generic' => q(പടിഞ്ഞാറൻ യൂറോപ്യൻ സമയം),
				'standard' => q(പടിഞ്ഞാറൻ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ഫാക്‌ലാൻഡ് ദ്വീപുകൾ വേനൽക്കാല സമയം),
				'generic' => q(ഫാക്‌ലാൻഡ് ദ്വീപുകൾ സമയം),
				'standard' => q(ഫാക്‌ലാൻഡ് ദ്വീപുകൾ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ഫിജി വേനൽക്കാല സമയം),
				'generic' => q(ഫിജി സമയം),
				'standard' => q(ഫിജി സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ഫ്രെഞ്ച് ഗയാന സമയം),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ഫ്രെഞ്ച് സതേൺ ആൻഡ് അൻറാർട്ടിക് സമയം),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ഗ്രീൻവിച്ച് മീൻ സമയം),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(ഗാലപ്പാഗോസ് സമയം),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ഗാമ്പിയർ സമയം),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(ജോർജ്ജിയ വേനൽക്കാല സമയം),
				'generic' => q(ജോർജ്ജിയ സമയം),
				'standard' => q(ജോർജ്ജിയ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(ഗിൽബർട്ട് ദ്വീപുകൾ സമയം),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(കിഴക്കൻ ഗ്രീൻലാൻഡ് വേനൽക്കാല സമയം),
				'generic' => q(കിഴക്കൻ ഗ്രീൻലാൻഡ് സമയം),
				'standard' => q(കിഴക്കൻ ഗ്രീൻലാൻഡ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(പശ്ചിമ ഗ്രീൻലാൻഡ് വേനൽക്കാല സമയം),
				'generic' => q(പശ്ചിമ ഗ്രീൻലാൻഡ് സമയം),
				'standard' => q(പശ്ചിമ ഗ്രീൻലാൻഡ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(ഗ്വാം സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(ഗൾഫ് സമയം),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(ഗയാന സമയം),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ഹവായി-അലൂഷ്യൻ പകൽ സമയം),
				'generic' => q(ഹവായി-അലൂഷ്യൻ സമയം),
				'standard' => q(ഹവായി-അലൂഷ്യൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ഹോങ് കോങ് വേനൽക്കാല സമയം),
				'generic' => q(ഹോങ് കോങ് സമയം),
				'standard' => q(ഹോങ് കോങ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ഹൌഡ് വേനൽക്കാല സമയം),
				'generic' => q(ഹൌഡ് സമയം),
				'standard' => q(ഹൌഡ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'India' => {
			long => {
				'standard' => q(ഇൻ‌ഡ്യ സ്റ്റാൻഡേർഡ് സമയം),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#അൻറാനനറിവോ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ചാഗോസ്#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ക്രിസ്തുമസ്#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#കോക്കോസ്#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#കൊമോറോ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#കെർഗുലെൻ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#മാഹി#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#മാലിദ്വീപുകൾ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#മൌറീഷ്യസ്#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#മയോട്ടി#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#റീയൂണിയൻ#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ഇൻഡ്യൻ മഹാസമുദ്ര സമയം),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ഇൻഡോചൈന സമയം),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(സെൻട്രൽ ഇൻഡോനേഷ്യ സമയം),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(കിഴക്കൻ ഇൻഡോനേഷ്യ സമയം),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(പശ്ചിമ ഇൻഡോനേഷ്യ സമയം),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ഇറാൻ പകൽ സമയം),
				'generic' => q(ഇറാൻ സമയം),
				'standard' => q(ഇറാൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ഇർകസ്ക് വേനൽക്കാല സമയം),
				'generic' => q(ഇർകസ്ക് സമയം),
				'standard' => q(ഇർകസ്ക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ഇസ്രായേൽ പകൽ സമയം),
				'generic' => q(ഇസ്രായേൽ സമയം),
				'standard' => q(ഇസ്രായേൽ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(ജപ്പാൻ പകൽ സമയം),
				'generic' => q(ജപ്പാൻ സമയം),
				'standard' => q(ജപ്പാൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി വേനൽക്കാല സമയം),
				'generic' => q(പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി സമയം),
				'standard' => q(പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(കിഴക്കൻ കസാഖ്സ്ഥാൻ സമയം),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(പടിഞ്ഞാറൻ കസാഖ്സ്ഥാൻ സമയം),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(കൊറിയൻ പകൽ സമയം),
				'generic' => q(കൊറിയൻ സമയം),
				'standard' => q(കൊറിയൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(കൊസ്റേ സമയം),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ക്രാസ്നോയാഴ്സ്ക് വേനൽക്കാല സമയം),
				'generic' => q(ക്രിസ്നോയാർസ്കി സമയം),
				'standard' => q(ക്രാസ്നോയാഴ്സ്ക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(കിർഗിസ്ഥാൻ സമയം),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(ലങ്ക സമയം),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(ലൈൻ ദ്വീപുകൾ സമയം),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(ലോർഡ് ഹോവ് പകൽ സമയം),
				'generic' => q(ലോർഡ് ഹോവ് സമയം),
				'standard' => q(ലോർഡ് ഹോവ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(മകൌ വേനൽക്കാല സമയം),
				'generic' => q(മകൌ സമയം),
				'standard' => q(മകൌ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(മക്വാറെ സമയം),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(മഗാഡൻ വേനൽക്കാല സമയം),
				'generic' => q(മഗഡാൻ സ്മയം),
				'standard' => q(മഗാഡൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(മലേഷ്യ സമയം),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(മാലിദ്വീപ് സമയം),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(മാർക്യുസാസ് സമയം),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(മാർഷൽ ദ്വീപുകൾ സമയം),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(മൌറീഷ്യസ് വേനൽക്കാല സമയം),
				'generic' => q(മൌറിഷ്യസ് സമയം),
				'standard' => q(മൌറിഷ്യസ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(മാവ്സൺ സമയം),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(യുലാൻ ബാറ്റർ വേനൽക്കാല സമയം),
				'generic' => q(യുലാൻ ബാറ്റർ സമയം),
				'standard' => q(യുലാൻ ബാറ്റർ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(മോസ്കോ വേനൽക്കാല സമയം),
				'generic' => q(മോസ്കോ സമയം),
				'standard' => q(മോസ്കോ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(മ്യാൻമാർ സമയം),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(നൌറു സമയം),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(നേപ്പാൾ സമയം),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(ന്യൂ കാലിഡോണിയ വേനൽക്കാല സമയം),
				'generic' => q(ന്യൂ കാലിഡോണിയ സമയം),
				'standard' => q(ന്യൂ കാലിഡോണിയ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(ന്യൂസീലൻഡ് പകൽ സമയം),
				'generic' => q(ന്യൂസീലൻഡ് സമയം),
				'standard' => q(ന്യൂസീലൻഡ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(ന്യൂഫൌണ്ട്‌ലാൻഡ് പകൽ‌ സമയം),
				'generic' => q(ന്യൂഫൌണ്ട്‌ലാൻഡ് സമയം),
				'standard' => q(ന്യൂഫൌണ്ട്‌ലാൻഡ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(നിയു സമയം),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(നോർഫോക് ദ്വീപുകൾ സമയം),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ഫെർണാണ്ടോ ഡി നൊറോന വേനൽക്കാല സമയം),
				'generic' => q(ഫെർണാണ്ടോ ഡി നൊറോന സമയം),
				'standard' => q(ഫെർണാണ്ടോ ഡി നൊറോന സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(നോർത്ത് മറിയാനാ ദ്വീപുകൾ സമയം),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(നോവോസിബിർസ്ക് വേനൽക്കാല സമയം),
				'generic' => q(നൊവേസിബിർസ്ക് സമയം),
				'standard' => q(നോവോസിബിർസ്ക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ഓംസ്‌ക്ക് വേനൽക്കാല സമയം),
				'generic' => q(ഓംസ്‌ക്ക് സമയം),
				'standard' => q(ഓംസ്‌ക്ക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ആപിയ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ഓക്ക്‌‌ലാൻറ്#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ചാതം#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ഈസ്റ്റർ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ഇഫാതെ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#എൻഡബറി#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ഫക്കാവോഫോ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ഫിജി#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ഫുണാഫുട്ടി#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ഗാലപ്പാഗോസ്#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ഗാന്പിയർ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ഗ്വാഡോ കനാൽ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ഗ്വാം#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ഹോണലൂലു#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ജോൺസ്റ്റൺ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#കിരിതിമാത്തി#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#കൊസ്രേ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ക്വാജലെയ്ൻ#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#മജൂറോ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#മാർക്യുസാസ്#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#മിഡ്‌വേ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#നവ്‌റു#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#നിയു#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#നോർ‌ഫോക്ക്#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#നോമിയ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#പാഗോ പോഗോ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#പലാവു#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#പിറ്റ്കയിൻ‌#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#പൊനാപ്#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#പോർട്ട് മോഴ്‌സ്ബൈ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#റാരോടോംഗ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#സെയ്‌പ്പാൻ‌#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#താഹിതി#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#തരാവ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ടോംഗാടാപു#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ട്രക്#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#വെയ്ക്#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#വാല്ലിസ്#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(പാകിസ്ഥാൻ വേനൽക്കാല സമയം),
				'generic' => q(പാകിസ്ഥാൻ സമയം),
				'standard' => q(പാകിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(പലൌ സമയം),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(പാപ്യു ന്യൂ ഗിനിയ സമയം),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(പരാഗ്വേ വേനൽക്കാല സമയം),
				'generic' => q(പരാഗ്വേ സമയം),
				'standard' => q(പരാഗ്വേ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(പെറു വേനൽക്കാല സമയം),
				'generic' => q(പെറു സമയം),
				'standard' => q(പെറു സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ഫിലിപ്പീൻ വേനൽക്കാല സമയം),
				'generic' => q(ഫിലിപ്പീൻ സമയം),
				'standard' => q(ഫിലിപ്പീൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ഫീനിക്സ് ദ്വീപുകൾ സമയം),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(പിയറി ആൻഡ് മിക്വലൻ പകൽ സമയം),
				'generic' => q(പിയറി ആൻഡ് മിക്വലൻ സമയം),
				'standard' => q(പിയറി ആൻഡ് മിക്വലൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(പിറ്റ്കെയ്ൻ സമയം),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(പൊനാപ് സമയം),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(ഖിസിലോർഡ വേനൽക്കാല സമയം),
				'generic' => q(ഖിസിലോർഡ സമയം),
				'standard' => q(ഖിസിലോർഡ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(റീയൂണിയൻ സമയം),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(റൊതീറ സമയം),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(സഖാലിൻ വേനൽക്കാല സമയം),
				'generic' => q(സഖലിൻ സമയം),
				'standard' => q(സഖാലിൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(സമാറ വേനൽക്കാല സമയം),
				'generic' => q(സമാര സമയം),
				'standard' => q(സമാറ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(സമോവാ വേനൽക്കാല സമയം),
				'generic' => q(സമോവാ സമയം),
				'standard' => q(സമോവാ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(സെയ്ഷെൽസ് സമയം),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(സിംഗപ്പൂർ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(സോളമൻ ദ്വീപുകൾ സമയം),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(ദക്ഷിണ ജോർജ്ജിയ സമയം),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(സൂറിനാം സമയം),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(സ്യോവ സമയം),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(തഹിതി സമയം),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(തായ്‌പെയ് പകൽ സമയം),
				'generic' => q(തായ്‌പെയ് സമയം),
				'standard' => q(തായ്‌പെയ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(തജികിസ്ഥാൻ സമയം),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(റ്റോക്കിലൌ സമയം),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(റ്റോംഗാ വേനൽക്കാല സമയം),
				'generic' => q(റ്റോംഗാ സമയം),
				'standard' => q(റ്റോംഗാ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ചൂക്ക് സമയം),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(തുർക്ക്മെനിസ്ഥാൻ വേനൽക്കാല സമയം),
				'generic' => q(തുർക്ക്മെനിസ്ഥാൻ സമയം),
				'standard' => q(തുർക്ക്മെനിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(തുവാലു സമയം),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ഉറുഗ്വെ വേനൽക്കാല സമയം),
				'generic' => q(ഉറുഗ്വെ സമയം),
				'standard' => q(ഉറുഗ്വെ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ഉസ്ബക്കിസ്ഥാൻ വേനൽ‌ക്കാല സമയം),
				'generic' => q(ഉസ്ബക്കിസ്ഥാൻ സമയം),
				'standard' => q(ഉസ്ബക്കിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(വന്വാതു വേനൽക്കാല സമയം),
				'generic' => q(വന്വാതു സമയം),
				'standard' => q(വന്വാതു സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(വെനസ്വേല സമയം),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(വ്‌ളാഡിവോസ്റ്റോക് വേനൽക്കാല സമയം),
				'generic' => q(വ്‌ളാഡിവോസ്റ്റോക് സമയം),
				'standard' => q(വ്‌ളാഡിവോസ്റ്റോക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(വോൾഗോഗ്രാഡ് വേനൽക്കാല സമയം),
				'generic' => q(വോൾഗോഗ്രാഡ് സമയം),
				'standard' => q(വോൾഗോഗ്രാഡ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(വോസ്റ്റോക് സമയം),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(വെയ്ക് ദ്വീപ് സമയം),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(വാലിസ് ആൻഡ് ഫ്യൂചുന സമയം),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(യാകസ്‌ക്ക് വേനൽക്കാല സമയം),
				'generic' => q(യാകസ്‌ക്ക് സമയം),
				'standard' => q(യാകസ്‌ക്ക് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(യെക്കാറ്ററിൻബർഗ് വേനൽക്കാല സമയം),
				'generic' => q(യിക്കാരെറിൻബർഗ് സമയം),
				'standard' => q(യെക്കാറ്ററിൻബർഗ് സ്റ്റാൻഡേർഡ് സമയം),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
