=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Uk - Package for language Ukrainian

=cut

package Locale::CLDR::Locales::Uk;
# This file auto generated from Data\common\main\uk.xml
#	on Sun 31 Dec  6:09:26 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-neuter','spellout-cardinal-feminine' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(мінус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нуль),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(одна),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(дві),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадцять[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридцять[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(сорок[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(пʼятдесят[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шістдесят[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(сімдесят[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(вісімдесят[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(девʼяносто[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двісті[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(чотириста[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(пʼятсот[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шістсот[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(сімсот[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(вісімсот[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(девʼятсот[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← $(cardinal,one{тисяча}few{тисячі}other{тисяч})$[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{мільйон}few{мільйони}other{мільйонів})$[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{мільярд}few{мільярди}other{мільярдів})$[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{більйон}few{більйони}other{більйонів})$[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{більярд}few{більярди}other{більярдів})$[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(мінус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нуль),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(один),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(чотири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пʼять),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шість),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(сім),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(вісім),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девʼять),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десять),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(одинадцять),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванадцять),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринадцять),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(чотирнадцять),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(пʼятнадцять),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шістнадцять),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(сімнадцять),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(вісімнадцять),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(девʼятнадцять),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадцять[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридцять[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(сорок[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(пʼятдесят[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шістдесят[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(сімдесят[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(вісімдесят[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(девʼяносто[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двісті[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(чотириста[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(пʼятсот[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шістсот[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(сімсот[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(вісімсот[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(девʼятсот[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← $(cardinal,one{тисяча}few{тисячі}other{тисяч})$[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{мільйон}few{мільйони}other{мільйонів})$[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{мільярд}few{мільярди}other{мільярдів})$[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{більйон}few{більйони}other{більйонів})$[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{більярд}few{більярди}other{більярдів})$[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-neuter' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(мінус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нуль),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(одне),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадцять[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридцять[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(сорок[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(пʼятдесят[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шістдесят[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(сімдесят[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(вісімдесят[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(девʼяносто[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двісті[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(чотириста[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(пʼятсот[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шістсот[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(сімсот[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(вісімсот[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(девʼятсот[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← $(cardinal,one{тисяча}few{тисячі}other{тисяч})$[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{мільйон}few{мільйони}other{мільйонів})$[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{мільярд}few{мільярди}other{мільярдів})$[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{більйон}few{більйони}other{більйонів})$[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← $(cardinal,one{більярд}few{більярди}other{більярдів})$[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
    } },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'афарська',
 				'ab' => 'абхазька',
 				'ace' => 'ачехська',
 				'ach' => 'ачолі',
 				'ada' => 'адангме',
 				'ady' => 'адигейська',
 				'ae' => 'авестійська',
 				'af' => 'африкаанс',
 				'afh' => 'африхілі',
 				'agq' => 'агем',
 				'ain' => 'айнська',
 				'ak' => 'акан',
 				'akk' => 'аккадська',
 				'akz' => 'алабама',
 				'ale' => 'алеутська',
 				'alt' => 'південноалтайська',
 				'am' => 'амхарська',
 				'an' => 'арагонська',
 				'ang' => 'давньоанглійська',
 				'anp' => 'ангіка',
 				'ar' => 'арабська',
 				'ar_001' => 'сучасна стандартна арабська',
 				'arc' => 'арамейська',
 				'arn' => 'арауканська',
 				'aro' => 'араона',
 				'arp' => 'арапахо',
 				'arq' => 'алжирська арабська',
 				'ars' => 'надждійська арабська',
 				'ars@alt=menu' => 'арабська, надждійська',
 				'arw' => 'аравакська',
 				'as' => 'асамська',
 				'asa' => 'асу',
 				'ase' => 'американська мова рухів',
 				'ast' => 'астурійська',
 				'av' => 'аварська',
 				'awa' => 'авадхі',
 				'ay' => 'аймара',
 				'az' => 'азербайджанська',
 				'az@alt=short' => 'азері',
 				'az_Arab' => 'південноазербайджанська',
 				'ba' => 'башкирська',
 				'bal' => 'балучі',
 				'ban' => 'балійська',
 				'bar' => 'баеріш',
 				'bas' => 'баса',
 				'bax' => 'бамум',
 				'bbc' => 'батак тоба',
 				'bbj' => 'гомала',
 				'be' => 'білоруська',
 				'bej' => 'беджа',
 				'bem' => 'бемба',
 				'bew' => 'бетаві',
 				'bez' => 'бена',
 				'bfd' => 'бафут',
 				'bfq' => 'бадага',
 				'bg' => 'болгарська',
 				'bgn' => 'східнобелуджійська',
 				'bho' => 'бходжпурі',
 				'bi' => 'біслама',
 				'bik' => 'бікольська',
 				'bin' => 'біні',
 				'bjn' => 'банджарська',
 				'bkm' => 'ком',
 				'bla' => 'сіксіка',
 				'bm' => 'бамбара',
 				'bn' => 'бенгальська',
 				'bo' => 'тибетська',
 				'bqi' => 'бахтіарі',
 				'br' => 'бретонська',
 				'bra' => 'брадж',
 				'brx' => 'бодо',
 				'bs' => 'боснійська',
 				'bss' => 'акус',
 				'bua' => 'бурятська',
 				'bug' => 'бугійська',
 				'bum' => 'булу',
 				'byn' => 'блін',
 				'byv' => 'медумба',
 				'ca' => 'каталонська',
 				'cad' => 'каддо',
 				'car' => 'карібська',
 				'cay' => 'кайюга',
 				'cch' => 'атсам',
 				'ccp' => 'чакма',
 				'ce' => 'чеченська',
 				'ceb' => 'себуанська',
 				'cgg' => 'кіга',
 				'ch' => 'чаморро',
 				'chb' => 'чібча',
 				'chg' => 'чагатайська',
 				'chk' => 'чуукська',
 				'chm' => 'марійська',
 				'chn' => 'чинук жаргон',
 				'cho' => 'чокто',
 				'chp' => 'чіпевʼян',
 				'chr' => 'черокі',
 				'chy' => 'чейєнн',
 				'ckb' => 'центральнокурдська',
 				'ckb@alt=menu' => 'курдська, сорані',
 				'ckb@alt=variant' => 'сорані',
 				'co' => 'корсиканська',
 				'cop' => 'коптська',
 				'cr' => 'крі',
 				'crh' => 'кримськотатарська',
 				'crs' => 'сейшельська креольська',
 				'cs' => 'чеська',
 				'csb' => 'кашубська',
 				'cu' => 'церковнословʼянська',
 				'cv' => 'чуваська',
 				'cy' => 'валлійська',
 				'da' => 'данська',
 				'dak' => 'дакота',
 				'dar' => 'даргінська',
 				'dav' => 'таіта',
 				'de' => 'німецька',
 				'de_CH' => 'швейцарська верхньонімецька',
 				'del' => 'делаварська',
 				'den' => 'слейв',
 				'dgr' => 'догрибська',
 				'din' => 'дінка',
 				'dje' => 'джерма',
 				'doi' => 'догрі',
 				'dsb' => 'нижньолужицька',
 				'dua' => 'дуала',
 				'dum' => 'середньонідерландська',
 				'dv' => 'дівехі',
 				'dyo' => 'дьола-фоні',
 				'dyu' => 'діула',
 				'dz' => 'дзонг-ке',
 				'dzg' => 'дазага',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефік',
 				'egy' => 'давньоєгипетська',
 				'eka' => 'екаджук',
 				'el' => 'грецька',
 				'elx' => 'еламська',
 				'en' => 'англійська',
 				'en_GB@alt=short' => 'англійська (Брит.)',
 				'en_US' => 'американська англійська',
 				'enm' => 'середньоанглійська',
 				'eo' => 'есперанто',
 				'es' => 'іспанська',
 				'es_419' => 'латиноамериканська іспанська',
 				'es_ES' => 'європейська іспанська',
 				'es_MX' => 'мексиканська іспанська',
 				'et' => 'естонська',
 				'eu' => 'баскська',
 				'ewo' => 'евондо',
 				'fa' => 'перська',
 				'fa_AF' => 'дарі',
 				'fan' => 'фанг',
 				'fat' => 'фанті',
 				'ff' => 'фула',
 				'fi' => 'фінська',
 				'fil' => 'філіппінська',
 				'fj' => 'фіджі',
 				'fo' => 'фарерська',
 				'fon' => 'фон',
 				'fr' => 'французька',
 				'fr_CA' => 'канадська французька',
 				'fr_CH' => 'швейцарська французька',
 				'frc' => 'кажунська французька',
 				'frm' => 'середньофранцузька',
 				'fro' => 'давньофранцузька',
 				'frp' => 'арпітанська',
 				'frr' => 'фризька північна',
 				'frs' => 'фризька східна',
 				'fur' => 'фріульська',
 				'fy' => 'західнофризька',
 				'ga' => 'ірландська',
 				'gaa' => 'га',
 				'gag' => 'гагаузька',
 				'gan' => 'ґань',
 				'gay' => 'гайо',
 				'gba' => 'гбайя',
 				'gd' => 'шотландська гельська',
 				'gez' => 'гєез',
 				'gil' => 'гільбертська',
 				'gl' => 'галісійська',
 				'gmh' => 'середньоверхньонімецька',
 				'gn' => 'гуарані',
 				'goh' => 'давньоверхньонімецька',
 				'gon' => 'гонді',
 				'gor' => 'горонтало',
 				'got' => 'готська',
 				'grb' => 'гребо',
 				'grc' => 'давньогрецька',
 				'gsw' => 'швейцарська німецька',
 				'gu' => 'гуджараті',
 				'guz' => 'гусії',
 				'gv' => 'менкська',
 				'gwi' => 'кучін',
 				'ha' => 'хауса',
 				'hai' => 'хайда',
 				'hak' => 'хаккаська',
 				'haw' => 'гавайська',
 				'he' => 'іврит',
 				'hi' => 'гінді',
 				'hil' => 'хілігайнон',
 				'hit' => 'хітіті',
 				'hmn' => 'хмонг',
 				'ho' => 'хірі-моту',
 				'hr' => 'хорватська',
 				'hsb' => 'верхньолужицька',
 				'hsn' => 'сянська китайська',
 				'ht' => 'гаїтянська креольська',
 				'hu' => 'угорська',
 				'hup' => 'хупа',
 				'hy' => 'вірменська',
 				'hz' => 'гереро',
 				'ia' => 'інтерлінгва',
 				'iba' => 'ібанська',
 				'ibb' => 'ібібіо',
 				'id' => 'індонезійська',
 				'ie' => 'інтерлінгве',
 				'ig' => 'ігбо',
 				'ii' => 'сичуаньська ї',
 				'ik' => 'інупіак',
 				'ilo' => 'ілоканська',
 				'inh' => 'інгуська',
 				'io' => 'ідо',
 				'is' => 'ісландська',
 				'it' => 'італійська',
 				'iu' => 'інуктітут',
 				'ja' => 'японська',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'юдео-перська',
 				'jrb' => 'юдео-арабська',
 				'jv' => 'яванська',
 				'ka' => 'грузинська',
 				'kaa' => 'каракалпацька',
 				'kab' => 'кабільська',
 				'kac' => 'качін',
 				'kaj' => 'йю',
 				'kam' => 'камба',
 				'kaw' => 'каві',
 				'kbd' => 'кабардинська',
 				'kbl' => 'канембу',
 				'kcg' => 'тіап',
 				'kde' => 'маконде',
 				'kea' => 'кабувердіану',
 				'kfo' => 'коро',
 				'kg' => 'конґолезька',
 				'kha' => 'кхасі',
 				'kho' => 'хотаносакська',
 				'khq' => 'койра чіїні',
 				'ki' => 'кікуйю',
 				'kj' => 'кунама',
 				'kk' => 'казахська',
 				'kkj' => 'како',
 				'kl' => 'калааллісут',
 				'kln' => 'календжин',
 				'km' => 'кхмерська',
 				'kmb' => 'кімбунду',
 				'kn' => 'каннада',
 				'ko' => 'корейська',
 				'koi' => 'комі-перм’яцька',
 				'kok' => 'конкані',
 				'kos' => 'косрае',
 				'kpe' => 'кпеллє',
 				'kr' => 'канурі',
 				'krc' => 'карачаєво-балкарська',
 				'krl' => 'карельська',
 				'kru' => 'курукх',
 				'ks' => 'кашмірська',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафіа',
 				'ksh' => 'кельнська',
 				'ku' => 'курдська',
 				'kum' => 'кумицька',
 				'kut' => 'кутенаї',
 				'kv' => 'комі',
 				'kw' => 'корнська',
 				'ky' => 'киргизька',
 				'la' => 'латинська',
 				'lad' => 'ладіно',
 				'lag' => 'лангі',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'люксембурзька',
 				'lez' => 'лезгінська',
 				'lg' => 'ганда',
 				'li' => 'лімбургійська',
 				'lkt' => 'лакота',
 				'ln' => 'лінгала',
 				'lo' => 'лаоська',
 				'lol' => 'монго',
 				'lou' => 'луїзіанська креольська',
 				'loz' => 'лозі',
 				'lrc' => 'північнолурська',
 				'lt' => 'литовська',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'луїсеньо',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'мізо',
 				'luy' => 'луйя',
 				'lv' => 'латиська',
 				'mad' => 'мадурська',
 				'maf' => 'мафа',
 				'mag' => 'магадхі',
 				'mai' => 'майтхілі',
 				'mak' => 'макасарська',
 				'man' => 'мандінго',
 				'mas' => 'масаї',
 				'mde' => 'маба',
 				'mdf' => 'мокша',
 				'mdr' => 'мандарська',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'маврикійська креольська',
 				'mg' => 'малагасійська',
 				'mga' => 'середньоірландська',
 				'mgh' => 'макува-меето',
 				'mgo' => 'мета',
 				'mh' => 'маршалльська',
 				'mi' => 'маорі',
 				'mic' => 'мікмак',
 				'min' => 'мінангкабау',
 				'mk' => 'македонська',
 				'ml' => 'малаялам',
 				'mn' => 'монгольська',
 				'mnc' => 'манчжурська',
 				'mni' => 'маніпурі',
 				'moh' => 'магавк',
 				'mos' => 'моссі',
 				'mr' => 'маратхі',
 				'ms' => 'малайська',
 				'mt' => 'мальтійська',
 				'mua' => 'мунданг',
 				'mul' => 'кілька мов',
 				'mus' => 'крік',
 				'mwl' => 'мірандська',
 				'mwr' => 'марварі',
 				'my' => 'бірманська',
 				'mye' => 'миін',
 				'myv' => 'ерзя',
 				'mzn' => 'мазандеранська',
 				'na' => 'науру',
 				'nan' => 'південноміньська',
 				'nap' => 'неаполітанська',
 				'naq' => 'нама',
 				'nb' => 'норвезька (букмол)',
 				'nd' => 'північна ндебеле',
 				'nds' => 'нижньонімецька',
 				'nds_NL' => 'нижньосаксонська',
 				'ne' => 'непальська',
 				'new' => 'неварі',
 				'ng' => 'ндонга',
 				'nia' => 'ніаська',
 				'niu' => 'ніуе',
 				'njo' => 'ао нага',
 				'nl' => 'нідерландська',
 				'nl_BE' => 'фламандська',
 				'nmg' => 'квазіо',
 				'nn' => 'норвезька (нюношк)',
 				'nnh' => 'нгємбун',
 				'no' => 'норвезька',
 				'nog' => 'ногайська',
 				'non' => 'давньонорвезька',
 				'nqo' => 'нко',
 				'nr' => 'ндебелє південна',
 				'nso' => 'північна сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'неварі класична',
 				'ny' => 'ньянджа',
 				'nym' => 'ньямвезі',
 				'nyn' => 'ньянколе',
 				'nyo' => 'ньоро',
 				'nzi' => 'нзіма',
 				'oc' => 'окситанська',
 				'oj' => 'оджібва',
 				'om' => 'оромо',
 				'or' => 'одія',
 				'os' => 'осетинська',
 				'osa' => 'осейдж',
 				'ota' => 'османська',
 				'pa' => 'панджабі',
 				'pag' => 'пангасінанська',
 				'pal' => 'пехлеві',
 				'pam' => 'пампанга',
 				'pap' => 'папʼяменто',
 				'pau' => 'палауанська',
 				'pcm' => 'нігерійсько-креольська',
 				'peo' => 'давньоперська',
 				'phn' => 'фінікійсько-пунічна',
 				'pi' => 'палі',
 				'pl' => 'польська',
 				'pon' => 'понапе',
 				'prg' => 'прусська',
 				'pro' => 'давньопровансальська',
 				'ps' => 'пушту',
 				'pt' => 'португальська',
 				'pt_BR' => 'бразильська португальська',
 				'pt_PT' => 'європейська португальська',
 				'qu' => 'кечуа',
 				'quc' => 'кіче',
 				'raj' => 'раджастхані',
 				'rap' => 'рапануї',
 				'rar' => 'раротонга',
 				'rhg' => 'рогінджа',
 				'rm' => 'ретороманська',
 				'rn' => 'рунді',
 				'ro' => 'румунська',
 				'ro_MD' => 'молдавська',
 				'rof' => 'ромбо',
 				'rom' => 'циганська',
 				'ru' => 'російська',
 				'rup' => 'арумунська',
 				'rw' => 'кіньяруанда',
 				'rwk' => 'рва',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'саха',
 				'sam' => 'самаритянська арамейська',
 				'saq' => 'самбуру',
 				'sas' => 'сасакська',
 				'sat' => 'сантальська',
 				'sba' => 'нгамбай',
 				'sbp' => 'сангу',
 				'sc' => 'сардинська',
 				'scn' => 'сицилійська',
 				'sco' => 'шотландська',
 				'sd' => 'синдхі',
 				'sdh' => 'південнокурдська',
 				'se' => 'північносаамська',
 				'see' => 'сенека',
 				'seh' => 'сена',
 				'sel' => 'селькупська',
 				'ses' => 'койраборо сені',
 				'sg' => 'санго',
 				'sga' => 'давньоірландська',
 				'sh' => 'сербсько-хорватська',
 				'shi' => 'тачеліт',
 				'shn' => 'шанська',
 				'shu' => 'чадійська арабська',
 				'si' => 'сингальська',
 				'sid' => 'сідамо',
 				'sk' => 'словацька',
 				'sl' => 'словенська',
 				'sm' => 'самоанська',
 				'sma' => 'південносаамська',
 				'smj' => 'саамська луле',
 				'smn' => 'саамська інарі',
 				'sms' => 'скольт-саамська',
 				'sn' => 'шона',
 				'snk' => 'сонінке',
 				'so' => 'сомалі',
 				'sog' => 'согдійська',
 				'sq' => 'албанська',
 				'sr' => 'сербська',
 				'srn' => 'сранан тонго',
 				'srr' => 'серер',
 				'ss' => 'сісваті',
 				'ssy' => 'сахо',
 				'st' => 'південна сото',
 				'su' => 'сунданська',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'шумерська',
 				'sv' => 'шведська',
 				'sw' => 'суахілі',
 				'sw_CD' => 'суахілі (Конго)',
 				'swb' => 'коморська',
 				'syc' => 'сирійська класична',
 				'syr' => 'сирійська',
 				'ta' => 'тамільська',
 				'te' => 'телугу',
 				'tem' => 'темне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таджицька',
 				'th' => 'тайська',
 				'ti' => 'тигринья',
 				'tig' => 'тигре',
 				'tiv' => 'тів',
 				'tk' => 'туркменська',
 				'tkl' => 'токелау',
 				'tl' => 'тагальська',
 				'tlh' => 'клінгонська',
 				'tli' => 'тлінгіт',
 				'tmh' => 'тамашек',
 				'tn' => 'тсвана',
 				'to' => 'тонганська',
 				'tog' => 'ньяса тонга',
 				'tpi' => 'ток-пісін',
 				'tr' => 'турецька',
 				'trv' => 'тароко',
 				'ts' => 'тсонга',
 				'tsi' => 'цимшиан',
 				'tt' => 'татарська',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалу',
 				'tw' => 'тві',
 				'twq' => 'тасавак',
 				'ty' => 'таїтянська',
 				'tyv' => 'тувинська',
 				'tzm' => 'центральноатласька тамазігт',
 				'udm' => 'удмуртська',
 				'ug' => 'уйгурська',
 				'uga' => 'угаритська',
 				'uk' => 'українська',
 				'umb' => 'умбунду',
 				'und' => 'невідома мова',
 				'ur' => 'урду',
 				'uz' => 'узбецька',
 				'vai' => 'ваї',
 				've' => 'венда',
 				'vi' => 'вʼєтнамська',
 				'vo' => 'волапюк',
 				'vot' => 'водська',
 				'vun' => 'вуньо',
 				'wa' => 'валлонська',
 				'wae' => 'вальзерська',
 				'wal' => 'волайтта',
 				'war' => 'варай',
 				'was' => 'вашо',
 				'wbp' => 'валпірі',
 				'wo' => 'волоф',
 				'wuu' => 'уська китайська',
 				'xal' => 'калмицька',
 				'xh' => 'кхоса',
 				'xog' => 'сога',
 				'yao' => 'яо',
 				'yap' => 'яп',
 				'yav' => 'янгбен',
 				'ybb' => 'ємба',
 				'yi' => 'їдиш',
 				'yo' => 'йоруба',
 				'yue' => 'кантонська',
 				'yue@alt=menu' => 'китайська кантонська',
 				'za' => 'чжуан',
 				'zap' => 'сапотекська',
 				'zbl' => 'блісса мова',
 				'zen' => 'зенага',
 				'zgh' => 'стандартна марокканська берберська',
 				'zh' => 'китайська',
 				'zh@alt=menu' => 'китайська мандаринська',
 				'zh_Hans' => 'китайська (спрощене письмо)',
 				'zh_Hans@alt=long' => 'китайська мандаринська (спрощене письмо)',
 				'zh_Hant' => 'китайська (традиційне письмо)',
 				'zh_Hant@alt=long' => 'китайська мандаринська (традиційне письмо)',
 				'zu' => 'зулуська',
 				'zun' => 'зуньї',
 				'zxx' => 'без мовного вмісту',
 				'zza' => 'зазакі',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'адлам',
 			'Afak' => 'афака',
 			'Aghb' => 'кавказька албанська',
 			'Ahom' => 'ахом',
 			'Arab' => 'арабиця',
 			'Arab@alt=variant' => 'персько-арабська',
 			'Aran' => 'насталік',
 			'Armi' => 'армі',
 			'Armn' => 'вірменська',
 			'Avst' => 'авестійський',
 			'Bali' => 'балійський',
 			'Bamu' => 'бамум',
 			'Bass' => 'басса',
 			'Batk' => 'батак',
 			'Beng' => 'бенгальська',
 			'Blis' => 'символи Блісса',
 			'Bopo' => 'бопомофо',
 			'Brah' => 'брахмі',
 			'Brai' => 'шрифт Брайля',
 			'Bugi' => 'бугійський',
 			'Buhd' => 'бухід',
 			'Cakm' => 'чакма',
 			'Cans' => 'уніфіковані символи канадських тубільців',
 			'Cari' => 'каріанський',
 			'Cham' => 'хамітський',
 			'Cher' => 'черокі',
 			'Cirt' => 'кирт',
 			'Copt' => 'коптський',
 			'Cprt' => 'кіпрський',
 			'Cyrl' => 'кирилиця',
 			'Cyrs' => 'давньоцерковнословʼянський',
 			'Deva' => 'деванагарі',
 			'Dsrt' => 'дезерет',
 			'Egyd' => 'єгипетський демотичний',
 			'Egyh' => 'єгипетський ієратичний',
 			'Egyp' => 'єгипетський ієрогліфічний',
 			'Ethi' => 'ефіопська',
 			'Geok' => 'кхутсурі',
 			'Geor' => 'грузинська',
 			'Glag' => 'глаголичний',
 			'Goth' => 'готичний',
 			'Grek' => 'грецька',
 			'Gujr' => 'гуджараті',
 			'Guru' => 'гурмухі',
 			'Hanb' => 'хань',
 			'Hang' => 'хангиль',
 			'Hani' => 'китайська',
 			'Hano' => 'хануну',
 			'Hans' => 'спрощена',
 			'Hans@alt=stand-alone' => 'китайська спрощена',
 			'Hant' => 'традиційна',
 			'Hant@alt=stand-alone' => 'китайська традиційна',
 			'Hebr' => 'іврит',
 			'Hira' => 'хірагана',
 			'Hmng' => 'пахау хмонг',
 			'Hrkt' => 'японські силабарії',
 			'Hung' => 'давньоугорський',
 			'Inds' => 'харапський',
 			'Ital' => 'давньоіталійський',
 			'Jamo' => 'чамо',
 			'Java' => 'яванський',
 			'Jpan' => 'японська',
 			'Kali' => 'кая лі',
 			'Kana' => 'катакана',
 			'Khar' => 'кхароштхі',
 			'Khmr' => 'кхмерська',
 			'Knda' => 'каннада',
 			'Kore' => 'корейська',
 			'Kthi' => 'каїті',
 			'Lana' => 'ланна',
 			'Laoo' => 'лаоська',
 			'Latf' => 'латинський фрактурний',
 			'Latg' => 'латинський гельський',
 			'Latn' => 'латиниця',
 			'Lepc' => 'лепча',
 			'Limb' => 'лімбу',
 			'Lina' => 'лінійний А',
 			'Linb' => 'лінійний В',
 			'Lisu' => 'абетка Фрейзера',
 			'Loma' => 'лома',
 			'Lyci' => 'лікійський',
 			'Lydi' => 'лідійський',
 			'Mand' => 'мандейський',
 			'Mani' => 'маніхейський',
 			'Maya' => 'майя ієрогліфічний',
 			'Mero' => 'мероїтський',
 			'Mlym' => 'малаяламська',
 			'Mong' => 'монгольська',
 			'Moon' => 'мун',
 			'Mtei' => 'мейтей майєк',
 			'Mymr' => 'мʼянмська',
 			'Newa' => 'нева',
 			'Nkoo' => 'нко',
 			'Ogam' => 'огамічний',
 			'Olck' => 'сантальський',
 			'Olck@alt=variant' => 'ол чікі',
 			'Orkh' => 'орхонський',
 			'Orya' => 'орія',
 			'Osge' => 'осейджиська',
 			'Osma' => 'османський',
 			'Perm' => 'давньопермський',
 			'Phag' => 'пхагс-па',
 			'Phli' => 'пехлеві написів',
 			'Phlp' => 'пехлеві релігійний',
 			'Phlv' => 'пехлеві літературний',
 			'Phnx' => 'фінікійський',
 			'Plrd' => 'писемність Полларда',
 			'Prti' => 'парфянський',
 			'Qaag' => 'зоджі',
 			'Rjng' => 'реджанг',
 			'Roro' => 'ронго-ронго',
 			'Runr' => 'рунічний',
 			'Samr' => 'самаритянський',
 			'Sara' => 'сараті',
 			'Saur' => 'саураштра',
 			'Sgnw' => 'знаковий',
 			'Shaw' => 'шоу',
 			'Sinh' => 'сингальська',
 			'Sund' => 'сунданський',
 			'Sylo' => 'сілоті нагрі',
 			'Syrc' => 'сирійський',
 			'Syre' => 'давньосирійський естрангело',
 			'Syrj' => 'давньосирійський західний',
 			'Syrn' => 'давньосирійський східний',
 			'Tagb' => 'тагбанва',
 			'Tale' => 'тай-лі',
 			'Talu' => 'новий тайський луе',
 			'Taml' => 'тамільська',
 			'Tang' => 'тангут',
 			'Tavt' => 'тай-вʼєт',
 			'Telu' => 'телугу',
 			'Teng' => 'тенгвар',
 			'Tfng' => 'тифінаг',
 			'Tglg' => 'тагальський',
 			'Thaa' => 'таана',
 			'Thai' => 'тайська',
 			'Tibt' => 'тибетська',
 			'Ugar' => 'угаритський',
 			'Vaii' => 'ваї',
 			'Visp' => 'видиме мовлення',
 			'Xpeo' => 'давньоперський',
 			'Xsux' => 'шумеро-аккадський клінопис',
 			'Yiii' => 'йї',
 			'Zinh' => 'успадкована',
 			'Zmth' => 'математична',
 			'Zsye' => 'емодзі',
 			'Zsym' => 'символьна',
 			'Zxxx' => 'безписемна',
 			'Zyyy' => 'звичайна',
 			'Zzzz' => 'невідома система письма',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'Світ',
 			'002' => 'Африка',
 			'003' => 'Північна Америка',
 			'005' => 'Південна Америка',
 			'009' => 'Океанія',
 			'011' => 'Західна Африка',
 			'013' => 'Центральна Америка',
 			'014' => 'Східна Африка',
 			'015' => 'Північна Африка',
 			'017' => 'Центральна Африка',
 			'018' => 'Південноафриканський регіон',
 			'019' => 'Американський регіон',
 			'021' => 'Північноамериканський регіон',
 			'029' => 'Карибський басейн',
 			'030' => 'Східна Азія',
 			'034' => 'Південна Азія',
 			'035' => 'Південно-Східна Азія',
 			'039' => 'Південна Європа',
 			'053' => 'Австралазія',
 			'054' => 'Меланезія',
 			'057' => 'Мікронезійський регіон',
 			'061' => 'Полінезія',
 			'142' => 'Азія',
 			'143' => 'Центральна Азія',
 			'145' => 'Західна Азія',
 			'150' => 'Європа',
 			'151' => 'Східна Європа',
 			'154' => 'Північна Європа',
 			'155' => 'Західна Європа',
 			'202' => 'Африка на південь від Сахари',
 			'419' => 'Латинська Америка',
 			'AC' => 'Острів Вознесіння',
 			'AD' => 'Андорра',
 			'AE' => 'Обʼєднані Арабські Емірати',
 			'AF' => 'Афганістан',
 			'AG' => 'Антигуа і Барбуда',
 			'AI' => 'Ангілья',
 			'AL' => 'Албанія',
 			'AM' => 'Вірменія',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктика',
 			'AR' => 'Аргентина',
 			'AS' => 'Американське Самоа',
 			'AT' => 'Австрія',
 			'AU' => 'Австралія',
 			'AW' => 'Аруба',
 			'AX' => 'Аландські Острови',
 			'AZ' => 'Азербайджан',
 			'BA' => 'Боснія і Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгія',
 			'BF' => 'Буркіна-Фасо',
 			'BG' => 'Болгарія',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунді',
 			'BJ' => 'Бенін',
 			'BL' => 'Сен-Бартелемі',
 			'BM' => 'Бермудські Острови',
 			'BN' => 'Бруней',
 			'BO' => 'Болівія',
 			'BQ' => 'Карибські Нідерланди',
 			'BR' => 'Бразилія',
 			'BS' => 'Багамські Острови',
 			'BT' => 'Бутан',
 			'BV' => 'Острів Буве',
 			'BW' => 'Ботсвана',
 			'BY' => 'Білорусь',
 			'BZ' => 'Беліз',
 			'CA' => 'Канада',
 			'CC' => 'Кокосові (Кілінг) Острови',
 			'CD' => 'Конго – Кіншаса',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Центральноафриканська Республіка',
 			'CG' => 'Конго – Браззавіль',
 			'CG@alt=variant' => 'Конго (Республіка)',
 			'CH' => 'Швейцарія',
 			'CI' => 'Кот-дʼІвуар',
 			'CI@alt=variant' => 'Берег Слонової Кістки',
 			'CK' => 'Острови Кука',
 			'CL' => 'Чилі',
 			'CM' => 'Камерун',
 			'CN' => 'Китай',
 			'CO' => 'Колумбія',
 			'CP' => 'Острів Кліппертон',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Острів Різдва',
 			'CY' => 'Кіпр',
 			'CZ' => 'Чехія',
 			'CZ@alt=variant' => 'Чеська Республіка',
 			'DE' => 'Німеччина',
 			'DG' => 'Дієго-Гарсія',
 			'DJ' => 'Джибуті',
 			'DK' => 'Данія',
 			'DM' => 'Домініка',
 			'DO' => 'Домініканська Республіка',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута і Мелілья',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонія',
 			'EG' => 'Єгипет',
 			'EH' => 'Західна Сахара',
 			'ER' => 'Еритрея',
 			'ES' => 'Іспанія',
 			'ET' => 'Ефіопія',
 			'EU' => 'Європейський Союз',
 			'EZ' => 'Єврозона',
 			'FI' => 'Фінляндія',
 			'FJ' => 'Фіджі',
 			'FK' => 'Фолклендські Острови',
 			'FK@alt=variant' => 'Фолклендські (Мальвінські) Острови',
 			'FM' => 'Мікронезія',
 			'FM@alt=variant' => 'Федеративні Штати Мікронезії',
 			'FO' => 'Фарерські Острови',
 			'FR' => 'Франція',
 			'GA' => 'Габон',
 			'GB' => 'Велика Британія',
 			'GD' => 'Гренада',
 			'GE' => 'Грузія',
 			'GF' => 'Французька Гвіана',
 			'GG' => 'Гернсі',
 			'GH' => 'Гана',
 			'GI' => 'Гібралтар',
 			'GL' => 'Гренландія',
 			'GM' => 'Гамбія',
 			'GN' => 'Гвінея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Екваторіальна Гвінея',
 			'GR' => 'Греція',
 			'GS' => 'Південна Джорджія та Південні Сандвічеві Острови',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвінея-Бісау',
 			'GY' => 'Гаяна',
 			'HK' => 'Гонконг, ОАР Китаю',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Острови Герд і Макдоналд',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватія',
 			'HT' => 'Гаїті',
 			'HU' => 'Угорщина',
 			'IC' => 'Канарські Острови',
 			'ID' => 'Індонезія',
 			'IE' => 'Ірландія',
 			'IL' => 'Ізраїль',
 			'IM' => 'Острів Мен',
 			'IN' => 'Індія',
 			'IO' => 'Британська територія в Індійському Океані',
 			'IQ' => 'Ірак',
 			'IR' => 'Іран',
 			'IS' => 'Ісландія',
 			'IT' => 'Італія',
 			'JE' => 'Джерсі',
 			'JM' => 'Ямайка',
 			'JO' => 'Йорданія',
 			'JP' => 'Японія',
 			'KE' => 'Кенія',
 			'KG' => 'Киргизстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кірибаті',
 			'KM' => 'Комори',
 			'KN' => 'Сент-Кітс і Невіс',
 			'KP' => 'Північна Корея',
 			'KR' => 'Південна Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайманові Острови',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ліван',
 			'LC' => 'Сент-Люсія',
 			'LI' => 'Ліхтенштейн',
 			'LK' => 'Шрі-Ланка',
 			'LR' => 'Ліберія',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвія',
 			'LY' => 'Лівія',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Чорногорія',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллові Острови',
 			'MK' => 'Північна Македонія',
 			'ML' => 'Малі',
 			'MM' => 'Мʼянма (Бірма)',
 			'MN' => 'Монголія',
 			'MO' => 'Макао, ОАР Китаю',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Північні Маріанські Острови',
 			'MQ' => 'Мартиніка',
 			'MR' => 'Мавританія',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикій',
 			'MV' => 'Мальдіви',
 			'MW' => 'Малаві',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзія',
 			'MZ' => 'Мозамбік',
 			'NA' => 'Намібія',
 			'NC' => 'Нова Каледонія',
 			'NE' => 'Нігер',
 			'NF' => 'Острів Норфолк',
 			'NG' => 'Нігерія',
 			'NI' => 'Нікарагуа',
 			'NL' => 'Нідерланди',
 			'NO' => 'Норвегія',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ніуе',
 			'NZ' => 'Нова Зеландія',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Французька Полінезія',
 			'PG' => 'Папуа-Нова Гвінея',
 			'PH' => 'Філіппіни',
 			'PK' => 'Пакистан',
 			'PL' => 'Польща',
 			'PM' => 'Сен-Пʼєр і Мікелон',
 			'PN' => 'Острови Піткерн',
 			'PR' => 'Пуерто-Рико',
 			'PS' => 'Палестинські території',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалія',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Віддалена Океанія',
 			'RE' => 'Реюньйон',
 			'RO' => 'Румунія',
 			'RS' => 'Сербія',
 			'RU' => 'Росія',
 			'RW' => 'Руанда',
 			'SA' => 'Саудівська Аравія',
 			'SB' => 'Соломонові Острови',
 			'SC' => 'Сейшельські Острови',
 			'SD' => 'Судан',
 			'SE' => 'Швеція',
 			'SG' => 'Сінгапур',
 			'SH' => 'Острів Святої Єлени',
 			'SI' => 'Словенія',
 			'SJ' => 'Шпіцберген та Ян-Маєн',
 			'SK' => 'Словаччина',
 			'SL' => 'Сьєрра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалі',
 			'SR' => 'Суринам',
 			'SS' => 'Південний Судан',
 			'ST' => 'Сан-Томе і Принсіпі',
 			'SV' => 'Сальвадор',
 			'SX' => 'Сінт-Мартен',
 			'SY' => 'Сирія',
 			'SZ' => 'Есватіні',
 			'SZ@alt=variant' => 'Свазіленд',
 			'TA' => 'Трістан-да-Кунья',
 			'TC' => 'Острови Теркс і Кайкос',
 			'TD' => 'Чад',
 			'TF' => 'Французькі Південні Території',
 			'TG' => 'Того',
 			'TH' => 'Таїланд',
 			'TJ' => 'Таджикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тімор-Лешті',
 			'TL@alt=variant' => 'Східний Тимор',
 			'TM' => 'Туркменістан',
 			'TN' => 'Туніс',
 			'TO' => 'Тонга',
 			'TR' => 'Туреччина',
 			'TT' => 'Тринідад і Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзанія',
 			'UA' => 'Україна',
 			'UG' => 'Уганда',
 			'UM' => 'Віддалені острови США',
 			'UN' => 'Організація Об’єднаних Націй',
 			'UN@alt=short' => 'ООН',
 			'US' => 'Сполучені Штати',
 			'US@alt=short' => 'США',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Вінсент і Гренадіни',
 			'VE' => 'Венесуела',
 			'VG' => 'Британські Віргінські острови',
 			'VI' => 'Віргінські Острови (США)',
 			'VN' => 'Вʼєтнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уолліс і Футуна',
 			'WS' => 'Самоа',
 			'XA' => 'Псевдоакценти',
 			'XB' => 'Псевдобіді',
 			'XK' => 'Косово',
 			'YE' => 'Ємен',
 			'YT' => 'Майотта',
 			'ZA' => 'Південно-Африканська Республіка',
 			'ZM' => 'Замбія',
 			'ZW' => 'Зімбабве',
 			'ZZ' => 'Невідомий регіон',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'Традиційна німецька орфографія',
 			'1994' => 'Стандартизована резьянська орфографія',
 			'1996' => 'Нова німецька орфографія з 1996 р.',
 			'1606NICT' => 'Пізньосередньофранцузська до 1606',
 			'1694ACAD' => 'Класична французька',
 			'1959ACAD' => 'Академічний',
 			'AREVELA' => 'Східновірменський',
 			'AREVMDA' => 'Західновірменський',
 			'BAKU1926' => 'Уніфікований турецький латинський алфавіт',
 			'BISKE' => 'Діалект Сан-Джорджіо/Біла',
 			'BOONT' => 'Бунтлінг',
 			'FONIPA' => 'Міжнародний фонетичний алфавіт',
 			'FONUPA' => 'Уральський фонетичний алфавіт',
 			'KKCOR' => 'Загальна орфографія',
 			'LIPAW' => 'Ліповазський діалект резьянської мови',
 			'MONOTON' => 'Монотонічний',
 			'NEDIS' => 'Натісонський діалект',
 			'NJIVA' => 'Діалект Нджіва',
 			'OSOJS' => 'Осоянський діалект',
 			'PINYIN' => 'Романізація піньїн',
 			'POLYTON' => 'Політонічний',
 			'POSIX' => 'Компʼютерний',
 			'REVISED' => 'Нова орфографія',
 			'ROZAJ' => 'Резьянський',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шотландська англійська',
 			'SCOUSE' => 'Ліверпульський діалект',
 			'SOLBA' => 'Діалект Столвіца/Солбіка',
 			'TARASK' => 'Орфографія Тараскевича',
 			'UCCOR' => 'Уніфікована орфографія',
 			'UCRCOR' => 'Уніфікована переглянута орфографія',
 			'VALENCIA' => 'Валенсійська',
 			'WADEGILE' => 'Романізація Вейда-Джайлза',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'календар',
 			'cf' => 'грошовий формат',
 			'colalternate' => 'ігнорувати сортування за символами',
 			'colbackwards' => 'зворотне сортування за діакритичними знаками',
 			'colcasefirst' => 'порядок верхнього/нижнього регістру',
 			'colcaselevel' => 'сортування з урахуванням регістру',
 			'collation' => 'порядок сортування',
 			'colnormalization' => 'уніфіковане сортування',
 			'colnumeric' => 'цифрове сортування',
 			'colstrength' => 'інтенсивність сортування',
 			'currency' => 'валюта',
 			'hc' => 'формат часу (12 або 24 години)',
 			'lb' => 'стиль розриву рядка',
 			'ms' => 'система вимірювання',
 			'numbers' => 'цифри',
 			'timezone' => 'часовий пояс',
 			'va' => 'варіант мовного коду',
 			'x' => 'особисте використання',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{буддійський календар},
 				'chinese' => q{китайський календар},
 				'coptic' => q{коптський календар},
 				'dangi' => q{корейський календар},
 				'ethiopic' => q{ефіопський календар},
 				'ethiopic-amete-alem' => q{ефіопський амете алем календар},
 				'gregorian' => q{григоріанський календар},
 				'hebrew' => q{єврейський календар},
 				'indian' => q{індійський світський календар},
 				'islamic' => q{ісламський календар},
 				'islamic-civil' => q{мусульманський світський календар},
 				'islamic-rgsa' => q{ісламський календар Саудівської Аравії},
 				'islamic-tbla' => q{ісламський астрономічний календар},
 				'islamic-umalqura' => q{ісламський календар (Умм аль-Кура)},
 				'iso8601' => q{календар ISO-8601},
 				'japanese' => q{японський календар},
 				'persian' => q{перський календар},
 				'roc' => q{календар Китайської Республіки},
 			},
 			'cf' => {
 				'account' => q{обліковий грошовий формат},
 				'standard' => q{стандартний грошовий формат},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{сортувати за символами},
 				'shifted' => q{сортувати, ігноруючи символи},
 			},
 			'colbackwards' => {
 				'no' => q{сортувати за діакритичними знаками уніфіковано},
 				'yes' => q{сортувати за діактричними знаками у зворотньому порядку},
 			},
 			'colcasefirst' => {
 				'lower' => q{сортувати нижній регістр наперед},
 				'no' => q{сортувати в порядку звичайного регістру},
 				'upper' => q{сортувати спершу за великими символами},
 			},
 			'colcaselevel' => {
 				'no' => q{сортувати без урахування регістру},
 				'yes' => q{сортувати з урахуванням регістру},
 			},
 			'collation' => {
 				'big5han' => q{китайський традиційний порядок сортування Big5},
 				'compat' => q{попередній порядок сортування, для сумісності},
 				'dictionary' => q{порядок сортування за словником},
 				'ducet' => q{типовий порядок сортування Юнікод},
 				'emoji' => q{порядок сортування за емодзі},
 				'eor' => q{європейські правила упорядкування},
 				'gb2312han' => q{китайський спрощений},
 				'phonebook' => q{порядок сортування за телефонним довідником},
 				'phonetic' => q{фонетичний порядок сортування},
 				'pinyin' => q{порядок сортування піньїнь},
 				'reformed' => q{реформований порядок сортування},
 				'search' => q{універсальний пошук},
 				'searchjl' => q{пошук за початковою приголосною хангул},
 				'standard' => q{стандартний порядок сортування},
 				'stroke' => q{порядок сортування за рисками},
 				'traditional' => q{традиційний порядок сортування},
 				'unihan' => q{порядок сортування за ключами ієрогліфів},
 				'zhuyin' => q{порядок сортування чжуїнь},
 			},
 			'colnormalization' => {
 				'no' => q{сортувати без уніфікації},
 				'yes' => q{сортувати за Unicode уніфіковано},
 			},
 			'colnumeric' => {
 				'no' => q{сортувати цифри окремо},
 				'yes' => q{сортувати за цифрами чисельно},
 			},
 			'colstrength' => {
 				'identical' => q{сортувати всі},
 				'primary' => q{сортувати лише за основними літерами},
 				'quaternary' => q{сортувати за діактричними знаками/регістром/шириною/кана},
 				'secondary' => q{сортувати за діактричними знаками},
 				'tertiary' => q{сортувати за діактричними знаками/регістром/шириною},
 			},
 			'd0' => {
 				'fwidth' => q{повна ширина},
 				'hwidth' => q{половинна ширина},
 				'npinyin' => q{цифри},
 			},
 			'hc' => {
 				'h11' => q{12-годинний формат (0–11)},
 				'h12' => q{12-годинний формат (1–12)},
 				'h23' => q{24-годинний формат (0–23)},
 				'h24' => q{24-годинний формат (1–24)},
 			},
 			'lb' => {
 				'loose' => q{неточний стиль розриву рядка},
 				'normal' => q{звичайний стиль розриву рядка},
 				'strict' => q{точний стиль розриву рядка},
 			},
 			'm0' => {
 				'bgn' => q{транслітерація РГН США},
 				'ungegn' => q{транслітерація ГЕГН ООН},
 			},
 			'ms' => {
 				'metric' => q{мертична система},
 				'uksystem' => q{англійська система мір},
 				'ussystem' => q{американська система мір},
 			},
 			'numbers' => {
 				'arab' => q{арабсько-індійські цифри},
 				'arabext' => q{арабсько-індійські розширені цифри},
 				'armn' => q{вірменські цифри},
 				'armnlow' => q{вірменські малі цифри},
 				'beng' => q{бенґальські цифри},
 				'deva' => q{цифри деванагарі},
 				'ethi' => q{ефіопські цифри},
 				'finance' => q{фінансові символи чисел},
 				'fullwide' => q{цифри повної ширини},
 				'geor' => q{грузинські цифри},
 				'grek' => q{грецькі цифри},
 				'greklow' => q{грецькі малі цифри},
 				'gujr' => q{цифри гуджараті},
 				'guru' => q{цифри гурмукхі},
 				'hanidec' => q{китайські десяткові цифри},
 				'hans' => q{китайські символи чисел (спрощене письмо)},
 				'hansfin' => q{китайські фінансові символи чисел (спрощене письмо)},
 				'hant' => q{китайські символи чисел (традиційне письмо)},
 				'hantfin' => q{китайські фінансові символи чисел (традиційне письмо)},
 				'hebr' => q{цифри івриту},
 				'jpan' => q{японські цифри},
 				'jpanfin' => q{японські фінансові цифри},
 				'khmr' => q{кхмерські цифри},
 				'knda' => q{цифри каннада},
 				'laoo' => q{лаоські цифри},
 				'latn' => q{західні цифри},
 				'mlym' => q{малаяламські цифри},
 				'mong' => q{монгольські цифри},
 				'mymr' => q{мʼянмські цифри},
 				'native' => q{місцеві цифри},
 				'orya' => q{цифри орія},
 				'roman' => q{римські цифри},
 				'romanlow' => q{римські малі цифри},
 				'taml' => q{тамільські традиційні цифри},
 				'tamldec' => q{тамільські цифри},
 				'telu' => q{цифри телугу},
 				'thai' => q{тайські цифри},
 				'tibt' => q{тибетські цифри},
 				'traditional' => q{традиційні символи чисел},
 				'vaii' => q{цифри ваї},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{Метрична},
 			'UK' => q{Британська},
 			'US' => q{Американська},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Мова: {0}',
 			'script' => 'Система письма: {0}',
 			'region' => 'Територія: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[{а́} {е́} ё {є́} {и́} {і́} {ї́} {о́} {у́} ъ ы э {ю́} {я́}]},
			index => ['А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Є', 'Ж', 'З', 'И', 'І', 'Ї', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ю', 'Я'],
			main => qr{[а б в г ґ д е є ж з и і ї й к л м н о п р с т у ф х ц ч ш щ ь ю я ʼ]},
			numbers => qr{[  \- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‑ – , ; \: ! ? . ' ’ " “ „ « » ( ) \[ \] \{ \} § @ * / \\ №]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Є', 'Ж', 'З', 'И', 'І', 'Ї', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0}…',
			'word-initial' => '…{0}',
			'word-medial' => '{0}…{1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(сторона світу),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(сторона світу),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(кібі{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(кібі{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(мебі{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(мебі{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(гібі{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(гібі{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(тебі{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(тебі{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(пебі{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(пебі{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ексбі{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ексбі{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(зебі{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(зебі{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(йобі{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(йобі{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(деци{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(деци{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(піко{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(піко{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(фемто{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(фемто{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ато{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ато{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(санти{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(санти{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зепто{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зепто{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(йокто{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(йокто{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(мілі{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(мілі{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(мікро{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(мікро{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(нано{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(нано{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(екса{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(екса{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(гекто{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(гекто{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(зета{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(зета{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(йота{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(йота{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(кіло{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(кіло{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(гіга{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(гіга{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'1' => q(neuter),
						'few' => q({0} g),
						'many' => q({0} g),
						'name' => q(прискорення вільного падіння),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					# Core Unit Identifier
					'g-force' => {
						'1' => q(neuter),
						'few' => q({0} g),
						'many' => q({0} g),
						'name' => q(прискорення вільного падіння),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'few' => q({0} метри на секунду у квадраті),
						'many' => q({0} метрів на секунду у квадраті),
						'name' => q(метри на секунду у квадраті),
						'one' => q({0} метр на секунду у квадраті),
						'other' => q({0} метра на секунду у квадраті),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'few' => q({0} метри на секунду у квадраті),
						'many' => q({0} метрів на секунду у квадраті),
						'name' => q(метри на секунду у квадраті),
						'one' => q({0} метр на секунду у квадраті),
						'other' => q({0} метра на секунду у квадраті),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'1' => q(feminine),
						'few' => q({0} кутові мінути),
						'many' => q({0} кутових мінут),
						'name' => q(кутові мінути),
						'one' => q({0} кутова мінута),
						'other' => q({0} кутової мінути),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'1' => q(feminine),
						'few' => q({0} кутові мінути),
						'many' => q({0} кутових мінут),
						'name' => q(кутові мінути),
						'one' => q({0} кутова мінута),
						'other' => q({0} кутової мінути),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'1' => q(feminine),
						'few' => q({0} кутові секунди),
						'many' => q({0} кутових секунд),
						'name' => q(кутові секунди),
						'one' => q({0} кутова секунда),
						'other' => q({0} кутової секунди),
					},
					# Core Unit Identifier
					'arc-second' => {
						'1' => q(feminine),
						'few' => q({0} кутові секунди),
						'many' => q({0} кутових секунд),
						'name' => q(кутові секунди),
						'one' => q({0} кутова секунда),
						'other' => q({0} кутової секунди),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'1' => q(masculine),
						'few' => q({0} градуси),
						'many' => q({0} градусів),
						'name' => q(градуси),
						'one' => q({0} градус),
						'other' => q({0} градуса),
					},
					# Core Unit Identifier
					'degree' => {
						'1' => q(masculine),
						'few' => q({0} градуси),
						'many' => q({0} градусів),
						'name' => q(градуси),
						'one' => q({0} градус),
						'other' => q({0} градуса),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'1' => q(masculine),
						'few' => q({0} радіани),
						'many' => q({0} радіанів),
						'name' => q(радіани),
						'one' => q({0} радіан),
						'other' => q({0} радіана),
					},
					# Core Unit Identifier
					'radian' => {
						'1' => q(masculine),
						'few' => q({0} радіани),
						'many' => q({0} радіанів),
						'name' => q(радіани),
						'one' => q({0} радіан),
						'other' => q({0} радіана),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'1' => q(masculine),
						'few' => q({0} оберти),
						'many' => q({0} обертів),
						'name' => q(оберти),
						'one' => q({0} оберт),
						'other' => q({0} оберта),
					},
					# Core Unit Identifier
					'revolution' => {
						'1' => q(masculine),
						'few' => q({0} оберти),
						'many' => q({0} обертів),
						'name' => q(оберти),
						'one' => q({0} оберт),
						'other' => q({0} оберта),
					},
					# Long Unit Identifier
					'area-acre' => {
						'few' => q({0} акри),
						'many' => q({0} акрів),
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акра),
					},
					# Core Unit Identifier
					'acre' => {
						'few' => q({0} акри),
						'many' => q({0} акрів),
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акра),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'few' => q({0} дунами),
						'many' => q({0} дунамів),
						'name' => q(дунами),
						'one' => q({0} дунам),
						'other' => q({0} дунама),
					},
					# Core Unit Identifier
					'dunam' => {
						'few' => q({0} дунами),
						'many' => q({0} дунамів),
						'name' => q(дунами),
						'one' => q({0} дунам),
						'other' => q({0} дунама),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'1' => q(masculine),
						'few' => q({0} гектари),
						'many' => q({0} гектарів),
						'name' => q(гектари),
						'one' => q({0} гектар),
						'other' => q({0} гектара),
					},
					# Core Unit Identifier
					'hectare' => {
						'1' => q(masculine),
						'few' => q({0} гектари),
						'many' => q({0} гектарів),
						'name' => q(гектари),
						'one' => q({0} гектар),
						'other' => q({0} гектара),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'few' => q({0} квадратні сантиметри),
						'many' => q({0} квадратних сантиметрів),
						'name' => q(квадратні сантиметри),
						'one' => q({0} квадратний сантиметр),
						'other' => q({0} квадратного сантиметра),
						'per' => q({0} на квадратний сантиметр),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'few' => q({0} квадратні сантиметри),
						'many' => q({0} квадратних сантиметрів),
						'name' => q(квадратні сантиметри),
						'one' => q({0} квадратний сантиметр),
						'other' => q({0} квадратного сантиметра),
						'per' => q({0} на квадратний сантиметр),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'few' => q({0} квадратні фути),
						'many' => q({0} квадратних футів),
						'name' => q(квадратні фути),
						'one' => q({0} квадратний фут),
						'other' => q({0} квадратного фута),
					},
					# Core Unit Identifier
					'square-foot' => {
						'few' => q({0} квадратні фути),
						'many' => q({0} квадратних футів),
						'name' => q(квадратні фути),
						'one' => q({0} квадратний фут),
						'other' => q({0} квадратного фута),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'few' => q({0} квадратні дюйми),
						'many' => q({0} квадратних дюймів),
						'name' => q(квадратні дюйми),
						'one' => q({0} квадратний дюйм),
						'other' => q({0} квадратного дюйма),
						'per' => q({0} квадратний дюйм),
					},
					# Core Unit Identifier
					'square-inch' => {
						'few' => q({0} квадратні дюйми),
						'many' => q({0} квадратних дюймів),
						'name' => q(квадратні дюйми),
						'one' => q({0} квадратний дюйм),
						'other' => q({0} квадратного дюйма),
						'per' => q({0} квадратний дюйм),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'few' => q({0} квадратні кілометри),
						'many' => q({0} квадратних кілометрів),
						'name' => q(квадратні кілометри),
						'one' => q({0} квадратний кілометр),
						'other' => q({0} квадратного кілометра),
						'per' => q({0} на квадратний кілометр),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'few' => q({0} квадратні кілометри),
						'many' => q({0} квадратних кілометрів),
						'name' => q(квадратні кілометри),
						'one' => q({0} квадратний кілометр),
						'other' => q({0} квадратного кілометра),
						'per' => q({0} на квадратний кілометр),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'few' => q({0} квадратні метри),
						'many' => q({0} квадратних метрів),
						'name' => q(квадтратні метри),
						'one' => q({0} квадратний метр),
						'other' => q({0} квадратного метра),
						'per' => q({0} на квадратний метр),
					},
					# Core Unit Identifier
					'square-meter' => {
						'few' => q({0} квадратні метри),
						'many' => q({0} квадратних метрів),
						'name' => q(квадтратні метри),
						'one' => q({0} квадратний метр),
						'other' => q({0} квадратного метра),
						'per' => q({0} на квадратний метр),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'few' => q({0} квадратні милі),
						'many' => q({0} квадратних миль),
						'name' => q(квадратні милі),
						'one' => q({0} квадратна миля),
						'other' => q({0} квадратної милі),
						'per' => q({0} на квадратну милю),
					},
					# Core Unit Identifier
					'square-mile' => {
						'few' => q({0} квадратні милі),
						'many' => q({0} квадратних миль),
						'name' => q(квадратні милі),
						'one' => q({0} квадратна миля),
						'other' => q({0} квадратної милі),
						'per' => q({0} на квадратну милю),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'few' => q({0} квадратні ярди),
						'many' => q({0} квадратних ярдів),
						'name' => q(квадратні ярди),
						'one' => q({0} квадратний ярд),
						'other' => q({0} квадратного ярда),
					},
					# Core Unit Identifier
					'square-yard' => {
						'few' => q({0} квадратні ярди),
						'many' => q({0} квадратних ярдів),
						'name' => q(квадратні ярди),
						'one' => q({0} квадратний ярд),
						'other' => q({0} квадратного ярда),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'few' => q({0} елементи),
						'many' => q({0} елементів),
						'name' => q(елементи),
						'one' => q({0} елемент),
						'other' => q({0} елемента),
					},
					# Core Unit Identifier
					'item' => {
						'few' => q({0} елементи),
						'many' => q({0} елементів),
						'name' => q(елементи),
						'one' => q({0} елемент),
						'other' => q({0} елемента),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'1' => q(masculine),
						'few' => q({0} карати),
						'many' => q({0} каратів),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Core Unit Identifier
					'karat' => {
						'1' => q(masculine),
						'few' => q({0} карати),
						'many' => q({0} каратів),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'few' => q({0} міліграми на децилітр),
						'many' => q({0} міліграмів на децилітр),
						'name' => q(міліграми на децилітр),
						'one' => q({0} міліграм на децилітр),
						'other' => q({0} міліграма на децилітр),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'few' => q({0} міліграми на децилітр),
						'many' => q({0} міліграмів на децилітр),
						'name' => q(міліграми на децилітр),
						'one' => q({0} міліграм на децилітр),
						'other' => q({0} міліграма на децилітр),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'few' => q({0} мілімолі на літр),
						'many' => q({0} мілімолів на літр),
						'name' => q(мілімолі на літр),
						'one' => q({0} мілімоль на літр),
						'other' => q({0} мілімоля на літр),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'few' => q({0} мілімолі на літр),
						'many' => q({0} мілімолів на літр),
						'name' => q(мілімолі на літр),
						'one' => q({0} мілімоль на літр),
						'other' => q({0} мілімоля на літр),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'1' => q(masculine),
						'few' => q({0} молі),
						'many' => q({0} молів),
						'name' => q(молі),
						'one' => q({0} моль),
						'other' => q({0} моля),
					},
					# Core Unit Identifier
					'mole' => {
						'1' => q(masculine),
						'few' => q({0} молі),
						'many' => q({0} молів),
						'name' => q(молі),
						'one' => q({0} моль),
						'other' => q({0} моля),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'1' => q(masculine),
						'few' => q({0} відсотки),
						'many' => q({0} відсотків),
						'name' => q(відсоток),
						'one' => q({0} відсоток),
						'other' => q({0} відсотка),
					},
					# Core Unit Identifier
					'percent' => {
						'1' => q(masculine),
						'few' => q({0} відсотки),
						'many' => q({0} відсотків),
						'name' => q(відсоток),
						'one' => q({0} відсоток),
						'other' => q({0} відсотка),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'1' => q(masculine),
						'few' => q({0} проміле),
						'many' => q({0} проміле),
						'name' => q(проміле),
						'one' => q({0} проміле),
						'other' => q({0} проміле),
					},
					# Core Unit Identifier
					'permille' => {
						'1' => q(masculine),
						'few' => q({0} проміле),
						'many' => q({0} проміле),
						'name' => q(проміле),
						'one' => q({0} проміле),
						'other' => q({0} проміле),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'1' => q(feminine),
						'few' => q({0} мільйонні долі),
						'many' => q({0} мільйонних доль),
						'name' => q(мільйонні долі),
						'one' => q({0} мільйонна доля),
						'other' => q({0} мільйонної долі),
					},
					# Core Unit Identifier
					'permillion' => {
						'1' => q(feminine),
						'few' => q({0} мільйонні долі),
						'many' => q({0} мільйонних доль),
						'name' => q(мільйонні долі),
						'one' => q({0} мільйонна доля),
						'other' => q({0} мільйонної долі),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'1' => q(feminine),
						'few' => q({0} проміріади),
						'many' => q({0} проміріад),
						'name' => q(проміріада),
						'one' => q({0} проміріада),
						'other' => q({0} проміріади),
					},
					# Core Unit Identifier
					'permyriad' => {
						'1' => q(feminine),
						'few' => q({0} проміріади),
						'many' => q({0} проміріад),
						'name' => q(проміріада),
						'one' => q({0} проміріада),
						'other' => q({0} проміріади),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'few' => q({0} літри на 100 кілометрів),
						'many' => q({0} літрів на 100 кілометрів),
						'name' => q(літри на 100 кілометрів),
						'one' => q({0} літр на 100 кілометрів),
						'other' => q({0} літра на 100 кілометрів),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'few' => q({0} літри на 100 кілометрів),
						'many' => q({0} літрів на 100 кілометрів),
						'name' => q(літри на 100 кілометрів),
						'one' => q({0} літр на 100 кілометрів),
						'other' => q({0} літра на 100 кілометрів),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'few' => q({0} літри на кілометр),
						'many' => q({0} літрів на кілометр),
						'name' => q(літри на кілометр),
						'one' => q({0} літр на кілометр),
						'other' => q({0} літра на кілометр),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'few' => q({0} літри на кілометр),
						'many' => q({0} літрів на кілометр),
						'name' => q(літри на кілометр),
						'one' => q({0} літр на кілометр),
						'other' => q({0} літра на кілометр),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'few' => q({0} милі на галон),
						'many' => q({0} миль на галон),
						'name' => q(милі на галон),
						'one' => q({0} миля на галон),
						'other' => q({0} милі на галон),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'few' => q({0} милі на галон),
						'many' => q({0} миль на галон),
						'name' => q(милі на галон),
						'one' => q({0} миля на галон),
						'other' => q({0} милі на галон),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'few' => q({0} милі на англійський галон),
						'many' => q({0} миль на англійський галон),
						'name' => q(милі на англійський галон),
						'one' => q({0} миля на англійський галон),
						'other' => q({0} милі на англійський галон),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'few' => q({0} милі на англійський галон),
						'many' => q({0} миль на англійський галон),
						'name' => q(милі на англійський галон),
						'one' => q({0} миля на англійський галон),
						'other' => q({0} милі на англійський галон),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} східної довготи),
						'north' => q({0} північної широти),
						'south' => q({0} південної широти),
						'west' => q({0} західної довготи),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} східної довготи),
						'north' => q({0} північної широти),
						'south' => q({0} південної широти),
						'west' => q({0} західної довготи),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'1' => q(masculine),
						'few' => q({0} біти),
						'many' => q({0} бітів),
						'name' => q(біти),
						'one' => q({0} біт),
						'other' => q({0} біта),
					},
					# Core Unit Identifier
					'bit' => {
						'1' => q(masculine),
						'few' => q({0} біти),
						'many' => q({0} бітів),
						'name' => q(біти),
						'one' => q({0} біт),
						'other' => q({0} біта),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'1' => q(masculine),
						'few' => q({0} байти),
						'many' => q({0} байтів),
						'name' => q(байти),
						'one' => q({0} байт),
						'other' => q({0} байта),
					},
					# Core Unit Identifier
					'byte' => {
						'1' => q(masculine),
						'few' => q({0} байти),
						'many' => q({0} байтів),
						'name' => q(байти),
						'one' => q({0} байт),
						'other' => q({0} байта),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'few' => q({0} гігабіти),
						'many' => q({0} гігабітів),
						'name' => q(гігабіти),
						'one' => q({0} гігабіт),
						'other' => q({0} гігабіта),
					},
					# Core Unit Identifier
					'gigabit' => {
						'few' => q({0} гігабіти),
						'many' => q({0} гігабітів),
						'name' => q(гігабіти),
						'one' => q({0} гігабіт),
						'other' => q({0} гігабіта),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'few' => q({0} гігабайти),
						'many' => q({0} гігабайтів),
						'name' => q(гігабайти),
						'one' => q({0} гігабайт),
						'other' => q({0} гігабайта),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'few' => q({0} гігабайти),
						'many' => q({0} гігабайтів),
						'name' => q(гігабайти),
						'one' => q({0} гігабайт),
						'other' => q({0} гігабайта),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'few' => q({0} кілобіти),
						'many' => q({0} кілобітів),
						'name' => q(кілобіти),
						'one' => q({0} кілобіт),
						'other' => q({0} кілобіта),
					},
					# Core Unit Identifier
					'kilobit' => {
						'few' => q({0} кілобіти),
						'many' => q({0} кілобітів),
						'name' => q(кілобіти),
						'one' => q({0} кілобіт),
						'other' => q({0} кілобіта),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'few' => q({0} кілобайти),
						'many' => q({0} кілобайтів),
						'name' => q(кілобайти),
						'one' => q({0} кілобайт),
						'other' => q({0} кілобайта),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'few' => q({0} кілобайти),
						'many' => q({0} кілобайтів),
						'name' => q(кілобайти),
						'one' => q({0} кілобайт),
						'other' => q({0} кілобайта),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'few' => q({0} мегабіти),
						'many' => q({0} мегабітів),
						'name' => q(мегабіти),
						'one' => q({0} мегабіт),
						'other' => q({0} мегабіта),
					},
					# Core Unit Identifier
					'megabit' => {
						'few' => q({0} мегабіти),
						'many' => q({0} мегабітів),
						'name' => q(мегабіти),
						'one' => q({0} мегабіт),
						'other' => q({0} мегабіта),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'few' => q({0} мегабайти),
						'many' => q({0} мегабайтів),
						'name' => q(мегабайти),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайта),
					},
					# Core Unit Identifier
					'megabyte' => {
						'few' => q({0} мегабайти),
						'many' => q({0} мегабайтів),
						'name' => q(мегабайти),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайта),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'few' => q({0} петабайти),
						'many' => q({0} петабайтів),
						'name' => q(петабайти),
						'one' => q({0} петабайт),
						'other' => q({0} петабайта),
					},
					# Core Unit Identifier
					'petabyte' => {
						'few' => q({0} петабайти),
						'many' => q({0} петабайтів),
						'name' => q(петабайти),
						'one' => q({0} петабайт),
						'other' => q({0} петабайта),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'few' => q({0} терабіти),
						'many' => q({0} терабітів),
						'name' => q(терабіти),
						'one' => q({0} терабіт),
						'other' => q({0} терабіта),
					},
					# Core Unit Identifier
					'terabit' => {
						'few' => q({0} терабіти),
						'many' => q({0} терабітів),
						'name' => q(терабіти),
						'one' => q({0} терабіт),
						'other' => q({0} терабіта),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'few' => q({0} терабайти),
						'many' => q({0} терабайтів),
						'name' => q(терабайти),
						'one' => q({0} терабайт),
						'other' => q({0} терабайта),
					},
					# Core Unit Identifier
					'terabyte' => {
						'few' => q({0} терабайти),
						'many' => q({0} терабайтів),
						'name' => q(терабайти),
						'one' => q({0} терабайт),
						'other' => q({0} терабайта),
					},
					# Long Unit Identifier
					'duration-century' => {
						'1' => q(neuter),
						'few' => q({0} століття),
						'many' => q({0} століть),
						'name' => q(століття),
						'one' => q({0} століття),
						'other' => q({0} століття),
					},
					# Core Unit Identifier
					'century' => {
						'1' => q(neuter),
						'few' => q({0} століття),
						'many' => q({0} століть),
						'name' => q(століття),
						'one' => q({0} століття),
						'other' => q({0} століття),
					},
					# Long Unit Identifier
					'duration-day' => {
						'1' => q(masculine),
						'few' => q({0} дні),
						'many' => q({0} днів),
						'name' => q(дні),
						'one' => q({0} день),
						'other' => q({0} дня),
						'per' => q({0} на день),
					},
					# Core Unit Identifier
					'day' => {
						'1' => q(masculine),
						'few' => q({0} дні),
						'many' => q({0} днів),
						'name' => q(дні),
						'one' => q({0} день),
						'other' => q({0} дня),
						'per' => q({0} на день),
					},
					# Long Unit Identifier
					'duration-day-person' => {
						'1' => q(masculine),
						'few' => q({0} дні),
						'many' => q({0} днів),
						'one' => q({0} день),
						'other' => q({0} дня),
					},
					# Core Unit Identifier
					'day-person' => {
						'1' => q(masculine),
						'few' => q({0} дні),
						'many' => q({0} днів),
						'one' => q({0} день),
						'other' => q({0} дня),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'1' => q(neuter),
						'few' => q({0} десятиріччя),
						'many' => q({0} десятиріч),
						'name' => q(десятиріччя),
						'one' => q({0} десятиріччя),
						'other' => q({0} десятиріччя),
					},
					# Core Unit Identifier
					'decade' => {
						'1' => q(neuter),
						'few' => q({0} десятиріччя),
						'many' => q({0} десятиріч),
						'name' => q(десятиріччя),
						'one' => q({0} десятиріччя),
						'other' => q({0} десятиріччя),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'1' => q(feminine),
						'few' => q({0} години),
						'many' => q({0} годин),
						'name' => q(години),
						'one' => q({0} година),
						'other' => q({0} години),
						'per' => q({0} на годину),
					},
					# Core Unit Identifier
					'hour' => {
						'1' => q(feminine),
						'few' => q({0} години),
						'many' => q({0} годин),
						'name' => q(години),
						'one' => q({0} година),
						'other' => q({0} години),
						'per' => q({0} на годину),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'few' => q({0} мікросекунди),
						'many' => q({0} мікросекунд),
						'name' => q(мікросекунди),
						'one' => q({0} мікросекунда),
						'other' => q({0} мікросекунди),
					},
					# Core Unit Identifier
					'microsecond' => {
						'few' => q({0} мікросекунди),
						'many' => q({0} мікросекунд),
						'name' => q(мікросекунди),
						'one' => q({0} мікросекунда),
						'other' => q({0} мікросекунди),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'few' => q({0} мілісекунди),
						'many' => q({0} мілісекунд),
						'name' => q(мілісекунди),
						'one' => q({0} мілісекунда),
						'other' => q({0} мілісекунди),
					},
					# Core Unit Identifier
					'millisecond' => {
						'few' => q({0} мілісекунди),
						'many' => q({0} мілісекунд),
						'name' => q(мілісекунди),
						'one' => q({0} мілісекунда),
						'other' => q({0} мілісекунди),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'1' => q(feminine),
						'few' => q({0} хвилини),
						'many' => q({0} хвилин),
						'name' => q(хвилини),
						'one' => q({0} хвилина),
						'other' => q({0} хвилини),
						'per' => q({0} на хвилину),
					},
					# Core Unit Identifier
					'minute' => {
						'1' => q(feminine),
						'few' => q({0} хвилини),
						'many' => q({0} хвилин),
						'name' => q(хвилини),
						'one' => q({0} хвилина),
						'other' => q({0} хвилини),
						'per' => q({0} на хвилину),
					},
					# Long Unit Identifier
					'duration-month' => {
						'1' => q(masculine),
						'few' => q({0} місяці),
						'many' => q({0} місяців),
						'name' => q(місяці),
						'one' => q({0} місяць),
						'other' => q({0} місяця),
						'per' => q({0} на місяць),
					},
					# Core Unit Identifier
					'month' => {
						'1' => q(masculine),
						'few' => q({0} місяці),
						'many' => q({0} місяців),
						'name' => q(місяці),
						'one' => q({0} місяць),
						'other' => q({0} місяця),
						'per' => q({0} на місяць),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'few' => q({0} наносекунди),
						'many' => q({0} наносекунд),
						'name' => q(наносекунди),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'few' => q({0} наносекунди),
						'many' => q({0} наносекунд),
						'name' => q(наносекунди),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					# Long Unit Identifier
					'duration-second' => {
						'1' => q(feminine),
						'few' => q({0} секунди),
						'many' => q({0} секунд),
						'name' => q(секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0} на секунду),
					},
					# Core Unit Identifier
					'second' => {
						'1' => q(feminine),
						'few' => q({0} секунди),
						'many' => q({0} секунд),
						'name' => q(секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0} на секунду),
					},
					# Long Unit Identifier
					'duration-week' => {
						'1' => q(masculine),
						'few' => q({0} тижні),
						'many' => q({0} тижнів),
						'name' => q(тижні),
						'one' => q({0} тиждень),
						'other' => q({0} тижня),
						'per' => q({0} на тиждень),
					},
					# Core Unit Identifier
					'week' => {
						'1' => q(masculine),
						'few' => q({0} тижні),
						'many' => q({0} тижнів),
						'name' => q(тижні),
						'one' => q({0} тиждень),
						'other' => q({0} тижня),
						'per' => q({0} на тиждень),
					},
					# Long Unit Identifier
					'duration-year' => {
						'1' => q(masculine),
						'few' => q({0} роки),
						'many' => q({0} років),
						'name' => q(роки),
						'one' => q({0} рік),
						'other' => q({0} року),
						'per' => q({0} на рік),
					},
					# Core Unit Identifier
					'year' => {
						'1' => q(masculine),
						'few' => q({0} роки),
						'many' => q({0} років),
						'name' => q(роки),
						'one' => q({0} рік),
						'other' => q({0} року),
						'per' => q({0} на рік),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'1' => q(masculine),
						'few' => q({0} ампери),
						'many' => q({0} амперів),
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					# Core Unit Identifier
					'ampere' => {
						'1' => q(masculine),
						'few' => q({0} ампери),
						'many' => q({0} амперів),
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'few' => q({0} міліампери),
						'many' => q({0} міліамперів),
						'name' => q(міліампери),
						'one' => q({0} міліампер),
						'other' => q({0} міліампера),
					},
					# Core Unit Identifier
					'milliampere' => {
						'few' => q({0} міліампери),
						'many' => q({0} міліамперів),
						'name' => q(міліампери),
						'one' => q({0} міліампер),
						'other' => q({0} міліампера),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'1' => q(masculine),
						'few' => q({0} оми),
						'many' => q({0} омів),
						'name' => q(оми),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					# Core Unit Identifier
					'ohm' => {
						'1' => q(masculine),
						'few' => q({0} оми),
						'many' => q({0} омів),
						'name' => q(оми),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'1' => q(masculine),
						'few' => q({0} вольти),
						'many' => q({0} вольтів),
						'name' => q(вольти),
						'one' => q({0} вольт),
						'other' => q({0} вольта),
					},
					# Core Unit Identifier
					'volt' => {
						'1' => q(masculine),
						'few' => q({0} вольти),
						'many' => q({0} вольтів),
						'name' => q(вольти),
						'one' => q({0} вольт),
						'other' => q({0} вольта),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'few' => q({0} одиниці теплові британські),
						'many' => q({0} одиниць теплових британських),
						'name' => q(одиниці теплові британські),
						'one' => q({0} одиниця теплова британська),
						'other' => q({0} одиниці теплової британської),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'few' => q({0} одиниці теплові британські),
						'many' => q({0} одиниць теплових британських),
						'name' => q(одиниці теплові британські),
						'one' => q({0} одиниця теплова британська),
						'other' => q({0} одиниці теплової британської),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'1' => q(feminine),
						'few' => q({0} калорії),
						'many' => q({0} калорій),
						'name' => q(калорії),
						'one' => q({0} калорія),
						'other' => q({0} калорії),
					},
					# Core Unit Identifier
					'calorie' => {
						'1' => q(feminine),
						'few' => q({0} калорії),
						'many' => q({0} калорій),
						'name' => q(калорії),
						'one' => q({0} калорія),
						'other' => q({0} калорії),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'few' => q({0} електрон-вольти),
						'many' => q({0} електрон-вольтів),
						'name' => q(електрон-вольти),
						'one' => q({0} електрон-вольт),
						'other' => q({0} електрон-вольта),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'few' => q({0} електрон-вольти),
						'many' => q({0} електрон-вольтів),
						'name' => q(електрон-вольти),
						'one' => q({0} електрон-вольт),
						'other' => q({0} електрон-вольта),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'few' => q({0} кілокалорії),
						'many' => q({0} кілокалорій),
						'name' => q(кілокалорії),
						'one' => q({0} кілокалорія),
						'other' => q({0} кілокалорії),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'few' => q({0} кілокалорії),
						'many' => q({0} кілокалорій),
						'name' => q(кілокалорії),
						'one' => q({0} кілокалорія),
						'other' => q({0} кілокалорії),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'1' => q(masculine),
						'few' => q({0} джоулі),
						'many' => q({0} джоулів),
						'name' => q(джоулі),
						'one' => q({0} джоуль),
						'other' => q({0} джоуля),
					},
					# Core Unit Identifier
					'joule' => {
						'1' => q(masculine),
						'few' => q({0} джоулі),
						'many' => q({0} джоулів),
						'name' => q(джоулі),
						'one' => q({0} джоуль),
						'other' => q({0} джоуля),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'few' => q({0} кілокалорії),
						'many' => q({0} кілокалорій),
						'name' => q(кілокалорії),
						'one' => q({0} кілокалорія),
						'other' => q({0} кілокалорії),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'few' => q({0} кілокалорії),
						'many' => q({0} кілокалорій),
						'name' => q(кілокалорії),
						'one' => q({0} кілокалорія),
						'other' => q({0} кілокалорії),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'few' => q({0} кілоджоулі),
						'many' => q({0} кілоджоулів),
						'name' => q(кілоджоулі),
						'one' => q({0} кілоджоуль),
						'other' => q({0} кілоджоуля),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'few' => q({0} кілоджоулі),
						'many' => q({0} кілоджоулів),
						'name' => q(кілоджоулі),
						'one' => q({0} кілоджоуль),
						'other' => q({0} кілоджоуля),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'few' => q({0} кіловат-години),
						'many' => q({0} кіловат-годин),
						'name' => q(кіловат-години),
						'one' => q({0} кіловат-година),
						'other' => q({0} кіловат-години),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'few' => q({0} кіловат-години),
						'many' => q({0} кіловат-годин),
						'name' => q(кіловат-години),
						'one' => q({0} кіловат-година),
						'other' => q({0} кіловат-години),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'few' => q({0} американських терми),
						'many' => q({0} американських термів),
						'name' => q(американський терм),
						'one' => q({0} американський терм),
						'other' => q({0} американського терма),
					},
					# Core Unit Identifier
					'therm-us' => {
						'few' => q({0} американських терми),
						'many' => q({0} американських термів),
						'name' => q(американський терм),
						'one' => q({0} американський терм),
						'other' => q({0} американського терма),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'few' => q({0} кіловат-години на 100 кілометрів),
						'many' => q({0} кіловат-годин на 100 кілометрів),
						'name' => q(кіловат-години на 100 кілометрів),
						'one' => q({0} кіловат-година на 100 кілометрів),
						'other' => q({0} кіловат-години на 100 кілометрів),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'few' => q({0} кіловат-години на 100 кілометрів),
						'many' => q({0} кіловат-годин на 100 кілометрів),
						'name' => q(кіловат-години на 100 кілометрів),
						'one' => q({0} кіловат-година на 100 кілометрів),
						'other' => q({0} кіловат-години на 100 кілометрів),
					},
					# Long Unit Identifier
					'force-newton' => {
						'1' => q(masculine),
						'few' => q({0} ньютони),
						'many' => q({0} ньютонів),
						'name' => q(ньютони),
						'one' => q({0} ньютон),
						'other' => q({0} ньютона),
					},
					# Core Unit Identifier
					'newton' => {
						'1' => q(masculine),
						'few' => q({0} ньютони),
						'many' => q({0} ньютонів),
						'name' => q(ньютони),
						'one' => q({0} ньютон),
						'other' => q({0} ньютона),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'few' => q({0} фунт-сили),
						'many' => q({0} фунт-сил),
						'name' => q(фунт-сили),
						'one' => q({0} фунт-сила),
						'other' => q({0} фунт-сили),
					},
					# Core Unit Identifier
					'pound-force' => {
						'few' => q({0} фунт-сили),
						'many' => q({0} фунт-сил),
						'name' => q(фунт-сили),
						'one' => q({0} фунт-сила),
						'other' => q({0} фунт-сили),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'few' => q({0} гігагерци),
						'many' => q({0} гігагерців),
						'name' => q(гігагерци),
						'one' => q({0} гігагерц),
						'other' => q({0} гігагерца),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'few' => q({0} гігагерци),
						'many' => q({0} гігагерців),
						'name' => q(гігагерци),
						'one' => q({0} гігагерц),
						'other' => q({0} гігагерца),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'1' => q(masculine),
						'few' => q({0} герци),
						'many' => q({0} герців),
						'name' => q(герци),
						'one' => q({0} герц),
						'other' => q({0} герца),
					},
					# Core Unit Identifier
					'hertz' => {
						'1' => q(masculine),
						'few' => q({0} герци),
						'many' => q({0} герців),
						'name' => q(герци),
						'one' => q({0} герц),
						'other' => q({0} герца),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'few' => q({0} кілогерци),
						'many' => q({0} кілогерців),
						'name' => q(кілогерци),
						'one' => q({0} кілогерц),
						'other' => q({0} кілогерца),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'few' => q({0} кілогерци),
						'many' => q({0} кілогерців),
						'name' => q(кілогерци),
						'one' => q({0} кілогерц),
						'other' => q({0} кілогерца),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'few' => q({0} мегагерци),
						'many' => q({0} мегагерців),
						'name' => q(мегагерци),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерца),
					},
					# Core Unit Identifier
					'megahertz' => {
						'few' => q({0} мегагерци),
						'many' => q({0} мегагерців),
						'name' => q(мегагерци),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерца),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'few' => q({0} точки),
						'many' => q({0} точок),
						'name' => q(точка),
						'one' => q({0} точка),
						'other' => q({0} точки),
					},
					# Core Unit Identifier
					'dot' => {
						'few' => q({0} точки),
						'many' => q({0} точок),
						'name' => q(точка),
						'one' => q({0} точка),
						'other' => q({0} точки),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'1' => q(masculine),
						'few' => q({0} ем),
						'many' => q({0} ем),
						'name' => q(ем),
						'one' => q({0} ем),
						'other' => q({0} ем),
					},
					# Core Unit Identifier
					'em' => {
						'1' => q(masculine),
						'few' => q({0} ем),
						'many' => q({0} ем),
						'name' => q(ем),
						'one' => q({0} ем),
						'other' => q({0} ем),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'few' => q({0} мегапікселі),
						'many' => q({0} мегапікселів),
						'name' => q(мегапікселі),
						'one' => q({0} мегапіксель),
						'other' => q({0} мегапікселя),
					},
					# Core Unit Identifier
					'megapixel' => {
						'few' => q({0} мегапікселі),
						'many' => q({0} мегапікселів),
						'name' => q(мегапікселі),
						'one' => q({0} мегапіксель),
						'other' => q({0} мегапікселя),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'1' => q(masculine),
						'few' => q({0} пікселі),
						'many' => q({0} пікселів),
						'name' => q(пікселі),
						'one' => q({0} піксель),
						'other' => q({0} пікселя),
					},
					# Core Unit Identifier
					'pixel' => {
						'1' => q(masculine),
						'few' => q({0} пікселі),
						'many' => q({0} пікселів),
						'name' => q(пікселі),
						'one' => q({0} піксель),
						'other' => q({0} пікселя),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'few' => q({0} астрономічні одиниці),
						'many' => q({0} астрономічних одиниць),
						'name' => q(астрономічні одиниці),
						'one' => q({0} астрономічна одиниця),
						'other' => q({0} астрономічної одиниці),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'few' => q({0} астрономічні одиниці),
						'many' => q({0} астрономічних одиниць),
						'name' => q(астрономічні одиниці),
						'one' => q({0} астрономічна одиниця),
						'other' => q({0} астрономічної одиниці),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'few' => q({0} сантиметри),
						'many' => q({0} сантиметрів),
						'name' => q(сантиметри),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметра),
						'per' => q({0} на сантиметр),
					},
					# Core Unit Identifier
					'centimeter' => {
						'few' => q({0} сантиметри),
						'many' => q({0} сантиметрів),
						'name' => q(сантиметри),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметра),
						'per' => q({0} на сантиметр),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'few' => q({0} дециметри),
						'many' => q({0} дециметрів),
						'name' => q(дециметри),
						'one' => q({0} дециметр),
						'other' => q({0} дециметра),
					},
					# Core Unit Identifier
					'decimeter' => {
						'few' => q({0} дециметри),
						'many' => q({0} дециметрів),
						'name' => q(дециметри),
						'one' => q({0} дециметр),
						'other' => q({0} дециметра),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'few' => q({0} радіуси Землі),
						'many' => q({0} радіусів Землі),
						'name' => q(радіус Землі),
						'one' => q({0} радіус Землі),
						'other' => q({0} радіуса Землі),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'few' => q({0} радіуси Землі),
						'many' => q({0} радіусів Землі),
						'name' => q(радіус Землі),
						'one' => q({0} радіус Землі),
						'other' => q({0} радіуса Землі),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'few' => q({0} фатоми),
						'many' => q({0} фатомів),
						'name' => q(фатоми),
						'one' => q({0} фатом),
						'other' => q({0} фатома),
					},
					# Core Unit Identifier
					'fathom' => {
						'few' => q({0} фатоми),
						'many' => q({0} фатомів),
						'name' => q(фатоми),
						'one' => q({0} фатом),
						'other' => q({0} фатома),
					},
					# Long Unit Identifier
					'length-foot' => {
						'few' => q({0} фути),
						'many' => q({0} футів),
						'name' => q(фути),
						'one' => q({0} фут),
						'other' => q({0} фута),
						'per' => q({0} на фут),
					},
					# Core Unit Identifier
					'foot' => {
						'few' => q({0} фути),
						'many' => q({0} футів),
						'name' => q(фути),
						'one' => q({0} фут),
						'other' => q({0} фута),
						'per' => q({0} на фут),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'few' => q({0} фурлонги),
						'many' => q({0} фурлонгів),
						'name' => q(фурлонги),
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонга),
					},
					# Core Unit Identifier
					'furlong' => {
						'few' => q({0} фурлонги),
						'many' => q({0} фурлонгів),
						'name' => q(фурлонги),
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонга),
					},
					# Long Unit Identifier
					'length-inch' => {
						'few' => q({0} дюйми),
						'many' => q({0} дюймів),
						'name' => q(дюйми),
						'one' => q({0} дюйм),
						'other' => q({0} дюйма),
						'per' => q({0} на дюйм),
					},
					# Core Unit Identifier
					'inch' => {
						'few' => q({0} дюйми),
						'many' => q({0} дюймів),
						'name' => q(дюйми),
						'one' => q({0} дюйм),
						'other' => q({0} дюйма),
						'per' => q({0} на дюйм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'few' => q({0} кілометри),
						'many' => q({0} кілометрів),
						'name' => q(кілометри),
						'one' => q({0} кілометр),
						'other' => q({0} кілометра),
						'per' => q({0} на кілометр),
					},
					# Core Unit Identifier
					'kilometer' => {
						'few' => q({0} кілометри),
						'many' => q({0} кілометрів),
						'name' => q(кілометри),
						'one' => q({0} кілометр),
						'other' => q({0} кілометра),
						'per' => q({0} на кілометр),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'few' => q({0} світлові роки),
						'many' => q({0} світлових років),
						'name' => q(світлові роки),
						'one' => q({0} світловий рік),
						'other' => q({0} світлового року),
					},
					# Core Unit Identifier
					'light-year' => {
						'few' => q({0} світлові роки),
						'many' => q({0} світлових років),
						'name' => q(світлові роки),
						'one' => q({0} світловий рік),
						'other' => q({0} світлового року),
					},
					# Long Unit Identifier
					'length-meter' => {
						'1' => q(masculine),
						'few' => q({0} метри),
						'many' => q({0} метрів),
						'name' => q(метри),
						'one' => q({0} метр),
						'other' => q({0} метра),
						'per' => q({0} на метр),
					},
					# Core Unit Identifier
					'meter' => {
						'1' => q(masculine),
						'few' => q({0} метри),
						'many' => q({0} метрів),
						'name' => q(метри),
						'one' => q({0} метр),
						'other' => q({0} метра),
						'per' => q({0} на метр),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'few' => q({0} мікрометри),
						'many' => q({0} мікрометрів),
						'name' => q(мікрометри),
						'one' => q({0} мікрометр),
						'other' => q({0} мікрометра),
					},
					# Core Unit Identifier
					'micrometer' => {
						'few' => q({0} мікрометри),
						'many' => q({0} мікрометрів),
						'name' => q(мікрометри),
						'one' => q({0} мікрометр),
						'other' => q({0} мікрометра),
					},
					# Long Unit Identifier
					'length-mile' => {
						'few' => q({0} милі),
						'many' => q({0} миль),
						'name' => q(милі),
						'one' => q({0} миля),
						'other' => q({0} милі),
					},
					# Core Unit Identifier
					'mile' => {
						'few' => q({0} милі),
						'many' => q({0} миль),
						'name' => q(милі),
						'one' => q({0} миля),
						'other' => q({0} милі),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'1' => q(feminine),
						'few' => q({0} скандинавські милі),
						'many' => q({0} скандинавських миль),
						'name' => q(скандинавські милі),
						'one' => q({0} скандинавська миля),
						'other' => q({0} скандинавської милі),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'1' => q(feminine),
						'few' => q({0} скандинавські милі),
						'many' => q({0} скандинавських миль),
						'name' => q(скандинавські милі),
						'one' => q({0} скандинавська миля),
						'other' => q({0} скандинавської милі),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'few' => q({0} міліметри),
						'many' => q({0} міліметрів),
						'name' => q(міліметри),
						'one' => q({0} міліметр),
						'other' => q({0} міліметра),
					},
					# Core Unit Identifier
					'millimeter' => {
						'few' => q({0} міліметри),
						'many' => q({0} міліметрів),
						'name' => q(міліметри),
						'one' => q({0} міліметр),
						'other' => q({0} міліметра),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'few' => q({0} нанометри),
						'many' => q({0} нанометрів),
						'name' => q(нанометри),
						'one' => q({0} нанометр),
						'other' => q({0} нанометра),
					},
					# Core Unit Identifier
					'nanometer' => {
						'few' => q({0} нанометри),
						'many' => q({0} нанометрів),
						'name' => q(нанометри),
						'one' => q({0} нанометр),
						'other' => q({0} нанометра),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'few' => q({0} морські милі),
						'many' => q({0} морських миль),
						'name' => q(морські милі),
						'one' => q({0} морська миля),
						'other' => q({0} морської милі),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'few' => q({0} морські милі),
						'many' => q({0} морських миль),
						'name' => q(морські милі),
						'one' => q({0} морська миля),
						'other' => q({0} морської милі),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'few' => q({0} парсеки),
						'many' => q({0} парсеків),
						'name' => q(парсеки),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					# Core Unit Identifier
					'parsec' => {
						'few' => q({0} парсеки),
						'many' => q({0} парсеків),
						'name' => q(парсеки),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'few' => q({0} пікометри),
						'many' => q({0} пікометрів),
						'name' => q(пікометри),
						'one' => q({0} пікометр),
						'other' => q({0} пікометра),
					},
					# Core Unit Identifier
					'picometer' => {
						'few' => q({0} пікометри),
						'many' => q({0} пікометрів),
						'name' => q(пікометри),
						'one' => q({0} пікометр),
						'other' => q({0} пікометра),
					},
					# Long Unit Identifier
					'length-point' => {
						'few' => q({0} пункти),
						'many' => q({0} пунктів),
						'name' => q(пункти),
						'one' => q({0} пункт),
						'other' => q({0} пункту),
					},
					# Core Unit Identifier
					'point' => {
						'few' => q({0} пункти),
						'many' => q({0} пунктів),
						'name' => q(пункти),
						'one' => q({0} пункт),
						'other' => q({0} пункту),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'few' => q({0} радіуси Сонця),
						'many' => q({0} радіусів Сонця),
						'name' => q(радіус Сонця),
						'one' => q({0} радіус Сонця),
						'other' => q({0} радіуса Сонця),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'few' => q({0} радіуси Сонця),
						'many' => q({0} радіусів Сонця),
						'name' => q(радіус Сонця),
						'one' => q({0} радіус Сонця),
						'other' => q({0} радіуса Сонця),
					},
					# Long Unit Identifier
					'length-yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'name' => q(ярди),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					# Core Unit Identifier
					'yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'name' => q(ярди),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					# Long Unit Identifier
					'light-candela' => {
						'1' => q(feminine),
						'few' => q({0} кандели),
						'many' => q({0} кандел),
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандели),
					},
					# Core Unit Identifier
					'candela' => {
						'1' => q(feminine),
						'few' => q({0} кандели),
						'many' => q({0} кандел),
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандели),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'1' => q(masculine),
						'few' => q({0} люмени),
						'many' => q({0} люменів),
						'name' => q(люмени),
						'one' => q({0} люмен),
						'other' => q({0} люмена),
					},
					# Core Unit Identifier
					'lumen' => {
						'1' => q(masculine),
						'few' => q({0} люмени),
						'many' => q({0} люменів),
						'name' => q(люмени),
						'one' => q({0} люмен),
						'other' => q({0} люмена),
					},
					# Long Unit Identifier
					'light-lux' => {
						'1' => q(masculine),
						'few' => q({0} люкси),
						'many' => q({0} люксів),
						'name' => q(люкси),
						'one' => q({0} люкс),
						'other' => q({0} люкса),
					},
					# Core Unit Identifier
					'lux' => {
						'1' => q(masculine),
						'few' => q({0} люкси),
						'many' => q({0} люксів),
						'name' => q(люкси),
						'one' => q({0} люкс),
						'other' => q({0} люкса),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'few' => q({0} світності Сонця),
						'many' => q({0} світностей Сонця),
						'name' => q(світності Сонця),
						'one' => q({0} світність Сонця),
						'other' => q({0} світності Сонця),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'few' => q({0} світності Сонця),
						'many' => q({0} світностей Сонця),
						'name' => q(світності Сонця),
						'one' => q({0} світність Сонця),
						'other' => q({0} світності Сонця),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'1' => q(masculine),
						'few' => q({0} карати),
						'many' => q({0} каратів),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Core Unit Identifier
					'carat' => {
						'1' => q(masculine),
						'few' => q({0} карати),
						'many' => q({0} каратів),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'few' => q({0} дальтони),
						'many' => q({0} дальтонів),
						'name' => q(дальтони),
						'one' => q({0} дальтон),
						'other' => q({0} дальтона),
					},
					# Core Unit Identifier
					'dalton' => {
						'few' => q({0} дальтони),
						'many' => q({0} дальтонів),
						'name' => q(дальтони),
						'one' => q({0} дальтон),
						'other' => q({0} дальтона),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'few' => q({0} маси Землі),
						'many' => q({0} мас Землі),
						'name' => q(маси Землі),
						'one' => q({0} маса Землі),
						'other' => q({0} маси Землі),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'few' => q({0} маси Землі),
						'many' => q({0} мас Землі),
						'name' => q(маси Землі),
						'one' => q({0} маса Землі),
						'other' => q({0} маси Землі),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'few' => q({0} грани),
						'many' => q({0} гранів),
						'name' => q(гран),
						'one' => q({0} гран),
						'other' => q({0} грана),
					},
					# Core Unit Identifier
					'grain' => {
						'few' => q({0} грани),
						'many' => q({0} гранів),
						'name' => q(гран),
						'one' => q({0} гран),
						'other' => q({0} грана),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'1' => q(masculine),
						'few' => q({0} грами),
						'many' => q({0} грамів),
						'name' => q(грами),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} на грам),
					},
					# Core Unit Identifier
					'gram' => {
						'1' => q(masculine),
						'few' => q({0} грами),
						'many' => q({0} грамів),
						'name' => q(грами),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} на грам),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'1' => q(masculine),
						'few' => q({0} кілограми),
						'many' => q({0} кілограмів),
						'name' => q(кілограми),
						'one' => q({0} кілограм),
						'other' => q({0} кілограма),
						'per' => q({0} на кілограм),
					},
					# Core Unit Identifier
					'kilogram' => {
						'1' => q(masculine),
						'few' => q({0} кілограми),
						'many' => q({0} кілограмів),
						'name' => q(кілограми),
						'one' => q({0} кілограм),
						'other' => q({0} кілограма),
						'per' => q({0} на кілограм),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'1' => q(feminine),
						'few' => q({0} метричні тонни),
						'many' => q({0} метричних тонн),
						'name' => q(метричні тонни),
						'one' => q({0} метрична тонна),
						'other' => q({0} метричної тонни),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'1' => q(feminine),
						'few' => q({0} метричні тонни),
						'many' => q({0} метричних тонн),
						'name' => q(метричні тонни),
						'one' => q({0} метрична тонна),
						'other' => q({0} метричної тонни),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'few' => q({0} мікрограми),
						'many' => q({0} мікрограм),
						'name' => q(мікрограми),
						'one' => q({0} мікрограм),
						'other' => q({0} мікрограма),
					},
					# Core Unit Identifier
					'microgram' => {
						'few' => q({0} мікрограми),
						'many' => q({0} мікрограм),
						'name' => q(мікрограми),
						'one' => q({0} мікрограм),
						'other' => q({0} мікрограма),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'few' => q({0} міліграми),
						'many' => q({0} міліграм),
						'name' => q(міліграми),
						'one' => q({0} міліграм),
						'other' => q({0} міліграма),
					},
					# Core Unit Identifier
					'milligram' => {
						'few' => q({0} міліграми),
						'many' => q({0} міліграм),
						'name' => q(міліграми),
						'one' => q({0} міліграм),
						'other' => q({0} міліграма),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'few' => q({0} унції),
						'many' => q({0} унцій),
						'name' => q(унції),
						'one' => q({0} унція),
						'other' => q({0} унції),
						'per' => q({0} на унцію),
					},
					# Core Unit Identifier
					'ounce' => {
						'few' => q({0} унції),
						'many' => q({0} унцій),
						'name' => q(унції),
						'one' => q({0} унція),
						'other' => q({0} унції),
						'per' => q({0} на унцію),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'few' => q({0} тройські унції),
						'many' => q({0} тройських унцій),
						'name' => q(тройські унції),
						'one' => q({0} тройська унція),
						'other' => q({0} тройської унції),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'few' => q({0} тройські унції),
						'many' => q({0} тройських унцій),
						'name' => q(тройські унції),
						'one' => q({0} тройська унція),
						'other' => q({0} тройської унції),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'few' => q({0} фунти),
						'many' => q({0} фунтів),
						'name' => q(фунти),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
						'per' => q({0} на фунт),
					},
					# Core Unit Identifier
					'pound' => {
						'few' => q({0} фунти),
						'many' => q({0} фунтів),
						'name' => q(фунти),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
						'per' => q({0} на фунт),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'few' => q({0} маси Сонця),
						'many' => q({0} мас Сонця),
						'name' => q(маси Сонця),
						'one' => q({0} маса Сонця),
						'other' => q({0} маси Сонця),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'few' => q({0} маси Сонця),
						'many' => q({0} мас Сонця),
						'name' => q(маси Сонця),
						'one' => q({0} маса Сонця),
						'other' => q({0} маси Сонця),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'few' => q({0} стоуни),
						'many' => q({0} стоунів),
						'name' => q(стоуни),
						'one' => q({0} стоун),
						'other' => q({0} стоуна),
					},
					# Core Unit Identifier
					'stone' => {
						'few' => q({0} стоуни),
						'many' => q({0} стоунів),
						'name' => q(стоуни),
						'one' => q({0} стоун),
						'other' => q({0} стоуна),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'few' => q({0} тонни),
						'many' => q({0} тонн),
						'name' => q(тонни),
						'one' => q({0} тонна),
						'other' => q({0} тонни),
					},
					# Core Unit Identifier
					'ton' => {
						'few' => q({0} тонни),
						'many' => q({0} тонн),
						'name' => q(тонни),
						'one' => q({0} тонна),
						'other' => q({0} тонни),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} на {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} на {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'few' => q({0} гігавати),
						'many' => q({0} гігаватів),
						'name' => q(гігавати),
						'one' => q({0} гігават),
						'other' => q({0} гігавата),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'few' => q({0} гігавати),
						'many' => q({0} гігаватів),
						'name' => q(гігавати),
						'one' => q({0} гігават),
						'other' => q({0} гігавата),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'few' => q({0} кінські сили),
						'many' => q({0} кінських сил),
						'name' => q(кінські сили),
						'one' => q({0} кінська сила),
						'other' => q({0} кінської сили),
					},
					# Core Unit Identifier
					'horsepower' => {
						'few' => q({0} кінські сили),
						'many' => q({0} кінських сил),
						'name' => q(кінські сили),
						'one' => q({0} кінська сила),
						'other' => q({0} кінської сили),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'few' => q({0} кіловати),
						'many' => q({0} кіловатів),
						'name' => q(кіловати),
						'one' => q({0} кіловат),
						'other' => q({0} кіловата),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'few' => q({0} кіловати),
						'many' => q({0} кіловатів),
						'name' => q(кіловати),
						'one' => q({0} кіловат),
						'other' => q({0} кіловата),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'few' => q({0} мегавати),
						'many' => q({0} мегават),
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавата),
					},
					# Core Unit Identifier
					'megawatt' => {
						'few' => q({0} мегавати),
						'many' => q({0} мегават),
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавата),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'few' => q({0} мілівати),
						'many' => q({0} міліват),
						'name' => q(мілівати),
						'one' => q({0} міліват),
						'other' => q({0} мілівата),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'few' => q({0} мілівати),
						'many' => q({0} міліват),
						'name' => q(мілівати),
						'one' => q({0} міліват),
						'other' => q({0} мілівата),
					},
					# Long Unit Identifier
					'power-watt' => {
						'1' => q(masculine),
						'few' => q({0} вати),
						'many' => q({0} ватів),
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вата),
					},
					# Core Unit Identifier
					'watt' => {
						'1' => q(masculine),
						'few' => q({0} вати),
						'many' => q({0} ватів),
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вата),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(квадратні {0}),
						'few' => q(квадратні {0}),
						'many' => q(квадратних {0}),
						'one' => q(квадратний {0}),
						'other' => q(квадратного {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(квадратні {0}),
						'few' => q(квадратні {0}),
						'many' => q(квадратних {0}),
						'one' => q(квадратний {0}),
						'other' => q(квадратного {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(кубічні {0}),
						'few' => q(кубічні {0}),
						'many' => q(кубічних {0}),
						'one' => q(кубічний {0}),
						'other' => q(кубічного {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(кубічні {0}),
						'few' => q(кубічні {0}),
						'many' => q(кубічних {0}),
						'one' => q(кубічний {0}),
						'other' => q(кубічного {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'1' => q(feminine),
						'few' => q({0} атмосфери),
						'many' => q({0} атмосфер),
						'name' => q(атмосфери),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфери),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'1' => q(feminine),
						'few' => q({0} атмосфери),
						'many' => q({0} атмосфер),
						'name' => q(атмосфери),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфери),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'1' => q(masculine),
						'few' => q({0} бари),
						'many' => q({0} барів),
						'name' => q(бари),
						'one' => q({0} бар),
						'other' => q({0} бара),
					},
					# Core Unit Identifier
					'bar' => {
						'1' => q(masculine),
						'few' => q({0} бари),
						'many' => q({0} барів),
						'name' => q(бари),
						'one' => q({0} бар),
						'other' => q({0} бара),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'few' => q({0} гектопаскалі),
						'many' => q({0} гектопаскалів),
						'name' => q(гектопаскалі),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаля),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'few' => q({0} гектопаскалі),
						'many' => q({0} гектопаскалів),
						'name' => q(гектопаскалі),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаля),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'few' => q({0} дюйми ртутного стовпа),
						'many' => q({0} дюймів ртутного стовпа),
						'name' => q(дюйми ртутного стовпа),
						'one' => q({0} дюйм ртутного стовпа),
						'other' => q({0} дюйма ртутного стовпа),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'few' => q({0} дюйми ртутного стовпа),
						'many' => q({0} дюймів ртутного стовпа),
						'name' => q(дюйми ртутного стовпа),
						'one' => q({0} дюйм ртутного стовпа),
						'other' => q({0} дюйма ртутного стовпа),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'few' => q({0} кілопаскалі),
						'many' => q({0} кілопаскалів),
						'name' => q(кілопаскалі),
						'one' => q({0} кілопаскаль),
						'other' => q({0} кілопаскаля),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'few' => q({0} кілопаскалі),
						'many' => q({0} кілопаскалів),
						'name' => q(кілопаскалі),
						'one' => q({0} кілопаскаль),
						'other' => q({0} кілопаскаля),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'few' => q({0} мегапаскалі),
						'many' => q({0} мегапаскалів),
						'name' => q(мегапаскалі),
						'one' => q({0} мегапаскаль),
						'other' => q({0} мегапаскаля),
					},
					# Core Unit Identifier
					'megapascal' => {
						'few' => q({0} мегапаскалі),
						'many' => q({0} мегапаскалів),
						'name' => q(мегапаскалі),
						'one' => q({0} мегапаскаль),
						'other' => q({0} мегапаскаля),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'few' => q({0} мілібари),
						'many' => q({0} мілібарів),
						'name' => q(мілібари),
						'one' => q({0} мілібар),
						'other' => q({0} мілібара),
					},
					# Core Unit Identifier
					'millibar' => {
						'few' => q({0} мілібари),
						'many' => q({0} мілібарів),
						'name' => q(мілібари),
						'one' => q({0} мілібар),
						'other' => q({0} мілібара),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'few' => q({0} міліметри ртутного стовпа),
						'many' => q({0} міліметрів ртутного стовпа),
						'name' => q(міліметри ртутного стовпа),
						'one' => q({0} міліметр ртутного стовпа),
						'other' => q({0} міліметра ртутного стовпа),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'few' => q({0} міліметри ртутного стовпа),
						'many' => q({0} міліметрів ртутного стовпа),
						'name' => q(міліметри ртутного стовпа),
						'one' => q({0} міліметр ртутного стовпа),
						'other' => q({0} міліметра ртутного стовпа),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'1' => q(masculine),
						'few' => q({0} паскалі),
						'many' => q({0} паскалів),
						'name' => q(паскалі),
						'one' => q({0} паскаль),
						'other' => q({0} паскаля),
					},
					# Core Unit Identifier
					'pascal' => {
						'1' => q(masculine),
						'few' => q({0} паскалі),
						'many' => q({0} паскалів),
						'name' => q(паскалі),
						'one' => q({0} паскаль),
						'other' => q({0} паскаля),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'few' => q({0} фунти на квадратний дюйм),
						'many' => q({0} фунтів на квадратний дюйм),
						'name' => q(фунти на квадратний дюйм),
						'one' => q({0} фунт на квадратний дюйм),
						'other' => q({0} фунта на квадратний дюйм),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'few' => q({0} фунти на квадратний дюйм),
						'many' => q({0} фунтів на квадратний дюйм),
						'name' => q(фунти на квадратний дюйм),
						'one' => q({0} фунт на квадратний дюйм),
						'other' => q({0} фунта на квадратний дюйм),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'few' => q({0} кілометри на годину),
						'many' => q({0} кілометрів на годину),
						'name' => q(кілометри на годину),
						'one' => q({0} кілометр на годину),
						'other' => q({0} кілометра на годину),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'few' => q({0} кілометри на годину),
						'many' => q({0} кілометрів на годину),
						'name' => q(кілометри на годину),
						'one' => q({0} кілометр на годину),
						'other' => q({0} кілометра на годину),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'few' => q({0} вузли),
						'many' => q({0} вузлів),
						'name' => q(вузол),
						'one' => q({0} вузол),
						'other' => q({0} вузла),
					},
					# Core Unit Identifier
					'knot' => {
						'few' => q({0} вузли),
						'many' => q({0} вузлів),
						'name' => q(вузол),
						'one' => q({0} вузол),
						'other' => q({0} вузла),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'few' => q({0} метри на секунду),
						'many' => q({0} метрів на секунду),
						'name' => q(метри на секунду),
						'one' => q({0} метр на секунду),
						'other' => q({0} метра на секунду),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'few' => q({0} метри на секунду),
						'many' => q({0} метрів на секунду),
						'name' => q(метри на секунду),
						'one' => q({0} метр на секунду),
						'other' => q({0} метра на секунду),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'few' => q({0} милі на годину),
						'many' => q({0} миль на годину),
						'name' => q(милі на годину),
						'one' => q({0} миля на годину),
						'other' => q({0} милі на годину),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'few' => q({0} милі на годину),
						'many' => q({0} миль на годину),
						'name' => q(милі на годину),
						'one' => q({0} миля на годину),
						'other' => q({0} милі на годину),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'1' => q(masculine),
						'few' => q({0} градуси Цельсія),
						'many' => q({0} градусів Цельсія),
						'name' => q(градуси Цельсія),
						'one' => q({0} градус Цельсія),
						'other' => q({0} градуса Цельсія),
					},
					# Core Unit Identifier
					'celsius' => {
						'1' => q(masculine),
						'few' => q({0} градуси Цельсія),
						'many' => q({0} градусів Цельсія),
						'name' => q(градуси Цельсія),
						'one' => q({0} градус Цельсія),
						'other' => q({0} градуса Цельсія),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'few' => q({0} градуси Фаренгейта),
						'many' => q({0} градусів Фаренгейта),
						'name' => q(градуси Фаренгейта),
						'one' => q({0} градус Фаренгейта),
						'other' => q({0} градуса Фаренгейта),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'few' => q({0} градуси Фаренгейта),
						'many' => q({0} градусів Фаренгейта),
						'name' => q(градуси Фаренгейта),
						'one' => q({0} градус Фаренгейта),
						'other' => q({0} градуса Фаренгейта),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'1' => q(masculine),
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'1' => q(masculine),
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'1' => q(masculine),
						'few' => q({0} кельвіни),
						'many' => q({0} кельвінів),
						'name' => q(кельвіни),
						'one' => q({0} кельвін),
						'other' => q({0} кельвіна),
					},
					# Core Unit Identifier
					'kelvin' => {
						'1' => q(masculine),
						'few' => q({0} кельвіни),
						'many' => q({0} кельвінів),
						'name' => q(кельвіни),
						'one' => q({0} кельвін),
						'other' => q({0} кельвіна),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'few' => q({0} ньютон-метри),
						'many' => q({0} ньютон-метрів),
						'name' => q(ньютон-метри),
						'one' => q({0} ньютон-метр),
						'other' => q({0} ньютон-метра),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'few' => q({0} ньютон-метри),
						'many' => q({0} ньютон-метрів),
						'name' => q(ньютон-метри),
						'one' => q({0} ньютон-метр),
						'other' => q({0} ньютон-метра),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'few' => q({0} фунт-фути),
						'many' => q({0} фунт-футів),
						'name' => q(фунт-фути),
						'one' => q({0} фунт-фут),
						'other' => q({0} фунт-фута),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'few' => q({0} фунт-фути),
						'many' => q({0} фунт-футів),
						'name' => q(фунт-фути),
						'one' => q({0} фунт-фут),
						'other' => q({0} фунт-фута),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'few' => q({0} акр-фути),
						'many' => q({0} акр-футів),
						'name' => q(акр-фути),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фута),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'few' => q({0} акр-фути),
						'many' => q({0} акр-футів),
						'name' => q(акр-фути),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фута),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'few' => q({0} барелі),
						'many' => q({0} барелів),
						'name' => q(барелі),
						'one' => q({0} барель),
						'other' => q({0} бареля),
					},
					# Core Unit Identifier
					'barrel' => {
						'few' => q({0} барелі),
						'many' => q({0} барелів),
						'name' => q(барелі),
						'one' => q({0} барель),
						'other' => q({0} бареля),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'few' => q({0} бушелі),
						'many' => q({0} бушелів),
						'name' => q(бушелі),
						'one' => q({0} бушель),
						'other' => q({0} бушеля),
					},
					# Core Unit Identifier
					'bushel' => {
						'few' => q({0} бушелі),
						'many' => q({0} бушелів),
						'name' => q(бушелі),
						'one' => q({0} бушель),
						'other' => q({0} бушеля),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'few' => q({0} сантилітри),
						'many' => q({0} сантилітрів),
						'name' => q(сантилітри),
						'one' => q({0} сантилітр),
						'other' => q({0} сантилітра),
					},
					# Core Unit Identifier
					'centiliter' => {
						'few' => q({0} сантилітри),
						'many' => q({0} сантилітрів),
						'name' => q(сантилітри),
						'one' => q({0} сантилітр),
						'other' => q({0} сантилітра),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'few' => q({0} кубічні сантиметри),
						'many' => q({0} кубічних сантиметрів),
						'name' => q(кубічні сантиметри),
						'one' => q({0} кубічний сантиметр),
						'other' => q({0} кубічного сантиметра),
						'per' => q({0} на кубічний сантиметр),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'few' => q({0} кубічні сантиметри),
						'many' => q({0} кубічних сантиметрів),
						'name' => q(кубічні сантиметри),
						'one' => q({0} кубічний сантиметр),
						'other' => q({0} кубічного сантиметра),
						'per' => q({0} на кубічний сантиметр),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'few' => q({0} кубічні фути),
						'many' => q({0} кубічних футів),
						'name' => q(кубічні фути),
						'one' => q({0} кубічний фут),
						'other' => q({0} кубічного фута),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'few' => q({0} кубічні фути),
						'many' => q({0} кубічних футів),
						'name' => q(кубічні фути),
						'one' => q({0} кубічний фут),
						'other' => q({0} кубічного фута),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'few' => q({0} кубічні дюйми),
						'many' => q({0} кубічних дюймів),
						'name' => q(кубічні дюйми),
						'one' => q({0} кубічний дюйм),
						'other' => q({0} кубічного дюйма),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'few' => q({0} кубічні дюйми),
						'many' => q({0} кубічних дюймів),
						'name' => q(кубічні дюйми),
						'one' => q({0} кубічний дюйм),
						'other' => q({0} кубічного дюйма),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'few' => q({0} кубічні кілометри),
						'many' => q({0} кубічних кілометрів),
						'name' => q(кубічні кілометри),
						'one' => q({0} кубічний кілометр),
						'other' => q({0} кубічного кілометра),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'few' => q({0} кубічні кілометри),
						'many' => q({0} кубічних кілометрів),
						'name' => q(кубічні кілометри),
						'one' => q({0} кубічний кілометр),
						'other' => q({0} кубічного кілометра),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'few' => q({0} кубічні метри),
						'many' => q({0} кубічних метрів),
						'name' => q(кубічні метри),
						'one' => q({0} кубічний метр),
						'other' => q({0} кубічного метра),
						'per' => q({0} на кубічний метр),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'few' => q({0} кубічні метри),
						'many' => q({0} кубічних метрів),
						'name' => q(кубічні метри),
						'one' => q({0} кубічний метр),
						'other' => q({0} кубічного метра),
						'per' => q({0} на кубічний метр),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'few' => q({0} кубічні милі),
						'many' => q({0} кубічних миль),
						'name' => q(кубічні милі),
						'one' => q({0} кубічна миля),
						'other' => q({0} кубічної милі),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'few' => q({0} кубічні милі),
						'many' => q({0} кубічних миль),
						'name' => q(кубічні милі),
						'one' => q({0} кубічна миля),
						'other' => q({0} кубічної милі),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'few' => q({0} кубічні ярди),
						'many' => q({0} кубічних ярдів),
						'name' => q(кубічні ярди),
						'one' => q({0} кубічний ярд),
						'other' => q({0} кубічного ярда),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'few' => q({0} кубічні ярди),
						'many' => q({0} кубічних ярдів),
						'name' => q(кубічні ярди),
						'one' => q({0} кубічний ярд),
						'other' => q({0} кубічного ярда),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'few' => q({0} склянки),
						'many' => q({0} склянок),
						'name' => q(склянки),
						'one' => q({0} склянка),
						'other' => q({0} склянки),
					},
					# Core Unit Identifier
					'cup' => {
						'few' => q({0} склянки),
						'many' => q({0} склянок),
						'name' => q(склянки),
						'one' => q({0} склянка),
						'other' => q({0} склянки),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричні чашки),
						'many' => q({0} метричних чашок),
						'name' => q(метричні чашки),
						'one' => q({0} метрична чашка),
						'other' => q({0} метричної чашки),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричні чашки),
						'many' => q({0} метричних чашок),
						'name' => q(метричні чашки),
						'one' => q({0} метрична чашка),
						'other' => q({0} метричної чашки),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'few' => q({0} децилітри),
						'many' => q({0} децилітрів),
						'name' => q(децилітри),
						'one' => q({0} децилітр),
						'other' => q({0} децилітра),
					},
					# Core Unit Identifier
					'deciliter' => {
						'few' => q({0} децилітри),
						'many' => q({0} децилітрів),
						'name' => q(децилітри),
						'one' => q({0} децилітр),
						'other' => q({0} децилітра),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'few' => q({0} десертні ложки),
						'many' => q({0} десертних ложок),
						'name' => q(десертна ложка),
						'one' => q({0} десертна ложка),
						'other' => q({0} десертної ложки),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'few' => q({0} десертні ложки),
						'many' => q({0} десертних ложок),
						'name' => q(десертна ложка),
						'one' => q({0} десертна ложка),
						'other' => q({0} десертної ложки),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'few' => q({0} імп. десертні ложки),
						'many' => q({0} імп. десертних ложок),
						'name' => q(імперська десертна ложка),
						'one' => q({0} імп. десертна ложка),
						'other' => q({0} імп. десертної ложки),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'few' => q({0} імп. десертні ложки),
						'many' => q({0} імп. десертних ложок),
						'name' => q(імперська десертна ложка),
						'one' => q({0} імп. десертна ложка),
						'other' => q({0} імп. десертної ложки),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'few' => q({0} рідинні драхми),
						'many' => q({0} рідинних драхм),
						'name' => q(рідинна драхма),
						'one' => q({0} рідинна драхма),
						'other' => q({0} рідинної драхми),
					},
					# Core Unit Identifier
					'dram' => {
						'few' => q({0} рідинні драхми),
						'many' => q({0} рідинних драхм),
						'name' => q(рідинна драхма),
						'one' => q({0} рідинна драхма),
						'other' => q({0} рідинної драхми),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'few' => q({0} краплі),
						'many' => q({0} крапель),
						'name' => q(крапля),
						'one' => q({0} крапля),
						'other' => q({0} краплі),
					},
					# Core Unit Identifier
					'drop' => {
						'few' => q({0} краплі),
						'many' => q({0} крапель),
						'name' => q(крапля),
						'one' => q({0} крапля),
						'other' => q({0} краплі),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'few' => q({0} рідкі унції),
						'many' => q({0} рідких унцій),
						'name' => q(рідкі унції),
						'one' => q({0} рідка унція),
						'other' => q({0} рідкої унції),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'few' => q({0} рідкі унції),
						'many' => q({0} рідких унцій),
						'name' => q(рідкі унції),
						'one' => q({0} рідка унція),
						'other' => q({0} рідкої унції),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'few' => q({0} англійські рідинні унції),
						'many' => q({0} англійських рідинних унцій),
						'name' => q(англійські рідинні унції),
						'one' => q({0} англійська рідинна унція),
						'other' => q({0} англійської рідинної унції),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'few' => q({0} англійські рідинні унції),
						'many' => q({0} англійських рідинних унцій),
						'name' => q(англійські рідинні унції),
						'one' => q({0} англійська рідинна унція),
						'other' => q({0} англійської рідинної унції),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'few' => q({0} галони),
						'many' => q({0} галонів),
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галона),
						'per' => q({0} на галон),
					},
					# Core Unit Identifier
					'gallon' => {
						'few' => q({0} галони),
						'many' => q({0} галонів),
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галона),
						'per' => q({0} на галон),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'few' => q({0} англійські галони),
						'many' => q({0} англійських галонів),
						'name' => q(англійські галони),
						'one' => q({0} англійський галон),
						'other' => q({0} англійського галона),
						'per' => q({0} на англійський галон),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'few' => q({0} англійські галони),
						'many' => q({0} англійських галонів),
						'name' => q(англійські галони),
						'one' => q({0} англійський галон),
						'other' => q({0} англійського галона),
						'per' => q({0} на англійський галон),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'few' => q({0} гектолітри),
						'many' => q({0} гектолітрів),
						'name' => q(гектолітри),
						'one' => q({0} гектолітр),
						'other' => q({0} гектолітра),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'few' => q({0} гектолітри),
						'many' => q({0} гектолітрів),
						'name' => q(гектолітри),
						'one' => q({0} гектолітр),
						'other' => q({0} гектолітра),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'few' => q({0} мірні склянки),
						'many' => q({0} мірних склянок),
						'name' => q(мірна склянка),
						'one' => q({0} мірна склянка),
						'other' => q({0} мірна склянка),
					},
					# Core Unit Identifier
					'jigger' => {
						'few' => q({0} мірні склянки),
						'many' => q({0} мірних склянок),
						'name' => q(мірна склянка),
						'one' => q({0} мірна склянка),
						'other' => q({0} мірна склянка),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'1' => q(masculine),
						'few' => q({0} літри),
						'many' => q({0} літрів),
						'name' => q(літри),
						'one' => q({0} літр),
						'other' => q({0} літра),
						'per' => q({0} на літр),
					},
					# Core Unit Identifier
					'liter' => {
						'1' => q(masculine),
						'few' => q({0} літри),
						'many' => q({0} літрів),
						'name' => q(літри),
						'one' => q({0} літр),
						'other' => q({0} літра),
						'per' => q({0} на літр),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'few' => q({0} мегалітри),
						'many' => q({0} мегалітрів),
						'name' => q(мегалітри),
						'one' => q({0} мегалітр),
						'other' => q({0} мегалітра),
					},
					# Core Unit Identifier
					'megaliter' => {
						'few' => q({0} мегалітри),
						'many' => q({0} мегалітрів),
						'name' => q(мегалітри),
						'one' => q({0} мегалітр),
						'other' => q({0} мегалітра),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'few' => q({0} мілілітри),
						'many' => q({0} мілілітрів),
						'name' => q(мілілітри),
						'one' => q({0} мілілітр),
						'other' => q({0} мілілітра),
					},
					# Core Unit Identifier
					'milliliter' => {
						'few' => q({0} мілілітри),
						'many' => q({0} мілілітрів),
						'name' => q(мілілітри),
						'one' => q({0} мілілітр),
						'other' => q({0} мілілітра),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'few' => q({0} дрібки),
						'many' => q({0} дрібок),
						'name' => q(дрібка),
						'one' => q({0} дрібка),
						'other' => q({0} дрібки),
					},
					# Core Unit Identifier
					'pinch' => {
						'few' => q({0} дрібки),
						'many' => q({0} дрібок),
						'name' => q(дрібка),
						'one' => q({0} дрібка),
						'other' => q({0} дрібки),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'few' => q({0} пінти),
						'many' => q({0} пінт),
						'name' => q(пінти),
						'one' => q({0} пінта),
						'other' => q({0} пінти),
					},
					# Core Unit Identifier
					'pint' => {
						'few' => q({0} пінти),
						'many' => q({0} пінт),
						'name' => q(пінти),
						'one' => q({0} пінта),
						'other' => q({0} пінти),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричні пінти),
						'many' => q({0} метричних пінт),
						'name' => q(метрична пінта),
						'one' => q({0} метрична пінта),
						'other' => q({0} метричної пінти),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'1' => q(feminine),
						'few' => q({0} метричні пінти),
						'many' => q({0} метричних пінт),
						'name' => q(метрична пінта),
						'one' => q({0} метрична пінта),
						'other' => q({0} метричної пінти),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'few' => q({0} кварти),
						'many' => q({0} кварт),
						'name' => q(кварти),
						'one' => q({0} кварта),
						'other' => q({0} кварти),
					},
					# Core Unit Identifier
					'quart' => {
						'few' => q({0} кварти),
						'many' => q({0} кварт),
						'name' => q(кварти),
						'one' => q({0} кварта),
						'other' => q({0} кварти),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'few' => q({0} імп. кварти),
						'many' => q({0} імп. кварт),
						'name' => q(імперська кварта),
						'one' => q({0} імп. кварта),
						'other' => q({0} імп. кварти),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'few' => q({0} імп. кварти),
						'many' => q({0} імп. кварт),
						'name' => q(імперська кварта),
						'one' => q({0} імп. кварта),
						'other' => q({0} імп. кварти),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'few' => q({0} столові ложки),
						'many' => q({0} столових ложок),
						'name' => q(cтолові ложки),
						'one' => q({0} столова ложка),
						'other' => q({0} столової ложки),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'few' => q({0} столові ложки),
						'many' => q({0} столових ложок),
						'name' => q(cтолові ложки),
						'one' => q({0} столова ложка),
						'other' => q({0} столової ложки),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'few' => q({0} чайні ложки),
						'many' => q({0} чайних ложок),
						'name' => q(чайні ложки),
						'one' => q({0} чайна ложка),
						'other' => q({0} чайної ложки),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'few' => q({0} чайні ложки),
						'many' => q({0} чайних ложок),
						'name' => q(чайні ложки),
						'one' => q({0} чайна ложка),
						'other' => q({0} чайної ложки),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(напрям),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(напрям),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Кі{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Кі{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Мі{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Мі{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Гі{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Гі{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ті{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ті{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Пі{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Пі{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Еі{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Еі{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Зі{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Зі{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Йі{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Йі{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(д{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(д{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(п{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(п{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ф{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ф{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(а{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(а{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(с{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(с{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зп{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зп{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(й{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(й{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(м{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(м{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(мк{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(мк{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(н{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(н{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(Е{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(Е{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(Й{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(Й{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'few' => q({0}g),
						'many' => q({0}g),
						'name' => q(g),
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'g-force' => {
						'few' => q({0}g),
						'many' => q({0}g),
						'name' => q(g),
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'few' => q({0}м/с²),
						'many' => q({0}м/с²),
						'name' => q(м/с²),
						'one' => q({0}м/с²),
						'other' => q({0}м/с²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'few' => q({0}м/с²),
						'many' => q({0}м/с²),
						'name' => q(м/с²),
						'one' => q({0}м/с²),
						'other' => q({0}м/с²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'name' => q(′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'name' => q(′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'few' => q({0}″),
						'many' => q({0}″),
						'name' => q(″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'few' => q({0}″),
						'many' => q({0}″),
						'name' => q(″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(рад.),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(рад.),
					},
					# Long Unit Identifier
					'area-acre' => {
						'few' => q({0} акр),
						'many' => q({0} акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					# Core Unit Identifier
					'acre' => {
						'few' => q({0} акр),
						'many' => q({0} акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'few' => q({0}дун.),
						'many' => q({0}дун.),
						'name' => q(дунам),
						'one' => q({0}дунам),
						'other' => q({0}дун.),
					},
					# Core Unit Identifier
					'dunam' => {
						'few' => q({0}дун.),
						'many' => q({0}дун.),
						'name' => q(дунам),
						'one' => q({0}дунам),
						'other' => q({0}дун.),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'few' => q({0}га),
						'many' => q({0}га),
						'name' => q(га),
						'one' => q({0}га),
						'other' => q({0}га),
					},
					# Core Unit Identifier
					'hectare' => {
						'few' => q({0}га),
						'many' => q({0}га),
						'name' => q(га),
						'one' => q({0}га),
						'other' => q({0}га),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'few' => q({0} фт²),
						'many' => q({0} фт²),
						'name' => q(фт²),
						'one' => q({0} фт²),
						'other' => q({0} фт²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'few' => q({0} фт²),
						'many' => q({0} фт²),
						'name' => q(фт²),
						'one' => q({0} фт²),
						'other' => q({0} фт²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'few' => q({0} км²),
						'many' => q({0} км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'few' => q({0} км²),
						'many' => q({0} км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'few' => q({0} м²),
						'many' => q({0} м²),
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'few' => q({0} м²),
						'many' => q({0} м²),
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'few' => q({0} мл²),
						'many' => q({0} мл²),
						'one' => q({0} мл²),
						'other' => q({0} мл²),
						'per' => q({0}/мл²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'few' => q({0} мл²),
						'many' => q({0} мл²),
						'one' => q({0} мл²),
						'other' => q({0} мл²),
						'per' => q({0}/мл²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'few' => q({0}ел.),
						'many' => q({0}ел.),
						'name' => q(ел.),
						'one' => q({0}ел.),
						'other' => q({0}ел.),
					},
					# Core Unit Identifier
					'item' => {
						'few' => q({0}ел.),
						'many' => q({0}ел.),
						'name' => q(ел.),
						'one' => q({0}ел.),
						'other' => q({0}ел.),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(кар.),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(кар.),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ммоль/л),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ммоль/л),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'few' => q({0}моль),
						'many' => q({0}моль),
						'one' => q({0}моль),
						'other' => q({0}моль),
					},
					# Core Unit Identifier
					'mole' => {
						'few' => q({0}моль),
						'many' => q({0}моль),
						'one' => q({0}моль),
						'other' => q({0}моль),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'few' => q({0}%),
						'many' => q({0}%),
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'few' => q({0}%),
						'many' => q({0}%),
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'few' => q({0} м. д.),
						'many' => q({0} м. д.),
						'name' => q(м. д.),
						'one' => q({0} м. д.),
						'other' => q({0} м. д.),
					},
					# Core Unit Identifier
					'permillion' => {
						'few' => q({0} м. д.),
						'many' => q({0} м. д.),
						'name' => q(м. д.),
						'one' => q({0} м. д.),
						'other' => q({0} м. д.),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(‱),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(‱),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'few' => q({0} л/100 км),
						'many' => q({0} л/100 км),
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'few' => q({0} л/100 км),
						'many' => q({0} л/100 км),
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'few' => q({0} мл/гал),
						'many' => q({0} мл/гал),
						'name' => q(мл/гал),
						'one' => q({0} мл/гал),
						'other' => q({0} мл/гал),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'few' => q({0} мл/гал),
						'many' => q({0} мл/гал),
						'name' => q(мл/гал),
						'one' => q({0} мл/гал),
						'other' => q({0} мл/гал),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'few' => q({0} мл/англ. гал.),
						'many' => q({0} мл/англ. гал.),
						'name' => q(мл/англ. гал.),
						'one' => q({0} мл/англ. гал.),
						'other' => q({0} мл/англ. гал.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'few' => q({0} мл/англ. гал.),
						'many' => q({0} мл/англ. гал.),
						'name' => q(мл/англ. гал.),
						'one' => q({0} мл/англ. гал.),
						'other' => q({0} мл/англ. гал.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}Сх),
						'north' => q({0}Пн),
						'south' => q({0}Пд),
						'west' => q({0}Зх),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}Сх),
						'north' => q({0}Пн),
						'south' => q({0}Пд),
						'west' => q({0}Зх),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(б),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(б),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(Б),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(Б),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Гб),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Гб),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ГБ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ГБ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(кб),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(кб),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(кБ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(кБ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Мб),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Мб),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(МБ),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(МБ),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Тб),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Тб),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ТБ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ТБ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'few' => q({0}ст),
						'many' => q({0}ст),
						'name' => q(ст),
						'one' => q({0}ст),
						'other' => q({0}ст),
					},
					# Core Unit Identifier
					'century' => {
						'few' => q({0}ст),
						'many' => q({0}ст),
						'name' => q(ст),
						'one' => q({0}ст),
						'other' => q({0}ст),
					},
					# Long Unit Identifier
					'duration-day' => {
						'few' => q({0}д),
						'many' => q({0}д),
						'name' => q(д),
						'one' => q({0}д),
						'other' => q({0}д),
						'per' => q({0}/д),
					},
					# Core Unit Identifier
					'day' => {
						'few' => q({0}д),
						'many' => q({0}д),
						'name' => q(д),
						'one' => q({0}д),
						'other' => q({0}д),
						'per' => q({0}/д),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'few' => q({0} год.),
						'many' => q({0} год.),
						'name' => q(г),
						'one' => q({0} год.),
						'other' => q({0} год.),
						'per' => q({0}/г),
					},
					# Core Unit Identifier
					'hour' => {
						'few' => q({0} год.),
						'many' => q({0} год.),
						'name' => q(г),
						'one' => q({0} год.),
						'other' => q({0} год.),
						'per' => q({0}/г),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'few' => q({0}мкс),
						'many' => q({0}мкс),
						'name' => q(мкс),
						'one' => q({0}мкс),
						'other' => q({0}мкс),
					},
					# Core Unit Identifier
					'microsecond' => {
						'few' => q({0}мкс),
						'many' => q({0}мкс),
						'name' => q(мкс),
						'one' => q({0}мкс),
						'other' => q({0}мкс),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'few' => q({0}мс),
						'many' => q({0}мс),
						'name' => q(мс),
						'one' => q({0}мс),
						'other' => q({0}мс),
					},
					# Core Unit Identifier
					'millisecond' => {
						'few' => q({0}мс),
						'many' => q({0}мс),
						'name' => q(мс),
						'one' => q({0}мс),
						'other' => q({0}мс),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'few' => q({0}х),
						'many' => q({0}х),
						'name' => q(х),
						'one' => q({0}х),
						'other' => q({0}х),
						'per' => q({0}/х),
					},
					# Core Unit Identifier
					'minute' => {
						'few' => q({0}х),
						'many' => q({0}х),
						'name' => q(х),
						'one' => q({0}х),
						'other' => q({0}х),
						'per' => q({0}/х),
					},
					# Long Unit Identifier
					'duration-month' => {
						'few' => q({0}м),
						'many' => q({0}м),
						'name' => q(м),
						'one' => q({0}м),
						'other' => q({0}м),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'month' => {
						'few' => q({0}м),
						'many' => q({0}м),
						'name' => q(м),
						'one' => q({0}м),
						'other' => q({0}м),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'few' => q({0}нс),
						'many' => q({0}нс),
						'name' => q(нс),
						'one' => q({0}нс),
						'other' => q({0}нс),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'few' => q({0}нс),
						'many' => q({0}нс),
						'name' => q(нс),
						'one' => q({0}нс),
						'other' => q({0}нс),
					},
					# Long Unit Identifier
					'duration-second' => {
						'few' => q({0}с),
						'many' => q({0}с),
						'name' => q(с),
						'one' => q({0}с),
						'other' => q({0}с),
						'per' => q({0}/с),
					},
					# Core Unit Identifier
					'second' => {
						'few' => q({0}с),
						'many' => q({0}с),
						'name' => q(с),
						'one' => q({0}с),
						'other' => q({0}с),
						'per' => q({0}/с),
					},
					# Long Unit Identifier
					'duration-week' => {
						'few' => q({0}т),
						'many' => q({0}т),
						'name' => q(т),
						'one' => q({0}т),
						'other' => q({0}т),
						'per' => q({0}/т),
					},
					# Core Unit Identifier
					'week' => {
						'few' => q({0}т),
						'many' => q({0}т),
						'name' => q(т),
						'one' => q({0}т),
						'other' => q({0}т),
						'per' => q({0}/т),
					},
					# Long Unit Identifier
					'duration-year' => {
						'few' => q({0}р),
						'many' => q({0}р),
						'name' => q(р),
						'one' => q({0}р),
						'other' => q({0}р),
						'per' => q({0}/р),
					},
					# Core Unit Identifier
					'year' => {
						'few' => q({0}р),
						'many' => q({0}р),
						'name' => q(р),
						'one' => q({0}р),
						'other' => q({0}р),
						'per' => q({0}/р),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ом),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ом),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(В),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(В),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'few' => q({0}Отб),
						'many' => q({0}Отб),
						'one' => q({0}Отб),
						'other' => q({0}Отб),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'few' => q({0}Отб),
						'many' => q({0}Отб),
						'one' => q({0}Отб),
						'other' => q({0}Отб),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'few' => q({0}еВ),
						'many' => q({0}еВ),
						'name' => q(еВ),
						'one' => q({0}еВ),
						'other' => q({0}еВ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'few' => q({0}еВ),
						'many' => q({0}еВ),
						'name' => q(еВ),
						'one' => q({0}еВ),
						'other' => q({0}еВ),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(Дж),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(Дж),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(кДж),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(кДж),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'few' => q({0} кВт⋅год),
						'many' => q({0} кВт⋅год),
						'name' => q(кВт⋅год),
						'one' => q({0} кВт⋅год),
						'other' => q({0} кВт⋅год),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'few' => q({0} кВт⋅год),
						'many' => q({0} кВт⋅год),
						'name' => q(кВт⋅год),
						'one' => q({0} кВт⋅год),
						'other' => q({0} кВт⋅год),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'few' => q({0} ам. терм.),
						'many' => q({0} ам. терм.),
						'name' => q(ам. терм.),
						'one' => q({0} ам. терм.),
						'other' => q({0} ам. терм.),
					},
					# Core Unit Identifier
					'therm-us' => {
						'few' => q({0} ам. терм.),
						'many' => q({0} ам. терм.),
						'name' => q(ам. терм.),
						'one' => q({0} ам. терм.),
						'other' => q({0} ам. терм.),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'few' => q({0}кВт⋅год/100км),
						'many' => q({0}кВт⋅год/100км),
						'name' => q(кВт⋅год/100 км),
						'one' => q({0}кВт⋅год/100км),
						'other' => q({0}кВт⋅год/100км),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'few' => q({0}кВт⋅год/100км),
						'many' => q({0}кВт⋅год/100км),
						'name' => q(кВт⋅год/100 км),
						'one' => q({0}кВт⋅год/100км),
						'other' => q({0}кВт⋅год/100км),
					},
					# Long Unit Identifier
					'force-newton' => {
						'few' => q({0}Н),
						'many' => q({0}Н),
						'name' => q(Н),
						'one' => q({0}Н),
						'other' => q({0}Н),
					},
					# Core Unit Identifier
					'newton' => {
						'few' => q({0}Н),
						'many' => q({0}Н),
						'name' => q(Н),
						'one' => q({0}Н),
						'other' => q({0}Н),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'few' => q({0}фнтс),
						'many' => q({0}фнтс),
						'name' => q(фнтс),
						'one' => q({0}фнтс),
						'other' => q({0}фнтс),
					},
					# Core Unit Identifier
					'pound-force' => {
						'few' => q({0}фнтс),
						'many' => q({0}фнтс),
						'name' => q(фнтс),
						'one' => q({0}фнтс),
						'other' => q({0}фнтс),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'few' => q({0} тчк/см),
						'many' => q({0} тчк/см),
						'name' => q(тчк/см),
						'one' => q({0} тчк/см),
						'other' => q({0} тчк/см),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'few' => q({0} тчк/см),
						'many' => q({0} тчк/см),
						'name' => q(тчк/см),
						'one' => q({0} тчк/см),
						'other' => q({0} тчк/см),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'few' => q({0} тчк/“),
						'many' => q({0} тчк/“),
						'name' => q(тчк/“),
						'one' => q({0} тчк/“),
						'other' => q({0} тчк/“),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'few' => q({0} тчк/“),
						'many' => q({0} тчк/“),
						'name' => q(тчк/“),
						'one' => q({0} тчк/“),
						'other' => q({0} тчк/“),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'few' => q({0} ем),
						'many' => q({0} ем),
						'name' => q(ем),
						'one' => q({0} ем),
						'other' => q({0} ем),
					},
					# Core Unit Identifier
					'em' => {
						'few' => q({0} ем),
						'many' => q({0} ем),
						'name' => q(ем),
						'one' => q({0} ем),
						'other' => q({0} ем),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'few' => q({0}Мп),
						'many' => q({0}Мп),
						'one' => q({0}Мп),
						'other' => q({0}Мп),
					},
					# Core Unit Identifier
					'megapixel' => {
						'few' => q({0}Мп),
						'many' => q({0}Мп),
						'one' => q({0}Мп),
						'other' => q({0}Мп),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'few' => q({0}п),
						'many' => q({0}п),
						'name' => q(п),
						'one' => q({0}п),
						'other' => q({0}п),
					},
					# Core Unit Identifier
					'pixel' => {
						'few' => q({0}п),
						'many' => q({0}п),
						'name' => q(п),
						'one' => q({0}п),
						'other' => q({0}п),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'few' => q({0} пкс/см),
						'many' => q({0} пкс/см),
						'name' => q(пкс/см),
						'one' => q({0} пкс/см),
						'other' => q({0} пкс/см),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'few' => q({0} пкс/см),
						'many' => q({0} пкс/см),
						'name' => q(пкс/см),
						'one' => q({0} пкс/см),
						'other' => q({0} пкс/см),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'few' => q({0} пкс/“),
						'many' => q({0} пкс/“),
						'name' => q(пкс/“),
						'one' => q({0} пкс/“),
						'other' => q({0} пкс/“),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'few' => q({0} пкс/“),
						'many' => q({0} пкс/“),
						'name' => q(пкс/“),
						'one' => q({0} пкс/“),
						'other' => q({0} пкс/“),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'few' => q({0} см),
						'many' => q({0} см),
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Core Unit Identifier
					'centimeter' => {
						'few' => q({0} см),
						'many' => q({0} см),
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'few' => q({0}дм),
						'many' => q({0}дм),
						'name' => q(дм),
						'one' => q({0}дм),
						'other' => q({0}дм),
					},
					# Core Unit Identifier
					'decimeter' => {
						'few' => q({0}дм),
						'many' => q({0}дм),
						'name' => q(дм),
						'one' => q({0}дм),
						'other' => q({0}дм),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'few' => q({0} фтм),
						'many' => q({0} фтм),
						'name' => q(фтм),
						'one' => q({0} фтм),
						'other' => q({0} фтм),
					},
					# Core Unit Identifier
					'fathom' => {
						'few' => q({0} фтм),
						'many' => q({0} фтм),
						'name' => q(фтм),
						'one' => q({0} фтм),
						'other' => q({0} фтм),
					},
					# Long Unit Identifier
					'length-foot' => {
						'few' => q({0} фт),
						'many' => q({0} фт),
						'name' => q(фт),
						'one' => q({0} фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Core Unit Identifier
					'foot' => {
						'few' => q({0} фт),
						'many' => q({0} фт),
						'name' => q(фт),
						'one' => q({0} фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'few' => q({0} фрл),
						'many' => q({0} фрл),
						'name' => q(фрл),
						'one' => q({0} фрл),
						'other' => q({0} фрл),
					},
					# Core Unit Identifier
					'furlong' => {
						'few' => q({0} фрл),
						'many' => q({0} фрл),
						'name' => q(фрл),
						'one' => q({0} фрл),
						'other' => q({0} фрл),
					},
					# Long Unit Identifier
					'length-inch' => {
						'few' => q({0} дм),
						'many' => q({0} дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
						'per' => q({0}/дм),
					},
					# Core Unit Identifier
					'inch' => {
						'few' => q({0} дм),
						'many' => q({0} дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
						'per' => q({0}/дм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'few' => q({0} км),
						'many' => q({0} км),
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Core Unit Identifier
					'kilometer' => {
						'few' => q({0} км),
						'many' => q({0} км),
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'few' => q({0} св. р.),
						'many' => q({0} св. р.),
						'one' => q({0} св. р.),
						'other' => q({0} св. р.),
					},
					# Core Unit Identifier
					'light-year' => {
						'few' => q({0} св. р.),
						'many' => q({0} св. р.),
						'one' => q({0} св. р.),
						'other' => q({0} св. р.),
					},
					# Long Unit Identifier
					'length-meter' => {
						'few' => q({0}м),
						'many' => q({0}м),
						'name' => q(м),
						'one' => q({0}м),
						'other' => q({0}м),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'meter' => {
						'few' => q({0}м),
						'many' => q({0}м),
						'name' => q(м),
						'one' => q({0}м),
						'other' => q({0}м),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'few' => q({0}мкм),
						'many' => q({0}мкм),
						'name' => q(мкм),
						'one' => q({0}мкм),
						'other' => q({0}мкм),
					},
					# Core Unit Identifier
					'micrometer' => {
						'few' => q({0}мкм),
						'many' => q({0}мкм),
						'name' => q(мкм),
						'one' => q({0}мкм),
						'other' => q({0}мкм),
					},
					# Long Unit Identifier
					'length-mile' => {
						'few' => q({0} мл),
						'many' => q({0} мл),
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Core Unit Identifier
					'mile' => {
						'few' => q({0} мл),
						'many' => q({0} мл),
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'few' => q({0} сканд. мл),
						'many' => q({0} сканд. мл),
						'name' => q(міл),
						'one' => q({0} сканд. мл),
						'other' => q({0} сканд. мл),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'few' => q({0} сканд. мл),
						'many' => q({0} сканд. мл),
						'name' => q(міл),
						'one' => q({0} сканд. мл),
						'other' => q({0} сканд. мл),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'few' => q({0} мм),
						'many' => q({0} мм),
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Core Unit Identifier
					'millimeter' => {
						'few' => q({0} мм),
						'many' => q({0} мм),
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'few' => q({0}нм),
						'many' => q({0}нм),
						'name' => q(нм),
						'one' => q({0}нм),
						'other' => q({0}нм),
					},
					# Core Unit Identifier
					'nanometer' => {
						'few' => q({0}нм),
						'many' => q({0}нм),
						'name' => q(нм),
						'one' => q({0}нм),
						'other' => q({0}нм),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'few' => q({0} м. мл),
						'many' => q({0} м. мл),
						'one' => q({0} м. мл),
						'other' => q({0} м. мл),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'few' => q({0} м. мл),
						'many' => q({0} м. мл),
						'one' => q({0} м. мл),
						'other' => q({0} м. мл),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'few' => q({0}пк),
						'many' => q({0}пк),
						'name' => q(парсек),
						'one' => q({0}пк),
						'other' => q({0}пк),
					},
					# Core Unit Identifier
					'parsec' => {
						'few' => q({0}пк),
						'many' => q({0}пк),
						'name' => q(парсек),
						'one' => q({0}пк),
						'other' => q({0}пк),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'few' => q({0} пм),
						'many' => q({0} пм),
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Core Unit Identifier
					'picometer' => {
						'few' => q({0} пм),
						'many' => q({0} пм),
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Long Unit Identifier
					'length-point' => {
						'few' => q({0}пт),
						'many' => q({0}пт),
						'name' => q(пт),
						'one' => q({0}пт),
						'other' => q({0}пт),
					},
					# Core Unit Identifier
					'point' => {
						'few' => q({0}пт),
						'many' => q({0}пт),
						'name' => q(пт),
						'one' => q({0}пт),
						'other' => q({0}пт),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'few' => q({0}R☉),
						'many' => q({0}R☉),
						'name' => q(R☉),
						'one' => q({0}R☉),
						'other' => q({0}R☉),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'few' => q({0}R☉),
						'many' => q({0}R☉),
						'name' => q(R☉),
						'one' => q({0}R☉),
						'other' => q({0}R☉),
					},
					# Long Unit Identifier
					'length-yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					# Core Unit Identifier
					'yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(лк),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(лк),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'few' => q({0}L☉),
						'many' => q({0}L☉),
						'name' => q(L☉),
						'one' => q({0}L☉),
						'other' => q({0}L☉),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'few' => q({0}L☉),
						'many' => q({0}L☉),
						'name' => q(L☉),
						'one' => q({0}L☉),
						'other' => q({0}L☉),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'few' => q({0} кар.),
						'many' => q({0} кар.),
						'name' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Core Unit Identifier
					'carat' => {
						'few' => q({0} кар.),
						'many' => q({0} кар.),
						'name' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'few' => q({0}Да),
						'many' => q({0}Да),
						'name' => q(Да),
						'one' => q({0}Да),
						'other' => q({0}Да),
					},
					# Core Unit Identifier
					'dalton' => {
						'few' => q({0}Да),
						'many' => q({0}Да),
						'name' => q(Да),
						'one' => q({0}Да),
						'other' => q({0}Да),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'few' => q({0}M⊕),
						'many' => q({0}M⊕),
						'name' => q(M⊕),
						'one' => q({0}M⊕),
						'other' => q({0}M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'few' => q({0}M⊕),
						'many' => q({0}M⊕),
						'name' => q(M⊕),
						'one' => q({0}M⊕),
						'other' => q({0}M⊕),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'few' => q({0} гр.),
						'many' => q({0} гр.),
						'name' => q(гр.),
						'one' => q({0} гр.),
						'other' => q({0} гр.),
					},
					# Core Unit Identifier
					'grain' => {
						'few' => q({0} гр.),
						'many' => q({0} гр.),
						'name' => q(гр.),
						'one' => q({0} гр.),
						'other' => q({0} гр.),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'few' => q({0}г),
						'many' => q({0}г),
						'name' => q(г),
						'one' => q({0}г),
						'other' => q({0}г),
						'per' => q({0}/г),
					},
					# Core Unit Identifier
					'gram' => {
						'few' => q({0}г),
						'many' => q({0}г),
						'name' => q(г),
						'one' => q({0}г),
						'other' => q({0}г),
						'per' => q({0}/г),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'few' => q({0}кг),
						'many' => q({0}кг),
						'name' => q(кг),
						'one' => q({0}кг),
						'other' => q({0}кг),
						'per' => q({0}/кг),
					},
					# Core Unit Identifier
					'kilogram' => {
						'few' => q({0}кг),
						'many' => q({0}кг),
						'name' => q(кг),
						'one' => q({0}кг),
						'other' => q({0}кг),
						'per' => q({0}/кг),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'few' => q({0}т),
						'many' => q({0}т),
						'name' => q(т),
						'one' => q({0}т),
						'other' => q({0}т),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'few' => q({0}т),
						'many' => q({0}т),
						'name' => q(т),
						'one' => q({0}т),
						'other' => q({0}т),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'few' => q({0}мкг),
						'many' => q({0}мкг),
						'one' => q({0}мкг),
						'other' => q({0}мкг),
					},
					# Core Unit Identifier
					'microgram' => {
						'few' => q({0}мкг),
						'many' => q({0}мкг),
						'one' => q({0}мкг),
						'other' => q({0}мкг),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'few' => q({0}мг),
						'many' => q({0}мг),
						'one' => q({0}мг),
						'other' => q({0}мг),
					},
					# Core Unit Identifier
					'milligram' => {
						'few' => q({0}мг),
						'many' => q({0}мг),
						'one' => q({0}мг),
						'other' => q({0}мг),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'few' => q({0} ун.),
						'many' => q({0} ун.),
						'name' => q(ун.),
						'one' => q({0} ун.),
						'other' => q({0} ун.),
						'per' => q({0}/ун),
					},
					# Core Unit Identifier
					'ounce' => {
						'few' => q({0} ун.),
						'many' => q({0} ун.),
						'name' => q(ун.),
						'one' => q({0} ун.),
						'other' => q({0} ун.),
						'per' => q({0}/ун),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'few' => q({0} тр. ун.),
						'many' => q({0} тр. ун.),
						'name' => q(тр. ун.),
						'one' => q({0} тр. ун.),
						'other' => q({0} тр. ун.),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'few' => q({0} тр. ун.),
						'many' => q({0} тр. ун.),
						'name' => q(тр. ун.),
						'one' => q({0} тр. ун.),
						'other' => q({0} тр. ун.),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'few' => q({0} фнт),
						'many' => q({0} фнт),
						'name' => q(фнт),
						'one' => q({0} фнт),
						'other' => q({0} фнт),
						'per' => q({0}/фнт),
					},
					# Core Unit Identifier
					'pound' => {
						'few' => q({0} фнт),
						'many' => q({0} фнт),
						'name' => q(фнт),
						'one' => q({0} фнт),
						'other' => q({0} фнт),
						'per' => q({0}/фнт),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'few' => q({0}M☉),
						'many' => q({0}M☉),
						'name' => q(M☉),
						'one' => q({0}M☉),
						'other' => q({0}M☉),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'few' => q({0}M☉),
						'many' => q({0}M☉),
						'name' => q(M☉),
						'one' => q({0}M☉),
						'other' => q({0}M☉),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'few' => q({0} стн),
						'many' => q({0} стн),
						'name' => q(стн),
						'one' => q({0} стн),
						'other' => q({0} стн),
					},
					# Core Unit Identifier
					'stone' => {
						'few' => q({0} стн),
						'many' => q({0} стн),
						'name' => q(стн),
						'one' => q({0} стн),
						'other' => q({0} стн),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'few' => q({0}т),
						'many' => q({0}т),
						'name' => q(тонни),
						'one' => q({0}т),
						'other' => q({0}т),
					},
					# Core Unit Identifier
					'ton' => {
						'few' => q({0}т),
						'many' => q({0}т),
						'name' => q(тонни),
						'one' => q({0}т),
						'other' => q({0}т),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'few' => q({0} к.с.),
						'many' => q({0} к.с.),
						'one' => q({0} к.с.),
						'other' => q({0} к.с.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'few' => q({0} к.с.),
						'many' => q({0} к.с.),
						'one' => q({0} к.с.),
						'other' => q({0} к.с.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'few' => q({0} кВт),
						'many' => q({0} кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'few' => q({0} кВт),
						'many' => q({0} кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'few' => q({0} Вт),
						'many' => q({0} Вт),
						'name' => q(Вт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Core Unit Identifier
					'watt' => {
						'few' => q({0} Вт),
						'many' => q({0} Вт),
						'name' => q(Вт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'few' => q({0} гПа),
						'many' => q({0} гПа),
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'few' => q({0} гПа),
						'many' => q({0} гПа),
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'few' => q({0} мбари),
						'many' => q({0} мбарів),
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбара),
					},
					# Core Unit Identifier
					'millibar' => {
						'few' => q({0} мбари),
						'many' => q({0} мбарів),
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбара),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'few' => q({0}ммрс),
						'many' => q({0}ммрс),
						'name' => q(ммрс),
						'one' => q({0}ммрс),
						'other' => q({0}ммрс),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'few' => q({0}ммрс),
						'many' => q({0}ммрс),
						'name' => q(ммрс),
						'one' => q({0}ммрс),
						'other' => q({0}ммрс),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'few' => q({0}psi),
						'many' => q({0}psi),
						'name' => q(фнт/дюйм²),
						'one' => q({0}psi),
						'other' => q({0}psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'few' => q({0}psi),
						'many' => q({0}psi),
						'name' => q(фнт/дюйм²),
						'one' => q({0}psi),
						'other' => q({0}psi),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'few' => q({0} км/год),
						'many' => q({0} км/год),
						'name' => q(км/год),
						'one' => q({0} км/год),
						'other' => q({0} км/год),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'few' => q({0} км/год),
						'many' => q({0} км/год),
						'name' => q(км/год),
						'one' => q({0} км/год),
						'other' => q({0} км/год),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'few' => q({0} вуз.),
						'many' => q({0} вуз.),
						'name' => q(вуз.),
						'one' => q({0} вуз.),
						'other' => q({0} вуз.),
					},
					# Core Unit Identifier
					'knot' => {
						'few' => q({0} вуз.),
						'many' => q({0} вуз.),
						'name' => q(вуз.),
						'one' => q({0} вуз.),
						'other' => q({0} вуз.),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'few' => q({0} м/с),
						'many' => q({0} м/с),
						'name' => q(м/с),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'few' => q({0} м/с),
						'many' => q({0} м/с),
						'name' => q(м/с),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'few' => q({0} мл/год),
						'many' => q({0} мл/год),
						'name' => q(мл/год),
						'one' => q({0} мл/год),
						'other' => q({0} мл/год),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'few' => q({0} мл/год),
						'many' => q({0} мл/год),
						'name' => q(мл/год),
						'one' => q({0} мл/год),
						'other' => q({0} мл/год),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'few' => q({0}°C),
						'many' => q({0}°C),
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'few' => q({0}°C),
						'many' => q({0}°C),
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'few' => q({0} К),
						'many' => q({0} К),
						'name' => q(К),
						'one' => q({0} К),
						'other' => q({0} К),
					},
					# Core Unit Identifier
					'kelvin' => {
						'few' => q({0} К),
						'many' => q({0} К),
						'name' => q(К),
						'one' => q({0} К),
						'other' => q({0} К),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'few' => q({0}Н·м),
						'many' => q({0}Н·м),
						'one' => q({0}Н·м),
						'other' => q({0}Н·м),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'few' => q({0}Н·м),
						'many' => q({0}Н·м),
						'one' => q({0}Н·м),
						'other' => q({0}Н·м),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'few' => q({0}фн-фт),
						'many' => q({0}фн-фт),
						'one' => q({0}фн-фт),
						'other' => q({0}фн-фт),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'few' => q({0}фн-фт),
						'many' => q({0}фн-фт),
						'one' => q({0}фн-фт),
						'other' => q({0}фн-фт),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'few' => q({0} акр-фт),
						'many' => q({0} акр-фт),
						'name' => q(акр-фт),
						'one' => q({0} акр-фт),
						'other' => q({0} акр-фт),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'few' => q({0} акр-фт),
						'many' => q({0} акр-фт),
						'name' => q(акр-фт),
						'one' => q({0} акр-фт),
						'other' => q({0} акр-фт),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'few' => q({0} брл),
						'many' => q({0} брл),
						'name' => q(брл),
						'one' => q({0} брл),
						'other' => q({0} брл),
					},
					# Core Unit Identifier
					'barrel' => {
						'few' => q({0} брл),
						'many' => q({0} брл),
						'name' => q(брл),
						'one' => q({0} брл),
						'other' => q({0} брл),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'few' => q({0}буш),
						'many' => q({0}буш),
						'name' => q(буш.),
						'one' => q({0}буш),
						'other' => q({0}буш),
					},
					# Core Unit Identifier
					'bushel' => {
						'few' => q({0}буш),
						'many' => q({0}буш),
						'name' => q(буш.),
						'one' => q({0}буш),
						'other' => q({0}буш),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'few' => q({0} фт³),
						'many' => q({0} фт³),
						'name' => q(фт³),
						'one' => q({0} фт³),
						'other' => q({0} фт³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'few' => q({0} фт³),
						'many' => q({0} фт³),
						'name' => q(фт³),
						'one' => q({0} фт³),
						'other' => q({0} фт³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'few' => q({0} км³),
						'many' => q({0} км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'few' => q({0} км³),
						'many' => q({0} км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'few' => q({0} милі³),
						'many' => q({0} миль³),
						'one' => q({0} миля³),
						'other' => q({0} милі³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'few' => q({0} милі³),
						'many' => q({0} миль³),
						'one' => q({0} миля³),
						'other' => q({0} милі³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'few' => q({0} чаш.),
						'many' => q({0} чаш.),
						'name' => q(чаш.),
						'one' => q({0} чаш.),
						'other' => q({0} чаш.),
					},
					# Core Unit Identifier
					'cup' => {
						'few' => q({0} чаш.),
						'many' => q({0} чаш.),
						'name' => q(чаш.),
						'one' => q({0} чаш.),
						'other' => q({0} чаш.),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'few' => q({0} м. чаш.),
						'many' => q({0} м. чаш.),
						'name' => q(м. чаш.),
						'one' => q({0} м. чаш.),
						'other' => q({0} м. чаш.),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'few' => q({0} м. чаш.),
						'many' => q({0} м. чаш.),
						'name' => q(м. чаш.),
						'one' => q({0} м. чаш.),
						'other' => q({0} м. чаш.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'few' => q({0} англ. дес. л.),
						'many' => q({0} англ. дес. л.),
						'name' => q(англ. дес. л.),
						'one' => q({0} англ. дес. л.),
						'other' => q({0} англ. дес. л.),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'few' => q({0} англ. дес. л.),
						'many' => q({0} англ. дес. л.),
						'name' => q(англ. дес. л.),
						'one' => q({0} англ. дес. л.),
						'other' => q({0} англ. дес. л.),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'few' => q({0} рід. дрхм),
						'many' => q({0} рід. дрхм),
						'name' => q(рід. дрхм),
						'one' => q({0} рід. дрхм),
						'other' => q({0} рід. дрхм),
					},
					# Core Unit Identifier
					'dram' => {
						'few' => q({0} рід. дрхм),
						'many' => q({0} рід. дрхм),
						'name' => q(рід. дрхм),
						'one' => q({0} рід. дрхм),
						'other' => q({0} рід. дрхм),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'few' => q({0} кр.),
						'many' => q({0} кр.),
						'name' => q(кр.),
						'one' => q({0} кр.),
						'other' => q({0} кр.),
					},
					# Core Unit Identifier
					'drop' => {
						'few' => q({0} кр.),
						'many' => q({0} кр.),
						'name' => q(кр.),
						'one' => q({0} кр.),
						'other' => q({0} кр.),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'few' => q({0} англ. рід. ун.),
						'many' => q({0} англ. рід. ун.),
						'name' => q(англ. рід. ун.),
						'one' => q({0} англ. рід. ун.),
						'other' => q({0} англ. рід. ун.),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'few' => q({0} англ. рід. ун.),
						'many' => q({0} англ. рід. ун.),
						'name' => q(англ. рід. ун.),
						'one' => q({0} англ. рід. ун.),
						'other' => q({0} англ. рід. ун.),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'few' => q({0} англ. гал.),
						'many' => q({0} англ. гал.),
						'name' => q(англ. гал.),
						'one' => q({0} англ. гал.),
						'other' => q({0} англ. гал.),
						'per' => q({0}/англ. гал.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'few' => q({0} англ. гал.),
						'many' => q({0} англ. гал.),
						'name' => q(англ. гал.),
						'one' => q({0} англ. гал.),
						'other' => q({0} англ. гал.),
						'per' => q({0}/англ. гал.),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'few' => q({0} мір.),
						'many' => q({0} мір.),
						'name' => q(мір.),
						'one' => q({0} мір.),
						'other' => q({0} мір.),
					},
					# Core Unit Identifier
					'jigger' => {
						'few' => q({0} мір.),
						'many' => q({0} мір.),
						'name' => q(мір.),
						'one' => q({0} мір.),
						'other' => q({0} мір.),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'few' => q({0}л),
						'many' => q({0}л),
						'name' => q(л),
						'one' => q({0}л),
						'other' => q({0}л),
					},
					# Core Unit Identifier
					'liter' => {
						'few' => q({0}л),
						'many' => q({0}л),
						'name' => q(л),
						'one' => q({0}л),
						'other' => q({0}л),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'few' => q({0} дріб.),
						'many' => q({0} дріб.),
						'name' => q(дріб.),
						'one' => q({0} дріб.),
						'other' => q({0} дріб.),
					},
					# Core Unit Identifier
					'pinch' => {
						'few' => q({0} дріб.),
						'many' => q({0} дріб.),
						'name' => q(дріб.),
						'one' => q({0} дріб.),
						'other' => q({0} дріб.),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'few' => q({0} пінт.),
						'many' => q({0} пінт.),
						'name' => q(пінт.),
						'one' => q({0} пінт.),
						'other' => q({0} пінт.),
					},
					# Core Unit Identifier
					'pint' => {
						'few' => q({0} пінт.),
						'many' => q({0} пінт.),
						'name' => q(пінт.),
						'one' => q({0} пінт.),
						'other' => q({0} пінт.),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'few' => q({0} м. пінт.),
						'many' => q({0} м. пінт.),
						'name' => q(м. пінт.),
						'one' => q({0} м. пінт.),
						'other' => q({0} м. пінт.),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'few' => q({0} м. пінт.),
						'many' => q({0} м. пінт.),
						'name' => q(м. пінт.),
						'one' => q({0} м. пінт.),
						'other' => q({0} м. пінт.),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'few' => q({0} англ. квар.),
						'many' => q({0} англ. квар.),
						'name' => q(англ. квар.),
						'one' => q({0} англ. квар.),
						'other' => q({0} англ. квар.),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'few' => q({0} англ. квар.),
						'many' => q({0} англ. квар.),
						'name' => q(англ. квар.),
						'one' => q({0} англ. квар.),
						'other' => q({0} англ. квар.),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(напрямок),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(напрямок),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Кі{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Кі{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Мі{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Мі{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Гі{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Гі{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ті{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ті{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Пі{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Пі{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Еі{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Еі{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Зі{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Зі{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Йі{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Йі{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(д{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(д{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(п{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(п{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ф{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ф{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(а{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(а{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(с{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(с{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зп{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зп{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(й{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(й{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(м{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(м{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(мк{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(мк{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(н{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(н{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(Е{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(Е{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(Й{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(Й{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'few' => q({0} g),
						'many' => q({0} g),
						'name' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					# Core Unit Identifier
					'g-force' => {
						'few' => q({0} g),
						'many' => q({0} g),
						'name' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'few' => q({0} м/с²),
						'many' => q({0} м/с²),
						'name' => q(метри/с²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'few' => q({0} м/с²),
						'many' => q({0} м/с²),
						'name' => q(метри/с²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'few' => q({0} кут. мін.),
						'many' => q({0} кут. мін.),
						'name' => q(кут. мін.),
						'one' => q({0} кут. мін.),
						'other' => q({0} кут. мін.),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'few' => q({0} кут. мін.),
						'many' => q({0} кут. мін.),
						'name' => q(кут. мін.),
						'one' => q({0} кут. мін.),
						'other' => q({0} кут. мін.),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'few' => q({0} кут. сек.),
						'many' => q({0} кут. сек.),
						'name' => q(кут. сек.),
						'one' => q({0} кут. сек.),
						'other' => q({0} кут. сек.),
					},
					# Core Unit Identifier
					'arc-second' => {
						'few' => q({0} кут. сек.),
						'many' => q({0} кут. сек.),
						'name' => q(кут. сек.),
						'one' => q({0} кут. сек.),
						'other' => q({0} кут. сек.),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(градуси),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(градуси),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'few' => q({0} рад.),
						'many' => q({0} рад.),
						'name' => q(радіани),
						'one' => q({0} рад.),
						'other' => q({0} рад.),
					},
					# Core Unit Identifier
					'radian' => {
						'few' => q({0} рад.),
						'many' => q({0} рад.),
						'name' => q(радіани),
						'one' => q({0} рад.),
						'other' => q({0} рад.),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'few' => q({0} об),
						'many' => q({0} об),
						'name' => q(об),
						'one' => q({0} об),
						'other' => q({0} об),
					},
					# Core Unit Identifier
					'revolution' => {
						'few' => q({0} об),
						'many' => q({0} об),
						'name' => q(об),
						'one' => q({0} об),
						'other' => q({0} об),
					},
					# Long Unit Identifier
					'area-acre' => {
						'few' => q({0} акри),
						'many' => q({0} акрів),
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акра),
					},
					# Core Unit Identifier
					'acre' => {
						'few' => q({0} акри),
						'many' => q({0} акрів),
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акра),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'few' => q({0} дунами),
						'many' => q({0} дунамів),
						'name' => q(дунами),
						'one' => q({0} дунам),
						'other' => q({0} дунама),
					},
					# Core Unit Identifier
					'dunam' => {
						'few' => q({0} дунами),
						'many' => q({0} дунамів),
						'name' => q(дунами),
						'one' => q({0} дунам),
						'other' => q({0} дунама),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'few' => q({0} га),
						'many' => q({0} га),
						'name' => q(га),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					# Core Unit Identifier
					'hectare' => {
						'few' => q({0} га),
						'many' => q({0} га),
						'name' => q(га),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'few' => q({0} см²),
						'many' => q({0} см²),
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'few' => q({0} см²),
						'many' => q({0} см²),
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'few' => q({0} фути²),
						'many' => q({0} футів²),
						'name' => q(фути²),
						'one' => q({0} фут²),
						'other' => q({0} фута²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'few' => q({0} фути²),
						'many' => q({0} футів²),
						'name' => q(фути²),
						'one' => q({0} фут²),
						'other' => q({0} фута²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'few' => q({0} дюйми²),
						'many' => q({0} дюймів²),
						'name' => q(дюйми²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйма²),
						'per' => q({0}/дюйм²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'few' => q({0} дюйми²),
						'many' => q({0} дюймів²),
						'name' => q(дюйми²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйма²),
						'per' => q({0}/дюйм²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'few' => q({0} км²),
						'many' => q({0} км²),
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'few' => q({0} км²),
						'many' => q({0} км²),
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'few' => q({0} м²),
						'many' => q({0} м²),
						'name' => q(м²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'few' => q({0} м²),
						'many' => q({0} м²),
						'name' => q(м²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'few' => q({0} милі²),
						'many' => q({0} миль²),
						'name' => q(милі²),
						'one' => q({0} миля²),
						'other' => q({0} милі²),
						'per' => q({0}/милю²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'few' => q({0} милі²),
						'many' => q({0} миль²),
						'name' => q(милі²),
						'one' => q({0} миля²),
						'other' => q({0} милі²),
						'per' => q({0}/милю²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'few' => q({0} ярди²),
						'many' => q({0} ярдів²),
						'name' => q(ярди²),
						'one' => q({0} ярд²),
						'other' => q({0} ярда²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'few' => q({0} ярди²),
						'many' => q({0} ярдів²),
						'name' => q(ярди²),
						'one' => q({0} ярд²),
						'other' => q({0} ярда²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'few' => q({0} ел.),
						'many' => q({0} ел.),
						'name' => q(ел.),
						'one' => q({0} ел.),
						'other' => q({0} ел.),
					},
					# Core Unit Identifier
					'item' => {
						'few' => q({0} ел.),
						'many' => q({0} ел.),
						'name' => q(ел.),
						'one' => q({0} ел.),
						'other' => q({0} ел.),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'few' => q({0} кар.),
						'many' => q({0} кар.),
						'name' => q(карати),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Core Unit Identifier
					'karat' => {
						'few' => q({0} кар.),
						'many' => q({0} кар.),
						'name' => q(карати),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'few' => q({0} мг/дл),
						'many' => q({0} мг/дл),
						'name' => q(мг/дл),
						'one' => q({0} мг/дл),
						'other' => q({0} мг/дл),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'few' => q({0} мг/дл),
						'many' => q({0} мг/дл),
						'name' => q(мг/дл),
						'one' => q({0} мг/дл),
						'other' => q({0} мг/дл),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'few' => q({0} ммоль/л),
						'many' => q({0} ммоль/л),
						'name' => q(мілімоль/літер),
						'one' => q({0} ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'few' => q({0} ммоль/л),
						'many' => q({0} ммоль/л),
						'name' => q(мілімоль/літер),
						'one' => q({0} ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'few' => q({0} моль),
						'many' => q({0} моль),
						'name' => q(моль),
						'one' => q({0} моль),
						'other' => q({0} моль),
					},
					# Core Unit Identifier
					'mole' => {
						'few' => q({0} моль),
						'many' => q({0} моль),
						'name' => q(моль),
						'one' => q({0} моль),
						'other' => q({0} моль),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'few' => q({0}%),
						'many' => q({0}%),
						'name' => q(відсоток),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'few' => q({0}%),
						'many' => q({0}%),
						'name' => q(відсоток),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'few' => q({0}‰),
						'many' => q({0}‰),
						'name' => q(проміле),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Core Unit Identifier
					'permille' => {
						'few' => q({0}‰),
						'many' => q({0}‰),
						'name' => q(проміле),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'few' => q({0} ppm),
						'many' => q({0} ppm),
						'name' => q(мільйонні долі),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'few' => q({0} ppm),
						'many' => q({0} ppm),
						'name' => q(мільйонні долі),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(проміріада),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(проміріада),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'few' => q({0} л/100 км),
						'many' => q({0} л/100 км),
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'few' => q({0} л/100 км),
						'many' => q({0} л/100 км),
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'few' => q({0} л/км),
						'many' => q({0} л/км),
						'name' => q(літри/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'few' => q({0} л/км),
						'many' => q({0} л/км),
						'name' => q(літри/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'few' => q({0} милі/гал.),
						'many' => q({0} миль/гал.),
						'name' => q(милі/гал.),
						'one' => q({0} миля/гал.),
						'other' => q({0} милі/гал.),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'few' => q({0} милі/гал.),
						'many' => q({0} миль/гал.),
						'name' => q(милі/гал.),
						'one' => q({0} миля/гал.),
						'other' => q({0} милі/гал.),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'few' => q({0} милі/англ. гал.),
						'many' => q({0} миль/англ. гал.),
						'name' => q(милі/англ. гал.),
						'one' => q({0} миля/англ. гал.),
						'other' => q({0} милі/англ. гал.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'few' => q({0} милі/англ. гал.),
						'many' => q({0} миль/англ. гал.),
						'name' => q(милі/англ. гал.),
						'one' => q({0} миля/англ. гал.),
						'other' => q({0} милі/англ. гал.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} сх. д.),
						'north' => q({0} пн. ш.),
						'south' => q({0} пд. ш.),
						'west' => q({0} зх. д.),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} сх. д.),
						'north' => q({0} пн. ш.),
						'south' => q({0} пд. ш.),
						'west' => q({0} зх. д.),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'few' => q({0} б),
						'many' => q({0} б),
						'name' => q(біт),
						'one' => q({0} б),
						'other' => q({0} б),
					},
					# Core Unit Identifier
					'bit' => {
						'few' => q({0} б),
						'many' => q({0} б),
						'name' => q(біт),
						'one' => q({0} б),
						'other' => q({0} б),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'few' => q({0} Б),
						'many' => q({0} Б),
						'name' => q(байт),
						'one' => q({0} Б),
						'other' => q({0} Б),
					},
					# Core Unit Identifier
					'byte' => {
						'few' => q({0} Б),
						'many' => q({0} Б),
						'name' => q(байт),
						'one' => q({0} Б),
						'other' => q({0} Б),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'few' => q({0} Гб),
						'many' => q({0} Гб),
						'name' => q(Гбіт),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					# Core Unit Identifier
					'gigabit' => {
						'few' => q({0} Гб),
						'many' => q({0} Гб),
						'name' => q(Гбіт),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'few' => q({0} ГБ),
						'many' => q({0} ГБ),
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'few' => q({0} ГБ),
						'many' => q({0} ГБ),
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'few' => q({0} кб),
						'many' => q({0} кб),
						'name' => q(кбіт),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					# Core Unit Identifier
					'kilobit' => {
						'few' => q({0} кб),
						'many' => q({0} кб),
						'name' => q(кбіт),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'few' => q({0} кБ),
						'many' => q({0} кБ),
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'few' => q({0} кБ),
						'many' => q({0} кБ),
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'few' => q({0} Мб),
						'many' => q({0} Мб),
						'name' => q(Мбіт),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					# Core Unit Identifier
					'megabit' => {
						'few' => q({0} Мб),
						'many' => q({0} Мб),
						'name' => q(Мбіт),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'few' => q({0} МБ),
						'many' => q({0} МБ),
						'name' => q(Мбайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					# Core Unit Identifier
					'megabyte' => {
						'few' => q({0} МБ),
						'many' => q({0} МБ),
						'name' => q(Мбайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'few' => q({0} ПБ),
						'many' => q({0} ПБ),
						'name' => q(ПБ),
						'one' => q({0} ПБ),
						'other' => q({0} ПБ),
					},
					# Core Unit Identifier
					'petabyte' => {
						'few' => q({0} ПБ),
						'many' => q({0} ПБ),
						'name' => q(ПБ),
						'one' => q({0} ПБ),
						'other' => q({0} ПБ),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'few' => q({0} Тб),
						'many' => q({0} Тб),
						'name' => q(Тбіт),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					# Core Unit Identifier
					'terabit' => {
						'few' => q({0} Тб),
						'many' => q({0} Тб),
						'name' => q(Тбіт),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'few' => q({0} ТБ),
						'many' => q({0} ТБ),
						'name' => q(Тбайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'few' => q({0} ТБ),
						'many' => q({0} ТБ),
						'name' => q(Тбайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'few' => q({0} ст.),
						'many' => q({0} ст.),
						'name' => q(ст.),
						'one' => q({0} ст.),
						'other' => q({0} ст.),
					},
					# Core Unit Identifier
					'century' => {
						'few' => q({0} ст.),
						'many' => q({0} ст.),
						'name' => q(ст.),
						'one' => q({0} ст.),
						'other' => q({0} ст.),
					},
					# Long Unit Identifier
					'duration-day' => {
						'few' => q({0} дн.),
						'many' => q({0} дн.),
						'name' => q(дні),
						'one' => q({0} дн.),
						'other' => q({0} дн.),
						'per' => q({0}/дн.),
					},
					# Core Unit Identifier
					'day' => {
						'few' => q({0} дн.),
						'many' => q({0} дн.),
						'name' => q(дні),
						'one' => q({0} дн.),
						'other' => q({0} дн.),
						'per' => q({0}/дн.),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'few' => q({0} 10-річчя),
						'many' => q({0} 10-річ),
						'name' => q(10-річчя),
						'one' => q({0} 10-річчя),
						'other' => q({0} 10-річчя),
					},
					# Core Unit Identifier
					'decade' => {
						'few' => q({0} 10-річчя),
						'many' => q({0} 10-річ),
						'name' => q(10-річчя),
						'one' => q({0} 10-річчя),
						'other' => q({0} 10-річчя),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'few' => q({0} год),
						'many' => q({0} год),
						'name' => q(год),
						'one' => q({0} год),
						'other' => q({0} год),
						'per' => q({0}/год),
					},
					# Core Unit Identifier
					'hour' => {
						'few' => q({0} год),
						'many' => q({0} год),
						'name' => q(год),
						'one' => q({0} год),
						'other' => q({0} год),
						'per' => q({0}/год),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'few' => q({0} мкс),
						'many' => q({0} мкс),
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					# Core Unit Identifier
					'microsecond' => {
						'few' => q({0} мкс),
						'many' => q({0} мкс),
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'few' => q({0} мс),
						'many' => q({0} мс),
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Core Unit Identifier
					'millisecond' => {
						'few' => q({0} мс),
						'many' => q({0} мс),
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'few' => q({0} хв),
						'many' => q({0} хв),
						'name' => q(хв),
						'one' => q({0} хв),
						'other' => q({0} хв),
						'per' => q({0}/хв),
					},
					# Core Unit Identifier
					'minute' => {
						'few' => q({0} хв),
						'many' => q({0} хв),
						'name' => q(хв),
						'one' => q({0} хв),
						'other' => q({0} хв),
						'per' => q({0}/хв),
					},
					# Long Unit Identifier
					'duration-month' => {
						'few' => q({0} міс.),
						'many' => q({0} міс.),
						'name' => q(міс.),
						'one' => q({0} міс.),
						'other' => q({0} міс.),
						'per' => q({0}/міс.),
					},
					# Core Unit Identifier
					'month' => {
						'few' => q({0} міс.),
						'many' => q({0} міс.),
						'name' => q(міс.),
						'one' => q({0} міс.),
						'other' => q({0} міс.),
						'per' => q({0}/міс.),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'few' => q({0} нс),
						'many' => q({0} нс),
						'name' => q(нс),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'few' => q({0} нс),
						'many' => q({0} нс),
						'name' => q(нс),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Long Unit Identifier
					'duration-second' => {
						'few' => q({0} с),
						'many' => q({0} с),
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
						'per' => q({0}/с),
					},
					# Core Unit Identifier
					'second' => {
						'few' => q({0} с),
						'many' => q({0} с),
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
						'per' => q({0}/с),
					},
					# Long Unit Identifier
					'duration-week' => {
						'few' => q({0} тиж.),
						'many' => q({0} тиж.),
						'name' => q(тиж.),
						'one' => q({0} тиж.),
						'other' => q({0} тиж.),
						'per' => q({0}/тиж.),
					},
					# Core Unit Identifier
					'week' => {
						'few' => q({0} тиж.),
						'many' => q({0} тиж.),
						'name' => q(тиж.),
						'one' => q({0} тиж.),
						'other' => q({0} тиж.),
						'per' => q({0}/тиж.),
					},
					# Long Unit Identifier
					'duration-year' => {
						'few' => q({0} р.),
						'many' => q({0} р.),
						'name' => q(р.),
						'one' => q({0} р.),
						'other' => q({0} р.),
						'per' => q({0}/р.),
					},
					# Core Unit Identifier
					'year' => {
						'few' => q({0} р.),
						'many' => q({0} р.),
						'name' => q(р.),
						'one' => q({0} р.),
						'other' => q({0} р.),
						'per' => q({0}/р.),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'few' => q({0} А),
						'many' => q({0} А),
						'name' => q(А),
						'one' => q({0} А),
						'other' => q({0} А),
					},
					# Core Unit Identifier
					'ampere' => {
						'few' => q({0} А),
						'many' => q({0} А),
						'name' => q(А),
						'one' => q({0} А),
						'other' => q({0} А),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'few' => q({0} мА),
						'many' => q({0} мА),
						'name' => q(мА),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					# Core Unit Identifier
					'milliampere' => {
						'few' => q({0} мА),
						'many' => q({0} мА),
						'name' => q(мА),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'few' => q({0} Ом),
						'many' => q({0} Ом),
						'name' => q(оми),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					# Core Unit Identifier
					'ohm' => {
						'few' => q({0} Ом),
						'many' => q({0} Ом),
						'name' => q(оми),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'few' => q({0} В),
						'many' => q({0} В),
						'name' => q(вольти),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					# Core Unit Identifier
					'volt' => {
						'few' => q({0} В),
						'many' => q({0} В),
						'name' => q(вольти),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'few' => q({0} Отб),
						'many' => q({0} Отб),
						'name' => q(Отб),
						'one' => q({0} Отб),
						'other' => q({0} Отб),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'few' => q({0} Отб),
						'many' => q({0} Отб),
						'name' => q(Отб),
						'one' => q({0} Отб),
						'other' => q({0} Отб),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'few' => q({0} кал),
						'many' => q({0} кал),
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Core Unit Identifier
					'calorie' => {
						'few' => q({0} кал),
						'many' => q({0} кал),
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'few' => q({0} еВ),
						'many' => q({0} еВ),
						'name' => q(електрон-вольт),
						'one' => q({0} еВ),
						'other' => q({0} еВ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'few' => q({0} еВ),
						'many' => q({0} еВ),
						'name' => q(електрон-вольт),
						'one' => q({0} еВ),
						'other' => q({0} еВ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'few' => q({0} ккал),
						'many' => q({0} ккал),
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'few' => q({0} ккал),
						'many' => q({0} ккал),
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'few' => q({0} Дж),
						'many' => q({0} Дж),
						'name' => q(джоулі),
						'one' => q({0} Дж),
						'other' => q({0} Дж),
					},
					# Core Unit Identifier
					'joule' => {
						'few' => q({0} Дж),
						'many' => q({0} Дж),
						'name' => q(джоулі),
						'one' => q({0} Дж),
						'other' => q({0} Дж),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'few' => q({0} ккал),
						'many' => q({0} ккал),
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'few' => q({0} ккал),
						'many' => q({0} ккал),
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'few' => q({0} кДж),
						'many' => q({0} кДж),
						'name' => q(кілоджоуль),
						'one' => q({0} кДж),
						'other' => q({0} кДж),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'few' => q({0} кДж),
						'many' => q({0} кДж),
						'name' => q(кілоджоуль),
						'one' => q({0} кДж),
						'other' => q({0} кДж),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'few' => q({0} кВт⋅год),
						'many' => q({0} кВт⋅год),
						'name' => q(кВт⋅год),
						'one' => q({0} кВт⋅год),
						'other' => q({0} кВт⋅год),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'few' => q({0} кВт⋅год),
						'many' => q({0} кВт⋅год),
						'name' => q(кВт⋅год),
						'one' => q({0} кВт⋅год),
						'other' => q({0} кВт⋅год),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'few' => q({0} ам. терми),
						'many' => q({0} ам. термів),
						'name' => q(ам. терми),
						'one' => q({0} ам. терм),
						'other' => q({0} ам. терма),
					},
					# Core Unit Identifier
					'therm-us' => {
						'few' => q({0} ам. терми),
						'many' => q({0} ам. термів),
						'name' => q(ам. терми),
						'one' => q({0} ам. терм),
						'other' => q({0} ам. терма),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'few' => q({0} кВт⋅год/100 км),
						'many' => q({0} кВт⋅год/100 км),
						'name' => q(кВт⋅год/100 км),
						'one' => q({0} кВт⋅год/100 км),
						'other' => q({0} кВт⋅год/100 км),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'few' => q({0} кВт⋅год/100 км),
						'many' => q({0} кВт⋅год/100 км),
						'name' => q(кВт⋅год/100 км),
						'one' => q({0} кВт⋅год/100 км),
						'other' => q({0} кВт⋅год/100 км),
					},
					# Long Unit Identifier
					'force-newton' => {
						'few' => q({0} Н),
						'many' => q({0} Н),
						'name' => q(ньютон),
						'one' => q({0} Н),
						'other' => q({0} Н),
					},
					# Core Unit Identifier
					'newton' => {
						'few' => q({0} Н),
						'many' => q({0} Н),
						'name' => q(ньютон),
						'one' => q({0} Н),
						'other' => q({0} Н),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'few' => q({0} фнтс),
						'many' => q({0} фнтс),
						'name' => q(фунт-сила),
						'one' => q({0} фнтс),
						'other' => q({0} фнтс),
					},
					# Core Unit Identifier
					'pound-force' => {
						'few' => q({0} фнтс),
						'many' => q({0} фнтс),
						'name' => q(фунт-сила),
						'one' => q({0} фнтс),
						'other' => q({0} фнтс),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'few' => q({0} ГГц),
						'many' => q({0} ГГц),
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'few' => q({0} ГГц),
						'many' => q({0} ГГц),
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'few' => q({0} Гц),
						'many' => q({0} Гц),
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					# Core Unit Identifier
					'hertz' => {
						'few' => q({0} Гц),
						'many' => q({0} Гц),
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'few' => q({0} кГц),
						'many' => q({0} кГц),
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'few' => q({0} кГц),
						'many' => q({0} кГц),
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'few' => q({0} МГц),
						'many' => q({0} МГц),
						'name' => q(МГц),
						'one' => q({0} МГц),
						'other' => q({0} МГц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'few' => q({0} МГц),
						'many' => q({0} МГц),
						'name' => q(МГц),
						'one' => q({0} МГц),
						'other' => q({0} МГц),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'few' => q({0} тчк),
						'many' => q({0} тчк),
						'name' => q(тчк),
						'one' => q({0} тчк),
						'other' => q({0} тчк),
					},
					# Core Unit Identifier
					'dot' => {
						'few' => q({0} тчк),
						'many' => q({0} тчк),
						'name' => q(тчк),
						'one' => q({0} тчк),
						'other' => q({0} тчк),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'few' => q({0} ppcm),
						'many' => q({0} ppcm),
						'name' => q(dpcm),
						'one' => q({0} ppcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'few' => q({0} ppcm),
						'many' => q({0} ppcm),
						'name' => q(dpcm),
						'one' => q({0} ppcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'few' => q({0} ppi),
						'many' => q({0} ppi),
						'name' => q(dpi),
						'one' => q({0} ppi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'few' => q({0} ppi),
						'many' => q({0} ppi),
						'name' => q(dpi),
						'one' => q({0} ppi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'few' => q({0} ем),
						'many' => q({0} ем),
						'name' => q(ем),
						'one' => q({0} ем),
						'other' => q({0} ем),
					},
					# Core Unit Identifier
					'em' => {
						'few' => q({0} ем),
						'many' => q({0} ем),
						'name' => q(ем),
						'one' => q({0} ем),
						'other' => q({0} ем),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'few' => q({0} Мп),
						'many' => q({0} Мп),
						'name' => q(Мп),
						'one' => q({0} Мп),
						'other' => q({0} Мп),
					},
					# Core Unit Identifier
					'megapixel' => {
						'few' => q({0} Мп),
						'many' => q({0} Мп),
						'name' => q(Мп),
						'one' => q({0} Мп),
						'other' => q({0} Мп),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'few' => q({0} пкс),
						'many' => q({0} пкс),
						'name' => q(пкс),
						'one' => q({0} пкс),
						'other' => q({0} пкс),
					},
					# Core Unit Identifier
					'pixel' => {
						'few' => q({0} пкс),
						'many' => q({0} пкс),
						'name' => q(пкс),
						'one' => q({0} пкс),
						'other' => q({0} пкс),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'few' => q({0} ppcm),
						'many' => q({0} ppcm),
						'name' => q(ppcm),
						'one' => q({0} ppcm),
						'other' => q({0} ppcm),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'few' => q({0} ppcm),
						'many' => q({0} ppcm),
						'name' => q(ppcm),
						'one' => q({0} ppcm),
						'other' => q({0} ppcm),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'few' => q({0} ppi),
						'many' => q({0} ppi),
						'name' => q(ppi),
						'one' => q({0} ppi),
						'other' => q({0} ppi),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'few' => q({0} ppi),
						'many' => q({0} ppi),
						'name' => q(ppi),
						'one' => q({0} ppi),
						'other' => q({0} ppi),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'few' => q({0} а. о.),
						'many' => q({0} а. о.),
						'name' => q(а. о.),
						'one' => q({0} а. о.),
						'other' => q({0} а. о.),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'few' => q({0} а. о.),
						'many' => q({0} а. о.),
						'name' => q(а. о.),
						'one' => q({0} а. о.),
						'other' => q({0} а. о.),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'few' => q({0} см),
						'many' => q({0} см),
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Core Unit Identifier
					'centimeter' => {
						'few' => q({0} см),
						'many' => q({0} см),
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'few' => q({0} дм),
						'many' => q({0} дм),
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					# Core Unit Identifier
					'decimeter' => {
						'few' => q({0} дм),
						'many' => q({0} дм),
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'few' => q({0} фтм),
						'many' => q({0} фтм),
						'name' => q(фатоми),
						'one' => q({0} фтм),
						'other' => q({0} фтм),
					},
					# Core Unit Identifier
					'fathom' => {
						'few' => q({0} фтм),
						'many' => q({0} фтм),
						'name' => q(фатоми),
						'one' => q({0} фтм),
						'other' => q({0} фтм),
					},
					# Long Unit Identifier
					'length-foot' => {
						'few' => q({0} фт),
						'many' => q({0} фт),
						'name' => q(фт),
						'one' => q({0} фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Core Unit Identifier
					'foot' => {
						'few' => q({0} фт),
						'many' => q({0} фт),
						'name' => q(фт),
						'one' => q({0} фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'few' => q({0} fur),
						'many' => q({0} fur),
						'name' => q(фурлонги),
						'one' => q({0} fur),
						'other' => q({0} fur),
					},
					# Core Unit Identifier
					'furlong' => {
						'few' => q({0} fur),
						'many' => q({0} fur),
						'name' => q(фурлонги),
						'one' => q({0} fur),
						'other' => q({0} fur),
					},
					# Long Unit Identifier
					'length-inch' => {
						'few' => q({0} дюйми),
						'many' => q({0} дюймів),
						'name' => q(дюйми),
						'one' => q({0} дюйм),
						'other' => q({0} дюйма),
						'per' => q({0}/дюйм),
					},
					# Core Unit Identifier
					'inch' => {
						'few' => q({0} дюйми),
						'many' => q({0} дюймів),
						'name' => q(дюйми),
						'one' => q({0} дюйм),
						'other' => q({0} дюйма),
						'per' => q({0}/дюйм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'few' => q({0} км),
						'many' => q({0} км),
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Core Unit Identifier
					'kilometer' => {
						'few' => q({0} км),
						'many' => q({0} км),
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'few' => q({0} св. р.),
						'many' => q({0} св. р.),
						'name' => q(св. р.),
						'one' => q({0} св. р.),
						'other' => q({0} св. р.),
					},
					# Core Unit Identifier
					'light-year' => {
						'few' => q({0} св. р.),
						'many' => q({0} св. р.),
						'name' => q(св. р.),
						'one' => q({0} св. р.),
						'other' => q({0} св. р.),
					},
					# Long Unit Identifier
					'length-meter' => {
						'few' => q({0} м),
						'many' => q({0} м),
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'meter' => {
						'few' => q({0} м),
						'many' => q({0} м),
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'few' => q({0} мкм),
						'many' => q({0} мкм),
						'name' => q(мкм),
						'one' => q({0} мкм),
						'other' => q({0} мкм),
					},
					# Core Unit Identifier
					'micrometer' => {
						'few' => q({0} мкм),
						'many' => q({0} мкм),
						'name' => q(мкм),
						'one' => q({0} мкм),
						'other' => q({0} мкм),
					},
					# Long Unit Identifier
					'length-mile' => {
						'few' => q({0} милі),
						'many' => q({0} миль),
						'name' => q(милі),
						'one' => q({0} миля),
						'other' => q({0} милі),
					},
					# Core Unit Identifier
					'mile' => {
						'few' => q({0} милі),
						'many' => q({0} миль),
						'name' => q(милі),
						'one' => q({0} миля),
						'other' => q({0} милі),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'few' => q({0} сканд. милі),
						'many' => q({0} сканд. миль),
						'name' => q(сканд. миля),
						'one' => q({0} сканд. миля),
						'other' => q({0} сканд. милі),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'few' => q({0} сканд. милі),
						'many' => q({0} сканд. миль),
						'name' => q(сканд. миля),
						'one' => q({0} сканд. миля),
						'other' => q({0} сканд. милі),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'few' => q({0} мм),
						'many' => q({0} мм),
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Core Unit Identifier
					'millimeter' => {
						'few' => q({0} мм),
						'many' => q({0} мм),
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'few' => q({0} нм),
						'many' => q({0} нм),
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					# Core Unit Identifier
					'nanometer' => {
						'few' => q({0} нм),
						'many' => q({0} нм),
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'few' => q({0} м. милі),
						'many' => q({0} м. миль),
						'name' => q(м. милі),
						'one' => q({0} м. миля),
						'other' => q({0} м. милі),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'few' => q({0} м. милі),
						'many' => q({0} м. миль),
						'name' => q(м. милі),
						'one' => q({0} м. миля),
						'other' => q({0} м. милі),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'few' => q({0} пк),
						'many' => q({0} пк),
						'name' => q(парсеки),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					# Core Unit Identifier
					'parsec' => {
						'few' => q({0} пк),
						'many' => q({0} пк),
						'name' => q(парсеки),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'few' => q({0} пм),
						'many' => q({0} пм),
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Core Unit Identifier
					'picometer' => {
						'few' => q({0} пм),
						'many' => q({0} пм),
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Long Unit Identifier
					'length-point' => {
						'few' => q({0} пт),
						'many' => q({0} пт),
						'name' => q(пт),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					# Core Unit Identifier
					'point' => {
						'few' => q({0} пт),
						'many' => q({0} пт),
						'name' => q(пт),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(радіус Сонця),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(радіус Сонця),
					},
					# Long Unit Identifier
					'length-yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'name' => q(ярди),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					# Core Unit Identifier
					'yard' => {
						'few' => q({0} ярди),
						'many' => q({0} ярдів),
						'name' => q(ярди),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					# Long Unit Identifier
					'light-candela' => {
						'few' => q({0} кд),
						'many' => q({0} кд),
						'name' => q(кд),
						'one' => q({0} кд),
						'other' => q({0} кд),
					},
					# Core Unit Identifier
					'candela' => {
						'few' => q({0} кд),
						'many' => q({0} кд),
						'name' => q(кд),
						'one' => q({0} кд),
						'other' => q({0} кд),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'few' => q({0} лм),
						'many' => q({0} лм),
						'name' => q(лм),
						'one' => q({0} лм),
						'other' => q({0} лм),
					},
					# Core Unit Identifier
					'lumen' => {
						'few' => q({0} лм),
						'many' => q({0} лм),
						'name' => q(лм),
						'one' => q({0} лм),
						'other' => q({0} лм),
					},
					# Long Unit Identifier
					'light-lux' => {
						'few' => q({0} лк),
						'many' => q({0} лк),
						'name' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					# Core Unit Identifier
					'lux' => {
						'few' => q({0} лк),
						'many' => q({0} лк),
						'name' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(світності Сонця),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(світності Сонця),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'few' => q({0} кар),
						'many' => q({0} кар),
						'name' => q(карати),
						'one' => q({0} кар),
						'other' => q({0} кар),
					},
					# Core Unit Identifier
					'carat' => {
						'few' => q({0} кар),
						'many' => q({0} кар),
						'name' => q(карати),
						'one' => q({0} кар),
						'other' => q({0} кар),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'few' => q({0} Да),
						'many' => q({0} Да),
						'name' => q(дальтони),
						'one' => q({0} Да),
						'other' => q({0} Да),
					},
					# Core Unit Identifier
					'dalton' => {
						'few' => q({0} Да),
						'many' => q({0} Да),
						'name' => q(дальтони),
						'one' => q({0} Да),
						'other' => q({0} Да),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(маси Землі),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(маси Землі),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'few' => q({0} грани),
						'many' => q({0} гранів),
						'name' => q(гран),
						'one' => q({0} гран),
						'other' => q({0} грана),
					},
					# Core Unit Identifier
					'grain' => {
						'few' => q({0} грани),
						'many' => q({0} гранів),
						'name' => q(гран),
						'one' => q({0} гран),
						'other' => q({0} грана),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'few' => q({0} г),
						'many' => q({0} г),
						'name' => q(г),
						'one' => q({0} г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Core Unit Identifier
					'gram' => {
						'few' => q({0} г),
						'many' => q({0} г),
						'name' => q(г),
						'one' => q({0} г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'few' => q({0} кг),
						'many' => q({0} кг),
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Core Unit Identifier
					'kilogram' => {
						'few' => q({0} кг),
						'many' => q({0} кг),
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'few' => q({0} метр. т),
						'many' => q({0} метр. т),
						'name' => q(метр. т),
						'one' => q({0} метр. т),
						'other' => q({0} метр. т),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'few' => q({0} метр. т),
						'many' => q({0} метр. т),
						'name' => q(метр. т),
						'one' => q({0} метр. т),
						'other' => q({0} метр. т),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'few' => q({0} мкг),
						'many' => q({0} мкг),
						'name' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					# Core Unit Identifier
					'microgram' => {
						'few' => q({0} мкг),
						'many' => q({0} мкг),
						'name' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'few' => q({0} мг),
						'many' => q({0} мг),
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					# Core Unit Identifier
					'milligram' => {
						'few' => q({0} мг),
						'many' => q({0} мг),
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'few' => q({0} унц.),
						'many' => q({0} унц.),
						'name' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					# Core Unit Identifier
					'ounce' => {
						'few' => q({0} унц.),
						'many' => q({0} унц.),
						'name' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'few' => q({0} тр. унції),
						'many' => q({0} тр. унцій),
						'name' => q(тр. унції),
						'one' => q({0} тр. унція),
						'other' => q({0} тр. унції),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'few' => q({0} тр. унції),
						'many' => q({0} тр. унцій),
						'name' => q(тр. унції),
						'one' => q({0} тр. унція),
						'other' => q({0} тр. унції),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'few' => q({0} фунти),
						'many' => q({0} фунтів),
						'name' => q(фунти),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
						'per' => q({0}/фунт),
					},
					# Core Unit Identifier
					'pound' => {
						'few' => q({0} фунти),
						'many' => q({0} фунтів),
						'name' => q(фунти),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
						'per' => q({0}/фунт),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(маси Сонця),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(маси Сонця),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'few' => q({0} стн),
						'many' => q({0} стн),
						'name' => q(стоун),
						'one' => q({0} стн),
						'other' => q({0} стн),
					},
					# Core Unit Identifier
					'stone' => {
						'few' => q({0} стн),
						'many' => q({0} стн),
						'name' => q(стоун),
						'one' => q({0} стн),
						'other' => q({0} стн),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'few' => q({0} т),
						'many' => q({0} т),
						'name' => q(тонни),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					# Core Unit Identifier
					'ton' => {
						'few' => q({0} т),
						'many' => q({0} т),
						'name' => q(тонни),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'few' => q({0} ГВт),
						'many' => q({0} ГВт),
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'few' => q({0} ГВт),
						'many' => q({0} ГВт),
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'few' => q({0} к. с.),
						'many' => q({0} к. с.),
						'name' => q(к. с.),
						'one' => q({0} к. с.),
						'other' => q({0} к. с.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'few' => q({0} к. с.),
						'many' => q({0} к. с.),
						'name' => q(к. с.),
						'one' => q({0} к. с.),
						'other' => q({0} к. с.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'few' => q({0} кВт),
						'many' => q({0} кВт),
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'few' => q({0} кВт),
						'many' => q({0} кВт),
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'few' => q({0} МВт),
						'many' => q({0} МВт),
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'few' => q({0} МВт),
						'many' => q({0} МВт),
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'few' => q({0} мВт),
						'many' => q({0} мВт),
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'few' => q({0} мВт),
						'many' => q({0} мВт),
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'few' => q({0} Вт),
						'many' => q({0} Вт),
						'name' => q(вати),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Core Unit Identifier
					'watt' => {
						'few' => q({0} Вт),
						'many' => q({0} Вт),
						'name' => q(вати),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q({0}²),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q({0}³),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q({0}³),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'few' => q({0} атм),
						'many' => q({0} атм),
						'name' => q(атм),
						'one' => q({0} атм),
						'other' => q({0} атм),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'few' => q({0} атм),
						'many' => q({0} атм),
						'name' => q(атм),
						'one' => q({0} атм),
						'other' => q({0} атм),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'few' => q({0} бар),
						'many' => q({0} бар),
						'name' => q(бар),
						'one' => q({0} бар),
						'other' => q({0} бар),
					},
					# Core Unit Identifier
					'bar' => {
						'few' => q({0} бар),
						'many' => q({0} бар),
						'name' => q(бар),
						'one' => q({0} бар),
						'other' => q({0} бар),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'few' => q({0} гПа),
						'many' => q({0} гПа),
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'few' => q({0} гПа),
						'many' => q({0} гПа),
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'few' => q({0} дюйми рт. ст.),
						'many' => q({0} дюймів рт. ст.),
						'name' => q(дюйми рт. ст.),
						'one' => q({0} дюйм рт. ст.),
						'other' => q({0} дюйма рт. ст.),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'few' => q({0} дюйми рт. ст.),
						'many' => q({0} дюймів рт. ст.),
						'name' => q(дюйми рт. ст.),
						'one' => q({0} дюйм рт. ст.),
						'other' => q({0} дюйма рт. ст.),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'few' => q({0} кПа),
						'many' => q({0} кПа),
						'name' => q(кПа),
						'one' => q({0} кПа),
						'other' => q({0} кПа),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'few' => q({0} кПа),
						'many' => q({0} кПа),
						'name' => q(кПа),
						'one' => q({0} кПа),
						'other' => q({0} кПа),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'few' => q({0} МПа),
						'many' => q({0} МПа),
						'name' => q(МПа),
						'one' => q({0} МПа),
						'other' => q({0} МПа),
					},
					# Core Unit Identifier
					'megapascal' => {
						'few' => q({0} МПа),
						'many' => q({0} МПа),
						'name' => q(МПа),
						'one' => q({0} МПа),
						'other' => q({0} МПа),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'few' => q({0} мбари),
						'many' => q({0} мбарів),
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбара),
					},
					# Core Unit Identifier
					'millibar' => {
						'few' => q({0} мбари),
						'many' => q({0} мбарів),
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбара),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'few' => q({0} мм рт. ст.),
						'many' => q({0} мм рт. ст.),
						'name' => q(мм рт. ст.),
						'one' => q({0} мм рт. ст.),
						'other' => q({0} мм рт. ст.),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'few' => q({0} мм рт. ст.),
						'many' => q({0} мм рт. ст.),
						'name' => q(мм рт. ст.),
						'one' => q({0} мм рт. ст.),
						'other' => q({0} мм рт. ст.),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'few' => q({0} Па),
						'many' => q({0} Па),
						'name' => q(Па),
						'one' => q({0} Па),
						'other' => q({0} Па),
					},
					# Core Unit Identifier
					'pascal' => {
						'few' => q({0} Па),
						'many' => q({0} Па),
						'name' => q(Па),
						'one' => q({0} Па),
						'other' => q({0} Па),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'few' => q({0} фунти/дюйм²),
						'many' => q({0} фунтів/дюйм²),
						'name' => q(фунт/дюйм²),
						'one' => q({0} фунт/дюйм²),
						'other' => q({0} фунта/дюйм²),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'few' => q({0} фунти/дюйм²),
						'many' => q({0} фунтів/дюйм²),
						'name' => q(фунт/дюйм²),
						'one' => q({0} фунт/дюйм²),
						'other' => q({0} фунта/дюйм²),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'few' => q({0} км/год),
						'many' => q({0} км/год),
						'name' => q(км/годину),
						'one' => q({0} км/год),
						'other' => q({0} км/год),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'few' => q({0} км/год),
						'many' => q({0} км/год),
						'name' => q(км/годину),
						'one' => q({0} км/год),
						'other' => q({0} км/год),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'few' => q({0} kn),
						'many' => q({0} kn),
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Core Unit Identifier
					'knot' => {
						'few' => q({0} kn),
						'many' => q({0} kn),
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'few' => q({0} м/с),
						'many' => q({0} м/с),
						'name' => q(метри/с),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'few' => q({0} м/с),
						'many' => q({0} м/с),
						'name' => q(метри/с),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'few' => q({0} милі/год),
						'many' => q({0} миль/год),
						'name' => q(милі/год),
						'one' => q({0} миля/год),
						'other' => q({0} милі/год),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'few' => q({0} милі/год),
						'many' => q({0} миль/год),
						'name' => q(милі/год),
						'one' => q({0} миля/год),
						'other' => q({0} милі/год),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'few' => q({0} °C),
						'many' => q({0} °C),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					# Core Unit Identifier
					'celsius' => {
						'few' => q({0} °C),
						'many' => q({0} °C),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'few' => q({0} °F),
						'many' => q({0} °F),
						'one' => q({0} °F),
						'other' => q({0} °F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'few' => q({0} °F),
						'many' => q({0} °F),
						'one' => q({0} °F),
						'other' => q({0} °F),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'few' => q({0} К),
						'many' => q({0} К),
						'name' => q(кельвін),
						'one' => q({0} К),
						'other' => q({0} К),
					},
					# Core Unit Identifier
					'kelvin' => {
						'few' => q({0} К),
						'many' => q({0} К),
						'name' => q(кельвін),
						'one' => q({0} К),
						'other' => q({0} К),
					},
					# Long Unit Identifier
					'times' => {
						'1' => q({0}⋅{1}),
					},
					# Core Unit Identifier
					'times' => {
						'1' => q({0}⋅{1}),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'few' => q({0} Н·м),
						'many' => q({0} Н·м),
						'name' => q(Н·м),
						'one' => q({0} Н·м),
						'other' => q({0} Н·м),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'few' => q({0} Н·м),
						'many' => q({0} Н·м),
						'name' => q(Н·м),
						'one' => q({0} Н·м),
						'other' => q({0} Н·м),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'few' => q({0} фнт-фт),
						'many' => q({0} фнт-фт),
						'name' => q(фунт-фут),
						'one' => q({0} фнт-фт),
						'other' => q({0} фнт-фт),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'few' => q({0} фнт-фт),
						'many' => q({0} фнт-фт),
						'name' => q(фунт-фут),
						'one' => q({0} фнт-фт),
						'other' => q({0} фнт-фт),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'few' => q({0} акр-фути),
						'many' => q({0} акр-футів),
						'name' => q(акр-фути),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фута),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'few' => q({0} акр-фути),
						'many' => q({0} акр-футів),
						'name' => q(акр-фути),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фута),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'few' => q({0} брл),
						'many' => q({0} брл),
						'name' => q(барель),
						'one' => q({0} брл),
						'other' => q({0} брл),
					},
					# Core Unit Identifier
					'barrel' => {
						'few' => q({0} брл),
						'many' => q({0} брл),
						'name' => q(барель),
						'one' => q({0} брл),
						'other' => q({0} брл),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'few' => q({0} буш.),
						'many' => q({0} буш.),
						'name' => q(бушелі),
						'one' => q({0} буш.),
						'other' => q({0} буш.),
					},
					# Core Unit Identifier
					'bushel' => {
						'few' => q({0} буш.),
						'many' => q({0} буш.),
						'name' => q(бушелі),
						'one' => q({0} буш.),
						'other' => q({0} буш.),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'few' => q({0} сл),
						'many' => q({0} сл),
						'name' => q(сл),
						'one' => q({0} сл),
						'other' => q({0} сл),
					},
					# Core Unit Identifier
					'centiliter' => {
						'few' => q({0} сл),
						'many' => q({0} сл),
						'name' => q(сл),
						'one' => q({0} сл),
						'other' => q({0} сл),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'few' => q({0} см³),
						'many' => q({0} см³),
						'name' => q(см³),
						'one' => q({0} см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'few' => q({0} см³),
						'many' => q({0} см³),
						'name' => q(см³),
						'one' => q({0} см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'few' => q({0} фути³),
						'many' => q({0} футів³),
						'name' => q(фути³),
						'one' => q({0} фут³),
						'other' => q({0} фута³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'few' => q({0} фути³),
						'many' => q({0} футів³),
						'name' => q(фути³),
						'one' => q({0} фут³),
						'other' => q({0} фута³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'few' => q({0} дюйми³),
						'many' => q({0} дюймів³),
						'name' => q(дюйми³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйма³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'few' => q({0} дюйми³),
						'many' => q({0} дюймів³),
						'name' => q(дюйми³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйма³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'few' => q({0} км³),
						'many' => q({0} км³),
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'few' => q({0} км³),
						'many' => q({0} км³),
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'few' => q({0} м³),
						'many' => q({0} м³),
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'few' => q({0} м³),
						'many' => q({0} м³),
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'few' => q({0} милі³),
						'many' => q({0} миль³),
						'name' => q(милі³),
						'one' => q({0} миля³),
						'other' => q({0} милі³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'few' => q({0} милі³),
						'many' => q({0} миль³),
						'name' => q(милі³),
						'one' => q({0} миля³),
						'other' => q({0} милі³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'few' => q({0} ярди³),
						'many' => q({0} ярдів³),
						'name' => q(ярди³),
						'one' => q({0} ярд³),
						'other' => q({0} ярда³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'few' => q({0} ярди³),
						'many' => q({0} ярдів³),
						'name' => q(ярди³),
						'one' => q({0} ярд³),
						'other' => q({0} ярда³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'few' => q({0} скл.),
						'many' => q({0} скл.),
						'name' => q(склянки),
						'one' => q({0} скл.),
						'other' => q({0} скл.),
					},
					# Core Unit Identifier
					'cup' => {
						'few' => q({0} скл.),
						'many' => q({0} скл.),
						'name' => q(склянки),
						'one' => q({0} скл.),
						'other' => q({0} скл.),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'few' => q({0} метр. чашки),
						'many' => q({0} метр. чашок),
						'name' => q(метр. чашки),
						'one' => q({0} метр. чашка),
						'other' => q({0} метр. чашки),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'few' => q({0} метр. чашки),
						'many' => q({0} метр. чашок),
						'name' => q(метр. чашки),
						'one' => q({0} метр. чашка),
						'other' => q({0} метр. чашки),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'few' => q({0} дл),
						'many' => q({0} дл),
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					# Core Unit Identifier
					'deciliter' => {
						'few' => q({0} дл),
						'many' => q({0} дл),
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'few' => q({0} дес. л.),
						'many' => q({0} дес. л.),
						'name' => q(дес. л.),
						'one' => q({0} дес. л.),
						'other' => q({0} дес. л.),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'few' => q({0} дес. л.),
						'many' => q({0} дес. л.),
						'name' => q(дес. л.),
						'one' => q({0} дес. л.),
						'other' => q({0} дес. л.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'few' => q({0} імп. дес. ложки),
						'many' => q({0} імп. дес. ложок),
						'name' => q(імп. дес. ложка),
						'one' => q({0} імп. дес. ложка),
						'other' => q({0} імп. дес. ложки),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'few' => q({0} імп. дес. ложки),
						'many' => q({0} імп. дес. ложок),
						'name' => q(імп. дес. ложка),
						'one' => q({0} імп. дес. ложка),
						'other' => q({0} імп. дес. ложки),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'few' => q({0} рід. драхми),
						'many' => q({0} рід. драхм),
						'name' => q(рід. драхма),
						'one' => q({0} рід. драхма),
						'other' => q({0} рід. драхми),
					},
					# Core Unit Identifier
					'dram' => {
						'few' => q({0} рід. драхми),
						'many' => q({0} рід. драхм),
						'name' => q(рід. драхма),
						'one' => q({0} рід. драхма),
						'other' => q({0} рід. драхми),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'few' => q({0} краплі),
						'many' => q({0} крапель),
						'name' => q(крапля),
						'one' => q({0} крапля),
						'other' => q({0} краплі),
					},
					# Core Unit Identifier
					'drop' => {
						'few' => q({0} краплі),
						'many' => q({0} крапель),
						'name' => q(крапля),
						'one' => q({0} крапля),
						'other' => q({0} краплі),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'few' => q({0} рід. унції),
						'many' => q({0} рід. унцій),
						'name' => q(рід. унція),
						'one' => q({0} рід. унція),
						'other' => q({0} рід. унції),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'few' => q({0} рід. унції),
						'many' => q({0} рід. унцій),
						'name' => q(рід. унція),
						'one' => q({0} рід. унція),
						'other' => q({0} рід. унції),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'few' => q({0} англ. рід. унції),
						'many' => q({0} англ. рід. унцій),
						'name' => q(англ. рід. унції),
						'one' => q({0} англ. рід. унція),
						'other' => q({0} англ. рід. унції),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'few' => q({0} англ. рід. унції),
						'many' => q({0} англ. рід. унцій),
						'name' => q(англ. рід. унції),
						'one' => q({0} англ. рід. унція),
						'other' => q({0} англ. рід. унції),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'few' => q({0} гал.),
						'many' => q({0} гал.),
						'name' => q(гал.),
						'one' => q({0} гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Core Unit Identifier
					'gallon' => {
						'few' => q({0} гал.),
						'many' => q({0} гал.),
						'name' => q(гал.),
						'one' => q({0} гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'few' => q({0} англ. галони),
						'many' => q({0} англ. галонів),
						'name' => q(англ. галон),
						'one' => q({0} англ. галон),
						'other' => q({0} англ. галона),
						'per' => q({0}/англ. галон),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'few' => q({0} англ. галони),
						'many' => q({0} англ. галонів),
						'name' => q(англ. галон),
						'one' => q({0} англ. галон),
						'other' => q({0} англ. галона),
						'per' => q({0}/англ. галон),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'few' => q({0} гл),
						'many' => q({0} гл),
						'name' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'few' => q({0} гл),
						'many' => q({0} гл),
						'name' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'few' => q({0} мірки),
						'many' => q({0} мірок),
						'name' => q(мірка),
						'one' => q({0} мірка),
						'other' => q({0} мірки),
					},
					# Core Unit Identifier
					'jigger' => {
						'few' => q({0} мірки),
						'many' => q({0} мірок),
						'name' => q(мірка),
						'one' => q({0} мірка),
						'other' => q({0} мірки),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'few' => q({0} л),
						'many' => q({0} л),
						'name' => q(л),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Core Unit Identifier
					'liter' => {
						'few' => q({0} л),
						'many' => q({0} л),
						'name' => q(л),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'few' => q({0} Мл),
						'many' => q({0} Мл),
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					# Core Unit Identifier
					'megaliter' => {
						'few' => q({0} Мл),
						'many' => q({0} Мл),
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'few' => q({0} мл),
						'many' => q({0} мл),
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Core Unit Identifier
					'milliliter' => {
						'few' => q({0} мл),
						'many' => q({0} мл),
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'few' => q({0} дрібки),
						'many' => q({0} дрібок),
						'name' => q(дрібка),
						'one' => q({0} дрібка),
						'other' => q({0} дрібки),
					},
					# Core Unit Identifier
					'pinch' => {
						'few' => q({0} дрібки),
						'many' => q({0} дрібок),
						'name' => q(дрібка),
						'one' => q({0} дрібка),
						'other' => q({0} дрібки),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'few' => q({0} пінти),
						'many' => q({0} пінт),
						'name' => q(пінти),
						'one' => q({0} пінта),
						'other' => q({0} пінти),
					},
					# Core Unit Identifier
					'pint' => {
						'few' => q({0} пінти),
						'many' => q({0} пінт),
						'name' => q(пінти),
						'one' => q({0} пінта),
						'other' => q({0} пінти),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'few' => q({0} метр. пінти),
						'many' => q({0} метр. пінт),
						'name' => q(метр. пінта),
						'one' => q({0} метр. пінта),
						'other' => q({0} метр. пінти),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'few' => q({0} метр. пінти),
						'many' => q({0} метр. пінт),
						'name' => q(метр. пінта),
						'one' => q({0} метр. пінта),
						'other' => q({0} метр. пінти),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'few' => q({0} квар.),
						'many' => q({0} квар.),
						'name' => q(квар.),
						'one' => q({0} квар.),
						'other' => q({0} квар.),
					},
					# Core Unit Identifier
					'quart' => {
						'few' => q({0} квар.),
						'many' => q({0} квар.),
						'name' => q(квар.),
						'one' => q({0} квар.),
						'other' => q({0} квар.),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'few' => q({0} імп. квар.),
						'many' => q({0} імп. квар.),
						'name' => q(імп. квар.),
						'one' => q({0} імп. квар.),
						'other' => q({0} імп. квар.),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'few' => q({0} імп. квар.),
						'many' => q({0} імп. квар.),
						'name' => q(імп. квар.),
						'one' => q({0} імп. квар.),
						'other' => q({0} імп. квар.),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'few' => q({0} ст. ложки),
						'many' => q({0} ст. ложок),
						'name' => q(ст. ложка),
						'one' => q({0} ст. ложка),
						'other' => q({0} ст. ложки),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'few' => q({0} ст. ложки),
						'many' => q({0} ст. ложок),
						'name' => q(ст. ложка),
						'one' => q({0} ст. ложка),
						'other' => q({0} ст. ложки),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'few' => q({0} ч. л.),
						'many' => q({0} ч. л.),
						'name' => q(ч. л.),
						'one' => q({0} ч. л.),
						'other' => q({0} ч. л.),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'few' => q({0} ч. л.),
						'many' => q({0} ч. л.),
						'name' => q(ч. л.),
						'one' => q({0} ч. л.),
						'other' => q({0} ч. л.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:так|т|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ні|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} і {1}),
				2 => q({0} і {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(Е),
			'group' => q( ),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'few' => '0 тис'.'',
					'many' => '0 тис'.'',
					'one' => '0 тис'.'',
					'other' => '0 тис'.'',
				},
				'10000' => {
					'few' => '00 тис'.'',
					'many' => '00 тис'.'',
					'one' => '00 тис'.'',
					'other' => '00 тис'.'',
				},
				'100000' => {
					'few' => '000 тис'.'',
					'many' => '000 тис'.'',
					'one' => '000 тис'.'',
					'other' => '000 тис'.'',
				},
				'1000000' => {
					'few' => '0 млн',
					'many' => '0 млн',
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'few' => '00 млн',
					'many' => '00 млн',
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'few' => '000 млн',
					'many' => '000 млн',
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'many' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'many' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'many' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 трлн',
					'many' => '0 трлн',
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'few' => '00 трлн',
					'many' => '00 трлн',
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'few' => '000 трлн',
					'many' => '000 трлн',
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'few' => '0 тисячі',
					'many' => '0 тисяч',
					'one' => '0 тисяча',
					'other' => '0 тисячі',
				},
				'10000' => {
					'few' => '00 тисячі',
					'many' => '00 тисяч',
					'one' => '00 тисяча',
					'other' => '00 тисячі',
				},
				'100000' => {
					'few' => '000 тисячі',
					'many' => '000 тисяч',
					'one' => '000 тисяча',
					'other' => '000 тисячі',
				},
				'1000000' => {
					'few' => '0 мільйони',
					'many' => '0 мільйонів',
					'one' => '0 мільйон',
					'other' => '0 мільйона',
				},
				'10000000' => {
					'few' => '00 мільйони',
					'many' => '00 мільйонів',
					'one' => '00 мільйон',
					'other' => '00 мільйона',
				},
				'100000000' => {
					'few' => '000 мільйони',
					'many' => '000 мільйонів',
					'one' => '000 мільйон',
					'other' => '000 мільйона',
				},
				'1000000000' => {
					'few' => '0 мільярди',
					'many' => '0 мільярдів',
					'one' => '0 мільярд',
					'other' => '0 мільярда',
				},
				'10000000000' => {
					'few' => '00 мільярди',
					'many' => '00 мільярдів',
					'one' => '00 мільярд',
					'other' => '00 мільярда',
				},
				'100000000000' => {
					'few' => '000 мільярди',
					'many' => '000 мільярдів',
					'one' => '000 мільярд',
					'other' => '000 мільярда',
				},
				'1000000000000' => {
					'few' => '0 трильйони',
					'many' => '0 трильйонів',
					'one' => '0 трильйон',
					'other' => '0 трильйона',
				},
				'10000000000000' => {
					'few' => '00 трильйони',
					'many' => '00 трильйонів',
					'one' => '00 трильйон',
					'other' => '00 трильйона',
				},
				'100000000000000' => {
					'few' => '000 трильйони',
					'many' => '000 трильйонів',
					'one' => '000 трильйон',
					'other' => '000 трильйона',
				},
			},
			'short' => {
				'1000' => {
					'few' => '0 тис'.'',
					'many' => '0 тис'.'',
					'one' => '0 тис'.'',
					'other' => '0 тис'.'',
				},
				'10000' => {
					'few' => '00 тис'.'',
					'many' => '00 тис'.'',
					'one' => '00 тис'.'',
					'other' => '00 тис'.'',
				},
				'100000' => {
					'few' => '000 тис'.'',
					'many' => '000 тис'.'',
					'one' => '000 тис'.'',
					'other' => '000 тис'.'',
				},
				'1000000' => {
					'few' => '0 млн',
					'many' => '0 млн',
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'few' => '00 млн',
					'many' => '00 млн',
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'few' => '000 млн',
					'many' => '000 млн',
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'many' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'many' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'many' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 трлн',
					'many' => '0 трлн',
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'few' => '00 трлн',
					'many' => '00 трлн',
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'few' => '000 трлн',
					'many' => '000 трлн',
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(андоррська песета),
				'few' => q(андоррські песети),
				'many' => q(андоррських песет),
				'one' => q(андоррська песета),
				'other' => q(андоррських песет),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(дирхам ОАЕ),
				'few' => q(дирхами ОАЕ),
				'many' => q(дирхамів ОАЕ),
				'one' => q(дирхам ОАЕ),
				'other' => q(дирхама ОАЕ),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(афгані \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(афганський афгані),
				'few' => q(афганські афгані),
				'many' => q(афганських афгані),
				'one' => q(афганський афгані),
				'other' => q(афганського афгані),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(албанський лек),
				'few' => q(албанські леки),
				'many' => q(албанських леків),
				'one' => q(албанський лек),
				'other' => q(албанського лека),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(вірменський драм),
				'few' => q(вірменські драми),
				'many' => q(вірменських драмів),
				'one' => q(вірменський драм),
				'other' => q(вірменського драма),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(нідерландський антильський гульден),
				'few' => q(нідерландські антильські гульдени),
				'many' => q(нідерландських антильських гульденів),
				'one' => q(нідерландський антильський гульден),
				'other' => q(нідерландського антильського гульдена),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ангольська кванза),
				'few' => q(ангольські кванзи),
				'many' => q(ангольських кванз),
				'one' => q(ангольська кванза),
				'other' => q(ангольської кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ангольська кванза \(1977–1990\)),
				'few' => q(ангольські кванзи \(1977–1990\)),
				'many' => q(ангольських кванз \(1977–1990\)),
				'one' => q(ангольська кванза \(1977–1990\)),
				'other' => q(ангольської кванзи \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(ангольська нова кванза \(1990–2000\)),
				'few' => q(ангольські нові кванзи \(1990–2000\)),
				'many' => q(ангольських нових кванз \(1990–2000\)),
				'one' => q(ангольська нова кванза \(1990–2000\)),
				'other' => q(ангольської нової кванзи \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(ангольська кванза реаджастадо \(1995–1999\)),
				'few' => q(ангольські кванзи реаджастадо \(1995–1999\)),
				'many' => q(ангольських кванз реаджастадо \(1995–1999\)),
				'one' => q(ангольська кванза реаджастадо \(1995–1999\)),
				'other' => q(ангольської кванзи реаджастадо \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(аргентинський австрал),
				'few' => q(аргентинські австрали),
				'many' => q(аргентинських австралів),
				'one' => q(аргентинський австрал),
				'other' => q(аргентинського австрала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(аргентинський песо \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(аргентинський песо),
				'few' => q(аргентинські песо),
				'many' => q(аргентинських песо),
				'one' => q(аргентинський песо),
				'other' => q(аргентинського песо),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(австрійський шилінг),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(австралійський долар),
				'few' => q(австралійські долари),
				'many' => q(австралійських доларів),
				'one' => q(австралійський долар),
				'other' => q(австралійського долара),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(арубський флорин),
				'few' => q(арубські флорини),
				'many' => q(арубських флоринів),
				'one' => q(арубський флорин),
				'other' => q(арубського флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(азербайджанський манат \(1993–2006\)),
				'few' => q(азербайджанські манати \(1993–2006\)),
				'many' => q(азербайджанських манатів \(1993–2006\)),
				'one' => q(азербайджанський манат \(1993–2006\)),
				'other' => q(азербайджанського маната \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(азербайджанський манат),
				'few' => q(азербайджанські манати),
				'many' => q(азербайджанських манатів),
				'one' => q(азербайджанський манат),
				'other' => q(азербайджанського маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(динар \(Боснія і Герцеговина\)),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(конвертована марка Боснії і Герцеговини),
				'few' => q(конвертовані марки Боснії і Герцеговини),
				'many' => q(конвертованих марок Боснії і Герцеговини),
				'one' => q(конвертована марка Боснії і Герцеговини),
				'other' => q(конвертованої марки Боснії і Герцеговини),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(барбадоський долар),
				'few' => q(барбадоські долари),
				'many' => q(барбадоських доларів),
				'one' => q(барбадоський долар),
				'other' => q(барбадоського долара),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(бангладеська така),
				'few' => q(бангладеські таки),
				'many' => q(бангладеських так),
				'one' => q(бангладеська така),
				'other' => q(бангладеської таки),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(бельгійський франк \(конвертований\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(бельгійський франк),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(бельгійський франк \(фінансовий\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(болгарський твердий лев),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(болгарський лев),
				'few' => q(болгарські леви),
				'many' => q(болгарських левів),
				'one' => q(болгарський лев),
				'other' => q(болгарського лева),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(бахрейнський динар),
				'few' => q(бахрейнські динари),
				'many' => q(бахрейнських динарів),
				'one' => q(бахрейнський динар),
				'other' => q(бахрейнського динара),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(бурундійський франк),
				'few' => q(бурундійські франки),
				'many' => q(бурундійських франків),
				'one' => q(бурундійський франк),
				'other' => q(бурундійського франка),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(бермудський долар),
				'few' => q(бермудські долари),
				'many' => q(бермудських доларів),
				'one' => q(бермудський долар),
				'other' => q(бермудського долара),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(брунейський долар),
				'few' => q(брунейські долари),
				'many' => q(брунейських доларів),
				'one' => q(брунейський долар),
				'other' => q(брунейського долара),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(болівійський болівіано),
				'few' => q(болівійські болівіано),
				'many' => q(болівійських болівіано),
				'one' => q(болівійський болівіано),
				'other' => q(болівійського болівіано),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(болівійське песо),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(болівійський мвдол),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(бразильське нове крузейро \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(бразильське крузадо),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(бразильське крузейро \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'BRL',
			display_name => {
				'currency' => q(бразильський реал),
				'few' => q(бразильські реали),
				'many' => q(бразильських реалів),
				'one' => q(бразильський реал),
				'other' => q(бразильського реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(бразильське нове крузадо),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(бразильське крузейро),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(багамський долар),
				'few' => q(багамські долари),
				'many' => q(багамських доларів),
				'one' => q(багамський долар),
				'other' => q(багамського долара),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(бутанський нгултрум),
				'few' => q(бутанські нгултруми),
				'many' => q(бутанських нгултрумів),
				'one' => q(бутанський нгултрум),
				'other' => q(бутанського нгултрума),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(бірманський кіат),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ботсванська пула),
				'few' => q(ботсванські пули),
				'many' => q(ботсванських пул),
				'one' => q(ботсванська пула),
				'other' => q(ботсванської пули),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(білоруський новий рубль \(1994–1999\)),
				'few' => q(білоруські нові рублі \(1994–1999\)),
				'many' => q(білоруських нових рублів \(1994–1999\)),
				'one' => q(білоруський новий рубль \(1994–1999\)),
				'other' => q(білоруського нового рубля \(1994–1999\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(білоруський рубль),
				'few' => q(білоруські рублі),
				'many' => q(білоруських рублів),
				'one' => q(білоруський рубль),
				'other' => q(білоруського рубля),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(білоруський рубль \(2000–2016\)),
				'few' => q(білоруські рублі \(2000–2016\)),
				'many' => q(білоруських рублів \(2000–2016\)),
				'one' => q(білоруський рубль \(2000–2016\)),
				'other' => q(білоруського рубля \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(белізький долар),
				'few' => q(белізькі долари),
				'many' => q(белізьких доларів),
				'one' => q(белізький долар),
				'other' => q(белізького долара),
			},
		},
		'CAD' => {
			symbol => 'CAD',
			display_name => {
				'currency' => q(канадський долар),
				'few' => q(канадські долари),
				'many' => q(канадських доларів),
				'one' => q(канадський долар),
				'other' => q(канадського долара),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(конголезький франк),
				'few' => q(конголезькі франки),
				'many' => q(конголезьких франків),
				'one' => q(конголезький франк),
				'other' => q(конголезького франка),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(євро WIR),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(швейцарський франк),
				'few' => q(швейцарські франки),
				'many' => q(швейцарських франків),
				'one' => q(швейцарський франк),
				'other' => q(швейцарського франка),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(франк WIR),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(чилійський юнідадес де фоменто),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(чилійський песо),
				'few' => q(чилійські песо),
				'many' => q(чилійських песо),
				'one' => q(чилійський песо),
				'other' => q(чилійського песо),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(китайський офшорний юань),
				'few' => q(китайські офшорні юані),
				'many' => q(китайських офшорних юанів),
				'one' => q(китайський офшорний юань),
				'other' => q(китайського офшорного юаня),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(китайський юань),
				'few' => q(китайські юані),
				'many' => q(китайських юанів),
				'one' => q(китайський юань),
				'other' => q(китайського юаня),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(колумбійський песо),
				'few' => q(колумбійські песо),
				'many' => q(колумбійських песо),
				'one' => q(колумбійський песо),
				'other' => q(колумбійського песо),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(одиниця реальної вартості),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(костариканський колон),
				'few' => q(костариканські колони),
				'many' => q(костариканських колонів),
				'one' => q(костариканський колон),
				'other' => q(костариканського колона),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(старий сербський динар),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(чехословацька тверда крона),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(кубинський конвертований песо),
				'few' => q(кубинські конвертовані песо),
				'many' => q(кубинських конвертованих песо),
				'one' => q(кубинський конвертований песо),
				'other' => q(кубинського конвертованого песо),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(кубинський песо),
				'few' => q(кубинські песо),
				'many' => q(кубинських песо),
				'one' => q(кубинський песо),
				'other' => q(кубинського песо),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ескудо Кабо-Верде),
				'few' => q(ескудо Кабо-Верде),
				'many' => q(ескудо Кабо-Верде),
				'one' => q(ескудо Кабо-Верде),
				'other' => q(ескудо Кабо-Верде),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(кіпрський фунт),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(чеська крона),
				'few' => q(чеські крони),
				'many' => q(чеських крон),
				'one' => q(чеська крона),
				'other' => q(чеської крони),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(марка НДР),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(німецька марка),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(джибутійський франк),
				'few' => q(джибутійські франки),
				'many' => q(джибутійських франків),
				'one' => q(джибутійський франк),
				'other' => q(джибутійського франка),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(данська крона),
				'few' => q(данські крони),
				'many' => q(данських крон),
				'one' => q(данська крона),
				'other' => q(данської крони),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(домініканський песо),
				'few' => q(домініканські песо),
				'many' => q(домініканських песо),
				'one' => q(домініканський песо),
				'other' => q(домініканського песо),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(алжирський динар),
				'few' => q(алжирські динари),
				'many' => q(алжирських динарів),
				'one' => q(алжирський динар),
				'other' => q(алжирського динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(еквадорський сукре),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(еквадорський юнідад де валор константе),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(естонська крона),
				'few' => q(естонські крони),
				'many' => q(естонських крон),
				'one' => q(естонська крона),
				'other' => q(естонської крони),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(єгипетський фунт),
				'few' => q(єгипетські фунти),
				'many' => q(єгипетських фунтів),
				'one' => q(єгипетський фунт),
				'other' => q(єгипетського фунта),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(еритрейська накфа),
				'few' => q(еритрейські накфи),
				'many' => q(еритрейських накф),
				'one' => q(еритрейська накфа),
				'other' => q(еритрейської накфи),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(іспанська песета \("А" рахунок\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(іспанська песета \(конвертовані рахунки\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(іспанська песета),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ефіопський бир),
				'few' => q(ефіопські бири),
				'many' => q(ефіопських бирів),
				'one' => q(ефіопський бир),
				'other' => q(ефіопського бира),
			},
		},
		'EUR' => {
			symbol => 'EUR',
			display_name => {
				'currency' => q(євро),
				'few' => q(євро),
				'many' => q(євро),
				'one' => q(євро),
				'other' => q(євро),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(фінляндська марка),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(фіджійський долар),
				'few' => q(фіджійські долари),
				'many' => q(фіджійських доларів),
				'one' => q(фіджійський долар),
				'other' => q(фіджійського долара),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(фунт Фолклендських островів),
				'few' => q(фунти Фолклендських островів),
				'many' => q(фунтів Фолклендських островів),
				'one' => q(фунт Фолклендських островів),
				'other' => q(фунта Фолклендських островів),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(французький франк),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(англійський фунт),
				'few' => q(англійські фунти),
				'many' => q(англійських фунтів),
				'one' => q(англійський фунт),
				'other' => q(англійського фунта),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(грузинський купон),
				'few' => q(грузинські купони),
				'many' => q(грузинських купонів),
				'one' => q(грузинський купон),
				'other' => q(грузинського купона),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(грузинський ларі),
				'few' => q(грузинські ларі),
				'many' => q(грузинських ларі),
				'one' => q(грузинський ларі),
				'other' => q(грузинського ларі),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ганський седі \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ганський седі),
				'few' => q(ганські седі),
				'many' => q(ганських седі),
				'one' => q(ганський седі),
				'other' => q(ганського седі),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(гібралтарський фунт),
				'few' => q(гібралтарські фунти),
				'many' => q(гібралтарських фунтів),
				'one' => q(гібралтарський фунт),
				'other' => q(гібралтарського фунта),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(гамбійський даласі),
				'few' => q(гамбійські даласі),
				'many' => q(гамбійських даласі),
				'one' => q(гамбійський даласі),
				'other' => q(гамбійського даласі),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(гвінейський франк),
				'few' => q(гвінейські франки),
				'many' => q(гвінейських франків),
				'one' => q(гвінейський франк),
				'other' => q(гвінейського франка),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(гвінейське сілі),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(еквеле \(Екваторіальна Ґвінея\)),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(грецька драхма),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(гватемальський кетсаль),
				'few' => q(гватемальські кетсалі),
				'many' => q(гватемальських кетсалів),
				'one' => q(гватемальський кетсаль),
				'other' => q(гватемальського кетсаля),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(ескудо португальської гвінеї),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(песо Гвінеї-Бісау),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(гаянський долар),
				'few' => q(гаянські долари),
				'many' => q(гаянських доларів),
				'one' => q(гаянський долар),
				'other' => q(гаянського долара),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(гонконгський долар),
				'few' => q(гонконгські долари),
				'many' => q(гонконгських доларів),
				'one' => q(гонконгський долар),
				'other' => q(гонконгського долара),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(гондураська лемпіра),
				'few' => q(гондураські лемпіри),
				'many' => q(гондураських лемпір),
				'one' => q(гондураська лемпіра),
				'other' => q(гондураської лемпіри),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(хорватський динар),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(хорватська куна),
				'few' => q(хорватські куни),
				'many' => q(хорватських кун),
				'one' => q(хорватська куна),
				'other' => q(хорватської куни),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(гаїтянський гурд),
				'few' => q(гаїтянські гурди),
				'many' => q(гаїтянських гурдів),
				'one' => q(гаїтянський гурд),
				'other' => q(гаїтянського гурда),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(угорський форинт),
				'few' => q(угорські форинти),
				'many' => q(угорських форинтів),
				'one' => q(угорський форинт),
				'other' => q(угорського форинта),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(індонезійська рупія),
				'few' => q(індонезійські рупії),
				'many' => q(індонезійських рупій),
				'one' => q(індонезійська рупія),
				'other' => q(індонезійські рупії),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ірландський фунт),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ізраїльський фунт),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(ізраїльський новий шекель),
				'few' => q(ізраїльські нові шекелі),
				'many' => q(ізраїльських нових шекелів),
				'one' => q(ізраїльський новий шекель),
				'other' => q(ізраїльського нового шекеля),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(індійська рупія),
				'few' => q(індійські рупії),
				'many' => q(індійських рупій),
				'one' => q(індійська рупія),
				'other' => q(індійської рупії),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(іракський динар),
				'few' => q(іракські динари),
				'many' => q(іракських динарів),
				'one' => q(іракський динар),
				'other' => q(іракського динара),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(іранський ріал),
				'few' => q(іранські ріали),
				'many' => q(іранських ріалів),
				'one' => q(іранський ріал),
				'other' => q(іранського ріала),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ісландська крона),
				'few' => q(ісландські кроні),
				'many' => q(ісландських крон),
				'one' => q(ісландська крона),
				'other' => q(ісландської крони),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(італійська ліра),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ямайський долар),
				'few' => q(ямайські долари),
				'many' => q(ямайських доларів),
				'one' => q(ямайський долар),
				'other' => q(ямайського долара),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(йорданський динар),
				'few' => q(йорданські динари),
				'many' => q(йорданських динарів),
				'one' => q(йорданський динар),
				'other' => q(йорданського динара),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(японська єна),
				'few' => q(японські єни),
				'many' => q(японських єн),
				'one' => q(японська єна),
				'other' => q(японської єни),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(кенійський шилінг),
				'few' => q(кенійські шилінги),
				'many' => q(кенійських шилінгів),
				'one' => q(кенійський шилінг),
				'other' => q(кенійського шилінга),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(киргизький сом),
				'few' => q(киргизькі соми),
				'many' => q(киргизьких сомів),
				'one' => q(киргизький сом),
				'other' => q(киргизького сома),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(камбоджійський рієль),
				'few' => q(камбоджійські рієлі),
				'many' => q(камбоджійських рієлів),
				'one' => q(камбоджійський рієль),
				'other' => q(камбоджійського рієля),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(коморський франк),
				'few' => q(коморські франки),
				'many' => q(коморських франків),
				'one' => q(коморський франк),
				'other' => q(коморського франка),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(північнокорейський вон),
				'few' => q(північнокорейські вони),
				'many' => q(північнокорейських вонів),
				'one' => q(північнокорейський вон),
				'other' => q(північнокорейського вона),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(південнокорейський вон),
				'few' => q(південнокорейські вони),
				'many' => q(південнокорейських вонів),
				'one' => q(південнокорейський вон),
				'other' => q(південнокорейського вона),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(кувейтський динар),
				'few' => q(кувейтські динари),
				'many' => q(кувейтських динарів),
				'one' => q(кувейтський динар),
				'other' => q(кувейтського динара),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(долар Кайманових островів),
				'few' => q(долари Кайманових островів),
				'many' => q(доларів Кайманових островів),
				'one' => q(долар Кайманових островів),
				'other' => q(долара Кайманових островів),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(казахстанський тенге),
				'few' => q(казахстанські тенге),
				'many' => q(казахстанських тенге),
				'one' => q(казахстанський тенге),
				'other' => q(казахстанського тенге),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(лаоський кіп),
				'few' => q(лаоські кіпи),
				'many' => q(лаоських кіпів),
				'one' => q(лаоський кіп),
				'other' => q(лаоського кіпа),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ліванський фунт),
				'few' => q(ліванські фунти),
				'many' => q(ліванських фунтів),
				'one' => q(ліванський фунт),
				'other' => q(ліванського фунта),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(шрі-ланкійська рупія),
				'few' => q(шрі-ланкійські рупії),
				'many' => q(шрі-ланкійських рупій),
				'one' => q(шрі-ланкійська рупія),
				'other' => q(шрі-ланкійської рупії),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ліберійський долар),
				'few' => q(ліберійські долари),
				'many' => q(ліберійських доларів),
				'one' => q(ліберійський долар),
				'other' => q(ліберійського долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(лесотський лоті),
				'few' => q(лесотські лоті),
				'many' => q(лесотських лоті),
				'one' => q(лесотський лоті),
				'other' => q(лесотського лоті),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(литовський літ),
				'few' => q(литовські літи),
				'many' => q(литовських літів),
				'one' => q(литовський літ),
				'other' => q(литовського літа),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(литовський талон),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(люксембурґський франк \(конвертований\)),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(люксембурзький франк),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(люксембурґський франк \(фінансовий\)),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(латвійський лат),
				'few' => q(латвійські лати),
				'many' => q(латвійських латів),
				'one' => q(латвійський лат),
				'other' => q(латвійського лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(латвійський рубль),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(лівійський динар),
				'few' => q(лівійські динари),
				'many' => q(лівійських динарів),
				'one' => q(лівійський динар),
				'other' => q(лівійського динара),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(марокканський дирхам),
				'few' => q(марокканські дирхами),
				'many' => q(марокканських дирхамів),
				'one' => q(марокканський дирхам),
				'other' => q(марокканського дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(марокканський франк),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(молдовський лей),
				'few' => q(молдовські леї),
				'many' => q(молдовських леїв),
				'one' => q(молдовський лей),
				'other' => q(молдовського лея),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(малагасійський аріарі),
				'few' => q(малагасійські аріарі),
				'many' => q(малагасійських аріарі),
				'one' => q(малагасійський аріарі),
				'other' => q(малагасійського аріарі),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(мадагаскарський франк),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(македонський денар),
				'few' => q(македонські денари),
				'many' => q(македонських денарів),
				'one' => q(македонський денар),
				'other' => q(македонського денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(малійський франк),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(кʼят Мʼянми),
				'few' => q(кʼяти Мʼянми),
				'many' => q(кʼятів Мʼянми),
				'one' => q(кʼят Мʼянми),
				'other' => q(кʼята Мʼянми),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(монгольський тугрик),
				'few' => q(монгольські тугрики),
				'many' => q(монгольських тугриків),
				'one' => q(монгольський тугрик),
				'other' => q(монгольського тугрика),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(патака Макао),
				'few' => q(патаки Макао),
				'many' => q(патак Макао),
				'one' => q(патака Макао),
				'other' => q(патаки Макао),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(мавританська угія \(1973–2017\)),
				'few' => q(мавританські угії \(1973–2017\)),
				'many' => q(мавританських угій \(1973–2017\)),
				'one' => q(мавританська угія \(1973–2017\)),
				'other' => q(мавританської угії \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(мавританська угія),
				'few' => q(мавританські угії),
				'many' => q(мавританських угій),
				'one' => q(мавританська угія),
				'other' => q(мавританської угії),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(мальтійська ліра),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(мальтійський фунт),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(маврикійська рупія),
				'few' => q(маврикійські рупії),
				'many' => q(маврикійських рупій),
				'one' => q(маврикійська рупія),
				'other' => q(маврикійської рупії),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(мальдівська руфія),
				'few' => q(мальдівські руфії),
				'many' => q(мальдівських руфій),
				'one' => q(мальдівська руфія),
				'other' => q(мальдівської руфії),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(малавійська квача),
				'few' => q(малавійські квачі),
				'many' => q(малавійських квач),
				'one' => q(малавійська квача),
				'other' => q(малавійської квачі),
			},
		},
		'MXN' => {
			symbol => 'MXN',
			display_name => {
				'currency' => q(мексиканський песо),
				'few' => q(мексиканські песо),
				'many' => q(мексиканських песо),
				'one' => q(мексиканський песо),
				'other' => q(мексиканського песо),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(мексиканське срібне песо \(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(мексиканський юнідад де інверсіон),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(малайзійський рингіт),
				'few' => q(малайзійські рингіти),
				'many' => q(малайзійських рингітів),
				'one' => q(малайзійський рингіт),
				'other' => q(малайзійського рингіта),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(мозамбіцький ескудо),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(старий мозамбіцький метикал),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(мозамбіцький метикал),
				'few' => q(мозамбіцькі метикали),
				'many' => q(мозамбіцьких метикалів),
				'one' => q(мозамбіцький метикал),
				'other' => q(мозамбіцького метикала),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(намібійський долар),
				'few' => q(намібійські долари),
				'many' => q(намібійських доларів),
				'one' => q(намібійський долар),
				'other' => q(намібійського долара),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(нігерійська найра),
				'few' => q(нігерійські найри),
				'many' => q(нігерійських найр),
				'one' => q(нігерійська найра),
				'other' => q(нігерійської найри),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(нікарагуанська кордоба \(1988–1991\)),
				'few' => q(нікарагуанські кордоби \(1988–1991\)),
				'many' => q(нікарагуанських кордоб \(1988–1991\)),
				'one' => q(нікарагуанська кордоба \(1988–1991\)),
				'other' => q(нікарагуанської кордоби \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(нікарагуанська кордоба),
				'few' => q(нікарагуанські кордоби),
				'many' => q(нікарагуанських кордоб),
				'one' => q(нікарагуанська кордоба),
				'other' => q(нікарагуанської кордоби),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(нідерландський гульден),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(норвезька крона),
				'few' => q(норвезькі крони),
				'many' => q(норвезьких крон),
				'one' => q(норвезька крона),
				'other' => q(норвезької крони),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(непальська рупія),
				'few' => q(непальські рупії),
				'many' => q(непальських рупій),
				'one' => q(непальська рупія),
				'other' => q(непальської рупії),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(новозеландський долар),
				'few' => q(новозеландські долари),
				'many' => q(новозеландських доларів),
				'one' => q(новозеландський долар),
				'other' => q(новозеландського долара),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(оманський ріал),
				'few' => q(оманські ріали),
				'many' => q(оманських ріалів),
				'one' => q(оманський ріал),
				'other' => q(оманського ріала),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(панамське бальбоа),
				'few' => q(панамські бальбоа),
				'many' => q(панамських бальбоа),
				'one' => q(панамське бальбоа),
				'other' => q(панамського бальбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(перуанський інті),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(перуанський новий сол),
				'few' => q(перуанські нові соли),
				'many' => q(перуанських нових солів),
				'one' => q(перуанський новий сол),
				'other' => q(перуанського нового сола),
			},
		},
		'PES' => {
			symbol => 'PES',
			display_name => {
				'currency' => q(перуанський сол \(1863–1965\)),
				'few' => q(перуанські соли \(1863–1965\)),
				'many' => q(перуанських солів \(1863–1965\)),
				'one' => q(перуанський сол \(1863–1965\)),
				'other' => q(перуанського сола \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(кіна Папуа-Нової Ґвінеї),
				'few' => q(кіни Папуа-Нової Ґвінеї),
				'many' => q(кін Папуа-Нової Ґвінеї),
				'one' => q(кіна Папуа-Нової Ґвінеї),
				'other' => q(кіни Папуа-Нової Ґвінеї),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(філіппінський песо),
				'few' => q(філіппінські песо),
				'many' => q(філіппінських песо),
				'one' => q(філіппінський песо),
				'other' => q(філіппінського песо),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(пакистанська рупія),
				'few' => q(пакистанські рупії),
				'many' => q(пакистанських рупій),
				'one' => q(пакистанська рупія),
				'other' => q(пакистанської рупії),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(польський злотий),
				'few' => q(польські злоті),
				'many' => q(польських злотих),
				'one' => q(польський злотий),
				'other' => q(польського злотого),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(польський злотий \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(португальський ескудо),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(парагвайський гуарані),
				'few' => q(парагвайські гуарані),
				'many' => q(парагвайських гуарані),
				'one' => q(парагвайський гуарані),
				'other' => q(парагвайського гуарані),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(катарський ріал),
				'few' => q(катарські ріали),
				'many' => q(катарських ріалів),
				'one' => q(катарський ріал),
				'other' => q(катарського ріала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(родезійський долар),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(старий румунський лей),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(румунський лей),
				'few' => q(румунські леї),
				'many' => q(румунських леїв),
				'one' => q(румунський лей),
				'other' => q(румунського лея),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(сербський динар),
				'few' => q(сербські динари),
				'many' => q(сербських динарів),
				'one' => q(сербський динар),
				'other' => q(сербського динара),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(російський рубль),
				'few' => q(російські рублі),
				'many' => q(російських рублів),
				'one' => q(російський рубль),
				'other' => q(російського рубля),
			},
		},
		'RUR' => {
			symbol => 'RUR',
			display_name => {
				'currency' => q(російський рубль \(1991–1998\)),
				'few' => q(російські рублі \(RUR\)),
				'many' => q(російських рублів \(RUR\)),
				'one' => q(російський рубль \(RUR\)),
				'other' => q(російського рубля \(RUR\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(руандійський франк),
				'few' => q(руандійські франки),
				'many' => q(руандійських франків),
				'one' => q(руандійський франк),
				'other' => q(руандійського франка),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(саудівський ріал),
				'few' => q(саудівські ріали),
				'many' => q(саудівських ріалів),
				'one' => q(саудівський ріал),
				'other' => q(саудівського ріала),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(долар Соломонових Островів),
				'few' => q(долари Соломонових Островів),
				'many' => q(доларів Соломонових Островів),
				'one' => q(долар Соломонових Островів),
				'other' => q(долара Соломонових Островів),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(сейшельська рупія),
				'few' => q(сейшельські рупії),
				'many' => q(сейшельських рупій),
				'one' => q(сейшельська рупія),
				'other' => q(сейшельської рупії),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(суданський динар),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(суданський фунт),
				'few' => q(суданські фунти),
				'many' => q(суданських фунтів),
				'one' => q(суданський фунт),
				'other' => q(суданського фунта),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(старий суданський фунт),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(шведська крона),
				'few' => q(шведські крони),
				'many' => q(шведських крон),
				'one' => q(шведська крона),
				'other' => q(шведської крони),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(сінгапурський долар),
				'few' => q(сінгапурські долари),
				'many' => q(сінгапурських доларів),
				'one' => q(сінгапурський долар),
				'other' => q(сінгапурського долара),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(фунт острова Святої Єлени),
				'few' => q(фунти острова Святої Єлени),
				'many' => q(фунтів острова Святої Єлени),
				'one' => q(фунт острова Святої Єлени),
				'other' => q(фунта острова Святої Єлени),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(словенський толар),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(словацька крона),
				'few' => q(словацькі крони),
				'many' => q(словацьких крон),
				'one' => q(словацька крона),
				'other' => q(словацької крони),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(леоне Сьєрра-Леоне),
				'few' => q(леоне Сьєрра-Леоне),
				'many' => q(леоне Сьєрра-Леоне),
				'one' => q(леоне Сьєрра-Леоне),
				'other' => q(леоне Сьєрра-Леоне),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(сомалійський шилінг),
				'few' => q(сомалійські шилінги),
				'many' => q(сомалійських шилінгів),
				'one' => q(сомалійський шилінг),
				'other' => q(сомалійського шилінга),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(суринамський долар),
				'few' => q(суринамські долари),
				'many' => q(суринамських доларів),
				'one' => q(суринамський долар),
				'other' => q(суринамського долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(суринамський гульден),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(південносуданський фунт),
				'few' => q(південносуданські фунти),
				'many' => q(південносуданських фунтів),
				'one' => q(південносуданський фунт),
				'other' => q(південносуданського фунта),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(добра Сан-Томе і Прінсіпі \(1977–2017\)),
				'few' => q(добри Сан-Томе і Принсіпі \(1977–2017\)),
				'many' => q(добр Сан-Томе і Принсіпі \(1977–2017\)),
				'one' => q(добра Сан-Томе і Прінсіпі \(1977–2017\)),
				'other' => q(добри Сан-Томе і Прінсіпі \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(добра Сан-Томе і Прінсіпі),
				'few' => q(добри Сан-Томе і Принсіпі),
				'many' => q(добр Сан-Томе і Принсіпі),
				'one' => q(добра Сан-Томе і Прінсіпі),
				'other' => q(добри Сан-Томе і Прінсіпі),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(радянський рубль),
				'few' => q(радянські рублі),
				'many' => q(радянських рублів),
				'one' => q(радянський рубль),
				'other' => q(радянського рубля),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(сальвадорський колон),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(сирійський фунт),
				'few' => q(сирійські фунти),
				'many' => q(сирійських фунтів),
				'one' => q(сирійський фунт),
				'other' => q(сирійського фунта),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(свазілендський лілангені),
				'few' => q(свазілендські лілангені),
				'many' => q(свазілендських лілангені),
				'one' => q(свазілендський лілангені),
				'other' => q(свазілендського лілангені),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(таїландський бат),
				'few' => q(таїландські бати),
				'many' => q(таїландських батів),
				'one' => q(таїландський бат),
				'other' => q(таїландського бата),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(таджицький рубль),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(таджицький сомоні),
				'few' => q(таджицькі сомоні),
				'many' => q(таджицьких сомоні),
				'one' => q(таджицький сомоні),
				'other' => q(таджицького сомоні),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(туркменський манат \(1993–2009\)),
				'few' => q(туркменські манати \(1993–2009\)),
				'many' => q(туркменських манатів \(1993–2009\)),
				'one' => q(туркменський манат \(1993–2009\)),
				'other' => q(туркменського маната \(1993–2009\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(туркменський манат),
				'few' => q(туркменські манати),
				'many' => q(туркменських манатів),
				'one' => q(туркменський манат),
				'other' => q(туркменського маната),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(туніський динар),
				'few' => q(туніські динари),
				'many' => q(туніських динарів),
				'one' => q(туніський динар),
				'other' => q(туніського динара),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(тонганська паанга),
				'few' => q(тонганські паанги),
				'many' => q(тонганських паанг),
				'one' => q(тонганська паанга),
				'other' => q(тонганської паанги),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(тіморський ескудо),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(турецька ліра \(1922–2005\)),
				'few' => q(турецькі ліри \(1922–2005\)),
				'many' => q(турецьких лір \(1922–2005\)),
				'one' => q(турецька ліра \(1922–2005\)),
				'other' => q(турецької ліри \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(турецька ліра),
				'few' => q(турецькі ліри),
				'many' => q(турецьких лір),
				'one' => q(турецька ліра),
				'other' => q(турецької ліри),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(долар Тринідаду і Тобаго),
				'few' => q(долари Тринідаду і Тобаго),
				'many' => q(доларів Тринідаду і Тобаго),
				'one' => q(долар Тринідаду і Тобаго),
				'other' => q(долара Тринідаду і Тобаго),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(новий тайванський долар),
				'few' => q(нові тайванські долари),
				'many' => q(нових тайванських доларів),
				'one' => q(новий тайванський долар),
				'other' => q(нового тайванського долара),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(танзанійський шилінг),
				'few' => q(танзанійські шилінги),
				'many' => q(танзанійських шилінгів),
				'one' => q(танзанійський шилінг),
				'other' => q(танзанійського шилінга),
			},
		},
		'UAH' => {
			symbol => '₴',
			display_name => {
				'currency' => q(українська гривня),
				'few' => q(українські гривні),
				'many' => q(українських гривень),
				'one' => q(українська гривня),
				'other' => q(української гривні),
			},
		},
		'UAK' => {
			symbol => 'крб.',
			display_name => {
				'currency' => q(український карбованець),
				'few' => q(українські карбованці),
				'many' => q(українських карбованців),
				'one' => q(український карбованець),
				'other' => q(українського карбованця),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(угандійський шилінг \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(угандійський шилінг),
				'few' => q(угандійські шилінги),
				'many' => q(угандійських шилінгів),
				'one' => q(угандійський шилінг),
				'other' => q(угандійського шилінга),
			},
		},
		'USD' => {
			symbol => 'USD',
			display_name => {
				'currency' => q(долар США),
				'few' => q(долари США),
				'many' => q(доларів США),
				'one' => q(долар США),
				'other' => q(долара США),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(долар США \(наступного дня\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(долар США \(цього дня\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(уругвайський песо в індексованих одиницях),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(уругвайське песо \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(уругвайський песо),
				'few' => q(уругвайські песо),
				'many' => q(уругвайських песо),
				'one' => q(уругвайський песо),
				'other' => q(уругвайського песо),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(узбецький сум),
				'few' => q(узбецькі суми),
				'many' => q(узбецьких сумів),
				'one' => q(узбецький сум),
				'other' => q(узбецького сума),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(венесуельський болівар \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(венесуельський болівар \(2008–2018\)),
				'few' => q(венесуельські болівари \(2008–2018\)),
				'many' => q(венесуельських боліварів \(2008–2018\)),
				'one' => q(венесуельський болівар \(2008–2018\)),
				'other' => q(венесуельського болівара \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(венесуельський болівар),
				'few' => q(венесуельські болівари),
				'many' => q(венесуельських боліварів),
				'one' => q(венесуельський болівар),
				'other' => q(венесуельського болівара),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(вʼєтнамський донг),
				'few' => q(вʼєтнамські донги),
				'many' => q(вʼєтнамських донгів),
				'one' => q(вʼєтнамський донг),
				'other' => q(вʼєтнамського донга),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(вануатський вату),
				'few' => q(вануатські вату),
				'many' => q(вануатських вату),
				'one' => q(вануатський вату),
				'other' => q(вануатського вату),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(самоанська тала),
				'few' => q(самоанські тали),
				'many' => q(самоанських тал),
				'one' => q(самоанська тала),
				'other' => q(самоанської тали),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(центральноафриканський франк),
				'few' => q(центральноафриканські франки),
				'many' => q(центральноафриканських франків),
				'one' => q(центральноафриканський франк),
				'other' => q(центральноафриканського франка),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(срібло),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(золото),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(європейська складена валютна одиниця),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(одиниця європейського валютного фонду),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(європейська розрахункова одиниця XBC),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(європейська розрахункова одиниця XBD),
			},
		},
		'XCD' => {
			symbol => 'XCD',
			display_name => {
				'currency' => q(східнокарибський долар),
				'few' => q(східнокарибські долари),
				'many' => q(східнокарибських доларів),
				'one' => q(східнокарибський долар),
				'other' => q(східнокарибського долара),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(спеціальні права запозичення),
				'few' => q(СПЗ),
				'many' => q(СПЗ),
				'one' => q(СПЗ),
				'other' => q(СПЗ),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(європейська валютна одиниця),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(французький золотий франк),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(французький франк UIC),
			},
		},
		'XOF' => {
			symbol => 'F CFA',
			display_name => {
				'currency' => q(західноафриканський франк),
				'few' => q(західноафриканські франки),
				'many' => q(західноафриканських франків),
				'one' => q(західноафриканський франк),
				'other' => q(західноафриканського франка),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(паладій),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(французький тихоокеанський франк),
				'few' => q(французькі тихоокеанські франки),
				'many' => q(французьких тихоокеанських франків),
				'one' => q(французький тихоокеанський франк),
				'other' => q(французького тихоокеанського франка),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(фонди RINET),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(код тестування валюти),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(невідома грошова одиниця),
				'few' => q(невідомі грошові одиниці),
				'many' => q(невідомих грошових одиниць),
				'one' => q(невідома грошова одиниця),
				'other' => q(невідомої грошової одиниці),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(єменський динар),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(єменський ріал),
				'few' => q(єменські ріали),
				'many' => q(єменських ріалів),
				'one' => q(єменський ріал),
				'other' => q(єменського ріала),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(югославський твердий динар),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(югославський новий динар),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(югославський конвертований динар),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(південноафриканський фінансовий ранд),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(південноафриканський ранд),
				'few' => q(південноафриканські ранди),
				'many' => q(південноафриканських рандів),
				'one' => q(південноафриканський ранд),
				'other' => q(південноафриканського ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(замбійська квача \(1968–2012\)),
				'few' => q(замбійські квачі \(1968–2012\)),
				'many' => q(замбійських квач \(1968–2012\)),
				'one' => q(замбійська квача \(1968–2012\)),
				'other' => q(замбійські квачі \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(замбійська квача),
				'few' => q(замбійські квачі),
				'many' => q(замбійських квач),
				'one' => q(замбійська квача),
				'other' => q(замбійської квачі),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(заїрський новий заїр),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(заїрський заїр),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(зімбабвійський долар),
				'few' => q(зімбабвійскі долари),
				'many' => q(зімбабвійських доларів),
				'one' => q(зімбабвійського долара),
				'other' => q(зімбабвійські долари),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(зімбабвійський долар \(2009\)),
				'few' => q(зімбабвійські долари \(2009\)),
				'many' => q(зімбабвійських доларів \(2009\)),
				'one' => q(зімбабвійський долар \(2009\)),
				'other' => q(зімбабвійського долара \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'few' => q(зімбабвійські долари \(2008\)),
				'many' => q(зімбабвійських доларів \(2008\)),
				'one' => q(зімбабвійський долар \(2008\)),
				'other' => q(зімбабвійського долара \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'тот',
							'баб.',
							'хат.',
							'кіх.',
							'тоб.',
							'амш.',
							'барам.',
							'барм.',
							'баш.',
							'баун.',
							'аб.',
							'мис.',
							'нас.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'тот',
							'бабе',
							'хатур',
							'кіхак',
							'тобе',
							'амшир',
							'барамхат',
							'бармуда',
							'башнас',
							'бауна',
							'абіб',
							'мисра',
							'насі'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'тот',
							'баб',
							'хат',
							'кіх',
							'тоб',
							'амш',
							'барам',
							'барм',
							'баш',
							'баун',
							'аб',
							'мис',
							'нас'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'тот',
							'бабе',
							'хатур',
							'кіхак',
							'тобе',
							'амшир',
							'барамхат',
							'бармуда',
							'башнас',
							'бауна',
							'абіб',
							'мисра',
							'насі'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'мес.',
							'тек.',
							'хед.',
							'тах.',
							'тер.',
							'єкат.',
							'мег.',
							'міяз.',
							'ген.',
							'сен.',
							'хам.',
							'нех.',
							'паг.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'01',
							'02',
							'03',
							'04',
							'05',
							'06',
							'07',
							'08',
							'09',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мескерема',
							'текемта',
							'хедара',
							'тахсаса',
							'тера',
							'єкатіта',
							'мегабіта',
							'міязія',
							'генбота',
							'сене',
							'хамле',
							'нехасе',
							'пагумена'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'мес.',
							'тек.',
							'хед.',
							'тах.',
							'тер.',
							'єкат.',
							'мег.',
							'міяз.',
							'ген.',
							'сен.',
							'хам.',
							'нех.',
							'паг.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'01',
							'02',
							'03',
							'04',
							'05',
							'06',
							'07',
							'08',
							'09',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мескерема',
							'текемт',
							'хедара',
							'тахсаса',
							'тера',
							'єкатіта',
							'мегабіта',
							'міязія',
							'генбота',
							'сене',
							'хамле',
							'нехасе',
							'пагумена'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'січ.',
							'лют.',
							'бер.',
							'квіт.',
							'трав.',
							'черв.',
							'лип.',
							'серп.',
							'вер.',
							'жовт.',
							'лист.',
							'груд.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'с',
							'л',
							'б',
							'к',
							'т',
							'ч',
							'л',
							'с',
							'в',
							'ж',
							'л',
							'г'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'січня',
							'лютого',
							'березня',
							'квітня',
							'травня',
							'червня',
							'липня',
							'серпня',
							'вересня',
							'жовтня',
							'листопада',
							'грудня'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'січ',
							'лют',
							'бер',
							'кві',
							'тра',
							'чер',
							'лип',
							'сер',
							'вер',
							'жов',
							'лис',
							'гру'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'С',
							'Л',
							'Б',
							'К',
							'Т',
							'Ч',
							'Л',
							'С',
							'В',
							'Ж',
							'Л',
							'Г'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'січень',
							'лютий',
							'березень',
							'квітень',
							'травень',
							'червень',
							'липень',
							'серпень',
							'вересень',
							'жовтень',
							'листопад',
							'грудень'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'тішри',
							'марчешван',
							'числьов',
							'тебет',
							'шеват',
							'адар I',
							'адар',
							'нісан',
							'іар',
							'сиван',
							'таммуз',
							'аб',
							'елул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'тішри',
							'марчешван',
							'числьов',
							'тебет',
							'шеват',
							'адар I',
							'адар',
							'нісан',
							'іар',
							'сиван',
							'таммуз',
							'аб',
							'елул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'тішри',
							'хешван',
							'кіслев',
							'тевет',
							'шват',
							'адар I',
							'адар',
							'нісан',
							'іяр',
							'сиван',
							'таммуз',
							'ав',
							'елул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'чайт.',
							'вайс.',
							'джай.',
							'асад.',
							'шрав.',
							'бхад.',
							'асв.',
							'кар.',
							'агр.',
							'паус.',
							'маг.',
							'фаль.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'чайтра',
							'вайсакха',
							'джайстха',
							'асадха',
							'шравана',
							'бхадра',
							'асвіна',
							'картіка',
							'аграхаяна',
							'пауса',
							'магха',
							'фальгуна'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'чайт.',
							'вайс.',
							'джай.',
							'асад.',
							'шрав.',
							'бхад.',
							'асв.',
							'кар.',
							'агр.',
							'паус.',
							'маг.',
							'фаль.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'чайтра',
							'вайсакха',
							'джайстха',
							'асадха',
							'шравана',
							'бхадра',
							'асвіна',
							'картіка',
							'аграхаяна',
							'пауса',
							'магха',
							'фальгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'мух.',
							'саф.',
							'рабі I',
							'рабі II',
							'джум. I',
							'джум. II',
							'радж.',
							'шааб.',
							'рам.',
							'дав.',
							'зу-ль-к.',
							'зу-ль-х.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мухаррам',
							'сафар',
							'рабі I',
							'рабі II',
							'джумада I',
							'джумада II',
							'раджаб',
							'шаабан',
							'рамадан',
							'даввал',
							'зу-ль-каада',
							'зу-ль-хіджа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'мух',
							'саф',
							'рабі I',
							'рабі II',
							'джум I',
							'джум II',
							'радж',
							'шааб',
							'рам',
							'дав',
							'зу-ль-к',
							'зу-ль-х'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мухаррам',
							'сафар',
							'рабі I',
							'рабі II',
							'джумада I',
							'джумада II',
							'раджаб',
							'шаабан',
							'рамадан',
							'даввал',
							'зу-ль-каада',
							'зу-ль-хіджа'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'фар.',
							'орд.',
							'хор.',
							'тір',
							'мор.',
							'шах.',
							'мех.',
							'абан',
							'азер',
							'дей',
							'бах.',
							'есф.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'фарвардін',
							'ордібехешт',
							'хордад',
							'тір',
							'мордад',
							'шахрівер',
							'мехр',
							'абан',
							'азер',
							'дей',
							'бахман',
							'есфанд'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'фар',
							'орд',
							'хор',
							'тір',
							'мор',
							'шах',
							'мех',
							'абан',
							'азер',
							'дей',
							'бах',
							'есф'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					narrow => {
						mon => 'П',
						tue => 'В',
						wed => 'С',
						thu => 'Ч',
						fri => 'П',
						sat => 'С',
						sun => 'Н'
					},
					short => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					wide => {
						mon => 'понеділок',
						tue => 'вівторок',
						wed => 'середа',
						thu => 'четвер',
						fri => 'пʼятниця',
						sat => 'субота',
						sun => 'неділя'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					narrow => {
						mon => 'П',
						tue => 'В',
						wed => 'С',
						thu => 'Ч',
						fri => 'П',
						sat => 'С',
						sun => 'Н'
					},
					short => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					wide => {
						mon => 'понеділок',
						tue => 'вівторок',
						wed => 'середа',
						thu => 'четвер',
						fri => 'пʼятниця',
						sat => 'субота',
						sun => 'неділя'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-й кв.',
						1 => '2-й кв.',
						2 => '3-й кв.',
						3 => '4-й кв.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-й квартал',
						1 => '2-й квартал',
						2 => '3-й квартал',
						3 => '4-й квартал'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-й кв.',
						1 => '2-й кв.',
						2 => '3-й кв.',
						3 => '4-й кв.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-й квартал',
						1 => '2-й квартал',
						2 => '3-й квартал',
						3 => '4-й квартал'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'japanese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{дня},
					'am' => q{дп},
					'evening1' => q{вечора},
					'midnight' => q{опівночі},
					'morning1' => q{ранку},
					'night1' => q{ночі},
					'noon' => q{пополудні},
					'pm' => q{пп},
				},
				'narrow' => {
					'afternoon1' => q{дня},
					'am' => q{дп},
					'evening1' => q{вечора},
					'midnight' => q{північ},
					'morning1' => q{ранку},
					'night1' => q{ночі},
					'noon' => q{п},
					'pm' => q{пп},
				},
				'wide' => {
					'afternoon1' => q{дня},
					'am' => q{дп},
					'evening1' => q{вечора},
					'midnight' => q{опівночі},
					'morning1' => q{ранку},
					'night1' => q{ночі},
					'noon' => q{пополудні},
					'pm' => q{пп},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{день},
					'am' => q{дп},
					'evening1' => q{вечір},
					'midnight' => q{північ},
					'morning1' => q{ранок},
					'night1' => q{ніч},
					'noon' => q{полудень},
					'pm' => q{пп},
				},
				'narrow' => {
					'afternoon1' => q{день},
					'am' => q{дп},
					'evening1' => q{вечір},
					'midnight' => q{північ},
					'morning1' => q{ранок},
					'night1' => q{ніч},
					'noon' => q{полудень},
					'pm' => q{пп},
				},
				'wide' => {
					'afternoon1' => q{день},
					'am' => q{дп},
					'evening1' => q{вечір},
					'morning1' => q{ранок},
					'night1' => q{ніч},
					'noon' => q{полудень},
					'pm' => q{пп},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'б. е.'
			},
			narrow => {
				'0' => 'б.е.'
			},
			wide => {
				'0' => 'б. е.'
			},
		},
		'coptic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'до н. е.',
				'1' => 'н. е.'
			},
			narrow => {
				'0' => 'до н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'до нашої ери',
				'1' => 'нашої ери'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
			narrow => {
				'0' => 'AM'
			},
			wide => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'Saka'
			},
			narrow => {
				'0' => 'Saka'
			},
			wide => {
				'0' => 'Saka'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
			narrow => {
				'0' => 'AH'
			},
			wide => {
				'0' => 'AH'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Тайка (645–650)',
				'1' => 'Хакуті (650–671)',
				'2' => 'Хакухо (672–686)',
				'3' => 'Сютьо (686–701)',
				'4' => 'Тайхо (701–704)',
				'5' => 'Кейун (704–708)',
				'6' => 'Вадо (708–715)',
				'7' => 'Рейкі (715–717)',
				'8' => 'Йоро (717–724)',
				'9' => 'Дзінгі (724–729)',
				'10' => 'Темпьо (729–749)',
				'11' => 'Темпьо-кампо (749–749)',
				'12' => 'Темпьо-сьохо (749–757)',
				'13' => 'Темпьо-ходзі (757–765)',
				'14' => 'Темпьо-дзінго (765–767)',
				'15' => 'Дзінго кейун (767–770)',
				'16' => 'Хокі (770–780)',
				'17' => 'Тен’о (781–782)',
				'18' => 'Енряку (782–806)',
				'19' => 'Дайдо (806–810)',
				'20' => 'Конін (810–824)',
				'21' => 'Тентьо (824–834)',
				'22' => 'Сьова (834–848)',
				'23' => 'Кадзьо (848–851)',
				'24' => 'Ніндзю (851–854)',
				'25' => 'Сайко (854–857)',
				'26' => 'Теннан (857–859)',
				'27' => 'Дзьоган (859–877)',
				'28' => 'Генкей (877–885)',
				'29' => 'Нінна (885–889)',
				'30' => 'Кампьо (889–898)',
				'31' => 'Сьотай (898–901)',
				'32' => 'Енгі (901–923)',
				'33' => 'Ентьо (923–931)',
				'34' => 'Сьохей (931–938)',
				'35' => 'Тенгьо (938–947)',
				'36' => 'Тенряку (947–957)',
				'37' => 'Тентоку (957–961)',
				'38' => 'Ова (961–964)',
				'39' => 'Кохо (964–968)',
				'40' => 'Анна (968–970)',
				'41' => 'Тенроку (970–973)',
				'42' => 'Тен’ен (973–976)',
				'43' => 'Дзьоген (976–978)',
				'44' => 'Тенген (978–983)',
				'45' => 'Ейкан (983–985)',
				'46' => 'Канна (985–987)',
				'47' => 'Ейен (987–989)',
				'48' => 'Ейсо (989–990)',
				'49' => 'Сьоряку (990–995)',
				'50' => 'Тьотоку (995–999)',
				'51' => 'Тьохо (999–1004)',
				'52' => 'Канко (1004–1012)',
				'53' => 'Тьова (1012–1017)',
				'54' => 'Каннін (1017–1021)',
				'55' => 'Дзіан (1021–1024)',
				'56' => 'Мандзю (1024–1028)',
				'57' => 'Тьоген (1028–1037)',
				'58' => 'Тьоряку (1037–1040)',
				'59' => 'Тьокю (1040–1044)',
				'60' => 'Кантоку (1044–1046)',
				'61' => 'Ейсьо (1046–1053)',
				'62' => 'Тенгі (1053–1058)',
				'63' => 'Кохей (1058–1065)',
				'64' => 'Дзіряку (1065–1069)',
				'65' => 'Енкю (1069–1074)',
				'66' => 'Сьохо (1074–1077)',
				'67' => 'Сьоряку (1077–1081)',
				'68' => 'Ейхо (1081–1084)',
				'69' => 'Отоку (1084–1087)',
				'70' => 'Кандзі (1087–1094)',
				'71' => 'Кахо (1094–1096)',
				'72' => 'Ейсьо (1096–1097)',
				'73' => 'Сьотоку (1097–1099)',
				'74' => 'Кова (1099–1104)',
				'75' => 'Тьодзі (1104–1106)',
				'76' => 'Кадзьо (1106–1108)',
				'77' => 'Теннін (1108–1110)',
				'78' => 'Тен’ей (1110–1113)',
				'79' => 'Ейкю (1113–1118)',
				'80' => 'Ген’ей (1118–1120)',
				'81' => 'Хоан (1120–1124)',
				'82' => 'Тендзі (1124–1126)',
				'83' => 'Дайдзі (1126–1131)',
				'84' => 'Тенсьо (1131–1132)',
				'85' => 'Тьосьо (1132–1135)',
				'86' => 'Хоен (1135–1141)',
				'87' => 'Ейдзі (1141–1142)',
				'88' => 'Кодзі (1142–1144)',
				'89' => 'Теньо (1144–1145)',
				'90' => 'Кюан (1145–1151)',
				'91' => 'Німпей (1151–1154)',
				'92' => 'Кюдзю (1154–1156)',
				'93' => 'Хоген (1156–1159)',
				'94' => 'Хейдзі (1159–1160)',
				'95' => 'Ейряку (1160–1161)',
				'96' => 'Охо (1161–1163)',
				'97' => 'Тьокан (1163–1165)',
				'98' => 'Ейман (1165–1166)',
				'99' => 'Нін’ан (1166–1169)',
				'100' => 'Као (1169–1171)',
				'101' => 'Сьоан (1171–1175)',
				'102' => 'Анген (1175–1177)',
				'103' => 'Дзісьо (1177–1181)',
				'104' => 'Йова (1181–1182)',
				'105' => 'Дзюей (1182–1184)',
				'106' => 'Генряку (1184–1185)',
				'107' => 'Бундзі (1185–1190)',
				'108' => 'Кенкю (1190–1199)',
				'109' => 'Сьодзі (1199–1201)',
				'110' => 'Кеннін (1201–1204)',
				'111' => 'Генкю (1204–1206)',
				'112' => 'Кен’ей (1206–1207)',
				'113' => 'Сьоген (1207–1211)',
				'114' => 'Кенряку (1211–1213)',
				'115' => 'Кенпо (1213–1219)',
				'116' => 'Дзьокю (1219–1222)',
				'117' => 'Дзьоо (1222–1224)',
				'118' => 'Геннін (1224–1225)',
				'119' => 'Кароку (1225–1227)',
				'120' => 'Антей (1227–1229)',
				'121' => 'Канкі (1229–1232)',
				'122' => 'Дзюей (1232–1233)',
				'123' => 'Темпуку (1233–1234)',
				'124' => 'Бунряку (1234–1235)',
				'125' => 'Катей (1235–1238)',
				'126' => 'Рякунін (1238–1239)',
				'127' => 'Ен’о (1239–1240)',
				'128' => 'Ніндзі (1240–1243)',
				'129' => 'Канген (1243–1247)',
				'130' => 'Хейдзі (1247–1249)',
				'131' => 'Кентьо (1249–1256)',
				'132' => 'Коген (1256–1257)',
				'133' => 'Сьока (1257–1259)',
				'134' => 'Сьоген (1259–1260)',
				'135' => 'Бун’о (1260–1261)',
				'136' => 'Котьо (1261–1264)',
				'137' => 'Бун’ей (1264–1275)',
				'138' => 'Кендзі (1275–1278)',
				'139' => 'Коан (1278–1288)',
				'140' => 'Сьоо (1288–1293)',
				'141' => 'Ейнін (1293–1299)',
				'142' => 'Сьоан (1299–1302)',
				'143' => 'Кенген (1302–1303)',
				'144' => 'Каген (1303–1306)',
				'145' => 'Токудзі (1306–1308)',
				'146' => 'Енкей (1308–1311)',
				'147' => 'Отьо (1311–1312)',
				'148' => 'Сьова (1312–1317)',
				'149' => 'Бумпо (1317–1319)',
				'150' => 'Ген’о (1319–1321)',
				'151' => 'Генкьо (1321–1324)',
				'152' => 'Сьотю (1324–1326)',
				'153' => 'Карекі (1326–1329)',
				'154' => 'Гентоку (1329–1331)',
				'155' => 'Генко (1331–1334)',
				'156' => 'Кемму (1334–1336)',
				'157' => 'Ейген (1336–1340)',
				'158' => 'Кококу (1340–1346)',
				'159' => 'Сьохей (1346–1370)',
				'160' => 'Кентоку (1370–1372)',
				'161' => 'Бунтю (1372–1375)',
				'162' => 'Тендзю (1375–1379)',
				'163' => 'Коряку (1379–1381)',
				'164' => 'Кова (1381–1384)',
				'165' => 'Гентю (1384–1392)',
				'166' => 'Мейтоку (1384–1387)',
				'167' => 'Какей (1387–1389)',
				'168' => 'Коо (1389–1390)',
				'169' => 'Мейтоку (1390–1394)',
				'170' => 'Оей (1394–1428)',
				'171' => 'Сьотьо (1428–1429)',
				'172' => 'Ейкьо (1429–1441)',
				'173' => 'Какіцу (1441–1444)',
				'174' => 'Буннан (1444–1449)',
				'175' => 'Хотоку (1449–1452)',
				'176' => 'Кьотоку (1452–1455)',
				'177' => 'Косьо (1455–1457)',
				'178' => 'Тьороку (1457–1460)',
				'179' => 'Кансьо (1460–1466)',
				'180' => 'Бунсьо (1466–1467)',
				'181' => 'Онін (1467–1469)',
				'182' => 'Буммей (1469–1487)',
				'183' => 'Тьокьо (1487–1489)',
				'184' => 'Ентоку (1489–1492)',
				'185' => 'Мейо (1492–1501)',
				'186' => 'Бункі (1501–1504)',
				'187' => 'Ейсьо (1504–1521)',
				'188' => 'Тайей (1521–1528)',
				'189' => 'Кьороку (1528–1532)',
				'190' => 'Теммон (1532–1555)',
				'191' => 'Кодзі (1555–1558)',
				'192' => 'Ейроку (1558–1570)',
				'193' => 'Генкі (1570–1573)',
				'194' => 'Тенсьо (1573–1592)',
				'195' => 'Бунроку (1592–1596)',
				'196' => 'Кейтьо (1596–1615)',
				'197' => 'Генна (1615–1624)',
				'198' => 'Кан’ей (1624–1644)',
				'199' => 'Сьохо (1644–1648)',
				'200' => 'Кейан (1648–1652)',
				'201' => 'Сьоо (1652–1655)',
				'202' => 'Мейряку (1655–1658)',
				'203' => 'Мандзі (1658–1661)',
				'204' => 'Камбун (1661–1673)',
				'205' => 'Емпо (1673–1681)',
				'206' => 'Тенва (1681–1684)',
				'207' => 'Дзьокьо (1684–1688)',
				'208' => 'Генроку (1688–1704)',
				'209' => 'Хоей (1704–1711)',
				'210' => 'Сьотоку (1711–1716)',
				'211' => 'Кьохо (1716–1736)',
				'212' => 'Гембун (1736–1741)',
				'213' => 'Канпо (1741–1744)',
				'214' => 'Енкьо (1744–1748)',
				'215' => 'Кан’ен (1748–1751)',
				'216' => 'Хоряку (1751–1764)',
				'217' => 'Мейва (1764–1772)',
				'218' => 'Ан’ей (1772–1781)',
				'219' => 'Теммей (1781–1789)',
				'220' => 'Кансей (1789–1801)',
				'221' => 'Кьова (1801–1804)',
				'222' => 'Бунка (1804–1818)',
				'223' => 'Бунсей (1818–1830)',
				'224' => 'Тенпо (1830–1844)',
				'225' => 'Кока (1844–1848)',
				'226' => 'Каей (1848–1854)',
				'227' => 'Ансей (1854–1860)',
				'228' => 'Ман’ен (1860–1861)',
				'229' => 'Бункю (1861–1864)',
				'230' => 'Гендзі (1864–1865)',
				'231' => 'Кейо (1865–1868)',
				'232' => 'Мейдзі',
				'233' => 'Тайсьо',
				'234' => 'Сьова',
				'235' => 'Хейсей',
				'236' => 'Рейва'
			},
		},
		'persian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d MMMM y 'р'. G},
			'long' => q{d MMMM y 'р'. G},
			'medium' => q{d MMM y 'р'. G},
			'short' => q{dd.MM.yy GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y 'р'.},
			'long' => q{d MMMM y 'р'.},
			'medium' => q{d MMM y 'р'.},
			'short' => q{dd.MM.yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} 'о' {0}},
			'long' => q{{1} 'о' {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} 'о' {0}},
			'long' => q{{1} 'о' {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{LLL y 'р'. G},
			GyMMMEd => q{E, d MMM y 'р'. G},
			GyMMMd => q{d MMM y 'р'. G},
			GyMd => q{dd-MM-y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd.MM},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMEd => q{E, d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{MM.y G},
			yyyyMEd => q{E, dd.MM.y G},
			yyyyMMM => q{LLL y 'р'. G},
			yyyyMMMEd => q{E, d MMM y 'р'. G},
			yyyyMMMM => q{LLLL y 'р'. G},
			yyyyMMMd => q{d MMM y 'р'. G},
			yyyyMd => q{dd.MM.y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y 'р'. G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{LLL y 'р'. G},
			GyMMMEd => q{E, d MMM y 'р'. G},
			GyMMMd => q{d MMM y 'р'. G},
			GyMd => q{dd-MM-y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{LL},
			MEd => q{E, dd.MM},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMEd => q{E, d MMMM},
			MMMMW => q{W-'й' 'тиж'. MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM.y},
			yMEd => q{E, dd.MM.y},
			yMMM => q{LLL y 'р'.},
			yMMMEd => q{E, d MMM y 'р'.},
			yMMMM => q{LLLL y 'р'.},
			yMMMd => q{d MMM y 'р'.},
			yMd => q{dd.MM.y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y 'р'.},
			yw => q{w-'й' 'тиж'. Y 'р'.},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				B => q{h B – h B},
				h => q{h–h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm–h:mm B},
				m => q{h:mm–h:mm B},
			},
			Gy => {
				G => q{y 'р'. G – y 'р'. G},
				y => q{y–y 'рр'. G},
			},
			GyM => {
				G => q{MM.y G – MM.y G},
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			GyMEd => {
				G => q{ccc, dd.MM.y G – ccc, dd.MM.y G},
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			GyMMM => {
				G => q{LLL y 'р'. G – LLL y 'р'. G},
				M => q{LLL – LLL y 'р'. G},
				y => q{LLL y – LLL y 'рр'. G},
			},
			GyMMMEd => {
				G => q{ccc, d MMM y 'р'. G – ccc, d MMM y 'р'. G},
				M => q{ccc, d MMM – ccc, d MMM y 'р'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'р'. G},
				y => q{ccc, d MMM y – ccc, d MMM y 'рр'. G},
			},
			GyMMMd => {
				G => q{d MMM y 'р'. G – d MMM y 'р'. G},
				M => q{d MMM – d MMM y 'р'. G},
				d => q{d–d MMM y 'р'. G},
				y => q{d MMM y – d MMM y 'рр'. G},
			},
			GyMd => {
				G => q{dd.MM.y G – dd.MM.y G},
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{E, dd.MM.y – E, dd.MM.y},
			},
			yMMM => {
				M => q{LLL–LLL y 'р'.},
				y => q{LLL y – LLL y 'рр'.},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y 'р'.},
				d => q{E, d – E, d MMM y 'р'.},
				y => q{E, d MMM y – E, d MMM y 'рр'.},
			},
			yMMMM => {
				M => q{LLLL – LLLL y 'р'.},
				y => q{LLLL y – LLLL y 'рр'.},
			},
			yMMMd => {
				M => q{d MMM – d MMM y 'р'.},
				d => q{d–d MMM y 'р'.},
				y => q{d MMM y – d MMM y 'рр'.},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
		'gregorian' => {
			Bh => {
				B => q{h B – h B},
				h => q{h–h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm–h:mm B},
				m => q{h:mm–h:mm B},
			},
			Gy => {
				G => q{y 'р'. G – y 'р'. G},
				y => q{y–y 'рр'. G},
			},
			GyM => {
				G => q{MM.y G – MM.y G},
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			GyMEd => {
				G => q{ccc, dd.MM.y G – ccc, dd.MM.y G},
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			GyMMM => {
				G => q{LLL y 'р'. G – LLL y 'р'. G},
				M => q{LLL – LLL y 'р'. G},
				y => q{LLL y – LLL y 'рр'. G},
			},
			GyMMMEd => {
				G => q{ccc, d MMM y 'р'. G – ccc, d MMM y 'р'. G},
				M => q{ccc, d MMM – ccc, d MMM y 'р'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'р'. G},
				y => q{ccc, d MMM y – ccc, d MMM y 'рр'. G},
			},
			GyMMMd => {
				G => q{d MMM y 'р'. G – d MMM y 'р'. G},
				M => q{d MMM – d MMM y 'р'. G},
				d => q{d–d MMM y 'р'. G},
				y => q{d MMM y – d MMM y 'рр'. G},
			},
			GyMd => {
				G => q{dd.MM.y G – dd.MM.y G},
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{E, dd.MM.y – E, dd.MM.y},
			},
			yMMM => {
				M => q{LLL–LLL y 'р'.},
				y => q{LLL y – LLL y 'рр'.},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y 'р'.},
				d => q{E, d – E, d MMM y 'р'.},
				y => q{E, d MMM y – E, d MMM y 'рр'.},
			},
			yMMMM => {
				M => q{LLLL – LLLL y 'р'.},
				y => q{LLLL y – LLLL y 'рр'.},
			},
			yMMMd => {
				M => q{d MMM – d MMM y 'р'.},
				d => q{d–d MMM y 'р'.},
				y => q{d MMM y – d MMM y 'рр'.},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(час: {0}),
		regionFormat => q(час: {0}, літній),
		regionFormat => q(час: {0}, стандартний),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q#час: Акрі, літній#,
				'generic' => q#час: Акрі#,
				'standard' => q#час: Акрі, стандартний#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#за часом в Афганістані#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абіджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банґі#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бісау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавіль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каїр#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакрі#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Джібуті#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ель-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фрітаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Ґабороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоганнесбурґ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Джуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кігалі#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Кіншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лаґос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Лібревіль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаші#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Моґадішо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровія#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найробі#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нджамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ніамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшотт#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уаґадуґу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Тріполі#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Туніс#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Віндгук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#за центральноафриканським часом#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#за східноафриканським часом#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#за південноафриканським часом#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#за західноафриканським літнім часом#,
				'generic' => q#за західноафриканським часом#,
				'standard' => q#за західноафриканським стандартним часом#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#за літнім часом на Алясці#,
				'generic' => q#за часом на Алясці#,
				'standard' => q#за стандартним часом на Алясці#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#за літнім часом на Амазонці#,
				'generic' => q#за часом на Амазонці#,
				'standard' => q#за стандартним часом на Амазонці#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкоридж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Анґілья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антиґуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Араґуаіна#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Ріоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Ріо-Ґальєґос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Сальта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Луїс#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуая#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьйон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Байя#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баїя Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белен#,
		},
		'America/Belize' => {
			exemplarCity => q#Беліз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Блан-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Віста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Боґота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кеймбрідж-Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампу-Ґранді#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Каєнна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайманові Острови#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чікаґо#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чіуауа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атікокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Ріка#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Денмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон-Крік#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Домініка#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Ейрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Сальвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нельсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Ґлейс-Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Ґус-Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Ґранд-Терк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Ґренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Ґваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Ґватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Ґуаякіль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Ґайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галіфакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Ермосільйо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Індіана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Індіана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Пітерсберг, Індіана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл-Сіті, Індіана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вівей, Індіана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Вінсенс, Індіана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Вінамак, Індіана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Індіанаполіс#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Інувік#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Ікалуїт#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Джуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтіселло, Кентуккі#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Ліма#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анджелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луїсвілл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуер-Принсес-Квотер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манаґуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Маріґо#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартініка#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меноміні#,
		},
		'America/Merida' => {
			exemplarCity => q#Меріда#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехіко#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Мікелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевідео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Ніпігон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норонья#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бʼюла, Північна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Сентр, Північна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Північна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охінаґа#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Панґніртанґ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Фінікс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуерто-Ріко#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта-Аренас#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейні-Рівер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ренкін-Інлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресіфі#,
		},
		'America/Regina' => {
			exemplarCity => q#Реджайна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резольют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Ріо-Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта-Ісабель#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарен#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяґо#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто-Домінґо#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Іттоккортоорміут#,
		},
		'America/Sitka' => {
			exemplarCity => q#Сітка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен-Бартелемі#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Кіттс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Люсія#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Вінсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свіфт-Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Теґусіґальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер-Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тіхуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вайтгорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Вінніпеґ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Єллоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#за північноамериканським центральним літнім часом#,
				'generic' => q#за північноамериканським центральним часом#,
				'standard' => q#за північноамериканським центральним стандартним часом#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#за північноамериканським східним літнім часом#,
				'generic' => q#за північноамериканським східним часом#,
				'standard' => q#за північноамериканським східним стандартним часом#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#за північноамериканським гірським літнім часом#,
				'generic' => q#за північноамериканським гірським часом#,
				'standard' => q#за північноамериканським гірським стандартним часом#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#за північноамериканським тихоокеанським літнім часом#,
				'generic' => q#за північноамериканським тихоокеанським часом#,
				'standard' => q#за північноамериканським тихоокеанським стандартним часом#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#час: Анадир, літній#,
				'generic' => q#час: Анадир#,
				'standard' => q#час: Анадир, стандартний#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейсі#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Девіс#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон-дʼЮрвіль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуорі#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сьова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#за літнім часом в Апіа#,
				'generic' => q#за часом в Апіа#,
				'standard' => q#за стандартним часом в Апіа#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#за арабським літнім часом#,
				'generic' => q#за арабським часом#,
				'standard' => q#за арабським стандартним часом#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгʼїр#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#за літнім аргентинським часом#,
				'generic' => q#за аргентинським часом#,
				'standard' => q#за стандартним аргентинським часом#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#за літнім за західноаргентинським часом#,
				'generic' => q#за західноаргентинським часом#,
				'standard' => q#за стандартним західноаргентинським часом#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#за вірменським літнім часом#,
				'generic' => q#за вірменським часом#,
				'standard' => q#за вірменським стандартним часом#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашгабат#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атирау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бішкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Колката#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Ділі#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеврон#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Іркутськ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Джакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Джайпур#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Єрусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачі#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярськ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала-Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Маніла#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Нікосія#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецьк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибірськ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омськ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтіанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Костанай#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Янгон#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ер-Ріяд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимін#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалін#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сінгапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Середньоколимськ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайбей#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбілісі#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхімпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токіо#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томськ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчі#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вʼєнтьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутськ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Єкатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Єреван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#за атлантичним літнім часом#,
				'generic' => q#за атлантичним часом#,
				'standard' => q#за атлантичним стандартним часом#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азорські Острови#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуди#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарські Острови#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарерські Острови#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкʼявік#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Південна Джорджія#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Острів Святої Єлени#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенлі#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаїда#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брісбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хілл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Каррі#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвін#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Евкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Гобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Ліндеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сідней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#за літнім центральноавстралійським часом#,
				'generic' => q#за центральноавстралійським часом#,
				'standard' => q#за стандартним центральноавстралійським часом#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#за літнім центральнозахідним австралійським часом#,
				'generic' => q#за центральнозахідним австралійським часом#,
				'standard' => q#за стандартним центральнозахідним австралійським часом#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#за літнім східноавстралійським часом#,
				'generic' => q#за східноавстралійським часом#,
				'standard' => q#за стандартним східноавстралійським часом#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#за літнім західноавстралійським часом#,
				'generic' => q#за західноавстралійським часом#,
				'standard' => q#за стандартним західноавстралійським часом#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#за літнім часом в Азербайджані#,
				'generic' => q#за часом в Азербайджані#,
				'standard' => q#за стандартним часом в Азербайджані#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#за літнім часом на Азорських Островах#,
				'generic' => q#за часом на Азорських Островах#,
				'standard' => q#за стандартним часом на Азорських Островах#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#за літнім часом у Бангладеш#,
				'generic' => q#за часом у Бангладеш#,
				'standard' => q#за стандартним часом у Бангладеш#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#за часом у Бутані#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#за болівійським часом#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#за літнім бразильським часом#,
				'generic' => q#за бразильським часом#,
				'standard' => q#за стандартним бразильським часом#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#за часом у Брунеї#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#за літнім часом на островах Кабо-Верде#,
				'generic' => q#за часом на островах Кабо-Верде#,
				'standard' => q#за стандартним часом на островах Кабо-Верде#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#за часом на Північних Маріанських островах#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#за літнім часом на архіпелазі Чатем#,
				'generic' => q#за часом на архіпелазі Чатем#,
				'standard' => q#за стандартним часом на архіпелазі Чатем#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#за літнім чилійським часом#,
				'generic' => q#за чилійським часом#,
				'standard' => q#за стандартним чилійським часом#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#за китайським літнім часом#,
				'generic' => q#за китайським часом#,
				'standard' => q#за китайським стандартним часом#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#за літнім часом у Чойбалсані#,
				'generic' => q#за часом у Чойбалсані#,
				'standard' => q#за стандартним часом у Чойбалсані#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#за часом на острові Різдва#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#за часом на Кокосових Островах#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#за літнім колумбійським часом#,
				'generic' => q#за колумбійським часом#,
				'standard' => q#за стандартним колумбійським часом#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#за літнім часом на Островах Кука#,
				'generic' => q#за часом на Островах Кука#,
				'standard' => q#за стандартним часом на Островах Кука#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#за літнім часом на Кубі#,
				'generic' => q#за часом на Кубі#,
				'standard' => q#за стандартним часом на Кубі#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#за часом у Девіс#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#за часом у Дюмон дʼЮрвіль#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#за часом у Східному Тиморі#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#за літнім часом на острові Пасхи#,
				'generic' => q#за часом на острові Пасхи#,
				'standard' => q#за стандартним часом на острові Пасхи#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#за часом в Еквадорі#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#за всесвітнім координованим часом#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Невідоме місто#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахань#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афіни#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлін#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бюзінген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинів#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублін#,
			long => {
				'daylight' => q#за літнім часом в Ірландії#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гібралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернсі#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Гельсінкі#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Острів Мен#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джерсі#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калінінград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Київ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Кіров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лісабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#за літнім часом у Великій Британії#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марієгамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Мінськ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгориця#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараєво#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Сімферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопʼє#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софія#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллінн#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ульяновськ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Відень#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вільнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запоріжжя#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюріх#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#за центральноєвропейським літнім часом#,
				'generic' => q#за центральноєвропейським часом#,
				'standard' => q#за центральноєвропейським стандартним часом#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#за східноєвропейським літнім часом#,
				'generic' => q#за східноєвропейським часом#,
				'standard' => q#за східноєвропейським стандартним часом#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#за далекосхідним європейським часом#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#за західноєвропейським літнім часом#,
				'generic' => q#за західноєвропейським часом#,
				'standard' => q#за західноєвропейським стандартним часом#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#за літнім часом на Фолклендських Островах#,
				'generic' => q#за часом на Фолклендських Островах#,
				'standard' => q#за стандартним часом на Фолклендських Островах#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#за літнім часом на Фіджі#,
				'generic' => q#за часом на Фіджі#,
				'standard' => q#за стандартним часом на Фіджі#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#за часом Французької Ґвіани#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#за часом на Французьких Південних і Антарктичних територіях#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#за Гринвічем#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#за часом Ґалапаґосу#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#за часом на острові Ґамбʼє#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#за літнім часом у Грузії#,
				'generic' => q#за часом у Грузії#,
				'standard' => q#за стандартним часом у Грузії#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#за часом на островах Гілберта#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#за літнім східним часом у Ґренландії#,
				'generic' => q#за східним часом у Ґренландії#,
				'standard' => q#за стандартним східним часом у Ґренландії#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#за літнім західним часом у Ґренландії#,
				'generic' => q#за західним часом у Ґренландії#,
				'standard' => q#за стандартним західним часом у Ґренландії#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#за часом на острові Гуам#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#за часом Перської затоки#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#за часом у Ґаяні#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#за літнім гавайсько-алеутським часом#,
				'generic' => q#за гавайсько-алеутським часом#,
				'standard' => q#за стандартним гавайсько-алеутським часом#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#за літнім часом у Гонконзі#,
				'generic' => q#за часом у Гонконзі#,
				'standard' => q#за стандартним часом у Гонконзі#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#за літнім часом у Ховді#,
				'generic' => q#за часом у Ховді#,
				'standard' => q#за стандартним часом у Ховді#,
			},
		},
		'India' => {
			long => {
				'standard' => q#за індійським стандартним часом#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананаріву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чаґос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Острів Різдва#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокосові Острови#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Комори#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Керґелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдіви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврікій#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюньйон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#за часом в Індійському Океані#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#за часом в Індокитаї#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#за центральноіндонезійським часом#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#за східноіндонезійським часом#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#за західноіндонезійським часом#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#за іранським літнім часом#,
				'generic' => q#за іранським часом#,
				'standard' => q#за іранським стандартним часом#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#за іркутським літнім часом#,
				'generic' => q#за іркутським часом#,
				'standard' => q#за іркутським стандартним часом#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#за ізраїльським літнім часом#,
				'generic' => q#за ізраїльським часом#,
				'standard' => q#за ізраїльським стандартним часом#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#за японським літнім часом#,
				'generic' => q#за японським часом#,
				'standard' => q#за японським стандартним часом#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#за камчатським літнім часом#,
				'generic' => q#за камчатським часом#,
				'standard' => q#за камчатським стандартним часом#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#за східним часом у Казахстані#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#за західним часом у Казахстані#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#за корейським літнім часом#,
				'generic' => q#за корейським часом#,
				'standard' => q#за корейським стандартним часом#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#за часом на острові Косрае#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#за красноярським літнім часом#,
				'generic' => q#за красноярським часом#,
				'standard' => q#за красноярським стандартним часом#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#за часом у Киргизстані#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#час: Ланка#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#за часом на острові Лайн#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#за літнім часом на острові Лорд-Хау#,
				'generic' => q#за часом на острові Лорд-Хау#,
				'standard' => q#за стандартним часом на острові Лорд-Хау#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#за часом на острові Маккуорі#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#за магаданським літнім часом#,
				'generic' => q#за магаданським часом#,
				'standard' => q#за магаданським стандартним часом#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#за часом у Малайзії#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#за часом на Мальдівах#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#за часом на Маркізьких островах#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#за часом на Маршаллових Островах#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#за літнім часом на острові Маврікій#,
				'generic' => q#за часом на острові Маврікій#,
				'standard' => q#за стандартним часом на острові Маврікій#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#за часом на станції Моусон#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#за літнім північнозахідним часом у Мексиці#,
				'generic' => q#за північнозахідним часом у Мексиці#,
				'standard' => q#за стандартним північнозахідним часом у Мексиці#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#за літнім тихоокеанським часом у Мексиці#,
				'generic' => q#за тихоокеанським часом у Мексиці#,
				'standard' => q#за стандартним тихоокеанським часом у Мексиці#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#за літнім часом в Улан-Баторі#,
				'generic' => q#за часом в Улан-Баторі#,
				'standard' => q#за стандартним часом в Улан-Баторі#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#за московським літнім часом#,
				'generic' => q#за московським часом#,
				'standard' => q#за московським стандартним часом#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#за часом у Мʼянмі#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#за часом на острові Науру#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#за часом у Непалі#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#за літнім часом на островах Нової Каледонії#,
				'generic' => q#за часом на островах Нової Каледонії#,
				'standard' => q#за стандартним часом на островах Нової Каледонії#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#за літнім часом у Новій Зеландії#,
				'generic' => q#за часом у Новій Зеландії#,
				'standard' => q#за стандартним часом у Новій Зеландії#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#за літнім часом у Ньюфаундленд#,
				'generic' => q#за часом на острові Ньюфаундленд#,
				'standard' => q#за стандартним часом на острові Ньюфаундленд#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#за часом на острові Ніуе#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#за літнім часом на острові Норфолк#,
				'generic' => q#за часом на острові Норфолк#,
				'standard' => q#за стандартним часом на острові Норфолк#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#за літнім часом на архіпелазі Фернанду-ді-Норонья#,
				'generic' => q#за часом на архіпелазі Фернанду-ді-Норонья#,
				'standard' => q#за стандартним часом на архіпелазі Фернанду-ді-Норонья#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#за новосибірським літнім часом#,
				'generic' => q#за новосибірським часом#,
				'standard' => q#за новосибірським стандартним часом#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#за омським літнім часом#,
				'generic' => q#за омським часом#,
				'standard' => q#за омським стандартним часом#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апіа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Буґенвіль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Острів Пасхи#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербері#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фіджі#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафуті#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Ґалапаґос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбʼє#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Гонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Джонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Кірітіматі#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваджалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маджуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркізькі острови#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мідвей#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ніуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго-Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Піткерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсбі#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таїті#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чуук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вейк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уолліс#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#за літнім часом у Пакистані#,
				'generic' => q#за часом у Пакистані#,
				'standard' => q#за стандартним часом у Пакистані#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#за часом на острові Палау#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#за часом на островах Папуа-Нова Ґвінея#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#за літнім параґвайським часом#,
				'generic' => q#за параґвайським часом#,
				'standard' => q#за стандартним параґвайським часом#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#за літнім часом у Перу#,
				'generic' => q#за часом у Перу#,
				'standard' => q#за стандартним часом у Перу#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#за літнім часом на Філіппінах#,
				'generic' => q#за часом на Філіппінах#,
				'standard' => q#за стандартним часом на Філіппінах#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#за часом на островах Фенікс#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#за літнім часом на островах Сен-П’єр і Мікелон#,
				'generic' => q#за часом на островах Сен-П’єр і Мікелон#,
				'standard' => q#за стандартним часом на островах Сен-П’єр і Мікелон#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#за часом на островах Піткерн#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#за часом на острові Понапе#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#за часом у Пхеньяні#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#час: Кизилорда, літній#,
				'generic' => q#час: Кизилорда#,
				'standard' => q#час: Кизилорда, стандартний#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#за часом на острові Реюньйон#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#за часом на станції Ротера#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#за сахалінським літнім часом#,
				'generic' => q#за сахалінським часом#,
				'standard' => q#за сахалінським стандартним часом#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#за самарським літнім часом#,
				'generic' => q#за самарським часом#,
				'standard' => q#за самарським стандартним часом#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#за літнім часом на острові Самоа#,
				'generic' => q#за часом на острові Самоа#,
				'standard' => q#за стандартним часом на острові Самоа#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#за часом на Сейшельських Островах#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#за часом у Сінгапурі#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#за часом на Соломонових Островах#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#за часом на острові Південна Джорджія#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#за часом у Суринамі#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#за часом на станції Сева#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#за часом на острові Таїті#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#за літнім часом у Тайбеї#,
				'generic' => q#за часом у Тайбеї#,
				'standard' => q#за стандартним часом у Тайбеї#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#за часом у Таджикистані#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#за часом на островах Токелау#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#за літнім часом на островах Тонга#,
				'generic' => q#за часом на островах Тонга#,
				'standard' => q#за стандартним часом на островах Тонга#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#за часом на островах Чуук#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#за літнім часом у Туркменістані#,
				'generic' => q#за часом у Туркменістані#,
				'standard' => q#за стандартним часом у Туркменістані#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#за часом на островах Тувалу#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#за літнім часом в Уруґваї#,
				'generic' => q#за часом в Уруґваї#,
				'standard' => q#за стандартним часом в Уруґваї#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#за літнім часом в Узбекистані#,
				'generic' => q#за часом в Узбекистані#,
				'standard' => q#за стандартним часом в Узбекистані#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#за літнім часом на островах Вануату#,
				'generic' => q#за часом на островах Вануату#,
				'standard' => q#за стандартним часом на островах Вануату#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#за часом у Венесуелі#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#за владивостоцьким літнім часом#,
				'generic' => q#за владивостоцьким часом#,
				'standard' => q#за владивостоцьким стандартним часом#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#за волгоградським літнім часом#,
				'generic' => q#за волгоградським часом#,
				'standard' => q#за волгоградським стандартним часом#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#за часом на станції Восток#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#за часом на острові Вейк#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#за часом на островах Уолліс і Футуна#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#за якутським літнім часом#,
				'generic' => q#за якутським часом#,
				'standard' => q#за якутським стандартним часом#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#за єкатеринбурзьким літнім часом#,
				'generic' => q#за єкатеринбурзьким часом#,
				'standard' => q#за єкатеринбурзьким стандартним часом#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#за стандартним часом на Юконі#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
