=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ka - Package for language Georgian

=cut

package Locale::CLDR::Locales::Ka;
# This file auto generated from Data\common\main\ka.xml
#	on Wed  3 Jan 11:17:34 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'hundred' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ი),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(­=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(­=%spellout-cardinal=),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(მინუს →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ნული),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← მძიმე →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(ერთი),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(ორი),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(სამი),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(ოთხი),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ხუთი),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ექვსი),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(შვიდი),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(რვა),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ცხრა),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ათი),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(თერთმეტი),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(თორმეტი),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(ცამეტი),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(თოთხმეტი),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(თხუთმეტი),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(თექვსმეტი),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(ჩვიდმეტი),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(თრვამეტი),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(ცხრამეტი),
				},
				'20' => {
					base_value => q(20),
					divisor => q(20),
					rule => q(ოცი),
				},
				'21' => {
					base_value => q(21),
					divisor => q(20),
					rule => q(ოცდა­→→),
				},
				'40' => {
					base_value => q(40),
					divisor => q(20),
					rule => q(ორმოცი),
				},
				'41' => {
					base_value => q(41),
					divisor => q(20),
					rule => q(ორმოცდა­→→),
				},
				'60' => {
					base_value => q(60),
					divisor => q(20),
					rule => q(სამოცი),
				},
				'61' => {
					base_value => q(61),
					divisor => q(20),
					rule => q(სამოცდა­→→),
				},
				'80' => {
					base_value => q(80),
					divisor => q(20),
					rule => q(ოთხმოცი),
				},
				'81' => {
					base_value => q(81),
					divisor => q(20),
					rule => q(ოთხმოცდა­→→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(ას→%%hundred→),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(ორას→%%hundred→),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(სამას→%%hundred→),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(ოთხას→%%hundred→),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(ხუთას→%%hundred→),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(ექვსას→%%hundred→),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(შვიდას→%%hundred→),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(რვაას→%%hundred→),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(ცხრაას→%%hundred→),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(ათას→%%th→),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←← ათას→%%th→),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←← მილიონ→%%th→),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←← მილიარდ→%%th→),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←← ბილიონ→%%th→),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← ბილიარდ→%%th→),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
		'th' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ი),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-cardinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-cardinal=),
				},
			},
		},
    } },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'აფარი',
 				'ab' => 'აფხაზური',
 				'ace' => 'აჩეხური',
 				'ach' => 'აჩოლი',
 				'ada' => 'ადანგმე',
 				'ady' => 'ადიღეური',
 				'ae' => 'ავესტური',
 				'af' => 'აფრიკაანსი',
 				'agq' => 'აღემი',
 				'ain' => 'აინუური',
 				'ak' => 'აკანი',
 				'akk' => 'აქადური',
 				'ale' => 'ალეუტური',
 				'alt' => 'სამხრეთ ალთაური',
 				'am' => 'ამჰარული',
 				'an' => 'არაგონული',
 				'ang' => 'ძველი ინგლისური',
 				'anp' => 'ანგიკა',
 				'ar' => 'არაბული',
 				'ar_001' => 'თანამედროვე სტანდარტული არაბული',
 				'arc' => 'არამეული',
 				'arn' => 'მაპუდუნგუნი',
 				'arp' => 'არაპაჰო',
 				'arw' => 'არავაკი',
 				'as' => 'ასამური',
 				'asa' => 'ასუ',
 				'ast' => 'ასტურიული',
 				'av' => 'ხუნძური',
 				'awa' => 'ავადი',
 				'ay' => 'აიმარა',
 				'az' => 'აზერბაიჯანული',
 				'ba' => 'ბაშკირული',
 				'bal' => 'ბელუჯი',
 				'ban' => 'ბალინური',
 				'bas' => 'ბასა',
 				'bax' => 'ბამუნი',
 				'be' => 'ბელარუსული',
 				'bej' => 'ბეჯა',
 				'bem' => 'ბემბა',
 				'bez' => 'ბენა',
 				'bg' => 'ბულგარული',
 				'bgn' => 'დასავლეთ ბელუჯი',
 				'bho' => 'ბოჯპური',
 				'bi' => 'ბისლამა',
 				'bin' => 'ბინი',
 				'bla' => 'სიკსიკა',
 				'bm' => 'ბამბარა',
 				'bn' => 'ბენგალური',
 				'bo' => 'ტიბეტური',
 				'br' => 'ბრეტონული',
 				'bra' => 'ბრაჯი',
 				'brx' => 'ბოდო',
 				'bs' => 'ბოსნიური',
 				'bua' => 'ბურიატული',
 				'bug' => 'ბუგინური',
 				'byn' => 'ბილინი',
 				'ca' => 'კატალანური',
 				'cay' => 'კაიუგა',
 				'ccp' => 'ჩაკმა',
 				'ce' => 'ჩეჩნური',
 				'ceb' => 'სებუანო',
 				'cgg' => 'ჩიგა',
 				'ch' => 'ჩამორო',
 				'chb' => 'ჩიბჩა',
 				'chk' => 'ჩუკოტკური',
 				'chm' => 'მარიული',
 				'chn' => 'ჩინუკის ჟარგონი',
 				'cho' => 'ჩოკტო',
 				'chp' => 'ჩიპევიანი',
 				'chr' => 'ჩეროკი',
 				'chy' => 'ჩეიენი',
 				'ckb' => 'ცენტრალური ქურთული',
 				'co' => 'კორსიკული',
 				'cop' => 'კოპტური',
 				'cr' => 'კრი',
 				'crh' => 'ყირიმულ-თურქული',
 				'crs' => 'სესელვა-კრეოლური ფრანგული',
 				'cs' => 'ჩეხური',
 				'csb' => 'კაშუბური',
 				'cu' => 'საეკლესიო სლავური',
 				'cv' => 'ჩუვაშური',
 				'cy' => 'უელსური',
 				'da' => 'დანიური',
 				'dak' => 'დაკოტური',
 				'dar' => 'დარგუული',
 				'dav' => 'ტაიტა',
 				'de' => 'გერმანული',
 				'de_AT' => 'ავსტრიული გერმანული',
 				'de_CH' => 'შვეიცარიული ზემოგერმანული',
 				'del' => 'დელავერული',
 				'den' => 'სლეივი',
 				'dgr' => 'დოგრიბი',
 				'din' => 'დინკა',
 				'dje' => 'ზარმა',
 				'doi' => 'დოგრი',
 				'dsb' => 'ქვემოსორბული',
 				'dua' => 'დუალა',
 				'dum' => 'საშუალო ჰოლანდიური',
 				'dv' => 'დივეჰი',
 				'dyo' => 'დიოლა',
 				'dyu' => 'დიულა',
 				'dz' => 'ძონგკხა',
 				'dzg' => 'დაზაგა',
 				'ebu' => 'ემბუ',
 				'ee' => 'ევე',
 				'efi' => 'ეფიკი',
 				'egy' => 'ძველეგვიპტური',
 				'eka' => 'ეკაჯუკი',
 				'el' => 'ბერძნული',
 				'en' => 'ინგლისური',
 				'en_AU' => 'ავსტრალიური ინგლისური',
 				'en_CA' => 'კანადური ინგლისური',
 				'en_GB' => 'ბრიტანული ინგლისური',
 				'en_GB@alt=short' => 'ინგლისური (გაერთ. სამეფო)',
 				'en_US' => 'ამერიკული ინგლისური',
 				'en_US@alt=short' => 'აშშ ინგლისური',
 				'enm' => 'საშუალო ინგლისური',
 				'eo' => 'ესპერანტო',
 				'es' => 'ესპანური',
 				'es_419' => 'ლათინურ ამერიკული ესპანური',
 				'es_ES' => 'ევროპული ესპანური',
 				'es_MX' => 'მექსიკური ესპანური',
 				'et' => 'ესტონური',
 				'eu' => 'ბასკური',
 				'ewo' => 'ევონდო',
 				'fa' => 'სპარსული',
 				'fa_AF' => 'დარი',
 				'ff' => 'ფულა',
 				'fi' => 'ფინური',
 				'fil' => 'ფილიპინური',
 				'fj' => 'ფიჯი',
 				'fo' => 'ფარერული',
 				'fon' => 'ფონი',
 				'fr' => 'ფრანგული',
 				'fr_CA' => 'კანადური ფრანგული',
 				'fr_CH' => 'შვეიცარიული ფრანგული',
 				'frm' => 'საშუალო ფრანგული',
 				'fro' => 'ძველი ფრანგული',
 				'frr' => 'ჩრდილოფრიზიული',
 				'frs' => 'აღმოსავლეთფრიზიული',
 				'fur' => 'ფრიულური',
 				'fy' => 'დასავლეთფრიზიული',
 				'ga' => 'ირლანდიური',
 				'gaa' => 'გა',
 				'gag' => 'გაგაუზური',
 				'gba' => 'გბაია',
 				'gd' => 'შოტლანდიური გელური',
 				'gez' => 'გეეზი',
 				'gil' => 'გილბერტული',
 				'gl' => 'გალისიური',
 				'gmh' => 'საშუალო ზემოგერმანული',
 				'gn' => 'გუარანი',
 				'goh' => 'ძველი ზემოგერმანული',
 				'gon' => 'გონდი',
 				'gor' => 'გორონტალო',
 				'got' => 'გოთური',
 				'grc' => 'ძველი ბერძნული',
 				'gsw' => 'შვეიცარიული გერმანული',
 				'gu' => 'გუჯარათი',
 				'guz' => 'გუსიი',
 				'gv' => 'მენური',
 				'gwi' => 'გვიჩინი',
 				'ha' => 'ჰაუსა',
 				'haw' => 'ჰავაიური',
 				'he' => 'ებრაული',
 				'hi' => 'ჰინდი',
 				'hil' => 'ჰილიგაინონი',
 				'hit' => 'ხეთური',
 				'hmn' => 'ჰმონგი',
 				'hr' => 'ხორვატული',
 				'hsb' => 'ზემოსორბული',
 				'ht' => 'ჰაიტიური კრეოლი',
 				'hu' => 'უნგრული',
 				'hup' => 'ჰუპა',
 				'hy' => 'სომხური',
 				'hz' => 'ჰერერო',
 				'ia' => 'ინტერლინგუალური',
 				'iba' => 'იბანი',
 				'ibb' => 'იბიბიო',
 				'id' => 'ინდონეზიური',
 				'ie' => 'ინტერლინგი',
 				'ig' => 'იგბო',
 				'ii' => 'სიჩუანის ი',
 				'ilo' => 'ილოკო',
 				'inh' => 'ინგუშური',
 				'io' => 'იდო',
 				'is' => 'ისლანდიური',
 				'it' => 'იტალიური',
 				'iu' => 'ინუკტიტუტი',
 				'ja' => 'იაპონური',
 				'jbo' => 'ლოჟბანი',
 				'jgo' => 'ნგომბა',
 				'jmc' => 'კიმაშამი',
 				'jpr' => 'იუდეო-სპარსული',
 				'jrb' => 'იუდეო-არაბული',
 				'jv' => 'იავური',
 				'ka' => 'ქართული',
 				'kaa' => 'ყარაყალფახური',
 				'kab' => 'კაბილური',
 				'kac' => 'კაჩინი',
 				'kaj' => 'კაჯი',
 				'kam' => 'კამბა',
 				'kbd' => 'ყაბარდოული',
 				'kcg' => 'ტიაპი',
 				'kde' => 'მაკონდე',
 				'kea' => 'კაბუვერდიანუ',
 				'kfo' => 'კორო',
 				'kg' => 'კონგო',
 				'kha' => 'ხასი',
 				'khq' => 'კოირა-ჩიინი',
 				'ki' => 'კიკუიუ',
 				'kj' => 'კუნამა',
 				'kk' => 'ყაზახური',
 				'kkj' => 'კაკო',
 				'kl' => 'დასავლეთ გრენლანდიური',
 				'kln' => 'კალენჯინი',
 				'km' => 'ქმერული',
 				'kmb' => 'კიმბუნდუ',
 				'kn' => 'კანადა',
 				'ko' => 'კორეული',
 				'koi' => 'კომი-პერმიაკული',
 				'kok' => 'კონკანი',
 				'kos' => 'კუსაიე',
 				'kpe' => 'კპელე',
 				'kr' => 'კანური',
 				'krc' => 'ყარაჩაულ-ბალყარული',
 				'krl' => 'კარელიური',
 				'kru' => 'კურუქი',
 				'ks' => 'ქაშმირული',
 				'ksb' => 'შამბალა',
 				'ksf' => 'ბაფია',
 				'ksh' => 'კიოლში',
 				'ku' => 'ქურთული',
 				'kum' => 'ყუმუხური',
 				'kut' => 'კუტენაი',
 				'kv' => 'კომი',
 				'kw' => 'კორნული',
 				'ky' => 'ყირგიზული',
 				'la' => 'ლათინური',
 				'lad' => 'ლადინო',
 				'lag' => 'ლანგი',
 				'lah' => 'ლანდა',
 				'lam' => 'ლამბა',
 				'lb' => 'ლუქსემბურგული',
 				'lez' => 'ლეზგიური',
 				'lg' => 'განდა',
 				'li' => 'ლიმბურგული',
 				'lkt' => 'ლაკოტა',
 				'ln' => 'ლინგალა',
 				'lo' => 'ლაოსური',
 				'lol' => 'მონგო',
 				'loz' => 'ლოზი',
 				'lrc' => 'ჩრდილოეთ ლური',
 				'lt' => 'ლიეტუვური',
 				'lu' => 'ლუბა-კატანგა',
 				'lua' => 'ლუბა-ლულუა',
 				'lui' => 'ლუისენიო',
 				'lun' => 'ლუნდა',
 				'luo' => 'ლუო',
 				'lus' => 'მიზო',
 				'luy' => 'ლუჰია',
 				'lv' => 'ლატვიური',
 				'mad' => 'მადურული',
 				'maf' => 'მაფა',
 				'mag' => 'მაგაჰი',
 				'mai' => 'მაითილი',
 				'mak' => 'მაკასარი',
 				'mas' => 'მასაი',
 				'mde' => 'მაბა',
 				'mdf' => 'მოქშა',
 				'men' => 'მენდე',
 				'mer' => 'მერუ',
 				'mfe' => 'მორისიენი',
 				'mg' => 'მალაგასიური',
 				'mga' => 'საშუალო ირლანდიური',
 				'mgh' => 'მაქუვა-მეეტო',
 				'mgo' => 'მეტა-ენა',
 				'mh' => 'მარშალური',
 				'mi' => 'მაორი',
 				'mic' => 'მიკმაკი',
 				'min' => 'მინანგკაბაუ',
 				'mk' => 'მაკედონური',
 				'ml' => 'მალაიალამური',
 				'mn' => 'მონღოლური',
 				'mnc' => 'მანჯურიული',
 				'mni' => 'მანიპური',
 				'moh' => 'მოჰაუკური',
 				'mos' => 'მოსი',
 				'mr' => 'მარათჰი',
 				'ms' => 'მალაიური',
 				'mt' => 'მალტური',
 				'mua' => 'მუნდანგი',
 				'mul' => 'სხვადასხვა ენა',
 				'mus' => 'კრიკი',
 				'mwl' => 'მირანდული',
 				'mwr' => 'მარვარი',
 				'my' => 'ბირმული',
 				'mye' => 'მიენე',
 				'myv' => 'ერზია',
 				'mzn' => 'მაზანდერანული',
 				'na' => 'ნაურუ',
 				'nap' => 'ნეაპოლიტანური',
 				'naq' => 'ნამა',
 				'nb' => 'ნორვეგიული ბუკმოლი',
 				'nd' => 'ჩრდილოეთ ნდებელე',
 				'nds' => 'ქვემოგერმანული',
 				'nds_NL' => 'ქვემოსაქსონური',
 				'ne' => 'ნეპალური',
 				'new' => 'ნევარი',
 				'ng' => 'ნდონგა',
 				'nia' => 'ნიასი',
 				'niu' => 'ნიუე',
 				'nl' => 'ნიდერლანდური',
 				'nl_BE' => 'ფლამანდიური',
 				'nmg' => 'კვასიო',
 				'nn' => 'ნორვეგიული ნიუნორსკი',
 				'nnh' => 'ნგიმბუნი',
 				'no' => 'ნორვეგიული',
 				'nog' => 'ნოღაური',
 				'non' => 'ძველსკანდინავიური',
 				'nqo' => 'ნკო',
 				'nr' => 'სამხრეთ ნდებელური',
 				'nso' => 'ჩრდილოეთ სოთო',
 				'nus' => 'ნუერი',
 				'nv' => 'ნავახო',
 				'nwc' => 'კლასიკური ნევარული',
 				'ny' => 'ნიანჯა',
 				'nym' => 'ნიამვეზი',
 				'nyn' => 'ნიანკოლე',
 				'nyo' => 'ნიორო',
 				'nzi' => 'ნზიმა',
 				'oc' => 'ოქსიტანური',
 				'oj' => 'ოჯიბვე',
 				'om' => 'ორომო',
 				'or' => 'ორია',
 				'os' => 'ოსური',
 				'pa' => 'პენჯაბური',
 				'pag' => 'პანგასინანი',
 				'pal' => 'ფალაური',
 				'pam' => 'პამპანგა',
 				'pap' => 'პაპიამენტო',
 				'pau' => 'ფალაუანი',
 				'pcm' => 'ნიგერიული კრეოლური',
 				'peo' => 'ძველი სპარსული',
 				'phn' => 'ფინიკიური',
 				'pi' => 'პალი',
 				'pl' => 'პოლონური',
 				'prg' => 'პრუსიული',
 				'pro' => 'ძველი პროვანსული',
 				'ps' => 'პუშტუ',
 				'pt' => 'პორტუგალიური',
 				'pt_BR' => 'ბრაზილიური პორტუგალიური',
 				'pt_PT' => 'ევროპული პორტუგალიური',
 				'qu' => 'კეჩუა',
 				'quc' => 'კიჩე',
 				'raj' => 'რაჯასთანი',
 				'rap' => 'რაპანუი',
 				'rar' => 'რაროტონგული',
 				'rhg' => 'როჰინგა',
 				'rm' => 'რეტორომანული',
 				'rn' => 'რუნდი',
 				'ro' => 'რუმინული',
 				'ro_MD' => 'მოლდავური',
 				'rof' => 'რომბო',
 				'rom' => 'ბოშური',
 				'ru' => 'რუსული',
 				'rup' => 'არომანული',
 				'rw' => 'კინიარუანდა',
 				'rwk' => 'რუა',
 				'sa' => 'სანსკრიტი',
 				'sad' => 'სანდავე',
 				'sah' => 'იაკუტური',
 				'sam' => 'სამარიულ-არამეული',
 				'saq' => 'სამბურუ',
 				'sat' => 'სანტალი',
 				'sba' => 'ნგამბაი',
 				'sbp' => 'სანგუ',
 				'sc' => 'სარდინიული',
 				'scn' => 'სიცილიური',
 				'sco' => 'შოტლანდიური',
 				'sd' => 'სინდჰური',
 				'sdh' => 'სამხრეთქურთული',
 				'se' => 'ჩრდილოეთ საამური',
 				'see' => 'სენეკა',
 				'seh' => 'სენა',
 				'sel' => 'სელკუპური',
 				'ses' => 'კოირაბორო-სენი',
 				'sg' => 'სანგო',
 				'sga' => 'ძველი ირლანდიური',
 				'sh' => 'სერბულ-ხორვატული',
 				'shi' => 'შილჰა',
 				'shn' => 'შანი',
 				'shu' => 'ჩადური არაბული',
 				'si' => 'სინჰალური',
 				'sk' => 'სლოვაკური',
 				'sl' => 'სლოვენური',
 				'sm' => 'სამოა',
 				'sma' => 'სამხრეთსამური',
 				'smj' => 'ლულე-საამური',
 				'smn' => 'ინარი-საამური',
 				'sms' => 'სკოლტ-საამური',
 				'sn' => 'შონა',
 				'snk' => 'სონინკე',
 				'so' => 'სომალიური',
 				'sq' => 'ალბანური',
 				'sr' => 'სერბული',
 				'srn' => 'სრანან ტონგო',
 				'ss' => 'სუატი',
 				'ssy' => 'საჰო',
 				'st' => 'სამხრეთ სოთოს ენა',
 				'su' => 'სუნდური',
 				'suk' => 'სუკუმა',
 				'sux' => 'შუმერული',
 				'sv' => 'შვედური',
 				'sw' => 'სუაჰილი',
 				'sw_CD' => 'კონგოს სუაჰილი',
 				'swb' => 'კომორული',
 				'syc' => 'კლასიკური სირიული',
 				'syr' => 'სირიული',
 				'ta' => 'ტამილური',
 				'te' => 'ტელუგუ',
 				'tem' => 'ტინმე',
 				'teo' => 'ტესო',
 				'tet' => 'ტეტუმი',
 				'tg' => 'ტაჯიკური',
 				'th' => 'ტაი',
 				'ti' => 'ტიგრინია',
 				'tig' => 'თიგრე',
 				'tk' => 'თურქმენული',
 				'tlh' => 'კლინგონი',
 				'tn' => 'ტსვანა',
 				'to' => 'ტონგანური',
 				'tpi' => 'ტოკ-პისინი',
 				'tr' => 'თურქული',
 				'trv' => 'ტაროკო',
 				'ts' => 'ტსონგა',
 				'tt' => 'თათრული',
 				'tum' => 'ტუმბუკა',
 				'tvl' => 'ტუვალუ',
 				'tw' => 'თუი',
 				'twq' => 'ტასავაქი',
 				'ty' => 'ტაიტური',
 				'tyv' => 'ტუვა',
 				'tzm' => 'ცენტრალური მოროკოს ტამაზიგხტი',
 				'udm' => 'უდმურტული',
 				'ug' => 'უიღურული',
 				'uga' => 'უგარითული',
 				'uk' => 'უკრაინული',
 				'umb' => 'უმბუნდუ',
 				'und' => 'უცნობი ენა',
 				'ur' => 'ურდუ',
 				'uz' => 'უზბეკური',
 				'vai' => 'ვაი',
 				've' => 'ვენდა',
 				'vi' => 'ვიეტნამური',
 				'vo' => 'ვოლაპუკი',
 				'vun' => 'ვუნჯო',
 				'wa' => 'ვალონური',
 				'wae' => 'ვალსერი',
 				'wal' => 'ველაითა',
 				'war' => 'ვარაი',
 				'wbp' => 'ვალპირი',
 				'wo' => 'ვოლოფური',
 				'xal' => 'ყალმუხური',
 				'xh' => 'ქჰოსა',
 				'xog' => 'სოგა',
 				'yav' => 'იანგბენი',
 				'ybb' => 'იემბა',
 				'yi' => 'იდიში',
 				'yo' => 'იორუბა',
 				'yue' => 'კანტონური',
 				'yue@alt=menu' => 'ჩინური, კანტონური',
 				'zbl' => 'ბლისსიმბოლოები',
 				'zen' => 'ზენაგა',
 				'zgh' => 'სტანდარტული მაროკოული ტამაზიგხტი',
 				'zh' => 'ჩინური',
 				'zh@alt=menu' => 'ჩინური, მანდარინი',
 				'zh_Hans' => 'გამარტივებული ჩინური',
 				'zh_Hans@alt=long' => 'გამარტივებული ჩინური მანდარინი',
 				'zh_Hant' => 'ტრადიციული ჩინური',
 				'zh_Hant@alt=long' => 'ტრადიციული ჩინური მანდარინი',
 				'zu' => 'ზულუ',
 				'zun' => 'ზუნი',
 				'zxx' => 'ლინგვისტური შიგთავსი არ არის',
 				'zza' => 'ზაზაკი',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'აფაკა',
 			'Arab' => 'არაბული',
 			'Armi' => 'იმპერიული არამეული',
 			'Armn' => 'სომხური',
 			'Avst' => 'ავესტური',
 			'Bali' => 'ბალიური',
 			'Bamu' => 'ბამუმი',
 			'Bass' => 'ბასა ვაჰი',
 			'Batk' => 'ბატაკი',
 			'Beng' => 'ბენგალური',
 			'Blis' => 'ბლისსიმბოლოები',
 			'Bopo' => 'ბოპომოფო',
 			'Brah' => 'ბრაჰმი',
 			'Brai' => 'ბრაილი',
 			'Bugi' => 'ლონტარა',
 			'Buhd' => 'ბუჰიდი',
 			'Cakm' => 'ჩაკმა',
 			'Cans' => 'კანადური სილაბური',
 			'Cari' => 'კარიული',
 			'Cham' => 'ჩამი',
 			'Cher' => 'ჩეროკი',
 			'Cirt' => 'კირთი',
 			'Copt' => 'კოპტური',
 			'Cprt' => 'კვიპროსული',
 			'Cyrl' => 'კირილიცა',
 			'Cyrs' => 'ძველი სლავური კირილიცა',
 			'Deva' => 'დევანაგარი',
 			'Dsrt' => 'დეზერეტის',
 			'Dupl' => 'დუპლოის სტენოგრაფია',
 			'Egyd' => 'ეგვიპტური დემოტიკური',
 			'Egyh' => 'ეგვიპტური იერატიკული',
 			'Egyp' => 'ეგვიპტური იეროგლიფური',
 			'Ethi' => 'ეთიოპიური',
 			'Geok' => 'ხუცური',
 			'Geor' => 'ქართული',
 			'Glag' => 'გლაგოლიცა',
 			'Goth' => 'გოთური',
 			'Gran' => 'გრანთა',
 			'Grek' => 'ბერძნული',
 			'Gujr' => 'გუჯარათული',
 			'Guru' => 'გურმუხი',
 			'Hanb' => 'ჰანბი',
 			'Hang' => 'ჰანგული',
 			'Hani' => 'ჰანი',
 			'Hano' => 'ჰანუნოო',
 			'Hans' => 'გამარტივებული',
 			'Hans@alt=stand-alone' => 'გამარტივებული ჰანი',
 			'Hant' => 'ტრადიციული',
 			'Hant@alt=stand-alone' => 'ტრადიციული ჰანი',
 			'Hebr' => 'ებრაული',
 			'Hira' => 'ჰირაგანა',
 			'Hluw' => 'ანატოლიური იეროგლიფური',
 			'Hmng' => 'ფაჰაუ-მონი',
 			'Hrkt' => 'იაპონური კანა',
 			'Hung' => 'ძველი უნგრული',
 			'Inds' => 'ჰარაფული',
 			'Ital' => 'იტალიკური',
 			'Jamo' => 'ჯამო',
 			'Java' => 'იავური',
 			'Jpan' => 'იაპონური',
 			'Jurc' => 'ჯურჯენული',
 			'Kali' => 'კაიაჰ-ლი',
 			'Kana' => 'კატაკანა',
 			'Khar' => 'ქაროშთი',
 			'Khmr' => 'ქმერული',
 			'Khoj' => 'ქოჯკი',
 			'Knda' => 'კანადა',
 			'Kore' => 'კორეული',
 			'Kpel' => 'კპელე',
 			'Kthi' => 'კაითი',
 			'Lana' => 'ტაი თამ',
 			'Laoo' => 'ლაოსური',
 			'Latf' => 'გოტიკური ლათინური',
 			'Latg' => 'გელური ლათინური',
 			'Latn' => 'ლათინური',
 			'Lepc' => 'რონგ-რინგი',
 			'Limb' => 'ლიმბუ',
 			'Lina' => 'A-ხაზოვანი',
 			'Linb' => 'B-ხაზოვანი',
 			'Lisu' => 'ფრეიზერის',
 			'Loma' => 'ლომა',
 			'Lyci' => 'ლიკიური',
 			'Lydi' => 'ლიდიური',
 			'Mand' => 'მანდეური',
 			'Mani' => 'მანიქეური',
 			'Maya' => 'მაიას იეროგლიფები',
 			'Mend' => 'მენდე',
 			'Merc' => 'მეროიტული კურსივი',
 			'Mero' => 'მეროიტული',
 			'Mlym' => 'მალაიალამური',
 			'Mong' => 'მონღოლური',
 			'Moon' => 'მუნისი',
 			'Mroo' => 'მრო',
 			'Mtei' => 'მანიპური',
 			'Mymr' => 'მიანმური',
 			'Narb' => 'ძველი ჩრდილოეთ-არაბული',
 			'Nbat' => 'ნაბატეური',
 			'Nkgb' => 'ნახი-გება',
 			'Nkoo' => 'ნკო',
 			'Nshu' => 'ნუშუ',
 			'Ogam' => 'ოღამი',
 			'Olck' => 'ოლ-ჩიკი',
 			'Orkh' => 'ორხონული',
 			'Orya' => 'ორია',
 			'Osma' => 'ოსმანია',
 			'Palm' => 'პალმირული',
 			'Perm' => 'ძველი პერმული',
 			'Phag' => 'ფაგსპა',
 			'Phli' => 'მონუმენტური ფალაური',
 			'Phlp' => 'ფსალმუნური ფალაური',
 			'Phlv' => 'წიგნური ფალაური',
 			'Phnx' => 'ფინიკიური',
 			'Plrd' => 'პოლარდისი',
 			'Prti' => 'მონუმენტური პართული',
 			'Rjng' => 'რეჯანგი',
 			'Roro' => 'რონგორონგო',
 			'Runr' => 'რუნული',
 			'Samr' => 'სამარიული',
 			'Sara' => 'სარატი',
 			'Sarb' => 'ძველი სამხრეთ-არაბული',
 			'Saur' => 'საურაშტრა',
 			'Sgnw' => 'ჟესტთა',
 			'Shaw' => 'შოუსი',
 			'Shrd' => 'შარადა',
 			'Sind' => 'ქუდავადი',
 			'Sinh' => 'სინჰალური',
 			'Sora' => 'სორან-სომპენი',
 			'Sund' => 'სუნდანური',
 			'Sylo' => 'სილოტი ნაგრი',
 			'Syrc' => 'სირიული',
 			'Syre' => 'სირიული ესტრანგელო',
 			'Syrj' => 'დასავლეთი სირიული',
 			'Syrn' => 'აღმოსავლეთი სირიული',
 			'Tagb' => 'ტაგბანვა',
 			'Takr' => 'ტაკრი',
 			'Tale' => 'ტაი ლე',
 			'Talu' => 'ახალი ტაი ლიუ',
 			'Taml' => 'ტამილური',
 			'Tang' => 'ტანღუტური',
 			'Tavt' => 'ტაი-ვიეტი',
 			'Telu' => 'ტელუგუ',
 			'Teng' => 'ტენგვარი',
 			'Tfng' => 'ტიფინაღი',
 			'Tglg' => 'ბაიბაინი',
 			'Thaa' => 'თაანა',
 			'Thai' => 'ტაი',
 			'Tibt' => 'ტიბეტური',
 			'Tirh' => 'ტირჰუტა',
 			'Ugar' => 'უგარითული',
 			'Vaii' => 'ვაი',
 			'Visp' => 'ხილული მეტყველება',
 			'Wara' => 'ვარანგ-კშიტი',
 			'Wole' => 'ვოლეაი',
 			'Xpeo' => 'ძველი სპარსული',
 			'Xsux' => 'შუმერულ-აქადური ლურსმნული',
 			'Yiii' => 'ი',
 			'Zinh' => 'გადაღებული',
 			'Zmth' => 'მათემატიკური ნოტაცია',
 			'Zsye' => 'Emoji',
 			'Zsym' => 'სიმბოლოები',
 			'Zxxx' => 'უმწერლობო',
 			'Zyyy' => 'ზოგადი',
 			'Zzzz' => 'უცნობი დამწერლობა',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'მსოფლიო',
 			'002' => 'აფრიკა',
 			'003' => 'ჩრდილოეთ ამერიკა',
 			'005' => 'სამხრეთ ამერიკა',
 			'009' => 'ოკეანეთი',
 			'011' => 'დასავლეთ აფრიკა',
 			'013' => 'ცენტრალური ამერიკა',
 			'014' => 'აღმოსავლეთ აფრიკა',
 			'015' => 'ჩრდილოეთ აფრიკა',
 			'017' => 'შუა აფრიკა',
 			'018' => 'სამხრეთ აფრიკა',
 			'019' => 'ამერიკები',
 			'021' => 'ამერიკის ჩრდილოეთი',
 			'029' => 'კარიბის ზღვა',
 			'030' => 'აღმოსავლეთ აზია',
 			'034' => 'სამხრეთ აზია',
 			'035' => 'სამხრეთ-აღმოსავლეთ აზია',
 			'039' => 'სამხრეთ ევროპა',
 			'053' => 'ავსტრალაზია',
 			'054' => 'მელანეზია',
 			'057' => 'მიკრონეზიის რეგიონი',
 			'061' => 'პოლინეზია',
 			'142' => 'აზია',
 			'143' => 'ცენტრალური აზია',
 			'145' => 'დასავლეთ აზია',
 			'150' => 'ევროპა',
 			'151' => 'აღმოსავლეთ ევროპა',
 			'154' => 'ჩრდილოეთ ევროპა',
 			'155' => 'დასავლეთ ევროპა',
 			'202' => 'სუბსაჰარული აფრიკა',
 			'419' => 'ლათინური ამერიკა',
 			'AC' => 'ამაღლების კუნძული',
 			'AD' => 'ანდორა',
 			'AE' => 'არაბთა გაერთიანებული საამიროები',
 			'AF' => 'ავღანეთი',
 			'AG' => 'ანტიგუა და ბარბუდა',
 			'AI' => 'ანგილია',
 			'AL' => 'ალბანეთი',
 			'AM' => 'სომხეთი',
 			'AO' => 'ანგოლა',
 			'AQ' => 'ანტარქტიკა',
 			'AR' => 'არგენტინა',
 			'AS' => 'ამერიკის სამოა',
 			'AT' => 'ავსტრია',
 			'AU' => 'ავსტრალია',
 			'AW' => 'არუბა',
 			'AX' => 'ალანდის კუნძულები',
 			'AZ' => 'აზერბაიჯანი',
 			'BA' => 'ბოსნია და ჰერცეგოვინა',
 			'BB' => 'ბარბადოსი',
 			'BD' => 'ბანგლადეში',
 			'BE' => 'ბელგია',
 			'BF' => 'ბურკინა-ფასო',
 			'BG' => 'ბულგარეთი',
 			'BH' => 'ბაჰრეინი',
 			'BI' => 'ბურუნდი',
 			'BJ' => 'ბენინი',
 			'BL' => 'სენ-ბართელმი',
 			'BM' => 'ბერმუდა',
 			'BN' => 'ბრუნეი',
 			'BO' => 'ბოლივია',
 			'BQ' => 'კარიბის ნიდერლანდები',
 			'BR' => 'ბრაზილია',
 			'BS' => 'ბაჰამის კუნძულები',
 			'BT' => 'ბუტანი',
 			'BV' => 'ბუვე',
 			'BW' => 'ბოტსვანა',
 			'BY' => 'ბელარუსი',
 			'BZ' => 'ბელიზი',
 			'CA' => 'კანადა',
 			'CC' => 'ქოქოსის (კილინგის) კუნძულები',
 			'CD' => 'კონგო - კინშასა',
 			'CD@alt=variant' => 'კონგო (კონგოს დემოკრატიული რესპუბლიკა)',
 			'CF' => 'ცენტრალური აფრიკის რესპუბლიკა',
 			'CG' => 'კონგო - ბრაზავილი',
 			'CG@alt=variant' => 'კონგო (რესპუბლიკა)',
 			'CH' => 'შვეიცარია',
 			'CI' => 'კოტ-დივუარი',
 			'CI@alt=variant' => 'სპილოს ძვლის სანაპირო',
 			'CK' => 'კუკის კუნძულები',
 			'CL' => 'ჩილე',
 			'CM' => 'კამერუნი',
 			'CN' => 'ჩინეთი',
 			'CO' => 'კოლუმბია',
 			'CP' => 'კლიპერტონის კუნძული',
 			'CR' => 'კოსტა-რიკა',
 			'CU' => 'კუბა',
 			'CV' => 'კაბო-ვერდე',
 			'CW' => 'კიურასაო',
 			'CX' => 'შობის კუნძული',
 			'CY' => 'კვიპროსი',
 			'CZ' => 'ჩეხეთი',
 			'CZ@alt=variant' => 'ჩეხეთის რესპუბლიკა',
 			'DE' => 'გერმანია',
 			'DG' => 'დიეგო-გარსია',
 			'DJ' => 'ჯიბუტი',
 			'DK' => 'დანია',
 			'DM' => 'დომინიკა',
 			'DO' => 'დომინიკელთა რესპუბლიკა',
 			'DZ' => 'ალჟირი',
 			'EA' => 'სეუტა და მელილა',
 			'EC' => 'ეკვადორი',
 			'EE' => 'ესტონეთი',
 			'EG' => 'ეგვიპტე',
 			'EH' => 'დასავლეთ საჰარა',
 			'ER' => 'ერიტრეა',
 			'ES' => 'ესპანეთი',
 			'ET' => 'ეთიოპია',
 			'EU' => 'ევროკავშირი',
 			'EZ' => 'ევროზონა',
 			'FI' => 'ფინეთი',
 			'FJ' => 'ფიჯი',
 			'FK' => 'ფოლკლენდის კუნძულები',
 			'FK@alt=variant' => 'ფოლკლენდის კუნძულები (მალვინის კუნძულები)',
 			'FM' => 'მიკრონეზია',
 			'FO' => 'ფარერის კუნძულები',
 			'FR' => 'საფრანგეთი',
 			'GA' => 'გაბონი',
 			'GB' => 'გაერთიანებული სამეფო',
 			'GB@alt=short' => 'გაერთ.სამ.',
 			'GD' => 'გრენადა',
 			'GE' => 'საქართველო',
 			'GF' => 'საფრანგეთის გვიანა',
 			'GG' => 'გერნსი',
 			'GH' => 'განა',
 			'GI' => 'გიბრალტარი',
 			'GL' => 'გრენლანდია',
 			'GM' => 'გამბია',
 			'GN' => 'გვინეა',
 			'GP' => 'გვადელუპა',
 			'GQ' => 'ეკვატორული გვინეა',
 			'GR' => 'საბერძნეთი',
 			'GS' => 'სამხრეთ ჯორჯია და სამხრეთ სენდვიჩის კუნძულები',
 			'GT' => 'გვატემალა',
 			'GU' => 'გუამი',
 			'GW' => 'გვინეა-ბისაუ',
 			'GY' => 'გაიანა',
 			'HK' => 'ჰონკონგის სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი',
 			'HK@alt=short' => 'ჰონკონგი',
 			'HM' => 'ჰერდი და მაკდონალდის კუნძულები',
 			'HN' => 'ჰონდურასი',
 			'HR' => 'ხორვატია',
 			'HT' => 'ჰაიტი',
 			'HU' => 'უნგრეთი',
 			'IC' => 'კანარის კუნძულები',
 			'ID' => 'ინდონეზია',
 			'IE' => 'ირლანდია',
 			'IL' => 'ისრაელი',
 			'IM' => 'მენის კუნძული',
 			'IN' => 'ინდოეთი',
 			'IO' => 'ბრიტანეთის ტერიტორია ინდოეთის ოკეანეში',
 			'IQ' => 'ერაყი',
 			'IR' => 'ირანი',
 			'IS' => 'ისლანდია',
 			'IT' => 'იტალია',
 			'JE' => 'ჯერსი',
 			'JM' => 'იამაიკა',
 			'JO' => 'იორდანია',
 			'JP' => 'იაპონია',
 			'KE' => 'კენია',
 			'KG' => 'ყირგიზეთი',
 			'KH' => 'კამბოჯა',
 			'KI' => 'კირიბატი',
 			'KM' => 'კომორის კუნძულები',
 			'KN' => 'სენტ-კიტსი და ნევისი',
 			'KP' => 'ჩრდილოეთ კორეა',
 			'KR' => 'სამხრეთ კორეა',
 			'KW' => 'ქუვეითი',
 			'KY' => 'კაიმანის კუნძულები',
 			'KZ' => 'ყაზახეთი',
 			'LA' => 'ლაოსი',
 			'LB' => 'ლიბანი',
 			'LC' => 'სენტ-ლუსია',
 			'LI' => 'ლიხტენშტაინი',
 			'LK' => 'შრი-ლანკა',
 			'LR' => 'ლიბერია',
 			'LS' => 'ლესოთო',
 			'LT' => 'ლიეტუვა',
 			'LU' => 'ლუქსემბურგი',
 			'LV' => 'ლატვია',
 			'LY' => 'ლიბია',
 			'MA' => 'მაროკო',
 			'MC' => 'მონაკო',
 			'MD' => 'მოლდოვა',
 			'ME' => 'მონტენეგრო',
 			'MF' => 'სენ-მარტენი',
 			'MG' => 'მადაგასკარი',
 			'MH' => 'მარშალის კუნძულები',
 			'MK' => 'ჩრდილოეთ მაკედონია',
 			'ML' => 'მალი',
 			'MM' => 'მიანმარი (ბირმა)',
 			'MN' => 'მონღოლეთი',
 			'MO' => 'მაკაოს სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი',
 			'MO@alt=short' => 'მაკაო',
 			'MP' => 'ჩრდილოეთ მარიანას კუნძულები',
 			'MQ' => 'მარტინიკა',
 			'MR' => 'მავრიტანია',
 			'MS' => 'მონსერატი',
 			'MT' => 'მალტა',
 			'MU' => 'მავრიკი',
 			'MV' => 'მალდივები',
 			'MW' => 'მალავი',
 			'MX' => 'მექსიკა',
 			'MY' => 'მალაიზია',
 			'MZ' => 'მოზამბიკი',
 			'NA' => 'ნამიბია',
 			'NC' => 'ახალი კალედონია',
 			'NE' => 'ნიგერი',
 			'NF' => 'ნორფოლკის კუნძული',
 			'NG' => 'ნიგერია',
 			'NI' => 'ნიკარაგუა',
 			'NL' => 'ნიდერლანდები',
 			'NO' => 'ნორვეგია',
 			'NP' => 'ნეპალი',
 			'NR' => 'ნაურუ',
 			'NU' => 'ნიუე',
 			'NZ' => 'ახალი ზელანდია',
 			'OM' => 'ომანი',
 			'PA' => 'პანამა',
 			'PE' => 'პერუ',
 			'PF' => 'საფრანგეთის პოლინეზია',
 			'PG' => 'პაპუა-ახალი გვინეა',
 			'PH' => 'ფილიპინები',
 			'PK' => 'პაკისტანი',
 			'PL' => 'პოლონეთი',
 			'PM' => 'სენ-პიერი და მიკელონი',
 			'PN' => 'პიტკერნის კუნძულები',
 			'PR' => 'პუერტო-რიკო',
 			'PS' => 'პალესტინის ტერიტორიები',
 			'PS@alt=short' => 'პალესტინა',
 			'PT' => 'პორტუგალია',
 			'PW' => 'პალაუ',
 			'PY' => 'პარაგვაი',
 			'QA' => 'კატარი',
 			'QO' => 'შორეული ოკეანეთი',
 			'RE' => 'რეუნიონი',
 			'RO' => 'რუმინეთი',
 			'RS' => 'სერბეთი',
 			'RU' => 'რუსეთი',
 			'RW' => 'რუანდა',
 			'SA' => 'საუდის არაბეთი',
 			'SB' => 'სოლომონის კუნძულები',
 			'SC' => 'სეიშელის კუნძულები',
 			'SD' => 'სუდანი',
 			'SE' => 'შვედეთი',
 			'SG' => 'სინგაპური',
 			'SH' => 'წმინდა ელენეს კუნძული',
 			'SI' => 'სლოვენია',
 			'SJ' => 'შპიცბერგენი და იან-მაიენი',
 			'SK' => 'სლოვაკეთი',
 			'SL' => 'სიერა-ლეონე',
 			'SM' => 'სან-მარინო',
 			'SN' => 'სენეგალი',
 			'SO' => 'სომალი',
 			'SR' => 'სურინამი',
 			'SS' => 'სამხრეთ სუდანი',
 			'ST' => 'სან-ტომე და პრინსიპი',
 			'SV' => 'სალვადორი',
 			'SX' => 'სინტ-მარტენი',
 			'SY' => 'სირია',
 			'SZ' => 'სვაზილენდი',
 			'SZ@alt=variant' => 'სვაზილანდი',
 			'TA' => 'ტრისტან-და-კუნია',
 			'TC' => 'თერქს-ქაიქოსის კუნძულები',
 			'TD' => 'ჩადი',
 			'TF' => 'ფრანგული სამხრეთის ტერიტორიები',
 			'TG' => 'ტოგო',
 			'TH' => 'ტაილანდი',
 			'TJ' => 'ტაჯიკეთი',
 			'TK' => 'ტოკელაუ',
 			'TL' => 'ტიმორ-ლესტე',
 			'TL@alt=variant' => 'აღმოსავლეთ ტიმორი',
 			'TM' => 'თურქმენეთი',
 			'TN' => 'ტუნისი',
 			'TO' => 'ტონგა',
 			'TR' => 'თურქეთი',
 			'TT' => 'ტრინიდადი და ტობაგო',
 			'TV' => 'ტუვალუ',
 			'TW' => 'ტაივანი',
 			'TZ' => 'ტანზანია',
 			'UA' => 'უკრაინა',
 			'UG' => 'უგანდა',
 			'UM' => 'აშშ-ის შორეული კუნძულები',
 			'UN' => 'გაერო',
 			'US' => 'ამერიკის შეერთებული შტატები',
 			'US@alt=short' => 'აშშ',
 			'UY' => 'ურუგვაი',
 			'UZ' => 'უზბეკეთი',
 			'VA' => 'ქალაქი ვატიკანი',
 			'VC' => 'სენტ-ვინსენტი და გრენადინები',
 			'VE' => 'ვენესუელა',
 			'VG' => 'ბრიტანეთის ვირჯინის კუნძულები',
 			'VI' => 'აშშ-ის ვირჯინის კუნძულები',
 			'VN' => 'ვიეტნამი',
 			'VU' => 'ვანუატუ',
 			'WF' => 'უოლისი და ფუტუნა',
 			'WS' => 'სამოა',
 			'XA' => 'ფსევდო-აქცენტები',
 			'XB' => 'ფსევდო-ორმიმართულებიანი',
 			'XK' => 'კოსოვო',
 			'YE' => 'იემენი',
 			'YT' => 'მაიოტა',
 			'ZA' => 'სამხრეთ აფრიკის რესპუბლიკა',
 			'ZM' => 'ზამბია',
 			'ZW' => 'ზიმბაბვე',
 			'ZZ' => 'უცნობი რეგიონი',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'ტრადიციული გერმანული ორთოგრაფია',
 			'1994' => 'სტანდარტული რეზიანული ორთოგრაფია',
 			'1996' => '1996 წლის გერმანული ორთოგრაფია',
 			'1606NICT' => 'გვიანი საშუალო ფრანგული',
 			'1694ACAD' => 'ადრე ახალი ფრანგული',
 			'1959ACAD' => 'აკადემიური',
 			'ALALC97' => 'ALA-LC რომანიზაცია',
 			'ALUKU' => 'ალუკუ',
 			'AREVELA' => 'აღმოსავლეთსომხური',
 			'AREVMDA' => 'დასავლეთსომხური',
 			'BAKU1926' => 'უნიფიცირებული თურქული ლათინური',
 			'BAUDDHA' => 'ბუდისტური სანსკრიტი',
 			'BISCAYAN' => 'ბისკაიური ბასკური',
 			'BISKE' => 'ბილური რეზიული',
 			'BOHORIC' => 'ბოხორიჩიცა',
 			'BOONT' => 'ბუნტლინგი',
 			'DAJNKO' => 'დაინჩიცა',
 			'EMODENG' => 'ადრე ახალი ინგლისური',
 			'FONIPA' => 'IPA',
 			'FONUPA' => 'UPA',
 			'FONXSAMP' => 'X-SAMPA',
 			'HEPBURN' => 'ჰეპბერნის რომანიზაცია',
 			'HOGNORSK' => 'ჰეგნორსკი',
 			'ITIHASA' => 'იტიხასა',
 			'JAUER' => 'მიუნსტერული რეტორომანული',
 			'JYUTPING' => 'იუტ-ფინი',
 			'KKCOR' => 'ზოგადი ორთოგრაფია',
 			'KSCOR' => 'სტანდარტული ორთოგრაფია',
 			'LAUKIKA' => 'ლაუკიკა',
 			'LIPAW' => 'ლიპოვაცური რეზიული',
 			'LUNA1918' => '1918 წლის რუსილი',
 			'METELKO' => 'მეტელკოსი',
 			'NDYUKA' => 'ნჯუკა',
 			'NEDIS' => 'ნატისონური',
 			'NJIVA' => 'ნიივური რეზიული',
 			'NULIK' => 'თანამედროვე ვოლაპიუკი',
 			'OSOJS' => 'ოსოიანური რეზიული',
 			'PAMAKA' => 'პამაკა',
 			'PETR1708' => 'პეტრის 1708 წლის',
 			'PINYIN' => 'პინ-ინი',
 			'POSIX' => 'კომპიუტერული',
 			'PUTER' => 'პუტერული რეტორომანული',
 			'REVISED' => 'ახალი ორთოგრაფია',
 			'RIGIK' => 'კლასიკური ვოლაპიუკი',
 			'ROZAJ' => 'რეზიული',
 			'RUMGR' => 'გრიშუნული რეტორომანული',
 			'SAAHO' => 'საჰო',
 			'SCOTLAND' => 'შოტლანდიური ინგლისური',
 			'SCOUSE' => 'სკაუსი',
 			'SOLBA' => 'სოლბიცური რეზიული',
 			'SURMIRAN' => 'სურმირანული რეტორომანული',
 			'SURSILV' => 'სურსილვანური რეტორომანული',
 			'SUTSILV' => 'სუტსილვანური რეტორომანული',
 			'TARASK' => 'ტარაშკევიცა',
 			'UCCOR' => 'უნიფიცირებული ორთოგრაფია',
 			'UCRCOR' => 'გადასინჯული უნიფიცირებული ორთოგრაფია',
 			'ULSTER' => 'ულსტერის ირლანდიური',
 			'VAIDIKA' => 'ვედური სანსკრიტი',
 			'VALENCIA' => 'ვალენსიური კატალანური',
 			'VALLADER' => 'ვალადერული რეტორომანული',
 			'WADEGILE' => 'ვეიდ-ჯაილზი',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'კალენდარი',
 			'cf' => 'ვალუტის ფორმატი',
 			'collation' => 'დახარისხების თანმიმდევრობა',
 			'currency' => 'ვალუტა',
 			'hc' => 'დროის სისტემა (12 ან 24)',
 			'lb' => 'სტრიქონის წყვეტის სტილი',
 			'ms' => 'საზომი სისტემა',
 			'numbers' => 'რიცხვები',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ბუდისტური კალენდარი},
 				'chinese' => q{ჩინური კალენდარი},
 				'coptic' => q{კოპტური კალენდარი},
 				'dangi' => q{კალენდარი დანგი},
 				'ethiopic' => q{ეთიოპიური კალენდარი},
 				'ethiopic-amete-alem' => q{ეთიოპიური ამეთე ალემი კალენდარი},
 				'gregorian' => q{გრიგორიანული კალენდარი},
 				'hebrew' => q{ებრაული კალენდარი},
 				'indian' => q{ინდოეთის ეროვნული კალენდარი},
 				'islamic' => q{ისლამური კალენდარი},
 				'islamic-civil' => q{ისლამური სამოქალაქო კალენდარი},
 				'iso8601' => q{ISO-8601 კალენდარი},
 				'japanese' => q{იაპონური კალენდარი},
 				'persian' => q{სპარსული კალენდარი},
 				'roc' => q{ჩინეთის რესპუბლიკის კალენდარი},
 			},
 			'cf' => {
 				'account' => q{ვალუტის ბუღალტრული ფორმატი},
 				'standard' => q{ვალუტის სტანდარტული ფორმატი},
 			},
 			'collation' => {
 				'big5han' => q{ტრადიციული ჩინური},
 				'dictionary' => q{ლექსიკონით},
 				'ducet' => q{უნიკოდის ნაგულისხმევი დახარისხების თანმიმდევრობა},
 				'gb2312han' => q{გამარტივებული ჩინური},
 				'phonebook' => q{ტელეფონის წიგნით},
 				'pinyin' => q{პინ-ინი},
 				'reformed' => q{რეფორმირებული},
 				'search' => q{ზოგადი დანიშნულების ძიება},
 				'searchjl' => q{ჰანგულის პირველი თანხმოვნით},
 				'standard' => q{სტანდარტული დახარისხების თანმიმდევრობა},
 				'stroke' => q{შტრიხით},
 				'traditional' => q{ტრადიციული},
 				'unihan' => q{ძირითადი შტრიხით},
 				'zhuyin' => q{ჟუინი},
 			},
 			'hc' => {
 				'h11' => q{12-საათიანი სისტემა (0-11)},
 				'h12' => q{12-საათიანი სისტემა (1-12)},
 				'h23' => q{24-საათიანი სისტემა (0-23)},
 				'h24' => q{24-საათიანი სისტემა (1-24)},
 			},
 			'lb' => {
 				'loose' => q{სტრიქონის რბილი წყვეტის სტილი},
 				'normal' => q{სტრიქონის ჩვეულებრივი წყვეტის სტილი},
 				'strict' => q{სტრიქონის ზედმიწევნითი წყვეტის სტილი},
 			},
 			'ms' => {
 				'metric' => q{მეტრული სისტემა},
 				'uksystem' => q{ბრიტანული საზომი სისტემა},
 				'ussystem' => q{ამერიკული საზომი სისტემა},
 			},
 			'numbers' => {
 				'arab' => q{არაბულ-ინდური ციფრები},
 				'arabext' => q{გაფართოებული არაბულ-ინდური ციფრები},
 				'armn' => q{სომხური რიცხვები},
 				'armnlow' => q{სომხური ქვედა რეგისტრის რიცხვები},
 				'bali' => q{ბალიური ციფრები},
 				'beng' => q{ბენგალური ციფრები},
 				'cham' => q{ჩამური ციფრები},
 				'deva' => q{დევანაგარის ციფრები},
 				'ethi' => q{ეთიოპიური რიცხვები},
 				'fullwide' => q{სრულსიგანიანი ციფრები},
 				'geor' => q{ქართული რიცხვები},
 				'grek' => q{ბერძნული რიცხვები},
 				'greklow' => q{ბერძნული ქვედა რეგისტრის რიცხვები},
 				'gujr' => q{გუჯარათული ციფრები},
 				'guru' => q{გურმუხული ციფრები},
 				'hanidec' => q{ჩინური ათობითი რიცხვები},
 				'hans' => q{გამარტივებული ჩინური რიცხვები},
 				'hansfin' => q{გამარტივებული ჩინური ფინანსური რიცხვები},
 				'hant' => q{ტრადიციული ჩინური რიცხვები},
 				'hantfin' => q{ტრადიციული ჩინური ფინანსური რიცხვები},
 				'hebr' => q{ებრაული რიცხვები},
 				'java' => q{იავური ციფრები},
 				'jpan' => q{იაპონური რიცხვები},
 				'jpanfin' => q{იაპონური ფინანსური რიცხვები},
 				'kali' => q{კაიაჰ-ლისი ციფრები},
 				'khmr' => q{ქხმერული ციფრები},
 				'knda' => q{კანადური რიცხვები},
 				'lana' => q{ტაი თამის ჰორასი ციფრები},
 				'lanatham' => q{ტაი თამის თამისი ციფრები},
 				'laoo' => q{ლაოსური ციფრები},
 				'latn' => q{დასავლური ციფრები},
 				'lepc' => q{რონგ-რინგის ციფრები},
 				'limb' => q{ლიმბური ციფრები},
 				'mlym' => q{მალაიალამური ციფრები},
 				'mong' => q{მონღოლური ციფრები},
 				'mtei' => q{მანიპური ციფრები},
 				'mymr' => q{მიანმური ციფრები},
 				'mymrshan' => q{მიანმური შანი ციფრები},
 				'nkoo' => q{ნკოური ციფრები},
 				'olck' => q{ოლ-ჩიკის ციფრები},
 				'orya' => q{ორიული ციფრები},
 				'roman' => q{რომაული ციფრები},
 				'romanlow' => q{რომაული ქვედა რეგისტრის რიცხვები},
 				'saur' => q{საურაშტრული ციფრები},
 				'sund' => q{სუნდანური ციფრები},
 				'talu' => q{ახალი ტაი ლიუსი ციფრები},
 				'taml' => q{ტრადიციული ტამილური რიცხვები},
 				'tamldec' => q{ტამილური ციფრები},
 				'telu' => q{ტელუგუს ციფრები},
 				'thai' => q{ტაილანდური ციფრები},
 				'tibt' => q{ტიბეტური ციფრები},
 				'vaii' => q{ვაიური ციფრები},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{მეტრული},
 			'UK' => q{ბრიტანული},
 			'US' => q{ამერიკული},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ენა: {0}',
 			'script' => 'დამწერლობა: {0}',
 			'region' => 'რეგიონი: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ⴀ ⴁ ⴂ ⴃ ⴄ ⴅ ⴆ ჱ ⴡ ⴇ ⴈ ⴉ ⴊ ⴋ ⴌ ჲ ⴢ ⴍ ⴎ ⴏ ⴐ ⴑ ⴒ ჳ ⴣ ⴓ ⴔ ⴕ ⴖ ⴗ ⴘ ⴙ ⴚ ⴛ ⴜ ⴝ ⴞ ჴ ⴤ ⴟ ⴠ ჵ ⴥ ჶ ჷ ჸ ჹ ჺ]},
			index => ['ა', 'ბ', 'გ', 'დ', 'ე', 'ვ', 'ზ', 'თ', 'ი', 'კ', 'ლ', 'მ', 'ნ', 'ო', 'პ', 'ჟ', 'რ', 'ს', 'ტ', 'უ', 'ფ', 'ქ', 'ღ', 'ყ', 'შ', 'ჩ', 'ც', 'ძ', 'წ', 'ჭ', 'ხ', 'ჯ', 'ჰ'],
			main => qr{[ა ბ გ დ ე ვ ზ თ ი კ ლ მ ნ ო პ ჟ რ ს ტ უ ფ ქ ღ ყ შ ჩ ც ძ წ ჭ ხ ჯ ჰ]},
			numbers => qr{[  \- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐ ‑ – — , ; \: ! ? . … ჻ ' ‘ ‚ “ „ « » ( ) \[ \] \{ \} § @ * / \& # † ‡ ′ ″ №]},
		};
	},
EOT
: sub {
		return { index => ['ა', 'ბ', 'გ', 'დ', 'ე', 'ვ', 'ზ', 'თ', 'ი', 'კ', 'ლ', 'მ', 'ნ', 'ო', 'პ', 'ჟ', 'რ', 'ს', 'ტ', 'უ', 'ფ', 'ქ', 'ღ', 'ყ', 'შ', 'ჩ', 'ც', 'ძ', 'წ', 'ჭ', 'ხ', 'ჯ', 'ჰ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(კარდინალური მიმართულება),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(კარდინალური მიმართულება),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(კიბი{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(კიბი{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(მები{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(მები{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(გიბი{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(გიბი{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(ტები{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(ტები{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(პები{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(პები{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ექსბი{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ექსბი{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(ზები{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(ზები{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(იობი{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(იობი{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(დეცი{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(დეცი{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(პიკო{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(პიკო{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ფემტო{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ფემტო{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ატო{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ატო{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(სანტი{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(სანტი{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ზეპტო{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ზეპტო{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(იოქტო{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(იოქტო{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(მილი{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(მილი{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(მიკრო{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(მიკრო{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ნანო{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ნანო{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(დეკა{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(დეკა{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ტერა{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ტერა{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(პეტა{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(პეტა{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ექსა{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ექსა{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ჰეკტო{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ჰეკტო{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(ზეტა{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(ზეტა{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(იოტა{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(იოტა{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(კილო{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(კილო{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(მეგა{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(მეგა{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(გიგა{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(გიგა{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ინერციის ძალა),
						'one' => q({0} ინერციის ძალა),
						'other' => q({0} ინერციის ძალა),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ინერციის ძალა),
						'one' => q({0} ინერციის ძალა),
						'other' => q({0} ინერციის ძალა),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(მეტრი კვადრატულ წამში),
						'one' => q({0} მ/წმ²),
						'other' => q({0} მ/წმ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(მეტრი კვადრატულ წამში),
						'one' => q({0} მ/წმ²),
						'other' => q({0} მ/წმ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(მინუტი),
						'one' => q({0} მინუტი),
						'other' => q({0} მინუტი),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(მინუტი),
						'one' => q({0} მინუტი),
						'other' => q({0} მინუტი),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(სეკუნდი),
						'one' => q({0} სეკუნდი),
						'other' => q({0} სეკუნდი),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(სეკუნდი),
						'one' => q({0} სეკუნდი),
						'other' => q({0} სეკუნდი),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(გრადუსი),
						'one' => q({0} გრადუსი),
						'other' => q({0} გრადუსი),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(გრადუსი),
						'one' => q({0} გრადუსი),
						'other' => q({0} გრადუსი),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(რადიანი),
						'one' => q({0} რადიანი),
						'other' => q({0} რადიანი),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(რადიანი),
						'one' => q({0} რადიანი),
						'other' => q({0} რადიანი),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(ბრუნვა),
						'one' => q({0} ბრუნვა),
						'other' => q({0} ბრუნვა),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(ბრუნვა),
						'one' => q({0} ბრუნვა),
						'other' => q({0} ბრუნვა),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(აკრი),
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(აკრი),
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(დუნამი),
						'one' => q({0} დუნამი),
						'other' => q({0} დუნამი),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(დუნამი),
						'one' => q({0} დუნამი),
						'other' => q({0} დუნამი),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ჰექტარი),
						'one' => q({0} ჰექტარი),
						'other' => q({0} ჰექტარი),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ჰექტარი),
						'one' => q({0} ჰექტარი),
						'other' => q({0} ჰექტარი),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(კვადრატული სანტიმეტრი),
						'one' => q({0} კვადრატული სანტიმეტრი),
						'other' => q({0} კვადრატული სანტიმეტრი),
						'per' => q({0} კვადრატულ სანტიმეტრში),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(კვადრატული სანტიმეტრი),
						'one' => q({0} კვადრატული სანტიმეტრი),
						'other' => q({0} კვადრატული სანტიმეტრი),
						'per' => q({0} კვადრატულ სანტიმეტრში),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(კვადრატული ფუტი),
						'one' => q({0} კვადრატული ფუტი),
						'other' => q({0} კვადრატული ფუტი),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(კვადრატული ფუტი),
						'one' => q({0} კვადრატული ფუტი),
						'other' => q({0} კვადრატული ფუტი),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(კვადრატული დუიმი),
						'one' => q({0} კვადრატული დუიმი),
						'other' => q({0} კვადრატული დუიმი),
						'per' => q({0} კვადრატულ დუიმში),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(კვადრატული დუიმი),
						'one' => q({0} კვადრატული დუიმი),
						'other' => q({0} კვადრატული დუიმი),
						'per' => q({0} კვადრატულ დუიმში),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(კვადრატული კილომეტრი),
						'one' => q({0} კვადრატული კილომეტრი),
						'other' => q({0} კვადრატული კილომეტრი),
						'per' => q({0} კვადრატულ კილომეტრში),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(კვადრატული კილომეტრი),
						'one' => q({0} კვადრატული კილომეტრი),
						'other' => q({0} კვადრატული კილომეტრი),
						'per' => q({0} კვადრატულ კილომეტრში),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(კვადრატული მეტრი),
						'one' => q({0} კვადრატული მეტრი),
						'other' => q({0} კვადრატული მეტრი),
						'per' => q({0} კვადრატულ მეტრში),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(კვადრატული მეტრი),
						'one' => q({0} კვადრატული მეტრი),
						'other' => q({0} კვადრატული მეტრი),
						'per' => q({0} კვადრატულ მეტრში),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(კვადრატული მილი),
						'one' => q({0} კვადრატული მილი),
						'other' => q({0} კვადრატული მილი),
						'per' => q({0} კვადრატულ მილში),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(კვადრატული მილი),
						'one' => q({0} კვადრატული მილი),
						'other' => q({0} კვადრატული მილი),
						'per' => q({0} კვადრატულ მილში),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(კვადრატული იარდი),
						'one' => q({0} კვადრატული იარდი),
						'other' => q({0} კვადრატული იარდი),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(კვადრატული იარდი),
						'one' => q({0} კვადრატული იარდი),
						'other' => q({0} კვადრატული იარდი),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ერთეული),
						'one' => q({0} ერთეული),
						'other' => q({0} ერთეული),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ერთეული),
						'one' => q({0} ერთეული),
						'other' => q({0} ერთეული),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(კარატი),
						'one' => q({0} კარატი),
						'other' => q({0} კარატი),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(კარატი),
						'one' => q({0} კარატი),
						'other' => q({0} კარატი),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(მილიგრამი დეცილიტრზე),
						'one' => q({0} მილიგრამი დეცილიტრზე),
						'other' => q({0} მილიგრამი დეცილიტრზე),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(მილიგრამი დეცილიტრზე),
						'one' => q({0} მილიგრამი დეცილიტრზე),
						'other' => q({0} მილიგრამი დეცილიტრზე),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(მილიმოლი ლიტრზე),
						'one' => q({0} მილიმოლი ლიტრზე),
						'other' => q({0} მილიმოლი ლიტრზე),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(მილიმოლი ლიტრზე),
						'one' => q({0} მილიმოლი ლიტრზე),
						'other' => q({0} მილიმოლი ლიტრზე),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(პროცენტი),
						'one' => q({0} პროცენტი),
						'other' => q({0} პროცენტი),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(პროცენტი),
						'one' => q({0} პროცენტი),
						'other' => q({0} პროცენტი),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(პრომილე),
						'one' => q({0} პრომილე),
						'other' => q({0} პრომილე),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(პრომილე),
						'one' => q({0} პრომილე),
						'other' => q({0} პრომილე),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ნაწილი მილიონზე),
						'one' => q({0} ნაწილი მილიონზე),
						'other' => q({0} ნაწილი მილიონზე),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ნაწილი მილიონზე),
						'one' => q({0} ნაწილი მილიონზე),
						'other' => q({0} ნაწილი მილიონზე),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ლიტრი 100 კილომეტრში),
						'one' => q({0} ლიტრი 100 კილომეტრში),
						'other' => q({0} ლიტრი 100 კილომეტრში),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ლიტრი 100 კილომეტრში),
						'one' => q({0} ლიტრი 100 კილომეტრში),
						'other' => q({0} ლიტრი 100 კილომეტრში),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ლიტრი კილომეტრზე),
						'one' => q({0} ლიტრი კილომეტრზე),
						'other' => q({0} ლიტრი კილომეტრზე),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ლიტრი კილომეტრზე),
						'one' => q({0} ლიტრი კილომეტრზე),
						'other' => q({0} ლიტრი კილომეტრზე),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(მილი გალონზე),
						'one' => q({0} მილი გალონზე),
						'other' => q({0} მილი გალონზე),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(მილი გალონზე),
						'one' => q({0} მილი გალონზე),
						'other' => q({0} მილი გალონზე),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(იმპ. გალონი მილზე),
						'one' => q({0} იმპ. გალონი მილზე),
						'other' => q({0} იმპ. გალონი მილზე),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(იმპ. გალონი მილზე),
						'one' => q({0} იმპ. გალონი მილზე),
						'other' => q({0} იმპ. გალონი მილზე),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} აღმოსავლეთით),
						'north' => q({0} ჩრდილოეთით),
						'south' => q({0} სამხრეთით),
						'west' => q({0} დასავლეთით),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} აღმოსავლეთით),
						'north' => q({0} ჩრდილოეთით),
						'south' => q({0} სამხრეთით),
						'west' => q({0} დასავლეთით),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(ბიტი),
						'one' => q({0} ბიტი),
						'other' => q({0} ბიტი),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(ბიტი),
						'one' => q({0} ბიტი),
						'other' => q({0} ბიტი),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(ბაიტი),
						'one' => q({0} ბაიტი),
						'other' => q({0} ბაიტი),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(ბაიტი),
						'one' => q({0} ბაიტი),
						'other' => q({0} ბაიტი),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(გიგაბიტი),
						'one' => q({0} გიგაბიტი),
						'other' => q({0} გიგაბიტი),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(გიგაბიტი),
						'one' => q({0} გიგაბიტი),
						'other' => q({0} გიგაბიტი),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(გიგაბაიტი),
						'one' => q({0} გიგაბაიტი),
						'other' => q({0} გიგაბაიტი),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(გიგაბაიტი),
						'one' => q({0} გიგაბაიტი),
						'other' => q({0} გიგაბაიტი),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(კილობიტი),
						'one' => q({0} კილობიტი),
						'other' => q({0} კილობიტი),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(კილობიტი),
						'one' => q({0} კილობიტი),
						'other' => q({0} კილობიტი),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(კილობაიტი),
						'one' => q({0} კილობაიტი),
						'other' => q({0} კილობაიტი),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(კილობაიტი),
						'one' => q({0} კილობაიტი),
						'other' => q({0} კილობაიტი),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(მეგაბიტი),
						'one' => q({0} მეგაბიტი),
						'other' => q({0} მეგაბიტი),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(მეგაბიტი),
						'one' => q({0} მეგაბიტი),
						'other' => q({0} მეგაბიტი),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(მეგაბაიტი),
						'one' => q({0} მეგაბაიტი),
						'other' => q({0} მეგაბაიტი),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(მეგაბაიტი),
						'one' => q({0} მეგაბაიტი),
						'other' => q({0} მეგაბაიტი),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(პბაიტი),
						'one' => q({0} პბაიტი),
						'other' => q({0} პეტაბაიტი),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(პბაიტი),
						'one' => q({0} პბაიტი),
						'other' => q({0} პეტაბაიტი),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ტერაბიტი),
						'one' => q({0} ტერაბიტი),
						'other' => q({0} ტერაბიტი),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ტერაბიტი),
						'one' => q({0} ტერაბიტი),
						'other' => q({0} ტერაბიტი),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ტერაბაიტი),
						'one' => q({0} ტერაბაიტი),
						'other' => q({0} ტერაბაიტი),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ტერაბაიტი),
						'one' => q({0} ტერაბაიტი),
						'other' => q({0} ტერაბაიტი),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(საუკუნე),
						'one' => q({0} საუკუნე),
						'other' => q({0} საუკუნე),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(საუკუნე),
						'one' => q({0} საუკუნე),
						'other' => q({0} საუკუნე),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(დღე),
						'one' => q({0} დღე),
						'other' => q({0} დღე),
						'per' => q({0} დღეში),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(დღე),
						'one' => q({0} დღე),
						'other' => q({0} დღე),
						'per' => q({0} დღეში),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(დეკადა),
						'one' => q({0} დეკადა),
						'other' => q({0} დეკადა),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(დეკადა),
						'one' => q({0} დეკადა),
						'other' => q({0} დეკადა),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(საათი),
						'one' => q({0} საათი),
						'other' => q({0} საათი),
						'per' => q({0} საათში),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(საათი),
						'one' => q({0} საათი),
						'other' => q({0} საათი),
						'per' => q({0} საათში),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(მიკროწამი),
						'one' => q({0} მიკროწამი),
						'other' => q({0} მიკროწამი),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(მიკროწამი),
						'one' => q({0} მიკროწამი),
						'other' => q({0} მიკროწამი),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(მილიწამი),
						'one' => q({0} მილიწამი),
						'other' => q({0} მილიწამი),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(მილიწამი),
						'one' => q({0} მილიწამი),
						'other' => q({0} მილიწამი),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(წუთი),
						'one' => q({0} წუთი),
						'other' => q({0} წუთი),
						'per' => q({0} წუთში),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(წუთი),
						'one' => q({0} წუთი),
						'other' => q({0} წუთი),
						'per' => q({0} წუთში),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(თვე),
						'one' => q({0} თვე),
						'other' => q({0} თვე),
						'per' => q({0} თვეში),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(თვე),
						'one' => q({0} თვე),
						'other' => q({0} თვე),
						'per' => q({0} თვეში),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ნანოწამი),
						'one' => q({0} ნანოწამი),
						'other' => q({0} ნანოწამი),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ნანოწამი),
						'one' => q({0} ნანოწამი),
						'other' => q({0} ნანოწამი),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(წამი),
						'one' => q({0} წამი),
						'other' => q({0} წამი),
						'per' => q({0} წამში),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(წამი),
						'one' => q({0} წამი),
						'other' => q({0} წამი),
						'per' => q({0} წამში),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(კვირა),
						'one' => q({0} კვირა),
						'other' => q({0} კვირა),
						'per' => q({0} კვირაში),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(კვირა),
						'one' => q({0} კვირა),
						'other' => q({0} კვირა),
						'per' => q({0} კვირაში),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(წელი),
						'one' => q({0} წელი),
						'other' => q({0} წელი),
						'per' => q({0} წელში),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(წელი),
						'one' => q({0} წელი),
						'other' => q({0} წელი),
						'per' => q({0} წელში),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ამპერი),
						'one' => q({0} ა),
						'other' => q({0} ა),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ამპერი),
						'one' => q({0} ა),
						'other' => q({0} ა),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(მილიამპერი),
						'one' => q({0} მილიამპერი),
						'other' => q({0} მილიამპერი),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(მილიამპერი),
						'one' => q({0} მილიამპერი),
						'other' => q({0} მილიამპერი),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ომი),
						'one' => q({0} ომი),
						'other' => q({0} ომი),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ომი),
						'one' => q({0} ომი),
						'other' => q({0} ომი),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ვოლტი),
						'one' => q({0} ვოლტი),
						'other' => q({0} ვოლტი),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ვოლტი),
						'one' => q({0} ვოლტი),
						'other' => q({0} ვოლტი),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(ბრიტანული სითბური ერთეული),
						'one' => q({0} ბრიტანული სითბური ერთეული),
						'other' => q({0} ბრიტანული სითბური ერთეული),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(ბრიტანული სითბური ერთეული),
						'one' => q({0} ბრიტანული სითბური ერთეული),
						'other' => q({0} ბრიტანული სითბური ერთეული),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(კალორია),
						'one' => q({0} კალორია),
						'other' => q({0} კალორია),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(კალორია),
						'one' => q({0} კალორია),
						'other' => q({0} კალორია),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ელექტრონვოლტი),
						'one' => q({0} ელექტრონვოლტი),
						'other' => q({0} ელექტრონვოლტი),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ელექტრონვოლტი),
						'one' => q({0} ელექტრონვოლტი),
						'other' => q({0} ელექტრონვოლტი),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(კალორია),
						'one' => q({0} კალორია),
						'other' => q({0} კალორია),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(კალორია),
						'one' => q({0} კალორია),
						'other' => q({0} კალორია),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(ჯოული),
						'one' => q({0} ჯოული),
						'other' => q({0} ჯოული),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(ჯოული),
						'one' => q({0} ჯოული),
						'other' => q({0} ჯოული),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(კილოკალორია),
						'one' => q({0} კილოკალორია),
						'other' => q({0} კილოკალორია),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(კილოკალორია),
						'one' => q({0} კილოკალორია),
						'other' => q({0} კილოკალორია),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(კილოჯოული),
						'one' => q({0} კილოჯოული),
						'other' => q({0} კილოჯოული),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(კილოჯოული),
						'one' => q({0} კილოჯოული),
						'other' => q({0} კილოჯოული),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(კილოვატ-საათი),
						'one' => q({0} კილოვატ-საათი),
						'other' => q({0} კილოვატ-საათი),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(კილოვატ-საათი),
						'one' => q({0} კილოვატ-საათი),
						'other' => q({0} კილოვატ-საათი),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(აშშ თერმი),
						'one' => q({0} აშშ თერმი),
						'other' => q({0} აშშ თერმი),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(აშშ თერმი),
						'one' => q({0} აშშ თერმი),
						'other' => q({0} აშშ თერმი),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(კვტსთ/100კმ),
						'one' => q({0} კვტსთ/100კმ),
						'other' => q({0} კვტსთ/100კმ),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(კვტსთ/100კმ),
						'one' => q({0} კვტსთ/100კმ),
						'other' => q({0} კვტსთ/100კმ),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(გიგაჰერცი),
						'one' => q({0} გიგაჰერცი),
						'other' => q({0} გიგაჰერცი),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(გიგაჰერცი),
						'one' => q({0} გიგაჰერცი),
						'other' => q({0} გიგაჰერცი),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(ჰერცი),
						'one' => q({0} ჰერცი),
						'other' => q({0} ჰერცი),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(ჰერცი),
						'one' => q({0} ჰერცი),
						'other' => q({0} ჰერცი),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(კილოჰერცი),
						'one' => q({0} კილოჰერცი),
						'other' => q({0} კილოჰერცი),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(კილოჰერცი),
						'one' => q({0} კილოჰერცი),
						'other' => q({0} კილოჰერცი),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(მეგაჰერცი),
						'one' => q({0} მეგაჰერცი),
						'other' => q({0} მეგაჰერცი),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(მეგაჰერცი),
						'one' => q({0} მეგაჰერცი),
						'other' => q({0} მეგაჰერცი),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(წერტილი),
						'one' => q({0} წერტილი),
						'other' => q({0} წერტილი),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(წერტილი),
						'one' => q({0} წერტილი),
						'other' => q({0} წერტილი),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(წერტილი სანტიმეტრზე),
						'one' => q({0} წერტილი სანტიმეტრზე),
						'other' => q({0} წერტილი სანტიმეტრზე),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(წერტილი სანტიმეტრზე),
						'one' => q({0} წერტილი სანტიმეტრზე),
						'other' => q({0} წერტილი სანტიმეტრზე),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(წერტილი დუიმზე),
						'one' => q({0} წერტილი დუიმზე),
						'other' => q({0} წერტილი დუიმზე),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(წერტილი დუიმზე),
						'one' => q({0} წერტილი დუიმზე),
						'other' => q({0} წერტილი დუიმზე),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(ტიპოგრაფიული ემი),
						'one' => q({0} ემი),
						'other' => q({0} ემი),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(ტიპოგრაფიული ემი),
						'one' => q({0} ემი),
						'other' => q({0} ემი),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(მეგაპიქსელი),
						'one' => q({0} მეგაპიქსელი),
						'other' => q({0} მეგაპიქსელი),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(მეგაპიქსელი),
						'one' => q({0} მეგაპიქსელი),
						'other' => q({0} მეგაპიქსელი),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(პიქსელი),
						'one' => q({0} პიქსელი),
						'other' => q({0} პიქსელი),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(პიქსელი),
						'one' => q({0} პიქსელი),
						'other' => q({0} პიქსელი),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(პიქსელი სანტიმეტრზე),
						'one' => q({0} პიქსელი სანტიმეტრზე),
						'other' => q({0} პიქსელი სანტიმეტრზე),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(პიქსელი სანტიმეტრზე),
						'one' => q({0} პიქსელი სანტიმეტრზე),
						'other' => q({0} პიქსელი სანტიმეტრზე),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(პიქსელი დუიმზე),
						'one' => q({0} პიქსელი დუიმზე),
						'other' => q({0} პიქსელი დუიმზე),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(პიქსელი დუიმზე),
						'one' => q({0} პიქსელი დუიმზე),
						'other' => q({0} პიქსელი დუიმზე),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ასტრონომიული ერთეული),
						'one' => q({0} ასტრონომიული ერთეული),
						'other' => q({0} ასტრონომიული ერთეული),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ასტრონომიული ერთეული),
						'one' => q({0} ასტრონომიული ერთეული),
						'other' => q({0} ასტრონომიული ერთეული),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(სანტიმეტრი),
						'one' => q({0} სანტიმეტრი),
						'other' => q({0} სანტიმეტრი),
						'per' => q({0} სანტიმეტრში),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(სანტიმეტრი),
						'one' => q({0} სანტიმეტრი),
						'other' => q({0} სანტიმეტრი),
						'per' => q({0} სანტიმეტრში),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(დეციმეტრი),
						'one' => q({0} დეციმეტრი),
						'other' => q({0} დეციმეტრი),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(დეციმეტრი),
						'one' => q({0} დეციმეტრი),
						'other' => q({0} დეციმეტრი),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(დედამიწის რადიუსი),
						'one' => q({0} დედამიწის რადიუსი),
						'other' => q({0} დედამიწის რადიუსი),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(დედამიწის რადიუსი),
						'one' => q({0} დედამიწის რადიუსი),
						'other' => q({0} დედამიწის რადიუსი),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ფატომი),
						'one' => q({0} ფატომი),
						'other' => q({0} ფატომი),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ფატომი),
						'one' => q({0} ფატომი),
						'other' => q({0} ფატომი),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ფუტი),
						'one' => q({0} ფუტი),
						'other' => q({0} ფუტი),
						'per' => q({0} ფუტში),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ფუტი),
						'one' => q({0} ფუტი),
						'other' => q({0} ფუტი),
						'per' => q({0} ფუტში),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(ფურლონგი),
						'one' => q({0} ფურლონგი),
						'other' => q({0} ფურლონგი),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(ფურლონგი),
						'one' => q({0} ფურლონგი),
						'other' => q({0} ფურლონგი),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(დუიმი),
						'one' => q({0} დუიმი),
						'other' => q({0} დუიმი),
						'per' => q({0} დუიმში),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(დუიმი),
						'one' => q({0} დუიმი),
						'other' => q({0} დუიმი),
						'per' => q({0} დუიმში),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(კილომეტრი),
						'one' => q({0} კილომეტრი),
						'other' => q({0} კილომეტრი),
						'per' => q({0} კილომეტრში),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(კილომეტრი),
						'one' => q({0} კილომეტრი),
						'other' => q({0} კილომეტრი),
						'per' => q({0} კილომეტრში),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(სინათლის წელი),
						'one' => q({0} სინათლის წელი),
						'other' => q({0} სინათლის წელი),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(სინათლის წელი),
						'one' => q({0} სინათლის წელი),
						'other' => q({0} სინათლის წელი),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(მეტრი),
						'one' => q({0} მეტრი),
						'other' => q({0} მეტრი),
						'per' => q({0} მეტრში),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(მეტრი),
						'one' => q({0} მეტრი),
						'other' => q({0} მეტრი),
						'per' => q({0} მეტრში),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(მიკრომეტრი),
						'one' => q({0} მიკრომეტრი),
						'other' => q({0} მიკრომეტრი),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(მიკრომეტრი),
						'one' => q({0} მიკრომეტრი),
						'other' => q({0} მიკრომეტრი),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(მილი),
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(მილი),
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(სკანდინავიური მილი),
						'one' => q({0} სკანდინავიური მილი),
						'other' => q({0} სკანდინავიური მილი),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(სკანდინავიური მილი),
						'one' => q({0} სკანდინავიური მილი),
						'other' => q({0} სკანდინავიური მილი),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(მილიმეტრი),
						'one' => q({0} მილიმეტრი),
						'other' => q({0} მილიმეტრი),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(მილიმეტრი),
						'one' => q({0} მილიმეტრი),
						'other' => q({0} მილიმეტრი),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(ნანომეტრი),
						'one' => q({0} ნანომეტრი),
						'other' => q({0} ნანომეტრი),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(ნანომეტრი),
						'one' => q({0} ნანომეტრი),
						'other' => q({0} ნანომეტრი),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(საზღვაო მილი),
						'one' => q({0} საზღვაო მილი),
						'other' => q({0} საზღვაო მილი),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(საზღვაო მილი),
						'one' => q({0} საზღვაო მილი),
						'other' => q({0} საზღვაო მილი),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(პარსეკი),
						'one' => q({0} პარსეკი),
						'other' => q({0} პარსეკი),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(პარსეკი),
						'one' => q({0} პარსეკი),
						'other' => q({0} პარსეკი),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(პიკომეტრი),
						'one' => q({0} პიკომეტრი),
						'other' => q({0} პიკომეტრი),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(პიკომეტრი),
						'one' => q({0} პიკომეტრი),
						'other' => q({0} პიკომეტრი),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(პუნქტი),
						'one' => q({0} პუნქტი),
						'other' => q({0} პუნქტი),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(პუნქტი),
						'one' => q({0} პუნქტი),
						'other' => q({0} პუნქტი),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(მზის რადიუსი),
						'one' => q({0} მზის რადიუსი),
						'other' => q({0} მზის რადიუსი),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(მზის რადიუსი),
						'one' => q({0} მზის რადიუსი),
						'other' => q({0} მზის რადიუსი),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(იარდი),
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(იარდი),
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(კანდელა),
						'one' => q({0} კანდელა),
						'other' => q({0} კანდელა),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(კანდელა),
						'one' => q({0} კანდელა),
						'other' => q({0} კანდელა),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ლუმენი),
						'one' => q({0} ლუმენი),
						'other' => q({0} ლუმენი),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ლუმენი),
						'one' => q({0} ლუმენი),
						'other' => q({0} ლუმენი),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(ლუქსი),
						'one' => q({0} ლუქსი),
						'other' => q({0} ლუქსი),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(ლუქსი),
						'one' => q({0} ლუქსი),
						'other' => q({0} ლუქსი),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(მზის სხივიერობა),
						'one' => q({0} მზის სხივიერობა),
						'other' => q({0} მზის სხივიერობა),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(მზის სხივიერობა),
						'one' => q({0} მზის სხივიერობა),
						'other' => q({0} მზის სხივიერობა),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(კარატი),
						'one' => q({0} კარატი),
						'other' => q({0} კარატი),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(კარატი),
						'one' => q({0} კარატი),
						'other' => q({0} კარატი),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(დალტონი),
						'one' => q({0} დალტონი),
						'other' => q({0} დალტონი),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(დალტონი),
						'one' => q({0} დალტონი),
						'other' => q({0} დალტონი),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(დედამიწის მასა),
						'one' => q({0} დედამიწის მასა),
						'other' => q({0} დედამიწის მასა),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(დედამიწის მასა),
						'one' => q({0} დედამიწის მასა),
						'other' => q({0} დედამიწის მასა),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(გრანი),
						'one' => q({0} გრანი),
						'other' => q({0} გრანი),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(გრანი),
						'one' => q({0} გრანი),
						'other' => q({0} გრანი),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(გრამი),
						'one' => q({0} გრამი),
						'other' => q({0} გრამი),
						'per' => q({0} გრამში),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(გრამი),
						'one' => q({0} გრამი),
						'other' => q({0} გრამი),
						'per' => q({0} გრამში),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(კილოგრამი),
						'one' => q({0} კილოგრამი),
						'other' => q({0} კილოგრამი),
						'per' => q({0} კილოგრამში),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(კილოგრამი),
						'one' => q({0} კილოგრამი),
						'other' => q({0} კილოგრამი),
						'per' => q({0} კილოგრამში),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(მეტრული ტონა),
						'one' => q({0} მეტრული ტონა),
						'other' => q({0} მეტრული ტონა),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(მეტრული ტონა),
						'one' => q({0} მეტრული ტონა),
						'other' => q({0} მეტრული ტონა),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(მიკროგრამი),
						'one' => q(მიკროგრამი),
						'other' => q({0} მიკროგრამი),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(მიკროგრამი),
						'one' => q(მიკროგრამი),
						'other' => q({0} მიკროგრამი),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(მილიგრამი),
						'one' => q({0} მილიგრამი),
						'other' => q({0} მილიგრამი),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(მილიგრამი),
						'one' => q({0} მილიგრამი),
						'other' => q({0} მილიგრამი),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(უნცია),
						'one' => q({0} უნცია),
						'other' => q({0} უნცია),
						'per' => q({0} უნციაში),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(უნცია),
						'one' => q({0} უნცია),
						'other' => q({0} უნცია),
						'per' => q({0} უნციაში),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ტრუას უნცია),
						'one' => q({0} ტრუას უნცია),
						'other' => q({0} ტრუას უნცია),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ტრუას უნცია),
						'one' => q({0} ტრუას უნცია),
						'other' => q({0} ტრუას უნცია),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(ფუნტი),
						'one' => q({0} ფუნტი),
						'other' => q({0} ფუნტი),
						'per' => q({0} ფუნტში),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(ფუნტი),
						'one' => q({0} ფუნტი),
						'other' => q({0} ფუნტი),
						'per' => q({0} ფუნტში),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(მზის მასა),
						'one' => q({0} მზის მასა),
						'other' => q({0} მზის მასა),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(მზის მასა),
						'one' => q({0} მზის მასა),
						'other' => q({0} მზის მასა),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(სტოუნი),
						'one' => q({0} სტოუნი),
						'other' => q({0} სტოუნი),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(სტოუნი),
						'one' => q({0} სტოუნი),
						'other' => q({0} სტოუნი),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ტონა),
						'one' => q({0} ტონა),
						'other' => q({0} ტ),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ტონა),
						'one' => q({0} ტონა),
						'other' => q({0} ტ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(გიგავატი),
						'one' => q({0} გიგავატი),
						'other' => q({0} გიგავატი),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(გიგავატი),
						'one' => q({0} გიგავატი),
						'other' => q({0} გიგავატი),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ცხენის ძალა),
						'one' => q({0} ცხენის ძალა),
						'other' => q({0} ცხენის ძალა),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ცხენის ძალა),
						'one' => q({0} ცხენის ძალა),
						'other' => q({0} ცხენის ძალა),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(კილოვატი),
						'one' => q({0} კილოვატი),
						'other' => q({0} კილოვატი),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(კილოვატი),
						'one' => q({0} კილოვატი),
						'other' => q({0} კილოვატი),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(მეგავატი),
						'one' => q({0} მეგავატი),
						'other' => q({0} მეგავატი),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(მეგავატი),
						'one' => q({0} მეგავატი),
						'other' => q({0} მეგავატი),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(მილივატი),
						'one' => q({0} მილივატი),
						'other' => q({0} მილივატი),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(მილივატი),
						'one' => q({0} მილივატი),
						'other' => q({0} მილივატი),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ვატი),
						'one' => q({0} ვატი),
						'other' => q({0} ვატი),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ვატი),
						'one' => q({0} ვატი),
						'other' => q({0} ვატი),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(კვადრატული {0}),
						'one' => q(კვადრატული {0}),
						'other' => q(კვადრატული {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(კვადრატული {0}),
						'one' => q(კვადრატული {0}),
						'other' => q(კვადრატული {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(კუბური {0}),
						'one' => q(კუბური {0}),
						'other' => q(კუბური {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(კუბური {0}),
						'one' => q(კუბური {0}),
						'other' => q(კუბური {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(ატმოსფეროები),
						'one' => q({0} ატმოსფერო),
						'other' => q({0} ატმოსფერო),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(ატმოსფეროები),
						'one' => q({0} ატმოსფერო),
						'other' => q({0} ატმოსფერო),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(ბარი),
						'one' => q({0} ბარი),
						'other' => q({0} ბარი),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(ბარი),
						'one' => q({0} ბარი),
						'other' => q({0} ბარი),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(ჰექტოპასკალი),
						'one' => q({0} ჰექტოპასკალი),
						'other' => q({0} ჰექტოპასკალი),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(ჰექტოპასკალი),
						'one' => q({0} ჰექტოპასკალი),
						'other' => q({0} ჰექტოპასკალი),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ვერცხლისწყლის დუიმი),
						'one' => q({0} ვერცხლისწყლის დუიმი),
						'other' => q({0} ვერცხლისწყლის დუიმი),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ვერცხლისწყლის დუიმი),
						'one' => q({0} ვერცხლისწყლის დუიმი),
						'other' => q({0} ვერცხლისწყლის დუიმი),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(კილოპასკალი),
						'one' => q({0} კილოპასკალი),
						'other' => q({0} კილოპასკალი),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(კილოპასკალი),
						'one' => q({0} კილოპასკალი),
						'other' => q({0} კილოპასკალი),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(მეგაპასკალი),
						'one' => q(მეგაპასკალი),
						'other' => q({0} მეგაპასკალი),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(მეგაპასკალი),
						'one' => q(მეგაპასკალი),
						'other' => q({0} მეგაპასკალი),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(მილიბარი),
						'one' => q({0} მილიბარი),
						'other' => q({0} მილიბარი),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(მილიბარი),
						'one' => q({0} მილიბარი),
						'other' => q({0} მილიბარი),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(მილიმეტრი ვერცხლისწყლის სვეტისა),
						'one' => q({0} მილიმეტრი ვერცხლისწყლის სვეტისა),
						'other' => q({0} მილიმეტრი ვერცხლისწყლის სვეტისა),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(მილიმეტრი ვერცხლისწყლის სვეტისა),
						'one' => q({0} მილიმეტრი ვერცხლისწყლის სვეტისა),
						'other' => q({0} მილიმეტრი ვერცხლისწყლის სვეტისა),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(პასკალი),
						'one' => q({0} პასკალი),
						'other' => q({0} პასკალი),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(პასკალი),
						'one' => q({0} პასკალი),
						'other' => q({0} პასკალი),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(ფუნტი კვადრატულ დუიმზე),
						'one' => q({0} ფუნტი კვადრატულ დუიმზე),
						'other' => q({0} ფუნტი კვადრატულ დუიმზე),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(ფუნტი კვადრატულ დუიმზე),
						'one' => q({0} ფუნტი კვადრატულ დუიმზე),
						'other' => q({0} ფუნტი კვადრატულ დუიმზე),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(კილომეტრი საათში),
						'one' => q({0} კილომეტრი საათში),
						'other' => q({0} კილომეტრი საათში),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(კილომეტრი საათში),
						'one' => q({0} კილომეტრი საათში),
						'other' => q({0} კილომეტრი საათში),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(კვანძი),
						'one' => q({0} კვანძი),
						'other' => q({0} კვანძი),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(კვანძი),
						'one' => q({0} კვანძი),
						'other' => q({0} კვანძი),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(მეტრი წამში),
						'one' => q({0} მეტრი წამში),
						'other' => q({0} მეტრი წამში),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(მეტრი წამში),
						'one' => q({0} მეტრი წამში),
						'other' => q({0} მეტრი წამში),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(მილი საათში),
						'one' => q({0} მილი საათში),
						'other' => q({0} მილი საათში),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(მილი საათში),
						'one' => q({0} მილი საათში),
						'other' => q({0} მილი საათში),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(გრადუსი ცელსიუსით),
						'one' => q({0} გრადუსი ცელსიუსით),
						'other' => q({0} გრადუსი ცელსიუსით),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(გრადუსი ცელსიუსით),
						'one' => q({0} გრადუსი ცელსიუსით),
						'other' => q({0} გრადუსი ცელსიუსით),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(გრადუსი ფარენჰეიტით),
						'one' => q({0} გრადუსი ფარენჰეიტით),
						'other' => q({0} გრადუსი ფარენჰეიტით),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(გრადუსი ფარენჰეიტით),
						'one' => q({0} გრადუსი ფარენჰეიტით),
						'other' => q({0} გრადუსი ფარენჰეიტით),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(კელვინის გრადუსი),
						'one' => q({0} კელვინი),
						'other' => q({0} კელვინის გრადუსი),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(კელვინის გრადუსი),
						'one' => q({0} კელვინი),
						'other' => q({0} კელვინის გრადუსი),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ნიუტონ-მეტრი),
						'one' => q({0} ნიუტონ-მეტრი),
						'other' => q({0} ნიუტონ-მეტრი),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ნიუტონ-მეტრი),
						'one' => q({0} ნიუტონ-მეტრი),
						'other' => q({0} ნიუტონ-მეტრი),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(ფუნტი-ფუტი),
						'one' => q({0} ფუნტი-ფუტი),
						'other' => q({0} ფუნტი-ფუტი),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(ფუნტი-ფუტი),
						'one' => q({0} ფუნტი-ფუტი),
						'other' => q({0} ფუნტი-ფუტი),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(აკრი-ფუტი),
						'one' => q({0} აკრი-ფუტი),
						'other' => q({0} აკრი-ფუტი),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(აკრი-ფუტი),
						'one' => q({0} აკრი-ფუტი),
						'other' => q({0} აკრი-ფუტი),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(ბარელი),
						'one' => q({0} ბარელი),
						'other' => q({0} ბარელი),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(ბარელი),
						'one' => q({0} ბარელი),
						'other' => q({0} ბარელი),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(ბუშელი),
						'one' => q({0} ბუშელი),
						'other' => q({0} ბუშელი),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(ბუშელი),
						'one' => q({0} ბუშელი),
						'other' => q({0} ბუშელი),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(სანტილიტრი),
						'one' => q({0} სანტილიტრი),
						'other' => q({0} სანტილიტრი),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(სანტილიტრი),
						'one' => q({0} სანტილიტრი),
						'other' => q({0} სანტილიტრი),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(კუბური სანტიმენტრი),
						'one' => q({0} კუბური სანტიმენტრი),
						'other' => q({0} კუბური სანტიმენტრი),
						'per' => q({0} კუბურ სანტიმეტრში),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(კუბური სანტიმენტრი),
						'one' => q({0} კუბური სანტიმენტრი),
						'other' => q({0} კუბური სანტიმენტრი),
						'per' => q({0} კუბურ სანტიმეტრში),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(კუბური ფუტი),
						'one' => q({0} კუბური ფუტი),
						'other' => q({0} კუბური ფუტი),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(კუბური ფუტი),
						'one' => q({0} კუბური ფუტი),
						'other' => q({0} კუბური ფუტი),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(კუბური დუიმი),
						'one' => q({0} კუბური დუიმი),
						'other' => q({0} კუბური დუიმი),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(კუბური დუიმი),
						'one' => q({0} კუბური დუიმი),
						'other' => q({0} კუბური დუიმი),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(კუბური კილომეტრი),
						'one' => q({0} კუბური კილომეტრი),
						'other' => q({0} კუბური კილომეტრი),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(კუბური კილომეტრი),
						'one' => q({0} კუბური კილომეტრი),
						'other' => q({0} კუბური კილომეტრი),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(კუბური მეტრი),
						'one' => q({0} კუბური მეტრი),
						'other' => q({0} კუბური მეტრი),
						'per' => q({0} კუბურ მეტრში),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(კუბური მეტრი),
						'one' => q({0} კუბური მეტრი),
						'other' => q({0} კუბური მეტრი),
						'per' => q({0} კუბურ მეტრში),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(კუბური მილი),
						'one' => q({0} კუბური მილი),
						'other' => q({0} კუბური მილი),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(კუბური მილი),
						'one' => q({0} კუბური მილი),
						'other' => q({0} კუბური მილი),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(კუბური იარდი),
						'one' => q({0} კუბური იარდი),
						'other' => q({0} კუბური იარდი),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(კუბური იარდი),
						'one' => q({0} კუბური იარდი),
						'other' => q({0} კუბური იარდი),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(ჭიქა),
						'one' => q({0} ჭიქა),
						'other' => q({0} ჭიქა),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(ჭიქა),
						'one' => q({0} ჭიქა),
						'other' => q({0} ჭიქა),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(მეტრული ჭიქა),
						'one' => q({0} მეტრული ჭიქა),
						'other' => q({0} მეტრული ჭიქა),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(მეტრული ჭიქა),
						'one' => q({0} მეტრული ჭიქა),
						'other' => q({0} მეტრული ჭიქა),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(დეცილიტრი),
						'one' => q({0} დეცილიტრი),
						'other' => q({0} დეცილიტრი),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(დეცილიტრი),
						'one' => q({0} დეცილიტრი),
						'other' => q({0} დეცილიტრი),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(დესერტის კოვზი),
						'one' => q({0} დესერტის კოვზი),
						'other' => q({0} დესერტის კოვზი),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(დესერტის კოვზი),
						'one' => q({0} დესერტის კოვზი),
						'other' => q({0} დესერტის კოვზი),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(ბრიტ. დესერტის კოვზი),
						'one' => q({0} ბრიტ. დესერტის კოვზი),
						'other' => q({0} ბრიტ. დესერტის კოვზი),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(ბრიტ. დესერტის კოვზი),
						'one' => q({0} ბრიტ. დესერტის კოვზი),
						'other' => q({0} ბრიტ. დესერტის კოვზი),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ბრიტანული თხევადი დრაქმა),
						'one' => q({0} ბრიტანული თხევადი დრაქმა),
						'other' => q({0} ბრიტანული თხევადი დრაქმა),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ბრიტანული თხევადი დრაქმა),
						'one' => q({0} ბრიტანული თხევადი დრაქმა),
						'other' => q({0} ბრიტანული თხევადი დრაქმა),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(წვეთი),
						'one' => q({0} წვეთი),
						'other' => q({0} წვეთი),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(წვეთი),
						'one' => q({0} წვეთი),
						'other' => q({0} წვეთი),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(თხევადი უნცია),
						'one' => q({0} თხევადი უნცია),
						'other' => q({0} თხევადი უნცია),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(თხევადი უნცია),
						'one' => q({0} თხევადი უნცია),
						'other' => q({0} თხევადი უნცია),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(ბრიტ. თხევადი უნცია),
						'one' => q({0} ბრიტ. თხევადი უნცია),
						'other' => q({0} ბრიტ. თხევადი უნცია),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(ბრიტ. თხევადი უნცია),
						'one' => q({0} ბრიტ. თხევადი უნცია),
						'other' => q({0} ბრიტ. თხევადი უნცია),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(გალონი),
						'one' => q({0} გალონი),
						'other' => q({0} გალონი),
						'per' => q({0} გალონში),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(გალონი),
						'one' => q({0} გალონი),
						'other' => q({0} გალონი),
						'per' => q({0} გალონში),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(იმპ. გალონი),
						'one' => q({0} იმპ. გალონი),
						'other' => q({0} იმპ. გალონი),
						'per' => q({0}/იმპ. გალ.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(იმპ. გალონი),
						'one' => q({0} იმპ. გალონი),
						'other' => q({0} იმპ. გალონი),
						'per' => q({0}/იმპ. გალ.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(ჰექტოლიტრი),
						'one' => q({0} ჰექტოლიტრი),
						'other' => q({0} ჰექტოლიტრი),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(ჰექტოლიტრი),
						'one' => q({0} ჰექტოლიტრი),
						'other' => q({0} ჰექტოლიტრი),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(ჯიგერი),
						'one' => q({0} ჯიგერი),
						'other' => q({0} ჯიგერი),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(ჯიგერი),
						'one' => q({0} ჯიგერი),
						'other' => q({0} ჯიგერი),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ლიტრი),
						'one' => q({0} ლიტრი),
						'other' => q({0} ლიტრი),
						'per' => q({0} ლიტრში),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ლიტრი),
						'one' => q({0} ლიტრი),
						'other' => q({0} ლიტრი),
						'per' => q({0} ლიტრში),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(მეგალიტრი),
						'one' => q({0} მეგალიტრი),
						'other' => q({0} მეგალიტრი),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(მეგალიტრი),
						'one' => q({0} მეგალიტრი),
						'other' => q({0} მეგალიტრი),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(მილილიტრი),
						'one' => q({0} მილილიტრი),
						'other' => q({0} მილილიტრი),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(მილილიტრი),
						'one' => q({0} მილილიტრი),
						'other' => q({0} მილილიტრი),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(მწიკვი),
						'one' => q({0} მწიკვი),
						'other' => q({0} მწიკვი),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(მწიკვი),
						'one' => q({0} მწიკვი),
						'other' => q({0} მწიკვი),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(პინტა),
						'one' => q({0} პინტა),
						'other' => q({0} პინტა),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(პინტა),
						'one' => q({0} პინტა),
						'other' => q({0} პინტა),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(მეტრული პინტა),
						'one' => q({0} მეტრული პინტა),
						'other' => q({0} მეტრული პინტა),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(მეტრული პინტა),
						'one' => q({0} მეტრული პინტა),
						'other' => q({0} მეტრული პინტა),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(კვარტა),
						'one' => q({0} კვარტა),
						'other' => q({0} კვარტა),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(კვარტა),
						'one' => q({0} კვარტა),
						'other' => q({0} კვარტა),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(ბრიტანული კვარტი),
						'one' => q({0} ბრიტანული კვარტი),
						'other' => q({0} ბრიტანული კვარტი),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(ბრიტანული კვარტი),
						'one' => q({0} ბრიტანული კვარტი),
						'other' => q({0} ბრიტანული კვარტი),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(სუფრის კოვზი),
						'one' => q({0} სუფრის კოვზი),
						'other' => q({0} სუფრის კოვზი),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(სუფრის კოვზი),
						'one' => q({0} სუფრის კოვზი),
						'other' => q({0} სუფრის კოვზი),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ჩაის კოვზი),
						'one' => q({0} ჩაის კოვზი),
						'other' => q({0} ჩაის კოვზი),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ჩაის კოვზი),
						'one' => q({0} ჩაის კოვზი),
						'other' => q({0} ჩაის კოვზი),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(მიმართულება),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(მიმართულება),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(კი{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(კი{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(მე{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(მე{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(გი{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(გი{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(ტე{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(ტე{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(პე{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(პე{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ექს{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ექს{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(ზე{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(ზე{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(იო{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(იო{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(დ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(დ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(პკ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(პკ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ფ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ფ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ა{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ა{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(ს{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(ს{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ზეპტო{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ზეპტო{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(იოქტო{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(იოქტო{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(მ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(მ{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(მკ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(მკ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ნ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ნ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(დეკა{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(დეკა{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ტ{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ტ{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(პტ{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(პტ{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ექსა{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ექსა{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ჰ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ჰ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(ზეტა{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(ზეტა{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(ი{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(ი{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(კ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(კ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(გ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(გ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} ინ. ძ.),
						'other' => q({0} ინ. ძ.),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} ინ. ძ.),
						'other' => q({0} ინ. ძ.),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0} წთ),
						'other' => q({0} წთ),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0} წთ),
						'other' => q({0} წთ),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0} წმ),
						'other' => q({0} წმ),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0} წმ),
						'other' => q({0} წმ),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} ჰა),
						'other' => q({0} ჰა),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} ჰა),
						'other' => q({0} ჰა),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} ფტ²),
						'other' => q({0} ფტ²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} ფტ²),
						'other' => q({0} ფტ²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0} კმ²),
						'other' => q({0} კმ²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0} კმ²),
						'other' => q({0} კმ²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0} მ²),
						'other' => q({0} მ²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0} მ²),
						'other' => q({0} მ²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} მილი²),
						'other' => q({0} მილი²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} მილი²),
						'other' => q({0} მილი²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'one' => q({0} ერთეული),
						'other' => q({0} ერთეული),
					},
					# Core Unit Identifier
					'item' => {
						'one' => q({0} ერთეული),
						'other' => q({0} ერთეული),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ლ/100კმ),
						'one' => q({0}ლ/100კმ),
						'other' => q({0}ლ/100კმ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ლ/100კმ),
						'one' => q({0}ლ/100კმ),
						'other' => q({0}ლ/100კმ),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}აღმ.),
						'north' => q({0}ჩრდ.),
						'south' => q({0} სამხრ.),
						'west' => q({0} დას.),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}აღმ.),
						'north' => q({0}ჩრდ.),
						'south' => q({0} სამხრ.),
						'west' => q({0} დას.),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(დღე),
						'one' => q({0} დღე),
						'other' => q({0} დღე),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(დღე),
						'one' => q({0} დღე),
						'other' => q({0} დღე),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(საათი),
						'one' => q({0}სთ),
						'other' => q({0}სთ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(საათი),
						'one' => q({0}სთ),
						'other' => q({0}სთ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(მწმ),
						'one' => q({0} მწმ),
						'other' => q({0} მწმ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(მწმ),
						'one' => q({0} მწმ),
						'other' => q({0} მწმ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(წთ),
						'one' => q({0}წთ),
						'other' => q({0}წთ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(წთ),
						'one' => q({0}წთ),
						'other' => q({0}წთ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(თვე),
						'one' => q({0} თვე),
						'other' => q({0} თვე),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(თვე),
						'one' => q({0} თვე),
						'other' => q({0} თვე),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(წმ),
						'one' => q({0}წმ),
						'other' => q({0}წმ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(წმ),
						'one' => q({0}წმ),
						'other' => q({0}წმ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(კვრ),
						'one' => q({0} კვრ),
						'other' => q({0} კვრ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(კვრ),
						'one' => q({0} კვრ),
						'other' => q({0} კვრ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(წ),
						'one' => q({0} წ),
						'other' => q({0} წ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(წ),
						'one' => q({0} წ),
						'other' => q({0} წ),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'one' => q({0} კვტსთ/100კმ),
						'other' => q({0} კვტსთ/100კმ),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'one' => q({0} კვტსთ/100კმ),
						'other' => q({0} კვტსთ/100კმ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(სმ),
						'one' => q({0} სმ),
						'other' => q({0} სმ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(სმ),
						'one' => q({0} სმ),
						'other' => q({0} სმ),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0} ფტ),
						'other' => q({0} ფტ),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0} ფტ),
						'other' => q({0} ფტ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0} დმ),
						'other' => q({0} დმ),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0} დმ),
						'other' => q({0} დმ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(კმ),
						'one' => q({0} კმ),
						'other' => q({0} კმ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(კმ),
						'one' => q({0} კმ),
						'other' => q({0} კმ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0} სწ),
						'other' => q({0} სწ),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0} სწ),
						'other' => q({0} სწ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(მ),
						'one' => q({0}მ),
						'other' => q({0}მ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(მ),
						'one' => q({0}მ),
						'other' => q({0}მ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(მმ),
						'one' => q({0} მმ),
						'other' => q({0} მმ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(მმ),
						'one' => q({0} მმ),
						'other' => q({0} მმ),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'one' => q({0} პმ),
						'other' => q({0} პმ),
					},
					# Core Unit Identifier
					'picometer' => {
						'one' => q({0} პმ),
						'other' => q({0} პმ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					# Core Unit Identifier
					'yard' => {
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(გრამი),
						'one' => q({0}გ),
						'other' => q({0}გ),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(გრამი),
						'one' => q({0}გ),
						'other' => q({0}გ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(კგ),
						'one' => q({0}კგ),
						'other' => q({0}კგ),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(კგ),
						'one' => q({0}კგ),
						'other' => q({0}კგ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0} უნც),
						'other' => q({0} უნც),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0} უნც),
						'other' => q({0} უნც),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0} ფნტ),
						'other' => q({0} ფნტ),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0} ფნტ),
						'other' => q({0} ფნტ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0}ცხ.ძ.),
						'other' => q({0}ცხ.ძ.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0}ცხ.ძ.),
						'other' => q({0}ცხ.ძ.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0} კვტ),
						'other' => q({0} კვტ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0} კვტ),
						'other' => q({0} კვტ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} ვტ),
						'other' => q({0} ვტ),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} ვტ),
						'other' => q({0} ვტ),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q({0}³),
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q({0}³),
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0} ჰპა),
						'other' => q({0} ჰპა),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0} ჰპა),
						'other' => q({0} ჰპა),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0} ვრც. დმ.),
						'other' => q({0} ვრც. დმ.),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0} ვრც. დმ.),
						'other' => q({0} ვრც. დმ.),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0} მბრ),
						'other' => q({0} მბრ),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0} მბრ),
						'other' => q({0} მბრ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(კმ/სთ),
						'one' => q({0} კმ/სთ),
						'other' => q({0} კმ/სთ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(კმ/სთ),
						'one' => q({0} კმ/სთ),
						'other' => q({0} კმ/სთ),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0} მ/წმ),
						'other' => q({0} მ/წმ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0} მ/წმ),
						'other' => q({0} მ/წმ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0} მილი/სთ),
						'other' => q({0} მილი/სთ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0} მილი/სთ),
						'other' => q({0} მილი/სთ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0} კმ³),
						'other' => q({0} კმ³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0} კმ³),
						'other' => q({0} კმ³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0} მილი³),
						'other' => q({0} მილი³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0} მილი³),
						'other' => q({0} მილი³),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ლიტრი),
						'one' => q({0}ლ),
						'other' => q({0}ლ),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ლიტრი),
						'one' => q({0}ლ),
						'other' => q({0}ლ),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(მიმართულება),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(მიმართულება),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(კი{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(კი{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(მე{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(მე{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(გი{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(გი{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(ტე{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(ტე{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(პე{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(პე{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ექს{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ექს{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(ზე{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(ზე{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(იო{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(იო{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(დ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(დ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(პკ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(პკ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ფ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ფ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ა{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ა{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(ს{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(ს{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ზეპტო{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ზეპტო{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(იოქტო{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(იოქტო{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(მ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(მ{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(მკ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(მკ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ნ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ნ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(დეკა{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(დეკა{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ტ{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ტ{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(პტ{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(პტ{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ექსა{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ექსა{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ჰ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ჰ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(ზეტა{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(ზეტა{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(ი{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(ი{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(კ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(კ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(გ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(გ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ინ. ძ.),
						'one' => q({0} ინ. ძ.),
						'other' => q({0} ინ. ძ.),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ინ. ძ.),
						'one' => q({0} ინ. ძ.),
						'other' => q({0} ინ. ძ.),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(მ/წმ²),
						'one' => q({0} მ/წმ²),
						'other' => q({0} მ/წმ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(მ/წმ²),
						'one' => q({0} მ/წმ²),
						'other' => q({0} მ/წმ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(მინუტი),
						'one' => q({0} მინუტი),
						'other' => q({0} მინუტი),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(მინუტი),
						'one' => q({0} მინუტი),
						'other' => q({0} მინუტი),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(სეკუნდი),
						'one' => q({0} სეკუნდი),
						'other' => q({0} სეკუნდი),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(სეკუნდი),
						'one' => q({0} სეკუნდი),
						'other' => q({0} სეკუნდი),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(გრადუსი),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(გრადუსი),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(რადიანი),
						'one' => q({0} რად.),
						'other' => q({0} რად.),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(რადიანი),
						'one' => q({0} რად.),
						'other' => q({0} რად.),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(ბრნ.),
						'one' => q({0} ბრნ.),
						'other' => q({0} ბრნ.),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(ბრნ.),
						'one' => q({0} ბრნ.),
						'other' => q({0} ბრნ.),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(აკრი),
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(აკრი),
						'one' => q({0} აკრი),
						'other' => q({0} აკრი),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(დუნამი),
						'one' => q({0} დუნამი),
						'other' => q({0} დუნამი),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(დუნამი),
						'one' => q({0} დუნამი),
						'other' => q({0} დუნამი),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ჰა),
						'one' => q({0} ჰა),
						'other' => q({0} ჰა),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ჰა),
						'one' => q({0} ჰა),
						'other' => q({0} ჰა),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(სმ²),
						'one' => q({0} სმ²),
						'other' => q({0} სმ²),
						'per' => q({0}/სმ²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(სმ²),
						'one' => q({0} სმ²),
						'other' => q({0} სმ²),
						'per' => q({0}/სმ²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ფუტი²),
						'one' => q({0} ფტ²),
						'other' => q({0} ფტ²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ფუტი²),
						'one' => q({0} ფტ²),
						'other' => q({0} ფტ²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(დუიმი²),
						'one' => q({0} დუიმი²),
						'other' => q({0} დუიმი²),
						'per' => q({0}/დუიმი²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(დუიმი²),
						'one' => q({0} დუიმი²),
						'other' => q({0} დუიმი²),
						'per' => q({0}/დუიმი²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(კმ²),
						'one' => q({0} კმ²),
						'other' => q({0} კმ²),
						'per' => q({0}/კმ²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(კმ²),
						'one' => q({0} კმ²),
						'other' => q({0} კმ²),
						'per' => q({0}/კმ²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(მ²),
						'one' => q({0} მ²),
						'other' => q({0} მ²),
						'per' => q({0}/მ²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(მ²),
						'one' => q({0} მ²),
						'other' => q({0} მ²),
						'per' => q({0}/მ²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(მილი²),
						'one' => q({0} მილი²),
						'other' => q({0} მილი²),
						'per' => q({0}/მილი²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(მილი²),
						'one' => q({0} მილი²),
						'other' => q({0} მილი²),
						'per' => q({0}/მილი²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(იარდი²),
						'one' => q({0} იარდი²),
						'other' => q({0} იარდი²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(იარდი²),
						'one' => q({0} იარდი²),
						'other' => q({0} იარდი²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ერთეული),
						'one' => q({0} ერთეული),
						'other' => q({0} ერთეული),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ერთეული),
						'one' => q({0} ერთეული),
						'other' => q({0} ერთეული),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(კარატი),
						'one' => q({0} კარ.),
						'other' => q({0} კარ.),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(კარატი),
						'one' => q({0} კარ.),
						'other' => q({0} კარ.),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(მგ/დლ),
						'one' => q({0} მგ/დლ),
						'other' => q({0} მგ/დლ),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(მგ/დლ),
						'one' => q({0} მგ/დლ),
						'other' => q({0} მგ/დლ),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(მმოლ/ლ),
						'one' => q({0} მმოლ/ლ),
						'other' => q({0} მმოლ/ლ),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(მმოლ/ლ),
						'one' => q({0} მმოლ/ლ),
						'other' => q({0} მმოლ/ლ),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(‰),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(‰),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ნაწილი/მილიონზე),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ნაწილი/მილიონზე),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ლ/100კმ),
						'one' => q({0} ლ/100კმ),
						'other' => q({0} ლ/100კმ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ლ/100კმ),
						'one' => q({0} ლ/100კმ),
						'other' => q({0} ლ/100კმ),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ლიტრი/კმ),
						'one' => q({0} ლ/კმ),
						'other' => q({0} ლ/კმ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ლიტრი/კმ),
						'one' => q({0} ლ/კმ),
						'other' => q({0} ლ/კმ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(მილი/გალ.),
						'one' => q({0} მილი/გალ.),
						'other' => q({0} მილი/გალ.),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(მილი/გალ.),
						'one' => q({0} მილი/გალ.),
						'other' => q({0} მილი/გალ.),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(მილი/იმპ. გალონზე),
						'one' => q({0} მილი/იმპ. გალონზე),
						'other' => q({0} მილი/იმპ. გალონზე),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(მილი/იმპ. გალონზე),
						'one' => q({0} მილი/იმპ. გალონზე),
						'other' => q({0} მილი/იმპ. გალონზე),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}აღმ.),
						'north' => q({0}ჩრდ.),
						'south' => q({0} სამხრ.),
						'west' => q({0} დას.),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}აღმ.),
						'north' => q({0}ჩრდ.),
						'south' => q({0} სამხრ.),
						'west' => q({0} დას.),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(ბიტი),
						'one' => q({0} ბიტი),
						'other' => q({0} ბიტი),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(ბიტი),
						'one' => q({0} ბიტი),
						'other' => q({0} ბიტი),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(ბაიტი),
						'one' => q({0} ბაიტი),
						'other' => q({0} ბაიტი),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(ბაიტი),
						'one' => q({0} ბაიტი),
						'other' => q({0} ბაიტი),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(გბიტი),
						'one' => q({0} გბიტი),
						'other' => q({0} გბიტი),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(გბიტი),
						'one' => q({0} გბიტი),
						'other' => q({0} გბიტი),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(კბიტი),
						'one' => q({0} კბიტი),
						'other' => q({0} კბიტი),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(კბიტი),
						'one' => q({0} კბიტი),
						'other' => q({0} კბიტი),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(კილობაიტი),
						'one' => q({0} კბაიტი),
						'other' => q({0} კბაიტი),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(კილობაიტი),
						'one' => q({0} კბაიტი),
						'other' => q({0} კბაიტი),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(მბიტი),
						'one' => q({0} მბიტი),
						'other' => q({0} მბიტი),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(მბიტი),
						'one' => q({0} მბიტი),
						'other' => q({0} მბიტი),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(პბაიტი),
						'one' => q({0} პბაიტი),
						'other' => q({0} პბაიტი),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(პბაიტი),
						'one' => q({0} პბაიტი),
						'other' => q({0} პბაიტი),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ტბიტი),
						'one' => q({0} ტბიტი),
						'other' => q({0} ტბიტი),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ტბიტი),
						'one' => q({0} ტბიტი),
						'other' => q({0} ტბიტი),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ტბაიტი),
						'one' => q({0} ტბაიტი),
						'other' => q({0} ტბაიტი),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ტბაიტი),
						'one' => q({0} ტბაიტი),
						'other' => q({0} ტბაიტი),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ს.),
						'one' => q({0} ს.),
						'other' => q({0} ს.),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ს.),
						'one' => q({0} ს.),
						'other' => q({0} ს.),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(დღე),
						'one' => q({0} დღე),
						'other' => q({0} დღე),
						'per' => q({0}/დღე),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(დღე),
						'one' => q({0} დღე),
						'other' => q({0} დღე),
						'per' => q({0}/დღე),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(დეკადა),
						'one' => q({0} დეკადა),
						'other' => q({0} დეკადა),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(დეკადა),
						'one' => q({0} დეკადა),
						'other' => q({0} დეკადა),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(სთ),
						'one' => q({0} სთ),
						'other' => q({0} სთ),
						'per' => q({0}/სთ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(სთ),
						'one' => q({0} სთ),
						'other' => q({0} სთ),
						'per' => q({0}/სთ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(მკწმ),
						'one' => q({0} მკწმ),
						'other' => q({0} მკწმ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(მკწმ),
						'one' => q({0} მკწმ),
						'other' => q({0} მკწმ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(მწმ),
						'one' => q({0} მწმ),
						'other' => q({0} მწმ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(მწმ),
						'one' => q({0} მწმ),
						'other' => q({0} მწმ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(წთ),
						'one' => q({0} წთ),
						'other' => q({0} წთ),
						'per' => q({0}/წთ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(წთ),
						'one' => q({0} წთ),
						'other' => q({0} წთ),
						'per' => q({0}/წთ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(თვე),
						'one' => q({0} თვე),
						'other' => q({0} თვე),
						'per' => q({0}/თვე),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(თვე),
						'one' => q({0} თვე),
						'other' => q({0} თვე),
						'per' => q({0}/თვე),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ნწმ),
						'one' => q({0} ნწმ),
						'other' => q({0} ნწმ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ნწმ),
						'one' => q({0} ნწმ),
						'other' => q({0} ნწმ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(წმ),
						'one' => q({0} წმ),
						'other' => q({0} წმ),
						'per' => q({0}/წმ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(წმ),
						'one' => q({0} წმ),
						'other' => q({0} წმ),
						'per' => q({0}/წმ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(კვრ),
						'one' => q({0} კვრ),
						'other' => q({0} კვრ),
						'per' => q({0}/კვრ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(კვრ),
						'one' => q({0} კვრ),
						'other' => q({0} კვრ),
						'per' => q({0}/კვრ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(წ),
						'one' => q({0} წ),
						'other' => q({0} წ),
						'per' => q({0}/წ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(წ),
						'one' => q({0} წ),
						'other' => q({0} წ),
						'per' => q({0}/წ),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ამპ),
						'one' => q({0} ა),
						'other' => q({0} ა),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ამპ),
						'one' => q({0} ა),
						'other' => q({0} ა),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(მილიამპ.),
						'one' => q({0} მამპ.),
						'other' => q({0} მამპ.),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(მილიამპ.),
						'one' => q({0} მამპ.),
						'other' => q({0} მამპ.),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ომი),
						'one' => q({0} ომ),
						'other' => q({0} ომ),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ომი),
						'one' => q({0} ომ),
						'other' => q({0} ომ),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ვოლტი),
						'one' => q({0} ვ),
						'other' => q({0} ვ),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ვოლტი),
						'one' => q({0} ვ),
						'other' => q({0} ვ),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(ბსე),
						'one' => q({0} ბსე),
						'other' => q({0} ბსე),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(ბსე),
						'one' => q({0} ბსე),
						'other' => q({0} ბსე),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(კალ),
						'one' => q({0} კალ),
						'other' => q({0} კალ),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(კალ),
						'one' => q({0} კალ),
						'other' => q({0} კალ),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ევ),
						'one' => q({0} ევ),
						'other' => q({0} ევ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ევ),
						'one' => q({0} ევ),
						'other' => q({0} ევ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(კალ),
						'one' => q({0} კალ),
						'other' => q({0} კალ),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(კალ),
						'one' => q({0} კალ),
						'other' => q({0} კალ),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(ჯოული),
						'one' => q({0} ჯ),
						'other' => q({0} ჯ),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(ჯოული),
						'one' => q({0} ჯ),
						'other' => q({0} ჯ),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(კკალ),
						'one' => q({0} კკალ),
						'other' => q({0} კკალ),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(კკალ),
						'one' => q({0} კკალ),
						'other' => q({0} კკალ),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(კჯ),
						'one' => q({0} კჯ),
						'other' => q({0} კჯ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(კჯ),
						'one' => q({0} კჯ),
						'other' => q({0} კჯ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(კვტსთ),
						'one' => q({0} კვტსთ),
						'other' => q({0} კვტსთ),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(კვტსთ),
						'one' => q({0} კვტსთ),
						'other' => q({0} კვტსთ),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(აშშ თერმი),
						'one' => q({0} აშშ თერმი),
						'other' => q({0} აშშ თერმი),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(აშშ თერმი),
						'one' => q({0} აშშ თერმი),
						'other' => q({0} აშშ თერმი),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(კვტსთ/100კმ),
						'one' => q({0} კვტსთ/100კმ),
						'other' => q({0} კვტსთ/100კმ),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(კვტსთ/100კმ),
						'one' => q({0} კვტსთ/100კმ),
						'other' => q({0} კვტსთ/100კმ),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(გჰც.),
						'one' => q({0} გჰც.),
						'other' => q({0} გჰც.),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(გჰც.),
						'one' => q({0} გჰც.),
						'other' => q({0} გჰც.),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(ჰც.),
						'one' => q({0} ჰც.),
						'other' => q({0} ჰც.),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(ჰც.),
						'one' => q({0} ჰც.),
						'other' => q({0} ჰც.),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(კჰც.),
						'one' => q({0} კჰც.),
						'other' => q({0} კჰც.),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(კჰც.),
						'one' => q({0} კჰც.),
						'other' => q({0} კჰც.),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(მჰც),
						'one' => q({0} მჰც),
						'other' => q({0} მჰც),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(მჰც),
						'one' => q({0} მჰც),
						'other' => q({0} მჰც),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(წერტილი),
						'one' => q({0} წერტილი),
						'other' => q({0} წერტილი),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(წერტილი),
						'one' => q({0} წერტილი),
						'other' => q({0} წერტილი),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(წერტ/სმ-ზე),
						'one' => q({0} წერტ/სმ-ზე),
						'other' => q({0} წერტ/სმ-ზე),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(წერტ/სმ-ზე),
						'one' => q({0} წერტ/სმ-ზე),
						'other' => q({0} წერტ/სმ-ზე),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(წერტ/დუიმზე),
						'one' => q({0} წერტ/დუიმზე),
						'other' => q({0} წერტ/დუიმზე),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(წერტ/დუიმზე),
						'one' => q({0} წერტ/დუიმზე),
						'other' => q({0} წერტ/დუიმზე),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(ემი),
						'one' => q({0} ემი),
						'other' => q({0} ემი),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(ემი),
						'one' => q({0} ემი),
						'other' => q({0} ემი),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(მპქს),
						'one' => q({0} მპქს),
						'other' => q({0} მპქს),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(მპქს),
						'one' => q({0} მპქს),
						'other' => q({0} მპქს),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(პქს),
						'one' => q({0} პქს),
						'other' => q({0} პქს),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(პქს),
						'one' => q({0} პქს),
						'other' => q({0} პქს),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(პქს/სმ-ზე),
						'one' => q({0} პქს/სმ-ზე),
						'other' => q({0} პქს/სმ-ზე),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(პქს/სმ-ზე),
						'one' => q({0} პქს/სმ-ზე),
						'other' => q({0} პქს/სმ-ზე),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(პიქს/დუიმზე),
						'one' => q({0} პიქს/დუიმზე),
						'other' => q({0} პიქს/დუიმზე),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(პიქს/დუიმზე),
						'one' => q({0} პიქს/დუიმზე),
						'other' => q({0} პიქს/დუიმზე),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ა.ე.),
						'one' => q({0} ა.ე.),
						'other' => q({0} ა.ე.),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ა.ე.),
						'one' => q({0} ა.ე.),
						'other' => q({0} ა.ე.),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(სმ),
						'one' => q({0} სმ),
						'other' => q({0} სმ),
						'per' => q({0}/სმ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(სმ),
						'one' => q({0} სმ),
						'other' => q({0} სმ),
						'per' => q({0}/სმ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(დმ),
						'one' => q({0} დმ),
						'other' => q({0} დმ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(დმ),
						'one' => q({0} დმ),
						'other' => q({0} დმ),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(⊕ რადიუსი),
						'one' => q({0} ⊕ რადიუსი),
						'other' => q({0} ⊕ რადიუსი),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(⊕ რადიუსი),
						'one' => q({0} ⊕ რადიუსი),
						'other' => q({0} ⊕ რადიუსი),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ფატომი),
						'one' => q({0} ფატომი),
						'other' => q({0} ფატომი),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ფატომი),
						'one' => q({0} ფატომი),
						'other' => q({0} ფატომი),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ფტ),
						'one' => q({0} ფტ),
						'other' => q({0} ფტ),
						'per' => q({0}/ფტ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ფტ),
						'one' => q({0} ფტ),
						'other' => q({0} ფტ),
						'per' => q({0}/ფტ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(ფურლონგი),
						'one' => q({0} ფურლონგი),
						'other' => q({0} ფურლონგი),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(ფურლონგი),
						'one' => q({0} ფურლონგი),
						'other' => q({0} ფურლონგი),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(დუიმი),
						'one' => q({0} დუიმი),
						'other' => q({0} დუიმი),
						'per' => q({0}/დუიმი),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(დუიმი),
						'one' => q({0} დუიმი),
						'other' => q({0} დუიმი),
						'per' => q({0}/დუიმი),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(კმ),
						'one' => q({0} კმ),
						'other' => q({0} კმ),
						'per' => q({0}/კმ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(კმ),
						'one' => q({0} კმ),
						'other' => q({0} კმ),
						'per' => q({0}/კმ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(სწ),
						'one' => q({0} სწ),
						'other' => q({0} სწ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(სწ),
						'one' => q({0} სწ),
						'other' => q({0} სწ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(მ),
						'one' => q({0} მ),
						'other' => q({0} მ),
						'per' => q({0}/მ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(მ),
						'one' => q({0} მ),
						'other' => q({0} მ),
						'per' => q({0}/მ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(მკმ),
						'one' => q({0} მკმ),
						'other' => q({0} მკმ),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(მკმ),
						'one' => q({0} მკმ),
						'other' => q({0} მკმ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(მილი),
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(მილი),
						'one' => q({0} მილი),
						'other' => q({0} მილი),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(სკანდ. მილი),
						'one' => q({0} სკანდ. მილი),
						'other' => q({0} სკანდ. მილი),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(სკანდ. მილი),
						'one' => q({0} სკანდ. მილი),
						'other' => q({0} სკანდ. მილი),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(მმ),
						'one' => q({0} მმ),
						'other' => q({0} მმ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(მმ),
						'one' => q({0} მმ),
						'other' => q({0} მმ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(ნმ),
						'one' => q({0} ნმ),
						'other' => q({0} ნმ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(ნმ),
						'one' => q({0} ნმ),
						'other' => q({0} ნმ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(საზღვაო მილი),
						'one' => q({0} საზღვ. მილი),
						'other' => q({0} საზღვ. მილი),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(საზღვაო მილი),
						'one' => q({0} საზღვ. მილი),
						'other' => q({0} საზღვ. მილი),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(პს),
						'one' => q({0} პს),
						'other' => q({0} პს),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(პს),
						'one' => q({0} პს),
						'other' => q({0} პს),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(პმ),
						'one' => q({0} პმ),
						'other' => q({0} პმ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(პმ),
						'one' => q({0} პმ),
						'other' => q({0} პმ),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(პნქტ.),
						'one' => q({0} პნქტ.),
						'other' => q({0} პქნტ.),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(პნქტ.),
						'one' => q({0} პნქტ.),
						'other' => q({0} პქნტ.),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(☉ რადიუსი),
						'one' => q({0} ☉ რადიუსი),
						'other' => q({0} ☉ რადიუსი),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(☉ რადიუსი),
						'one' => q({0} ☉ რადიუსი),
						'other' => q({0} ☉ რადიუსი),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(იარდი),
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(იარდი),
						'one' => q({0} იარდი),
						'other' => q({0} იარდი),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(კდ),
						'one' => q({0} კდ),
						'other' => q({0} კდ),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(კდ),
						'one' => q({0} კდ),
						'other' => q({0} კდ),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ლმ),
						'one' => q({0} ლმ),
						'other' => q({0} ლმ),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ლმ),
						'one' => q({0} ლმ),
						'other' => q({0} ლმ),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(ლუქსი),
						'one' => q({0} ლუქსი),
						'other' => q({0} ლუქსი),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(ლუქსი),
						'one' => q({0} ლუქსი),
						'other' => q({0} ლუქსი),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(☉ სხივიერობა),
						'one' => q({0} ☉ სხივიერობა),
						'other' => q({0} ☉ სხივიერობა),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(☉ სხივიერობა),
						'one' => q({0} ☉ სხივიერობა),
						'other' => q({0} ☉ სხივიერობა),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(კარატი),
						'one' => q({0} კარ.),
						'other' => q({0} კარ.),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(კარატი),
						'one' => q({0} კარ.),
						'other' => q({0} კარ.),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(დალტონი),
						'one' => q({0} დალტ.),
						'other' => q({0} დალტ.),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(დალტონი),
						'one' => q({0} დალტ.),
						'other' => q({0} დალტ.),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(გრანი),
						'one' => q({0} გრანი),
						'other' => q({0} გრანი),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(გრანი),
						'one' => q({0} გრანი),
						'other' => q({0} გრანი),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(გრამი),
						'one' => q({0} გ),
						'other' => q({0} გ),
						'per' => q({0}/გ),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(გრამი),
						'one' => q({0} გ),
						'other' => q({0} გ),
						'per' => q({0}/გ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(კილოგრამი),
						'one' => q({0} კგ),
						'other' => q({0} კგ),
						'per' => q({0}/კგ),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(კილოგრამი),
						'one' => q({0} კგ),
						'other' => q({0} კგ),
						'per' => q({0}/კგ),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(მტ),
						'one' => q({0} მტ),
						'other' => q({0} მტ),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(მტ),
						'one' => q({0} მტ),
						'other' => q({0} მტ),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(მკგ),
						'one' => q({0} მკგ),
						'other' => q({0} მკგ),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(მკგ),
						'one' => q({0} მკგ),
						'other' => q({0} მკგ),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(მგ),
						'one' => q({0} მგ),
						'other' => q({0} მგ),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(მგ),
						'one' => q({0} მგ),
						'other' => q({0} მგ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(უნცია),
						'one' => q({0} უნც),
						'other' => q({0} უნც),
						'per' => q({0}/უნც),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(უნცია),
						'one' => q({0} უნც),
						'other' => q({0} უნც),
						'per' => q({0}/უნც),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ტრუას უნცია),
						'one' => q({0} ტრ. უნც.),
						'other' => q({0} ტრ. უნც.),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ტრუას უნცია),
						'one' => q({0} ტრ. უნც.),
						'other' => q({0} ტრ. უნც.),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(ფუნტი),
						'one' => q({0} ფნტ),
						'other' => q({0} ფნტ),
						'per' => q({0}/ფნტ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(ფუნტი),
						'one' => q({0} ფნტ),
						'other' => q({0} ფნტ),
						'per' => q({0}/ფნტ),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(სტოუნი),
						'one' => q({0} სტოუნი),
						'other' => q({0} სტოუნი),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(სტოუნი),
						'one' => q({0} სტოუნი),
						'other' => q({0} სტოუნი),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ტონა),
						'one' => q({0} ტ),
						'other' => q({0} ტ),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ტონა),
						'one' => q({0} ტ),
						'other' => q({0} ტ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(გვტ),
						'one' => q({0} გვტ),
						'other' => q({0} გვტ),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(გვტ),
						'one' => q({0} გვტ),
						'other' => q({0} გვტ),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ცხ. ძ.),
						'one' => q({0} ცხ. ძ.),
						'other' => q({0} ცხ. ძ.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ცხ. ძ.),
						'one' => q({0} ცხ. ძ.),
						'other' => q({0} ცხ. ძ.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(კვტ),
						'one' => q({0} კვტ),
						'other' => q({0} კვტ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(კვტ),
						'one' => q({0} კვტ),
						'other' => q({0} კვტ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(მგვტ),
						'one' => q({0} მგვტ),
						'other' => q({0} მგვტ),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(მგვტ),
						'one' => q({0} მგვტ),
						'other' => q({0} მგვტ),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(მლვტ),
						'one' => q({0} მლვტ),
						'other' => q({0} მლვტ),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(მლვტ),
						'one' => q({0} მლვტ),
						'other' => q({0} მლვტ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ვტ),
						'one' => q({0} ვტ),
						'other' => q({0} ვტ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ვტ),
						'one' => q({0} ვტ),
						'other' => q({0} ვტ),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q({0}³),
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q({0}³),
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(ატმ.),
						'one' => q({0} ატმ.),
						'other' => q({0} ატმ.),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(ატმ.),
						'one' => q({0} ატმ.),
						'other' => q({0} ატმ.),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(ბარი),
						'one' => q({0} ბარი),
						'other' => q({0} ბარი),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(ბარი),
						'one' => q({0} ბარი),
						'other' => q({0} ბარი),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(ჰპა),
						'one' => q({0} ჰპა),
						'other' => q({0} ჰპა),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(ჰპა),
						'one' => q({0} ჰპა),
						'other' => q({0} ჰპა),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ვრც. დმ.),
						'one' => q({0} ვრც. დმ.),
						'other' => q({0} ვრც. დმ.),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ვრც. დმ.),
						'one' => q({0} ვრც. დმ.),
						'other' => q({0} ვრც. დმ.),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(კპა),
						'one' => q({0} კპა),
						'other' => q({0} კპა),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(კპა),
						'one' => q({0} კპა),
						'other' => q({0} კპა),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(მპა),
						'one' => q({0} მპა),
						'other' => q({0} მპა),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(მპა),
						'one' => q({0} მპა),
						'other' => q({0} მპა),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(მბარი),
						'one' => q({0} მბარი),
						'other' => q({0} მბარი),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(მბარი),
						'one' => q({0} მბარი),
						'other' => q({0} მბარი),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(მმ ვწყ. სვ.),
						'one' => q({0} მმ ვწყ. სვ.),
						'other' => q({0} მმ ვწყ. სვ.),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(მმ ვწყ. სვ.),
						'one' => q({0} მმ ვწყ. სვ.),
						'other' => q({0} მმ ვწყ. სვ.),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(პა),
						'one' => q({0} პა),
						'other' => q({0} პა),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(პა),
						'one' => q({0} პა),
						'other' => q({0} პა),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(ფნტ. კვ. დმ.),
						'one' => q({0} ფნტ. კვ. დმ.),
						'other' => q({0} ფნტ. კვ. დმ.),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(ფნტ. კვ. დმ.),
						'one' => q({0} ფნტ. კვ. დმ.),
						'other' => q({0} ფნტ. კვ. დმ.),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(კმ/სთ),
						'one' => q({0} კმ/სთ),
						'other' => q({0} კმ/სთ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(კმ/სთ),
						'one' => q({0} კმ/სთ),
						'other' => q({0} კმ/სთ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(კვძ.),
						'one' => q({0} კვძ.),
						'other' => q({0} კვძ.),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(კვძ.),
						'one' => q({0} კვძ.),
						'other' => q({0} კვძ.),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(მ/წმ),
						'one' => q({0} მ/წმ),
						'other' => q({0} მ/წმ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(მ/წმ),
						'one' => q({0} მ/წმ),
						'other' => q({0} მ/წმ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(მილი/სთ),
						'one' => q({0} მილი/სთ),
						'other' => q({0} მილი/სთ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(მილი/სთ),
						'one' => q({0} მილი/სთ),
						'other' => q({0} მილი/სთ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ნიუტ. მ),
						'one' => q({0} ნიუტ. მ),
						'other' => q({0} ნიუტ. მ),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ნიუტ. მ),
						'one' => q({0} ნიუტ. მ),
						'other' => q({0} ნიუტ. მ),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(ფუნტი-ფუტი),
						'one' => q({0} ფუნტი-ფუტი),
						'other' => q({0} ფუნტი-ფუტი),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(ფუნტი-ფუტი),
						'one' => q({0} ფუნტი-ფუტი),
						'other' => q({0} ფუნტი-ფუტი),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(აკრ.ფტ.),
						'one' => q({0} აკრ.ფტ.),
						'other' => q({0} აკრ.ფტ.),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(აკრ.ფტ.),
						'one' => q({0} აკრ.ფტ.),
						'other' => q({0} აკრ.ფტ.),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(ბარელი),
						'one' => q({0} ბარ.),
						'other' => q({0} ბარ.),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(ბარელი),
						'one' => q({0} ბარ.),
						'other' => q({0} ბარ.),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(ბუშელი),
						'one' => q({0} ბუშელი),
						'other' => q({0} ბუშელი),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(ბუშელი),
						'one' => q({0} ბუშელი),
						'other' => q({0} ბუშელი),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(სლ),
						'one' => q({0} სლ),
						'other' => q({0} სლ),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(სლ),
						'one' => q({0} სლ),
						'other' => q({0} სლ),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(სმ³),
						'one' => q({0} სმ³),
						'other' => q({0} სმ³),
						'per' => q({0}/სმ³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(სმ³),
						'one' => q({0} სმ³),
						'other' => q({0} სმ³),
						'per' => q({0}/სმ³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ფუტი³),
						'one' => q({0} ფტ³),
						'other' => q({0} ფტ³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ფუტი³),
						'one' => q({0} ფტ³),
						'other' => q({0} ფტ³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(დუიმი³),
						'one' => q({0} დუიმი³),
						'other' => q({0} დუიმი³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(დუიმი³),
						'one' => q({0} დუიმი³),
						'other' => q({0} დუიმი³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(კუბური კილომეტრი),
						'one' => q({0} კმ³),
						'other' => q({0} კმ³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(კუბური კილომეტრი),
						'one' => q({0} კმ³),
						'other' => q({0} კმ³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(მ³),
						'one' => q({0} მ³),
						'other' => q({0} მ³),
						'per' => q({0}/მ³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(მ³),
						'one' => q({0} მ³),
						'other' => q({0} მ³),
						'per' => q({0}/მ³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(კუბური მილი),
						'one' => q({0} მილი³),
						'other' => q({0} მილი³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(კუბური მილი),
						'one' => q({0} მილი³),
						'other' => q({0} მილი³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(იარდი³),
						'one' => q({0} იარდი³),
						'other' => q({0} იარდი³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(იარდი³),
						'one' => q({0} იარდი³),
						'other' => q({0} იარდი³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(ჭიქა),
						'one' => q({0} ჭიქა),
						'other' => q({0} ჭიქა),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(ჭიქა),
						'one' => q({0} ჭიქა),
						'other' => q({0} ჭიქა),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(მეტრ. ჭიქა),
						'one' => q({0} მეტრ. ჭიქა),
						'other' => q({0} მეტრ. ჭიქა),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(მეტრ. ჭიქა),
						'one' => q({0} მეტრ. ჭიქა),
						'other' => q({0} მეტრ. ჭიქა),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(დლ),
						'one' => q({0} დლ),
						'other' => q({0} დლ),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(დლ),
						'one' => q({0} დლ),
						'other' => q({0} დლ),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(დესერტის კოვზი),
						'one' => q({0} დესერტის კოვზი),
						'other' => q({0} დესერტის კოვზი),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(დესერტის კოვზი),
						'one' => q({0} დესერტის კოვზი),
						'other' => q({0} დესერტის კოვზი),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(ბრიტ. დესერტის კოვზი),
						'one' => q({0} ბრიტ. დეს. კოვზი),
						'other' => q({0} ბრიტ. დეს. კოვზი),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(ბრიტ. დესერტის კოვზი),
						'one' => q({0} ბრიტ. დეს. კოვზი),
						'other' => q({0} ბრიტ. დეს. კოვზი),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ბრიტ. თხევადი დრაქმა),
						'one' => q({0} ბრიტ. თხევ. დრაქმა),
						'other' => q({0} ბრიტ. თხევ. დრაქმა),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ბრიტ. თხევადი დრაქმა),
						'one' => q({0} ბრიტ. თხევ. დრაქმა),
						'other' => q({0} ბრიტ. თხევ. დრაქმა),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(წვეთი),
						'one' => q({0} წვეთი),
						'other' => q({0} წვეთი),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(წვეთი),
						'one' => q({0} წვეთი),
						'other' => q({0} წვეთი),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(თხ. უნცია),
						'one' => q({0} თხ. უნცია),
						'other' => q({0} თხ. უნცია),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(თხ. უნცია),
						'one' => q({0} თხ. უნცია),
						'other' => q({0} თხ. უნცია),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(ბრიტ. თხევ. უნც.),
						'one' => q({0} ბრიტ. თხევ. უნც.),
						'other' => q({0} ბრიტ. თხევ. უნც.),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(ბრიტ. თხევ. უნც.),
						'one' => q({0} ბრიტ. თხევ. უნც.),
						'other' => q({0} ბრიტ. თხევ. უნც.),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(გალონი),
						'one' => q({0} გალონი),
						'other' => q({0} გალონი),
						'per' => q({0}/გალონი),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(გალონი),
						'one' => q({0} გალონი),
						'other' => q({0} გალონი),
						'per' => q({0}/გალონი),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(იმპ. გალ.),
						'one' => q({0} იმპ. გალ.),
						'other' => q({0} იმპ. გალ.),
						'per' => q({0}/იმპ. გალ.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(იმპ. გალ.),
						'one' => q({0} იმპ. გალ.),
						'other' => q({0} იმპ. გალ.),
						'per' => q({0}/იმპ. გალ.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(ჰლ),
						'one' => q({0} ჰლ),
						'other' => q({0} ჰლ),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(ჰლ),
						'one' => q({0} ჰლ),
						'other' => q({0} ჰლ),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(ჯიგერი),
						'one' => q({0} ჯიგერი),
						'other' => q({0} ჯიგერი),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(ჯიგერი),
						'one' => q({0} ჯიგერი),
						'other' => q({0} ჯიგერი),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ლიტრი),
						'one' => q({0} ლ),
						'other' => q({0} ლ),
						'per' => q({0}/ლ),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ლიტრი),
						'one' => q({0} ლ),
						'other' => q({0} ლ),
						'per' => q({0}/ლ),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(მეგალ.),
						'one' => q({0} მეგალ.),
						'other' => q({0} მეგალ.),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(მეგალ.),
						'one' => q({0} მეგალ.),
						'other' => q({0} მეგალ.),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(მილილ.),
						'one' => q({0} მილილ.),
						'other' => q({0} მილილ.),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(მილილ.),
						'one' => q({0} მილილ.),
						'other' => q({0} მილილ.),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(მწიკვი),
						'one' => q({0} მწიკვი),
						'other' => q({0} მწიკვი),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(მწიკვი),
						'one' => q({0} მწიკვი),
						'other' => q({0} მწიკვი),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(პინტა),
						'one' => q({0} პინტა),
						'other' => q({0} პინტა),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(პინტა),
						'one' => q({0} პინტა),
						'other' => q({0} პინტა),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(მეტრ. პინტა),
						'one' => q({0} მეტრ. პინტა),
						'other' => q({0} მეტრ. პინტა),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(მეტრ. პინტა),
						'one' => q({0} მეტრ. პინტა),
						'other' => q({0} მეტრ. პინტა),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(კვარტა),
						'one' => q({0} კვარტა),
						'other' => q({0} კვარტა),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(კვარტა),
						'one' => q({0} კვარტა),
						'other' => q({0} კვარტა),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(ბრიტ. კვარტი),
						'one' => q({0} ბრიტ. კვარტი),
						'other' => q({0} ბრიტ. კვარტი),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(ბრიტ. კვარტი),
						'one' => q({0} ბრიტ. კვარტი),
						'other' => q({0} ბრიტ. კვარტი),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ს. კოვზი),
						'one' => q({0} ს. კოვზი),
						'other' => q({0} ს. კოვზი),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ს. კოვზი),
						'one' => q({0} ს. კოვზი),
						'other' => q({0} ს. კოვზი),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ჩ. კოვზი),
						'one' => q({0} ჩ. კოვზი),
						'other' => q({0} ჩ. კოვზი),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ჩ. კოვზი),
						'one' => q({0} ჩ. კოვზი),
						'other' => q({0} ჩ. კოვზი),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:კი|კ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:არა|ა|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has traditional_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'geor',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 2,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q( ),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(არ არის რიცხვი),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 ათ'.'',
					'other' => '0 ათ'.'',
				},
				'10000' => {
					'one' => '00 ათ'.'',
					'other' => '00 ათ'.'',
				},
				'100000' => {
					'one' => '000 ათ'.'',
					'other' => '000 ათ'.'',
				},
				'1000000' => {
					'one' => '0 მლნ'.'',
					'other' => '0 მლნ'.'',
				},
				'10000000' => {
					'one' => '00 მლნ'.'',
					'other' => '00 მლნ'.'',
				},
				'100000000' => {
					'one' => '000 მლნ'.'',
					'other' => '000 მლნ'.'',
				},
				'1000000000' => {
					'one' => '0 მლრდ'.'',
					'other' => '0 მლრდ'.'',
				},
				'10000000000' => {
					'one' => '00 მლრდ'.'',
					'other' => '00 მლრდ'.'',
				},
				'100000000000' => {
					'one' => '000 მლრ'.'',
					'other' => '000 მლრ'.'',
				},
				'1000000000000' => {
					'one' => '0 ტრლ'.'',
					'other' => '0 ტრლ'.'',
				},
				'10000000000000' => {
					'one' => '00 ტრლ'.'',
					'other' => '00 ტრლ'.'',
				},
				'100000000000000' => {
					'one' => '000 ტრლ'.'',
					'other' => '000 ტრლ'.'',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ათასი',
					'other' => '0 ათასი',
				},
				'10000' => {
					'one' => '00 ათასი',
					'other' => '00 ათასი',
				},
				'100000' => {
					'one' => '000 ათასი',
					'other' => '000 ათასი',
				},
				'1000000' => {
					'one' => '0 მილიონი',
					'other' => '0 მილიონი',
				},
				'10000000' => {
					'one' => '00 მილიონი',
					'other' => '00 მილიონი',
				},
				'100000000' => {
					'one' => '000 მილიონი',
					'other' => '000 მილიონი',
				},
				'1000000000' => {
					'one' => '0 მილიარდი',
					'other' => '0 მილიარდი',
				},
				'10000000000' => {
					'one' => '00 მილიარდი',
					'other' => '00 მილიარდი',
				},
				'100000000000' => {
					'one' => '000 მილიარდი',
					'other' => '000 მილიარდი',
				},
				'1000000000000' => {
					'one' => '0 ტრილიონი',
					'other' => '0 ტრილიონი',
				},
				'10000000000000' => {
					'one' => '00 ტრილიონი',
					'other' => '00 ტრილიონი',
				},
				'100000000000000' => {
					'one' => '000 ტრილიონი',
					'other' => '000 ტრილიონი',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ათ'.'',
					'other' => '0 ათ'.'',
				},
				'10000' => {
					'one' => '00 ათ'.'',
					'other' => '00 ათ'.'',
				},
				'100000' => {
					'one' => '000 ათ'.'',
					'other' => '000 ათ'.'',
				},
				'1000000' => {
					'one' => '0 მლნ'.'',
					'other' => '0 მლნ'.'',
				},
				'10000000' => {
					'one' => '00 მლნ'.'',
					'other' => '00 მლნ'.'',
				},
				'100000000' => {
					'one' => '000 მლნ'.'',
					'other' => '000 მლნ'.'',
				},
				'1000000000' => {
					'one' => '0 მლრდ'.'',
					'other' => '0 მლრდ'.'',
				},
				'10000000000' => {
					'one' => '00 მლრდ'.'',
					'other' => '00 მლრდ'.'',
				},
				'100000000000' => {
					'one' => '000 მლრ'.'',
					'other' => '000 მლრ'.'',
				},
				'1000000000000' => {
					'one' => '0 ტრლ'.'',
					'other' => '0 ტრლ'.'',
				},
				'10000000000000' => {
					'one' => '00 ტრლ'.'',
					'other' => '00 ტრლ'.'',
				},
				'100000000000000' => {
					'one' => '000 ტრლ'.'',
					'other' => '000 ტრლ'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(ანდორული პესეტა),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(არაბთა გაერთიანებული საამიროების დირჰამი),
				'one' => q(არაბთა გაერთიანებული საამიროების დირჰამი),
				'other' => q(არაბთა გაერთიანებული საამიროების დირჰამი),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(ავღანი \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ავღანური ავღანი),
				'one' => q(ავღანური ავღანი),
				'other' => q(ავღანური ავღანი),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ალბანური ლეკი),
				'one' => q(ალბანური ლეკი),
				'other' => q(ალბანური ლეკი),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(სომხური დრამი),
				'one' => q(სომხური დრამი),
				'other' => q(სომხური დრამი),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(ნიდერლანდების ანტილების გულდენი),
				'one' => q(ნიდრელანდების ანტილიის გულდენი),
				'other' => q(ნიდრელანდების ანტილიის გულდენი),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ანგოლური კვანზა),
				'one' => q(ანგოლური კვანზა),
				'other' => q(ანგოლური კვანზა),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ანგოლური კვანზა \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(ანგოლური ახალი კვანზა \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(ანგოლური მიტოლებული კვანზა \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(არგენტინული აუსტრალი),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(არგენტინული პესო \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(არგენტინული პესო),
				'one' => q(არგენტინული პესო),
				'other' => q(არგენტინული პესო),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ავსტრიული შილინგი),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(ავსტრალიური დოლარი),
				'one' => q(ავსტრალიური დოლარი),
				'other' => q(ავსტრალიური დოლარი),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(არუბანული გულდენი),
				'one' => q(არუბანული გულდენი),
				'other' => q(არუბანული გულდენი),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(აზერბაიჯანული მანათი \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(აზერბაიჯანული მანათი),
				'one' => q(აზერბაიჯანული მანათი),
				'other' => q(აზერბაიჯანული მანათი),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(ბოსნია-ჰერცოგოვინას დინარი),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ბოსნია და ჰერცოგოვინას კონვერტირებადი მარკა),
				'one' => q(ბოსნია და ჰერცოგოვინას კონვერტირებადი მარკა),
				'other' => q(ბოსნია და ჰერცოგოვინას კონვერტირებადი მარკა),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(ბარბადოსული დოლარი),
				'one' => q(ბარბადოსული დოლარი),
				'other' => q(ბარბადოსული დოლარი),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(ბანგლადეშური ტაკა),
				'one' => q(ბანგლადეშური ტაკა),
				'other' => q(ბანგლადეშური ტაკა),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(ბელგიური ფრანკი \(კოვერტირებადი\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ბელგიური ფრანკი),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(ბელგიური ფრანკი \(ფინანსური\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(ბულგარული მყარი ლევი),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ბულგარული ლევი),
				'one' => q(ბულგარული ლევი),
				'other' => q(ბულგარული ლევი),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(ბაჰრეინული დინარი),
				'one' => q(ბაჰრეინული დინარი),
				'other' => q(ბაჰრეინული დინარი),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ბურუნდიული ფრანკი),
				'one' => q(ბურუნდიული ფრანკი),
				'other' => q(ბურუნდიული ფრანკი),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ბერმუდული დოლარი),
				'one' => q(ბერმუდული დოლარი),
				'other' => q(ბერმუდული დოლარი),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ბრუნეული დოლარი),
				'one' => q(ბრუნეული დოლარი),
				'other' => q(ბრუნეული დოლარი),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ბოლივიური ბოლივიანო),
				'one' => q(ბოლივიური ბოლივიანო),
				'other' => q(ბოლივიური ბოლივიანო),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ბოლივიური პესო),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზეირო ნოვო \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზადო),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზეირო \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ბრაზილიური რეალი),
				'one' => q(ბრაზილიური რეალი),
				'other' => q(ბრაზილიური რეალი),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზადო ნოვო),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ბრაზილიური კრუზეირო),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(ბაჰამური დოლარი),
				'one' => q(ბაჰამური დოლარი),
				'other' => q(ბაჰამური დოლარი),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ბუტანური ნგულტრუმი),
				'one' => q(ბუტანური ნგულტრუმი),
				'other' => q(ბუტანური ნგულტრუმი),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ბოცვანური პულა),
				'one' => q(ბოცვანური პულა),
				'other' => q(ბოცვანური პულა),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ახალი ბელარუსიული რუბლი \(1994–1999\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(ბელორუსული რუბლი),
				'one' => q(ბელორუსული რუბლი),
				'other' => q(ბელორუსული რუბლი),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(ბელორუსული რუბლი \(2000–2016\)),
				'one' => q(ბელორუსული რუბლი \(2000–2016\)),
				'other' => q(ბელორუსული რუბლი \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ბელიზის დოლარი),
				'one' => q(ბელიზის დოლარი),
				'other' => q(ბელიზის დოლარი),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(კანადური დოლარი),
				'one' => q(კანადური დოლარი),
				'other' => q(კანადური დოლარი),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(კონგოს ფრანკი),
				'one' => q(კონგოს ფრანკი),
				'other' => q(კონგოს ფრანკი),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(შვეიცარიული ფრანკი),
				'one' => q(შვეიცარიული ფრანკი),
				'other' => q(შვეიცარიული ფრანკი),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(ჩილეს პესო),
				'one' => q(ჩილეს პესო),
				'other' => q(ჩილეს პესო),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(ჩინური იუანი \(ოფშორი\)),
				'one' => q(ჩინური იუანი \(ოფშორი\)),
				'other' => q(ჩინური იუანი \(ოფშორი\)),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(ჩინური იუანი),
				'one' => q(ჩინური უანი),
				'other' => q(ჩინური უანი),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(კოლუმბიური პესო),
				'one' => q(კოლუმბიური პესო),
				'other' => q(კოლუმბიური პესო),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(კოსტა-რიკული კოლონი),
				'one' => q(კოსტა-რიკული კოლონი),
				'other' => q(კოსტა რიკული კოლონი),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(ძველი სერბიული დინარი),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(ჩეხოსლოვაკიის მყარი კრონა),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(კუბური კონვერტირებადი პესო),
				'one' => q(კუბური კონვერტირებადი პესო),
				'other' => q(კუბური კონვერტირებადი პესო),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(კუბური პესო),
				'one' => q(კუბური პესო),
				'other' => q(კუბური პესო),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(კაბო-ვერდეს ესკუდო),
				'one' => q(კაბო-ვერდეს ესკუდო),
				'other' => q(კაბო-ვერდეს ესკუდო),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(კვიპროსის გირვანქა),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(ჩეხური კრონა),
				'one' => q(ჩეხური კრონა),
				'other' => q(ჩეხური კრონა),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(აღმოსავლეთ გერმანული მარკა),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(გერმანული მარკა),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ჯიბუტის ფრანკი),
				'one' => q(ჯიბუტის ფრანკი),
				'other' => q(ჯიბუტის ფრანკი),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(დანიური კრონა),
				'one' => q(დანიური კრონა),
				'other' => q(დანიური კრონა),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(დომინიკური პესო),
				'one' => q(დომინიკური პესო),
				'other' => q(დომინიკური პესო),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ალჟირული დინარი),
				'one' => q(ალჟირული დინარი),
				'other' => q(ალჟირული დინარი),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ესტონური კრუნა),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ეგვიპტური გირვანქა),
				'one' => q(ეგვიპტური გირვანქა),
				'other' => q(ეგვიპტური გირვანქა),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ერიტრეის ნაკფა),
				'one' => q(ერიტრეის ნაკფა),
				'other' => q(ერიტრეის ნაკფა),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(ესპანური პესეტა),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ეთიოპიური ბირი),
				'one' => q(ეთიოპიური ბირი),
				'other' => q(ეთიოპიური ბირი),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ევრო),
				'one' => q(ევრო),
				'other' => q(ევრო),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ფინური მარკა),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ფიჯის დოლარი),
				'one' => q(ფიჯის დოლარი),
				'other' => q(ფიჯის დოლარი),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ფოლკლენდის კუნძულების ფუნტი),
				'one' => q(ფოლკლენდის კუნძულების ფუნტი),
				'other' => q(ფოლკლენდის კუნძულების ფუნტი),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ფრანგული ფრანკი),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ბრიტანული გირვანქა სტერლინგი),
				'one' => q(ბრიტანული გირვანქა სტერლინგი),
				'other' => q(ბრიტანული გირვანქა სტერლინგი),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(ქართული კუპონი ლარით),
			},
		},
		'GEL' => {
			symbol => '₾',
			display_name => {
				'currency' => q(ქართული ლარი),
				'one' => q(ქართული ლარი),
				'other' => q(ქართული ლარი),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(განური სედი),
				'one' => q(განური სედი),
				'other' => q(განური სედი),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(გიბრალტარული ფუნტი),
				'one' => q(გიბრალტარული ფუნტი),
				'other' => q(გიბრალტარული ფუნტი),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(გამბიური დალასი),
				'one' => q(გამბიური დალასი),
				'other' => q(გამბიური დალასი),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(გვინეური ფრანკი),
				'one' => q(გვინეური ფრანკი),
				'other' => q(გვინეური ფრანკი),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(ბერძნული დრაჰმა),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(გვატემალური კეტსალი),
				'one' => q(გვატემალური კეტსალი),
				'other' => q(გვატემალური კეტსალი),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(პორტუგალიური გინეა ესკუდო),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(გაიანური დოლარი),
				'one' => q(გაიანური დოლარი),
				'other' => q(გაიანური დოლარი),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(ჰონკონგის დოლარი),
				'one' => q(ჰონკონგის დოლარი),
				'other' => q(ჰონკონგის დოლარი),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ჰონდურასული ლემპირა),
				'one' => q(ჰონდურასული ლემპირა),
				'other' => q(ჰონდურასული ლემპირა),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ხორვატიული დინარი),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ხორვატული კუნა),
				'one' => q(ხორვატული კუნა),
				'other' => q(ხორვატული კუნა),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ჰაიტური გურდი),
				'one' => q(ჰაიტური გურდი),
				'other' => q(ჰაიტური გურდი),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(უნგრული ფორინტი),
				'one' => q(უნგრული ფორინტი),
				'other' => q(უნგრული ფორინტი),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ინდონეზიური რუპია),
				'one' => q(ინდონეზიური რუპია),
				'other' => q(ინდონეზიური რუპია),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ირლანდიური გირვანქა),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(ისრაელის ახალი შეკელი),
				'one' => q(ისრაელის ახალი შეკელი),
				'other' => q(ისრაელის ახალი შეკელი),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(ინდური რუპია),
				'one' => q(ინდური რუპია),
				'other' => q(ინდური რუპია),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ერაყული დინარი),
				'one' => q(ერაყული დინარი),
				'other' => q(ერაყული დინარი),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ირანული რიალი),
				'one' => q(ირანული რიალი),
				'other' => q(ირანული რიალი),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ისლანდიური კრონა),
				'one' => q(ისლანდიური კრონა),
				'other' => q(ისლანდიური კრონა),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(იტალიური ლირა),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(იამაიკური დოლარი),
				'one' => q(იამაიკური დოლარი),
				'other' => q(იამაიკური დოლარი),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(იორდანიული დოლარი),
				'one' => q(იორდანიული დოლარი),
				'other' => q(იორდანიული დოლარი),
			},
		},
		'JPY' => {
			symbol => 'JPY',
			display_name => {
				'currency' => q(იაპონური იენი),
				'one' => q(იაპონური იენი),
				'other' => q(იაპონური იენი),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(კენიური შილინგი),
				'one' => q(კენიური შილინგი),
				'other' => q(კენიური შილინგი),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ყირგიზული სომი),
				'one' => q(ყირგიზული სომი),
				'other' => q(ყირგიზული სომი),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(კამბოჯური რიელი),
				'one' => q(კამბოჯური რიელი),
				'other' => q(კამბოჯური რიელი),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(კომორული ფრანკი),
				'one' => q(კომორული ფრანკი),
				'other' => q(კომორული ფრანკი),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(ჩრდილოეთ კორეული ვონი),
				'one' => q(ჩრდილოეთ კორეული ვონი),
				'other' => q(ჩრდილოეთ კორეული ვონი),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(სამხრეთ კორეული ვონი),
				'one' => q(სამხრეთ კორეული ვონი),
				'other' => q(სამხრეთ კორეული ვონი),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(ქუვეითური დინარი),
				'one' => q(ქუვეითური დინარი),
				'other' => q(ქუვეითური დინარი),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(კაიმანის კუნძულების დოლარი),
				'one' => q(კაიმანის კუნძულების დოლარი),
				'other' => q(კაიმანის კუნძულების დოლარი),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ყაზახური ტენგე),
				'one' => q(ყაზახური ტენგე),
				'other' => q(ყაზახური ტენგე),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(ლაოსური კიპი),
				'one' => q(ლაოსური კიპი),
				'other' => q(ლაოსური კიპი),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ლიბანური ფუნტი),
				'one' => q(ლიბანური ფუნტი),
				'other' => q(ლიბანური ფუნტი),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(შრი-ლანკური რუპია),
				'one' => q(შრი-ლანკური რუპია),
				'other' => q(შრი-ლანკური რუპია),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ლიბერიული დოლარი),
				'one' => q(ლიბერიული დოლარი),
				'other' => q(ლიბერიული დოლარი),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(ლესოთოს ლოტი),
				'one' => q(ლესოთოს ლოტი),
				'other' => q(ლესოთოს ლოტი),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(ლიტვური ლიტა),
				'one' => q(ლიტვური ლიტა),
				'other' => q(ლიტვური ლიტა),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(ლიტვური ტალონი),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(ლუქსემბურგის კონვერტირებადი ფრანკი),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ლუქსემბურგის ფრანკი),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(ლუქსემბურგის ფინანსური ფრანკი),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(ლატვიური ლატი),
				'one' => q(ლატვიური ლატი),
				'other' => q(ლატვიური ლატი),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ლატვიური რუბლი),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ლიბიური დინარი),
				'one' => q(ლიბიური დინარი),
				'other' => q(ლიბიური დინარი),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(მაროკოს დირჰამი),
				'one' => q(მაროკოს დირჰამი),
				'other' => q(მაროკოს დირჰამი),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(მაროკოს ფრანკი),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(მოლდოვური ლეუ),
				'one' => q(მოლდოვური ლეუ),
				'other' => q(მოლდოვური ლეუ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(მადაგასკარის არიარი),
				'one' => q(მადაგასკარის არიარი),
				'other' => q(მადაგასკარის არიარი),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(მადაგასკარის ფრანკი),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(მაკედონიური დინარი),
				'one' => q(მაკედონიური დინარი),
				'other' => q(მაკედონიური დინარი),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(მალის ფრანკი),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(მიანმარის კიატი),
				'one' => q(მიანმარის კიატი),
				'other' => q(მიანმარის კიატი),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(მონღოლური ტუგრიკი),
				'one' => q(მონღოლური ტუგრიკი),
				'other' => q(მონღოლური ტუგრიკი),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(მაკაუს პატაკა),
				'one' => q(მაკაუს პატაკა),
				'other' => q(მაკაუს პატაკა),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(მავრიტანული უგია \(1973–2017\)),
				'one' => q(მავრიტანული უგია \(1973–2017\)),
				'other' => q(მავრიტანული უგია \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(მავრიტანული უგია),
				'one' => q(მავრიტანული უგია),
				'other' => q(მავრიტანული უგია),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(მალტის ლირა),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(მალტის გირვანქა),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(მავრიტანული რუპია),
				'one' => q(მავრიტანული რუპია),
				'other' => q(მავრიტანული რუპია),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(მალდივური რუფია),
				'one' => q(მალდივური რუფია),
				'other' => q(მალდივური რუფია),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(მალავიური კვაჩა),
				'one' => q(მალავიური კვაჩა),
				'other' => q(მალავიური კვაჩა),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(მექსიკური პესო),
				'one' => q(მექსიკური პესო),
				'other' => q(მექსიკური პესო),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(მექსიკური ვერცხლის პესო \(1861–1992\)),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(მალაიზიური რინგიტი),
				'one' => q(მალაიზიური რინგიტი),
				'other' => q(მალაიზიური რინგიტი),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(მოზამბიკური ესკუდო),
				'one' => q(მოზამბიკური ესკუდო),
				'other' => q(მოზამბიკური ესკუდო),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(ძველი მოზამბიკური მეტიკალი),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(მოზამბიკური მეტიკალი),
				'one' => q(მოზამბიკური მეტიკალი),
				'other' => q(მოზამბიკური მეტიკალი),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(ნამიბიური დოლარი),
				'one' => q(ნამიბიური დოლარი),
				'other' => q(ნამიბიური დოლარი),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(ნიგერიული ნაირა),
				'one' => q(ნიგერიული ნაირა),
				'other' => q(ნიგერიული ნაირა),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(ნიკარაგუას კორდობა),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(ნიკარაგუას ოქროს კორდობა),
				'one' => q(ნიკარაგუას ოქროს კორდობა),
				'other' => q(ნიკარაგუას ოქროს კორდობა),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(ჰოლანდიური გულდენი),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ნორვეგიული კრონა),
				'one' => q(ნორვეგიული კრონა),
				'other' => q(ნორვეგიული კრონა),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(ნეპალური რუპია),
				'one' => q(ნეპალური რუპია),
				'other' => q(ნეპალური რუპია),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(ახალი ზელანდიის დოლარი),
				'one' => q(ახალი ზელანდიის დოლარი),
				'other' => q(ახალი ზელანდიის დოლარი),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ომანის რიალი),
				'one' => q(ომანის რიალი),
				'other' => q(ომანის რიალი),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(პანამური ბალბოა),
				'one' => q(პანამური ბალბოა),
				'other' => q(პანამური ბალბოა),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(პერუს ინტი),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(პერუს სოლი),
				'one' => q(პერუს სოლი),
				'other' => q(პერუს სოლი),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(პერუს სოლი \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(პაპუა-ახალი გვინეის კინა),
				'one' => q(პაპუა-ახალი გვინეის კინა),
				'other' => q(პაპუა-ახალი გვინეის კინა),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ფილიპინური პესო),
				'one' => q(ფილიპინური პესო),
				'other' => q(ფილიპინური პესო),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(პაკისტანური რუპია),
				'one' => q(პაკისტანური რუპია),
				'other' => q(პაკისტანური რუპია),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(პოლონური ზლოტი),
				'one' => q(პოლონური ზლოტი),
				'other' => q(პოლონური ზლოტი),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(პოლონური ზლოტი \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(პორტუგალიური ესკუდო),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(პარაგვაული გუარანი),
				'one' => q(პარაგვაული გუარანი),
				'other' => q(პარაგვაული გუარანი),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(კატარის რიალი),
				'one' => q(კატარის რიალი),
				'other' => q(კატარის რიალი),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(როდეზიული დოლარი),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(ძველი რუმინული ლეუ),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(რუმინული ლეუ),
				'one' => q(რუმინული ლეუ),
				'other' => q(რუმინული ლეუ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(სერბული დინარი),
				'one' => q(სერბული დინარი),
				'other' => q(სერბული დინარი),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(რუსული რუბლი),
				'one' => q(რუსული რუბლი),
				'other' => q(რუსული რუბლი),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(რუსული რუბლი \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(რუანდული ფრანკი),
				'one' => q(რუანდული ფრანკი),
				'other' => q(რუანდული ფრანკი),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(საუდის არაბეთის რიალი),
				'one' => q(საუდის არაბეთის რიალი),
				'other' => q(საუდის არაბეთის რიალი),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(სოლომონის კუნძულების დოლარი),
				'one' => q(სოლომონის კუნძულების დოლარი),
				'other' => q(სოლომონის კუნძულების დოლარი),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(სეიშელური რუპია),
				'one' => q(სეიშელური რუპია),
				'other' => q(სეიშელური რუპია),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(სუდანის დინარი),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(სუდანური ფუნტი),
				'one' => q(სუდანური ფუნტი),
				'other' => q(სუდანური ფუნტი),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(სუდანის გირვანქა),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(შვედური კრონა),
				'one' => q(შვედური კრონა),
				'other' => q(შვედური კრონა),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(სინგაპურის დოლარი),
				'one' => q(სინგაპურის დოლარი),
				'other' => q(სინგაპურის დოლარი),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(წმ. ელენეს კუნძულის ფუნტი),
				'one' => q(წმ. ელენეს კუნძულის ფუნტი),
				'other' => q(წმ. ელენეს კუნძულის ფუნტი),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(სიერა-ლეონეს ლეონე),
				'one' => q(სიერა-ლეონეს ლეონე),
				'other' => q(სიერა-ლეონეს ლეონე),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(სომალური შილინგი),
				'one' => q(სომალური შილინგი),
				'other' => q(სომალური შილინგი),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(სურინამული დოლარი),
				'one' => q(სურინამული დოლარი),
				'other' => q(სურინამული დოლარი),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(სურინამის გულდენი),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(სამხრეთ სუდანური ფუნტი),
				'one' => q(სამხრეთ სუდანური ფუნტი),
				'other' => q(სამხრეთ სუდანური ფუნტი),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(სან-ტომე და პრინსიპის დობრა \(1977–2017\)),
				'one' => q(სან-ტომე და პრინსიპის დობრა \(1977–2017\)),
				'other' => q(სან-ტომე და პრინსიპის დობრა \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(სან-ტომე და პრინსიპის დობრა),
				'one' => q(სან-ტომე და პრინსიპის დობრა),
				'other' => q(სან-ტომე და პრინსიპის დობრა),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(საბჭოთა რუბლი),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(სირიული ფუნტი),
				'one' => q(სირიული გირვანქა),
				'other' => q(სირიული გირვანქა),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(სვაზილენდის ლილანგენი),
				'one' => q(სვაზილენდის ლილანგენი),
				'other' => q(სვაზილენდის ლილანგენი),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(ტაილანდური ბატი),
				'one' => q(ტაილანდური ბატი),
				'other' => q(ტაილანდური ბატი),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(ტაჯიკური რუბლი),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(ტაჯიკური სომონი),
				'one' => q(ტაჯიკური სომონი),
				'other' => q(ტაჯიკური სომონი),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(თურქმენული მანათი),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(თურქმენეთის მანათი),
				'one' => q(თურქმენეთის მანათი),
				'other' => q(თურქმენეთის მანათი),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(ტუნისური დინარი),
				'one' => q(ტუნისის დინარი),
				'other' => q(ტუნისის დინარი),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ტონგანური პაანგა),
				'one' => q(ტონგანური პაანგა),
				'other' => q(ტონგანური პაანგა),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(თურქული ლირა),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ახალი თურქული ლირა),
				'one' => q(ახალი თურქული ლირა),
				'other' => q(ახალი თურქული ლირა),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ტრინიდად და ტობაგოს დოლარი),
				'one' => q(ტრინიდად და ტობაგოს დოლარი),
				'other' => q(ტრინიდად და ტობაგოს დოლარი),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ტაივანური ახალი დოლარი),
				'one' => q(ტაივანური ახალი დოლარი),
				'other' => q(ტაივანური ახალი დოლარი),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ტანზანიური შილინგი),
				'one' => q(ტანზანიური შილინგი),
				'other' => q(ტანზანიური შილინგი),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(უკრაინული გრივნა),
				'one' => q(უკრაინული გრივნა),
				'other' => q(უკრაინული გრივნა),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(უკრაინული კარბოვანეცი),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(უგანდური შილინგი \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(უგანდური შილინგი),
				'one' => q(უგანდური შილინგი),
				'other' => q(უგანდური შილინგი),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(აშშ დოლარი),
				'one' => q(აშშ დოლარი),
				'other' => q(აშშ დოლარი),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(აშშ დოლარი \(შემდეგი დღე\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(აშშ დოლარი \(იგივე დღე\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ურუგვაის პესო \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ურუგვაის პესო),
				'one' => q(ურუგვაის პესო),
				'other' => q(ურუგვაის პესო),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(უზბეკური სუმი),
				'one' => q(უზბეკური სუმი),
				'other' => q(უზბეკური სუმი),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ვენესუელის ბოლივარი \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ვენესუელის ბოლივარი \(2008–2018\)),
				'one' => q(ვენესუელის ბოლივარი \(2008–2018\)),
				'other' => q(ვენესუელის ბოლივარი \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(ვენესუელის ბოლივარი),
				'one' => q(ვენესუელის ბოლივარი),
				'other' => q(ვენესუელის ბოლივარი),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(ვიეტნამური დონგი),
				'one' => q(ვიეტნამური დონგი),
				'other' => q(ვიეტნამური დონგი),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ვანუატუს ვატუ),
				'one' => q(ვანატუს ვატუ),
				'other' => q(ვანატუს ვატუ),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(სამოური ტალა),
				'one' => q(დასავლეთ სამოას ტალა),
				'other' => q(სამოური ტალა),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ცენტრალურ აფრიკული CFA ფრანკი),
				'one' => q(ცენტრალურ აფრიკული CFA ფრანკი),
				'other' => q(ცენტრალურ აფრიკული CFA ფრანკი),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(ვერცხლი),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(ევროპული კომპპოზიტური ერთეული),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ევროპული ფულადი ერთეული),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(აღმოსავლეთ კარიბიული დოლარი),
				'one' => q(აღმოსავლეთ კარიბიული დოლარი),
				'other' => q(აღმოსავლეთ კარიბიული დოლარი),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(ევროპული სავალუტო ერთეული),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ფრანგული ოქროს ფრანკი),
			},
		},
		'XOF' => {
			symbol => 'F CFA',
			display_name => {
				'currency' => q(დასავლეთ აფრიკული CFA ფრანკი),
				'one' => q(დასავლეთ აფრიკული CFA ფრანკი),
				'other' => q(დასავლეთ აფრიკული CFA ფრანკი),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ფრანკი),
				'one' => q(CFP ფრანკი),
				'other' => q(CFP ფრანკი),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(უცნობი ვალუტა),
				'one' => q(\(ვალუტის უცნობი ერთეული\)),
				'other' => q(\(უცნობი ვალუტა\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(იემენის დინარი),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(იემენის რეალი),
				'one' => q(იემენის რეალი),
				'other' => q(იემენის რეალი),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(იუგოსლავიური მყარი დინარი),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(იუგოსლავიური ახალი დინარი),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(იუგოსლავიური კონვერტირებადი დინარი),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(სამხრეთ აფრიკული რანდი),
				'one' => q(სამხრეთ აფრიკული რანდი),
				'other' => q(სამხრეთ აფრიკული რანდი),
			},
		},
		'ZMK' => {
			symbol => 'ZMK',
			display_name => {
				'currency' => q(ზამბიური კვაჭა \(1968–2012\)),
				'one' => q(ზამბიური კვაჭა \(1968–2012\)),
				'other' => q(ზამბიური კვაჭა \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ზამბიური კვაჭა),
				'one' => q(ზამბიური კვაჭა),
				'other' => q(ზამბიური კვაჭა),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(ზაირის ახალი ზაირი),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(ზაირის ზაირი),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ზიმბაბვეს დოლარი),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'იან',
							'თებ',
							'მარ',
							'აპრ',
							'მაი',
							'ივნ',
							'ივლ',
							'აგვ',
							'სექ',
							'ოქტ',
							'ნოე',
							'დეკ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ი',
							'თ',
							'მ',
							'ა',
							'მ',
							'ი',
							'ი',
							'ა',
							'ს',
							'ო',
							'ნ',
							'დ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'იანვარი',
							'თებერვალი',
							'მარტი',
							'აპრილი',
							'მაისი',
							'ივნისი',
							'ივლისი',
							'აგვისტო',
							'სექტემბერი',
							'ოქტომბერი',
							'ნოემბერი',
							'დეკემბერი'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'იან',
							'თებ',
							'მარ',
							'აპრ',
							'მაი',
							'ივნ',
							'ივლ',
							'აგვ',
							'სექ',
							'ოქტ',
							'ნოე',
							'დეკ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ი',
							'თ',
							'მ',
							'ა',
							'მ',
							'ი',
							'ი',
							'ა',
							'ს',
							'ო',
							'ნ',
							'დ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'იანვარი',
							'თებერვალი',
							'მარტი',
							'აპრილი',
							'მაისი',
							'ივნისი',
							'ივლისი',
							'აგვისტო',
							'სექტემბერი',
							'ოქტომბერი',
							'ნოემბერი',
							'დეკემბერი'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'თიშრეი',
							'ხეშვანი',
							'ქისლევი',
							'ტევეთი',
							'შვატი',
							'ადარი I',
							'ადარი',
							'ნისანი',
							'იარი',
							'სივანი',
							'თამუზი',
							'ავი',
							'ელული'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'მუჰ.',
							'საფ.',
							'რაბ. I',
							'რაბ. II',
							'ჯუმ. I',
							'ჯუმ. II',
							'რაჯ.',
							'შაბ.',
							'რამ.',
							'შავ.',
							'ზულ-კ.',
							'ზულ-ჰ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'მუჰარამი',
							'საფარი',
							'რაბი ულ-ავალი',
							'რაბი ულ-ახირი',
							'ჯუმადა ულ-ავალი',
							'ჯუმადა ულ-ახირი',
							'რაჯაბი',
							'შაბანი',
							'რამადანი',
							'შავალი',
							'ზულ-კაადა',
							'ზულ-ჰიჯა'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'მუჰ.',
							'საფ.',
							'რაბ. I',
							'რაბ. II',
							'ჯუმ. I',
							'ჯუმ. II',
							'რაჯ.',
							'შაბ.',
							'რამ.',
							'შავ.',
							'ზულ-კ.',
							'ზულ-ჰ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'მუჰარამი',
							'საფარი',
							'რაბი ულ-ავალი',
							'რაბი ულ-ახირი',
							'ჯუმადა ულ-ავალი',
							'ჯუმადა ულ-ახირი',
							'რაჯაბი',
							'შაბანი',
							'რამადანი',
							'შავალი',
							'ზულ-კაადა',
							'ზულ-ჰიჯა'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ფარვარდინი',
							'ორდიბეჰეშთი',
							'ხორდადი',
							'თირი',
							'მორდადი',
							'შაჰრივარი',
							'მეჰრი',
							'აბანი',
							'აზარი',
							'დეი',
							'ბაჰმანი',
							'ესფანდი'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ორშ',
						tue => 'სამ',
						wed => 'ოთხ',
						thu => 'ხუთ',
						fri => 'პარ',
						sat => 'შაბ',
						sun => 'კვი'
					},
					narrow => {
						mon => 'ო',
						tue => 'ს',
						wed => 'ო',
						thu => 'ხ',
						fri => 'პ',
						sat => 'შ',
						sun => 'კ'
					},
					short => {
						mon => 'ორ',
						tue => 'სმ',
						wed => 'ოთ',
						thu => 'ხთ',
						fri => 'პრ',
						sat => 'შბ',
						sun => 'კვ'
					},
					wide => {
						mon => 'ორშაბათი',
						tue => 'სამშაბათი',
						wed => 'ოთხშაბათი',
						thu => 'ხუთშაბათი',
						fri => 'პარასკევი',
						sat => 'შაბათი',
						sun => 'კვირა'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ორშ',
						tue => 'სამ',
						wed => 'ოთხ',
						thu => 'ხუთ',
						fri => 'პარ',
						sat => 'შაბ',
						sun => 'კვი'
					},
					narrow => {
						mon => 'ო',
						tue => 'ს',
						wed => 'ო',
						thu => 'ხ',
						fri => 'პ',
						sat => 'შ',
						sun => 'კ'
					},
					short => {
						mon => 'ორ',
						tue => 'სმ',
						wed => 'ოთ',
						thu => 'ხთ',
						fri => 'პრ',
						sat => 'შბ',
						sun => 'კვ'
					},
					wide => {
						mon => 'ორშაბათი',
						tue => 'სამშაბათი',
						wed => 'ოთხშაბათი',
						thu => 'ხუთშაბათი',
						fri => 'პარასკევი',
						sat => 'შაბათი',
						sun => 'კვირა'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'I კვ.',
						1 => 'II კვ.',
						2 => 'III კვ.',
						3 => 'IV კვ.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'I კვარტალი',
						1 => 'II კვარტალი',
						2 => 'III კვარტალი',
						3 => 'IV კვარტალი'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'I კვ.',
						1 => 'II კვ.',
						2 => 'III კვ.',
						3 => 'IV კვ.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'I კვარტალი',
						1 => 'II კვარტალი',
						2 => 'III კვარტალი',
						3 => 'IV კვარტალი'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{ნაშუადღ.},
					'am' => q{AM},
					'evening1' => q{საღ.},
					'midnight' => q{შუაღამეს},
					'morning1' => q{დილ.},
					'night1' => q{ღამ.},
					'noon' => q{შუადღ.},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{ნაშუადღ.},
					'am' => q{a},
					'evening1' => q{საღ.},
					'midnight' => q{შუაღამეს},
					'morning1' => q{დილ.},
					'night1' => q{ღამ.},
					'noon' => q{შუადღ.},
					'pm' => q{p},
				},
				'wide' => {
					'afternoon1' => q{ნაშუადღევს},
					'am' => q{AM},
					'evening1' => q{საღამოს},
					'midnight' => q{შუაღამეს},
					'morning1' => q{დილით},
					'night1' => q{ღამით},
					'noon' => q{შუადღეს},
					'pm' => q{PM},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{ნაშუადღევი},
					'am' => q{AM},
					'evening1' => q{საღამო},
					'midnight' => q{შუაღამე},
					'morning1' => q{დილა},
					'night1' => q{ღამე},
					'noon' => q{შუადღე},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{ნაშუადღევი},
					'am' => q{AM},
					'evening1' => q{საღამო},
					'midnight' => q{შუაღამე},
					'morning1' => q{დილა},
					'night1' => q{ღამე},
					'noon' => q{შუადღე},
					'pm' => q{PM},
				},
				'wide' => {
					'afternoon1' => q{ნაშუადღევი},
					'am' => q{AM},
					'evening1' => q{საღამო},
					'midnight' => q{შუაღამე},
					'morning1' => q{დილა},
					'night1' => q{ღამე},
					'noon' => q{შუადღე},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ძვ. წ.',
				'1' => 'ახ. წ.'
			},
			wide => {
				'0' => 'ძველი წელთაღრიცხვით',
				'1' => 'ახალი წელთაღრიცხვით'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, dd MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{dd.MM.y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM. y},
			'short' => q{dd.MM.yy},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM, y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			GyMd => q{d.M.y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d.M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M.y G},
			yyyyMEd => q{E, d.M.y G},
			yyyyMMM => q{MMM, y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d.M.y G},
			yyyyQQQ => q{QQQ, y G},
			yyyyQQQQ => q{QQQQ, y G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E, HH:mm},
			EHms => q{E, HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM. y G},
			GyMMMEd => q{E, d MMM. y G},
			GyMMMd => q{d MMM. y G},
			GyMd => q{d.M.y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, d.M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMW => q{MMMMს კვირა W},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M.y},
			yMEd => q{E, d.M.y},
			yMMM => q{MMM. y},
			yMMMEd => q{E, d MMM. y},
			yMMMM => q{MMMM, y},
			yMMMd => q{d MMM. y},
			yMd => q{d.M.y},
			yQQQ => q{QQQ, y},
			yQQQQ => q{QQQQ, y},
			yw => q{კვირა w, Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				B => q{h B – h B},
				h => q{h – h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm – h:mm B},
				m => q{h:mm–h:mm B},
			},
			Gy => {
				G => q{G y – G y},
				y => q{G y–y},
			},
			GyM => {
				G => q{GGGGG y-MM – GGGGG y-MM},
				M => q{GGGGG y-MM – y-MM},
				y => q{GGGGG y-MM – y-MM},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM. – E, dd.MM.},
				d => q{E, dd.MM. – E, dd.MM.},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM. – dd.MM.},
				d => q{dd.MM. – dd.MM.},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y G},
				d => q{E, dd.MM.y – E, dd.MM.y G},
				y => q{E, dd.MM.y – E, dd.MM.y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y G},
				d => q{E, d – E, d MMM y G},
				y => q{E, d MMM, y – E, d MMM, y G},
			},
			yMMMM => {
				M => q{MM – MM.y G},
				y => q{MM.y – MM.y G},
			},
			yMMMd => {
				M => q{dd MM – dd MM, y},
				d => q{d – d MMM, y},
				y => q{dd MMM, y – d MMM, y},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
		},
		'gregorian' => {
			Bh => {
				B => q{h B – h B},
				h => q{h–h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm–h:mm B},
				m => q{h:mm–h:mm B},
			},
			Gy => {
				G => q{G y – G y},
				y => q{G y–y},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM. – E, dd.MM.},
				d => q{E, dd.MM. – E, dd.MM.},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM. – dd.MM.},
				d => q{dd.MM. – dd.MM.},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{E, dd.MM.y – E, dd.MM.y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM. – E, d MMM. y},
				d => q{E, d MMM. – E, d MMM. y},
				y => q{E, d MMM. y – E, d MMM. y},
			},
			yMMMM => {
				M => q{MMMM – MMMM, y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{dd MMM. – dd MMM. y},
				d => q{d–d MMM, y},
				y => q{dd MMM. y – d MMM. y},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(დრო: {0}),
		regionFormat => q({0} ზაფხულის დრო),
		regionFormat => q({0} სტანდარტული დრო),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#ავღანეთის დრო#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#აბიჯანი#,
		},
		'Africa/Accra' => {
			exemplarCity => q#აკრა#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ადის-აბება#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ალჟირი#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ასმარა#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ბამაკო#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ბანგი#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ბანჯული#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ბისაუ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ბლანტირი#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ბრაზავილი#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ბუჯუმბურა#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#კაირო#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#კასაბლანკა#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#სეუტა#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#კონაკრი#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#დაკარი#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#დარ-ეს-სალამი#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ჯიბუტი#,
		},
		'Africa/Douala' => {
			exemplarCity => q#დუალა#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ელ-ააიუნი#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ფრიტაუნი#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#გაბორონე#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ჰარარე#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#იოჰანესბურგი#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ჯუბა#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#კამპალა#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ხარტუმი#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#კიგალი#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#კინშასა#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ლაგოსი#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ლიბრევილი#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ლომე#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ლუანდა#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ლუბუმბაში#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ლუსაკა#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#მალაბო#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#მაპუტო#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#მასერუ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#მბაბანე#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#მოგადიშუ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#მონროვია#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ნაირობი#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ნჯამენა#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ნიამეი#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ნუაკშოტი#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#უაგადუგუ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#პორტო-ნოვო#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#სენ-ტომე#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ტრიპოლი#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ტუნისი#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ვინდხუკი#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ცენტრალური აფრიკის დრო#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#აღმოსავლეთ აფრიკის დრო#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#სამხრეთ აფრიკის დრო#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#დასავლეთ აფრიკის ზაფხულის დრო#,
				'generic' => q#დასავლეთ აფრიკის დრო#,
				'standard' => q#დასავლეთ აფრიკის სტანდარტული დრო#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ალასკის ზაფხულის დრო#,
				'generic' => q#ალასკის დრო#,
				'standard' => q#ალასკის სტანდარტული დრო#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ამაზონიის ზაფხულის დრო#,
				'generic' => q#ამაზონიის დრო#,
				'standard' => q#ამაზონიის სტანდარტული დრო#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ადაკი#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ენქორაჯი#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ანგილია#,
		},
		'America/Antigua' => {
			exemplarCity => q#ანტიგუა#,
		},
		'America/Araguaina' => {
			exemplarCity => q#არაგუაინა#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ლა რიოხა#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#რიო გალეგოსი#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#სალტა#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#სან ხუანი#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#სან-ლუისი#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ტუკუმანი#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#უშუაია#,
		},
		'America/Aruba' => {
			exemplarCity => q#არუბა#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ასუნსიონი#,
		},
		'America/Bahia' => {
			exemplarCity => q#ბაია#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ბაჰია ბანდერასი#,
		},
		'America/Barbados' => {
			exemplarCity => q#ბარბადოსი#,
		},
		'America/Belem' => {
			exemplarCity => q#ბელემი#,
		},
		'America/Belize' => {
			exemplarCity => q#ბელიზი#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ბლან-საბლონი#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ბოა ვისტა#,
		},
		'America/Bogota' => {
			exemplarCity => q#ბოგოტა#,
		},
		'America/Boise' => {
			exemplarCity => q#ბუასი#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ბუენოს-აირესი#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#კემბრიჯ ბეი#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#კამპო გრანდე#,
		},
		'America/Cancun' => {
			exemplarCity => q#კანკუნი#,
		},
		'America/Caracas' => {
			exemplarCity => q#კარაკასი#,
		},
		'America/Catamarca' => {
			exemplarCity => q#კატამარკა#,
		},
		'America/Cayenne' => {
			exemplarCity => q#კაიენა#,
		},
		'America/Cayman' => {
			exemplarCity => q#კაიმანი#,
		},
		'America/Chicago' => {
			exemplarCity => q#ჩიკაგო#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ჩიჰუაჰუა#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ატიკოკანი#,
		},
		'America/Cordoba' => {
			exemplarCity => q#კორდობა#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#კოსტა-რიკა#,
		},
		'America/Creston' => {
			exemplarCity => q#კრესტონი#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#კუიაბა#,
		},
		'America/Curacao' => {
			exemplarCity => q#კიურასაო#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#დენმარკშავნი#,
		},
		'America/Dawson' => {
			exemplarCity => q#დოუსონი#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#დოუსონ ქრიკი#,
		},
		'America/Denver' => {
			exemplarCity => q#დენვერი#,
		},
		'America/Detroit' => {
			exemplarCity => q#დეტროიტი#,
		},
		'America/Dominica' => {
			exemplarCity => q#დომინიკა#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ედმონტონი#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ეირუნეპე#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#სალვადორი#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ფორტ-ნელსონი#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ფორტალეზა#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#გლეის ბეი#,
		},
		'America/Godthab' => {
			exemplarCity => q#გოდთები#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#გუზ ბეი#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#გრანდ-ტურკი#,
		},
		'America/Grenada' => {
			exemplarCity => q#გრენადა#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#გვადელუპა#,
		},
		'America/Guatemala' => {
			exemplarCity => q#გვატემალა#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#გუაიაკილი#,
		},
		'America/Guyana' => {
			exemplarCity => q#გაიანა#,
		},
		'America/Halifax' => {
			exemplarCity => q#ჰალიფაქსი#,
		},
		'America/Havana' => {
			exemplarCity => q#ჰავანა#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ჰერმოსილო#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ნოქსი, ინდიანა#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#მარენგო, ინდიანა#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#პიტერსბურგი, ინდიანა#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#თელ სითი, ინდიანა#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ვივეი, ინდიანა#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ვინსენი, ინდიანა#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#უინემაკი, ინდიანა#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ინდიანაპოლისი#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ინუვიკი#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#იქალუიტი#,
		},
		'America/Jamaica' => {
			exemplarCity => q#იამაიკა#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ჯუჯუი#,
		},
		'America/Juneau' => {
			exemplarCity => q#ჯუნო#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#მონტიჩელო, კენტუკი#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#კრალენდიიკი#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ლა-პაზი#,
		},
		'America/Lima' => {
			exemplarCity => q#ლიმა#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ლოს-ანჯელესი#,
		},
		'America/Louisville' => {
			exemplarCity => q#ლუისვილი#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ლოერ პრინც კვორტერი#,
		},
		'America/Maceio' => {
			exemplarCity => q#მასეიო#,
		},
		'America/Managua' => {
			exemplarCity => q#მანაგუა#,
		},
		'America/Manaus' => {
			exemplarCity => q#მანაუსი#,
		},
		'America/Marigot' => {
			exemplarCity => q#მარიგო#,
		},
		'America/Martinique' => {
			exemplarCity => q#მარტინიკი#,
		},
		'America/Matamoros' => {
			exemplarCity => q#მატამოროსი#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#მაზატლანი#,
		},
		'America/Mendoza' => {
			exemplarCity => q#მენდოზა#,
		},
		'America/Menominee' => {
			exemplarCity => q#მენომინი#,
		},
		'America/Merida' => {
			exemplarCity => q#მერიდა#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#მეტლაკატლა#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#მეხიკო#,
		},
		'America/Miquelon' => {
			exemplarCity => q#მიკელონი#,
		},
		'America/Moncton' => {
			exemplarCity => q#მონქტონი#,
		},
		'America/Monterrey' => {
			exemplarCity => q#მონტერეი#,
		},
		'America/Montevideo' => {
			exemplarCity => q#მონტევიდეო#,
		},
		'America/Montserrat' => {
			exemplarCity => q#მონსერატი#,
		},
		'America/Nassau' => {
			exemplarCity => q#ნასაუ#,
		},
		'America/New_York' => {
			exemplarCity => q#ნიუ-იორკი#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ნიპიგონი#,
		},
		'America/Nome' => {
			exemplarCity => q#ნომი#,
		},
		'America/Noronha' => {
			exemplarCity => q#ნორონია#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ბიულა, ჩრდილოეთი დაკოტა#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ცენტრი, ჩრდილოეთი დაკოტა#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ნიუ-სალემი, ჩრდილოეთი დაკოტა#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ოხინაგა#,
		},
		'America/Panama' => {
			exemplarCity => q#პანამა#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#პანგნირტუნგი#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#პარამარიბო#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ფენიქსი#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#პორტ-ა-პრინსი#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#პორტ-ოვ-სპეინი#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#პორტუ-ველიო#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#პუერტო-რიკო#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#პუნტა-არენასი#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#რეინი რივერი#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#რენკინ ინლეტი#,
		},
		'America/Recife' => {
			exemplarCity => q#რეციფე#,
		},
		'America/Regina' => {
			exemplarCity => q#რეჯინა#,
		},
		'America/Resolute' => {
			exemplarCity => q#რეზოლუტე#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#რიო ბრანკო#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#სანტა ისაბელი#,
		},
		'America/Santarem' => {
			exemplarCity => q#სანტარემი#,
		},
		'America/Santiago' => {
			exemplarCity => q#სანტიაგო#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#სანტო-დომინგო#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#სან-პაულუ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#სკორსბისუნდი#,
		},
		'America/Sitka' => {
			exemplarCity => q#სიტკა#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#სენ-ბართელემი#,
		},
		'America/St_Johns' => {
			exemplarCity => q#სენტ-ჯონსი#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#სენტ-კიტსი#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#სენტ-ლუსია#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#სენ-ტომასი#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#სენ-ვინსენტი#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#სვიფტ კარენტი#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ტეგუჩიგალპა#,
		},
		'America/Thule' => {
			exemplarCity => q#თულე#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#თანდერ ბეი#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ტიხუანა#,
		},
		'America/Toronto' => {
			exemplarCity => q#ტორონტო#,
		},
		'America/Tortola' => {
			exemplarCity => q#ტორტოლა#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ვანკუვერი#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#უაითჰორსი#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#უინიპეგი#,
		},
		'America/Yakutat' => {
			exemplarCity => q#იაკუტატი#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#იელოუნაიფი#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#ჩრდილოეთ ამერიკის ცენტრალური ზაფხულის დრო#,
				'generic' => q#ჩრდილოეთ ამერიკის ცენტრალური დრო#,
				'standard' => q#ჩრდილოეთ ამერიკის ცენტრალური სტანდარტული დრო#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ჩრდილოეთ ამერიკის აღმოსავლეთის ზაფხულის დრო#,
				'generic' => q#ჩრდილოეთ ამერიკის აღმოსავლეთის დრო#,
				'standard' => q#ჩრდილოეთ ამერიკის აღმოსავლეთის სტანდარტული დრო#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ჩრდილოეთ ამერიკის მაუნთინის ზაფხულის დრო#,
				'generic' => q#ჩრდილოეთ ამერიკის მაუნთინის დრო#,
				'standard' => q#ჩრდილოეთ ამერიკის მაუნთინის სტანდარტული დრო#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#ჩრდილოეთ ამერიკის წყნარი ოკეანის ზაფხულის დრო#,
				'generic' => q#ჩრდილოეთ ამერიკის წყნარი ოკეანის დრო#,
				'standard' => q#ჩრდილოეთ ამერიკის წყნარი ოკეანის სტანდარტული დრო#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#კეისი#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#დევისი#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#დიუმონ დ’ურვილი#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#მექვორი#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#მოუსონი#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#მაკმურდო#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#პალმერი#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#როთერა#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#სიოუა#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ტროლი#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ვოსტოკი#,
		},
		'Apia' => {
			long => {
				'daylight' => q#აპიას ზაფხულის დრო#,
				'generic' => q#აპიას დრო#,
				'standard' => q#აპიას სტანდარტული დრო#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#არაბეთის ზაფხულის დრო#,
				'generic' => q#არაბეთის დრო#,
				'standard' => q#არაბეთის სტანდარტული დრო#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ლონგირბიენი#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#არგენტინის ზაფხულის დრო#,
				'generic' => q#არგენტინის დრო#,
				'standard' => q#არგენტინის სტანდარტული დრო#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#დასავლეთ არგენტინის ზაფხულის დრო#,
				'generic' => q#დასავლეთ არგენტინის დრო#,
				'standard' => q#დასავლეთ არგენტინის სტანდარტული დრო#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#სომხეთის ზაფხულის დრო#,
				'generic' => q#სომხეთის დრო#,
				'standard' => q#სომხეთის სტანდარტული დრო#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ადენი#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ალმატი#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ამანი#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ანადირი#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#აქტაუ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#აქტობე#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#აშხაბადი#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#ატირაუ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ბაღდადი#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ბაჰრეინი#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ბაქო#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ბანგკოკი#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#ბარნაული#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ბეირუთი#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ბიშკეკი#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ბრუნეი#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#კალკუტა#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ჩიტა#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ჩოიბალსანი#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#კოლომბო#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#დამასკი#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#დაკა#,
		},
		'Asia/Dili' => {
			exemplarCity => q#დილი#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#დუბაი#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#დუშანბე#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ფამაგუსტა#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#გაზა#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ჰებრონი#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ჰონკონგი#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ჰოვდი#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ირკუტსკი#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ჯაკარტა#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ჯაიაპურა#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#იერუსალიმი#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ქაბული#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#კამჩატკა#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#კარაჩი#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#კატმანდუ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ხანდიგა#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#კრასნოიარსკი#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#კუალა-ლუმპური#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#კუჩინგი#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ქუვეითი#,
		},
		'Asia/Macau' => {
			exemplarCity => q#მაკაო#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#მაგადანი#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#მაკასარი#,
		},
		'Asia/Manila' => {
			exemplarCity => q#მანილა#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#მუსკატი#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ნიკოსია#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ნოვოკუზნეცკი#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ნოვოსიბირსკი#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ომსკი#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ორალი#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#პნომპენი#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#პონტიანაკი#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ფხენიანი#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#კატარი#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#კოსტანაი#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ყიზილორდა#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#რანგუნი#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ერ-რიადი#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ჰოჩიმინი#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#სახალინი#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#სამარყანდი#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#სეული#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#შანხაი#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#სინგაპური#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#სრედნეკოლიმსკი#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ტაიპეი#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ტაშკენტი#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#თბილისი#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#თეირანი#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#თხიმფხუ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ტოკიო#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ტომსკი#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ულანბატარი#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ურუმქი#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#უსტ-ნერა#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ვიენტიანი#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ვლადივოსტოკი#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#იაკუტსკი#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ეკატერინბურგი#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ერევანი#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ატლანტიკის ოკეანის ზაფხულის დრო#,
				'generic' => q#ატლანტიკის ოკეანის დრო#,
				'standard' => q#ატლანტიკის ოკეანის სტანდარტული დრო#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#აზორის კუნძულები#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ბერმუდა#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#კანარი#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#კაბო-ვერდე#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ფარერის კუნძულები#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#მადეირა#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#რეიკიავიკი#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#სამხრეთ ჯორჯია#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#წმ. ელენეს კუნძული#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#სტენლი#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ადელაიდა#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ბრისბეინი#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ბროუკენ ჰილი#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ქური#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#დარვინი#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ეუკლა#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ჰობარტი#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ლინდმანი#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ლორდ ჰოუი#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#მელბურნი#,
		},
		'Australia/Perth' => {
			exemplarCity => q#პერთი#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#სიდნეი#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ავსტრალიის ცენტრალური ზაფხულის დრო#,
				'generic' => q#ცენტრალური ავსტრალიის დრო#,
				'standard' => q#ავსტრალიის ცენტრალური სტანდარტული დრო#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ცენტრალური და დასავლეთ ავსტრალიის ზაფხულის დრო#,
				'generic' => q#ცენტრალური და დასავლეთ ავსტრალიის დრო#,
				'standard' => q#ცენტრალური და დასავლეთ ავსტრალიის სტანდარტული დრო#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#აღმოსავლეთ ავსტრალიის ზაფხულის დრო#,
				'generic' => q#აღმოსავლეთ ავსტრალიის დრო#,
				'standard' => q#აღმოსავლეთ ავსტრალიის სტანდარტული დრო#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#დასავლეთ ავსტრალიის ზაფხულის დრო#,
				'generic' => q#დასავლეთ ავსტრალიის დრო#,
				'standard' => q#დასავლეთ ავსტრალიის სტანდარტული დრო#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#აზერბაიჯანის ზაფხულის დრო#,
				'generic' => q#აზერბაიჯანის დრო#,
				'standard' => q#აზერბაიჯანის სტანდარტული დრო#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#აზორის კუნძულების ზაფხულის დრო#,
				'generic' => q#აზორის კუნძულების დრო#,
				'standard' => q#აზორის კუნძულების სტანდარტული დრო#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#ბანგლადეშის ზაფხულის დრო#,
				'generic' => q#ბანგლადეშის დრო#,
				'standard' => q#ბანგლადეშის სტანდარტული დრო#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ბუტანის დრო#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ბოლივიის დრო#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ბრაზილიის ზაფხულის დრო#,
				'generic' => q#ბრაზილიის დრო#,
				'standard' => q#ბრაზილიის სტანდარტული დრო#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ბრუნეი-დარუსალამის დრო#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#კაბო-ვერდეს ზაფხულის დრო#,
				'generic' => q#კაბო-ვერდეს დრო#,
				'standard' => q#კაბო-ვერდეს სტანდარტული დრო#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#ჩამოროს დრო#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#ჩატემის ზაფხულის დრო#,
				'generic' => q#ჩატემის დრო#,
				'standard' => q#ჩატემის სტანდარტული დრო#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ჩილეს ზაფხულის დრო#,
				'generic' => q#ჩილეს დრო#,
				'standard' => q#ჩილეს სტანდარტული დრო#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#ჩინეთის დროის სარტყელი#,
				'generic' => q#ჩინეთის დრო#,
				'standard' => q#ჩინეთის სტანდარტული დრო#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#ჩოიბალსანის ზაფხულის დრო#,
				'generic' => q#ჩოიბალსანის დრო#,
				'standard' => q#ჩოიბალსანის სტანდარტული დრო#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#შობის კუნძულის დრო#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ქოქოსის კუნძულების დრო#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#კოლუმბიის ზაფხულის დრო#,
				'generic' => q#კოლუმბიის დრო#,
				'standard' => q#კოლუმბიის სტანდარტული დრო#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#კუკის კუნძულების ნახევრად ზაფხულის დრო#,
				'generic' => q#კუკის კუნძულების დრო#,
				'standard' => q#კუკის კუნძულების სტანდარტული დრო#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#კუბის ზაფხულის დრო#,
				'generic' => q#კუბის დრო#,
				'standard' => q#კუბის სტანდარტული დრო#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#დევისის დრო#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#დუმონ-დურვილის დრო#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#აღმოსავლეთ ტიმორის დრო#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#აღდგომის კუნძულის ზაფხულის დრო#,
				'generic' => q#აღდგომის კუნძულის დრო#,
				'standard' => q#აღდგომის კუნძულის სტანდარტული დრო#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ეკვადორის დრო#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#მსოფლიო კოორდინირებული დრო#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#უცნობი ქალაქი#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ამსტერდამი#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ანდორა#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#ასტრახანი#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ათენი#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ბელგრადი#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ბერლინი#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ბრატისლავა#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ბრიუსელი#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ბუქარესტი#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ბუდაპეშტი#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ბუსინგენი#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#კიშინიოვი#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#კოპენჰაგენი#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#დუბლინი#,
			long => {
				'daylight' => q#ირლანდიის სტანდარტული დრო#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#გიბრალტარი#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#გერნსი#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ჰელსინკი#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#მენის კუნძული#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#სტამბოლი#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ჯერსი#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#კალინინგრადი#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#კიევი#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#კიროვი#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ლისაბონი#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ლიუბლიანა#,
		},
		'Europe/London' => {
			exemplarCity => q#ლონდონი#,
			long => {
				'daylight' => q#ბრიტანეთის ზაფხულის დრო#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ლუქსემბურგი#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#მადრიდი#,
		},
		'Europe/Malta' => {
			exemplarCity => q#მალტა#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#მარიჰამნი#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#მინსკი#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#მონაკო#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#მოსკოვი#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ოსლო#,
		},
		'Europe/Paris' => {
			exemplarCity => q#პარიზი#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#პოდგორიცა#,
		},
		'Europe/Prague' => {
			exemplarCity => q#პრაღა#,
		},
		'Europe/Riga' => {
			exemplarCity => q#რიგა#,
		},
		'Europe/Rome' => {
			exemplarCity => q#რომი#,
		},
		'Europe/Samara' => {
			exemplarCity => q#სამარა#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#სან-მარინო#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#სარაევო#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#სარატოვი#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#სიმფეროპოლი#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#სკოპიე#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#სოფია#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#სტოკჰოლმი#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ტალინი#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ტირანა#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ულიანოვსკი#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#უჟგოროდი#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ვადუცი#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ვატიკანი#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ვენა#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ვილნიუსი#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ვოლგოგრადი#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ვარშავა#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ზაგრები#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ზაპოროჟიე#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ციურიხი#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#ცენტრალური ევროპის ზაფხულის დრო#,
				'generic' => q#ცენტრალური ევროპის დრო#,
				'standard' => q#ცენტრალური ევროპის სტანდარტული დრო#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#აღმოსავლეთ ევროპის ზაფხულის დრო#,
				'generic' => q#აღმოსავლეთ ევროპის დრო#,
				'standard' => q#აღმოსავლეთ ევროპის სტანდარტული დრო#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#შორეული აღმოსავლეთ ევროპის დრო#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#დასავლეთ ევროპის ზაფხულის დრო#,
				'generic' => q#დასავლეთ ევროპის დრო#,
				'standard' => q#დასავლეთ ევროპის სტანდარტული დრო#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ფოლკლენდის კუნძულების ზაფხულის დრო#,
				'generic' => q#ფოლკლენდის კუნძულების დრო#,
				'standard' => q#ფოლკლენდის კუნძულების სტანდარტული დრო#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ფიჯის ზაფხულის დრო#,
				'generic' => q#ფიჯის დრო#,
				'standard' => q#ფიჯის სტანდარტული დრო#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#საფრანგეთის გვიანის დრო#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ფრანგული სამხრეთის და ანტარქტიკის დრო#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#გრინვიჩის საშუალო დრო#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#გალაპაგოსის დრო#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#გამბიერის დრო#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#საქართველოს ზაფხულის დრო#,
				'generic' => q#საქართველოს დრო#,
				'standard' => q#საქართველოს სტანდარტული დრო#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#გილბერტის კუნძულების დრო#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#აღმოსავლეთ გრენლანდიის ზაფხულის დრო#,
				'generic' => q#აღმოსავლეთ გრენლანდიის დრო#,
				'standard' => q#აღმოსავლეთ გრენლანდიის სტანდარტული დრო#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#დასავლეთ გრენლანდიის ზაფხულის დრო#,
				'generic' => q#დასავლეთ გრენლანდიის დრო#,
				'standard' => q#დასავლეთ გრენლანდიის სტანდარტული დრო#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#სპარსეთის ყურის სტანდარტული დრო#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#გაიანის დრო#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ჰავაისა და ალეუტის ზაფხულის დრო#,
				'generic' => q#ჰავაისა და ალეუტის დრო#,
				'standard' => q#ჰავაისა და ალეუტის სტანდარტული დრო#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ჰონკონგის ზაფხულის დრო#,
				'generic' => q#ჰონკონგის დრო#,
				'standard' => q#ჰონკონგის სტანდარტული დრო#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ჰოვდის ზაფხულის დრო#,
				'generic' => q#ჰოვდის დრო#,
				'standard' => q#ჰოვდის სტანდარტული დრო#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ინდოეთის დრო#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ანტანანარივუ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ჩაგოსი#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#შობის კუნძული#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ქოქოსი#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#კომორო#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#კერგელენი#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#მაჰე#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#მალდივები#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#მავრიკი#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#მაიოტი#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#რეიუნიონი#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ინდოეთის ოკეანის კუნძულების დრო#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ინდოჩინეთის დრო#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ცენტრალური ინდონეზიის დრო#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#აღმოსავლეთ ინდონეზიის დრო#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#დასავლეთ ინდონეზიის დრო#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ირანის დროის სარტყელი#,
				'generic' => q#ირანის დრო#,
				'standard' => q#ირანის სტანდარტული დრო#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ირკუტსკის ზაფხულის დრო#,
				'generic' => q#ირკუტსკის დრო#,
				'standard' => q#ირკუტსკის სტანდარტული დრო#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ისრაელის ზაფხულის დრო#,
				'generic' => q#ისრაელის დრო#,
				'standard' => q#ისრაელის სტანდარტული დრო#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#იაპონიის ზაფხულის დრო#,
				'generic' => q#იაპონიის დრო#,
				'standard' => q#იაპონიის სტანდარტული დრო#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#აღმოსავლეთ ყაზახეთის დრო#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#დასავლეთ ყაზახეთის დრო#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#კორეის ზაფხულის დრო#,
				'generic' => q#კორეის დრო#,
				'standard' => q#კორეის სტანდარტული დრო#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#კოსრეს დრო#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#კრასნოიარსკის ზაფხულის დრო#,
				'generic' => q#კრასნოიარსკის დრო#,
				'standard' => q#კრასნოიარსკის სტანდარტული დრო#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#ყირგიზეთის დრო#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ლაინის კუნძულების დრო#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#ლორდ-ჰაუს ზაფხულის დრო#,
				'generic' => q#ლორდ-ჰაუს დრო#,
				'standard' => q#ლორდ-ჰაუს სტანდარტული დრო#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#მაქკუორის კუნძულის დრო#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#მაგადანის ზაფხულის დრო#,
				'generic' => q#მაგადანის დრო#,
				'standard' => q#მაგადანის სტანდარტული დრო#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#მალაიზიის დრო#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#მალდივების დრო#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#მარკიზის კუნძულების დრო#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#მარშალის კუნძულების დრო#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#მავრიკის ზაფხულის დრო#,
				'generic' => q#მავრიკის დრო#,
				'standard' => q#მავრიკის სტანდარტული დრო#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#მოუსონის დრო#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#ჩრდილო-დასავლეთ მექსიკის ზაფხულის დრო#,
				'generic' => q#ჩრდილო-აღმოსავლეთ მექსიკის დრო#,
				'standard' => q#ჩრდილო-დასავლეთ მექსიკის დრო#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#მექსიკის წყნარი ოკეანის ზაფხულის დრო#,
				'generic' => q#მექსიკის წყნარი ოკეანის დრო#,
				'standard' => q#მექსიკის წყნარი ოკეანის სტანდარტული დრო#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ულან-ბატორის ზაფხულის დრო#,
				'generic' => q#ულან-ბატორის დრო#,
				'standard' => q#ულან-ბატორის სტანდარტული დრო#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#მოსკოვის ზაფხულის დრო#,
				'generic' => q#მოსკოვის დრო#,
				'standard' => q#მოსკოვის სტანდარტული დრო#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#მიანმარის დრო#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ნაურუს დრო#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#ნეპალის დრო#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#ახალი კალედონიის ზაფხულის დრო#,
				'generic' => q#ახალი კალედონიის დრო#,
				'standard' => q#ახალი კალედონიის სტანდარტული დრო#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ახალი ზელანდიის ზაფხულის დრო#,
				'generic' => q#ახალი ზელანდიის დრო#,
				'standard' => q#ახალი ზელანდიის სტანდარტული დრო#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ნიუფაუნდლენდის ზაფხულის დრო#,
				'generic' => q#ნიუფაუნდლენდის დრო#,
				'standard' => q#ნიუფაუნდლენდის სტანდარტული დრო#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#ნიუეს დრო#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#ნორფოლკის კუნძულის ზაფხულის დრო#,
				'generic' => q#ნორფოლკის კუნძულის დრო#,
				'standard' => q#ნორფოლკის კუნძულის სტანდარტული დრო#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ფერნანდო-დე-ნორონიას ზაფხულის დრო#,
				'generic' => q#ფერნანდო-დე-ნორონიას დრო#,
				'standard' => q#ფერნანდო-დე-ნორონიას სტანდარტული დრო#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#ნოვოსიბირსკის ზაფხულის დრო#,
				'generic' => q#ნოვოსიბირსკის დრო#,
				'standard' => q#ნოვოსიბირსკის სტანდარტული დრო#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ომსკის ზაფხულის დრო#,
				'generic' => q#ომსკის დრო#,
				'standard' => q#ომსკის სტანდარტული დრო#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#აპია#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ოკლენდი#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ბუგენვილი#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ჩათამი#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ისთერი#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ეფატე#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ენდერბური#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ფაკაოფო#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ფიჯი#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ფუნაფუტი#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#გალაპაგოსი#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#გამბიერი#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#გვადალკანალი#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#გუამი#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ჰონოლულუ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ჯონსტონი#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#კირიტიმატი#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#კოსრაე#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#კვაჯალეინი#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#მახურო#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#მარკეზასი#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#მიდუეი#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ნაურუ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ნიუე#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ნორფოლკი#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ნუმეა#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#პაგო-პაგო#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#პალაუ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#პიტკერნი#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#პონპეი#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#პორტ მორსბი#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#რაროტონგა#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#საიპანი#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ტაიტი#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ტარაუა#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ტონგატაპუ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ჩუუკი#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#უეიკი#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ვალისი#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#პაკისტანის ზაფხულის დრო#,
				'generic' => q#პაკისტანის დრო#,
				'standard' => q#პაკისტანის სტანდარტული დრო#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#პალაუს დრო#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#პაპუა-ახალი გვინეის დრო#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#პარაგვაის ზაფხულის დრო#,
				'generic' => q#პარაგვაის დრო#,
				'standard' => q#პარაგვაის სტანდარტული დრო#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#პერუს ზაფხულის დრო#,
				'generic' => q#პერუს დრო#,
				'standard' => q#პერუს სტანდარტული დრო#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ფილიპინების ზაფხულის დრო#,
				'generic' => q#ფილიპინების დრო#,
				'standard' => q#ფილიპინების სტანდარტული დრო#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ფენიქსის კუნძულების დრო#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#სენ-პიერის და მიკელონის ზაფხულის დრო#,
				'generic' => q#სენ-პიერის და მიკელონის დრო#,
				'standard' => q#სენ-პიერის და მიკელონის სტანდარტული დრო#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#პიტკერნის დრო#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#პონაპეს დრო#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ფხენიანის დრო#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#რეიუნიონის დრო#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#როთერის დრო#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#სახალინის ზაფხულის დრო#,
				'generic' => q#სახალინის დრო#,
				'standard' => q#სახალინის სტანდარტული დრო#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#სამოას ზაფხულის დრო#,
				'generic' => q#სამოას დრო#,
				'standard' => q#სამოას სტანდარტული დრო#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#სეიშელის კუნძულების დრო#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#სინგაპურის დრო#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#სოლომონის კუნძულების დრო#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#სამხრეთ გეორგიის დრო#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#სურინამის დრო#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#სიოვას დრო#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ტაიტის დრო#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ტაიბეის ზაფხულის დრო#,
				'generic' => q#ტაიბეის დრო#,
				'standard' => q#ტაიბეის სტანდარტული დრო#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ტაჯიკეთის დრო#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ტოკელაუს დრო#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ტონგის ზაფხულის დრო#,
				'generic' => q#ტონგის დრო#,
				'standard' => q#ტონგის სტანდარტული დრო#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ჩუუკის დრო#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#თურქმენეთის ზაფხულის დრო#,
				'generic' => q#თურქმენეთის დრო#,
				'standard' => q#თურქმენეთის სტანდარტული დრო#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ტუვალუს დრო#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ურუგვაის ზაფხულის დრო#,
				'generic' => q#ურუგვაის დრო#,
				'standard' => q#ურუგვაის სტანდარტული დრო#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#უზბეკეთის ზაფხულის დრო#,
				'generic' => q#უზბეკეთის დრო#,
				'standard' => q#უზბეკეთის სტანდარტული დრო#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ვანუატუს ზაფხულის დრო#,
				'generic' => q#ვანუატუს დრო#,
				'standard' => q#ვანუატუს სტანდარტული დრო#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ვენესუელის დრო#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ვლადივოსტოკის ზაფხულის დრო#,
				'generic' => q#ვლადივოსტოკის დრო#,
				'standard' => q#ვლადივოსტოკის სტანდარტული დრო#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ვოლგოგრადის ზაფხულის დრო#,
				'generic' => q#ვოლგოგრადის დრო#,
				'standard' => q#ვოლგოგრადის სტანდარტული დრო#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ვოსტოკის დრო#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ვეიკის კუნძულის დრო#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ვოლისი და ფუტუნას დრო#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#იაკუტსკის ზაფხულის დრო#,
				'generic' => q#იაკუტსკის დრო#,
				'standard' => q#იაკუტსკის სტანდარტული დრო#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ეკატერინბურგის ზაფხულის დრო#,
				'generic' => q#ეკატერინბურგის დრო#,
				'standard' => q#ეკატერინბურგის სტანდარტული დრო#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#იუკონის დრო#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
