=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Brx - Package for language Bodo

=cut

package Locale::CLDR::Locales::Brx;
# This file auto generated from Data\common\main\brx.xml
#	on Fri 28 Jun  8:55:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.45.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'ab' => 'आब्खाजियान',
 				'ace' => 'एचेनिज',
 				'ach' => 'अकोली',
 				'ada' => 'एडांगमे',
 				'ady' => 'अदिघे',
 				'ae' => 'अवस्तन्',
 				'af' => 'आफ्रिकान्स',
 				'afh' => 'अफ्रीहीली',
 				'agq' => 'आघेम',
 				'ain' => 'ऐनू',
 				'ak' => 'आकान',
 				'akk' => 'अकाडिनी',
 				'ale' => 'आलेउट',
 				'alt' => 'खोलायारि आल्टाई',
 				'am' => 'आम्हारिक',
 				'an' => 'आरागनिस',
 				'ang' => 'पुरानी अंग्रेज़ी',
 				'ann' => 'अबल’',
 				'anp' => 'आङिका',
 				'ar' => 'आराबिक',
 				'ar_001' => 'गोदान मानथाखोआरि आराबिक',
 				'arc' => 'अरामाईक',
 				'arn' => 'मापुचे',
 				'arp' => 'आरापाह’',
 				'ars' => 'नाजडी आराबिक',
 				'arw' => 'अरावाक',
 				'as' => 'असमिया',
 				'asa' => 'आसु',
 				'ast' => 'आस्तुरियान',
 				'atj' => 'आतिकामेको',
 				'av' => 'आभारिक',
 				'awa' => 'अवधी',
 				'ay' => 'आयमारा',
 				'az' => 'आजारबायजानि',
 				'az@alt=short' => 'आजेरि',
 				'ba' => 'बाशकिर',
 				'bal' => 'बलूची',
 				'ban' => 'बालिनिस',
 				'bas' => 'बासा',
 				'be' => 'बेलारुसियान',
 				'bej' => 'बेजा',
 				'bem' => 'बेम्बा',
 				'bez' => 'बेना',
 				'bg' => 'बुल्गारियान',
 				'bho' => 'भजपुरी',
 				'bi' => 'बिस्लामा',
 				'bik' => 'बिकोल्',
 				'bin' => 'बिनी',
 				'bla' => 'सीकसीका',
 				'bm' => 'बाम्बारा',
 				'bn' => 'बांला',
 				'bo' => 'तिब्बती',
 				'br' => 'ब्रेट’न',
 				'bra' => 'ब्रज',
 				'brx' => 'बर’',
 				'bs' => 'बस्नियान',
 				'bua' => 'बुरियात',
 				'bug' => 'बुगिनीज',
 				'byn' => 'ब्लीन',
 				'ca' => 'कातालान',
 				'cad' => 'काद्दौ',
 				'car' => 'कारीब्',
 				'cay' => 'कायुगा',
 				'cch' => 'आत्सम',
 				'ccp' => 'चाकमा',
 				'ce' => 'चेचेन',
 				'ceb' => 'चेबुआनो',
 				'cgg' => 'चीगा',
 				'ch' => 'चामोर्रो',
 				'chb' => 'चीबचा',
 				'chg' => 'चगताई',
 				'chk' => 'चुकेसे',
 				'chm' => 'मारि',
 				'chn' => 'चीनूक् जार्गन्',
 				'cho' => 'चक्टाऊ',
 				'chp' => 'चिपेव्यान',
 				'chr' => 'चेरकी',
 				'chy' => 'चेयेण',
 				'ckb' => 'मिरु कुर्दिस',
 				'ckb@alt=menu' => 'कुर्दिस, मिरु',
 				'ckb@alt=variant' => 'कुर्दिस, सरानि',
 				'clc' => 'चिल्कटिन',
 				'co' => 'कर्सिकान',
 				'cop' => 'कॉप्टीक्',
 				'cr' => 'क्री',
 				'crg' => 'मिचिफ',
 				'crh' => 'तुर्की क्रिमिया',
 				'crj' => 'खोलायारि सानजा क्री',
 				'crk' => 'हायेनारि क्री',
 				'crl' => 'साहायारि सानजा क्री',
 				'crm' => 'मूज क्री',
 				'crr' => 'केर’लिना एल्गंक्यान',
 				'cs' => 'चैक',
 				'csb' => 'काशुबियान्',
 				'csw' => 'स्वाम्पी क्री',
 				'cu' => 'चर्च स्लाविक्',
 				'cv' => 'चुभास',
 				'cy' => 'वैल्श',
 				'da' => 'डानिश',
 				'dak' => 'डाक’टा',
 				'dar' => 'दर्गवा',
 				'dav' => 'टाइटा',
 				'de' => 'जार्मान',
 				'de_AT' => 'अस्ट्रेयाआरि जार्मान',
 				'de_CH' => 'सुइस गोजौ जार्मान',
 				'del' => 'दलावार्',
 				'den' => 'स्लेव्',
 				'dgr' => 'डोगरीब',
 				'din' => 'डींगका',
 				'dje' => 'जार्मा',
 				'doi' => 'डोगरी',
 				'dsb' => 'गाहायसिन सर्बियान',
 				'dua' => 'डुआला',
 				'dum' => 'मध्य डच',
 				'dv' => 'दीवेही',
 				'dyo' => 'जला- फन्यी',
 				'dyu' => 'द्युआला',
 				'dz' => 'झंखा',
 				'dzg' => 'डाजागा',
 				'ebu' => 'इम्बु',
 				'ee' => 'एवे',
 				'efi' => 'एफिक',
 				'egy' => 'प्राचीन मिस्री',
 				'eka' => 'एकाजुक',
 				'el' => 'ग्रीक',
 				'elx' => 'एलामी',
 				'en' => 'इंराजी',
 				'en_AU' => 'अस्ट्रेलियानि इंराजी',
 				'en_CA' => 'कानाडानि इंराजी',
 				'en_GB' => 'ब्रिटिश इंराजी',
 				'en_GB@alt=short' => 'इउ.के इंराजी',
 				'en_US' => 'आमेरिकानि इंराजी',
 				'en_US@alt=short' => 'इउ.एस इंराजी',
 				'enm' => 'मध्य अंग्रेज़ी',
 				'eo' => 'एस्पेरान्त’',
 				'es' => 'स्पेनिश',
 				'es_419' => 'लेटीन आमेरिकानि स्पेनिश',
 				'es_ES' => 'युरोपनि स्पेनिश',
 				'es_MX' => 'मेक्सिक’नि स्पेनिश',
 				'et' => 'एस्ट’नियान',
 				'eu' => 'बास्क',
 				'ewo' => 'एव’न्द’',
 				'fa' => 'फार्सी',
 				'fa_AF' => 'डारी',
 				'fan' => 'फाँग्',
 				'fat' => 'फाँटी',
 				'ff' => 'फुलाह',
 				'fi' => 'फिन्निस',
 				'fil' => 'फिलिपिन’',
 				'fj' => 'फिजियान',
 				'fo' => 'फेर’वीज',
 				'fon' => 'फ’न',
 				'fr' => 'फ्रेन्च',
 				'fr_CA' => 'कानाडानि फ्रेन्च',
 				'fr_CH' => 'सुइस फ्रेन्च',
 				'frc' => 'काजुन फ्रेन्च',
 				'frm' => 'मध्य फ्रांसीसी',
 				'fro' => 'पुरानी फ्रांसीसी',
 				'frr' => 'उत्तरी फ्रीज़ियन्',
 				'frs' => 'पूर्वी फ्रीज़ियन्',
 				'fur' => 'फ्रिउलियान',
 				'fy' => 'सोनाबारि फ्रिजियान',
 				'ga' => 'आईरिश',
 				'gaa' => 'गा',
 				'gay' => 'गायो',
 				'gba' => 'ग्बाया',
 				'gd' => 'स्कटिस गैलिक',
 				'gez' => 'गीज',
 				'gil' => 'गील्बर्टिस',
 				'gl' => 'गेलिसियान',
 				'gmh' => 'मध्य उच्चस्तरी जर्मन',
 				'gn' => 'गुआरानी',
 				'goh' => 'पुरानी उच्चस्तरी जर्मन',
 				'gon' => 'गाँडी',
 				'gor' => 'गर’न्टाल’',
 				'got' => 'गॉथिक',
 				'grb' => 'ग्रेबो',
 				'grc' => 'प्राचीन यूनानी',
 				'gsw' => 'स्वीस जार्मान',
 				'gu' => 'गुजराती',
 				'guz' => 'गुशि',
 				'gv' => 'मेनक्स',
 				'gwi' => 'ग्वीचलीन',
 				'ha' => 'हाउसा',
 				'hai' => 'हाईडा',
 				'haw' => 'हावाईयान',
 				'hax' => 'खोलायारि हाईडा',
 				'he' => 'हिब्रिउ',
 				'hi' => 'हिन्दी',
 				'hil' => 'हिलीगैन’न',
 				'hit' => 'हीत्ती',
 				'hmn' => 'ह्मंग',
 				'ho' => 'हीरी मोटु',
 				'hr' => 'क्रवेशियान',
 				'hsb' => 'गोजौआरि सर्बियान',
 				'ht' => 'हाईटियान क्रिअल',
 				'hu' => 'हांगारियान',
 				'hup' => 'हूपा',
 				'hur' => 'हाल्क’मेलेम',
 				'hy' => 'आर्मेनियान',
 				'hz' => 'हेरेर’',
 				'ia' => 'ईन्टरलिंग्वा',
 				'iba' => 'ईबान',
 				'ibb' => 'ईबिबिय’',
 				'id' => 'ईण्डनेसियान',
 				'ie' => 'ईन्टरलिंग्वे',
 				'ig' => 'ईग्ब’',
 				'ii' => 'शीचुआन यी',
 				'ik' => 'इनुपियाक़्',
 				'ikt' => 'सोनाबारि कानाडियान इनुक्तितुत',
 				'ilo' => 'इल’क’',
 				'inh' => 'ईंगुष',
 				'io' => 'ईड’',
 				'is' => 'आइस्लेन्डिक',
 				'it' => 'इटालियान',
 				'iu' => 'इनुक्टीटुत',
 				'ja' => 'जापानीज',
 				'jbo' => 'ल’जबान',
 				'jgo' => 'न्गम्बा',
 				'jmc' => 'मेचामे',
 				'jpr' => 'यहुदी फ़ारसी',
 				'jrb' => 'यहुदी अरबी',
 				'jv' => 'जाभानीस',
 				'ka' => 'जर्जियान',
 				'kaa' => 'कारा कलपक',
 				'kab' => 'काबील',
 				'kac' => 'काचीन',
 				'kaj' => 'झु',
 				'kam' => 'काम्बा',
 				'kaw' => 'कावी',
 				'kbd' => 'काबार्डीयानि',
 				'kcg' => 'त्याप',
 				'kde' => 'माक’ण्डे',
 				'kea' => 'काबुभेर्डीयानु',
 				'kfo' => 'कर’',
 				'kg' => 'कॉंगो',
 				'kgp' => 'काईङां',
 				'kha' => 'खासि',
 				'kho' => 'ख़ोतानी',
 				'khq' => 'कईरा चीनि',
 				'ki' => 'किकुयु',
 				'kj' => 'कुआनयामा',
 				'kk' => 'काजाख',
 				'kkj' => 'काक’',
 				'kl' => 'कलालीसुत',
 				'kln' => 'कालेनजिन',
 				'km' => 'ख्मेर',
 				'kmb' => 'किम्बुन्डु',
 				'kn' => 'कन्नड',
 				'ko' => 'करियान',
 				'kok' => 'कोंकणी',
 				'kos' => 'कोस्राईयन्',
 				'kpe' => 'क्पेले',
 				'kr' => 'कनुरी',
 				'krc' => 'कराचय-बलकार',
 				'krl' => 'करेलियान',
 				'kru' => 'कुरुख',
 				'ks' => 'काश्मिरी',
 				'ksb' => 'शामबाला',
 				'ksf' => 'बाफिया',
 				'ksh' => 'कलगन्यान',
 				'ku' => 'कुर्दीश',
 				'kum' => 'कुमीक',
 				'kut' => 'कुतेनाई',
 				'kv' => 'क’मी',
 				'kw' => 'कर्निस',
 				'kwk' => 'क्वाकवाला',
 				'ky' => 'किरगीज',
 				'la' => 'लेटीन',
 				'lad' => 'लाडीन’',
 				'lag' => 'लाङि',
 				'lah' => 'लाह्डां',
 				'lam' => 'लांबा',
 				'lb' => 'लाक्जेमबुर्गीश',
 				'lez' => 'लेजघीयान',
 				'lg' => 'गान्डा',
 				'li' => 'लीम्बुर्गिस',
 				'lil' => 'लिल्लुवेत',
 				'lkt' => 'लाक’ता',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाऊ',
 				'lol' => 'मोंगो',
 				'lou' => 'लुईसियाना क्रेवल',
 				'loz' => 'ल’जी',
 				'lrc' => 'साहायारि लुरी',
 				'lsm' => 'सामीया',
 				'lt' => 'लिथुवानियान',
 				'lu' => 'लुबा-काटाङा',
 				'lua' => 'लुबा लुलुआ',
 				'lui' => 'लुईसेनो',
 				'lun' => 'लुण्डा',
 				'luo' => 'लुअ’',
 				'lus' => 'लुशाई',
 				'luy' => 'लुईया',
 				'lv' => 'लाटभियान',
 				'mad' => 'मादुरीज',
 				'mag' => 'मगाही',
 				'mai' => 'मैथीली',
 				'mak' => 'माकासार',
 				'man' => 'मांडींगो',
 				'mas' => 'मासाई',
 				'mdf' => 'मोक्षा',
 				'mdr' => 'मंदार',
 				'men' => 'मेन्दे',
 				'mer' => 'मेरु',
 				'mfe' => 'मरिछ्येन',
 				'mg' => 'मालागासी',
 				'mga' => 'मध्य आईरीश भाषा',
 				'mgh' => 'माखुवा- मीट्ट’',
 				'mgo' => 'मेता',
 				'mh' => 'मार्शेलिस',
 				'mi' => 'माऔरि',
 				'mic' => 'मिईकमाक',
 				'min' => 'मिनांकाबाऊ',
 				'mk' => 'मेसेड’नियान',
 				'ml' => 'मालायालम',
 				'mn' => 'मंगलियान',
 				'mnc' => 'मांचु',
 				'mni' => 'मनिपुरी',
 				'moe' => 'इन्नु-आइमुन',
 				'moh' => 'महाउक',
 				'mos' => 'मस्सी',
 				'mr' => 'माराथी',
 				'ms' => 'मलै',
 				'mt' => 'माल्टीज',
 				'mua' => 'मुन्दां',
 				'mul' => 'गोबां रावफोर',
 				'mus' => 'मुस्क’गी',
 				'mwl' => 'मिराण्डीज',
 				'mwr' => 'मारवाड़ी',
 				'my' => 'बार्मिस',
 				'myv' => 'एर्जीया',
 				'mzn' => 'माजान्देरानि',
 				'na' => 'नाऊरू',
 				'nap' => 'नियापलिटान',
 				'naq' => 'नामा',
 				'nb' => 'नरवैजियान बकमाल',
 				'nd' => 'साहा न्देबेले',
 				'nds' => 'गाहाय जार्मान',
 				'ne' => 'नेपाली',
 				'new' => 'नेवारी',
 				'ng' => 'न्डोंगा',
 				'nia' => 'नियास',
 				'niu' => 'नियुइआन',
 				'nl' => 'डात्च',
 				'nl_BE' => 'फ्लेमिस',
 				'nmg' => 'क्वासिअ’',
 				'nn' => 'नरवैजियान निनर्स्क',
 				'nnh' => 'न्गीएम्बून',
 				'no' => 'नरवैजियान',
 				'nog' => 'न’गाई',
 				'non' => 'पुरानी नॉर्स्',
 				'nqo' => 'नंक’',
 				'nr' => 'खोला न्देबेले',
 				'nso' => 'साहायारि सथ’',
 				'nus' => 'नूवेर',
 				'nv' => 'नावाहो',
 				'nwc' => 'पुरानी नेवारी',
 				'ny' => 'न्यान्जा',
 				'nym' => 'न्यामवेज़ी',
 				'nyn' => 'न्यानकोले',
 				'nyo' => 'न्यौरो',
 				'nzi' => 'न्ज़ीमा',
 				'oc' => 'अक्सितान',
 				'oj' => 'ओहीबवा',
 				'ojb' => 'साहा-सोनाबारि अजिब्वा',
 				'ojc' => 'मिरु अजिब्वा',
 				'ojs' => 'अजि क्री',
 				'ojw' => 'सोनाबारि अजिब्वा',
 				'oka' => 'अकानागान',
 				'om' => 'अरम’',
 				'or' => 'उरीया',
 				'os' => 'अस्सेटीक',
 				'osa' => 'ओसेज',
 				'ota' => 'तुर्की ओटोमान',
 				'pa' => 'पान्जाबी',
 				'pag' => 'पाङासिनान',
 				'pal' => 'पहलवी',
 				'pam' => 'पाम्पाङा',
 				'pap' => 'पापीआमेन्तो',
 				'pau' => 'पालाऊवान',
 				'pcm' => 'नाइजेरियान पिदजीन',
 				'peo' => 'पुरानी फ़ारसी',
 				'phn' => 'फीनीसी',
 				'pi' => 'पाली',
 				'pis' => 'पिजिन',
 				'pl' => 'पलिश',
 				'pon' => 'पोहनपी',
 				'pqm' => 'मालिसीत- पास्सामक्वद्दी',
 				'pro' => 'पुरानी प्रोवाँसाल',
 				'ps' => 'पाश्त’',
 				'pt' => 'पर्टुगिज',
 				'pt_BR' => 'ब्राजिलनि पर्टुगिज',
 				'pt_PT' => 'युरोपनि पर्टुगिज',
 				'qu' => 'क्वेचुआ',
 				'raj' => 'राजस्थानी',
 				'rap' => 'रापानुई',
 				'rar' => 'रार’टंगान',
 				'rhg' => 'रहिंगीया',
 				'rm' => 'रमान्श',
 				'rn' => 'रुन्दी',
 				'ro' => 'रमानीयान',
 				'ro_MD' => 'मोल्डेवियन्',
 				'rof' => 'रम्ब’',
 				'rom' => 'रुमानी',
 				'ru' => 'रासियान',
 				'rup' => 'आरोमानियान',
 				'rw' => 'किन्यार्वान्दा',
 				'rwk' => 'र्वा',
 				'sa' => 'संस्कृत',
 				'sad' => 'साण्डावे',
 				'sah' => 'साखा',
 				'sam' => 'समारीती आरामाईक़',
 				'saq' => 'साम्बुरू',
 				'sas' => 'सासक',
 				'sat' => 'सान्थाली',
 				'sba' => 'न्गाम्बै',
 				'sbp' => 'साङु',
 				'sc' => 'सार्दीनीयान',
 				'scn' => 'सिसिलियान',
 				'sco' => 'स्क’टस',
 				'sd' => 'सिन्धी',
 				'se' => 'साहायारि सामी',
 				'seh' => 'सेना',
 				'sel' => 'सेलकुप',
 				'ses' => 'कईराबर’ सेन्नि',
 				'sg' => 'साङ’',
 				'sga' => 'पुरानी आईरीश',
 				'sh' => 'सर्बो-क्रोएशन्',
 				'shi' => 'ताचेल्हीट',
 				'shn' => 'शान',
 				'si' => 'सींहाला',
 				'sid' => 'सीदामो',
 				'sk' => 'स्ल’भाक',
 				'sl' => 'स्लोभेनियान',
 				'slh' => 'खोलायारि लाशुतसीद',
 				'sm' => 'साम’वान',
 				'sma' => 'पश्चीमी सामी',
 				'smj' => 'लुले सामी',
 				'smn' => 'ईनारी सामी',
 				'sms' => 'स्कल्ट सामी',
 				'sn' => 'शना',
 				'snk' => 'स’निन्के',
 				'so' => 'स’माली',
 				'sog' => 'सोगडीयन',
 				'sq' => 'आल्बानियान',
 				'sr' => 'सार्बियान',
 				'srn' => 'स्रानान टंग’',
 				'srr' => 'सेरेर',
 				'ss' => 'स्वाटि',
 				'st' => 'खोलायारि सथ’',
 				'str' => 'स्ट्रैत्स सालिश',
 				'su' => 'सुन्दानी',
 				'suk' => 'सुकुमा',
 				'sus' => 'सुसु',
 				'sux' => 'सुमेरिअन',
 				'sv' => 'स्वीडिश',
 				'sw' => 'स्वाहिली',
 				'swb' => 'कमरियान',
 				'syc' => 'पारंपरीक सिरिआक',
 				'syr' => 'सिरिआक',
 				'ta' => 'तामिल',
 				'tce' => 'खोलायारि तात्चने',
 				'te' => 'तेलुगु',
 				'tem' => 'तीमने',
 				'teo' => 'तेस’',
 				'ter' => 'तेरेनो',
 				'tet' => 'तेतुम',
 				'tg' => 'ताजिक',
 				'tgx' => 'तागीश',
 				'th' => 'थाई',
 				'tht' => 'टाहल्टान',
 				'ti' => 'तिग्रीन्या',
 				'tig' => 'टीग्रे',
 				'tiv' => 'टीव्',
 				'tk' => 'तुर्कमेन',
 				'tkl' => 'टोकेलौ',
 				'tl' => 'तागालोग',
 				'tlh' => 'क्लिङ’न',
 				'tli' => 'त्लिङीत',
 				'tmh' => 'तमाशेक',
 				'tn' => 'त्स्वाना',
 				'to' => 'टंगान',
 				'tog' => 'न्यासा टॉंगा',
 				'tok' => 'टकि पना',
 				'tpi' => 'ट’क पिसीन',
 				'tr' => 'तुर्कीस',
 				'trv' => 'तार’क’',
 				'ts' => 'त्संगा',
 				'tsi' => 'त्सीमशीआन्',
 				'tt' => 'टाटार',
 				'ttm' => 'साहायारि तात्च’ने',
 				'tum' => 'तुम्बुका',
 				'tvl' => 'टुभालु',
 				'tw' => 'ट्वी',
 				'twq' => 'तेसावाक',
 				'ty' => 'टाहीटियान',
 				'tyv' => 'तुभिनियान',
 				'tzm' => 'सेन्ट्रेल आटलास तामाजाईट',
 				'udm' => 'उडमुर्त',
 				'ug' => 'उईघुर',
 				'uga' => 'उगारिती',
 				'uk' => 'युक्रेनियान',
 				'umb' => 'उम्बुन्डु',
 				'und' => 'मिथियै राव',
 				'ur' => 'ऊर्दु',
 				'uz' => 'उजबेक',
 				'vai' => 'भाई',
 				've' => 'भेन्डा',
 				'vi' => 'भियेतनामिस',
 				'vo' => 'वोलापोक',
 				'vot' => 'वोटीक',
 				'vun' => 'भुन्ज’',
 				'wa' => 'वाल्लुन',
 				'wae' => 'वाल्सार',
 				'wal' => 'वलाईत्ता',
 				'war' => 'वारै',
 				'was' => 'वाशो',
 				'wo' => 'वल’फ',
 				'wuu' => 'वु चाइनीज',
 				'xal' => 'कालमीक',
 				'xh' => 'ख’सा',
 				'xog' => 'स’गा',
 				'yao' => 'याओ',
 				'yap' => 'यापीज़',
 				'yav' => 'यांबेन',
 				'ybb' => 'येम्बा',
 				'yi' => 'यीद्दीश',
 				'yo' => 'यरूबा',
 				'yrl' => 'न्हीगातू',
 				'yue' => 'केन्टनिज',
 				'yue@alt=menu' => 'चाईनिज, केन्टनिज',
 				'za' => 'ज़ुआंग',
 				'zap' => 'ज़ापोतेक',
 				'zbl' => 'ब्लीस चिन्ह',
 				'zen' => 'ज़ेनागा',
 				'zgh' => 'स्टेन्दार्द मरक्कान तामाजाईट',
 				'zh' => 'चाइनीज',
 				'zh@alt=menu' => 'चाइनीज, मेण्डारिन',
 				'zh_Hans' => 'गोरलै खालामनाय चाइनीज',
 				'zh_Hans@alt=long' => 'गोरलै खालामनाय मेण्डारिन चाइनीज',
 				'zh_Hant' => 'आसार-खान्थियारि चाइनीज',
 				'zu' => 'जुलू',
 				'zun' => 'जुनी',
 				'zxx' => 'रावआरि आयदाफोर जेबो गैया',
 				'zza' => 'जाजा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'आदलाम',
 			'Arab' => 'आराबिक',
 			'Aran' => 'नास्तालिक',
 			'Armi' => 'शहनशाही आरामाईक',
 			'Armn' => 'आर्मेनियान',
 			'Avst' => 'अवस्तन्',
 			'Bali' => 'बाली',
 			'Batk' => 'बटकी',
 			'Beng' => 'बांला',
 			'Blis' => 'ब्लीस चीन्ह',
 			'Bopo' => 'बप’मफ’',
 			'Brah' => 'ब्रह्मी',
 			'Brai' => 'ब्रैल',
 			'Bugi' => 'बुगीनी',
 			'Buhd' => 'बुहीद',
 			'Cakm' => 'चाकमा',
 			'Cans' => 'जथाय कानाडीयान थागिबियारि रिंसार हानजा',
 			'Cari' => 'कारियन',
 			'Cham' => 'कॅम',
 			'Cher' => 'चेर’की',
 			'Cirt' => 'सिर्थ',
 			'Copt' => 'कॉप्ट',
 			'Cprt' => 'सीप्रीओट्',
 			'Cyrl' => 'सिरिल्लिक',
 			'Cyrs' => 'पुरानी चर्च सिरिलिक्',
 			'Deva' => 'देबनागिरि',
 			'Dsrt' => 'देसेरट्',
 			'Egyd' => 'मीस्री डैमोटीक्',
 			'Egyh' => 'मीस्री हैरैटीक्',
 			'Egyp' => 'मीस्री हैरोग्लीफ़्',
 			'Ethi' => 'ईथियपिक',
 			'Geok' => 'जोर्जीयन खुतसुरी',
 			'Geor' => 'जर्जियान',
 			'Glag' => 'ग्लैगोलिटीक',
 			'Goth' => 'गौथीक',
 			'Grek' => 'ग्रीक',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरमुखी',
 			'Hanb' => 'बप’मफ’ थानाय हान',
 			'Hang' => 'हांगुल',
 			'Hani' => 'हान',
 			'Hano' => 'हानुनु',
 			'Hans' => 'गोरलै खालामना होनाय',
 			'Hans@alt=stand-alone' => 'गोरलै खालामना होनाय हान',
 			'Hant' => 'आसार-खान्थिनि',
 			'Hant@alt=stand-alone' => 'आसार-खान्थिनि हान',
 			'Hebr' => 'हिब्रिऊ',
 			'Hira' => 'हीरागाना',
 			'Hmng' => 'पाहवाह ह्मौंग',
 			'Hrkt' => 'जापानीज रिंसारथिफोर/हांखोफोर',
 			'Hung' => 'पुरानी हंगैरीयन',
 			'Inds' => 'सिन्धु',
 			'Ital' => 'पुरानी इटैलियन',
 			'Jamo' => 'जाम’',
 			'Java' => 'जावानीस',
 			'Jpan' => 'जापानीज',
 			'Kali' => 'कायाह ली',
 			'Kana' => 'काताकाना',
 			'Khar' => 'खरोष्टी',
 			'Khmr' => 'ख्मेर',
 			'Knda' => 'कण्णडा',
 			'Kore' => 'क’रीयान',
 			'Lana' => 'लाना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ्रैक्तुर लैटिन',
 			'Latg' => 'गैलीक लैटिन',
 			'Latn' => 'लेटीन',
 			'Lepc' => 'लेपचा',
 			'Limb' => 'लिम्बु',
 			'Lina' => 'लीनीयर ए',
 			'Linb' => 'लीनीयर बी',
 			'Lyci' => 'लीसीयन',
 			'Lydi' => 'लीडीयन',
 			'Mand' => 'मांडे',
 			'Mani' => 'मानीकी',
 			'Maya' => 'माया हीरोग्लीफ्',
 			'Mero' => 'मेरोईटीक्',
 			'Mlym' => 'मलयालम',
 			'Mong' => 'मंगलियान',
 			'Moon' => 'मुन्',
 			'Mtei' => 'मैतेई मायेक',
 			'Mymr' => 'म्यानमार',
 			'Nkoo' => 'नंक’',
 			'Ogam' => 'ओगहैम',
 			'Olck' => 'अल चीकी',
 			'Orkh' => 'ओरखोन',
 			'Orya' => 'उड़िया',
 			'Osma' => 'ओस्मानिया',
 			'Perm' => 'पुरानी पर्मीक्',
 			'Phag' => 'फाग्स पा',
 			'Phlv' => 'बुक (सालटर) पहलवी',
 			'Phnx' => 'फोनीशीयन',
 			'Plrd' => 'पौलार्ड़ फोनेटीक',
 			'Rjng' => 'रेजेंग',
 			'Rohg' => 'हानिफि',
 			'Roro' => 'रोंगोरोंगो',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समारती',
 			'Sara' => 'सराती',
 			'Saur' => 'सौराष्ट्र',
 			'Sgnw' => 'सांकेतिक लेख',
 			'Shaw' => 'शेवियन',
 			'Sinh' => 'सिंहाली',
 			'Sund' => 'सून्डानीज',
 			'Sylo' => 'सील्होटी नागरी',
 			'Syrc' => 'सीरीआक',
 			'Syre' => 'एस्ट्रांगलो सीरीआक',
 			'Syrj' => 'पश्चीमी सीरीआक',
 			'Syrn' => 'पूर्वी सीरीआक',
 			'Tagb' => 'तागबानवा',
 			'Tale' => 'ताई ले',
 			'Talu' => 'नया ताई लुए',
 			'Taml' => 'तामिल',
 			'Telu' => 'तेलुगु',
 			'Teng' => 'तेंगवार',
 			'Tfng' => 'तिफिनाघ',
 			'Tglg' => 'टागालॉग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिबेतान',
 			'Ugar' => 'ऊगारीटीक',
 			'Vaii' => 'भाई',
 			'Visp' => 'वीज़ीबल बोली',
 			'Xpeo' => 'पुरानी फारसी',
 			'Xsux' => 'सुमेरो अक्काड़ी कुनेईफॉर्म',
 			'Yiii' => 'यी',
 			'Zinh' => 'विरासत',
 			'Zmth' => 'सानखान्थियारि दैदेन्नाय हांखोफोर',
 			'Zsye' => 'ईम’जी',
 			'Zsym' => 'नेर्सोनफोर',
 			'Zxxx' => 'लिरै',
 			'Zyyy' => 'साधारन',
 			'Zzzz' => 'मिथियै हांखो',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'बुहुम',
 			'002' => 'आफ्रिका',
 			'003' => 'साहा आमेरिका',
 			'005' => 'खोला आमेरिका',
 			'009' => 'ओशेआनिया',
 			'011' => 'सोनाबारि आफ्रिका',
 			'013' => 'मिरु आमेरिका',
 			'014' => 'सानजायारि आफ्रिका',
 			'015' => 'साहायारि आफ्रिका',
 			'017' => 'गेजेरारि आफ्रिका',
 			'018' => 'खोलायारि आफ्रिका',
 			'019' => 'आमेरिकानि',
 			'021' => 'साहायारि आमेरिका',
 			'029' => 'केरिबियान',
 			'030' => 'सानजायारि एसिया',
 			'034' => 'खोलायारि एसिया',
 			'035' => 'खोला-सानजा एसिया',
 			'039' => 'खोलायारि यूरोप',
 			'053' => 'अस्ट्रेलएसिया',
 			'054' => 'मेलानेसिया',
 			'057' => 'माईक्र’नेसियायारि ओनसोल',
 			'061' => 'पलिनेसिया',
 			'142' => 'एसिया',
 			'143' => 'मिरु एसिया',
 			'145' => 'सोनाबारि एसिया',
 			'150' => 'यूरोप',
 			'151' => 'सानजायारि यूरोप',
 			'154' => 'साहायारि यूरोप',
 			'155' => 'सोनाबारि यूरोप',
 			'202' => 'साहारायारि लोब्बा गोनां आफ्रिका',
 			'419' => 'लेटीन आमेरिका',
 			'AC' => 'एसेनसिअन द्वीप',
 			'AD' => 'एन्डर्रा',
 			'AE' => 'जथाय आराब एमिरेत',
 			'AF' => 'आफगानिस्तान',
 			'AG' => 'एन्टिगुआ आरो बारबुडा',
 			'AI' => 'एंगुइल्ला',
 			'AL' => 'आल्बानिया',
 			'AM' => 'आर्मेनिया',
 			'AO' => 'आंगला',
 			'AQ' => 'एन्टार्कटिका',
 			'AR' => 'आर्जेन्टिना',
 			'AS' => 'आमेरिकान सामआ',
 			'AT' => 'अस्ट्रिया',
 			'AU' => 'अस्ट्रेलिया',
 			'AW' => 'आरूबा',
 			'AX' => 'आलाण्ड द्वीपफोर',
 			'AZ' => 'आजेरबाईजान',
 			'BA' => 'बसनिया आरो होर्जेगभिना',
 			'BB' => 'बारबाड’स',
 			'BD' => 'बांलादेश',
 			'BE' => 'बेलजियाम',
 			'BF' => 'बुर्किना फास’',
 			'BG' => 'बुल्गारिया',
 			'BH' => 'बाहरैन',
 			'BI' => 'बुरूण्डी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सैन्ट बार्थेलेमी',
 			'BM' => 'बारमूडा',
 			'BN' => 'ब्रूने',
 			'BO' => 'बलिभिया',
 			'BQ' => 'केरिबियान नेदारलेण्डस',
 			'BR' => 'ब्राजील',
 			'BS' => 'बाहामास',
 			'BT' => 'भूटान',
 			'BV' => 'बूभेट द्वीप',
 			'BW' => 'बत्स्वाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलिज',
 			'CA' => 'केनाडा',
 			'CC' => 'कक’स द्वीपफोर',
 			'CD' => 'कंग’-किनशासा',
 			'CD@alt=variant' => 'कंग’ (दि.आर.सि)',
 			'CF' => 'मिरु आफ्रिका सुबुंखुंथाय',
 			'CG' => 'कंग’- ब्राज्जाभील',
 			'CG@alt=variant' => 'कंग’ (सुबुंखुंथाय)',
 			'CH' => 'सुईजारलेण्ड',
 			'CI' => 'कट दिभवेर',
 			'CI@alt=variant' => 'आईभरि कस्ट',
 			'CK' => 'कुक द्वीप',
 			'CL' => 'चिले',
 			'CM' => 'केमेरून',
 			'CN' => 'चाइना',
 			'CO' => 'कलम्बिया',
 			'CP' => 'क्लिप्पार्टन द्वीप',
 			'CR' => 'कस्टा रिका',
 			'CU' => 'क्यूबा',
 			'CV' => 'केप भेर्दे',
 			'CW' => 'कुरासाव',
 			'CX' => 'ख्रिसमास द्वीपफोर',
 			'CY' => 'साइप्रास',
 			'CZ' => 'चेखिया',
 			'CZ@alt=variant' => 'चेख सुबुंखुंथाय',
 			'DE' => 'जार्मानी',
 			'DG' => 'दियेग’ गार्सिया',
 			'DJ' => 'जिबौति',
 			'DK' => 'डेनमार्क',
 			'DM' => 'दमिनिका',
 			'DO' => 'दमिनिकान सुबुंखुंथाय',
 			'DZ' => 'आल्जेरिया',
 			'EA' => 'किउता आरो मेलिल्ला',
 			'EC' => 'एक्वाड’र',
 			'EE' => 'एस्ट’निया',
 			'EG' => 'ईजिप्त',
 			'EH' => 'सोनाबारि साहारा',
 			'ER' => 'एरिट्रिया',
 			'ES' => 'स्पैन',
 			'ET' => 'इथिय’पिया',
 			'EU' => 'यूरोपनि जथाय',
 			'EZ' => 'यूरो ओनसोल',
 			'FI' => 'फिनलेण्ड',
 			'FJ' => 'फिजी',
 			'FK' => 'फकलेण्ड द्वीपफोर',
 			'FM' => 'माइक्रनेशिया',
 			'FO' => 'फेर’ द्वीपफोर',
 			'FR' => 'फ्रान्स',
 			'GA' => 'गाबन',
 			'GB' => 'जथाय ब्रिटिश हादोर',
 			'GB@alt=short' => 'इउ.के',
 			'GD' => 'ग्रेनादा',
 			'GE' => 'जर्जिया',
 			'GF' => 'फ्रेन्च गिआना',
 			'GG' => 'गोर्नसि',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टार',
 			'GL' => 'ग्रीनलेण्ड',
 			'GM' => 'गाम्बिया',
 			'GN' => 'गिनीया',
 			'GP' => 'ग्वादेल्यूप',
 			'GQ' => 'बिसुबारि गिनीया',
 			'GR' => 'ग्रीस',
 			'GS' => 'खोला जर्जिया आरो खोला सेण्डवीच द्वीपफोर',
 			'GT' => 'गुवाटेमाला',
 			'GU' => 'गुआम',
 			'GW' => 'गिनीया- बिसाऊ',
 			'GY' => 'गुयाना',
 			'HK' => 'हंकं एस.ए.आर चाइना',
 			'HK@alt=short' => 'हंकं',
 			'HM' => 'होर्द आरो मेकद’नाल्ड द्वीपफोर',
 			'HN' => 'हण्डूरास',
 			'HR' => 'क्रवेशिया',
 			'HT' => 'हाइती',
 			'HU' => 'हांगारी',
 			'IC' => 'कानारि द्वीपफोर',
 			'ID' => 'इण्ड’नेशिया',
 			'IE' => 'आयारलेण्ड',
 			'IL' => 'इज्राईल',
 			'IM' => 'आयोल अफ मेन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिशनि भारतारि लैथो बाहागो',
 			'IQ' => 'ईराक',
 			'IR' => 'ईरान',
 			'IS' => 'आइसलेण्ड',
 			'IT' => 'इटाली',
 			'JE' => 'जोर्सि',
 			'JM' => 'जामाइका',
 			'JO' => 'जर्डान',
 			'JP' => 'जापान',
 			'KE' => 'केनिया',
 			'KG' => 'किर्गीस्तान',
 			'KH' => 'कम्ब’डिया',
 			'KI' => 'किरिबाती',
 			'KM' => 'कम’र’ज',
 			'KN' => 'सैन्ट कीत्स आरो नेभिस',
 			'KP' => 'साहा करिया',
 			'KR' => 'खोला करिया',
 			'KW' => 'कुवैत',
 			'KY' => 'कैमेन द्वीपफोर',
 			'KZ' => 'काजाखस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबान’न',
 			'LC' => 'सैन्ट लुसिया',
 			'LI' => 'लिक्तोनस्ताईन',
 			'LK' => 'श्रीलंका',
 			'LR' => 'लाइबेरिया',
 			'LS' => 'लेस’थ’',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लाक्जेमबुर्ग',
 			'LV' => 'लाटभीया',
 			'LY' => 'लीबिया',
 			'MA' => 'मरक्क’',
 			'MC' => 'मनाक’',
 			'MD' => 'मल्ड’भा',
 			'ME' => 'मन्टेनेग्र’',
 			'MF' => 'सैन्ट मार्तिन',
 			'MG' => 'मादागास्कार',
 			'MH' => 'मार्शेल द्वीप',
 			'MK' => 'साहा मेसेड’निया',
 			'ML' => 'माली',
 			'MM' => 'म्यानमार',
 			'MN' => 'मंगलिया',
 			'MO' => 'माकाउ एस.ए.आर चाइना',
 			'MO@alt=short' => 'माकाउ',
 			'MP' => 'साहायारि मारियाना द्वीप',
 			'MQ' => 'मार्तिनिक',
 			'MR' => 'माउरिटानिया',
 			'MS' => 'मनत्सेरात',
 			'MT' => 'माल्टा',
 			'MU' => 'मरिसियास',
 			'MV' => 'मालदीव',
 			'MW' => 'मालावी',
 			'MX' => 'मेक्सिक’',
 			'MY' => 'मालेशिया',
 			'MZ' => 'मजाम्बिक',
 			'NA' => 'नामीबिया',
 			'NC' => 'निउ केलेडनिया',
 			'NE' => 'नाइजेर',
 			'NF' => 'नर्फ’क द्वीप',
 			'NG' => 'नाइजेरिया',
 			'NI' => 'निकारागुआ',
 			'NL' => 'नेदारलेण्ड',
 			'NO' => 'नरवै',
 			'NP' => 'नेपाल',
 			'NR' => 'नाउरू',
 			'NU' => 'नीयूए',
 			'NZ' => 'न्यूजीलेण्ड',
 			'OM' => 'ओमान',
 			'PA' => 'पानामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्रेन्च पलिनेशिया',
 			'PG' => 'पापुआ निउ गिनी',
 			'PH' => 'फिलीपिन्स',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पलेण्ड',
 			'PM' => 'सैन्ट. पिएर आरो मिकैलन',
 			'PN' => 'पिटकाईर्न द्वीप',
 			'PR' => 'पुवेर्ट’ रीक’',
 			'PS' => 'पेलेस्ताइननि ओनसोलफोर',
 			'PS@alt=short' => 'पेलेस्ताइन',
 			'PT' => 'पर्तुगाल',
 			'PW' => 'पालाऊ',
 			'PY' => 'पारागुए',
 			'QA' => 'कातार',
 			'QO' => 'बायजोआरि असियानिया',
 			'RE' => 'रेयूनियन',
 			'RO' => 'रमानिया',
 			'RS' => 'सार्बिया',
 			'RU' => 'रासिया',
 			'RW' => 'रूआण्डा',
 			'SA' => 'साउदि आराबिया',
 			'SB' => 'सल’मन द्वीप',
 			'SC' => 'सैशेल्लेस',
 			'SD' => 'सूदान',
 			'SE' => 'स्वीडेन',
 			'SG' => 'सिंंगाप’र',
 			'SH' => 'सैन्ट हेलेना',
 			'SI' => 'स्ल’भेनिया',
 			'SJ' => 'स्भालबार्ड आरो जान मायेन',
 			'SK' => 'स्लभाकिया',
 			'SL' => 'सियेरा लेओन',
 			'SM' => 'सान मेरिन’',
 			'SN' => 'सेनेगाल',
 			'SO' => 'समालिया',
 			'SR' => 'सुरिनाम',
 			'SS' => 'खोला सुदान',
 			'ST' => 'साऊ तमे आरो प्रिन्सिप',
 			'SV' => 'एल साल्भाड’र',
 			'SX' => 'सिन्त मार्तेन',
 			'SY' => 'सीरिया',
 			'SZ' => 'एस्वातिनि',
 			'SZ@alt=variant' => 'स्वाजीलेण्ड',
 			'TA' => 'त्रिस्तान दा कुन्हा',
 			'TC' => 'तुर्की आरो काईक’ज द्वीपफोर',
 			'TD' => 'चाड',
 			'TF' => 'फ्रान्सनि खोलायारि बाहागोफोर',
 			'TG' => 'टग’',
 			'TH' => 'थाइलेण्ड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'टकेलाऊ',
 			'TL' => 'तिमर-लेस्ते',
 			'TL@alt=variant' => 'सानजा तिमर',
 			'TM' => 'तुर्कमेनीस्तान',
 			'TN' => 'त्युनिशिया',
 			'TO' => 'टंगा',
 			'TR' => 'तुर्की',
 			'TT' => 'त्रिनिडाड आरो तबेग’',
 			'TV' => 'तुभालु',
 			'TW' => 'ताइवान',
 			'TZ' => 'तान्जानिया',
 			'UA' => 'यूक्रेन',
 			'UG' => 'उगाण्डा',
 			'UM' => 'इउ.एस नि बायजोआरि द्वीपफोर',
 			'UN' => 'जथाय हादोरफोर',
 			'US' => 'जथाय हादोर आमेरिका',
 			'US@alt=short' => 'इउ. एस',
 			'UY' => 'ऊरुगुवे',
 			'UZ' => 'उजबेकिस्तान',
 			'VA' => 'भेटिकान नोगोर',
 			'VC' => 'सैन्ट भिन्सेन्ट आरो ग्रेनादीन्स',
 			'VE' => 'भेनेजुवेला',
 			'VG' => 'ब्रिटिश भार्जिन द्वीपफोर',
 			'VI' => 'इउ. एस भार्जिन द्वीपफोर',
 			'VN' => 'भियेतनाम',
 			'VU' => 'भानुआटु',
 			'WF' => 'वालिस आरो फ्युचुना',
 			'WS' => 'सामआ',
 			'XA' => 'नंखाइ-गारांबोलो',
 			'XB' => 'नंखाइ- बिदि',
 			'XK' => 'कस’भ’',
 			'YE' => 'येमेन',
 			'YT' => 'मायत्ते',
 			'ZA' => 'खोला आफ्रिका',
 			'ZM' => 'जाम्बिया',
 			'ZW' => 'जिम्बाब्वे',
 			'ZZ' => 'मिथियै ओनसोल',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'पारम्पारिक जर्मन वर्तनी 1901',
 			'1994' => 'पारम्पारिक रेसीयन वर्तनी 1994',
 			'1996' => 'जर्मन वर्तनी 1996',
 			'1606NICT' => 'मध्य फ्रांसीसी 1606 तक',
 			'AREVELA' => 'पूर्वी अर्मेनियाई',
 			'BAKU1926' => 'युनीफाईड तुर्की लैटीनी वर्तनी',
 			'BISKE' => 'सान जीओर्जीओ / बीला डायलेक्ट',
 			'BOONT' => 'बुन्तलींग',
 			'FONIPA' => 'आईपीए फ़ोनेटीक्स',
 			'FONUPA' => 'युपीए फ़ोनेटीक्स',
 			'LIPAW' => 'रेज़ीयन की लीपोवाज़ डायलेक्ट',
 			'MONOTON' => 'एकस्वरीय',
 			'NEDIS' => 'नाटीसोन डायलेक्ट',
 			'NJIVA' => 'ग्नीवा या न्जीवा डायलेक्ट',
 			'OSOJS' => 'ओसेआको ओसोजाने डायलेक्ट',
 			'POLYTON' => 'बहुस्वरीय',
 			'POSIX' => 'कम्प्यूटर',
 			'REVISED' => 'संशोधित वर्तनी',
 			'ROZAJ' => 'रेज़ीयन',
 			'SAAHO' => 'साहो',
 			'SCOTLAND' => 'मानक स्कॉट अंग्रेज़ी',
 			'SCOUSE' => 'स्काउज़',
 			'SOLBA' => 'श्टोलविज़्ज़ा या सोलबीका डायलेक्ट',
 			'TARASK' => 'तारास्कीएवीचा वर्तनी',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'केलेण्डार/फान्जामुथि',
 			'cf' => 'मुद्रानि नुथाय',
 			'collation' => 'रान्नायनि फारि',
 			'currency' => 'मुद्रा',
 			'hc' => 'घन्टानि गिदिंफिन्नाय ( 12 बेरेखा 24)',
 			'lb' => 'हांखो सिफायनाय दह‘ङ',
 			'ms' => 'जखा लानाय आदब',
 			'numbers' => 'अनजिमाफोर',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बौद्ध फान्जामुथि},
 				'chinese' => q{चाइनिज फान्जामुथि},
 				'coptic' => q{कप्तिक फान्जामुथि},
 				'dangi' => q{दांगि फान्जामुथि},
 				'ethiopic' => q{इथिय’पियानि फान्जामुथि},
 				'ethiopic-amete-alem' => q{इथिय’पिक आमेते आलेम फान्जामुथि},
 				'gregorian' => q{ग्रेग’रियान फान्जामुथि},
 				'hebrew' => q{हिब्रिउ फान्जामुथि},
 				'indian' => q{भारतनि हादोरनां फान्जामुथि},
 				'islamic' => q{इस्लामिक फान्जामुथि},
 				'islamic-civil' => q{इस्लामिक फान्जामुथि ( फारि, हादोरारि मुगा)},
 				'islamic-umalqura' => q{इस्लामिक फान्जामुथि( ऊम आल-कूरा)},
 				'iso8601' => q{आइ.एस.अ-8601 फान्जामुथि},
 				'japanese' => q{जापानीज फान्जामुथि},
 				'persian' => q{पार्सियान फान्जामुथि},
 				'roc' => q{मिंगुव’ फान्जामुथि},
 			},
 			'cf' => {
 				'account' => q{मुद्रानि नुथायखौ हिसाब लाखिनाय},
 				'standard' => q{थाखोआरि मुद्रानि नुथाय},
 			},
 			'collation' => {
 				'big5han' => q{पारम्पारिक चीनी वर्गीकरण बीग फ़ाईव},
 				'ducet' => q{गरहाजिर इउनिकड रान्नायनि फारि},
 				'gb2312han' => q{सरलीकृत चीनी वर्गीकरण जीबी2312},
 				'phonebook' => q{दूरभाष निर्देशिका वर्गीकरण},
 				'pinyin' => q{पिनयीन वर्गीकरण},
 				'search' => q{सादारन-जाहोननि नायगिरनाय},
 				'standard' => q{थाखोआरि रोखोम फारि},
 				'stroke' => q{स्ट्रोक वर्गीकरण},
 				'traditional' => q{पारम्पारिक वर्गीकरण},
 			},
 			'hc' => {
 				'h11' => q{12 घन्टानि आदब (0–11)},
 				'h12' => q{12 घन्टानि आदब (1–12)},
 				'h23' => q{24 घन्टानि आदब ( 0–23)},
 				'h24' => q{24 घन्टानि आदब ( 1–24)},
 			},
 			'lb' => {
 				'loose' => q{गुरै हांखो सिफायनाय दह‘ङ},
 				'normal' => q{जासिमा हांखो सिफायनाय दह‘ङ},
 				'strict' => q{गोख्रों हांखो सिफायनाय दह‘ङ},
 			},
 			'ms' => {
 				'metric' => q{मेट्रिक आदब},
 				'uksystem' => q{ब्रिटिसा गनायनाय जखा लानाय आदब},
 				'ussystem' => q{इउ.एस नि जखा लानाय आदब},
 			},
 			'numbers' => {
 				'arab' => q{आराबिक-इण्डिक अनजिमाफोर},
 				'arabext' => q{फोलावनाय आराबिक-इण्डिक अनजिमाफोर},
 				'armn' => q{आर्मेनियानि अनजिमा दिन्थिनाय हांखो},
 				'armnlow' => q{आर्मेनियानि अनजिमा दिन्थिनाय फिसा हांखो},
 				'beng' => q{बांला अनजिमाफोर},
 				'cakm' => q{चाकमा अनजिमाफोर},
 				'deva' => q{देबनागिरि अनजिमाफोर},
 				'ethi' => q{इथिय’पियानि अनजिमाफोर},
 				'fullwide' => q{आबुं-गुवारथिनि अनजिमाफोर},
 				'geor' => q{जर्जियान अनजिमा दिन्थिनाय हांखोफोर},
 				'grek' => q{ग्रीक अनजिमा दिन्थिनाय हांखोफोर},
 				'greklow' => q{ग्रीक अनजिमा दिन्थिनाय फिसा हांखोफोर},
 				'gujr' => q{गुजराती अनजिमाफोर},
 				'guru' => q{गुरमुखी अनजिमाफोर},
 				'hanidec' => q{चाइनीज दशमिक अनजिमा दिन्थिनाय हांखोफोर},
 				'hans' => q{गोरलै खालामनाय चाइनीज अनजिमा दिन्थिनाय हांखोफोर},
 				'hansfin' => q{गोरलै खालामनाय चाइनीज रांआरि अनजिमा दिन्थिनाय हांखोफोर},
 				'hant' => q{आसार-खान्थियारि चाइनीज अनजिमा दिन्थिनाय हांखोफोर},
 				'hantfin' => q{आसार-खान्थियारि चाइनीज रांआरि अनजिमा दिन्थिनाय हांखोफोर},
 				'hebr' => q{हिब्रिउ अनजिमा दिन्थिनाय हांखोफोर},
 				'java' => q{जाभानीज अनजिमा दिन्थिनाय हांखोफोर},
 				'jpan' => q{जापानीज अनजिमा दिन्थिनाय हांखोफोर},
 				'jpanfin' => q{जापानीज रांआरि अनजिमा दिन्थिनाय हांखोफोर},
 				'khmr' => q{ख्मेर अनजिमाफोर},
 				'knda' => q{कान्नाडा अनजिमाफोर},
 				'laoo' => q{लाव अनजिमाफोर},
 				'latn' => q{सोनाबारी अनजिमाफोर},
 				'mlym' => q{मालायालम अनजिमाफोर},
 				'mtei' => q{मितै मायेक अनजिमाफोर},
 				'mymr' => q{म्यानमारनि अनजिमाफोर},
 				'olck' => q{अल चिकि अनजिमाफोर},
 				'orya' => q{अरिया अनजिमाफोर},
 				'roman' => q{रमान अनजिमा दिन्थिनाय हांखोफोर},
 				'romanlow' => q{रमान अनजिमा दिन्थिनाय फिसा हांखोफोर},
 				'taml' => q{आसार खान्थियारि तामिल अनजिमा दिन्थिनाय हांखोफोर},
 				'tamldec' => q{तामिल अनजिमाफोर},
 				'telu' => q{तेलुगु अनजिमाफोर},
 				'thai' => q{थाई अनजिमाफोर},
 				'tibt' => q{तिब्बति अनजिमाफोर},
 				'vaii' => q{भाई अनजिमाफोर},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{मेट्रिक जखा},
 			'UK' => q{इउ.के},
 			'US' => q{इउ.एस},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'राव: {0}',
 			'script' => 'हांखो: {0}',
 			'region' => 'ओनसोल: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍]},
			index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऍ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड{ड़}', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'ळ', 'व', 'श', 'ष', 'स', 'ह'],
			main => qr{[़ ँ ं अ आ इ ई उ ऊ ऍ ए ऐ ऑ ओ औ क ख ग घ च छ ज झ ञ ट ठ ड{ड़} ढ ण त थ द ध न प फ ब भ म य र ल ळ व श ष स ह ा ि ी ु ू ृ ॅ े ै ॉ ो ौ ्]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऍ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड{ड़}', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'ळ', 'व', 'श', 'ष', 'स', 'ह'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0} सान),
						'other' => q({0} सान),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0} सान),
						'other' => q({0} सान),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} रिंगा),
						'other' => q({0} घंटे),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} रिंगा),
						'other' => q({0} घंटे),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0} मिन.),
						'other' => q({0} मिन.),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0} मिन.),
						'other' => q({0} मिन.),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0} महीना),
						'other' => q({0} महीने),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0} महीना),
						'other' => q({0} महीने),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0} सेकं.),
						'other' => q({0} सेकं.),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0} सेकं.),
						'other' => q({0} सेकं.),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} सप्ताह),
						'other' => q({0} सप्ताह),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} सप्ताह),
						'other' => q({0} सप्ताह),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0} साल),
						'other' => q({0} साल),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0} साल),
						'other' => q({0} साल),
					},
				},
				'short' => {
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(सान),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(सान),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(घंटे),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(घंटे),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(मिन.),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(मिन.),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(महीने),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(महीने),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(सेकं.),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(सेकं.),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(सप्ताह),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(सप्ताह),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(साल),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(साल),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:नंगौ|नं|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:नङा|न|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0}, आरो {1}),
				2 => q({0} आरो {1}),
		} }
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'superscriptingExponent' => q(x),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0के',
					'other' => '0के',
				},
				'10000' => {
					'one' => '00के',
					'other' => '00के',
				},
				'100000' => {
					'one' => '000के',
					'other' => '000के',
				},
				'1000000' => {
					'one' => '0एम',
					'other' => '0एम',
				},
				'10000000' => {
					'one' => '00एम',
					'other' => '00एम',
				},
				'100000000' => {
					'one' => '000एम',
					'other' => '000एम',
				},
				'1000000000' => {
					'one' => '0बि',
					'other' => '0बि',
				},
				'10000000000' => {
					'one' => '00बि',
					'other' => '00बि',
				},
				'100000000000' => {
					'one' => '000बि',
					'other' => '000बि',
				},
				'1000000000000' => {
					'one' => '0ति',
					'other' => '0ति',
				},
				'10000000000000' => {
					'one' => '00ति',
					'other' => '00ति',
				},
				'100000000000000' => {
					'one' => '000ति',
					'other' => '000ति',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 रोजा',
					'other' => '0 रोजा',
				},
				'10000' => {
					'one' => '00 रोजा',
					'other' => '00 रोजा',
				},
				'100000' => {
					'one' => '000 रोजा',
					'other' => '000 रोजा',
				},
				'1000000' => {
					'one' => '0 निजुत',
					'other' => '0 निजुत',
				},
				'10000000' => {
					'one' => '00 निजुत',
					'other' => '00 निजुत',
				},
				'100000000' => {
					'one' => '000 निजुत',
					'other' => '000 निजुत',
				},
				'1000000000' => {
					'one' => '0 बिलियन',
					'other' => '0 बिलियन',
				},
				'10000000000' => {
					'one' => '00 बिलियन',
					'other' => '00 बिलियन',
				},
				'100000000000' => {
					'one' => '000 बिलियन',
					'other' => '000 बिलियन',
				},
				'1000000000000' => {
					'one' => '0 त्रिलियन',
					'other' => '0 त्रिलियन',
				},
				'10000000000000' => {
					'one' => '00 त्रिलियन',
					'other' => '00 त्रिलियन',
				},
				'100000000000000' => {
					'one' => '000 त्रिलियन',
					'other' => '000 त्रिलियन',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0के',
					'other' => '0के',
				},
				'10000' => {
					'one' => '00के',
					'other' => '00के',
				},
				'100000' => {
					'one' => '000के',
					'other' => '000के',
				},
				'1000000' => {
					'one' => '0एम',
					'other' => '0एम',
				},
				'10000000' => {
					'one' => '00एम',
					'other' => '00एम',
				},
				'100000000' => {
					'one' => '000एम',
					'other' => '000एम',
				},
				'1000000000' => {
					'one' => '0बि',
					'other' => '0बि',
				},
				'10000000000' => {
					'one' => '00बि',
					'other' => '00बि',
				},
				'100000000000' => {
					'one' => '000बि',
					'other' => '000बि',
				},
				'1000000000000' => {
					'one' => '0ति',
					'other' => '0ति',
				},
				'10000000000000' => {
					'one' => '00ति',
					'other' => '00ति',
				},
				'100000000000000' => {
					'one' => '000ति',
					'other' => '000ति',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(ऐन्डोरा का पेसेता),
			},
		},
		'AED' => {
			symbol => 'ए.इ.दि',
			display_name => {
				'currency' => q(इउ.ए.इ दिर्हाम),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(अफ़ग़ानी 1927–2002),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(अफ़ग़ानी),
			},
		},
		'ALL' => {
			symbol => 'अल',
			display_name => {
				'currency' => q(आल्बानियानि लेक),
			},
		},
		'AMD' => {
			symbol => 'ए.एम.दि',
			display_name => {
				'currency' => q(आर्मेनियानि द्राम),
			},
		},
		'ANG' => {
			symbol => 'ए.एन.जि',
			display_name => {
				'currency' => q(नेदारलेण्डनि एन्टिलियान गिल्डार),
			},
		},
		'AOA' => {
			symbol => 'ए.अ.ए',
			display_name => {
				'currency' => q(आंगलानि क्वान्जा),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(एंगोला क्वानज़ा \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(एंगोला नया क्वानज़ा \(1990–20000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(एंगोला क्वानज़ा सुधारीत \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(अर्जेण्टीनी ओस्ट्राल),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(अर्जेण्टीनी पेसो \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ए.आर.एस',
			display_name => {
				'currency' => q(आर्जेन्टिनानि पेस’),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ऑस्ट्रियन शीलींग),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(ऑस्ट्रेलियन डॉलर),
			},
		},
		'AWG' => {
			symbol => 'ए.दब्ल्यु.जि',
			display_name => {
				'currency' => q(आरूबान फ्ल’रिन),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(आज़रबैजानी मनात \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'ए.जेत.एन',
			display_name => {
				'currency' => q(आजेरबाईजाननि मनात),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(बोसनिया हेर्ज़ेगोविना का दीनार),
			},
		},
		'BAM' => {
			symbol => 'बि.ए.एम',
			display_name => {
				'currency' => q(बसनिया-हार्जेगभिनानि सोलायहाथाव मार्क),
			},
		},
		'BBD' => {
			symbol => 'बि.बि.दि',
			display_name => {
				'currency' => q(बारबाद’सनि डलार),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(बांगलादेश टका),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(बेल्जियन फ्राँ कनवर्टीबल),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(बेल्जियन फ्राँ),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(बेल्जियन फ्राँ फिनानसीयल \(वित्तीय\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(बल्गेरियाई हार्ड लेव),
			},
		},
		'BGN' => {
			symbol => 'बि.जि.एन',
			display_name => {
				'currency' => q(बुल्गारियानि लेभ),
			},
		},
		'BHD' => {
			symbol => 'बि.ऐत्स.दि',
			display_name => {
				'currency' => q(बाहरैननि दिनार),
			},
		},
		'BIF' => {
			symbol => 'बि.आइ.एफ',
			display_name => {
				'currency' => q(बुरूण्डीनि फ्रांक),
			},
		},
		'BMD' => {
			symbol => 'बि.एम.डि',
			display_name => {
				'currency' => q(बारमुडानि डलार),
				'one' => q(बारमुडानि डलार),
				'other' => q(बारमुडानि डलारफोर),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ब्रुनई डॉलर),
			},
		},
		'BOB' => {
			symbol => 'बि.अ.बि',
			display_name => {
				'currency' => q(बलिभियानि बलिभियान’),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(बोलिवियाई पेसो),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(बोलिवियाई डॉलर),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ब्रज़ीली नया क्रुज़ेरो \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ब्रज़ीली क्रुज़ाडो),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ब्रज़ीली क्रुज़ेरो \(190–1993\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(ब्राजिलनि रीयाल),
				'one' => q(ब्राजिलनि रीयाल),
				'other' => q(ब्राजिलनि रीयालफोर),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ब्रज़ीली नया क्रुज़ाडो),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ब्रज़ीली क्रुज़ेरो),
			},
		},
		'BSD' => {
			symbol => 'बि.एस.दि',
			display_name => {
				'currency' => q(बाहामासनि डलार),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(भुतान का नगुलत्रुम),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(बर्मी \(म्यानमारी\) क्याट),
			},
		},
		'BWP' => {
			symbol => 'बि.दब्ल्यु.पि',
			display_name => {
				'currency' => q(बत्स्वानानि पुला),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(बेलारुसी नया रूबल \(194–1999\)),
			},
		},
		'BYN' => {
			symbol => 'बि.वाई.एन',
			display_name => {
				'currency' => q(बेलारुसनि रूबल),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(बेलारुसी रूबल \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'बि.जेद.डि',
			display_name => {
				'currency' => q(बेलीज डलार),
			},
		},
		'CAD' => {
			symbol => 'सि.ए $',
			display_name => {
				'currency' => q(कानाडानि डलार),
				'one' => q(कानाडानि डलार),
				'other' => q(कानाडानि डलारफोर),
			},
		},
		'CDF' => {
			symbol => 'सि.दि.एफ',
			display_name => {
				'currency' => q(कंग’नि फ्रांक),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(आईरलैण्ड का युरो),
			},
		},
		'CHF' => {
			symbol => 'सि.ऐत्स.एफ',
			display_name => {
				'currency' => q(सुईस फ्रांक),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(आईरलैण्ड का फ़्रैंक),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(चीली का ऊनीदादेस द फोमेंटो),
			},
		},
		'CLP' => {
			symbol => 'सि.एल.पि',
			display_name => {
				'currency' => q(चिलीनि पेस’),
			},
		},
		'CNH' => {
			symbol => 'सि.एन.ऐत्स',
			display_name => {
				'currency' => q(चाइनीज युवान \( हाब्रांनि गोजान\)),
			},
		},
		'CNY' => {
			symbol => 'सिएन¥',
			display_name => {
				'currency' => q(चाइनीज युवान),
			},
		},
		'COP' => {
			symbol => 'सि.अ.पि',
			display_name => {
				'currency' => q(कल’म्बयानि पेस’),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(युनीदाद द वालोर रेआल),
			},
		},
		'CRC' => {
			symbol => 'सि.आर.सि',
			display_name => {
				'currency' => q(क’स्टा रिकानि कल’न),
				'one' => q(क’स्टा रिका कल’न),
				'other' => q(क’स्टा रिकानि कल’न),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(सर्बिया का डीनार),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(चैकोस्लोवाकिय हार्ड कोरुना),
			},
		},
		'CUC' => {
			symbol => 'सि.इउ.सि',
			display_name => {
				'currency' => q(किउबानि सोलायहाथाव पेस’),
			},
		},
		'CUP' => {
			symbol => 'सि.इउ.पि',
			display_name => {
				'currency' => q(किउबानि पेस’),
			},
		},
		'CVE' => {
			symbol => 'सि.भि.इ',
			display_name => {
				'currency' => q(केप भेर्देनि एस्कुद’),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(साईप्रस का पाऊंड),
			},
		},
		'CZK' => {
			symbol => 'सि.जेद.के',
			display_name => {
				'currency' => q(चेखनि करुना),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(ईस्ट जर्मन ओस्टमार्क),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(डॉईच मार्क),
			},
		},
		'DJF' => {
			symbol => 'दि.जे.एफ',
			display_name => {
				'currency' => q(जिबौतिनि फ्रांक),
			},
		},
		'DKK' => {
			symbol => 'दि.के.के',
			display_name => {
				'currency' => q(डेनमार्कनि क्र’न),
			},
		},
		'DOP' => {
			symbol => 'डि.अ.पि',
			display_name => {
				'currency' => q(डमिनिकानि पेस’),
			},
		},
		'DZD' => {
			symbol => 'दि.जेत.दि',
			display_name => {
				'currency' => q(आल्जेरियानि दिनार),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(एक्वादोर सुक्रे),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(एक्वादोर युनीदाद दे वालोर कॉनस्तांते),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(एस्टोनियाई क्रून),
			},
		},
		'EGP' => {
			symbol => 'ई.जि.पि',
			display_name => {
				'currency' => q(ईजिप्तनि पाउण्ड),
			},
		},
		'ERN' => {
			symbol => 'इ.आर.एन',
			display_name => {
				'currency' => q(एरित्रीयानि नाकफा),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(हीस्पानी पेसेता \(ए अकाऊँट\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(हीस्पानी पेसेता \(कनवर्टीबल अकाऊँट\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(हीस्पानी पेसेता),
			},
		},
		'ETB' => {
			symbol => 'इ.ति.बि',
			display_name => {
				'currency' => q(इथिय’पियानि बीर्र),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(इउर’),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(फीनीश मार्क्का),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(फ़िजी का डॉलर),
			},
		},
		'FKP' => {
			symbol => 'एफ.के.पि',
			display_name => {
				'currency' => q(फ’कलेण्ड द्वीपफोरनि पाउण्ड),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(फ्राँसीसी फ्राँ),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ब्रिटिश पाउण्ड),
				'one' => q(ब्रिटिश पाउण्ड),
				'other' => q(ब्रिटिश पाउण्डफोर),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(जॉर्जिया का कुपोन लारीत),
			},
		},
		'GEL' => {
			symbol => 'जि.इ.एल',
			display_name => {
				'currency' => q(जर्जियानि लारी),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(घाना चेदी \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'जि.ऐत्स.एस',
			display_name => {
				'currency' => q(घानानि सेदि),
			},
		},
		'GIP' => {
			symbol => 'जि.आइ.पि',
			display_name => {
				'currency' => q(जिब्राल्टारनि पाउण्ड),
			},
		},
		'GMD' => {
			symbol => 'जि.एम.दि',
			display_name => {
				'currency' => q(गाम्बियानि दालासि),
			},
		},
		'GNF' => {
			symbol => 'जि.एन.एफ',
			display_name => {
				'currency' => q(गिनीयानि फ्रांक),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(गीनी सीली),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ऐक्वाटरी गीनी एक्वेले गीनीआना),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(युनानी द्राखमा),
			},
		},
		'GTQ' => {
			symbol => 'जि.ति.किउ',
			display_name => {
				'currency' => q(गुआतेमालानि क्वेत्जाल),
				'one' => q(गुआतेमाला क्वेत्जाल),
				'other' => q(गुआतेमालानि क्वेत्जाल),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(पुरतुगी गीनी का एस्कुएदो),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(गीनी बिस्साऊ का पेसो),
			},
		},
		'GYD' => {
			symbol => 'जि.वाई.दि',
			display_name => {
				'currency' => q(गुयानानि डलार),
			},
		},
		'HKD' => {
			symbol => 'ऐत्स.के$',
			display_name => {
				'currency' => q(हंकं डलार),
			},
		},
		'HNL' => {
			symbol => 'ऐत्स.एन.एल',
			display_name => {
				'currency' => q(हन्दुरासनि लेम्पिरा),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(क्रोएशियाई दीनार),
			},
		},
		'HRK' => {
			symbol => 'ऐत्स.आर.के',
			display_name => {
				'currency' => q(क्रवेशियानि कुना),
			},
		},
		'HTG' => {
			symbol => 'ऐत्स.ति.जि',
			display_name => {
				'currency' => q(हाईतीनि गूर्द),
			},
		},
		'HUF' => {
			symbol => 'ऐत्स.इउ.एफ',
			display_name => {
				'currency' => q(हांगारीनि फरिन्त),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(इण्डोनेशियाई रुपिया),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(आईरीश पौंड),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(इस्राइली पौंड),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(इज्राईलनि गोदान शेकेल),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(भारतनि रुपी),
			},
		},
		'IQD' => {
			symbol => 'आइ.किउ.दि',
			display_name => {
				'currency' => q(ईराकनि दिनार),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ईरानी रीयाल),
			},
		},
		'ISK' => {
			symbol => 'आई.एस.के',
			display_name => {
				'currency' => q(आईसलेण्डनि क्र’ना),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(इतली का लीरा),
			},
		},
		'JMD' => {
			symbol => 'जे.एम.दि',
			display_name => {
				'currency' => q(जामाईकानि डलार),
			},
		},
		'JOD' => {
			symbol => 'जे.अ.दि',
			display_name => {
				'currency' => q(जर्डाननि दिनार),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(जापानीज येन),
			},
		},
		'KES' => {
			symbol => 'के.इ.एस',
			display_name => {
				'currency' => q(केनियानि शिलिं),
			},
		},
		'KGS' => {
			symbol => 'के.जि.एस',
			display_name => {
				'currency' => q(कीर्गीस्ताननि स’म),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(कंबोडिया का रिएल),
			},
		},
		'KMF' => {
			symbol => 'के.एम.एफ',
			display_name => {
				'currency' => q(कम’र’नि फ्रांक),
			},
		},
		'KPW' => {
			symbol => 'के.पि.दब्ल्यु',
			display_name => {
				'currency' => q(साहा करियानि व’न),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(खोला करियानि व’न),
			},
		},
		'KWD' => {
			symbol => 'के.दब्ल्यु.दि',
			display_name => {
				'currency' => q(कुवैतनि दिनार),
			},
		},
		'KYD' => {
			symbol => 'के.वाई.दि',
			display_name => {
				'currency' => q(कैमेन द्वीपनि डलार),
			},
		},
		'KZT' => {
			symbol => 'के.जेत.ति',
			display_name => {
				'currency' => q(काजाखस्ताननि तेंगे),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(लाओस का कीप),
			},
		},
		'LBP' => {
			symbol => 'एल.बि.पि',
			display_name => {
				'currency' => q(लेबान’ननि पाउण्ड),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(श्री लंका रूपी),
			},
		},
		'LRD' => {
			symbol => 'एल.आर.दि',
			display_name => {
				'currency' => q(लीबेरियानि डलार),
			},
		},
		'LSL' => {
			symbol => 'एल.एस.एल',
			display_name => {
				'currency' => q(लेस’थ’नि लटि),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(लिथुआनियाई लिता),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(लिथुआनियाई टालोनास),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(लुक्ज़मबुर्गी कनवर्टीबल फ्राँ),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(लुक्ज़मबुर्गी फ्राँ),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(लुक्ज़मबुर्गी वीत्ती फ्राँ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(लाटवियाई लाट्स),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(लाटवियाई रूबल),
			},
		},
		'LYD' => {
			symbol => 'एल.वाई.दि',
			display_name => {
				'currency' => q(लिबियानि दिनार),
			},
		},
		'MAD' => {
			symbol => 'एम.ए.दि',
			display_name => {
				'currency' => q(मरक्क’नि दिर्हाम),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(मोरक्किय फ्राँ),
			},
		},
		'MDL' => {
			symbol => 'एम.डि.एल',
			display_name => {
				'currency' => q(मल्ड’भानि लिउ),
			},
		},
		'MGA' => {
			symbol => 'एम.जि.ए',
			display_name => {
				'currency' => q(मालागासी आरिआरी),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(मादागास्करी फ्राँ),
			},
		},
		'MKD' => {
			symbol => 'एम.के.दि',
			display_name => {
				'currency' => q(मेसेड’नियानि देनार),
				'one' => q(मेसेड’नियानि देनार),
				'other' => q(मेसेड’नियानि देनारि),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(माली का फ्राँ),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(म्यानमारी क्याट),
			},
		},
		'MNT' => {
			symbol => 'एम.एन.ति',
			display_name => {
				'currency' => q(मंगलियानि तुग्रीक),
			},
		},
		'MOP' => {
			symbol => 'एम.अ.पि',
			display_name => {
				'currency' => q(माकाउनि पाताका),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(मौरिटानी ऊगुया \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'एम.आर.इउ',
			display_name => {
				'currency' => q(म’रिशियानि ऊगुया),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(माल्टी लीरा),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(माल्टी पौंड),
			},
		},
		'MUR' => {
			symbol => 'एम.इउ.आर',
			display_name => {
				'currency' => q(मरिसियानि रुपी),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(मालदीव द्वीप का रूफिया),
			},
		},
		'MWK' => {
			symbol => 'एम.दब्ल्यु.के',
			display_name => {
				'currency' => q(मालावीनि क्वाचा),
			},
		},
		'MXN' => {
			symbol => 'एम.एक्स $',
			display_name => {
				'currency' => q(मेक्सिकान पेस’),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(मेक्सिकन रजती पेसो \(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(मेक्सिकन युनीदाद द ईनवेरसिओन \(युडीआई\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(मलेशियन रिंगित),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(मोज़ांबीक एस्कुएदो),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(मोज़ांबीक पुराना मेतीकाल),
			},
		},
		'MZN' => {
			symbol => 'एम.जेत.एन',
			display_name => {
				'currency' => q(मजाम्बिकनि मेटिकेल),
			},
		},
		'NAD' => {
			symbol => 'एन.ए.दि',
			display_name => {
				'currency' => q(नामिबियानि डलार),
			},
		},
		'NGN' => {
			symbol => 'एन.जि.एन',
			display_name => {
				'currency' => q(नाइजेरियानि नायरा),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(नीकारागुआई कोर्दोबा),
			},
		},
		'NIO' => {
			symbol => 'एन.आई.अ',
			display_name => {
				'currency' => q(निकारागुआनि कर्द’बा),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(नेदरलैण्ड गीलडर),
			},
		},
		'NOK' => {
			symbol => 'एन.अ.के',
			display_name => {
				'currency' => q(नरवैनि क्र’न),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(नेपाली रुपी),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(न्यूज़ीलैंड डॉलर),
			},
		},
		'OMR' => {
			symbol => 'अ.एम.आर',
			display_name => {
				'currency' => q(अमाननि रियाल),
			},
		},
		'PAB' => {
			symbol => 'पि.ए.बि',
			display_name => {
				'currency' => q(पानामानि बाल्ब’आ),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(पेरूवाई ईंटी),
			},
		},
		'PEN' => {
			symbol => 'पि.इ.एन',
			display_name => {
				'currency' => q(पेरूनि सल),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(पेरुवाई सोल \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(पापुआ न्यु गीनी का कीना),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(फ़िलिपीन का पेसो),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(पाकिस्तानी रुपया),
			},
		},
		'PLN' => {
			symbol => 'पि.एल.एन',
			display_name => {
				'currency' => q(पलेण्डनि ज्ल’टी),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(पुरतुगी एस्कुदो),
			},
		},
		'PYG' => {
			symbol => 'पि.आई.जि',
			display_name => {
				'currency' => q(पारागुवेनि गुआरानी),
			},
		},
		'QAR' => {
			symbol => 'किउ.ए.आर',
			display_name => {
				'currency' => q(कातारनि रियाल),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(रोडेशियाई डॉलर),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(रोमानियाई पुरानी ल),
			},
		},
		'RON' => {
			symbol => 'आर.अ.एन',
			display_name => {
				'currency' => q(रमानियानि लिउ),
			},
		},
		'RSD' => {
			symbol => 'आर.एस.दि',
			display_name => {
				'currency' => q(सार्बियानि दिनार),
			},
		},
		'RUB' => {
			symbol => 'रूब',
			display_name => {
				'currency' => q(रासियानि रूबल),
				'one' => q(रासियानि रूबल),
				'other' => q(रासियानि रूबलफोर),
			},
		},
		'RWF' => {
			symbol => 'आर.एफ',
			display_name => {
				'currency' => q(रुवान्दानि फ्रांक),
			},
		},
		'SAR' => {
			symbol => 'एस.ए.आर',
			display_name => {
				'currency' => q(साउदि रियाल),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(सोलोमन द्वीप का डॉलर),
			},
		},
		'SCR' => {
			symbol => 'एस.सि.आर',
			display_name => {
				'currency' => q(सैशेल्लेसनि रूपी),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(सुदानी पुराना डॉलर),
			},
		},
		'SDG' => {
			symbol => 'एस.दि.जि',
			display_name => {
				'currency' => q(सुदाननि पाउण्ड),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(सुदानी पुराना पौंड),
			},
		},
		'SEK' => {
			symbol => 'एस.इ.के',
			display_name => {
				'currency' => q(स्वीडेननि क्र’ना),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(सिंगापुर डॉलर),
			},
		},
		'SHP' => {
			symbol => 'एस.ऐत्स.पि',
			display_name => {
				'currency' => q(सैन्ट हेलेनानि पाउण्ड),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(स्लोवेनियाई तोलार),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(स्लोवाकी कोरुना),
			},
		},
		'SLE' => {
			symbol => 'एस.एल.इ',
			display_name => {
				'currency' => q(सीयेर्रा लिय’ननि लीयन),
			},
		},
		'SLL' => {
			symbol => 'एस.एल.एल',
			display_name => {
				'currency' => q(सीयेर्रा लिय’ननि लीयन \(1964—2022\)),
			},
		},
		'SOS' => {
			symbol => 'एस.अ.एस',
			display_name => {
				'currency' => q(समालियानि शिलिं),
			},
		},
		'SRD' => {
			symbol => 'एस.आर.डि',
			display_name => {
				'currency' => q(सुरीनामनि डलार),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(सुरीनाम गील्डर),
			},
		},
		'SSP' => {
			symbol => 'एस.एस.पि',
			display_name => {
				'currency' => q(खोला सुदानारि पाउण्ड),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(साँव तोमे एवं प्रीन्सीपे का डोब्रा \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'एस.ति.एन',
			display_name => {
				'currency' => q(साऊ तमे आरो प्रिन्सिपनि दब्रा),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(सोवियत रूबल),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(एल सालवादर कोलोन),
			},
		},
		'SYP' => {
			symbol => 'एस.वाई.पि',
			display_name => {
				'currency' => q(सीरियानि पाउण्ड),
			},
		},
		'SZL' => {
			symbol => 'एस.जेत.एल',
			display_name => {
				'currency' => q(स्वाजी लीलांगेनी),
				'one' => q(स्वाजी लीलांगेनी),
				'other' => q(स्वाजी एमालांगेनी),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(थाई बाह्ट),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(ताजीक़ीस्तानी रूबल),
			},
		},
		'TJS' => {
			symbol => 'ति.जे.एस',
			display_name => {
				'currency' => q(ताजिकिस्ताननि सम’नि),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(तुर्कमेनीस्तानी मानाट),
			},
		},
		'TMT' => {
			symbol => 'ति.एम.ति',
			display_name => {
				'currency' => q(तुर्कमेनीस्ताननि मानात),
			},
		},
		'TND' => {
			symbol => 'ति.एन.दि',
			display_name => {
				'currency' => q(त्सुनीसीयानि दिनार),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(टॉंगा पाईंगा),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(तीमोरी एस्कुदो),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(तुर्की लीरा),
			},
		},
		'TRY' => {
			symbol => 'ति.आर.वाई',
			display_name => {
				'currency' => q(तुर्कीनि लीरा),
			},
		},
		'TTD' => {
			symbol => 'ति.ति.डि',
			display_name => {
				'currency' => q(त्रिनिदाद आरो तबाग’ डलार),
			},
		},
		'TWD' => {
			symbol => 'एन.ति$',
			display_name => {
				'currency' => q(ताईवाननि गोदान डलार),
			},
		},
		'TZS' => {
			symbol => 'ति.जेत.एस',
			display_name => {
				'currency' => q(तान्जानियानि शिलिं),
			},
		},
		'UAH' => {
			symbol => 'इउ.ए.ऐत्स',
			display_name => {
				'currency' => q(युक्रेननि ह्रीभनिया),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(युक्रेनी कार्बोवानेत्ज़),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(युगाँडाई शीलींग \(1996–1987\)),
			},
		},
		'UGX' => {
			symbol => 'इउ.जि.एक्स',
			display_name => {
				'currency' => q(उगाण्डानि शिलिं),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(इउ.एस डलार),
				'one' => q(इउ.एस डलार),
				'other' => q(इउ.एस डलारफोर),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(अमरिकी डॉलर \(अगले दिन का\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(अमरिकी डॉलर \(इसी दिन का\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(ऊरुगुए का पेसो आन ऊनीदादोस ईंदेक्सादास),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ऊरुगुए का पेसो \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'इउ.वाई.इउ',
			display_name => {
				'currency' => q(उरुगुवेनि पेस’),
			},
		},
		'UZS' => {
			symbol => 'इउ.जेत.एस',
			display_name => {
				'currency' => q(उजबेकिस्ताननि स’म),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(वेनेज़ुएलाई बोलिवार \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(वेनेज़ुएलाई बोलिवार \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'भि.इ.एस',
			display_name => {
				'currency' => q(भेनेजुवेलानि बलिभार),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(वीयतनामी डॉंग),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(वनुआटु वटु),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(वेस्टर्न समोआ ताला),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(मिरु आफ्रिकानि सि.एफ.ए फ्रांक),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(रजत),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(सोना),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(एक्यु),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(एम्यु),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(यूरोपी एकाऊंट का युनीट \(एक्स बी सी\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(यूरोपी एकाऊंट का युनीट \(एक्स बी डी\)),
			},
		},
		'XCD' => {
			symbol => 'इ.सि $',
			display_name => {
				'currency' => q(सानजा केरिबियान डलार),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(स्पेशियल ड्राईंग राईट्स),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(यूरोपी मुद्रा \(एक्यु\)),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(फ्रानसीसी सुवर्ण फ्राँ),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(फ्रानसीसी युआईसी फ्राँ),
			},
		},
		'XOF' => {
			symbol => 'एफ सि.एफ.ए',
			display_name => {
				'currency' => q(सोनाब आफ्रिकानि सि.एफ.ए फ्रांक),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(पैलेडियम),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(फ्रानसीसी फेदेरेशनी फ्राँ),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(प्लैटीनम),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(रीनैट फंड्स),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(टेस्टींग करनसी कोड),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(मिथियै रां),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(यमनी दीनार),
			},
		},
		'YER' => {
			symbol => 'वाई.इ.आर',
			display_name => {
				'currency' => q(येमेननि रियाल),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(युगोस्लावी हार्ड दीनार),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(युगोस्लावी नोवीय \(नये\) दीनार),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(युगोस्लावी कनवर्टीबल दीनार),
			},
		},
		'ZAR' => {
			symbol => 'जेत.ए.आर',
			display_name => {
				'currency' => q(खोला आफ्रिकानि राण्ड),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ज़ाम्बियाई क्वाचा \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'जेत.के',
			display_name => {
				'currency' => q(जाम्बियानि क्वाचा),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(ज़ाईरी नये ज़ाईर),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(ज़ाईरी ज़ाईर),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ज़ीम्बाबवेई डॉलर),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जान',
							'फेब',
							'मार्च',
							'एप्रि',
							'मे',
							'जुन',
							'जुल',
							'आग',
							'सेप',
							'अक्ट’',
							'नवे',
							'डिसे'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जानुवारी',
							'फेब्रूवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'आगष्ट',
							'सेप्थेम्बर',
							'अक्ट’बर',
							'नवेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ज',
							'फ',
							'म',
							'ए',
							'म',
							'ज',
							'ज',
							'आ',
							'स',
							'अ',
							'न',
							'ड'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'छैत्र',
							'बैसागो',
							'जेथो',
							'आसार',
							'सावोन',
							'भाद्र',
							'आसिन',
							'काथि',
							'आघोन',
							'पुष',
							'मागो',
							'फागुन'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सम',
						tue => 'मंगल',
						wed => 'बुध',
						thu => 'बिस्थि',
						fri => 'सुखुर',
						sat => 'सनि',
						sun => 'रबि'
					},
					wide => {
						mon => 'समबार',
						tue => 'मंगलबार',
						wed => 'बुधबार',
						thu => 'बिस्थिबार',
						fri => 'सुखुरबार',
						sat => 'सनिबार',
						sun => 'रबिबार'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'स',
						tue => 'मं',
						wed => 'बु',
						thu => 'बि',
						fri => 'सु',
						sat => 'स',
						sun => 'र'
					},
					wide => {
						mon => 'समबार',
						tue => 'मंगलबार',
						wed => 'बुधबार',
						thu => 'बिस्थिबार',
						fri => 'सुुखुरबार',
						sat => 'सनिबार',
						sun => 'रबिबार'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'किउ 1',
						1 => 'किउ 2',
						2 => 'किउ 3',
						3 => 'किउ 4'
					},
					wide => {0 => 'ब्रै बाहागोनि सेथि खोन्दो',
						1 => 'ब्रै बाहागोनि नैथि खोन्दो',
						2 => 'ब्रै बाहागोनि थामथि खोन्दो',
						3 => 'ब्रै बाहागोनि ब्रैथि खोन्दो'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{फुं},
					'pm' => q{बेलासे},
				},
				'narrow' => {
					'am' => q{फुं},
					'pm' => q{बे},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'बि.सि.',
				'1' => 'ए.दि'
			},
			wide => {
				'0' => 'ख्राइष्तनि सिगां',
				'1' => 'आन्न’ दामिनि'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'साका'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{d MMMM y, EEEE, G},
			'long' => q{d MMMM y, G},
			'medium' => q{d MMM y, G},
			'short' => q{d/M/yy GGGGG},
		},
		'gregorian' => {
			'full' => q{d MMMM y, EEEE},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{dd-MM-y},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{a h:mm:ss zzzz},
			'long' => q{a h:mm:ss z},
			'medium' => q{a h:mm:ss},
			'short' => q{a नि h:mm},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			Ehm => q{E a h:mm},
			Ehms => q{E a h:mm:ss},
			GyMMM => q{G, MMMM y},
			GyMMMEd => q{d MMM, G y, E},
			GyMMMd => q{d MMM, G y},
			GyMd => q{GGGGG d/M/y},
			MEd => q{d/M, E},
			MMMEd => q{d MMM, E},
			MMMMEd => q{d MMMM, E},
			MMMMd => q{d MMMM},
			MMMd => q{d-MMM},
			Md => q{d/M},
			h => q{a h},
			hm => q{a h:mm},
			hms => q{a h:mm:ss},
			yM => q{M/y},
			yMEd => q{d/M/y, E},
			yMMM => q{MMM y},
			yMMMEd => q{d MMM, y, E},
			yMMMM => q{MMMM y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yyyyM => q{GGGGG M/y},
			yyyyMEd => q{GGGGG d/M/y, E},
			yyyyMMM => q{G MMM y},
			yyyyMMMEd => q{d MMM y, G E},
			yyyyMMMM => q{G MMMM y},
			yyyyMMMd => q{d MMM y, G},
			yyyyMd => q{GGGGG d/M/y},
		},
		'gregorian' => {
			Bh => q{B नि h},
			Bhm => q{B नि h:mm},
			Bhms => q{B नि h:mm:ss},
			EBhm => q{E B नि h:mm},
			EBhms => q{E B नि h:mm:ss},
			Ehm => q{a h:mm, E},
			Ehms => q{a h:mm:ss, E},
			Gy => q{Gy},
			GyMMMEd => q{G y MMM E d},
			GyMd => q{GGGGG dd-MM-y},
			MEd => q{E, M/d},
			MMMEd => q{E, MMM d},
			MMMMEd => q{E, MMMM d},
			MMMd => q{d-MMM},
			Md => q{M/d},
			h => q{a नि h},
			hmsv => q{a नि h:mm:ss v},
			hmv => q{a h:mm v},
			yM => q{M/y},
			yMEd => q{E, M/d/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, MMM d, y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{dd-MM-y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				B => q{B h– B h},
				h => q{B h–h},
			},
			Bhm => {
				B => q{B h:mm – B h:mm},
				h => q{B h:mm –h:mm},
				m => q{B h:mm – h:mm},
			},
			Gy => {
				G => q{G y–G y},
			},
			GyM => {
				G => q{GGGGG M/y – GGGGG M/y},
				M => q{GGGGG M/y – M/y},
				y => q{GGGGG M/y – M/y},
			},
			GyMEd => {
				G => q{GGGGG d/M/y, E – GGGGG d/M/y, E},
				M => q{GGGGG d/M/y, E – d/M/y, E},
				d => q{GGGGG d/M/y – d/M/y, E},
				y => q{GGGGG d/M/y, E – d/M/y, E},
			},
			GyMMM => {
				G => q{G MMM y – G MMM y},
				M => q{G MMM–MMM y},
				y => q{G MMM y – MMM y},
			},
			GyMMMEd => {
				G => q{G d MMM, y, E – G d MMM, y, E},
				M => q{G y, d MMM, E– d MMM, E},
				d => q{G d MMM, y, E – G d MMM, y, E},
				y => q{G d MMM, y, E – d MMM, y, E},
			},
			GyMMMd => {
				G => q{G d MMM, y – G d MMM, y},
				M => q{G y d MMM – d MMM},
				d => q{G d–d MMM, y},
				y => q{G d MMM, y – d MMM, y},
			},
			GyMd => {
				G => q{GGGGG d/M/y – GGGGG d/M/y},
				M => q{GGGGG d/M/y – d/M/y},
				d => q{GGGGG d/M/y – d/M/y},
				y => q{GGGGG d/M/y – d/M/y},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{d/M, E – d/M, E},
				d => q{d/M, E – d/M, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{d MMM, E – d MMM, E},
				d => q{d MMM, E – d MMM, E},
			},
			MMMd => {
				M => q{d MMM –d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			fallback => '{0} – {1}',
			yM => {
				M => q{GGGGG M/y – M/y},
				y => q{GGGGG M/y – M/y},
			},
			yMEd => {
				M => q{GGGGG d/M/y, E – d/M/y, E},
				d => q{GGGGG d/M/y, E – d/M/y, E},
				y => q{GGGGG d/M/y, E – d/M/y, E},
			},
			yMMM => {
				M => q{G MMM–MMM y},
				y => q{G MMM y– MMM y},
			},
			yMMMEd => {
				M => q{G d MMM, E – d MMM, E y},
				d => q{G d MMM, E – d MMM, E y},
				y => q{G d MMM, y, E – d MMM, y, E},
			},
			yMMMM => {
				M => q{G MMMM–MMMM y},
				y => q{G MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{G d MMM – d MMM, y},
				d => q{G d–d MMM, y},
				y => q{G d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{GGGGG d/M/y – d/M/y},
				d => q{GGGGG d/M/y – d/M/y},
				y => q{GGGGG d/M/y – d/M/y},
			},
		},
		'gregorian' => {
			Bh => {
				B => q{Bनि h – Bनि h},
				h => q{B नि h–h},
			},
			Bhm => {
				B => q{B नि h:mm – B नि h:mm},
				h => q{B नि h:mm–h:mm},
				m => q{B नि h:mm–h:mm},
			},
			GyM => {
				G => q{G M/y – G M/y},
				M => q{G M/y – M/y},
				y => q{G M/y – M/y},
			},
			GyMEd => {
				G => q{G d/M/y, E – G d/My, E},
				M => q{G d/M/y E – G d/M/y, E},
				d => q{G d/M/y, E – G d/M/y, E},
				y => q{G d/M/y, E – d/My, E},
			},
			GyMMM => {
				y => q{G y MMM–y MMM},
			},
			GyMMMEd => {
				G => q{G y, d MMM, E – G y, d MMM, E},
				M => q{G y, d MMM, E – d MMM E},
				d => q{G y, d MMM, E– d MMM, E},
				y => q{d MMM y, E–d MMM y, E G},
			},
			GyMMMd => {
				G => q{G y, MMM d – G y, MMM d},
				M => q{G y, MMM d – MMM d},
				d => q{G y, MMM d–d},
				y => q{G y, MMM d – y, MMM d},
			},
			GyMd => {
				G => q{G d/M/y – G d/M/y},
				M => q{G d/M/y – d/M/y},
				d => q{G d/M/y – d/M/y},
				y => q{G d/M/y – d/M/y},
			},
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{d/M, E – d/M, E},
				d => q{d/M, E –d/M, E},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{d MMM, E – d MMM, E},
				d => q{d MMM, E – d MMM, E},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M –/dM},
				d => q{d/M – d/M},
			},
			h => {
				a => q{a नि h–a नि h},
				h => q{a नि h–h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a नि h:mm–h:mm},
				m => q{a h:mm – h:mm},
			},
			hmv => {
				a => q{a h:mm – a h:mm v},
				h => q{a h:mm – h:mm v},
				m => q{a h:mm–h:mm v},
			},
			hv => {
				a => q{a h– a h v},
				h => q{a h–h v},
			},
			yM => {
				M => q{M/y–M/y},
				y => q{M/y–M/y},
			},
			yMEd => {
				M => q{d/M/y, E – d/M/y, E},
				d => q{d/M/y, E – d/M/y, E},
				y => q{d/M/y, E – d/M/y, E},
			},
			yMMMEd => {
				M => q{d MMM, y, E – d MMM, y, E},
				d => q{y, d MMM, E– d MMM, E},
				y => q{d MMM, y, E – d MMM, y,E},
			},
			yMMMd => {
				M => q{y, d MMM– d MMM},
				d => q{y, d–d MMM},
				y => q{y, MMM d – y, MMM d},
			},
			yMd => {
				M => q{d/M/y–d/M/y},
				d => q{d/M/y–d/M/y},
				y => q{d/M/y–d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(जि.एम.ति {0}),
		gmtZeroFormat => q(जि.एम.ति),
		regionFormat => q({0} सम),
		regionFormat => q({0} साननि सोरां सम),
		regionFormat => q({0} थाखोआरि सम),
		'Acre' => {
			long => {
				'daylight' => q#आकर समर टाईम#,
				'generic' => q#एकोर सम#,
				'standard' => q#आकर स्टैंडर्ड टाईम#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#आफगानीस्तान सम#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अबिदजान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#आक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#एद्दिस आबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#आल्जीएर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#आस्मारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बामाक’#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बांगूई#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बन्जुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिस्साउ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लान्टाईर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राज्जाभील#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुम्बुरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#कायर’#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कासाब्लांका#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउता#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कनाक्री#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डाकार#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#दार एस सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबौटी#,
		},
		'Africa/Douala' => {
			exemplarCity => q#दुआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#एल आइऊन#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ्रीटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गैबोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हारारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जहान्सबार्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#काम्पाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्तूम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#किगालि#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किन्शासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लाग’स#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिब्रेभिल#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लमे#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुआन्डा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबुम्बाशी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मालाब’#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुट’#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मासेरू#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#म्बाबाने#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मगाडिशु#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मन्र’भिया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नाईरौबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#न्जामेना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नीआमे#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#न्वाकश’त#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ऊगाडुगु#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पर्ट’-नभ’#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साव टमे#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिप’ली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ट्यूनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विन्दह’क#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#मिरु आफ्रिका सम#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#सानजा आफ्रिका सम#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#खोला आफ्रिकानि थाखोआरि सम#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#सोनाब आफ्रिकानि दैज्लां सम#,
				'generic' => q#सोनाब आफ्रिकानि सम#,
				'standard' => q#सोनाब आफ्रिकानि थाखोआरि सम#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#आलास्कानि सानारि सम#,
				'generic' => q#आलास्कानि सम#,
				'standard' => q#आलास्का स्टेन्डार्ड सम#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#अलमाटी समर टाईम#,
				'generic' => q#अलमाटी टाईम#,
				'standard' => q#अलमाटी स्टैंडर्ड टाईम#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#आमाजन दैज्लां सम#,
				'generic' => q#आमाजन सम#,
				'standard' => q#आमाजन थाखोआऱि सम#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#एडेक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#एंकरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#एंग्वीला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एन्टिगुवा#,
		},
		'America/Araguaina' => {
			exemplarCity => q#आरागुआईना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रिअजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रिअ गालेगस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#साल्टा#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान हुवान#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सान लुईस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमान#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशूआयिया#,
		},
		'America/Aruba' => {
			exemplarCity => q#आरूबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#आसुनसीअन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बाहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बाहिया बान्देरास#,
		},
		'America/Barbados' => {
			exemplarCity => q#बार्बाड’स#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलिज#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लांक- साब्लन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बआ भिस्ता#,
		},
		'America/Bogota' => {
			exemplarCity => q#बग’टा#,
		},
		'America/Boise' => {
			exemplarCity => q#बयसि#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#बुएन’स एरेस#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#केम्ब्रिज गाथोन#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#केम्प ग्रान्ड#,
		},
		'America/Cancun' => {
			exemplarCity => q#कांकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#काराकास#,
		},
		'America/Catamarca' => {
			exemplarCity => q#काटामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेन#,
		},
		'America/Cayman' => {
			exemplarCity => q#कैमेन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकाग’#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चुहभाभा#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#आतिककान#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कर्डबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कस्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#कुईआबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#कूरासाव#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डानमार्कस्भान#,
		},
		'America/Dawson' => {
			exemplarCity => q#डावस’न#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डावस’न क्रीक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेनभोर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्र’ईत#,
		},
		'America/Dominica' => {
			exemplarCity => q#डमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एडमन्टन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#एईरुनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#एल साल्भाडर#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#फर्त नेलसन#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फर्टालेजा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस बेइ#,
		},
		'America/Godthab' => {
			exemplarCity => q#नूक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूज बेइ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रेण्ड तार्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनाडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वादेलूप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#गुआयाकिल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गुयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हेलिफेक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हाभाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हार्म’सिल्ल’#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नक्स, इण्डियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेङ’, इण्डियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पितार्सबार्ग, इण्डियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#तेल नोगोर, इण्डियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#भेभै, इण्डियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#भानसेन्नेस, इण्डियाना#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनामेक, इण्डियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इण्डियानापलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनूविक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकालुईत#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जामाईका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजुई#,
		},
		'America/Juneau' => {
			exemplarCity => q#जुनो#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मन्टिछेल’, केन्टाकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#क्रालेणजीक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाज#,
		},
		'America/Lima' => {
			exemplarCity => q#लीमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लस एन्जेलोस#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुईवील#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लवार प्रिन्सोस क्वार्तार#,
		},
		'America/Maceio' => {
			exemplarCity => q#माचेईओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मनागुआ#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनाउस#,
		},
		'America/Marigot' => {
			exemplarCity => q#मेरिगत#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टीनीक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#मेतामरस#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माजाटलान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेन्ड’जा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेन’मीनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेत्लाकात्ला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिक’ सिती#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिक्वेल’न#,
		},
		'America/Moncton' => {
			exemplarCity => q#मक्ट’न#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मन्टेर्रे#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मन्टेभिडिअ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मनसेर्रात#,
		},
		'America/Nassau' => {
			exemplarCity => q#नास्साउ#,
		},
		'America/New_York' => {
			exemplarCity => q#निउ यर्क#,
		},
		'America/Nome' => {
			exemplarCity => q#न’म#,
		},
		'America/Noronha' => {
			exemplarCity => q#नर’न्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#बेऊलाह, साहा डाक’ता#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#सेन्टोर, साहा डाक’ता#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#निउ सालेम, साहा डाक’ता#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#आजिनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पानामा#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारामारिब’#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फीनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पर्ट-आऊ-प्रिन्स#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पर्ट अफ स्पैन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पर्ट’ भेल्ह’#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#पुएर्ट’ रिक’#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#पुन्टा आरेनास#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रेनकिन इनलेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रेसिफे#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रेजल्युत#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रिअ ब्रान्क’#,
		},
		'America/Santarem' => {
			exemplarCity => q#सान्तारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सान्तिआग’#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सान्तो डमिग’#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साव पावल’#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ईत्त’क्वर्तूमी#,
		},
		'America/Sitka' => {
			exemplarCity => q#सित्का#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सैन्ट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सैन्ट जन्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सैन्ट कीत्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सैन्ट लुसिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सैन्ट थमास#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सैन्ट भिन्सेन्ट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#सुईफत कार्रेन्त#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#तेगुसिगाल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थ्यूल#,
		},
		'America/Tijuana' => {
			exemplarCity => q#टिहुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टरन्ट’#,
		},
		'America/Tortola' => {
			exemplarCity => q#टर्त’ला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#भेनकूभर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#व्हाईतहर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#वीनीपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#याकुतात#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#साहा आमेरिकानि मिरु सानारि सम#,
				'generic' => q#साहा आमेरिकानि मिरु सम#,
				'standard' => q#साहा आमेरिकानि मिरु मानथाखोआरि सम#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#साहा आमेरिकानि सानजायारि सानारि सम#,
				'generic' => q#साहा आमेरिकानि सानजायारि सम#,
				'standard' => q#साहा आमेरिकानि सानजायारि थाखोआरि सम#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#साहा आमोरिकानि हाजोमायारि सानारि सम#,
				'generic' => q#साहा आमेरिकानि हाजोमायारि सम#,
				'standard' => q#साहा आमेरिकानि हाजोमायारि थाखोआरि सम#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#साहा आमेरिकानि पेसिफिक सानारि सम#,
				'generic' => q#साहा आमेरिकानि पेसिफिक सम#,
				'standard' => q#साहा आमेरिकानि पेसिफिक थाखोआरि सम#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#अनादीर समर टाईम#,
				'generic' => q#आनादीर सम#,
				'standard' => q#अनादीर स्टैंडर्ड टाईम#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#केसी#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेभिस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#डुमन्त-डीआर्भील#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#माक्वारी#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#मौसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#मेकमार्ड’#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पालमार#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#सीअवा#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#त्र’ल#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#भस्त’क#,
		},
		'Apia' => {
			long => {
				'daylight' => q#आपिया सान सम#,
				'generic' => q#आपिया सम#,
				'standard' => q#आपिया थाखोआरि सम#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#अक़्टाऊ समर टाईम#,
				'generic' => q#अक्टाऊ सम#,
				'standard' => q#अक़्टाऊ स्टैंडर्ड टाईम#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#अक़्टोबे समर टाईम#,
				'generic' => q#आक्त’ब सम#,
				'standard' => q#अक़्टोबे स्टैंडर्ड टाईम#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#आराबीयान सानारि सम#,
				'generic' => q#आराबीयान सम#,
				'standard' => q#आराबीयान थाखोआरि सम#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लंयारब्येन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#आर्जेन्टिना दैज्लां सम#,
				'generic' => q#आर्जेन्टिना सम#,
				'standard' => q#आर्जेन्टिना थाखोआरि सम#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#सोनाब आर्जेन्टिना दैज्लां सम#,
				'generic' => q#सोनाब आर्जेन्टिना सम#,
				'standard' => q#सोनाब आर्जेन्टिना थाखोआरि सम#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#आर्मेनिया दैज्लां सम#,
				'generic' => q#आर्मेनिया सम#,
				'standard' => q#आर्मेनिया थाखोआरि सम#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#एडेन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#आल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#आम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#आनाडीर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#अक्ताउ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#आक्त’बे#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अश्गाबात#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#आतीराउ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बाघदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बाहरैन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकू#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बैंगकॉक#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#बार्नौल#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बैरुत#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिश्केक#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रुनइ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कलकाता#,
		},
		'Asia/Chita' => {
			exemplarCity => q#चीता#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#च’इबालसान#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कलम्ब’#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दामास्कास#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#धाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#डिली#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबाई#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दुशान्बे#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#फामागुस्ता#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाजा#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हेब्र’न#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हंकं#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ह’भ्द#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ईर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जाकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#जेरुजालेम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबूल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कामचाटका#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमान्डु#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खान्दीगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्न’यार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#क्वाला लम्पुर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कूचिंग#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवैत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#माकाऊ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मागादान#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#माकास्सार#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनीला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मास्केट#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निक’सिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#नभ’कुज्नेत्स्क#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नभ’सिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#अम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#अराल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#नॉम पेन#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पोंतिआनाक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्यंयां#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कातार#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#कस्तानै#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#कीजीलर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रंगून#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाध#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#साइगॉन#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#साखालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समरकान्द#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#स’उल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#शांघाई#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापुर#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#स्रेदनेक’लिम्स्क#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ताईपेइ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ताशकेन्त#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#तिबिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिम्फु#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ट’क्य’#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#तम्स्क#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबातार#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरुमकी#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#आस्त-नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#वियंसियान#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#भ्लादिभस्त’क#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#याकूत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#येकातेरीनाबुर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेभान#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#आटलान्टिक सानारि सम#,
				'generic' => q#आटलान्टिक सम#,
				'standard' => q#आटलान्टिक थाखोआरि सम#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#आज’र्स#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बार्मुडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#केनेरी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप भेर्दे#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फेरौ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#माडैरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रीकयाभिक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#खोला जर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सैन्ट हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टेनली#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडेलैड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रीसबेन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्र’केन हिल#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्वीन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#यूक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#हबार्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिण्डमेन#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लर्ड हावि#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेलबौर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पोर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिडनी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#अ’स्ट्रेलिया मिरु सानारि सम#,
				'generic' => q#मिरु अ’स्ट्रेलिया सम#,
				'standard' => q#अ’स्ट्रेलियानि मिरु थाखोआरि सम#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#अस्ट्रेलियानि मिरु सोनाबारि सानारि सम#,
				'generic' => q#अस्ट्रेलियानि मिरु सोनाबारि सम#,
				'standard' => q#अस्ट्रेलियानि मिरु सोनाबारि थाखोआरि सम#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#अस्ट्रेलियानि सानजायारि सानारि सम#,
				'generic' => q#सानजायारि अस्ट्रेलिया सम#,
				'standard' => q#अस्ट्रेलियानि सानजायारि थाखोआरि सम#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#अस्ट्रेलियानि सोनाबारि सानारि सम#,
				'generic' => q#सोनाबारि अस्ट्रेलिया सम#,
				'standard' => q#अस्ट्रेलियानि सोनाबारि थाखोआरि सम#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#आजारबाईजान दैज्लां सम#,
				'generic' => q#आजारबाईजान सम#,
				'standard' => q#आजारबाईजान थाखोआरि सम#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#आज’र्सनि दैज्लां सम#,
				'generic' => q#आज’र्सनि सम#,
				'standard' => q#आज’र्सनि थाखोआरि सम#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#बांलादेश दैज्लां सम#,
				'generic' => q#बांलादेश सम#,
				'standard' => q#बांलादेश थाखोआरि सम#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#भुटान सम#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#बलिभिया सम#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ब्राजीलिया दैज्लां सम#,
				'generic' => q#ब्राजीलिया सम#,
				'standard' => q#ब्राजीलिया थाखोआरि सम#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ब्रुनेई दर उस सलाम स्टैंडर्ड टाईम#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#केप भेर्दे दैज्लां सम#,
				'generic' => q#केप भेर्दे सम#,
				'standard' => q#केप भेर्दे थाखोआरि सम#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#चाम’र्र’ थाखोआरि सम#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#चेथाम सानारि सम#,
				'generic' => q#चेथाम सम#,
				'standard' => q#चेथाम थाखोआरि सम#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#चीले दैज्लां सम#,
				'generic' => q#चीले सम#,
				'standard' => q#चीले थाखोआरि सम#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#चाईना सानारि सम#,
				'generic' => q#चाईना सम#,
				'standard' => q#चाईना थाखोआरि सम#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#च’इबालसान दैज्लां सम#,
				'generic' => q#च’इबालसान सम#,
				'standard' => q#च’इबालसान थाखोआरि सम#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ख्रीस्टमास द्वीप सम#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#कक’स द्वीपफोरनि सम#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#कलम्बिया दैज्लां सम#,
				'generic' => q#कलम्बिया सम#,
				'standard' => q#कलम्बिया थाखोआरि सम#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#कुक द्वीपफोरनि खावसे दैज्लां सम#,
				'generic' => q#कुक द्वीपफोरनि सम#,
				'standard' => q#कुक द्वीपफोरनि थाखोआरि सम#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#किउबा सानारि सम#,
				'generic' => q#किउबा सम#,
				'standard' => q#किउबा थाखोआरि सम#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#डेभिस सम#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#डुमन्त-डीआर्भील सम#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ईस्ट टीमोर स्टैंडर्ड टाईम#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#सानजायारि द्वीप दैज्लां सम#,
				'generic' => q#सानजायारि द्वीप सम#,
				'standard' => q#सानजायारि द्वीप थाखोआरि सम#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#एकुवाडर सम#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#गोरोबहोनाय मुलुगनां सम#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#मिथियै नोगोर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ऐम्स्टरडाम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#आन्ड’रा#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#आस्त्राखान#,
		},
		'Europe/Athens' => {
			exemplarCity => q#एथेन्स#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बार्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ब्रातिस्लाभा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रुस्सेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#बुकारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुदापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#बुसिंगेन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसीनौ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कपेनहेगेन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डाबलिन#,
			long => {
				'daylight' => q#आईरीश थाखोआरि सम#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टार#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#गार्नसी#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हेल्सिंकी#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#आयोल अफ मेन#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#इस्तानबुल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जार्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कालिनींग्राद#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#कीभ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#किर’भ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#जुब्ल्याना#,
		},
		'Europe/London' => {
			exemplarCity => q#लन्दन#,
			long => {
				'daylight' => q#ब्रीटीश दैज्लां सम#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लाक्जेम्बार्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#माद्रिद#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#मारैहाम#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिन्स्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मनाक’#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मस्कौ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#अस्ल’#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पेरिस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पदग’रिका#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्रेग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रिगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#र’म#,
		},
		'Europe/Samara' => {
			exemplarCity => q#सामारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सान मारिन’#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#साराजेभ’#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#सारात’भ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फेर’प’ल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्क’प्जे#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सफिया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्ट’कह’म#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#टेलिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टिरेन#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ऊल्यान’भ्स्क#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#भाडुज#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#भेटिकान#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#भियेन्ना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#विल्निउस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#भल्ग’ग्रेद#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वारसौ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#जाग्रेब#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#जुरिख#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#मिरु युर’पनि दैज्लां सम#,
				'generic' => q#मिरु युर’पनि सम#,
				'standard' => q#मिरु युर’पनि थाखोआरि सम#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#सानजायारि युर’पनि दैज्लां सम#,
				'generic' => q#सानजायारि युर’पनि सम#,
				'standard' => q#सानजायारि युर’पनि थाखोआरि सम#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#गोजानसिन-सानजायारि युर’पनि सम#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#सोनाब युर’पनि दैज्लां सम#,
				'generic' => q#सोनाब युर’पनि सम#,
				'standard' => q#सोनाब युर’पनि थाखोआरि सम#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#फकलेण्ड द्वीपफोरनि दैज्लां सम#,
				'generic' => q#फकलेण्ड द्वीपफोरनि सम#,
				'standard' => q#फकलेण्ड द्वीपफोरनि थाखोआरि सम#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#फीजी दैज्लां सम#,
				'generic' => q#फीजी सम#,
				'standard' => q#फीजी थाखोआरि सम#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#फ्रेन्च गुईयाना सम#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#फ्रेन्च खोलायारि आरो एन्टार्कटिक सम#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ग्रिनवीच गेजेरारि सम#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#गालापाग’स सम#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#गाम्बियेर सम#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#जर्जिया दैज्लां सम#,
				'generic' => q#जर्जिया सम#,
				'standard' => q#जर्जिया थाखोआरि सम#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#गीलबार्ट द्वीपफोरनि सम#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#सानडजा ग्रीनलेण्ड दैज्लां सम#,
				'generic' => q#सानजा ग्रीनलेण्ड सम#,
				'standard' => q#सानजा ग्रीनलेण्ड थाखोआरि सम#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#सेनाब ग्रीनलेण्ड दैज्लां सम#,
				'generic' => q#सोनाब ग्रीनलेण्ड सम#,
				'standard' => q#सोनाब ग्रीनलेण्ड थाखोआरि सम#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#गुआम स्टैंडर्ड टाईम#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#गाल्फ थाखोआरि सम#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#गुयाना सम#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#हावाई-एल्युतियान सानारि सम#,
				'generic' => q#हावाई-एल्युतियान सम#,
				'standard' => q#हावाई-एल्युतियान थाखोआरि सम#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#हंकं दैज्लां सम#,
				'generic' => q#हंकं सम#,
				'standard' => q#हंकं थाखोआरि सम#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ह’भ्द दैज्लां सम#,
				'generic' => q#ह’भ्द सम#,
				'standard' => q#ह’भ्द थाखोआरि सम#,
			},
		},
		'India' => {
			long => {
				'standard' => q#भारतारि थाखोआरि सम#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#एन्टानानारिभ’#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#चाग’स#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ख्रीस्टमास द्वीप#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कक’स#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कम’र’#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#केर्गेलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#मालदीभ्स#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मरिशियास#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#माय’त्ते#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रेयूनिय’न#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#भारत लैथोमायारि सम#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ईंडो चइना स्टैंडर्ड टाईम#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ईंडोनीशिया स्टैंडर्ड टाईम#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#ईस्टर्न ईंडोनीशिया स्टैंडर्ड टाईम#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#वेस्टर्न ईंडोनीशिया स्टैंडर्ड टाईम#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#इरान सानारि सम#,
				'generic' => q#इरान सम#,
				'standard' => q#इरान थाखोआरि सम#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ईर्कुत्स्क दैज्लांं सम#,
				'generic' => q#ईर्कुत्स्क सम#,
				'standard' => q#ईर्कुत्स्क थाखोआरि सम#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#इज्राईल सानारि सम#,
				'generic' => q#इज्राईल सम#,
				'standard' => q#इज्राईल थाखोआरि सम#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#जापान सानारि सम#,
				'generic' => q#जापान सम#,
				'standard' => q#जापान थाखोआरि सम#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#पेत्रोपावलोस्क कामचटका समर टाईम#,
				'generic' => q#पेत्र’पाभ्ल’भ्स्क-कामचात्स्कि सम#,
				'standard' => q#पेत्रोपावलोस्क कामचटका स्टैंडर्ड टाईम#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#सानजा काजाखस्तान सम#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#सोनाब काजाखस्तान सम#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#क’रिया सानारि सम#,
				'generic' => q#क’रिया सम#,
				'standard' => q#क’रिया थाखोआरि सम#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#कस्रे सम#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#क्रास्न’यार्स्क दैज्लांं सम#,
				'generic' => q#क्रास्न’यार्स्क सम#,
				'standard' => q#क्रास्न’यार्स्क थाखोआरि सम#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#कीर्गीस्तान सम#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#लंका स्टैंडर्ड टाईम#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#लाईन द्वीपफोरनि सम#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#लर्ड हावि सानारि सम#,
				'generic' => q#लर्ड हावि सम#,
				'standard' => q#लर्ड हावि थाखोआरि सम#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#माकाऊ समर टाईम#,
				'generic' => q#माकाऊ सम#,
				'standard' => q#माकाऊ स्टैंडर्ड टाईम#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#मागादान दैज्लां सम#,
				'generic' => q#मागादान सम#,
				'standard' => q#मागादान थाखोआरि सम#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#मलेशिया स्टैंडर्ड टाईम#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#मालदीभ्स सम#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#मार्केसास सम#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#मार्शेल द्वीपफोरनि सम#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#म’रिशियासनि दैज्लां सम#,
				'generic' => q#म’रिशियासनि सम#,
				'standard' => q#म’रिशियासनि थाखोआरि सम#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#मौसन सम#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#मेक्सिक’नि पेसिफिक सानारि सम#,
				'generic' => q#मेक्सिक’नि पेसिफिक सम#,
				'standard' => q#मेक्सिक’नि पेसिफिक थाखोआरि सम#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#उलानबातार दैज्लां सम#,
				'generic' => q#उलानबातार सम#,
				'standard' => q#उलानबातार थाखोआरि सम#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#मस्कौ दैज्लां सम#,
				'generic' => q#मस्कौ सम#,
				'standard' => q#मस्कौ थाखोआरि सम#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#म्यानमार स्टैंडर्ड टाईम#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#नाऊरु सम#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#नेपाल सम#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#गोदान केलेडनिया दैज्लां सम#,
				'generic' => q#गोदान केलेडनिया सम#,
				'standard' => q#गोदान केलेडनिया थाखोआरि सम#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#निउजिलेण्ड सानारि सम#,
				'generic' => q#निउजिलेण्ड सम#,
				'standard' => q#निउजिलेण्ड थाखोआरि सम#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#निउफाउन्दलेन्द सानारि सम#,
				'generic' => q#निउफाउन्दलेन्द सम#,
				'standard' => q#निउफाउन्दलेन्द थाखोआरि सम#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#नीऊए सम#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#नरफ’क द्वीप सानारि सम#,
				'generic' => q#नरफ’क द्वीप सम#,
				'standard' => q#नरफ’क द्वीप थाखोआरि सम#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#फेरनान्द’ दे नर’न्हा दैज्लां सम#,
				'generic' => q#फेरनान्द’ दे नर’न्हा सम#,
				'standard' => q#फेरनान्द’ दे नर’न्हा थाखोआरि सम#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#नॉर्थ मारिआना स्टैंडर्ड टाईम#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#नभ’सिबिर्स्क दैज्लां सम#,
				'generic' => q#नभ’सिबिर्स्क सम#,
				'standard' => q#नभ’सिबिर्स्क थाखोआरि सम#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#अम्स्क दैज्लां सम#,
				'generic' => q#अम्स्क सम#,
				'standard' => q#अम्स्क थाखोआरि सम#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#आपिया#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#औकलैण्ड#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#बुगैनभील#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चाथाम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#सानजायारि#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#एफाटे#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#एन्डारबारी#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फाकाअफ’#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फिजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फुनाफूटी#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गालापाग’स#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#गाम्बियेर#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ग्वाडालकेनेल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#गुवाम#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#हनलुलु#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#केन्ट’न#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरीतिमाति#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कस्रे#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाजालैन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#माजूर’#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मार्केसास#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मीडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नाऊरु#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#नीऊए#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नरफ’क#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नूमिया#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पाग’ पाग’#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पालाउ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पिटकैर्न#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पनापे#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पर्ट मर्सबी#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#रार’टंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#साइपान#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#टाहिटी#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#तारावा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टंगाटापु#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#चूक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वेक#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वालिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#पाकिस्तान दैज्लां सम#,
				'generic' => q#पाकिस्तान सम#,
				'standard' => q#पाकिस्तान थाखोआरि सम#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#पालाउ सम#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#पापुआ निउ गिनी सम#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#पारागुवे दैज्लां सम#,
				'generic' => q#पारागुवे सम#,
				'standard' => q#पारागुवे थाखोआरि सम#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#पेरु दैज्लां सम#,
				'generic' => q#पेरु सम#,
				'standard' => q#पेरु थाखोआरि सम#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#फीलीपीन्स समर टाईम#,
				'generic' => q#फिलीपीन्स सम#,
				'standard' => q#फीलीपीन्स स्टैंडर्ड टाईम#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#फनीक्स द्वीपफोरनि सम#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#सैन्ट पियेर आरो मिक्वेलन सानारि सम#,
				'generic' => q#सैन्ट पियेर आरो मिक्वेलन सम#,
				'standard' => q#सैन्ट पियेर आरो मिक्वेलन थाखोआरि सम#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#पीटकैर्न सम#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#पनापे सम#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#प्यंयां सम#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#क़ीज़ीलोर्डा समर टाईम#,
				'generic' => q#क़ीज़ीलोर्डा टाईम#,
				'standard' => q#क़ीज़ीलोर्डा स्टैंडर्ड टाईम#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#रियूनियन सम#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#रथेरा सम#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#साखालिन दैज्लां सम#,
				'generic' => q#साखालिन सम#,
				'standard' => q#साखालिन थाखोआरि सम#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#समारा समर टाईम#,
				'generic' => q#समारा टाईम#,
				'standard' => q#समारा स्टैंडर्ड टाईम#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#साम’वा सानारि सम#,
				'generic' => q#साम’वा सम#,
				'standard' => q#साम’वा थाखोआरि सम#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#सेशेल्स सम#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#सींगापुर स्टैंडर्ड टाईम#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#सल’मन द्वीपफोरनि सम#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#खोला जर्जिया सम#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#सुरीनाम सम#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#सीअवा सम#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#टाहिटी सम#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ताईपेइ सानारि सम#,
				'generic' => q#ताईपेइ सम#,
				'standard' => q#ताईपेइ थाखोआरि सम#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ताजिकिस्तान सम#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#टकेलौ सम#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#टंगा दैज्लां सम#,
				'generic' => q#टंगा सम#,
				'standard' => q#टंगा थाखोआरि सम#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#चूक सम#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#तुर्कमेनीस्तान दैज्लां सम#,
				'generic' => q#तुर्कमेनीस्तान सम#,
				'standard' => q#तुर्कमेनीस्तान थाखोआरि सम#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#तुभालु सम#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#उरुगुवे दैज्लां सम#,
				'generic' => q#उरुगुवे सम#,
				'standard' => q#उरुगुवे थाखोआरि सम#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#उजबेकिस्तान दैज्लां सम#,
				'generic' => q#उजबेकिस्तान सम#,
				'standard' => q#उजबेकिस्तान थाखोआरि सम#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#वानुआटु दैज्लां सम#,
				'generic' => q#वानुआटु सम#,
				'standard' => q#वानुआटु थाखोआरि सम#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#भेनेजुवेला सम#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#भ्लादिभस्त’क दैज्लां सम#,
				'generic' => q#भ्लादिभस्त’क सम#,
				'standard' => q#भ्लादिभस्त’क थाखोआरि सम#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#भल्ग’ग्रेद दैज्लां सम#,
				'generic' => q#भल्ग’ग्रेद सम#,
				'standard' => q#भल्ग’ग्रेद थाखोआरि सम#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#भस्त’क सम#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#वैक द्वीप सम#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#वालीस आरो फुतुना सम#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#याकुत्स्क दैज्लां सम#,
				'generic' => q#याकुत्स्क सम#,
				'standard' => q#याकुत्स्क थाखोआरि सम#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#येकातेरीनाबुर्ग दैज्लां सम#,
				'generic' => q#येकातेरीनाबुर्ग सम#,
				'standard' => q#येकातेरीनाबुर्ग थाखोआरि सम#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#यूकन सम#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
