=head1

Locale::CLDR::Locales::Br - Package for language Breton

=cut

package Locale::CLDR::Locales::Br;
# This file auto generated from Data\common\main\br.xml
#	on Sat  6 Feb 10:30:22 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'afar',
 				'ab' => 'abkhazeg',
 				'ace' => 'achineg',
 				'ach' => 'acoli',
 				'ada' => 'adangme',
 				'ady' => 'adygeieg',
 				'ae' => 'avesteg',
 				'aeb' => 'arabeg Tunizia',
 				'af' => 'afrikaans',
 				'afh' => 'afrihili',
 				'agq' => 'aghem',
 				'ain' => 'ainoueg',
 				'ak' => 'akan',
 				'akk' => 'akadeg',
 				'akz' => 'alabamaeg',
 				'ale' => 'aleouteg',
 				'aln' => 'gegeg',
 				'alt' => 'altaieg ar Su',
 				'am' => 'amhareg',
 				'an' => 'aragoneg',
 				'ang' => 'hensaozneg',
 				'anp' => 'angika',
 				'ar' => 'arabeg',
 				'ar_001' => 'arabeg modern',
 				'arc' => 'arameeg',
 				'arn' => 'araoukaneg',
 				'aro' => 'araona',
 				'arp' => 'arapaho',
 				'arq' => 'arabeg Aljeria',
 				'arw' => 'arawakeg',
 				'ary' => 'arabeg Maroko',
 				'arz' => 'arabeg Egipt',
 				'as' => 'asameg',
 				'asa' => 'asu',
 				'ase' => 'yezh sinoù Amerika',
 				'ast' => 'asturianeg',
 				'av' => 'avar',
 				'awa' => 'awadhi',
 				'ay' => 'aymara',
 				'az' => 'azerbaidjaneg',
 				'az@alt=short' => 'azeri',
 				'ba' => 'bachkir',
 				'bal' => 'baloutchi',
 				'ban' => 'balineg',
 				'bar' => 'bavarieg',
 				'bas' => 'basaa',
 				'be' => 'belaruseg',
 				'bej' => 'bedawieg',
 				'bem' => 'bemba',
 				'bez' => 'bena',
 				'bg' => 'bulgareg',
 				'bgn' => 'baloutchi ar Cʼhornôg',
 				'bho' => 'bhojpuri',
 				'bi' => 'bislama',
 				'bik' => 'bikol',
 				'bin' => 'bini',
 				'bm' => 'bambara',
 				'bn' => 'bengali',
 				'bo' => 'tibetaneg',
 				'br' => 'brezhoneg',
 				'bra' => 'braj',
 				'brh' => 'brahweg',
 				'brx' => 'bodo',
 				'bs' => 'bosneg',
 				'bss' => 'akoose',
 				'bua' => 'bouriat',
 				'bug' => 'bugi',
 				'byn' => 'blin',
 				'ca' => 'katalaneg',
 				'cad' => 'caddo',
 				'car' => 'karibeg',
 				'cch' => 'atsam',
 				'ce' => 'tchetcheneg',
 				'ceb' => 'cebuano',
 				'ch' => 'chamorru',
 				'chb' => 'chibcha',
 				'chm' => 'marieg',
 				'cho' => 'choktaw',
 				'chp' => 'chipewyan',
 				'chr' => 'cherokee',
 				'chy' => 'cheyenne',
 				'ckb' => 'kurdeg sorani',
 				'co' => 'korseg',
 				'cop' => 'kopteg',
 				'cr' => 'kri',
 				'crh' => 'turkeg Krimea',
 				'cs' => 'tchekeg',
 				'csb' => 'kachoubeg',
 				'cu' => 'slavoneg iliz',
 				'cv' => 'tchouvatch',
 				'cy' => 'kembraeg',
 				'da' => 'daneg',
 				'dak' => 'dakota',
 				'dar' => 'dargwa',
 				'de' => 'alamaneg',
 				'de_AT' => 'alamaneg Aostria',
 				'de_CH' => 'alamaneg uhel Suis',
 				'del' => 'delaware',
 				'dgr' => 'dogrib',
 				'din' => 'dinka',
 				'doi' => 'dogri',
 				'dsb' => 'izelsorabeg',
 				'dum' => 'nederlandeg krenn',
 				'dv' => 'divehi',
 				'dyu' => 'dyula',
 				'dz' => 'dzongkha',
 				'ebu' => 'embu',
 				'ee' => 'ewe',
 				'efi' => 'efik',
 				'egy' => 'henegipteg',
 				'eka' => 'ekajuk',
 				'el' => 'gresianeg',
 				'elx' => 'elameg',
 				'en' => 'saozneg',
 				'en_AU' => 'saozneg Aostralia',
 				'en_CA' => 'saozneg Kanada',
 				'en_GB' => 'saozneg Breizh-Veur',
 				'en_GB@alt=short' => 'saozneg RU',
 				'en_US' => 'saozneg Amerika',
 				'en_US@alt=short' => 'saozneg SU',
 				'enm' => 'krennsaozneg',
 				'eo' => 'esperanteg',
 				'es' => 'spagnoleg',
 				'es_419' => 'spagnoleg Amerika latin',
 				'es_ES' => 'spagnoleg Europa',
 				'es_MX' => 'spagnoleg Mecʼhiko',
 				'et' => 'estoneg',
 				'eu' => 'euskareg',
 				'ewo' => 'ewondo',
 				'fa' => 'perseg',
 				'fan' => 'fang',
 				'fat' => 'fanti',
 				'fi' => 'finneg',
 				'fil' => 'filipineg',
 				'fit' => 'finneg traoñienn an Torne',
 				'fj' => 'fidjieg',
 				'fo' => 'faeroeg',
 				'fon' => 'fon',
 				'fr' => 'galleg',
 				'fr_CA' => 'galleg Kanada',
 				'fr_CH' => 'galleg Suis',
 				'frc' => 'galleg cajun',
 				'frm' => 'krenncʼhalleg',
 				'fro' => 'hencʼhalleg',
 				'frp' => 'arpitaneg',
 				'frr' => 'frizeg an Norzh',
 				'frs' => 'frizeg ar Reter',
 				'fur' => 'frioulaneg',
 				'fy' => 'frizeg ar Cʼhornôg',
 				'ga' => 'iwerzhoneg',
 				'gaa' => 'ga',
 				'gag' => 'gagaouzeg',
 				'gan' => 'sinaeg Gan',
 				'gay' => 'gayo',
 				'gba' => 'gbaya',
 				'gd' => 'skoseg',
 				'gez' => 'gezeg',
 				'gil' => 'gilberteg',
 				'gl' => 'galizeg',
 				'gmh' => 'krennalamaneg uhel',
 				'gn' => 'guarani',
 				'goh' => 'henalamaneg uhel',
 				'gor' => 'gorontalo',
 				'got' => 'goteg',
 				'grb' => 'grebo',
 				'grc' => 'hencʼhresianeg',
 				'gsw' => 'alamaneg Suis',
 				'gu' => 'gujarati',
 				'gv' => 'manaveg',
 				'ha' => 'haousa',
 				'hai' => 'haida',
 				'hak' => 'sinaeg Hakka',
 				'haw' => 'hawaieg',
 				'he' => 'hebraeg',
 				'hi' => 'hindi',
 				'hil' => 'hiligaynon',
 				'hmn' => 'hmong',
 				'ho' => 'hiri motu',
 				'hr' => 'kroateg',
 				'hsb' => 'uhelsorabeg',
 				'hsn' => 'sinaeg Xian',
 				'ht' => 'haitieg',
 				'hu' => 'hungareg',
 				'hup' => 'hupa',
 				'hy' => 'armenianeg',
 				'hz' => 'herero',
 				'ia' => 'interlingua',
 				'iba' => 'iban',
 				'ibb' => 'ibibio',
 				'id' => 'indonezeg',
 				'ie' => 'interlingue',
 				'ig' => 'igbo',
 				'ii' => 'yieg Sichuan',
 				'ik' => 'inupiaq',
 				'inh' => 'ingoucheg',
 				'io' => 'ido',
 				'is' => 'islandeg',
 				'it' => 'italianeg',
 				'iu' => 'inuktitut',
 				'ja' => 'japaneg',
 				'jam' => 'kreoleg Jamaika',
 				'jpr' => 'yuzev-perseg',
 				'jrb' => 'yuzev-arabeg',
 				'jv' => 'javaneg',
 				'ka' => 'jorjianeg',
 				'kaa' => 'karakalpak',
 				'kab' => 'kabileg',
 				'kac' => 'kachin',
 				'kam' => 'kamba',
 				'kbd' => 'kabardeg',
 				'kea' => 'kabuverdianu',
 				'kg' => 'kongo',
 				'kha' => 'khasi',
 				'kho' => 'khotaneg',
 				'ki' => 'kikuyu',
 				'kj' => 'kwanyama',
 				'kk' => 'kazak',
 				'km' => 'khmer',
 				'kmb' => 'kimbundu',
 				'kn' => 'kanareg',
 				'ko' => 'koreaneg',
 				'kok' => 'konkani',
 				'kos' => 'kosrae',
 				'kpe' => 'kpelle',
 				'kr' => 'kanouri',
 				'krc' => 'karatchay-balkar',
 				'kri' => 'krio',
 				'krl' => 'karelieg',
 				'kru' => 'kurukh',
 				'ks' => 'kashmiri',
 				'ksh' => 'koluneg',
 				'ku' => 'kurdeg',
 				'kut' => 'kutenai',
 				'kw' => 'kerneveureg',
 				'ky' => 'kirgiz',
 				'la' => 'latin',
 				'lad' => 'ladino',
 				'lah' => 'lahnda',
 				'lam' => 'lamba',
 				'lb' => 'luksembourgeg',
 				'lez' => 'lezgi',
 				'lfn' => 'lingua franca nova',
 				'lg' => 'ganda',
 				'li' => 'limbourgeg',
 				'lij' => 'ligurieg',
 				'ln' => 'lingala',
 				'lo' => 'laoseg',
 				'lol' => 'mongo',
 				'loz' => 'lozi',
 				'lt' => 'lituaneg',
 				'lu' => 'luba-katanga',
 				'lua' => 'luba-lulua',
 				'lui' => 'luiseno',
 				'lun' => 'lunda',
 				'luo' => 'luo',
 				'lus' => 'lushai',
 				'luy' => 'luyia',
 				'lv' => 'latvieg',
 				'lzh' => 'sinaeg lennegel',
 				'mag' => 'magahi',
 				'mai' => 'maithili',
 				'mas' => 'masai',
 				'mdf' => 'moksha',
 				'mdr' => 'mandar',
 				'men' => 'mende',
 				'mfe' => 'moriseg',
 				'mg' => 'malgacheg',
 				'mga' => 'krenniwerzhoneg',
 				'mh' => 'marshall',
 				'mi' => 'maori',
 				'mk' => 'makedoneg',
 				'ml' => 'malayalam',
 				'mn' => 'mongoleg',
 				'mnc' => 'manchou',
 				'mni' => 'manipuri',
 				'moh' => 'mohawk',
 				'mr' => 'marathi',
 				'mrj' => 'marieg ar Cʼhornôg',
 				'ms' => 'malayseg',
 				'mt' => 'malteg',
 				'mul' => 'yezhoù lies',
 				'mus' => 'muskogi',
 				'mwl' => 'mirandeg',
 				'my' => 'birmaneg',
 				'myv' => 'erza',
 				'na' => 'naurueg',
 				'nan' => 'sinaeg Min Nan',
 				'nap' => 'napolitaneg',
 				'nb' => 'norvegeg bokmål',
 				'nd' => 'ndebele an Norzh',
 				'nds' => 'alamaneg izel',
 				'nds_NL' => 'saksoneg izel',
 				'ne' => 'nepaleg',
 				'new' => 'newari',
 				'ng' => 'ndonga',
 				'nia' => 'nias',
 				'niu' => 'niue',
 				'njo' => 'aoeg',
 				'nl' => 'nederlandeg',
 				'nl_BE' => 'flandrezeg',
 				'nn' => 'norvegeg nynorsk',
 				'no' => 'norvegeg',
 				'nog' => 'nogay',
 				'non' => 'hennorseg',
 				'nov' => 'novial',
 				'nr' => 'ndebele ar Su',
 				'nso' => 'sotho an Norzh',
 				'nv' => 'navacʼho',
 				'nwc' => 'newari klasel',
 				'ny' => 'nyanja',
 				'nym' => 'nyamwezi',
 				'nyn' => 'nyankole',
 				'nyo' => 'nyoro',
 				'oc' => 'okitaneg',
 				'oj' => 'ojibwa',
 				'or' => 'oriya',
 				'os' => 'oseteg',
 				'osa' => 'osage',
 				'ota' => 'turkeg otoman',
 				'pa' => 'punjabi',
 				'pag' => 'pangasinan',
 				'pal' => 'pahlavi',
 				'pam' => 'pampanga',
 				'pap' => 'papiamento',
 				'pau' => 'palau',
 				'pcd' => 'pikardeg',
 				'pdc' => 'alamaneg Pennsylvania',
 				'peo' => 'henberseg',
 				'phn' => 'fenikianeg',
 				'pi' => 'pali',
 				'pl' => 'poloneg',
 				'pms' => 'piemonteg',
 				'pnt' => 'ponteg',
 				'pon' => 'pohnpei',
 				'prg' => 'henbruseg',
 				'pro' => 'henbrovañseg',
 				'ps' => 'pachto',
 				'pt' => 'portugaleg',
 				'pt_BR' => 'portugaleg Brazil',
 				'pt_PT' => 'portugaleg Europa',
 				'qu' => 'kechuaeg',
 				'qug' => 'kichuaeg Chimborazo',
 				'raj' => 'rajasthani',
 				'rap' => 'rapanui',
 				'rar' => 'rarotonga',
 				'rgn' => 'romagnoleg',
 				'rm' => 'romañcheg',
 				'rn' => 'rundi',
 				'ro' => 'roumaneg',
 				'ro_MD' => 'moldoveg',
 				'rof' => 'rombo',
 				'rom' => 'romanieg',
 				'ru' => 'rusianeg',
 				'rup' => 'aroumaneg',
 				'rw' => 'kinyarwanda',
 				'rwk' => 'rwa',
 				'sa' => 'sanskriteg',
 				'sad' => 'sandawe',
 				'sah' => 'yakouteg',
 				'sam' => 'arameeg ar Samaritaned',
 				'sas' => 'sasak',
 				'sat' => 'santali',
 				'sc' => 'sardeg',
 				'scn' => 'sikilieg',
 				'sco' => 'skoteg',
 				'sd' => 'sindhi',
 				'sdc' => 'sasareseg',
 				'se' => 'sámi an Norzh',
 				'sg' => 'sango',
 				'sga' => 'heniwerzhoneg',
 				'sh' => 'serb-kroateg',
 				'shi' => 'tacheliteg',
 				'shn' => 'shan',
 				'shu' => 'arabeg Tchad',
 				'si' => 'singhaleg',
 				'sid' => 'sidamo',
 				'sk' => 'slovakeg',
 				'sl' => 'sloveneg',
 				'sm' => 'samoan',
 				'sma' => 'sámi ar Su',
 				'smj' => 'sámi Luleå',
 				'smn' => 'sámi Inari',
 				'sms' => 'sámi Skolt',
 				'sn' => 'shona',
 				'snk' => 'soninke',
 				'so' => 'somali',
 				'sog' => 'sogdieg',
 				'sq' => 'albaneg',
 				'sr' => 'serbeg',
 				'srr' => 'serer',
 				'ss' => 'swati',
 				'st' => 'sotho ar Su',
 				'su' => 'sundaneg',
 				'sux' => 'sumereg',
 				'sv' => 'svedeg',
 				'sw' => 'swahili',
 				'swb' => 'komoreg',
 				'swc' => 'swahili Kongo',
 				'syc' => 'sirieg klasel',
 				'syr' => 'sirieg',
 				'szl' => 'silezieg',
 				'ta' => 'tamileg',
 				'tcy' => 'touloueg',
 				'te' => 'telougou',
 				'ter' => 'tereno',
 				'tet' => 'tetum',
 				'tg' => 'tadjik',
 				'th' => 'thai',
 				'ti' => 'tigrigna',
 				'tig' => 'tigreaneg',
 				'tiv' => 'tiv',
 				'tk' => 'turkmeneg',
 				'tkl' => 'tokelau',
 				'tl' => 'tagalog',
 				'tlh' => 'klingon',
 				'tli' => 'tinglit',
 				'tmh' => 'tamacheg',
 				'tn' => 'tswana',
 				'to' => 'tonga',
 				'tog' => 'nyasa tonga',
 				'tpi' => 'tok pisin',
 				'tr' => 'turkeg',
 				'tru' => 'turoyoeg',
 				'ts' => 'tsonga',
 				'tsi' => 'tsimshian',
 				'tt' => 'tatar',
 				'tum' => 'tumbuka',
 				'tvl' => 'tuvalu',
 				'tw' => 'twi',
 				'ty' => 'tahitianeg',
 				'tyv' => 'touva',
 				'tzm' => 'tamazigteg Kreizatlas',
 				'udm' => 'oudmourteg',
 				'ug' => 'ouigoureg',
 				'uga' => 'ougariteg',
 				'uk' => 'ukraineg',
 				'umb' => 'umbundu',
 				'und' => 'yezh dianav',
 				'ur' => 'ourdou',
 				'uz' => 'ouzbekeg',
 				'vai' => 'vai',
 				've' => 'venda',
 				'vec' => 'venezieg',
 				'vep' => 'vepseg',
 				'vi' => 'vietnameg',
 				'vls' => 'flandrezeg ar c’hornôg',
 				'vo' => 'volapük',
 				'vot' => 'votyakeg',
 				'vro' => 'voroeg',
 				'wa' => 'walloneg',
 				'wae' => 'walser',
 				'wal' => 'walamo',
 				'war' => 'waray',
 				'was' => 'washo',
 				'wo' => 'wolof',
 				'wuu' => 'sinaeg Wu',
 				'xal' => 'kalmouk',
 				'xh' => 'xhosa',
 				'xmf' => 'megreleg',
 				'yao' => 'yao',
 				'yap' => 'yapeg',
 				'yi' => 'yiddish',
 				'yo' => 'yorouba',
 				'yue' => 'kantoneg',
 				'za' => 'zhuang',
 				'zap' => 'zapoteg',
 				'zbl' => 'Bliss',
 				'zea' => 'zelandeg',
 				'zen' => 'zenaga',
 				'zgh' => 'tamacheg Maroko standart',
 				'zh' => 'sinaeg',
 				'zh_Hans' => 'sinaeg eeunaet',
 				'zh_Hant' => 'sinaeg hengounel',
 				'zu' => 'zouloueg',
 				'zun' => 'zuni',
 				'zxx' => 'diyezh',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'arabek',
 			'Armi' => 'arameek impalaerel',
 			'Armn' => 'armenianek',
 			'Avst' => 'avestek',
 			'Bali' => 'balinek',
 			'Beng' => 'bengali',
 			'Bopo' => 'bopomofo',
 			'Brai' => 'Braille',
 			'Bugi' => 'bougiek',
 			'Copt' => 'koptek',
 			'Cyrl' => 'kirillek',
 			'Cyrs' => 'kirillek henslavonek',
 			'Deva' => 'devanagari',
 			'Egyp' => 'hieroglifoù egiptek',
 			'Ethi' => 'etiopek',
 			'Geor' => 'jorjianek',
 			'Glag' => 'glagolitek',
 			'Goth' => 'gotek',
 			'Grek' => 'gresianek',
 			'Gujr' => 'gujarati',
 			'Guru' => 'gurmukhi',
 			'Hang' => 'hangeul',
 			'Hani' => 'han',
 			'Hans' => 'eeunaet',
 			'Hans@alt=stand-alone' => 'han eeunaet',
 			'Hant' => 'hengounel',
 			'Hant@alt=stand-alone' => 'han hengounel',
 			'Hebr' => 'hebraek',
 			'Hira' => 'hiragana',
 			'Hluw' => 'hieroglifoù Anatolia',
 			'Ital' => 'henitalek',
 			'Java' => 'javanek',
 			'Jpan' => 'japanek',
 			'Kana' => 'katakana',
 			'Khmr' => 'khmer',
 			'Knda' => 'kannada',
 			'Kore' => 'koreanek',
 			'Laoo' => 'laosek',
 			'Latg' => 'latin gouezelek',
 			'Latn' => 'latin',
 			'Maya' => 'hieroglifoù mayaek',
 			'Mlym' => 'malayalam',
 			'Mong' => 'mongolek',
 			'Mymr' => 'myanmar',
 			'Ogam' => 'ogam',
 			'Orya' => 'oriya',
 			'Runr' => 'runek',
 			'Sinh' => 'singhalek',
 			'Sund' => 'sundanek',
 			'Syrc' => 'siriek',
 			'Syre' => 'siriek Estrangelā',
 			'Syrj' => 'siriek ar C’hornôg',
 			'Syrn' => 'siriek ar Reter',
 			'Taml' => 'tamilek',
 			'Telu' => 'telougou',
 			'Tglg' => 'tagalog',
 			'Thaa' => 'thaana',
 			'Thai' => 'thai',
 			'Tibt' => 'tibetanek',
 			'Ugar' => 'ougaritek',
 			'Vaii' => 'vai',
 			'Xpeo' => 'persek kozh',
 			'Zmth' => 'notadur jedoniel',
 			'Zsym' => 'arouezioù',
 			'Zxxx' => 'anskrivet',
 			'Zyyy' => 'boutin',
 			'Zzzz' => 'skritur dianav',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Bed',
 			'002' => 'Afrika',
 			'003' => 'Norzhamerika',
 			'005' => 'Suamerika',
 			'009' => 'Oseania',
 			'011' => 'Afrika ar Cʼhornôg',
 			'013' => 'Kreizamerika',
 			'014' => 'Afrika ar Reter',
 			'015' => 'Afrika an Norzh',
 			'017' => 'Afrika ar Cʼhreiz',
 			'018' => 'Afrika ar Su',
 			'019' => 'Amerikaoù',
 			'021' => 'Amerika an Norzh',
 			'029' => 'Karib',
 			'030' => 'Azia ar Reter',
 			'034' => 'Azia ar Su',
 			'035' => 'Azia ar Gevred',
 			'039' => 'Europa ar Su',
 			'053' => 'Aostralazia',
 			'054' => 'Melanezia',
 			'057' => 'Rannved Mikronezia',
 			'061' => 'Polinezia',
 			'142' => 'Azia',
 			'143' => 'Azia ar Cʼhreiz',
 			'145' => 'Azia ar Cʼhornôg',
 			'150' => 'Europa',
 			'151' => 'Europa ar Reter',
 			'154' => 'Europa an Norzh',
 			'155' => 'Europa ar Cʼhornôg',
 			'419' => 'Amerika Latin',
 			'AC' => 'Enez Ascension',
 			'AD' => 'Andorra',
 			'AE' => 'Emirelezhioù Arab Unanet',
 			'AF' => 'Afghanistan',
 			'AG' => 'Antigua ha Barbuda',
 			'AI' => 'Anguilla',
 			'AL' => 'Albania',
 			'AM' => 'Armenia',
 			'AN' => 'Antilhez Nederlandat',
 			'AO' => 'Angola',
 			'AQ' => 'Antarktika',
 			'AR' => 'Arcʼhantina',
 			'AS' => 'Samoa Amerikan',
 			'AT' => 'Aostria',
 			'AU' => 'Aostralia',
 			'AW' => 'Aruba',
 			'AX' => 'Inizi Åland',
 			'AZ' => 'Azerbaidjan',
 			'BA' => 'Bosnia ha Herzegovina',
 			'BB' => 'Barbados',
 			'BD' => 'Bangladesh',
 			'BE' => 'Belgia',
 			'BF' => 'Burkina Faso',
 			'BG' => 'Bulgaria',
 			'BH' => 'Bahrein',
 			'BI' => 'Burundi',
 			'BJ' => 'Benin',
 			'BL' => 'Saint Barthélemy',
 			'BM' => 'Bermuda',
 			'BN' => 'Brunei',
 			'BO' => 'Bolivia',
 			'BQ' => 'Karib Nederlandat',
 			'BR' => 'Brazil',
 			'BS' => 'Bahamas',
 			'BT' => 'Bhoutan',
 			'BV' => 'Enez Bouvet',
 			'BW' => 'Botswana',
 			'BY' => 'Belarus',
 			'BZ' => 'Belize',
 			'CA' => 'Kanada',
 			'CC' => 'Inizi Kokoz',
 			'CD' => 'Kongo - Kinshasa',
 			'CD@alt=variant' => 'Kongo (RDK)',
 			'CF' => 'Republik Kreizafrikan',
 			'CG' => 'Kongo - Brazzaville',
 			'CG@alt=variant' => 'Kongo (Republik)',
 			'CH' => 'Suis',
 			'CI' => 'Aod an Olifant',
 			'CI@alt=variant' => 'Aod Olifant',
 			'CK' => 'Inizi Cook',
 			'CL' => 'Chile',
 			'CM' => 'Kameroun',
 			'CN' => 'Sina',
 			'CO' => 'Kolombia',
 			'CP' => 'Enez Clipperton',
 			'CR' => 'Costa Rica',
 			'CU' => 'Kuba',
 			'CV' => 'Kab-Glas',
 			'CW' => 'Curaçao',
 			'CX' => 'Enez Christmas',
 			'CY' => 'Kiprenez',
 			'CZ' => 'Republik Tchek',
 			'DE' => 'Alamagn',
 			'DG' => 'Diego Garcia',
 			'DJ' => 'Djibouti',
 			'DK' => 'Danmark',
 			'DM' => 'Dominica',
 			'DO' => 'Republik Dominikan',
 			'DZ' => 'Aljeria',
 			'EA' => 'Ceuta ha Melilla',
 			'EC' => 'Ecuador',
 			'EE' => 'Estonia',
 			'EG' => 'Egipt',
 			'EH' => 'Sahara ar Cʼhornôg',
 			'ER' => 'Eritrea',
 			'ES' => 'Spagn',
 			'ET' => 'Etiopia',
 			'EU' => 'Unaniezh Europa',
 			'FI' => 'Finland',
 			'FJ' => 'Fidji',
 			'FK' => 'Inizi Falkland',
 			'FK@alt=variant' => 'Inizi Falkland (Inizi Maloù)',
 			'FM' => 'Mikronezia',
 			'FO' => 'Inizi Faero',
 			'FR' => 'Frañs',
 			'GA' => 'Gabon',
 			'GB' => 'Rouantelezh-Unanet',
 			'GB@alt=short' => 'RU',
 			'GD' => 'Grenada',
 			'GE' => 'Jorjia',
 			'GF' => 'Gwiana cʼhall',
 			'GG' => 'Gwernenez',
 			'GH' => 'Ghana',
 			'GI' => 'Jibraltar',
 			'GL' => 'Greunland',
 			'GM' => 'Gambia',
 			'GN' => 'Ginea',
 			'GP' => 'Gwadeloup',
 			'GQ' => 'Ginea ar Cʼheheder',
 			'GR' => 'Gres',
 			'GS' => 'Inizi Georgia ar Su hag Inizi Sandwich ar Su',
 			'GT' => 'Guatemala',
 			'GU' => 'Guam',
 			'GW' => 'Ginea-Bissau',
 			'GY' => 'Guyana',
 			'HK' => 'Hong Kong RMD Sina',
 			'HK@alt=short' => 'Hong Kong',
 			'HM' => 'Inizi Heard ha McDonald',
 			'HN' => 'Honduras',
 			'HR' => 'Kroatia',
 			'HT' => 'Haiti',
 			'HU' => 'Hungaria',
 			'IC' => 'Inizi Kanariez',
 			'ID' => 'Indonezia',
 			'IE' => 'Iwerzhon',
 			'IL' => 'Israel',
 			'IM' => 'Enez Vanav',
 			'IN' => 'India',
 			'IO' => 'Tiriad breizhveurat Meurvor Indez',
 			'IQ' => 'Iraq',
 			'IR' => 'Iran',
 			'IS' => 'Island',
 			'IT' => 'Italia',
 			'JE' => 'Jerzenez',
 			'JM' => 'Jamaika',
 			'JO' => 'Jordania',
 			'JP' => 'Japan',
 			'KE' => 'Kenya',
 			'KG' => 'Kyrgyzstan',
 			'KH' => 'Kambodja',
 			'KI' => 'Kiribati',
 			'KM' => 'Komorez',
 			'KN' => 'Saint Kitts ha Nevis',
 			'KP' => 'Korea an Norzh',
 			'KR' => 'Korea ar Su',
 			'KW' => 'Koweit',
 			'KY' => 'Inizi Cayman',
 			'KZ' => 'Kazakstan',
 			'LA' => 'Laos',
 			'LB' => 'Liban',
 			'LC' => 'Saint Lucia',
 			'LI' => 'Liechtenstein',
 			'LK' => 'Sri Lanka',
 			'LR' => 'Liberia',
 			'LS' => 'Lesotho',
 			'LT' => 'Lituania',
 			'LU' => 'Luksembourg',
 			'LV' => 'Latvia',
 			'LY' => 'Libia',
 			'MA' => 'Maroko',
 			'MC' => 'Monaco',
 			'MD' => 'Moldova',
 			'ME' => 'Montenegro',
 			'MF' => 'Saint Martin',
 			'MG' => 'Madagaskar',
 			'MH' => 'Inizi Marshall',
 			'MK' => 'Makedonia',
 			'MK@alt=variant' => 'Makedonia (RYKM)',
 			'ML' => 'Mali',
 			'MM' => 'Myanmar (Birmania)',
 			'MN' => 'Mongolia',
 			'MO' => 'Macau RMD Sina',
 			'MO@alt=short' => 'Macau',
 			'MP' => 'Inizi Mariana an Norzh',
 			'MQ' => 'Martinik',
 			'MR' => 'Maouritania',
 			'MS' => 'Montserrat',
 			'MT' => 'Malta',
 			'MU' => 'Moris',
 			'MV' => 'Maldivez',
 			'MW' => 'Malawi',
 			'MX' => 'Mecʼhiko',
 			'MY' => 'Malaysia',
 			'MZ' => 'Mozambik',
 			'NA' => 'Namibia',
 			'NC' => 'Kaledonia Nevez',
 			'NE' => 'Niger',
 			'NF' => 'Enez Norfolk',
 			'NG' => 'Nigeria',
 			'NI' => 'Nicaragua',
 			'NL' => 'Izelvroioù',
 			'NO' => 'Norvegia',
 			'NP' => 'Nepal',
 			'NR' => 'Nauru',
 			'NU' => 'Niue',
 			'NZ' => 'Zeland-Nevez',
 			'OM' => 'Oman',
 			'PA' => 'Panamá',
 			'PE' => 'Perou',
 			'PF' => 'Polinezia Cʼhall',
 			'PG' => 'Papoua Ginea-Nevez',
 			'PH' => 'Filipinez',
 			'PK' => 'Pakistan',
 			'PL' => 'Polonia',
 			'PM' => 'Sant-Pêr-ha-Mikelon',
 			'PN' => 'Enez Pitcairn',
 			'PR' => 'Puerto Rico',
 			'PS' => 'Tiriadoù Palestina',
 			'PS@alt=short' => 'Palestina',
 			'PT' => 'Portugal',
 			'PW' => 'Palau',
 			'PY' => 'Paraguay',
 			'QA' => 'Qatar',
 			'QO' => 'Oseania diabell',
 			'RE' => 'Ar Reünion',
 			'RO' => 'Roumania',
 			'RS' => 'Serbia',
 			'RU' => 'Rusia',
 			'RW' => 'Rwanda',
 			'SA' => 'Arabia Saoudat',
 			'SB' => 'Inizi Salomon',
 			'SC' => 'Sechelez',
 			'SD' => 'Soudan',
 			'SE' => 'Sveden',
 			'SG' => 'Singapour',
 			'SH' => 'Saint-Helena',
 			'SI' => 'Slovenia',
 			'SJ' => 'Svalbard',
 			'SK' => 'Slovakia',
 			'SL' => 'Sierra Leone',
 			'SM' => 'San Marino',
 			'SN' => 'Senegal',
 			'SO' => 'Somalia',
 			'SR' => 'Surinam',
 			'SS' => 'Susoudan',
 			'ST' => 'São Tomé ha Príncipe',
 			'SV' => 'Salvador',
 			'SX' => 'Sint Maarten',
 			'SY' => 'Siria',
 			'SZ' => 'Swaziland',
 			'TA' => 'Tristan da Cunha',
 			'TC' => 'Inizi Turks ha Caicos',
 			'TD' => 'Tchad',
 			'TF' => 'Douaroù aostral Frañs',
 			'TG' => 'Togo',
 			'TH' => 'Thailand',
 			'TJ' => 'Tadjikistan',
 			'TK' => 'Tokelau',
 			'TL' => 'Timor-Leste',
 			'TL@alt=variant' => 'Timor ar Reter',
 			'TM' => 'Turkmenistan',
 			'TN' => 'Tunizia',
 			'TO' => 'Tonga',
 			'TR' => 'Turkia',
 			'TT' => 'Trinidad ha Tobago',
 			'TV' => 'Tuvalu',
 			'TW' => 'Taiwan',
 			'TZ' => 'Tanzania',
 			'UA' => 'Ukraina',
 			'UG' => 'Ouganda',
 			'UM' => 'Inizi diabell ar Stadoù-Unanet',
 			'US' => 'Stadoù-Unanet',
 			'US@alt=short' => 'SU',
 			'UY' => 'Uruguay',
 			'UZ' => 'Ouzbekistan',
 			'VA' => 'Vatikan',
 			'VC' => 'Sant Visant hag ar Grenadinez',
 			'VE' => 'Venezuela',
 			'VG' => 'Inizi Gwercʼh Breizh-Veur',
 			'VI' => 'Inizi Gwercʼh ar Stadoù-Unanet',
 			'VN' => 'Viêt Nam',
 			'VU' => 'Vanuatu',
 			'WF' => 'Wallis ha Futuna',
 			'WS' => 'Samoa',
 			'XK' => 'Kosovo',
 			'YE' => 'Yemen',
 			'YT' => 'Mayotte',
 			'ZA' => 'Suafrika',
 			'ZM' => 'Zambia',
 			'ZW' => 'Zimbabwe',
 			'ZZ' => 'Rannved dianav',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'reizhskrivadur alamanek hengounel',
 			'1994' => 'reizhskrivadur resianek skoueriekaet',
 			'1996' => 'reizhskrivadur alamanek 1996',
 			'1606NICT' => 'krenncʼhalleg',
 			'1694ACAD' => 'galleg rakvodern',
 			'1959ACAD' => 'belaruseg akademek',
 			'ALALC97' => 'romanekadur ALA-LC 1997',
 			'ALUKU' => 'rannyezh aloukou',
 			'AREVELA' => 'armenianeg ar Reter',
 			'AREVMDA' => 'armenianeg ar Cʼhornôg',
 			'BAKU1926' => 'lizherenneg latin turkek unvan',
 			'BAUDDHA' => 'sanskriteg hiron boudaat',
 			'BISCAYAN' => 'rannyezh euskarek Bizkaia',
 			'BISKE' => 'rannyezh San Giorgio/Bila',
 			'BOHORIC' => 'lizherenneg Bohorič',
 			'BOONT' => 'boontling',
 			'DAJNKO' => 'lizherenneg Dajnko',
 			'EMODENG' => 'saozneg rakvodern',
 			'FONIPA' => 'lizherenneg fonetek etrebroadel',
 			'FONUPA' => 'lizherenneg fonetek ouralek',
 			'FONXSAMP' => 'treuzskrivadur X-SAMPA',
 			'HEPBURN' => 'romanekadur Hepburn',
 			'HOGNORSK' => 'uhelnorvegeg',
 			'ITIHASA' => 'sanskriteg itihâsa',
 			'JAUER' => 'rannyezh romañchek Jauer',
 			'JYUTPING' => 'romanekadur kantonek Jyutping',
 			'KKCOR' => 'kerneveureg kumun',
 			'KOCIEWIE' => 'Kociewie',
 			'KSCOR' => 'kerneveureg standart',
 			'LAUKIKA' => 'sanskriteg klasel',
 			'LIPAW' => 'rannyezh resianek Lipovaz',
 			'LUNA1918' => 'reizhskrivadur rusianek goude 1917',
 			'METELKO' => 'lizherenneg Metelko',
 			'MONOTON' => 'gresianeg untonel',
 			'NDYUKA' => 'rannyezh Ndyuka',
 			'NEDIS' => 'rannyezh Natisone',
 			'NJIVA' => 'rannyezh Gniva/Njiva',
 			'NULIK' => 'volapük modern',
 			'OSOJS' => 'rannyezh Oseacco/Osojane',
 			'PAMAKA' => 'rannyezh Pamaka',
 			'PETR1708' => 'reizhskrivadur rusianek 1708 Pêr I',
 			'PINYIN' => 'romanekadur pinyin',
 			'POLYTON' => 'gresianeg liestonel',
 			'POSIX' => 'POSIX',
 			'PUTER' => 'rannyezh romañchek Puter',
 			'REVISED' => 'reizhskrivadur reizhet',
 			'RIGIK' => 'volapük klasel',
 			'ROZAJ' => 'resianeg',
 			'RUMGR' => 'romañcheg Grischun',
 			'SAAHO' => 'saho',
 			'SCOTLAND' => 'saozneg standart skos',
 			'SCOUSE' => 'scouse',
 			'SOLBA' => 'rannyezh Stolvizza/Solbica',
 			'SURMIRAN' => 'rannyezh romañchek surmiran',
 			'SURSILV' => 'rannyezh romañchek sursilvan',
 			'SUTSILV' => 'rannyezh romañchek sutsilvan',
 			'TARASK' => 'belaruseg Taraskievica',
 			'UCCOR' => 'kerneveureg unvan',
 			'UCRCOR' => 'kerneveureg unvan reizhet',
 			'ULSTER' => 'rannyezh skotek Ulad',
 			'UNIFON' => 'lizherenneg fonetek Unifon',
 			'VAIDIKA' => 'sanskriteg vedek',
 			'VALENCIA' => 'valensianeg',
 			'VALLADER' => 'rannyezh romañchek Vallader',
 			'WADEGILE' => 'romanekadur Wade-Giles',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'deiziadur',
 			'collation' => 'doare rummañ',
 			'currency' => 'moneiz',
 			'hc' => 'kelcʼhiad eurioù',
 			'ms' => 'reizhiad vuzuliañ',
 			'numbers' => 'niveroù',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{deiziadur boudaat},
 				'chinese' => q{deiziadur sinaat},
 				'coptic' => q{deiziadur kopt},
 				'dangi' => q{deiziadur dangi},
 				'ethiopic' => q{deiziadur etiopiat},
 				'ethiopic-amete-alem' => q{deiziadur etiopiat Amete Alem},
 				'gregorian' => q{deiziadur gregorian},
 				'hebrew' => q{deiziadur hebraek},
 				'indian' => q{deiziadur indian},
 				'islamic' => q{deiziadur islamek},
 				'islamic-civil' => q{deiziadur islamek keodedel},
 				'islamic-rgsa' => q{deiziadur islamek (Arabia Saoudat)},
 				'islamic-tbla' => q{deiziadur islamek steredoniel},
 				'islamic-umalqura' => q{deiziadur islamek (Umm al-Qura)},
 				'iso8601' => q{deiziadur ISO-8601},
 				'japanese' => q{deiziadur japanat},
 				'persian' => q{deiziadur persek},
 				'roc' => q{deiziadur Republik Sina},
 			},
 			'collation' => {
 				'big5han' => q{urzh rummañ sinaek hengounel - Big5},
 				'dictionary' => q{urzh rummañ ar geriadur},
 				'ducet' => q{urzh rummañ Unicode dre ziouer},
 				'eor' => q{reolennoù urzhiañ europat},
 				'gb2312han' => q{urzh rummañ sinaek eeunaet - GB2312},
 				'phonebook' => q{urzh rummañ al levr-pellgomz},
 				'pinyin' => q{urzh rummañ pinyin},
 				'reformed' => q{urzh rummañ adreizhet},
 				'search' => q{enklask hollek},
 				'standard' => q{urzh rummañ standart},
 				'stroke' => q{urzh rummañ an tresoù},
 				'traditional' => q{urzh rummañ hengounel},
 				'unihan' => q{urzh rummañ UniHan},
 				'zhuyin' => q{urzh rummañ Zhuyin},
 			},
 			'hc' => {
 				'h11' => q{reizhiad 12 eurvezh (0–11)},
 				'h12' => q{reizhiad 12 eurvezh (1–12)},
 				'h23' => q{reizhiad 24 eurvezh (0–23)},
 				'h24' => q{reizhiad 24 eurvezh (1–24)},
 			},
 			'ms' => {
 				'metric' => q{reizhiad vetrek},
 				'uksystem' => q{reizhiad vuzuliañ RU},
 				'ussystem' => q{reizhiad vuzuliañ SU},
 			},
 			'numbers' => {
 				'arab' => q{sifroù arabek indian},
 				'arabext' => q{sifroù arabek indian astennet},
 				'armn' => q{niveroù armenianek},
 				'armnlow' => q{niveroù armenianek bihan},
 				'bali' => q{sifroù balinek},
 				'beng' => q{sifroù bengali},
 				'brah' => q{sifroù brahmi},
 				'cakm' => q{sifroù chakma},
 				'cham' => q{sifroù cham},
 				'deva' => q{sifroù devanagari},
 				'ethi' => q{niveroù etiopiat},
 				'fullwide' => q{sifroù led plaen},
 				'geor' => q{niveroù jorjianek},
 				'grek' => q{niveroù gresianek},
 				'greklow' => q{niveroù gresianek bihan},
 				'gujr' => q{sifroù gujarati},
 				'guru' => q{sifroù gurmukhi},
 				'hanidec' => q{niveroù sinaek dekvedennek},
 				'hans' => q{niveroù sinaek eeunaet},
 				'hansfin' => q{niveroù sinaek eeunaet an arcʼhant},
 				'hant' => q{niveroù sinaek hengounel},
 				'hantfin' => q{niveroù sinaek hengounel an arcʼhant},
 				'hebr' => q{niveroù hebraek},
 				'java' => q{sifroù javanek},
 				'jpan' => q{niveroù japanek},
 				'jpanfin' => q{niveroù japanek an arcʼhant},
 				'kali' => q{sifroù Kayah Li},
 				'khmr' => q{sifroù khmer},
 				'knda' => q{sifroù kanarek},
 				'lana' => q{sifroù Tai Tham Hora},
 				'lanatham' => q{sifroù Tai Tham Tham},
 				'laoo' => q{sifroù laosek},
 				'latn' => q{sifroù arabek ar Cʼhornôg},
 				'lepc' => q{sifroù lepcha},
 				'limb' => q{sifroù limbu},
 				'mlym' => q{sifroù malayalam},
 				'mong' => q{sifroù mongolek},
 				'mtei' => q{sifroù meitei mayek},
 				'mymr' => q{sifroù myanmar},
 				'mymrshan' => q{sifroù shan Myanmar},
 				'nkoo' => q{sifroù nʼko},
 				'olck' => q{sifroù ol chiki},
 				'orya' => q{sifroù oriya},
 				'osma' => q{sifroù osmanya},
 				'roman' => q{niveroù roman},
 				'romanlow' => q{niveroù roman bihan},
 				'sora' => q{sifroù Sora Sompeng},
 				'sund' => q{sifroù sundanek},
 				'takr' => q{sifroù takri},
 				'taml' => q{niveroù tamilek hengounel},
 				'tamldec' => q{sifroù tamilek},
 				'telu' => q{sifroù telougou},
 				'thai' => q{sifroù thai},
 				'tibt' => q{sifroù tibetan},
 				'vaii' => q{sifroù vai},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{metrek},
 			'UK' => q{RU},
 			'US' => q{SU},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'region' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[á à ă â å ä ã ā æ c ç é è ĕ ë ē í ì ĭ î ï ī ó ò ŏ ô ö ø ō œ q ú ŭ û ü ū ÿ])},
			index => ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],
			main => qr{(?^u:[a b {ch} {cʼh} d e ê f g h i j k l m n ñ o p r s t u ù v w x y z])},
		};
	},
EOT
: sub {
		return { index => ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'few' => q({0} akr),
						'many' => q({0} a akroù),
						'name' => q(akroù),
						'one' => q({0} akr),
						'other' => q({0} akr),
						'two' => q({0} akr),
					},
					'ampere' => {
						'few' => q({0} amper),
						'many' => q({0} a amperoù),
						'name' => q(amperoù),
						'one' => q({0} amper),
						'other' => q({0} amper),
						'two' => q({0} amper),
					},
					'astronomical-unit' => {
						'few' => q({0} unanenn steredoniel),
						'many' => q({0} a unanennoù steredoniel),
						'name' => q(unanennoù steredoniel),
						'one' => q({0} unanenn steredoniel),
						'other' => q({0} unanenn steredoniel),
						'two' => q({0} unanenn steredoniel),
					},
					'bit' => {
						'few' => q({0} bit),
						'many' => q({0} a vitoù),
						'name' => q(bitoù),
						'one' => q({0} bit),
						'other' => q({0} bit),
						'two' => q({0} vit),
					},
					'bushel' => {
						'few' => q({0} foezellad),
						'many' => q({0} a boezelladoù),
						'name' => q(poezelladoù),
						'one' => q({0} poezellad),
						'other' => q({0} poezellad),
						'two' => q({0} boezellad),
					},
					'byte' => {
						'few' => q({0} okted),
						'many' => q({0} a oktedoù),
						'name' => q(oktedoù),
						'one' => q({0} okted),
						'other' => q({0} okted),
						'two' => q({0} okted),
					},
					'calorie' => {
						'few' => q({0} c'halorienn),
						'many' => q({0} a galoriennoù),
						'name' => q(kaloriennoù),
						'one' => q({0} galorienn),
						'other' => q({0} kalorienn),
						'two' => q({0} galorienn),
					},
					'carat' => {
						'few' => q({0} c'harat),
						'many' => q({0} a garatoù),
						'name' => q(karatoù),
						'one' => q({0} c'harat),
						'other' => q({0} karat),
						'two' => q({0} garat),
					},
					'celsius' => {
						'few' => q({0} derez Celsius),
						'many' => q({0} a zerezioù Celsius),
						'name' => q(derezioù Celsius),
						'one' => q({0} derez Celsius),
						'other' => q({0} derez Celsius),
						'two' => q({0} zerez Celsius),
					},
					'centiliter' => {
						'few' => q({0} c'hentilitr),
						'many' => q({0} a gentilitroù),
						'name' => q(kentilitroù),
						'one' => q({0} c'hentilitr),
						'other' => q({0} kentilitr),
						'two' => q({0} gentilitr),
					},
					'centimeter' => {
						'few' => q({0} c'hentimetr),
						'many' => q({0} a gentimetroù),
						'name' => q(kentimetroù),
						'one' => q({0} c'hentimetr),
						'other' => q({0} kentimetr),
						'per' => q({0} dre gentimetr),
						'two' => q({0} gentimetr),
					},
					'century' => {
						'few' => q({0} c'hantved),
						'many' => q({0} a gantvedoù),
						'name' => q(kantvedoù),
						'one' => q({0} c'hantved),
						'other' => q({0} kantved),
						'two' => q({0} gantved),
					},
					'coordinate' => {
						'east' => q({0} Reter),
						'north' => q({0} Norzh),
						'south' => q({0} Su),
						'west' => q({0} Kornôg),
					},
					'cubic-centimeter' => {
						'few' => q({0} c'hentimetr diñs),
						'many' => q({0} a gentimetroù diñs),
						'name' => q(kentimetroù diñs),
						'one' => q({0} c'hentimetr diñs),
						'other' => q({0} kentimetr diñs),
						'per' => q({0} dre gentimetr diñs),
						'two' => q({0} gentimetr diñs),
					},
					'cubic-foot' => {
						'few' => q({0} zroatad diñs),
						'many' => q({0} a droatadoù diñs),
						'name' => q(troatadoù diñs),
						'one' => q({0} troatad diñs),
						'other' => q({0} troatad diñs),
						'two' => q({0} droatad diñs),
					},
					'cubic-inch' => {
						'few' => q({0} meutad diñs),
						'many' => q({0} a veutadoù diñs),
						'name' => q(meutadoù diñs),
						'one' => q({0} meutad diñs),
						'other' => q({0} meutad diñs),
						'two' => q({0} veutad diñs),
					},
					'cubic-kilometer' => {
						'few' => q({0} c'hilometr diñs),
						'many' => q({0} a gilometroù diñs),
						'name' => q(kilometroù diñs),
						'one' => q({0} c'hilometr diñs),
						'other' => q({0} kilometr diñs),
						'two' => q({0} gilometr diñs),
					},
					'cubic-meter' => {
						'few' => q({0} metr diñs),
						'many' => q({0} a vetroù diñs),
						'name' => q(metroù diñs),
						'one' => q({0} metr diñs),
						'other' => q({0} metr diñs),
						'per' => q({0} dre vetr diñs),
						'two' => q({0} vetr diñs),
					},
					'cubic-mile' => {
						'few' => q({0} miltir diñs),
						'many' => q({0} a viltirioù diñs),
						'name' => q(miltirioù diñs),
						'one' => q({0} miltir diñs),
						'other' => q({0} miltir diñs),
						'two' => q({0} viltir diñs),
					},
					'day' => {
						'few' => q({0} deiz),
						'many' => q({0} a zeizioù),
						'name' => q(deizioù),
						'one' => q({0} deiz),
						'other' => q({0} deiz),
						'per' => q({0} dre zeiz),
						'two' => q({0} zeiz),
					},
					'deciliter' => {
						'few' => q({0} dekilitr),
						'many' => q({0} a zekilitroù),
						'name' => q(dekilitroù),
						'one' => q({0} dekilitr),
						'other' => q({0} dekilitr),
						'two' => q({0} zekilitr),
					},
					'decimeter' => {
						'few' => q({0} dekimetr),
						'many' => q({0} a zekimetroù),
						'name' => q(dekimetroù),
						'one' => q({0} dekimetr),
						'other' => q({0} dekimetr),
						'two' => q({0} zekimetr),
					},
					'degree' => {
						'few' => q({0} derez),
						'many' => q({0} a zerezioù),
						'name' => q(derezioù),
						'one' => q({0} derez),
						'other' => q({0} derez),
						'two' => q({0} zerez),
					},
					'fahrenheit' => {
						'few' => q({0} derez Fahrenheit),
						'many' => q({0} a zerezioù Fahrenheit),
						'name' => q(derezioù Fahrenheit),
						'one' => q({0} derez Fahrenheit),
						'other' => q({0} derez Fahrenheit),
						'two' => q({0} zerez Fahrenheit),
					},
					'fathom' => {
						'few' => q({0} gourhedad),
						'many' => q({0} a c'hourhedadoù),
						'name' => q(gourhedadoù),
						'one' => q({0} gourhedad),
						'other' => q({0} gourhedad),
						'two' => q({0} c'hourhedad),
					},
					'foot' => {
						'few' => q({0} zroatad),
						'many' => q({0} a droatadoù),
						'name' => q(troatadoù),
						'one' => q({0} troatad),
						'other' => q({0} troatad),
						'per' => q({0} dre droatad),
						'two' => q({0} droatad),
					},
					'gallon' => {
						'few' => q({0} gallon),
						'many' => q({0} a c'hallonoù),
						'name' => q(gallonoù),
						'one' => q({0} gallon),
						'other' => q({0} gallon),
						'per' => q({0} dre cʼhallon),
						'two' => q({0} c'hallon),
					},
					'generic' => {
						'few' => q({0} derez),
						'many' => q({0} a zerezioù),
						'name' => q(derezioù),
						'one' => q({0} derez),
						'other' => q({0} derez),
						'two' => q({0} zerez),
					},
					'gigabit' => {
						'few' => q({0} gigabit),
						'many' => q({0} a c'higabitoù),
						'name' => q(gigabitoù),
						'one' => q({0} gigabit),
						'other' => q({0} gigabit),
						'two' => q({0} c'higabit),
					},
					'gigabyte' => {
						'few' => q({0} gigaokted),
						'many' => q({0} a c'higaoktedoù),
						'name' => q(gigaoktedoù),
						'one' => q({0} gigaokted),
						'other' => q({0} gigaokted),
						'two' => q({0} c'higaokted),
					},
					'gigahertz' => {
						'few' => q({0} gigahertz),
						'many' => q({0} a c'higahertzoù),
						'name' => q(gigahertzoù),
						'one' => q({0} gigahertz),
						'other' => q({0} gigahertz),
						'two' => q({0} c'higahertz),
					},
					'gigawatt' => {
						'few' => q({0} gigawatt),
						'many' => q({0} a c'higawattoù),
						'name' => q(gigawattoù),
						'one' => q({0} gigawatt),
						'other' => q({0} gigawatt),
						'two' => q({0} c'higawatt),
					},
					'gram' => {
						'few' => q({0} gramm),
						'many' => q({0} a c'hrammoù),
						'name' => q(grammoù),
						'one' => q({0} gramm),
						'other' => q({0} gramm),
						'per' => q({0} dre cʼhramm),
						'two' => q({0} c'hramm),
					},
					'hectare' => {
						'few' => q({0} hektar),
						'many' => q({0} a hektaroù),
						'name' => q(hektaroù),
						'one' => q({0} hektar),
						'other' => q({0} hektar),
						'two' => q({0} hektar),
					},
					'hectoliter' => {
						'few' => q({0} hektolitr),
						'many' => q({0} a hektolitroù),
						'name' => q(hektolitroù),
						'one' => q({0} hektolitr),
						'other' => q({0} hektolitr),
						'two' => q({0} hektolitr),
					},
					'hectopascal' => {
						'few' => q({0} hektopaskal),
						'many' => q({0} a hektopaskaloù),
						'name' => q(hektopaskaloù),
						'one' => q({0} hektopaskal),
						'other' => q({0} hektopaskal),
						'two' => q({0} hektopaskal),
					},
					'hertz' => {
						'few' => q({0} hertz),
						'many' => q({0} a hertzoù),
						'name' => q(hertzoù),
						'one' => q({0} hertz),
						'other' => q({0} hertz),
						'two' => q({0} hertz),
					},
					'horsepower' => {
						'few' => q({0} marc'had nerzh),
						'many' => q({0} a varc'hadoù nerzh),
						'name' => q(marcʼhadoù nerzh),
						'one' => q({0} marc'had nerzh),
						'other' => q({0} marc'had nerzh),
						'two' => q({0} varc'had nerzh),
					},
					'hour' => {
						'few' => q({0} eur),
						'many' => q({0} a eurioù),
						'name' => q(eurioù),
						'one' => q({0} eur),
						'other' => q({0} eur),
						'per' => q({0} dre eur),
						'two' => q({0} eur),
					},
					'inch' => {
						'few' => q({0} meutad),
						'many' => q({0} a veutadoù),
						'name' => q(meutadoù),
						'one' => q({0} meutad),
						'other' => q({0} meutad),
						'per' => q({0} dre veutad),
						'two' => q({0} veutad),
					},
					'joule' => {
						'few' => q({0} joul),
						'many' => q({0} a jouloù),
						'name' => q(jouloù),
						'one' => q({0} joul),
						'other' => q({0} joul),
						'two' => q({0} joul),
					},
					'karat' => {
						'few' => q({0} c'harat),
						'many' => q({0} a garatoù),
						'name' => q(karatoù),
						'one' => q({0} c'harat),
						'other' => q({0} karat),
						'two' => q({0} garat),
					},
					'kelvin' => {
						'few' => q({0} c'helvin),
						'many' => q({0} a gelvinoù),
						'name' => q(kelvinoù),
						'one' => q({0} c'helvin),
						'other' => q({0} kelvin),
						'two' => q({0} gelvin),
					},
					'kilobit' => {
						'few' => q({0} c'hilobit),
						'many' => q({0} a gilobitoù),
						'name' => q(kilobitoù),
						'one' => q({0} c'hilobit),
						'other' => q({0} kilobit),
						'two' => q({0} gilobit),
					},
					'kilobyte' => {
						'few' => q({0} c'hilookted),
						'many' => q({0} a gilooktedoù),
						'name' => q(kilooktedoù),
						'one' => q({0} c'hilookted),
						'other' => q({0} kilookted),
						'two' => q({0} gilookted),
					},
					'kilocalorie' => {
						'few' => q({0} c'hilokalorienn),
						'many' => q({0} a gilokaloriennoù),
						'name' => q(kilokaloriennoù),
						'one' => q({0} gilokalorienn),
						'other' => q({0} kilokalorienn),
						'two' => q({0} gilokalorienn),
					},
					'kilogram' => {
						'few' => q({0} c'hilogramm),
						'many' => q({0} a gilogrammoù),
						'name' => q(kilogrammoù),
						'one' => q({0} c'hilogramm),
						'other' => q({0} kilogramm),
						'per' => q({0} dre gilogramm),
						'two' => q({0} gilogramm),
					},
					'kilohertz' => {
						'few' => q({0} c'hilohertz),
						'many' => q({0} a gilohertzoù),
						'name' => q(kilohertzoù),
						'one' => q({0} c'hilohertz),
						'other' => q({0} kilohertz),
						'two' => q({0} gilohertz),
					},
					'kilojoule' => {
						'few' => q({0} c'hilojoul),
						'many' => q({0} a gilojouloù),
						'name' => q(kilojouloù),
						'one' => q({0} c'hilojoul),
						'other' => q({0} kilojoul),
						'two' => q({0} gilojoul),
					},
					'kilometer' => {
						'few' => q({0} c'hilometr),
						'many' => q({0} a gilometroù),
						'name' => q(kilometroù),
						'one' => q({0} c'hilometr),
						'other' => q({0} kilometr),
						'per' => q({0} dre gilometr),
						'two' => q({0} gilometr),
					},
					'kilometer-per-hour' => {
						'few' => q({0} c'hilometr dre eur),
						'many' => q({0} a gilometroù dre eur),
						'name' => q(kilometroù dre eur),
						'one' => q({0} c'hilometr dre eur),
						'other' => q({0} kilometr dre eur),
						'two' => q({0} gilometr dre eur),
					},
					'kilowatt' => {
						'few' => q({0} c'hilowatt),
						'many' => q({0} a gilowattoù),
						'name' => q(kilowattoù),
						'one' => q({0} c'hilowatt),
						'other' => q({0} kilowatt),
						'two' => q({0} gilowatt),
					},
					'kilowatt-hour' => {
						'few' => q({0} c'hilowatt-eur),
						'many' => q({0} a gilowattoù-eurioù),
						'name' => q(kilowattoù-eurioù),
						'one' => q({0} c'hilowatt-eur),
						'other' => q({0} kilowatt-eur),
						'two' => q({0} gilowatt-eur),
					},
					'knot' => {
						'few' => q({0} skoulm),
						'many' => q({0} a skoulmoù),
						'name' => q(skoulmoù),
						'one' => q({0} skoulm),
						'other' => q({0} skoulm),
						'two' => q({0} skoulm),
					},
					'liter' => {
						'few' => q({0} litr),
						'many' => q({0} a litroù),
						'name' => q(litroù),
						'one' => q({0} litr),
						'other' => q({0} litr),
						'per' => q({0} dre litr),
						'two' => q({0} litr),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} litr dre 100 kilometr),
						'many' => q({0} a litroù dre 100 kilometr),
						'name' => q(litroù dre 100 kilometr),
						'one' => q({0} litr dre 100 kilometr),
						'other' => q({0} litr dre 100 kilometr),
						'two' => q({0} litr dre 100 kilometr),
					},
					'liter-per-kilometer' => {
						'few' => q({0} litr dre gilometr),
						'many' => q({0} a litroù dre gilometr),
						'name' => q(litroù dre gilometr),
						'one' => q({0} litr dre gilometr),
						'other' => q({0} litr dre gilometr),
						'two' => q({0} litr dre gilometr),
					},
					'lux' => {
						'few' => q({0} lx),
						'many' => q({0} a luksoù),
						'name' => q(luksoù),
						'one' => q({0} luks),
						'other' => q({0} lx),
						'two' => q({0} lx),
					},
					'megabit' => {
						'few' => q({0} megabit),
						'many' => q({0} a vegabitoù),
						'name' => q(megabitoù),
						'one' => q({0} megabit),
						'other' => q({0} megabit),
						'two' => q({0} vegabit),
					},
					'megabyte' => {
						'few' => q({0} megaokted),
						'many' => q({0} a vegaoktedoù),
						'name' => q(megaoktedoù),
						'one' => q({0} megaokted),
						'other' => q({0} megaokted),
						'two' => q({0} vegaokted),
					},
					'megahertz' => {
						'few' => q({0} megahertz),
						'many' => q({0} a vegahertzoù),
						'name' => q(megahertzoù),
						'one' => q({0} megahertz),
						'other' => q({0} megahertz),
						'two' => q({0} vegahertz),
					},
					'megaliter' => {
						'few' => q({0} megalitr),
						'many' => q({0} a vegalitroù),
						'name' => q(megalitroù),
						'one' => q({0} megalitr),
						'other' => q({0} megalitr),
						'two' => q({0} vegalitr),
					},
					'megawatt' => {
						'few' => q({0} megawatt),
						'many' => q({0} a vegawattoù),
						'name' => q(megawattoù),
						'one' => q({0} megawatt),
						'other' => q({0} megawatt),
						'two' => q({0} vegawatt),
					},
					'meter' => {
						'few' => q({0} metr),
						'many' => q({0} a vetroù),
						'name' => q(metroù),
						'one' => q({0} metr),
						'other' => q({0} metr),
						'per' => q({0} dre vetr),
						'two' => q({0} vetr),
					},
					'meter-per-second' => {
						'few' => q({0} metr dre eilenn),
						'many' => q({0} a vetroù dre eilenn),
						'name' => q(metroù dre eilenn),
						'one' => q({0} metr dre eilenn),
						'other' => q({0} metr dre eilenn),
						'two' => q({0} vetr dre eilenn),
					},
					'meter-per-second-squared' => {
						'few' => q({0} metr dre eilenn garrez),
						'many' => q({0} a vetroù dre eilenn garrez),
						'name' => q(metroù dre eilenn garrez),
						'one' => q({0} metr dre eilenn garrez),
						'other' => q({0} metr dre eilenn garrez),
						'two' => q({0} vetr dre eilenn garrez),
					},
					'metric-ton' => {
						'few' => q({0} zonenn metrek),
						'many' => q({0} a donennoù metrek),
						'name' => q(tonennoù metrek),
						'one' => q({0} donenn vetrek),
						'other' => q({0} tonenn vetrek),
						'two' => q({0} donenn vetrek),
					},
					'microgram' => {
						'few' => q({0} mikrogramm),
						'many' => q({0} a vikrogrammoù),
						'name' => q(mikrogrammoù),
						'one' => q({0} mikrogramm),
						'other' => q({0} mikrogramm),
						'two' => q({0} vikrogramm),
					},
					'micrometer' => {
						'few' => q({0} mikrometr),
						'many' => q({0} a vikrometroù),
						'name' => q(mikrometroù),
						'one' => q({0} mikrometr),
						'other' => q({0} mikrometr),
						'two' => q({0} vikrometr),
					},
					'microsecond' => {
						'few' => q({0} mikroeilenn),
						'many' => q({0} a vikroeilennoù),
						'name' => q(mikroeilennoù),
						'one' => q({0} mikroeilenn),
						'other' => q({0} mikroeilenn),
						'two' => q({0} vikroeilenn),
					},
					'mile' => {
						'few' => q({0} miltir),
						'many' => q({0} a viltirioù),
						'name' => q(miltirioù),
						'one' => q({0} miltir),
						'other' => q({0} miltir),
						'two' => q({0} viltir),
					},
					'mile-per-gallon' => {
						'few' => q({0} miltir dre c'hallon),
						'many' => q({0} a viltirioù dre c'hallon),
						'name' => q(miltirioù dre cʼhallon),
						'one' => q({0} miltir dre c'hallon),
						'other' => q({0} miltir dre c'hallon),
						'two' => q({0} viltir dre c'hallon),
					},
					'mile-per-hour' => {
						'few' => q({0} miltir dre eur),
						'many' => q({0} a viltirioù dre eur),
						'name' => q(miltirioù dre eur),
						'one' => q({0} miltir dre eur),
						'other' => q({0} miltir dre eur),
						'two' => q({0} viltir dre eur),
					},
					'milliampere' => {
						'few' => q({0} miliamper),
						'many' => q({0} a viliamperoù),
						'name' => q(miliamperoù),
						'one' => q({0} miliamper),
						'other' => q({0} miliamper),
						'two' => q({0} viliamper),
					},
					'millibar' => {
						'few' => q({0} milibar),
						'many' => q({0} a vilibaroù),
						'name' => q(milibaroù),
						'one' => q({0} milibar),
						'other' => q({0} milibar),
						'two' => q({0} vilibar),
					},
					'milligram' => {
						'few' => q({0} miligramm),
						'many' => q({0} a viligrammoù),
						'name' => q(miligrammoù),
						'one' => q({0} miligramm),
						'other' => q({0} miligramm),
						'two' => q({0} viligramm),
					},
					'milliliter' => {
						'few' => q({0} mililitr),
						'many' => q({0} a vililitroù),
						'name' => q(mililitroù),
						'one' => q({0} mililitr),
						'other' => q({0} mililitr),
						'two' => q({0} vililitr),
					},
					'millimeter' => {
						'few' => q({0} milimetr),
						'many' => q({0} a vilimetroù),
						'name' => q(milimetroù),
						'one' => q({0} milimetr),
						'other' => q({0} milimetr),
						'two' => q({0} vilimetr),
					},
					'millisecond' => {
						'few' => q({0} milieilenn),
						'many' => q({0} a vilieilennoù),
						'name' => q(milieilennoù),
						'one' => q({0} milieilenn),
						'other' => q({0} milieilenn),
						'two' => q({0} vilieilenn),
					},
					'milliwatt' => {
						'few' => q({0} miliwatt),
						'many' => q({0} a viliwattoù),
						'name' => q(miliwattoù),
						'one' => q({0} miliwatt),
						'other' => q({0} miliwatt),
						'two' => q({0} viliwatt),
					},
					'minute' => {
						'few' => q({0} munut),
						'many' => q({0} a vunutoù),
						'name' => q(munutoù),
						'one' => q({0} munut),
						'other' => q({0} munut),
						'per' => q({0} dre vunut),
						'two' => q({0} vunut),
					},
					'month' => {
						'few' => q({0} miz),
						'many' => q({0} a vizioù),
						'name' => q(mizioù),
						'one' => q({0} miz),
						'other' => q({0} miz),
						'per' => q({0} dre viz),
						'two' => q({0} viz),
					},
					'nanometer' => {
						'few' => q({0} nanometr),
						'many' => q({0} a nanometroù),
						'name' => q(nanometroù),
						'one' => q({0} nanometr),
						'other' => q({0} nanometr),
						'two' => q({0} nanometr),
					},
					'nanosecond' => {
						'few' => q({0} nanoeilenn),
						'many' => q({0} a nanoeilennoù),
						'name' => q(nanoeilennoù),
						'one' => q({0} nanoeilenn),
						'other' => q({0} nanoeilenn),
						'two' => q({0} nanoeilenn),
					},
					'nautical-mile' => {
						'few' => q({0} milmor),
						'many' => q({0} a vilmorioù),
						'name' => q(milmorioù),
						'one' => q({0} milmor),
						'other' => q({0} milmor),
						'two' => q({0} vilmor),
					},
					'ohm' => {
						'few' => q({0} ohm),
						'many' => q({0} a ohmoù),
						'name' => q(ohmoù),
						'one' => q({0} ohm),
						'other' => q({0} ohm),
						'two' => q({0} ohm),
					},
					'ounce' => {
						'few' => q({0} oñs),
						'many' => q({0} a oñsoù),
						'name' => q(oñsoù),
						'one' => q({0} oñs),
						'other' => q({0} oñs),
						'per' => q({0} dre oñs),
						'two' => q({0} oñs),
					},
					'parsec' => {
						'few' => q({0} farsek),
						'many' => q({0} a barsekoù),
						'name' => q(parsekoù),
						'one' => q({0} parsek),
						'other' => q({0} parsek),
						'two' => q({0} barsek),
					},
					'per' => {
						'1' => q({0} dre {1}),
					},
					'picometer' => {
						'few' => q({0} fikometr),
						'many' => q({0} a bikometroù),
						'name' => q(pikometroù),
						'one' => q({0} pikometr),
						'other' => q({0} pikometr),
						'two' => q({0} bikometr),
					},
					'pint' => {
						'few' => q({0} fint),
						'many' => q({0} a bintoù),
						'name' => q(pintoù),
						'one' => q({0} pint),
						'other' => q({0} pint),
						'two' => q({0} bint),
					},
					'pint-metric' => {
						'few' => q({0} fint metrek),
						'many' => q({0} a bintoù metrek),
						'name' => q(pintoù metrek),
						'one' => q({0} pint metrek),
						'other' => q({0} pint metrek),
						'two' => q({0} bint metrek),
					},
					'pound' => {
						'few' => q({0} lur),
						'many' => q({0} a lurioù),
						'name' => q(lurioù),
						'one' => q({0} lur),
						'other' => q({0} lur),
						'per' => q({0} dre lur),
						'two' => q({0} lur),
					},
					'pound-per-square-inch' => {
						'few' => q({0} lur dre veutad karrez),
						'many' => q({0} a lurioù dre veutad karrez),
						'name' => q(lurioù dre veutad karrez),
						'one' => q({0} lur dre veutad karrez),
						'other' => q({0} lur dre veutad karrez),
						'two' => q({0} lur dre veutad karrez),
					},
					'quart' => {
						'few' => q({0} c'hard),
						'many' => q({0} a gardoù),
						'name' => q(kardoù),
						'one' => q({0} c'hard),
						'other' => q({0} kard),
						'two' => q({0} gard),
					},
					'radian' => {
						'few' => q({0} radian),
						'many' => q({0} a radianoù),
						'name' => q(radianoù),
						'one' => q({0} radian),
						'other' => q({0} radian),
						'two' => q({0} radian),
					},
					'second' => {
						'few' => q({0} eilenn),
						'many' => q({0} a eilennoù),
						'name' => q(eilennoù),
						'one' => q({0} eilenn),
						'other' => q({0} eilenn),
						'per' => q({0} dre eilenn),
						'two' => q({0} eilenn),
					},
					'square-centimeter' => {
						'few' => q({0} c'hentimetr karrez),
						'many' => q({0} a gentimetroù karrez),
						'name' => q(kentimetroù karrez),
						'one' => q({0} c'hentimetr karrez),
						'other' => q({0} kentimetr karrez),
						'per' => q({0} dre gentimetr karrez),
						'two' => q({0} gentimetr karrez),
					},
					'square-foot' => {
						'few' => q({0} zroatad karrez),
						'many' => q({0} a droatadoù karrez),
						'name' => q(troatadoù karrez),
						'one' => q({0} troatad karrez),
						'other' => q({0} troatad karrez),
						'two' => q({0} droatad karrez),
					},
					'square-inch' => {
						'few' => q({0} meutad karrez),
						'many' => q({0} a veutadoù karrez),
						'name' => q(meutadoù karrez),
						'one' => q({0} meutad karrez),
						'other' => q({0} meutad karrez),
						'per' => q({0} dre veutad karrez),
						'two' => q({0} veutad karrez),
					},
					'square-kilometer' => {
						'few' => q({0} c'hilometr karrez),
						'many' => q({0} a gilometroù karrez),
						'name' => q(kilometroù karrez),
						'one' => q({0} c'hilometr karrez),
						'other' => q({0} kilometr karrez),
						'two' => q({0} gilometr karrez),
					},
					'square-meter' => {
						'few' => q({0} metr karrez),
						'many' => q({0} a vetroù garrez),
						'name' => q(metroù karrez),
						'one' => q({0} metr karrez),
						'other' => q({0} metr karrez),
						'per' => q({0} dre vetr karrez),
						'two' => q({0} vetr karrez),
					},
					'square-mile' => {
						'few' => q({0} miltir karrez),
						'many' => q({0} a viltirioù karrez),
						'name' => q(miltirioù karrez),
						'one' => q({0} miltir karrez),
						'other' => q({0} miltir karrez),
						'two' => q({0} viltir karrez),
					},
					'terabit' => {
						'few' => q({0} zerabit),
						'many' => q({0} a derabitoù),
						'name' => q(terabitoù),
						'one' => q({0} terabit),
						'other' => q({0} terabit),
						'two' => q({0} derabit),
					},
					'terabyte' => {
						'few' => q({0} zeraokted),
						'many' => q({0} a deraoktedoù),
						'name' => q(teraoktedoù),
						'one' => q({0} teraokted),
						'other' => q({0} teraokted),
						'two' => q({0} deraokted),
					},
					'ton' => {
						'few' => q({0} zonenn),
						'many' => q({0} a donennoù),
						'name' => q(tonennoù),
						'one' => q({0} donenn),
						'other' => q({0} tonenn),
						'two' => q({0} donenn),
					},
					'volt' => {
						'few' => q({0} volt),
						'many' => q({0} a voltoù),
						'name' => q(voltoù),
						'one' => q({0} volt),
						'other' => q({0} volt),
						'two' => q({0} volt),
					},
					'watt' => {
						'few' => q({0} watt),
						'many' => q({0} a wattoù),
						'name' => q(wattoù),
						'one' => q({0} watt),
						'other' => q({0} watt),
						'two' => q({0} watt),
					},
					'week' => {
						'few' => q({0} sizhun),
						'many' => q({0} a sizhunioù),
						'name' => q(sizhunioù),
						'one' => q({0} sizhun),
						'other' => q({0} sizhun),
						'per' => q({0} dre sizhun),
						'two' => q({0} sizhun),
					},
					'year' => {
						'few' => q({0} bloaz),
						'many' => q({0} a vloazioù),
						'name' => q(bloazioù),
						'one' => q({0} bloaz),
						'other' => q({0} vloaz),
						'per' => q({0} dre vloaz),
						'two' => q({0} vloaz),
					},
				},
				'narrow' => {
					'acre' => {
						'few' => q({0} ac),
						'many' => q({0} ac),
						'name' => q(ac),
						'one' => q({0} ac),
						'other' => q({0} ac),
						'two' => q({0} ac),
					},
					'astronomical-unit' => {
						'few' => q({0} au),
						'many' => q({0} au),
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
						'two' => q({0} au),
					},
					'bit' => {
						'few' => q({0} b),
						'many' => q({0} b),
						'name' => q(b),
						'one' => q({0} b),
						'other' => q({0} b),
						'two' => q({0} b),
					},
					'byte' => {
						'few' => q({0} o),
						'many' => q({0} o),
						'name' => q(o),
						'one' => q({0} o),
						'other' => q({0} o),
						'two' => q({0} o),
					},
					'carat' => {
						'few' => q({0} CD),
						'many' => q({0} CD),
						'name' => q(CD),
						'one' => q({0} CD),
						'other' => q({0} CD),
						'two' => q({0} CD),
					},
					'celsius' => {
						'few' => q({0}°C),
						'many' => q({0}°C),
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
						'two' => q({0}°C),
					},
					'centiliter' => {
						'few' => q({0} cl),
						'many' => q({0} cl),
						'name' => q(cl),
						'one' => q({0} cl),
						'other' => q({0} cl),
						'two' => q({0} cl),
					},
					'centimeter' => {
						'few' => q({0} cm),
						'many' => q({0} cm),
						'name' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
						'two' => q({0} cm),
					},
					'cubic-centimeter' => {
						'few' => q({0} cm³),
						'many' => q({0} cm³),
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
						'two' => q({0} cm³),
					},
					'cubic-foot' => {
						'few' => q({0} ft³),
						'many' => q({0} ft³),
						'name' => q(ft³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
						'two' => q({0} ft³),
					},
					'cubic-inch' => {
						'few' => q({0} in³),
						'many' => q({0} in³),
						'name' => q(in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
						'two' => q({0} in³),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'many' => q({0} km³),
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
						'two' => q({0} km³),
					},
					'cubic-meter' => {
						'few' => q({0} m³),
						'many' => q({0} m³),
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
						'two' => q({0} m³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'many' => q({0} mi³),
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
						'two' => q({0} mi³),
					},
					'day' => {
						'per' => q({0}/d),
					},
					'deciliter' => {
						'few' => q({0} dl),
						'many' => q({0} dl),
						'name' => q(dl),
						'one' => q({0} dl),
						'other' => q({0} dl),
						'two' => q({0} dl),
					},
					'decimeter' => {
						'few' => q({0} dm),
						'many' => q({0} dm),
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
						'two' => q({0} dm),
					},
					'degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
						'two' => q({0}°F),
					},
					'fathom' => {
						'few' => q({0} fm),
						'many' => q({0} fm),
						'name' => q(fm),
						'one' => q({0} fm),
						'other' => q({0} fm),
						'two' => q({0} fm),
					},
					'foot' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'name' => q(′),
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0}/′),
						'two' => q({0}′),
					},
					'gallon' => {
						'per' => q({0}/gal),
					},
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} Gb),
						'many' => q({0} Gb),
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
						'two' => q({0} Gb),
					},
					'gigabyte' => {
						'few' => q({0} Go),
						'many' => q({0} Go),
						'name' => q(Go),
						'one' => q({0} Go),
						'other' => q({0} Go),
						'two' => q({0} Go),
					},
					'gram' => {
						'few' => q({0} g),
						'many' => q({0} g),
						'name' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
						'two' => q({0} g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'many' => q({0} ha),
						'name' => q(ha),
						'one' => q({0} ha),
						'other' => q({0} ha),
						'two' => q({0} ha),
					},
					'hectoliter' => {
						'few' => q({0} hl),
						'many' => q({0} hl),
						'name' => q(hl),
						'one' => q({0} hl),
						'other' => q({0} hl),
						'two' => q({0} hl),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'many' => q({0} hPa),
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
						'two' => q({0} hPa),
					},
					'horsepower' => {
						'few' => q({0} hp),
						'many' => q({0} hp),
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
						'two' => q({0} hp),
					},
					'inch' => {
						'few' => q({0}″),
						'many' => q({0}″),
						'name' => q(″),
						'one' => q({0}″),
						'other' => q({0}″),
						'per' => q({0}/″),
						'two' => q({0}″),
					},
					'inch-hg' => {
						'few' => q({0}″Hg),
						'many' => q({0}″Hg),
						'name' => q(″Hg),
						'one' => q({0}″Hg),
						'other' => q({0}″Hg),
						'two' => q({0}″Hg),
					},
					'karat' => {
						'few' => q({0} kt),
						'many' => q({0} kt),
						'name' => q(kt),
						'one' => q({0} kt),
						'other' => q({0} kt),
						'two' => q({0} kt),
					},
					'kelvin' => {
						'few' => q({0} K),
						'many' => q({0} K),
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
						'two' => q({0} K),
					},
					'kilobit' => {
						'few' => q({0} kb),
						'many' => q({0} kb),
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
						'two' => q({0} kb),
					},
					'kilobyte' => {
						'few' => q({0} ko),
						'many' => q({0} ko),
						'name' => q(ko),
						'one' => q({0} ko),
						'other' => q({0} ko),
						'two' => q({0} ko),
					},
					'kilogram' => {
						'few' => q({0} kg),
						'many' => q({0} kg),
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
						'two' => q({0} kg),
					},
					'kilometer' => {
						'few' => q({0} km),
						'many' => q({0} km),
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
						'per' => q({0}/km),
						'two' => q({0} km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} km/h),
						'many' => q({0} km/h),
						'name' => q(km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
						'two' => q({0} km/h),
					},
					'knot' => {
						'few' => q({0} n),
						'many' => q({0} n),
						'name' => q(n),
						'one' => q({0} n),
						'other' => q({0} n),
						'two' => q({0} n),
					},
					'liter' => {
						'few' => q({0} l),
						'many' => q({0} l),
						'name' => q(l),
						'one' => q({0} l),
						'other' => q({0} l),
						'per' => q({0}/l),
						'two' => q({0} l),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} l/100km),
						'many' => q({0} l/100km),
						'name' => q(l/100km),
						'one' => q({0} l/100km),
						'other' => q({0} l/100km),
						'two' => q({0} l/100km),
					},
					'liter-per-kilometer' => {
						'few' => q({0} l/km),
						'many' => q({0} l/km),
						'name' => q(l/km),
						'one' => q({0} l/km),
						'other' => q({0} l/km),
						'two' => q({0} l/km),
					},
					'lux' => {
						'few' => q({0} lx),
						'many' => q({0} lx),
						'name' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
						'two' => q({0} lx),
					},
					'megabit' => {
						'few' => q({0} Mb),
						'many' => q({0} Mb),
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
						'two' => q({0} Mb),
					},
					'megabyte' => {
						'few' => q({0} Mo),
						'many' => q({0} Mo),
						'name' => q(Mo),
						'one' => q({0} Mo),
						'other' => q({0} Mo),
						'two' => q({0} Mo),
					},
					'megaliter' => {
						'few' => q({0} Ml),
						'many' => q({0} Ml),
						'name' => q(Ml),
						'one' => q({0} Ml),
						'other' => q({0} Ml),
						'two' => q({0} Ml),
					},
					'meter' => {
						'few' => q({0} m),
						'many' => q({0} m),
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
						'per' => q({0}/m),
						'two' => q({0} m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'many' => q({0} m/s),
						'name' => q(m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
						'two' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'few' => q({0} m/s²),
						'many' => q({0} m/s²),
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
						'two' => q({0} m/s²),
					},
					'metric-ton' => {
						'few' => q({0} t),
						'many' => q({0} t),
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
						'two' => q({0} t),
					},
					'microgram' => {
						'few' => q({0} µg),
						'many' => q({0} µg),
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
						'two' => q({0} µg),
					},
					'micrometer' => {
						'few' => q({0} µm),
						'many' => q({0} µm),
						'name' => q(µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
						'two' => q({0} µm),
					},
					'mile' => {
						'few' => q({0} mi),
						'many' => q({0} mi),
						'name' => q(mi),
						'one' => q({0} mi),
						'other' => q({0} mi),
						'two' => q({0} mi),
					},
					'mile-per-gallon' => {
						'few' => q({0} mi/gal),
						'many' => q({0} mi/gal),
						'name' => q(mi/gal),
						'one' => q({0} mi/gal),
						'other' => q({0} mi/gal),
						'two' => q({0} mi/gal),
					},
					'mile-per-hour' => {
						'few' => q({0} mi/h),
						'many' => q({0} mi/h),
						'name' => q(mi/h),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
						'two' => q({0} mi/h),
					},
					'mile-scandinavian' => {
						'few' => q({0} smi),
						'many' => q({0} smi),
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
						'two' => q({0} smi),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'many' => q({0} mbar),
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
						'two' => q({0} mbar),
					},
					'milligram' => {
						'few' => q({0} mg),
						'many' => q({0} mg),
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
						'two' => q({0} mg),
					},
					'milliliter' => {
						'few' => q({0} ml),
						'many' => q({0} ml),
						'name' => q(ml),
						'one' => q({0} ml),
						'other' => q({0} ml),
						'two' => q({0} ml),
					},
					'millimeter' => {
						'few' => q({0} mm),
						'many' => q({0} mm),
						'name' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
						'two' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} mmHg),
						'many' => q({0} mmHg),
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
						'two' => q({0} mmHg),
					},
					'minute' => {
						'per' => q({0}/min),
					},
					'nanometer' => {
						'few' => q({0} nm),
						'many' => q({0} nm),
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
						'two' => q({0} nm),
					},
					'nautical-mile' => {
						'few' => q({0} nmi),
						'many' => q({0} nmi),
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
						'two' => q({0} nmi),
					},
					'ohm' => {
						'few' => q({0} Ω),
						'many' => q({0} Ω),
						'name' => q(Ω),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
						'two' => q({0} Ω),
					},
					'ounce' => {
						'per' => q({0}/oz),
					},
					'parsec' => {
						'few' => q({0} pc),
						'many' => q({0} pc),
						'name' => q(pc),
						'one' => q({0} pc),
						'other' => q({0} pc),
						'two' => q({0} pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} pm),
						'many' => q({0} pm),
						'name' => q(pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
						'two' => q({0} pm),
					},
					'pint' => {
						'few' => q({0} pt),
						'many' => q({0} pt),
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
						'two' => q({0} pt),
					},
					'pint-metric' => {
						'few' => q({0} mpt),
						'many' => q({0} mpt),
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
						'two' => q({0} mpt),
					},
					'pound' => {
						'few' => q({0} lb),
						'many' => q({0} lb),
						'name' => q(lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
						'two' => q({0} lb),
					},
					'pound-per-square-inch' => {
						'few' => q({0} lb/in²),
						'many' => q({0} lb/in²),
						'name' => q(lb/in²),
						'one' => q({0} lb/in²),
						'other' => q({0} lb/in²),
						'two' => q({0} lb/in²),
					},
					'quart' => {
						'few' => q({0} qt),
						'many' => q({0} qt),
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
						'two' => q({0} qt),
					},
					'radian' => {
						'few' => q({0} rad),
						'many' => q({0} rad),
						'name' => q(rad),
						'one' => q({0} rad),
						'other' => q({0} rad),
						'two' => q({0} rad),
					},
					'square-centimeter' => {
						'few' => q({0} cm²),
						'many' => q({0} cm²),
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
						'two' => q({0} cm²),
					},
					'square-foot' => {
						'few' => q({0} ft²),
						'many' => q({0} ft²),
						'name' => q(ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
						'two' => q({0} ft²),
					},
					'square-inch' => {
						'few' => q({0} in²),
						'many' => q({0} in²),
						'name' => q(in²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
						'two' => q({0} in²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'many' => q({0} km²),
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'two' => q({0} km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'many' => q({0} m²),
						'name' => q(m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
						'two' => q({0} m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'many' => q({0} mi²),
						'name' => q(mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
						'two' => q({0} mi²),
					},
					'terabit' => {
						'few' => q({0} Tb),
						'many' => q({0} Tb),
						'name' => q(Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
						'two' => q({0} Tb),
					},
					'terabyte' => {
						'few' => q({0} To),
						'many' => q({0} To),
						'name' => q(To),
						'one' => q({0} To),
						'other' => q({0} To),
						'two' => q({0} To),
					},
					'ton' => {
						'few' => q({0} tn),
						'many' => q({0} tn),
						'name' => q(tn),
						'one' => q({0} tn),
						'other' => q({0} tn),
						'two' => q({0} tn),
					},
					'year' => {
						'few' => q({0} b),
						'many' => q({0} b),
						'name' => q(b),
						'one' => q({0} b),
						'other' => q({0} b),
						'per' => q({0}/b),
						'two' => q({0} b),
					},
				},
				'short' => {
					'acre' => {
						'few' => q({0} ac),
						'many' => q({0} ac),
						'name' => q(ac),
						'one' => q({0} ac),
						'other' => q({0} ac),
						'two' => q({0} ac),
					},
					'ampere' => {
						'few' => q({0} A),
						'many' => q({0} A),
						'name' => q(A),
						'one' => q({0} A),
						'other' => q({0} A),
						'two' => q({0} A),
					},
					'astronomical-unit' => {
						'few' => q({0} au),
						'many' => q({0} au),
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
						'two' => q({0} au),
					},
					'bit' => {
						'few' => q({0} bit),
						'many' => q({0} bit),
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
						'two' => q({0} bit),
					},
					'byte' => {
						'few' => q({0} o),
						'many' => q({0} o),
						'name' => q(o),
						'one' => q({0} o),
						'other' => q({0} o),
						'two' => q({0} o),
					},
					'calorie' => {
						'few' => q({0} cal),
						'many' => q({0} cal),
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
						'two' => q({0} cal),
					},
					'carat' => {
						'few' => q({0} CD),
						'many' => q({0} CD),
						'name' => q(CD),
						'one' => q({0} CD),
						'other' => q({0} CD),
						'two' => q({0} CD),
					},
					'celsius' => {
						'few' => q({0}°C),
						'many' => q({0}°C),
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
						'two' => q({0}°C),
					},
					'centiliter' => {
						'few' => q({0} cl),
						'many' => q({0} cl),
						'name' => q(cl),
						'one' => q({0} cl),
						'other' => q({0} cl),
						'two' => q({0} cl),
					},
					'centimeter' => {
						'few' => q({0} cm),
						'many' => q({0} cm),
						'name' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
						'two' => q({0} cm),
					},
					'century' => {
						'few' => q({0} kved),
						'many' => q({0} kved),
						'name' => q(kved),
						'one' => q({0} kved),
						'other' => q({0} kved),
						'two' => q({0} kved),
					},
					'coordinate' => {
						'east' => q({0} R),
						'north' => q({0} N),
						'south' => q({0} S),
						'west' => q({0} K),
					},
					'cubic-centimeter' => {
						'few' => q({0} cm³),
						'many' => q({0} cm³),
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
						'two' => q({0} cm³),
					},
					'cubic-foot' => {
						'few' => q({0} ft³),
						'many' => q({0} ft³),
						'name' => q(ft³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
						'two' => q({0} ft³),
					},
					'cubic-inch' => {
						'few' => q({0} in³),
						'many' => q({0} in³),
						'name' => q(in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
						'two' => q({0} in³),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'many' => q({0} km³),
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
						'two' => q({0} km³),
					},
					'cubic-meter' => {
						'few' => q({0} m³),
						'many' => q({0} m³),
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
						'two' => q({0} m³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'many' => q({0} mi³),
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
						'two' => q({0} mi³),
					},
					'day' => {
						'few' => q({0} d),
						'many' => q({0} d),
						'name' => q(d),
						'one' => q({0} d),
						'other' => q({0} d),
						'per' => q({0}/d),
						'two' => q({0} d),
					},
					'deciliter' => {
						'few' => q({0} dl),
						'many' => q({0} dl),
						'name' => q(dl),
						'one' => q({0} dl),
						'other' => q({0} dl),
						'two' => q({0} dl),
					},
					'decimeter' => {
						'few' => q({0} dm),
						'many' => q({0} dm),
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
						'two' => q({0} dm),
					},
					'degree' => {
						'few' => q({0} deg),
						'many' => q({0} deg),
						'name' => q(deg),
						'one' => q({0} deg),
						'other' => q({0} deg),
						'two' => q({0} deg),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
						'two' => q({0}°F),
					},
					'fathom' => {
						'few' => q({0} fm),
						'many' => q({0} fm),
						'name' => q(fm),
						'one' => q({0} fm),
						'other' => q({0} fm),
						'two' => q({0} fm),
					},
					'foot' => {
						'few' => q({0} ft),
						'many' => q({0} ft),
						'name' => q(ft),
						'one' => q({0} ft),
						'other' => q({0} ft),
						'per' => q({0}/ft),
						'two' => q({0} ft),
					},
					'gallon' => {
						'few' => q({0} gal),
						'many' => q({0} gal),
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
						'two' => q({0} gal),
					},
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} Gbit),
						'many' => q({0} Gbit),
						'name' => q(Gbit),
						'one' => q({0} Gbit),
						'other' => q({0} Gbit),
						'two' => q({0} Gbit),
					},
					'gigabyte' => {
						'few' => q({0} Go),
						'many' => q({0} Go),
						'name' => q(Go),
						'one' => q({0} Go),
						'other' => q({0} Go),
						'two' => q({0} Go),
					},
					'gigahertz' => {
						'few' => q({0} GHz),
						'many' => q({0} GHz),
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
						'two' => q({0} GHz),
					},
					'gigawatt' => {
						'few' => q({0} GW),
						'many' => q({0} GW),
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
						'two' => q({0} GW),
					},
					'gram' => {
						'few' => q({0} g),
						'many' => q({0} g),
						'name' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
						'two' => q({0} g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'many' => q({0} ha),
						'name' => q(ha),
						'one' => q({0} ha),
						'other' => q({0} ha),
						'two' => q({0} ha),
					},
					'hectoliter' => {
						'few' => q({0} hl),
						'many' => q({0} hl),
						'name' => q(hl),
						'one' => q({0} hl),
						'other' => q({0} hl),
						'two' => q({0} hl),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'many' => q({0} hPa),
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
						'two' => q({0} hPa),
					},
					'hertz' => {
						'few' => q({0} Hz),
						'many' => q({0} Hz),
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
						'two' => q({0} Hz),
					},
					'horsepower' => {
						'few' => q({0} hp),
						'many' => q({0} hp),
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
						'two' => q({0} hp),
					},
					'hour' => {
						'few' => q({0} h),
						'many' => q({0} h),
						'name' => q(h),
						'one' => q({0} h),
						'other' => q({0} h),
						'per' => q({0}/h),
						'two' => q({0} h),
					},
					'inch' => {
						'few' => q({0} in),
						'many' => q({0} in),
						'name' => q(in),
						'one' => q({0} in),
						'other' => q({0} in),
						'per' => q({0}/in),
						'two' => q({0} in),
					},
					'inch-hg' => {
						'few' => q({0} inHg),
						'many' => q({0} inHg),
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
						'two' => q({0} inHg),
					},
					'joule' => {
						'few' => q({0} J),
						'many' => q({0} J),
						'name' => q(J),
						'one' => q({0} J),
						'other' => q({0} J),
						'two' => q({0} J),
					},
					'karat' => {
						'few' => q({0} kt),
						'many' => q({0} kt),
						'name' => q(kt),
						'one' => q({0} kt),
						'other' => q({0} kt),
						'two' => q({0} kt),
					},
					'kelvin' => {
						'few' => q({0} K),
						'many' => q({0} K),
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
						'two' => q({0} K),
					},
					'kilobit' => {
						'few' => q({0} kbit),
						'many' => q({0} kbit),
						'name' => q(kbit),
						'one' => q({0} kbit),
						'other' => q({0} kbit),
						'two' => q({0} kbit),
					},
					'kilobyte' => {
						'few' => q({0} ko),
						'many' => q({0} ko),
						'name' => q(ko),
						'one' => q({0} ko),
						'other' => q({0} ko),
						'two' => q({0} ko),
					},
					'kilocalorie' => {
						'few' => q({0} kcal),
						'many' => q({0} kcal),
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
						'two' => q({0} kcal),
					},
					'kilogram' => {
						'few' => q({0} kg),
						'many' => q({0} kg),
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
						'two' => q({0} kg),
					},
					'kilohertz' => {
						'few' => q({0} kHz),
						'many' => q({0} kHz),
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
						'two' => q({0} kHz),
					},
					'kilojoule' => {
						'few' => q({0} kJ),
						'many' => q({0} kJ),
						'name' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
						'two' => q({0} kJ),
					},
					'kilometer' => {
						'few' => q({0} km),
						'many' => q({0} km),
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
						'per' => q({0}/km),
						'two' => q({0} km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} km/h),
						'many' => q({0} km/h),
						'name' => q(km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
						'two' => q({0} km/h),
					},
					'kilowatt' => {
						'few' => q({0} kW),
						'many' => q({0} kW),
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
						'two' => q({0} kW),
					},
					'kilowatt-hour' => {
						'few' => q({0} kWh),
						'many' => q({0} kWh),
						'name' => q(kWh),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
						'two' => q({0} kWh),
					},
					'knot' => {
						'few' => q({0} nd),
						'many' => q({0} nd),
						'name' => q(nd),
						'one' => q({0} nd),
						'other' => q({0} nd),
						'two' => q({0} nd),
					},
					'light-year' => {
						'name' => q(ly),
					},
					'liter' => {
						'few' => q({0} l),
						'many' => q({0} l),
						'name' => q(l),
						'one' => q({0} l),
						'other' => q({0} l),
						'per' => q({0}/l),
						'two' => q({0} l),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} l/100km),
						'many' => q({0} l/100km),
						'name' => q(l/100km),
						'one' => q({0} l/100km),
						'other' => q({0} l/100km),
						'two' => q({0} l/100km),
					},
					'liter-per-kilometer' => {
						'few' => q({0} l/km),
						'many' => q({0} l/km),
						'name' => q(l/km),
						'one' => q({0} l/km),
						'other' => q({0} l/km),
						'two' => q({0} l/km),
					},
					'lux' => {
						'few' => q({0} lx),
						'many' => q({0} lx),
						'name' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
						'two' => q({0} lx),
					},
					'megabit' => {
						'few' => q({0} Mbit),
						'many' => q({0} Mbit),
						'name' => q(Mbit),
						'one' => q({0} Mbit),
						'other' => q({0} Mbit),
						'two' => q({0} Mbit),
					},
					'megabyte' => {
						'few' => q({0} Mo),
						'many' => q({0} Mo),
						'name' => q(Mo),
						'one' => q({0} Mo),
						'other' => q({0} Mo),
						'two' => q({0} Mo),
					},
					'megahertz' => {
						'few' => q({0} MHz),
						'many' => q({0} MHz),
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
						'two' => q({0} MHz),
					},
					'megaliter' => {
						'few' => q({0} Ml),
						'many' => q({0} Ml),
						'name' => q(Ml),
						'one' => q({0} Ml),
						'other' => q({0} Ml),
						'two' => q({0} Ml),
					},
					'megawatt' => {
						'few' => q({0} MW),
						'many' => q({0} MW),
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
						'two' => q({0} MW),
					},
					'meter' => {
						'few' => q({0} m),
						'many' => q({0} m),
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
						'per' => q({0}/m),
						'two' => q({0} m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'many' => q({0} m/s),
						'name' => q(m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
						'two' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'few' => q({0} m/s²),
						'many' => q({0} m/s²),
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
						'two' => q({0} m/s²),
					},
					'metric-ton' => {
						'few' => q({0} t),
						'many' => q({0} t),
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
						'two' => q({0} t),
					},
					'microgram' => {
						'few' => q({0} µg),
						'many' => q({0} µg),
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
						'two' => q({0} µg),
					},
					'micrometer' => {
						'few' => q({0} µm),
						'many' => q({0} µm),
						'name' => q(µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
						'two' => q({0} µm),
					},
					'microsecond' => {
						'few' => q({0} μs),
						'many' => q({0} μs),
						'name' => q(μs),
						'one' => q({0} μs),
						'other' => q({0} μs),
						'two' => q({0} μs),
					},
					'mile' => {
						'few' => q({0} mi),
						'many' => q({0} mi),
						'name' => q(mi),
						'one' => q({0} mi),
						'other' => q({0} mi),
						'two' => q({0} mi),
					},
					'mile-per-gallon' => {
						'few' => q({0} mi/gal),
						'many' => q({0} mi/gal),
						'name' => q(mi/gal),
						'one' => q({0} mi/gal),
						'other' => q({0} mi/gal),
						'two' => q({0} mi/gal),
					},
					'mile-per-hour' => {
						'few' => q({0} mi/h),
						'many' => q({0} mi/h),
						'name' => q(mi/h),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
						'two' => q({0} mi/h),
					},
					'mile-scandinavian' => {
						'few' => q({0} smi),
						'many' => q({0} smi),
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
						'two' => q({0} smi),
					},
					'milliampere' => {
						'few' => q({0} mA),
						'many' => q({0} mA),
						'name' => q(mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
						'two' => q({0} mA),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'many' => q({0} mbar),
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
						'two' => q({0} mbar),
					},
					'milligram' => {
						'few' => q({0} mg),
						'many' => q({0} mg),
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
						'two' => q({0} mg),
					},
					'milliliter' => {
						'few' => q({0} ml),
						'many' => q({0} ml),
						'name' => q(ml),
						'one' => q({0} ml),
						'other' => q({0} ml),
						'two' => q({0} ml),
					},
					'millimeter' => {
						'few' => q({0} mm),
						'many' => q({0} mm),
						'name' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
						'two' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} mmHg),
						'many' => q({0} mmHg),
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
						'two' => q({0} mmHg),
					},
					'millisecond' => {
						'few' => q({0} ms),
						'many' => q({0} ms),
						'name' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
						'two' => q({0} ms),
					},
					'milliwatt' => {
						'few' => q({0} mW),
						'many' => q({0} mW),
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
						'two' => q({0} mW),
					},
					'minute' => {
						'few' => q({0} min),
						'many' => q({0} min),
						'name' => q(min),
						'one' => q({0} min),
						'other' => q({0} min),
						'per' => q({0}/min),
						'two' => q({0} min),
					},
					'nanometer' => {
						'few' => q({0} nm),
						'many' => q({0} nm),
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
						'two' => q({0} nm),
					},
					'nanosecond' => {
						'few' => q({0} ns),
						'many' => q({0} ns),
						'name' => q(ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
						'two' => q({0} ns),
					},
					'nautical-mile' => {
						'few' => q({0} nmi),
						'many' => q({0} nmi),
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
						'two' => q({0} nmi),
					},
					'ohm' => {
						'few' => q({0} Ω),
						'many' => q({0} Ω),
						'name' => q(Ω),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
						'two' => q({0} Ω),
					},
					'ounce' => {
						'few' => q({0} oz),
						'many' => q({0} oz),
						'name' => q(oz),
						'one' => q({0} oz),
						'other' => q({0} oz),
						'per' => q({0}/oz),
						'two' => q({0} oz),
					},
					'ounce-troy' => {
						'few' => q({0} oz t),
						'many' => q({0} oz t),
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
						'two' => q({0} oz t),
					},
					'parsec' => {
						'few' => q({0} pc),
						'many' => q({0} pc),
						'name' => q(pc),
						'one' => q({0} pc),
						'other' => q({0} pc),
						'two' => q({0} pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} pm),
						'many' => q({0} pm),
						'name' => q(pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
						'two' => q({0} pm),
					},
					'pint' => {
						'few' => q({0} pt),
						'many' => q({0} pt),
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
						'two' => q({0} pt),
					},
					'pint-metric' => {
						'few' => q({0} mpt),
						'many' => q({0} mpt),
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
						'two' => q({0} mpt),
					},
					'pound' => {
						'few' => q({0} lb),
						'many' => q({0} lb),
						'name' => q(lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
						'two' => q({0} lb),
					},
					'pound-per-square-inch' => {
						'few' => q({0} lb/in²),
						'many' => q({0} lb/in²),
						'name' => q(lb/in²),
						'one' => q({0} lb/in²),
						'other' => q({0} lb/in²),
						'two' => q({0} lb/in²),
					},
					'quart' => {
						'few' => q({0} qt),
						'many' => q({0} qt),
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
						'two' => q({0} qt),
					},
					'radian' => {
						'few' => q({0} rad),
						'many' => q({0} rad),
						'name' => q(rad),
						'one' => q({0} rad),
						'other' => q({0} rad),
						'two' => q({0} rad),
					},
					'second' => {
						'few' => q({0} s),
						'many' => q({0} s),
						'name' => q(s),
						'one' => q({0} s),
						'other' => q({0} s),
						'per' => q({0}/s),
						'two' => q({0} s),
					},
					'square-centimeter' => {
						'few' => q({0} cm²),
						'many' => q({0} cm²),
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
						'two' => q({0} cm²),
					},
					'square-foot' => {
						'few' => q({0} ft²),
						'many' => q({0} ft²),
						'name' => q(ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
						'two' => q({0} ft²),
					},
					'square-inch' => {
						'few' => q({0} in²),
						'many' => q({0} in²),
						'name' => q(in²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
						'two' => q({0} in²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'many' => q({0} km²),
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'two' => q({0} km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'many' => q({0} m²),
						'name' => q(m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
						'two' => q({0} m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'many' => q({0} mi²),
						'name' => q(mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
						'two' => q({0} mi²),
					},
					'terabit' => {
						'few' => q({0} Tbit),
						'many' => q({0} Tbit),
						'name' => q(Tbit),
						'one' => q({0} Tbit),
						'other' => q({0} Tbit),
						'two' => q({0} Tbit),
					},
					'terabyte' => {
						'few' => q({0} To),
						'many' => q({0} To),
						'name' => q(To),
						'one' => q({0} To),
						'other' => q({0} To),
						'two' => q({0} To),
					},
					'ton' => {
						'few' => q({0} tn),
						'many' => q({0} tn),
						'name' => q(tn),
						'one' => q({0} tn),
						'other' => q({0} tn),
						'two' => q({0} tn),
					},
					'volt' => {
						'few' => q({0} V),
						'many' => q({0} V),
						'name' => q(V),
						'one' => q({0} V),
						'other' => q({0} V),
						'two' => q({0} V),
					},
					'watt' => {
						'few' => q({0} W),
						'many' => q({0} W),
						'name' => q(W),
						'one' => q({0} W),
						'other' => q({0} W),
						'two' => q({0} W),
					},
					'year' => {
						'few' => q({0} bl.),
						'many' => q({0} bl.),
						'name' => q(bl.),
						'one' => q({0} bl.),
						'other' => q({0} bl.),
						'per' => q({0}/bl.),
						'two' => q({0} bl.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arab' => {
			'timeSeparator' => q(:),
		},
		'latn' => {
			'decimal' => q(,),
			'group' => q( ),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0.###',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0 %',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			symbol => 'ADP',
			display_name => {
				'currency' => q(peseta Andorra),
				'few' => q(feseta Andorra),
				'many' => q(a besetaoù Andorra),
				'one' => q(beseta Andorra),
				'other' => q(peseta Andorra),
				'two' => q(beseta Andorra),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(dirham EAU),
				'few' => q(dirham EAU),
				'many' => q(a zirhamoù EAU),
				'one' => q(dirham EAU),
				'other' => q(dirham EAU),
				'two' => q(zirham EAU),
			},
		},
		'AFA' => {
			symbol => 'AFA',
			display_name => {
				'currency' => q(afghani Afghanistan \(1927–2002\)),
				'few' => q(afghani Afghanistan \(1927–2002\)),
				'many' => q(a afghanioù Afghanistan \(1927–2002\)),
				'one' => q(afghani Afghanistan \(1927–2002\)),
				'other' => q(afghani Afghanistan \(1927–2002\)),
				'two' => q(afghani Afghanistan \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(afghani Afghanistan),
				'few' => q(afghani Afghanistan),
				'many' => q(a afghanioù Afghanistan),
				'one' => q(afghani Afghanistan),
				'other' => q(afghani Afghanistan),
				'two' => q(afghani Afghanistan),
			},
		},
		'ALK' => {
			symbol => 'ALK',
			display_name => {
				'currency' => q(lek Albania \(1946–1965\)),
				'few' => q(lek Albania \(1946–1965\)),
				'many' => q(a lekoù Albania \(1946–1965\)),
				'one' => q(lek Albania \(1946–1965\)),
				'other' => q(lek Albania \(1946–1965\)),
				'two' => q(lek Albania \(1946–1965\)),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(lek Albania),
				'few' => q(lek Albania),
				'many' => q(a lekoù Albania),
				'one' => q(lek Albania),
				'other' => q(lek Albania),
				'two' => q(lek Albania),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(dram Armenia),
				'few' => q(dram Armenia),
				'many' => q(a zramoù Armenia),
				'one' => q(dram Armenia),
				'other' => q(dram Armenia),
				'two' => q(zram Armenia),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(florin Antilhez nederlandat),
				'few' => q(florin Antilhez nederlandat),
				'many' => q(a florinoù Antilhez),
				'one' => q(florin Antilhez nederlandat),
				'other' => q(florin Antilhez nederlandat),
				'two' => q(florin Antilhez nederlandat),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(kwanza Angola),
				'few' => q(cʼhwanza Angola),
				'many' => q(a gwanzaoù Angola),
				'one' => q(cʼhwanza Angola),
				'other' => q(kwanza Angola),
				'two' => q(gwanza Angola),
			},
		},
		'AOK' => {
			symbol => 'AOK',
			display_name => {
				'currency' => q(kwanza Angola \(1977–1991\)),
				'few' => q(cʼhwanza Angola \(1977–1991\)),
				'many' => q(a gwanzaoù Angola \(1977–1991\)),
				'one' => q(cʼhwanza Angola \(1977–1991\)),
				'other' => q(kwanza Angola \(1977–1991\)),
				'two' => q(gwanza Angola \(1977–1991\)),
			},
		},
		'AON' => {
			symbol => 'AON',
			display_name => {
				'currency' => q(kwanza nevez Angola \(1990–2000\)),
				'few' => q(cʼhwanza nevez Angola \(1990–2000\)),
				'many' => q(a gwanzaoù nevez Angola \(1990–2000\)),
				'one' => q(cʼhwanza nevez Angola \(1990–2000\)),
				'other' => q(kwanza nevez Angola \(1990–2000\)),
				'two' => q(gwanza nevez Angola \(1990–2000\)),
			},
		},
		'AOR' => {
			symbol => 'AOR',
		},
		'ARA' => {
			symbol => 'ARA',
		},
		'ARL' => {
			symbol => 'ARL',
		},
		'ARM' => {
			symbol => 'ARM',
			display_name => {
				'currency' => q(peso Arcʼhantina \(1881–1970\)),
				'few' => q(feso Arcʼhantina \(1881–1970\)),
				'many' => q(a besoioù Arcʼhantina \(1881–1970\)),
				'one' => q(peso Arcʼhantina \(1881–1970\)),
				'other' => q(peso Arcʼhantina \(1881–1970\)),
				'two' => q(beso Arcʼhantina \(1881–1970\)),
			},
		},
		'ARP' => {
			symbol => 'ARP',
			display_name => {
				'currency' => q(peso Arcʼhantina \(1983–1985\)),
				'few' => q(feso Arcʼhantina \(1983–1985\)),
				'many' => q(a besoioù Arcʼhantina \(1983–1985\)),
				'one' => q(peso Arcʼhantina \(1983–1985\)),
				'other' => q(peso Arcʼhantina \(1983–1985\)),
				'two' => q(beso Arcʼhantina \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(peso Arcʼhantina),
				'few' => q(feso Arcʼhantina),
				'many' => q(a pesoioù Arcʼhantina),
				'one' => q(peso Arcʼhantina),
				'other' => q(peso Arcʼhantina),
				'two' => q(beso Arcʼhantina),
			},
		},
		'ATS' => {
			symbol => 'ATS',
			display_name => {
				'currency' => q(schilling Aostria),
				'few' => q(schilling Aostria),
				'many' => q(a schillingoù Aostria),
				'one' => q(schilling Aostria),
				'other' => q(schilling Aostria),
				'two' => q(schilling Aostria),
			},
		},
		'AUD' => {
			symbol => '$A',
			display_name => {
				'currency' => q(dollar Aostralia),
				'few' => q(dollar Aostralia),
				'many' => q(a zollaroù Aostralia),
				'one' => q(dollar Aostralia),
				'other' => q(dollar Aostralia),
				'two' => q(zollar Aostralia),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(florin Aruba),
				'few' => q(florin Aruba),
				'many' => q(a florinoù Aruba),
				'one' => q(florin Aruba),
				'other' => q(florin Aruba),
				'two' => q(florin Aruba),
			},
		},
		'AZM' => {
			symbol => 'AZM',
			display_name => {
				'currency' => q(manat Azerbaidjan \(1993–2006\)),
				'few' => q(manat Azerbaidjan \(1993–2006\)),
				'many' => q(a vanatoù Azerbaidjan \(1993–2006\)),
				'one' => q(manat Azerbaidjan \(1993–2006\)),
				'other' => q(manat Azerbaidjan \(1993–2006\)),
				'two' => q(vanat Azerbaidjan \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(manat Azerbaidjan),
				'few' => q(manat Azerbaidjan),
				'many' => q(a vanatoù Azerbaidjan),
				'one' => q(manat Azerbaidjan),
				'other' => q(manat Azerbaidjan),
				'two' => q(vanat Azerbaidjan),
			},
		},
		'BAD' => {
			symbol => 'BAD',
			display_name => {
				'currency' => q(dinar Bosnia ha Herzegovina \(1992–1994\)),
				'few' => q(dinar Bosnia ha Herzegovina \(1992–1994\)),
				'many' => q(a zinaroù Bosnia ha Herzegovina \(1992–1994\)),
				'one' => q(dinar Bosnia ha Herzegovina \(1992–1994\)),
				'other' => q(dinar Bosnia ha Herzegovina \(1992–1994\)),
				'two' => q(zinar Bosnia ha Herzegovina \(1992–1994\)),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(mark kemmadus Bosnia ha Herzegovina),
				'few' => q(mark kemmadus Bosnia ha Herzegovina),
				'many' => q(a varkoù kemmadus Bosnia ha Herzegovina),
				'one' => q(mark kemmadus Bosnia ha Herzegovina),
				'other' => q(mark kemmadus Bosnia ha Herzegovina),
				'two' => q(vark kemmadus Bosnia ha Herzegovina),
			},
		},
		'BAN' => {
			symbol => 'BAN',
			display_name => {
				'currency' => q(dinar nevez Bosnia ha Herzegovina \(1994–1997\)),
				'few' => q(dinar nevez Bosnia ha Herzegovina \(1994–1997\)),
				'many' => q(a zinaroù nevez Bosnia ha Herzegovina \(1994–1997\)),
				'one' => q(dinar nevez Bosnia ha Herzegovina \(1994–1997\)),
				'other' => q(dinar nevez Bosnia ha Herzegovina \(1994–1997\)),
				'two' => q(zinar nevez Bosnia ha Herzegovina \(1994–1997\)),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(dollar Barbados),
				'few' => q(dollar Barbados),
				'many' => q(a zollaroù Barbados),
				'one' => q(dollar Barbados),
				'other' => q(dollar Barbados),
				'two' => q(zollar Barbados),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(taka Bangladesh),
				'few' => q(zaka Bangladesh),
				'many' => q(a dakaoù Bangladesh),
				'one' => q(taka Bangladesh),
				'other' => q(taka Bangladesh),
				'two' => q(daka Bangladesh),
			},
		},
		'BEC' => {
			symbol => 'BEC',
			display_name => {
				'currency' => q(lur Belgia \(kemmadus\)),
				'few' => q(lur Belgia \(kemmadus\)),
				'many' => q(a lurioù Belgia \(kemmadus\)),
				'one' => q(lur Belgia \(kemmadus\)),
				'other' => q(lur Belgia \(kemmadus\)),
				'two' => q(lur Belgia \(kemmadus\)),
			},
		},
		'BEF' => {
			symbol => 'BEF',
			display_name => {
				'currency' => q(lur Belgia),
				'few' => q(lur Belgia),
				'many' => q(a lurioù Belgia),
				'one' => q(lur Belgia),
				'other' => q(lur Belgia),
				'two' => q(lur Belgia),
			},
		},
		'BEL' => {
			symbol => 'BEL',
			display_name => {
				'currency' => q(BEL),
				'few' => q(BEL),
				'many' => q(BEL),
				'one' => q(BEL),
				'other' => q(BEL),
				'two' => q(BEL),
			},
		},
		'BGL' => {
			symbol => 'BGL',
		},
		'BGM' => {
			symbol => 'BGM',
			display_name => {
				'currency' => q(lev sokialour Bulgaria),
				'few' => q(lev sokialour Bulgaria),
				'many' => q(a levoù sokialour Bulgaria),
				'one' => q(lev sokialour Bulgaria),
				'other' => q(lev sokialour Bulgaria),
				'two' => q(lev sokialour Bulgaria),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(lev Bulgaria),
				'few' => q(lev Bulgaria),
				'many' => q(a levoù Bulgaria),
				'one' => q(lev Bulgaria),
				'other' => q(lev Bulgaria),
				'two' => q(lev Bulgaria),
			},
		},
		'BGO' => {
			symbol => 'BGO',
			display_name => {
				'currency' => q(lev Bulgaria \(1879–1952\)),
				'few' => q(lev Bulgaria \(1879–1952\)),
				'many' => q(a levoù Bulgaria \(1879–1952\)),
				'one' => q(lev Bulgaria \(1879–1952\)),
				'other' => q(lev Bulgaria \(1879–1952\)),
				'two' => q(lev Bulgaria \(1879–1952\)),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(dinar Bahrein),
				'few' => q(dinar Bahrein),
				'many' => q(a zinaroù Bahrein),
				'one' => q(dinar Bahrein),
				'other' => q(dinar Bahrein),
				'two' => q(zinar Bahrein),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(lur Burundi),
				'few' => q(lur Burundi),
				'many' => q(a lurioù Burundi),
				'one' => q(lur Burundi),
				'other' => q(lur Burundi),
				'two' => q(lur Burundi),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(dollar Bermuda),
				'few' => q(dollar Bermuda),
				'many' => q(a zollaroù Bermuda),
				'one' => q(dollar Bermuda),
				'other' => q(dollar Bermuda),
				'two' => q(zollar Bermuda),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(dollar Brunei),
				'few' => q(dollar Brunei),
				'many' => q(a zollaroù Brunei),
				'one' => q(dollar Brunei),
				'other' => q(dollar Brunei),
				'two' => q(zollar Brunei),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(boliviano Bolivia),
				'few' => q(boliviano Bolivia),
				'many' => q(a volivianoioù Bolivia),
				'one' => q(boliviano Bolivia),
				'other' => q(boliviano Bolivia),
				'two' => q(voliviano Bolivia),
			},
		},
		'BOL' => {
			symbol => 'BOL',
			display_name => {
				'currency' => q(boliviano Bolivia \(1863–1963\)),
				'few' => q(boliviano Bolivia \(1863–1963\)),
				'many' => q(a volivianoioù Bolivia \(1863–1963\)),
				'one' => q(boliviano Bolivia \(1863–1963\)),
				'other' => q(boliviano Bolivia \(1863–1963\)),
				'two' => q(voliviano Bolivia \(1863–1963\)),
			},
		},
		'BOP' => {
			symbol => 'BOP',
			display_name => {
				'currency' => q(peso Bolivia),
				'few' => q(feso Bolivia),
				'many' => q(a besoioù Bolivia),
				'one' => q(peso Bolivia),
				'other' => q(peso Bolivia),
				'two' => q(beso Bolivia),
			},
		},
		'BOV' => {
			symbol => 'BOV',
		},
		'BRB' => {
			symbol => 'BRB',
		},
		'BRC' => {
			symbol => 'BRC',
		},
		'BRE' => {
			symbol => 'BRE',
		},
		'BRL' => {
			symbol => 'BRL',
			display_name => {
				'currency' => q(real Brazil),
				'few' => q(real Brazil),
				'many' => q(a realioù Brazil),
				'one' => q(real Brazil),
				'other' => q(real Brazil),
				'two' => q(real Brazil),
			},
		},
		'BRN' => {
			symbol => 'BRN',
		},
		'BRR' => {
			symbol => 'BRR',
		},
		'BRZ' => {
			symbol => 'BRZ',
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(dollar Bahamas),
				'few' => q(dollar Bahamas),
				'many' => q(a zollaroù Bahamas),
				'one' => q(dollar Bahamas),
				'other' => q(dollar Bahamas),
				'two' => q(zollar Bahamas),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ngultrum Bhoutan),
				'few' => q(ngultrum Bhoutan),
				'many' => q(a ngultrumoù Bhoutan),
				'one' => q(ngultrum Bhoutan),
				'other' => q(ngultrum Bhoutan),
				'two' => q(ngultrum Bhoutan),
			},
		},
		'BUK' => {
			symbol => 'BUK',
			display_name => {
				'currency' => q(kyat Birmania),
				'few' => q(cʼhyat Birmania),
				'many' => q(a gyatoù Birmania),
				'one' => q(cʼhyat Birmania),
				'other' => q(kyat Birmania),
				'two' => q(gyat Birmania),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(pula Botswana),
				'few' => q(fula Botswana),
				'many' => q(a bulaoù Botswana),
				'one' => q(pula Botswana),
				'other' => q(pula Botswana),
				'two' => q(bula Botswana),
			},
		},
		'BYB' => {
			symbol => 'BYB',
			display_name => {
				'currency' => q(roubl nevez Belarus \(1994–1999\)),
				'few' => q(roubl nevez Belarus \(1994–1999\)),
				'many' => q(a roubloù nevez Belarus \(1994–1999\)),
				'one' => q(roubl nevez Belarus \(1994–1999\)),
				'other' => q(roubl nevez Belarus \(1994–1999\)),
				'two' => q(roubl nevez Belarus \(1994–1999\)),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(roubl Belarus),
				'few' => q(roubl Belarus),
				'many' => q(a roubloù Belarus),
				'one' => q(roubl Belarus),
				'other' => q(roubl Belarus),
				'two' => q(roubl Belarus),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(dollar Belize),
				'few' => q(dollar Belize),
				'many' => q(a zollaroù Belize),
				'one' => q(dollar Belize),
				'other' => q(dollar Belize),
				'two' => q(zollar Belize),
			},
		},
		'CAD' => {
			symbol => '$CA',
			display_name => {
				'currency' => q(dollar Kanada),
				'few' => q(dollar Kanada),
				'many' => q(a zollaroù Kanada),
				'one' => q(dollar Kanada),
				'other' => q(dollar Kanada),
				'two' => q(zollar Kanada),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(lur Kongo),
				'few' => q(lur Kongo),
				'many' => q(a lurioù Kongo),
				'one' => q(lur Kongo),
				'other' => q(lur Kongo),
				'two' => q(lur Kongo),
			},
		},
		'CHE' => {
			symbol => 'CHE',
			display_name => {
				'currency' => q(euro WIR),
				'few' => q(euro WIR),
				'many' => q(a euroioù WIR),
				'one' => q(euro WIR),
				'other' => q(euro WIR),
				'two' => q(euro WIR),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(lur Suis),
				'few' => q(lur Suis),
				'many' => q(a lurioù Suis),
				'one' => q(lur Suis),
				'other' => q(lur Suis),
				'two' => q(lur Suis),
			},
		},
		'CHW' => {
			symbol => 'CHW',
			display_name => {
				'currency' => q(lur WIR),
				'few' => q(lur WIR),
				'many' => q(a lurioù WIR),
				'one' => q(lur WIR),
				'other' => q(lur WIR),
				'two' => q(lur WIR),
			},
		},
		'CLE' => {
			symbol => 'CLE',
			display_name => {
				'currency' => q(escudo Chile),
				'few' => q(escudo Chile),
				'many' => q(a escudoioù Chile),
				'one' => q(escudo Chile),
				'other' => q(escudo Chile),
				'two' => q(escudo Chile),
			},
		},
		'CLF' => {
			symbol => 'CLF',
			display_name => {
				'currency' => q(unanenn jediñ Chile),
				'few' => q(unanenn jediñ Chile),
				'many' => q(a unanennoù jediñ Chile),
				'one' => q(unanenn jediñ Chile),
				'other' => q(unanenn jediñ Chile),
				'two' => q(unanenn jediñ Chile),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(peso Chile),
				'few' => q(feso Chile),
				'many' => q(a besoioù Chile),
				'one' => q(peso Chile),
				'other' => q(peso Chile),
				'two' => q(beso Chile),
			},
		},
		'CNX' => {
			symbol => 'CNX',
			display_name => {
				'currency' => q(dollar Bank poblel Sina),
				'few' => q(dollar Bank poblel Sina),
				'many' => q(a zollaroù Bank poblel Sina),
				'one' => q(dollar Bank poblel Sina),
				'other' => q(dollar Bank poblel Sina),
				'two' => q(zollar Bank poblel Sina),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(yuan Sina),
				'few' => q(yuan Sina),
				'many' => q(a yuanoù Sina),
				'one' => q(yuan Sina),
				'other' => q(yuan Sina),
				'two' => q(yuan Sina),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(peso Kolombia),
				'few' => q(feso Kolombia),
				'many' => q(a besoioù Kolombia),
				'one' => q(peso Kolombia),
				'other' => q(peso Kolombia),
				'two' => q(beso Kolombia),
			},
		},
		'COU' => {
			symbol => 'COU',
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(colón Costa Rica),
				'few' => q(cʼholón Costa Rica),
				'many' => q(a golónoù Costa Rica),
				'one' => q(cʼholón Costa Rica),
				'other' => q(colón Costa Rica),
				'two' => q(golón Costa Rica),
			},
		},
		'CSD' => {
			symbol => 'CSD',
			display_name => {
				'currency' => q(dinar Serbia \(2002–2006\)),
				'few' => q(dinar Serbia \(2002–2006\)),
				'many' => q(a zinaroù Serbia \(2002–2006\)),
				'one' => q(dinar Serbia \(2002–2006\)),
				'other' => q(dinar Serbia \(2002–2006\)),
				'two' => q(zinar Serbia \(2002–2006\)),
			},
		},
		'CSK' => {
			symbol => 'CSK',
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(peso kemmadus Kuba),
				'few' => q(feso kemmadus Kuba),
				'many' => q(a besoioù kemmadus Kuba),
				'one' => q(peso kemmadus Kuba),
				'other' => q(peso kemmadus Kuba),
				'two' => q(beso gemmadus Kuba),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(peso Kuba),
				'few' => q(feso Kuba),
				'many' => q(a besoioù Kuba),
				'one' => q(peso Kuba),
				'other' => q(peso Kuba),
				'two' => q(beso Kuba),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(escudo Kab Glas),
				'few' => q(escudo Kab Glas),
				'many' => q(a escudoioù Kab Glas),
				'one' => q(escudo Kab Glas),
				'other' => q(escudo Kab Glas),
				'two' => q(escudo Kab Glas),
			},
		},
		'CYP' => {
			symbol => 'CYP',
			display_name => {
				'currency' => q(lur Kiprenez),
				'few' => q(lur Kiprenez),
				'many' => q(a lurioù Kiprenez),
				'one' => q(lur Kiprenez),
				'other' => q(lur Kiprenez),
				'two' => q(lur Kiprenez),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(kurunenn Tchek),
				'few' => q(cʼhurunenn Tchek),
				'many' => q(a gurunennoù Tchek),
				'one' => q(gurunenn Tchek),
				'other' => q(kurunenn Tchek),
				'two' => q(gurunenn Tchek),
			},
		},
		'DDM' => {
			symbol => 'DDM',
			display_name => {
				'currency' => q(mark Alamagn ar Reter),
				'few' => q(mark Alamagn ar Reter),
				'many' => q(a varkoù Alamagn ar Reter),
				'one' => q(mark Alamagn ar Reter),
				'other' => q(mark Alamagn ar Reter),
				'two' => q(mark Alamagn ar Reter),
			},
		},
		'DEM' => {
			symbol => 'DEM',
			display_name => {
				'currency' => q(mark Alamagn),
				'few' => q(mark Alamagn),
				'many' => q(a varkoù Alamagn),
				'one' => q(mark Alamagn),
				'other' => q(mark Alamagn),
				'two' => q(vark Alamagn),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(lur Djibouti),
				'few' => q(lur Djibouti),
				'many' => q(a lurioù Djibouti),
				'one' => q(lur Djibouti),
				'other' => q(lur Djibouti),
				'two' => q(lur Djibouti),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(kurunenn Danmark),
				'few' => q(cʼhurunenn Danmark),
				'many' => q(a gurunennoù Danmark),
				'one' => q(gurunenn Danmark),
				'other' => q(kurunenn Danmark),
				'two' => q(gurunenn Danmark),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(peso Dominikan),
				'few' => q(feso Dominikan),
				'many' => q(a besoioù Dominikan),
				'one' => q(peso Dominikan),
				'other' => q(peso Dominikan),
				'two' => q(beso Dominikan),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(dinar Aljeria),
				'few' => q(dinar Aljeria),
				'many' => q(a zinaroù Aljeria),
				'one' => q(dinar Aljeria),
				'other' => q(dinar Aljeria),
				'two' => q(zinar Aljeria),
			},
		},
		'ECS' => {
			symbol => 'ECS',
		},
		'ECV' => {
			symbol => 'ECV',
		},
		'EEK' => {
			symbol => 'EEK',
			display_name => {
				'currency' => q(kurunenn Estonia),
				'few' => q(cʼhurunenn Estonia),
				'many' => q(a gurunennoù Estonia),
				'one' => q(gurunenn Estonia),
				'other' => q(kurunenn Estonia),
				'two' => q(gurunenn Estonia),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(lur Egipt),
				'few' => q(lur Egipt),
				'many' => q(a lurioù Egipt),
				'one' => q(lur Egipt),
				'other' => q(lur Egipt),
				'two' => q(lur Egipt),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(nakfa Eritrea),
				'few' => q(nakfa Eritrea),
				'many' => q(a nakfaoù Eritrea),
				'one' => q(nakfa Eritrea),
				'other' => q(nakfa Eritrea),
				'two' => q(nakfa Eritrea),
			},
		},
		'ESA' => {
			symbol => 'ESA',
		},
		'ESB' => {
			symbol => 'ESB',
			display_name => {
				'currency' => q(peseta gemmadus Spagn),
				'few' => q(feseta gemmadus Spagn),
				'many' => q(a besetaoù kemmadus Spagn),
				'one' => q(beseta gemmadus Spagn),
				'other' => q(peseta gemmadus Spagn),
				'two' => q(beseta gemmadus Spagn),
			},
		},
		'ESP' => {
			symbol => 'ESP',
			display_name => {
				'currency' => q(peseta Spagn),
				'few' => q(feseta Spagn),
				'many' => q(a besetaoù Spagn),
				'one' => q(beseta Spagn),
				'other' => q(peseta Spagn),
				'two' => q(beseta Spagn),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(birr Etiopia),
				'few' => q(birr Etiopia),
				'many' => q(a virroù Etiopia),
				'one' => q(birr Etiopia),
				'other' => q(birr Etiopia),
				'two' => q(virr Etiopia),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(euro),
				'few' => q(euro),
				'many' => q(a euroioù),
				'one' => q(euro),
				'other' => q(euro),
				'two' => q(euro),
			},
		},
		'FIM' => {
			symbol => 'FIM',
			display_name => {
				'currency' => q(mark Finland),
				'few' => q(mark Finland),
				'many' => q(a varkoù Finland),
				'one' => q(mark Finland),
				'other' => q(mark Finland),
				'two' => q(vark Finland),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(dollar Fidji),
				'few' => q(dollar Fidji),
				'many' => q(a zollaroù Fidji),
				'one' => q(dollar Fidji),
				'other' => q(dollar Fidji),
				'two' => q(zollar Fidji),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(lur Inizi Falkland),
				'few' => q(lur Inizi Falkland),
				'many' => q(a lurioù Inizi Falkland),
				'one' => q(lur Inizi Falkland),
				'other' => q(lur Inizi Falkland),
				'two' => q(lur Inizi Falkland),
			},
		},
		'FRF' => {
			symbol => 'FRF',
			display_name => {
				'currency' => q(lur gall),
				'few' => q(lur gall),
				'many' => q(a lurioù gall),
				'one' => q(lur gall),
				'other' => q(lur gall),
				'two' => q(lur gall),
			},
		},
		'GBP' => {
			symbol => '£ RU',
			display_name => {
				'currency' => q(lur Breizh-Veur),
				'few' => q(lur Breizh-Veur),
				'many' => q(a lurioù Breizh-Veur),
				'one' => q(lur Breizh-Veur),
				'other' => q(lur Breizh-Veur),
				'two' => q(lur Breizh-Veur),
			},
		},
		'GEK' => {
			symbol => 'GEK',
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(lari Jorjia),
				'few' => q(lari Jorjia),
				'many' => q(a larioù Jorjia),
				'one' => q(lari Jorjia),
				'other' => q(lari Jorjia),
				'two' => q(lari Jorjia),
			},
		},
		'GHC' => {
			symbol => 'GHC',
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(cedi Ghana),
				'few' => q(cedi Ghana),
				'many' => q(cedi Ghana),
				'one' => q(cedi Ghana),
				'other' => q(cedi Ghana),
				'two' => q(cedi Ghana),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(lur Jibraltar),
				'few' => q(lur Jibraltar),
				'many' => q(a lurioù Jibraltar),
				'one' => q(lur Jibraltar),
				'other' => q(lur Jibraltar),
				'two' => q(lur Jibraltar),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(dalasi Gambia),
				'few' => q(dalasi Gambia),
				'many' => q(a zalasioù Gambia),
				'one' => q(dalasi Gambia),
				'other' => q(dalasi Gambia),
				'two' => q(zalasi Gambia),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(lur Ginea),
				'few' => q(lur Ginea),
				'many' => q(a lurioù Ginea),
				'one' => q(lur Ginea),
				'other' => q(lur Ginea),
				'two' => q(lur Ginea),
			},
		},
		'GNS' => {
			symbol => 'GNS',
			display_name => {
				'currency' => q(syli Ginea),
				'few' => q(syli Ginea),
				'many' => q(a sylioù Ginea),
				'one' => q(syli Ginea),
				'other' => q(syli Ginea),
				'two' => q(syli Ginea),
			},
		},
		'GQE' => {
			symbol => 'GQE',
			display_name => {
				'currency' => q(ekwele Ginea ar Cʼheheder),
				'few' => q(ekwele Ginea ar Cʼheheder),
				'many' => q(a ekweleoù Ginea ar Cʼheheder),
				'one' => q(ekwele Ginea ar Cʼheheder),
				'other' => q(ekwele Ginea ar Cʼheheder),
				'two' => q(ekwele Ginea ar Cʼheheder),
			},
		},
		'GRD' => {
			symbol => 'GRD',
			display_name => {
				'currency' => q(drakm Gres),
				'few' => q(drakm Gres),
				'many' => q(a zrakmoù Gres),
				'one' => q(drakm Gres),
				'other' => q(drakm Gres),
				'two' => q(zrakm Gres),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(quetzal Guatemala),
				'few' => q(cʼhuetzal Guatemala),
				'many' => q(a guetzaloù Guatemala),
				'one' => q(cʼhuetzal Guatemala),
				'other' => q(quetzal Guatemala),
				'two' => q(guetzal Guatemala),
			},
		},
		'GWE' => {
			symbol => 'GWE',
		},
		'GWP' => {
			symbol => 'GWP',
			display_name => {
				'currency' => q(peso Ginea-Bissau),
				'few' => q(feso Ginea-Bissau),
				'many' => q(a besoioù Ginea-Bissau),
				'one' => q(peso Ginea-Bissau),
				'other' => q(peso Ginea-Bissau),
				'two' => q(beso Ginea-Bissau),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(dollar Guyana),
				'few' => q(dollar Guyana),
				'many' => q(a zollaroù Guyana),
				'one' => q(dollar Guyana),
				'other' => q(dollar Guyana),
				'two' => q(zollar Guyana),
			},
		},
		'HKD' => {
			symbol => '$ HK',
			display_name => {
				'currency' => q(dollar Hong Kong),
				'few' => q(dollar Hong Kong),
				'many' => q(a zollaroù Hong Kong),
				'one' => q(dollar Hong Kong),
				'other' => q(dollar Hong Kong),
				'two' => q(zollar Hong Kong),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(lempira Honduras),
				'few' => q(lempira Honduras),
				'many' => q(a lempiraoù Honduras),
				'one' => q(lempira Honduras),
				'other' => q(lempira Honduras),
				'two' => q(lempira Honduras),
			},
		},
		'HRD' => {
			symbol => 'HRD',
			display_name => {
				'currency' => q(dinar Kroatia),
				'few' => q(dinar Kroatia),
				'many' => q(a zinaroù Kroatia),
				'one' => q(dinar Kroatia),
				'other' => q(dinar Kroatia),
				'two' => q(zinar Kroatia),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(kuna Kroatia),
				'few' => q(cʼhuna Kroatia),
				'many' => q(a gunaoù Kroatia),
				'one' => q(cʼhuna Kroatia),
				'other' => q(kuna Kroatia),
				'two' => q(guna Kroatia),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(gourde Haiti),
				'few' => q(gourde Haiti),
				'many' => q(a cʼhourdeoù Haiti),
				'one' => q(gourde Haiti),
				'other' => q(gourde Haiti),
				'two' => q(cʼhourde Haiti),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(forint Hungaria),
				'few' => q(forint Hungaria),
				'many' => q(a forintoù Hungaria),
				'one' => q(forint Hungaria),
				'other' => q(forint Hungaria),
				'two' => q(forint Hungaria),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(roupi Indonezia),
				'few' => q(roupi Indonezia),
				'many' => q(a roupioù Indonezia),
				'one' => q(roupi Indonezia),
				'other' => q(roupi Indonezia),
				'two' => q(roupi Indonezia),
			},
		},
		'IEP' => {
			symbol => 'IEP',
			display_name => {
				'currency' => q(lur Iwerzhon),
				'few' => q(lur Iwerzhon),
				'many' => q(a lurioù Iwerzhon),
				'one' => q(lur Iwerzhon),
				'other' => q(lur Iwerzhon),
				'two' => q(lur Iwerzhon),
			},
		},
		'ILP' => {
			symbol => 'ILP',
			display_name => {
				'currency' => q(lur Israel),
				'few' => q(lur Israel),
				'many' => q(a lurioù Israel),
				'one' => q(lur Israel),
				'other' => q(lur Israel),
				'two' => q(lur Israel),
			},
		},
		'ILR' => {
			symbol => 'ILR',
			display_name => {
				'currency' => q(shekel Israel \(1980–1985\)),
				'few' => q(shekel Israel \(1980–1985\)),
				'many' => q(shekel Israel \(1980–1985\)),
				'one' => q(shekel Israel \(1980–1985\)),
				'other' => q(shekel Israel \(1980–1985\)),
				'two' => q(shekel Israel \(1980–1985\)),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(shekel nevez Israel),
				'few' => q(shekel nevez Israel),
				'many' => q(shekel nevez Israel),
				'one' => q(shekel nevez Israel),
				'other' => q(shekel nevez Israel),
				'two' => q(shekel nevez Israel),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(roupi India),
				'few' => q(roupi India),
				'many' => q(a roupioù India),
				'one' => q(roupi India),
				'other' => q(roupi India),
				'two' => q(roupi India),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(dinar Iraq),
				'few' => q(dinar Iraq),
				'many' => q(a zinaroù Iraq),
				'one' => q(dinar Iraq),
				'other' => q(dinar Iraq),
				'two' => q(zinar Iraq),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(rial Iran),
				'few' => q(rial Iran),
				'many' => q(a rialoù Iran),
				'one' => q(rial Iran),
				'other' => q(rial Iran),
				'two' => q(rial Iran),
			},
		},
		'ISJ' => {
			symbol => 'ISJ',
			display_name => {
				'currency' => q(kurunenn Island \(1918–1981\)),
				'few' => q(cʼhurunenn Island \(1918–1981\)),
				'many' => q(a gurunennoù Island \(1918–1981\)),
				'one' => q(gurunenn Island \(1918–1981\)),
				'other' => q(kurunenn Island \(1918–1981\)),
				'two' => q(gurunenn Island \(1918–1981\)),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(kurunenn Island),
				'few' => q(cʼhurunenn Island),
				'many' => q(a gurunennoù Island),
				'one' => q(gurunenn Island),
				'other' => q(kurunenn Island),
				'two' => q(gurunenn Island),
			},
		},
		'ITL' => {
			symbol => 'ITL',
			display_name => {
				'currency' => q(lur Italia),
				'few' => q(lur Italia),
				'many' => q(a lurioù Italia),
				'one' => q(lur Italia),
				'other' => q(lur Italia),
				'two' => q(lur Italia),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(dollar Jamaika),
				'few' => q(dollar Jamaika),
				'many' => q(a zollaroù Jamaika),
				'one' => q(dollar Jamaika),
				'other' => q(dollar Jamaika),
				'two' => q(zollar Jamaika),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(dinar Jordania),
				'few' => q(dinar Jordania),
				'many' => q(a zinaroù Jordania),
				'one' => q(dinar Jordania),
				'other' => q(dinar Jordania),
				'two' => q(zinar Jordania),
			},
		},
		'JPY' => {
			symbol => 'JPY',
			display_name => {
				'currency' => q(yen Japan),
				'few' => q(yen Japan),
				'many' => q(a yenoù Japan),
				'one' => q(yen Japan),
				'other' => q(yen Japan),
				'two' => q(yen Japan),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(shilling Kenya),
				'few' => q(shilling Kenya),
				'many' => q(a shillingoù Kenya),
				'one' => q(shilling Kenya),
				'other' => q(shilling Kenya),
				'two' => q(shilling Kenya),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(som Kyrgyzstan),
				'few' => q(som Kyrgyzstan),
				'many' => q(a somoù Kyrgyzstan),
				'one' => q(som Kyrgyzstan),
				'other' => q(som Kyrgyzstan),
				'two' => q(som Kyrgyzstan),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(riel Kambodja),
				'few' => q(riel Kambodja),
				'many' => q(a rieloù Kambodja),
				'one' => q(riel Kambodja),
				'other' => q(riel Kambodja),
				'two' => q(riel Kambodja),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(lur Komorez),
				'few' => q(lur Komorez),
				'many' => q(a lurioù Komorez),
				'one' => q(lur Komorez),
				'other' => q(lur Komorez),
				'two' => q(lur Komorez),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(won Korea an Norzh),
				'few' => q(won Korea an Norzh),
				'many' => q(a wonoù Korea an Norzh),
				'one' => q(won Korea an Norzh),
				'other' => q(won Korea an Norzh),
				'two' => q(won Korea an Norzh),
			},
		},
		'KRH' => {
			symbol => 'KRH',
			display_name => {
				'currency' => q(hwan Korea ar Su \(1953–1962\)),
				'few' => q(hwan Korea ar Su \(1953–1962\)),
				'many' => q(a hwanoù Korea ar Su \(1953–1962\)),
				'one' => q(hwan Korea ar Su \(1953–1962\)),
				'other' => q(hwan Korea ar Su \(1953–1962\)),
				'two' => q(hwan Korea ar Su \(1953–1962\)),
			},
		},
		'KRO' => {
			symbol => 'KRO',
			display_name => {
				'currency' => q(won Korea ar Su \(1945–1953\)),
				'few' => q(won Korea ar Su \(1945–1953\)),
				'many' => q(a wonoù Korea ar Su \(1945–1953\)),
				'one' => q(won Korea ar Su \(1945–1953\)),
				'other' => q(won Korea ar Su \(1945–1953\)),
				'two' => q(won Korea ar Su \(1945–1953\)),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(won Korea ar Su),
				'few' => q(won Korea ar Su),
				'many' => q(a wonoù Korea ar Su),
				'one' => q(won Korea ar Su),
				'other' => q(won Korea ar Su),
				'two' => q(won Korea ar Su),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(dinar Koweit),
				'few' => q(dinar Koweit),
				'many' => q(a zinaroù Koweit),
				'one' => q(dinar Koweit),
				'other' => q(dinar Koweit),
				'two' => q(zinar Koweit),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(dollar Inizi Cayman),
				'few' => q(dollar Inizi Cayman),
				'many' => q(a zollaroù Inizi Cayman),
				'one' => q(dollar Inizi Cayman),
				'other' => q(dollar Inizi Cayman),
				'two' => q(zollar Inizi Cayman),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(tenge Kazakstan),
				'few' => q(zenge Kazakstan),
				'many' => q(a dengeoù Kazakstan),
				'one' => q(tenge Kazakstan),
				'other' => q(tenge Kazakstan),
				'two' => q(denge Kazakstan),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(kip Laos),
				'few' => q(cʼhip Laos),
				'many' => q(a gipoù Laos),
				'one' => q(cʼhip Laos),
				'other' => q(kip Laos),
				'two' => q(gip Laos),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(lur Liban),
				'few' => q(lur Liban),
				'many' => q(a lurioù Liban),
				'one' => q(lur Liban),
				'other' => q(lur Liban),
				'two' => q(lur Liban),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(roupi Sri Lanka),
				'few' => q(roupi Sri Lanka),
				'many' => q(a roupioù Sri Lanka),
				'one' => q(roupi Sri Lanka),
				'other' => q(roupi Sri Lanka),
				'two' => q(roupi Sri Lanka),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(dollar Liberia),
				'few' => q(dollar Liberia),
				'many' => q(a zollaroù Liberia),
				'one' => q(dollar Liberia),
				'other' => q(dollar Liberia),
				'two' => q(zollar Liberia),
			},
		},
		'LSL' => {
			symbol => 'LSL',
			display_name => {
				'currency' => q(loti Lesotho),
				'few' => q(loti Lesotho),
				'many' => q(a lotioù Lesotho),
				'one' => q(loti Lesotho),
				'other' => q(loti Lesotho),
				'two' => q(loti Lesotho),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(litas Lituania),
				'few' => q(litas Lituania),
				'many' => q(a litasoù Lituania),
				'one' => q(litas Lituania),
				'other' => q(litas Lituania),
				'two' => q(litas Lituania),
			},
		},
		'LTT' => {
			symbol => 'LTT',
			display_name => {
				'currency' => q(talonas Lituania),
				'few' => q(zalonas Lituania),
				'many' => q(a dalonasoù Lituania),
				'one' => q(talonas Lituania),
				'other' => q(talonas Lituania),
				'two' => q(dalonas Lituania),
			},
		},
		'LUC' => {
			symbol => 'LUC',
			display_name => {
				'currency' => q(lur kemmadus Luksembourg),
				'few' => q(lur kemmadus Luksembourg),
				'many' => q(a lurioù kemmadus Luksembourg),
				'one' => q(lur kemmadus Luksembourg),
				'other' => q(lur kemmadus Luksembourg),
				'two' => q(lur kemmadus Luksembourg),
			},
		},
		'LUF' => {
			symbol => 'LUF',
			display_name => {
				'currency' => q(lur Luksembourg),
				'few' => q(lur Luksembourg),
				'many' => q(a lurioù Luksembourg),
				'one' => q(lur Luksembourg),
				'other' => q(lur Luksembourg),
				'two' => q(lur Luksembourg),
			},
		},
		'LUL' => {
			symbol => 'LUL',
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(lats Latvia),
				'few' => q(lats Latvia),
				'many' => q(a latsoù Latvia),
				'one' => q(lats Latvia),
				'other' => q(lats Latvia),
				'two' => q(lats Latvia),
			},
		},
		'LVR' => {
			symbol => 'LVR',
			display_name => {
				'currency' => q(roubl Latvia),
				'few' => q(roubl Latvia),
				'many' => q(a roubloù Latvia),
				'one' => q(roubl Latvia),
				'other' => q(roubl Latvia),
				'two' => q(roubl Latvia),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(dinar Libia),
				'few' => q(dinar Libia),
				'many' => q(a zinaroù Libia),
				'one' => q(dinar Libia),
				'other' => q(dinar Libia),
				'two' => q(zinar Libia),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(dirham Maroko),
				'few' => q(dirham Maroko),
				'many' => q(a zirhamoù Maroko),
				'one' => q(dirham Maroko),
				'other' => q(dirham Maroko),
				'two' => q(zirham Maroko),
			},
		},
		'MAF' => {
			symbol => 'MAF',
			display_name => {
				'currency' => q(lur Maroko),
				'few' => q(lur Maroko),
				'many' => q(a lurioù Maroko),
				'one' => q(lur Maroko),
				'other' => q(lur Maroko),
				'two' => q(lur Maroko),
			},
		},
		'MCF' => {
			symbol => 'MCF',
			display_name => {
				'currency' => q(lur Monaco),
				'few' => q(lur Monaco),
				'many' => q(a lurioù Monaco),
				'one' => q(lur Monaco),
				'other' => q(lur Monaco),
				'two' => q(lur Monaco),
			},
		},
		'MDC' => {
			symbol => 'MDC',
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(leu Moldova),
				'few' => q(leu Moldova),
				'many' => q(leu Moldova),
				'one' => q(leu Moldova),
				'other' => q(leu Moldova),
				'two' => q(leu Moldova),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ariary Madagaskar),
				'few' => q(ariary Madagaskar),
				'many' => q(a ariaryoù Madagaska),
				'one' => q(ariary Madagaskar),
				'other' => q(ariary Madagaskar),
				'two' => q(ariary Madagaskar),
			},
		},
		'MGF' => {
			symbol => 'MGF',
			display_name => {
				'currency' => q(lur Madagaskar),
				'few' => q(lur Madagaskar),
				'many' => q(a lurioù Madagaskar),
				'one' => q(lur Madagaskar),
				'other' => q(lur Madagaskar),
				'two' => q(lur Madagaskar),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(denar Makedonia),
				'few' => q(denar Makedonia),
				'many' => q(a zenaroù Makedonia),
				'one' => q(denar Makedonia),
				'other' => q(denar Makedonia),
				'two' => q(zenar Makedonia),
			},
		},
		'MKN' => {
			symbol => 'MKN',
			display_name => {
				'currency' => q(denar Makedonia \(1992–1993\)),
				'few' => q(denar Makedonia \(1992–1993\)),
				'many' => q(a zenaroù Makedonia \(1992–1993\)),
				'one' => q(denar Makedonia \(1992–1993\)),
				'other' => q(denar Makedonia \(1992–1993\)),
				'two' => q(zenar Makedonia \(1992–1993\)),
			},
		},
		'MLF' => {
			symbol => 'MLF',
			display_name => {
				'currency' => q(lur Mali),
				'few' => q(lur Mali),
				'many' => q(a lurioù Mali),
				'one' => q(lur Mali),
				'other' => q(lur Mali),
				'two' => q(lur Mali),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(kyat Myanmar),
				'few' => q(cʼhyat Myanmar),
				'many' => q(a gyatoù Myanmar),
				'one' => q(cʼhyat Myanmar),
				'other' => q(kyat Myanmar),
				'two' => q(gyat Myanmar),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(tugrik Mongolia),
				'few' => q(zugrik Mongolia),
				'many' => q(a dugrikoù Mongolia),
				'one' => q(tugrik Mongolia),
				'other' => q(tugrik Mongolia),
				'two' => q(dugrik Mongolia),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(pataca Macau),
				'few' => q(fataca Macau),
				'many' => q(a batacaoù Macau),
				'one' => q(pataca Macau),
				'other' => q(pataca Macau),
				'two' => q(bataca Macau),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(ouguiya Maouritania),
				'few' => q(ouguiya Maouritania),
				'many' => q(a ouguiyaoù Maouritania),
				'one' => q(ouguiya Maouritania),
				'other' => q(ouguiya Maouritania),
				'two' => q(ouguiya Maouritania),
			},
		},
		'MTL' => {
			symbol => 'MTL',
			display_name => {
				'currency' => q(lira Malta),
				'few' => q(lira Malta),
				'many' => q(a liraoù Malta),
				'one' => q(lira Malta),
				'other' => q(lira Malta),
				'two' => q(lira Malta),
			},
		},
		'MTP' => {
			symbol => 'MTP',
			display_name => {
				'currency' => q(lur Malta),
				'few' => q(lur Malta),
				'many' => q(a lurioù Malta),
				'one' => q(lur Malta),
				'other' => q(lur Malta),
				'two' => q(lur Malta),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(roupi Moris),
				'few' => q(roupi Moris),
				'many' => q(a roupioù Moris),
				'one' => q(roupi Moris),
				'other' => q(roupi Moris),
				'two' => q(roupi Moris),
			},
		},
		'MVP' => {
			display_name => {
				'currency' => q(roupi Maldivez),
				'few' => q(roupi Maldivez),
				'many' => q(a roupioù Maldivez),
				'one' => q(roupi Maldivez),
				'other' => q(roupi Maldivez),
				'two' => q(roupi Maldivez),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(rufiyaa Maldivez),
				'few' => q(rufiyaa Maldivez),
				'many' => q(a rufiyaaoù Maldivez),
				'one' => q(rufiyaa Maldivez),
				'other' => q(rufiyaa Maldivez),
				'two' => q(rufiyaa Maldivez),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(kwacha Malawi),
				'few' => q(kwacha Malawi),
				'many' => q(a gwachaoù Malawi),
				'one' => q(cʼhwacha Malawi),
				'other' => q(kwacha Malawi),
				'two' => q(gwacha Malawi),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(peso Mecʼhiko),
				'few' => q(feso Mecʼhiko),
				'many' => q(a besoioù Mecʼhiko),
				'one' => q(peso Mecʼhiko),
				'other' => q(peso Mecʼhiko),
				'two' => q(beso Mecʼhiko),
			},
		},
		'MXP' => {
			symbol => 'MXP',
			display_name => {
				'currency' => q(peso arcʼhant Mecʼhiko \(1861–1992\)),
				'few' => q(feso arcʼhant Mecʼhiko \(1861–1992\)),
				'many' => q(a besoioù arcʼhant Mecʼhiko \(1861–1992\)),
				'one' => q(peso arcʼhant Mecʼhiko \(1861–1992\)),
				'other' => q(peso arcʼhant Mecʼhiko \(1861–1992\)),
				'two' => q(beso arcʼhant Mecʼhiko \(1861–1992\)),
			},
		},
		'MXV' => {
			symbol => 'MXV',
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ringgit Malaysia),
				'few' => q(ringgit Malaysia),
				'many' => q(a ringgitoù Malaysia),
				'one' => q(ringgit Malaysia),
				'other' => q(ringgit Malaysia),
				'two' => q(ringgit Malaysia),
			},
		},
		'MZE' => {
			symbol => 'MZE',
			display_name => {
				'currency' => q(escudo Mozambik),
				'few' => q(escudo Mozambik),
				'many' => q(a escudoioù Mozambik),
				'one' => q(escudo Mozambik),
				'other' => q(escudo Mozambik),
				'two' => q(escudo Mozambik),
			},
		},
		'MZM' => {
			symbol => 'MZM',
			display_name => {
				'currency' => q(metical Mozambik \(1980–2006\)),
				'few' => q(metical Mozambik \(1980–2006\)),
				'many' => q(a veticaloù Mozambik \(1980–2006\)),
				'one' => q(metical Mozambik \(1980–2006\)),
				'other' => q(metical Mozambik \(1980–2006\)),
				'two' => q(vetical Mozambik \(1980–2006\)),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(metical Mozambik),
				'few' => q(metical Mozambik),
				'many' => q(a veticaloù Mozambik),
				'one' => q(metical Mozambik),
				'other' => q(metical Mozambik),
				'two' => q(vetical Mozambik),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(dollar Namibia),
				'few' => q(dollar Namibia),
				'many' => q(a zollaroù Namibia),
				'one' => q(dollar Namibia),
				'other' => q(dollar Namibia),
				'two' => q(zollar Namibia),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(naira Nigeria),
				'few' => q(naira Nigeria),
				'many' => q(a nairaoù Nigeria),
				'one' => q(naira Nigeria),
				'other' => q(naira Nigeria),
				'two' => q(naira Nigeria),
			},
		},
		'NIC' => {
			symbol => 'NIC',
			display_name => {
				'currency' => q(cordoba Nicaragua \(1988–1991\)),
				'few' => q(cʼhordoba Nicaragua \(1988–1991\)),
				'many' => q(a gordobaoù Nicaragua \(1988–1991\)),
				'one' => q(cʼhordoba Nicaragua \(1988–1991\)),
				'other' => q(cordoba Nicaragua \(1988–1991\)),
				'two' => q(gordoba Nicaragua \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(cordoba Nicaragua),
				'few' => q(cʼhordoba Nicaragua),
				'many' => q(a gordobaoù Nicaragua),
				'one' => q(cʼhordoba Nicaragua),
				'other' => q(cordoba Nicaragua),
				'two' => q(gordoba Nicaragua),
			},
		},
		'NLG' => {
			symbol => 'NLG',
			display_name => {
				'currency' => q(florin an Izelvroioù),
				'few' => q(florin an Izelvroioù),
				'many' => q(a florinoù an Izelvroioù),
				'one' => q(florin an Izelvroioù),
				'other' => q(florin an Izelvroioù),
				'two' => q(florin an Izelvroioù),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(kurunenn Norvegia),
				'few' => q(cʼhurunenn Norvegia),
				'many' => q(a gurunennoù Norvegia),
				'one' => q(gurunenn Norvegia),
				'other' => q(kurunenn Norvegia),
				'two' => q(gurunenn Norvegia),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(roupi Nepal),
				'few' => q(roupi Nepal),
				'many' => q(a roupioù Nepal),
				'one' => q(roupi Nepal),
				'other' => q(roupi Nepal),
				'two' => q(roupi Nepal),
			},
		},
		'NZD' => {
			symbol => '$ ZN',
			display_name => {
				'currency' => q(dollar Zeland-Nevez),
				'few' => q(dollar Zeland-Nevez),
				'many' => q(a zollaroù Zeland-Nevez),
				'one' => q(dollar Zeland-Nevez),
				'other' => q(dollar Zeland-Nevez),
				'two' => q(zollar Zeland-Nevez),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(rial Oman),
				'few' => q(rial Oman),
				'many' => q(a rialoù Oman),
				'one' => q(rial Oman),
				'other' => q(rial Oman),
				'two' => q(rial Oman),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(balboa Panamá),
				'few' => q(balboa Panamá),
				'many' => q(a valboaoù Panamá),
				'one' => q(balboa Panamá),
				'other' => q(balboa Panamá),
				'two' => q(valboa Panamá),
			},
		},
		'PEI' => {
			symbol => 'PEI',
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(nuevo sol Perou),
				'few' => q(nuevo sol Perou),
				'many' => q(nuevo sol Perou),
				'one' => q(nuevo sol Perou),
				'other' => q(nuevo sol Perou),
				'two' => q(nuevo sol Perou),
			},
		},
		'PES' => {
			symbol => 'PES',
			display_name => {
				'currency' => q(sol Perou \(1863–1965\)),
				'few' => q(sol Perou \(1863–1965\)),
				'many' => q(a solioù Perou \(1863–1965\)),
				'one' => q(sol Perou \(1863–1965\)),
				'other' => q(sol Perou \(1863–1965\)),
				'two' => q(sol Perou \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(kina Papoua Ginea-Nevez),
				'few' => q(cʼhina Papoua Ginea-Nevez),
				'many' => q(a ginaoù Papoua Ginea-Nevez),
				'one' => q(cʼhina Papoua Ginea-Nevez),
				'other' => q(kina Papoua Ginea-Nevez),
				'two' => q(gina Papoua Ginea-Nevez),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(peso Filipinez),
				'few' => q(feso Filipinez),
				'many' => q(a besoioù Filipinez),
				'one' => q(peso Filipinez),
				'other' => q(peso Filipinez),
				'two' => q(beso Filipinez),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(roupi Pakistan),
				'few' => q(roupi Pakistan),
				'many' => q(a roupioù Pakistan),
				'one' => q(roupi Pakistan),
				'other' => q(roupi Pakistan),
				'two' => q(roupi Pakistan),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(zloty Polonia),
				'few' => q(zloty Polonia),
				'many' => q(a zlotyoù Polonia),
				'one' => q(zloty Polonia),
				'other' => q(zloty Polonia),
				'two' => q(zloty Polonia),
			},
		},
		'PLZ' => {
			symbol => 'PLZ',
			display_name => {
				'currency' => q(zloty Polonia \(1950–1995\)),
				'few' => q(zloty Polonia \(1950–1995\)),
				'many' => q(a zlotyoù Polonia \(1950–1995\)),
				'one' => q(zloty Polonia \(1950–1995\)),
				'other' => q(zloty Polonia \(1950–1995\)),
				'two' => q(zloty Polonia \(1950–1995\)),
			},
		},
		'PTE' => {
			symbol => 'PTE',
			display_name => {
				'currency' => q(escudo Portugal),
				'few' => q(escudo Portugal),
				'many' => q(a escudoioù Portugal),
				'one' => q(escudo Portugal),
				'other' => q(escudo Portugal),
				'two' => q(escudo Portugal),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(guarani Paraguay),
				'few' => q(guarani Paraguay),
				'many' => q(a uaranioù Paraguay),
				'one' => q(guarani Paraguay),
				'other' => q(guarani Paraguay),
				'two' => q(uarani Paraguay),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(rial Qatar),
				'few' => q(rial Qatar),
				'many' => q(a rialoù Qatar),
				'one' => q(rial Qatar),
				'other' => q(rial Qatar),
				'two' => q(rial Qatar),
			},
		},
		'RHD' => {
			symbol => 'RHD',
			display_name => {
				'currency' => q(dollar Rodezia),
				'few' => q(dollar Rodezia),
				'many' => q(a zollaroù Rodezia),
				'one' => q(dollar Rodezia),
				'other' => q(dollar Rodezia),
				'two' => q(zollar Rodezia),
			},
		},
		'ROL' => {
			symbol => 'ROL',
			display_name => {
				'currency' => q(leu Roumania \(1952–2006\)),
				'few' => q(leu Roumania \(1952–2006\)),
				'many' => q(leu Roumania \(1952–2006\)),
				'one' => q(leu Roumania \(1952–2006\)),
				'other' => q(leu Roumania \(1952–2006\)),
				'two' => q(leu Roumania \(1952–2006\)),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(leu Roumania),
				'few' => q(leu Roumania),
				'many' => q(leu Roumania),
				'one' => q(leu Roumania),
				'other' => q(leu Roumania),
				'two' => q(leu Roumania),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(dinar Serbia),
				'few' => q(dinar Serbia),
				'many' => q(a zinaroù Serbia),
				'one' => q(dinar Serbia),
				'other' => q(dinar Serbia),
				'two' => q(zinar Serbia),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(roubl Rusia),
				'few' => q(roubl Rusia),
				'many' => q(a roubloù Rusia),
				'one' => q(roubl Rusia),
				'other' => q(roubl Rusia),
				'two' => q(roubl Rusia),
			},
		},
		'RUR' => {
			symbol => 'RUR',
			display_name => {
				'currency' => q(roubl Rusia \(1991–1998\)),
				'few' => q(roubl Rusia \(1991–1998\)),
				'many' => q(a roubloù Rusia \(1991–1998\)),
				'one' => q(roubl Rusia \(1991–1998\)),
				'other' => q(roubl Rusia \(1991–1998\)),
				'two' => q(roubl Rusia \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(lur Rwanda),
				'few' => q(lur Rwanda),
				'many' => q(a lurioù Rwanda),
				'one' => q(lur Rwanda),
				'other' => q(lur Rwanda),
				'two' => q(lur Rwanda),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(riyal Arabia Saoudat),
				'few' => q(riyal Arabia Saoudat),
				'many' => q(a riyaloù Arabia Saoudat),
				'one' => q(riyal Arabia Saoudat),
				'other' => q(riyal Arabia Saoudat),
				'two' => q(riyal Arabia Saoudat),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(dollar Inizi Salomon),
				'few' => q(dollar Inizi Salomon),
				'many' => q(a zollaroù Inizi Salomon),
				'one' => q(dollar Inizi Salomon),
				'other' => q(dollar Inizi Salomon),
				'two' => q(zollar Inizi Salomon),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(roupi Sechelez),
				'few' => q(roupi Sechelez),
				'many' => q(a roupioù Sechelez),
				'one' => q(roupi Sechelez),
				'other' => q(roupi Sechelez),
				'two' => q(roupi Sechelez),
			},
		},
		'SDD' => {
			symbol => 'SDD',
			display_name => {
				'currency' => q(dinar Soudan \(1992–2007\)),
				'few' => q(dinar Soudan \(1992–2007\)),
				'many' => q(a zinaroù Soudan \(1992–2007\)),
				'one' => q(dinar Soudan \(1992–2007\)),
				'other' => q(dinar Soudan \(1992–2007\)),
				'two' => q(zinar Soudan \(1992–2007\)),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(lur Soudan),
				'few' => q(lur Soudan),
				'many' => q(a lurioù Soudan),
				'one' => q(lur Soudan),
				'other' => q(lur Soudan),
				'two' => q(lur Soudan),
			},
		},
		'SDP' => {
			symbol => 'SDP',
			display_name => {
				'currency' => q(lur Soudan \(1957–1998\)),
				'few' => q(lur Soudan \(1957–1998\)),
				'many' => q(a lurioù Soudan \(1957–1998\)),
				'one' => q(lur Soudan \(1957–1998\)),
				'other' => q(lur Soudan \(1957–1998\)),
				'two' => q(lur Soudan \(1957–1998\)),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(kurunenn Sveden),
				'few' => q(cʼhurunenn Sveden),
				'many' => q(a gurunennoù Sveden),
				'one' => q(gurunenn Sveden),
				'other' => q(kurunenn Sveden),
				'two' => q(gurunenn Sveden),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(dollar Singapour),
				'few' => q(dollar Singapour),
				'many' => q(a zollaroù Singapour),
				'one' => q(dollar Singapour),
				'other' => q(dollar Singapour),
				'two' => q(zollar Singapour),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(lur Saint-Helena),
				'few' => q(lur Saint-Helena),
				'many' => q(a lurioù Saint-Helena),
				'one' => q(lur Saint-Helena),
				'other' => q(lur Saint-Helena),
				'two' => q(lur Saint-Helena),
			},
		},
		'SIT' => {
			symbol => 'SIT',
			display_name => {
				'currency' => q(tolar Slovenia),
				'few' => q(zolar Slovenia),
				'many' => q(a dolaroù Slovenia),
				'one' => q(tolar Slovenia),
				'other' => q(tolar Slovenia),
				'two' => q(dolar Slovenia),
			},
		},
		'SKK' => {
			symbol => 'SKK',
			display_name => {
				'currency' => q(kurunenn Slovakia),
				'few' => q(cʼhurunenn Slovakia),
				'many' => q(a gurunennoù Slovakia),
				'one' => q(gurunenn Slovakia),
				'other' => q(kurunenn Slovakia),
				'two' => q(gurunenn Slovakia),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(leone Sierra Leone),
				'few' => q(leone Sierra Leone),
				'many' => q(a leoneoù Sierra Leone),
				'one' => q(leone Sierra Leone),
				'other' => q(leone Sierra Leone),
				'two' => q(leone Sierra Leone),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(shilling Somalia),
				'few' => q(shilling Somalia),
				'many' => q(a shillingoù Somalia),
				'one' => q(shilling Somalia),
				'other' => q(shilling Somalia),
				'two' => q(shilling Somalia),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(dollar Surinam),
				'few' => q(dollar Surinam),
				'many' => q(a zollaroù Surinam),
				'one' => q(dollar Surinam),
				'other' => q(dollar Surinam),
				'two' => q(zollar Surinam),
			},
		},
		'SRG' => {
			symbol => 'SRG',
			display_name => {
				'currency' => q(florin Surinam),
				'few' => q(florin Surinam),
				'many' => q(a florinoù Surinam),
				'one' => q(florin Surinam),
				'other' => q(florin Surinam),
				'two' => q(florin Surinam),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(lur Susoudan),
				'few' => q(lur Susoudan),
				'many' => q(a lurioù Susoudan),
				'one' => q(lur Susoudan),
				'other' => q(lur Susoudan),
				'two' => q(lur Susoudan),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(dobra São Tomé ha Príncipe),
				'few' => q(dobra São Tomé ha Príncipe),
				'many' => q(a zobraoù São Tomé ha Príncipe),
				'one' => q(dobra São Tomé ha Príncipe),
				'other' => q(dobra São Tomé ha Príncipe),
				'two' => q(zobra São Tomé ha Príncipe),
			},
		},
		'SUR' => {
			symbol => 'SUR',
			display_name => {
				'currency' => q(roubl soviedel),
				'few' => q(roubl soviedel),
				'many' => q(a roubloù soviedel),
				'one' => q(roubl soviedel),
				'other' => q(roubl soviedel),
				'two' => q(roubl soviedel),
			},
		},
		'SVC' => {
			symbol => 'SVC',
			display_name => {
				'currency' => q(colón Salvador),
				'few' => q(cʼholón Salvador),
				'many' => q(a golónoù Salvador),
				'one' => q(cʼholón Salvador),
				'other' => q(colón Salvador),
				'two' => q(golón Salvador),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(lur Siria),
				'few' => q(lur Siria),
				'many' => q(a lurioù Siria),
				'one' => q(lur Siria),
				'other' => q(lur Siria),
				'two' => q(lur Siria),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(lilangeni Swaziland),
				'few' => q(lilangeni Swaziland),
				'many' => q(a lilangenioù Swaziland),
				'one' => q(lilangeni Swaziland),
				'other' => q(lilangeni Swaziland),
				'two' => q(lilangeni Swaziland),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(baht Thailand),
				'few' => q(baht Thailand),
				'many' => q(a vahtoù Thailand),
				'one' => q(baht Thailand),
				'other' => q(baht Thailand),
				'two' => q(vaht Thailand),
			},
		},
		'TJR' => {
			symbol => 'TJR',
			display_name => {
				'currency' => q(roubl Tadjikistan),
				'few' => q(roubl Tadjikistan),
				'many' => q(a roubloù Tadjikistan),
				'one' => q(roubl Tadjikistan),
				'other' => q(roubl Tadjikistan),
				'two' => q(roubl Tadjikistan),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(somoni Tadjikistan),
				'few' => q(somoni Tadjikistan),
				'many' => q(a somonioù Tadjikistan),
				'one' => q(somoni Tadjikistan),
				'other' => q(somoni Tadjikistan),
				'two' => q(somoni Tadjikistan),
			},
		},
		'TMM' => {
			symbol => 'TMM',
			display_name => {
				'currency' => q(manat Turkmenistan \(1993–2009\)),
				'few' => q(manat Turkmenistan \(1993–2009\)),
				'many' => q(a vanatoù Turkmenistan \(1993–2009\)),
				'one' => q(manat Turkmenistan \(1993–2009\)),
				'other' => q(manat Turkmenistan \(1993–2009\)),
				'two' => q(vanat Turkmenistan \(1993–2009\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(manat Turkmenistan),
				'few' => q(manat Turkmenistan),
				'many' => q(a vanatoù Turkmenistan),
				'one' => q(manat Turkmenistan),
				'other' => q(manat Turkmenistan),
				'two' => q(vanat Turkmenistan),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(dinar Tunizia),
				'few' => q(dinar Tunizia),
				'many' => q(a zinaroù Tunizia),
				'one' => q(dinar Tunizia),
				'other' => q(dinar Tunizia),
				'two' => q(zinar Tunizia),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(paʻanga Tonga),
				'few' => q(faʻanga Tonga),
				'many' => q(a baʻangaoù Tonga),
				'one' => q(paʻanga Tonga),
				'other' => q(paʻanga Tonga),
				'two' => q(baʻanga Tonga),
			},
		},
		'TPE' => {
			symbol => 'TPE',
			display_name => {
				'currency' => q(escudo Timor),
				'few' => q(escudo Timor),
				'many' => q(a escudoioù Timor),
				'one' => q(escudo Timor),
				'other' => q(escudo Timor),
				'two' => q(escudo Timor),
			},
		},
		'TRL' => {
			symbol => 'TRL',
			display_name => {
				'currency' => q(lur Turkia \(1922–2005\)),
				'few' => q(lur Turkia \(1922–2005\)),
				'many' => q(a lurioù Turkia \(1922–2005\)),
				'one' => q(lur Turkia \(1922–2005\)),
				'other' => q(lur Turkia \(1922–2005\)),
				'two' => q(lur Turkia \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(lur Turkia),
				'few' => q(lur Turkia),
				'many' => q(a lurioù Turkia),
				'one' => q(lur Turkia),
				'other' => q(lur Turkia),
				'two' => q(lur Turkia),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(dollar Trinidad ha Tobago),
				'few' => q(dollar Trinidad ha Tobago),
				'many' => q(a zollaroù Trinidad ha Tobago),
				'one' => q(dollar Trinidad ha Tobago),
				'other' => q(dollar Trinidad ha Tobago),
				'two' => q(zollar Trinidad ha Tobago),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(dollar nevez Taiwan),
				'few' => q(dollar nevez Taiwan),
				'many' => q(a zollaroù nevez Taiwan),
				'one' => q(dollar nevez Taiwan),
				'other' => q(dollar nevez Taiwan),
				'two' => q(zollar nevez Taiwan),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(shilling Tanzania),
				'few' => q(shilling Tanzania),
				'many' => q(a shillingoù Tanzania),
				'one' => q(shilling Tanzania),
				'other' => q(shilling Tanzania),
				'two' => q(shilling Tanzania),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(hryvnia Ukraina),
				'few' => q(hryvnia Ukraina),
				'many' => q(a hryvniaoù Ukraina),
				'one' => q(hryvnia Ukraina),
				'other' => q(hryvnia Ukraina),
				'two' => q(hryvnia Ukraina),
			},
		},
		'UAK' => {
			symbol => 'UAK',
		},
		'UGS' => {
			symbol => 'UGS',
			display_name => {
				'currency' => q(shilling Ouganda \(1966–1987\)),
				'few' => q(shilling Ouganda \(1966–1987\)),
				'many' => q(a shillingoù Ouganda \(1966–1987\)),
				'one' => q(shilling Ouganda \(1966–1987\)),
				'other' => q(shilling Ouganda \(1966–1987\)),
				'two' => q(shilling Ouganda \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(shilling Ouganda),
				'few' => q(shilling Ouganda),
				'many' => q(a shillingoù Ouganda),
				'one' => q(shilling Ouganda),
				'other' => q(shilling Ouganda),
				'two' => q(shilling Ouganda),
			},
		},
		'USD' => {
			symbol => '$ SU',
			display_name => {
				'currency' => q(dollar SU),
				'few' => q(dollar SU),
				'many' => q(a zollaroù SU),
				'one' => q(dollar SU),
				'other' => q(dollar SU),
				'two' => q(zollar SU),
			},
		},
		'USN' => {
			symbol => 'USN',
		},
		'USS' => {
			symbol => 'USS',
		},
		'UYI' => {
			symbol => 'UYI',
		},
		'UYP' => {
			symbol => 'UYP',
			display_name => {
				'currency' => q(peso Uruguay \(1975–1993\)),
				'few' => q(feso Uruguay \(1975–1993\)),
				'many' => q(a besoioù Uruguay \(1975–1993\)),
				'one' => q(peso Uruguay \(1975–1993\)),
				'other' => q(peso Uruguay \(1975–1993\)),
				'two' => q(beso Uruguay \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(peso Uruguay),
				'few' => q(feso Uruguay),
				'many' => q(a besoioù Uruguay),
				'one' => q(peso Uruguay),
				'other' => q(peso Uruguay),
				'two' => q(beso Uruguay),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(som Ouzbekistan),
				'few' => q(som Ouzbekistan),
				'many' => q(a somoù Ouzbekistan),
				'one' => q(som Ouzbekistan),
				'other' => q(som Ouzbekistan),
				'two' => q(som Ouzbekistan),
			},
		},
		'VEB' => {
			symbol => 'VEB',
			display_name => {
				'currency' => q(bolivar Venezuela \(1871–2008\)),
				'few' => q(bolivar Venezuela \(1871–2008\)),
				'many' => q(a volivaroù Venezuela \(1871–2008\)),
				'one' => q(bolivar Venezuela \(1871–2008\)),
				'other' => q(bolivar Venezuela \(1871–2008\)),
				'two' => q(volivar Venezuela \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(bolivar Venezuela),
				'few' => q(bolivar Venezuela),
				'many' => q(a volivaroù Venezuela),
				'one' => q(bolivar Venezuela),
				'other' => q(bolivar Venezuela),
				'two' => q(volivar Venezuela),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(dong Viêt Nam),
				'few' => q(dong Viêt Nam),
				'many' => q(a zongoù Viêt Nam),
				'one' => q(dong Viêt Nam),
				'other' => q(dong Viêt Nam),
				'two' => q(zong Viêt Nam),
			},
		},
		'VNN' => {
			symbol => 'VNN',
			display_name => {
				'currency' => q(dong Viêt Nam \(1978–1985\)),
				'few' => q(dong Viêt Nam \(1978–1985\)),
				'many' => q(a zongoù Viêt Nam \(1978–1985\)),
				'one' => q(dong Viêt Nam \(1978–1985\)),
				'other' => q(dong Viêt Nam \(1978–1985\)),
				'two' => q(zong Viêt Nam \(1978–1985\)),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(vatu Vanuatu),
				'few' => q(vatu Vanuatu),
				'many' => q(a vatuoù Vanuatu),
				'one' => q(vatu Vanuatu),
				'other' => q(vatu Vanuatu),
				'two' => q(vatu Vanuatu),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(tala Samoa),
				'few' => q(zala Samoa),
				'many' => q(a dalaoù Samoa),
				'one' => q(tala Samoa),
				'other' => q(tala Samoa),
				'two' => q(dala Samoa),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(lur CFA Kreizafrika),
				'few' => q(lur CFA Kreizafrika),
				'many' => q(lur CFA Kreizafrika),
				'one' => q(lur CFA Kreizafrika),
				'other' => q(lur CFA Kreizafrika),
				'two' => q(lur CFA Kreizafrika),
			},
		},
		'XAG' => {
			symbol => 'XAG',
			display_name => {
				'currency' => q(arcʼhant),
			},
		},
		'XAU' => {
			symbol => 'XAU',
			display_name => {
				'currency' => q(aour),
			},
		},
		'XBA' => {
			symbol => 'XBA',
			display_name => {
				'currency' => q(unanenn genaoz europat),
				'few' => q(unanenn genaoz europat),
				'many' => q(a unanennoù kenaoz europat),
				'one' => q(unanenn genaoz europat),
				'other' => q(unanenn genaoz europat),
				'two' => q(unanenn genaoz europat),
			},
		},
		'XBB' => {
			symbol => 'XBB',
			display_name => {
				'currency' => q(unanenn voneiz europat),
				'few' => q(unanenn voneiz europat),
				'many' => q(a unanennoù moneiz europat),
				'one' => q(unanenn voneiz europat),
				'other' => q(unanenn voneiz europat),
				'two' => q(unanenn voneiz europat),
			},
		},
		'XBC' => {
			symbol => 'XBC',
			display_name => {
				'currency' => q(unanenn jediñ europat \(XBC\)),
				'few' => q(unanenn jediñ europat \(XBC\)),
				'many' => q(a unanennoù jediñ europat \(XBC\)),
				'one' => q(unanenn jediñ europat \(XBC\)),
				'other' => q(unanenn jediñ europat \(XBC\)),
				'two' => q(unanenn jediñ europat \(XBC\)),
			},
		},
		'XBD' => {
			symbol => 'XBD',
			display_name => {
				'currency' => q(unanenn jediñ europat \(XBD\)),
				'few' => q(unanenn jediñ europat \(XBD\)),
				'many' => q(a unanennoù jediñ europat \(XBD\)),
				'one' => q(unanenn jediñ europat \(XBD\)),
				'other' => q(unanenn jediñ europat \(XBD\)),
				'two' => q(unanenn jediñ europat \(XBD\)),
			},
		},
		'XCD' => {
			symbol => 'XCD',
			display_name => {
				'currency' => q(dollar Karib ar reter),
				'few' => q(dollar Karib ar reter),
				'many' => q(a zollaroù Karib ar reter),
				'one' => q(dollar Karib ar reter),
				'other' => q(dollar Karib ar reter),
				'two' => q(zollar Karib ar reter),
			},
		},
		'XDR' => {
			symbol => 'XDR',
			display_name => {
				'currency' => q(gwirioù tennañ arbennik),
				'few' => q(gwirioù tennañ arbennik),
				'many' => q(gwirioù tennañ arbennik),
				'one' => q(gwirioù tennañ arbennik),
				'other' => q(gwirioù tennañ arbennik),
				'two' => q(gwirioù tennañ arbennik),
			},
		},
		'XEU' => {
			symbol => 'XEU',
			display_name => {
				'currency' => q(unanenn jediñ europat),
				'few' => q(unanenn jediñ europat),
				'many' => q(a unanennoù jediñ europat),
				'one' => q(unanenn jediñ europat),
				'other' => q(unanenn jediñ europat),
				'two' => q(unanenn jediñ europat),
			},
		},
		'XFO' => {
			symbol => 'XFO',
			display_name => {
				'currency' => q(lur aour Frañs),
				'few' => q(lur aour Frañs),
				'many' => q(a lurioù aour Frañs),
				'one' => q(lur aour Frañs),
				'other' => q(lur aour Frañs),
				'two' => q(lur aour Frañs),
			},
		},
		'XFU' => {
			symbol => 'XFU',
			display_name => {
				'currency' => q(lur Unaniezh etrebroadel an hentoù-houarn),
				'few' => q(lur Unaniezh etrebroadel an hentoù-houarn),
				'many' => q(a lurioù Unaniezh etrebroadel an hentoù-houarn),
				'one' => q(lur Unaniezh etrebroadel an hentoù-houarn),
				'other' => q(lur Unaniezh etrebroadel an hentoù-houarn),
				'two' => q(lur Unaniezh etrebroadel an hentoù-houarn),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(lur CFA Afrika ar Cʼhornôg),
				'few' => q(lur CFA BCEAO),
				'many' => q(a lurioù CFA BCEAO),
				'one' => q(lur CFA Afrika ar Cʼhornôg),
				'other' => q(lur CFA Afrika ar Cʼhornôg),
				'two' => q(lur CFA BCEAO),
			},
		},
		'XPD' => {
			symbol => 'XPD',
			display_name => {
				'currency' => q(palladiom),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(lur CFP),
				'few' => q(lur CFP),
				'many' => q(a lurioù CFP),
				'one' => q(lur CFP),
				'other' => q(lur CFP),
				'two' => q(lur CFP),
			},
		},
		'XPT' => {
			symbol => 'XPT',
			display_name => {
				'currency' => q(platin),
			},
		},
		'XRE' => {
			symbol => 'XRE',
		},
		'XSU' => {
			symbol => 'XSU',
		},
		'XTS' => {
			symbol => 'XTS',
			display_name => {
				'currency' => q(kod moneiz amprouiñ),
				'few' => q(unanenn voneiz amprouiñ),
				'many' => q(a unanennoù voneiz amprouiñ),
				'one' => q(unanenn voneiz amprouiñ),
				'other' => q(unanenn voneiz amprouiñ),
				'two' => q(unanenn voneiz amprouiñ),
			},
		},
		'XXX' => {
			symbol => 'XXX',
			display_name => {
				'currency' => q(moneiz dianav),
				'few' => q(\(moneiz dianav\)),
				'many' => q(\(moneiz dianav\)),
				'one' => q(\(moneiz dianav\)),
				'other' => q(\(moneiz dianav\)),
				'two' => q(\(moneiz dianav\)),
			},
		},
		'YDD' => {
			symbol => 'YDD',
			display_name => {
				'currency' => q(dinar Yemen),
				'few' => q(dinar Yemen),
				'many' => q(a zinaroù Yemen),
				'one' => q(dinar Yemen),
				'other' => q(dinar Yemen),
				'two' => q(zinar Yemen),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(rial Yemen),
				'few' => q(rial Yemen),
				'many' => q(a rialoù Yemen),
				'one' => q(rial Yemen),
				'other' => q(rial Yemen),
				'two' => q(rial Yemen),
			},
		},
		'YUD' => {
			symbol => 'YUD',
		},
		'YUM' => {
			symbol => 'YUM',
			display_name => {
				'currency' => q(dinar nevez Yougoslavia \(1994–2002\)),
				'few' => q(dinar nevez Yougoslavia \(1994–2002\)),
				'many' => q(a zinaroù nevez Yougoslavia \(1994–2002\)),
				'one' => q(dinar nevez Yougoslavia \(1994–2002\)),
				'other' => q(dinar nevez Yougoslavia \(1994–2002\)),
				'two' => q(zinar nevez Yougoslavia \(1994–2002\)),
			},
		},
		'YUN' => {
			symbol => 'YUN',
			display_name => {
				'currency' => q(dinar kemmadus Yougoslavia \(1990–1992\)),
				'few' => q(dinar kemmadus Yougoslavia \(1990–1992\)),
				'many' => q(a zinaroù kemmadus Yougoslavia \(1990–1992\)),
				'one' => q(dinar kemmadus Yougoslavia \(1990–1992\)),
				'other' => q(dinar kemmadus Yougoslavia \(1990–1992\)),
				'two' => q(zinar kemmadus Yougoslavia \(1990–1992\)),
			},
		},
		'YUR' => {
			symbol => 'YUR',
			display_name => {
				'currency' => q(dinar adreizhet Yougoslavia \(1992–1993\)),
				'few' => q(dinar adreizhet Yougoslavia \(1992–1993\)),
				'many' => q(a zinaroù adreizhet Yougoslavia \(1992–1993\)),
				'one' => q(dinar adreizhet Yougoslavia \(1992–1993\)),
				'other' => q(dinar adreizhet Yougoslavia \(1992–1993\)),
				'two' => q(zinar adreizhet Yougoslavia \(1992–1993\)),
			},
		},
		'ZAL' => {
			symbol => 'ZAL',
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(rand Suafrika),
				'few' => q(rand Suafrika),
				'many' => q(a randoù Suafrika),
				'one' => q(rand Suafrika),
				'other' => q(rand Suafrika),
				'two' => q(rand Suafrika),
			},
		},
		'ZMK' => {
			symbol => 'ZMK',
			display_name => {
				'currency' => q(kwacha Zambia \(1968–2012\)),
				'few' => q(kwacha Zambia \(1968–2012\)),
				'many' => q(a gwachaoù Zambia \(1968–2012\)),
				'one' => q(cʼhwacha Zambia \(1968–2012\)),
				'other' => q(kwacha Zambia \(1968–2012\)),
				'two' => q(gwacha Zambia \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(kwacha Zambia),
				'few' => q(kwacha Zambia),
				'many' => q(a gwachaoù Zambia),
				'one' => q(cʼhwacha Zambia),
				'other' => q(kwacha Zambia),
				'two' => q(gwacha Zambia),
			},
		},
		'ZRN' => {
			symbol => 'ZRN',
		},
		'ZRZ' => {
			symbol => 'ZRZ',
		},
		'ZWD' => {
			symbol => 'ZWD',
			display_name => {
				'currency' => q(dollar Zimbabwe \(1980–2008\)),
				'few' => q(dollar Zimbabwe \(1980–2008\)),
				'many' => q(a zollaroù Zimbabwe \(1980–2008\)),
				'one' => q(dollar Zimbabwe \(1980–2008\)),
				'other' => q(dollar Zimbabwe \(1980–2008\)),
				'two' => q(zollar Zimbabwe \(1980–2008\)),
			},
		},
		'ZWL' => {
			symbol => 'ZWL',
			display_name => {
				'currency' => q(dollar Zimbabwe \(2009\)),
				'few' => q(dollar Zimbabwe \(2009\)),
				'many' => q(a zollaroù Zimbabwe \(2009\)),
				'one' => q(dollar Zimbabwe \(2009\)),
				'other' => q(dollar Zimbabwe \(2009\)),
				'two' => q(zollar Zimbabwe \(2009\)),
			},
		},
		'ZWR' => {
			symbol => 'ZWR',
			display_name => {
				'currency' => q(dollar Zimbabwe \(2008\)),
				'few' => q(dollar Zimbabwe \(2008\)),
				'many' => q(a zollaroù Zimbabwe \(2008\)),
				'one' => q(dollar Zimbabwe \(2008\)),
				'other' => q(dollar Zimbabwe \(2008\)),
				'two' => q(zollar Zimbabwe \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Gen.',
							'Cʼhwe.',
							'Meur.',
							'Ebr.',
							'Mae',
							'Mezh.',
							'Goue.',
							'Eost',
							'Gwen.',
							'Here',
							'Du',
							'Kzu.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'01',
							'02',
							'03',
							'04',
							'05',
							'06',
							'07',
							'08',
							'09',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Genver',
							'Cʼhwevrer',
							'Meurzh',
							'Ebrel',
							'Mae',
							'Mezheven',
							'Gouere',
							'Eost',
							'Gwengolo',
							'Here',
							'Du',
							'Kerzu'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Gen.',
							'Cʼhwe.',
							'Meur.',
							'Ebr.',
							'Mae',
							'Mezh.',
							'Goue.',
							'Eost',
							'Gwen.',
							'Here',
							'Du',
							'Ker.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'01',
							'02',
							'03',
							'04',
							'05',
							'06',
							'07',
							'08',
							'09',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Genver',
							'Cʼhwevrer',
							'Meurzh',
							'Ebrel',
							'Mae',
							'Mezheven',
							'Gouere',
							'Eost',
							'Gwengolo',
							'Here',
							'Du',
							'Kerzu'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Lun',
						tue => 'Meu.',
						wed => 'Mer.',
						thu => 'Yaou',
						fri => 'Gwe.',
						sat => 'Sad.',
						sun => 'Sul'
					},
					narrow => {
						mon => 'L',
						tue => 'Mz',
						wed => 'Mc',
						thu => 'Y',
						fri => 'G',
						sat => 'Sa',
						sun => 'Su'
					},
					wide => {
						mon => 'Lun',
						tue => 'Meurzh',
						wed => 'Mercʼher',
						thu => 'Yaou',
						fri => 'Gwener',
						sat => 'Sadorn',
						sun => 'Sul'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'Lun',
						tue => 'Meu.',
						wed => 'Mer.',
						thu => 'Yaou',
						fri => 'Gwe.',
						sat => 'Sad.',
						sun => 'Sul'
					},
					narrow => {
						mon => 'L',
						tue => 'Mz',
						wed => 'Mc',
						thu => 'Y',
						fri => 'G',
						sat => 'Sa',
						sun => 'Su'
					},
					wide => {
						mon => 'Lun',
						tue => 'Meurzh',
						wed => 'Mercʼher',
						thu => 'Yaou',
						fri => 'Gwener',
						sat => 'Sadorn',
						sun => 'Sul'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1añ trim.',
						1 => '2l trim.',
						2 => '3e trim.',
						3 => '4e trim.'
					},
					wide => {0 => '1añ trimiziad',
						1 => '2l trimiziad',
						2 => '3e trimiziad',
						3 => '4e trimiziad'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1añ trim.',
						1 => '2l trim.',
						2 => '3e trim.',
						3 => '4e trim.'
					},
					wide => {0 => '1añ trimiziad',
						1 => '2l trimiziad',
						2 => '3e trimiziad',
						3 => '4e trimiziad'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'pm' => q{gm},
					'am' => q{am},
				},
				'abbreviated' => {
					'am' => q{A.M.},
					'pm' => q{G.M.},
				},
				'wide' => {
					'am' => q{A.M.},
					'pm' => q{G.M.},
				},
			},
			'stand-alone' => {
				'wide' => {
					'am' => q{a-raok merenn},
					'pm' => q{goude merenn},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			abbreviated => {
				'0' => 'a-raok J.K.',
				'1' => 'goude J.K.'
			},
			narrow => {
				'0' => 'a-raok J.K.',
				'1' => 'goude J.K.'
			},
			wide => {
				'0' => 'a-raok Jezuz-Krist',
				'1' => 'goude Jezuz-Krist'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'a-raok R.S.',
				'1' => 'R.S.'
			},
			narrow => {
				'0' => 'a-raok R.S.',
				'1' => 'R.S.'
			},
			wide => {
				'0' => 'a-raok Republik Sina',
				'1' => 'Republik Sina'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
		'roc' => {
			'full' => q{G y MMMM d, EEEE},
			'short' => q{GGGGG y-MM-dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'full' => q{{1} 'da' {0}},
			'long' => q{{1} 'da' {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{MM},
			MEd => q{E dd/MM},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMd => q{d MMM},
			Md => q{dd/MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM/y},
			yMEd => q{E dd/MM/y},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMd => q{d MMM y},
			yMd => q{dd/MM/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'roc' => {
			fallback => '{0} – {1}',
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{E dd/MM – E dd/MM},
				d => q{E dd/MM – E dd/MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E d MMM – E d MMM},
				d => q{E d MMM – E d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd/MM – dd/MM},
				d => q{dd/MM – dd/MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM/y – MM/y},
				y => q{MM/y – MM/y},
			},
			yMEd => {
				M => q{E dd/MM/y – E dd/MM/y},
				d => q{E dd/MM/y – E dd/MM/y},
				y => q{E dd/MM/y – E dd/MM/y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E d MMM – E d MMM y},
				d => q{E d MMM – E d MMM y},
				y => q{E d MMM y – E d MMM y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{dd/MM/y – dd/MM/y},
				d => q{dd/MM/y – dd/MM/y},
				y => q{dd/MM/y – dd/MM/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(UTC),
		regionFormat => q(eur {0}),
		regionFormat => q(eur hañv {0}),
		regionFormat => q(eur cʼhoañv {0}),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(eur Afghanistan),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Abidjan#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Accra#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Adis Abeba#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Aljer#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Asmara#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Bamako#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Bangui#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Banjul#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Bissau#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Brazzaville#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Bujumbura#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Kaero#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Dar el Beida (Casablanca)#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Conakry#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Dakar#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Dar es Salaam#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Djibouti#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#LaʼYoun#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Freetown#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Gaborone#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Harare#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Johannesburg#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Juba#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Kampala#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Khartoum#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Kigali#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Kinshasa#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Lagos#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Libreville#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Lomé#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Luanda#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Lubumbashi#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Lusaka#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Malabo#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Maputo#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Maseru#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Mbabane#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Muqdisho#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Monrovia#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Nairobi#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#NʼDjamena#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Niamey#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Nouakchott#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Ouagadougou#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Porto-Novo#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#São Tomé#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Tarabulus (Tripoli)#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Tuniz#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Windhoek#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(eur Kreizafrika),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(eur Afrika ar Reter),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(eur cʼhoañv Suafrika),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(eur hañv Afrika ar Cʼhornôg),
				'generic' => q(eur Afrika ar Cʼhornôg),
				'standard' => q(eur cʼhoañv Afrika ar Cʼhornôg),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(eur hañv Alaska),
				'generic' => q(eur Alaska),
				'standard' => q(eur cʼhoañv Alaska),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(eur hañv Almaty),
				'generic' => q(eur Almaty),
				'standard' => q(eur cʼhoañv Almaty),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(eur hañv an Amazon),
				'generic' => q(eur an Amazon),
				'standard' => q(eur cʼhoañv an Amazon),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Adak#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Anchorage#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Anguilla#,
		},
		'America/Antigua' => {
			exemplarCity => q#Antigua#,
		},
		'America/Aruba' => {
			exemplarCity => q#Aruba#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Asunción#,
		},
		'America/Barbados' => {
			exemplarCity => q#Barbados#,
		},
		'America/Belem' => {
			exemplarCity => q#Belém#,
		},
		'America/Belize' => {
			exemplarCity => q#Belize#,
		},
		'America/Bogota' => {
			exemplarCity => q#Bogotá#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Buenos Aires#,
		},
		'America/Caracas' => {
			exemplarCity => q#Caracas#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Cayenne#,
		},
		'America/Cayman' => {
			exemplarCity => q#Cayman#,
		},
		'America/Chicago' => {
			exemplarCity => q#Chicago#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Costa Rica#,
		},
		'America/Denver' => {
			exemplarCity => q#Denver#,
		},
		'America/Dominica' => {
			exemplarCity => q#Dominica#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Edmonton#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Salvador#,
		},
		'America/Godthab' => {
			exemplarCity => q#Nuuk (Godthåb)#,
		},
		'America/Grenada' => {
			exemplarCity => q#Grenada#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Gwadeloup#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Guatemala#,
		},
		'America/Guyana' => {
			exemplarCity => q#Guyana#,
		},
		'America/Havana' => {
			exemplarCity => q#La Habana#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Inuvik#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Jamaika#,
		},
		'America/La_Paz' => {
			exemplarCity => q#La Paz#,
		},
		'America/Lima' => {
			exemplarCity => q#Lima#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Los Angeles#,
		},
		'America/Managua' => {
			exemplarCity => q#Managua#,
		},
		'America/Manaus' => {
			exemplarCity => q#Manaus#,
		},
		'America/Martinique' => {
			exemplarCity => q#Martinik#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Kêr Vecʼhiko#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Mikelon#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Monterrey#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Montevideo#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Montserrat#,
		},
		'America/Nassau' => {
			exemplarCity => q#Nassau#,
		},
		'America/New_York' => {
			exemplarCity => q#New York#,
		},
		'America/Panama' => {
			exemplarCity => q#Panamá#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Paramaribo#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Port-au-Prince#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Port of Spain#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Puerto Rico#,
		},
		'America/Recife' => {
			exemplarCity => q#Recife#,
		},
		'America/Santiago' => {
			exemplarCity => q#Santiago#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#São Paulo#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Saint Barthélemy#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Saint Johnʼs#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Saint Kitts#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Saint Lucia#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Sant Visant#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Tegucigalpa#,
		},
		'America/Thule' => {
			exemplarCity => q#Qânâq#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Vancouver#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Winnipeg#,
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(eur hañv ar Reter),
				'generic' => q(eur ar Reter),
				'standard' => q(eur cʼhoañv ar Reter),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(eur hañv ar Menezioù),
				'generic' => q(eur ar Menezioù),
				'standard' => q(eur cʼhoañv ar Menezioù),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(eur hañv Anadyrʼ),
				'generic' => q(eur Anadyrʼ),
				'standard' => q(eur cʼhoañv Anadyrʼ),
			},
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Macquarie#,
		},
		'Apia' => {
			long => {
				'daylight' => q(eur hañv Apia),
				'generic' => q(eur Apia),
				'standard' => q(eur cʼhoañv Apia),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(eur hañv Arabia),
				'generic' => q(eur Arabia),
				'standard' => q(eur cʼhoañv Arabia),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Longyearbyen#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(eur hañv Arcʼhantina),
				'generic' => q(eur Arcʼhantina),
				'standard' => q(eur cʼhoañv Arcʼhantina),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(eur hañv Arcʼhantina ar Cʼhornôg),
				'generic' => q(eur Arcʼhantina ar Cʼhornôg),
				'standard' => q(eur cʼhoañv Arcʼhantina ar Cʼhornôg),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(eur hañv Armenia),
				'generic' => q(eur Armenia),
				'standard' => q(eur cʼhoañv Armenia),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Aden#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Almaty#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Amman#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Anadyrʼ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ashgabat#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Baghdad#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Bahrein#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Bakou#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Bangkok#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Bayrut#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Bishkek#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Brunei#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Calcutta#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Kolamba#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Damask#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Dushanbe#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Gaza#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Hong Kong#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Irkutsk#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Jakarta#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Jayapura#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Jeruzalem#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Kaboul#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Karachi#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Kathmandu#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Kuala Lumpur#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Koweit#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Macau#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Manila#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Masqat#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Levkosía#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Novosibirsk#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Phnum Pénh#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Pʼyongyang#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Qatar#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Yangon#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Riyadh#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Kêr Hô-Chi-Minh#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Sakhalin#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Seoul#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Shanghai#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Singapour#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Taipei#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Toshkent#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Tbilisi#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Tehran#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Thimphu#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Tokyo#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Ulaanbaatar#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Ürümqi#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Viangchan#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Vladivostok#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Yakutsk#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Yekaterinbourg#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Yerevan#,
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Azorez#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Bermudez#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Kanariez#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Kab Glas#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Faero#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Madeira#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Reykjavík#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Georgia ar Su#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Saint Helena#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Adelaide#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Brisbane#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Darwin#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Melbourne#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Perth#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Sydney#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(eur hañv Kreizaostralia),
				'generic' => q(eur Kreizaostralia),
				'standard' => q(eur cʼhoañv Kreizaostralia),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(eur hañv Kreizaostralia ar Cʼhornôg),
				'generic' => q(eur Kreizaostralia ar Cʼhornôg),
				'standard' => q(eur cʼhoañv Kreizaostralia ar Cʼhornôg),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(eur hañv Aostralia ar Reter),
				'generic' => q(eur Aostralia ar Reter),
				'standard' => q(eur cʼhoañv Aostralia ar Reter),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(eur hañv Aostralia ar Cʼhornôg),
				'generic' => q(eur Aostralia ar Cʼhornôg),
				'standard' => q(eur cʼhoañv Aostralia ar Cʼhornôg),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(eur hañv Azerbaidjan),
				'generic' => q(eur Azerbaidjan),
				'standard' => q(eur cʼhoañv Azerbaidjan),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(eur hañv an Azorez),
				'generic' => q(eur an Azorez),
				'standard' => q(eur cʼhoañv an Azorez),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(eur hañv Bangladesh),
				'generic' => q(eur Bangladesh),
				'standard' => q(eur cʼhoañv Bangladesh),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(eur Bhoutan),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(eur Bolivia),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(eur hañv Brasília),
				'generic' => q(eur Brasília),
				'standard' => q(eur cʼhoañv Brasília),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(eur Brunei Darussalam),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(eur hañv ar Cʼhab-Glas),
				'generic' => q(eur ar Cʼhab-Glas),
				'standard' => q(eur cʼhoañv ar Cʼhab-Glas),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(eur hañv Chatham),
				'generic' => q(eur Chatham),
				'standard' => q(eur cʼhoañv Chatham),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(eur hañv Chile),
				'generic' => q(eur Chile),
				'standard' => q(eur cʼhoañv Chile),
			},
		},
		'China' => {
			long => {
				'daylight' => q(eur hañv Sina),
				'generic' => q(eur Sina),
				'standard' => q(eur cʼhoañv Sina),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(eur Enez Christmas),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(eur Inizi Kokoz),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(eur hañv Kolombia),
				'generic' => q(eur Kolombia),
				'standard' => q(eur cʼhoañv Kolombia),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(eur hañv Inizi Cook),
				'generic' => q(eur Inizi Cook),
				'standard' => q(eur cʼhoañv Inizi Cook),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(eur hañv Kuba),
				'generic' => q(eur Kuba),
				'standard' => q(eur cʼhoañv Kuba),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(eur Timor ar Reter),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(eur hañv Enez Pask),
				'generic' => q(eur Enez Pask),
				'standard' => q(eur cʼhoañv Enez Pask),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(eur Ecuador),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#kêr dianav#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Amsterdam#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Andorra#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Aten#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Beograd#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Berlin#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Bratislava#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Brusel#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Bukarest#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Budapest#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Chisinau#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Kopenhagen#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Dulenn#,
			long => {
				'daylight' => q(eur cʼhoañv Iwerzhon),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Jibraltar#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Gwernenez#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Helsinki#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Manav#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Istanbul#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Jerzenez#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Kaliningrad#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Kiev#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Lisboa#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Ljubljana#,
		},
		'Europe/London' => {
			exemplarCity => q#Londrez#,
			long => {
				'daylight' => q(eur hañv Breizh-Veur),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Luksembourg#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Madrid#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Malta#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Marjehamn#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Mensk#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Monaco#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Moskov#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Oslo#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Pariz#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Podgorica#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Praha#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Riga#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Roma#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#San Marino#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Sarajevo#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Skopje#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Sofia#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Stockholm#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Tallinn#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Tiranë#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Vaduz#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Vatikan#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Vienna#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Vilnius#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Volgograd#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Varsovia#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Zagreb#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(eur hañv Kreizeuropa),
				'generic' => q(eur Kreizeuropa),
				'standard' => q(eur cʼhoañv Kreizeuropa),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(eur hañv Europa ar Reter),
				'generic' => q(eur Europa ar Reter),
				'standard' => q(eur cʼhoañv Europa ar Reter),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(eur hañv Europa ar Cʼhornôg),
				'generic' => q(eur Europa ar Cʼhornôg),
				'standard' => q(eur cʼhoañv Europa ar Cʼhornôg),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(eur hañv Inizi Falkland),
				'generic' => q(eur Inizi Falkland),
				'standard' => q(eur cʼhoañv Inizi Falkland),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(eur hañv Fidji),
				'generic' => q(eur Fidji),
				'standard' => q(eur cʼhoañv Fidji),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(eur Gwiana cʼhall),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(eur Douaroù aostral Frañs hag Antarktika),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Amzer keitat Greenwich (AKG)),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(eur Inizi Galápagos),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(eur Gambier),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(eur hañv Jorjia),
				'generic' => q(eur Jorjia),
				'standard' => q(eur cʼhoañv Jorjia),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(eur hañv Greunland ar Reter),
				'generic' => q(eur Greunland ar Reter),
				'standard' => q(eur cʼhoañv Greunland ar Reter),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(eur hañv Greunland ar Cʼhornôg),
				'generic' => q(eur Greunland ar Cʼhornôg),
				'standard' => q(eur cʼhoañv Greunland ar Cʼhornôg),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(eur cʼhoañv Guam),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(eur cʼhoañv ar Pleg-mor Arab-ha-Pers),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(eur Guyana),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(eur hañv Hong Kong),
				'generic' => q(eur Hong Kong),
				'standard' => q(eur cʼhoañv Hong Kong),
			},
		},
		'India' => {
			long => {
				'standard' => q(eur cʼhoañv India),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Antananarivo#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Chagos#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Christmas#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Kokoz#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Komorez#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Kergelenn#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Maldivez#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Moris#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Mayotte#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Reünion#,
		},
		'Indochina' => {
			long => {
				'standard' => q(eur Indez-Sina),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(eur Indonezia ar Reter),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(eur Indonezia ar Cʼhornôg),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(eur hañv Iran),
				'generic' => q(eur Iran),
				'standard' => q(eur cʼhoañv Iran),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(eur hañv Irkutsk),
				'generic' => q(eur Irkutsk),
				'standard' => q(eur cʼhoañv Irkutsk),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(eur hañv Israel),
				'generic' => q(eur Israel),
				'standard' => q(eur cʼhoañv Israel),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(eur hañv Japan),
				'generic' => q(eur Japan),
				'standard' => q(eur cʼhoañv Japan),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(eur Kazakstan ar Reter),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(eur Kazakstan ar Cʼhornôg),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(eur hañv Korea),
				'generic' => q(eur Korea),
				'standard' => q(eur cʼhoañv Korea),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(eur Kyrgyzstan),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(eur Sri Lanka),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(eur hañv Macau),
				'generic' => q(eur Macau),
				'standard' => q(eur cʼhoañv Macau),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(eur Enez Macquarie),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(eur Malaysia),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(eur ar Maldivez),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(eur Inizi Markiz),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(eur Inizi Marshall),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(eur hañv Moris),
				'generic' => q(eur Moris),
				'standard' => q(eur cʼhoañv Moris),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(eur hañv Gwalarn Mecʼhiko),
				'generic' => q(eur Gwalarn Mecʼhiko),
				'standard' => q(eur cʼhoañv Gwalarn Mecʼhiko),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(eur hañv Ulaanbaatar),
				'generic' => q(eur Ulaanbaatar),
				'standard' => q(eur cʼhoañv Ulaanbaatar),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(eur hañv Moskov),
				'generic' => q(eur Moskov),
				'standard' => q(eur cʼhoañv Moskov),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(eur Myanmar),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(eur Nauru),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(eur Nepal),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(eur hañv Kaledonia Nevez),
				'generic' => q(eur Kaledonia Nevez),
				'standard' => q(eur cʼhoañv Kaledonia Nevez),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(eur hañv Zeland-Nevez),
				'generic' => q(eur Zeland-Nevez),
				'standard' => q(eur cʼhoañv Zeland-Nevez),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(eur hañv Newfoundland),
				'generic' => q(eur Newfoundland),
				'standard' => q(eur cʼhoañv Newfoundland),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(eur Niue),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(eur Enez Norfolk),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(eur hañv Novosibirsk),
				'generic' => q(eur Novosibirsk),
				'standard' => q(eur cʼhoañv Novosibirsk),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Apia#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Auckland#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Bougainville#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Chatham#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Enez Pask#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Fidji#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Galápagos#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Gambier#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Guam#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Honolulu#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Markiz#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Midway#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Nauru#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Niue#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Norfolk#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Noumea#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Pago Pago#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Palau#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Pitcairn#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Port Moresby#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Rarotonga#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Tahiti#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Wallis#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(eur hañv Pakistan),
				'generic' => q(eur Pakistan),
				'standard' => q(eur cʼhoañv Pakistan),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(eur Palau),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(eur hañv Paraguay),
				'generic' => q(eur Paraguay),
				'standard' => q(eur cʼhoañv Paraguay),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(eur hañv Perou),
				'generic' => q(eur Perou),
				'standard' => q(eur cʼhoañv Perou),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(eur hañv ar Filipinez),
				'generic' => q(eur ar Filipinez),
				'standard' => q(eur cʼhoañv ar Filipinez),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(eur hañv Sant-Pêr-ha-Mikelon),
				'generic' => q(eur Sant-Pêr-ha-Mikelon),
				'standard' => q(eur cʼhoañv Sant-Pêr-ha-Mikelon),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(eur Pitcairn),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(eur ar Reünion),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(eur hañv Sakhalin),
				'generic' => q(eur Sakhalin),
				'standard' => q(eur cʼhoañv Sakhalin),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(eur hañv Samoa),
				'generic' => q(eur Samoa),
				'standard' => q(eur cʼhoañv Samoa),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(eur Sechelez),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(eur cʼhoañv Singapour),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(eur Inizi Salomon),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(eur Georgia ar Su),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(eur Surinam),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(eur Tahiti),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(eur hañv Taipei),
				'generic' => q(eur Taipei),
				'standard' => q(eur cʼhoañv Taipei),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(eur Tadjikistan),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(eur Tokelau),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(eur hañv Tonga),
				'generic' => q(eur Tonga),
				'standard' => q(eur cʼhoañv Tonga),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(eur hañv Turkmenistan),
				'generic' => q(eur Turkmenistan),
				'standard' => q(eur cʼhoañv Turkmenistan),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(eur Tuvalu),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(eur hañv Uruguay),
				'generic' => q(eur Uruguay),
				'standard' => q(eur cʼhoañv Uruguay),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(eur hañv Ouzbekistan),
				'generic' => q(eur Ouzbekistan),
				'standard' => q(eur cʼhoañv Ouzbekistan),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(eur hañv Vanuatu),
				'generic' => q(eur Vanuatu),
				'standard' => q(eur cʼhoañv Vanuatu),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(eur Venezuela),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(eur hañv Vladivostok),
				'generic' => q(eur Vladivostok),
				'standard' => q(eur cʼhoañv Vladivostok),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(eur hañv Volgograd),
				'generic' => q(eur Volgograd),
				'standard' => q(eur cʼhoañv Volgograd),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(eur Wallis ha Futuna),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(eur hañv Yakutsk),
				'generic' => q(eur Yakutsk),
				'standard' => q(eur cʼhoañv Yakutsk),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(eur hañv Yekaterinbourg),
				'generic' => q(eur Yekaterinbourg),
				'standard' => q(eur cʼhoañv Yekaterinbourg),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
