use lib 't', 'lib';
use strict;
use warnings;
use Test::More tests => 30;
use IO::All;
use IO_All_Test;

my $expected1 = 't/mydir/dir1;t/mydir/dir2;t/mydir/file1;t/mydir/file2;t/mydir/file3';
my $expected2 = 't/mydir/dir1;t/mydir/dir1/dira;t/mydir/dir1/file1;t/mydir/dir2;t/mydir/dir2/file1;t/mydir/file1;t/mydir/file2;t/mydir/file3';
my $expected3 = 't/mydir/dir1;t/mydir/dir1/dira;t/mydir/dir1/dira/dirx;t/mydir/dir1/file1;t/mydir/dir2;t/mydir/dir2/file1;t/mydir/file1;t/mydir/file2;t/mydir/file3';
my $expected4 = 't/mydir/dir1;t/mydir/dir1/dira;t/mydir/dir1/dira/dirx;t/mydir/dir1/dira/dirx/file1;t/mydir/dir1/file1;t/mydir/dir2;t/mydir/dir2/file1;t/mydir/file1;t/mydir/file2;t/mydir/file3';
my $expected_files1 = 't/mydir/file1;t/mydir/file2;t/mydir/file3';
my $expected_files2 = 't/mydir/dir1/file1;t/mydir/dir2/file1;t/mydir/file1;t/mydir/file2;t/mydir/file3';
my $expected_files4 = 't/mydir/dir1/dira/dirx/file1;t/mydir/dir1/file1;t/mydir/dir2/file1;t/mydir/file1;t/mydir/file2;t/mydir/file3';
my $expected_dirs1 = 't/mydir/dir1;t/mydir/dir2';
my $expected_dirs2 = 't/mydir/dir1;t/mydir/dir1/dira;t/mydir/dir2';
my $expected_dirs3 = 't/mydir/dir1;t/mydir/dir1/dira;t/mydir/dir1/dira/dirx;t/mydir/dir2';
my $expected_filt1 = 't/mydir/dir1/dira;t/mydir/dir1/dira/dirx';
my $expected_filt2 = 't/mydir/dir1/dira/dirx';

is(join(';', io('t/mydir')->all), $expected1);
is(join(';', io('t/mydir')->all(1)), $expected1);
is(join(';', io('t/mydir')->all(2)), $expected2);
is(join(';', io('t/mydir')->all(3)), $expected3);
is(join(';', io('t/mydir')->all(4)), $expected4);
is(join(';', io('t/mydir')->all(5)), $expected4);
is(join(';', io('t/mydir')->all(0)), $expected4);
is(join(';', io('t/mydir')->All), $expected4);
is(join(';', io('t/mydir')->deep->all), $expected4);
is(join(';', io('t/mydir')->all_files), $expected_files1);
is(join(';', io('t/mydir')->all_files(1)), $expected_files1);
is(join(';', io('t/mydir')->all_files(2)), $expected_files2);
is(join(';', io('t/mydir')->all_files(3)), $expected_files2);
is(join(';', io('t/mydir')->all_files(4)), $expected_files4);
is(join(';', io('t/mydir')->all_files(5)), $expected_files4);
is(join(';', io('t/mydir')->all_files(0)), $expected_files4);
is(join(';', io('t/mydir')->All_Files), $expected_files4);
is(join(';', io('t/mydir')->deep->all_files), $expected_files4);
is(join(';', io('t/mydir')->All_Files(2)), $expected_files4);
is(join(';', io('t/mydir')->all_dirs), $expected_dirs1);
is(join(';', io('t/mydir')->all_dirs(1)), $expected_dirs1);
is(join(';', io('t/mydir')->all_dirs(2)), $expected_dirs2);
is(join(';', io('t/mydir')->all_dirs(3)), $expected_dirs3);
is(join(';', io('t/mydir')->all_dirs(4)), $expected_dirs3);
is(join(';', io('t/mydir')->all_dirs(5)), $expected_dirs3);
is(join(';', io('t/mydir')->all_dirs(0)), $expected_dirs3);
is(join(';', io('t/mydir')->All_Dirs), $expected_dirs3);
is(join(';', io('t/mydir')->deep->all_dirs), $expected_dirs3);
is(join(';', io('t/mydir')->filter(sub {/dira/})->All_Dirs), $expected_filt1);
is(join(';', io('t/mydir')->filter(sub {/x/})->All_Dirs), $expected_filt2);
