/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.util.FileUtils;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

public class SafariFileBasedLauncher
extends SafariCustomProfileLauncher {
    public SafariFileBasedLauncher(RemoteControlConfiguration configuration, String sessionId) {
        super(configuration, sessionId);
    }

    public SafariFileBasedLauncher(RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(configuration, sessionId, browserLaunchLocation);
    }

    public SafariFileBasedLauncher(RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(configuration, sessionId, browserInstallation);
    }

    protected void launch(String url) {
        String query = LauncherUtils.getQueryString(url);
        query = query + "&driverUrl=http://localhost:" + this.getPort() + "/selenium-server/driver/";
        try {
            if (SeleniumServer.isEnsureCleanSession()) {
                this.ensureCleanSession();
            }
            String fileUrl = this.createExtractedFiles().toURL() + "?" + query;
            this.launchSafari(fileUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File createExtractedFiles() {
        File coreDir = new File(this.customProfileDir, "core");
        try {
            coreDir.mkdirs();
            ResourceExtractor.extractResourcePath(SafariFileBasedLauncher.class, "/core", coreDir);
            File userExtensions = this.getConfiguration().getUserExtensions();
            if (userExtensions != null) {
                File userExtensionsJavascriptFile = new File(coreDir, "scripts/user-extensions.js");
                FileUtils.getFileUtils().copyFile(userExtensions, userExtensionsJavascriptFile, null, true);
            }
            return new File(coreDir, "RemoteRunner.html");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

