# -*- perl -*-

#
# Author: Gisbert W. Selke, TapirSoft Selke & Selke GbR.
#
# Copyright (C) 2015 Gisbert W. Selke. All rights reserved.
# This package is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
#
# Mail: gws@cpan.org
#


package Map::Tube::Lyon;
use strict;
use warnings;

our $VERSION = '0.01';

=encoding utf8

=head1 NAME

Map::Tube::Lyon - Interface to the Lyon métro map

=cut

use File::Share ':all';
use Moo;
use namespace::clean;

has xml => ( is => 'ro', default => sub { return dist_file( 'Map-Tube-Lyon', 'lyon-map.xml' ) } );

with 'Map::Tube';

=head1 SYNOPSIS

    use Map::Tube::Lyon;
    my $tube = Map::Tube::Lyon->new();

    my $route = $tube->get_shortest_route('Foch', 'Gorge de Loup');

    print "Route: $route\n";

=head1 DESCRIPTION

This module allows to find the shortest route between any two given métro
stations in Lyon. All interesting methods are provided by the role L<Map::Tube>.

=head1 METHODS

=head2 CONSTRUCTOR

    use Map::Tube::Lyon;
    my $tube = Map::Tube::Lyon->new();

This will read the tube information from the shared file F<lyon-map.xml>,
which is part of the distribution.

=head1 ERRORS

If something goes wrong, maybe because the map information file was corrupted,
the constructor will die.

=head1 AUTHOR

Gisbert W. Selke, TapirSoft Selke & Selke GbR.

=head1 COPYRIGHT AND LICENCE

The data for the XML file were taken from the French-language Wikipedia,
entry "Liste des stations du métro de Lyon". It is CC BY-SA. The module
itself is free software; you may redistribute and/or modify it under the
same terms as Perl itself.

=head1 SEE ALSO

L<Map::Tube>, L<Map::Tube::GraphViz>.

=cut

1;
