#
# $Id: Null.pm,v 3a618b2c89fc 2016/02/01 06:36:57 gomor $
#
# log::null Brik
#
package Metabrik::Log::Null;
use strict;
use warnings;

use base qw(Metabrik::Core::Log);

sub brik_properties {
   return {
      revision => '$Revision: 3a618b2c89fc $',
      tags => [ qw(unstable logging) ],
      author => 'GomoR <GomoR[at]metabrik.org>',
      license => 'http://opensource.org/licenses/BSD-3-Clause',
      attributes => {
         level => [ qw(0|1|2|3) ],
      },
      commands => {
         info => [ qw(string caller|OPTIONAL) ],
         verbose => [ qw(string caller|OPTIONAL) ],
         warning => [ qw(string caller|OPTIONAL) ],
         error => [ qw(string caller|OPTIONAL) ],
         fatal => [ qw(string caller|OPTIONAL) ],
         debug => [ qw(string caller|OPTIONAL) ],
      },
   };
}

sub _msg {
   my $self = shift;
   my ($brik, $msg) = @_;

   $msg ||= 'undef';

   $brik =~ s/^metabrik:://i;

   return lc($brik).": $msg\n";
}

sub warning {
   my $self = shift;

   return 1;
}

sub error {
   my $self = shift;

   return;
}

sub fatal {
   my $self = shift;
   my ($msg, $caller) = @_;

   my $buffer = "[F] ".$self->_msg(($caller) ||= caller(), $msg);

   die($buffer);
}

sub info {
   my $self = shift;

   return 1;
}

sub verbose {
   my $self = shift;

   return 1;
}

sub debug {
   my $self = shift;

   return 1;
}

1;

__END__

=head1 NAME

Metabrik::Log::Null - log::null Brik

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2014-2016, Patrice E<lt>GomoRE<gt> Auffret

You may distribute this module under the terms of The BSD 3-Clause License.
See LICENSE file in the source distribution archive.

=head1 AUTHOR

Patrice E<lt>GomoRE<gt> Auffret

=cut
