package App::Manoc::Controller::About;
#ABSTRACT: Controller for about page

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'Catalyst::Controller'; }

use English '-no_match_vars';


sub index : Path : Args(0) {
    my ( $self, $c ) = @_;

    $c->forward('/about/stats');
}


sub stats : Private {
    my ( $self, $c ) = @_;

    my $schema = $c->model('ManocDB');

    eval { require SNMP::Info };
    my $snmpinfo_ver = ( $@ ? 'n/a' : $SNMP::Info::VERSION );

    my $stats = {
        manoc_ver    => $App::Manoc::VERSION,
        db_version   => $App::Manoc::DB::SCHEMA_VERSION,
        dbi_ver      => $DBI::VERSION,
        dbic_ver     => $DBIx::Class::VERSION,
        catalyst_ver => $Catalyst::VERSION,
        snmpinfo_ver => $snmpinfo_ver,
        perl_version => $PERL_VERSION,

        tot_racks   => $schema->resultset('Rack')->count,
        tot_devices => $schema->resultset('Device')->count,
        tot_ifaces  => $schema->resultset('DeviceIfStatus')->count,
        tot_cdps    => $schema->resultset('CDPNeigh')->count,
        mat_entries => $schema->resultset('Mat')->count,
        arp_entries => $schema->resultset('Arp')->count
    };

    $c->stash( stats => $stats );
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=head1 NAME

App::Manoc::Controller::About - Controller for about page

=head1 VERSION

version 2.99.4

=head1 ACTIONS

=head2 index

=head2 stats

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
