
#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Transform::Proj4;

our @EXPORT_OK = qw( t_proj t_proj_aea t_proj_aeqd t_proj_airy t_proj_aitoff t_proj_alsk t_proj_apian t_proj_august t_proj_bacon t_proj_bipc t_proj_boggs t_proj_bonne t_proj_calcofi t_proj_cass t_proj_cc t_proj_cea t_proj_chamb t_proj_collg t_proj_comill t_proj_crast t_proj_denoy t_proj_eck1 t_proj_eck2 t_proj_eck3 t_proj_eck4 t_proj_eck5 t_proj_eck6 t_proj_eqc t_proj_eqdc t_proj_etmerc t_proj_euler t_proj_fahey t_proj_fouc t_proj_fouc_s t_proj_gall t_proj_geocent t_proj_geos t_proj_gins8 t_proj_gn_sinu t_proj_gnom t_proj_goode t_proj_gs48 t_proj_gs50 t_proj_gstmerc t_proj_hammer t_proj_hatano t_proj_healpix t_proj_igh t_proj_imw_p t_proj_isea t_proj_kav5 t_proj_kav7 t_proj_krovak t_proj_labrd t_proj_laea t_proj_lagrng t_proj_larr t_proj_lask t_proj_latlon t_proj_latlong t_proj_lcc t_proj_lcca t_proj_leac t_proj_lee_os t_proj_longlat t_proj_lonlat t_proj_loxim t_proj_lsat t_proj_mbt_fps t_proj_mbt_s t_proj_mbtfpp t_proj_mbtfpq t_proj_mbtfps t_proj_merc t_proj_mil_os t_proj_mill t_proj_misrsom t_proj_moll t_proj_murd1 t_proj_murd2 t_proj_murd3 t_proj_natearth t_proj_natearth2 t_proj_nell t_proj_nell_h t_proj_nicol t_proj_nsper t_proj_nzmg t_proj_ob_tran t_proj_ocea t_proj_oea t_proj_omerc t_proj_ortel t_proj_ortho t_proj_patterson t_proj_pconic t_proj_poly t_proj_putp1 t_proj_putp2 t_proj_putp3 t_proj_putp3p t_proj_putp4p t_proj_putp5 t_proj_putp5p t_proj_putp6 t_proj_putp6p t_proj_qsc t_proj_qua_aut t_proj_rhealpix t_proj_robin t_proj_rouss t_proj_rpoly t_proj_sch t_proj_sinu t_proj_somerc t_proj_stere t_proj_sterea t_proj_tcc t_proj_tcea t_proj_times t_proj_tissot t_proj_tmerc t_proj_tpeqd t_proj_tpers t_proj_ups t_proj_urm5 t_proj_urmfps t_proj_utm t_proj_vandg t_proj_vandg2 t_proj_vandg3 t_proj_vandg4 t_proj_vitk1 t_proj_wag1 t_proj_wag2 t_proj_wag3 t_proj_wag4 t_proj_wag5 t_proj_wag6 t_proj_wag7 t_proj_weren t_proj_wink1 t_proj_wink2 t_proj_wintri PDL::PP _proj4_dummy );
our %EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;



   
   our @ISA = ( 'PDL::Exporter','DynaLoader','PDL::Transform' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::Transform::Proj4 ;


BEGIN {
use PDL;
use PDL::NiceSlice;
use PDL::Transform;
use PDL::GIS::Proj;


}


#
# PDL::Transform::Proj4
#
# Judd Taylor, USF IMaRS
# 4 Apr 2006
#

=head1 NAME

PDL::Transform::Proj4 - PDL::Transform interface to the Proj4 projection library

=head1 SYNOPSIS

 # Using the generalized proj interface:
 # Make an orthographic map of Earth
 use PDL::Transform::Cartography;
 use PDL::Transform::Proj4;
 $x = earth_coast();
 $x = graticule(10,2)->glue(1,$x);
 $t = t_proj( proj_params => "+proj=ortho +ellps=WGS84 +lon_0=-90 +lat_0=40" );
 $w = pgwin(xs);
 $w->lines($t->apply($x)->clean_lines());
 
 # Using the aliased functions:
 # Make an orthographic map of Earth
 use PDL::Transform::Cartography;
 use PDL::Transform::Proj4;
 $x = earth_coast();
 $x = graticule(10,2)->glue(1,$x);
 $t = t_proj_ortho( ellps => 'WGS84', lon_0 => -90, lat_0 => 40 )
 $w = pgwin(xs);
 $w->lines($t->apply($x)->clean_lines());

=head1 DESCRIPTION

Works like PDL::Transform::Cartography, but using the proj library in the background.

Please see the proj library docs at L<http://www.remotesensing.org/proj> for more information
on proj, and how to use the library.

=head1 GENERALIZED INTERFACE

The main object here is the PDL::Transform::Proj4 object, aliased to the t_proj() function.

This object accepts all of the standard options described below, but mainly is there to be called
with just the B<proj_params> option defined.

When options are used, they must be used with a '+' before them when placed in the proj_params string,
but that is not required otherwise. See the SYNOPSIS above.

=head2 ALIASED INTERFACE

Other than t_proj(), all of the other transforms below have been autogenerated, and may not work
properly. The main problem is determining the parameters a projection requires from the proj
library itself. 

Due to the difficulties in doing this, there may be times when the proj docs specify a parameter 
for a projection that won't work using the anon-hash type specification. In that case, just throw
that parameter in the proj_params string, and everything should work fine.

=head1 PARAMETERS AVAILABLE IN ALL PROJECTIONS

=head2 General Parameters

=head3 proj_params

This is a string containing the proj "plus style" parameters. This would be similar to what you 
would put on the command line for the 'proj' tool. Like "+proj=ortho +ellps=WGS84 +lon_0=-90 +lat_0=40".

This parameter overrides the others below when it contains parameters that are also specified 
explicitly.

=head3 proj

The proj projection code to use (like ortho...)

=head3 x_0

Cartesian X offset for the output of the transformation

=head3 y_0

Cartesian Y offset for the output of the transformation

=head3 lat_0

Central latitude for the projection.
NOTE: This may mean other things depending on the projection selected, read the proj docs!

=head3 lon_0

Central longitude for the projection.
NOTE: This may mean other things depending on the projection selected, read the proj docs!

=head3 units

Cartesian units used for the output of the projection.
NOTE: Like most of the options here, this is likely useless in the current implementation
of this library.

=head3 init

Specify a file:unit for proj to use for its runtime defaults. See the proj docs.

=head3 no_defs

Don't load any defaults. See the proj docs.

=head3 over

Normally, the transformation limits the output to between -180 and 180 degrees (or the
cartesian equivalent), but with this option that behavior is turned off.

=head3 geoc

Input values are geocentric coordinates.

=head2 Earth Figure Parameters

=head3 ellps

Ellipsoid datum to use. Ex: WGS72, WGS74.
See the proj docs and command line tool for list of possibilities ('proj -le').

=head3 R

Radius of the Earth.

=head3 R_A

Radius of a sphere with equivalent surface area of specified ellipse. 

=head3 R_V

Radius of a sphere with equivalent volume of specified ellipse. 

=head3 R_a

Arithmetic mean of the major and minor axis, Ra = (a + b)/2. 

=head3 R_g

Geometric mean of the major and minor axis, Rg = (ab)1/2. 

=head3 R_h

Harmonic mean of the major and minor axis, Rh = 2ab/(a + b). 

=head3 R_lat_a=phi

Arithmetic mean of the principle radii at latitude phi.

=head3 R_lat_g=phi

Geometric mean of the principle radii at latitude phi.

=head3 b

Semiminor axis or polar radius 

=head3 f

Flattening

=head3 rf

Reciprocal flattening, +rf=1/f

=head3 e

Eccentricity +e=e 

=head3 es

Eccentricity squared +es=e2

=cut


sub new 
{
    my $proto = shift;
    my $sub = "PDL::Transform::Proj4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $class = ref($proto) || $proto;
    my $self  = $class->SUPER::new( @_ );
    
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Proj4";

    # Grab our options:
    
    # Used in the general sense:
    $self->{params}->{proj_params} = PDL::Transform::_opt( $o, ['proj_params','params'] );

    # Projection options available to all projections:
    $self->{general_params} = [ qw( proj x_0 y_0 lat_0 lon_0 units init ) ];
    foreach my $param ( @{ $self->{general_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    # Options that have no value (like "+over"):
    $self->{bool_params} = [ qw( no_defs over geoc ) ];
    foreach my $param ( @{ $self->{bool_params} } )
        { $self->{params}->{$param} = ( PDL::Transform::_opt( $o, [ $param ] ) ) ? 'ON' : undef; }
    
    # Options for the Earth figure: (ellipsoid, etc):
    $self->{earth_params} = [ qw( ellps R R_A R_V R_a R_g R_h R_lat_a R_lat_g b f rf e es ) ];
    foreach my $param ( @{ $self->{earth_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    # First process the old params that may already be in the string:
    # These override the specific params set above:
    if( defined( $self->{params}->{proj_params} ) )
    {
        $self->{orig_proj_params} = $self->{params}->{proj_params};
        
        my @params = split( /\s+/, $self->{orig_proj_params} );
        foreach my $param ( @params )
        {
            if( $param =~ /^\+(\S+)=(\S+)/ )
            {
                my ($name, $val) = ($1, $2);
                $self->{params}->{$name} = $val;
                #print STDERR "$sub: $name => $val\n";
            }
            elsif( $param =~ /^\+(\S+)/ )
            {   # Boolean option
                $self->{params}->{$1} = 'ON';
            }                
        }
    }
    
    # Update the proj_string to current options:
    #
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    ##############################
    # The meat -- just copy and paste from Transform.pm :)
    #    (and do some proj stuff here as well)
    
    # Forward transformation:
    $self->{func} = sub 
    {
        my $in = shift;
        my $opt = shift;
        my $sub = "PDL::Transform::Proj4->{func}()";
        
        my $out = $in->new_or_inplace();
        
        # Always set the badflag to 1 here, to handle possible bad projection values:
        $out->badflag(1);
        
        PDL::GIS::Proj::fwd_trans_inplace( $out->((0)), $out->((1)), $opt->{proj_params}, 1 );
        return $out;
    };
  
    # Inverse transformation:
    $self->{inv} = sub 
    {
        my $in = shift;
        my $opt = shift;
        my $sub = "PDL::Transform::Proj4->{inv}()";
        
        my $out = $in->new_or_inplace();
        
        # Always set the badflag to 1 here, to handle possible bad projection values:
        $out->badflag(1);
        
        PDL::GIS::Proj::inv_trans_inplace( $out->((0)), $out->((1)), $opt->{proj_params}, 1 );
        return $out;
    };
  
    return $self;
} # End of new()...

sub update_proj_string
{
    my $self = shift;
    my $sub = "PDL::Transform::Proj4::update_proj_string()";
    
    # (Re)Generate the proj_params string from the options passed:
    #
    delete( $self->{params}->{proj_params} );
    my $proj_string = "";
    
    foreach my $param ( keys %{ $self->{params} } )
    {
        next unless defined( $self->{params}->{$param} );
        
        $proj_string .= ( $self->{params}->{$param} eq 'ON' ) 
                        ? "+$param " : " +$param=" . $self->{params}->{$param} . " ";
        #print STDERR "$sub: Adding \'$proj_string\'...\n";
    }
    
    #print STDERR "$sub: Final proj_params: \'$proj_string\'\n";
    
    $self->{params}->{proj_params} = $proj_string;
} # End of update_proj_string()...

sub proj_params
{
    my $self = shift;
    $self->update_proj_string();
    return $self->{params}->{proj_params};
} # End of proj_params()...

sub t_proj 
{ 
    PDL::Transform::Proj4->new( @_ );
} # End of t_proj()...

1;








=head1 FUNCTIONS

=head2 t_proj

This is the main entry point for the generalized interface. See above on its usage.

=cut




=head2 t_proj_aea

Autogenerated transformation function for Proj4 projection code aea. 

The full name for this projection is Albers Equal Area.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_aea 
    { PDL::Transform::Proj4::aea->new( @_ ); }


=head2 t_proj_aeqd

Autogenerated transformation function for Proj4 projection code aeqd. 

The full name for this projection is Azimuthal Equidistant.

Projection Parameters

=for options

=over 4

=item guam

=item lat_0

=back



=cut


sub t_proj_aeqd 
    { PDL::Transform::Proj4::aeqd->new( @_ ); }


=head2 t_proj_airy

Autogenerated transformation function for Proj4 projection code airy. 

The full name for this projection is Airy.

Projection Parameters

=for options

=over 4

=item lat_b

=item no_cut

=back



=cut


sub t_proj_airy 
    { PDL::Transform::Proj4::airy->new( @_ ); }


=head2 t_proj_aitoff

Autogenerated transformation function for Proj4 projection code aitoff. 

The full name for this projection is Aitoff.


=cut


sub t_proj_aitoff 
    { PDL::Transform::Proj4::aitoff->new( @_ ); }


=head2 t_proj_alsk

Autogenerated transformation function for Proj4 projection code alsk. 

The full name for this projection is Mod. Stereographic of Alaska.


=cut


sub t_proj_alsk 
    { PDL::Transform::Proj4::alsk->new( @_ ); }


=head2 t_proj_apian

Autogenerated transformation function for Proj4 projection code apian. 

The full name for this projection is Apian Globular I.


=cut


sub t_proj_apian 
    { PDL::Transform::Proj4::apian->new( @_ ); }


=head2 t_proj_august

Autogenerated transformation function for Proj4 projection code august. 

The full name for this projection is August Epicycloidal.


=cut


sub t_proj_august 
    { PDL::Transform::Proj4::august->new( @_ ); }


=head2 t_proj_bacon

Autogenerated transformation function for Proj4 projection code bacon. 

The full name for this projection is Bacon Globular.


=cut


sub t_proj_bacon 
    { PDL::Transform::Proj4::bacon->new( @_ ); }


=head2 t_proj_bipc

Autogenerated transformation function for Proj4 projection code bipc. 

The full name for this projection is Bipolar conic of western hemisphere.


=cut


sub t_proj_bipc 
    { PDL::Transform::Proj4::bipc->new( @_ ); }


=head2 t_proj_boggs

Autogenerated transformation function for Proj4 projection code boggs. 

The full name for this projection is Boggs Eumorphic.


=cut


sub t_proj_boggs 
    { PDL::Transform::Proj4::boggs->new( @_ ); }


=head2 t_proj_bonne

Autogenerated transformation function for Proj4 projection code bonne. 

The full name for this projection is Bonne (Werner lat_1=90).

Projection Parameters

=for options

=over 4

=item lat_1

=back



=cut


sub t_proj_bonne 
    { PDL::Transform::Proj4::bonne->new( @_ ); }


=head2 t_proj_calcofi

Autogenerated transformation function for Proj4 projection code calcofi. 

The full name for this projection is Cal Coop Ocean Fish Invest Lines/Stations.


=cut


sub t_proj_calcofi 
    { PDL::Transform::Proj4::calcofi->new( @_ ); }


=head2 t_proj_cass

Autogenerated transformation function for Proj4 projection code cass. 

The full name for this projection is Cassini.


=cut


sub t_proj_cass 
    { PDL::Transform::Proj4::cass->new( @_ ); }


=head2 t_proj_cc

Autogenerated transformation function for Proj4 projection code cc. 

The full name for this projection is Central Cylindrical.


=cut


sub t_proj_cc 
    { PDL::Transform::Proj4::cc->new( @_ ); }


=head2 t_proj_cea

Autogenerated transformation function for Proj4 projection code cea. 

The full name for this projection is Equal Area Cylindrical.

Projection Parameters

=for options

=over 4

=item lat_ts

=back



=cut


sub t_proj_cea 
    { PDL::Transform::Proj4::cea->new( @_ ); }


=head2 t_proj_chamb

Autogenerated transformation function for Proj4 projection code chamb. 

The full name for this projection is Chamberlin Trimetric.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lat_3

=item lon_1

=item lon_2

=item lon_3

=back



=cut


sub t_proj_chamb 
    { PDL::Transform::Proj4::chamb->new( @_ ); }


=head2 t_proj_collg

Autogenerated transformation function for Proj4 projection code collg. 

The full name for this projection is Collignon.


=cut


sub t_proj_collg 
    { PDL::Transform::Proj4::collg->new( @_ ); }


=head2 t_proj_comill

Autogenerated transformation function for Proj4 projection code comill. 

The full name for this projection is Compact Miller.


=cut


sub t_proj_comill 
    { PDL::Transform::Proj4::comill->new( @_ ); }


=head2 t_proj_crast

Autogenerated transformation function for Proj4 projection code crast. 

The full name for this projection is Craster Parabolic (Putnins P4).


=cut


sub t_proj_crast 
    { PDL::Transform::Proj4::crast->new( @_ ); }


=head2 t_proj_denoy

Autogenerated transformation function for Proj4 projection code denoy. 

The full name for this projection is Denoyer Semi-Elliptical.


=cut


sub t_proj_denoy 
    { PDL::Transform::Proj4::denoy->new( @_ ); }


=head2 t_proj_eck1

Autogenerated transformation function for Proj4 projection code eck1. 

The full name for this projection is Eckert I.


=cut


sub t_proj_eck1 
    { PDL::Transform::Proj4::eck1->new( @_ ); }


=head2 t_proj_eck2

Autogenerated transformation function for Proj4 projection code eck2. 

The full name for this projection is Eckert II.


=cut


sub t_proj_eck2 
    { PDL::Transform::Proj4::eck2->new( @_ ); }


=head2 t_proj_eck3

Autogenerated transformation function for Proj4 projection code eck3. 

The full name for this projection is Eckert III.


=cut


sub t_proj_eck3 
    { PDL::Transform::Proj4::eck3->new( @_ ); }


=head2 t_proj_eck4

Autogenerated transformation function for Proj4 projection code eck4. 

The full name for this projection is Eckert IV.


=cut


sub t_proj_eck4 
    { PDL::Transform::Proj4::eck4->new( @_ ); }


=head2 t_proj_eck5

Autogenerated transformation function for Proj4 projection code eck5. 

The full name for this projection is Eckert V.


=cut


sub t_proj_eck5 
    { PDL::Transform::Proj4::eck5->new( @_ ); }


=head2 t_proj_eck6

Autogenerated transformation function for Proj4 projection code eck6. 

The full name for this projection is Eckert VI.


=cut


sub t_proj_eck6 
    { PDL::Transform::Proj4::eck6->new( @_ ); }


=head2 t_proj_eqc

Autogenerated transformation function for Proj4 projection code eqc. 

The full name for this projection is Equidistant Cylindrical (Plate Caree).

Projection Parameters

=for options

=over 4

=item lat_00

=item lat_ts

=back



=cut


sub t_proj_eqc 
    { PDL::Transform::Proj4::eqc->new( @_ ); }


=head2 t_proj_eqdc

Autogenerated transformation function for Proj4 projection code eqdc. 

The full name for this projection is Equidistant Conic.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_eqdc 
    { PDL::Transform::Proj4::eqdc->new( @_ ); }


=head2 t_proj_etmerc

Autogenerated transformation function for Proj4 projection code etmerc. 

The full name for this projection is Extended Transverse Mercator.

Projection Parameters

=for options

=over 4

=item lat_0(0)

=item lat_ts(0)

=back



=cut


sub t_proj_etmerc 
    { PDL::Transform::Proj4::etmerc->new( @_ ); }


=head2 t_proj_euler

Autogenerated transformation function for Proj4 projection code euler. 

The full name for this projection is Euler.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_euler 
    { PDL::Transform::Proj4::euler->new( @_ ); }


=head2 t_proj_fahey

Autogenerated transformation function for Proj4 projection code fahey. 

The full name for this projection is Fahey.


=cut


sub t_proj_fahey 
    { PDL::Transform::Proj4::fahey->new( @_ ); }


=head2 t_proj_fouc

Autogenerated transformation function for Proj4 projection code fouc. 

The full name for this projection is Foucaut.


=cut


sub t_proj_fouc 
    { PDL::Transform::Proj4::fouc->new( @_ ); }


=head2 t_proj_fouc_s

Autogenerated transformation function for Proj4 projection code fouc_s. 

The full name for this projection is Foucaut Sinusoidal.


=cut


sub t_proj_fouc_s 
    { PDL::Transform::Proj4::fouc_s->new( @_ ); }


=head2 t_proj_gall

Autogenerated transformation function for Proj4 projection code gall. 

The full name for this projection is Gall (Gall Stereographic).


=cut


sub t_proj_gall 
    { PDL::Transform::Proj4::gall->new( @_ ); }


=head2 t_proj_geocent

Autogenerated transformation function for Proj4 projection code geocent. 

The full name for this projection is Geocentric.


=cut


sub t_proj_geocent 
    { PDL::Transform::Proj4::geocent->new( @_ ); }


=head2 t_proj_geos

Autogenerated transformation function for Proj4 projection code geos. 

The full name for this projection is Geostationary Satellite View.

Projection Parameters

=for options

=over 4

=item h

=back



=cut


sub t_proj_geos 
    { PDL::Transform::Proj4::geos->new( @_ ); }


=head2 t_proj_gins8

Autogenerated transformation function for Proj4 projection code gins8. 

The full name for this projection is Ginsburg VIII (TsNIIGAiK).


=cut


sub t_proj_gins8 
    { PDL::Transform::Proj4::gins8->new( @_ ); }


=head2 t_proj_gn_sinu

Autogenerated transformation function for Proj4 projection code gn_sinu. 

The full name for this projection is General Sinusoidal Series.

Projection Parameters

=for options

=over 4

=item m

=item n

=back



=cut


sub t_proj_gn_sinu 
    { PDL::Transform::Proj4::gn_sinu->new( @_ ); }


=head2 t_proj_gnom

Autogenerated transformation function for Proj4 projection code gnom. 

The full name for this projection is Gnomonic.


=cut


sub t_proj_gnom 
    { PDL::Transform::Proj4::gnom->new( @_ ); }


=head2 t_proj_goode

Autogenerated transformation function for Proj4 projection code goode. 

The full name for this projection is Goode Homolosine.


=cut


sub t_proj_goode 
    { PDL::Transform::Proj4::goode->new( @_ ); }


=head2 t_proj_gs48

Autogenerated transformation function for Proj4 projection code gs48. 

The full name for this projection is Mod. Stereographic of 48 U.S..


=cut


sub t_proj_gs48 
    { PDL::Transform::Proj4::gs48->new( @_ ); }


=head2 t_proj_gs50

Autogenerated transformation function for Proj4 projection code gs50. 

The full name for this projection is Mod. Stereographic of 50 U.S..


=cut


sub t_proj_gs50 
    { PDL::Transform::Proj4::gs50->new( @_ ); }


=head2 t_proj_gstmerc

Autogenerated transformation function for Proj4 projection code gstmerc. 

The full name for this projection is Gauss-Schreiber Transverse Mercator (aka Gauss-Laborde Reunion).

Projection Parameters

=for options

=over 4

=item k_0

=item lat_0

=item lon_0

=back



=cut


sub t_proj_gstmerc 
    { PDL::Transform::Proj4::gstmerc->new( @_ ); }


=head2 t_proj_hammer

Autogenerated transformation function for Proj4 projection code hammer. 

The full name for this projection is Hammer & Eckert-Greifendorff.

Projection Parameters

=for options

=over 4

=item M

=item W

=back



=cut


sub t_proj_hammer 
    { PDL::Transform::Proj4::hammer->new( @_ ); }


=head2 t_proj_hatano

Autogenerated transformation function for Proj4 projection code hatano. 

The full name for this projection is Hatano Asymmetrical Equal Area.


=cut


sub t_proj_hatano 
    { PDL::Transform::Proj4::hatano->new( @_ ); }


=head2 t_proj_healpix

Autogenerated transformation function for Proj4 projection code healpix. 

The full name for this projection is HEALPix.


=cut


sub t_proj_healpix 
    { PDL::Transform::Proj4::healpix->new( @_ ); }


=head2 t_proj_igh

Autogenerated transformation function for Proj4 projection code igh. 

The full name for this projection is Interrupted Goode Homolosine.


=cut


sub t_proj_igh 
    { PDL::Transform::Proj4::igh->new( @_ ); }


=head2 t_proj_imw_p

Autogenerated transformation function for Proj4 projection code imw_p. 

The full name for this projection is International Map of the World Polyconic.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lon_1

=back



=cut


sub t_proj_imw_p 
    { PDL::Transform::Proj4::imw_p->new( @_ ); }


=head2 t_proj_isea

Autogenerated transformation function for Proj4 projection code isea. 

The full name for this projection is Icosahedral Snyder Equal Area.


=cut


sub t_proj_isea 
    { PDL::Transform::Proj4::isea->new( @_ ); }


=head2 t_proj_kav5

Autogenerated transformation function for Proj4 projection code kav5. 

The full name for this projection is Kavraisky V.


=cut


sub t_proj_kav5 
    { PDL::Transform::Proj4::kav5->new( @_ ); }


=head2 t_proj_kav7

Autogenerated transformation function for Proj4 projection code kav7. 

The full name for this projection is Kavraisky VII.


=cut


sub t_proj_kav7 
    { PDL::Transform::Proj4::kav7->new( @_ ); }


=head2 t_proj_krovak

Autogenerated transformation function for Proj4 projection code krovak. 

The full name for this projection is Krovak.


=cut


sub t_proj_krovak 
    { PDL::Transform::Proj4::krovak->new( @_ ); }


=head2 t_proj_labrd

Autogenerated transformation function for Proj4 projection code labrd. 

The full name for this projection is Laborde.


=cut


sub t_proj_labrd 
    { PDL::Transform::Proj4::labrd->new( @_ ); }


=head2 t_proj_laea

Autogenerated transformation function for Proj4 projection code laea. 

The full name for this projection is Lambert Azimuthal Equal Area.


=cut


sub t_proj_laea 
    { PDL::Transform::Proj4::laea->new( @_ ); }


=head2 t_proj_lagrng

Autogenerated transformation function for Proj4 projection code lagrng. 

The full name for this projection is Lagrange.

Projection Parameters

=for options

=over 4

=item W

=back



=cut


sub t_proj_lagrng 
    { PDL::Transform::Proj4::lagrng->new( @_ ); }


=head2 t_proj_larr

Autogenerated transformation function for Proj4 projection code larr. 

The full name for this projection is Larrivee.


=cut


sub t_proj_larr 
    { PDL::Transform::Proj4::larr->new( @_ ); }


=head2 t_proj_lask

Autogenerated transformation function for Proj4 projection code lask. 

The full name for this projection is Laskowski.


=cut


sub t_proj_lask 
    { PDL::Transform::Proj4::lask->new( @_ ); }


=head2 t_proj_latlon

Autogenerated transformation function for Proj4 projection code latlon. 

The full name for this projection is Lat/long (Geodetic alias).


=cut


sub t_proj_latlon 
    { PDL::Transform::Proj4::latlon->new( @_ ); }


=head2 t_proj_latlong

Autogenerated transformation function for Proj4 projection code latlong. 

The full name for this projection is Lat/long (Geodetic alias).


=cut


sub t_proj_latlong 
    { PDL::Transform::Proj4::latlong->new( @_ ); }


=head2 t_proj_lcc

Autogenerated transformation function for Proj4 projection code lcc. 

The full name for this projection is Lambert Conformal Conic.

Projection Parameters

=for options

=over 4

=item lat_0

=item lat_1

=item lat_2

=back



=cut


sub t_proj_lcc 
    { PDL::Transform::Proj4::lcc->new( @_ ); }


=head2 t_proj_lcca

Autogenerated transformation function for Proj4 projection code lcca. 

The full name for this projection is Lambert Conformal Conic Alternative.

Projection Parameters

=for options

=over 4

=item lat_0

=back



=cut


sub t_proj_lcca 
    { PDL::Transform::Proj4::lcca->new( @_ ); }


=head2 t_proj_leac

Autogenerated transformation function for Proj4 projection code leac. 

The full name for this projection is Lambert Equal Area Conic.

Projection Parameters

=for options

=over 4

=item lat_1

=item south

=back



=cut


sub t_proj_leac 
    { PDL::Transform::Proj4::leac->new( @_ ); }


=head2 t_proj_lee_os

Autogenerated transformation function for Proj4 projection code lee_os. 

The full name for this projection is Lee Oblated Stereographic.


=cut


sub t_proj_lee_os 
    { PDL::Transform::Proj4::lee_os->new( @_ ); }


=head2 t_proj_longlat

Autogenerated transformation function for Proj4 projection code longlat. 

The full name for this projection is Lat/long (Geodetic alias).


=cut


sub t_proj_longlat 
    { PDL::Transform::Proj4::longlat->new( @_ ); }


=head2 t_proj_lonlat

Autogenerated transformation function for Proj4 projection code lonlat. 

The full name for this projection is Lat/long (Geodetic).


=cut


sub t_proj_lonlat 
    { PDL::Transform::Proj4::lonlat->new( @_ ); }


=head2 t_proj_loxim

Autogenerated transformation function for Proj4 projection code loxim. 

The full name for this projection is Loximuthal.


=cut


sub t_proj_loxim 
    { PDL::Transform::Proj4::loxim->new( @_ ); }


=head2 t_proj_lsat

Autogenerated transformation function for Proj4 projection code lsat. 

The full name for this projection is Space oblique for LANDSAT.

Projection Parameters

=for options

=over 4

=item lsat

=item path

=back



=cut


sub t_proj_lsat 
    { PDL::Transform::Proj4::lsat->new( @_ ); }


=head2 t_proj_mbt_fps

Autogenerated transformation function for Proj4 projection code mbt_fps. 

The full name for this projection is McBryde-Thomas Flat-Pole Sine (No. 2).


=cut


sub t_proj_mbt_fps 
    { PDL::Transform::Proj4::mbt_fps->new( @_ ); }


=head2 t_proj_mbt_s

Autogenerated transformation function for Proj4 projection code mbt_s. 

The full name for this projection is McBryde-Thomas Flat-Polar Sine (No. 1).


=cut


sub t_proj_mbt_s 
    { PDL::Transform::Proj4::mbt_s->new( @_ ); }


=head2 t_proj_mbtfpp

Autogenerated transformation function for Proj4 projection code mbtfpp. 

The full name for this projection is McBride-Thomas Flat-Polar Parabolic.


=cut


sub t_proj_mbtfpp 
    { PDL::Transform::Proj4::mbtfpp->new( @_ ); }


=head2 t_proj_mbtfpq

Autogenerated transformation function for Proj4 projection code mbtfpq. 

The full name for this projection is McBryde-Thomas Flat-Polar Quartic.


=cut


sub t_proj_mbtfpq 
    { PDL::Transform::Proj4::mbtfpq->new( @_ ); }


=head2 t_proj_mbtfps

Autogenerated transformation function for Proj4 projection code mbtfps. 

The full name for this projection is McBryde-Thomas Flat-Polar Sinusoidal.


=cut


sub t_proj_mbtfps 
    { PDL::Transform::Proj4::mbtfps->new( @_ ); }


=head2 t_proj_merc

Autogenerated transformation function for Proj4 projection code merc. 

The full name for this projection is Mercator.

Projection Parameters

=for options

=over 4

=item lat_ts

=back



=cut


sub t_proj_merc 
    { PDL::Transform::Proj4::merc->new( @_ ); }


=head2 t_proj_mil_os

Autogenerated transformation function for Proj4 projection code mil_os. 

The full name for this projection is Miller Oblated Stereographic.


=cut


sub t_proj_mil_os 
    { PDL::Transform::Proj4::mil_os->new( @_ ); }


=head2 t_proj_mill

Autogenerated transformation function for Proj4 projection code mill. 

The full name for this projection is Miller Cylindrical.


=cut


sub t_proj_mill 
    { PDL::Transform::Proj4::mill->new( @_ ); }


=head2 t_proj_misrsom

Autogenerated transformation function for Proj4 projection code misrsom. 

The full name for this projection is Space oblique for MISR.

Projection Parameters

=for options

=over 4

=item path

=back



=cut


sub t_proj_misrsom 
    { PDL::Transform::Proj4::misrsom->new( @_ ); }


=head2 t_proj_moll

Autogenerated transformation function for Proj4 projection code moll. 

The full name for this projection is Mollweide.


=cut


sub t_proj_moll 
    { PDL::Transform::Proj4::moll->new( @_ ); }


=head2 t_proj_murd1

Autogenerated transformation function for Proj4 projection code murd1. 

The full name for this projection is Murdoch I.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_murd1 
    { PDL::Transform::Proj4::murd1->new( @_ ); }


=head2 t_proj_murd2

Autogenerated transformation function for Proj4 projection code murd2. 

The full name for this projection is Murdoch II.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_murd2 
    { PDL::Transform::Proj4::murd2->new( @_ ); }


=head2 t_proj_murd3

Autogenerated transformation function for Proj4 projection code murd3. 

The full name for this projection is Murdoch III.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_murd3 
    { PDL::Transform::Proj4::murd3->new( @_ ); }


=head2 t_proj_natearth

Autogenerated transformation function for Proj4 projection code natearth. 

The full name for this projection is Natural Earth.


=cut


sub t_proj_natearth 
    { PDL::Transform::Proj4::natearth->new( @_ ); }


=head2 t_proj_natearth2

Autogenerated transformation function for Proj4 projection code natearth2. 

The full name for this projection is Natural Earth 2.


=cut


sub t_proj_natearth2 
    { PDL::Transform::Proj4::natearth2->new( @_ ); }


=head2 t_proj_nell

Autogenerated transformation function for Proj4 projection code nell. 

The full name for this projection is Nell.


=cut


sub t_proj_nell 
    { PDL::Transform::Proj4::nell->new( @_ ); }


=head2 t_proj_nell_h

Autogenerated transformation function for Proj4 projection code nell_h. 

The full name for this projection is Nell-Hammer.


=cut


sub t_proj_nell_h 
    { PDL::Transform::Proj4::nell_h->new( @_ ); }


=head2 t_proj_nicol

Autogenerated transformation function for Proj4 projection code nicol. 

The full name for this projection is Nicolosi Globular.


=cut


sub t_proj_nicol 
    { PDL::Transform::Proj4::nicol->new( @_ ); }


=head2 t_proj_nsper

Autogenerated transformation function for Proj4 projection code nsper. 

The full name for this projection is Near-sided perspective.

Projection Parameters

=for options

=over 4

=item h

=back



=cut


sub t_proj_nsper 
    { PDL::Transform::Proj4::nsper->new( @_ ); }


=head2 t_proj_nzmg

Autogenerated transformation function for Proj4 projection code nzmg. 

The full name for this projection is New Zealand Map Grid.


=cut


sub t_proj_nzmg 
    { PDL::Transform::Proj4::nzmg->new( @_ ); }


=head2 t_proj_ob_tran

Autogenerated transformation function for Proj4 projection code ob_tran. 

The full name for this projection is General Oblique Transformation.

Projection Parameters

=for options

=over 4

=item o_alpha

=item o_lat_1

=item o_lat_2

=item o_lat_c

=item o_lat_p

=item o_lon_1

=item o_lon_2

=item o_lon_c

=item o_lon_p

=item o_proj

=back



=cut


sub t_proj_ob_tran 
    { PDL::Transform::Proj4::ob_tran->new( @_ ); }


=head2 t_proj_ocea

Autogenerated transformation function for Proj4 projection code ocea. 

The full name for this projection is Oblique Cylindrical Equal Area.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lon_1

=item lon_2

=back



=cut


sub t_proj_ocea 
    { PDL::Transform::Proj4::ocea->new( @_ ); }


=head2 t_proj_oea

Autogenerated transformation function for Proj4 projection code oea. 

The full name for this projection is Oblated Equal Area.

Projection Parameters

=for options

=over 4

=item m

=item n

=item theta

=back



=cut


sub t_proj_oea 
    { PDL::Transform::Proj4::oea->new( @_ ); }


=head2 t_proj_omerc

Autogenerated transformation function for Proj4 projection code omerc. 

The full name for this projection is Oblique Mercator.

Projection Parameters

=for options

=over 4

=item alpha

=item gamma

=item lat_1

=item lat_2

=item lon_1

=item lon_2

=item lonc

=item no_off

=back



=cut


sub t_proj_omerc 
    { PDL::Transform::Proj4::omerc->new( @_ ); }


=head2 t_proj_ortel

Autogenerated transformation function for Proj4 projection code ortel. 

The full name for this projection is Ortelius Oval.


=cut


sub t_proj_ortel 
    { PDL::Transform::Proj4::ortel->new( @_ ); }


=head2 t_proj_ortho

Autogenerated transformation function for Proj4 projection code ortho. 

The full name for this projection is Orthographic.


=cut


sub t_proj_ortho 
    { PDL::Transform::Proj4::ortho->new( @_ ); }


=head2 t_proj_patterson

Autogenerated transformation function for Proj4 projection code patterson. 

The full name for this projection is Patterson Cylindrical.


=cut


sub t_proj_patterson 
    { PDL::Transform::Proj4::patterson->new( @_ ); }


=head2 t_proj_pconic

Autogenerated transformation function for Proj4 projection code pconic. 

The full name for this projection is Perspective Conic.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_pconic 
    { PDL::Transform::Proj4::pconic->new( @_ ); }


=head2 t_proj_poly

Autogenerated transformation function for Proj4 projection code poly. 

The full name for this projection is Polyconic (American).


=cut


sub t_proj_poly 
    { PDL::Transform::Proj4::poly->new( @_ ); }


=head2 t_proj_putp1

Autogenerated transformation function for Proj4 projection code putp1. 

The full name for this projection is Putnins P1.


=cut


sub t_proj_putp1 
    { PDL::Transform::Proj4::putp1->new( @_ ); }


=head2 t_proj_putp2

Autogenerated transformation function for Proj4 projection code putp2. 

The full name for this projection is Putnins P2.


=cut


sub t_proj_putp2 
    { PDL::Transform::Proj4::putp2->new( @_ ); }


=head2 t_proj_putp3

Autogenerated transformation function for Proj4 projection code putp3. 

The full name for this projection is Putnins P3.


=cut


sub t_proj_putp3 
    { PDL::Transform::Proj4::putp3->new( @_ ); }


=head2 t_proj_putp3p

Autogenerated transformation function for Proj4 projection code putp3p. 

The full name for this projection is Putnins P3'.


=cut


sub t_proj_putp3p 
    { PDL::Transform::Proj4::putp3p->new( @_ ); }


=head2 t_proj_putp4p

Autogenerated transformation function for Proj4 projection code putp4p. 

The full name for this projection is Putnins P4'.


=cut


sub t_proj_putp4p 
    { PDL::Transform::Proj4::putp4p->new( @_ ); }


=head2 t_proj_putp5

Autogenerated transformation function for Proj4 projection code putp5. 

The full name for this projection is Putnins P5.


=cut


sub t_proj_putp5 
    { PDL::Transform::Proj4::putp5->new( @_ ); }


=head2 t_proj_putp5p

Autogenerated transformation function for Proj4 projection code putp5p. 

The full name for this projection is Putnins P5'.


=cut


sub t_proj_putp5p 
    { PDL::Transform::Proj4::putp5p->new( @_ ); }


=head2 t_proj_putp6

Autogenerated transformation function for Proj4 projection code putp6. 

The full name for this projection is Putnins P6.


=cut


sub t_proj_putp6 
    { PDL::Transform::Proj4::putp6->new( @_ ); }


=head2 t_proj_putp6p

Autogenerated transformation function for Proj4 projection code putp6p. 

The full name for this projection is Putnins P6'.


=cut


sub t_proj_putp6p 
    { PDL::Transform::Proj4::putp6p->new( @_ ); }


=head2 t_proj_qsc

Autogenerated transformation function for Proj4 projection code qsc. 

The full name for this projection is Quadrilateralized Spherical Cube.


=cut


sub t_proj_qsc 
    { PDL::Transform::Proj4::qsc->new( @_ ); }


=head2 t_proj_qua_aut

Autogenerated transformation function for Proj4 projection code qua_aut. 

The full name for this projection is Quartic Authalic.


=cut


sub t_proj_qua_aut 
    { PDL::Transform::Proj4::qua_aut->new( @_ ); }


=head2 t_proj_rhealpix

Autogenerated transformation function for Proj4 projection code rhealpix. 

The full name for this projection is rHEALPix.

Projection Parameters

=for options

=over 4

=item south_square

=back



=cut


sub t_proj_rhealpix 
    { PDL::Transform::Proj4::rhealpix->new( @_ ); }


=head2 t_proj_robin

Autogenerated transformation function for Proj4 projection code robin. 

The full name for this projection is Robinson.


=cut


sub t_proj_robin 
    { PDL::Transform::Proj4::robin->new( @_ ); }


=head2 t_proj_rouss

Autogenerated transformation function for Proj4 projection code rouss. 

The full name for this projection is Roussilhe Stereographic.


=cut


sub t_proj_rouss 
    { PDL::Transform::Proj4::rouss->new( @_ ); }


=head2 t_proj_rpoly

Autogenerated transformation function for Proj4 projection code rpoly. 

The full name for this projection is Rectangular Polyconic.

Projection Parameters

=for options

=over 4

=item lat_ts

=back



=cut


sub t_proj_rpoly 
    { PDL::Transform::Proj4::rpoly->new( @_ ); }


=head2 t_proj_sch

Autogenerated transformation function for Proj4 projection code sch. 

The full name for this projection is Spherical Cross-track Height.

Projection Parameters

=for options

=over 4

=item h_0

=item phdg_0

=item plat_0

=item plon_0

=back



=cut


sub t_proj_sch 
    { PDL::Transform::Proj4::sch->new( @_ ); }


=head2 t_proj_sinu

Autogenerated transformation function for Proj4 projection code sinu. 

The full name for this projection is Sinusoidal (Sanson-Flamsteed).


=cut


sub t_proj_sinu 
    { PDL::Transform::Proj4::sinu->new( @_ ); }


=head2 t_proj_somerc

Autogenerated transformation function for Proj4 projection code somerc. 

The full name for this projection is Swiss. Obl. Mercator.


=cut


sub t_proj_somerc 
    { PDL::Transform::Proj4::somerc->new( @_ ); }


=head2 t_proj_stere

Autogenerated transformation function for Proj4 projection code stere. 

The full name for this projection is Stereographic.

Projection Parameters

=for options

=over 4

=item lat_ts

=back



=cut


sub t_proj_stere 
    { PDL::Transform::Proj4::stere->new( @_ ); }


=head2 t_proj_sterea

Autogenerated transformation function for Proj4 projection code sterea. 

The full name for this projection is Oblique Stereographic Alternative.


=cut


sub t_proj_sterea 
    { PDL::Transform::Proj4::sterea->new( @_ ); }


=head2 t_proj_tcc

Autogenerated transformation function for Proj4 projection code tcc. 

The full name for this projection is Transverse Central Cylindrical.


=cut


sub t_proj_tcc 
    { PDL::Transform::Proj4::tcc->new( @_ ); }


=head2 t_proj_tcea

Autogenerated transformation function for Proj4 projection code tcea. 

The full name for this projection is Transverse Cylindrical Equal Area.


=cut


sub t_proj_tcea 
    { PDL::Transform::Proj4::tcea->new( @_ ); }


=head2 t_proj_times

Autogenerated transformation function for Proj4 projection code times. 

The full name for this projection is Times.


=cut


sub t_proj_times 
    { PDL::Transform::Proj4::times->new( @_ ); }


=head2 t_proj_tissot

Autogenerated transformation function for Proj4 projection code tissot. 

The full name for this projection is Tissot.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_tissot 
    { PDL::Transform::Proj4::tissot->new( @_ ); }


=head2 t_proj_tmerc

Autogenerated transformation function for Proj4 projection code tmerc. 

The full name for this projection is Transverse Mercator.


=cut


sub t_proj_tmerc 
    { PDL::Transform::Proj4::tmerc->new( @_ ); }


=head2 t_proj_tpeqd

Autogenerated transformation function for Proj4 projection code tpeqd. 

The full name for this projection is Two Point Equidistant.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=item lon_1

=item lon_2

=back



=cut


sub t_proj_tpeqd 
    { PDL::Transform::Proj4::tpeqd->new( @_ ); }


=head2 t_proj_tpers

Autogenerated transformation function for Proj4 projection code tpers. 

The full name for this projection is Tilted perspective.

Projection Parameters

=for options

=over 4

=item azi

=item h

=item tilt

=back



=cut


sub t_proj_tpers 
    { PDL::Transform::Proj4::tpers->new( @_ ); }


=head2 t_proj_ups

Autogenerated transformation function for Proj4 projection code ups. 

The full name for this projection is Universal Polar Stereographic.

Projection Parameters

=for options

=over 4

=item south

=back



=cut


sub t_proj_ups 
    { PDL::Transform::Proj4::ups->new( @_ ); }


=head2 t_proj_urm5

Autogenerated transformation function for Proj4 projection code urm5. 

The full name for this projection is Urmaev V.

Projection Parameters

=for options

=over 4

=item alpha

=item n

=item q

=back



=cut


sub t_proj_urm5 
    { PDL::Transform::Proj4::urm5->new( @_ ); }


=head2 t_proj_urmfps

Autogenerated transformation function for Proj4 projection code urmfps. 

The full name for this projection is Urmaev Flat-Polar Sinusoidal.

Projection Parameters

=for options

=over 4

=item n

=back



=cut


sub t_proj_urmfps 
    { PDL::Transform::Proj4::urmfps->new( @_ ); }


=head2 t_proj_utm

Autogenerated transformation function for Proj4 projection code utm. 

The full name for this projection is Universal Transverse Mercator (UTM).

Projection Parameters

=for options

=over 4

=item south

=item zone

=back



=cut


sub t_proj_utm 
    { PDL::Transform::Proj4::utm->new( @_ ); }


=head2 t_proj_vandg

Autogenerated transformation function for Proj4 projection code vandg. 

The full name for this projection is van der Grinten (I).


=cut


sub t_proj_vandg 
    { PDL::Transform::Proj4::vandg->new( @_ ); }


=head2 t_proj_vandg2

Autogenerated transformation function for Proj4 projection code vandg2. 

The full name for this projection is van der Grinten II.


=cut


sub t_proj_vandg2 
    { PDL::Transform::Proj4::vandg2->new( @_ ); }


=head2 t_proj_vandg3

Autogenerated transformation function for Proj4 projection code vandg3. 

The full name for this projection is van der Grinten III.


=cut


sub t_proj_vandg3 
    { PDL::Transform::Proj4::vandg3->new( @_ ); }


=head2 t_proj_vandg4

Autogenerated transformation function for Proj4 projection code vandg4. 

The full name for this projection is van der Grinten IV.


=cut


sub t_proj_vandg4 
    { PDL::Transform::Proj4::vandg4->new( @_ ); }


=head2 t_proj_vitk1

Autogenerated transformation function for Proj4 projection code vitk1. 

The full name for this projection is Vitkovsky I.

Projection Parameters

=for options

=over 4

=item lat_1

=item lat_2

=back



=cut


sub t_proj_vitk1 
    { PDL::Transform::Proj4::vitk1->new( @_ ); }


=head2 t_proj_wag1

Autogenerated transformation function for Proj4 projection code wag1. 

The full name for this projection is Wagner I (Kavraisky VI).


=cut


sub t_proj_wag1 
    { PDL::Transform::Proj4::wag1->new( @_ ); }


=head2 t_proj_wag2

Autogenerated transformation function for Proj4 projection code wag2. 

The full name for this projection is Wagner II.


=cut


sub t_proj_wag2 
    { PDL::Transform::Proj4::wag2->new( @_ ); }


=head2 t_proj_wag3

Autogenerated transformation function for Proj4 projection code wag3. 

The full name for this projection is Wagner III.

Projection Parameters

=for options

=over 4

=item lat_ts

=back



=cut


sub t_proj_wag3 
    { PDL::Transform::Proj4::wag3->new( @_ ); }


=head2 t_proj_wag4

Autogenerated transformation function for Proj4 projection code wag4. 

The full name for this projection is Wagner IV.


=cut


sub t_proj_wag4 
    { PDL::Transform::Proj4::wag4->new( @_ ); }


=head2 t_proj_wag5

Autogenerated transformation function for Proj4 projection code wag5. 

The full name for this projection is Wagner V.


=cut


sub t_proj_wag5 
    { PDL::Transform::Proj4::wag5->new( @_ ); }


=head2 t_proj_wag6

Autogenerated transformation function for Proj4 projection code wag6. 

The full name for this projection is Wagner VI.


=cut


sub t_proj_wag6 
    { PDL::Transform::Proj4::wag6->new( @_ ); }


=head2 t_proj_wag7

Autogenerated transformation function for Proj4 projection code wag7. 

The full name for this projection is Wagner VII.


=cut


sub t_proj_wag7 
    { PDL::Transform::Proj4::wag7->new( @_ ); }


=head2 t_proj_weren

Autogenerated transformation function for Proj4 projection code weren. 

The full name for this projection is Werenskiold I.


=cut


sub t_proj_weren 
    { PDL::Transform::Proj4::weren->new( @_ ); }


=head2 t_proj_wink1

Autogenerated transformation function for Proj4 projection code wink1. 

The full name for this projection is Winkel I.

Projection Parameters

=for options

=over 4

=item lat_ts

=back



=cut


sub t_proj_wink1 
    { PDL::Transform::Proj4::wink1->new( @_ ); }


=head2 t_proj_wink2

Autogenerated transformation function for Proj4 projection code wink2. 

The full name for this projection is Winkel II.

Projection Parameters

=for options

=over 4

=item lat_1

=back



=cut


sub t_proj_wink2 
    { PDL::Transform::Proj4::wink2->new( @_ ); }


=head2 t_proj_wintri

Autogenerated transformation function for Proj4 projection code wintri. 

The full name for this projection is Winkel Tripel.

Projection Parameters

=for options

=over 4

=item lat_1

=back



=cut


sub t_proj_wintri 
    { PDL::Transform::Proj4::wintri->new( @_ ); }




*_proj4_dummy = \&PDL::_proj4_dummy;



;


# Autogenerated code for the Proj4 projection code: 
#    aea
#
package PDL::Transform::Proj4::aea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::aea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Albers Equal Area";
    $self->{proj_code} = "aea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::aea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    aeqd
#
package PDL::Transform::Proj4::aeqd;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::aeqd::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Azimuthal Equidistant";
    $self->{proj_code} = "aeqd";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 guam ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::aeqd::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    airy
#
package PDL::Transform::Proj4::airy;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::airy::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Airy";
    $self->{proj_code} = "airy";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( no_cut lat_b ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::airy::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    aitoff
#
package PDL::Transform::Proj4::aitoff;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::aitoff::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Aitoff";
    $self->{proj_code} = "aitoff";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::aitoff::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    alsk
#
package PDL::Transform::Proj4::alsk;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::alsk::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Mod. Stereographic of Alaska";
    $self->{proj_code} = "alsk";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::alsk::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    apian
#
package PDL::Transform::Proj4::apian;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::apian::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Apian Globular I";
    $self->{proj_code} = "apian";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::apian::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    august
#
package PDL::Transform::Proj4::august;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::august::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "August Epicycloidal";
    $self->{proj_code} = "august";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::august::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    bacon
#
package PDL::Transform::Proj4::bacon;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::bacon::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Bacon Globular";
    $self->{proj_code} = "bacon";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::bacon::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    bipc
#
package PDL::Transform::Proj4::bipc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::bipc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Bipolar conic of western hemisphere";
    $self->{proj_code} = "bipc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::bipc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    boggs
#
package PDL::Transform::Proj4::boggs;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::boggs::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Boggs Eumorphic";
    $self->{proj_code} = "boggs";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::boggs::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    bonne
#
package PDL::Transform::Proj4::bonne;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::bonne::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Bonne (Werner lat_1=90)";
    $self->{proj_code} = "bonne";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::bonne::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    calcofi
#
package PDL::Transform::Proj4::calcofi;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::calcofi::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Cal Coop Ocean Fish Invest Lines/Stations";
    $self->{proj_code} = "calcofi";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::calcofi::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    cass
#
package PDL::Transform::Proj4::cass;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::cass::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Cassini";
    $self->{proj_code} = "cass";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::cass::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    cc
#
package PDL::Transform::Proj4::cc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::cc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Central Cylindrical";
    $self->{proj_code} = "cc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::cc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    cea
#
package PDL::Transform::Proj4::cea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::cea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Equal Area Cylindrical";
    $self->{proj_code} = "cea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::cea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    chamb
#
package PDL::Transform::Proj4::chamb;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::chamb::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Chamberlin Trimetric";
    $self->{proj_code} = "chamb";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lon_1 lat_2 lon_2 lat_3 lon_3 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::chamb::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    collg
#
package PDL::Transform::Proj4::collg;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::collg::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Collignon";
    $self->{proj_code} = "collg";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::collg::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    comill
#
package PDL::Transform::Proj4::comill;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::comill::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Compact Miller";
    $self->{proj_code} = "comill";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::comill::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    crast
#
package PDL::Transform::Proj4::crast;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::crast::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Craster Parabolic (Putnins P4)";
    $self->{proj_code} = "crast";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::crast::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    denoy
#
package PDL::Transform::Proj4::denoy;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::denoy::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Denoyer Semi-Elliptical";
    $self->{proj_code} = "denoy";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::denoy::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eck1
#
package PDL::Transform::Proj4::eck1;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Eckert I";
    $self->{proj_code} = "eck1";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eck1::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eck2
#
package PDL::Transform::Proj4::eck2;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Eckert II";
    $self->{proj_code} = "eck2";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eck2::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eck3
#
package PDL::Transform::Proj4::eck3;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Eckert III";
    $self->{proj_code} = "eck3";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eck3::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eck4
#
package PDL::Transform::Proj4::eck4;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Eckert IV";
    $self->{proj_code} = "eck4";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eck4::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eck5
#
package PDL::Transform::Proj4::eck5;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Eckert V";
    $self->{proj_code} = "eck5";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eck5::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eck6
#
package PDL::Transform::Proj4::eck6;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eck6::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Eckert VI";
    $self->{proj_code} = "eck6";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eck6::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eqc
#
package PDL::Transform::Proj4::eqc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eqc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Equidistant Cylindrical (Plate Caree)";
    $self->{proj_code} = "eqc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts lat_00 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eqc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    eqdc
#
package PDL::Transform::Proj4::eqdc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::eqdc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Equidistant Conic";
    $self->{proj_code} = "eqdc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::eqdc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    etmerc
#
package PDL::Transform::Proj4::etmerc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::etmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Extended Transverse Mercator";
    $self->{proj_code} = "etmerc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts(0) lat_0(0) ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::etmerc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    euler
#
package PDL::Transform::Proj4::euler;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::euler::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Euler";
    $self->{proj_code} = "euler";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::euler::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    fahey
#
package PDL::Transform::Proj4::fahey;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::fahey::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Fahey";
    $self->{proj_code} = "fahey";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::fahey::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    fouc
#
package PDL::Transform::Proj4::fouc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::fouc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Foucaut";
    $self->{proj_code} = "fouc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::fouc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    fouc_s
#
package PDL::Transform::Proj4::fouc_s;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::fouc_s::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Foucaut Sinusoidal";
    $self->{proj_code} = "fouc_s";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::fouc_s::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    gall
#
package PDL::Transform::Proj4::gall;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gall::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Gall (Gall Stereographic)";
    $self->{proj_code} = "gall";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::gall::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    geocent
#
package PDL::Transform::Proj4::geocent;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::geocent::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Geocentric";
    $self->{proj_code} = "geocent";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::geocent::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    geos
#
package PDL::Transform::Proj4::geos;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::geos::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Geostationary Satellite View";
    $self->{proj_code} = "geos";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( h ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::geos::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    gins8
#
package PDL::Transform::Proj4::gins8;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gins8::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Ginsburg VIII (TsNIIGAiK)";
    $self->{proj_code} = "gins8";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::gins8::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    gn_sinu
#
package PDL::Transform::Proj4::gn_sinu;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gn_sinu::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "General Sinusoidal Series";
    $self->{proj_code} = "gn_sinu";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( m n ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::gn_sinu::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    gnom
#
package PDL::Transform::Proj4::gnom;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gnom::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Gnomonic";
    $self->{proj_code} = "gnom";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::gnom::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    goode
#
package PDL::Transform::Proj4::goode;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::goode::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Goode Homolosine";
    $self->{proj_code} = "goode";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::goode::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    gs48
#
package PDL::Transform::Proj4::gs48;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gs48::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Mod. Stereographic of 48 U.S.";
    $self->{proj_code} = "gs48";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::gs48::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    gs50
#
package PDL::Transform::Proj4::gs50;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gs50::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Mod. Stereographic of 50 U.S.";
    $self->{proj_code} = "gs50";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::gs50::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    gstmerc
#
package PDL::Transform::Proj4::gstmerc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::gstmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Gauss-Schreiber Transverse Mercator (aka Gauss-Laborde Reunion)";
    $self->{proj_code} = "gstmerc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 lon_0 k_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::gstmerc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    hammer
#
package PDL::Transform::Proj4::hammer;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::hammer::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Hammer & Eckert-Greifendorff";
    $self->{proj_code} = "hammer";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( W M ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::hammer::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    hatano
#
package PDL::Transform::Proj4::hatano;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::hatano::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Hatano Asymmetrical Equal Area";
    $self->{proj_code} = "hatano";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::hatano::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    healpix
#
package PDL::Transform::Proj4::healpix;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::healpix::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "HEALPix";
    $self->{proj_code} = "healpix";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::healpix::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    igh
#
package PDL::Transform::Proj4::igh;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::igh::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Interrupted Goode Homolosine";
    $self->{proj_code} = "igh";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::igh::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    imw_p
#
package PDL::Transform::Proj4::imw_p;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::imw_p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "International Map of the World Polyconic";
    $self->{proj_code} = "imw_p";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 lon_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::imw_p::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    isea
#
package PDL::Transform::Proj4::isea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::isea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Icosahedral Snyder Equal Area";
    $self->{proj_code} = "isea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::isea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    kav5
#
package PDL::Transform::Proj4::kav5;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::kav5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Kavraisky V";
    $self->{proj_code} = "kav5";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::kav5::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    kav7
#
package PDL::Transform::Proj4::kav7;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::kav7::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Kavraisky VII";
    $self->{proj_code} = "kav7";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::kav7::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    krovak
#
package PDL::Transform::Proj4::krovak;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::krovak::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Krovak";
    $self->{proj_code} = "krovak";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::krovak::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    labrd
#
package PDL::Transform::Proj4::labrd;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::labrd::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Laborde";
    $self->{proj_code} = "labrd";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::labrd::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    laea
#
package PDL::Transform::Proj4::laea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::laea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lambert Azimuthal Equal Area";
    $self->{proj_code} = "laea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::laea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    lagrng
#
package PDL::Transform::Proj4::lagrng;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lagrng::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lagrange";
    $self->{proj_code} = "lagrng";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( W ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::lagrng::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    larr
#
package PDL::Transform::Proj4::larr;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::larr::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Larrivee";
    $self->{proj_code} = "larr";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::larr::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    lask
#
package PDL::Transform::Proj4::lask;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lask::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Laskowski";
    $self->{proj_code} = "lask";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::lask::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    latlon
#
package PDL::Transform::Proj4::latlon;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::latlon::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lat/long (Geodetic alias)";
    $self->{proj_code} = "latlon";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::latlon::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    latlong
#
package PDL::Transform::Proj4::latlong;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::latlong::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lat/long (Geodetic alias)";
    $self->{proj_code} = "latlong";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::latlong::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    lcc
#
package PDL::Transform::Proj4::lcc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lcc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lambert Conformal Conic";
    $self->{proj_code} = "lcc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 lat_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::lcc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    lcca
#
package PDL::Transform::Proj4::lcca;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lcca::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lambert Conformal Conic Alternative";
    $self->{proj_code} = "lcca";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_0 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::lcca::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    leac
#
package PDL::Transform::Proj4::leac;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::leac::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lambert Equal Area Conic";
    $self->{proj_code} = "leac";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 south ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::leac::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    lee_os
#
package PDL::Transform::Proj4::lee_os;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lee_os::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lee Oblated Stereographic";
    $self->{proj_code} = "lee_os";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::lee_os::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    longlat
#
package PDL::Transform::Proj4::longlat;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::longlat::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lat/long (Geodetic alias)";
    $self->{proj_code} = "longlat";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::longlat::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    lonlat
#
package PDL::Transform::Proj4::lonlat;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lonlat::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Lat/long (Geodetic)";
    $self->{proj_code} = "lonlat";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::lonlat::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    loxim
#
package PDL::Transform::Proj4::loxim;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::loxim::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Loximuthal";
    $self->{proj_code} = "loxim";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::loxim::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    lsat
#
package PDL::Transform::Proj4::lsat;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::lsat::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Space oblique for LANDSAT";
    $self->{proj_code} = "lsat";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lsat path ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::lsat::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    mbt_fps
#
package PDL::Transform::Proj4::mbt_fps;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbt_fps::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "McBryde-Thomas Flat-Pole Sine (No. 2)";
    $self->{proj_code} = "mbt_fps";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::mbt_fps::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    mbt_s
#
package PDL::Transform::Proj4::mbt_s;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbt_s::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "McBryde-Thomas Flat-Polar Sine (No. 1)";
    $self->{proj_code} = "mbt_s";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::mbt_s::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    mbtfpp
#
package PDL::Transform::Proj4::mbtfpp;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbtfpp::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "McBride-Thomas Flat-Polar Parabolic";
    $self->{proj_code} = "mbtfpp";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::mbtfpp::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    mbtfpq
#
package PDL::Transform::Proj4::mbtfpq;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbtfpq::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "McBryde-Thomas Flat-Polar Quartic";
    $self->{proj_code} = "mbtfpq";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::mbtfpq::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    mbtfps
#
package PDL::Transform::Proj4::mbtfps;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mbtfps::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "McBryde-Thomas Flat-Polar Sinusoidal";
    $self->{proj_code} = "mbtfps";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::mbtfps::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    merc
#
package PDL::Transform::Proj4::merc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::merc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Mercator";
    $self->{proj_code} = "merc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::merc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    mil_os
#
package PDL::Transform::Proj4::mil_os;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mil_os::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Miller Oblated Stereographic";
    $self->{proj_code} = "mil_os";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::mil_os::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    mill
#
package PDL::Transform::Proj4::mill;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::mill::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Miller Cylindrical";
    $self->{proj_code} = "mill";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::mill::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    misrsom
#
package PDL::Transform::Proj4::misrsom;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::misrsom::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Space oblique for MISR";
    $self->{proj_code} = "misrsom";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( path ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::misrsom::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    moll
#
package PDL::Transform::Proj4::moll;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::moll::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Mollweide";
    $self->{proj_code} = "moll";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::moll::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    murd1
#
package PDL::Transform::Proj4::murd1;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::murd1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Murdoch I";
    $self->{proj_code} = "murd1";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::murd1::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    murd2
#
package PDL::Transform::Proj4::murd2;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::murd2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Murdoch II";
    $self->{proj_code} = "murd2";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::murd2::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    murd3
#
package PDL::Transform::Proj4::murd3;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::murd3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Murdoch III";
    $self->{proj_code} = "murd3";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::murd3::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    natearth
#
package PDL::Transform::Proj4::natearth;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::natearth::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Natural Earth";
    $self->{proj_code} = "natearth";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::natearth::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    natearth2
#
package PDL::Transform::Proj4::natearth2;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::natearth2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Natural Earth 2";
    $self->{proj_code} = "natearth2";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::natearth2::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    nell
#
package PDL::Transform::Proj4::nell;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nell::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Nell";
    $self->{proj_code} = "nell";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::nell::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    nell_h
#
package PDL::Transform::Proj4::nell_h;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nell_h::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Nell-Hammer";
    $self->{proj_code} = "nell_h";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::nell_h::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    nicol
#
package PDL::Transform::Proj4::nicol;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nicol::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Nicolosi Globular";
    $self->{proj_code} = "nicol";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::nicol::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    nsper
#
package PDL::Transform::Proj4::nsper;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nsper::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Near-sided perspective";
    $self->{proj_code} = "nsper";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( h ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::nsper::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    nzmg
#
package PDL::Transform::Proj4::nzmg;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::nzmg::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "New Zealand Map Grid";
    $self->{proj_code} = "nzmg";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::nzmg::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    ob_tran
#
package PDL::Transform::Proj4::ob_tran;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ob_tran::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "General Oblique Transformation";
    $self->{proj_code} = "ob_tran";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( o_proj o_lat_p o_lon_p o_alpha o_lon_c o_lat_c o_lon_1 o_lat_1 o_lon_2 o_lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::ob_tran::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    ocea
#
package PDL::Transform::Proj4::ocea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ocea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Oblique Cylindrical Equal Area";
    $self->{proj_code} = "ocea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 lon_1 lon_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::ocea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    oea
#
package PDL::Transform::Proj4::oea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::oea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Oblated Equal Area";
    $self->{proj_code} = "oea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( n m theta ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::oea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    omerc
#
package PDL::Transform::Proj4::omerc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::omerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Oblique Mercator";
    $self->{proj_code} = "omerc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( alpha gamma no_off lonc lon_1 lat_1 lon_2 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::omerc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    ortel
#
package PDL::Transform::Proj4::ortel;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ortel::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Ortelius Oval";
    $self->{proj_code} = "ortel";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::ortel::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    ortho
#
package PDL::Transform::Proj4::ortho;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ortho::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Orthographic";
    $self->{proj_code} = "ortho";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::ortho::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    patterson
#
package PDL::Transform::Proj4::patterson;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::patterson::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Patterson Cylindrical";
    $self->{proj_code} = "patterson";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::patterson::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    pconic
#
package PDL::Transform::Proj4::pconic;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::pconic::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Perspective Conic";
    $self->{proj_code} = "pconic";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::pconic::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    poly
#
package PDL::Transform::Proj4::poly;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::poly::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Polyconic (American)";
    $self->{proj_code} = "poly";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::poly::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp1
#
package PDL::Transform::Proj4::putp1;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P1";
    $self->{proj_code} = "putp1";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp1::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp2
#
package PDL::Transform::Proj4::putp2;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P2";
    $self->{proj_code} = "putp2";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp2::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp3
#
package PDL::Transform::Proj4::putp3;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P3";
    $self->{proj_code} = "putp3";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp3::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp3p
#
package PDL::Transform::Proj4::putp3p;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp3p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P3'";
    $self->{proj_code} = "putp3p";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp3p::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp4p
#
package PDL::Transform::Proj4::putp4p;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp4p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P4'";
    $self->{proj_code} = "putp4p";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp4p::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp5
#
package PDL::Transform::Proj4::putp5;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P5";
    $self->{proj_code} = "putp5";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp5::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp5p
#
package PDL::Transform::Proj4::putp5p;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp5p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P5'";
    $self->{proj_code} = "putp5p";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp5p::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp6
#
package PDL::Transform::Proj4::putp6;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp6::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P6";
    $self->{proj_code} = "putp6";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp6::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    putp6p
#
package PDL::Transform::Proj4::putp6p;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::putp6p::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Putnins P6'";
    $self->{proj_code} = "putp6p";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::putp6p::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    qsc
#
package PDL::Transform::Proj4::qsc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::qsc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Quadrilateralized Spherical Cube";
    $self->{proj_code} = "qsc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::qsc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    qua_aut
#
package PDL::Transform::Proj4::qua_aut;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::qua_aut::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Quartic Authalic";
    $self->{proj_code} = "qua_aut";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::qua_aut::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    rhealpix
#
package PDL::Transform::Proj4::rhealpix;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::rhealpix::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "rHEALPix";
    $self->{proj_code} = "rhealpix";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( south_square ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::rhealpix::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    robin
#
package PDL::Transform::Proj4::robin;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::robin::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Robinson";
    $self->{proj_code} = "robin";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::robin::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    rouss
#
package PDL::Transform::Proj4::rouss;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::rouss::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Roussilhe Stereographic";
    $self->{proj_code} = "rouss";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::rouss::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    rpoly
#
package PDL::Transform::Proj4::rpoly;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::rpoly::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Rectangular Polyconic";
    $self->{proj_code} = "rpoly";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::rpoly::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    sch
#
package PDL::Transform::Proj4::sch;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::sch::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Spherical Cross-track Height";
    $self->{proj_code} = "sch";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( plat_0  plon_0   phdg_0  h_0   ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::sch::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    sinu
#
package PDL::Transform::Proj4::sinu;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::sinu::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Sinusoidal (Sanson-Flamsteed)";
    $self->{proj_code} = "sinu";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::sinu::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    somerc
#
package PDL::Transform::Proj4::somerc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::somerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Swiss. Obl. Mercator";
    $self->{proj_code} = "somerc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::somerc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    stere
#
package PDL::Transform::Proj4::stere;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::stere::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Stereographic";
    $self->{proj_code} = "stere";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::stere::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    sterea
#
package PDL::Transform::Proj4::sterea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::sterea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Oblique Stereographic Alternative";
    $self->{proj_code} = "sterea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::sterea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    tcc
#
package PDL::Transform::Proj4::tcc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tcc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Transverse Central Cylindrical";
    $self->{proj_code} = "tcc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::tcc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    tcea
#
package PDL::Transform::Proj4::tcea;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tcea::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Transverse Cylindrical Equal Area";
    $self->{proj_code} = "tcea";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::tcea::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    times
#
package PDL::Transform::Proj4::times;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::times::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Times";
    $self->{proj_code} = "times";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::times::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    tissot
#
package PDL::Transform::Proj4::tissot;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tissot::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Tissot";
    $self->{proj_code} = "tissot";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::tissot::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    tmerc
#
package PDL::Transform::Proj4::tmerc;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tmerc::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Transverse Mercator";
    $self->{proj_code} = "tmerc";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::tmerc::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    tpeqd
#
package PDL::Transform::Proj4::tpeqd;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tpeqd::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Two Point Equidistant";
    $self->{proj_code} = "tpeqd";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lon_1 lat_2 lon_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::tpeqd::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    tpers
#
package PDL::Transform::Proj4::tpers;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::tpers::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Tilted perspective";
    $self->{proj_code} = "tpers";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( tilt azi h ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::tpers::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    ups
#
package PDL::Transform::Proj4::ups;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::ups::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Universal Polar Stereographic";
    $self->{proj_code} = "ups";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( south ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::ups::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    urm5
#
package PDL::Transform::Proj4::urm5;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::urm5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Urmaev V";
    $self->{proj_code} = "urm5";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( n q alpha ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::urm5::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    urmfps
#
package PDL::Transform::Proj4::urmfps;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::urmfps::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Urmaev Flat-Polar Sinusoidal";
    $self->{proj_code} = "urmfps";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( n ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::urmfps::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    utm
#
package PDL::Transform::Proj4::utm;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::utm::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Universal Transverse Mercator (UTM)";
    $self->{proj_code} = "utm";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( zone south ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::utm::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    vandg
#
package PDL::Transform::Proj4::vandg;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "van der Grinten (I)";
    $self->{proj_code} = "vandg";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::vandg::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    vandg2
#
package PDL::Transform::Proj4::vandg2;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "van der Grinten II";
    $self->{proj_code} = "vandg2";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::vandg2::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    vandg3
#
package PDL::Transform::Proj4::vandg3;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "van der Grinten III";
    $self->{proj_code} = "vandg3";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::vandg3::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    vandg4
#
package PDL::Transform::Proj4::vandg4;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vandg4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "van der Grinten IV";
    $self->{proj_code} = "vandg4";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::vandg4::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    vitk1
#
package PDL::Transform::Proj4::vitk1;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::vitk1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Vitkovsky I";
    $self->{proj_code} = "vitk1";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 lat_2 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::vitk1::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wag1
#
package PDL::Transform::Proj4::wag1;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Wagner I (Kavraisky VI)";
    $self->{proj_code} = "wag1";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wag1::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wag2
#
package PDL::Transform::Proj4::wag2;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Wagner II";
    $self->{proj_code} = "wag2";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wag2::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wag3
#
package PDL::Transform::Proj4::wag3;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag3::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Wagner III";
    $self->{proj_code} = "wag3";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wag3::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wag4
#
package PDL::Transform::Proj4::wag4;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag4::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Wagner IV";
    $self->{proj_code} = "wag4";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wag4::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wag5
#
package PDL::Transform::Proj4::wag5;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag5::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Wagner V";
    $self->{proj_code} = "wag5";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wag5::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wag6
#
package PDL::Transform::Proj4::wag6;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag6::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Wagner VI";
    $self->{proj_code} = "wag6";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wag6::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wag7
#
package PDL::Transform::Proj4::wag7;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wag7::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Wagner VII";
    $self->{proj_code} = "wag7";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wag7::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    weren
#
package PDL::Transform::Proj4::weren;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::weren::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Werenskiold I";
    $self->{proj_code} = "weren";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw(  ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::weren::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wink1
#
package PDL::Transform::Proj4::wink1;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wink1::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Winkel I";
    $self->{proj_code} = "wink1";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_ts ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wink1::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wink2
#
package PDL::Transform::Proj4::wink2;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wink2::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Winkel II";
    $self->{proj_code} = "wink2";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wink2::new()...

1;




# Autogenerated code for the Proj4 projection code: 
#    wintri
#
package PDL::Transform::Proj4::wintri;
our @ISA = ( 'PDL::Transform::Proj4' );

sub new
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $sub = "PDL::Transform::Proj4::wintri::new()";
    #print STDERR "$sub: ARGS: [" . join(", ", @_ ) . "]\n";
    my $self  = $class->SUPER::new( @_ );
    bless ($self, $class);
    
    my $o = $_[0];
    unless( (ref $o) ) 
        { $o = {@_}; }
    
    #use Data::Dumper;
    #my $dd2 = Data::Dumper->new( [$o], ["$sub: o"] );
    #$dd2->Indent(1);
    #print STDERR $dd2->Dump();
        
    $self->{name} = "Winkel Tripel";
    $self->{proj_code} = "wintri";

    # Make sure proj is set in the options:
    $self->{params}->{proj} = $self->{proj_code};
    
    # Grab our projection specific options:
    #
    $self->{projection_params} = [ qw( lat_1 ) ];
    foreach my $param ( @{ $self->{projection_params} } )
        { $self->{params}->{$param} = PDL::Transform::_opt( $o, [ $param ] ); }
    
    $self->update_proj_string();
    
    #my $dd = Data::Dumper->new( [$self->{params}], ["$sub: params"] );
    #$dd->Indent(1);
    #print STDERR $dd->Dump();
    
    #print STDERR "$sub: Final proj_params: \'" . $self->{params}->{proj_params} . "\'\n";
        
    return $self;
} # End of PDL::Transform::wintri::new()...

1;




=head1 AUTHOR & MAINTAINER

Judd Taylor, Orbital Systems, Ltd.
judd dot t at orbitalsystems dot com

=cut






# Exit with OK status

1;

		   