/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;

public final class TailCallLoop
extends UnaryExpression {
    UserFunction containingFunction;

    public TailCallLoop(UserFunction function, Expression body) {
        super(body);
        this.containingFunction = function;
    }

    public UserFunction getContainingFunction() {
        return this.containingFunction;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        return this;
    }

    public int getImplementationMethod() {
        return this.getBaseExpression().getImplementationMethod();
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public Expression copy(RebindingMap rebindings) {
        throw new UnsupportedOperationException("TailCallLoop.copy()");
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        TailCallInfo tail;
        UserFunction target;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            SequenceIterator iter = this.getBaseExpression().iterate(cm);
            GroundedValue extent = SequenceExtent.makeSequenceExtent(iter);
            tail = cm.getTailCallInfo();
            if (tail != null) continue;
            return extent.iterate();
        } while ((target = this.establishTargetFunction(tail, cm)) == this.containingFunction);
        return this.tailCallDifferentFunction(target, cm).iterate();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        TailCallInfo tail;
        UserFunction target;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            Item item = this.getBaseExpression().evaluateItem(context);
            tail = cm.getTailCallInfo();
            if (tail != null) continue;
            return item;
        } while ((target = this.establishTargetFunction(tail, cm)) == this.containingFunction);
        return this.tailCallDifferentFunction(target, cm).head();
    }

    private UserFunction establishTargetFunction(TailCallInfo tail, XPathContextMajor cm) {
        if (tail instanceof TailCallFunction) {
            return ((TailCallFunction)tail).function;
        }
        if (tail instanceof TailCallComponent) {
            Component targetComponent = ((TailCallComponent)tail).component;
            cm.setCurrentComponent(targetComponent);
            return (UserFunction)targetComponent.getActor();
        }
        throw new AssertionError();
    }

    public void process(XPathContext context) throws XPathException {
        TailCallInfo tail;
        UserFunction target;
        XPathContextMajor cm = (XPathContextMajor)context;
        Expression operand = this.getBaseExpression();
        do {
            operand.process(context);
            tail = cm.getTailCallInfo();
            if (tail != null) continue;
            return;
        } while ((target = this.establishTargetFunction(tail, cm)) == this.containingFunction);
        SequenceTool.process(this.tailCallDifferentFunction(target, cm), cm, operand.getLocation());
    }

    private Sequence tailCallDifferentFunction(UserFunction userFunction, XPathContextMajor cm) throws XPathException {
        cm.resetStackFrameMap(userFunction.getStackFrameMap(), userFunction.getArity());
        try {
            return ExpressionTool.evaluate(userFunction.getBody(), userFunction.getEvaluationMode(), cm, 1);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this.getLocation());
            err.maybeSetContext(cm);
            throw err;
        }
    }

    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    public String getExpressionName() {
        return "tailCallLoop";
    }

    protected static class TailCallFunction
    implements TailCallInfo {
        public UserFunction function;

        protected TailCallFunction() {
        }
    }

    protected static class TailCallComponent
    implements TailCallInfo {
        public Component component;
        public UserFunction function;

        protected TailCallComponent() {
        }
    }

    public static interface TailCallInfo {
    }
}

