#!/usr/bin/perl -w
# ABSTRACT: A command-line tool for FM synthesis and effects

use 5.018;

use strict;

use Carp;

use Narwhal::Preset;

use Data::Dumper;

use constant (
  EPSILON => 0.000001,
  TIMEOUT => 14400.0,
);

use Narwhal::Synth;
use Narwhal::Tone::Pluck;
use Narwhal::Tone::Sine;
use Narwhal::Tone::Square;
use Narwhal::Tone::Triangle;
use Narwhal::Tone::Noise;
use Narwhal::Tone::Sawtooth;
use Narwhal::Tone::Trapezium;
use Narwhal::Tone::Exp;
use Narwhal::Tone::WhiteNoise;
use Narwhal::Tone::PinkNoise;
use Narwhal::Tone::BrownNoise;
use Narwhal::Tone::TPDFNoise;
use Narwhal::Effect::Fade;
use Narwhal::Effect::Chorus;
use Narwhal::Effect::Delay;
use Narwhal::Effect::Echo;
use Narwhal::Effect::Echos;
use Narwhal::Effect::Flanger;
use Narwhal::Effect::Overdrive;
use Narwhal::Effect::Phaser;

{ package Narwhal;
    
    use Carp;
    
    use Moose;
    use Moose::Util::TypeConstraints;
    
    use Getopt::Long;
    
    use YAML::Tiny;
    
    use Data::Dumper;
    
    use constant DEFAULT_FORMAT => 'YAML';
        
    enum 'Format', [qw(YAML XML JSON)];
    
    has 'format' => (
        is => 'rw',
        isa => 'Format',
    );
    
    has 'preset' => (
        is => 'rw',
        isa => 'Narwhal::Preset',
    );
    
    sub get_options {
        my $self = shift;    
        my $opt_format = DEFAULT_FORMAT;
        eval {
            GetOptions('format=s' => \$opt_format);
            $self->format($opt_format);
        };
      
        die "Regrettably, this is not a valid format option.  Choose one of YAML,JSON or XML." if $@;
      
        return(0);
    }
    
    sub begin {
        my $self = shift;
        $self->get_options();
        return(0);
    }
    
    sub capture {
        my @lines = <>;
        my $diamond = "@lines";
        
        if($diamond) {
            return($diamond);
        } else {
            return(0);
        }
    }
    
    sub parse {
        my $self = shift;
        $self->preset(Narwhal::Preset->new(format => $self->format,diamond => $self->capture));
        if($self->preset->parse()) {
            return(1);
        } else {
            return(0);
        }
    }
    
    sub proc {
        my $self = shift;
        
        return($self->preset->proc());
    }
    
    sub gencmd {
        my $self = shift;
        my $class = shift;
        
        my @cmds;
        
        for my $synth (@{$self->preset->synths}) {            
            push(@cmds,join(' ',$self->preset->process,$self->preset->handle,$synth->gencmd()));            
        }
               
        return(@cmds);
    }
}

1;