# Narwhal

Narwhal is a command for Linux, Mac and Windows permitting SoX tone generation using preset files written in YAML, JSON or XML.  

The tones may either be exported to a popular audio file format or played to an audio output device.

### Example YAML preset file
    #!/usr/local/bin/narwhal.pl --format=YAML
    - preset            :
        tty             :   STDOUT
        description     :   "A sequence of picking and grinning.\n"
        alias           :   picka
        process         :   play
        rate            :   48000
        - synth         :
          length        :   0.5
          combine       :   fmod    
          - tones       :
            - pluck     :
              - notes   :   |   
                            E4
                            G2
                            D3
                            G3 
                            F3
                            A4
              sustain   :   20
              tone-1    :   20
              tone-2    :   90
            - pluck     :
              - notes   :   |
                            E2
                            A2
                            G3
                            G3 
                            B3
                            E4
              sustain   :   20
              tone-1    :   20
              tone-2    :   90
        - effects       :
          - fade        :
              in        :   0.125
              out       :   0.125
    - sequence          :   |
                            picka
                            picka
                            picka
                            picka
