#!/usr/bin/env perl

use strict;
use warnings;
use v5.30;

use PDK::Device::H3c;
use PDK::Device::Cisco;
use PDK::Concern::Netdisco::H3c;
use PDK::Concern::Netdisco::Cisco;
use Data::Dumper;
use Data::Printer;

my $config = <<NXOS;
<SZX9-23F-PSW01>display lldp neighbor-information list | include GE
23F_SERVER_RACK      GE2/0/15        9c54-c262-5be0  Smartrate-Ethernet1/0/1
SZX9-MG-SW01         GE2/0/47        60da-83b2-bbda  GigabitEthernet1/0/47
NXOS

my @config = split(/\n/, $config);
say Dumper @config;

my $d = PDK::Device::H3c->new(host => 'fake');
my $nd = PDK::Concern::Netdisco::H3c->new(device => $d, debug => 1);
say Dumper $nd->gen_iface_desc(\@config);
