package PDK::Concern::Netdisco::H3c;

use utf8;
use v5.30;
use Moose;
use Data::Dumper;
use namespace::autoclean;

with 'PDK::Concern::Netdisco::Role';

# PDK::Device execCommands 入参接收数组引用
sub commands {
  my $self = shift;

  ['display lldp neighbor-information list | include GE']
}

# 生成接口描述命令
sub gen_iface_desc {
  my ($self, $topology) = @_;
  my @commands = ('system-view');

  foreach my $line (@{$topology}) {
    # 跳过不需要处理的行
    if ($line =~ /display/ || $line !~ /GE|XGE|Ethernet/i) {
      $self->dump("跳过不需要处理的行：$line");
      next;
    }

    my ($local_port, $chassis, $remote_port, $neighbor);

    # 解析接口信息
    if ($line =~ /^X?GE/) {
      ($local_port, $chassis, $remote_port, $neighbor) = split /\s+/, $line;
      $self->dump("匹配单行格式1：$line");
    }
    elsif ($line =~ /X?GE/) {
      ($neighbor, $local_port, $chassis, $remote_port) = split /\s+/, $line;
      $self->dump("匹配单行格式2：$line");
    } else {
      $self->dump("未匹配正则格式跳过解析：$line");
      warn("未匹配正则格式跳过解析：$line");
      next;
    }

    # 打印解析到的数据
    $self->dump("打印解析到的数据：\n" . Dumper($local_port, $neighbor, $remote_port));

    # 跳过非以太网接口
    next if $remote_port !~ /eth|twe|ten|gig/i;

    # 处理特殊情况（AP设备）
    $neighbor = "AP-${neighbor}" if $line =~ /Smartrate-Ethernet1\/0\/1/;
    $neighbor =~ s/(?:\.|\().*$//; # 移除域名和括号内容

    # 规范化接口名称
    $local_port  = $self->refine_if($local_port);
    $remote_port = $self->refine_if($remote_port);

    # 移除邻居接口可能出现的空白
    $remote_port =~ s/\s+//g;

    # 将目标端口全部转换为大写
    $remote_port = uc $remote_port;

    # 生成接口描述命令
    push @commands, (
      "interface $local_port",
      "description TO_${neighbor}_${remote_port}"
    );
  }

  # 添加退出和保存配置命令
  push @commands, ('quit', 'quit', 'save force');

  # 打印最终生成的脚本
  $self->dump("邻居拓扑解析完毕并生成接口描述脚本:\n" . Dumper @commands);

  return @commands;
}

__PACKAGE__->meta->make_immutable;
1;