package Yandex::Translate;

use strict;
use warnings;
use HTTP::Tiny;
use JSON;

$Yandex::Translate::VERSION = '0.02';

sub new
{
    my $class = shift;
    my $self = {
	_key_        => shift,
        _text_       => shift,
        _from_lang_  => shift,
        _to_lang_    => shift,
	_base_       => "https://translate.yandex.net/api/v1.5/tr.json",
	_post_       => undef
    };

    bless $self, $class;
    return $self
}

sub set_key
{
    my ( $self, $key ) = @_;
    $self->{_key_} = $key if defined($key);
}

sub get_langs_list
{
    my $self = shift;
    my $query = '/getLangs?';
    $self->{_post_} = 'ui=en&key='.$self->{_key_};
    my $response = HTTP::Tiny->new->get($self->{_base_} . $query  . $self->{_post_});
    die "Invalid Api\n" if $response->{status} eq '403';
    die "Blocked Api\n" if $response->{status} eq '402';
    die "Failed!\n" unless $response->{success};
    my $result = undef;
    if (length $response->{content}) {
        my $json_respond =  JSON->new->utf8->decode($response->{content});
	my $index = 0;
	while ($index < 10) {
	    $result .= ' | '.$json_respond->{dirs}[$index];
	    $index++;
	}
    }

    return $result.'... for more info visit https://translate.yandex.com\n' if defined($result);
}

sub set_text 
{
    my ( $self, $text ) = @_;
    $self->{_text_} = $text if defined($text);
}

sub set_from_lang
{
    my ($self, $from_lang) = @_;
    $self->{_from_lang_} = $from_lang if defined($from_lang);
}

sub set_to_lang
{
    my ($self, $to_lang) = @_;
    $self->{_to_lang_} = $to_lang if defined($to_lang);
}

sub detect_lang
{
    my $self = shift;
    my $query = '/detect?';
    $self->{_post_} = 'text='.$self->{_text_}.'&key='.$self->{_key_};
    my $response = HTTP::Tiny->new->get($self->{_base_} . $query  . $self->{_post_});
    
    die "Failed!\n" unless $response->{success};
   
    if (length $response->{content}) {
        my $json_respond =  JSON->new->utf8->decode($response->{content});
	return $json_respond->{lang}."\n";
    }
}

sub translate
{
    my $self = shift;
    my $query = '/translate?';
    $self->{_text_} =~ s/ /+/ig;
    $self->{_post_} = 'lang='.$self->{_from_lang_}.'-'.$self->{_to_lang_}.'&key='.$self->{_key_}.'&text='.$self->{_text_};
    my $response = HTTP::Tiny->new->get($self->{_base_} . $query  . $self->{_post_});
    die "Invalid Api\n" if $response->{status} eq '401';
    die "Invalid Api\n" if $response->{status} eq '403';
    die "Exceeded the daily limit on the amount of translated text\n" if $response->{status} eq '403';
    die "Exceeded the maximum text size\n" if $response->{status} eq '413';
    die "The text cannot be translated\n" if $response->{status} eq '422';
    die "The specified translation direction is not supported\n" if $response->{status} eq '501';
    die "Failed!\n" unless $response->{success};

    if (length $response->{content}) {
        my $json_respond =  JSON->new->utf8->decode($response->{content});
        return $json_respond->{text}[0]."\n";
    }
}

1;
__END__

