#!/usr/bin/perl
use 5.010;
use strict;
use warnings;

# This script splits a YAML input file into two.
# One for use with whatever you originally need for.
# Another for use with this module (Finance::Asset)

use YAML::XS qw(LoadFile DumpFile);
use Data::Dumper;

my $input_yml       = shift or die "YAML file needed as input param";

my $output_curr = {};
my $output_curr_yml = 'curr_underlyings.yml';

my $output_fa = {};
my $output_fa_yml   = 'fa_underlyings.yml';

# for Finance::Asset, we only need the following, the rest go back
my @fa_keys = qw/
    pip_size
    market_convention
    divisor
    display_name
    exchange_name
    /;

my $underlyings = LoadFile($input_yml);

for my $ul (keys %$underlyings) {

    my @ul_keys = keys %{$underlyings->{$ul}};

    for my $k (@ul_keys) {
        if (grep { /^$k$/ } @fa_keys) {
            $output_fa->{$ul}{$k} = $underlyings->{$ul}{$k};
        }
        else {
            $output_curr->{$ul}{$k} = $underlyings->{$ul}{$k};
        }
    }
}

DumpFile($output_curr_yml, $output_curr);
DumpFile($output_fa_yml, $output_fa);

