package Net::TVDB::Languages;
{
  $Net::TVDB::Languages::VERSION = '1.120570';
}

use strict;
use warnings;

# You should never edit this file. Everything in here is automatically
# generated by tools/generate-languages.pl.

# ABSTRACT: A list of languages supported by thetvdb.com
require Exporter;
our @ISA       = qw(Exporter);
our @EXPORT_OK = qw($languages);

our $languages = {
    "Portugu\x{ea}s" => {
        'abbreviation' => 'pt',
        'id'           => '26'
    },
    'Polski' => {
        'abbreviation' => 'pl',
        'id'           => '18'
    },
    "T\x{fc}rk\x{e7}e" => {
        'abbreviation' => 'tr',
        'id'           => '21'
    },
    " \x{5e2}\x{5d1}\x{5e8}\x{5d9}\x{5ea}" => {
        'abbreviation' => 'he',
        'id'           => '24'
    },
    'Norsk' => {
        'abbreviation' => 'no',
        'id'           => '9'
    },
"\x{440}\x{443}\x{441}\x{441}\x{43a}\x{438}\x{439} \x{44f}\x{437}\x{44b}\x{43a}"
      => {
        'abbreviation' => 'ru',
        'id'           => '22'
      },
    "\x{65e5}\x{672c}\x{8a9e}" => {
        'abbreviation' => 'ja',
        'id'           => '25'
    },
    "\x{395}\x{3bb}\x{3bb}\x{3b7}\x{3bd}\x{3b9}\x{3ba}\x{3ac}" => {
        'abbreviation' => 'el',
        'id'           => '20'
    },
    'Magyar' => {
        'abbreviation' => 'hu',
        'id'           => '19'
    },
    'English' => {
        'abbreviation' => 'en',
        'id'           => '7'
    },
    'Italiano' => {
        'abbreviation' => 'it',
        'id'           => '15'
    },
    'Hrvatski' => {
        'abbreviation' => 'hr',
        'id'           => '31'
    },
    "Fran\x{e7}ais" => {
        'abbreviation' => 'fr',
        'id'           => '17'
    },
    "\x{d55c}\x{ad6d}\x{c5b4}" => {
        'abbreviation' => 'ko',
        'id'           => '32'
    },
    'Svenska' => {
        'abbreviation' => 'sv',
        'id'           => '8'
    },
    "Espa\x{f1}ol" => {
        'abbreviation' => 'es',
        'id'           => '16'
    },
    'Deutsch' => {
        'abbreviation' => 'de',
        'id'           => '14'
    },
    "\x{10d}e\x{161}tina" => {
        'abbreviation' => 'cs',
        'id'           => '28'
    },
    'Nederlands' => {
        'abbreviation' => 'nl',
        'id'           => '13'
    },
    'Slovenski' => {
        'abbreviation' => 'sl',
        'id'           => '30'
    },
    'Suomeksi' => {
        'abbreviation' => 'fi',
        'id'           => '11'
    },
    'Dansk' => {
        'abbreviation' => 'da',
        'id'           => '10'
    },
    "\x{4e2d}\x{6587}" => {
        'abbreviation' => 'zh',
        'id'           => '27'
    }
};


1;

__END__
=pod

=head1 NAME

Net::TVDB::Languages - A list of languages supported by thetvdb.com

=head1 VERSION

version 1.120570

=head1 SYNOPSIS

  use Net::TVDB::Languages qw($languages);

=head1 DESCRIPTION

This contains all the langauges supported by http://thetvdb.com as of 2012-02-22.

They are as follows:

=over 4

=item *

Português

=item *

Polski

=item *

Türkçe

=item *

 עברית

=item *

Norsk

=item *

русский язык

=item *

日本語

=item *

Ελληνικά

=item *

Magyar

=item *

English

=item *

Italiano

=item *

Hrvatski

=item *

Français

=item *

한국어

=item *

Svenska

=item *

Español

=item *

Deutsch

=item *

čeština

=item *

Nederlands

=item *

Slovenski

=item *

Suomeksi

=item *

Dansk

=item *

中文

=back

=head1 AUTHOR

Andrew Jones <andrew@arjones.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Andrew Jones.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

