#!/usr/bin/perl
use 5.010; use strict; use warnings; use utf8;

package Lingua::EN::Titlecase::Simple;
$Lingua::EN::Titlecase::Simple::VERSION = '1.001';
# ABSTRACT: John Gruber's headline capitalization script

eval "use Exporter::Tidy all => [ 'titlecase' ]" if defined caller;

our @SMALL_WORD
	= qw/ (?<!q&)a an and as at(?!&t) but by en for if in of on or the to v[.]? via vs[.]? /;

sub titlecase {
	my @str = @_ or return;

	for ( @str ) {
		s{\A\s+}{}, s{\s+\z}{};

		$_ = lc $_ unless /[[:lower:]]/;

		state $apos = q/ (?: ['’] [[:lower:]]* )? /;
		state $small_re = join '|', @SMALL_WORD;

		s{
			\b _*\K (?:
				( (?<=[ ][/\\]) [[:alpha:]]+ [-_[:alpha:]/\\]+ |   # file path or
				[-_[:alpha:]]+ [@.:] [-_[:alpha:]@.:/]+ $apos )    # URL, domain, or email
				|
				( (?i) $small_re $apos )                           # or small word (case-insensitive)
				|
				( [[:alpha:]] [[:lower:]'’()\[\]{}]* $apos )       # or word w/o internal caps
				|
				( [[:alpha:]] [[:alpha:]'’()\[\]{}]* $apos )       # or some other word
			) (?= _* \b )
		}{
			; defined $1 ? $1         # preserve URL, domain, or email
			: defined $2 ? lc $2      # lowercase small word
			: defined $3 ? ucfirst $3 # capitalize lower-case word
			: $4                      # preserve other kinds of word
		}exgo;

		# exceptions for small words: capitalize at start and end of title
		s{
			(?: \A [[:punct:]]*        # start of title...
			|  [:.;?!][ ]+             # or of subsentence...
			|  [ ]['"“‘(\[][ ]*     )  # or of inserted subphrase...
			\K
			( $small_re ) \b           # ... followed by small word
		}{\u\L$1}xigo;

		s{
			\b ( $small_re )      # small word...
			(?= [[:punct:]]* \Z   # ... at the end of the title...
			|   ['"’”)\]] [ ] )   # ... or of an inserted subphrase?
		}{\u\L$1}xigo;
	}

	wantarray ? @str : ( @str > 1 ) ? \@str : $str[0];
}

return 1 if defined caller;

eval 'use open qw( :encoding(UTF-8) :std )';
my $opt_force = @ARGV && '-f' eq $ARGV[0];
shift @ARGV if $opt_force;
shift @ARGV if @ARGV && '--' eq $ARGV[0];
print titlecase( $opt_force ? lc : $_ ), "\n" while readline;
