use v5.10.0;
package JMAP::Tester::Response::Paragraph;
# ABSTRACT: a group of sentences in a JMAP response
$JMAP::Tester::Response::Paragraph::VERSION = '0.001';
use Moo;

has sentences => (is => 'bare', reader => '_sentences', required => 1);

sub sentences { @{ $_[0]->_sentences } }

sub single {
  my ($self, $name) = @_;

  my @sentences = $self->sentences;

  Carp::confess("more than one sentence in set, but ->single called")
    if @sentences > 1;

  Carp::confess("single sentence not of expected name <$name>")
    if defined $name && $name ne $sentences[0]->name;

  return $sentences[0];
}

sub as_struct {
  [ map {; $_->as_struct } $_[0]->sentences ]
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JMAP::Tester::Response::Paragraph - a group of sentences in a JMAP response

=head1 VERSION

version 0.001

=head1 AUTHOR

Ricardo Signes <rjbs@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by FastMail, Ltd..

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
