use Evo::Base -strict;
use Evo::Manager;
use Benchmark ':all';
use Test::More;
use Evo;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my ($L, $n);

sub recursive {
  $L--;
  return unless $L > 0;
  Evo::asap { recursive() };
}

my $N      = 10;
my $EXPECT = 5;
my ($t, $perf);

$t = timeit(
  $N,
  sub {
    $L = 100_000;
    $n = $L;
    recursive();
    diag "$n calls";
  }
);

diag "$L: " . timestr $t;
$perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";


$t = timeit(
  $N,
  sub {
    $L = 100_000;
    $n = $L;
    Evo::asap { recursive() };
    diag "$n calls";
  }
);

diag "$L: " . timestr $t;
$perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";
done_testing;
