#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = '0.09';

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'WRAPPER' => 41,
			'FILTER' => 73,
			'FOR' => 72,
			'GET' => 42,
			'SWITCH' => 74,
			'UNLESS' => 67,
			"\$" => 33,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'LITERAL' => 37,
			'META' => 38,
			'INCLUDE' => 66,
			'RAW' => 31,
			'CALL' => 60,
			'RETURN' => 21,
			"(" => 22,
			"\${" => 24,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			"{" => 28,
			'WHILE' => 15,
			'IF' => 17,
			'rawperl' => 18,
			'IDENT' => 56,
			";" => -19,
			'NUMBER' => 59,
			'INSERT' => 9,
			'TRY' => 11,
			'SET' => 54,
			'JAVASCRIPT' => 13,
			'CLEAR' => 1,
			'MACRO' => 2,
			"\"" => 49,
			'NEXT' => 50,
			'BLOCK' => 51,
			"[" => 5,
			'LAST' => 6,
			'THROW' => 7,
			'STOP' => 8,
			'PROCESS' => 52,
			'TEXT' => 44,
			'DEBUG' => 45,
			'REF' => 48
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 43,
			'sterm' => 47,
			'directive' => 46,
			'try' => 3,
			'atomexpr' => 4,
			'condition' => 53,
			'expr' => 10,
			'block' => 14,
			'raw' => 12,
			'chunk' => 57,
			'item' => 55,
			'template' => 16,
			'lterm' => 19,
			'filter' => 58,
			'atomdir' => 23,
			'javascript' => 20,
			'defblock' => 27,
			'assign' => 65,
			'view' => 29,
			'wrapper' => 64,
			'ident' => 62,
			'loop' => 26,
			'capture' => 32,
			'node' => 30,
			'use' => 34,
			'anonblock' => 69,
			'statement' => 68,
			'chunks' => 70,
			'setlist' => 71,
			'macro' => 40,
			'switch' => 39,
			'defblockname' => 75
		}
	},
	{#State 1
		DEFAULT => -40
	},
	{#State 2
		ACTIONS => {
			'IDENT' => 76
		}
	},
	{#State 3
		DEFAULT => -25
	},
	{#State 4
		ACTIONS => {
			'IF' => 79,
			'WHILE' => 78,
			'UNLESS' => 80,
			'WRAPPER' => 77,
			'FOR' => 81,
			'FILTER' => 82
		}
	},
	{#State 5
		ACTIONS => {
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5,
			"]" => 84,
			"\${" => 24,
			"\$" => 33,
			"{" => 28,
			'LITERAL' => 83,
			'REF' => 48
		},
		GOTOS => {
			'item' => 55,
			'list' => 86,
			'lterm' => 19,
			'node' => 30,
			'range' => 85,
			'term' => 88,
			'sterm' => 87,
			'ident' => 89
		}
	},
	{#State 6
		DEFAULT => -41
	},
	{#State 7
		ACTIONS => {
			'LITERAL' => 92,
			'NUMBER' => 97,
			'IDENT' => 98,
			"\"" => 100,
			'FILENAME' => 91,
			"\$" => 93
		},
		GOTOS => {
			'filename' => 90,
			'names' => 96,
			'nameargs' => 94,
			'name' => 95,
			'filepart' => 99
		}
	},
	{#State 8
		DEFAULT => -39
	},
	{#State 9
		ACTIONS => {
			"\$" => 93,
			"\"" => 100,
			'FILENAME' => 91,
			'IDENT' => 98,
			'NUMBER' => 97,
			'LITERAL' => 92
		},
		GOTOS => {
			'nameargs' => 101,
			'filename' => 90,
			'names' => 96,
			'name' => 95,
			'filepart' => 99
		}
	},
	{#State 10
		ACTIONS => {
			'CMPOP' => 105,
			"?" => 103,
			"+" => 102,
			'BINOP' => 110,
			'OR' => 109,
			'AND' => 107,
			'CAT' => 111,
			";" => -17,
			"/" => 108,
			'MOD' => 106,
			'DIV' => 104
		},
		DEFAULT => -28
	},
	{#State 11
		ACTIONS => {
			";" => 112
		}
	},
	{#State 12
		DEFAULT => -14
	},
	{#State 13
		ACTIONS => {
			";" => 113
		}
	},
	{#State 14
		DEFAULT => -1
	},
	{#State 15
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			'NOT' => 63,
			'REF' => 48,
			"{" => 28,
			'LITERAL' => 83,
			"\$" => 33,
			"\${" => 24,
			"(" => 22
		},
		GOTOS => {
			'item' => 55,
			'term' => 43,
			'expr' => 114,
			'lterm' => 19,
			'node' => 30,
			'sterm' => 47,
			'ident' => 89
		}
	},
	{#State 16
		ACTIONS => {
			'' => 115
		}
	},
	{#State 17
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			'REF' => 48,
			'NOT' => 63,
			'LITERAL' => 83,
			"{" => 28,
			"\$" => 33,
			"\${" => 24,
			"(" => 22
		},
		GOTOS => {
			'ident' => 89,
			'sterm' => 47,
			'lterm' => 19,
			'node' => 30,
			'expr' => 116,
			'item' => 55,
			'term' => 43
		}
	},
	{#State 18
		DEFAULT => -16
	},
	{#State 19
		DEFAULT => -104
	},
	{#State 20
		DEFAULT => -26
	},
	{#State 21
		DEFAULT => -38
	},
	{#State 22
		ACTIONS => {
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59,
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			'NOT' => 63,
			'REF' => 48,
			"{" => 28,
			'LITERAL' => 37
		},
		GOTOS => {
			'item' => 55,
			'lterm' => 19,
			'node' => 30,
			'expr' => 117,
			'term' => 43,
			'ident' => 119,
			'sterm' => 47,
			'assign' => 118
		}
	},
	{#State 23
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 24
		ACTIONS => {
			'LITERAL' => 83,
			'NUMBER' => 59,
			'REF' => 48,
			"\${" => 24,
			'IDENT' => 56,
			"\"" => 49,
			"\$" => 33
		},
		GOTOS => {
			'node' => 30,
			'ident' => 89,
			'sterm' => 120,
			'item' => 55
		}
	},
	{#State 25
		ACTIONS => {
			'NUMBER' => 97,
			'LITERAL' => 122,
			"\$" => 121,
			'IDENT' => 127,
			"\${" => 24,
			'FILENAME' => 91,
			"\"" => 128
		},
		GOTOS => {
			'lvalue' => 124,
			'nameargs' => 123,
			'item' => 126,
			'filepart' => 99,
			'name' => 95,
			'lnameargs' => 125,
			'names' => 96,
			'filename' => 90
		}
	},
	{#State 26
		DEFAULT => -24
	},
	{#State 27
		DEFAULT => -9
	},
	{#State 28
		ACTIONS => {
			'IDENT' => 56,
			"\${" => 24,
			"\$" => 33,
			'LITERAL' => 129
		},
		DEFAULT => -120,
		GOTOS => {
			'item' => 133,
			'params' => 132,
			'param' => 131,
			'hash' => 130
		}
	},
	{#State 29
		DEFAULT => -15
	},
	{#State 30
		DEFAULT => -128
	},
	{#State 31
		ACTIONS => {
			"\$" => 121,
			'FILENAME' => 91,
			"\"" => 128,
			"\${" => 24,
			'IDENT' => 127,
			'NUMBER' => 97,
			'LITERAL' => 122
		},
		GOTOS => {
			'item' => 126,
			'name' => 95,
			'filepart' => 99,
			'nameargs' => 123,
			'lvalue' => 124,
			'filename' => 90,
			'names' => 96,
			'lnameargs' => 134
		}
	},
	{#State 32
		DEFAULT => -11
	},
	{#State 33
		ACTIONS => {
			'IDENT' => 135
		}
	},
	{#State 34
		DEFAULT => -13
	},
	{#State 35
		ACTIONS => {
			'LITERAL' => 138,
			"\$" => 33,
			'IDENT' => 56,
			"\${" => 24
		},
		GOTOS => {
			'item' => 55,
			'ident' => 137,
			'setlist' => 136,
			'node' => 30,
			'assign' => 65
		}
	},
	{#State 36
		ACTIONS => {
			'NUMBER' => 97,
			'LITERAL' => 92,
			"\$" => 93,
			'IDENT' => 98,
			'FILENAME' => 91,
			"\"" => 100
		},
		GOTOS => {
			'name' => 95,
			'filepart' => 99,
			'nameargs' => 139,
			'filename' => 90,
			'names' => 96
		}
	},
	{#State 37
		ACTIONS => {
			'ASSIGN' => 140
		},
		DEFAULT => -113
	},
	{#State 38
		ACTIONS => {
			'IDENT' => 142
		},
		GOTOS => {
			'meta' => 143,
			'metadata' => 141
		}
	},
	{#State 39
		DEFAULT => -23
	},
	{#State 40
		DEFAULT => -12
	},
	{#State 41
		ACTIONS => {
			'NUMBER' => 97,
			'LITERAL' => 92,
			"\$" => 93,
			"\"" => 100,
			'FILENAME' => 91,
			'IDENT' => 98
		},
		GOTOS => {
			'name' => 95,
			'filepart' => 99,
			'nameargs' => 144,
			'filename' => 90,
			'names' => 96
		}
	},
	{#State 42
		ACTIONS => {
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			'REF' => 48,
			'NOT' => 63,
			'LITERAL' => 83,
			"{" => 28,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'item' => 55,
			'term' => 43,
			'expr' => 145,
			'sterm' => 47,
			'ident' => 89,
			'lterm' => 19,
			'node' => 30
		}
	},
	{#State 43
		DEFAULT => -147
	},
	{#State 44
		DEFAULT => -6
	},
	{#State 45
		ACTIONS => {
			'LITERAL' => 92,
			'NUMBER' => 97,
			'IDENT' => 98,
			'FILENAME' => 91,
			"\"" => 100,
			"\$" => 93
		},
		GOTOS => {
			'filename' => 90,
			'names' => 96,
			'nameargs' => 146,
			'name' => 95,
			'filepart' => 99
		}
	},
	{#State 46
		DEFAULT => -8
	},
	{#State 47
		DEFAULT => -105
	},
	{#State 48
		ACTIONS => {
			"\${" => 24,
			'IDENT' => 56,
			"\$" => 33
		},
		GOTOS => {
			'item' => 55,
			'node' => 30,
			'ident' => 147
		}
	},
	{#State 49
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 148
		}
	},
	{#State 50
		DEFAULT => -42
	},
	{#State 51
		ACTIONS => {
			'FILENAME' => 91,
			'IDENT' => 151,
			'NUMBER' => 97,
			'LITERAL' => 153
		},
		DEFAULT => -88,
		GOTOS => {
			'filepart' => 99,
			'metadata' => 149,
			'blockname' => 150,
			'meta' => 143,
			'filename' => 154,
			'blockargs' => 152
		}
	},
	{#State 52
		ACTIONS => {
			'LITERAL' => 92,
			'NUMBER' => 97,
			"\"" => 100,
			'FILENAME' => 91,
			'IDENT' => 98,
			"\$" => 93
		},
		GOTOS => {
			'nameargs' => 155,
			'filename' => 90,
			'names' => 96,
			'name' => 95,
			'filepart' => 99
		}
	},
	{#State 53
		DEFAULT => -22
	},
	{#State 54
		ACTIONS => {
			"\$" => 33,
			'IDENT' => 56,
			"\${" => 24,
			'LITERAL' => 138
		},
		GOTOS => {
			'assign' => 65,
			'node' => 30,
			'setlist' => 156,
			'ident' => 137,
			'item' => 55
		}
	},
	{#State 55
		ACTIONS => {
			"(" => 157
		},
		DEFAULT => -129
	},
	{#State 56
		DEFAULT => -131
	},
	{#State 57
		DEFAULT => -5
	},
	{#State 58
		DEFAULT => -45
	},
	{#State 59
		DEFAULT => -114
	},
	{#State 60
		ACTIONS => {
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			'REF' => 48,
			'NOT' => 63,
			'LITERAL' => 83,
			"{" => 28,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'term' => 43,
			'item' => 55,
			'expr' => 158,
			'lterm' => 19,
			'node' => 30,
			'ident' => 89,
			'sterm' => 47
		}
	},
	{#State 61
		DEFAULT => -27
	},
	{#State 62
		ACTIONS => {
			'DOT' => 160,
			'ASSIGN' => 159
		},
		DEFAULT => -110
	},
	{#State 63
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			'NOT' => 63,
			'REF' => 48,
			'LITERAL' => 83,
			"{" => 28,
			"\$" => 33,
			"\${" => 24,
			"(" => 22
		},
		GOTOS => {
			'expr' => 161,
			'item' => 55,
			'term' => 43,
			'node' => 30,
			'lterm' => 19,
			'sterm' => 47,
			'ident' => 89
		}
	},
	{#State 64
		DEFAULT => -44
	},
	{#State 65
		DEFAULT => -150
	},
	{#State 66
		ACTIONS => {
			'NUMBER' => 97,
			'LITERAL' => 92,
			"\$" => 93,
			"\"" => 100,
			'FILENAME' => 91,
			'IDENT' => 98
		},
		GOTOS => {
			'name' => 95,
			'filepart' => 99,
			'nameargs' => 162,
			'filename' => 90,
			'names' => 96
		}
	},
	{#State 67
		ACTIONS => {
			"\${" => 24,
			"(" => 22,
			"\$" => 33,
			"{" => 28,
			'LITERAL' => 83,
			'REF' => 48,
			'NOT' => 63,
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5
		},
		GOTOS => {
			'term' => 43,
			'item' => 55,
			'expr' => 163,
			'ident' => 89,
			'sterm' => 47,
			'node' => 30,
			'lterm' => 19
		}
	},
	{#State 68
		ACTIONS => {
			";" => 164
		}
	},
	{#State 69
		DEFAULT => -10
	},
	{#State 70
		ACTIONS => {
			'DEFAULT' => 35,
			'VIEW' => 36,
			'LITERAL' => 37,
			'META' => 38,
			'UNLESS' => 67,
			"\$" => 33,
			'FOR' => 72,
			'FILTER' => 73,
			'GET' => 42,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			"{" => 28,
			'CALL' => 60,
			'RETURN' => 21,
			"(" => 22,
			"\${" => 24,
			'RAW' => 31,
			'INCLUDE' => 66,
			'TRY' => 11,
			'SET' => 54,
			'JAVASCRIPT' => 13,
			'INSERT' => 9,
			";" => -19,
			'NUMBER' => 59,
			'WHILE' => 15,
			'IF' => 17,
			'IDENT' => 56,
			'rawperl' => 18,
			'DEBUG' => 45,
			'REF' => 48,
			'TEXT' => 44,
			'LAST' => 6,
			'BLOCK' => 51,
			"[" => 5,
			'THROW' => 7,
			'STOP' => 8,
			'PROCESS' => 52,
			'CLEAR' => 1,
			'MACRO' => 2,
			"\"" => 49,
			'NEXT' => 50
		},
		DEFAULT => -2,
		GOTOS => {
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'defblock' => 27,
			'assign' => 65,
			'view' => 29,
			'directive' => 46,
			'loop' => 26,
			'sterm' => 47,
			'wrapper' => 64,
			'ident' => 62,
			'atomexpr' => 4,
			'try' => 3,
			'condition' => 53,
			'capture' => 32,
			'node' => 30,
			'use' => 34,
			'anonblock' => 69,
			'statement' => 68,
			'expr' => 10,
			'raw' => 12,
			'setlist' => 71,
			'item' => 55,
			'chunk' => 165,
			'switch' => 39,
			'macro' => 40,
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19
		}
	},
	{#State 71
		ACTIONS => {
			'LITERAL' => 138,
			'IDENT' => 56,
			"\${" => 24,
			'COMMA' => 167,
			"\$" => 33
		},
		DEFAULT => -20,
		GOTOS => {
			'node' => 30,
			'ident' => 137,
			'assign' => 166,
			'item' => 55
		}
	},
	{#State 72
		ACTIONS => {
			"[" => 5,
			'NUMBER' => 59,
			"\"" => 49,
			'IDENT' => 168,
			"{" => 28,
			'LITERAL' => 83,
			'REF' => 48,
			"\${" => 24,
			"\$" => 33
		},
		GOTOS => {
			'item' => 55,
			'term' => 169,
			'sterm' => 47,
			'ident' => 89,
			'loopvar' => 170,
			'lterm' => 19,
			'node' => 30
		}
	},
	{#State 73
		ACTIONS => {
			'LITERAL' => 122,
			'NUMBER' => 97,
			'FILENAME' => 91,
			"\"" => 128,
			'IDENT' => 127,
			"\${" => 24,
			"\$" => 121
		},
		GOTOS => {
			'names' => 96,
			'lnameargs' => 171,
			'filename' => 90,
			'nameargs' => 123,
			'lvalue' => 124,
			'item' => 126,
			'filepart' => 99,
			'name' => 95
		}
	},
	{#State 74
		ACTIONS => {
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5,
			"\${" => 24,
			"(" => 22,
			"\$" => 33,
			'LITERAL' => 83,
			"{" => 28,
			'NOT' => 63,
			'REF' => 48
		},
		GOTOS => {
			'item' => 55,
			'term' => 43,
			'expr' => 172,
			'lterm' => 19,
			'node' => 30,
			'ident' => 89,
			'sterm' => 47
		}
	},
	{#State 75
		ACTIONS => {
			'IDENT' => 142
		},
		DEFAULT => -88,
		GOTOS => {
			'metadata' => 149,
			'meta' => 143,
			'blockargs' => 173
		}
	},
	{#State 76
		ACTIONS => {
			'DEFAULT' => 35,
			'LITERAL' => 37,
			"\$" => 33,
			'UNLESS' => 67,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'NOT' => 63,
			'perl' => 61,
			"{" => 28,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 178,
			'INCLUDE' => 66,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'INSERT' => 9,
			'NUMBER' => 59,
			'IF' => 17,
			'WHILE' => 15,
			'IDENT' => 56,
			'REF' => 48,
			'DEBUG' => 45,
			'THROW' => 7,
			'LAST' => 6,
			'BLOCK' => 174,
			"[" => 5,
			'PROCESS' => 52,
			'STOP' => 8,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49
		},
		GOTOS => {
			'setlist' => 71,
			'mdir' => 176,
			'expr' => 177,
			'filter' => 58,
			'lterm' => 19,
			'item' => 55,
			'switch' => 39,
			'assign' => 65,
			'wrapper' => 64,
			'loop' => 26,
			'directive' => 175,
			'sterm' => 47,
			'ident' => 119,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'condition' => 53,
			'node' => 30,
			'try' => 3,
			'atomexpr' => 4
		}
	},
	{#State 77
		ACTIONS => {
			"\$" => 93,
			"\"" => 100,
			'FILENAME' => 91,
			'IDENT' => 98,
			'NUMBER' => 97,
			'LITERAL' => 92
		},
		GOTOS => {
			'name' => 95,
			'filepart' => 99,
			'filename' => 90,
			'names' => 96,
			'nameargs' => 179
		}
	},
	{#State 78
		ACTIONS => {
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5,
			"\$" => 33,
			"\${" => 24,
			"(" => 22,
			'REF' => 48,
			'NOT' => 63,
			'LITERAL' => 83,
			"{" => 28
		},
		GOTOS => {
			'expr' => 180,
			'term' => 43,
			'item' => 55,
			'lterm' => 19,
			'node' => 30,
			'sterm' => 47,
			'ident' => 89
		}
	},
	{#State 79
		ACTIONS => {
			"\$" => 33,
			"\${" => 24,
			"(" => 22,
			'REF' => 48,
			'NOT' => 63,
			"{" => 28,
			'LITERAL' => 83,
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5
		},
		GOTOS => {
			'node' => 30,
			'lterm' => 19,
			'ident' => 89,
			'sterm' => 47,
			'expr' => 181,
			'item' => 55,
			'term' => 43
		}
	},
	{#State 80
		ACTIONS => {
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5,
			"\${" => 24,
			"(" => 22,
			"\$" => 33,
			'LITERAL' => 83,
			"{" => 28,
			'NOT' => 63,
			'REF' => 48
		},
		GOTOS => {
			'expr' => 182,
			'term' => 43,
			'item' => 55,
			'ident' => 89,
			'sterm' => 47,
			'lterm' => 19,
			'node' => 30
		}
	},
	{#State 81
		ACTIONS => {
			"\$" => 33,
			"\${" => 24,
			'REF' => 48,
			'LITERAL' => 83,
			"{" => 28,
			"\"" => 49,
			'IDENT' => 168,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'term' => 169,
			'item' => 55,
			'sterm' => 47,
			'ident' => 89,
			'lterm' => 19,
			'node' => 30,
			'loopvar' => 183
		}
	},
	{#State 82
		ACTIONS => {
			'FILENAME' => 91,
			"\"" => 128,
			'IDENT' => 127,
			"\${" => 24,
			"\$" => 121,
			'LITERAL' => 122,
			'NUMBER' => 97
		},
		GOTOS => {
			'nameargs' => 123,
			'lvalue' => 124,
			'item' => 126,
			'name' => 95,
			'filepart' => 99,
			'filename' => 90,
			'lnameargs' => 184,
			'names' => 96
		}
	},
	{#State 83
		DEFAULT => -113
	},
	{#State 84
		DEFAULT => -108
	},
	{#State 85
		ACTIONS => {
			"]" => 185
		}
	},
	{#State 86
		ACTIONS => {
			'COMMA' => 187,
			"\$" => 33,
			"]" => 188,
			"\${" => 24,
			'REF' => 48,
			'LITERAL' => 83,
			"{" => 28,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'term' => 186,
			'item' => 55,
			'ident' => 89,
			'sterm' => 47,
			'lterm' => 19,
			'node' => 30
		}
	},
	{#State 87
		ACTIONS => {
			'TO' => 189
		},
		DEFAULT => -105
	},
	{#State 88
		DEFAULT => -117
	},
	{#State 89
		ACTIONS => {
			'DOT' => 160
		},
		DEFAULT => -110
	},
	{#State 90
		ACTIONS => {
			'DOT' => 190
		},
		DEFAULT => -169
	},
	{#State 91
		DEFAULT => -173
	},
	{#State 92
		DEFAULT => -170
	},
	{#State 93
		ACTIONS => {
			"\${" => 24,
			'IDENT' => 56,
			"\$" => 33
		},
		GOTOS => {
			'item' => 55,
			'ident' => 191,
			'node' => 30
		}
	},
	{#State 94
		DEFAULT => -37
	},
	{#State 95
		DEFAULT => -167
	},
	{#State 96
		ACTIONS => {
			"(" => 194,
			"+" => 193
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 192
		}
	},
	{#State 97
		DEFAULT => -175
	},
	{#State 98
		DEFAULT => -174
	},
	{#State 99
		DEFAULT => -172
	},
	{#State 100
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 195
		}
	},
	{#State 101
		DEFAULT => -34
	},
	{#State 102
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			'REF' => 48,
			'NOT' => 63,
			"{" => 28,
			'LITERAL' => 83,
			"\$" => 33,
			"\${" => 24,
			"(" => 22
		},
		GOTOS => {
			'expr' => 196,
			'term' => 43,
			'item' => 55,
			'sterm' => 47,
			'ident' => 89,
			'node' => 30,
			'lterm' => 19
		}
	},
	{#State 103
		ACTIONS => {
			'NOT' => 63,
			'REF' => 48,
			'LITERAL' => 83,
			"{" => 28,
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			"[" => 5,
			'NUMBER' => 59,
			"\"" => 49,
			'IDENT' => 56
		},
		GOTOS => {
			'sterm' => 47,
			'ident' => 89,
			'lterm' => 19,
			'node' => 30,
			'term' => 43,
			'item' => 55,
			'expr' => 197
		}
	},
	{#State 104
		ACTIONS => {
			"{" => 28,
			'LITERAL' => 83,
			'REF' => 48,
			'NOT' => 63,
			"\${" => 24,
			"(" => 22,
			"\$" => 33,
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49
		},
		GOTOS => {
			'sterm' => 47,
			'ident' => 89,
			'node' => 30,
			'lterm' => 19,
			'term' => 43,
			'item' => 55,
			'expr' => 198
		}
	},
	{#State 105
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			'LITERAL' => 83,
			"{" => 28,
			'NOT' => 63,
			'REF' => 48,
			"\${" => 24,
			"(" => 22,
			"\$" => 33
		},
		GOTOS => {
			'item' => 55,
			'term' => 43,
			'expr' => 199,
			'lterm' => 19,
			'node' => 30,
			'ident' => 89,
			'sterm' => 47
		}
	},
	{#State 106
		ACTIONS => {
			"(" => 22,
			"\${" => 24,
			"\$" => 33,
			"{" => 28,
			'LITERAL' => 83,
			'REF' => 48,
			'NOT' => 63,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'node' => 30,
			'lterm' => 19,
			'ident' => 89,
			'sterm' => 47,
			'expr' => 200,
			'item' => 55,
			'term' => 43
		}
	},
	{#State 107
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			'LITERAL' => 83,
			"{" => 28,
			'NOT' => 63,
			'REF' => 48,
			"\${" => 24,
			"(" => 22,
			"\$" => 33
		},
		GOTOS => {
			'expr' => 201,
			'term' => 43,
			'item' => 55,
			'lterm' => 19,
			'node' => 30,
			'ident' => 89,
			'sterm' => 47
		}
	},
	{#State 108
		ACTIONS => {
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59,
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			'REF' => 48,
			'NOT' => 63,
			'LITERAL' => 83,
			"{" => 28
		},
		GOTOS => {
			'term' => 43,
			'item' => 55,
			'expr' => 202,
			'node' => 30,
			'lterm' => 19,
			'sterm' => 47,
			'ident' => 89
		}
	},
	{#State 109
		ACTIONS => {
			'NOT' => 63,
			'REF' => 48,
			"{" => 28,
			'LITERAL' => 83,
			"\$" => 33,
			"\${" => 24,
			"(" => 22,
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49
		},
		GOTOS => {
			'term' => 43,
			'item' => 55,
			'expr' => 203,
			'lterm' => 19,
			'node' => 30,
			'ident' => 89,
			'sterm' => 47
		}
	},
	{#State 110
		ACTIONS => {
			"[" => 5,
			'NUMBER' => 59,
			"\"" => 49,
			'IDENT' => 56,
			'REF' => 48,
			'NOT' => 63,
			'LITERAL' => 83,
			"{" => 28,
			"\$" => 33,
			"(" => 22,
			"\${" => 24
		},
		GOTOS => {
			'node' => 30,
			'lterm' => 19,
			'ident' => 89,
			'sterm' => 47,
			'expr' => 204,
			'term' => 43,
			'item' => 55
		}
	},
	{#State 111
		ACTIONS => {
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			'NOT' => 63,
			'REF' => 48,
			"{" => 28,
			'LITERAL' => 83,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'expr' => 205,
			'item' => 55,
			'term' => 43,
			'lterm' => 19,
			'node' => 30,
			'sterm' => 47,
			'ident' => 89
		}
	},
	{#State 112
		ACTIONS => {
			'WRAPPER' => 41,
			'GET' => 42,
			'FILTER' => 73,
			'FOR' => 72,
			'SWITCH' => 74,
			"\$" => 33,
			'UNLESS' => 67,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			'INCLUDE' => 66,
			'RAW' => 31,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			"{" => 28,
			'IF' => 17,
			'WHILE' => 15,
			'IDENT' => 56,
			'rawperl' => 18,
			'NUMBER' => 59,
			";" => -19,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'THROW' => 7,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'STOP' => 8,
			'PROCESS' => 52,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 43,
			'atomdir' => 23,
			'javascript' => 20,
			'defblock' => 27,
			'assign' => 65,
			'view' => 29,
			'loop' => 26,
			'ident' => 62,
			'wrapper' => 64,
			'directive' => 46,
			'sterm' => 47,
			'atomexpr' => 4,
			'try' => 3,
			'capture' => 32,
			'condition' => 53,
			'node' => 30,
			'anonblock' => 69,
			'use' => 34,
			'expr' => 10,
			'statement' => 68,
			'block' => 206,
			'chunks' => 70,
			'setlist' => 71,
			'raw' => 12,
			'chunk' => 57,
			'item' => 55,
			'macro' => 40,
			'switch' => 39,
			'defblockname' => 75,
			'lterm' => 19,
			'filter' => 58
		}
	},
	{#State 113
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 207
		}
	},
	{#State 114
		ACTIONS => {
			'CMPOP' => 105,
			"?" => 103,
			'AND' => 107,
			'MOD' => 106,
			'OR' => 109,
			'BINOP' => 110,
			'DIV' => 104,
			"/" => 108,
			";" => 208,
			'CAT' => 111,
			"+" => 102
		}
	},
	{#State 115
		DEFAULT => 0
	},
	{#State 116
		ACTIONS => {
			"?" => 103,
			'CMPOP' => 105,
			'AND' => 107,
			'CAT' => 111,
			";" => 209,
			"/" => 108,
			"+" => 102,
			'MOD' => 106,
			'OR' => 109,
			'BINOP' => 110,
			'DIV' => 104
		}
	},
	{#State 117
		ACTIONS => {
			"+" => 102,
			'CAT' => 111,
			"/" => 108,
			'DIV' => 104,
			'BINOP' => 110,
			'OR' => 109,
			'MOD' => 106,
			'AND' => 107,
			")" => 210,
			"?" => 103,
			'CMPOP' => 105
		}
	},
	{#State 118
		ACTIONS => {
			")" => 211
		}
	},
	{#State 119
		ACTIONS => {
			'ASSIGN' => 212,
			'DOT' => 160
		},
		DEFAULT => -110
	},
	{#State 120
		ACTIONS => {
			"}" => 213
		}
	},
	{#State 121
		ACTIONS => {
			'IDENT' => 214,
			"\${" => 24,
			"\$" => 33
		},
		GOTOS => {
			'item' => 55,
			'ident' => 191,
			'node' => 30
		}
	},
	{#State 122
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 123
		DEFAULT => -159
	},
	{#State 124
		ACTIONS => {
			'ASSIGN' => 215
		}
	},
	{#State 125
		DEFAULT => -75
	},
	{#State 126
		DEFAULT => -160
	},
	{#State 127
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 128
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 216
		}
	},
	{#State 129
		ACTIONS => {
			'ASSIGN' => 217
		}
	},
	{#State 130
		ACTIONS => {
			"}" => 218
		}
	},
	{#State 131
		DEFAULT => -123
	},
	{#State 132
		ACTIONS => {
			'LITERAL' => 129,
			"\${" => 24,
			'IDENT' => 56,
			'COMMA' => 219,
			"\$" => 33
		},
		DEFAULT => -119,
		GOTOS => {
			'param' => 220,
			'item' => 133
		}
	},
	{#State 133
		ACTIONS => {
			'ASSIGN' => 221
		}
	},
	{#State 134
		DEFAULT => -76
	},
	{#State 135
		DEFAULT => -133
	},
	{#State 136
		ACTIONS => {
			"\$" => 33,
			'COMMA' => 167,
			"\${" => 24,
			'LITERAL' => 138,
			'IDENT' => 56
		},
		DEFAULT => -33,
		GOTOS => {
			'item' => 55,
			'node' => 30,
			'ident' => 137,
			'assign' => 166
		}
	},
	{#State 137
		ACTIONS => {
			'DOT' => 160,
			'ASSIGN' => 212
		}
	},
	{#State 138
		ACTIONS => {
			'ASSIGN' => 140
		}
	},
	{#State 139
		ACTIONS => {
			";" => 222
		}
	},
	{#State 140
		ACTIONS => {
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5,
			"\${" => 24,
			"(" => 22,
			"\$" => 33,
			'LITERAL' => 83,
			"{" => 28,
			'NOT' => 63,
			'REF' => 48
		},
		GOTOS => {
			'ident' => 89,
			'sterm' => 47,
			'node' => 30,
			'lterm' => 19,
			'item' => 55,
			'term' => 43,
			'expr' => 223
		}
	},
	{#State 141
		ACTIONS => {
			'IDENT' => 142,
			'COMMA' => 225
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 224
		}
	},
	{#State 142
		ACTIONS => {
			'ASSIGN' => 226
		}
	},
	{#State 143
		DEFAULT => -100
	},
	{#State 144
		ACTIONS => {
			";" => 227
		}
	},
	{#State 145
		ACTIONS => {
			'CAT' => 111,
			"/" => 108,
			'MOD' => 106,
			'DIV' => 104,
			'AND' => 107,
			"+" => 102,
			'BINOP' => 110,
			'OR' => 109,
			"?" => 103,
			'CMPOP' => 105
		},
		DEFAULT => -30
	},
	{#State 146
		DEFAULT => -43
	},
	{#State 147
		ACTIONS => {
			'DOT' => 160
		},
		DEFAULT => -111
	},
	{#State 148
		ACTIONS => {
			'IDENT' => 56,
			"\${" => 24,
			'TEXT' => 228,
			"\"" => 229,
			"\$" => 33,
			";" => 230
		},
		GOTOS => {
			'node' => 30,
			'ident' => 231,
			'quotable' => 232,
			'item' => 55
		}
	},
	{#State 149
		ACTIONS => {
			'IDENT' => 142,
			'COMMA' => 225
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 224
		}
	},
	{#State 150
		DEFAULT => -84
	},
	{#State 151
		ACTIONS => {
			'ASSIGN' => 226
		},
		DEFAULT => -174
	},
	{#State 152
		ACTIONS => {
			";" => 233
		}
	},
	{#State 153
		DEFAULT => -86
	},
	{#State 154
		ACTIONS => {
			'DOT' => 190
		},
		DEFAULT => -85
	},
	{#State 155
		DEFAULT => -36
	},
	{#State 156
		ACTIONS => {
			'LITERAL' => 138,
			"\${" => 24,
			"\$" => 33,
			'COMMA' => 167,
			'IDENT' => 56
		},
		DEFAULT => -32,
		GOTOS => {
			'item' => 55,
			'assign' => 166,
			'node' => 30,
			'ident' => 137
		}
	},
	{#State 157
		DEFAULT => -157,
		GOTOS => {
			'args' => 234
		}
	},
	{#State 158
		ACTIONS => {
			'AND' => 107,
			'DIV' => 104,
			'MOD' => 106,
			"/" => 108,
			'CAT' => 111,
			"?" => 103,
			'CMPOP' => 105,
			'OR' => 109,
			'BINOP' => 110,
			"+" => 102
		},
		DEFAULT => -31
	},
	{#State 159
		ACTIONS => {
			'NUMBER' => 59,
			'IF' => 17,
			'WHILE' => 15,
			'IDENT' => 56,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'INSERT' => 9,
			'THROW' => 7,
			'BLOCK' => 174,
			"[" => 5,
			'LAST' => 6,
			'PROCESS' => 52,
			'STOP' => 8,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'REF' => 48,
			'DEBUG' => 45,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'DEFAULT' => 35,
			'LITERAL' => 37,
			"\$" => 33,
			'UNLESS' => 67,
			'INCLUDE' => 66,
			'NOT' => 63,
			'perl' => 61,
			"{" => 28,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22
		},
		GOTOS => {
			'condition' => 53,
			'node' => 30,
			'atomexpr' => 4,
			'try' => 3,
			'assign' => 65,
			'directive' => 175,
			'ident' => 119,
			'wrapper' => 64,
			'sterm' => 47,
			'loop' => 26,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'filter' => 58,
			'lterm' => 19,
			'item' => 55,
			'switch' => 39,
			'setlist' => 71,
			'expr' => 235,
			'mdir' => 236
		}
	},
	{#State 160
		ACTIONS => {
			"\$" => 33,
			'IDENT' => 56,
			"\${" => 24,
			'NUMBER' => 237
		},
		GOTOS => {
			'node' => 238,
			'item' => 55
		}
	},
	{#State 161
		ACTIONS => {
			"+" => 102,
			"/" => 108,
			'DIV' => 104,
			'CMPOP' => 105,
			'BINOP' => 110,
			'CAT' => 111,
			'MOD' => 106
		},
		DEFAULT => -143
	},
	{#State 162
		DEFAULT => -35
	},
	{#State 163
		ACTIONS => {
			"?" => 103,
			'CMPOP' => 105,
			'AND' => 107,
			'MOD' => 106,
			'BINOP' => 110,
			'OR' => 109,
			'DIV' => 104,
			'CAT' => 111,
			"/" => 108,
			";" => 239,
			"+" => 102
		}
	},
	{#State 164
		DEFAULT => -7
	},
	{#State 165
		DEFAULT => -4
	},
	{#State 166
		DEFAULT => -148
	},
	{#State 167
		DEFAULT => -149
	},
	{#State 168
		ACTIONS => {
			'ASSIGN' => 241,
			'IN' => 240
		},
		DEFAULT => -131
	},
	{#State 169
		DEFAULT => -157,
		GOTOS => {
			'args' => 242
		}
	},
	{#State 170
		ACTIONS => {
			";" => 243
		}
	},
	{#State 171
		ACTIONS => {
			";" => 244
		}
	},
	{#State 172
		ACTIONS => {
			"?" => 103,
			'CMPOP' => 105,
			'AND' => 107,
			"+" => 102,
			"/" => 108,
			";" => 245,
			'CAT' => 111,
			'MOD' => 106,
			'DIV' => 104,
			'BINOP' => 110,
			'OR' => 109
		}
	},
	{#State 173
		ACTIONS => {
			";" => 246
		}
	},
	{#State 174
		ACTIONS => {
			";" => 247
		}
	},
	{#State 175
		DEFAULT => -93
	},
	{#State 176
		DEFAULT => -92
	},
	{#State 177
		ACTIONS => {
			"?" => 103,
			'CMPOP' => 105,
			"+" => 102,
			'OR' => 109,
			'BINOP' => 110,
			'AND' => 107,
			'CAT' => 111,
			"/" => 108,
			'DIV' => 104,
			'MOD' => 106
		},
		DEFAULT => -28
	},
	{#State 178
		ACTIONS => {
			'NOT' => 63,
			'REF' => 48,
			'LITERAL' => 37,
			"{" => 28,
			"\$" => 33,
			"\${" => 24,
			"(" => 22,
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 248,
			"\"" => 49
		},
		GOTOS => {
			'term' => 43,
			'expr' => 117,
			'assign' => 118,
			'sterm' => 47,
			'ident' => 119,
			'item' => 55,
			'margs' => 249,
			'node' => 30,
			'lterm' => 19
		}
	},
	{#State 179
		DEFAULT => -68
	},
	{#State 180
		ACTIONS => {
			'CAT' => 111,
			"/" => 108,
			"+" => 102,
			'MOD' => 106,
			'BINOP' => 110,
			'OR' => 109,
			'DIV' => 104,
			'CMPOP' => 105,
			"?" => 103,
			'AND' => 107
		},
		DEFAULT => -63
	},
	{#State 181
		ACTIONS => {
			'CMPOP' => 105,
			"?" => 103,
			'AND' => 107,
			'MOD' => 106,
			'DIV' => 104,
			'BINOP' => 110,
			'OR' => 109,
			"+" => 102,
			'CAT' => 111,
			"/" => 108
		},
		DEFAULT => -47
	},
	{#State 182
		ACTIONS => {
			'AND' => 107,
			"?" => 103,
			'CMPOP' => 105,
			"+" => 102,
			'CAT' => 111,
			"/" => 108,
			'DIV' => 104,
			'BINOP' => 110,
			'OR' => 109,
			'MOD' => 106
		},
		DEFAULT => -49
	},
	{#State 183
		DEFAULT => -60
	},
	{#State 184
		DEFAULT => -82
	},
	{#State 185
		DEFAULT => -107
	},
	{#State 186
		DEFAULT => -115
	},
	{#State 187
		DEFAULT => -116
	},
	{#State 188
		DEFAULT => -106
	},
	{#State 189
		ACTIONS => {
			'REF' => 48,
			'NUMBER' => 59,
			'LITERAL' => 83,
			"\$" => 33,
			"\"" => 49,
			"\${" => 24,
			'IDENT' => 56
		},
		GOTOS => {
			'ident' => 89,
			'sterm' => 250,
			'node' => 30,
			'item' => 55
		}
	},
	{#State 190
		ACTIONS => {
			'NUMBER' => 97,
			'FILENAME' => 91,
			'IDENT' => 98
		},
		GOTOS => {
			'filepart' => 251
		}
	},
	{#State 191
		ACTIONS => {
			'DOT' => 160
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 252
		}
	},
	{#State 192
		ACTIONS => {
			"[" => 5,
			"\"" => 49,
			"{" => 28,
			'NOT' => 63,
			'REF' => 48,
			"\${" => 24,
			"(" => 22,
			'COMMA' => 255,
			'NUMBER' => 59,
			'IDENT' => 56,
			'LITERAL' => 256,
			"\$" => 33
		},
		DEFAULT => -164,
		GOTOS => {
			'term' => 43,
			'expr' => 257,
			'ident' => 253,
			'sterm' => 47,
			'param' => 258,
			'item' => 254,
			'node' => 30,
			'lterm' => 19
		}
	},
	{#State 193
		ACTIONS => {
			'NUMBER' => 97,
			'LITERAL' => 92,
			'IDENT' => 98,
			"\"" => 100,
			'FILENAME' => 91
		},
		GOTOS => {
			'filename' => 90,
			'filepart' => 99,
			'name' => 259
		}
	},
	{#State 194
		DEFAULT => -157,
		GOTOS => {
			'args' => 260
		}
	},
	{#State 195
		ACTIONS => {
			";" => 230,
			"\"" => 261,
			"\${" => 24,
			'TEXT' => 228,
			'IDENT' => 56,
			"\$" => 33
		},
		GOTOS => {
			'item' => 55,
			'quotable' => 232,
			'node' => 30,
			'ident' => 231
		}
	},
	{#State 196
		ACTIONS => {
			'DIV' => 104,
			"/" => 108,
			'MOD' => 106
		},
		DEFAULT => -136
	},
	{#State 197
		ACTIONS => {
			":" => 262,
			'AND' => 107,
			'CMPOP' => 105,
			"?" => 103,
			'DIV' => 104,
			'BINOP' => 110,
			'OR' => 109,
			'MOD' => 106,
			"+" => 102,
			"/" => 108,
			'CAT' => 111
		}
	},
	{#State 198
		ACTIONS => {
			'MOD' => 106
		},
		DEFAULT => -137
	},
	{#State 199
		ACTIONS => {
			"+" => 102,
			'DIV' => 104,
			"/" => 108,
			'BINOP' => 110,
			'MOD' => 106
		},
		DEFAULT => -139
	},
	{#State 200
		DEFAULT => -138
	},
	{#State 201
		ACTIONS => {
			"+" => 102,
			"/" => 108,
			'DIV' => 104,
			'BINOP' => 110,
			'CMPOP' => 105,
			'CAT' => 111,
			'MOD' => 106
		},
		DEFAULT => -141
	},
	{#State 202
		ACTIONS => {
			'DIV' => 104,
			'MOD' => 106
		},
		DEFAULT => -135
	},
	{#State 203
		ACTIONS => {
			'CMPOP' => 105,
			'BINOP' => 110,
			'MOD' => 106,
			'CAT' => 111,
			"+" => 102,
			'DIV' => 104,
			"/" => 108
		},
		DEFAULT => -142
	},
	{#State 204
		ACTIONS => {
			'MOD' => 106,
			"/" => 108,
			'DIV' => 104,
			"+" => 102
		},
		DEFAULT => -134
	},
	{#State 205
		ACTIONS => {
			"+" => 102,
			"/" => 108,
			'DIV' => 104,
			'BINOP' => 110,
			'CMPOP' => 105,
			'MOD' => 106
		},
		DEFAULT => -140
	},
	{#State 206
		ACTIONS => {
			'CATCH' => 265,
			'FINAL' => 263
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 264
		}
	},
	{#State 207
		ACTIONS => {
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			"{" => 28,
			'INCLUDE' => 66,
			'RAW' => 31,
			"\$" => 33,
			'UNLESS' => 67,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			'WRAPPER' => 41,
			'GET' => 42,
			'FILTER' => 73,
			'FOR' => 72,
			'SWITCH' => 74,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'THROW' => 7,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'STOP' => 8,
			'PROCESS' => 52,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'IF' => 17,
			'WHILE' => 15,
			'rawperl' => 18,
			'IDENT' => 56,
			";" => -19,
			'NUMBER' => 59
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 3,
			'atomexpr' => 4,
			'node' => 30,
			'condition' => 53,
			'capture' => 32,
			'javascript' => 20,
			'atomdir' => 23,
			'term' => 43,
			'ident' => 62,
			'wrapper' => 64,
			'sterm' => 47,
			'directive' => 46,
			'loop' => 26,
			'assign' => 65,
			'defblock' => 27,
			'view' => 29,
			'switch' => 39,
			'macro' => 40,
			'item' => 55,
			'chunk' => 57,
			'lterm' => 19,
			'filter' => 58,
			'defblockname' => 75,
			'statement' => 68,
			'expr' => 10,
			'anonblock' => 69,
			'use' => 34,
			'raw' => 12,
			'setlist' => 71,
			'chunks' => 70,
			'block' => 266
		}
	},
	{#State 208
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 267
		}
	},
	{#State 209
		ACTIONS => {
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'INSERT' => 9,
			";" => -19,
			'NUMBER' => 59,
			'IDENT' => 56,
			'rawperl' => 18,
			'IF' => 17,
			'WHILE' => 15,
			'REF' => 48,
			'DEBUG' => 45,
			'TEXT' => 44,
			'PROCESS' => 52,
			'STOP' => 8,
			'THROW' => 7,
			'BLOCK' => 51,
			'LAST' => 6,
			"[" => 5,
			'NEXT' => 50,
			"\"" => 49,
			'MACRO' => 2,
			'CLEAR' => 1,
			'META' => 38,
			'LITERAL' => 37,
			'VIEW' => 36,
			'DEFAULT' => 35,
			"\$" => 33,
			'UNLESS' => 67,
			'SWITCH' => 74,
			'GET' => 42,
			'FILTER' => 73,
			'FOR' => 72,
			'WRAPPER' => 41,
			"{" => 28,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			"\${" => 24,
			"(" => 22,
			'RETURN' => 21,
			'CALL' => 60,
			'RAW' => 31,
			'INCLUDE' => 66
		},
		DEFAULT => -3,
		GOTOS => {
			'expr' => 10,
			'statement' => 68,
			'use' => 34,
			'anonblock' => 69,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'block' => 268,
			'macro' => 40,
			'switch' => 39,
			'chunk' => 57,
			'item' => 55,
			'filter' => 58,
			'lterm' => 19,
			'defblockname' => 75,
			'javascript' => 20,
			'atomdir' => 23,
			'term' => 43,
			'directive' => 46,
			'sterm' => 47,
			'loop' => 26,
			'ident' => 62,
			'wrapper' => 64,
			'defblock' => 27,
			'assign' => 65,
			'view' => 29,
			'atomexpr' => 4,
			'try' => 3,
			'node' => 30,
			'capture' => 32,
			'condition' => 53
		}
	},
	{#State 210
		DEFAULT => -146
	},
	{#State 211
		DEFAULT => -145
	},
	{#State 212
		ACTIONS => {
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59,
			"(" => 22,
			"\${" => 24,
			"\$" => 33,
			'LITERAL' => 83,
			"{" => 28,
			'REF' => 48,
			'NOT' => 63
		},
		GOTOS => {
			'node' => 30,
			'lterm' => 19,
			'ident' => 89,
			'sterm' => 47,
			'expr' => 269,
			'item' => 55,
			'term' => 43
		}
	},
	{#State 213
		DEFAULT => -132
	},
	{#State 214
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 215
		ACTIONS => {
			'NUMBER' => 97,
			'LITERAL' => 92,
			"\$" => 93,
			'FILENAME' => 91,
			"\"" => 100,
			'IDENT' => 98
		},
		GOTOS => {
			'name' => 95,
			'filepart' => 99,
			'filename' => 90,
			'names' => 96,
			'nameargs' => 270
		}
	},
	{#State 216
		ACTIONS => {
			";" => 230,
			"\$" => 33,
			'TEXT' => 228,
			"\${" => 24,
			'IDENT' => 56,
			"\"" => 271
		},
		GOTOS => {
			'node' => 30,
			'ident' => 231,
			'quotable' => 232,
			'item' => 55
		}
	},
	{#State 217
		ACTIONS => {
			"{" => 28,
			'LITERAL' => 83,
			'NOT' => 63,
			'REF' => 48,
			"\${" => 24,
			"(" => 22,
			"\$" => 33,
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49
		},
		GOTOS => {
			'term' => 43,
			'item' => 55,
			'expr' => 272,
			'lterm' => 19,
			'node' => 30,
			'ident' => 89,
			'sterm' => 47
		}
	},
	{#State 218
		DEFAULT => -109
	},
	{#State 219
		DEFAULT => -122
	},
	{#State 220
		DEFAULT => -121
	},
	{#State 221
		ACTIONS => {
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			'NOT' => 63,
			'REF' => 48,
			"{" => 28,
			'LITERAL' => 83,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'node' => 30,
			'lterm' => 19,
			'sterm' => 47,
			'ident' => 89,
			'item' => 55,
			'term' => 43,
			'expr' => 273
		}
	},
	{#State 222
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 274
		}
	},
	{#State 223
		ACTIONS => {
			'CMPOP' => 105,
			"?" => 103,
			'BINOP' => 110,
			'OR' => 109,
			"+" => 102,
			'AND' => 107,
			'DIV' => 104,
			'MOD' => 106,
			"/" => 108,
			'CAT' => 111
		},
		DEFAULT => -152
	},
	{#State 224
		DEFAULT => -98
	},
	{#State 225
		DEFAULT => -99
	},
	{#State 226
		ACTIONS => {
			"\"" => 277,
			'LITERAL' => 275,
			'NUMBER' => 276
		}
	},
	{#State 227
		ACTIONS => {
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			"{" => 28,
			'INCLUDE' => 66,
			'RAW' => 31,
			"\$" => 33,
			'UNLESS' => 67,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			'WRAPPER' => 41,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			'SWITCH' => 74,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'THROW' => 7,
			'LAST' => 6,
			'BLOCK' => 51,
			"[" => 5,
			'STOP' => 8,
			'PROCESS' => 52,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'IF' => 17,
			'WHILE' => 15,
			'rawperl' => 18,
			'IDENT' => 56,
			'NUMBER' => 59,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 68,
			'expr' => 10,
			'anonblock' => 69,
			'use' => 34,
			'raw' => 12,
			'chunks' => 70,
			'setlist' => 71,
			'block' => 278,
			'switch' => 39,
			'macro' => 40,
			'item' => 55,
			'chunk' => 57,
			'lterm' => 19,
			'filter' => 58,
			'defblockname' => 75,
			'javascript' => 20,
			'atomdir' => 23,
			'term' => 43,
			'ident' => 62,
			'loop' => 26,
			'sterm' => 47,
			'wrapper' => 64,
			'directive' => 46,
			'view' => 29,
			'assign' => 65,
			'defblock' => 27,
			'atomexpr' => 4,
			'try' => 3,
			'node' => 30,
			'condition' => 53,
			'capture' => 32
		}
	},
	{#State 228
		DEFAULT => -179
	},
	{#State 229
		DEFAULT => -112
	},
	{#State 230
		DEFAULT => -180
	},
	{#State 231
		ACTIONS => {
			'DOT' => 160
		},
		DEFAULT => -178
	},
	{#State 232
		DEFAULT => -176
	},
	{#State 233
		ACTIONS => {
			'WRAPPER' => 41,
			'SWITCH' => 74,
			'GET' => 42,
			'FILTER' => 73,
			'FOR' => 72,
			"\$" => 33,
			'UNLESS' => 67,
			'META' => 38,
			'LITERAL' => 37,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'INCLUDE' => 66,
			'RAW' => 31,
			"\${" => 24,
			"(" => 22,
			'RETURN' => 21,
			'CALL' => 60,
			"{" => 28,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			'IDENT' => 56,
			'rawperl' => 18,
			'IF' => 17,
			'WHILE' => 15,
			'NUMBER' => 59,
			";" => -19,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'NEXT' => 50,
			"\"" => 49,
			'MACRO' => 2,
			'CLEAR' => 1,
			'STOP' => 8,
			'PROCESS' => 52,
			'THROW' => 7,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19,
			'item' => 55,
			'chunk' => 57,
			'switch' => 39,
			'macro' => 40,
			'block' => 279,
			'raw' => 12,
			'setlist' => 71,
			'chunks' => 70,
			'use' => 34,
			'anonblock' => 69,
			'statement' => 68,
			'expr' => 10,
			'condition' => 53,
			'capture' => 32,
			'node' => 30,
			'atomexpr' => 4,
			'try' => 3,
			'assign' => 65,
			'view' => 29,
			'defblock' => 27,
			'directive' => 46,
			'sterm' => 47,
			'loop' => 26,
			'ident' => 62,
			'wrapper' => 64,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20
		}
	},
	{#State 234
		ACTIONS => {
			")" => 280,
			"\$" => 33,
			'COMMA' => 255,
			"(" => 22,
			"\${" => 24,
			'NOT' => 63,
			'REF' => 48,
			'LITERAL' => 256,
			"{" => 28,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'lterm' => 19,
			'node' => 30,
			'item' => 254,
			'param' => 258,
			'ident' => 253,
			'sterm' => 47,
			'term' => 43,
			'expr' => 257
		}
	},
	{#State 235
		ACTIONS => {
			"?" => 103,
			'CMPOP' => 105,
			'COMMA' => -151,
			"\${" => -151,
			'BINOP' => 110,
			'OR' => 109,
			"+" => 102,
			"\$" => -151,
			'AND' => 107,
			'LITERAL' => -151,
			'MOD' => 106,
			'DIV' => 104,
			'IDENT' => -151,
			";" => -151,
			"/" => 108,
			'CAT' => 111
		},
		DEFAULT => -28
	},
	{#State 236
		DEFAULT => -90
	},
	{#State 237
		DEFAULT => -127
	},
	{#State 238
		DEFAULT => -126
	},
	{#State 239
		ACTIONS => {
			'IF' => 17,
			'WHILE' => 15,
			'IDENT' => 56,
			'rawperl' => 18,
			";" => -19,
			'NUMBER' => 59,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'THROW' => 7,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'STOP' => 8,
			'PROCESS' => 52,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45,
			'WRAPPER' => 41,
			'GET' => 42,
			'FILTER' => 73,
			'FOR' => 72,
			'SWITCH' => 74,
			"\$" => 33,
			'UNLESS' => 67,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			'INCLUDE' => 66,
			'RAW' => 31,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			"{" => 28
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 53,
			'capture' => 32,
			'node' => 30,
			'try' => 3,
			'atomexpr' => 4,
			'view' => 29,
			'defblock' => 27,
			'assign' => 65,
			'loop' => 26,
			'sterm' => 47,
			'ident' => 62,
			'directive' => 46,
			'wrapper' => 64,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19,
			'item' => 55,
			'chunk' => 57,
			'switch' => 39,
			'macro' => 40,
			'block' => 281,
			'raw' => 12,
			'setlist' => 71,
			'chunks' => 70,
			'use' => 34,
			'anonblock' => 69,
			'statement' => 68,
			'expr' => 10
		}
	},
	{#State 240
		ACTIONS => {
			'LITERAL' => 83,
			"{" => 28,
			'REF' => 48,
			"\${" => 24,
			"\$" => 33,
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49
		},
		GOTOS => {
			'item' => 55,
			'term' => 282,
			'node' => 30,
			'lterm' => 19,
			'sterm' => 47,
			'ident' => 89
		}
	},
	{#State 241
		ACTIONS => {
			"\$" => 33,
			"\${" => 24,
			'REF' => 48,
			'LITERAL' => 83,
			"{" => 28,
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5
		},
		GOTOS => {
			'sterm' => 47,
			'ident' => 89,
			'lterm' => 19,
			'node' => 30,
			'term' => 283,
			'item' => 55
		}
	},
	{#State 242
		ACTIONS => {
			"[" => 5,
			'NUMBER' => 59,
			"\"" => 49,
			'IDENT' => 56,
			"{" => 28,
			'LITERAL' => 256,
			'NOT' => 63,
			'REF' => 48,
			"(" => 22,
			"\${" => 24,
			'COMMA' => 255,
			"\$" => 33
		},
		DEFAULT => -66,
		GOTOS => {
			'sterm' => 47,
			'ident' => 253,
			'term' => 43,
			'expr' => 257,
			'lterm' => 19,
			'node' => 30,
			'param' => 258,
			'item' => 254
		}
	},
	{#State 243
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 284
		}
	},
	{#State 244
		ACTIONS => {
			'DEBUG' => 45,
			'REF' => 48,
			'TEXT' => 44,
			'STOP' => 8,
			'PROCESS' => 52,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'THROW' => 7,
			"\"" => 49,
			'NEXT' => 50,
			'CLEAR' => 1,
			'MACRO' => 2,
			'TRY' => 11,
			'SET' => 54,
			'JAVASCRIPT' => 13,
			'INSERT' => 9,
			";" => -19,
			'NUMBER' => 59,
			'rawperl' => 18,
			'IDENT' => 56,
			'WHILE' => 15,
			'IF' => 17,
			"{" => 28,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			"(" => 22,
			"\${" => 24,
			'CALL' => 60,
			'RETURN' => 21,
			'RAW' => 31,
			'INCLUDE' => 66,
			'LITERAL' => 37,
			'META' => 38,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'UNLESS' => 67,
			"\$" => 33,
			'SWITCH' => 74,
			'FILTER' => 73,
			'FOR' => 72,
			'GET' => 42,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 69,
			'use' => 34,
			'expr' => 10,
			'statement' => 68,
			'block' => 285,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'chunk' => 57,
			'item' => 55,
			'macro' => 40,
			'switch' => 39,
			'defblockname' => 75,
			'lterm' => 19,
			'filter' => 58,
			'term' => 43,
			'atomdir' => 23,
			'javascript' => 20,
			'assign' => 65,
			'defblock' => 27,
			'view' => 29,
			'directive' => 46,
			'sterm' => 47,
			'ident' => 62,
			'loop' => 26,
			'wrapper' => 64,
			'atomexpr' => 4,
			'try' => 3,
			'capture' => 32,
			'condition' => 53,
			'node' => 30
		}
	},
	{#State 245
		ACTIONS => {
			'RAW' => 31,
			'INCLUDE' => 66,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			"{" => 28,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			"\$" => 33,
			'UNLESS' => 67,
			'THROW' => 7,
			'BLOCK' => 51,
			'LAST' => 6,
			"[" => 5,
			'STOP' => 8,
			'PROCESS' => 52,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'REF' => 48,
			'DEBUG' => 45,
			'TEXT' => 44,
			'NUMBER' => 59,
			";" => -19,
			'IF' => 17,
			'WHILE' => 15,
			'rawperl' => 18,
			'IDENT' => 56,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'INSERT' => 9
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 286,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'use' => 34,
			'anonblock' => 69,
			'expr' => 10,
			'statement' => 68,
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19,
			'chunk' => 57,
			'item' => 55,
			'macro' => 40,
			'switch' => 39,
			'assign' => 65,
			'view' => 29,
			'defblock' => 27,
			'loop' => 26,
			'sterm' => 47,
			'wrapper' => 64,
			'directive' => 46,
			'ident' => 62,
			'term' => 43,
			'atomdir' => 23,
			'javascript' => 20,
			'capture' => 32,
			'condition' => 53,
			'node' => 30,
			'try' => 3,
			'atomexpr' => 4
		}
	},
	{#State 246
		ACTIONS => {
			'CALL' => 60,
			'RETURN' => 21,
			"(" => 22,
			"\${" => 24,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			"{" => 28,
			'INCLUDE' => 66,
			'RAW' => 31,
			'UNLESS' => 67,
			"\$" => 33,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'LITERAL' => 37,
			'META' => 38,
			'WRAPPER' => 41,
			'FILTER' => 73,
			'FOR' => 72,
			'GET' => 42,
			'SWITCH' => 74,
			'TEXT' => 44,
			'DEBUG' => 45,
			'REF' => 48,
			'CLEAR' => 1,
			'MACRO' => 2,
			"\"" => 49,
			'NEXT' => 50,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'THROW' => 7,
			'PROCESS' => 52,
			'STOP' => 8,
			'INSERT' => 9,
			'TRY' => 11,
			'SET' => 54,
			'JAVASCRIPT' => 13,
			'WHILE' => 15,
			'IF' => 17,
			'rawperl' => 18,
			'IDENT' => 56,
			'NUMBER' => 59,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 53,
			'atomexpr' => 4,
			'try' => 3,
			'sterm' => 47,
			'directive' => 46,
			'term' => 43,
			'filter' => 58,
			'lterm' => 19,
			'item' => 55,
			'chunk' => 57,
			'template' => 287,
			'block' => 14,
			'raw' => 12,
			'expr' => 10,
			'capture' => 32,
			'node' => 30,
			'view' => 29,
			'defblock' => 27,
			'assign' => 65,
			'loop' => 26,
			'ident' => 62,
			'wrapper' => 64,
			'atomdir' => 23,
			'javascript' => 20,
			'defblockname' => 75,
			'switch' => 39,
			'macro' => 40,
			'setlist' => 71,
			'chunks' => 70,
			'use' => 34,
			'anonblock' => 69,
			'statement' => 68
		}
	},
	{#State 247
		ACTIONS => {
			'RAW' => 31,
			'INCLUDE' => 66,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			"{" => 28,
			'CALL' => 60,
			'RETURN' => 21,
			"(" => 22,
			"\${" => 24,
			'FILTER' => 73,
			'FOR' => 72,
			'GET' => 42,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'LITERAL' => 37,
			'META' => 38,
			'UNLESS' => 67,
			"\$" => 33,
			"[" => 5,
			'LAST' => 6,
			'BLOCK' => 51,
			'THROW' => 7,
			'PROCESS' => 52,
			'STOP' => 8,
			'CLEAR' => 1,
			'MACRO' => 2,
			"\"" => 49,
			'NEXT' => 50,
			'DEBUG' => 45,
			'REF' => 48,
			'TEXT' => 44,
			'NUMBER' => 59,
			";" => -19,
			'WHILE' => 15,
			'IF' => 17,
			'rawperl' => 18,
			'IDENT' => 56,
			'TRY' => 11,
			'SET' => 54,
			'JAVASCRIPT' => 13,
			'INSERT' => 9
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 288,
			'raw' => 12,
			'chunks' => 70,
			'setlist' => 71,
			'anonblock' => 69,
			'use' => 34,
			'statement' => 68,
			'expr' => 10,
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19,
			'item' => 55,
			'chunk' => 57,
			'switch' => 39,
			'macro' => 40,
			'defblock' => 27,
			'view' => 29,
			'assign' => 65,
			'sterm' => 47,
			'loop' => 26,
			'wrapper' => 64,
			'ident' => 62,
			'directive' => 46,
			'term' => 43,
			'atomdir' => 23,
			'javascript' => 20,
			'condition' => 53,
			'capture' => 32,
			'node' => 30,
			'try' => 3,
			'atomexpr' => 4
		}
	},
	{#State 248
		ACTIONS => {
			'IDENT' => -97,
			")" => -97,
			'COMMA' => -97
		},
		DEFAULT => -131
	},
	{#State 249
		ACTIONS => {
			'IDENT' => 291,
			")" => 290,
			'COMMA' => 289
		}
	},
	{#State 250
		DEFAULT => -118
	},
	{#State 251
		DEFAULT => -171
	},
	{#State 252
		ACTIONS => {
			'LITERAL' => 256,
			"\$" => 33,
			'NUMBER' => 59,
			'IDENT' => 56,
			'NOT' => 63,
			'REF' => 48,
			"{" => 28,
			'COMMA' => 255,
			"(" => 22,
			"\${" => 24,
			"[" => 5,
			"\"" => 49
		},
		DEFAULT => -163,
		GOTOS => {
			'lterm' => 19,
			'node' => 30,
			'item' => 254,
			'param' => 258,
			'sterm' => 47,
			'ident' => 253,
			'term' => 43,
			'expr' => 257
		}
	},
	{#State 253
		ACTIONS => {
			'ASSIGN' => 292,
			'DOT' => 160
		},
		DEFAULT => -110
	},
	{#State 254
		ACTIONS => {
			"(" => 157,
			'ASSIGN' => 221
		},
		DEFAULT => -129
	},
	{#State 255
		DEFAULT => -156
	},
	{#State 256
		ACTIONS => {
			'ASSIGN' => 217
		},
		DEFAULT => -113
	},
	{#State 257
		ACTIONS => {
			'BINOP' => 110,
			'OR' => 109,
			"+" => 102,
			"?" => 103,
			'CMPOP' => 105,
			'DIV' => 104,
			'MOD' => 106,
			'CAT' => 111,
			"/" => 108,
			'AND' => 107
		},
		DEFAULT => -153
	},
	{#State 258
		DEFAULT => -154
	},
	{#State 259
		DEFAULT => -166
	},
	{#State 260
		ACTIONS => {
			")" => 293,
			'COMMA' => 255,
			"\$" => 33,
			"(" => 22,
			"\${" => 24,
			'REF' => 48,
			'NOT' => 63,
			"{" => 28,
			'LITERAL' => 256,
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59
		},
		GOTOS => {
			'item' => 254,
			'param' => 258,
			'lterm' => 19,
			'node' => 30,
			'expr' => 257,
			'term' => 43,
			'sterm' => 47,
			'ident' => 253
		}
	},
	{#State 261
		DEFAULT => -168
	},
	{#State 262
		ACTIONS => {
			'REF' => 48,
			'NOT' => 63,
			"{" => 28,
			'LITERAL' => 83,
			"\$" => 33,
			"\${" => 24,
			"(" => 22,
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49
		},
		GOTOS => {
			'term' => 43,
			'item' => 55,
			'expr' => 294,
			'ident' => 89,
			'sterm' => 47,
			'lterm' => 19,
			'node' => 30
		}
	},
	{#State 263
		ACTIONS => {
			";" => 295
		}
	},
	{#State 264
		ACTIONS => {
			'END' => 296
		}
	},
	{#State 265
		ACTIONS => {
			";" => 297,
			'NUMBER' => 97,
			'DEFAULT' => 299,
			'IDENT' => 98,
			'FILENAME' => 91
		},
		GOTOS => {
			'filepart' => 99,
			'filename' => 298
		}
	},
	{#State 266
		ACTIONS => {
			'END' => 300
		}
	},
	{#State 267
		ACTIONS => {
			'THROW' => 7,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'STOP' => 8,
			'PROCESS' => 52,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'REF' => 48,
			'DEBUG' => 45,
			'TEXT' => 44,
			";" => -19,
			'NUMBER' => 59,
			'IF' => 17,
			'WHILE' => 15,
			'rawperl' => 18,
			'IDENT' => 56,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'INSERT' => 9,
			'RAW' => 31,
			'INCLUDE' => 66,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			"{" => 28,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'GET' => 42,
			'FILTER' => 73,
			'FOR' => 72,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			"\$" => 33,
			'UNLESS' => 67
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 68,
			'expr' => 10,
			'anonblock' => 69,
			'use' => 34,
			'raw' => 12,
			'setlist' => 71,
			'chunks' => 70,
			'block' => 301,
			'switch' => 39,
			'macro' => 40,
			'item' => 55,
			'chunk' => 57,
			'filter' => 58,
			'lterm' => 19,
			'defblockname' => 75,
			'javascript' => 20,
			'atomdir' => 23,
			'term' => 43,
			'directive' => 46,
			'ident' => 62,
			'wrapper' => 64,
			'sterm' => 47,
			'loop' => 26,
			'assign' => 65,
			'view' => 29,
			'defblock' => 27,
			'try' => 3,
			'atomexpr' => 4,
			'node' => 30,
			'condition' => 53,
			'capture' => 32
		}
	},
	{#State 268
		ACTIONS => {
			'ELSE' => 302,
			'ELSIF' => 304
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 303
		}
	},
	{#State 269
		ACTIONS => {
			'MOD' => 106,
			'DIV' => 104,
			"/" => 108,
			'CAT' => 111,
			'AND' => 107,
			'BINOP' => 110,
			'OR' => 109,
			"+" => 102,
			'CMPOP' => 105,
			"?" => 103
		},
		DEFAULT => -151
	},
	{#State 270
		DEFAULT => -158
	},
	{#State 271
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 272
		ACTIONS => {
			"?" => 103,
			"+" => 102,
			"/" => 108,
			'DIV' => 104,
			'CMPOP' => 105,
			'BINOP' => 110,
			'OR' => 109,
			'AND' => 107,
			'CAT' => 111,
			'MOD' => 106
		},
		DEFAULT => -124
	},
	{#State 273
		ACTIONS => {
			"/" => 108,
			'DIV' => 104,
			"+" => 102,
			"?" => 103,
			'CAT' => 111,
			'MOD' => 106,
			'AND' => 107,
			'BINOP' => 110,
			'OR' => 109,
			'CMPOP' => 105
		},
		DEFAULT => -125
	},
	{#State 274
		ACTIONS => {
			'WRAPPER' => 41,
			'SWITCH' => 74,
			'FOR' => 72,
			'FILTER' => 73,
			'GET' => 42,
			'UNLESS' => 67,
			"\$" => 33,
			'LITERAL' => 37,
			'META' => 38,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'INCLUDE' => 66,
			'RAW' => 31,
			"(" => 22,
			"\${" => 24,
			'CALL' => 60,
			'RETURN' => 21,
			"{" => 28,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			'rawperl' => 18,
			'IDENT' => 56,
			'WHILE' => 15,
			'IF' => 17,
			'NUMBER' => 59,
			";" => -19,
			'INSERT' => 9,
			'SET' => 54,
			'TRY' => 11,
			'JAVASCRIPT' => 13,
			"\"" => 49,
			'NEXT' => 50,
			'CLEAR' => 1,
			'MACRO' => 2,
			'STOP' => 8,
			'PROCESS' => 52,
			'LAST' => 6,
			"[" => 5,
			'BLOCK' => 51,
			'THROW' => 7,
			'TEXT' => 44,
			'DEBUG' => 45,
			'REF' => 48
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 69,
			'use' => 34,
			'statement' => 68,
			'expr' => 10,
			'block' => 305,
			'raw' => 12,
			'chunks' => 70,
			'setlist' => 71,
			'item' => 55,
			'chunk' => 57,
			'switch' => 39,
			'macro' => 40,
			'defblockname' => 75,
			'lterm' => 19,
			'filter' => 58,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'assign' => 65,
			'view' => 29,
			'defblock' => 27,
			'wrapper' => 64,
			'loop' => 26,
			'ident' => 62,
			'sterm' => 47,
			'directive' => 46,
			'atomexpr' => 4,
			'try' => 3,
			'condition' => 53,
			'capture' => 32,
			'node' => 30
		}
	},
	{#State 275
		DEFAULT => -101
	},
	{#State 276
		DEFAULT => -103
	},
	{#State 277
		ACTIONS => {
			'TEXT' => 306
		}
	},
	{#State 278
		ACTIONS => {
			'END' => 307
		}
	},
	{#State 279
		ACTIONS => {
			'END' => 308
		}
	},
	{#State 280
		DEFAULT => -130
	},
	{#State 281
		ACTIONS => {
			'ELSIF' => 304,
			'ELSE' => 302
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 309
		}
	},
	{#State 282
		DEFAULT => -157,
		GOTOS => {
			'args' => 310
		}
	},
	{#State 283
		DEFAULT => -157,
		GOTOS => {
			'args' => 311
		}
	},
	{#State 284
		ACTIONS => {
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			"\$" => 33,
			'UNLESS' => 67,
			'RAW' => 31,
			'INCLUDE' => 66,
			'NOT' => 63,
			'perl' => 61,
			'USE' => 25,
			"{" => 28,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'NUMBER' => 59,
			";" => -19,
			'IF' => 17,
			'WHILE' => 15,
			'IDENT' => 56,
			'rawperl' => 18,
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'INSERT' => 9,
			'THROW' => 7,
			"[" => 5,
			'LAST' => 6,
			'BLOCK' => 51,
			'STOP' => 8,
			'PROCESS' => 52,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'REF' => 48,
			'DEBUG' => 45,
			'TEXT' => 44
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 30,
			'capture' => 32,
			'condition' => 53,
			'atomexpr' => 4,
			'try' => 3,
			'loop' => 26,
			'directive' => 46,
			'ident' => 62,
			'sterm' => 47,
			'wrapper' => 64,
			'view' => 29,
			'assign' => 65,
			'defblock' => 27,
			'javascript' => 20,
			'term' => 43,
			'atomdir' => 23,
			'lterm' => 19,
			'filter' => 58,
			'defblockname' => 75,
			'macro' => 40,
			'switch' => 39,
			'chunk' => 57,
			'item' => 55,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'block' => 312,
			'expr' => 10,
			'statement' => 68,
			'use' => 34,
			'anonblock' => 69
		}
	},
	{#State 285
		ACTIONS => {
			'END' => 313
		}
	},
	{#State 286
		ACTIONS => {
			'CASE' => 314
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 315
		}
	},
	{#State 287
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 288
		ACTIONS => {
			'END' => 317
		}
	},
	{#State 289
		DEFAULT => -96
	},
	{#State 290
		ACTIONS => {
			'IDENT' => 56,
			'WHILE' => 15,
			'IF' => 17,
			'NUMBER' => 59,
			'INSERT' => 9,
			'TRY' => 11,
			'SET' => 54,
			'JAVASCRIPT' => 13,
			"\"" => 49,
			'NEXT' => 50,
			'CLEAR' => 1,
			'STOP' => 8,
			'PROCESS' => 52,
			"[" => 5,
			'LAST' => 6,
			'BLOCK' => 174,
			'THROW' => 7,
			'DEBUG' => 45,
			'REF' => 48,
			'WRAPPER' => 41,
			'SWITCH' => 74,
			'FOR' => 72,
			'FILTER' => 73,
			'GET' => 42,
			'UNLESS' => 67,
			"\$" => 33,
			'LITERAL' => 37,
			'DEFAULT' => 35,
			'INCLUDE' => 66,
			"(" => 22,
			"\${" => 24,
			'CALL' => 60,
			'RETURN' => 21,
			"{" => 28,
			'perl' => 61,
			'NOT' => 63
		},
		GOTOS => {
			'item' => 55,
			'switch' => 39,
			'filter' => 58,
			'lterm' => 19,
			'mdir' => 318,
			'expr' => 177,
			'setlist' => 71,
			'atomexpr' => 4,
			'try' => 3,
			'condition' => 53,
			'node' => 30,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'assign' => 65,
			'ident' => 119,
			'sterm' => 47,
			'wrapper' => 64,
			'loop' => 26,
			'directive' => 175
		}
	},
	{#State 291
		DEFAULT => -95
	},
	{#State 292
		ACTIONS => {
			'IDENT' => 56,
			"\"" => 49,
			'NUMBER' => 59,
			"[" => 5,
			"\$" => 33,
			"\${" => 24,
			"(" => 22,
			'REF' => 48,
			'NOT' => 63,
			'LITERAL' => 83,
			"{" => 28
		},
		GOTOS => {
			'expr' => 319,
			'item' => 55,
			'term' => 43,
			'ident' => 89,
			'sterm' => 47,
			'lterm' => 19,
			'node' => 30
		}
	},
	{#State 293
		DEFAULT => -165
	},
	{#State 294
		ACTIONS => {
			'DIV' => 104,
			"/" => 108,
			"?" => 103,
			"+" => 102,
			'AND' => 107,
			'MOD' => 106,
			'CAT' => 111,
			'CMPOP' => 105,
			'OR' => 109,
			'BINOP' => 110
		},
		DEFAULT => -144
	},
	{#State 295
		ACTIONS => {
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'INSERT' => 9,
			'NUMBER' => 59,
			";" => -19,
			'IDENT' => 56,
			'rawperl' => 18,
			'IF' => 17,
			'WHILE' => 15,
			'REF' => 48,
			'DEBUG' => 45,
			'TEXT' => 44,
			'STOP' => 8,
			'PROCESS' => 52,
			'THROW' => 7,
			"[" => 5,
			'LAST' => 6,
			'BLOCK' => 51,
			'NEXT' => 50,
			"\"" => 49,
			'MACRO' => 2,
			'CLEAR' => 1,
			'META' => 38,
			'LITERAL' => 37,
			'VIEW' => 36,
			'DEFAULT' => 35,
			"\$" => 33,
			'UNLESS' => 67,
			'SWITCH' => 74,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			'WRAPPER' => 41,
			"{" => 28,
			'NOT' => 63,
			'perl' => 61,
			'USE' => 25,
			"\${" => 24,
			"(" => 22,
			'RETURN' => 21,
			'CALL' => 60,
			'RAW' => 31,
			'INCLUDE' => 66
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 320,
			'raw' => 12,
			'setlist' => 71,
			'chunks' => 70,
			'use' => 34,
			'anonblock' => 69,
			'statement' => 68,
			'expr' => 10,
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19,
			'item' => 55,
			'chunk' => 57,
			'switch' => 39,
			'macro' => 40,
			'defblock' => 27,
			'view' => 29,
			'assign' => 65,
			'loop' => 26,
			'sterm' => 47,
			'directive' => 46,
			'wrapper' => 64,
			'ident' => 62,
			'term' => 43,
			'atomdir' => 23,
			'javascript' => 20,
			'condition' => 53,
			'capture' => 32,
			'node' => 30,
			'atomexpr' => 4,
			'try' => 3
		}
	},
	{#State 296
		DEFAULT => -69
	},
	{#State 297
		ACTIONS => {
			'perl' => 61,
			'USE' => 25,
			'NOT' => 63,
			"{" => 28,
			'CALL' => 60,
			'RETURN' => 21,
			"(" => 22,
			"\${" => 24,
			'RAW' => 31,
			'INCLUDE' => 66,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'LITERAL' => 37,
			'META' => 38,
			'UNLESS' => 67,
			"\$" => 33,
			'FOR' => 72,
			'FILTER' => 73,
			'GET' => 42,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'DEBUG' => 45,
			'REF' => 48,
			'TEXT' => 44,
			'LAST' => 6,
			'BLOCK' => 51,
			"[" => 5,
			'THROW' => 7,
			'PROCESS' => 52,
			'STOP' => 8,
			'CLEAR' => 1,
			'MACRO' => 2,
			"\"" => 49,
			'NEXT' => 50,
			'SET' => 54,
			'TRY' => 11,
			'JAVASCRIPT' => 13,
			'INSERT' => 9,
			'NUMBER' => 59,
			";" => -19,
			'WHILE' => 15,
			'IF' => 17,
			'IDENT' => 56,
			'rawperl' => 18
		},
		DEFAULT => -3,
		GOTOS => {
			'atomexpr' => 4,
			'try' => 3,
			'condition' => 53,
			'capture' => 32,
			'node' => 30,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'view' => 29,
			'assign' => 65,
			'defblock' => 27,
			'wrapper' => 64,
			'ident' => 62,
			'loop' => 26,
			'sterm' => 47,
			'directive' => 46,
			'item' => 55,
			'chunk' => 57,
			'switch' => 39,
			'macro' => 40,
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19,
			'anonblock' => 69,
			'use' => 34,
			'statement' => 68,
			'expr' => 10,
			'block' => 321,
			'raw' => 12,
			'chunks' => 70,
			'setlist' => 71
		}
	},
	{#State 298
		ACTIONS => {
			'DOT' => 190,
			";" => 322
		}
	},
	{#State 299
		ACTIONS => {
			";" => 323
		}
	},
	{#State 300
		DEFAULT => -80
	},
	{#State 301
		ACTIONS => {
			'END' => 324
		}
	},
	{#State 302
		ACTIONS => {
			";" => 325
		}
	},
	{#State 303
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 304
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			"{" => 28,
			'LITERAL' => 83,
			'NOT' => 63,
			'REF' => 48,
			"\${" => 24,
			"(" => 22,
			"\$" => 33
		},
		GOTOS => {
			'term' => 43,
			'item' => 55,
			'expr' => 327,
			'ident' => 89,
			'sterm' => 47,
			'node' => 30,
			'lterm' => 19
		}
	},
	{#State 305
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 306
		ACTIONS => {
			"\"" => 329
		}
	},
	{#State 307
		DEFAULT => -67
	},
	{#State 308
		DEFAULT => -89
	},
	{#State 309
		ACTIONS => {
			'END' => 330
		}
	},
	{#State 310
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			"{" => 28,
			'LITERAL' => 256,
			'REF' => 48,
			'NOT' => 63,
			"\${" => 24,
			"(" => 22,
			"\$" => 33,
			'COMMA' => 255
		},
		DEFAULT => -65,
		GOTOS => {
			'sterm' => 47,
			'ident' => 253,
			'term' => 43,
			'expr' => 257,
			'lterm' => 19,
			'node' => 30,
			'item' => 254,
			'param' => 258
		}
	},
	{#State 311
		ACTIONS => {
			'NUMBER' => 59,
			"[" => 5,
			'IDENT' => 56,
			"\"" => 49,
			'NOT' => 63,
			'REF' => 48,
			'LITERAL' => 256,
			"{" => 28,
			'COMMA' => 255,
			"\$" => 33,
			"\${" => 24,
			"(" => 22
		},
		DEFAULT => -64,
		GOTOS => {
			'ident' => 253,
			'sterm' => 47,
			'term' => 43,
			'expr' => 257,
			'lterm' => 19,
			'node' => 30,
			'param' => 258,
			'item' => 254
		}
	},
	{#State 312
		ACTIONS => {
			'END' => 331
		}
	},
	{#State 313
		DEFAULT => -81
	},
	{#State 314
		ACTIONS => {
			"\"" => 49,
			'IDENT' => 56,
			"[" => 5,
			'NUMBER' => 59,
			";" => 333,
			"\$" => 33,
			"\${" => 24,
			'DEFAULT' => 334,
			'REF' => 48,
			'LITERAL' => 83,
			"{" => 28
		},
		GOTOS => {
			'ident' => 89,
			'sterm' => 47,
			'lterm' => 19,
			'node' => 30,
			'item' => 55,
			'term' => 332
		}
	},
	{#State 315
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 316
		DEFAULT => -83
	},
	{#State 317
		DEFAULT => -94
	},
	{#State 318
		DEFAULT => -91
	},
	{#State 319
		ACTIONS => {
			"+" => 102,
			'BINOP' => 110,
			'OR' => 109,
			"?" => 103,
			'CMPOP' => 105,
			"/" => 108,
			'CAT' => 111,
			'DIV' => 104,
			'MOD' => 106,
			'AND' => 107
		},
		DEFAULT => -155
	},
	{#State 320
		DEFAULT => -73
	},
	{#State 321
		ACTIONS => {
			'FINAL' => 263,
			'CATCH' => 265
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 336
		}
	},
	{#State 322
		ACTIONS => {
			";" => -19,
			'NUMBER' => 59,
			'WHILE' => 15,
			'IF' => 17,
			'IDENT' => 56,
			'rawperl' => 18,
			'SET' => 54,
			'TRY' => 11,
			'JAVASCRIPT' => 13,
			'INSERT' => 9,
			"[" => 5,
			'BLOCK' => 51,
			'LAST' => 6,
			'THROW' => 7,
			'STOP' => 8,
			'PROCESS' => 52,
			'CLEAR' => 1,
			'MACRO' => 2,
			"\"" => 49,
			'NEXT' => 50,
			'DEBUG' => 45,
			'REF' => 48,
			'TEXT' => 44,
			'FOR' => 72,
			'FILTER' => 73,
			'GET' => 42,
			'SWITCH' => 74,
			'WRAPPER' => 41,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'LITERAL' => 37,
			'META' => 38,
			'UNLESS' => 67,
			"\$" => 33,
			'RAW' => 31,
			'INCLUDE' => 66,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			"{" => 28,
			'CALL' => 60,
			'RETURN' => 21,
			"(" => 22,
			"\${" => 24
		},
		DEFAULT => -3,
		GOTOS => {
			'javascript' => 20,
			'atomdir' => 23,
			'term' => 43,
			'directive' => 46,
			'wrapper' => 64,
			'ident' => 62,
			'sterm' => 47,
			'loop' => 26,
			'defblock' => 27,
			'assign' => 65,
			'view' => 29,
			'try' => 3,
			'atomexpr' => 4,
			'node' => 30,
			'condition' => 53,
			'capture' => 32,
			'statement' => 68,
			'expr' => 10,
			'use' => 34,
			'anonblock' => 69,
			'raw' => 12,
			'chunks' => 70,
			'setlist' => 71,
			'block' => 337,
			'switch' => 39,
			'macro' => 40,
			'item' => 55,
			'chunk' => 57,
			'lterm' => 19,
			'filter' => 58,
			'defblockname' => 75
		}
	},
	{#State 323
		ACTIONS => {
			'WRAPPER' => 41,
			'SWITCH' => 74,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			"\$" => 33,
			'UNLESS' => 67,
			'META' => 38,
			'LITERAL' => 37,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'INCLUDE' => 66,
			'RAW' => 31,
			"\${" => 24,
			"(" => 22,
			'RETURN' => 21,
			'CALL' => 60,
			"{" => 28,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			'rawperl' => 18,
			'IDENT' => 56,
			'IF' => 17,
			'WHILE' => 15,
			";" => -19,
			'NUMBER' => 59,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'NEXT' => 50,
			"\"" => 49,
			'MACRO' => 2,
			'CLEAR' => 1,
			'STOP' => 8,
			'PROCESS' => 52,
			'THROW' => 7,
			'BLOCK' => 51,
			"[" => 5,
			'LAST' => 6,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 338,
			'chunks' => 70,
			'setlist' => 71,
			'raw' => 12,
			'anonblock' => 69,
			'use' => 34,
			'expr' => 10,
			'statement' => 68,
			'defblockname' => 75,
			'filter' => 58,
			'lterm' => 19,
			'chunk' => 57,
			'item' => 55,
			'macro' => 40,
			'switch' => 39,
			'defblock' => 27,
			'view' => 29,
			'assign' => 65,
			'loop' => 26,
			'wrapper' => 64,
			'ident' => 62,
			'directive' => 46,
			'sterm' => 47,
			'term' => 43,
			'atomdir' => 23,
			'javascript' => 20,
			'capture' => 32,
			'condition' => 53,
			'node' => 30,
			'atomexpr' => 4,
			'try' => 3
		}
	},
	{#State 324
		DEFAULT => -62
	},
	{#State 325
		ACTIONS => {
			"\$" => 33,
			'UNLESS' => 67,
			'META' => 38,
			'LITERAL' => 37,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'WRAPPER' => 41,
			'SWITCH' => 74,
			'GET' => 42,
			'FILTER' => 73,
			'FOR' => 72,
			"\${" => 24,
			"(" => 22,
			'RETURN' => 21,
			'CALL' => 60,
			"{" => 28,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61,
			'INCLUDE' => 66,
			'RAW' => 31,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'IDENT' => 56,
			'rawperl' => 18,
			'IF' => 17,
			'WHILE' => 15,
			'NUMBER' => 59,
			";" => -19,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45,
			'NEXT' => 50,
			"\"" => 49,
			'MACRO' => 2,
			'CLEAR' => 1,
			'PROCESS' => 52,
			'STOP' => 8,
			'THROW' => 7,
			'LAST' => 6,
			"[" => 5,
			'BLOCK' => 51
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 75,
			'lterm' => 19,
			'filter' => 58,
			'chunk' => 57,
			'item' => 55,
			'macro' => 40,
			'switch' => 39,
			'block' => 339,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'anonblock' => 69,
			'use' => 34,
			'expr' => 10,
			'statement' => 68,
			'capture' => 32,
			'condition' => 53,
			'node' => 30,
			'try' => 3,
			'atomexpr' => 4,
			'defblock' => 27,
			'assign' => 65,
			'view' => 29,
			'directive' => 46,
			'loop' => 26,
			'ident' => 62,
			'wrapper' => 64,
			'sterm' => 47,
			'term' => 43,
			'atomdir' => 23,
			'javascript' => 20
		}
	},
	{#State 326
		DEFAULT => -46
	},
	{#State 327
		ACTIONS => {
			'OR' => 109,
			'BINOP' => 110,
			'DIV' => 104,
			'MOD' => 106,
			";" => 340,
			'CAT' => 111,
			"/" => 108,
			"+" => 102,
			'AND' => 107,
			"?" => 103,
			'CMPOP' => 105
		}
	},
	{#State 328
		DEFAULT => -78
	},
	{#State 329
		DEFAULT => -102
	},
	{#State 330
		DEFAULT => -48
	},
	{#State 331
		DEFAULT => -59
	},
	{#State 332
		ACTIONS => {
			";" => 341
		}
	},
	{#State 333
		ACTIONS => {
			";" => -19,
			'NUMBER' => 59,
			'rawperl' => 18,
			'IDENT' => 56,
			'WHILE' => 15,
			'IF' => 17,
			'SET' => 54,
			'TRY' => 11,
			'JAVASCRIPT' => 13,
			'INSERT' => 9,
			'STOP' => 8,
			'PROCESS' => 52,
			'BLOCK' => 51,
			'LAST' => 6,
			"[" => 5,
			'THROW' => 7,
			"\"" => 49,
			'NEXT' => 50,
			'CLEAR' => 1,
			'MACRO' => 2,
			'DEBUG' => 45,
			'REF' => 48,
			'TEXT' => 44,
			'SWITCH' => 74,
			'FILTER' => 73,
			'FOR' => 72,
			'GET' => 42,
			'WRAPPER' => 41,
			'LITERAL' => 37,
			'META' => 38,
			'DEFAULT' => 35,
			'VIEW' => 36,
			'UNLESS' => 67,
			"\$" => 33,
			'RAW' => 31,
			'INCLUDE' => 66,
			"{" => 28,
			'perl' => 61,
			'USE' => 25,
			'NOT' => 63,
			"(" => 22,
			"\${" => 24,
			'CALL' => 60,
			'RETURN' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'capture' => 32,
			'condition' => 53,
			'node' => 30,
			'atomexpr' => 4,
			'try' => 3,
			'defblock' => 27,
			'assign' => 65,
			'view' => 29,
			'directive' => 46,
			'wrapper' => 64,
			'sterm' => 47,
			'ident' => 62,
			'loop' => 26,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'defblockname' => 75,
			'lterm' => 19,
			'filter' => 58,
			'chunk' => 57,
			'item' => 55,
			'macro' => 40,
			'switch' => 39,
			'block' => 342,
			'chunks' => 70,
			'setlist' => 71,
			'raw' => 12,
			'anonblock' => 69,
			'use' => 34,
			'expr' => 10,
			'statement' => 68
		}
	},
	{#State 334
		ACTIONS => {
			";" => 343
		}
	},
	{#State 335
		DEFAULT => -53
	},
	{#State 336
		DEFAULT => -72
	},
	{#State 337
		ACTIONS => {
			'FINAL' => 263,
			'CATCH' => 265
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 344
		}
	},
	{#State 338
		ACTIONS => {
			'CATCH' => 265,
			'FINAL' => 263
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 345
		}
	},
	{#State 339
		DEFAULT => -51
	},
	{#State 340
		ACTIONS => {
			"\"" => 49,
			'NEXT' => 50,
			'CLEAR' => 1,
			'MACRO' => 2,
			'PROCESS' => 52,
			'STOP' => 8,
			'BLOCK' => 51,
			'LAST' => 6,
			"[" => 5,
			'THROW' => 7,
			'TEXT' => 44,
			'DEBUG' => 45,
			'REF' => 48,
			'IDENT' => 56,
			'rawperl' => 18,
			'WHILE' => 15,
			'IF' => 17,
			'NUMBER' => 59,
			";" => -19,
			'INSERT' => 9,
			'SET' => 54,
			'TRY' => 11,
			'JAVASCRIPT' => 13,
			'INCLUDE' => 66,
			'RAW' => 31,
			"(" => 22,
			"\${" => 24,
			'CALL' => 60,
			'RETURN' => 21,
			"{" => 28,
			'USE' => 25,
			'perl' => 61,
			'NOT' => 63,
			'WRAPPER' => 41,
			'SWITCH' => 74,
			'FOR' => 72,
			'FILTER' => 73,
			'GET' => 42,
			'UNLESS' => 67,
			"\$" => 33,
			'LITERAL' => 37,
			'META' => 38,
			'DEFAULT' => 35,
			'VIEW' => 36
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 62,
			'loop' => 26,
			'sterm' => 47,
			'wrapper' => 64,
			'directive' => 46,
			'assign' => 65,
			'view' => 29,
			'defblock' => 27,
			'javascript' => 20,
			'atomdir' => 23,
			'term' => 43,
			'node' => 30,
			'capture' => 32,
			'condition' => 53,
			'atomexpr' => 4,
			'try' => 3,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'block' => 346,
			'expr' => 10,
			'statement' => 68,
			'anonblock' => 69,
			'use' => 34,
			'lterm' => 19,
			'filter' => 58,
			'defblockname' => 75,
			'macro' => 40,
			'switch' => 39,
			'chunk' => 57,
			'item' => 55
		}
	},
	{#State 341
		ACTIONS => {
			'rawperl' => 18,
			'IDENT' => 56,
			'IF' => 17,
			'WHILE' => 15,
			";" => -19,
			'NUMBER' => 59,
			'INSERT' => 9,
			'JAVASCRIPT' => 13,
			'SET' => 54,
			'TRY' => 11,
			'NEXT' => 50,
			"\"" => 49,
			'MACRO' => 2,
			'CLEAR' => 1,
			'STOP' => 8,
			'PROCESS' => 52,
			'THROW' => 7,
			'LAST' => 6,
			'BLOCK' => 51,
			"[" => 5,
			'TEXT' => 44,
			'REF' => 48,
			'DEBUG' => 45,
			'WRAPPER' => 41,
			'SWITCH' => 74,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			"\$" => 33,
			'UNLESS' => 67,
			'META' => 38,
			'LITERAL' => 37,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'INCLUDE' => 66,
			'RAW' => 31,
			"\${" => 24,
			"(" => 22,
			'RETURN' => 21,
			'CALL' => 60,
			"{" => 28,
			'NOT' => 63,
			'USE' => 25,
			'perl' => 61
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 69,
			'use' => 34,
			'expr' => 10,
			'statement' => 68,
			'block' => 347,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'chunk' => 57,
			'item' => 55,
			'macro' => 40,
			'switch' => 39,
			'defblockname' => 75,
			'lterm' => 19,
			'filter' => 58,
			'atomdir' => 23,
			'term' => 43,
			'javascript' => 20,
			'assign' => 65,
			'defblock' => 27,
			'view' => 29,
			'ident' => 62,
			'wrapper' => 64,
			'directive' => 46,
			'loop' => 26,
			'sterm' => 47,
			'atomexpr' => 4,
			'try' => 3,
			'capture' => 32,
			'condition' => 53,
			'node' => 30
		}
	},
	{#State 342
		DEFAULT => -56
	},
	{#State 343
		ACTIONS => {
			'REF' => 48,
			'DEBUG' => 45,
			'TEXT' => 44,
			'THROW' => 7,
			'BLOCK' => 51,
			"[" => 5,
			'LAST' => 6,
			'PROCESS' => 52,
			'STOP' => 8,
			'MACRO' => 2,
			'CLEAR' => 1,
			'NEXT' => 50,
			"\"" => 49,
			'JAVASCRIPT' => 13,
			'TRY' => 11,
			'SET' => 54,
			'INSERT' => 9,
			'NUMBER' => 59,
			";" => -19,
			'IF' => 17,
			'WHILE' => 15,
			'IDENT' => 56,
			'rawperl' => 18,
			'NOT' => 63,
			'perl' => 61,
			'USE' => 25,
			"{" => 28,
			'RETURN' => 21,
			'CALL' => 60,
			"\${" => 24,
			"(" => 22,
			'RAW' => 31,
			'INCLUDE' => 66,
			'VIEW' => 36,
			'DEFAULT' => 35,
			'META' => 38,
			'LITERAL' => 37,
			"\$" => 33,
			'UNLESS' => 67,
			'GET' => 42,
			'FOR' => 72,
			'FILTER' => 73,
			'SWITCH' => 74,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 46,
			'ident' => 62,
			'sterm' => 47,
			'wrapper' => 64,
			'loop' => 26,
			'assign' => 65,
			'defblock' => 27,
			'view' => 29,
			'javascript' => 20,
			'atomdir' => 23,
			'term' => 43,
			'node' => 30,
			'capture' => 32,
			'condition' => 53,
			'try' => 3,
			'atomexpr' => 4,
			'setlist' => 71,
			'chunks' => 70,
			'raw' => 12,
			'block' => 348,
			'expr' => 10,
			'statement' => 68,
			'use' => 34,
			'anonblock' => 69,
			'filter' => 58,
			'lterm' => 19,
			'defblockname' => 75,
			'macro' => 40,
			'switch' => 39,
			'chunk' => 57,
			'item' => 55
		}
	},
	{#State 344
		DEFAULT => -70
	},
	{#State 345
		DEFAULT => -71
	},
	{#State 346
		ACTIONS => {
			'ELSE' => 302,
			'ELSIF' => 304
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 349
		}
	},
	{#State 347
		ACTIONS => {
			'CASE' => 314
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 350
		}
	},
	{#State 348
		DEFAULT => -55
	},
	{#State 349
		DEFAULT => -50
	},
	{#State 350
		DEFAULT => -54
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
