#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.10 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21,
			'MACRO' => 25,
			'BLOCK' => 27,
			'META' => 26,
			'STOP' => 28,
			'INSERT' => 24,
			'UNLESS' => 23,
			'rawperl' => 59,
			'WHILE' => 31,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'IDENT' => 29,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'USE' => 11,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53,
			'CALL' => 16,
			'GET' => 41,
			"\${" => 40,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'FILTER' => 4,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'NOT' => 8
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'switch' => 42,
			'filter' => 45,
			'ident' => 9,
			'macro' => 51,
			'node' => 54,
			'view' => 13,
			'capture' => 12,
			'atomexpr' => 15,
			'javascript' => 17,
			'block' => 14,
			'template' => 57,
			'sterm' => 58,
			'use' => 20,
			'atomdir' => 60,
			'item' => 61,
			'expr' => 64,
			'directive' => 30,
			'term' => 32,
			'chunks' => 68,
			'chunk' => 70,
			'assign' => 69,
			'condition' => 65,
			'raw' => 66,
			'setlist' => 67,
			'loop' => 33,
			'defblock' => 71,
			'anonblock' => 37,
			'defblockname' => 75,
			'try' => 74
		}
	},
	{#State 1
		ACTIONS => {
			";" => 76
		}
	},
	{#State 2
		DEFAULT => -40
	},
	{#State 3
		ACTIONS => {
			";" => 77
		}
	},
	{#State 4
		ACTIONS => {
			"\${" => 40,
			"\"" => 78,
			'LITERAL' => 91,
			"\$" => 82,
			'FILENAME' => 81,
			'IDENT' => 88,
			'NUMBER' => 84
		},
		GOTOS => {
			'lnameargs' => 86,
			'item' => 80,
			'nameargs' => 85,
			'filename' => 89,
			'names' => 83,
			'name' => 87,
			'lvalue' => 90,
			'filepart' => 79
		}
	},
	{#State 5
		ACTIONS => {
			'FILENAME' => 81,
			'IDENT' => 88,
			'NUMBER' => 84,
			"\${" => 40,
			"\"" => 78,
			"\$" => 82,
			'LITERAL' => 91
		},
		GOTOS => {
			'lvalue' => 90,
			'filepart' => 79,
			'name' => 87,
			'filename' => 89,
			'names' => 83,
			'item' => 80,
			'nameargs' => 85,
			'lnameargs' => 92
		}
	},
	{#State 6
		ACTIONS => {
			'IDENT' => 29,
			'LITERAL' => 94,
			"\$" => 53,
			"\${" => 40
		},
		DEFAULT => -120,
		GOTOS => {
			'params' => 93,
			'item' => 97,
			'param' => 96,
			'hash' => 95
		}
	},
	{#State 7
		ACTIONS => {
			'ASSIGN' => 98
		},
		DEFAULT => -113
	},
	{#State 8
		ACTIONS => {
			'REF' => 52,
			"\${" => 40,
			"(" => 18,
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35,
			"[" => 46,
			"\"" => 72,
			"{" => 6,
			'LITERAL' => 100,
			"\$" => 53
		},
		GOTOS => {
			'ident' => 99,
			'lterm' => 39,
			'sterm' => 58,
			'node' => 54,
			'item' => 61,
			'term' => 32,
			'expr' => 101
		}
	},
	{#State 9
		ACTIONS => {
			'DOT' => 103,
			'ASSIGN' => 102
		},
		DEFAULT => -110
	},
	{#State 10
		ACTIONS => {
			'LITERAL' => 100,
			"{" => 6,
			"\$" => 53,
			"\"" => 72,
			"[" => 46,
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29,
			"(" => 18,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'expr' => 104,
			'lterm' => 39,
			'ident' => 99,
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54
		}
	},
	{#State 11
		ACTIONS => {
			'NUMBER' => 84,
			'IDENT' => 88,
			'FILENAME' => 81,
			'LITERAL' => 91,
			"\$" => 82,
			"\"" => 78,
			"\${" => 40
		},
		GOTOS => {
			'lnameargs' => 105,
			'nameargs' => 85,
			'item' => 80,
			'names' => 83,
			'filename' => 89,
			'name' => 87,
			'filepart' => 79,
			'lvalue' => 90
		}
	},
	{#State 12
		DEFAULT => -11
	},
	{#State 13
		DEFAULT => -15
	},
	{#State 14
		DEFAULT => -1
	},
	{#State 15
		ACTIONS => {
			'IF' => 110,
			'WHILE' => 108,
			'FOR' => 107,
			'WRAPPER' => 111,
			'FILTER' => 106,
			'UNLESS' => 109
		}
	},
	{#State 16
		ACTIONS => {
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35,
			"[" => 46,
			"\"" => 72,
			"\$" => 53,
			"{" => 6,
			'LITERAL' => 100,
			'REF' => 52,
			"(" => 18,
			"\${" => 40
		},
		GOTOS => {
			'lterm' => 39,
			'ident' => 99,
			'term' => 32,
			'item' => 61,
			'sterm' => 58,
			'node' => 54,
			'expr' => 112
		}
	},
	{#State 17
		DEFAULT => -26
	},
	{#State 18
		ACTIONS => {
			'REF' => 52,
			"(" => 18,
			"\${" => 40,
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35,
			"[" => 46,
			"\"" => 72,
			"{" => 6,
			'LITERAL' => 7,
			"\$" => 53
		},
		GOTOS => {
			'assign' => 113,
			'term' => 32,
			'sterm' => 58,
			'lterm' => 39,
			'ident' => 115,
			'expr' => 114,
			'item' => 61,
			'node' => 54
		}
	},
	{#State 19
		DEFAULT => -6
	},
	{#State 20
		DEFAULT => -13
	},
	{#State 21
		ACTIONS => {
			"\$" => 119,
			'LITERAL' => 116,
			"\"" => 120,
			'NUMBER' => 84,
			'IDENT' => 117,
			'FILENAME' => 81
		},
		GOTOS => {
			'filepart' => 79,
			'filename' => 89,
			'names' => 83,
			'name' => 87,
			'nameargs' => 118
		}
	},
	{#State 22
		ACTIONS => {
			"\$" => 53,
			"{" => 6,
			'LITERAL' => 100,
			"\"" => 72,
			"[" => 46,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29,
			"\${" => 40,
			"(" => 18,
			'REF' => 52
		},
		GOTOS => {
			'expr' => 121,
			'lterm' => 39,
			'ident' => 99,
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54
		}
	},
	{#State 23
		ACTIONS => {
			"(" => 18,
			"\${" => 40,
			'REF' => 52,
			"\"" => 72,
			'LITERAL' => 100,
			"{" => 6,
			"\$" => 53,
			"[" => 46,
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35
		},
		GOTOS => {
			'expr' => 122,
			'sterm' => 58,
			'node' => 54,
			'item' => 61,
			'term' => 32,
			'ident' => 99,
			'lterm' => 39
		}
	},
	{#State 24
		ACTIONS => {
			"\"" => 120,
			"\$" => 119,
			'LITERAL' => 116,
			'IDENT' => 117,
			'NUMBER' => 84,
			'FILENAME' => 81
		},
		GOTOS => {
			'nameargs' => 123,
			'filename' => 89,
			'filepart' => 79,
			'names' => 83,
			'name' => 87
		}
	},
	{#State 25
		ACTIONS => {
			'IDENT' => 124
		}
	},
	{#State 26
		ACTIONS => {
			'IDENT' => 127
		},
		GOTOS => {
			'metadata' => 126,
			'meta' => 125
		}
	},
	{#State 27
		ACTIONS => {
			'IDENT' => 130,
			'NUMBER' => 84,
			'FILENAME' => 81,
			'LITERAL' => 132
		},
		DEFAULT => -88,
		GOTOS => {
			'metadata' => 129,
			'meta' => 125,
			'blockargs' => 133,
			'filename' => 131,
			'filepart' => 79,
			'blockname' => 128
		}
	},
	{#State 28
		DEFAULT => -39
	},
	{#State 29
		DEFAULT => -131
	},
	{#State 30
		DEFAULT => -8
	},
	{#State 31
		ACTIONS => {
			"(" => 18,
			"\${" => 40,
			'REF' => 52,
			'LITERAL' => 100,
			"\$" => 53,
			"{" => 6,
			"\"" => 72,
			"[" => 46,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29
		},
		GOTOS => {
			'lterm' => 39,
			'ident' => 99,
			'term' => 32,
			'item' => 61,
			'sterm' => 58,
			'node' => 54,
			'expr' => 134
		}
	},
	{#State 32
		DEFAULT => -147
	},
	{#State 33
		DEFAULT => -24
	},
	{#State 34
		DEFAULT => -42
	},
	{#State 35
		DEFAULT => -114
	},
	{#State 36
		ACTIONS => {
			'REF' => 52,
			"\${" => 40,
			'NUMBER' => 35,
			'IDENT' => 136,
			"[" => 46,
			'LITERAL' => 100,
			"{" => 6,
			"\$" => 53,
			"\"" => 72
		},
		GOTOS => {
			'item' => 61,
			'term' => 135,
			'loopvar' => 137,
			'sterm' => 58,
			'node' => 54,
			'lterm' => 39,
			'ident' => 99
		}
	},
	{#State 37
		DEFAULT => -10
	},
	{#State 38
		DEFAULT => -44
	},
	{#State 39
		DEFAULT => -104
	},
	{#State 40
		ACTIONS => {
			'NUMBER' => 35,
			'IDENT' => 29,
			'REF' => 52,
			"\${" => 40,
			"\$" => 53,
			'LITERAL' => 100,
			"\"" => 72
		},
		GOTOS => {
			'ident' => 99,
			'node' => 54,
			'sterm' => 138,
			'item' => 61
		}
	},
	{#State 41
		ACTIONS => {
			"(" => 18,
			"\${" => 40,
			'REF' => 52,
			"[" => 46,
			"{" => 6,
			'LITERAL' => 100,
			"\$" => 53,
			"\"" => 72,
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29
		},
		GOTOS => {
			'lterm' => 39,
			'ident' => 99,
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54,
			'expr' => 139
		}
	},
	{#State 42
		DEFAULT => -23
	},
	{#State 43
		ACTIONS => {
			'NUMBER' => 84,
			'IDENT' => 117,
			'FILENAME' => 81,
			'LITERAL' => 116,
			"\$" => 119,
			"\"" => 120
		},
		GOTOS => {
			'name' => 87,
			'filepart' => 79,
			'filename' => 89,
			'names' => 83,
			'nameargs' => 140
		}
	},
	{#State 44
		DEFAULT => -38
	},
	{#State 45
		DEFAULT => -45
	},
	{#State 46
		ACTIONS => {
			'REF' => 52,
			"\${" => 40,
			"]" => 143,
			'NUMBER' => 35,
			'IDENT' => 29,
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6,
			"\"" => 72,
			"[" => 46
		},
		GOTOS => {
			'item' => 61,
			'list' => 142,
			'node' => 54,
			'lterm' => 39,
			'ident' => 99,
			'term' => 144,
			'range' => 145,
			'sterm' => 141
		}
	},
	{#State 47
		ACTIONS => {
			'IDENT' => 29,
			"\${" => 40,
			'LITERAL' => 147,
			"\$" => 53
		},
		GOTOS => {
			'ident' => 146,
			'item' => 61,
			'node' => 54,
			'setlist' => 148,
			'assign' => 69
		}
	},
	{#State 48
		DEFAULT => -27
	},
	{#State 49
		ACTIONS => {
			"\"" => 120,
			"\$" => 119,
			'LITERAL' => 116,
			'FILENAME' => 81,
			'IDENT' => 117,
			'NUMBER' => 84
		},
		GOTOS => {
			'name' => 87,
			'names' => 83,
			'filename' => 89,
			'filepart' => 79,
			'nameargs' => 149
		}
	},
	{#State 50
		ACTIONS => {
			'NUMBER' => 84,
			'IDENT' => 117,
			'FILENAME' => 81,
			'LITERAL' => 116,
			"\$" => 119,
			"\"" => 120
		},
		GOTOS => {
			'filename' => 89,
			'filepart' => 79,
			'names' => 83,
			'name' => 87,
			'nameargs' => 150
		}
	},
	{#State 51
		DEFAULT => -12
	},
	{#State 52
		ACTIONS => {
			'IDENT' => 29,
			"\${" => 40,
			"\$" => 53
		},
		GOTOS => {
			'ident' => 151,
			'item' => 61,
			'node' => 54
		}
	},
	{#State 53
		ACTIONS => {
			'IDENT' => 152
		}
	},
	{#State 54
		DEFAULT => -128
	},
	{#State 55
		DEFAULT => -41
	},
	{#State 56
		ACTIONS => {
			"\${" => 40,
			"\$" => 53,
			'LITERAL' => 147,
			'IDENT' => 29
		},
		GOTOS => {
			'assign' => 69,
			'setlist' => 153,
			'item' => 61,
			'node' => 54,
			'ident' => 146
		}
	},
	{#State 57
		ACTIONS => {
			'' => 154
		}
	},
	{#State 58
		DEFAULT => -105
	},
	{#State 59
		DEFAULT => -16
	},
	{#State 60
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 61
		ACTIONS => {
			"(" => 155
		},
		DEFAULT => -129
	},
	{#State 62
		ACTIONS => {
			"\"" => 120,
			'LITERAL' => 116,
			"\$" => 119,
			'IDENT' => 117,
			'NUMBER' => 84,
			'FILENAME' => 81
		},
		GOTOS => {
			'name' => 87,
			'names' => 83,
			'filename' => 89,
			'filepart' => 79,
			'nameargs' => 156
		}
	},
	{#State 63
		ACTIONS => {
			'FILENAME' => 81,
			'IDENT' => 117,
			'NUMBER' => 84,
			"\"" => 120,
			'LITERAL' => 116,
			"\$" => 119
		},
		GOTOS => {
			'nameargs' => 157,
			'names' => 83,
			'filepart' => 79,
			'filename' => 89,
			'name' => 87
		}
	},
	{#State 64
		ACTIONS => {
			";" => -17,
			'MOD' => 162,
			"/" => 159,
			'AND' => 160,
			'CAT' => 163,
			"+" => 158,
			'BINOP' => 161,
			'OR' => 166,
			"?" => 167,
			'DIV' => 165,
			'CMPOP' => 164
		},
		DEFAULT => -28
	},
	{#State 65
		DEFAULT => -22
	},
	{#State 66
		DEFAULT => -14
	},
	{#State 67
		ACTIONS => {
			'COMMA' => 168,
			'IDENT' => 29,
			'LITERAL' => 147,
			"\$" => 53,
			"\${" => 40
		},
		DEFAULT => -20,
		GOTOS => {
			'assign' => 169,
			'item' => 61,
			'node' => 54,
			'ident' => 146
		}
	},
	{#State 68
		ACTIONS => {
			'NOT' => 8,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'FILTER' => 4,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'RAW' => 5,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			"\${" => 40,
			'GET' => 41,
			'CALL' => 16,
			"\$" => 53,
			'LAST' => 55,
			'DEFAULT' => 56,
			'VIEW' => 50,
			'REF' => 52,
			'SWITCH' => 10,
			'USE' => 11,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'IDENT' => 29,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'WHILE' => 31,
			'rawperl' => 59,
			'UNLESS' => 23,
			'INSERT' => 24,
			'BLOCK' => 27,
			'META' => 26,
			'MACRO' => 25,
			'STOP' => 28,
			'THROW' => 21,
			'IF' => 22,
			"(" => 18,
			'TEXT' => 19,
			'NUMBER' => 35,
			'TRY' => 73,
			'FOR' => 36,
			";" => -19,
			"\"" => 72,
			'NEXT' => 34
		},
		DEFAULT => -2,
		GOTOS => {
			'expr' => 64,
			'directive' => 30,
			'atomdir' => 60,
			'item' => 61,
			'filter' => 45,
			'switch' => 42,
			'use' => 20,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'anonblock' => 37,
			'atomexpr' => 15,
			'javascript' => 17,
			'defblockname' => 75,
			'try' => 74,
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'chunk' => 170,
			'assign' => 69,
			'condition' => 65,
			'loop' => 33,
			'macro' => 51,
			'setlist' => 67,
			'raw' => 66,
			'term' => 32,
			'ident' => 9
		}
	},
	{#State 69
		DEFAULT => -150
	},
	{#State 70
		DEFAULT => -5
	},
	{#State 71
		DEFAULT => -9
	},
	{#State 72
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 171
		}
	},
	{#State 73
		ACTIONS => {
			";" => 172
		}
	},
	{#State 74
		DEFAULT => -25
	},
	{#State 75
		ACTIONS => {
			'IDENT' => 127
		},
		DEFAULT => -88,
		GOTOS => {
			'meta' => 125,
			'metadata' => 129,
			'blockargs' => 173
		}
	},
	{#State 76
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 174
		}
	},
	{#State 77
		DEFAULT => -7
	},
	{#State 78
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 175
		}
	},
	{#State 79
		DEFAULT => -172
	},
	{#State 80
		DEFAULT => -160
	},
	{#State 81
		DEFAULT => -173
	},
	{#State 82
		ACTIONS => {
			'IDENT' => 176,
			"\${" => 40,
			"\$" => 53
		},
		GOTOS => {
			'item' => 61,
			'node' => 54,
			'ident' => 177
		}
	},
	{#State 83
		ACTIONS => {
			"(" => 179,
			"+" => 178
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 180
		}
	},
	{#State 84
		DEFAULT => -175
	},
	{#State 85
		DEFAULT => -159
	},
	{#State 86
		ACTIONS => {
			";" => 181
		}
	},
	{#State 87
		DEFAULT => -167
	},
	{#State 88
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 89
		ACTIONS => {
			'DOT' => 182
		},
		DEFAULT => -169
	},
	{#State 90
		ACTIONS => {
			'ASSIGN' => 183
		}
	},
	{#State 91
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 92
		DEFAULT => -76
	},
	{#State 93
		ACTIONS => {
			"\$" => 53,
			'LITERAL' => 94,
			"\${" => 40,
			'IDENT' => 29,
			'COMMA' => 184
		},
		DEFAULT => -119,
		GOTOS => {
			'param' => 185,
			'item' => 97
		}
	},
	{#State 94
		ACTIONS => {
			'ASSIGN' => 186
		}
	},
	{#State 95
		ACTIONS => {
			"}" => 187
		}
	},
	{#State 96
		DEFAULT => -123
	},
	{#State 97
		ACTIONS => {
			'ASSIGN' => 188
		}
	},
	{#State 98
		ACTIONS => {
			'REF' => 52,
			"(" => 18,
			"\${" => 40,
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29,
			"{" => 6,
			"\$" => 53,
			'LITERAL' => 100,
			"\"" => 72,
			"[" => 46
		},
		GOTOS => {
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54,
			'lterm' => 39,
			'ident' => 99,
			'expr' => 189
		}
	},
	{#State 99
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -110
	},
	{#State 100
		DEFAULT => -113
	},
	{#State 101
		ACTIONS => {
			'CMPOP' => 164,
			'DIV' => 165,
			'BINOP' => 161,
			'MOD' => 162,
			"+" => 158,
			'CAT' => 163,
			"/" => 159
		},
		DEFAULT => -143
	},
	{#State 102
		ACTIONS => {
			"\"" => 72,
			'NEXT' => 34,
			'TRY' => 73,
			'NUMBER' => 35,
			'FOR' => 36,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21,
			'STOP' => 28,
			'BLOCK' => 190,
			'UNLESS' => 23,
			'INSERT' => 24,
			'IDENT' => 29,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'SWITCH' => 10,
			'REF' => 52,
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			"\${" => 40,
			'GET' => 41,
			'FILTER' => 4,
			'RETURN' => 44,
			'INCLUDE' => 43,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8
		},
		GOTOS => {
			'item' => 61,
			'atomdir' => 60,
			'mdir' => 192,
			'filter' => 45,
			'expr' => 193,
			'directive' => 191,
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'switch' => 42,
			'node' => 54,
			'javascript' => 17,
			'atomexpr' => 15,
			'try' => 74,
			'term' => 32,
			'ident' => 115,
			'assign' => 69,
			'setlist' => 67,
			'loop' => 33,
			'condition' => 65
		}
	},
	{#State 103
		ACTIONS => {
			'NUMBER' => 194,
			'IDENT' => 29,
			"\$" => 53,
			"\${" => 40
		},
		GOTOS => {
			'node' => 195,
			'item' => 61
		}
	},
	{#State 104
		ACTIONS => {
			"?" => 167,
			'OR' => 166,
			'CMPOP' => 164,
			'BINOP' => 161,
			'MOD' => 162,
			'AND' => 160,
			'CAT' => 163,
			"/" => 159,
			"+" => 158,
			'DIV' => 165,
			";" => 196
		}
	},
	{#State 105
		DEFAULT => -75
	},
	{#State 106
		ACTIONS => {
			"\"" => 78,
			'LITERAL' => 91,
			"\$" => 82,
			"\${" => 40,
			'IDENT' => 88,
			'NUMBER' => 84,
			'FILENAME' => 81
		},
		GOTOS => {
			'filepart' => 79,
			'lvalue' => 90,
			'names' => 83,
			'filename' => 89,
			'name' => 87,
			'lnameargs' => 197,
			'nameargs' => 85,
			'item' => 80
		}
	},
	{#State 107
		ACTIONS => {
			'REF' => 52,
			"\${" => 40,
			'IDENT' => 136,
			'NUMBER' => 35,
			"\"" => 72,
			"{" => 6,
			'LITERAL' => 100,
			"\$" => 53,
			"[" => 46
		},
		GOTOS => {
			'lterm' => 39,
			'ident' => 99,
			'term' => 135,
			'loopvar' => 198,
			'item' => 61,
			'sterm' => 58,
			'node' => 54
		}
	},
	{#State 108
		ACTIONS => {
			"(" => 18,
			"\${" => 40,
			'REF' => 52,
			"[" => 46,
			"{" => 6,
			"\$" => 53,
			'LITERAL' => 100,
			"\"" => 72,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29
		},
		GOTOS => {
			'lterm' => 39,
			'ident' => 99,
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54,
			'expr' => 199
		}
	},
	{#State 109
		ACTIONS => {
			"\"" => 72,
			'LITERAL' => 100,
			"\$" => 53,
			"{" => 6,
			"[" => 46,
			'IDENT' => 29,
			'NUMBER' => 35,
			'NOT' => 8,
			"(" => 18,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'expr' => 200,
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54,
			'lterm' => 39,
			'ident' => 99
		}
	},
	{#State 110
		ACTIONS => {
			"\${" => 40,
			"(" => 18,
			'REF' => 52,
			"[" => 46,
			'LITERAL' => 100,
			"{" => 6,
			"\$" => 53,
			"\"" => 72,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29
		},
		GOTOS => {
			'expr' => 201,
			'lterm' => 39,
			'ident' => 99,
			'term' => 32,
			'item' => 61,
			'sterm' => 58,
			'node' => 54
		}
	},
	{#State 111
		ACTIONS => {
			"\"" => 120,
			"\$" => 119,
			'LITERAL' => 116,
			'IDENT' => 117,
			'NUMBER' => 84,
			'FILENAME' => 81
		},
		GOTOS => {
			'nameargs' => 202,
			'names' => 83,
			'filepart' => 79,
			'filename' => 89,
			'name' => 87
		}
	},
	{#State 112
		ACTIONS => {
			'CMPOP' => 164,
			'DIV' => 165,
			"?" => 167,
			'OR' => 166,
			'BINOP' => 161,
			'CAT' => 163,
			"/" => 159,
			'AND' => 160,
			"+" => 158,
			'MOD' => 162
		},
		DEFAULT => -31
	},
	{#State 113
		ACTIONS => {
			")" => 203
		}
	},
	{#State 114
		ACTIONS => {
			'CMPOP' => 164,
			'BINOP' => 161,
			"?" => 167,
			'OR' => 166,
			")" => 204,
			'DIV' => 165,
			'CAT' => 163,
			"/" => 159,
			'AND' => 160,
			"+" => 158,
			'MOD' => 162
		}
	},
	{#State 115
		ACTIONS => {
			'ASSIGN' => 205,
			'DOT' => 103
		},
		DEFAULT => -110
	},
	{#State 116
		DEFAULT => -170
	},
	{#State 117
		DEFAULT => -174
	},
	{#State 118
		DEFAULT => -37
	},
	{#State 119
		ACTIONS => {
			"\$" => 53,
			"\${" => 40,
			'IDENT' => 29
		},
		GOTOS => {
			'item' => 61,
			'node' => 54,
			'ident' => 177
		}
	},
	{#State 120
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 206
		}
	},
	{#State 121
		ACTIONS => {
			'BINOP' => 161,
			'CMPOP' => 164,
			'OR' => 166,
			"?" => 167,
			'DIV' => 165,
			";" => 207,
			'MOD' => 162,
			"+" => 158,
			"/" => 159,
			'AND' => 160,
			'CAT' => 163
		}
	},
	{#State 122
		ACTIONS => {
			'MOD' => 162,
			"/" => 159,
			'CAT' => 163,
			'AND' => 160,
			"+" => 158,
			'DIV' => 165,
			";" => 208,
			"?" => 167,
			'OR' => 166,
			'CMPOP' => 164,
			'BINOP' => 161
		}
	},
	{#State 123
		DEFAULT => -34
	},
	{#State 124
		ACTIONS => {
			'REF' => 52,
			'SWITCH' => 10,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'CALL' => 16,
			'DEFAULT' => 56,
			'LAST' => 55,
			"\$" => 53,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'FILTER' => 4,
			"\${" => 40,
			'GET' => 41,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			'NOT' => 8,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'NEXT' => 34,
			"\"" => 72,
			'THROW' => 21,
			'IF' => 22,
			"(" => 211,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'WHILE' => 31,
			'IDENT' => 29,
			'INSERT' => 24,
			'UNLESS' => 23,
			'STOP' => 28,
			'BLOCK' => 190
		},
		GOTOS => {
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'switch' => 42,
			'mdir' => 209,
			'atomdir' => 60,
			'item' => 61,
			'filter' => 45,
			'expr' => 210,
			'directive' => 191,
			'term' => 32,
			'ident' => 115,
			'assign' => 69,
			'loop' => 33,
			'setlist' => 67,
			'condition' => 65,
			'node' => 54,
			'javascript' => 17,
			'atomexpr' => 15,
			'try' => 74
		}
	},
	{#State 125
		DEFAULT => -100
	},
	{#State 126
		ACTIONS => {
			'COMMA' => 212,
			'IDENT' => 127
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 213
		}
	},
	{#State 127
		ACTIONS => {
			'ASSIGN' => 214
		}
	},
	{#State 128
		DEFAULT => -84
	},
	{#State 129
		ACTIONS => {
			'COMMA' => 212,
			'IDENT' => 127
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 213
		}
	},
	{#State 130
		ACTIONS => {
			'ASSIGN' => 214
		},
		DEFAULT => -174
	},
	{#State 131
		ACTIONS => {
			'DOT' => 182
		},
		DEFAULT => -85
	},
	{#State 132
		DEFAULT => -86
	},
	{#State 133
		ACTIONS => {
			";" => 215
		}
	},
	{#State 134
		ACTIONS => {
			"?" => 167,
			'OR' => 166,
			'BINOP' => 161,
			'CMPOP' => 164,
			"+" => 158,
			"/" => 159,
			'AND' => 160,
			'CAT' => 163,
			'MOD' => 162,
			";" => 216,
			'DIV' => 165
		}
	},
	{#State 135
		DEFAULT => -157,
		GOTOS => {
			'args' => 217
		}
	},
	{#State 136
		ACTIONS => {
			'IN' => 218,
			'ASSIGN' => 219
		},
		DEFAULT => -131
	},
	{#State 137
		ACTIONS => {
			";" => 220
		}
	},
	{#State 138
		ACTIONS => {
			"}" => 221
		}
	},
	{#State 139
		ACTIONS => {
			"+" => 158,
			'AND' => 160,
			'CAT' => 163,
			"/" => 159,
			'MOD' => 162,
			'BINOP' => 161,
			'OR' => 166,
			"?" => 167,
			'DIV' => 165,
			'CMPOP' => 164
		},
		DEFAULT => -30
	},
	{#State 140
		DEFAULT => -35
	},
	{#State 141
		ACTIONS => {
			'TO' => 222
		},
		DEFAULT => -105
	},
	{#State 142
		ACTIONS => {
			"\${" => 40,
			'REF' => 52,
			'COMMA' => 225,
			"[" => 46,
			"\"" => 72,
			"{" => 6,
			'LITERAL' => 100,
			"\$" => 53,
			'IDENT' => 29,
			'NUMBER' => 35,
			"]" => 224
		},
		GOTOS => {
			'lterm' => 39,
			'ident' => 99,
			'term' => 223,
			'item' => 61,
			'node' => 54,
			'sterm' => 58
		}
	},
	{#State 143
		DEFAULT => -108
	},
	{#State 144
		DEFAULT => -117
	},
	{#State 145
		ACTIONS => {
			"]" => 226
		}
	},
	{#State 146
		ACTIONS => {
			'ASSIGN' => 205,
			'DOT' => 103
		}
	},
	{#State 147
		ACTIONS => {
			'ASSIGN' => 98
		}
	},
	{#State 148
		ACTIONS => {
			"\$" => 53,
			'LITERAL' => 147,
			'IDENT' => 29,
			"\${" => 40,
			'COMMA' => 168
		},
		DEFAULT => -32,
		GOTOS => {
			'assign' => 169,
			'ident' => 146,
			'node' => 54,
			'item' => 61
		}
	},
	{#State 149
		DEFAULT => -43
	},
	{#State 150
		ACTIONS => {
			";" => 227
		}
	},
	{#State 151
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -111
	},
	{#State 152
		DEFAULT => -133
	},
	{#State 153
		ACTIONS => {
			"\${" => 40,
			'COMMA' => 168,
			"\$" => 53,
			'LITERAL' => 147,
			'IDENT' => 29
		},
		DEFAULT => -33,
		GOTOS => {
			'item' => 61,
			'node' => 54,
			'ident' => 146,
			'assign' => 169
		}
	},
	{#State 154
		DEFAULT => 0
	},
	{#State 155
		DEFAULT => -157,
		GOTOS => {
			'args' => 228
		}
	},
	{#State 156
		DEFAULT => -36
	},
	{#State 157
		ACTIONS => {
			";" => 229
		}
	},
	{#State 158
		ACTIONS => {
			'REF' => 52,
			"(" => 18,
			"\${" => 40,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29,
			"[" => 46,
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6,
			"\"" => 72
		},
		GOTOS => {
			'expr' => 230,
			'ident' => 99,
			'lterm' => 39,
			'sterm' => 58,
			'node' => 54,
			'term' => 32,
			'item' => 61
		}
	},
	{#State 159
		ACTIONS => {
			"\"" => 72,
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6,
			"[" => 46,
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35,
			"\${" => 40,
			"(" => 18,
			'REF' => 52
		},
		GOTOS => {
			'ident' => 99,
			'lterm' => 39,
			'node' => 54,
			'sterm' => 58,
			'item' => 61,
			'term' => 32,
			'expr' => 231
		}
	},
	{#State 160
		ACTIONS => {
			"[" => 46,
			"\"" => 72,
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6,
			'IDENT' => 29,
			'NUMBER' => 35,
			'NOT' => 8,
			"(" => 18,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'expr' => 232,
			'term' => 32,
			'item' => 61,
			'node' => 54,
			'sterm' => 58,
			'lterm' => 39,
			'ident' => 99
		}
	},
	{#State 161
		ACTIONS => {
			"[" => 46,
			'LITERAL' => 100,
			"{" => 6,
			"\$" => 53,
			"\"" => 72,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29,
			"(" => 18,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'lterm' => 39,
			'ident' => 99,
			'term' => 32,
			'item' => 61,
			'sterm' => 58,
			'node' => 54,
			'expr' => 233
		}
	},
	{#State 162
		ACTIONS => {
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35,
			"[" => 46,
			"\"" => 72,
			'LITERAL' => 100,
			"\$" => 53,
			"{" => 6,
			'REF' => 52,
			"\${" => 40,
			"(" => 18
		},
		GOTOS => {
			'expr' => 234,
			'term' => 32,
			'item' => 61,
			'node' => 54,
			'sterm' => 58,
			'lterm' => 39,
			'ident' => 99
		}
	},
	{#State 163
		ACTIONS => {
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29,
			"{" => 6,
			'LITERAL' => 100,
			"\$" => 53,
			"\"" => 72,
			"[" => 46,
			'REF' => 52,
			"(" => 18,
			"\${" => 40
		},
		GOTOS => {
			'expr' => 235,
			'ident' => 99,
			'lterm' => 39,
			'node' => 54,
			'sterm' => 58,
			'item' => 61,
			'term' => 32
		}
	},
	{#State 164
		ACTIONS => {
			"[" => 46,
			"\"" => 72,
			"\$" => 53,
			"{" => 6,
			'LITERAL' => 100,
			'IDENT' => 29,
			'NUMBER' => 35,
			'NOT' => 8,
			"(" => 18,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'term' => 32,
			'item' => 61,
			'sterm' => 58,
			'node' => 54,
			'lterm' => 39,
			'ident' => 99,
			'expr' => 236
		}
	},
	{#State 165
		ACTIONS => {
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6,
			"\"" => 72,
			"[" => 46,
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29,
			"(" => 18,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'expr' => 237,
			'lterm' => 39,
			'ident' => 99,
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54
		}
	},
	{#State 166
		ACTIONS => {
			'REF' => 52,
			"(" => 18,
			"\${" => 40,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29,
			'LITERAL' => 100,
			"\$" => 53,
			"{" => 6,
			"\"" => 72,
			"[" => 46
		},
		GOTOS => {
			'sterm' => 58,
			'node' => 54,
			'item' => 61,
			'term' => 32,
			'ident' => 99,
			'lterm' => 39,
			'expr' => 238
		}
	},
	{#State 167
		ACTIONS => {
			"(" => 18,
			"\${" => 40,
			'REF' => 52,
			"[" => 46,
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6,
			"\"" => 72,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29
		},
		GOTOS => {
			'expr' => 239,
			'ident' => 99,
			'lterm' => 39,
			'node' => 54,
			'sterm' => 58,
			'term' => 32,
			'item' => 61
		}
	},
	{#State 168
		DEFAULT => -149
	},
	{#State 169
		DEFAULT => -148
	},
	{#State 170
		DEFAULT => -4
	},
	{#State 171
		ACTIONS => {
			"\"" => 244,
			";" => 243,
			"\$" => 53,
			'TEXT' => 242,
			"\${" => 40,
			'IDENT' => 29
		},
		GOTOS => {
			'quotable' => 241,
			'item' => 61,
			'node' => 54,
			'ident' => 240
		}
	},
	{#State 172
		ACTIONS => {
			'TRY' => 73,
			'NUMBER' => 35,
			'FOR' => 36,
			";" => -19,
			"\"" => 72,
			'NEXT' => 34,
			'IF' => 22,
			'THROW' => 21,
			'TEXT' => 19,
			"(" => 18,
			'IDENT' => 29,
			'WHILE' => 31,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'rawperl' => 59,
			'META' => 26,
			'MACRO' => 25,
			'BLOCK' => 27,
			'STOP' => 28,
			'INSERT' => 24,
			'UNLESS' => 23,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50,
			'USE' => 11,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'CALL' => 16,
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'FILTER' => 4,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'GET' => 41,
			"\${" => 40,
			'NOT' => 8,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'atomexpr' => 15,
			'anonblock' => 37,
			'javascript' => 17,
			'defblockname' => 75,
			'try' => 74,
			'block' => 245,
			'term' => 32,
			'ident' => 9,
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'condition' => 65,
			'macro' => 51,
			'loop' => 33,
			'setlist' => 67,
			'raw' => 66,
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'use' => 20,
			'switch' => 42
		}
	},
	{#State 173
		ACTIONS => {
			";" => 246
		}
	},
	{#State 174
		ACTIONS => {
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50,
			'USE' => 11,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'GET' => 41,
			"\${" => 40,
			'FILTER' => 4,
			'RAW' => 5,
			'RETURN' => 44,
			'INCLUDE' => 43,
			"\"" => 72,
			";" => -19,
			'NEXT' => 34,
			'NUMBER' => 35,
			'TRY' => 73,
			'FOR' => 36,
			'rawperl' => 59,
			'META' => 26,
			'MACRO' => 25,
			'BLOCK' => 27,
			'STOP' => 28,
			'INSERT' => 24,
			'UNLESS' => 23,
			'IDENT' => 29,
			'WHILE' => 31,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'atomdir' => 60,
			'item' => 61,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30,
			'statement' => 3,
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'use' => 20,
			'switch' => 42,
			'view' => 13,
			'node' => 54,
			'capture' => 12,
			'defblock' => 71,
			'defblockname' => 75,
			'javascript' => 17,
			'atomexpr' => 15,
			'anonblock' => 37,
			'block' => 247,
			'try' => 74,
			'term' => 32,
			'ident' => 9,
			'assign' => 69,
			'chunk' => 70,
			'chunks' => 68,
			'setlist' => 67,
			'loop' => 33,
			'raw' => 66,
			'macro' => 51,
			'condition' => 65
		}
	},
	{#State 175
		ACTIONS => {
			'IDENT' => 29,
			"\${" => 40,
			'TEXT' => 242,
			"\$" => 53,
			";" => 243,
			"\"" => 248
		},
		GOTOS => {
			'ident' => 240,
			'node' => 54,
			'item' => 61,
			'quotable' => 241
		}
	},
	{#State 176
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 177
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 249
		}
	},
	{#State 178
		ACTIONS => {
			"\"" => 120,
			'LITERAL' => 116,
			'FILENAME' => 81,
			'IDENT' => 117,
			'NUMBER' => 84
		},
		GOTOS => {
			'filename' => 89,
			'filepart' => 79,
			'name' => 250
		}
	},
	{#State 179
		DEFAULT => -157,
		GOTOS => {
			'args' => 251
		}
	},
	{#State 180
		ACTIONS => {
			'REF' => 52,
			"\"" => 72,
			"\$" => 53,
			'NUMBER' => 35,
			"\${" => 40,
			"(" => 18,
			'COMMA' => 252,
			'LITERAL' => 257,
			"{" => 6,
			"[" => 46,
			'IDENT' => 29,
			'NOT' => 8
		},
		DEFAULT => -164,
		GOTOS => {
			'expr' => 254,
			'param' => 255,
			'node' => 54,
			'item' => 253,
			'ident' => 256,
			'lterm' => 39,
			'sterm' => 58,
			'term' => 32
		}
	},
	{#State 181
		ACTIONS => {
			'IF' => 22,
			'THROW' => 21,
			'TEXT' => 19,
			"(" => 18,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'IDENT' => 29,
			'META' => 26,
			'MACRO' => 25,
			'BLOCK' => 27,
			'STOP' => 28,
			'UNLESS' => 23,
			'INSERT' => 24,
			'rawperl' => 59,
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'RAW' => 5,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'FILTER' => 4,
			"\${" => 40,
			'GET' => 41,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'NOT' => 8,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'USE' => 11,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'CALL' => 16,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 9,
			'term' => 32,
			'condition' => 65,
			'loop' => 33,
			'macro' => 51,
			'setlist' => 67,
			'raw' => 66,
			'chunks' => 68,
			'chunk' => 70,
			'assign' => 69,
			'defblock' => 71,
			'capture' => 12,
			'node' => 54,
			'view' => 13,
			'try' => 74,
			'block' => 258,
			'atomexpr' => 15,
			'anonblock' => 37,
			'defblockname' => 75,
			'javascript' => 17,
			'wrapper' => 38,
			'lterm' => 39,
			'sterm' => 58,
			'statement' => 3,
			'use' => 20,
			'switch' => 42,
			'filter' => 45,
			'atomdir' => 60,
			'item' => 61,
			'directive' => 30,
			'expr' => 64
		}
	},
	{#State 182
		ACTIONS => {
			'IDENT' => 117,
			'NUMBER' => 84,
			'FILENAME' => 81
		},
		GOTOS => {
			'filepart' => 259
		}
	},
	{#State 183
		ACTIONS => {
			"\"" => 120,
			"\$" => 119,
			'LITERAL' => 116,
			'FILENAME' => 81,
			'IDENT' => 117,
			'NUMBER' => 84
		},
		GOTOS => {
			'filename' => 89,
			'filepart' => 79,
			'names' => 83,
			'name' => 87,
			'nameargs' => 260
		}
	},
	{#State 184
		DEFAULT => -122
	},
	{#State 185
		DEFAULT => -121
	},
	{#State 186
		ACTIONS => {
			'REF' => 52,
			"(" => 18,
			"\${" => 40,
			'IDENT' => 29,
			'NUMBER' => 35,
			'NOT' => 8,
			"[" => 46,
			"\"" => 72,
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6
		},
		GOTOS => {
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54,
			'lterm' => 39,
			'ident' => 99,
			'expr' => 261
		}
	},
	{#State 187
		DEFAULT => -109
	},
	{#State 188
		ACTIONS => {
			'REF' => 52,
			"\${" => 40,
			"(" => 18,
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29,
			"\$" => 53,
			"{" => 6,
			'LITERAL' => 100,
			"\"" => 72,
			"[" => 46
		},
		GOTOS => {
			'term' => 32,
			'item' => 61,
			'node' => 54,
			'sterm' => 58,
			'lterm' => 39,
			'ident' => 99,
			'expr' => 262
		}
	},
	{#State 189
		ACTIONS => {
			'DIV' => 165,
			'CMPOP' => 164,
			'CAT' => 163,
			"/" => 159,
			'AND' => 160,
			"+" => 158,
			'MOD' => 162,
			'BINOP' => 161,
			'OR' => 166,
			"?" => 167
		},
		DEFAULT => -152
	},
	{#State 190
		ACTIONS => {
			";" => 263
		}
	},
	{#State 191
		DEFAULT => -93
	},
	{#State 192
		DEFAULT => -90
	},
	{#State 193
		ACTIONS => {
			'BINOP' => 161,
			"?" => 167,
			'OR' => 166,
			";" => -151,
			"\$" => -151,
			'MOD' => 162,
			"+" => 158,
			'CAT' => 163,
			'AND' => 160,
			"/" => 159,
			"\${" => -151,
			'CMPOP' => 164,
			'COMMA' => -151,
			'DIV' => 165,
			'LITERAL' => -151,
			'IDENT' => -151
		},
		DEFAULT => -28
	},
	{#State 194
		DEFAULT => -127
	},
	{#State 195
		DEFAULT => -126
	},
	{#State 196
		ACTIONS => {
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'IDENT' => 29,
			'META' => 26,
			'BLOCK' => 27,
			'STOP' => 28,
			'MACRO' => 25,
			'INSERT' => 24,
			'UNLESS' => 23,
			'rawperl' => 59,
			'IF' => 22,
			'THROW' => 21,
			'TEXT' => 19,
			"(" => 18,
			'CALL' => 16,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53,
			'USE' => 11,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'NOT' => 8,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'FILTER' => 4,
			'GET' => 41,
			"\${" => 40,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1
		},
		DEFAULT => -3,
		GOTOS => {
			'macro' => 51,
			'setlist' => 67,
			'loop' => 33,
			'raw' => 66,
			'condition' => 65,
			'chunk' => 70,
			'assign' => 69,
			'chunks' => 68,
			'ident' => 9,
			'term' => 32,
			'block' => 264,
			'try' => 74,
			'javascript' => 17,
			'defblockname' => 75,
			'atomexpr' => 15,
			'anonblock' => 37,
			'capture' => 12,
			'defblock' => 71,
			'view' => 13,
			'node' => 54,
			'use' => 20,
			'switch' => 42,
			'lterm' => 39,
			'wrapper' => 38,
			'statement' => 3,
			'sterm' => 58,
			'directive' => 30,
			'expr' => 64,
			'filter' => 45,
			'item' => 61,
			'atomdir' => 60
		}
	},
	{#State 197
		DEFAULT => -82
	},
	{#State 198
		DEFAULT => -60
	},
	{#State 199
		ACTIONS => {
			"+" => 158,
			'CAT' => 163,
			"/" => 159,
			'AND' => 160,
			'MOD' => 162,
			'DIV' => 165,
			'OR' => 166,
			"?" => 167,
			'BINOP' => 161,
			'CMPOP' => 164
		},
		DEFAULT => -63
	},
	{#State 200
		ACTIONS => {
			'CMPOP' => 164,
			'BINOP' => 161,
			"?" => 167,
			'OR' => 166,
			'DIV' => 165,
			'MOD' => 162,
			"/" => 159,
			'AND' => 160,
			'CAT' => 163,
			"+" => 158
		},
		DEFAULT => -49
	},
	{#State 201
		ACTIONS => {
			'CMPOP' => 164,
			'BINOP' => 161,
			"?" => 167,
			'OR' => 166,
			'DIV' => 165,
			"/" => 159,
			'AND' => 160,
			'CAT' => 163,
			"+" => 158,
			'MOD' => 162
		},
		DEFAULT => -47
	},
	{#State 202
		DEFAULT => -68
	},
	{#State 203
		DEFAULT => -145
	},
	{#State 204
		DEFAULT => -146
	},
	{#State 205
		ACTIONS => {
			"\${" => 40,
			"(" => 18,
			'REF' => 52,
			"\"" => 72,
			"{" => 6,
			'LITERAL' => 100,
			"\$" => 53,
			"[" => 46,
			'IDENT' => 29,
			'NUMBER' => 35,
			'NOT' => 8
		},
		GOTOS => {
			'expr' => 265,
			'ident' => 99,
			'lterm' => 39,
			'node' => 54,
			'sterm' => 58,
			'item' => 61,
			'term' => 32
		}
	},
	{#State 206
		ACTIONS => {
			"\"" => 266,
			";" => 243,
			"\$" => 53,
			'TEXT' => 242,
			"\${" => 40,
			'IDENT' => 29
		},
		GOTOS => {
			'quotable' => 241,
			'item' => 61,
			'node' => 54,
			'ident' => 240
		}
	},
	{#State 207
		ACTIONS => {
			'THROW' => 21,
			'IF' => 22,
			"(" => 18,
			'TEXT' => 19,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'WHILE' => 31,
			'IDENT' => 29,
			'UNLESS' => 23,
			'INSERT' => 24,
			'MACRO' => 25,
			'STOP' => 28,
			'BLOCK' => 27,
			'META' => 26,
			'rawperl' => 59,
			'FOR' => 36,
			'NUMBER' => 35,
			'TRY' => 73,
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'RAW' => 5,
			'FILTER' => 4,
			'GET' => 41,
			"\${" => 40,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			'NOT' => 8,
			"[" => 46,
			"{" => 6,
			'LITERAL' => 7,
			'USE' => 11,
			'VIEW' => 50,
			'SWITCH' => 10,
			'REF' => 52,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'CALL' => 16,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53
		},
		DEFAULT => -3,
		GOTOS => {
			'use' => 20,
			'switch' => 42,
			'statement' => 3,
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'expr' => 64,
			'directive' => 30,
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45,
			'assign' => 69,
			'chunk' => 70,
			'chunks' => 68,
			'setlist' => 67,
			'loop' => 33,
			'raw' => 66,
			'macro' => 51,
			'condition' => 65,
			'term' => 32,
			'ident' => 9,
			'javascript' => 17,
			'defblockname' => 75,
			'atomexpr' => 15,
			'anonblock' => 37,
			'block' => 267,
			'try' => 74,
			'view' => 13,
			'node' => 54,
			'capture' => 12,
			'defblock' => 71
		}
	},
	{#State 208
		ACTIONS => {
			'DEFAULT' => 56,
			'LAST' => 55,
			"\$" => 53,
			'CALL' => 16,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'USE' => 11,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'NOT' => 8,
			'GET' => 41,
			"\${" => 40,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'FILTER' => 4,
			'NEXT' => 34,
			"\"" => 72,
			";" => -19,
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'STOP' => 28,
			'BLOCK' => 27,
			'MACRO' => 25,
			'META' => 26,
			'UNLESS' => 23,
			'INSERT' => 24,
			'rawperl' => 59,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'IDENT' => 29,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 32,
			'ident' => 9,
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'condition' => 65,
			'loop' => 33,
			'raw' => 66,
			'setlist' => 67,
			'macro' => 51,
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'atomexpr' => 15,
			'anonblock' => 37,
			'defblockname' => 75,
			'javascript' => 17,
			'try' => 74,
			'block' => 268,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'switch' => 42,
			'use' => 20,
			'atomdir' => 60,
			'item' => 61,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30
		}
	},
	{#State 209
		DEFAULT => -92
	},
	{#State 210
		ACTIONS => {
			'MOD' => 162,
			'AND' => 160,
			'CAT' => 163,
			"/" => 159,
			"+" => 158,
			'BINOP' => 161,
			"?" => 167,
			'OR' => 166,
			'DIV' => 165,
			'CMPOP' => 164
		},
		DEFAULT => -28
	},
	{#State 211
		ACTIONS => {
			'IDENT' => 270,
			'NOT' => 8,
			'NUMBER' => 35,
			"[" => 46,
			"\"" => 72,
			'LITERAL' => 7,
			"\$" => 53,
			"{" => 6,
			'REF' => 52,
			"(" => 18,
			"\${" => 40
		},
		GOTOS => {
			'expr' => 114,
			'node' => 54,
			'item' => 61,
			'margs' => 269,
			'assign' => 113,
			'ident' => 115,
			'lterm' => 39,
			'sterm' => 58,
			'term' => 32
		}
	},
	{#State 212
		DEFAULT => -99
	},
	{#State 213
		DEFAULT => -98
	},
	{#State 214
		ACTIONS => {
			'NUMBER' => 272,
			"\"" => 271,
			'LITERAL' => 273
		}
	},
	{#State 215
		ACTIONS => {
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'USE' => 11,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53,
			'CALL' => 16,
			'GET' => 41,
			"\${" => 40,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'RAW' => 5,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'FILTER' => 4,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'NOT' => 8,
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'FOR' => 36,
			'NUMBER' => 35,
			'TRY' => 73,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21,
			'STOP' => 28,
			'MACRO' => 25,
			'META' => 26,
			'BLOCK' => 27,
			'UNLESS' => 23,
			'INSERT' => 24,
			'rawperl' => 59,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'IDENT' => 29
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 30,
			'expr' => 64,
			'filter' => 45,
			'item' => 61,
			'atomdir' => 60,
			'use' => 20,
			'switch' => 42,
			'wrapper' => 38,
			'lterm' => 39,
			'sterm' => 58,
			'statement' => 3,
			'try' => 74,
			'block' => 274,
			'anonblock' => 37,
			'atomexpr' => 15,
			'defblockname' => 75,
			'javascript' => 17,
			'defblock' => 71,
			'capture' => 12,
			'node' => 54,
			'view' => 13,
			'condition' => 65,
			'loop' => 33,
			'macro' => 51,
			'setlist' => 67,
			'raw' => 66,
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'ident' => 9,
			'term' => 32
		}
	},
	{#State 216
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 275
		}
	},
	{#State 217
		ACTIONS => {
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35,
			"\"" => 72,
			'LITERAL' => 257,
			"\$" => 53,
			"{" => 6,
			"[" => 46,
			'REF' => 52,
			'COMMA' => 252,
			"(" => 18,
			"\${" => 40
		},
		DEFAULT => -66,
		GOTOS => {
			'expr' => 254,
			'item' => 253,
			'node' => 54,
			'param' => 255,
			'term' => 32,
			'sterm' => 58,
			'lterm' => 39,
			'ident' => 256
		}
	},
	{#State 218
		ACTIONS => {
			"\$" => 53,
			'LITERAL' => 100,
			"{" => 6,
			"\"" => 72,
			"[" => 46,
			'NUMBER' => 35,
			'IDENT' => 29,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'sterm' => 58,
			'node' => 54,
			'term' => 276,
			'item' => 61,
			'ident' => 99,
			'lterm' => 39
		}
	},
	{#State 219
		ACTIONS => {
			'IDENT' => 29,
			'NUMBER' => 35,
			"[" => 46,
			"\"" => 72,
			'LITERAL' => 100,
			"{" => 6,
			"\$" => 53,
			'REF' => 52,
			"\${" => 40
		},
		GOTOS => {
			'node' => 54,
			'sterm' => 58,
			'item' => 61,
			'term' => 277,
			'ident' => 99,
			'lterm' => 39
		}
	},
	{#State 220
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 278
		}
	},
	{#State 221
		DEFAULT => -132
	},
	{#State 222
		ACTIONS => {
			"\$" => 53,
			'LITERAL' => 100,
			"\"" => 72,
			"\${" => 40,
			'NUMBER' => 35,
			'IDENT' => 29,
			'REF' => 52
		},
		GOTOS => {
			'ident' => 99,
			'node' => 54,
			'sterm' => 279,
			'item' => 61
		}
	},
	{#State 223
		DEFAULT => -115
	},
	{#State 224
		DEFAULT => -106
	},
	{#State 225
		DEFAULT => -116
	},
	{#State 226
		DEFAULT => -107
	},
	{#State 227
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 280
		}
	},
	{#State 228
		ACTIONS => {
			'LITERAL' => 257,
			"\$" => 53,
			"{" => 6,
			"\"" => 72,
			"[" => 46,
			")" => 281,
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29,
			"\${" => 40,
			"(" => 18,
			'COMMA' => 252,
			'REF' => 52
		},
		GOTOS => {
			'param' => 255,
			'node' => 54,
			'item' => 253,
			'expr' => 254,
			'ident' => 256,
			'lterm' => 39,
			'sterm' => 58,
			'term' => 32
		}
	},
	{#State 229
		ACTIONS => {
			";" => -19,
			"\"" => 72,
			'NEXT' => 34,
			'TRY' => 73,
			'NUMBER' => 35,
			'FOR' => 36,
			'rawperl' => 59,
			'UNLESS' => 23,
			'INSERT' => 24,
			'META' => 26,
			'STOP' => 28,
			'MACRO' => 25,
			'BLOCK' => 27,
			'IDENT' => 29,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'WHILE' => 31,
			"(" => 18,
			'TEXT' => 19,
			'THROW' => 21,
			'IF' => 22,
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'VIEW' => 50,
			'SWITCH' => 10,
			'REF' => 52,
			'USE' => 11,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			"\${" => 40,
			'GET' => 41,
			'FILTER' => 4,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'RAW' => 5
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 70,
			'assign' => 69,
			'chunks' => 68,
			'macro' => 51,
			'setlist' => 67,
			'raw' => 66,
			'loop' => 33,
			'condition' => 65,
			'term' => 32,
			'ident' => 9,
			'defblockname' => 75,
			'javascript' => 17,
			'anonblock' => 37,
			'atomexpr' => 15,
			'block' => 282,
			'try' => 74,
			'view' => 13,
			'node' => 54,
			'capture' => 12,
			'defblock' => 71,
			'switch' => 42,
			'use' => 20,
			'statement' => 3,
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'expr' => 64,
			'directive' => 30,
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45
		}
	},
	{#State 230
		ACTIONS => {
			'MOD' => 162,
			"/" => 159,
			'DIV' => 165
		},
		DEFAULT => -136
	},
	{#State 231
		ACTIONS => {
			'DIV' => 165,
			'MOD' => 162
		},
		DEFAULT => -135
	},
	{#State 232
		ACTIONS => {
			'CMPOP' => 164,
			'DIV' => 165,
			'BINOP' => 161,
			'MOD' => 162,
			"+" => 158,
			"/" => 159,
			'CAT' => 163
		},
		DEFAULT => -141
	},
	{#State 233
		ACTIONS => {
			'DIV' => 165,
			'MOD' => 162,
			"/" => 159,
			"+" => 158
		},
		DEFAULT => -134
	},
	{#State 234
		DEFAULT => -138
	},
	{#State 235
		ACTIONS => {
			'CMPOP' => 164,
			'DIV' => 165,
			'BINOP' => 161,
			'MOD' => 162,
			"+" => 158,
			"/" => 159
		},
		DEFAULT => -140
	},
	{#State 236
		ACTIONS => {
			"+" => 158,
			"/" => 159,
			'MOD' => 162,
			'BINOP' => 161,
			'DIV' => 165
		},
		DEFAULT => -139
	},
	{#State 237
		ACTIONS => {
			'MOD' => 162
		},
		DEFAULT => -137
	},
	{#State 238
		ACTIONS => {
			'BINOP' => 161,
			'MOD' => 162,
			"+" => 158,
			"/" => 159,
			'CAT' => 163,
			'CMPOP' => 164,
			'DIV' => 165
		},
		DEFAULT => -142
	},
	{#State 239
		ACTIONS => {
			'CMPOP' => 164,
			'BINOP' => 161,
			":" => 283,
			'OR' => 166,
			"?" => 167,
			'DIV' => 165,
			'MOD' => 162,
			'AND' => 160,
			"/" => 159,
			'CAT' => 163,
			"+" => 158
		}
	},
	{#State 240
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -178
	},
	{#State 241
		DEFAULT => -176
	},
	{#State 242
		DEFAULT => -179
	},
	{#State 243
		DEFAULT => -180
	},
	{#State 244
		DEFAULT => -112
	},
	{#State 245
		ACTIONS => {
			'FINAL' => 286,
			'CATCH' => 285
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 284
		}
	},
	{#State 246
		ACTIONS => {
			'TRY' => 73,
			'NUMBER' => 35,
			'FOR' => 36,
			";" => -19,
			"\"" => 72,
			'NEXT' => 34,
			'IF' => 22,
			'THROW' => 21,
			'TEXT' => 19,
			"(" => 18,
			'IDENT' => 29,
			'WHILE' => 31,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'rawperl' => 59,
			'META' => 26,
			'BLOCK' => 27,
			'STOP' => 28,
			'MACRO' => 25,
			'INSERT' => 24,
			'UNLESS' => 23,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			'USE' => 11,
			'perl' => 48,
			'SET' => 47,
			'DEBUG' => 49,
			'CALL' => 16,
			"\$" => 53,
			'LAST' => 55,
			'DEFAULT' => 56,
			'FILTER' => 4,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			"\${" => 40,
			'GET' => 41,
			'NOT' => 8,
			'LITERAL' => 7,
			"{" => 6,
			"[" => 46
		},
		DEFAULT => -3,
		GOTOS => {
			'view' => 13,
			'node' => 54,
			'capture' => 12,
			'javascript' => 17,
			'atomexpr' => 15,
			'block' => 14,
			'template' => 287,
			'ident' => 9,
			'macro' => 51,
			'filter' => 45,
			'statement' => 3,
			'lterm' => 39,
			'wrapper' => 38,
			'switch' => 42,
			'defblock' => 71,
			'defblockname' => 75,
			'anonblock' => 37,
			'try' => 74,
			'term' => 32,
			'assign' => 69,
			'chunk' => 70,
			'chunks' => 68,
			'loop' => 33,
			'setlist' => 67,
			'raw' => 66,
			'condition' => 65,
			'atomdir' => 60,
			'item' => 61,
			'expr' => 64,
			'directive' => 30,
			'sterm' => 58,
			'use' => 20
		}
	},
	{#State 247
		ACTIONS => {
			'END' => 288
		}
	},
	{#State 248
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 249
		ACTIONS => {
			'NUMBER' => 35,
			"\$" => 53,
			"\"" => 72,
			'REF' => 52,
			'NOT' => 8,
			'IDENT' => 29,
			"[" => 46,
			"{" => 6,
			'LITERAL' => 257,
			'COMMA' => 252,
			"\${" => 40,
			"(" => 18
		},
		DEFAULT => -163,
		GOTOS => {
			'sterm' => 58,
			'term' => 32,
			'ident' => 256,
			'lterm' => 39,
			'node' => 54,
			'item' => 253,
			'param' => 255,
			'expr' => 254
		}
	},
	{#State 250
		DEFAULT => -166
	},
	{#State 251
		ACTIONS => {
			"{" => 6,
			"\$" => 53,
			'LITERAL' => 257,
			"\"" => 72,
			")" => 289,
			"[" => 46,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29,
			"(" => 18,
			"\${" => 40,
			'COMMA' => 252,
			'REF' => 52
		},
		GOTOS => {
			'node' => 54,
			'item' => 253,
			'param' => 255,
			'expr' => 254,
			'sterm' => 58,
			'term' => 32,
			'ident' => 256,
			'lterm' => 39
		}
	},
	{#State 252
		DEFAULT => -156
	},
	{#State 253
		ACTIONS => {
			"(" => 155,
			'ASSIGN' => 188
		},
		DEFAULT => -129
	},
	{#State 254
		ACTIONS => {
			'MOD' => 162,
			"+" => 158,
			'CAT' => 163,
			'AND' => 160,
			"/" => 159,
			'BINOP' => 161,
			"?" => 167,
			'OR' => 166,
			'DIV' => 165,
			'CMPOP' => 164
		},
		DEFAULT => -153
	},
	{#State 255
		DEFAULT => -154
	},
	{#State 256
		ACTIONS => {
			'DOT' => 103,
			'ASSIGN' => 290
		},
		DEFAULT => -110
	},
	{#State 257
		ACTIONS => {
			'ASSIGN' => 186
		},
		DEFAULT => -113
	},
	{#State 258
		ACTIONS => {
			'END' => 291
		}
	},
	{#State 259
		DEFAULT => -171
	},
	{#State 260
		DEFAULT => -158
	},
	{#State 261
		ACTIONS => {
			'BINOP' => 161,
			'CAT' => 163,
			"/" => 159,
			"+" => 158,
			'MOD' => 162,
			"?" => 167,
			'OR' => 166,
			'AND' => 160,
			'CMPOP' => 164,
			'DIV' => 165
		},
		DEFAULT => -124
	},
	{#State 262
		ACTIONS => {
			'DIV' => 165,
			'CMPOP' => 164,
			'AND' => 160,
			"?" => 167,
			'OR' => 166,
			"+" => 158,
			'CAT' => 163,
			"/" => 159,
			'MOD' => 162,
			'BINOP' => 161
		},
		DEFAULT => -125
	},
	{#State 263
		ACTIONS => {
			'CALL' => 16,
			'DEFAULT' => 56,
			'LAST' => 55,
			"\$" => 53,
			'USE' => 11,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50,
			'DEBUG' => 49,
			'perl' => 48,
			'SET' => 47,
			'NOT' => 8,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'RAW' => 5,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'FILTER' => 4,
			"\${" => 40,
			'GET' => 41,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'FOR' => 36,
			'NUMBER' => 35,
			'TRY' => 73,
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'IDENT' => 29,
			'META' => 26,
			'STOP' => 28,
			'MACRO' => 25,
			'BLOCK' => 27,
			'INSERT' => 24,
			'UNLESS' => 23,
			'rawperl' => 59,
			'IF' => 22,
			'THROW' => 21,
			'TEXT' => 19,
			"(" => 18
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 42,
			'use' => 20,
			'lterm' => 39,
			'wrapper' => 38,
			'statement' => 3,
			'sterm' => 58,
			'directive' => 30,
			'expr' => 64,
			'filter' => 45,
			'atomdir' => 60,
			'item' => 61,
			'setlist' => 67,
			'loop' => 33,
			'raw' => 66,
			'macro' => 51,
			'condition' => 65,
			'chunk' => 70,
			'assign' => 69,
			'chunks' => 68,
			'ident' => 9,
			'term' => 32,
			'block' => 292,
			'try' => 74,
			'javascript' => 17,
			'defblockname' => 75,
			'anonblock' => 37,
			'atomexpr' => 15,
			'capture' => 12,
			'defblock' => 71,
			'view' => 13,
			'node' => 54
		}
	},
	{#State 264
		ACTIONS => {
			'CASE' => 293
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 294
		}
	},
	{#State 265
		ACTIONS => {
			'AND' => 160,
			"/" => 159,
			'CAT' => 163,
			"+" => 158,
			'MOD' => 162,
			"?" => 167,
			'OR' => 166,
			'BINOP' => 161,
			'DIV' => 165,
			'CMPOP' => 164
		},
		DEFAULT => -151
	},
	{#State 266
		DEFAULT => -168
	},
	{#State 267
		ACTIONS => {
			'ELSE' => 295,
			'ELSIF' => 297
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 296
		}
	},
	{#State 268
		ACTIONS => {
			'ELSIF' => 297,
			'ELSE' => 295
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 298
		}
	},
	{#State 269
		ACTIONS => {
			")" => 300,
			'IDENT' => 301,
			'COMMA' => 299
		}
	},
	{#State 270
		ACTIONS => {
			'IDENT' => -97,
			")" => -97,
			'COMMA' => -97
		},
		DEFAULT => -131
	},
	{#State 271
		ACTIONS => {
			'TEXT' => 302
		}
	},
	{#State 272
		DEFAULT => -103
	},
	{#State 273
		DEFAULT => -101
	},
	{#State 274
		ACTIONS => {
			'END' => 303
		}
	},
	{#State 275
		ACTIONS => {
			'NOT' => 8,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'RAW' => 5,
			'FILTER' => 4,
			"\${" => 40,
			'GET' => 41,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			'CALL' => 16,
			'DEFAULT' => 56,
			'LAST' => 55,
			"\$" => 53,
			'USE' => 11,
			'VIEW' => 50,
			'SWITCH' => 10,
			'REF' => 52,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'WHILE' => 31,
			'IDENT' => 29,
			'INSERT' => 24,
			'UNLESS' => 23,
			'BLOCK' => 27,
			'STOP' => 28,
			'META' => 26,
			'MACRO' => 25,
			'rawperl' => 59,
			'THROW' => 21,
			'IF' => 22,
			"(" => 18,
			'TEXT' => 19,
			'FOR' => 36,
			'NUMBER' => 35,
			'TRY' => 73,
			'NEXT' => 34,
			"\"" => 72,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 32,
			'ident' => 9,
			'assign' => 69,
			'chunk' => 70,
			'chunks' => 68,
			'setlist' => 67,
			'raw' => 66,
			'loop' => 33,
			'macro' => 51,
			'condition' => 65,
			'view' => 13,
			'node' => 54,
			'capture' => 12,
			'defblock' => 71,
			'javascript' => 17,
			'defblockname' => 75,
			'atomexpr' => 15,
			'anonblock' => 37,
			'block' => 304,
			'try' => 74,
			'statement' => 3,
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'use' => 20,
			'switch' => 42,
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30
		}
	},
	{#State 276
		DEFAULT => -157,
		GOTOS => {
			'args' => 305
		}
	},
	{#State 277
		DEFAULT => -157,
		GOTOS => {
			'args' => 306
		}
	},
	{#State 278
		ACTIONS => {
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'FOR' => 36,
			'NUMBER' => 35,
			'TRY' => 73,
			'BLOCK' => 27,
			'STOP' => 28,
			'META' => 26,
			'MACRO' => 25,
			'UNLESS' => 23,
			'INSERT' => 24,
			'rawperl' => 59,
			'WHILE' => 31,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'IDENT' => 29,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53,
			'CALL' => 16,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'USE' => 11,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			"[" => 46,
			"{" => 6,
			'LITERAL' => 7,
			'NOT' => 8,
			"\${" => 40,
			'GET' => 41,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'FILTER' => 4
		},
		DEFAULT => -3,
		GOTOS => {
			'chunks' => 68,
			'chunk' => 70,
			'assign' => 69,
			'condition' => 65,
			'loop' => 33,
			'setlist' => 67,
			'macro' => 51,
			'raw' => 66,
			'term' => 32,
			'ident' => 9,
			'atomexpr' => 15,
			'anonblock' => 37,
			'defblockname' => 75,
			'javascript' => 17,
			'try' => 74,
			'block' => 307,
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'use' => 20,
			'switch' => 42,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'expr' => 64,
			'directive' => 30,
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45
		}
	},
	{#State 279
		DEFAULT => -118
	},
	{#State 280
		ACTIONS => {
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'WHILE' => 31,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'IDENT' => 29,
			'BLOCK' => 27,
			'STOP' => 28,
			'MACRO' => 25,
			'META' => 26,
			'INSERT' => 24,
			'UNLESS' => 23,
			'rawperl' => 59,
			'IF' => 22,
			'THROW' => 21,
			'TEXT' => 19,
			"(" => 18,
			'CALL' => 16,
			'DEFAULT' => 56,
			'LAST' => 55,
			"\$" => 53,
			'USE' => 11,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'NOT' => 8,
			"[" => 46,
			"{" => 6,
			'LITERAL' => 7,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'FILTER' => 4,
			"\${" => 40,
			'GET' => 41,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'switch' => 42,
			'use' => 20,
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'atomexpr' => 15,
			'anonblock' => 37,
			'defblockname' => 75,
			'javascript' => 17,
			'try' => 74,
			'block' => 308,
			'term' => 32,
			'ident' => 9,
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'condition' => 65,
			'loop' => 33,
			'macro' => 51,
			'setlist' => 67,
			'raw' => 66
		}
	},
	{#State 281
		DEFAULT => -130
	},
	{#State 282
		ACTIONS => {
			'END' => 309
		}
	},
	{#State 283
		ACTIONS => {
			"(" => 18,
			"\${" => 40,
			'REF' => 52,
			"[" => 46,
			"\"" => 72,
			'LITERAL' => 100,
			"\$" => 53,
			"{" => 6,
			'IDENT' => 29,
			'NUMBER' => 35,
			'NOT' => 8
		},
		GOTOS => {
			'expr' => 310,
			'ident' => 99,
			'lterm' => 39,
			'node' => 54,
			'sterm' => 58,
			'item' => 61,
			'term' => 32
		}
	},
	{#State 284
		ACTIONS => {
			'END' => 311
		}
	},
	{#State 285
		ACTIONS => {
			'IDENT' => 117,
			'NUMBER' => 84,
			'FILENAME' => 81,
			";" => 313,
			'DEFAULT' => 314
		},
		GOTOS => {
			'filepart' => 79,
			'filename' => 312
		}
	},
	{#State 286
		ACTIONS => {
			";" => 315
		}
	},
	{#State 287
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 288
		DEFAULT => -80
	},
	{#State 289
		DEFAULT => -165
	},
	{#State 290
		ACTIONS => {
			'REF' => 52,
			"(" => 18,
			"\${" => 40,
			'IDENT' => 29,
			'NUMBER' => 35,
			'NOT' => 8,
			"\"" => 72,
			'LITERAL' => 100,
			"{" => 6,
			"\$" => 53,
			"[" => 46
		},
		GOTOS => {
			'expr' => 317,
			'item' => 61,
			'term' => 32,
			'sterm' => 58,
			'node' => 54,
			'lterm' => 39,
			'ident' => 99
		}
	},
	{#State 291
		DEFAULT => -81
	},
	{#State 292
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 293
		ACTIONS => {
			"\$" => 53,
			"{" => 6,
			'LITERAL' => 100,
			";" => 320,
			"\"" => 72,
			"[" => 46,
			'DEFAULT' => 321,
			'NUMBER' => 35,
			'IDENT' => 29,
			"\${" => 40,
			'REF' => 52
		},
		GOTOS => {
			'sterm' => 58,
			'node' => 54,
			'term' => 319,
			'item' => 61,
			'ident' => 99,
			'lterm' => 39
		}
	},
	{#State 294
		ACTIONS => {
			'END' => 322
		}
	},
	{#State 295
		ACTIONS => {
			";" => 323
		}
	},
	{#State 296
		ACTIONS => {
			'END' => 324
		}
	},
	{#State 297
		ACTIONS => {
			'REF' => 52,
			"\${" => 40,
			"(" => 18,
			'NUMBER' => 35,
			'NOT' => 8,
			'IDENT' => 29,
			"{" => 6,
			"\$" => 53,
			'LITERAL' => 100,
			"\"" => 72,
			"[" => 46
		},
		GOTOS => {
			'sterm' => 58,
			'node' => 54,
			'term' => 32,
			'item' => 61,
			'ident' => 99,
			'lterm' => 39,
			'expr' => 325
		}
	},
	{#State 298
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 299
		DEFAULT => -96
	},
	{#State 300
		ACTIONS => {
			'NUMBER' => 35,
			'TRY' => 73,
			'FOR' => 36,
			"\"" => 72,
			'NEXT' => 34,
			'IDENT' => 29,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'WHILE' => 31,
			'INSERT' => 24,
			'UNLESS' => 23,
			'BLOCK' => 190,
			'STOP' => 28,
			'THROW' => 21,
			'IF' => 22,
			"(" => 18,
			'CALL' => 16,
			"\$" => 53,
			'LAST' => 55,
			'DEFAULT' => 56,
			'REF' => 52,
			'SWITCH' => 10,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'NOT' => 8,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'FILTER' => 4,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			"\${" => 40,
			'GET' => 41
		},
		GOTOS => {
			'sterm' => 58,
			'wrapper' => 38,
			'lterm' => 39,
			'switch' => 42,
			'item' => 61,
			'mdir' => 327,
			'atomdir' => 60,
			'filter' => 45,
			'expr' => 210,
			'directive' => 191,
			'term' => 32,
			'ident' => 115,
			'assign' => 69,
			'condition' => 65,
			'loop' => 33,
			'setlist' => 67,
			'node' => 54,
			'atomexpr' => 15,
			'javascript' => 17,
			'try' => 74
		}
	},
	{#State 301
		DEFAULT => -95
	},
	{#State 302
		ACTIONS => {
			"\"" => 328
		}
	},
	{#State 303
		DEFAULT => -89
	},
	{#State 304
		ACTIONS => {
			'END' => 329
		}
	},
	{#State 305
		ACTIONS => {
			'IDENT' => 29,
			'NOT' => 8,
			'NUMBER' => 35,
			"[" => 46,
			"\"" => 72,
			"{" => 6,
			"\$" => 53,
			'LITERAL' => 257,
			'REF' => 52,
			'COMMA' => 252,
			"(" => 18,
			"\${" => 40
		},
		DEFAULT => -65,
		GOTOS => {
			'param' => 255,
			'item' => 253,
			'node' => 54,
			'expr' => 254,
			'lterm' => 39,
			'ident' => 256,
			'term' => 32,
			'sterm' => 58
		}
	},
	{#State 306
		ACTIONS => {
			'NOT' => 8,
			'NUMBER' => 35,
			'IDENT' => 29,
			"[" => 46,
			'LITERAL' => 257,
			"\$" => 53,
			"{" => 6,
			"\"" => 72,
			'COMMA' => 252,
			'REF' => 52,
			"(" => 18,
			"\${" => 40
		},
		DEFAULT => -64,
		GOTOS => {
			'lterm' => 39,
			'ident' => 256,
			'term' => 32,
			'sterm' => 58,
			'param' => 255,
			'item' => 253,
			'node' => 54,
			'expr' => 254
		}
	},
	{#State 307
		ACTIONS => {
			'END' => 330
		}
	},
	{#State 308
		ACTIONS => {
			'END' => 331
		}
	},
	{#State 309
		DEFAULT => -67
	},
	{#State 310
		ACTIONS => {
			'CAT' => 163,
			"/" => 159,
			"+" => 158,
			'MOD' => 162,
			'BINOP' => 161,
			'DIV' => 165,
			'CMPOP' => 164,
			'AND' => 160,
			"?" => 167,
			'OR' => 166
		},
		DEFAULT => -144
	},
	{#State 311
		DEFAULT => -69
	},
	{#State 312
		ACTIONS => {
			'DOT' => 182,
			";" => 332
		}
	},
	{#State 313
		ACTIONS => {
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'NEXT' => 34,
			"\"" => 72,
			";" => -19,
			'IF' => 22,
			'THROW' => 21,
			'TEXT' => 19,
			"(" => 18,
			'WHILE' => 31,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'IDENT' => 29,
			'BLOCK' => 27,
			'META' => 26,
			'MACRO' => 25,
			'STOP' => 28,
			'UNLESS' => 23,
			'INSERT' => 24,
			'rawperl' => 59,
			'USE' => 11,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'CALL' => 16,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'FILTER' => 4,
			"\${" => 40,
			'GET' => 41,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'NOT' => 8,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 32,
			'ident' => 9,
			'chunks' => 68,
			'chunk' => 70,
			'assign' => 69,
			'condition' => 65,
			'raw' => 66,
			'setlist' => 67,
			'loop' => 33,
			'macro' => 51,
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'anonblock' => 37,
			'atomexpr' => 15,
			'javascript' => 17,
			'defblockname' => 75,
			'try' => 74,
			'block' => 333,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'switch' => 42,
			'use' => 20,
			'atomdir' => 60,
			'item' => 61,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30
		}
	},
	{#State 314
		ACTIONS => {
			";" => 334
		}
	},
	{#State 315
		ACTIONS => {
			'perl' => 48,
			'SET' => 47,
			'DEBUG' => 49,
			'VIEW' => 50,
			'REF' => 52,
			'SWITCH' => 10,
			'USE' => 11,
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			'GET' => 41,
			"\${" => 40,
			'FILTER' => 4,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'RAW' => 5,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			";" => -19,
			"\"" => 72,
			'NEXT' => 34,
			'NUMBER' => 35,
			'TRY' => 73,
			'FOR' => 36,
			"(" => 18,
			'TEXT' => 19,
			'THROW' => 21,
			'IF' => 22,
			'rawperl' => 59,
			'INSERT' => 24,
			'UNLESS' => 23,
			'META' => 26,
			'MACRO' => 25,
			'BLOCK' => 27,
			'STOP' => 28,
			'IDENT' => 29,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'WHILE' => 31
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 74,
			'block' => 335,
			'atomexpr' => 15,
			'anonblock' => 37,
			'javascript' => 17,
			'defblockname' => 75,
			'defblock' => 71,
			'capture' => 12,
			'node' => 54,
			'view' => 13,
			'condition' => 65,
			'loop' => 33,
			'macro' => 51,
			'raw' => 66,
			'setlist' => 67,
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'ident' => 9,
			'term' => 32,
			'directive' => 30,
			'expr' => 64,
			'filter' => 45,
			'item' => 61,
			'atomdir' => 60,
			'use' => 20,
			'switch' => 42,
			'wrapper' => 38,
			'lterm' => 39,
			'sterm' => 58,
			'statement' => 3
		}
	},
	{#State 316
		DEFAULT => -83
	},
	{#State 317
		ACTIONS => {
			"?" => 167,
			'OR' => 166,
			'BINOP' => 161,
			'MOD' => 162,
			"/" => 159,
			'AND' => 160,
			'CAT' => 163,
			"+" => 158,
			'CMPOP' => 164,
			'DIV' => 165
		},
		DEFAULT => -155
	},
	{#State 318
		DEFAULT => -94
	},
	{#State 319
		ACTIONS => {
			";" => 336
		}
	},
	{#State 320
		ACTIONS => {
			'STOP' => 28,
			'BLOCK' => 27,
			'MACRO' => 25,
			'META' => 26,
			'UNLESS' => 23,
			'INSERT' => 24,
			'rawperl' => 59,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'IDENT' => 29,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21,
			'NEXT' => 34,
			"\"" => 72,
			";" => -19,
			'FOR' => 36,
			'NUMBER' => 35,
			'TRY' => 73,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'NOT' => 8,
			"\${" => 40,
			'GET' => 41,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'RAW' => 5,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'FILTER' => 4,
			'DEFAULT' => 56,
			'LAST' => 55,
			"\$" => 53,
			'CALL' => 16,
			'DEBUG' => 49,
			'SET' => 47,
			'perl' => 48,
			'USE' => 11,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'anonblock' => 37,
			'atomexpr' => 15,
			'javascript' => 17,
			'defblockname' => 75,
			'try' => 74,
			'block' => 337,
			'term' => 32,
			'ident' => 9,
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'condition' => 65,
			'loop' => 33,
			'raw' => 66,
			'macro' => 51,
			'setlist' => 67,
			'atomdir' => 60,
			'item' => 61,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'switch' => 42,
			'use' => 20
		}
	},
	{#State 321
		ACTIONS => {
			";" => 338
		}
	},
	{#State 322
		DEFAULT => -53
	},
	{#State 323
		ACTIONS => {
			'rawperl' => 59,
			'UNLESS' => 23,
			'INSERT' => 24,
			'BLOCK' => 27,
			'MACRO' => 25,
			'STOP' => 28,
			'META' => 26,
			'IDENT' => 29,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'WHILE' => 31,
			"(" => 18,
			'TEXT' => 19,
			'THROW' => 21,
			'IF' => 22,
			"\"" => 72,
			";" => -19,
			'NEXT' => 34,
			'NUMBER' => 35,
			'TRY' => 73,
			'FOR' => 36,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			"\${" => 40,
			'GET' => 41,
			'FILTER' => 4,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'RAW' => 5,
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'VIEW' => 50,
			'REF' => 52,
			'SWITCH' => 10,
			'USE' => 11
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30,
			'statement' => 3,
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'switch' => 42,
			'use' => 20,
			'view' => 13,
			'node' => 54,
			'capture' => 12,
			'defblock' => 71,
			'defblockname' => 75,
			'javascript' => 17,
			'atomexpr' => 15,
			'anonblock' => 37,
			'block' => 339,
			'try' => 74,
			'term' => 32,
			'ident' => 9,
			'assign' => 69,
			'chunk' => 70,
			'chunks' => 68,
			'loop' => 33,
			'raw' => 66,
			'macro' => 51,
			'setlist' => 67,
			'condition' => 65
		}
	},
	{#State 324
		DEFAULT => -46
	},
	{#State 325
		ACTIONS => {
			";" => 340,
			'DIV' => 165,
			"+" => 158,
			"/" => 159,
			'CAT' => 163,
			'AND' => 160,
			'MOD' => 162,
			'BINOP' => 161,
			'CMPOP' => 164,
			'OR' => 166,
			"?" => 167
		}
	},
	{#State 326
		DEFAULT => -48
	},
	{#State 327
		DEFAULT => -91
	},
	{#State 328
		DEFAULT => -102
	},
	{#State 329
		DEFAULT => -62
	},
	{#State 330
		DEFAULT => -59
	},
	{#State 331
		DEFAULT => -78
	},
	{#State 332
		ACTIONS => {
			'CALL' => 16,
			'LAST' => 55,
			'DEFAULT' => 56,
			"\$" => 53,
			'USE' => 11,
			'VIEW' => 50,
			'REF' => 52,
			'SWITCH' => 10,
			'DEBUG' => 49,
			'perl' => 48,
			'SET' => 47,
			'NOT' => 8,
			"[" => 46,
			'LITERAL' => 7,
			"{" => 6,
			'RETURN' => 44,
			'INCLUDE' => 43,
			'RAW' => 5,
			'FILTER' => 4,
			"\${" => 40,
			'GET' => 41,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			'FOR' => 36,
			'TRY' => 73,
			'NUMBER' => 35,
			'NEXT' => 34,
			";" => -19,
			"\"" => 72,
			'WRAPPER' => 63,
			'PROCESS' => 62,
			'WHILE' => 31,
			'IDENT' => 29,
			'UNLESS' => 23,
			'INSERT' => 24,
			'STOP' => 28,
			'BLOCK' => 27,
			'META' => 26,
			'MACRO' => 25,
			'rawperl' => 59,
			'THROW' => 21,
			'IF' => 22,
			"(" => 18,
			'TEXT' => 19
		},
		DEFAULT => -3,
		GOTOS => {
			'view' => 13,
			'node' => 54,
			'capture' => 12,
			'defblock' => 71,
			'javascript' => 17,
			'defblockname' => 75,
			'anonblock' => 37,
			'atomexpr' => 15,
			'block' => 341,
			'try' => 74,
			'term' => 32,
			'ident' => 9,
			'chunk' => 70,
			'assign' => 69,
			'chunks' => 68,
			'loop' => 33,
			'setlist' => 67,
			'macro' => 51,
			'raw' => 66,
			'condition' => 65,
			'atomdir' => 60,
			'item' => 61,
			'filter' => 45,
			'expr' => 64,
			'directive' => 30,
			'statement' => 3,
			'sterm' => 58,
			'lterm' => 39,
			'wrapper' => 38,
			'use' => 20,
			'switch' => 42
		}
	},
	{#State 333
		ACTIONS => {
			'FINAL' => 286,
			'CATCH' => 285
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 342
		}
	},
	{#State 334
		ACTIONS => {
			";" => -19,
			"\"" => 72,
			'NEXT' => 34,
			'TRY' => 73,
			'NUMBER' => 35,
			'FOR' => 36,
			'rawperl' => 59,
			'UNLESS' => 23,
			'INSERT' => 24,
			'META' => 26,
			'MACRO' => 25,
			'STOP' => 28,
			'BLOCK' => 27,
			'IDENT' => 29,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'WHILE' => 31,
			"(" => 18,
			'TEXT' => 19,
			'THROW' => 21,
			'IF' => 22,
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'perl' => 48,
			'SET' => 47,
			'DEBUG' => 49,
			'VIEW' => 50,
			'SWITCH' => 10,
			'REF' => 52,
			'USE' => 11,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			'JAVASCRIPT' => 1,
			'CLEAR' => 2,
			'GET' => 41,
			"\${" => 40,
			'FILTER' => 4,
			'INCLUDE' => 43,
			'RETURN' => 44,
			'RAW' => 5
		},
		DEFAULT => -3,
		GOTOS => {
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'condition' => 65,
			'raw' => 66,
			'loop' => 33,
			'macro' => 51,
			'setlist' => 67,
			'term' => 32,
			'ident' => 9,
			'anonblock' => 37,
			'atomexpr' => 15,
			'defblockname' => 75,
			'javascript' => 17,
			'try' => 74,
			'block' => 343,
			'node' => 54,
			'view' => 13,
			'defblock' => 71,
			'capture' => 12,
			'switch' => 42,
			'use' => 20,
			'sterm' => 58,
			'statement' => 3,
			'wrapper' => 38,
			'lterm' => 39,
			'expr' => 64,
			'directive' => 30,
			'item' => 61,
			'atomdir' => 60,
			'filter' => 45
		}
	},
	{#State 335
		DEFAULT => -73
	},
	{#State 336
		ACTIONS => {
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'perl' => 48,
			'SET' => 47,
			'DEBUG' => 49,
			'SWITCH' => 10,
			'REF' => 52,
			'VIEW' => 50,
			'USE' => 11,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'GET' => 41,
			"\${" => 40,
			'FILTER' => 4,
			'RAW' => 5,
			'RETURN' => 44,
			'INCLUDE' => 43,
			";" => -19,
			"\"" => 72,
			'NEXT' => 34,
			'TRY' => 73,
			'NUMBER' => 35,
			'FOR' => 36,
			'rawperl' => 59,
			'META' => 26,
			'BLOCK' => 27,
			'STOP' => 28,
			'MACRO' => 25,
			'INSERT' => 24,
			'UNLESS' => 23,
			'IDENT' => 29,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'setlist' => 67,
			'raw' => 66,
			'macro' => 51,
			'loop' => 33,
			'condition' => 65,
			'assign' => 69,
			'chunk' => 70,
			'chunks' => 68,
			'ident' => 9,
			'term' => 32,
			'block' => 344,
			'try' => 74,
			'defblockname' => 75,
			'javascript' => 17,
			'anonblock' => 37,
			'atomexpr' => 15,
			'capture' => 12,
			'defblock' => 71,
			'view' => 13,
			'node' => 54,
			'use' => 20,
			'switch' => 42,
			'lterm' => 39,
			'wrapper' => 38,
			'statement' => 3,
			'sterm' => 58,
			'directive' => 30,
			'expr' => 64,
			'filter' => 45,
			'atomdir' => 60,
			'item' => 61
		}
	},
	{#State 337
		DEFAULT => -56
	},
	{#State 338
		ACTIONS => {
			"\"" => 72,
			";" => -19,
			'NEXT' => 34,
			'NUMBER' => 35,
			'TRY' => 73,
			'FOR' => 36,
			'rawperl' => 59,
			'MACRO' => 25,
			'BLOCK' => 27,
			'META' => 26,
			'STOP' => 28,
			'INSERT' => 24,
			'UNLESS' => 23,
			'IDENT' => 29,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21,
			"\$" => 53,
			'DEFAULT' => 56,
			'LAST' => 55,
			'CALL' => 16,
			'perl' => 48,
			'SET' => 47,
			'DEBUG' => 49,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			'USE' => 11,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'GET' => 41,
			"\${" => 40,
			'FILTER' => 4,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44
		},
		DEFAULT => -3,
		GOTOS => {
			'lterm' => 39,
			'wrapper' => 38,
			'statement' => 3,
			'sterm' => 58,
			'use' => 20,
			'switch' => 42,
			'filter' => 45,
			'atomdir' => 60,
			'item' => 61,
			'directive' => 30,
			'expr' => 64,
			'ident' => 9,
			'term' => 32,
			'loop' => 33,
			'macro' => 51,
			'raw' => 66,
			'setlist' => 67,
			'condition' => 65,
			'chunk' => 70,
			'assign' => 69,
			'chunks' => 68,
			'capture' => 12,
			'defblock' => 71,
			'view' => 13,
			'node' => 54,
			'block' => 345,
			'try' => 74,
			'javascript' => 17,
			'defblockname' => 75,
			'atomexpr' => 15,
			'anonblock' => 37
		}
	},
	{#State 339
		DEFAULT => -51
	},
	{#State 340
		ACTIONS => {
			"\$" => 53,
			'LAST' => 55,
			'DEFAULT' => 56,
			'CALL' => 16,
			'SET' => 47,
			'perl' => 48,
			'DEBUG' => 49,
			'REF' => 52,
			'SWITCH' => 10,
			'VIEW' => 50,
			'USE' => 11,
			"{" => 6,
			'LITERAL' => 7,
			"[" => 46,
			'NOT' => 8,
			'CLEAR' => 2,
			'JAVASCRIPT' => 1,
			'GET' => 41,
			"\${" => 40,
			'FILTER' => 4,
			'RAW' => 5,
			'INCLUDE' => 43,
			'RETURN' => 44,
			";" => -19,
			"\"" => 72,
			'NEXT' => 34,
			'NUMBER' => 35,
			'TRY' => 73,
			'FOR' => 36,
			'rawperl' => 59,
			'MACRO' => 25,
			'STOP' => 28,
			'BLOCK' => 27,
			'META' => 26,
			'UNLESS' => 23,
			'INSERT' => 24,
			'IDENT' => 29,
			'WHILE' => 31,
			'PROCESS' => 62,
			'WRAPPER' => 63,
			'TEXT' => 19,
			"(" => 18,
			'IF' => 22,
			'THROW' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'directive' => 30,
			'expr' => 64,
			'filter' => 45,
			'atomdir' => 60,
			'item' => 61,
			'switch' => 42,
			'use' => 20,
			'wrapper' => 38,
			'lterm' => 39,
			'sterm' => 58,
			'statement' => 3,
			'try' => 74,
			'block' => 346,
			'atomexpr' => 15,
			'anonblock' => 37,
			'defblockname' => 75,
			'javascript' => 17,
			'defblock' => 71,
			'capture' => 12,
			'node' => 54,
			'view' => 13,
			'condition' => 65,
			'setlist' => 67,
			'raw' => 66,
			'macro' => 51,
			'loop' => 33,
			'chunks' => 68,
			'assign' => 69,
			'chunk' => 70,
			'ident' => 9,
			'term' => 32
		}
	},
	{#State 341
		ACTIONS => {
			'CATCH' => 285,
			'FINAL' => 286
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 347
		}
	},
	{#State 342
		DEFAULT => -72
	},
	{#State 343
		ACTIONS => {
			'FINAL' => 286,
			'CATCH' => 285
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 348
		}
	},
	{#State 344
		ACTIONS => {
			'CASE' => 293
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 349
		}
	},
	{#State 345
		DEFAULT => -55
	},
	{#State 346
		ACTIONS => {
			'ELSE' => 295,
			'ELSIF' => 297
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 350
		}
	},
	{#State 347
		DEFAULT => -70
	},
	{#State 348
		DEFAULT => -71
	},
	{#State 349
		DEFAULT => -54
	},
	{#State 350
		DEFAULT => -50
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
