package Zeta;

use 5.006;
use strict;
use warnings;

use Zeta::Util qw(:ALL);

=head1 NAME

A loose collection of modules that can simplify creation of various scripts,
applications, and web-applications.

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

Provides a very loose and basic framework for different applications. 

Perhaps a little code snippet.

    use Zeta;

    my $foo = new Zeta();
    ...

=head1 AUTHOR

Gregory S. Youngblood, C<< <zeta at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-zeta at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Zeta>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.




=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Zeta


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Zeta>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Zeta>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Zeta>

=item * Search CPAN

L<http://search.cpan.org/dist/Zeta/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 1995-2012 Gregory S. Youngblood.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.


=cut

1; # End of Zeta
