$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;
use Twilio::Twiml;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6e1650084fe73e11a80270e3c5878a0c';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
);
my $test;

###############################################
$test = 'Get Calls instance';
my $calls = $api->Calls;
is ref($calls), 'Twilio::Calls', $test;

###############################################
$test = 'Get Calls list';
my @calls = $api->Calls;
is @calls > 0, 1, $test;

###############################################
$test = 'Items in the list are Twilio::Calls::Call instances';
my $ok = 1;
for my $i (@calls) {
	$ok = 0 unless ref($i) eq 'Twilio::Calls::Call';
}
is $ok, 1, $test;

###############################################
$test = 'Get instance by sid';
my $call = $api->Calls->get($calls[0]->sid);
is ref($call), 'Twilio::Calls::Call', $test;

###############################################
$test = 'Make call';
$call = $calls->create (
	from	=> '+525541614848',
	to		=> '+5215541414570',
	url		=> Echo(Response(Pause, Say( 'This is a new test made at 18:30:15'))),
);
is $call->status, 'queued', $test;

###############################################
$test = 'Call is ringing';
$call = $calls->get($call->sid);
is $call->status, 'ringing', $test;

###############################################
$test = 'Call is answered';
while (1) {
	$call = $calls->get($call->sid);
	if ($call->status eq 'in-progress') {
		is 1, 1, $test;
		
		###############################################
		sleep 3;
		$test = 'Redirect live call';
		$call->url = Echo(Response(Say(language => 'es', voice => 'woman', content => 'Tu llamada ha sido redirigida al sistema en espaol. La hora es 18:30:15.')));
		is $call->status, 'in-progress', $test;
		
		###############################################
		sleep 3;
		$test = 'Cancel in-progress call';
		$call->status = 'completed';
		is $call->status, 'completed', $test;
		last;
	}
}

done_testing;
