$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6e1650084fe73e11a80270e3c5878a0c';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
);
my $test;

###############################################
$test = 'Get Applications instance';
my $apps = $api->Applications;
is ref($apps), 'Twilio::Applications', $test;

###############################################
$test = 'Get Applications list';
my @apps = $api->Applications;
is @apps > 0, 1, $test;

###############################################
$test = 'Items in the list are Twilio::Applications::Application instances';
my $ok = 1;
for my $i (@apps) {
	$ok = 0 unless ref($i) eq 'Twilio::Applications::Application';
}
is $ok, 1, $test;

###############################################
$test = 'Get instance by sid';
my $app = $api->Applications->get($apps[0]->sid);
is ref($app), 'Twilio::Applications::Application', $test;

###############################################
$test = 'Change friendly name of instance';
my $friendly_name = $app->friendly_name;
my $new_name = 'Test name';
$app->friendly_name = $new_name;
$app = $apps->get($app->sid);
is $app->friendly_name, $new_name, $test;

###############################################
$test = 'Change friendly name back to original';
$app->friendly_name = $friendly_name;
$app = $apps->get($app->sid);
is $app->friendly_name, $friendly_name, $test;

done_testing;
