package Twilio::Twiml;
use Twilio::Twiml::Command;
use Perlmazing;
require Exporter;
our @ISA = qw(Exporter);
our $AUTOLOAD;
my @autoloaded = qw(Defaults Echo Response Say Play Gather Record Sms Dial Number Sip Client Conference Queue Enqueue Leave Hangup Redirect Reject Pause Message);
our @EXPORT = @autoloaded;
my $generic = __PACKAGE__->new;

sub new {
	my $class = shift;
	my $self = {
		indentation		=> '	',
		defaults		=> {},
	};
	bless $self, $class;
}

sub SayCouple {
	my $self = shift;
	my $params;
	{
		no warnings;
		$params = {@_};
	}
	my $content = delete $params->{content};
	my $first_voice = delete $params->{voice};
	$first_voice = 'man' unless $first_voice eq 'woman';
	my @says;
	if (not_empty $content and not ref $content) {
		my @lines = split /\n+/, $content;
		my @voices = ($first_voice eq 'man') ? qw(man woman) : qw(woman man);
		for my $i (@lines) {
			trim $i;
			next unless not_empty $i;
			push @says, $self->Say (
				%$params,
				voice	=> $voices[0],
				content	=> $i,
			);
			push @voices, shift @voices;
		}
	}
	@says;
}

sub AUTOLOAD {
	my $autoload = $AUTOLOAD;
	my $name = substr $autoload, rindex($autoload, ':') + 1;
	my @call = caller(0);
	die "Can't locate object method \"$name\" via package \"Twilio::Twiml\" at $call[1] line $call[2]\n" unless in_array @autoloaded, $name;
	my $self = (ref($_[0]) eq __PACKAGE__) ? shift : $generic;
	$self->{defaults}->{$name} = {} unless isa_hash $self->{defaults}->{$name};
	my $p = $self->{defaults}->{$name};
	my $count = grep { ref($_) eq 'Twilio::Twiml::Command' } @_;
	if (@_ == 1) {
		$p->{content} = $_[0];
	} elsif ($count and $count == @_) {
		$p->{content} = [@_];
	} else {
		for (my $i = 0; $i < @_; $i += 2) {
			if (ref($_[$i]) eq 'Twilio::Twiml::Command') {
				die "Received a Twilio::Twiml::Command as parameter name (are you possibly missing a 'content' key or something similar?) at $call[1] line $call[2]\n";
			}
		}
		no warnings;
		$p = {%$p, @_};
	}
	my $content = delete $p->{content};
	my $command = Twilio::Twiml::Command->new (
		command	=> $name,
		params	=> $p,
		content	=> $content,
		Twiml	=> $self,
	);
	$command;
}

sub DESTROY {
	1;
}

sub Echo {
	my $self = (ref($_[0]) eq __PACKAGE__) ? shift : $generic;
	my $final = '';
	for my $i (@_) {
		$final .= $i;
	}
	escape_uri $final;
	'http://twimlets.com/echo?Twiml='.$final;
}

sub Defaults {
	my $self = (ref($_[0]) eq __PACKAGE__) ? shift : $generic;
	push (@_, undef) if @_ % 2;
	my $params = {@_};
	my @call = caller(0);
	my $defaults = {};
	for my $i (keys %$params) {
		my $name = trim ucfirst lc $i;
		die "Invalid twiml defaults key '$name' at $call[1] line $call[2]\n" unless in_array @EXPORT, $name;
		$defaults->{trim ucfirst lc $i} = $params->{$i};
	}
	$self->{defaults} = {
		%{$self->{defaults}},
		%$defaults,
	};
}

1;