#!perl
use warnings; use strict;
use Test::More tests => 1;
use Test::Exception;
use Test::Builder;

# early tests for Elive::Entity::Session - under construction

use lib '.';
use t::Elive;

use Elive;
use Elive::Entity::Session;

use Carp; $SIG{__DIE__} = \&Carp::confess;

our $t = Test::Builder->new;
our $class = 'Elive::Entity::Session' ;

our $connection;

SKIP: {

    my %result = t::Elive->test_connection();
    my $auth = $result{auth};

    my $connection_class = $result{class};
    skip ($result{reason} || 'skipping live tests', 1)
	if $connection_class->isa('t::Elive::MockConnection');

    $connection = $connection_class->connect(@$auth);
    Elive->connection($connection);

##    my $session_start = time();
##    my $session_end = $session_start + 900;
##    my $until = $session_start + 2*24*60*60;
    
    my $session_start = '1308632400';
    my $session_end   = '1308634200';
    my $until         = '1308837600';

    $session_start .= '000';
    $session_end .= '000';
    $until .= '000';

    my %insert_data = (
	name => 'tests, generated by t/soap-session-recurring.t',
	facilitatorId => Elive->login->userId,
	password => 'test', # what else?
	start =>  $session_start,
	end => $session_end,
	privateMeeting => 1,
	restrictedMeeting => 1,
	repeatEvery => 2,
	repeatSessionInterval => 1,
	repeatSessionMonthlyInterval => 1,
	repeatSessionMonthlyDay => 0,
	tuesdaySessionIndicator => 1,
	until => $until,
##	repeatSessionMonthlyInterval => 1,
##	repeatSessionMonthlyDay => 1,
##	(map {$_.'SessionIndicator' => 0} qw(sunday monday tuesday wednesday thursday friday saturday)),
    );

    my @sessions = $class->insert(\%insert_data);
    ok (@sessions, 'created sessions');
    diag "todo - recurring session tests";

    use YAML; warn YAML::Dump({sessions => \@sessions});

    $_->delete for @sessions;
}

Elive->disconnect;

