package Net::OAI::Record;

use strict;

=head1 NAME

Net::OAI::Record - An OAI-PMH record.

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=head2 new()

probably don't want to instantiate this yourself

=cut

sub new {
    my ( $class, %opts ) = @_;
    return bless {
	header	    => $opts{ header },
	@{[$opts{ metadata } ? (metadata => $opts{ metadata }) : ()]},
	@{[$opts{ recorddata } ? (recorddata => $opts{ recorddata }) : ()]},
    }, ref( $class ) || $class;
}

=head2 header()

=cut

sub header {
    my $self = shift;
    return( $self->{ header } );
}

=head2 metadata()

=cut 

sub metadata {
    my $self = shift;
#   return undef unless exists $self->{ metadata };
    return $self->{ metadata } || undef;
}

=head2 recorddata()

=cut 

sub recorddata {
    my $self = shift;
#   return undef unless exists $self->{ recorddata };
    return $self->{ recorddata } || undef;
}

=head1 TODO

=head1 SEE ALSO

=head1 AUTHORS

Ed Summers <ehs@pobox.com>

=cut


1;
