#!/usr/bin/env node

"use strict";

// If we don't have this, we're done for
const { exit } = require('process');
const fs = require('fs');
const path = require('path');

module.paths.push( '/usr/local/lib/node_modules' );

// Assume their kit is good
require('uuid');
require('playwright');
require('express');

// Get what we actually want from our deps
const { v4 : uuidv4 } = require('uuid');
const { chromium, firefox, webkit, devices } = require('playwright');
const express = require('express');

// Defines our interface
// let sharedir = require.resolve('playwright'); // api.json should be shipped with playwright itself
// var theFile = path.dirname(sharedir) + '/api.json';
// let rawdata = fs.readFileSync(theFile);

// This is automatically inserted via sed
let spec =
[{"name":"Accessibility","spec":[{"type":"text","text":"The Accessibility class provides methods for inspecting Chromium's accessibility tree. The accessibility tree is used by↵assistive technology such as [screen readers](https://en.wikipedia.org/wiki/Screen_reader) or↵[switches](https://en.wikipedia.org/wiki/Switch_access)."},{"type":"text","text":"Accessibility is a very platform-specific thing. On different platforms, there are different screen readers that might↵have wildly different output."},{"type":"text","text":"Rendering engines of Chromium, Firefox and WebKit have a concept of \"accessibility tree\", which is then translated into different↵platform-specific APIs. Accessibility namespace gives access to this Accessibility Tree."},{"type":"text","text":"Most of the accessibility tree gets filtered out when converting from internal browser AX Tree to Platform-specific AX-Tree or by↵assistive technologies themselves. By default, Playwright tries to approximate this filtering, exposing only the↵\"interesting\" nodes of the tree."}],"langs":{"only":["csharp","js","python"],"aliases":{},"types":{},"overrides":{}},"comment":"The Accessibility class provides methods for inspecting Chromium's accessibility tree. The accessibility tree is\nused by assistive technology such as [screen readers](https://en.wikipedia.org/wiki/Screen_reader) or\n[switches](https://en.wikipedia.org/wiki/Switch_access).\n\nAccessibility is a very platform-specific thing. On different platforms, there are different screen readers that\nmight have wildly different output.\n\nRendering engines of Chromium, Firefox and WebKit have a concept of \"accessibility tree\", which is then translated\ninto different platform-specific APIs. Accessibility namespace gives access to this Accessibility Tree.\n\nMost of the accessibility tree gets filtered out when converting from internal browser AX Tree to Platform-specific\nAX-Tree or by assistive technologies themselves. By default, Playwright tries to approximate this filtering,\nexposing only the \"interesting\" nodes of the tree.","since":"v1.8","members":[{"kind":"method","langs":{"types":{"java":{"name":"","union":[{"name":"null"},{"name":"string"}],"expression":"[null]|[string]"},"csharp":{"name":"","union":[{"name":"null"},{"name":"JsonElement"}],"expression":"[null]|[JsonElement]"}}},"since":"v1.8","deprecated":"This method is deprecated. Please use other libraries such as [Axe](https://www.deque.com/axe/) if you need to test page accessibility. See our Node.js [guide](https://playwright.dev/docs/accessibility-testing) for integration with Axe.","name":"snapshot","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"role","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"The [role](https://www.w3.org/TR/wai-aria/#usage)."}],"required":true,"comment":"The [role](https://www.w3.org/TR/wai-aria/#usage).","async":false,"alias":"role","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A human readable name for the node."}],"required":true,"comment":"A human readable name for the node.","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"","union":[{"name":"string"},{"name":"float"}],"expression":"[string]|[float]"},"spec":[{"type":"text","text":"The current value of the node, if applicable."}],"required":true,"comment":"The current value of the node, if applicable.","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"description","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"An additional human readable description of the node, if applicable."}],"required":true,"comment":"An additional human readable description of the node, if applicable.","async":false,"alias":"description","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"keyshortcuts","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Keyboard shortcuts associated with this node, if applicable."}],"required":true,"comment":"Keyboard shortcuts associated with this node, if applicable.","async":false,"alias":"keyshortcuts","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"roledescription","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A human readable alternative to the role, if applicable."}],"required":true,"comment":"A human readable alternative to the role, if applicable.","async":false,"alias":"roledescription","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"valuetext","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A description of the current value, if applicable."}],"required":true,"comment":"A description of the current value, if applicable.","async":false,"alias":"valuetext","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"disabled","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node is disabled, if applicable."}],"required":true,"comment":"Whether the node is disabled, if applicable.","async":false,"alias":"disabled","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"expanded","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node is expanded or collapsed, if applicable."}],"required":true,"comment":"Whether the node is expanded or collapsed, if applicable.","async":false,"alias":"expanded","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"focused","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node is focused, if applicable."}],"required":true,"comment":"Whether the node is focused, if applicable.","async":false,"alias":"focused","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"modal","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node is [modal](https://en.wikipedia.org/wiki/Modal_window), if applicable."}],"required":true,"comment":"Whether the node is [modal](https://en.wikipedia.org/wiki/Modal_window), if applicable.","async":false,"alias":"modal","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"multiline","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node text input supports multiline, if applicable."}],"required":true,"comment":"Whether the node text input supports multiline, if applicable.","async":false,"alias":"multiline","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"multiselectable","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether more than one child can be selected, if applicable."}],"required":true,"comment":"Whether more than one child can be selected, if applicable.","async":false,"alias":"multiselectable","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"readonly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node is read only, if applicable."}],"required":true,"comment":"Whether the node is read only, if applicable.","async":false,"alias":"readonly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"required","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node is required, if applicable."}],"required":true,"comment":"Whether the node is required, if applicable.","async":false,"alias":"required","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"selected","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the node is selected in its parent node, if applicable."}],"required":true,"comment":"Whether the node is selected in its parent node, if applicable.","async":false,"alias":"selected","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"checked","type":{"name":"","union":[{"name":"boolean"},{"name":"\"mixed\""}],"expression":"[boolean]|\"mixed\""},"spec":[{"type":"text","text":"Whether the checkbox is checked, or \"mixed\", if applicable."}],"required":true,"comment":"Whether the checkbox is checked, or \"mixed\", if applicable.","async":false,"alias":"checked","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"pressed","type":{"name":"","union":[{"name":"boolean"},{"name":"\"mixed\""}],"expression":"[boolean]|\"mixed\""},"spec":[{"type":"text","text":"Whether the toggle button is checked, or \"mixed\", if applicable."}],"required":true,"comment":"Whether the toggle button is checked, or \"mixed\", if applicable.","async":false,"alias":"pressed","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"level","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"The level of a heading, if applicable."}],"required":true,"comment":"The level of a heading, if applicable.","async":false,"alias":"level","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"valuemin","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"The minimum value in a node, if applicable."}],"required":true,"comment":"The minimum value in a node, if applicable.","async":false,"alias":"valuemin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"valuemax","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"The maximum value in a node, if applicable."}],"required":true,"comment":"The maximum value in a node, if applicable.","async":false,"alias":"valuemax","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"autocomplete","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"What kind of autocomplete is supported by a control, if applicable."}],"required":true,"comment":"What kind of autocomplete is supported by a control, if applicable.","async":false,"alias":"autocomplete","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"haspopup","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"What kind of popup is currently being shown for a node, if applicable."}],"required":true,"comment":"What kind of popup is currently being shown for a node, if applicable.","async":false,"alias":"haspopup","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"invalid","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Whether and in what way this node's value is invalid, if applicable."}],"required":true,"comment":"Whether and in what way this node's value is invalid, if applicable.","async":false,"alias":"invalid","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"orientation","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Whether the node is oriented horizontally or vertically, if applicable."}],"required":true,"comment":"Whether the node is oriented horizontally or vertically, if applicable.","async":false,"alias":"orientation","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"children","type":{"name":"Array","templates":[{"name":"Object"}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"Child nodes, if any, if applicable."}],"required":true,"comment":"Child nodes, if any, if applicable.","async":false,"alias":"children","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Captures the current state of the accessibility tree. The returned object represents the root accessible node of the↵page."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The Chromium accessibility tree contains nodes that go unused on most platforms and by most screen readers. Playwright↵will discard them as well for an easier to process tree, unless `interestingOnly` is set to `false`."}]},{"type":"text","text":"**Usage**"},{"type":"text","text":"An example of dumping the entire accessibility tree:"},{"type":"code","lines":["const snapshot = await page.accessibility.snapshot();","console.log(snapshot);"],"codeLang":"js"},{"type":"code","lines":["String snapshot = page.accessibility().snapshot();","System.out.println(snapshot);"],"codeLang":"java"},{"type":"code","lines":["snapshot = await page.accessibility.snapshot()","print(snapshot)"],"codeLang":"python async"},{"type":"code","lines":["snapshot = page.accessibility.snapshot()","print(snapshot)"],"codeLang":"python sync"},{"type":"code","lines":["var accessibilitySnapshot = await page.Accessibility.SnapshotAsync();","Console.WriteLine(System.Text.Json.JsonSerializer.Serialize(accessibilitySnapshot));"],"codeLang":"csharp"},{"type":"text","text":"An example of logging the focused node's name:"},{"type":"code","lines":["const snapshot = await page.accessibility.snapshot();","const node = findFocusedNode(snapshot);","console.log(node && node.name);","","function findFocusedNode(node) {","  if (node.focused)","    return node;","  for (const child of node.children || []) {","    const foundNode = findFocusedNode(child);","    if (foundNode)","      return foundNode;","  }","  return null;","}"],"codeLang":"js"},{"type":"code","lines":["var accessibilitySnapshot = await page.Accessibility.SnapshotAsync();","Console.WriteLine(System.Text.Json.JsonSerializer.Serialize(accessibilitySnapshot));"],"codeLang":"csharp"},{"type":"code","lines":["// FIXME","String snapshot = page.accessibility().snapshot();"],"codeLang":"java"},{"type":"code","lines":["def find_focused_node(node):","    if node.get(\"focused\"):","        return node","    for child in (node.get(\"children\") or []):","        found_node = find_focused_node(child)","        if found_node:","            return found_node","    return None","","snapshot = await page.accessibility.snapshot()","node = find_focused_node(snapshot)","if node:","    print(node[\"name\"])"],"codeLang":"python async"},{"type":"code","lines":["def find_focused_node(node):","    if node.get(\"focused\"):","        return node","    for child in (node.get(\"children\") or []):","        found_node = find_focused_node(child)","        if found_node:","            return found_node","    return None","","snapshot = page.accessibility.snapshot()","node = find_focused_node(snapshot)","if node:","    print(node[\"name\"])"],"codeLang":"python sync"}],"required":true,"comment":"Captures the current state of the accessibility tree. The returned object represents the root accessible node of\nthe page.\n\n**NOTE** The Chromium accessibility tree contains nodes that go unused on most platforms and by most screen\nreaders. Playwright will discard them as well for an easier to process tree, unless `interestingOnly` is set to\n`false`.\n\n**Usage**\n\nAn example of dumping the entire accessibility tree:\n\n```js\nconst snapshot = await page.accessibility.snapshot();\nconsole.log(snapshot);\n```\n\n```java\nString snapshot = page.accessibility().snapshot();\nSystem.out.println(snapshot);\n```\n\n```py\nsnapshot = await page.accessibility.snapshot()\nprint(snapshot)\n```\n\n```py\nsnapshot = page.accessibility.snapshot()\nprint(snapshot)\n```\n\n```csharp\nvar accessibilitySnapshot = await page.Accessibility.SnapshotAsync();\nConsole.WriteLine(System.Text.Json.JsonSerializer.Serialize(accessibilitySnapshot));\n```\n\nAn example of logging the focused node's name:\n\n```js\nconst snapshot = await page.accessibility.snapshot();\nconst node = findFocusedNode(snapshot);\nconsole.log(node && node.name);\n\nfunction findFocusedNode(node) {\n  if (node.focused)\n    return node;\n  for (const child of node.children || []) {\n    const foundNode = findFocusedNode(child);\n    if (foundNode)\n      return foundNode;\n  }\n  return null;\n}\n```\n\n```csharp\nvar accessibilitySnapshot = await page.Accessibility.SnapshotAsync();\nConsole.WriteLine(System.Text.Json.JsonSerializer.Serialize(accessibilitySnapshot));\n```\n\n```java\n// FIXME\nString snapshot = page.accessibility().snapshot();\n```\n\n```py\ndef find_focused_node(node):\n    if node.get(\"focused\"):\n        return node\n    for child in (node.get(\"children\") or []):\n        found_node = find_focused_node(child)\n        if found_node:\n            return found_node\n    return None\n\nsnapshot = await page.accessibility.snapshot()\nnode = find_focused_node(snapshot)\nif node:\n    print(node[\"name\"])\n```\n\n```py\ndef find_focused_node(node):\n    if node.get(\"focused\"):\n        return node\n    for child in (node.get(\"children\") or []):\n        found_node = find_focused_node(child)\n        if found_node:\n            return found_node\n    return None\n\nsnapshot = page.accessibility.snapshot()\nnode = find_focused_node(snapshot)\nif node:\n    print(node[\"name\"])\n```\n","async":true,"alias":"snapshot","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"interestingOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Prune uninteresting nodes from the tree. Defaults to `true`."}],"required":false,"comment":"Prune uninteresting nodes from the tree. Defaults to `true`.","async":false,"alias":"interestingOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"root","type":{"name":"ElementHandle","expression":"[ElementHandle]"},"spec":[{"type":"text","text":"The root DOM element for the snapshot. Defaults to the whole page."}],"required":false,"comment":"The root DOM element for the snapshot. Defaults to the whole page.","async":false,"alias":"root","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]}]},{"name":"Android","spec":[{"type":"text","text":"Playwright has **experimental** support for Android automation. This includes Chrome for Android and Android WebView."},{"type":"text","text":"*Requirements*"},{"type":"li","text":"Android device or AVD Emulator.","liType":"bullet"},{"type":"li","text":"[ADB daemon](https://developer.android.com/studio/command-line/adb) running and authenticated with your device. Typically running `adb devices` is all you need to do.","liType":"bullet"},{"type":"li","text":"[`Chrome 87`](https://play.google.com/store/apps/details?id=com.android.chrome) or newer installed on the device","liType":"bullet"},{"type":"li","text":"\"Enable command line on non-rooted devices\" enabled in `chrome://flags`.","liType":"bullet"},{"type":"text","text":"*Known limitations*"},{"type":"li","text":"Raw USB operation is not yet supported, so you need ADB.","liType":"bullet"},{"type":"li","text":"Device needs to be awake to produce screenshots. Enabling \"Stay awake\" developer mode will help.","liType":"bullet"},{"type":"li","text":"We didn't run all the tests against the device, so not everything works.","liType":"bullet"},{"type":"text","text":"*How to run*"},{"type":"text","text":"An example of the Android automation script would be:"},{"type":"code","lines":["const { _android: android } = require('playwright');","","(async () => {","  // Connect to the device.","  const [device] = await android.devices();","  console.log(`Model: ${device.model()}`);","  console.log(`Serial: ${device.serial()}`);","  // Take screenshot of the whole device.","  await device.screenshot({ path: 'device.png' });","","  {","    // --------------------- WebView -----------------------","","    // Launch an application with WebView.","    await device.shell('am force-stop org.chromium.webview_shell');","    await device.shell('am start org.chromium.webview_shell/.WebViewBrowserActivity');","    // Get the WebView.","    const webview = await device.webView({ pkg: 'org.chromium.webview_shell' });","","    // Fill the input box.","    await device.fill({","      res: 'org.chromium.webview_shell:id/url_field',","    }, 'github.com/microsoft/playwright');","    await device.press({","      res: 'org.chromium.webview_shell:id/url_field',","    }, 'Enter');","","    // Work with WebView's page as usual.","    const page = await webview.page();","    await page.waitForNavigation({ url: /.*microsoft\\/playwright.*/ });","    console.log(await page.title());","  }","","  {","    // --------------------- Browser -----------------------","","    // Launch Chrome browser.","    await device.shell('am force-stop com.android.chrome');","    const context = await device.launchBrowser();","","    // Use BrowserContext as usual.","    const page = await context.newPage();","    await page.goto('https://webkit.org/');","    console.log(await page.evaluate(() => window.location.href));","    await page.screenshot({ path: 'page.png' });","","    await context.close();","  }","","  // Close the device.","  await device.close();","})();"],"codeLang":"js"}],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"comment":"Playwright has **experimental** support for Android automation. This includes Chrome for Android and Android\nWebView.\n\n*Requirements*\n- Android device or AVD Emulator.\n- [ADB daemon](https://developer.android.com/studio/command-line/adb) running and authenticated with your device.\n  Typically running `adb devices` is all you need to do.\n- [`Chrome 87`](https://play.google.com/store/apps/details?id=com.android.chrome) or newer installed on the\n  device\n- \"Enable command line on non-rooted devices\" enabled in `chrome://flags`.\n\n*Known limitations*\n- Raw USB operation is not yet supported, so you need ADB.\n- Device needs to be awake to produce screenshots. Enabling \"Stay awake\" developer mode will help.\n- We didn't run all the tests against the device, so not everything works.\n\n*How to run*\n\nAn example of the Android automation script would be:\n\n```js\nconst { _android: android } = require('playwright');\n\n(async () => {\n  // Connect to the device.\n  const [device] = await android.devices();\n  console.log(`Model: ${device.model()}`);\n  console.log(`Serial: ${device.serial()}`);\n  // Take screenshot of the whole device.\n  await device.screenshot({ path: 'device.png' });\n\n  {\n    // --------------------- WebView -----------------------\n\n    // Launch an application with WebView.\n    await device.shell('am force-stop org.chromium.webview_shell');\n    await device.shell('am start org.chromium.webview_shell/.WebViewBrowserActivity');\n    // Get the WebView.\n    const webview = await device.webView({ pkg: 'org.chromium.webview_shell' });\n\n    // Fill the input box.\n    await device.fill({\n      res: 'org.chromium.webview_shell:id/url_field',\n    }, 'github.com/microsoft/playwright');\n    await device.press({\n      res: 'org.chromium.webview_shell:id/url_field',\n    }, 'Enter');\n\n    // Work with WebView's page as usual.\n    const page = await webview.page();\n    await page.waitForNavigation({ url: /.*microsoft\\/playwright.*/ });\n    console.log(await page.title());\n  }\n\n  {\n    // --------------------- Browser -----------------------\n\n    // Launch Chrome browser.\n    await device.shell('am force-stop com.android.chrome');\n    const context = await device.launchBrowser();\n\n    // Use BrowserContext as usual.\n    const page = await context.newPage();\n    await page.goto('https://webkit.org/');\n    console.log(await page.evaluate(() => window.location.href));\n    await page.screenshot({ path: 'page.png' });\n\n    await context.close();\n  }\n\n  // Close the device.\n  await device.close();\n})();\n```\n","since":"v1.9","members":[{"kind":"method","langs":{},"since":"v1.28","name":"connect","type":{"name":"AndroidDevice","expression":"[AndroidDevice]"},"spec":[{"type":"text","text":"This methods attaches Playwright to an existing Android device.↵Use [`method: Android.launchServer`] to launch a new Android server instance."}],"required":true,"comment":"This methods attaches Playwright to an existing Android device. Use [`method: Android.launchServer`] to launch a\nnew Android server instance.","async":true,"alias":"connect","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.28","name":"wsEndpoint","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A browser websocket endpoint to connect to."}],"required":true,"comment":"A browser websocket endpoint to connect to.","async":false,"alias":"wsEndpoint","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.28","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Additional HTTP headers to be sent with web socket connect request. Optional."}],"required":false,"comment":"Additional HTTP headers to be sent with web socket connect request. Optional.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"slowMo","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you↵can see what is going on. Defaults to `0`."}],"required":false,"comment":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you can see what is going\non. Defaults to `0`.","async":false,"alias":"slowMo","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the connection to be established. Defaults to↵`30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Maximum time in milliseconds to wait for the connection to be established. Defaults to `30000` (30 seconds). Pass\n`0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"devices","type":{"name":"Array","templates":[{"name":"AndroidDevice"}],"expression":"[Array]<[AndroidDevice]>"},"spec":[{"type":"text","text":"Returns the list of detected Android devices."}],"required":true,"comment":"Returns the list of detected Android devices.","async":true,"alias":"devices","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.22","name":"host","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional host to establish ADB server connection. Default to `127.0.0.1`."}],"required":false,"comment":"Optional host to establish ADB server connection. Default to `127.0.0.1`.","async":false,"alias":"host","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.21","name":"omitDriverInstall","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Prevents automatic playwright driver installation on attach. Assumes that the drivers have been installed already."}],"required":false,"comment":"Prevents automatic playwright driver installation on attach. Assumes that the drivers have been installed already.","async":false,"alias":"omitDriverInstall","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.20","name":"port","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Optional port to establish ADB server connection. Default to `5037`."}],"required":false,"comment":"Optional port to establish ADB server connection. Default to `5037`.","async":false,"alias":"port","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.28","name":"launchServer","type":{"name":"BrowserServer","expression":"[BrowserServer]"},"spec":[{"type":"text","text":"Launches Playwright Android server that clients can connect to. See the following example:"},{"type":"text","text":"**Usage**"},{"type":"text","text":"Server Side:"},{"type":"code","lines":["const { _android } = require('playwright');","","(async () => {","  const browserServer = await _android.launchServer({","    // If you have multiple devices connected and want to use a specific one.","    // deviceSerialNumber: '<deviceSerialNumber>',","  });","  const wsEndpoint = browserServer.wsEndpoint();","  console.log(wsEndpoint);","})();"],"codeLang":"js"},{"type":"text","text":"Client Side:"},{"type":"code","lines":["const { _android } = require('playwright');","","(async () => {","  const device = await _android.connect('<wsEndpoint>');","","  console.log(device.model());","  console.log(device.serial());","  await device.shell('am force-stop com.android.chrome');","  const context = await device.launchBrowser();","","  const page = await context.newPage();","  await page.goto('https://webkit.org/');","  console.log(await page.evaluate(() => window.location.href));","  await page.screenshot({ path: 'page-chrome-1.png' });","","  await context.close();","})();"],"codeLang":"js"}],"required":true,"comment":"Launches Playwright Android server that clients can connect to. See the following example:\n\n**Usage**\n\nServer Side:\n\n```js\nconst { _android } = require('playwright');\n\n(async () => {\n  const browserServer = await _android.launchServer({\n    // If you have multiple devices connected and want to use a specific one.\n    // deviceSerialNumber: '<deviceSerialNumber>',\n  });\n  const wsEndpoint = browserServer.wsEndpoint();\n  console.log(wsEndpoint);\n})();\n```\n\nClient Side:\n\n```js\nconst { _android } = require('playwright');\n\n(async () => {\n  const device = await _android.connect('<wsEndpoint>');\n\n  console.log(device.model());\n  console.log(device.serial());\n  await device.shell('am force-stop com.android.chrome');\n  const context = await device.launchBrowser();\n\n  const page = await context.newPage();\n  await page.goto('https://webkit.org/');\n  console.log(await page.evaluate(() => window.location.href));\n  await page.screenshot({ path: 'page-chrome-1.png' });\n\n  await context.close();\n})();\n```\n","async":true,"alias":"launchServer","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.28","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.28","name":"adbHost","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional host to establish ADB server connection. Default to `127.0.0.1`."}],"required":false,"comment":"Optional host to establish ADB server connection. Default to `127.0.0.1`.","async":false,"alias":"adbHost","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"adbPort","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Optional port to establish ADB server connection. Default to `5037`."}],"required":false,"comment":"Optional port to establish ADB server connection. Default to `5037`.","async":false,"alias":"adbPort","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"deviceSerialNumber","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional device serial number to launch the browser on. If not specified, it will↵throw if multiple devices are connected."}],"required":false,"comment":"Optional device serial number to launch the browser on. If not specified, it will throw if multiple devices are\nconnected.","async":false,"alias":"deviceSerialNumber","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.45","name":"host","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Host to use for the web socket. It is optional and if it is omitted, the server will accept connections on the unspecified IPv6 address (::) when IPv6 is available, or the unspecified IPv4 address (0.0.0.0) otherwise. Consider hardening it with picking a specific interface."}],"required":false,"comment":"Host to use for the web socket. It is optional and if it is omitted, the server will accept connections on the\nunspecified IPv6 address (::) when IPv6 is available, or the unspecified IPv4 address (0.0.0.0) otherwise. Consider\nhardening it with picking a specific interface.","async":false,"alias":"host","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"omitDriverInstall","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Prevents automatic playwright driver installation on attach. Assumes that the drivers have been installed already."}],"required":false,"comment":"Prevents automatic playwright driver installation on attach. Assumes that the drivers have been installed already.","async":false,"alias":"omitDriverInstall","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"port","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Port to use for the web socket. Defaults to 0 that picks any available port."}],"required":false,"comment":"Port to use for the web socket. Defaults to 0 that picks any available port.","async":false,"alias":"port","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","name":"wsPath","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Path at which to serve the Android Server. For security, this defaults to an↵unguessable string."},{"type":"note","noteType":"warning","children":[{"type":"text","text":"Any process or web page (including those running in Playwright) with knowledge↵of the `wsPath` can take control of the OS user. For this reason, you should↵use an unguessable token when using this option."}]}],"required":false,"comment":"Path at which to serve the Android Server. For security, this defaults to an unguessable string.\n\n**NOTE** Any process or web page (including those running in Playwright) with knowledge of the `wsPath` can take\ncontrol of the OS user. For this reason, you should use an unguessable token when using this option.\n","async":false,"alias":"wsPath","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"setDefaultTimeout","type":{"name":"void"},"spec":[{"type":"text","text":"This setting will change the default maximum time for all the methods accepting `timeout` option."}],"required":true,"comment":"This setting will change the default maximum time for all the methods accepting `timeout` option.","async":false,"alias":"setDefaultTimeout","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds"}],"required":true,"comment":"Maximum time in milliseconds","async":false,"alias":"timeout","overloadIndex":0}]}]},{"name":"AndroidDevice","spec":[{"type":"text","text":"`AndroidDevice` represents a connected device, either real hardware or emulated. Devices can be obtained using [`method: Android.devices`]."}],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"comment":"`AndroidDevice` represents a connected device, either real hardware or emulated. Devices can be obtained using\n[`method: Android.devices`].","since":"v1.9","members":[{"kind":"event","langs":{},"since":"v1.28","name":"close","type":{"name":"AndroidDevice","expression":"[AndroidDevice]"},"spec":[{"type":"text","text":"Emitted when the device connection gets closed."}],"required":true,"comment":"Emitted when the device connection gets closed.","async":false,"alias":"close","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.9","name":"webView","type":{"name":"AndroidWebView","expression":"[AndroidWebView]"},"spec":[{"type":"text","text":"Emitted when a new WebView instance is detected."}],"required":true,"comment":"Emitted when a new WebView instance is detected.","async":false,"alias":"webView","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Disconnects from the device."}],"required":true,"comment":"Disconnects from the device.","async":true,"alias":"close","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"drag","type":{"name":"void"},"spec":[{"type":"text","text":"Drags the widget defined by `selector` towards `dest` point."}],"required":true,"comment":"Drags the widget defined by `selector` towards `dest` point.","async":true,"alias":"drag","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to drag."}],"required":true,"comment":"Selector to drag.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"dest","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Point to drag to."}],"required":true,"comment":"Point to drag to.","async":false,"alias":"dest","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"speed","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Optional speed of the drag in pixels per second."}],"required":false,"comment":"Optional speed of the drag in pixels per second.","async":false,"alias":"speed","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"fill","type":{"name":"void"},"spec":[{"type":"text","text":"Fills the specific `selector` input box with `text`."}],"required":true,"comment":"Fills the specific `selector` input box with `text`.","async":true,"alias":"fill","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to fill."}],"required":true,"comment":"Selector to fill.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"text","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Text to be filled in the input box."}],"required":true,"comment":"Text to be filled in the input box.","async":false,"alias":"text","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"fling","type":{"name":"void"},"spec":[{"type":"text","text":"Flings the widget defined by `selector` in  the specified `direction`."}],"required":true,"comment":"Flings the widget defined by `selector` in  the specified `direction`.","async":true,"alias":"fling","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to fling."}],"required":true,"comment":"Selector to fling.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"direction","type":{"name":"AndroidFlingDirection","union":[{"name":"\"down\""},{"name":"\"up\""},{"name":"\"left\""},{"name":"\"right\""}],"expression":"[AndroidFlingDirection]<\"down\"|\"up\"|\"left\"|\"right\">"},"spec":[{"type":"text","text":"Fling direction."}],"required":true,"comment":"Fling direction.","async":false,"alias":"direction","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"speed","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Optional speed of the fling in pixels per second."}],"required":false,"comment":"Optional speed of the fling in pixels per second.","async":false,"alias":"speed","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"info","type":{"name":"AndroidElementInfo","expression":"[AndroidElementInfo]"},"spec":[{"type":"text","text":"Returns information about a widget defined by `selector`."}],"required":true,"comment":"Returns information about a widget defined by `selector`.","async":true,"alias":"info","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to return information about."}],"required":true,"comment":"Selector to return information about.","async":false,"alias":"selector","overloadIndex":0}]},{"kind":"property","langs":{},"since":"v1.9","name":"input","type":{"name":"AndroidInput","expression":"[AndroidInput]"},"spec":[],"required":true,"comment":"","async":false,"alias":"input","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"installApk","type":{"name":"void"},"spec":[{"type":"text","text":"Installs an apk on the device."}],"required":true,"comment":"Installs an apk on the device.","async":true,"alias":"installApk","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"file","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"}],"expression":"[string]|[Buffer]"},"spec":[{"type":"text","text":"Either a path to the apk file, or apk file content."}],"required":true,"comment":"Either a path to the apk file, or apk file content.","async":false,"alias":"file","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"args","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"Optional arguments to pass to the `shell:cmd package install` call. Defaults to `-r -t -S`."}],"required":false,"comment":"Optional arguments to pass to the `shell:cmd package install` call. Defaults to `-r -t -S`.","async":false,"alias":"args","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"launchBrowser","type":{"name":"BrowserContext","expression":"[BrowserContext]"},"spec":[{"type":"text","text":"Launches Chrome browser on the device, and returns its persistent context."}],"required":true,"comment":"Launches Chrome browser on the device, and returns its persistent context.","async":true,"alias":"launchBrowser","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"acceptDownloads","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted."}],"required":false,"comment":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted.","async":false,"alias":"acceptDownloads","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.29","name":"args","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"note","noteType":"warning","children":[{"type":"text","text":"Use custom browser args at your own risk, as some of them may break Playwright functionality."}]},{"type":"text","text":"Additional arguments to pass to the browser instance. The list of Chromium flags can be found↵[here](https://peter.sh/experiments/chromium-command-line-switches/)."}],"required":false,"comment":"**NOTE** Use custom browser args at your own risk, as some of them may break Playwright functionality.\n\nAdditional arguments to pass to the browser instance. The list of Chromium flags can be found\n[here](https://peter.sh/experiments/chromium-command-line-switches/).","async":false,"alias":"args","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"baseURL","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`], [`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by using the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the corresponding URL. Unset by default. Examples:"},{"type":"li","text":"baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in `http://localhost:3000/foo/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"}],"required":false,"comment":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`],\n[`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by\nusing the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the\ncorresponding URL. Unset by default. Examples:\n- baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`\n- baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in\n  `http://localhost:3000/foo/bar.html`\n- baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in\n  `http://localhost:3000/bar.html`","async":false,"alias":"baseURL","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"bypassCSP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`."}],"required":false,"comment":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`.","async":false,"alias":"bypassCSP","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"colorScheme","type":{"name":"","union":[{"name":"null"},{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""}]}],"expression":"null|[ColorScheme]<\"light\"|\"dark\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `null` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"colorScheme","type":{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ColorScheme]<\"light\"|\"dark\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `'null'` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"contrast","type":{"name":"","union":[{"name":"null"},{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""}]}],"expression":"null|[Contrast]<\"no-preference\"|\"more\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"contrast","type":{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""},{"name":"\"null\""}],"expression":"[Contrast]<\"no-preference\"|\"more\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"deviceScaleFactor","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about [emulating devices with device scale factor](../emulation.md#devices)."}],"required":false,"comment":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about\n[emulating devices with device scale factor](../emulation.md#devices).","async":false,"alias":"deviceScaleFactor","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"extraHTTPHeaders","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object containing additional HTTP headers to be sent with every request. Defaults to none."}],"required":false,"comment":"An object containing additional HTTP headers to be sent with every request. Defaults to none.","async":false,"alias":"extraHTTPHeaders","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"forcedColors","type":{"name":"","union":[{"name":"null"},{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""}]}],"expression":"null|[ForcedColors]<\"active\"|\"none\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"forcedColors","type":{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""},{"name":"\"null\""}],"expression":"[ForcedColors]<\"active\"|\"none\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"geolocation","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"latitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Latitude between -90 and 90."}],"required":true,"comment":"Latitude between -90 and 90.","async":false,"alias":"latitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"longitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Longitude between -180 and 180."}],"required":true,"comment":"Longitude between -180 and 180.","async":false,"alias":"longitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"accuracy","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Non-negative accuracy value. Defaults to `0`."}],"required":false,"comment":"Non-negative accuracy value. Defaults to `0`.","async":false,"alias":"accuracy","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"geolocation","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"hasTouch","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Specifies if viewport supports touch events. Defaults to false. Learn more about [mobile emulation](../emulation.md#devices)."}],"required":false,"comment":"Specifies if viewport supports touch events. Defaults to false. Learn more about\n[mobile emulation](../emulation.md#devices).","async":false,"alias":"hasTouch","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"httpCredentials","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"password","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Restrain sending http credentials on specific origin (scheme://host:port)."}],"required":false,"comment":"Restrain sending http credentials on specific origin (scheme://host:port).","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"send","type":{"name":"HttpCredentialsSend","union":[{"name":"\"unauthorized\""},{"name":"\"always\""}],"expression":"[HttpCredentialsSend]<\"unauthorized\"|\"always\">"},"spec":[{"type":"text","text":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests sent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with the each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with `WWW-Authenticate` header is received. Defaults to `'unauthorized'`."}],"required":false,"comment":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests\nsent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with\nthe each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with\n`WWW-Authenticate` header is received. Defaults to `'unauthorized'`.","async":false,"alias":"send","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication).↵If no origin is specified, the username and password are sent to any servers upon unauthorized responses."}],"required":false,"comment":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication). If no\norigin is specified, the username and password are sent to any servers upon unauthorized responses.","async":false,"alias":"httpCredentials","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"isMobile","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device, so you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more about [mobile emulation](../emulation.md#ismobile)."}],"required":false,"comment":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device,\nso you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more\nabout [mobile emulation](../emulation.md#ismobile).","async":false,"alias":"isMobile","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"javaScriptEnabled","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about [disabling JavaScript](../emulation.md#javascript-enabled)."}],"required":false,"comment":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about\n[disabling JavaScript](../emulation.md#javascript-enabled).","async":false,"alias":"javaScriptEnabled","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"locale","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value, `Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default locale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone)."}],"required":false,"comment":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value,\n`Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default\nlocale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone).","async":false,"alias":"locale","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging."}],"required":false,"comment":"Logger sink for Playwright logging.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"noViewport","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Does not enforce fixed viewport, allows resizing window in the headed mode."}],"required":false,"comment":"Does not enforce fixed viewport, allows resizing window in the headed mode.","async":false,"alias":"noViewport","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"offline","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to emulate network being offline. Defaults to `false`. Learn more about [network emulation](../emulation.md#offline)."}],"required":false,"comment":"Whether to emulate network being offline. Defaults to `false`. Learn more about\n[network emulation](../emulation.md#offline).","async":false,"alias":"offline","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"permissions","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"A list of permissions to grant to all pages in this context. See↵[`method: BrowserContext.grantPermissions`] for more details. Defaults to none."}],"required":false,"comment":"A list of permissions to grant to all pages in this context. See [`method: BrowserContext.grantPermissions`] for\nmore details. Defaults to none.","async":false,"alias":"permissions","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"pkg","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional package name to launch instead of default Chrome for Android."}],"required":false,"comment":"Optional package name to launch instead of default Chrome for Android.","async":false,"alias":"pkg","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.29","name":"proxy","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.29","name":"server","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example↵`http://myproxy.com:3128` or `socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP↵proxy."}],"required":true,"comment":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example `http://myproxy.com:3128` or\n`socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy.","async":false,"alias":"server","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.29","name":"bypass","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org,↵.domain.com\"`."}],"required":false,"comment":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`.","async":false,"alias":"bypass","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.29","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional username to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional username to use if HTTP proxy requires authentication.","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.29","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional password to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional password to use if HTTP proxy requires authentication.","async":false,"alias":"password","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Network proxy settings."}],"required":false,"comment":"Network proxy settings.","async":false,"alias":"proxy","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"recordHar","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"omitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to↵`false`. Deprecated, use `content` policy instead."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`. Deprecated, use\n`content` policy instead.","async":false,"alias":"omitContent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"content","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is specified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output files and to `embed` for all other file extensions."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is\nspecified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output\nfiles and to `embed` for all other file extensions.","async":false,"alias":"content","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by default."}],"required":true,"comment":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by\ndefault.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"mode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"mode","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"urlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was provided and the passed URL is a path, it gets merged via the [`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none."}],"required":false,"comment":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was\nprovided and the passed URL is a path, it gets merged via the\n[`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none.","async":false,"alias":"urlFilter","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file. If not↵specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be↵saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file.\nIf not specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be\nsaved.","async":false,"alias":"recordHar","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_content"},"types":{},"overrides":{}},"since":"v1.9","name":"recordHarContent","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files and all of these files are archived along with the HAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files and all of these files are archived along with the\nHAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification.","async":false,"alias":"recordHarContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_mode"},"types":{},"overrides":{}},"since":"v1.9","name":"recordHarMode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"recordHarMode","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_omit_content"},"types":{},"overrides":{}},"since":"v1.9","name":"recordHarOmitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`.","async":false,"alias":"recordHarOmitContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_path"},"types":{},"overrides":{}},"since":"v1.9","name":"recordHarPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the↵specified HAR file on the filesystem. If not specified, the HAR is not recorded. Make sure to↵call [`method: BrowserContext.close`] for the HAR to be saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the specified HAR file\non the filesystem. If not specified, the HAR is not recorded. Make sure to call [`method: BrowserContext.close`]\nfor the HAR to be saved.","async":false,"alias":"recordHarPath","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_url_filter"},"types":{},"overrides":{}},"since":"v1.9","name":"recordHarUrlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[],"required":false,"comment":"","async":false,"alias":"recordHarUrlFilter","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"recordVideo","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"dir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the directory to put videos into."}],"required":true,"comment":"Path to the directory to put videos into.","async":false,"alias":"dir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"size","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to\nfit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of\neach page will be scaled down if necessary to fit the specified size.","async":false,"alias":"size","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded. Make↵sure to await [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded.\nMake sure to await [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideo","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_dir"},"types":{},"overrides":{}},"since":"v1.9","name":"recordVideoDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables video recording for all pages into the specified directory. If not specified videos are↵not recorded. Make sure to call [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into the specified directory. If not specified videos are not recorded. Make\nsure to call [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideoDir","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_size"},"types":{},"overrides":{}},"since":"v1.9","name":"recordVideoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to fit into\n800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of each page\nwill be scaled down if necessary to fit the specified size.","async":false,"alias":"recordVideoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"reducedMotion","type":{"name":"","union":[{"name":"null"},{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""}]}],"expression":"null|[ReducedMotion]<\"reduce\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"reducedMotion","type":{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ReducedMotion]<\"reduce\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"aliases":{"java":"screenSize","csharp":"screenSize"},"types":{},"overrides":{}},"since":"v1.9","name":"screen","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the↵`viewport` is set."}],"required":false,"comment":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the\n`viewport` is set.","async":false,"alias":"screen","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"serviceWorkers","type":{"name":"ServiceWorkerPolicy","union":[{"name":"\"allow\""},{"name":"\"block\""}],"expression":"[ServiceWorkerPolicy]<\"allow\"|\"block\">"},"spec":[{"type":"text","text":"Whether to allow sites to register Service workers. Defaults to `'allow'`."},{"type":"li","text":"`'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be registered.","liType":"bullet"},{"type":"li","text":"`'block'`: Playwright will block all registration of Service Workers.","liType":"bullet"}],"required":false,"comment":"Whether to allow sites to register Service workers. Defaults to `'allow'`.\n- `'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be\n  registered.\n- `'block'`: Playwright will block all registration of Service Workers.","async":false,"alias":"serviceWorkers","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"strictSelectors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations↵on selectors that imply single target DOM element will throw when more than one element matches the selector.↵This option does not affect any Locator APIs (Locators are always strict). Defaults to `false`.↵See `Locator` to learn more about the strict mode."}],"required":false,"comment":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations on\nselectors that imply single target DOM element will throw when more than one element matches the selector. This\noption does not affect any Locator APIs (Locators are always strict). Defaults to `false`. See `Locator` to learn\nmore about the strict mode.","async":false,"alias":"strictSelectors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"timezoneId","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Changes the timezone of the context. See [ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)↵for a list of supported timezone IDs. Defaults to the system timezone."}],"required":false,"comment":"Changes the timezone of the context. See\n[ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)\nfor a list of supported timezone IDs. Defaults to the system timezone.","async":false,"alias":"timezoneId","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"userAgent","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specific user agent to use in this context."}],"required":false,"comment":"Specific user agent to use in this context.","async":false,"alias":"userAgent","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","deprecated":"Use `recordVideo` instead.","name":"videoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","deprecated":"Use `recordVideo` instead.","name":"videosPath","type":{"name":"path","expression":"[path]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videosPath","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{"java":"viewportSize"},"types":{},"overrides":{}},"since":"v1.9","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `null` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `null` value opts out from the default presets, makes viewport depend on the↵host window size defined by the operating system. It makes the execution of the↵tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `null` to disable the consistent\nviewport emulation. Learn more about [viewport emulation](../emulation#viewport).\n\n**NOTE** The `null` value opts out from the default presets, makes viewport depend on the host window size defined\nby the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{"csharp":"viewportSize"},"types":{},"overrides":{}},"since":"v1.9","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `ViewportSize.NoViewport` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `ViewportSize.NoViewport` value opts out from the default presets,↵makes viewport depend on the host window size defined by the operating system.↵It makes the execution of the tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `ViewportSize.NoViewport` to\ndisable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport).\n\n**NOTE** The `ViewportSize.NoViewport` value opts out from the default presets, makes viewport depend on the host\nwindow size defined by the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed viewport. Learn more about [viewport emulation](../emulation.md#viewport)."}],"required":false,"comment":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed\nviewport. Learn more about [viewport emulation](../emulation.md#viewport).","async":false,"alias":"viewport","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"longTap","type":{"name":"void"},"spec":[{"type":"text","text":"Performs a long tap on the widget defined by `selector`."}],"required":true,"comment":"Performs a long tap on the widget defined by `selector`.","async":true,"alias":"longTap","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to tap on."}],"required":true,"comment":"Selector to tap on.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"model","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Device model."}],"required":true,"comment":"Device model.","async":false,"alias":"model","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"open","type":{"name":"AndroidSocket","expression":"[AndroidSocket]"},"spec":[{"type":"text","text":"Launches a process in the shell on the device and returns a socket to communicate with the launched process."}],"required":true,"comment":"Launches a process in the shell on the device and returns a socket to communicate with the launched process.","async":true,"alias":"open","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"command","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Shell command to execute."}],"required":true,"comment":"Shell command to execute.","async":false,"alias":"command","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"pinchClose","type":{"name":"void"},"spec":[{"type":"text","text":"Pinches the widget defined by `selector` in the closing direction."}],"required":true,"comment":"Pinches the widget defined by `selector` in the closing direction.","async":true,"alias":"pinchClose","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to pinch close."}],"required":true,"comment":"Selector to pinch close.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"percent","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"The size of the pinch as a percentage of the widget's size."}],"required":true,"comment":"The size of the pinch as a percentage of the widget's size.","async":false,"alias":"percent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"speed","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Optional speed of the pinch in pixels per second."}],"required":false,"comment":"Optional speed of the pinch in pixels per second.","async":false,"alias":"speed","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"pinchOpen","type":{"name":"void"},"spec":[{"type":"text","text":"Pinches the widget defined by `selector` in the open direction."}],"required":true,"comment":"Pinches the widget defined by `selector` in the open direction.","async":true,"alias":"pinchOpen","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to pinch open."}],"required":true,"comment":"Selector to pinch open.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"percent","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"The size of the pinch as a percentage of the widget's size."}],"required":true,"comment":"The size of the pinch as a percentage of the widget's size.","async":false,"alias":"percent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"speed","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Optional speed of the pinch in pixels per second."}],"required":false,"comment":"Optional speed of the pinch in pixels per second.","async":false,"alias":"speed","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"press","type":{"name":"void"},"spec":[{"type":"text","text":"Presses the specific `key` in the widget defined by `selector`."}],"required":true,"comment":"Presses the specific `key` in the widget defined by `selector`.","async":true,"alias":"press","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to press the key in."}],"required":true,"comment":"Selector to press the key in.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"key","type":{"name":"AndroidKey","expression":"[AndroidKey]"},"spec":[{"type":"text","text":"The key to press."}],"required":true,"comment":"The key to press.","async":false,"alias":"key","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"push","type":{"name":"void"},"spec":[{"type":"text","text":"Copies a file to the device."}],"required":true,"comment":"Copies a file to the device.","async":true,"alias":"push","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"file","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"}],"expression":"[string]|[Buffer]"},"spec":[{"type":"text","text":"Either a path to the file, or file content."}],"required":true,"comment":"Either a path to the file, or file content.","async":false,"alias":"file","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Path to the file on the device."}],"required":true,"comment":"Path to the file on the device.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"mode","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Optional file mode, defaults to `644` (`rw-r--r--`)."}],"required":false,"comment":"Optional file mode, defaults to `644` (`rw-r--r--`).","async":false,"alias":"mode","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"screenshot","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Returns the buffer with the captured screenshot of the device."}],"required":true,"comment":"Returns the buffer with the captured screenshot of the device.","async":true,"alias":"screenshot","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"The file path to save the image to. If `path` is a↵relative path, then it is resolved relative to the current working directory. If no path is provided, the image won't be↵saved to the disk."}],"required":false,"comment":"The file path to save the image to. If `path` is a relative path, then it is resolved relative to the current\nworking directory. If no path is provided, the image won't be saved to the disk.","async":false,"alias":"path","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"scroll","type":{"name":"void"},"spec":[{"type":"text","text":"Scrolls the widget defined by `selector` in  the specified `direction`."}],"required":true,"comment":"Scrolls the widget defined by `selector` in  the specified `direction`.","async":true,"alias":"scroll","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to scroll."}],"required":true,"comment":"Selector to scroll.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"direction","type":{"name":"AndroidScrollDirection","union":[{"name":"\"down\""},{"name":"\"up\""},{"name":"\"left\""},{"name":"\"right\""}],"expression":"[AndroidScrollDirection]<\"down\"|\"up\"|\"left\"|\"right\">"},"spec":[{"type":"text","text":"Scroll direction."}],"required":true,"comment":"Scroll direction.","async":false,"alias":"direction","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"percent","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Distance to scroll as a percentage of the widget's size."}],"required":true,"comment":"Distance to scroll as a percentage of the widget's size.","async":false,"alias":"percent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"speed","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Optional speed of the scroll in pixels per second."}],"required":false,"comment":"Optional speed of the scroll in pixels per second.","async":false,"alias":"speed","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"serial","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Device serial number."}],"required":true,"comment":"Device serial number.","async":false,"alias":"serial","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"setDefaultTimeout","type":{"name":"void"},"spec":[{"type":"text","text":"This setting will change the default maximum time for all the methods accepting `timeout` option."}],"required":true,"comment":"This setting will change the default maximum time for all the methods accepting `timeout` option.","async":false,"alias":"setDefaultTimeout","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds"}],"required":true,"comment":"Maximum time in milliseconds","async":false,"alias":"timeout","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"shell","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Executes a shell command on the device and returns its output."}],"required":true,"comment":"Executes a shell command on the device and returns its output.","async":true,"alias":"shell","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"command","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Shell command to execute."}],"required":true,"comment":"Shell command to execute.","async":false,"alias":"command","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"swipe","type":{"name":"void"},"spec":[{"type":"text","text":"Swipes the widget defined by `selector` in  the specified `direction`."}],"required":true,"comment":"Swipes the widget defined by `selector` in  the specified `direction`.","async":true,"alias":"swipe","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to swipe."}],"required":true,"comment":"Selector to swipe.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"direction","type":{"name":"AndroidSwipeDirection","union":[{"name":"\"down\""},{"name":"\"up\""},{"name":"\"left\""},{"name":"\"right\""}],"expression":"[AndroidSwipeDirection]<\"down\"|\"up\"|\"left\"|\"right\">"},"spec":[{"type":"text","text":"Swipe direction."}],"required":true,"comment":"Swipe direction.","async":false,"alias":"direction","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"percent","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Distance to swipe as a percentage of the widget's size."}],"required":true,"comment":"Distance to swipe as a percentage of the widget's size.","async":false,"alias":"percent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"speed","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Optional speed of the swipe in pixels per second."}],"required":false,"comment":"Optional speed of the swipe in pixels per second.","async":false,"alias":"speed","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"tap","type":{"name":"void"},"spec":[{"type":"text","text":"Taps on the widget defined by `selector`."}],"required":true,"comment":"Taps on the widget defined by `selector`.","async":true,"alias":"tap","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to tap on."}],"required":true,"comment":"Selector to tap on.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"duration","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Optional duration of the tap in milliseconds."}],"required":false,"comment":"Optional duration of the tap in milliseconds.","async":false,"alias":"duration","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"wait","type":{"name":"void"},"spec":[{"type":"text","text":"Waits for the specific `selector` to either appear or disappear, depending on the `state`."}],"required":true,"comment":"Waits for the specific `selector` to either appear or disappear, depending on the `state`.","async":true,"alias":"wait","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"AndroidSelector","expression":"[AndroidSelector]"},"spec":[{"type":"text","text":"Selector to wait for."}],"required":true,"comment":"Selector to wait for.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"state","type":{"name":"AndroidDeviceState","union":[{"name":"\"gone\""}],"expression":"[AndroidDeviceState]<\"gone\">"},"spec":[{"type":"text","text":"Optional state. Can be either:"},{"type":"li","text":"default - wait for element to be present.","liType":"bullet"},{"type":"li","text":"`'gone'` - wait for element to not be present.","liType":"bullet"}],"required":false,"comment":"Optional state. Can be either:\n- default - wait for element to be present.\n- `'gone'` - wait for element to not be present.","async":false,"alias":"state","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"waitForEvent","type":{"name":"any","expression":"[any]"},"spec":[{"type":"text","text":"Waits for event to fire and passes its value into the predicate function. Returns when the predicate returns truthy value."}],"required":true,"comment":"Waits for event to fire and passes its value into the predicate function. Returns when the predicate returns truthy\nvalue.","async":true,"alias":"waitForEvent","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["js","python","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"event","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Event name, same one typically passed into `*.on(event)`."}],"required":true,"comment":"Event name, same one typically passed into `*.on(event)`.","async":false,"alias":"event","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"optionsOrPredicate","type":{"name":"","union":[{"name":"function"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"predicate","type":{"name":"function","expression":"[function]"},"spec":[{"type":"text","text":"receives the event data and resolves to truthy value when the waiting should resolve."}],"required":true,"comment":"receives the event data and resolves to truthy value when the waiting should resolve.","async":false,"alias":"predicate","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to↵disable timeout. The default value can be changed by using the [`method: AndroidDevice.setDefaultTimeout`]."}],"required":false,"comment":"maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: AndroidDevice.setDefaultTimeout`].","async":false,"alias":"timeout","overloadIndex":0}]}],"expression":"[function]|[Object]"},"spec":[{"type":"text","text":"Either a predicate that receives an event or an options object. Optional."}],"required":false,"comment":"Either a predicate that receives an event or an options object. Optional.","async":false,"alias":"optionsOrPredicate","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"webView","type":{"name":"AndroidWebView","expression":"[AndroidWebView]"},"spec":[{"type":"text","text":"This method waits until `AndroidWebView` matching the `selector` is opened and returns it. If there is already an open `AndroidWebView` matching the `selector`, returns immediately."}],"required":true,"comment":"This method waits until `AndroidWebView` matching the `selector` is opened and returns it. If there is already an\nopen `AndroidWebView` matching the `selector`, returns immediately.","async":true,"alias":"webView","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"pkg","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional Package identifier."}],"required":false,"comment":"Optional Package identifier.","async":false,"alias":"pkg","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"socketName","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional webview socket name."}],"required":false,"comment":"Optional webview socket name.","async":false,"alias":"socketName","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":true,"comment":"","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed by↵using the [`method: AndroidDevice.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time in milliseconds, defaults to 30 seconds, pass `0` to disable timeout. The default value can be changed\nby using the [`method: AndroidDevice.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"webViews","type":{"name":"Array","templates":[{"name":"AndroidWebView"}],"expression":"[Array]<[AndroidWebView]>"},"spec":[{"type":"text","text":"Currently open WebViews."}],"required":true,"comment":"Currently open WebViews.","async":false,"alias":"webViews","overloadIndex":0,"args":[]}]},{"name":"AndroidInput","spec":[],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","members":[{"kind":"method","langs":{},"since":"v1.9","name":"drag","type":{"name":"void"},"spec":[{"type":"text","text":"Performs a drag between `from` and `to` points."}],"required":true,"comment":"Performs a drag between `from` and `to` points.","async":true,"alias":"drag","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"from","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"The start point of the drag."}],"required":true,"comment":"The start point of the drag.","async":false,"alias":"from","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"to","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"The end point of the drag."}],"required":true,"comment":"The end point of the drag.","async":false,"alias":"to","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"steps","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"The number of steps in the drag. Each step takes 5 milliseconds to complete."}],"required":true,"comment":"The number of steps in the drag. Each step takes 5 milliseconds to complete.","async":false,"alias":"steps","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"press","type":{"name":"void"},"spec":[{"type":"text","text":"Presses the `key`."}],"required":true,"comment":"Presses the `key`.","async":true,"alias":"press","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"key","type":{"name":"AndroidKey","expression":"[AndroidKey]"},"spec":[{"type":"text","text":"Key to press."}],"required":true,"comment":"Key to press.","async":false,"alias":"key","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"swipe","type":{"name":"void"},"spec":[{"type":"text","text":"Swipes following the path defined by `segments`."}],"required":true,"comment":"Swipes following the path defined by `segments`.","async":true,"alias":"swipe","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"from","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"The point to start swiping from."}],"required":true,"comment":"The point to start swiping from.","async":false,"alias":"from","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"segments","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"Points following the `from` point in the swipe gesture."}],"required":true,"comment":"Points following the `from` point in the swipe gesture.","async":false,"alias":"segments","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"steps","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"The number of steps for each segment. Each step takes 5 milliseconds to complete, so 100 steps means half a second per each segment."}],"required":true,"comment":"The number of steps for each segment. Each step takes 5 milliseconds to complete, so 100 steps means half a second\nper each segment.","async":false,"alias":"steps","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"tap","type":{"name":"void"},"spec":[{"type":"text","text":"Taps at the specified `point`."}],"required":true,"comment":"Taps at the specified `point`.","async":true,"alias":"tap","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"point","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"The point to tap at."}],"required":true,"comment":"The point to tap at.","async":false,"alias":"point","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"type","type":{"name":"void"},"spec":[{"type":"text","text":"Types `text` into currently focused widget."}],"required":true,"comment":"Types `text` into currently focused widget.","async":true,"alias":"type","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"text","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Text to type."}],"required":true,"comment":"Text to type.","async":false,"alias":"text","overloadIndex":0}]}]},{"name":"AndroidSocket","spec":[{"type":"text","text":"`AndroidSocket` is a way to communicate with a process launched on the `AndroidDevice`. Use [`method: AndroidDevice.open`] to open a socket."}],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"comment":"`AndroidSocket` is a way to communicate with a process launched on the `AndroidDevice`. Use\n[`method: AndroidDevice.open`] to open a socket.","since":"v1.9","members":[{"kind":"event","langs":{},"since":"v1.9","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Emitted when the socket is closed."}],"required":true,"comment":"Emitted when the socket is closed.","async":false,"alias":"close","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.9","name":"data","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Emitted when data is available to read from the socket."}],"required":true,"comment":"Emitted when data is available to read from the socket.","async":false,"alias":"data","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Closes the socket."}],"required":true,"comment":"Closes the socket.","async":true,"alias":"close","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"write","type":{"name":"void"},"spec":[{"type":"text","text":"Writes some `data` to the socket."}],"required":true,"comment":"Writes some `data` to the socket.","async":true,"alias":"write","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"data","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Data to write."}],"required":true,"comment":"Data to write.","async":false,"alias":"data","overloadIndex":0}]}]},{"name":"AndroidWebView","spec":[{"type":"text","text":"`AndroidWebView` represents a WebView open on the `AndroidDevice`. WebView is usually obtained using [`method: AndroidDevice.webView`]."}],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"comment":"`AndroidWebView` represents a WebView open on the `AndroidDevice`. WebView is usually obtained using\n[`method: AndroidDevice.webView`].","since":"v1.9","members":[{"kind":"event","langs":{},"since":"v1.9","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Emitted when the WebView is closed."}],"required":true,"comment":"Emitted when the WebView is closed.","async":false,"alias":"close","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"page","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Connects to the WebView and returns a regular Playwright `Page` to interact with."}],"required":true,"comment":"Connects to the WebView and returns a regular Playwright `Page` to interact with.","async":true,"alias":"page","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"pid","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"WebView process PID."}],"required":true,"comment":"WebView process PID.","async":false,"alias":"pid","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"pkg","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"WebView package identifier."}],"required":true,"comment":"WebView package identifier.","async":false,"alias":"pkg","overloadIndex":0,"args":[]}]},{"name":"APIRequest","spec":[{"type":"text","text":"Exposes API that can be used for the Web API testing. This class is used for creating↵`APIRequestContext` instance which in turn can be used for sending web requests. An instance↵of this class can be obtained via [`property: Playwright.request`]. For more information↵see `APIRequestContext`."}],"langs":{},"comment":"Exposes API that can be used for the Web API testing. This class is used for creating `APIRequestContext` instance\nwhich in turn can be used for sending web requests. An instance of this class can be obtained via\n[`property: Playwright.request`]. For more information see `APIRequestContext`.","since":"v1.16","members":[{"kind":"method","langs":{},"since":"v1.16","name":"newContext","type":{"name":"APIRequestContext","expression":"[APIRequestContext]"},"spec":[{"type":"text","text":"Creates new instances of `APIRequestContext`."}],"required":true,"comment":"Creates new instances of `APIRequestContext`.","async":true,"alias":"newContext","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"baseURL","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Methods like [`method: APIRequestContext.get`] take the base URL into consideration by using the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the corresponding URL. Examples:"},{"type":"li","text":"baseURL: `http://localhost:3000` and sending request to `/bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo/` and sending request to `./bar.html` results in `http://localhost:3000/foo/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"}],"required":false,"comment":"Methods like [`method: APIRequestContext.get`] take the base URL into consideration by using the\n[`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the corresponding URL.\nExamples:\n- baseURL: `http://localhost:3000` and sending request to `/bar.html` results in `http://localhost:3000/bar.html`\n- baseURL: `http://localhost:3000/foo/` and sending request to `./bar.html` results in\n  `http://localhost:3000/foo/bar.html`\n- baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in\n  `http://localhost:3000/bar.html`","async":false,"alias":"baseURL","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"clientCertificates","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"1.46","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port."}],"required":true,"comment":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port.","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"certPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the certificate in PEM format."}],"required":false,"comment":"Path to the file with the certificate in PEM format.","async":false,"alias":"certPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"cert","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the certificate in PEM format."}],"required":false,"comment":"Direct value of the certificate in PEM format.","async":false,"alias":"cert","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"keyPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the private key in PEM format."}],"required":false,"comment":"Path to the file with the private key in PEM format.","async":false,"alias":"keyPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"key","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the private key in PEM format."}],"required":false,"comment":"Direct value of the private key in PEM format.","async":false,"alias":"key","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfxPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Path to the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfxPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfx","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Direct value of the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfx","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"passphrase","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Passphrase for the private key (PEM or PFX)."}],"required":false,"comment":"Passphrase for the private key (PEM or PFX).","async":false,"alias":"passphrase","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"TLS Client Authentication allows the server to request a client certificate and verify it."},{"type":"text","text":"**Details**"},{"type":"text","text":"An array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`, a single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally, `passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided with an exact match to the request origin that the certificate is valid for."},{"type":"note","noteType":"note","children":[{"type":"text","text":"When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it work by replacing `localhost` with `local.playwright`."}]}],"required":false,"comment":"TLS Client Authentication allows the server to request a client certificate and verify it.\n\n**Details**\n\nAn array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`,\na single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally,\n`passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided\nwith an exact match to the request origin that the certificate is valid for.\n\n**NOTE** When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it\nwork by replacing `localhost` with `local.playwright`.\n","async":false,"alias":"clientCertificates","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"extraHTTPHeaders","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object containing additional HTTP headers to be sent with every request. Defaults to none."}],"required":false,"comment":"An object containing additional HTTP headers to be sent with every request. Defaults to none.","async":false,"alias":"extraHTTPHeaders","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.51","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"httpCredentials","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"password","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Restrain sending http credentials on specific origin (scheme://host:port)."}],"required":false,"comment":"Restrain sending http credentials on specific origin (scheme://host:port).","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"send","type":{"name":"HttpCredentialsSend","union":[{"name":"\"unauthorized\""},{"name":"\"always\""}],"expression":"[HttpCredentialsSend]<\"unauthorized\"|\"always\">"},"spec":[{"type":"text","text":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests sent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with the each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with `WWW-Authenticate` header is received. Defaults to `'unauthorized'`."}],"required":false,"comment":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests\nsent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with\nthe each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with\n`WWW-Authenticate` header is received. Defaults to `'unauthorized'`.","async":false,"alias":"send","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication).↵If no origin is specified, the username and password are sent to any servers upon unauthorized responses."}],"required":false,"comment":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication). If no\norigin is specified, the username and password are sent to any servers upon unauthorized responses.","async":false,"alias":"httpCredentials","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.52","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects. This can be overwritten for each request individually."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects. This can be overwritten for each request\nindividually.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"proxy","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"server","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example↵`http://myproxy.com:3128` or `socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP↵proxy."}],"required":true,"comment":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example `http://myproxy.com:3128` or\n`socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy.","async":false,"alias":"server","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"bypass","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org,↵.domain.com\"`."}],"required":false,"comment":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`.","async":false,"alias":"bypass","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional username to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional username to use if HTTP proxy requires authentication.","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional password to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional password to use if HTTP proxy requires authentication.","async":false,"alias":"password","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Network proxy settings."}],"required":false,"comment":"Network proxy settings.","async":false,"alias":"proxy","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"storageState","type":{"name":"","union":[{"name":"path"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"cookies","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"domain","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"expires","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Unix time in seconds."}],"required":true,"comment":"Unix time in seconds.","async":false,"alias":"expires","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"httpOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"httpOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"secure","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"secure","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"sameSite","type":{"name":"SameSiteAttribute","union":[{"name":"\"Strict\""},{"name":"\"Lax\""},{"name":"\"None\""}],"expression":"[SameSiteAttribute]<\"Strict\"|\"Lax\"|\"None\">"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"sameSite","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"cookies","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"origins","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"localStorage","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"localStorage","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origins","overloadIndex":0}]}],"expression":"[path]|[Object]"},"spec":[{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information↵obtained via [`method: BrowserContext.storageState`] or [`method: APIRequestContext.storageState`]. Either a path to the↵file with saved storage, or the value returned by one of [`method: BrowserContext.storageState`] or↵[`method: APIRequestContext.storageState`] methods."}],"required":false,"comment":"Populates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`] or [`method: APIRequestContext.storageState`].\nEither a path to the file with saved storage, or the value returned by one of\n[`method: BrowserContext.storageState`] or [`method: APIRequestContext.storageState`] methods.","async":false,"alias":"storageState","overloadIndex":0},{"kind":"property","langs":{"only":["java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"storageState","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information↵obtained via [`method: BrowserContext.storageState`] or [`method: APIRequestContext.storageState`]. Either a path to the↵file with saved storage, or the value returned by one of [`method: BrowserContext.storageState`] or↵[`method: APIRequestContext.storageState`] methods."}],"required":false,"comment":"Populates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`] or [`method: APIRequestContext.storageState`].\nEither a path to the file with saved storage, or the value returned by one of\n[`method: BrowserContext.storageState`] or [`method: APIRequestContext.storageState`] methods.","async":false,"alias":"storageState","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"storageStatePath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information↵obtained via [`method: BrowserContext.storageState`]. Path to the file with saved storage state."}],"required":false,"comment":"Populates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`]. Path to the file with saved storage state.","async":false,"alias":"storageStatePath","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the response. Defaults to↵`30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Maximum time in milliseconds to wait for the response. Defaults to `30000` (30 seconds). Pass `0` to disable\ntimeout.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"userAgent","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specific user agent to use in this context."}],"required":false,"comment":"Specific user agent to use in this context.","async":false,"alias":"userAgent","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]}]},{"name":"APIRequestContext","spec":[{"type":"text","text":"This API is used for the Web API testing. You can use it to trigger API endpoints, configure micro-services, prepare↵environment or the service to your e2e test."},{"type":"text","text":"Each Playwright browser context has associated with it `APIRequestContext` instance which shares cookie storage with↵the browser context and can be accessed via [`property: BrowserContext.request`] or [`property: Page.request`].↵It is also possible to create a new APIRequestContext instance manually by calling [`method: APIRequest.newContext`]."},{"type":"text","text":"**Cookie management**"},{"type":"text","text":"`APIRequestContext` returned by [`property: BrowserContext.request`] and [`property: Page.request`] shares cookie↵storage with the corresponding `BrowserContext`. Each API request will have `Cookie` header populated with the↵values from the browser context. If the API response contains `Set-Cookie` header it will automatically update↵`BrowserContext` cookies and requests made from the page will pick them up. This means that if you log in using↵this API, your e2e test will be logged in and vice versa."},{"type":"text","text":"If you want API requests to not interfere with the browser cookies you should create a new `APIRequestContext` by↵calling [`method: APIRequest.newContext`]. Such `APIRequestContext` object will have its own isolated cookie↵storage."},{"type":"code","lines":["import os","import asyncio","from playwright.async_api import async_playwright, Playwright","","REPO = \"test-repo-1\"","USER = \"github-username\"","API_TOKEN = os.getenv(\"GITHUB_API_TOKEN\")","","async def run(playwright: Playwright):","    # This will launch a new browser, create a context and page. When making HTTP","    # requests with the internal APIRequestContext (e.g. `context.request` or `page.request`)","    # it will automatically set the cookies to the browser page and vice versa.","    browser = await playwright.chromium.launch()","    context = await browser.new_context(base_url=\"https://api.github.com\")","    api_request_context = context.request","    page = await context.new_page()","","    # Alternatively you can create a APIRequestContext manually without having a browser context attached:","    # api_request_context = await playwright.request.new_context(base_url=\"https://api.github.com\")","","    # Create a repository.","    response = await api_request_context.post(","        \"/user/repos\",","        headers={","            \"Accept\": \"application/vnd.github.v3+json\",","            # Add GitHub personal access token.","            \"Authorization\": f\"token {API_TOKEN}\",","        },","        data={\"name\": REPO},","    )","    assert response.ok","    assert response.json()[\"name\"] == REPO","","    # Delete a repository.","    response = await api_request_context.delete(","        f\"/repos/{USER}/{REPO}\",","        headers={","            \"Accept\": \"application/vnd.github.v3+json\",","            # Add GitHub personal access token.","            \"Authorization\": f\"token {API_TOKEN}\",","        },","    )","    assert response.ok","    assert await response.body() == '{\"status\": \"ok\"}'","","async def main():","    async with async_playwright() as playwright:","        await run(playwright)","","asyncio.run(main())"],"codeLang":"python async"},{"type":"code","lines":["import os","from playwright.sync_api import sync_playwright","","REPO = \"test-repo-1\"","USER = \"github-username\"","API_TOKEN = os.getenv(\"GITHUB_API_TOKEN\")","","with sync_playwright() as p:","    # This will launch a new browser, create a context and page. When making HTTP","    # requests with the internal APIRequestContext (e.g. `context.request` or `page.request`)","    # it will automatically set the cookies to the browser page and vice versa.","    browser = p.chromium.launch()","    context = browser.new_context(base_url=\"https://api.github.com\")","    api_request_context = context.request","    page = context.new_page()","","    # Alternatively you can create a APIRequestContext manually without having a browser context attached:","    # api_request_context = p.request.new_context(base_url=\"https://api.github.com\")","","","    # Create a repository.","    response = api_request_context.post(","        \"/user/repos\",","        headers={","            \"Accept\": \"application/vnd.github.v3+json\",","            # Add GitHub personal access token.","            \"Authorization\": f\"token {API_TOKEN}\",","        },","        data={\"name\": REPO},","    )","    assert response.ok","    assert response.json()[\"name\"] == REPO","","    # Delete a repository.","    response = api_request_context.delete(","        f\"/repos/{USER}/{REPO}\",","        headers={","            \"Accept\": \"application/vnd.github.v3+json\",","            # Add GitHub personal access token.","            \"Authorization\": f\"token {API_TOKEN}\",","        },","    )","    assert response.ok","    assert await response.body() == '{\"status\": \"ok\"}'"],"codeLang":"python sync"}],"langs":{},"comment":"This API is used for the Web API testing. You can use it to trigger API endpoints, configure micro-services,\nprepare environment or the service to your e2e test.\n\nEach Playwright browser context has associated with it `APIRequestContext` instance which shares cookie storage\nwith the browser context and can be accessed via [`property: BrowserContext.request`] or\n[`property: Page.request`]. It is also possible to create a new APIRequestContext instance manually by calling\n[`method: APIRequest.newContext`].\n\n**Cookie management**\n\n`APIRequestContext` returned by [`property: BrowserContext.request`] and [`property: Page.request`] shares cookie\nstorage with the corresponding `BrowserContext`. Each API request will have `Cookie` header populated with the\nvalues from the browser context. If the API response contains `Set-Cookie` header it will automatically update\n`BrowserContext` cookies and requests made from the page will pick them up. This means that if you log in using\nthis API, your e2e test will be logged in and vice versa.\n\nIf you want API requests to not interfere with the browser cookies you should create a new `APIRequestContext` by\ncalling [`method: APIRequest.newContext`]. Such `APIRequestContext` object will have its own isolated cookie\nstorage.\n\n```py\nimport os\nimport asyncio\nfrom playwright.async_api import async_playwright, Playwright\n\nREPO = \"test-repo-1\"\nUSER = \"github-username\"\nAPI_TOKEN = os.getenv(\"GITHUB_API_TOKEN\")\n\nasync def run(playwright: Playwright):\n    # This will launch a new browser, create a context and page. When making HTTP\n    # requests with the internal APIRequestContext (e.g. `context.request` or `page.request`)\n    # it will automatically set the cookies to the browser page and vice versa.\n    browser = await playwright.chromium.launch()\n    context = await browser.new_context(base_url=\"https://api.github.com\")\n    api_request_context = context.request\n    page = await context.new_page()\n\n    # Alternatively you can create a APIRequestContext manually without having a browser context attached:\n    # api_request_context = await playwright.request.new_context(base_url=\"https://api.github.com\")\n\n    # Create a repository.\n    response = await api_request_context.post(\n        \"/user/repos\",\n        headers={\n            \"Accept\": \"application/vnd.github.v3+json\",\n            # Add GitHub personal access token.\n            \"Authorization\": f\"token {API_TOKEN}\",\n        },\n        data={\"name\": REPO},\n    )\n    assert response.ok\n    assert response.json()[\"name\"] == REPO\n\n    # Delete a repository.\n    response = await api_request_context.delete(\n        f\"/repos/{USER}/{REPO}\",\n        headers={\n            \"Accept\": \"application/vnd.github.v3+json\",\n            # Add GitHub personal access token.\n            \"Authorization\": f\"token {API_TOKEN}\",\n        },\n    )\n    assert response.ok\n    assert await response.body() == '{\"status\": \"ok\"}'\n\nasync def main():\n    async with async_playwright() as playwright:\n        await run(playwright)\n\nasyncio.run(main())\n```\n\n```py\nimport os\nfrom playwright.sync_api import sync_playwright\n\nREPO = \"test-repo-1\"\nUSER = \"github-username\"\nAPI_TOKEN = os.getenv(\"GITHUB_API_TOKEN\")\n\nwith sync_playwright() as p:\n    # This will launch a new browser, create a context and page. When making HTTP\n    # requests with the internal APIRequestContext (e.g. `context.request` or `page.request`)\n    # it will automatically set the cookies to the browser page and vice versa.\n    browser = p.chromium.launch()\n    context = browser.new_context(base_url=\"https://api.github.com\")\n    api_request_context = context.request\n    page = context.new_page()\n\n    # Alternatively you can create a APIRequestContext manually without having a browser context attached:\n    # api_request_context = p.request.new_context(base_url=\"https://api.github.com\")\n\n\n    # Create a repository.\n    response = api_request_context.post(\n        \"/user/repos\",\n        headers={\n            \"Accept\": \"application/vnd.github.v3+json\",\n            # Add GitHub personal access token.\n            \"Authorization\": f\"token {API_TOKEN}\",\n        },\n        data={\"name\": REPO},\n    )\n    assert response.ok\n    assert response.json()[\"name\"] == REPO\n\n    # Delete a repository.\n    response = api_request_context.delete(\n        f\"/repos/{USER}/{REPO}\",\n        headers={\n            \"Accept\": \"application/vnd.github.v3+json\",\n            # Add GitHub personal access token.\n            \"Authorization\": f\"token {API_TOKEN}\",\n        },\n    )\n    assert response.ok\n    assert await response.body() == '{\"status\": \"ok\"}'\n```\n","since":"v1.16","members":[{"kind":"method","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.23","name":"createFormData","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Creates a new `FormData` instance which is used for providing form and multipart data when making HTTP requests."}],"required":true,"comment":"Creates a new `FormData` instance which is used for providing form and multipart data when making HTTP requests.","async":false,"alias":"createFormData","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"delete","type":{"name":"APIResponse","expression":"[APIResponse]"},"spec":[{"type":"text","text":"Sends HTTP(S) [DELETE](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/DELETE) request and returns its response.↵The method will populate request cookies from the context and update↵context cookies from the response. The method will automatically follow redirects."}],"required":true,"comment":"Sends HTTP(S) [DELETE](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/DELETE) request and returns its\nresponse. The method will populate request cookies from the context and update context cookies from the response.\nThe method will automatically follow redirects.","async":true,"alias":"delete","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Target URL."}],"required":true,"comment":"Target URL.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.17","name":"data","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"},{"name":"Serializable"}],"expression":"[string]|[Buffer]|[Serializable]"},"spec":[{"type":"text","text":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string↵and `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type` header will be↵set to `application/octet-stream` if not explicitly set."}],"required":false,"comment":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string\nand `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type`\nheader will be set to `application/octet-stream` if not explicitly set.","async":false,"alias":"data","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.17","name":"form","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"FormData"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.17","name":"form","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.17","name":"form","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by it."}],"required":false,"comment":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by\nit.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.46","name":"maxRetries","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not retry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries."}],"required":false,"comment":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not\nretry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries.","async":false,"alias":"maxRetries","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.17","name":"multipart","type":{"name":"","union":[{"name":"FormData"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.17","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.17","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}]}],"expression":"[FormData]|[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed either as [`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream)↵or as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed either as\n[`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream) or as file-like object containing file\nname, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.17","name":"multipart","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.17","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.17","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.17","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.17","name":"multipart","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"URLSearchParams"},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[URLSearchParams]|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"Object","templates":[{"name":"string"},{"name":"Serializable"}],"expression":"[Object]<[string], [Serializable]>"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"paramsString","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"paramsString","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"params","type":{"name":"RequestOptions","expression":"[RequestOptions]"},"spec":[{"type":"text","text":"Optional request parameters."}],"required":false,"comment":"Optional request parameters.","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.16","name":"dispose","type":{"name":"void"},"spec":[{"type":"text","text":"All responses returned by [`method: APIRequestContext.get`] and similar methods are stored in the memory, so that you can later call [`method: APIResponse.body`].This method discards all its resources, calling any method on disposed `APIRequestContext` will throw an exception."}],"required":true,"comment":"All responses returned by [`method: APIRequestContext.get`] and similar methods are stored in the memory, so that\nyou can later call [`method: APIResponse.body`].This method discards all its resources, calling any method on\ndisposed `APIRequestContext` will throw an exception.","async":true,"alias":"dispose","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.45","name":"reason","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"The reason to be reported to the operations interrupted by the context disposal."}],"required":false,"comment":"The reason to be reported to the operations interrupted by the context disposal.","async":false,"alias":"reason","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.16","name":"fetch","type":{"name":"APIResponse","expression":"[APIResponse]"},"spec":[{"type":"text","text":"Sends HTTP(S) request and returns its response. The method will populate request cookies from the context and update↵context cookies from the response. The method will automatically follow redirects."},{"type":"text","text":"**Usage**"},{"type":"text","text":"JSON objects can be passed directly to the request:"},{"type":"code","lines":["await request.fetch('https://example.com/api/createBook', {","  method: 'post',","  data: {","    title: 'Book Title',","    author: 'John Doe',","  }","});"],"codeLang":"js"},{"type":"code","lines":["Map<String, Object> data = new HashMap();","data.put(\"title\", \"Book Title\");","data.put(\"body\", \"John Doe\");","request.fetch(\"https://example.com/api/createBook\", RequestOptions.create().setMethod(\"post\").setData(data));"],"codeLang":"java"},{"type":"code","lines":["data = {","    \"title\": \"Book Title\",","    \"body\": \"John Doe\",","}","api_request_context.fetch(\"https://example.com/api/createBook\", method=\"post\", data=data)"],"codeLang":"python"},{"type":"code","lines":["var data = new Dictionary<string, object>() {","  { \"title\", \"Book Title\" },","  { \"body\", \"John Doe\" }","};","await Request.FetchAsync(\"https://example.com/api/createBook\", new() { Method = \"post\", DataObject = data });"],"codeLang":"csharp"},{"type":"text","text":"The common way to send file(s) in the body of a request is to upload them as form fields with `multipart/form-data` encoding, by specifiying the `multipart` parameter:"},{"type":"code","lines":["const form = new FormData();","form.set('name', 'John');","form.append('name', 'Doe');","// Send two file fields with the same name.","form.append('file', new File(['console.log(2024);'], 'f1.js', { type: 'text/javascript' }));","form.append('file', new File(['hello'], 'f2.txt', { type: 'text/plain' }));","await request.fetch('https://example.com/api/uploadForm', {","  multipart: form","});"],"codeLang":"js"},{"type":"code","lines":["// Pass file path to the form data constructor:","Path file = Paths.get(\"team.csv\");","APIResponse response = request.fetch(\"https://example.com/api/uploadTeamList\",","  RequestOptions.create().setMethod(\"post\").setMultipart(","    FormData.create().set(\"fileField\", file)));","","// Or you can pass the file content directly as FilePayload object:","FilePayload filePayload = new FilePayload(\"f.js\", \"text/javascript\",","      \"console.log(2022);\".getBytes(StandardCharsets.UTF_8));","APIResponse response = request.fetch(\"https://example.com/api/uploadScript\",","  RequestOptions.create().setMethod(\"post\").setMultipart(","    FormData.create().set(\"fileField\", filePayload)));"],"codeLang":"java"},{"type":"code","lines":["api_request_context.fetch(","  \"https://example.com/api/uploadScript\",  method=\"post\",","  multipart={","    \"fileField\": {","      \"name\": \"f.js\",","      \"mimeType\": \"text/javascript\",","      \"buffer\": b\"console.log(2022);\",","    },","  })"],"codeLang":"python"},{"type":"code","lines":["var file = new FilePayload()","{","    Name = \"f.js\",","    MimeType = \"text/javascript\",","    Buffer = System.Text.Encoding.UTF8.GetBytes(\"console.log(2022);\")","};","var multipart = Context.APIRequest.CreateFormData();","multipart.Set(\"fileField\", file);","await Request.FetchAsync(\"https://example.com/api/uploadScript\", new() { Method = \"post\", Multipart = multipart });"],"codeLang":"csharp"}],"required":true,"comment":"Sends HTTP(S) request and returns its response. The method will populate request cookies from the context and\nupdate context cookies from the response. The method will automatically follow redirects.\n\n**Usage**\n\nJSON objects can be passed directly to the request:\n\n```js\nawait request.fetch('https://example.com/api/createBook', {\n  method: 'post',\n  data: {\n    title: 'Book Title',\n    author: 'John Doe',\n  }\n});\n```\n\n```java\nMap<String, Object> data = new HashMap();\ndata.put(\"title\", \"Book Title\");\ndata.put(\"body\", \"John Doe\");\nrequest.fetch(\"https://example.com/api/createBook\", RequestOptions.create().setMethod(\"post\").setData(data));\n```\n\n```python\ndata = {\n    \"title\": \"Book Title\",\n    \"body\": \"John Doe\",\n}\napi_request_context.fetch(\"https://example.com/api/createBook\", method=\"post\", data=data)\n```\n\n```csharp\nvar data = new Dictionary<string, object>() {\n  { \"title\", \"Book Title\" },\n  { \"body\", \"John Doe\" }\n};\nawait Request.FetchAsync(\"https://example.com/api/createBook\", new() { Method = \"post\", DataObject = data });\n```\n\nThe common way to send file(s) in the body of a request is to upload them as form fields with `multipart/form-data`\nencoding, by specifiying the `multipart` parameter:\n\n```js\nconst form = new FormData();\nform.set('name', 'John');\nform.append('name', 'Doe');\n// Send two file fields with the same name.\nform.append('file', new File(['console.log(2024);'], 'f1.js', { type: 'text/javascript' }));\nform.append('file', new File(['hello'], 'f2.txt', { type: 'text/plain' }));\nawait request.fetch('https://example.com/api/uploadForm', {\n  multipart: form\n});\n```\n\n```java\n// Pass file path to the form data constructor:\nPath file = Paths.get(\"team.csv\");\nAPIResponse response = request.fetch(\"https://example.com/api/uploadTeamList\",\n  RequestOptions.create().setMethod(\"post\").setMultipart(\n    FormData.create().set(\"fileField\", file)));\n\n// Or you can pass the file content directly as FilePayload object:\nFilePayload filePayload = new FilePayload(\"f.js\", \"text/javascript\",\n      \"console.log(2022);\".getBytes(StandardCharsets.UTF_8));\nAPIResponse response = request.fetch(\"https://example.com/api/uploadScript\",\n  RequestOptions.create().setMethod(\"post\").setMultipart(\n    FormData.create().set(\"fileField\", filePayload)));\n```\n\n```python\napi_request_context.fetch(\n  \"https://example.com/api/uploadScript\",  method=\"post\",\n  multipart={\n    \"fileField\": {\n      \"name\": \"f.js\",\n      \"mimeType\": \"text/javascript\",\n      \"buffer\": b\"console.log(2022);\",\n    },\n  })\n```\n\n```csharp\nvar file = new FilePayload()\n{\n    Name = \"f.js\",\n    MimeType = \"text/javascript\",\n    Buffer = System.Text.Encoding.UTF8.GetBytes(\"console.log(2022);\")\n};\nvar multipart = Context.APIRequest.CreateFormData();\nmultipart.Set(\"fileField\", file);\nawait Request.FetchAsync(\"https://example.com/api/uploadScript\", new() { Method = \"post\", Multipart = multipart });\n```\n","async":true,"alias":"fetch","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"urlOrRequest","type":{"name":"","union":[{"name":"string"},{"name":"Request"}],"expression":"[string]|[Request]"},"spec":[{"type":"text","text":"Target URL or Request to get all parameters from."}],"required":true,"comment":"Target URL or Request to get all parameters from.","async":false,"alias":"urlOrRequest","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"data","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"},{"name":"Serializable"}],"expression":"[string]|[Buffer]|[Serializable]"},"spec":[{"type":"text","text":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string↵and `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type` header will be↵set to `application/octet-stream` if not explicitly set."}],"required":false,"comment":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string\nand `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type`\nheader will be set to `application/octet-stream` if not explicitly set.","async":false,"alias":"data","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"FormData"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by it."}],"required":false,"comment":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by\nit.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.46","name":"maxRetries","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not retry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries."}],"required":false,"comment":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not\nretry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries.","async":false,"alias":"maxRetries","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"method","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"If set changes the fetch method (e.g. [PUT](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PUT) or↵[POST](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST)). If not specified, GET method is used."}],"required":false,"comment":"If set changes the fetch method (e.g. [PUT](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PUT) or\n[POST](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST)). If not specified, GET method is used.","async":false,"alias":"method","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"","union":[{"name":"FormData"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}]}],"expression":"[FormData]|[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed either as [`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream)↵or as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed either as\n[`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream) or as file-like object containing file\nname, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"URLSearchParams"},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[URLSearchParams]|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"Object","templates":[{"name":"string"},{"name":"Serializable"}],"expression":"[Object]<[string], [Serializable]>"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"paramsString","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"paramsString","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"params","type":{"name":"RequestOptions","expression":"[RequestOptions]"},"spec":[{"type":"text","text":"Optional request parameters."}],"required":false,"comment":"Optional request parameters.","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.16","name":"get","type":{"name":"APIResponse","expression":"[APIResponse]"},"spec":[{"type":"text","text":"Sends HTTP(S) [GET](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/GET) request and returns its response.↵The method will populate request cookies from the context and update↵context cookies from the response. The method will automatically follow redirects."},{"type":"text","text":"**Usage**"},{"type":"text","text":"Request parameters can be configured with `params` option, they will be serialized into the URL search parameters:"},{"type":"code","lines":["// Passing params as object","await request.get('https://example.com/api/getText', {","  params: {","    'isbn': '1234',","    'page': 23,","  }","});","","// Passing params as URLSearchParams","const searchParams = new URLSearchParams();","searchParams.set('isbn', '1234');","searchParams.append('page', 23);","searchParams.append('page', 24);","await request.get('https://example.com/api/getText', { params: searchParams });","","// Passing params as string","const queryString = 'isbn=1234&page=23&page=24';","await request.get('https://example.com/api/getText', { params: queryString });"],"codeLang":"js"},{"type":"code","lines":["request.get(\"https://example.com/api/getText\", RequestOptions.create()","  .setQueryParam(\"isbn\", \"1234\")","  .setQueryParam(\"page\", 23));"],"codeLang":"java"},{"type":"code","lines":["query_params = {","  \"isbn\": \"1234\",","  \"page\": \"23\"","}","api_request_context.get(\"https://example.com/api/getText\", params=query_params)"],"codeLang":"python"},{"type":"code","lines":["var queryParams = new Dictionary<string, object>()","{","  { \"isbn\", \"1234\" },","  { \"page\", 23 },","};","await request.GetAsync(\"https://example.com/api/getText\", new() { Params = queryParams });"],"codeLang":"csharp"}],"required":true,"comment":"Sends HTTP(S) [GET](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/GET) request and returns its\nresponse. The method will populate request cookies from the context and update context cookies from the response.\nThe method will automatically follow redirects.\n\n**Usage**\n\nRequest parameters can be configured with `params` option, they will be serialized into the URL search parameters:\n\n```js\n// Passing params as object\nawait request.get('https://example.com/api/getText', {\n  params: {\n    'isbn': '1234',\n    'page': 23,\n  }\n});\n\n// Passing params as URLSearchParams\nconst searchParams = new URLSearchParams();\nsearchParams.set('isbn', '1234');\nsearchParams.append('page', 23);\nsearchParams.append('page', 24);\nawait request.get('https://example.com/api/getText', { params: searchParams });\n\n// Passing params as string\nconst queryString = 'isbn=1234&page=23&page=24';\nawait request.get('https://example.com/api/getText', { params: queryString });\n```\n\n```java\nrequest.get(\"https://example.com/api/getText\", RequestOptions.create()\n  .setQueryParam(\"isbn\", \"1234\")\n  .setQueryParam(\"page\", 23));\n```\n\n```python\nquery_params = {\n  \"isbn\": \"1234\",\n  \"page\": \"23\"\n}\napi_request_context.get(\"https://example.com/api/getText\", params=query_params)\n```\n\n```csharp\nvar queryParams = new Dictionary<string, object>()\n{\n  { \"isbn\", \"1234\" },\n  { \"page\", 23 },\n};\nawait request.GetAsync(\"https://example.com/api/getText\", new() { Params = queryParams });\n```\n","async":true,"alias":"get","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Target URL."}],"required":true,"comment":"Target URL.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"data","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"},{"name":"Serializable"}],"expression":"[string]|[Buffer]|[Serializable]"},"spec":[{"type":"text","text":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string↵and `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type` header will be↵set to `application/octet-stream` if not explicitly set."}],"required":false,"comment":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string\nand `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type`\nheader will be set to `application/octet-stream` if not explicitly set.","async":false,"alias":"data","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"form","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"FormData"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"form","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"form","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by it."}],"required":false,"comment":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by\nit.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.46","name":"maxRetries","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not retry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries."}],"required":false,"comment":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not\nretry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries.","async":false,"alias":"maxRetries","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"multipart","type":{"name":"","union":[{"name":"FormData"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}]}],"expression":"[FormData]|[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed either as [`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream)↵or as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed either as\n[`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream) or as file-like object containing file\nname, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"multipart","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"multipart","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"URLSearchParams"},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[URLSearchParams]|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"Object","templates":[{"name":"string"},{"name":"Serializable"}],"expression":"[Object]<[string], [Serializable]>"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"paramsString","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"paramsString","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"params","type":{"name":"RequestOptions","expression":"[RequestOptions]"},"spec":[{"type":"text","text":"Optional request parameters."}],"required":false,"comment":"Optional request parameters.","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.16","name":"head","type":{"name":"APIResponse","expression":"[APIResponse]"},"spec":[{"type":"text","text":"Sends HTTP(S) [HEAD](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/HEAD) request and returns its response.↵The method will populate request cookies from the context and update↵context cookies from the response. The method will automatically follow redirects."}],"required":true,"comment":"Sends HTTP(S) [HEAD](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/HEAD) request and returns its\nresponse. The method will populate request cookies from the context and update context cookies from the response.\nThe method will automatically follow redirects.","async":true,"alias":"head","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Target URL."}],"required":true,"comment":"Target URL.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"data","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"},{"name":"Serializable"}],"expression":"[string]|[Buffer]|[Serializable]"},"spec":[{"type":"text","text":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string↵and `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type` header will be↵set to `application/octet-stream` if not explicitly set."}],"required":false,"comment":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string\nand `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type`\nheader will be set to `application/octet-stream` if not explicitly set.","async":false,"alias":"data","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"form","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"form","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"FormData"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"form","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by it."}],"required":false,"comment":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by\nit.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.46","name":"maxRetries","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not retry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries."}],"required":false,"comment":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not\nretry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries.","async":false,"alias":"maxRetries","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"multipart","type":{"name":"","union":[{"name":"FormData"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}]}],"expression":"[FormData]|[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed either as [`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream)↵or as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed either as\n[`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream) or as file-like object containing file\nname, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"multipart","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.26","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.26","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"multipart","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"URLSearchParams"},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[URLSearchParams]|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"Object","templates":[{"name":"string"},{"name":"Serializable"}],"expression":"[Object]<[string], [Serializable]>"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"paramsString","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"paramsString","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"params","type":{"name":"RequestOptions","expression":"[RequestOptions]"},"spec":[{"type":"text","text":"Optional request parameters."}],"required":false,"comment":"Optional request parameters.","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.16","name":"patch","type":{"name":"APIResponse","expression":"[APIResponse]"},"spec":[{"type":"text","text":"Sends HTTP(S) [PATCH](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PATCH) request and returns its response.↵The method will populate request cookies from the context and update↵context cookies from the response. The method will automatically follow redirects."}],"required":true,"comment":"Sends HTTP(S) [PATCH](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PATCH) request and returns its\nresponse. The method will populate request cookies from the context and update context cookies from the response.\nThe method will automatically follow redirects.","async":true,"alias":"patch","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Target URL."}],"required":true,"comment":"Target URL.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"data","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"},{"name":"Serializable"}],"expression":"[string]|[Buffer]|[Serializable]"},"spec":[{"type":"text","text":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string↵and `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type` header will be↵set to `application/octet-stream` if not explicitly set."}],"required":false,"comment":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string\nand `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type`\nheader will be set to `application/octet-stream` if not explicitly set.","async":false,"alias":"data","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"FormData"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by it."}],"required":false,"comment":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by\nit.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.46","name":"maxRetries","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not retry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries."}],"required":false,"comment":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not\nretry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries.","async":false,"alias":"maxRetries","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"","union":[{"name":"FormData"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}]}],"expression":"[FormData]|[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed either as [`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream)↵or as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed either as\n[`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream) or as file-like object containing file\nname, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"URLSearchParams"},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[URLSearchParams]|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"Object","templates":[{"name":"string"},{"name":"Serializable"}],"expression":"[Object]<[string], [Serializable]>"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"paramsString","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"paramsString","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"params","type":{"name":"RequestOptions","expression":"[RequestOptions]"},"spec":[{"type":"text","text":"Optional request parameters."}],"required":false,"comment":"Optional request parameters.","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.16","name":"post","type":{"name":"APIResponse","expression":"[APIResponse]"},"spec":[{"type":"text","text":"Sends HTTP(S) [POST](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST) request and returns its response.↵The method will populate request cookies from the context and update↵context cookies from the response. The method will automatically follow redirects."},{"type":"text","text":"**Usage**"},{"type":"text","text":"JSON objects can be passed directly to the request:"},{"type":"code","lines":["await request.post('https://example.com/api/createBook', {","  data: {","    title: 'Book Title',","    author: 'John Doe',","  }","});"],"codeLang":"js"},{"type":"code","lines":["Map<String, Object> data = new HashMap();","data.put(\"title\", \"Book Title\");","data.put(\"body\", \"John Doe\");","request.post(\"https://example.com/api/createBook\", RequestOptions.create().setData(data));"],"codeLang":"java"},{"type":"code","lines":["data = {","    \"title\": \"Book Title\",","    \"body\": \"John Doe\",","}","api_request_context.post(\"https://example.com/api/createBook\", data=data)"],"codeLang":"python"},{"type":"code","lines":["var data = new Dictionary<string, object>() {","  { \"firstName\", \"John\" },","  { \"lastName\", \"Doe\" }","};","await request.PostAsync(\"https://example.com/api/createBook\", new() { DataObject = data });"],"codeLang":"csharp"},{"type":"text","text":"To send form data to the server use `form` option. Its value will be encoded into the request body with `application/x-www-form-urlencoded` encoding (see below how to use `multipart/form-data` form encoding to send files):"},{"type":"code","lines":["await request.post('https://example.com/api/findBook', {","  form: {","    title: 'Book Title',","    author: 'John Doe',","  }","});"],"codeLang":"js"},{"type":"code","lines":["request.post(\"https://example.com/api/findBook\", RequestOptions.create().setForm(","    FormData.create().set(\"title\", \"Book Title\").set(\"body\", \"John Doe\")","));"],"codeLang":"java"},{"type":"code","lines":["formData = {","    \"title\": \"Book Title\",","    \"body\": \"John Doe\",","}","api_request_context.post(\"https://example.com/api/findBook\", form=formData)"],"codeLang":"python"},{"type":"code","lines":["var formData = Context.APIRequest.CreateFormData();","formData.Set(\"title\", \"Book Title\");","formData.Set(\"body\", \"John Doe\");","await request.PostAsync(\"https://example.com/api/findBook\", new() { Form = formData });"],"codeLang":"csharp"},{"type":"text","text":"The common way to send file(s) in the body of a request is to upload them as form fields with `multipart/form-data` encoding. Use `FormData` to construct request body and pass it to the request as `multipart` parameter:"},{"type":"code","lines":["const form = new FormData();","form.set('name', 'John');","form.append('name', 'Doe');","// Send two file fields with the same name.","form.append('file', new File(['console.log(2024);'], 'f1.js', { type: 'text/javascript' }));","form.append('file', new File(['hello'], 'f2.txt', { type: 'text/plain' }));","await request.post('https://example.com/api/uploadForm', {","  multipart: form","});"],"codeLang":"js"},{"type":"code","lines":["// Pass file path to the form data constructor:","Path file = Paths.get(\"team.csv\");","APIResponse response = request.post(\"https://example.com/api/uploadTeamList\",","  RequestOptions.create().setMultipart(","    FormData.create().set(\"fileField\", file)));","","// Or you can pass the file content directly as FilePayload object:","FilePayload filePayload1 = new FilePayload(\"f1.js\", \"text/javascript\",","      \"console.log(2022);\".getBytes(StandardCharsets.UTF_8));","APIResponse response = request.post(\"https://example.com/api/uploadScript\",","  RequestOptions.create().setMultipart(","    FormData.create().set(\"fileField\", filePayload)));"],"codeLang":"java"},{"type":"code","lines":["api_request_context.post(","  \"https://example.com/api/uploadScript'\",","  multipart={","    \"fileField\": {","      \"name\": \"f.js\",","      \"mimeType\": \"text/javascript\",","      \"buffer\": b\"console.log(2022);\",","    },","  })"],"codeLang":"python"},{"type":"code","lines":["var file = new FilePayload()","{","    Name = \"f.js\",","    MimeType = \"text/javascript\",","    Buffer = System.Text.Encoding.UTF8.GetBytes(\"console.log(2022);\")","};","var multipart = Context.APIRequest.CreateFormData();","multipart.Set(\"fileField\", file);","await request.PostAsync(\"https://example.com/api/uploadScript\", new() { Multipart = multipart });"],"codeLang":"csharp"}],"required":true,"comment":"Sends HTTP(S) [POST](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST) request and returns its\nresponse. The method will populate request cookies from the context and update context cookies from the response.\nThe method will automatically follow redirects.\n\n**Usage**\n\nJSON objects can be passed directly to the request:\n\n```js\nawait request.post('https://example.com/api/createBook', {\n  data: {\n    title: 'Book Title',\n    author: 'John Doe',\n  }\n});\n```\n\n```java\nMap<String, Object> data = new HashMap();\ndata.put(\"title\", \"Book Title\");\ndata.put(\"body\", \"John Doe\");\nrequest.post(\"https://example.com/api/createBook\", RequestOptions.create().setData(data));\n```\n\n```python\ndata = {\n    \"title\": \"Book Title\",\n    \"body\": \"John Doe\",\n}\napi_request_context.post(\"https://example.com/api/createBook\", data=data)\n```\n\n```csharp\nvar data = new Dictionary<string, object>() {\n  { \"firstName\", \"John\" },\n  { \"lastName\", \"Doe\" }\n};\nawait request.PostAsync(\"https://example.com/api/createBook\", new() { DataObject = data });\n```\n\nTo send form data to the server use `form` option. Its value will be encoded into the request body with\n`application/x-www-form-urlencoded` encoding (see below how to use `multipart/form-data` form encoding to send\nfiles):\n\n```js\nawait request.post('https://example.com/api/findBook', {\n  form: {\n    title: 'Book Title',\n    author: 'John Doe',\n  }\n});\n```\n\n```java\nrequest.post(\"https://example.com/api/findBook\", RequestOptions.create().setForm(\n    FormData.create().set(\"title\", \"Book Title\").set(\"body\", \"John Doe\")\n));\n```\n\n```python\nformData = {\n    \"title\": \"Book Title\",\n    \"body\": \"John Doe\",\n}\napi_request_context.post(\"https://example.com/api/findBook\", form=formData)\n```\n\n```csharp\nvar formData = Context.APIRequest.CreateFormData();\nformData.Set(\"title\", \"Book Title\");\nformData.Set(\"body\", \"John Doe\");\nawait request.PostAsync(\"https://example.com/api/findBook\", new() { Form = formData });\n```\n\nThe common way to send file(s) in the body of a request is to upload them as form fields with `multipart/form-data`\nencoding. Use `FormData` to construct request body and pass it to the request as `multipart` parameter:\n\n```js\nconst form = new FormData();\nform.set('name', 'John');\nform.append('name', 'Doe');\n// Send two file fields with the same name.\nform.append('file', new File(['console.log(2024);'], 'f1.js', { type: 'text/javascript' }));\nform.append('file', new File(['hello'], 'f2.txt', { type: 'text/plain' }));\nawait request.post('https://example.com/api/uploadForm', {\n  multipart: form\n});\n```\n\n```java\n// Pass file path to the form data constructor:\nPath file = Paths.get(\"team.csv\");\nAPIResponse response = request.post(\"https://example.com/api/uploadTeamList\",\n  RequestOptions.create().setMultipart(\n    FormData.create().set(\"fileField\", file)));\n\n// Or you can pass the file content directly as FilePayload object:\nFilePayload filePayload1 = new FilePayload(\"f1.js\", \"text/javascript\",\n      \"console.log(2022);\".getBytes(StandardCharsets.UTF_8));\nAPIResponse response = request.post(\"https://example.com/api/uploadScript\",\n  RequestOptions.create().setMultipart(\n    FormData.create().set(\"fileField\", filePayload)));\n```\n\n```python\napi_request_context.post(\n  \"https://example.com/api/uploadScript'\",\n  multipart={\n    \"fileField\": {\n      \"name\": \"f.js\",\n      \"mimeType\": \"text/javascript\",\n      \"buffer\": b\"console.log(2022);\",\n    },\n  })\n```\n\n```csharp\nvar file = new FilePayload()\n{\n    Name = \"f.js\",\n    MimeType = \"text/javascript\",\n    Buffer = System.Text.Encoding.UTF8.GetBytes(\"console.log(2022);\")\n};\nvar multipart = Context.APIRequest.CreateFormData();\nmultipart.Set(\"fileField\", file);\nawait request.PostAsync(\"https://example.com/api/uploadScript\", new() { Multipart = multipart });\n```\n","async":true,"alias":"post","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Target URL."}],"required":true,"comment":"Target URL.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"data","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"},{"name":"Serializable"}],"expression":"[string]|[Buffer]|[Serializable]"},"spec":[{"type":"text","text":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string↵and `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type` header will be↵set to `application/octet-stream` if not explicitly set."}],"required":false,"comment":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string\nand `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type`\nheader will be set to `application/octet-stream` if not explicitly set.","async":false,"alias":"data","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"FormData"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by it."}],"required":false,"comment":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by\nit.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.46","name":"maxRetries","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not retry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries."}],"required":false,"comment":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not\nretry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries.","async":false,"alias":"maxRetries","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"","union":[{"name":"FormData"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}]}],"expression":"[FormData]|[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed either as [`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream)↵or as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed either as\n[`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream) or as file-like object containing file\nname, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"URLSearchParams"},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[URLSearchParams]|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"Object","templates":[{"name":"string"},{"name":"Serializable"}],"expression":"[Object]<[string], [Serializable]>"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"paramsString","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"paramsString","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"params","type":{"name":"RequestOptions","expression":"[RequestOptions]"},"spec":[{"type":"text","text":"Optional request parameters."}],"required":false,"comment":"Optional request parameters.","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.16","name":"put","type":{"name":"APIResponse","expression":"[APIResponse]"},"spec":[{"type":"text","text":"Sends HTTP(S) [PUT](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PUT) request and returns its response.↵The method will populate request cookies from the context and update↵context cookies from the response. The method will automatically follow redirects."}],"required":true,"comment":"Sends HTTP(S) [PUT](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/PUT) request and returns its\nresponse. The method will populate request cookies from the context and update context cookies from the response.\nThe method will automatically follow redirects.","async":true,"alias":"put","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Target URL."}],"required":true,"comment":"Target URL.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"data","type":{"name":"","union":[{"name":"string"},{"name":"Buffer"},{"name":"Serializable"}],"expression":"[string]|[Buffer]|[Serializable]"},"spec":[{"type":"text","text":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string↵and `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type` header will be↵set to `application/octet-stream` if not explicitly set."}],"required":false,"comment":"Allows to set post data of the request. If the data parameter is an object, it will be serialized to json string\nand `content-type` header will be set to `application/json` if not explicitly set. Otherwise the `content-type`\nheader will be set to `application/octet-stream` if not explicitly set.","async":false,"alias":"data","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"failOnStatusCode","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned↵for all status codes."}],"required":false,"comment":"Whether to throw on response codes other than 2xx and 3xx. By default response object is returned for all status\ncodes.","async":false,"alias":"failOnStatusCode","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"FormData"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"form","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `application/x-www-form-urlencoded`↵unless explicitly provided."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `application/x-www-form-urlencoded` encoding and sent\nas this request body. If this parameter is specified `content-type` header will be set to\n`application/x-www-form-urlencoded` unless explicitly provided.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"form","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by it."}],"required":false,"comment":"Allows to set HTTP headers. These headers will apply to the fetched request as well as any redirects initiated by\nit.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.26","name":"maxRedirects","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is exceeded.↵Defaults to `20`. Pass `0` to not follow redirects."}],"required":false,"comment":"Maximum number of request redirects that will be followed automatically. An error will be thrown if the number is\nexceeded. Defaults to `20`. Pass `0` to not follow redirects.","async":false,"alias":"maxRedirects","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.46","name":"maxRetries","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not retry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries."}],"required":false,"comment":"Maximum number of times network errors should be retried. Currently only `ECONNRESET` error is retried. Does not\nretry based on HTTP response codes. An error will be thrown if the limit is exceeded. Defaults to `0` - no retries.","async":false,"alias":"maxRetries","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"","union":[{"name":"FormData"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}]}],"expression":"[FormData]|[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed either as [`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream)↵or as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed either as\n[`fs.ReadStream`](https://nodejs.org/api/fs.html#fs_class_fs_readstream) or as file-like object containing file\nname, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}],"templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"},{"name":"ReadStream"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]|[ReadStream]|[Object]>"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"multipart","type":{"name":"FormData","expression":"[FormData]"},"spec":[{"type":"text","text":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as↵this request body. If this parameter is specified `content-type` header will be set to `multipart/form-data`↵unless explicitly provided. File values can be passed as file-like object containing file name, mime-type and its content."},{"type":"text","text":"An instance of `FormData` can be created via [`method: APIRequestContext.createFormData`]."}],"required":false,"comment":"Provides an object that will be serialized as html form using `multipart/form-data` encoding and sent as this\nrequest body. If this parameter is specified `content-type` header will be set to `multipart/form-data` unless\nexplicitly provided. File values can be passed as file-like object containing file name, mime-type and its content.\n\nAn instance of `FormData` can be created via [`method: APIRequestContext.createFormData`].","async":false,"alias":"multipart","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"URLSearchParams"},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[URLSearchParams]|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"","union":[{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}]},{"name":"string"}],"expression":"[Object]<[string], [string]|[float]|[boolean]>|[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"params","type":{"name":"Object","templates":[{"name":"string"},{"name":"Serializable"}],"expression":"[Object]<[string], [Serializable]>"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"paramsString","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Query parameters to be sent with the URL."}],"required":false,"comment":"Query parameters to be sent with the URL.","async":false,"alias":"paramsString","overloadIndex":0},{"kind":"property","langs":{"only":["js","python","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Request timeout in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.18","name":"params","type":{"name":"RequestOptions","expression":"[RequestOptions]"},"spec":[{"type":"text","text":"Optional request parameters."}],"required":false,"comment":"Optional request parameters.","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"types":{"java":{"name":"string","expression":"[string]"},"csharp":{"name":"string","expression":"[string]"}}},"since":"v1.16","name":"storageState","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"cookies","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"domain","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"expires","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Unix time in seconds."}],"required":true,"comment":"Unix time in seconds.","async":false,"alias":"expires","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"httpOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"httpOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"secure","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"secure","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"sameSite","type":{"name":"SameSiteAttribute","union":[{"name":"\"Strict\""},{"name":"\"Lax\""},{"name":"\"None\""}],"expression":"[SameSiteAttribute]<\"Strict\"|\"Lax\"|\"None\">"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"sameSite","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"cookies","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"origins","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"localStorage","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"localStorage","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origins","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Returns storage state for this request context, contains current cookies and local storage snapshot if it was passed to the constructor."}],"required":true,"comment":"Returns storage state for this request context, contains current cookies and local storage snapshot if it was\npassed to the constructor.","async":true,"alias":"storageState","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.16","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.51","name":"indexedDB","type":{"name":"boolean","expression":"boolean"},"spec":[{"type":"text","text":"Set to `true` to include IndexedDB in the storage state snapshot."}],"required":false,"comment":"Set to `true` to include IndexedDB in the storage state snapshot.","async":false,"alias":"indexedDB","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"The file path to save the storage state to. If `path` is a relative path, then it is resolved relative to↵current working directory. If no path is provided, storage↵state is still returned, but won't be saved to the disk."}],"required":false,"comment":"The file path to save the storage state to. If `path` is a relative path, then it is resolved relative to current\nworking directory. If no path is provided, storage state is still returned, but won't be saved to the disk.","async":false,"alias":"path","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]}]},{"name":"APIResponse","spec":[{"type":"text","text":"`APIResponse` class represents responses returned by [`method: APIRequestContext.get`] and similar methods."},{"type":"code","lines":["import asyncio","from playwright.async_api import async_playwright, Playwright","","async def run(playwright: Playwright):","    context = await playwright.request.new_context()","    response = await context.get(\"https://example.com/user/repos\")","    assert response.ok","    assert response.status == 200","    assert response.headers[\"content-type\"] == \"application/json; charset=utf-8\"","    json_data = await response.json()","    assert json_data[\"name\"] == \"foobar\"","    assert await response.body() == '{\"status\": \"ok\"}'","","","async def main():","    async with async_playwright() as playwright:","        await run(playwright)","","asyncio.run(main())"],"codeLang":"python async"},{"type":"code","lines":["from playwright.sync_api import sync_playwright","","with sync_playwright() as p:","    context = playwright.request.new_context()","    response = context.get(\"https://example.com/user/repos\")","    assert response.ok","    assert response.status == 200","    assert response.headers[\"content-type\"] == \"application/json; charset=utf-8\"","    assert response.json()[\"name\"] == \"foobar\"","    assert response.body() == '{\"status\": \"ok\"}'"],"codeLang":"python sync"}],"langs":{},"comment":"`APIResponse` class represents responses returned by [`method: APIRequestContext.get`] and similar methods.\n\n```py\nimport asyncio\nfrom playwright.async_api import async_playwright, Playwright\n\nasync def run(playwright: Playwright):\n    context = await playwright.request.new_context()\n    response = await context.get(\"https://example.com/user/repos\")\n    assert response.ok\n    assert response.status == 200\n    assert response.headers[\"content-type\"] == \"application/json; charset=utf-8\"\n    json_data = await response.json()\n    assert json_data[\"name\"] == \"foobar\"\n    assert await response.body() == '{\"status\": \"ok\"}'\n\n\nasync def main():\n    async with async_playwright() as playwright:\n        await run(playwright)\n\nasyncio.run(main())\n```\n\n```py\nfrom playwright.sync_api import sync_playwright\n\nwith sync_playwright() as p:\n    context = playwright.request.new_context()\n    response = context.get(\"https://example.com/user/repos\")\n    assert response.ok\n    assert response.status == 200\n    assert response.headers[\"content-type\"] == \"application/json; charset=utf-8\"\n    assert response.json()[\"name\"] == \"foobar\"\n    assert response.body() == '{\"status\": \"ok\"}'\n```\n","since":"v1.16","members":[{"kind":"method","langs":{},"since":"v1.16","name":"body","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Returns the buffer with response body."}],"required":true,"comment":"Returns the buffer with response body.","async":true,"alias":"body","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"dispose","type":{"name":"void"},"spec":[{"type":"text","text":"Disposes the body of this response. If not called then the body will stay in memory until the context closes."}],"required":true,"comment":"Disposes the body of this response. If not called then the body will stay in memory until the context closes.","async":true,"alias":"dispose","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object with all the response HTTP headers associated with this response."}],"required":true,"comment":"An object with all the response HTTP headers associated with this response.","async":false,"alias":"headers","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"headersArray","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.16","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Name of the header."}],"required":true,"comment":"Name of the header.","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.16","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Value of the header."}],"required":true,"comment":"Value of the header.","async":false,"alias":"value","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"An array with all the response HTTP headers associated with this response. Header names are not lower-cased.↵Headers with multiple entries, such as `Set-Cookie`, appear in the array multiple times."}],"required":true,"comment":"An array with all the response HTTP headers associated with this response. Header names are not lower-cased.\nHeaders with multiple entries, such as `Set-Cookie`, appear in the array multiple times.","async":false,"alias":"headersArray","overloadIndex":0,"args":[]},{"kind":"method","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"json","type":{"name":"Serializable","expression":"[Serializable]"},"spec":[{"type":"text","text":"Returns the JSON representation of response body."},{"type":"text","text":"This method will throw if the response body is not parsable via `JSON.parse`."}],"required":true,"comment":"Returns the JSON representation of response body.\n\nThis method will throw if the response body is not parsable via `JSON.parse`.","async":true,"alias":"json","overloadIndex":0,"args":[]},{"kind":"method","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.16","name":"json","type":{"name":"","union":[{"name":"null"},{"name":"JsonElement"}],"expression":"[null]|[JsonElement]"},"spec":[{"type":"text","text":"Returns the JSON representation of response body."},{"type":"text","text":"This method will throw if the response body is not parsable via `JSON.parse`."}],"required":true,"comment":"Returns the JSON representation of response body.\n\nThis method will throw if the response body is not parsable via `JSON.parse`.","async":true,"alias":"json","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"ok","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Contains a boolean stating whether the response was successful (status in the range 200-299) or not."}],"required":true,"comment":"Contains a boolean stating whether the response was successful (status in the range 200-299) or not.","async":false,"alias":"ok","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"status","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Contains the status code of the response (e.g., 200 for a success)."}],"required":true,"comment":"Contains the status code of the response (e.g., 200 for a success).","async":false,"alias":"status","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"statusText","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Contains the status text of the response (e.g. usually an \"OK\" for a success)."}],"required":true,"comment":"Contains the status text of the response (e.g. usually an \"OK\" for a success).","async":false,"alias":"statusText","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"text","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns the text representation of response body."}],"required":true,"comment":"Returns the text representation of response body.","async":true,"alias":"text","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.16","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Contains the URL of the response."}],"required":true,"comment":"Contains the URL of the response.","async":false,"alias":"url","overloadIndex":0,"args":[]}]},{"name":"APIResponseAssertions","spec":[{"type":"text","text":"The `APIResponseAssertions` class provides assertion methods that can be used to make assertions about the `APIResponse` in the tests."},{"type":"code","lines":["import { test, expect } from '@playwright/test';","","test('navigates to login', async ({ page }) => {","  // ...","  const response = await page.request.get('https://playwright.dev');","  await expect(response).toBeOK();","});"],"codeLang":"js"},{"type":"code","lines":["// ...","import static com.microsoft.playwright.assertions.PlaywrightAssertions.assertThat;","","public class TestPage {","  // ...","  @Test","  void navigatesToLoginPage() {","    // ...","    APIResponse response = page.request().get(\"https://playwright.dev\");","    assertThat(response).isOK();","  }","}"],"codeLang":"java"},{"type":"code","lines":["from playwright.async_api import Page, expect","","async def test_navigates_to_login_page(page: Page) -> None:","    # ..","    response = await page.request.get('https://playwright.dev')","    await expect(response).to_be_ok()"],"codeLang":"python async"},{"type":"code","lines":["from playwright.sync_api import Page, expect","","def test_navigates_to_login_page(page: Page) -> None:","    # ..","    response = page.request.get('https://playwright.dev')","    expect(response).to_be_ok()"],"codeLang":"python sync"}],"langs":{},"comment":"The `APIResponseAssertions` class provides assertion methods that can be used to make assertions about the\n`APIResponse` in the tests.\n\n```js\nimport { test, expect } from '@playwright/test';\n\ntest('navigates to login', async ({ page }) => {\n  // ...\n  const response = await page.request.get('https://playwright.dev');\n  await expect(response).toBeOK();\n});\n```\n\n```java\n// ...\nimport static com.microsoft.playwright.assertions.PlaywrightAssertions.assertThat;\n\npublic class TestPage {\n  // ...\n  @Test\n  void navigatesToLoginPage() {\n    // ...\n    APIResponse response = page.request().get(\"https://playwright.dev\");\n    assertThat(response).isOK();\n  }\n}\n```\n\n```py\nfrom playwright.async_api import Page, expect\n\nasync def test_navigates_to_login_page(page: Page) -> None:\n    # ..\n    response = await page.request.get('https://playwright.dev')\n    await expect(response).to_be_ok()\n```\n\n```py\nfrom playwright.sync_api import Page, expect\n\ndef test_navigates_to_login_page(page: Page) -> None:\n    # ..\n    response = page.request.get('https://playwright.dev')\n    expect(response).to_be_ok()\n```\n","since":"v1.18","members":[{"kind":"property","langs":{"only":["java","js","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.20","name":"not","type":{"name":"APIResponseAssertions","expression":"[APIResponseAssertions]"},"spec":[{"type":"text","text":"Makes the assertion check for the opposite condition. For example, this code tests that the response status is not successful:"},{"type":"code","lines":["await expect(response).not.toBeOK();"],"codeLang":"js"},{"type":"code","lines":["assertThat(response).not().isOK();"],"codeLang":"java"}],"required":true,"comment":"Makes the assertion check for the opposite condition. For example, this code tests that the response status is not\nsuccessful:\n\n```js\nawait expect(response).not.toBeOK();\n```\n\n```java\nassertThat(response).not().isOK();\n```\n","async":false,"alias":"not","overloadIndex":0,"args":[]},{"kind":"method","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.19","name":"NotToBeOK","type":{"name":"void"},"spec":[{"type":"text","text":"The opposite of [`method: APIResponseAssertions.toBeOK`]."}],"required":true,"comment":"The opposite of [`method: APIResponseAssertions.toBeOK`].","async":true,"alias":"NotToBeOK","overloadIndex":0,"args":[]},{"kind":"method","langs":{"aliases":{"java":"isOK"},"types":{},"overrides":{}},"since":"v1.18","name":"toBeOK","type":{"name":"void"},"spec":[{"type":"text","text":"Ensures the response status code is within `200..299` range."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await expect(response).toBeOK();"],"codeLang":"js"},{"type":"code","lines":["assertThat(response).isOK();"],"codeLang":"java"},{"type":"code","lines":["from playwright.async_api import expect","","# ...","await expect(response).to_be_ok()"],"codeLang":"python async"},{"type":"code","lines":["import re","from playwright.sync_api import expect","","# ...","expect(response).to_be_ok()"],"codeLang":"python sync"}],"required":true,"comment":"Ensures the response status code is within `200..299` range.\n\n**Usage**\n\n```js\nawait expect(response).toBeOK();\n```\n\n```java\nassertThat(response).isOK();\n```\n\n```py\nfrom playwright.async_api import expect\n\n# ...\nawait expect(response).to_be_ok()\n```\n\n```py\nimport re\nfrom playwright.sync_api import expect\n\n# ...\nexpect(response).to_be_ok()\n```\n","async":true,"alias":"toBeOK","overloadIndex":0,"args":[]}]},{"name":"Browser","spec":[{"type":"text","text":"A Browser is created via [`method: BrowserType.launch`]. An example of using a `Browser` to create a `Page`:"},{"type":"code","lines":["const { firefox } = require('playwright');  // Or 'chromium' or 'webkit'.","","(async () => {","  const browser = await firefox.launch();","  const page = await browser.newPage();","  await page.goto('https://example.com');","  await browser.close();","})();"],"codeLang":"js"},{"type":"code","lines":["import com.microsoft.playwright.*;","","public class Example {"," public static void main(String[] args) {","   try (Playwright playwright = Playwright.create()) {","     BrowserType firefox = playwright.firefox();","     Browser browser = firefox.launch();","     Page page = browser.newPage();","     page.navigate(\"https://example.com\");","     browser.close();","   }"," }","}"],"codeLang":"java"},{"type":"code","lines":["import asyncio","from playwright.async_api import async_playwright, Playwright","","async def run(playwright: Playwright):","    firefox = playwright.firefox","    browser = await firefox.launch()","    page = await browser.new_page()","    await page.goto(\"https://example.com\")","    await browser.close()","","async def main():","    async with async_playwright() as playwright:","        await run(playwright)","asyncio.run(main())"],"codeLang":"python async"},{"type":"code","lines":["from playwright.sync_api import sync_playwright, Playwright","","def run(playwright: Playwright):","    firefox = playwright.firefox","    browser = firefox.launch()","    page = browser.new_page()","    page.goto(\"https://example.com\")","    browser.close()","","with sync_playwright() as playwright:","    run(playwright)"],"codeLang":"python sync"},{"type":"code","lines":["using Microsoft.Playwright;","","using var playwright = await Playwright.CreateAsync();","var firefox = playwright.Firefox;","var browser = await firefox.LaunchAsync(new() { Headless = false });","var page = await browser.NewPageAsync();","await page.GotoAsync(\"https://www.bing.com\");","await browser.CloseAsync();"],"codeLang":"csharp"}],"langs":{},"comment":"A Browser is created via [`method: BrowserType.launch`]. An example of using a `Browser` to create a `Page`:\n\n```js\nconst { firefox } = require('playwright');  // Or 'chromium' or 'webkit'.\n\n(async () => {\n  const browser = await firefox.launch();\n  const page = await browser.newPage();\n  await page.goto('https://example.com');\n  await browser.close();\n})();\n```\n\n```java\nimport com.microsoft.playwright.*;\n\npublic class Example {\n public static void main(String[] args) {\n   try (Playwright playwright = Playwright.create()) {\n     BrowserType firefox = playwright.firefox();\n     Browser browser = firefox.launch();\n     Page page = browser.newPage();\n     page.navigate(\"https://example.com\");\n     browser.close();\n   }\n }\n}\n```\n\n```py\nimport asyncio\nfrom playwright.async_api import async_playwright, Playwright\n\nasync def run(playwright: Playwright):\n    firefox = playwright.firefox\n    browser = await firefox.launch()\n    page = await browser.new_page()\n    await page.goto(\"https://example.com\")\n    await browser.close()\n\nasync def main():\n    async with async_playwright() as playwright:\n        await run(playwright)\nasyncio.run(main())\n```\n\n```py\nfrom playwright.sync_api import sync_playwright, Playwright\n\ndef run(playwright: Playwright):\n    firefox = playwright.firefox\n    browser = firefox.launch()\n    page = browser.new_page()\n    page.goto(\"https://example.com\")\n    browser.close()\n\nwith sync_playwright() as playwright:\n    run(playwright)\n```\n\n```csharp\nusing Microsoft.Playwright;\n\nusing var playwright = await Playwright.CreateAsync();\nvar firefox = playwright.Firefox;\nvar browser = await firefox.LaunchAsync(new() { Headless = false });\nvar page = await browser.NewPageAsync();\nawait page.GotoAsync(\"https://www.bing.com\");\nawait browser.CloseAsync();\n```\n","since":"v1.8","members":[{"kind":"event","langs":{},"since":"v1.8","name":"disconnected","type":{"name":"Browser","expression":"[Browser]"},"spec":[{"type":"text","text":"Emitted when Browser gets disconnected from the browser application. This might happen because of one of the following:"},{"type":"li","text":"Browser application is closed or crashed.","liType":"bullet"},{"type":"li","text":"The [`method: Browser.close`] method was called.","liType":"bullet"}],"required":true,"comment":"Emitted when Browser gets disconnected from the browser application. This might happen because of one of the\nfollowing:\n- Browser application is closed or crashed.\n- The [`method: Browser.close`] method was called.","async":false,"alias":"disconnected","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.23","name":"browserType","type":{"name":"BrowserType","expression":"[BrowserType]"},"spec":[{"type":"text","text":"Get the browser type (chromium, firefox or webkit) that the browser belongs to."}],"required":true,"comment":"Get the browser type (chromium, firefox or webkit) that the browser belongs to.","async":false,"alias":"browserType","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"In case this browser is obtained using [`method: BrowserType.launch`], closes the browser and all of its pages (if any↵were opened)."},{"type":"text","text":"In case this browser is connected to, clears all created contexts belonging to this browser and disconnects from the↵browser server."},{"type":"note","noteType":"note","children":[{"type":"text","text":"This is similar to force-quitting the browser. To close pages gracefully and ensure you receive page close events, call [`method: BrowserContext.close`] on any `BrowserContext` instances you explicitly created earlier using [`method: Browser.newContext`] **before** calling [`method: Browser.close`]."}]},{"type":"text","text":"The `Browser` object itself is considered to be disposed and cannot be used anymore."}],"required":true,"comment":"In case this browser is obtained using [`method: BrowserType.launch`], closes the browser and all of its pages (if\nany were opened).\n\nIn case this browser is connected to, clears all created contexts belonging to this browser and disconnects from\nthe browser server.\n\n**NOTE** This is similar to force-quitting the browser. To close pages gracefully and ensure you receive page close\nevents, call [`method: BrowserContext.close`] on any `BrowserContext` instances you explicitly created earlier\nusing [`method: Browser.newContext`] **before** calling [`method: Browser.close`].\n\nThe `Browser` object itself is considered to be disposed and cannot be used anymore.","async":true,"alias":"close","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.40","name":"reason","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"The reason to be reported to the operations interrupted by the browser closure."}],"required":false,"comment":"The reason to be reported to the operations interrupted by the browser closure.","async":false,"alias":"reason","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"contexts","type":{"name":"Array","templates":[{"name":"BrowserContext"}],"expression":"[Array]<[BrowserContext]>"},"spec":[{"type":"text","text":"Returns an array of all open browser contexts. In a newly created browser, this will return zero browser contexts."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const browser = await pw.webkit.launch();","console.log(browser.contexts().length); // prints `0`","","const context = await browser.newContext();","console.log(browser.contexts().length); // prints `1`"],"codeLang":"js"},{"type":"code","lines":["Browser browser = pw.webkit().launch();","System.out.println(browser.contexts().size()); // prints \"0\"","BrowserContext context = browser.newContext();","System.out.println(browser.contexts().size()); // prints \"1\""],"codeLang":"java"},{"type":"code","lines":["browser = await pw.webkit.launch()","print(len(browser.contexts)) # prints `0`","context = await browser.new_context()","print(len(browser.contexts)) # prints `1`"],"codeLang":"python async"},{"type":"code","lines":["browser = pw.webkit.launch()","print(len(browser.contexts)) # prints `0`","context = browser.new_context()","print(len(browser.contexts)) # prints `1`"],"codeLang":"python sync"},{"type":"code","lines":["using var playwright = await Playwright.CreateAsync();","var browser = await playwright.Webkit.LaunchAsync();","System.Console.WriteLine(browser.Contexts.Count); // prints \"0\"","var context = await browser.NewContextAsync();","System.Console.WriteLine(browser.Contexts.Count); // prints \"1\""],"codeLang":"csharp"}],"required":true,"comment":"Returns an array of all open browser contexts. In a newly created browser, this will return zero browser contexts.\n\n**Usage**\n\n```js\nconst browser = await pw.webkit.launch();\nconsole.log(browser.contexts().length); // prints `0`\n\nconst context = await browser.newContext();\nconsole.log(browser.contexts().length); // prints `1`\n```\n\n```java\nBrowser browser = pw.webkit().launch();\nSystem.out.println(browser.contexts().size()); // prints \"0\"\nBrowserContext context = browser.newContext();\nSystem.out.println(browser.contexts().size()); // prints \"1\"\n```\n\n```py\nbrowser = await pw.webkit.launch()\nprint(len(browser.contexts)) # prints `0`\ncontext = await browser.new_context()\nprint(len(browser.contexts)) # prints `1`\n```\n\n```py\nbrowser = pw.webkit.launch()\nprint(len(browser.contexts)) # prints `0`\ncontext = browser.new_context()\nprint(len(browser.contexts)) # prints `1`\n```\n\n```csharp\nusing var playwright = await Playwright.CreateAsync();\nvar browser = await playwright.Webkit.LaunchAsync();\nSystem.Console.WriteLine(browser.Contexts.Count); // prints \"0\"\nvar context = await browser.NewContextAsync();\nSystem.Console.WriteLine(browser.Contexts.Count); // prints \"1\"\n```\n","async":false,"alias":"contexts","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"isConnected","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Indicates that the browser is connected."}],"required":true,"comment":"Indicates that the browser is connected.","async":false,"alias":"isConnected","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.11","name":"newBrowserCDPSession","type":{"name":"CDPSession","expression":"[CDPSession]"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"CDP Sessions are only supported on Chromium-based browsers."}]},{"type":"text","text":"Returns the newly created browser session."}],"required":true,"comment":"**NOTE** CDP Sessions are only supported on Chromium-based browsers.\n\nReturns the newly created browser session.","async":true,"alias":"newBrowserCDPSession","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"newContext","type":{"name":"BrowserContext","expression":"[BrowserContext]"},"spec":[{"type":"text","text":"Creates a new browser context. It won't share cookies/cache with other browser contexts."},{"type":"note","noteType":"note","children":[{"type":"text","text":"If directly using this method to create `BrowserContext`s, it is best practice to explicitly close the returned context via [`method: BrowserContext.close`] when your code is done with the `BrowserContext`,↵and before calling [`method: Browser.close`]. This will ensure the `context` is closed gracefully and any artifacts—like HARs and videos—are fully flushed and saved."}]},{"type":"text","text":"**Usage**"},{"type":"code","lines":["(async () => {","  const browser = await playwright.firefox.launch();  // Or 'chromium' or 'webkit'.","  // Create a new incognito browser context.","  const context = await browser.newContext();","  // Create a new page in a pristine context.","  const page = await context.newPage();","  await page.goto('https://example.com');","","  // Gracefully close up everything","  await context.close();","  await browser.close();","})();"],"codeLang":"js"},{"type":"code","lines":["Browser browser = playwright.firefox().launch();  // Or 'chromium' or 'webkit'.","// Create a new incognito browser context.","BrowserContext context = browser.newContext();","// Create a new page in a pristine context.","Page page = context.newPage();","page.navigate(\"https://example.com\");","","// Graceful close up everything","context.close();","browser.close();"],"codeLang":"java"},{"type":"code","lines":["browser = await playwright.firefox.launch() # or \"chromium\" or \"webkit\".","# create a new incognito browser context.","context = await browser.new_context()","# create a new page in a pristine context.","page = await context.new_page()","await page.goto(\"https://example.com\")","","# gracefully close up everything","await context.close()","await browser.close()"],"codeLang":"python async"},{"type":"code","lines":["browser = playwright.firefox.launch() # or \"chromium\" or \"webkit\".","# create a new incognito browser context.","context = browser.new_context()","# create a new page in a pristine context.","page = context.new_page()","page.goto(\"https://example.com\")","","# gracefully close up everything","context.close()","browser.close()"],"codeLang":"python sync"},{"type":"code","lines":["using var playwright = await Playwright.CreateAsync();","var browser = await playwright.Firefox.LaunchAsync();","// Create a new incognito browser context.","var context = await browser.NewContextAsync();","// Create a new page in a pristine context.","var page = await context.NewPageAsync(); ;","await page.GotoAsync(\"https://www.bing.com\");","","// Gracefully close up everything","await context.CloseAsync();","await browser.CloseAsync();"],"codeLang":"csharp"}],"required":true,"comment":"Creates a new browser context. It won't share cookies/cache with other browser contexts.\n\n**NOTE** If directly using this method to create `BrowserContext`s, it is best practice to explicitly close the\nreturned context via [`method: BrowserContext.close`] when your code is done with the `BrowserContext`, and before\ncalling [`method: Browser.close`]. This will ensure the `context` is closed gracefully and any artifacts—like HARs\nand videos—are fully flushed and saved.\n\n**Usage**\n\n```js\n(async () => {\n  const browser = await playwright.firefox.launch();  // Or 'chromium' or 'webkit'.\n  // Create a new incognito browser context.\n  const context = await browser.newContext();\n  // Create a new page in a pristine context.\n  const page = await context.newPage();\n  await page.goto('https://example.com');\n\n  // Gracefully close up everything\n  await context.close();\n  await browser.close();\n})();\n```\n\n```java\nBrowser browser = playwright.firefox().launch();  // Or 'chromium' or 'webkit'.\n// Create a new incognito browser context.\nBrowserContext context = browser.newContext();\n// Create a new page in a pristine context.\nPage page = context.newPage();\npage.navigate(\"https://example.com\");\n\n// Graceful close up everything\ncontext.close();\nbrowser.close();\n```\n\n```py\nbrowser = await playwright.firefox.launch() # or \"chromium\" or \"webkit\".\n# create a new incognito browser context.\ncontext = await browser.new_context()\n# create a new page in a pristine context.\npage = await context.new_page()\nawait page.goto(\"https://example.com\")\n\n# gracefully close up everything\nawait context.close()\nawait browser.close()\n```\n\n```py\nbrowser = playwright.firefox.launch() # or \"chromium\" or \"webkit\".\n# create a new incognito browser context.\ncontext = browser.new_context()\n# create a new page in a pristine context.\npage = context.new_page()\npage.goto(\"https://example.com\")\n\n# gracefully close up everything\ncontext.close()\nbrowser.close()\n```\n\n```csharp\nusing var playwright = await Playwright.CreateAsync();\nvar browser = await playwright.Firefox.LaunchAsync();\n// Create a new incognito browser context.\nvar context = await browser.NewContextAsync();\n// Create a new page in a pristine context.\nvar page = await context.NewPageAsync(); ;\nawait page.GotoAsync(\"https://www.bing.com\");\n\n// Gracefully close up everything\nawait context.CloseAsync();\nawait browser.CloseAsync();\n```\n","async":true,"alias":"newContext","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"acceptDownloads","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted."}],"required":false,"comment":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted.","async":false,"alias":"acceptDownloads","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"baseURL","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`], [`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by using the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the corresponding URL. Unset by default. Examples:"},{"type":"li","text":"baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in `http://localhost:3000/foo/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"}],"required":false,"comment":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`],\n[`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by\nusing the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the\ncorresponding URL. Unset by default. Examples:\n- baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`\n- baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in\n  `http://localhost:3000/foo/bar.html`\n- baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in\n  `http://localhost:3000/bar.html`","async":false,"alias":"baseURL","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypassCSP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`."}],"required":false,"comment":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`.","async":false,"alias":"bypassCSP","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"clientCertificates","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"1.46","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port."}],"required":true,"comment":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port.","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"certPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the certificate in PEM format."}],"required":false,"comment":"Path to the file with the certificate in PEM format.","async":false,"alias":"certPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"cert","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the certificate in PEM format."}],"required":false,"comment":"Direct value of the certificate in PEM format.","async":false,"alias":"cert","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"keyPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the private key in PEM format."}],"required":false,"comment":"Path to the file with the private key in PEM format.","async":false,"alias":"keyPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"key","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the private key in PEM format."}],"required":false,"comment":"Direct value of the private key in PEM format.","async":false,"alias":"key","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfxPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Path to the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfxPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfx","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Direct value of the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfx","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"passphrase","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Passphrase for the private key (PEM or PFX)."}],"required":false,"comment":"Passphrase for the private key (PEM or PFX).","async":false,"alias":"passphrase","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"TLS Client Authentication allows the server to request a client certificate and verify it."},{"type":"text","text":"**Details**"},{"type":"text","text":"An array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`, a single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally, `passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided with an exact match to the request origin that the certificate is valid for."},{"type":"note","noteType":"note","children":[{"type":"text","text":"When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it work by replacing `localhost` with `local.playwright`."}]}],"required":false,"comment":"TLS Client Authentication allows the server to request a client certificate and verify it.\n\n**Details**\n\nAn array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`,\na single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally,\n`passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided\nwith an exact match to the request origin that the certificate is valid for.\n\n**NOTE** When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it\nwork by replacing `localhost` with `local.playwright`.\n","async":false,"alias":"clientCertificates","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"colorScheme","type":{"name":"","union":[{"name":"null"},{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""}]}],"expression":"null|[ColorScheme]<\"light\"|\"dark\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `null` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"colorScheme","type":{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ColorScheme]<\"light\"|\"dark\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `'null'` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"contrast","type":{"name":"","union":[{"name":"null"},{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""}]}],"expression":"null|[Contrast]<\"no-preference\"|\"more\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"contrast","type":{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""},{"name":"\"null\""}],"expression":"[Contrast]<\"no-preference\"|\"more\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"deviceScaleFactor","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about [emulating devices with device scale factor](../emulation.md#devices)."}],"required":false,"comment":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about\n[emulating devices with device scale factor](../emulation.md#devices).","async":false,"alias":"deviceScaleFactor","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"extraHTTPHeaders","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object containing additional HTTP headers to be sent with every request. Defaults to none."}],"required":false,"comment":"An object containing additional HTTP headers to be sent with every request. Defaults to none.","async":false,"alias":"extraHTTPHeaders","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"forcedColors","type":{"name":"","union":[{"name":"null"},{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""}]}],"expression":"null|[ForcedColors]<\"active\"|\"none\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"forcedColors","type":{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""},{"name":"\"null\""}],"expression":"[ForcedColors]<\"active\"|\"none\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"geolocation","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"latitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Latitude between -90 and 90."}],"required":true,"comment":"Latitude between -90 and 90.","async":false,"alias":"latitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"longitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Longitude between -180 and 180."}],"required":true,"comment":"Longitude between -180 and 180.","async":false,"alias":"longitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"accuracy","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Non-negative accuracy value. Defaults to `0`."}],"required":false,"comment":"Non-negative accuracy value. Defaults to `0`.","async":false,"alias":"accuracy","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"geolocation","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"hasTouch","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Specifies if viewport supports touch events. Defaults to false. Learn more about [mobile emulation](../emulation.md#devices)."}],"required":false,"comment":"Specifies if viewport supports touch events. Defaults to false. Learn more about\n[mobile emulation](../emulation.md#devices).","async":false,"alias":"hasTouch","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpCredentials","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"password","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Restrain sending http credentials on specific origin (scheme://host:port)."}],"required":false,"comment":"Restrain sending http credentials on specific origin (scheme://host:port).","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"send","type":{"name":"HttpCredentialsSend","union":[{"name":"\"unauthorized\""},{"name":"\"always\""}],"expression":"[HttpCredentialsSend]<\"unauthorized\"|\"always\">"},"spec":[{"type":"text","text":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests sent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with the each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with `WWW-Authenticate` header is received. Defaults to `'unauthorized'`."}],"required":false,"comment":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests\nsent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with\nthe each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with\n`WWW-Authenticate` header is received. Defaults to `'unauthorized'`.","async":false,"alias":"send","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication).↵If no origin is specified, the username and password are sent to any servers upon unauthorized responses."}],"required":false,"comment":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication). If no\norigin is specified, the username and password are sent to any servers upon unauthorized responses.","async":false,"alias":"httpCredentials","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"isMobile","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device, so you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more about [mobile emulation](../emulation.md#ismobile)."}],"required":false,"comment":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device,\nso you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more\nabout [mobile emulation](../emulation.md#ismobile).","async":false,"alias":"isMobile","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"javaScriptEnabled","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about [disabling JavaScript](../emulation.md#javascript-enabled)."}],"required":false,"comment":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about\n[disabling JavaScript](../emulation.md#javascript-enabled).","async":false,"alias":"javaScriptEnabled","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"locale","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value, `Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default locale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone)."}],"required":false,"comment":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value,\n`Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default\nlocale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone).","async":false,"alias":"locale","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging."}],"required":false,"comment":"Logger sink for Playwright logging.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"noViewport","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Does not enforce fixed viewport, allows resizing window in the headed mode."}],"required":false,"comment":"Does not enforce fixed viewport, allows resizing window in the headed mode.","async":false,"alias":"noViewport","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"offline","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to emulate network being offline. Defaults to `false`. Learn more about [network emulation](../emulation.md#offline)."}],"required":false,"comment":"Whether to emulate network being offline. Defaults to `false`. Learn more about\n[network emulation](../emulation.md#offline).","async":false,"alias":"offline","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"permissions","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"A list of permissions to grant to all pages in this context. See↵[`method: BrowserContext.grantPermissions`] for more details. Defaults to none."}],"required":false,"comment":"A list of permissions to grant to all pages in this context. See [`method: BrowserContext.grantPermissions`] for\nmore details. Defaults to none.","async":false,"alias":"permissions","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"proxy","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"server","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example↵`http://myproxy.com:3128` or `socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy."}],"required":true,"comment":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example `http://myproxy.com:3128` or\n`socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy.","async":false,"alias":"server","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypass","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`."}],"required":false,"comment":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`.","async":false,"alias":"bypass","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional username to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional username to use if HTTP proxy requires authentication.","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional password to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional password to use if HTTP proxy requires authentication.","async":false,"alias":"password","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Network proxy settings to use with this context. Defaults to none."}],"required":false,"comment":"Network proxy settings to use with this context. Defaults to none.","async":false,"alias":"proxy","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"recordHar","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"omitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to↵`false`. Deprecated, use `content` policy instead."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`. Deprecated, use\n`content` policy instead.","async":false,"alias":"omitContent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"content","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is specified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output files and to `embed` for all other file extensions."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is\nspecified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output\nfiles and to `embed` for all other file extensions.","async":false,"alias":"content","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by default."}],"required":true,"comment":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by\ndefault.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"mode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"mode","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"urlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was provided and the passed URL is a path, it gets merged via the [`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none."}],"required":false,"comment":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was\nprovided and the passed URL is a path, it gets merged via the\n[`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none.","async":false,"alias":"urlFilter","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file. If not↵specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be↵saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file.\nIf not specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be\nsaved.","async":false,"alias":"recordHar","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_content"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarContent","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files and all of these files are archived along with the HAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files and all of these files are archived along with the\nHAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification.","async":false,"alias":"recordHarContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_mode"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarMode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"recordHarMode","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_omit_content"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarOmitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`.","async":false,"alias":"recordHarOmitContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_path"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the↵specified HAR file on the filesystem. If not specified, the HAR is not recorded. Make sure to↵call [`method: BrowserContext.close`] for the HAR to be saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the specified HAR file\non the filesystem. If not specified, the HAR is not recorded. Make sure to call [`method: BrowserContext.close`]\nfor the HAR to be saved.","async":false,"alias":"recordHarPath","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_url_filter"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarUrlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[],"required":false,"comment":"","async":false,"alias":"recordHarUrlFilter","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideo","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"dir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the directory to put videos into."}],"required":true,"comment":"Path to the directory to put videos into.","async":false,"alias":"dir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"size","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to\nfit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of\neach page will be scaled down if necessary to fit the specified size.","async":false,"alias":"size","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded. Make↵sure to await [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded.\nMake sure to await [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideo","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_dir"},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideoDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables video recording for all pages into the specified directory. If not specified videos are↵not recorded. Make sure to call [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into the specified directory. If not specified videos are not recorded. Make\nsure to call [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideoDir","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_size"},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to fit into\n800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of each page\nwill be scaled down if necessary to fit the specified size.","async":false,"alias":"recordVideoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"reducedMotion","type":{"name":"","union":[{"name":"null"},{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""}]}],"expression":"null|[ReducedMotion]<\"reduce\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"reducedMotion","type":{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ReducedMotion]<\"reduce\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"aliases":{"java":"screenSize","csharp":"screenSize"},"types":{},"overrides":{}},"since":"v1.8","name":"screen","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the↵`viewport` is set."}],"required":false,"comment":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the\n`viewport` is set.","async":false,"alias":"screen","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"serviceWorkers","type":{"name":"ServiceWorkerPolicy","union":[{"name":"\"allow\""},{"name":"\"block\""}],"expression":"[ServiceWorkerPolicy]<\"allow\"|\"block\">"},"spec":[{"type":"text","text":"Whether to allow sites to register Service workers. Defaults to `'allow'`."},{"type":"li","text":"`'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be registered.","liType":"bullet"},{"type":"li","text":"`'block'`: Playwright will block all registration of Service Workers.","liType":"bullet"}],"required":false,"comment":"Whether to allow sites to register Service workers. Defaults to `'allow'`.\n- `'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be\n  registered.\n- `'block'`: Playwright will block all registration of Service Workers.","async":false,"alias":"serviceWorkers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"storageState","type":{"name":"","union":[{"name":"path"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"cookies","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"domain","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Domain and path are required. For the cookie to apply to all subdomains as well, prefix domain with a dot, like this: \".example.com\""}],"required":true,"comment":"Domain and path are required. For the cookie to apply to all subdomains as well, prefix domain with a dot, like\nthis: \".example.com\"","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Domain and path are required"}],"required":true,"comment":"Domain and path are required","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"expires","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Unix time in seconds."}],"required":true,"comment":"Unix time in seconds.","async":false,"alias":"expires","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"httpOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"secure","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"secure","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"sameSite","type":{"name":"SameSiteAttribute","union":[{"name":"\"Strict\""},{"name":"\"Lax\""},{"name":"\"None\""}],"expression":"[SameSiteAttribute]<\"Strict\"|\"Lax\"|\"None\">"},"spec":[{"type":"text","text":"sameSite flag"}],"required":true,"comment":"sameSite flag","async":false,"alias":"sameSite","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"Cookies to set for context"}],"required":true,"comment":"Cookies to set for context","async":false,"alias":"cookies","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"origins","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"localStorage","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"localStorage to set for context"}],"required":true,"comment":"localStorage to set for context","async":false,"alias":"localStorage","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origins","overloadIndex":0}]}],"expression":"[path]|[Object]"},"spec":[{"type":"text","text":"Learn more about [storage state and auth](../auth.md)."},{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information obtained via [`method: BrowserContext.storageState`]."}],"required":false,"comment":"Learn more about [storage state and auth](../auth.md).\n\nPopulates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`].","async":false,"alias":"storageState","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"storageState","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information↵obtained via [`method: BrowserContext.storageState`]."}],"required":false,"comment":"Populates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`].","async":false,"alias":"storageState","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"storageStatePath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information↵obtained via [`method: BrowserContext.storageState`]. Path to the file with saved storage state."}],"required":false,"comment":"Populates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`]. Path to the file with saved storage state.","async":false,"alias":"storageStatePath","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"strictSelectors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations↵on selectors that imply single target DOM element will throw when more than one element matches the selector.↵This option does not affect any Locator APIs (Locators are always strict). Defaults to `false`.↵See `Locator` to learn more about the strict mode."}],"required":false,"comment":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations on\nselectors that imply single target DOM element will throw when more than one element matches the selector. This\noption does not affect any Locator APIs (Locators are always strict). Defaults to `false`. See `Locator` to learn\nmore about the strict mode.","async":false,"alias":"strictSelectors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"timezoneId","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Changes the timezone of the context. See [ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)↵for a list of supported timezone IDs. Defaults to the system timezone."}],"required":false,"comment":"Changes the timezone of the context. See\n[ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)\nfor a list of supported timezone IDs. Defaults to the system timezone.","async":false,"alias":"timezoneId","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"userAgent","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specific user agent to use in this context."}],"required":false,"comment":"Specific user agent to use in this context.","async":false,"alias":"userAgent","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"Use `recordVideo` instead.","name":"videoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"Use `recordVideo` instead.","name":"videosPath","type":{"name":"path","expression":"[path]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videosPath","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{"java":"viewportSize"},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `null` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `null` value opts out from the default presets, makes viewport depend on the↵host window size defined by the operating system. It makes the execution of the↵tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `null` to disable the consistent\nviewport emulation. Learn more about [viewport emulation](../emulation#viewport).\n\n**NOTE** The `null` value opts out from the default presets, makes viewport depend on the host window size defined\nby the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{"csharp":"viewportSize"},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `ViewportSize.NoViewport` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `ViewportSize.NoViewport` value opts out from the default presets,↵makes viewport depend on the host window size defined by the operating system.↵It makes the execution of the tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `ViewportSize.NoViewport` to\ndisable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport).\n\n**NOTE** The `ViewportSize.NoViewport` value opts out from the default presets, makes viewport depend on the host\nwindow size defined by the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed viewport. Learn more about [viewport emulation](../emulation.md#viewport)."}],"required":false,"comment":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed\nviewport. Learn more about [viewport emulation](../emulation.md#viewport).","async":false,"alias":"viewport","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"newPage","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Creates a new page in a new browser context. Closing this page will close the context as well."},{"type":"text","text":"This is a convenience API that should only be used for the single-page scenarios and short snippets. Production code and↵testing frameworks should explicitly create [`method: Browser.newContext`] followed by the↵[`method: BrowserContext.newPage`] to control their exact life times."}],"required":true,"comment":"Creates a new page in a new browser context. Closing this page will close the context as well.\n\nThis is a convenience API that should only be used for the single-page scenarios and short snippets. Production\ncode and testing frameworks should explicitly create [`method: Browser.newContext`] followed by the\n[`method: BrowserContext.newPage`] to control their exact life times.","async":true,"alias":"newPage","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"acceptDownloads","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted."}],"required":false,"comment":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted.","async":false,"alias":"acceptDownloads","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"baseURL","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`], [`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by using the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the corresponding URL. Unset by default. Examples:"},{"type":"li","text":"baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in `http://localhost:3000/foo/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"}],"required":false,"comment":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`],\n[`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by\nusing the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the\ncorresponding URL. Unset by default. Examples:\n- baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`\n- baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in\n  `http://localhost:3000/foo/bar.html`\n- baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in\n  `http://localhost:3000/bar.html`","async":false,"alias":"baseURL","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypassCSP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`."}],"required":false,"comment":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`.","async":false,"alias":"bypassCSP","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"clientCertificates","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"1.46","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port."}],"required":true,"comment":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port.","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"certPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the certificate in PEM format."}],"required":false,"comment":"Path to the file with the certificate in PEM format.","async":false,"alias":"certPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"cert","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the certificate in PEM format."}],"required":false,"comment":"Direct value of the certificate in PEM format.","async":false,"alias":"cert","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"keyPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the private key in PEM format."}],"required":false,"comment":"Path to the file with the private key in PEM format.","async":false,"alias":"keyPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"key","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the private key in PEM format."}],"required":false,"comment":"Direct value of the private key in PEM format.","async":false,"alias":"key","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfxPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Path to the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfxPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfx","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Direct value of the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfx","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"passphrase","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Passphrase for the private key (PEM or PFX)."}],"required":false,"comment":"Passphrase for the private key (PEM or PFX).","async":false,"alias":"passphrase","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"TLS Client Authentication allows the server to request a client certificate and verify it."},{"type":"text","text":"**Details**"},{"type":"text","text":"An array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`, a single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally, `passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided with an exact match to the request origin that the certificate is valid for."},{"type":"note","noteType":"note","children":[{"type":"text","text":"When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it work by replacing `localhost` with `local.playwright`."}]}],"required":false,"comment":"TLS Client Authentication allows the server to request a client certificate and verify it.\n\n**Details**\n\nAn array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`,\na single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally,\n`passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided\nwith an exact match to the request origin that the certificate is valid for.\n\n**NOTE** When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it\nwork by replacing `localhost` with `local.playwright`.\n","async":false,"alias":"clientCertificates","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"colorScheme","type":{"name":"","union":[{"name":"null"},{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""}]}],"expression":"null|[ColorScheme]<\"light\"|\"dark\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `null` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"colorScheme","type":{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ColorScheme]<\"light\"|\"dark\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `'null'` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"contrast","type":{"name":"","union":[{"name":"null"},{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""}]}],"expression":"null|[Contrast]<\"no-preference\"|\"more\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"contrast","type":{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""},{"name":"\"null\""}],"expression":"[Contrast]<\"no-preference\"|\"more\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"deviceScaleFactor","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about [emulating devices with device scale factor](../emulation.md#devices)."}],"required":false,"comment":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about\n[emulating devices with device scale factor](../emulation.md#devices).","async":false,"alias":"deviceScaleFactor","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"extraHTTPHeaders","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object containing additional HTTP headers to be sent with every request. Defaults to none."}],"required":false,"comment":"An object containing additional HTTP headers to be sent with every request. Defaults to none.","async":false,"alias":"extraHTTPHeaders","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"forcedColors","type":{"name":"","union":[{"name":"null"},{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""}]}],"expression":"null|[ForcedColors]<\"active\"|\"none\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"forcedColors","type":{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""},{"name":"\"null\""}],"expression":"[ForcedColors]<\"active\"|\"none\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"geolocation","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"latitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Latitude between -90 and 90."}],"required":true,"comment":"Latitude between -90 and 90.","async":false,"alias":"latitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"longitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Longitude between -180 and 180."}],"required":true,"comment":"Longitude between -180 and 180.","async":false,"alias":"longitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"accuracy","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Non-negative accuracy value. Defaults to `0`."}],"required":false,"comment":"Non-negative accuracy value. Defaults to `0`.","async":false,"alias":"accuracy","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"geolocation","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"hasTouch","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Specifies if viewport supports touch events. Defaults to false. Learn more about [mobile emulation](../emulation.md#devices)."}],"required":false,"comment":"Specifies if viewport supports touch events. Defaults to false. Learn more about\n[mobile emulation](../emulation.md#devices).","async":false,"alias":"hasTouch","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpCredentials","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"password","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Restrain sending http credentials on specific origin (scheme://host:port)."}],"required":false,"comment":"Restrain sending http credentials on specific origin (scheme://host:port).","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"send","type":{"name":"HttpCredentialsSend","union":[{"name":"\"unauthorized\""},{"name":"\"always\""}],"expression":"[HttpCredentialsSend]<\"unauthorized\"|\"always\">"},"spec":[{"type":"text","text":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests sent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with the each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with `WWW-Authenticate` header is received. Defaults to `'unauthorized'`."}],"required":false,"comment":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests\nsent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with\nthe each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with\n`WWW-Authenticate` header is received. Defaults to `'unauthorized'`.","async":false,"alias":"send","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication).↵If no origin is specified, the username and password are sent to any servers upon unauthorized responses."}],"required":false,"comment":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication). If no\norigin is specified, the username and password are sent to any servers upon unauthorized responses.","async":false,"alias":"httpCredentials","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"isMobile","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device, so you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more about [mobile emulation](../emulation.md#ismobile)."}],"required":false,"comment":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device,\nso you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more\nabout [mobile emulation](../emulation.md#ismobile).","async":false,"alias":"isMobile","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"javaScriptEnabled","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about [disabling JavaScript](../emulation.md#javascript-enabled)."}],"required":false,"comment":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about\n[disabling JavaScript](../emulation.md#javascript-enabled).","async":false,"alias":"javaScriptEnabled","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"locale","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value, `Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default locale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone)."}],"required":false,"comment":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value,\n`Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default\nlocale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone).","async":false,"alias":"locale","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging."}],"required":false,"comment":"Logger sink for Playwright logging.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"noViewport","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Does not enforce fixed viewport, allows resizing window in the headed mode."}],"required":false,"comment":"Does not enforce fixed viewport, allows resizing window in the headed mode.","async":false,"alias":"noViewport","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"offline","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to emulate network being offline. Defaults to `false`. Learn more about [network emulation](../emulation.md#offline)."}],"required":false,"comment":"Whether to emulate network being offline. Defaults to `false`. Learn more about\n[network emulation](../emulation.md#offline).","async":false,"alias":"offline","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"permissions","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"A list of permissions to grant to all pages in this context. See↵[`method: BrowserContext.grantPermissions`] for more details. Defaults to none."}],"required":false,"comment":"A list of permissions to grant to all pages in this context. See [`method: BrowserContext.grantPermissions`] for\nmore details. Defaults to none.","async":false,"alias":"permissions","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"proxy","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"server","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example↵`http://myproxy.com:3128` or `socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy."}],"required":true,"comment":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example `http://myproxy.com:3128` or\n`socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy.","async":false,"alias":"server","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypass","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`."}],"required":false,"comment":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`.","async":false,"alias":"bypass","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional username to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional username to use if HTTP proxy requires authentication.","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional password to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional password to use if HTTP proxy requires authentication.","async":false,"alias":"password","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Network proxy settings to use with this context. Defaults to none."}],"required":false,"comment":"Network proxy settings to use with this context. Defaults to none.","async":false,"alias":"proxy","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"recordHar","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"omitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to↵`false`. Deprecated, use `content` policy instead."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`. Deprecated, use\n`content` policy instead.","async":false,"alias":"omitContent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"content","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is specified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output files and to `embed` for all other file extensions."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is\nspecified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output\nfiles and to `embed` for all other file extensions.","async":false,"alias":"content","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by default."}],"required":true,"comment":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by\ndefault.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"mode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"mode","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"urlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was provided and the passed URL is a path, it gets merged via the [`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none."}],"required":false,"comment":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was\nprovided and the passed URL is a path, it gets merged via the\n[`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none.","async":false,"alias":"urlFilter","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file. If not↵specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be↵saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file.\nIf not specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be\nsaved.","async":false,"alias":"recordHar","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_content"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarContent","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files and all of these files are archived along with the HAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files and all of these files are archived along with the\nHAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification.","async":false,"alias":"recordHarContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_mode"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarMode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"recordHarMode","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_omit_content"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarOmitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`.","async":false,"alias":"recordHarOmitContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_path"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the↵specified HAR file on the filesystem. If not specified, the HAR is not recorded. Make sure to↵call [`method: BrowserContext.close`] for the HAR to be saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the specified HAR file\non the filesystem. If not specified, the HAR is not recorded. Make sure to call [`method: BrowserContext.close`]\nfor the HAR to be saved.","async":false,"alias":"recordHarPath","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_url_filter"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarUrlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[],"required":false,"comment":"","async":false,"alias":"recordHarUrlFilter","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideo","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"dir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the directory to put videos into."}],"required":true,"comment":"Path to the directory to put videos into.","async":false,"alias":"dir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"size","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to\nfit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of\neach page will be scaled down if necessary to fit the specified size.","async":false,"alias":"size","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded. Make↵sure to await [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded.\nMake sure to await [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideo","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_dir"},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideoDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables video recording for all pages into the specified directory. If not specified videos are↵not recorded. Make sure to call [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into the specified directory. If not specified videos are not recorded. Make\nsure to call [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideoDir","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_size"},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to fit into\n800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of each page\nwill be scaled down if necessary to fit the specified size.","async":false,"alias":"recordVideoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"reducedMotion","type":{"name":"","union":[{"name":"null"},{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""}]}],"expression":"null|[ReducedMotion]<\"reduce\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"reducedMotion","type":{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ReducedMotion]<\"reduce\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"aliases":{"java":"screenSize","csharp":"screenSize"},"types":{},"overrides":{}},"since":"v1.8","name":"screen","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the↵`viewport` is set."}],"required":false,"comment":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the\n`viewport` is set.","async":false,"alias":"screen","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"serviceWorkers","type":{"name":"ServiceWorkerPolicy","union":[{"name":"\"allow\""},{"name":"\"block\""}],"expression":"[ServiceWorkerPolicy]<\"allow\"|\"block\">"},"spec":[{"type":"text","text":"Whether to allow sites to register Service workers. Defaults to `'allow'`."},{"type":"li","text":"`'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be registered.","liType":"bullet"},{"type":"li","text":"`'block'`: Playwright will block all registration of Service Workers.","liType":"bullet"}],"required":false,"comment":"Whether to allow sites to register Service workers. Defaults to `'allow'`.\n- `'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be\n  registered.\n- `'block'`: Playwright will block all registration of Service Workers.","async":false,"alias":"serviceWorkers","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"storageState","type":{"name":"","union":[{"name":"path"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"cookies","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"domain","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Domain and path are required. For the cookie to apply to all subdomains as well, prefix domain with a dot, like this: \".example.com\""}],"required":true,"comment":"Domain and path are required. For the cookie to apply to all subdomains as well, prefix domain with a dot, like\nthis: \".example.com\"","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Domain and path are required"}],"required":true,"comment":"Domain and path are required","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"expires","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Unix time in seconds."}],"required":true,"comment":"Unix time in seconds.","async":false,"alias":"expires","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"httpOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"secure","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"secure","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"sameSite","type":{"name":"SameSiteAttribute","union":[{"name":"\"Strict\""},{"name":"\"Lax\""},{"name":"\"None\""}],"expression":"[SameSiteAttribute]<\"Strict\"|\"Lax\"|\"None\">"},"spec":[{"type":"text","text":"sameSite flag"}],"required":true,"comment":"sameSite flag","async":false,"alias":"sameSite","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"Cookies to set for context"}],"required":true,"comment":"Cookies to set for context","async":false,"alias":"cookies","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"origins","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"localStorage","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"localStorage to set for context"}],"required":true,"comment":"localStorage to set for context","async":false,"alias":"localStorage","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origins","overloadIndex":0}]}],"expression":"[path]|[Object]"},"spec":[{"type":"text","text":"Learn more about [storage state and auth](../auth.md)."},{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information obtained via [`method: BrowserContext.storageState`]."}],"required":false,"comment":"Learn more about [storage state and auth](../auth.md).\n\nPopulates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`].","async":false,"alias":"storageState","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"storageState","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information↵obtained via [`method: BrowserContext.storageState`]."}],"required":false,"comment":"Populates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`].","async":false,"alias":"storageState","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"storageStatePath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Populates context with given storage state. This option can be used to initialize context with logged-in information↵obtained via [`method: BrowserContext.storageState`]. Path to the file with saved storage state."}],"required":false,"comment":"Populates context with given storage state. This option can be used to initialize context with logged-in\ninformation obtained via [`method: BrowserContext.storageState`]. Path to the file with saved storage state.","async":false,"alias":"storageStatePath","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"strictSelectors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations↵on selectors that imply single target DOM element will throw when more than one element matches the selector.↵This option does not affect any Locator APIs (Locators are always strict). Defaults to `false`.↵See `Locator` to learn more about the strict mode."}],"required":false,"comment":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations on\nselectors that imply single target DOM element will throw when more than one element matches the selector. This\noption does not affect any Locator APIs (Locators are always strict). Defaults to `false`. See `Locator` to learn\nmore about the strict mode.","async":false,"alias":"strictSelectors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"timezoneId","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Changes the timezone of the context. See [ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)↵for a list of supported timezone IDs. Defaults to the system timezone."}],"required":false,"comment":"Changes the timezone of the context. See\n[ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)\nfor a list of supported timezone IDs. Defaults to the system timezone.","async":false,"alias":"timezoneId","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"userAgent","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specific user agent to use in this context."}],"required":false,"comment":"Specific user agent to use in this context.","async":false,"alias":"userAgent","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"Use `recordVideo` instead.","name":"videoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"Use `recordVideo` instead.","name":"videosPath","type":{"name":"path","expression":"[path]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videosPath","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{"java":"viewportSize"},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `null` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `null` value opts out from the default presets, makes viewport depend on the↵host window size defined by the operating system. It makes the execution of the↵tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `null` to disable the consistent\nviewport emulation. Learn more about [viewport emulation](../emulation#viewport).\n\n**NOTE** The `null` value opts out from the default presets, makes viewport depend on the host window size defined\nby the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{"csharp":"viewportSize"},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `ViewportSize.NoViewport` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `ViewportSize.NoViewport` value opts out from the default presets,↵makes viewport depend on the host window size defined by the operating system.↵It makes the execution of the tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `ViewportSize.NoViewport` to\ndisable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport).\n\n**NOTE** The `ViewportSize.NoViewport` value opts out from the default presets, makes viewport depend on the host\nwindow size defined by the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed viewport. Learn more about [viewport emulation](../emulation.md#viewport)."}],"required":false,"comment":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed\nviewport. Learn more about [viewport emulation](../emulation.md#viewport).","async":false,"alias":"viewport","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"removeAllListeners","type":{"name":"void"},"spec":[{"type":"text","text":"Removes all the listeners of the given type (or all registered listeners if no type given).↵Allows to wait for async listeners to complete or to ignore subsequent errors from these listeners."}],"required":true,"comment":"Removes all the listeners of the given type (or all registered listeners if no type given). Allows to wait for\nasync listeners to complete or to ignore subsequent errors from these listeners.","async":true,"alias":"removeAllListeners","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.47","name":"type","type":{"name":"string","expression":"[string]"},"spec":[],"required":false,"comment":"","async":false,"alias":"type","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.47","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"behavior","type":{"name":"RemoveAllListenersBehavior","union":[{"name":"\"wait\""},{"name":"\"ignoreErrors\""},{"name":"\"default\""}],"expression":"[RemoveAllListenersBehavior]<\"wait\"|\"ignoreErrors\"|\"default\">"},"spec":[{"type":"text","text":"Specifies whether to wait for already running listeners and what to do if they throw errors:"},{"type":"li","text":"`'default'` - do not wait for current listener calls (if any) to finish, if the listener throws, it may result in unhandled error","liType":"bullet"},{"type":"li","text":"`'wait'` - wait for current listener calls (if any) to finish","liType":"bullet"},{"type":"li","text":"`'ignoreErrors'` - do not wait for current listener calls (if any) to finish, all errors thrown by the listeners after removal are silently caught","liType":"bullet"}],"required":false,"comment":"Specifies whether to wait for already running listeners and what to do if they throw errors:\n- `'default'` - do not wait for current listener calls (if any) to finish, if the listener throws, it may result\n  in unhandled error\n- `'wait'` - wait for current listener calls (if any) to finish\n- `'ignoreErrors'` - do not wait for current listener calls (if any) to finish, all errors thrown by the\n  listeners after removal are silently caught","async":false,"alias":"behavior","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"only":["java","js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.11","name":"startTracing","type":{"name":"void"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"This API controls [Chromium Tracing](https://www.chromium.org/developers/how-tos/trace-event-profiling-tool) which is a low-level chromium-specific debugging tool. API to control [Playwright Tracing](../trace-viewer) could be found [here](./class-tracing)."}]},{"type":"text","text":"You can use [`method: Browser.startTracing`] and [`method: Browser.stopTracing`] to create a trace file that can↵be opened in Chrome DevTools performance panel."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await browser.startTracing(page, { path: 'trace.json' });","await page.goto('https://www.google.com');","await browser.stopTracing();"],"codeLang":"js"},{"type":"code","lines":["browser.startTracing(page, new Browser.StartTracingOptions()","  .setPath(Paths.get(\"trace.json\")));","page.navigate(\"https://www.google.com\");","browser.stopTracing();"],"codeLang":"java"},{"type":"code","lines":["await browser.start_tracing(page, path=\"trace.json\")","await page.goto(\"https://www.google.com\")","await browser.stop_tracing()"],"codeLang":"python async"},{"type":"code","lines":["browser.start_tracing(page, path=\"trace.json\")","page.goto(\"https://www.google.com\")","browser.stop_tracing()"],"codeLang":"python sync"}],"required":true,"comment":"**NOTE** This API controls\n[Chromium Tracing](https://www.chromium.org/developers/how-tos/trace-event-profiling-tool) which is a low-level\nchromium-specific debugging tool. API to control [Playwright Tracing](../trace-viewer) could be found\n[here](./class-tracing).\n\nYou can use [`method: Browser.startTracing`] and [`method: Browser.stopTracing`] to create a trace file that can be\nopened in Chrome DevTools performance panel.\n\n**Usage**\n\n```js\nawait browser.startTracing(page, { path: 'trace.json' });\nawait page.goto('https://www.google.com');\nawait browser.stopTracing();\n```\n\n```java\nbrowser.startTracing(page, new Browser.StartTracingOptions()\n  .setPath(Paths.get(\"trace.json\")));\npage.navigate(\"https://www.google.com\");\nbrowser.stopTracing();\n```\n\n```py\nawait browser.start_tracing(page, path=\"trace.json\")\nawait page.goto(\"https://www.google.com\")\nawait browser.stop_tracing()\n```\n\n```py\nbrowser.start_tracing(page, path=\"trace.json\")\npage.goto(\"https://www.google.com\")\nbrowser.stop_tracing()\n```\n","async":true,"alias":"startTracing","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.11","name":"page","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Optional, if specified, tracing includes screenshots of the given page."}],"required":false,"comment":"Optional, if specified, tracing includes screenshots of the given page.","async":false,"alias":"page","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"categories","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"specify custom categories to use instead of default."}],"required":false,"comment":"specify custom categories to use instead of default.","async":false,"alias":"categories","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"A path to write the trace file to."}],"required":false,"comment":"A path to write the trace file to.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"screenshots","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"captures screenshots in the trace."}],"required":false,"comment":"captures screenshots in the trace.","async":false,"alias":"screenshots","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"only":["java","js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.11","name":"stopTracing","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"This API controls [Chromium Tracing](https://www.chromium.org/developers/how-tos/trace-event-profiling-tool) which is a low-level chromium-specific debugging tool. API to control [Playwright Tracing](../trace-viewer) could be found [here](./class-tracing)."}]},{"type":"text","text":"Returns the buffer with trace data."}],"required":true,"comment":"**NOTE** This API controls\n[Chromium Tracing](https://www.chromium.org/developers/how-tos/trace-event-profiling-tool) which is a low-level\nchromium-specific debugging tool. API to control [Playwright Tracing](../trace-viewer) could be found\n[here](./class-tracing).\n\nReturns the buffer with trace data.","async":true,"alias":"stopTracing","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"version","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns the browser version."}],"required":true,"comment":"Returns the browser version.","async":false,"alias":"version","overloadIndex":0,"args":[]}]},{"name":"BrowserContext","spec":[{"type":"text","text":"BrowserContexts provide a way to operate multiple independent browser sessions."},{"type":"text","text":"If a page opens another page, e.g. with a `window.open` call, the popup will belong to the parent page's browser↵context."},{"type":"text","text":"Playwright allows creating isolated non-persistent browser contexts with [`method: Browser.newContext`] method. Non-persistent browser↵contexts don't write any browsing data to disk."},{"type":"code","lines":["// Create a new incognito browser context","const context = await browser.newContext();","// Create a new page inside context.","const page = await context.newPage();","await page.goto('https://example.com');","// Dispose context once it's no longer needed.","await context.close();"],"codeLang":"js"},{"type":"code","lines":["// Create a new incognito browser context","BrowserContext context = browser.newContext();","// Create a new page inside context.","Page page = context.newPage();","page.navigate(\"https://example.com\");","// Dispose context once it is no longer needed.","context.close();"],"codeLang":"java"},{"type":"code","lines":["# create a new incognito browser context","context = await browser.new_context()","# create a new page inside context.","page = await context.new_page()","await page.goto(\"https://example.com\")","# dispose context once it is no longer needed.","await context.close()"],"codeLang":"python async"},{"type":"code","lines":["# create a new incognito browser context","context = browser.new_context()","# create a new page inside context.","page = context.new_page()","page.goto(\"https://example.com\")","# dispose context once it is no longer needed.","context.close()"],"codeLang":"python sync"},{"type":"code","lines":["using var playwright = await Playwright.CreateAsync();","var browser = await playwright.Firefox.LaunchAsync(new() { Headless = false });","// Create a new incognito browser context","var context = await browser.NewContextAsync();","// Create a new page inside context.","var page = await context.NewPageAsync();","await page.GotoAsync(\"https://bing.com\");","// Dispose context once it is no longer needed.","await context.CloseAsync();"],"codeLang":"csharp"}],"langs":{},"comment":"BrowserContexts provide a way to operate multiple independent browser sessions.\n\nIf a page opens another page, e.g. with a `window.open` call, the popup will belong to the parent page's browser\ncontext.\n\nPlaywright allows creating isolated non-persistent browser contexts with [`method: Browser.newContext`] method.\nNon-persistent browser contexts don't write any browsing data to disk.\n\n```js\n// Create a new incognito browser context\nconst context = await browser.newContext();\n// Create a new page inside context.\nconst page = await context.newPage();\nawait page.goto('https://example.com');\n// Dispose context once it's no longer needed.\nawait context.close();\n```\n\n```java\n// Create a new incognito browser context\nBrowserContext context = browser.newContext();\n// Create a new page inside context.\nPage page = context.newPage();\npage.navigate(\"https://example.com\");\n// Dispose context once it is no longer needed.\ncontext.close();\n```\n\n```py\n# create a new incognito browser context\ncontext = await browser.new_context()\n# create a new page inside context.\npage = await context.new_page()\nawait page.goto(\"https://example.com\")\n# dispose context once it is no longer needed.\nawait context.close()\n```\n\n```py\n# create a new incognito browser context\ncontext = browser.new_context()\n# create a new page inside context.\npage = context.new_page()\npage.goto(\"https://example.com\")\n# dispose context once it is no longer needed.\ncontext.close()\n```\n\n```csharp\nusing var playwright = await Playwright.CreateAsync();\nvar browser = await playwright.Firefox.LaunchAsync(new() { Headless = false });\n// Create a new incognito browser context\nvar context = await browser.NewContextAsync();\n// Create a new page inside context.\nvar page = await context.NewPageAsync();\nawait page.GotoAsync(\"https://bing.com\");\n// Dispose context once it is no longer needed.\nawait context.CloseAsync();\n```\n","since":"v1.8","members":[{"kind":"event","langs":{},"since":"v1.11","name":"backgroundPage","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"Only works with Chromium browser's persistent context."}]},{"type":"text","text":"Emitted when new background page is created in the context."},{"type":"code","lines":["context.onBackgroundPage(backgroundPage -> {","  System.out.println(backgroundPage.url());","});"],"codeLang":"java"},{"type":"code","lines":["const backgroundPage = await context.waitForEvent('backgroundpage');"],"codeLang":"js"},{"type":"code","lines":["background_page = await context.wait_for_event(\"backgroundpage\")"],"codeLang":"python async"},{"type":"code","lines":["background_page = context.wait_for_event(\"backgroundpage\")"],"codeLang":"python sync"},{"type":"code","lines":["context.BackgroundPage += (_, backgroundPage) =>","{","    Console.WriteLine(backgroundPage.Url);","};",""],"codeLang":"csharp"}],"required":true,"comment":"**NOTE** Only works with Chromium browser's persistent context.\n\nEmitted when new background page is created in the context.\n\n```java\ncontext.onBackgroundPage(backgroundPage -> {\n  System.out.println(backgroundPage.url());\n});\n```\n\n```js\nconst backgroundPage = await context.waitForEvent('backgroundpage');\n```\n\n```py\nbackground_page = await context.wait_for_event(\"backgroundpage\")\n```\n\n```py\nbackground_page = context.wait_for_event(\"backgroundpage\")\n```\n\n```csharp\ncontext.BackgroundPage += (_, backgroundPage) =>\n{\n    Console.WriteLine(backgroundPage.Url);\n};\n\n```\n","async":false,"alias":"backgroundPage","overloadIndex":0,"args":[]},{"kind":"property","langs":{},"since":"v1.45","name":"clock","type":{"name":"Clock","expression":"[Clock]"},"spec":[{"type":"text","text":"Playwright has ability to mock clock and passage of time."}],"required":true,"comment":"Playwright has ability to mock clock and passage of time.","async":false,"alias":"clock","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.8","name":"close","type":{"name":"BrowserContext","expression":"[BrowserContext]"},"spec":[{"type":"text","text":"Emitted when Browser context gets closed. This might happen because of one of the following:"},{"type":"li","text":"Browser context is closed.","liType":"bullet"},{"type":"li","text":"Browser application is closed or crashed.","liType":"bullet"},{"type":"li","text":"The [`method: Browser.close`] method was called.","liType":"bullet"}],"required":true,"comment":"Emitted when Browser context gets closed. This might happen because of one of the following:\n- Browser context is closed.\n- Browser application is closed or crashed.\n- The [`method: Browser.close`] method was called.","async":false,"alias":"close","overloadIndex":0,"args":[]},{"kind":"event","langs":{"aliases":{"java":"consoleMessage"},"types":{},"overrides":{}},"since":"v1.34","name":"console","type":{"name":"ConsoleMessage","expression":"[ConsoleMessage]"},"spec":[{"type":"text","text":"Emitted when JavaScript within the page calls one of console API methods, e.g. `console.log` or `console.dir`."},{"type":"text","text":"The arguments passed into `console.log` and the page are available on the `ConsoleMessage` event handler argument."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["context.on('console', async msg => {","  const values = [];","  for (const arg of msg.args())","    values.push(await arg.jsonValue());","  console.log(...values);","});","await page.evaluate(() => console.log('hello', 5, { foo: 'bar' }));"],"codeLang":"js"},{"type":"code","lines":["context.onConsoleMessage(msg -> {","  for (int i = 0; i < msg.args().size(); ++i)","    System.out.println(i + \": \" + msg.args().get(i).jsonValue());","});","page.evaluate(\"() => console.log('hello', 5, { foo: 'bar' })\");"],"codeLang":"java"},{"type":"code","lines":["async def print_args(msg):","    values = []","    for arg in msg.args:","        values.append(await arg.json_value())","    print(values)","","context.on(\"console\", print_args)","await page.evaluate(\"console.log('hello', 5, { foo: 'bar' })\")"],"codeLang":"python async"},{"type":"code","lines":["def print_args(msg):","    for arg in msg.args:","        print(arg.json_value())","","context.on(\"console\", print_args)","page.evaluate(\"console.log('hello', 5, { foo: 'bar' })\")"],"codeLang":"python sync"},{"type":"code","lines":["context.Console += async (_, msg) =>","{","    foreach (var arg in msg.Args)","        Console.WriteLine(await arg.JsonValueAsync<object>());","};","","await page.EvaluateAsync(\"console.log('hello', 5, { foo: 'bar' })\");"],"codeLang":"csharp"}],"required":true,"comment":"Emitted when JavaScript within the page calls one of console API methods, e.g. `console.log` or `console.dir`.\n\nThe arguments passed into `console.log` and the page are available on the `ConsoleMessage` event handler argument.\n\n**Usage**\n\n```js\ncontext.on('console', async msg => {\n  const values = [];\n  for (const arg of msg.args())\n    values.push(await arg.jsonValue());\n  console.log(...values);\n});\nawait page.evaluate(() => console.log('hello', 5, { foo: 'bar' }));\n```\n\n```java\ncontext.onConsoleMessage(msg -> {\n  for (int i = 0; i < msg.args().size(); ++i)\n    System.out.println(i + \": \" + msg.args().get(i).jsonValue());\n});\npage.evaluate(\"() => console.log('hello', 5, { foo: 'bar' })\");\n```\n\n```py\nasync def print_args(msg):\n    values = []\n    for arg in msg.args:\n        values.append(await arg.json_value())\n    print(values)\n\ncontext.on(\"console\", print_args)\nawait page.evaluate(\"console.log('hello', 5, { foo: 'bar' })\")\n```\n\n```py\ndef print_args(msg):\n    for arg in msg.args:\n        print(arg.json_value())\n\ncontext.on(\"console\", print_args)\npage.evaluate(\"console.log('hello', 5, { foo: 'bar' })\")\n```\n\n```csharp\ncontext.Console += async (_, msg) =>\n{\n    foreach (var arg in msg.Args)\n        Console.WriteLine(await arg.JsonValueAsync<object>());\n};\n\nawait page.EvaluateAsync(\"console.log('hello', 5, { foo: 'bar' })\");\n```\n","async":false,"alias":"console","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.34","name":"dialog","type":{"name":"Dialog","expression":"[Dialog]"},"spec":[{"type":"text","text":"Emitted when a JavaScript dialog appears, such as `alert`, `prompt`, `confirm` or `beforeunload`. Listener **must** either [`method: Dialog.accept`] or [`method: Dialog.dismiss`] the dialog - otherwise the page will [freeze](https://developer.mozilla.org/en-US/docs/Web/JavaScript/EventLoop#never_blocking) waiting for the dialog, and actions like click will never finish."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["context.on('dialog', dialog => {","  dialog.accept();","});"],"codeLang":"js"},{"type":"code","lines":["context.onDialog(dialog -> {","  dialog.accept();","});"],"codeLang":"java"},{"type":"code","lines":["context.on(\"dialog\", lambda dialog: dialog.accept())"],"codeLang":"python"},{"type":"code","lines":["Context.Dialog += async (_, dialog) =>","{","    await dialog.AcceptAsync();","};"],"codeLang":"csharp"},{"type":"note","noteType":"note","children":[{"type":"text","text":"When no [`event: Page.dialog`] or [`event: BrowserContext.dialog`] listeners are present, all dialogs are automatically dismissed."}]}],"required":true,"comment":"Emitted when a JavaScript dialog appears, such as `alert`, `prompt`, `confirm` or `beforeunload`. Listener **must**\neither [`method: Dialog.accept`] or [`method: Dialog.dismiss`] the dialog - otherwise the page will\n[freeze](https://developer.mozilla.org/en-US/docs/Web/JavaScript/EventLoop#never_blocking) waiting for the dialog,\nand actions like click will never finish.\n\n**Usage**\n\n```js\ncontext.on('dialog', dialog => {\n  dialog.accept();\n});\n```\n\n```java\ncontext.onDialog(dialog -> {\n  dialog.accept();\n});\n```\n\n```python\ncontext.on(\"dialog\", lambda dialog: dialog.accept())\n```\n\n```csharp\nContext.Dialog += async (_, dialog) =>\n{\n    await dialog.AcceptAsync();\n};\n```\n\n**NOTE** When no [`event: Page.dialog`] or [`event: BrowserContext.dialog`] listeners are present, all dialogs are\nautomatically dismissed.\n","async":false,"alias":"dialog","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.8","name":"page","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"The event is emitted when a new Page is created in the BrowserContext. The page may still be loading. The event will↵also fire for popup pages. See also [`event: Page.popup`] to receive events about popups relevant to a specific page."},{"type":"text","text":"The earliest moment that page is available is when it has navigated to the initial url. For example, when opening a↵popup with `window.open('http://example.com')`, this event will fire when the network request to \"http://example.com\" is↵done and its response has started loading in the popup. If you would like to route/listen to this network request, use [`method: BrowserContext.route`] and [`event: BrowserContext.request`] respectively instead of similar methods on the `Page`."},{"type":"code","lines":["const newPagePromise = context.waitForEvent('page');","await page.getByText('open new page').click();","const newPage = await newPagePromise;","console.log(await newPage.evaluate('location.href'));"],"codeLang":"js"},{"type":"code","lines":["Page newPage = context.waitForPage(() -> {","  page.getByText(\"open new page\").click();","});","System.out.println(newPage.evaluate(\"location.href\"));"],"codeLang":"java"},{"type":"code","lines":["async with context.expect_page() as page_info:","    await page.get_by_text(\"open new page\").click(),","page = await page_info.value","print(await page.evaluate(\"location.href\"))"],"codeLang":"python async"},{"type":"code","lines":["with context.expect_page() as page_info:","    page.get_by_text(\"open new page\").click(),","page = page_info.value","print(page.evaluate(\"location.href\"))"],"codeLang":"python sync"},{"type":"code","lines":["var popup = await context.RunAndWaitForPageAsync(async =>","{","    await page.GetByText(\"open new page\").ClickAsync();","});","Console.WriteLine(await popup.EvaluateAsync<string>(\"location.href\"));"],"codeLang":"csharp"},{"type":"note","noteType":"note","children":[{"type":"text","text":"Use [`method: Page.waitForLoadState`] to wait until the page gets to a particular state (you should not need it in most↵cases)."}]}],"required":true,"comment":"The event is emitted when a new Page is created in the BrowserContext. The page may still be loading. The event\nwill also fire for popup pages. See also [`event: Page.popup`] to receive events about popups relevant to a\nspecific page.\n\nThe earliest moment that page is available is when it has navigated to the initial url. For example, when opening a\npopup with `window.open('http://example.com')`, this event will fire when the network request to\n\"http://example.com\" is done and its response has started loading in the popup. If you would like to route/listen\nto this network request, use [`method: BrowserContext.route`] and [`event: BrowserContext.request`] respectively\ninstead of similar methods on the `Page`.\n\n```js\nconst newPagePromise = context.waitForEvent('page');\nawait page.getByText('open new page').click();\nconst newPage = await newPagePromise;\nconsole.log(await newPage.evaluate('location.href'));\n```\n\n```java\nPage newPage = context.waitForPage(() -> {\n  page.getByText(\"open new page\").click();\n});\nSystem.out.println(newPage.evaluate(\"location.href\"));\n```\n\n```py\nasync with context.expect_page() as page_info:\n    await page.get_by_text(\"open new page\").click(),\npage = await page_info.value\nprint(await page.evaluate(\"location.href\"))\n```\n\n```py\nwith context.expect_page() as page_info:\n    page.get_by_text(\"open new page\").click(),\npage = page_info.value\nprint(page.evaluate(\"location.href\"))\n```\n\n```csharp\nvar popup = await context.RunAndWaitForPageAsync(async =>\n{\n    await page.GetByText(\"open new page\").ClickAsync();\n});\nConsole.WriteLine(await popup.EvaluateAsync<string>(\"location.href\"));\n```\n\n**NOTE** Use [`method: Page.waitForLoadState`] to wait until the page gets to a particular state (you should not\nneed it in most cases).\n","async":false,"alias":"page","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.38","name":"webError","type":{"name":"WebError","expression":"[WebError]"},"spec":[{"type":"text","text":"Emitted when exception is unhandled in any of the pages in this↵context. To listen for errors from a particular page, use [`event: Page.pageError`] instead."}],"required":true,"comment":"Emitted when exception is unhandled in any of the pages in this context. To listen for errors from a particular\npage, use [`event: Page.pageError`] instead.","async":false,"alias":"webError","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.12","name":"request","type":{"name":"Request","expression":"[Request]"},"spec":[{"type":"text","text":"Emitted when a request is issued from any pages created through this context.↵The [request] object is read-only. To only listen for requests from a particular↵page, use [`event: Page.request`]."},{"type":"text","text":"In order to intercept and mutate requests, see [`method: BrowserContext.route`]↵or [`method: Page.route`]."}],"required":true,"comment":"Emitted when a request is issued from any pages created through this context. The [request] object is read-only. To\nonly listen for requests from a particular page, use [`event: Page.request`].\n\nIn order to intercept and mutate requests, see [`method: BrowserContext.route`] or [`method: Page.route`].","async":false,"alias":"request","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.12","name":"requestFailed","type":{"name":"Request","expression":"[Request]"},"spec":[{"type":"text","text":"Emitted when a request fails, for example by timing out. To only listen for↵failed requests from a particular page, use [`event: Page.requestFailed`]."},{"type":"note","noteType":"note","children":[{"type":"text","text":"HTTP Error responses, such as 404 or 503, are still successful responses from HTTP standpoint, so request will complete↵with [`event: BrowserContext.requestFinished`] event and not with [`event: BrowserContext.requestFailed`]."}]}],"required":true,"comment":"Emitted when a request fails, for example by timing out. To only listen for failed requests from a particular page,\nuse [`event: Page.requestFailed`].\n\n**NOTE** HTTP Error responses, such as 404 or 503, are still successful responses from HTTP standpoint, so request\nwill complete with [`event: BrowserContext.requestFinished`] event and not with\n[`event: BrowserContext.requestFailed`].\n","async":false,"alias":"requestFailed","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.12","name":"requestFinished","type":{"name":"Request","expression":"[Request]"},"spec":[{"type":"text","text":"Emitted when a request finishes successfully after downloading the response body. For a successful response, the↵sequence of events is `request`, `response` and `requestfinished`. To listen for↵successful requests from a particular page, use [`event: Page.requestFinished`]."}],"required":true,"comment":"Emitted when a request finishes successfully after downloading the response body. For a successful response, the\nsequence of events is `request`, `response` and `requestfinished`. To listen for successful requests from a\nparticular page, use [`event: Page.requestFinished`].","async":false,"alias":"requestFinished","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.12","name":"response","type":{"name":"Response","expression":"[Response]"},"spec":[{"type":"text","text":"Emitted when [response] status and headers are received for a request. For a successful response, the sequence of events↵is `request`, `response` and `requestfinished`. To listen for response events↵from a particular page, use [`event: Page.response`]."}],"required":true,"comment":"Emitted when [response] status and headers are received for a request. For a successful response, the sequence of\nevents is `request`, `response` and `requestfinished`. To listen for response events from a particular page, use\n[`event: Page.response`].","async":false,"alias":"response","overloadIndex":0,"args":[]},{"kind":"event","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.11","name":"serviceWorker","type":{"name":"Worker","expression":"[Worker]"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"Service workers are only supported on Chromium-based browsers."}]},{"type":"text","text":"Emitted when new service worker is created in the context."}],"required":true,"comment":"**NOTE** Service workers are only supported on Chromium-based browsers.\n\nEmitted when new service worker is created in the context.","async":false,"alias":"serviceWorker","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"addCookies","type":{"name":"void"},"spec":[{"type":"text","text":"Adds cookies into this browser context. All pages within this context will have these cookies installed. Cookies can be↵obtained via [`method: BrowserContext.cookies`]."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await browserContext.addCookies([cookieObject1, cookieObject2]);"],"codeLang":"js"},{"type":"code","lines":["browserContext.addCookies(Arrays.asList(cookieObject1, cookieObject2));"],"codeLang":"java"},{"type":"code","lines":["await browser_context.add_cookies([cookie_object1, cookie_object2])"],"codeLang":"python async"},{"type":"code","lines":["browser_context.add_cookies([cookie_object1, cookie_object2])"],"codeLang":"python sync"},{"type":"code","lines":["await context.AddCookiesAsync(new[] { cookie1, cookie2 });"],"codeLang":"csharp"}],"required":true,"comment":"Adds cookies into this browser context. All pages within this context will have these cookies installed. Cookies\ncan be obtained via [`method: BrowserContext.cookies`].\n\n**Usage**\n\n```js\nawait browserContext.addCookies([cookieObject1, cookieObject2]);\n```\n\n```java\nbrowserContext.addCookies(Arrays.asList(cookieObject1, cookieObject2));\n```\n\n```py\nawait browser_context.add_cookies([cookie_object1, cookie_object2])\n```\n\n```py\nbrowser_context.add_cookies([cookie_object1, cookie_object2])\n```\n\n```csharp\nawait context.AddCookiesAsync(new[] { cookie1, cookie2 });\n```\n","async":true,"alias":"addCookies","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"cookies","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Either url or domain / path are required. Optional."}],"required":false,"comment":"Either url or domain / path are required. Optional.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"domain","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"For the cookie to apply to all subdomains as well, prefix domain with a dot, like this: \".example.com\". Either url or domain / path are required. Optional."}],"required":false,"comment":"For the cookie to apply to all subdomains as well, prefix domain with a dot, like this: \".example.com\". Either url\nor domain / path are required. Optional.","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Either url or domain / path are required Optional."}],"required":false,"comment":"Either url or domain / path are required Optional.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"expires","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Unix time in seconds. Optional."}],"required":false,"comment":"Unix time in seconds. Optional.","async":false,"alias":"expires","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional."}],"required":false,"comment":"Optional.","async":false,"alias":"httpOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"secure","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional."}],"required":false,"comment":"Optional.","async":false,"alias":"secure","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"sameSite","type":{"name":"SameSiteAttribute","union":[{"name":"\"Strict\""},{"name":"\"Lax\""},{"name":"\"None\""}],"expression":"[SameSiteAttribute]<\"Strict\"|\"Lax\"|\"None\">"},"spec":[{"type":"text","text":"Optional."}],"required":false,"comment":"Optional.","async":false,"alias":"sameSite","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"partitionKey","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"For partitioned third-party cookies (aka [CHIPS](https://developer.mozilla.org/en-US/docs/Web/Privacy/Guides/Privacy_sandbox/Partitioned_cookies)), the partition key. Optional."}],"required":false,"comment":"For partitioned third-party cookies (aka\n[CHIPS](https://developer.mozilla.org/en-US/docs/Web/Privacy/Guides/Privacy_sandbox/Partitioned_cookies)), the\npartition key. Optional.","async":false,"alias":"partitionKey","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[],"required":true,"comment":"","async":false,"alias":"cookies","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"addInitScript","type":{"name":"void"},"spec":[{"type":"text","text":"Adds a script which would be evaluated in one of the following scenarios:"},{"type":"li","text":"Whenever a page is created in the browser context or is navigated.","liType":"bullet"},{"type":"li","text":"Whenever a child frame is attached or navigated in any page in the browser context. In this case, the script is↵evaluated in the context of the newly attached frame.","liType":"bullet"},{"type":"text","text":"The script is evaluated after the document was created but before any of its scripts were run. This is useful to amend↵the JavaScript environment, e.g. to seed `Math.random`."},{"type":"text","text":"**Usage**"},{"type":"text","text":"An example of overriding `Math.random` before the page loads:"},{"type":"code","lines":["// preload.js","Math.random = () => 42;"],"codeLang":"js browser"},{"type":"code","lines":["// In your playwright script, assuming the preload.js file is in same directory.","await browserContext.addInitScript({","  path: 'preload.js'","});"],"codeLang":"js"},{"type":"code","lines":["// In your playwright script, assuming the preload.js file is in same directory.","browserContext.addInitScript(Paths.get(\"preload.js\"));"],"codeLang":"java"},{"type":"code","lines":["# in your playwright script, assuming the preload.js file is in same directory.","await browser_context.add_init_script(path=\"preload.js\")"],"codeLang":"python async"},{"type":"code","lines":["# in your playwright script, assuming the preload.js file is in same directory.","browser_context.add_init_script(path=\"preload.js\")"],"codeLang":"python sync"},{"type":"code","lines":["await Context.AddInitScriptAsync(scriptPath: \"preload.js\");"],"codeLang":"csharp"},{"type":"note","noteType":"note","children":[{"type":"text","text":"The order of evaluation of multiple scripts installed via [`method: BrowserContext.addInitScript`] and↵[`method: Page.addInitScript`] is not defined."}]}],"required":true,"comment":"Adds a script which would be evaluated in one of the following scenarios:\n- Whenever a page is created in the browser context or is navigated.\n- Whenever a child frame is attached or navigated in any page in the browser context. In this case, the script is\n  evaluated in the context of the newly attached frame.\n\nThe script is evaluated after the document was created but before any of its scripts were run. This is useful to\namend the JavaScript environment, e.g. to seed `Math.random`.\n\n**Usage**\n\nAn example of overriding `Math.random` before the page loads:\n\n```js\n// preload.js\nMath.random = () => 42;\n```\n\n```js\n// In your playwright script, assuming the preload.js file is in same directory.\nawait browserContext.addInitScript({\n  path: 'preload.js'\n});\n```\n\n```java\n// In your playwright script, assuming the preload.js file is in same directory.\nbrowserContext.addInitScript(Paths.get(\"preload.js\"));\n```\n\n```py\n# in your playwright script, assuming the preload.js file is in same directory.\nawait browser_context.add_init_script(path=\"preload.js\")\n```\n\n```py\n# in your playwright script, assuming the preload.js file is in same directory.\nbrowser_context.add_init_script(path=\"preload.js\")\n```\n\n```csharp\nawait Context.AddInitScriptAsync(scriptPath: \"preload.js\");\n```\n\n**NOTE** The order of evaluation of multiple scripts installed via [`method: BrowserContext.addInitScript`] and\n[`method: Page.addInitScript`] is not defined.\n","async":true,"alias":"addInitScript","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"script","type":{"name":"","union":[{"name":"function"},{"name":"string"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the JavaScript file. If `path` is a relative path, then it is resolved relative to the↵current working directory. Optional."}],"required":false,"comment":"Path to the JavaScript file. If `path` is a relative path, then it is resolved relative to the current working\ndirectory. Optional.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"content","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Raw script content. Optional."}],"required":false,"comment":"Raw script content. Optional.","async":false,"alias":"content","overloadIndex":0}]}],"expression":"[function]|[string]|[Object]"},"spec":[{"type":"text","text":"Script to be evaluated in all pages in the browser context."}],"required":true,"comment":"Script to be evaluated in all pages in the browser context.","async":false,"alias":"script","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"script","type":{"name":"","union":[{"name":"string"},{"name":"path"}],"expression":"[string]|[path]"},"spec":[{"type":"text","text":"Script to be evaluated in all pages in the browser context."}],"required":true,"comment":"Script to be evaluated in all pages in the browser context.","async":false,"alias":"script","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"arg","type":{"name":"Serializable","expression":"[Serializable]"},"spec":[{"type":"text","text":"Optional argument to pass to `script` (only supported when passing a function)."}],"required":false,"comment":"Optional argument to pass to `script` (only supported when passing a function).","async":false,"alias":"arg","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the JavaScript file. If `path` is a relative path, then it is resolved relative to the current working directory. Optional."}],"required":false,"comment":"Path to the JavaScript file. If `path` is a relative path, then it is resolved relative to the current working\ndirectory. Optional.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"script","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Script to be evaluated in all pages in the browser context. Optional."}],"required":false,"comment":"Script to be evaluated in all pages in the browser context. Optional.","async":false,"alias":"script","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.11","name":"backgroundPages","type":{"name":"Array","templates":[{"name":"Page"}],"expression":"[Array]<[Page]>"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"Background pages are only supported on Chromium-based browsers."}]},{"type":"text","text":"All existing background pages in the context."}],"required":true,"comment":"**NOTE** Background pages are only supported on Chromium-based browsers.\n\nAll existing background pages in the context.","async":false,"alias":"backgroundPages","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"browser","type":{"name":"","union":[{"name":"null"},{"name":"Browser"}],"expression":"[null]|[Browser]"},"spec":[{"type":"text","text":"Gets the browser instance that owns the context. Returns `null` if the context is created outside of normal browser, e.g. Android or Electron."}],"required":true,"comment":"Gets the browser instance that owns the context. Returns `null` if the context is created outside of normal\nbrowser, e.g. Android or Electron.","async":false,"alias":"browser","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"clearCookies","type":{"name":"void"},"spec":[{"type":"text","text":"Removes cookies from context. Accepts optional filter."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await context.clearCookies();","await context.clearCookies({ name: 'session-id' });","await context.clearCookies({ domain: 'my-origin.com' });","await context.clearCookies({ domain: /.*my-origin\\.com/ });","await context.clearCookies({ path: '/api/v1' });","await context.clearCookies({ name: 'session-id', domain: 'my-origin.com' });"],"codeLang":"js"},{"type":"code","lines":["context.clearCookies();","context.clearCookies(new BrowserContext.ClearCookiesOptions().setName(\"session-id\"));","context.clearCookies(new BrowserContext.ClearCookiesOptions().setDomain(\"my-origin.com\"));","context.clearCookies(new BrowserContext.ClearCookiesOptions().setPath(\"/api/v1\"));","context.clearCookies(new BrowserContext.ClearCookiesOptions()","                         .setName(\"session-id\")","                         .setDomain(\"my-origin.com\"));"],"codeLang":"java"},{"type":"code","lines":["await context.clear_cookies()","await context.clear_cookies(name=\"session-id\")","await context.clear_cookies(domain=\"my-origin.com\")","await context.clear_cookies(path=\"/api/v1\")","await context.clear_cookies(name=\"session-id\", domain=\"my-origin.com\")"],"codeLang":"python async"},{"type":"code","lines":["context.clear_cookies()","context.clear_cookies(name=\"session-id\")","context.clear_cookies(domain=\"my-origin.com\")","context.clear_cookies(path=\"/api/v1\")","context.clear_cookies(name=\"session-id\", domain=\"my-origin.com\")"],"codeLang":"python sync"},{"type":"code","lines":["await context.ClearCookiesAsync();","await context.ClearCookiesAsync(new() { Name = \"session-id\" });","await context.ClearCookiesAsync(new() { Domain = \"my-origin.com\" });","await context.ClearCookiesAsync(new() { Path = \"/api/v1\" });","await context.ClearCookiesAsync(new() { Name = \"session-id\", Domain = \"my-origin.com\" });"],"codeLang":"csharp"}],"required":true,"comment":"Removes cookies from context. Accepts optional filter.\n\n**Usage**\n\n```js\nawait context.clearCookies();\nawait context.clearCookies({ name: 'session-id' });\nawait context.clearCookies({ domain: 'my-origin.com' });\nawait context.clearCookies({ domain: /.*my-origin\\.com/ });\nawait context.clearCookies({ path: '/api/v1' });\nawait context.clearCookies({ name: 'session-id', domain: 'my-origin.com' });\n```\n\n```java\ncontext.clearCookies();\ncontext.clearCookies(new BrowserContext.ClearCookiesOptions().setName(\"session-id\"));\ncontext.clearCookies(new BrowserContext.ClearCookiesOptions().setDomain(\"my-origin.com\"));\ncontext.clearCookies(new BrowserContext.ClearCookiesOptions().setPath(\"/api/v1\"));\ncontext.clearCookies(new BrowserContext.ClearCookiesOptions()\n                         .setName(\"session-id\")\n                         .setDomain(\"my-origin.com\"));\n```\n\n```py\nawait context.clear_cookies()\nawait context.clear_cookies(name=\"session-id\")\nawait context.clear_cookies(domain=\"my-origin.com\")\nawait context.clear_cookies(path=\"/api/v1\")\nawait context.clear_cookies(name=\"session-id\", domain=\"my-origin.com\")\n```\n\n```py\ncontext.clear_cookies()\ncontext.clear_cookies(name=\"session-id\")\ncontext.clear_cookies(domain=\"my-origin.com\")\ncontext.clear_cookies(path=\"/api/v1\")\ncontext.clear_cookies(name=\"session-id\", domain=\"my-origin.com\")\n```\n\n```csharp\nawait context.ClearCookiesAsync();\nawait context.ClearCookiesAsync(new() { Name = \"session-id\" });\nawait context.ClearCookiesAsync(new() { Domain = \"my-origin.com\" });\nawait context.ClearCookiesAsync(new() { Path = \"/api/v1\" });\nawait context.ClearCookiesAsync(new() { Name = \"session-id\", Domain = \"my-origin.com\" });\n```\n","async":true,"alias":"clearCookies","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.43","name":"domain","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"Only removes cookies with the given domain."}],"required":false,"comment":"Only removes cookies with the given domain.","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.43","name":"name","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"Only removes cookies with the given name."}],"required":false,"comment":"Only removes cookies with the given name.","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.43","name":"path","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"Only removes cookies with the given path."}],"required":false,"comment":"Only removes cookies with the given path.","async":false,"alias":"path","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"clearPermissions","type":{"name":"void"},"spec":[{"type":"text","text":"Clears all permission overrides for the browser context."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const context = await browser.newContext();","await context.grantPermissions(['clipboard-read']);","// do stuff ..","context.clearPermissions();"],"codeLang":"js"},{"type":"code","lines":["BrowserContext context = browser.newContext();","context.grantPermissions(Arrays.asList(\"clipboard-read\"));","// do stuff ..","context.clearPermissions();"],"codeLang":"java"},{"type":"code","lines":["context = await browser.new_context()","await context.grant_permissions([\"clipboard-read\"])","# do stuff ..","context.clear_permissions()"],"codeLang":"python async"},{"type":"code","lines":["context = browser.new_context()","context.grant_permissions([\"clipboard-read\"])","# do stuff ..","context.clear_permissions()"],"codeLang":"python sync"},{"type":"code","lines":["var context = await browser.NewContextAsync();","await context.GrantPermissionsAsync(new[] { \"clipboard-read\" });","// Alternatively, you can use the helper class ContextPermissions","//  to specify the permissions...","// do stuff ...","await context.ClearPermissionsAsync();"],"codeLang":"csharp"}],"required":true,"comment":"Clears all permission overrides for the browser context.\n\n**Usage**\n\n```js\nconst context = await browser.newContext();\nawait context.grantPermissions(['clipboard-read']);\n// do stuff ..\ncontext.clearPermissions();\n```\n\n```java\nBrowserContext context = browser.newContext();\ncontext.grantPermissions(Arrays.asList(\"clipboard-read\"));\n// do stuff ..\ncontext.clearPermissions();\n```\n\n```py\ncontext = await browser.new_context()\nawait context.grant_permissions([\"clipboard-read\"])\n# do stuff ..\ncontext.clear_permissions()\n```\n\n```py\ncontext = browser.new_context()\ncontext.grant_permissions([\"clipboard-read\"])\n# do stuff ..\ncontext.clear_permissions()\n```\n\n```csharp\nvar context = await browser.NewContextAsync();\nawait context.GrantPermissionsAsync(new[] { \"clipboard-read\" });\n// Alternatively, you can use the helper class ContextPermissions\n//  to specify the permissions...\n// do stuff ...\nawait context.ClearPermissionsAsync();\n```\n","async":true,"alias":"clearPermissions","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Closes the browser context. All the pages that belong to the browser context will be closed."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The default browser context cannot be closed."}]}],"required":true,"comment":"Closes the browser context. All the pages that belong to the browser context will be closed.\n\n**NOTE** The default browser context cannot be closed.\n","async":true,"alias":"close","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.40","name":"reason","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"The reason to be reported to the operations interrupted by the context closure."}],"required":false,"comment":"The reason to be reported to the operations interrupted by the context closure.","async":false,"alias":"reason","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"cookies","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"domain","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"expires","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Unix time in seconds."}],"required":true,"comment":"Unix time in seconds.","async":false,"alias":"expires","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"httpOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"secure","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"secure","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"sameSite","type":{"name":"SameSiteAttribute","union":[{"name":"\"Strict\""},{"name":"\"Lax\""},{"name":"\"None\""}],"expression":"[SameSiteAttribute]<\"Strict\"|\"Lax\"|\"None\">"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"sameSite","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"partitionKey","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":false,"comment":"","async":false,"alias":"partitionKey","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"If no URLs are specified, this method returns all cookies. If URLs are specified, only cookies that affect those URLs↵are returned."}],"required":true,"comment":"If no URLs are specified, this method returns all cookies. If URLs are specified, only cookies that affect those\nURLs are returned.","async":true,"alias":"cookies","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"urls","type":{"name":"","union":[{"name":"string"},{"name":"Array","templates":[{"name":"string"}]}],"expression":"[string]|[Array]<[string]>"},"spec":[{"type":"text","text":"Optional list of URLs."}],"required":false,"comment":"Optional list of URLs.","async":false,"alias":"urls","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"exposeBinding","type":{"name":"void"},"spec":[{"type":"text","text":"The method adds a function called `name` on the `window` object of every frame in every page in the context.↵When called, the function executes `callback` and returns a [Promise] which resolves to the return value of↵`callback`. If the `callback` returns a [Promise], it will be awaited."},{"type":"text","text":"The first argument of the `callback` function contains information about the caller: `{ browserContext:↵BrowserContext, page: Page, frame: Frame }`."},{"type":"text","text":"See [`method: Page.exposeBinding`] for page-only version."},{"type":"text","text":"**Usage**"},{"type":"text","text":"An example of exposing page URL to all frames in all pages in the context:"},{"type":"code","lines":["const { webkit } = require('playwright');  // Or 'chromium' or 'firefox'.","","(async () => {","  const browser = await webkit.launch({ headless: false });","  const context = await browser.newContext();","  await context.exposeBinding('pageURL', ({ page }) => page.url());","  const page = await context.newPage();","  await page.setContent(`","    <script>","      async function onClick() {","        document.querySelector('div').textContent = await window.pageURL();","      }","    </script>","    <button onclick=\"onClick()\">Click me</button>","    <div></div>","  `);","  await page.getByRole('button').click();","})();"],"codeLang":"js"},{"type":"code","lines":["import com.microsoft.playwright.*;","","public class Example {","  public static void main(String[] args) {","    try (Playwright playwright = Playwright.create()) {","      BrowserType webkit = playwright.webkit();","      Browser browser = webkit.launch(new BrowserType.LaunchOptions().setHeadless(false));","      BrowserContext context = browser.newContext();","      context.exposeBinding(\"pageURL\", (source, args) -> source.page().url());","      Page page = context.newPage();","      page.setContent(\"<script>\\n\" +","        \"  async function onClick() {\\n\" +","        \"    document.querySelector('div').textContent = await window.pageURL();\\n\" +","        \"  }\\n\" +","        \"</script>\\n\" +","        \"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +","        \"<div></div>\");","      page.getByRole(AriaRole.BUTTON).click();","    }","  }","}"],"codeLang":"java"},{"type":"code","lines":["import asyncio","from playwright.async_api import async_playwright, Playwright","","async def run(playwright: Playwright):","    webkit = playwright.webkit","    browser = await webkit.launch(headless=False)","    context = await browser.new_context()","    await context.expose_binding(\"pageURL\", lambda source: source[\"page\"].url)","    page = await context.new_page()","    await page.set_content(\"\"\"","    <script>","      async function onClick() {","        document.querySelector('div').textContent = await window.pageURL();","      }","    </script>","    <button onclick=\"onClick()\">Click me</button>","    <div></div>","    \"\"\")","    await page.get_by_role(\"button\").click()","","async def main():","    async with async_playwright() as playwright:","        await run(playwright)","asyncio.run(main())"],"codeLang":"python async"},{"type":"code","lines":["from playwright.sync_api import sync_playwright, Playwright","","def run(playwright: Playwright):","    webkit = playwright.webkit","    browser = webkit.launch(headless=False)","    context = browser.new_context()","    context.expose_binding(\"pageURL\", lambda source: source[\"page\"].url)","    page = context.new_page()","    page.set_content(\"\"\"","    <script>","      async function onClick() {","        document.querySelector('div').textContent = await window.pageURL();","      }","    </script>","    <button onclick=\"onClick()\">Click me</button>","    <div></div>","    \"\"\")","    page.get_by_role(\"button\").click()","","with sync_playwright() as playwright:","    run(playwright)"],"codeLang":"python sync"},{"type":"code","lines":["using Microsoft.Playwright;","","using var playwright = await Playwright.CreateAsync();","var browser = await playwright.Webkit.LaunchAsync(new() { Headless = false });","var context = await browser.NewContextAsync();","","await context.ExposeBindingAsync(\"pageURL\", source => source.Page.Url);","var page = await context.NewPageAsync();","await page.SetContentAsync(\"<script>\\n\" +","\"  async function onClick() {\\n\" +","\"    document.querySelector('div').textContent = await window.pageURL();\\n\" +","\"  }\\n\" +","\"</script>\\n\" +","\"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +","\"<div></div>\");","await page.GetByRole(AriaRole.Button).ClickAsync();"],"codeLang":"csharp"}],"required":true,"comment":"The method adds a function called `name` on the `window` object of every frame in every page in the context. When\ncalled, the function executes `callback` and returns a [Promise] which resolves to the return value of `callback`.\nIf the `callback` returns a [Promise], it will be awaited.\n\nThe first argument of the `callback` function contains information about the caller: `{ browserContext:\nBrowserContext, page: Page, frame: Frame }`.\n\nSee [`method: Page.exposeBinding`] for page-only version.\n\n**Usage**\n\nAn example of exposing page URL to all frames in all pages in the context:\n\n```js\nconst { webkit } = require('playwright');  // Or 'chromium' or 'firefox'.\n\n(async () => {\n  const browser = await webkit.launch({ headless: false });\n  const context = await browser.newContext();\n  await context.exposeBinding('pageURL', ({ page }) => page.url());\n  const page = await context.newPage();\n  await page.setContent(`\n    <script>\n      async function onClick() {\n        document.querySelector('div').textContent = await window.pageURL();\n      }\n    </script>\n    <button onclick=\"onClick()\">Click me</button>\n    <div></div>\n  `);\n  await page.getByRole('button').click();\n})();\n```\n\n```java\nimport com.microsoft.playwright.*;\n\npublic class Example {\n  public static void main(String[] args) {\n    try (Playwright playwright = Playwright.create()) {\n      BrowserType webkit = playwright.webkit();\n      Browser browser = webkit.launch(new BrowserType.LaunchOptions().setHeadless(false));\n      BrowserContext context = browser.newContext();\n      context.exposeBinding(\"pageURL\", (source, args) -> source.page().url());\n      Page page = context.newPage();\n      page.setContent(\"<script>\\n\" +\n        \"  async function onClick() {\\n\" +\n        \"    document.querySelector('div').textContent = await window.pageURL();\\n\" +\n        \"  }\\n\" +\n        \"</script>\\n\" +\n        \"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +\n        \"<div></div>\");\n      page.getByRole(AriaRole.BUTTON).click();\n    }\n  }\n}\n```\n\n```py\nimport asyncio\nfrom playwright.async_api import async_playwright, Playwright\n\nasync def run(playwright: Playwright):\n    webkit = playwright.webkit\n    browser = await webkit.launch(headless=False)\n    context = await browser.new_context()\n    await context.expose_binding(\"pageURL\", lambda source: source[\"page\"].url)\n    page = await context.new_page()\n    await page.set_content(\"\"\"\n    <script>\n      async function onClick() {\n        document.querySelector('div').textContent = await window.pageURL();\n      }\n    </script>\n    <button onclick=\"onClick()\">Click me</button>\n    <div></div>\n    \"\"\")\n    await page.get_by_role(\"button\").click()\n\nasync def main():\n    async with async_playwright() as playwright:\n        await run(playwright)\nasyncio.run(main())\n```\n\n```py\nfrom playwright.sync_api import sync_playwright, Playwright\n\ndef run(playwright: Playwright):\n    webkit = playwright.webkit\n    browser = webkit.launch(headless=False)\n    context = browser.new_context()\n    context.expose_binding(\"pageURL\", lambda source: source[\"page\"].url)\n    page = context.new_page()\n    page.set_content(\"\"\"\n    <script>\n      async function onClick() {\n        document.querySelector('div').textContent = await window.pageURL();\n      }\n    </script>\n    <button onclick=\"onClick()\">Click me</button>\n    <div></div>\n    \"\"\")\n    page.get_by_role(\"button\").click()\n\nwith sync_playwright() as playwright:\n    run(playwright)\n```\n\n```csharp\nusing Microsoft.Playwright;\n\nusing var playwright = await Playwright.CreateAsync();\nvar browser = await playwright.Webkit.LaunchAsync(new() { Headless = false });\nvar context = await browser.NewContextAsync();\n\nawait context.ExposeBindingAsync(\"pageURL\", source => source.Page.Url);\nvar page = await context.NewPageAsync();\nawait page.SetContentAsync(\"<script>\\n\" +\n\"  async function onClick() {\\n\" +\n\"    document.querySelector('div').textContent = await window.pageURL();\\n\" +\n\"  }\\n\" +\n\"</script>\\n\" +\n\"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +\n\"<div></div>\");\nawait page.GetByRole(AriaRole.Button).ClickAsync();\n```\n","async":true,"alias":"exposeBinding","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Name of the function on the window object."}],"required":true,"comment":"Name of the function on the window object.","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"callback","type":{"name":"function","expression":"[function]"},"spec":[{"type":"text","text":"Callback function that will be called in the Playwright's context."}],"required":true,"comment":"Callback function that will be called in the Playwright's context.","async":false,"alias":"callback","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option will be removed in the future.","name":"handle","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to pass the argument as a handle, instead of passing by value. When passing a handle, only one argument is↵supported. When passing by value, multiple arguments are supported."}],"required":false,"comment":"Whether to pass the argument as a handle, instead of passing by value. When passing a handle, only one argument is\nsupported. When passing by value, multiple arguments are supported.","async":false,"alias":"handle","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"exposeFunction","type":{"name":"void"},"spec":[{"type":"text","text":"The method adds a function called `name` on the `window` object of every frame in every page in the context.↵When called, the function executes `callback` and returns a [Promise] which resolves to the return value of↵`callback`."},{"type":"text","text":"If the `callback` returns a [Promise], it will be awaited."},{"type":"text","text":"See [`method: Page.exposeFunction`] for page-only version."},{"type":"text","text":"**Usage**"},{"type":"text","text":"An example of adding a `sha256` function to all pages in the context:"},{"type":"code","lines":["const { webkit } = require('playwright');  // Or 'chromium' or 'firefox'.","const crypto = require('crypto');","","(async () => {","  const browser = await webkit.launch({ headless: false });","  const context = await browser.newContext();","  await context.exposeFunction('sha256', text =>","    crypto.createHash('sha256').update(text).digest('hex'),","  );","  const page = await context.newPage();","  await page.setContent(`","    <script>","      async function onClick() {","        document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');","      }","    </script>","    <button onclick=\"onClick()\">Click me</button>","    <div></div>","  `);","  await page.getByRole('button').click();","})();"],"codeLang":"js"},{"type":"code","lines":["import com.microsoft.playwright.*;","","import java.nio.charset.StandardCharsets;","import java.security.MessageDigest;","import java.security.NoSuchAlgorithmException;","import java.util.Base64;","","public class Example {","  public static void main(String[] args) {","    try (Playwright playwright = Playwright.create()) {","      BrowserType webkit = playwright.webkit();","      Browser browser = webkit.launch(new BrowserType.LaunchOptions().setHeadless(false));","      BrowserContext context = browser.newContext();","      context.exposeFunction(\"sha256\", args -> {","        String text = (String) args[0];","        MessageDigest crypto;","        try {","          crypto = MessageDigest.getInstance(\"SHA-256\");","        } catch (NoSuchAlgorithmException e) {","          return null;","        }","        byte[] token = crypto.digest(text.getBytes(StandardCharsets.UTF_8));","        return Base64.getEncoder().encodeToString(token);","      });","      Page page = context.newPage();","      page.setContent(\"<script>\\n\" +","        \"  async function onClick() {\\n\" +","        \"    document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');\\n\" +","        \"  }\\n\" +","        \"</script>\\n\" +","        \"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +","        \"<div></div>\\n\");","      page.getByRole(AriaRole.BUTTON).click();","    }","  }","}"],"codeLang":"java"},{"type":"code","lines":["import asyncio","import hashlib","from playwright.async_api import async_playwright, Playwright","","def sha256(text: str) -> str:","    m = hashlib.sha256()","    m.update(bytes(text, \"utf8\"))","    return m.hexdigest()","","","async def run(playwright: Playwright):","    webkit = playwright.webkit","    browser = await webkit.launch(headless=False)","    context = await browser.new_context()","    await context.expose_function(\"sha256\", sha256)","    page = await context.new_page()","    await page.set_content(\"\"\"","        <script>","          async function onClick() {","            document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');","          }","        </script>","        <button onclick=\"onClick()\">Click me</button>","        <div></div>","    \"\"\")","    await page.get_by_role(\"button\").click()","","async def main():","    async with async_playwright() as playwright:","        await run(playwright)","asyncio.run(main())"],"codeLang":"python async"},{"type":"code","lines":["import hashlib","from playwright.sync_api import sync_playwright","","def sha256(text: str) -> str:","    m = hashlib.sha256()","    m.update(bytes(text, \"utf8\"))","    return m.hexdigest()","","","def run(playwright: Playwright):","    webkit = playwright.webkit","    browser = webkit.launch(headless=False)","    context = browser.new_context()","    context.expose_function(\"sha256\", sha256)","    page = context.new_page()","    page.set_content(\"\"\"","        <script>","          async function onClick() {","            document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');","          }","        </script>","        <button onclick=\"onClick()\">Click me</button>","        <div></div>","    \"\"\")","    page.get_by_role(\"button\").click()","","with sync_playwright() as playwright:","    run(playwright)"],"codeLang":"python sync"},{"type":"code","lines":["using Microsoft.Playwright;","using System;","using System.Security.Cryptography;","using System.Threading.Tasks;","","class BrowserContextExamples","{","    public static async Task Main()","    {","        using var playwright = await Playwright.CreateAsync();","        var browser = await playwright.Webkit.LaunchAsync(new() { Headless = false });","        var context = await browser.NewContextAsync();","","        await context.ExposeFunctionAsync(\"sha256\", (string input) =>","        {","            return Convert.ToBase64String(","                SHA256.Create().ComputeHash(System.Text.Encoding.UTF8.GetBytes(input)));","        });","","        var page = await context.NewPageAsync();","        await page.SetContentAsync(\"<script>\\n\" +","        \"  async function onClick() {\\n\" +","        \"    document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');\\n\" +","        \"  }\\n\" +","        \"</script>\\n\" +","        \"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +","        \"<div></div>\");","","        await page.GetByRole(AriaRole.Button).ClickAsync();","        Console.WriteLine(await page.TextContentAsync(\"div\"));","    }","}"],"codeLang":"csharp"}],"required":true,"comment":"The method adds a function called `name` on the `window` object of every frame in every page in the context. When\ncalled, the function executes `callback` and returns a [Promise] which resolves to the return value of `callback`.\n\nIf the `callback` returns a [Promise], it will be awaited.\n\nSee [`method: Page.exposeFunction`] for page-only version.\n\n**Usage**\n\nAn example of adding a `sha256` function to all pages in the context:\n\n```js\nconst { webkit } = require('playwright');  // Or 'chromium' or 'firefox'.\nconst crypto = require('crypto');\n\n(async () => {\n  const browser = await webkit.launch({ headless: false });\n  const context = await browser.newContext();\n  await context.exposeFunction('sha256', text =>\n    crypto.createHash('sha256').update(text).digest('hex'),\n  );\n  const page = await context.newPage();\n  await page.setContent(`\n    <script>\n      async function onClick() {\n        document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');\n      }\n    </script>\n    <button onclick=\"onClick()\">Click me</button>\n    <div></div>\n  `);\n  await page.getByRole('button').click();\n})();\n```\n\n```java\nimport com.microsoft.playwright.*;\n\nimport java.nio.charset.StandardCharsets;\nimport java.security.MessageDigest;\nimport java.security.NoSuchAlgorithmException;\nimport java.util.Base64;\n\npublic class Example {\n  public static void main(String[] args) {\n    try (Playwright playwright = Playwright.create()) {\n      BrowserType webkit = playwright.webkit();\n      Browser browser = webkit.launch(new BrowserType.LaunchOptions().setHeadless(false));\n      BrowserContext context = browser.newContext();\n      context.exposeFunction(\"sha256\", args -> {\n        String text = (String) args[0];\n        MessageDigest crypto;\n        try {\n          crypto = MessageDigest.getInstance(\"SHA-256\");\n        } catch (NoSuchAlgorithmException e) {\n          return null;\n        }\n        byte[] token = crypto.digest(text.getBytes(StandardCharsets.UTF_8));\n        return Base64.getEncoder().encodeToString(token);\n      });\n      Page page = context.newPage();\n      page.setContent(\"<script>\\n\" +\n        \"  async function onClick() {\\n\" +\n        \"    document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');\\n\" +\n        \"  }\\n\" +\n        \"</script>\\n\" +\n        \"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +\n        \"<div></div>\\n\");\n      page.getByRole(AriaRole.BUTTON).click();\n    }\n  }\n}\n```\n\n```py\nimport asyncio\nimport hashlib\nfrom playwright.async_api import async_playwright, Playwright\n\ndef sha256(text: str) -> str:\n    m = hashlib.sha256()\n    m.update(bytes(text, \"utf8\"))\n    return m.hexdigest()\n\n\nasync def run(playwright: Playwright):\n    webkit = playwright.webkit\n    browser = await webkit.launch(headless=False)\n    context = await browser.new_context()\n    await context.expose_function(\"sha256\", sha256)\n    page = await context.new_page()\n    await page.set_content(\"\"\"\n        <script>\n          async function onClick() {\n            document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');\n          }\n        </script>\n        <button onclick=\"onClick()\">Click me</button>\n        <div></div>\n    \"\"\")\n    await page.get_by_role(\"button\").click()\n\nasync def main():\n    async with async_playwright() as playwright:\n        await run(playwright)\nasyncio.run(main())\n```\n\n```py\nimport hashlib\nfrom playwright.sync_api import sync_playwright\n\ndef sha256(text: str) -> str:\n    m = hashlib.sha256()\n    m.update(bytes(text, \"utf8\"))\n    return m.hexdigest()\n\n\ndef run(playwright: Playwright):\n    webkit = playwright.webkit\n    browser = webkit.launch(headless=False)\n    context = browser.new_context()\n    context.expose_function(\"sha256\", sha256)\n    page = context.new_page()\n    page.set_content(\"\"\"\n        <script>\n          async function onClick() {\n            document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');\n          }\n        </script>\n        <button onclick=\"onClick()\">Click me</button>\n        <div></div>\n    \"\"\")\n    page.get_by_role(\"button\").click()\n\nwith sync_playwright() as playwright:\n    run(playwright)\n```\n\n```csharp\nusing Microsoft.Playwright;\nusing System;\nusing System.Security.Cryptography;\nusing System.Threading.Tasks;\n\nclass BrowserContextExamples\n{\n    public static async Task Main()\n    {\n        using var playwright = await Playwright.CreateAsync();\n        var browser = await playwright.Webkit.LaunchAsync(new() { Headless = false });\n        var context = await browser.NewContextAsync();\n\n        await context.ExposeFunctionAsync(\"sha256\", (string input) =>\n        {\n            return Convert.ToBase64String(\n                SHA256.Create().ComputeHash(System.Text.Encoding.UTF8.GetBytes(input)));\n        });\n\n        var page = await context.NewPageAsync();\n        await page.SetContentAsync(\"<script>\\n\" +\n        \"  async function onClick() {\\n\" +\n        \"    document.querySelector('div').textContent = await window.sha256('PLAYWRIGHT');\\n\" +\n        \"  }\\n\" +\n        \"</script>\\n\" +\n        \"<button onclick=\\\"onClick()\\\">Click me</button>\\n\" +\n        \"<div></div>\");\n\n        await page.GetByRole(AriaRole.Button).ClickAsync();\n        Console.WriteLine(await page.TextContentAsync(\"div\"));\n    }\n}\n```\n","async":true,"alias":"exposeFunction","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Name of the function on the window object."}],"required":true,"comment":"Name of the function on the window object.","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"callback","type":{"name":"function","expression":"[function]"},"spec":[{"type":"text","text":"Callback function that will be called in the Playwright's context."}],"required":true,"comment":"Callback function that will be called in the Playwright's context.","async":false,"alias":"callback","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"grantPermissions","type":{"name":"void"},"spec":[{"type":"text","text":"Grants specified permissions to the browser context. Only grants corresponding permissions to the given origin if↵specified."}],"required":true,"comment":"Grants specified permissions to the browser context. Only grants corresponding permissions to the given origin if\nspecified.","async":true,"alias":"grantPermissions","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"permissions","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"A list of permissions to grant."},{"type":"note","noteType":"danger","children":[{"type":"text","text":"Supported permissions differ between browsers, and even between different versions of the same browser. Any permission may stop working after an update."}]},{"type":"text","text":"Here are some permissions that may be supported by some browsers:"},{"type":"li","text":"`'accelerometer'`","liType":"bullet"},{"type":"li","text":"`'ambient-light-sensor'`","liType":"bullet"},{"type":"li","text":"`'background-sync'`","liType":"bullet"},{"type":"li","text":"`'camera'`","liType":"bullet"},{"type":"li","text":"`'clipboard-read'`","liType":"bullet"},{"type":"li","text":"`'clipboard-write'`","liType":"bullet"},{"type":"li","text":"`'geolocation'`","liType":"bullet"},{"type":"li","text":"`'gyroscope'`","liType":"bullet"},{"type":"li","text":"`'magnetometer'`","liType":"bullet"},{"type":"li","text":"`'microphone'`","liType":"bullet"},{"type":"li","text":"`'midi-sysex'` (system-exclusive midi)","liType":"bullet"},{"type":"li","text":"`'midi'`","liType":"bullet"},{"type":"li","text":"`'notifications'`","liType":"bullet"},{"type":"li","text":"`'payment-handler'`","liType":"bullet"},{"type":"li","text":"`'storage-access'`","liType":"bullet"},{"type":"li","text":"`'local-fonts'`","liType":"bullet"}],"required":true,"comment":"A list of permissions to grant.\n\n**NOTE** Supported permissions differ between browsers, and even between different versions of the same browser.\nAny permission may stop working after an update.\n\nHere are some permissions that may be supported by some browsers:\n- `'accelerometer'`\n- `'ambient-light-sensor'`\n- `'background-sync'`\n- `'camera'`\n- `'clipboard-read'`\n- `'clipboard-write'`\n- `'geolocation'`\n- `'gyroscope'`\n- `'magnetometer'`\n- `'microphone'`\n- `'midi-sysex'` (system-exclusive midi)\n- `'midi'`\n- `'notifications'`\n- `'payment-handler'`\n- `'storage-access'`\n- `'local-fonts'`","async":false,"alias":"permissions","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"The [origin] to grant permissions to, e.g. \"https://example.com\"."}],"required":false,"comment":"The [origin] to grant permissions to, e.g. \"https://example.com\".","async":false,"alias":"origin","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.11","name":"newCDPSession","type":{"name":"CDPSession","expression":"[CDPSession]"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"CDP sessions are only supported on Chromium-based browsers."}]},{"type":"text","text":"Returns the newly created session."}],"required":true,"comment":"**NOTE** CDP sessions are only supported on Chromium-based browsers.\n\nReturns the newly created session.","async":true,"alias":"newCDPSession","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.11","name":"page","type":{"name":"","union":[{"name":"Page"},{"name":"Frame"}],"expression":"[Page]|[Frame]"},"spec":[{"type":"text","text":"Target to create new session for. For backwards-compatibility, this parameter is↵named `page`, but it can be a `Page` or `Frame` type."}],"required":true,"comment":"Target to create new session for. For backwards-compatibility, this parameter is named `page`, but it can be a\n`Page` or `Frame` type.","async":false,"alias":"page","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"newPage","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Creates a new page in the browser context."}],"required":true,"comment":"Creates a new page in the browser context.","async":true,"alias":"newPage","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"pages","type":{"name":"Array","templates":[{"name":"Page"}],"expression":"[Array]<[Page]>"},"spec":[{"type":"text","text":"Returns all open pages in the context."}],"required":true,"comment":"Returns all open pages in the context.","async":false,"alias":"pages","overloadIndex":0,"args":[]},{"kind":"method","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"removeAllListeners","type":{"name":"void"},"spec":[{"type":"text","text":"Removes all the listeners of the given type (or all registered listeners if no type given).↵Allows to wait for async listeners to complete or to ignore subsequent errors from these listeners."}],"required":true,"comment":"Removes all the listeners of the given type (or all registered listeners if no type given). Allows to wait for\nasync listeners to complete or to ignore subsequent errors from these listeners.","async":true,"alias":"removeAllListeners","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.47","name":"type","type":{"name":"string","expression":"[string]"},"spec":[],"required":false,"comment":"","async":false,"alias":"type","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.47","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.47","name":"behavior","type":{"name":"RemoveAllListenersBehavior","union":[{"name":"\"wait\""},{"name":"\"ignoreErrors\""},{"name":"\"default\""}],"expression":"[RemoveAllListenersBehavior]<\"wait\"|\"ignoreErrors\"|\"default\">"},"spec":[{"type":"text","text":"Specifies whether to wait for already running listeners and what to do if they throw errors:"},{"type":"li","text":"`'default'` - do not wait for current listener calls (if any) to finish, if the listener throws, it may result in unhandled error","liType":"bullet"},{"type":"li","text":"`'wait'` - wait for current listener calls (if any) to finish","liType":"bullet"},{"type":"li","text":"`'ignoreErrors'` - do not wait for current listener calls (if any) to finish, all errors thrown by the listeners after removal are silently caught","liType":"bullet"}],"required":false,"comment":"Specifies whether to wait for already running listeners and what to do if they throw errors:\n- `'default'` - do not wait for current listener calls (if any) to finish, if the listener throws, it may result\n  in unhandled error\n- `'wait'` - wait for current listener calls (if any) to finish\n- `'ignoreErrors'` - do not wait for current listener calls (if any) to finish, all errors thrown by the\n  listeners after removal are silently caught","async":false,"alias":"behavior","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"property","langs":{"aliases":{"csharp":"APIRequest"},"types":{},"overrides":{}},"since":"v1.16","name":"request","type":{"name":"APIRequestContext","expression":"[APIRequestContext]"},"spec":[{"type":"text","text":"API testing helper associated with this context. Requests made with this API will use context cookies."}],"required":true,"comment":"API testing helper associated with this context. Requests made with this API will use context cookies.","async":false,"alias":"request","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"route","type":{"name":"void"},"spec":[{"type":"text","text":"Routing provides the capability to modify network requests that are made by any page in the browser context. Once route↵is enabled, every request matching the url pattern will stall unless it's continued, fulfilled or aborted."},{"type":"note","noteType":"note","children":[{"type":"text","text":"[`method: BrowserContext.route`] will not intercept requests intercepted by Service Worker. See [this](https://github.com/microsoft/playwright/issues/1090) issue. We recommend disabling Service Workers when using request interception by setting `serviceWorkers` to `'block'`."}]},{"type":"text","text":"**Usage**"},{"type":"text","text":"An example of a naive handler that aborts all image requests:"},{"type":"code","lines":["const context = await browser.newContext();","await context.route('**/*.{png,jpg,jpeg}', route => route.abort());","const page = await context.newPage();","await page.goto('https://example.com');","await browser.close();"],"codeLang":"js"},{"type":"code","lines":["BrowserContext context = browser.newContext();","context.route(\"**/*.{png,jpg,jpeg}\", route -> route.abort());","Page page = context.newPage();","page.navigate(\"https://example.com\");","browser.close();"],"codeLang":"java"},{"type":"code","lines":["context = await browser.new_context()","page = await context.new_page()","await context.route(\"**/*.{png,jpg,jpeg}\", lambda route: route.abort())","await page.goto(\"https://example.com\")","await browser.close()"],"codeLang":"python async"},{"type":"code","lines":["context = browser.new_context()","page = context.new_page()","context.route(\"**/*.{png,jpg,jpeg}\", lambda route: route.abort())","page.goto(\"https://example.com\")","browser.close()"],"codeLang":"python sync"},{"type":"code","lines":["var context = await browser.NewContextAsync();","var page = await context.NewPageAsync();","await context.RouteAsync(\"**/*.{png,jpg,jpeg}\", r => r.AbortAsync());","await page.GotoAsync(\"https://theverge.com\");","await browser.CloseAsync();"],"codeLang":"csharp"},{"type":"text","text":"or the same snippet using a regex pattern instead:"},{"type":"code","lines":["const context = await browser.newContext();","await context.route(/(\\.png$)|(\\.jpg$)/, route => route.abort());","const page = await context.newPage();","await page.goto('https://example.com');","await browser.close();"],"codeLang":"js"},{"type":"code","lines":["BrowserContext context = browser.newContext();","context.route(Pattern.compile(\"(\\\\.png$)|(\\\\.jpg$)\"), route -> route.abort());","Page page = context.newPage();","page.navigate(\"https://example.com\");","browser.close();"],"codeLang":"java"},{"type":"code","lines":["context = await browser.new_context()","page = await context.new_page()","await context.route(re.compile(r\"(\\.png$)|(\\.jpg$)\"), lambda route: route.abort())","page = await context.new_page()","await page.goto(\"https://example.com\")","await browser.close()"],"codeLang":"python async"},{"type":"code","lines":["context = browser.new_context()","page = context.new_page()","context.route(re.compile(r\"(\\.png$)|(\\.jpg$)\"), lambda route: route.abort())","page = await context.new_page()","page = context.new_page()","page.goto(\"https://example.com\")","browser.close()"],"codeLang":"python sync"},{"type":"code","lines":["var context = await browser.NewContextAsync();","var page = await context.NewPageAsync();","await context.RouteAsync(new Regex(\"(\\\\.png$)|(\\\\.jpg$)\"), r => r.AbortAsync());","await page.GotoAsync(\"https://theverge.com\");","await browser.CloseAsync();"],"codeLang":"csharp"},{"type":"text","text":"It is possible to examine the request to decide the route action. For example, mocking all requests that contain some post data, and leaving all other requests as is:"},{"type":"code","lines":["await context.route('/api/**', async route => {","  if (route.request().postData().includes('my-string'))","    await route.fulfill({ body: 'mocked-data' });","  else","    await route.continue();","});"],"codeLang":"js"},{"type":"code","lines":["context.route(\"/api/**\", route -> {","  if (route.request().postData().contains(\"my-string\"))","    route.fulfill(new Route.FulfillOptions().setBody(\"mocked-data\"));","  else","    route.resume();","});"],"codeLang":"java"},{"type":"code","lines":["async def handle_route(route: Route):","  if (\"my-string\" in route.request.post_data):","    await route.fulfill(body=\"mocked-data\")","  else:","    await route.continue_()","await context.route(\"/api/**\", handle_route)"],"codeLang":"python async"},{"type":"code","lines":["def handle_route(route: Route):","  if (\"my-string\" in route.request.post_data):","    route.fulfill(body=\"mocked-data\")","  else:","    route.continue_()","context.route(\"/api/**\", handle_route)"],"codeLang":"python sync"},{"type":"code","lines":["await page.RouteAsync(\"/api/**\", async r =>","{","    if (r.Request.PostData.Contains(\"my-string\"))","        await r.FulfillAsync(new() { Body = \"mocked-data\" });","    else","        await r.ContinueAsync();","});"],"codeLang":"csharp"},{"type":"text","text":"Page routes (set up with [`method: Page.route`]) take precedence over browser context routes when request matches both↵handlers."},{"type":"text","text":"To remove a route with its handler you can use [`method: BrowserContext.unroute`]."},{"type":"note","noteType":"note","children":[{"type":"text","text":"Enabling routing disables http cache."}]}],"required":true,"comment":"Routing provides the capability to modify network requests that are made by any page in the browser context. Once\nroute is enabled, every request matching the url pattern will stall unless it's continued, fulfilled or aborted.\n\n**NOTE** [`method: BrowserContext.route`] will not intercept requests intercepted by Service Worker. See\n[this](https://github.com/microsoft/playwright/issues/1090) issue. We recommend disabling Service Workers when\nusing request interception by setting `serviceWorkers` to `'block'`.\n\n**Usage**\n\nAn example of a naive handler that aborts all image requests:\n\n```js\nconst context = await browser.newContext();\nawait context.route('**/*.{png,jpg,jpeg}', route => route.abort());\nconst page = await context.newPage();\nawait page.goto('https://example.com');\nawait browser.close();\n```\n\n```java\nBrowserContext context = browser.newContext();\ncontext.route(\"**/*.{png,jpg,jpeg}\", route -> route.abort());\nPage page = context.newPage();\npage.navigate(\"https://example.com\");\nbrowser.close();\n```\n\n```py\ncontext = await browser.new_context()\npage = await context.new_page()\nawait context.route(\"**/*.{png,jpg,jpeg}\", lambda route: route.abort())\nawait page.goto(\"https://example.com\")\nawait browser.close()\n```\n\n```py\ncontext = browser.new_context()\npage = context.new_page()\ncontext.route(\"**/*.{png,jpg,jpeg}\", lambda route: route.abort())\npage.goto(\"https://example.com\")\nbrowser.close()\n```\n\n```csharp\nvar context = await browser.NewContextAsync();\nvar page = await context.NewPageAsync();\nawait context.RouteAsync(\"**/*.{png,jpg,jpeg}\", r => r.AbortAsync());\nawait page.GotoAsync(\"https://theverge.com\");\nawait browser.CloseAsync();\n```\n\nor the same snippet using a regex pattern instead:\n\n```js\nconst context = await browser.newContext();\nawait context.route(/(\\.png$)|(\\.jpg$)/, route => route.abort());\nconst page = await context.newPage();\nawait page.goto('https://example.com');\nawait browser.close();\n```\n\n```java\nBrowserContext context = browser.newContext();\ncontext.route(Pattern.compile(\"(\\\\.png$)|(\\\\.jpg$)\"), route -> route.abort());\nPage page = context.newPage();\npage.navigate(\"https://example.com\");\nbrowser.close();\n```\n\n```py\ncontext = await browser.new_context()\npage = await context.new_page()\nawait context.route(re.compile(r\"(\\.png$)|(\\.jpg$)\"), lambda route: route.abort())\npage = await context.new_page()\nawait page.goto(\"https://example.com\")\nawait browser.close()\n```\n\n```py\ncontext = browser.new_context()\npage = context.new_page()\ncontext.route(re.compile(r\"(\\.png$)|(\\.jpg$)\"), lambda route: route.abort())\npage = await context.new_page()\npage = context.new_page()\npage.goto(\"https://example.com\")\nbrowser.close()\n```\n\n```csharp\nvar context = await browser.NewContextAsync();\nvar page = await context.NewPageAsync();\nawait context.RouteAsync(new Regex(\"(\\\\.png$)|(\\\\.jpg$)\"), r => r.AbortAsync());\nawait page.GotoAsync(\"https://theverge.com\");\nawait browser.CloseAsync();\n```\n\nIt is possible to examine the request to decide the route action. For example, mocking all requests that contain\nsome post data, and leaving all other requests as is:\n\n```js\nawait context.route('/api/**', async route => {\n  if (route.request().postData().includes('my-string'))\n    await route.fulfill({ body: 'mocked-data' });\n  else\n    await route.continue();\n});\n```\n\n```java\ncontext.route(\"/api/**\", route -> {\n  if (route.request().postData().contains(\"my-string\"))\n    route.fulfill(new Route.FulfillOptions().setBody(\"mocked-data\"));\n  else\n    route.resume();\n});\n```\n\n```py\nasync def handle_route(route: Route):\n  if (\"my-string\" in route.request.post_data):\n    await route.fulfill(body=\"mocked-data\")\n  else:\n    await route.continue_()\nawait context.route(\"/api/**\", handle_route)\n```\n\n```py\ndef handle_route(route: Route):\n  if (\"my-string\" in route.request.post_data):\n    route.fulfill(body=\"mocked-data\")\n  else:\n    route.continue_()\ncontext.route(\"/api/**\", handle_route)\n```\n\n```csharp\nawait page.RouteAsync(\"/api/**\", async r =>\n{\n    if (r.Request.PostData.Contains(\"my-string\"))\n        await r.FulfillAsync(new() { Body = \"mocked-data\" });\n    else\n        await r.ContinueAsync();\n});\n```\n\nPage routes (set up with [`method: Page.route`]) take precedence over browser context routes when request matches\nboth handlers.\n\nTo remove a route with its handler you can use [`method: BrowserContext.unroute`].\n\n**NOTE** Enabling routing disables http cache.\n","async":true,"alias":"route","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"url","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"},{"name":"function","args":[{"name":"URL"}],"returnType":{"name":"boolean"}}],"expression":"[string]|[RegExp]|[function]([URL]):[boolean]"},"spec":[{"type":"text","text":"A glob pattern, regex pattern, or predicate that receives a [URL] to match during routing. If `baseURL` is set in the context options and the provided URL is a string that does not start with `*`, it is resolved using the [`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor."}],"required":true,"comment":"A glob pattern, regex pattern, or predicate that receives a [URL] to match during routing. If `baseURL` is set in\nthe context options and the provided URL is a string that does not start with `*`, it is resolved using the\n[`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"handler","type":{"name":"function","args":[{"name":"Route"},{"name":"Request"}],"returnType":{"name":"","union":[{"name":"Promise","templates":[{"name":"any"}]},{"name":"any"}]},"expression":"[function]([Route], [Request]): [Promise<any>|any]"},"spec":[{"type":"text","text":"handler function to route the request."}],"required":true,"comment":"handler function to route the request.","async":false,"alias":"handler","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"handler","type":{"name":"function","args":[{"name":"Route"}],"expression":"[function]([Route])"},"spec":[{"type":"text","text":"handler function to route the request."}],"required":true,"comment":"handler function to route the request.","async":false,"alias":"handler","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.15","name":"times","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"How often a route should be used. By default it will be used every time."}],"required":false,"comment":"How often a route should be used. By default it will be used every time.","async":false,"alias":"times","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.23","name":"routeFromHAR","type":{"name":"void"},"spec":[{"type":"text","text":"If specified the network requests that are made in the context will be served from the HAR file. Read more about [Replaying from HAR](../mock.md#replaying-from-har)."},{"type":"text","text":"Playwright will not serve requests intercepted by Service Worker from the HAR file. See [this](https://github.com/microsoft/playwright/issues/1090) issue. We recommend disabling Service Workers when using request interception by setting `serviceWorkers` to `'block'`."}],"required":true,"comment":"If specified the network requests that are made in the context will be served from the HAR file. Read more about\n[Replaying from HAR](../mock.md#replaying-from-har).\n\nPlaywright will not serve requests intercepted by Service Worker from the HAR file. See\n[this](https://github.com/microsoft/playwright/issues/1090) issue. We recommend disabling Service Workers when\nusing request interception by setting `serviceWorkers` to `'block'`.","async":true,"alias":"routeFromHAR","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.23","name":"har","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to a [HAR](http://www.softwareishard.com/blog/har-12-spec) file with prerecorded network data. If `path` is a relative path, then it is resolved relative to the current working directory."}],"required":true,"comment":"Path to a [HAR](http://www.softwareishard.com/blog/har-12-spec) file with prerecorded network data. If `path` is a\nrelative path, then it is resolved relative to the current working directory.","async":false,"alias":"har","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.23","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.23","name":"notFound","type":{"name":"HarNotFound","union":[{"name":"\"abort\""},{"name":"\"fallback\""}],"expression":"[HarNotFound]<\"abort\"|\"fallback\">"},"spec":[{"type":"li","text":"If set to 'abort' any request not found in the HAR file will be aborted.","liType":"bullet"},{"type":"li","text":"If set to 'fallback' falls through to the next route handler in the handler chain.","liType":"bullet"},{"type":"text","text":"Defaults to abort."}],"required":false,"comment":"- If set to 'abort' any request not found in the HAR file will be aborted.\n- If set to 'fallback' falls through to the next route handler in the handler chain.\n\nDefaults to abort.","async":false,"alias":"notFound","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.23","name":"update","type":{"name":"boolean","expression":"boolean"},"spec":[{"type":"text","text":"If specified, updates the given HAR with the actual network information instead of serving from file. The file is written to disk when [`method: BrowserContext.close`] is called."}],"required":false,"comment":"If specified, updates the given HAR with the actual network information instead of serving from file. The file is\nwritten to disk when [`method: BrowserContext.close`] is called.","async":false,"alias":"update","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.32","name":"updateContent","type":{"name":"RouteFromHarUpdateContentPolicy","union":[{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[RouteFromHarUpdateContentPolicy]<\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is specified, content is stored inline the HAR file."}],"required":false,"comment":"Optional setting to control resource content management. If `attach` is specified, resources are persisted as\nseparate files or entries in the ZIP archive. If `embed` is specified, content is stored inline the HAR file.","async":false,"alias":"updateContent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.32","name":"updateMode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `minimal`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to\n`minimal`.","async":false,"alias":"updateMode","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.23","name":"url","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"A glob pattern, regular expression or predicate to match the request URL. Only requests with URL matching the pattern will be served from the HAR file. If not specified, all requests are served from the HAR file."}],"required":false,"comment":"A glob pattern, regular expression or predicate to match the request URL. Only requests with URL matching the\npattern will be served from the HAR file. If not specified, all requests are served from the HAR file.","async":false,"alias":"url","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.48","name":"routeWebSocket","type":{"name":"void"},"spec":[{"type":"text","text":"This method allows to modify websocket connections that are made by any page in the browser context."},{"type":"text","text":"Note that only `WebSocket`s created after this method was called will be routed. It is recommended to call this method before creating any pages."},{"type":"text","text":"**Usage**"},{"type":"text","text":"Below is an example of a simple handler that blocks some websocket messages.↵See `WebSocketRoute` for more details and examples."},{"type":"code","lines":["await context.routeWebSocket('/ws', async ws => {","  ws.routeSend(message => {","    if (message === 'to-be-blocked')","      return;","    ws.send(message);","  });","  await ws.connect();","});"],"codeLang":"js"},{"type":"code","lines":["context.routeWebSocket(\"/ws\", ws -> {","  ws.routeSend(message -> {","    if (\"to-be-blocked\".equals(message))","      return;","    ws.send(message);","  });","  ws.connect();","});"],"codeLang":"java"},{"type":"code","lines":["def message_handler(ws: WebSocketRoute, message: Union[str, bytes]):","  if message == \"to-be-blocked\":","    return","  ws.send(message)","","async def handler(ws: WebSocketRoute):","  ws.route_send(lambda message: message_handler(ws, message))","  await ws.connect()","","await context.route_web_socket(\"/ws\", handler)"],"codeLang":"python async"},{"type":"code","lines":["def message_handler(ws: WebSocketRoute, message: Union[str, bytes]):","  if message == \"to-be-blocked\":","    return","  ws.send(message)","","def handler(ws: WebSocketRoute):","  ws.route_send(lambda message: message_handler(ws, message))","  ws.connect()","","context.route_web_socket(\"/ws\", handler)"],"codeLang":"python sync"},{"type":"code","lines":["await context.RouteWebSocketAsync(\"/ws\", async ws => {","  ws.RouteSend(message => {","    if (message == \"to-be-blocked\")","      return;","    ws.Send(message);","  });","  await ws.ConnectAsync();","});"],"codeLang":"csharp"}],"required":true,"comment":"This method allows to modify websocket connections that are made by any page in the browser context.\n\nNote that only `WebSocket`s created after this method was called will be routed. It is recommended to call this\nmethod before creating any pages.\n\n**Usage**\n\nBelow is an example of a simple handler that blocks some websocket messages. See `WebSocketRoute` for more details\nand examples.\n\n```js\nawait context.routeWebSocket('/ws', async ws => {\n  ws.routeSend(message => {\n    if (message === 'to-be-blocked')\n      return;\n    ws.send(message);\n  });\n  await ws.connect();\n});\n```\n\n```java\ncontext.routeWebSocket(\"/ws\", ws -> {\n  ws.routeSend(message -> {\n    if (\"to-be-blocked\".equals(message))\n      return;\n    ws.send(message);\n  });\n  ws.connect();\n});\n```\n\n```py\ndef message_handler(ws: WebSocketRoute, message: Union[str, bytes]):\n  if message == \"to-be-blocked\":\n    return\n  ws.send(message)\n\nasync def handler(ws: WebSocketRoute):\n  ws.route_send(lambda message: message_handler(ws, message))\n  await ws.connect()\n\nawait context.route_web_socket(\"/ws\", handler)\n```\n\n```py\ndef message_handler(ws: WebSocketRoute, message: Union[str, bytes]):\n  if message == \"to-be-blocked\":\n    return\n  ws.send(message)\n\ndef handler(ws: WebSocketRoute):\n  ws.route_send(lambda message: message_handler(ws, message))\n  ws.connect()\n\ncontext.route_web_socket(\"/ws\", handler)\n```\n\n```csharp\nawait context.RouteWebSocketAsync(\"/ws\", async ws => {\n  ws.RouteSend(message => {\n    if (message == \"to-be-blocked\")\n      return;\n    ws.Send(message);\n  });\n  await ws.ConnectAsync();\n});\n```\n","async":true,"alias":"routeWebSocket","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.48","name":"url","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"},{"name":"function","args":[{"name":"URL"}],"returnType":{"name":"boolean"}}],"expression":"[string]|[RegExp]|[function]([URL]):[boolean]"},"spec":[{"type":"text","text":"Only WebSockets with the url matching this pattern will be routed. A string pattern can be relative to the `baseURL` context option."}],"required":true,"comment":"Only WebSockets with the url matching this pattern will be routed. A string pattern can be relative to the\n`baseURL` context option.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.48","name":"handler","type":{"name":"function","args":[{"name":"WebSocketRoute"}],"returnType":{"name":"","union":[{"name":"Promise","templates":[{"name":"any"}]},{"name":"any"}]},"expression":"[function]([WebSocketRoute]): [Promise<any>|any]"},"spec":[{"type":"text","text":"Handler function to route the WebSocket."}],"required":true,"comment":"Handler function to route the WebSocket.","async":false,"alias":"handler","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.48","name":"handler","type":{"name":"function","args":[{"name":"WebSocketRoute"}],"expression":"[function]([WebSocketRoute])"},"spec":[{"type":"text","text":"Handler function to route the WebSocket."}],"required":true,"comment":"Handler function to route the WebSocket.","async":false,"alias":"handler","overloadIndex":0}]},{"kind":"method","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.11","name":"serviceWorkers","type":{"name":"Array","templates":[{"name":"Worker"}],"expression":"[Array]<[Worker]>"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"Service workers are only supported on Chromium-based browsers."}]},{"type":"text","text":"All existing service workers in the context."}],"required":true,"comment":"**NOTE** Service workers are only supported on Chromium-based browsers.\n\nAll existing service workers in the context.","async":false,"alias":"serviceWorkers","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"setDefaultNavigationTimeout","type":{"name":"void"},"spec":[{"type":"text","text":"This setting will change the default maximum navigation time for the following methods and related shortcuts:"},{"type":"li","text":"[`method: Page.goBack`]","liType":"bullet"},{"type":"li","text":"[`method: Page.goForward`]","liType":"bullet"},{"type":"li","text":"[`method: Page.goto`]","liType":"bullet"},{"type":"li","text":"[`method: Page.reload`]","liType":"bullet"},{"type":"li","text":"[`method: Page.setContent`]","liType":"bullet"},{"type":"li","text":"[`method: Page.waitForNavigation`]","liType":"bullet"},{"type":"note","noteType":"note","children":[{"type":"text","text":"[`method: Page.setDefaultNavigationTimeout`] and [`method: Page.setDefaultTimeout`] take priority over↵[`method: BrowserContext.setDefaultNavigationTimeout`]."}]}],"required":true,"comment":"This setting will change the default maximum navigation time for the following methods and related shortcuts:\n- [`method: Page.goBack`]\n- [`method: Page.goForward`]\n- [`method: Page.goto`]\n- [`method: Page.reload`]\n- [`method: Page.setContent`]\n- [`method: Page.waitForNavigation`]\n\n**NOTE** [`method: Page.setDefaultNavigationTimeout`] and [`method: Page.setDefaultTimeout`] take priority over\n[`method: BrowserContext.setDefaultNavigationTimeout`].\n","async":false,"alias":"setDefaultNavigationTimeout","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum navigation time in milliseconds"}],"required":true,"comment":"Maximum navigation time in milliseconds","async":false,"alias":"timeout","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"setDefaultTimeout","type":{"name":"void"},"spec":[{"type":"text","text":"This setting will change the default maximum time for all the methods accepting `timeout` option."},{"type":"note","noteType":"note","children":[{"type":"text","text":"[`method: Page.setDefaultNavigationTimeout`], [`method: Page.setDefaultTimeout`] and↵[`method: BrowserContext.setDefaultNavigationTimeout`] take priority over [`method: BrowserContext.setDefaultTimeout`]."}]}],"required":true,"comment":"This setting will change the default maximum time for all the methods accepting `timeout` option.\n\n**NOTE** [`method: Page.setDefaultNavigationTimeout`], [`method: Page.setDefaultTimeout`] and\n[`method: BrowserContext.setDefaultNavigationTimeout`] take priority over\n[`method: BrowserContext.setDefaultTimeout`].\n","async":false,"alias":"setDefaultTimeout","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Pass `0` to disable timeout."}],"required":true,"comment":"Maximum time in milliseconds. Pass `0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"setExtraHTTPHeaders","type":{"name":"void"},"spec":[{"type":"text","text":"The extra HTTP headers will be sent with every request initiated by any page in the context. These headers are merged↵with page-specific extra HTTP headers set with [`method: Page.setExtraHTTPHeaders`]. If page overrides a particular↵header, page-specific header value will be used instead of the browser context header value."},{"type":"note","noteType":"note","children":[{"type":"text","text":"[`method: BrowserContext.setExtraHTTPHeaders`] does not guarantee the order of headers in the outgoing requests."}]}],"required":true,"comment":"The extra HTTP headers will be sent with every request initiated by any page in the context. These headers are\nmerged with page-specific extra HTTP headers set with [`method: Page.setExtraHTTPHeaders`]. If page overrides a\nparticular header, page-specific header value will be used instead of the browser context header value.\n\n**NOTE** [`method: BrowserContext.setExtraHTTPHeaders`] does not guarantee the order of headers in the outgoing\nrequests.\n","async":true,"alias":"setExtraHTTPHeaders","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object containing additional HTTP headers to be sent with every request. All header values must be strings."}],"required":true,"comment":"An object containing additional HTTP headers to be sent with every request. All header values must be strings.","async":false,"alias":"headers","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"setGeolocation","type":{"name":"void"},"spec":[{"type":"text","text":"Sets the context's geolocation. Passing `null` or `undefined` emulates position unavailable."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await browserContext.setGeolocation({ latitude: 59.95, longitude: 30.31667 });"],"codeLang":"js"},{"type":"code","lines":["browserContext.setGeolocation(new Geolocation(59.95, 30.31667));"],"codeLang":"java"},{"type":"code","lines":["await browser_context.set_geolocation({\"latitude\": 59.95, \"longitude\": 30.31667})"],"codeLang":"python async"},{"type":"code","lines":["browser_context.set_geolocation({\"latitude\": 59.95, \"longitude\": 30.31667})"],"codeLang":"python sync"},{"type":"code","lines":["await context.SetGeolocationAsync(new Geolocation()","{","    Latitude = 59.95f,","    Longitude = 30.31667f","});"],"codeLang":"csharp"},{"type":"note","noteType":"note","children":[{"type":"text","text":"Consider using [`method: BrowserContext.grantPermissions`] to grant permissions for the browser context pages to read↵its geolocation."}]}],"required":true,"comment":"Sets the context's geolocation. Passing `null` or `undefined` emulates position unavailable.\n\n**Usage**\n\n```js\nawait browserContext.setGeolocation({ latitude: 59.95, longitude: 30.31667 });\n```\n\n```java\nbrowserContext.setGeolocation(new Geolocation(59.95, 30.31667));\n```\n\n```py\nawait browser_context.set_geolocation({\"latitude\": 59.95, \"longitude\": 30.31667})\n```\n\n```py\nbrowser_context.set_geolocation({\"latitude\": 59.95, \"longitude\": 30.31667})\n```\n\n```csharp\nawait context.SetGeolocationAsync(new Geolocation()\n{\n    Latitude = 59.95f,\n    Longitude = 30.31667f\n});\n```\n\n**NOTE** Consider using [`method: BrowserContext.grantPermissions`] to grant permissions for the browser context\npages to read its geolocation.\n","async":true,"alias":"setGeolocation","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"geolocation","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"latitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Latitude between -90 and 90."}],"required":true,"comment":"Latitude between -90 and 90.","async":false,"alias":"latitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"longitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Longitude between -180 and 180."}],"required":true,"comment":"Longitude between -180 and 180.","async":false,"alias":"longitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"accuracy","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Non-negative accuracy value. Defaults to `0`."}],"required":false,"comment":"Non-negative accuracy value. Defaults to `0`.","async":false,"alias":"accuracy","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[],"required":true,"comment":"","async":false,"alias":"geolocation","overloadIndex":0}]},{"kind":"method","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"Browsers may cache credentials after successful authentication. Create a new browser context instead.","name":"setHTTPCredentials","type":{"name":"void"},"spec":[],"required":true,"comment":"","async":true,"alias":"setHTTPCredentials","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"httpCredentials","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"password","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[],"required":true,"comment":"","async":false,"alias":"httpCredentials","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"setOffline","type":{"name":"void"},"spec":[],"required":true,"comment":"","async":true,"alias":"setOffline","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"offline","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to emulate network being offline for the browser context."}],"required":true,"comment":"Whether to emulate network being offline for the browser context.","async":false,"alias":"offline","overloadIndex":0}]},{"kind":"method","langs":{"types":{"csharp":{"name":"string","expression":"[string]"},"java":{"name":"string","expression":"[string]"}}},"since":"v1.8","name":"storageState","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"cookies","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"domain","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"domain","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"expires","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Unix time in seconds."}],"required":true,"comment":"Unix time in seconds.","async":false,"alias":"expires","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpOnly","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"httpOnly","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"secure","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"secure","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"sameSite","type":{"name":"SameSiteAttribute","union":[{"name":"\"Strict\""},{"name":"\"Lax\""},{"name":"\"None\""}],"expression":"[SameSiteAttribute]<\"Strict\"|\"Lax\"|\"None\">"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"sameSite","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"partitionKey","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":false,"comment":"","async":false,"alias":"partitionKey","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"cookies","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"origins","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"localStorage","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"value","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"localStorage","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"origins","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Returns storage state for this browser context, contains current cookies, local storage snapshot and IndexedDB snapshot."}],"required":true,"comment":"Returns storage state for this browser context, contains current cookies, local storage snapshot and IndexedDB\nsnapshot.","async":true,"alias":"storageState","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.51","name":"indexedDB","type":{"name":"boolean","expression":"boolean"},"spec":[{"type":"text","text":"Set to `true` to include [IndexedDB](https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API) in the storage state snapshot.↵If your application uses IndexedDB to store authentication tokens, like Firebase Authentication, enable this."}],"required":false,"comment":"Set to `true` to include [IndexedDB](https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API) in the storage\nstate snapshot. If your application uses IndexedDB to store authentication tokens, like Firebase Authentication,\nenable this.","async":false,"alias":"indexedDB","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"The file path to save the storage state to. If `path` is a relative path, then it is resolved relative to↵current working directory. If no path is provided, storage↵state is still returned, but won't be saved to the disk."}],"required":false,"comment":"The file path to save the storage state to. If `path` is a relative path, then it is resolved relative to current\nworking directory. If no path is provided, storage state is still returned, but won't be saved to the disk.","async":false,"alias":"path","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"property","langs":{},"since":"v1.12","name":"tracing","type":{"name":"Tracing","expression":"[Tracing]"},"spec":[],"required":true,"comment":"","async":false,"alias":"tracing","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.41","name":"unrouteAll","type":{"name":"void"},"spec":[{"type":"text","text":"Removes all routes created with [`method: BrowserContext.route`] and [`method: BrowserContext.routeFromHAR`]."}],"required":true,"comment":"Removes all routes created with [`method: BrowserContext.route`] and [`method: BrowserContext.routeFromHAR`].","async":true,"alias":"unrouteAll","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.41","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.41","name":"behavior","type":{"name":"UnrouteBehavior","union":[{"name":"\"wait\""},{"name":"\"ignoreErrors\""},{"name":"\"default\""}],"expression":"[UnrouteBehavior]<\"wait\"|\"ignoreErrors\"|\"default\">"},"spec":[{"type":"text","text":"Specifies whether to wait for already running handlers and what to do if they throw errors:"},{"type":"li","text":"`'default'` - do not wait for current handler calls (if any) to finish, if unrouted handler throws, it may result in unhandled error","liType":"bullet"},{"type":"li","text":"`'wait'` - wait for current handler calls (if any) to finish","liType":"bullet"},{"type":"li","text":"`'ignoreErrors'` - do not wait for current handler calls (if any) to finish, all errors thrown by the handlers after unrouting are silently caught","liType":"bullet"}],"required":false,"comment":"Specifies whether to wait for already running handlers and what to do if they throw errors:\n- `'default'` - do not wait for current handler calls (if any) to finish, if unrouted handler throws, it may\n  result in unhandled error\n- `'wait'` - wait for current handler calls (if any) to finish\n- `'ignoreErrors'` - do not wait for current handler calls (if any) to finish, all errors thrown by the handlers\n  after unrouting are silently caught","async":false,"alias":"behavior","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"unroute","type":{"name":"void"},"spec":[{"type":"text","text":"Removes a route created with [`method: BrowserContext.route`]. When `handler` is not specified, removes all↵routes for the `url`."}],"required":true,"comment":"Removes a route created with [`method: BrowserContext.route`]. When `handler` is not specified, removes all routes\nfor the `url`.","async":true,"alias":"unroute","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"url","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"},{"name":"function","args":[{"name":"URL"}],"returnType":{"name":"boolean"}}],"expression":"[string]|[RegExp]|[function]([URL]):[boolean]"},"spec":[{"type":"text","text":"A glob pattern, regex pattern or predicate receiving [URL] used to register a routing with↵[`method: BrowserContext.route`]."}],"required":true,"comment":"A glob pattern, regex pattern or predicate receiving [URL] used to register a routing with\n[`method: BrowserContext.route`].","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"handler","type":{"name":"function","args":[{"name":"Route"},{"name":"Request"}],"returnType":{"name":"","union":[{"name":"Promise","templates":[{"name":"any"}]},{"name":"any"}]},"expression":"[function]([Route], [Request]): [Promise<any>|any]"},"spec":[{"type":"text","text":"Optional handler function used to register a routing with [`method: BrowserContext.route`]."}],"required":false,"comment":"Optional handler function used to register a routing with [`method: BrowserContext.route`].","async":false,"alias":"handler","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"handler","type":{"name":"function","args":[{"name":"Route"}],"expression":"[function]([Route])"},"spec":[{"type":"text","text":"Optional handler function used to register a routing with [`method: BrowserContext.route`]."}],"required":false,"comment":"Optional handler function used to register a routing with [`method: BrowserContext.route`].","async":false,"alias":"handler","overloadIndex":0}]},{"kind":"method","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.32","name":"waitForCondition","type":{"name":"void"},"spec":[{"type":"text","text":"The method will block until the condition returns true. All Playwright events will↵be dispatched while the method is waiting for the condition."},{"type":"text","text":"**Usage**"},{"type":"text","text":"Use the method to wait for a condition that depends on page events:"},{"type":"code","lines":["List<String> failedUrls = new ArrayList<>();","context.onResponse(response -> {","  if (!response.ok()) {","    failedUrls.add(response.url());","  }","});","page1.getByText(\"Create user\").click();","page2.getByText(\"Submit button\").click();","context.waitForCondition(() -> failedUrls.size() > 3);"],"codeLang":"java"}],"required":true,"comment":"The method will block until the condition returns true. All Playwright events will be dispatched while the method\nis waiting for the condition.\n\n**Usage**\n\nUse the method to wait for a condition that depends on page events:\n\n```java\nList<String> failedUrls = new ArrayList<>();\ncontext.onResponse(response -> {\n  if (!response.ok()) {\n    failedUrls.add(response.url());\n  }\n});\npage1.getByText(\"Create user\").click();\npage2.getByText(\"Submit button\").click();\ncontext.waitForCondition(() -> failedUrls.size() > 3);\n```\n","async":true,"alias":"waitForCondition","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.32","name":"condition","type":{"name":"BooleanSupplier","expression":"[BooleanSupplier]"},"spec":[{"type":"text","text":"Condition to wait for."}],"required":true,"comment":"Condition to wait for.","async":false,"alias":"condition","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.32","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.32","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default↵value can be changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"only":["java","python","csharp"],"aliases":{"python":"expect_console_message","csharp":"RunAndWaitForConsoleMessage"},"types":{"python":{"name":"EventContextManager","templates":[{"name":"ConsoleMessage"}],"expression":"[EventContextManager]<[ConsoleMessage]>"}},"overrides":{}},"since":"v1.34","name":"waitForConsoleMessage","type":{"name":"ConsoleMessage","expression":"[ConsoleMessage]"},"spec":[{"type":"text","text":"Performs action and waits for a `ConsoleMessage` to be logged by in the pages in the context. If predicate is provided, it passes↵`ConsoleMessage` value into the `predicate` function and waits for `predicate(message)` to return a truthy value.↵Will throw an error if the page is closed before the [`event: BrowserContext.console`] event is fired."}],"required":true,"comment":"Performs action and waits for a `ConsoleMessage` to be logged by in the pages in the context. If predicate is\nprovided, it passes `ConsoleMessage` value into the `predicate` function and waits for `predicate(message)` to\nreturn a truthy value. Will throw an error if the page is closed before the [`event: BrowserContext.console`] event\nis fired.","async":true,"alias":"waitForConsoleMessage","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.34","name":"action","type":{"name":"Func","templates":[{"name":"Task"}],"expression":"[Func<Task>]"},"spec":[{"type":"text","text":"Action that triggers the event."}],"required":true,"comment":"Action that triggers the event.","async":false,"alias":"action","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.34","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.34","name":"predicate","type":{"name":"function","args":[{"name":"ConsoleMessage"}],"returnType":{"name":"boolean"},"expression":"[function]([ConsoleMessage]):[boolean]"},"spec":[{"type":"text","text":"Receives the `ConsoleMessage` object and resolves to truthy value when the waiting should resolve."}],"required":false,"comment":"Receives the `ConsoleMessage` object and resolves to truthy value when the waiting should resolve.","async":false,"alias":"predicate","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.34","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.↵The default value can be changed by using the [`method: BrowserContext.setDefaultTimeout`]."}],"required":false,"comment":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: BrowserContext.setDefaultTimeout`].","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.34","name":"callback","type":{"name":"Runnable","expression":"[Runnable]"},"spec":[{"type":"text","text":"Callback that performs the action triggering the event."}],"required":true,"comment":"Callback that performs the action triggering the event.","async":false,"alias":"callback","overloadIndex":0}]},{"kind":"method","langs":{"only":["js","python"],"aliases":{"python":"expect_event"},"types":{"python":{"name":"EventContextManager","expression":"[EventContextManager]"}},"overrides":{}},"since":"v1.8","name":"waitForEvent","type":{"name":"any","expression":"[any]"},"spec":[{"type":"text","text":"Waits for event to fire and passes its value into the predicate function. Returns when the predicate returns truthy↵value. Will throw an error if the context closes before the event is fired. Returns the event data value."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const pagePromise = context.waitForEvent('page');","await page.getByRole('button').click();","const page = await pagePromise;"],"codeLang":"js"},{"type":"code","lines":["Page newPage = context.waitForPage(() -> page.getByRole(AriaRole.BUTTON).click());"],"codeLang":"java"},{"type":"code","lines":["async with context.expect_event(\"page\") as event_info:","    await page.get_by_role(\"button\").click()","page = await event_info.value"],"codeLang":"python async"},{"type":"code","lines":["with context.expect_event(\"page\") as event_info:","    page.get_by_role(\"button\").click()","page = event_info.value"],"codeLang":"python sync"},{"type":"code","lines":["var page = await context.RunAndWaitForPageAsync(async () =>","{","    await page.GetByRole(AriaRole.Button).ClickAsync();","});"],"codeLang":"csharp"}],"required":true,"comment":"Waits for event to fire and passes its value into the predicate function. Returns when the predicate returns truthy\nvalue. Will throw an error if the context closes before the event is fired. Returns the event data value.\n\n**Usage**\n\n```js\nconst pagePromise = context.waitForEvent('page');\nawait page.getByRole('button').click();\nconst page = await pagePromise;\n```\n\n```java\nPage newPage = context.waitForPage(() -> page.getByRole(AriaRole.BUTTON).click());\n```\n\n```py\nasync with context.expect_event(\"page\") as event_info:\n    await page.get_by_role(\"button\").click()\npage = await event_info.value\n```\n\n```py\nwith context.expect_event(\"page\") as event_info:\n    page.get_by_role(\"button\").click()\npage = event_info.value\n```\n\n```csharp\nvar page = await context.RunAndWaitForPageAsync(async () =>\n{\n    await page.GetByRole(AriaRole.Button).ClickAsync();\n});\n```\n","async":true,"alias":"waitForEvent","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"event","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Event name, same one would pass into `browserContext.on(event)`."}],"required":true,"comment":"Event name, same one would pass into `browserContext.on(event)`.","async":false,"alias":"event","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"optionsOrPredicate","type":{"name":"","union":[{"name":"function"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"predicate","type":{"name":"function","expression":"[function]"},"spec":[{"type":"text","text":"Receives the event data and resolves to truthy value when the waiting should resolve."}],"required":true,"comment":"Receives the event data and resolves to truthy value when the waiting should resolve.","async":false,"alias":"predicate","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time to wait for in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] method."}],"required":false,"comment":"Maximum time to wait for in milliseconds. Defaults to `0` - no timeout. The default value can be changed via\n`actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] method.","async":false,"alias":"timeout","overloadIndex":0}]}],"expression":"[function]|[Object]"},"spec":[{"type":"text","text":"Either a predicate that receives an event or an options object. Optional."}],"required":false,"comment":"Either a predicate that receives an event or an options object. Optional.","async":false,"alias":"optionsOrPredicate","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"predicate","type":{"name":"function","expression":"[function]"},"spec":[{"type":"text","text":"Receives the event data and resolves to truthy value when the waiting should resolve."}],"required":false,"comment":"Receives the event data and resolves to truthy value when the waiting should resolve.","async":false,"alias":"predicate","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.↵The default value can be changed by using the [`method: BrowserContext.setDefaultTimeout`]."}],"required":false,"comment":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: BrowserContext.setDefaultTimeout`].","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"only":["java","python","csharp"],"aliases":{"python":"expect_page","csharp":"RunAndWaitForPage"},"types":{"python":{"name":"EventContextManager","templates":[{"name":"Page"}],"expression":"[EventContextManager]<[Page]>"}},"overrides":{}},"since":"v1.9","name":"waitForPage","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Performs action and waits for a new `Page` to be created in the context. If predicate is provided, it passes↵`Page` value into the `predicate` function and waits for `predicate(event)` to return a truthy value.↵Will throw an error if the context closes before new `Page` is created."}],"required":true,"comment":"Performs action and waits for a new `Page` to be created in the context. If predicate is provided, it passes `Page`\nvalue into the `predicate` function and waits for `predicate(event)` to return a truthy value. Will throw an error\nif the context closes before new `Page` is created.","async":true,"alias":"waitForPage","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.12","name":"action","type":{"name":"Func","templates":[{"name":"Task"}],"expression":"[Func<Task>]"},"spec":[{"type":"text","text":"Action that triggers the event."}],"required":true,"comment":"Action that triggers the event.","async":false,"alias":"action","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"predicate","type":{"name":"function","args":[{"name":"Page"}],"returnType":{"name":"boolean"},"expression":"[function]([Page]):[boolean]"},"spec":[{"type":"text","text":"Receives the `Page` object and resolves to truthy value when the waiting should resolve."}],"required":false,"comment":"Receives the `Page` object and resolves to truthy value when the waiting should resolve.","async":false,"alias":"predicate","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.↵The default value can be changed by using the [`method: BrowserContext.setDefaultTimeout`]."}],"required":false,"comment":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: BrowserContext.setDefaultTimeout`].","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"callback","type":{"name":"Runnable","expression":"[Runnable]"},"spec":[{"type":"text","text":"Callback that performs the action triggering the event."}],"required":true,"comment":"Callback that performs the action triggering the event.","async":false,"alias":"callback","overloadIndex":0}]},{"kind":"method","langs":{"only":["python"],"aliases":{"python":"wait_for_event"},"types":{},"overrides":{}},"since":"v1.8","name":"waitForEvent2","type":{"name":"any","expression":"[any]"},"spec":[{"type":"note","noteType":"note","children":[{"type":"text","text":"In most cases, you should use [`method: BrowserContext.waitForEvent`]."}]},{"type":"text","text":"Waits for given `event` to fire. If predicate is provided, it passes↵event's value into the `predicate` function and waits for `predicate(event)` to return a truthy value.↵Will throw an error if the browser context is closed before the `event` is fired."}],"required":true,"comment":"**NOTE** In most cases, you should use [`method: BrowserContext.waitForEvent`].\n\nWaits for given `event` to fire. If predicate is provided, it passes event's value into the `predicate` function\nand waits for `predicate(event)` to return a truthy value. Will throw an error if the browser context is closed\nbefore the `event` is fired.","async":true,"alias":"waitForEvent2","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["js","python","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"event","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Event name, same one typically passed into `*.on(event)`."}],"required":true,"comment":"Event name, same one typically passed into `*.on(event)`.","async":false,"alias":"event","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"predicate","type":{"name":"function","expression":"[function]"},"spec":[{"type":"text","text":"Receives the event data and resolves to truthy value when the waiting should resolve."}],"required":false,"comment":"Receives the event data and resolves to truthy value when the waiting should resolve.","async":false,"alias":"predicate","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout.↵The default value can be changed by using the [`method: BrowserContext.setDefaultTimeout`]."}],"required":false,"comment":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: BrowserContext.setDefaultTimeout`].","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]}]},{"name":"BrowserServer","spec":[],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","members":[{"kind":"event","langs":{},"since":"v1.8","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Emitted when the browser server closes."}],"required":true,"comment":"Emitted when the browser server closes.","async":false,"alias":"close","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Closes the browser gracefully and makes sure the process is terminated."}],"required":true,"comment":"Closes the browser gracefully and makes sure the process is terminated.","async":true,"alias":"close","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"kill","type":{"name":"void"},"spec":[{"type":"text","text":"Kills the browser process and waits for the process to exit."}],"required":true,"comment":"Kills the browser process and waits for the process to exit.","async":true,"alias":"kill","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"process","type":{"name":"ChildProcess","expression":"[ChildProcess]"},"spec":[{"type":"text","text":"Spawned browser application process."}],"required":true,"comment":"Spawned browser application process.","async":false,"alias":"process","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"wsEndpoint","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Browser websocket url."},{"type":"text","text":"Browser websocket endpoint which can be used as an argument to [`method: BrowserType.connect`] to establish connection↵to the browser."},{"type":"text","text":"Note that if the listen `host` option in `launchServer` options is not specified, localhost will be output anyway, even if the actual listening address is an unspecified address."}],"required":true,"comment":"Browser websocket url.\n\nBrowser websocket endpoint which can be used as an argument to [`method: BrowserType.connect`] to establish\nconnection to the browser.\n\nNote that if the listen `host` option in `launchServer` options is not specified, localhost will be output anyway,\neven if the actual listening address is an unspecified address.","async":false,"alias":"wsEndpoint","overloadIndex":0,"args":[]}]},{"name":"BrowserType","spec":[{"type":"text","text":"BrowserType provides methods to launch a specific browser instance or connect to an existing one. The following is a↵typical example of using Playwright to drive automation:"},{"type":"code","lines":["const { chromium } = require('playwright');  // Or 'firefox' or 'webkit'.","","(async () => {","  const browser = await chromium.launch();","  const page = await browser.newPage();","  await page.goto('https://example.com');","  // other actions...","  await browser.close();","})();"],"codeLang":"js"},{"type":"code","lines":["import com.microsoft.playwright.*;","","public class Example {","  public static void main(String[] args) {","    try (Playwright playwright = Playwright.create()) {","      BrowserType chromium = playwright.chromium();","      Browser browser = chromium.launch();","      Page page = browser.newPage();","      page.navigate(\"https://example.com\");","      // other actions...","      browser.close();","    }","  }","}"],"codeLang":"java"},{"type":"code","lines":["import asyncio","from playwright.async_api import async_playwright, Playwright","","async def run(playwright: Playwright):","    chromium = playwright.chromium","    browser = await chromium.launch()","    page = await browser.new_page()","    await page.goto(\"https://example.com\")","    # other actions...","    await browser.close()","","async def main():","    async with async_playwright() as playwright:","        await run(playwright)","asyncio.run(main())"],"codeLang":"python async"},{"type":"code","lines":["from playwright.sync_api import sync_playwright, Playwright","","def run(playwright: Playwright):","    chromium = playwright.chromium","    browser = chromium.launch()","    page = browser.new_page()","    page.goto(\"https://example.com\")","    # other actions...","    browser.close()","","with sync_playwright() as playwright:","    run(playwright)"],"codeLang":"python sync"},{"type":"code","lines":["using Microsoft.Playwright;","using System.Threading.Tasks;","","class BrowserTypeExamples","{","    public static async Task Run()","    {","        using var playwright = await Playwright.CreateAsync();","        var chromium = playwright.Chromium;","        var browser = await chromium.LaunchAsync();","        var page = await browser.NewPageAsync();","        await page.GotoAsync(\"https://www.bing.com\");","        // other actions","        await browser.CloseAsync();","    }","}"],"codeLang":"csharp"}],"langs":{},"comment":"BrowserType provides methods to launch a specific browser instance or connect to an existing one. The following is\na typical example of using Playwright to drive automation:\n\n```js\nconst { chromium } = require('playwright');  // Or 'firefox' or 'webkit'.\n\n(async () => {\n  const browser = await chromium.launch();\n  const page = await browser.newPage();\n  await page.goto('https://example.com');\n  // other actions...\n  await browser.close();\n})();\n```\n\n```java\nimport com.microsoft.playwright.*;\n\npublic class Example {\n  public static void main(String[] args) {\n    try (Playwright playwright = Playwright.create()) {\n      BrowserType chromium = playwright.chromium();\n      Browser browser = chromium.launch();\n      Page page = browser.newPage();\n      page.navigate(\"https://example.com\");\n      // other actions...\n      browser.close();\n    }\n  }\n}\n```\n\n```py\nimport asyncio\nfrom playwright.async_api import async_playwright, Playwright\n\nasync def run(playwright: Playwright):\n    chromium = playwright.chromium\n    browser = await chromium.launch()\n    page = await browser.new_page()\n    await page.goto(\"https://example.com\")\n    # other actions...\n    await browser.close()\n\nasync def main():\n    async with async_playwright() as playwright:\n        await run(playwright)\nasyncio.run(main())\n```\n\n```py\nfrom playwright.sync_api import sync_playwright, Playwright\n\ndef run(playwright: Playwright):\n    chromium = playwright.chromium\n    browser = chromium.launch()\n    page = browser.new_page()\n    page.goto(\"https://example.com\")\n    # other actions...\n    browser.close()\n\nwith sync_playwright() as playwright:\n    run(playwright)\n```\n\n```csharp\nusing Microsoft.Playwright;\nusing System.Threading.Tasks;\n\nclass BrowserTypeExamples\n{\n    public static async Task Run()\n    {\n        using var playwright = await Playwright.CreateAsync();\n        var chromium = playwright.Chromium;\n        var browser = await chromium.LaunchAsync();\n        var page = await browser.NewPageAsync();\n        await page.GotoAsync(\"https://www.bing.com\");\n        // other actions\n        await browser.CloseAsync();\n    }\n}\n```\n","since":"v1.8","members":[{"kind":"method","langs":{},"since":"v1.8","name":"connect","type":{"name":"Browser","expression":"[Browser]"},"spec":[{"type":"text","text":"This method attaches Playwright to an existing browser instance created via `BrowserType.launchServer` in Node.js."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The major and minor version of the Playwright instance that connects needs to match the version of Playwright that launches the browser (1.2.3 → is compatible with 1.2.x)."}]}],"required":true,"comment":"This method attaches Playwright to an existing browser instance created via `BrowserType.launchServer` in Node.js.\n\n**NOTE** The major and minor version of the Playwright instance that connects needs to match the version of\nPlaywright that launches the browser (1.2.3 → is compatible with 1.2.x).\n","async":true,"alias":"connect","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.10","name":"wsEndpoint","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A Playwright browser websocket endpoint to connect to. You obtain this endpoint via `BrowserServer.wsEndpoint`."}],"required":true,"comment":"A Playwright browser websocket endpoint to connect to. You obtain this endpoint via `BrowserServer.wsEndpoint`.","async":false,"alias":"wsEndpoint","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.37","name":"exposeNetwork","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"This option exposes network available on the connecting client to the browser being connected to. Consists of a list of rules separated by comma."},{"type":"text","text":"Available rules:"},{"type":"li","text":"Hostname pattern, for example: `example.com`, `*.org:99`, `x.*.y.com`, `*foo.org`.","liType":"ordinal"},{"type":"li","text":"IP literal, for example: `127.0.0.1`, `0.0.0.0:99`, `[::1]`, `[0:0::1]:99`.","liType":"ordinal"},{"type":"li","text":"`<loopback>` that matches local loopback interfaces: `localhost`, `*.localhost`, `127.0.0.1`, `[::1]`.","liType":"ordinal"},{"type":"text","text":"Some common examples:"},{"type":"li","text":"`\"*\"` to expose all network.","liType":"ordinal"},{"type":"li","text":"`\"<loopback>\"` to expose localhost network.","liType":"ordinal"},{"type":"li","text":"`\"*.test.internal-domain,*.staging.internal-domain,<loopback>\"` to expose test/staging deployments and localhost.","liType":"ordinal"}],"required":false,"comment":"This option exposes network available on the connecting client to the browser being connected to. Consists of a\nlist of rules separated by comma.\n\nAvailable rules:\n1. Hostname pattern, for example: `example.com`, `*.org:99`, `x.*.y.com`, `*foo.org`.\n1. IP literal, for example: `127.0.0.1`, `0.0.0.0:99`, `[::1]`, `[0:0::1]:99`.\n1. `<loopback>` that matches local loopback interfaces: `localhost`, `*.localhost`, `127.0.0.1`, `[::1]`.\n\nSome common examples:\n1. `\"*\"` to expose all network.\n1. `\"<loopback>\"` to expose localhost network.\n1. `\"*.test.internal-domain,*.staging.internal-domain,<loopback>\"` to expose test/staging deployments and\n   localhost.","async":false,"alias":"exposeNetwork","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Additional HTTP headers to be sent with web socket connect request. Optional."}],"required":false,"comment":"Additional HTTP headers to be sent with web socket connect request. Optional.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.14","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging. Optional."}],"required":false,"comment":"Logger sink for Playwright logging. Optional.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.10","name":"slowMo","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you↵can see what is going on. Defaults to 0."}],"required":false,"comment":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you can see what is going\non. Defaults to 0.","async":false,"alias":"slowMo","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.10","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the connection to be established. Defaults to↵`0` (no timeout)."}],"required":false,"comment":"Maximum time in milliseconds to wait for the connection to be established. Defaults to `0` (no timeout).","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"connectOverCDP","type":{"name":"Browser","expression":"[Browser]"},"spec":[{"type":"text","text":"This method attaches Playwright to an existing browser instance using the Chrome DevTools Protocol."},{"type":"text","text":"The default browser context is accessible via [`method: Browser.contexts`]."},{"type":"note","noteType":"note","children":[{"type":"text","text":"Connecting over the Chrome DevTools Protocol is only supported for Chromium-based browsers."}]},{"type":"note","noteType":"note","children":[{"type":"text","text":"This connection is significantly lower fidelity than the Playwright protocol connection via [`method: BrowserType.connect`]. If you are experiencing issues or attempting to use advanced functionality, you probably want to use [`method: BrowserType.connect`]."}]},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const browser = await playwright.chromium.connectOverCDP('http://localhost:9222');","const defaultContext = browser.contexts()[0];","const page = defaultContext.pages()[0];"],"codeLang":"js"},{"type":"code","lines":["Browser browser = playwright.chromium().connectOverCDP(\"http://localhost:9222\");","BrowserContext defaultContext = browser.contexts().get(0);","Page page = defaultContext.pages().get(0);"],"codeLang":"java"},{"type":"code","lines":["browser = await playwright.chromium.connect_over_cdp(\"http://localhost:9222\")","default_context = browser.contexts[0]","page = default_context.pages[0]"],"codeLang":"python async"},{"type":"code","lines":["browser = playwright.chromium.connect_over_cdp(\"http://localhost:9222\")","default_context = browser.contexts[0]","page = default_context.pages[0]"],"codeLang":"python sync"},{"type":"code","lines":["var browser = await playwright.Chromium.ConnectOverCDPAsync(\"http://localhost:9222\");","var defaultContext = browser.Contexts[0];","var page = defaultContext.Pages[0];"],"codeLang":"csharp"}],"required":true,"comment":"This method attaches Playwright to an existing browser instance using the Chrome DevTools Protocol.\n\nThe default browser context is accessible via [`method: Browser.contexts`].\n\n**NOTE** Connecting over the Chrome DevTools Protocol is only supported for Chromium-based browsers.\n\n**NOTE** This connection is significantly lower fidelity than the Playwright protocol connection via\n[`method: BrowserType.connect`]. If you are experiencing issues or attempting to use advanced functionality, you\nprobably want to use [`method: BrowserType.connect`].\n\n**Usage**\n\n```js\nconst browser = await playwright.chromium.connectOverCDP('http://localhost:9222');\nconst defaultContext = browser.contexts()[0];\nconst page = defaultContext.pages()[0];\n```\n\n```java\nBrowser browser = playwright.chromium().connectOverCDP(\"http://localhost:9222\");\nBrowserContext defaultContext = browser.contexts().get(0);\nPage page = defaultContext.pages().get(0);\n```\n\n```py\nbrowser = await playwright.chromium.connect_over_cdp(\"http://localhost:9222\")\ndefault_context = browser.contexts[0]\npage = default_context.pages[0]\n```\n\n```py\nbrowser = playwright.chromium.connect_over_cdp(\"http://localhost:9222\")\ndefault_context = browser.contexts[0]\npage = default_context.pages[0]\n```\n\n```csharp\nvar browser = await playwright.Chromium.ConnectOverCDPAsync(\"http://localhost:9222\");\nvar defaultContext = browser.Contexts[0];\nvar page = defaultContext.Pages[0];\n```\n","async":true,"alias":"connectOverCDP","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.11","name":"endpointURL","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A CDP websocket endpoint or http url to connect to. For example `http://localhost:9222/` or `ws://127.0.0.1:9222/devtools/browser/387adf4c-243f-4051-a181-46798f4a46f4`."}],"required":true,"comment":"A CDP websocket endpoint or http url to connect to. For example `http://localhost:9222/` or\n`ws://127.0.0.1:9222/devtools/browser/387adf4c-243f-4051-a181-46798f4a46f4`.","async":false,"alias":"endpointURL","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.14","deprecated":"Use the first argument instead.","name":"endpointURL","type":{"name":"string","expression":"[string]"},"spec":[],"required":false,"comment":"","async":false,"alias":"endpointURL","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"headers","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Additional HTTP headers to be sent with connect request. Optional."}],"required":false,"comment":"Additional HTTP headers to be sent with connect request. Optional.","async":false,"alias":"headers","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.14","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging. Optional."}],"required":false,"comment":"Logger sink for Playwright logging. Optional.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"slowMo","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you↵can see what is going on. Defaults to 0."}],"required":false,"comment":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you can see what is going\non. Defaults to 0.","async":false,"alias":"slowMo","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the connection to be established. Defaults to↵`30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Maximum time in milliseconds to wait for the connection to be established. Defaults to `30000` (30 seconds). Pass\n`0` to disable timeout.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"executablePath","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A path where Playwright expects to find a bundled browser executable."}],"required":true,"comment":"A path where Playwright expects to find a bundled browser executable.","async":false,"alias":"executablePath","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"launch","type":{"name":"Browser","expression":"[Browser]"},"spec":[{"type":"text","text":"Returns the browser instance."},{"type":"text","text":"**Usage**"},{"type":"text","text":"You can use `ignoreDefaultArgs` to filter out `--mute-audio` from default arguments:"},{"type":"code","lines":["const browser = await chromium.launch({  // Or 'firefox' or 'webkit'.","  ignoreDefaultArgs: ['--mute-audio']","});"],"codeLang":"js"},{"type":"code","lines":["// Or \"firefox\" or \"webkit\".","Browser browser = chromium.launch(new BrowserType.LaunchOptions()","  .setIgnoreDefaultArgs(Arrays.asList(\"--mute-audio\")));"],"codeLang":"java"},{"type":"code","lines":["browser = await playwright.chromium.launch( # or \"firefox\" or \"webkit\".","    ignore_default_args=[\"--mute-audio\"]",")"],"codeLang":"python async"},{"type":"code","lines":["browser = playwright.chromium.launch( # or \"firefox\" or \"webkit\".","    ignore_default_args=[\"--mute-audio\"]",")"],"codeLang":"python sync"},{"type":"code","lines":["var browser = await playwright.Chromium.LaunchAsync(new() {","    IgnoreDefaultArgs = new[] { \"--mute-audio\" }","});"],"codeLang":"csharp"},{"type":"text","text":"> **Chromium-only** Playwright can also be used to control the Google Chrome or Microsoft Edge browsers, but it works best with the version of↵Chromium it is bundled with. There is no guarantee it will work with any other version. Use `executablePath`↵option with extreme caution."},{"type":"text","text":">"},{"type":"text","text":"> If Google Chrome (rather than Chromium) is preferred, a↵[Chrome Canary](https://www.google.com/chrome/browser/canary.html) or↵[Dev Channel](https://www.chromium.org/getting-involved/dev-channel) build is suggested."},{"type":"text","text":">"},{"type":"text","text":"> Stock browsers like Google Chrome and Microsoft Edge are suitable for tests that require proprietary media codecs for video playback. See [this article](https://www.howtogeek.com/202825/what%E2%80%99s-the-difference-between-chromium-and-chrome/) for other differences between Chromium and Chrome.↵[This article](https://chromium.googlesource.com/chromium/src/+/lkgr/docs/chromium_browser_vs_google_chrome.md)↵describes some differences for Linux users."}],"required":true,"comment":"Returns the browser instance.\n\n**Usage**\n\nYou can use `ignoreDefaultArgs` to filter out `--mute-audio` from default arguments:\n\n```js\nconst browser = await chromium.launch({  // Or 'firefox' or 'webkit'.\n  ignoreDefaultArgs: ['--mute-audio']\n});\n```\n\n```java\n// Or \"firefox\" or \"webkit\".\nBrowser browser = chromium.launch(new BrowserType.LaunchOptions()\n  .setIgnoreDefaultArgs(Arrays.asList(\"--mute-audio\")));\n```\n\n```py\nbrowser = await playwright.chromium.launch( # or \"firefox\" or \"webkit\".\n    ignore_default_args=[\"--mute-audio\"]\n)\n```\n\n```py\nbrowser = playwright.chromium.launch( # or \"firefox\" or \"webkit\".\n    ignore_default_args=[\"--mute-audio\"]\n)\n```\n\n```csharp\nvar browser = await playwright.Chromium.LaunchAsync(new() {\n    IgnoreDefaultArgs = new[] { \"--mute-audio\" }\n});\n```\n\n> **Chromium-only** Playwright can also be used to control the Google Chrome or Microsoft Edge browsers, but it\nworks best with the version of Chromium it is bundled with. There is no guarantee it will work with any other\nversion. Use `executablePath` option with extreme caution.\n>\n> If Google Chrome (rather than Chromium) is preferred, a\n[Chrome Canary](https://www.google.com/chrome/browser/canary.html) or\n[Dev Channel](https://www.chromium.org/getting-involved/dev-channel) build is suggested.\n>\n> Stock browsers like Google Chrome and Microsoft Edge are suitable for tests that require proprietary media codecs\nfor video playback. See\n[this article](https://www.howtogeek.com/202825/what%E2%80%99s-the-difference-between-chromium-and-chrome/) for\nother differences between Chromium and Chrome.\n[This article](https://chromium.googlesource.com/chromium/src/+/lkgr/docs/chromium_browser_vs_google_chrome.md)\ndescribes some differences for Linux users.","async":true,"alias":"launch","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"args","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"note","noteType":"warning","children":[{"type":"text","text":"Use custom browser args at your own risk, as some of them may break Playwright functionality."}]},{"type":"text","text":"Additional arguments to pass to the browser instance. The list of Chromium flags can be found↵[here](https://peter.sh/experiments/chromium-command-line-switches/)."}],"required":false,"comment":"**NOTE** Use custom browser args at your own risk, as some of them may break Playwright functionality.\n\nAdditional arguments to pass to the browser instance. The list of Chromium flags can be found\n[here](https://peter.sh/experiments/chromium-command-line-switches/).","async":false,"alias":"args","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"channel","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Browser distribution channel."},{"type":"text","text":"Use \"chromium\" to [opt in to new headless mode](../browsers.md#chromium-new-headless-mode)."},{"type":"text","text":"Use \"chrome\", \"chrome-beta\", \"chrome-dev\", \"chrome-canary\", \"msedge\", \"msedge-beta\", \"msedge-dev\", or \"msedge-canary\" to use branded [Google Chrome and Microsoft Edge](../browsers.md#google-chrome--microsoft-edge)."}],"required":false,"comment":"Browser distribution channel.\n\nUse \"chromium\" to [opt in to new headless mode](../browsers.md#chromium-new-headless-mode).\n\nUse \"chrome\", \"chrome-beta\", \"chrome-dev\", \"chrome-canary\", \"msedge\", \"msedge-beta\", \"msedge-dev\", or\n\"msedge-canary\" to use branded [Google Chrome and Microsoft Edge](../browsers.md#google-chrome--microsoft-edge).","async":false,"alias":"channel","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"chromiumSandbox","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Enable Chromium sandboxing. Defaults to `false`."}],"required":false,"comment":"Enable Chromium sandboxing. Defaults to `false`.","async":false,"alias":"chromiumSandbox","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"Use [debugging tools](../debug.md) instead.","name":"devtools","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"**Chromium-only** Whether to auto-open a Developer Tools panel for each tab. If this option is `true`, the↵`headless` option will be set `false`."}],"required":false,"comment":"**Chromium-only** Whether to auto-open a Developer Tools panel for each tab. If this option is `true`, the\n`headless` option will be set `false`.","async":false,"alias":"devtools","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"downloadsPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"If specified, accepted downloads are downloaded into this directory. Otherwise, temporary directory is created and is↵deleted when browser is closed. In either case, the downloads are deleted when the browser context they were created in↵is closed."}],"required":false,"comment":"If specified, accepted downloads are downloaded into this directory. Otherwise, temporary directory is created and\nis deleted when browser is closed. In either case, the downloads are deleted when the browser context they were\ncreated in is closed.","async":false,"alias":"downloadsPath","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"env","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Specify environment variables that will be visible to the browser. Defaults to `process.env`."}],"required":false,"comment":"Specify environment variables that will be visible to the browser. Defaults to `process.env`.","async":false,"alias":"env","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"env","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Specify environment variables that will be visible to the browser. Defaults to `process.env`."}],"required":false,"comment":"Specify environment variables that will be visible to the browser. Defaults to `process.env`.","async":false,"alias":"env","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"executablePath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to a browser executable to run instead of the bundled one. If `executablePath` is a relative path, then↵it is resolved relative to the current working directory. Note that Playwright only works with the bundled Chromium,↵Firefox or WebKit, use at your own risk."}],"required":false,"comment":"Path to a browser executable to run instead of the bundled one. If `executablePath` is a relative path, then it is\nresolved relative to the current working directory. Note that Playwright only works with the bundled Chromium,\nFirefox or WebKit, use at your own risk.","async":false,"alias":"executablePath","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"firefoxUserPrefs","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Firefox user preferences. Learn more about the Firefox user preferences at↵[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox)."},{"type":"text","text":"You can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via `PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable."}],"required":false,"comment":"Firefox user preferences. Learn more about the Firefox user preferences at\n[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox).\n\nYou can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via\n`PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable.","async":false,"alias":"firefoxUserPrefs","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"firefoxUserPrefs","type":{"name":"Object","templates":[{"name":"string"},{"name":"any"}],"expression":"[Object]<[string], [any]>"},"spec":[{"type":"text","text":"Firefox user preferences. Learn more about the Firefox user preferences at↵[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox)."},{"type":"text","text":"You can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via `PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable."}],"required":false,"comment":"Firefox user preferences. Learn more about the Firefox user preferences at\n[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox).\n\nYou can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via\n`PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable.","async":false,"alias":"firefoxUserPrefs","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGHUP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on SIGHUP. Defaults to `true`."}],"required":false,"comment":"Close the browser process on SIGHUP. Defaults to `true`.","async":false,"alias":"handleSIGHUP","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGINT","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on Ctrl-C. Defaults to `true`."}],"required":false,"comment":"Close the browser process on Ctrl-C. Defaults to `true`.","async":false,"alias":"handleSIGINT","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGTERM","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on SIGTERM. Defaults to `true`."}],"required":false,"comment":"Close the browser process on SIGTERM. Defaults to `true`.","async":false,"alias":"handleSIGTERM","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"headless","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to run browser in headless mode. More details for↵[Chromium](https://developers.google.com/web/updates/2017/04/headless-chrome) and↵[Firefox](https://hacks.mozilla.org/2017/12/using-headless-mode-in-firefox/). Defaults to `true` unless the↵`devtools` option is `true`."}],"required":false,"comment":"Whether to run browser in headless mode. More details for\n[Chromium](https://developers.google.com/web/updates/2017/04/headless-chrome) and\n[Firefox](https://hacks.mozilla.org/2017/12/using-headless-mode-in-firefox/). Defaults to `true` unless the\n`devtools` option is `true`.","async":false,"alias":"headless","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"ignoreAllDefaultArgs","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`.↵Dangerous option; use with care. Defaults to `false`."}],"required":false,"comment":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. Dangerous\noption; use with care. Defaults to `false`.","async":false,"alias":"ignoreAllDefaultArgs","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"ignoreDefaultArgs","type":{"name":"","union":[{"name":"boolean"},{"name":"Array","templates":[{"name":"string"}]}],"expression":"[boolean]|[Array]<[string]>"},"spec":[{"type":"text","text":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. If an↵array is given, then filters out the given default arguments. Dangerous option; use with care. Defaults to `false`."}],"required":false,"comment":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. If an array is\ngiven, then filters out the given default arguments. Dangerous option; use with care. Defaults to `false`.","async":false,"alias":"ignoreDefaultArgs","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"ignoreDefaultArgs","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`.↵Dangerous option; use with care."}],"required":false,"comment":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. Dangerous\noption; use with care.","async":false,"alias":"ignoreDefaultArgs","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging."}],"required":false,"comment":"Logger sink for Playwright logging.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"proxy","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"server","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example↵`http://myproxy.com:3128` or `socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP↵proxy."}],"required":true,"comment":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example `http://myproxy.com:3128` or\n`socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy.","async":false,"alias":"server","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypass","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org,↵.domain.com\"`."}],"required":false,"comment":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`.","async":false,"alias":"bypass","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional username to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional username to use if HTTP proxy requires authentication.","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional password to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional password to use if HTTP proxy requires authentication.","async":false,"alias":"password","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Network proxy settings."}],"required":false,"comment":"Network proxy settings.","async":false,"alias":"proxy","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"slowMo","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you can see what is going on."}],"required":false,"comment":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you can see what is going\non.","async":false,"alias":"slowMo","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the browser instance to start. Defaults to `30000` (30 seconds). Pass `0` to↵disable timeout."}],"required":false,"comment":"Maximum time in milliseconds to wait for the browser instance to start. Defaults to `30000` (30 seconds). Pass `0`\nto disable timeout.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"tracesDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"If specified, traces are saved into this directory."}],"required":false,"comment":"If specified, traces are saved into this directory.","async":false,"alias":"tracesDir","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"launchPersistentContext","type":{"name":"BrowserContext","expression":"[BrowserContext]"},"spec":[{"type":"text","text":"Returns the persistent browser context instance."},{"type":"text","text":"Launches browser that uses persistent storage located at `userDataDir` and returns the only context. Closing↵this context will automatically close the browser."}],"required":true,"comment":"Returns the persistent browser context instance.\n\nLaunches browser that uses persistent storage located at `userDataDir` and returns the only context. Closing this\ncontext will automatically close the browser.","async":true,"alias":"launchPersistentContext","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"userDataDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to a User Data Directory, which stores browser session data like cookies and local storage. Pass an empty string to create a temporary directory."},{"type":"text","text":"More details for↵[Chromium](https://chromium.googlesource.com/chromium/src/+/master/docs/user_data_dir.md#introduction) and↵[Firefox](https://wiki.mozilla.org/Firefox/CommandLineOptions#User_profile). Chromium's user data directory is the **parent** directory of the \"Profile Path\" seen at `chrome://version`."},{"type":"text","text":"Note that browsers do not allow launching multiple instances with the same User Data Directory."}],"required":true,"comment":"Path to a User Data Directory, which stores browser session data like cookies and local storage. Pass an empty\nstring to create a temporary directory.\n\nMore details for\n[Chromium](https://chromium.googlesource.com/chromium/src/+/master/docs/user_data_dir.md#introduction) and\n[Firefox](https://wiki.mozilla.org/Firefox/CommandLineOptions#User_profile). Chromium's user data directory is the\n**parent** directory of the \"Profile Path\" seen at `chrome://version`.\n\nNote that browsers do not allow launching multiple instances with the same User Data Directory.","async":false,"alias":"userDataDir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"acceptDownloads","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted."}],"required":false,"comment":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted.","async":false,"alias":"acceptDownloads","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"args","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"note","noteType":"warning","children":[{"type":"text","text":"Use custom browser args at your own risk, as some of them may break Playwright functionality."}]},{"type":"text","text":"Additional arguments to pass to the browser instance. The list of Chromium flags can be found↵[here](https://peter.sh/experiments/chromium-command-line-switches/)."}],"required":false,"comment":"**NOTE** Use custom browser args at your own risk, as some of them may break Playwright functionality.\n\nAdditional arguments to pass to the browser instance. The list of Chromium flags can be found\n[here](https://peter.sh/experiments/chromium-command-line-switches/).","async":false,"alias":"args","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"baseURL","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`], [`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by using the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the corresponding URL. Unset by default. Examples:"},{"type":"li","text":"baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in `http://localhost:3000/foo/bar.html`","liType":"bullet"},{"type":"li","text":"baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in `http://localhost:3000/bar.html`","liType":"bullet"}],"required":false,"comment":"When using [`method: Page.goto`], [`method: Page.route`], [`method: Page.waitForURL`],\n[`method: Page.waitForRequest`], or [`method: Page.waitForResponse`] it takes the base URL in consideration by\nusing the [`URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor for building the\ncorresponding URL. Unset by default. Examples:\n- baseURL: `http://localhost:3000` and navigating to `/bar.html` results in `http://localhost:3000/bar.html`\n- baseURL: `http://localhost:3000/foo/` and navigating to `./bar.html` results in\n  `http://localhost:3000/foo/bar.html`\n- baseURL: `http://localhost:3000/foo` (without trailing slash) and navigating to `./bar.html` results in\n  `http://localhost:3000/bar.html`","async":false,"alias":"baseURL","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypassCSP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`."}],"required":false,"comment":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`.","async":false,"alias":"bypassCSP","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"channel","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Browser distribution channel."},{"type":"text","text":"Use \"chromium\" to [opt in to new headless mode](../browsers.md#chromium-new-headless-mode)."},{"type":"text","text":"Use \"chrome\", \"chrome-beta\", \"chrome-dev\", \"chrome-canary\", \"msedge\", \"msedge-beta\", \"msedge-dev\", or \"msedge-canary\" to use branded [Google Chrome and Microsoft Edge](../browsers.md#google-chrome--microsoft-edge)."}],"required":false,"comment":"Browser distribution channel.\n\nUse \"chromium\" to [opt in to new headless mode](../browsers.md#chromium-new-headless-mode).\n\nUse \"chrome\", \"chrome-beta\", \"chrome-dev\", \"chrome-canary\", \"msedge\", \"msedge-beta\", \"msedge-dev\", or\n\"msedge-canary\" to use branded [Google Chrome and Microsoft Edge](../browsers.md#google-chrome--microsoft-edge).","async":false,"alias":"channel","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"chromiumSandbox","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Enable Chromium sandboxing. Defaults to `false`."}],"required":false,"comment":"Enable Chromium sandboxing. Defaults to `false`.","async":false,"alias":"chromiumSandbox","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"clientCertificates","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"1.46","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port."}],"required":true,"comment":"Exact origin that the certificate is valid for. Origin includes `https` protocol, a hostname and optionally a port.","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"certPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the certificate in PEM format."}],"required":false,"comment":"Path to the file with the certificate in PEM format.","async":false,"alias":"certPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"cert","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the certificate in PEM format."}],"required":false,"comment":"Direct value of the certificate in PEM format.","async":false,"alias":"cert","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"keyPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the file with the private key in PEM format."}],"required":false,"comment":"Path to the file with the private key in PEM format.","async":false,"alias":"keyPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"key","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the private key in PEM format."}],"required":false,"comment":"Direct value of the private key in PEM format.","async":false,"alias":"key","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfxPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Path to the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfxPath","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"pfx","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"Direct value of the PFX or PKCS12 encoded private key and certificate chain."}],"required":false,"comment":"Direct value of the PFX or PKCS12 encoded private key and certificate chain.","async":false,"alias":"pfx","overloadIndex":0},{"kind":"property","langs":{},"since":"1.46","name":"passphrase","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Passphrase for the private key (PEM or PFX)."}],"required":false,"comment":"Passphrase for the private key (PEM or PFX).","async":false,"alias":"passphrase","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"TLS Client Authentication allows the server to request a client certificate and verify it."},{"type":"text","text":"**Details**"},{"type":"text","text":"An array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`, a single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally, `passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided with an exact match to the request origin that the certificate is valid for."},{"type":"note","noteType":"note","children":[{"type":"text","text":"When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it work by replacing `localhost` with `local.playwright`."}]}],"required":false,"comment":"TLS Client Authentication allows the server to request a client certificate and verify it.\n\n**Details**\n\nAn array of client certificates to be used. Each certificate object must have either both `certPath` and `keyPath`,\na single `pfxPath`, or their corresponding direct value equivalents (`cert` and `key`, or `pfx`). Optionally,\n`passphrase` property should be provided if the certificate is encrypted. The `origin` property should be provided\nwith an exact match to the request origin that the certificate is valid for.\n\n**NOTE** When using WebKit on macOS, accessing `localhost` will not pick up client certificates. You can make it\nwork by replacing `localhost` with `local.playwright`.\n","async":false,"alias":"clientCertificates","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"colorScheme","type":{"name":"","union":[{"name":"null"},{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""}]}],"expression":"null|[ColorScheme]<\"light\"|\"dark\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `null` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"colorScheme","type":{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ColorScheme]<\"light\"|\"dark\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `'null'` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"contrast","type":{"name":"","union":[{"name":"null"},{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""}]}],"expression":"null|[Contrast]<\"no-preference\"|\"more\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"contrast","type":{"name":"Contrast","union":[{"name":"\"no-preference\""},{"name":"\"more\""},{"name":"\"null\""}],"expression":"[Contrast]<\"no-preference\"|\"more\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-contrast'` media feature, supported values are `'no-preference'`, `'more'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"contrast","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"deviceScaleFactor","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about [emulating devices with device scale factor](../emulation.md#devices)."}],"required":false,"comment":"Specify device scale factor (can be thought of as dpr). Defaults to `1`. Learn more about\n[emulating devices with device scale factor](../emulation.md#devices).","async":false,"alias":"deviceScaleFactor","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"Use [debugging tools](../debug.md) instead.","name":"devtools","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"**Chromium-only** Whether to auto-open a Developer Tools panel for each tab. If this option is `true`, the↵`headless` option will be set `false`."}],"required":false,"comment":"**Chromium-only** Whether to auto-open a Developer Tools panel for each tab. If this option is `true`, the\n`headless` option will be set `false`.","async":false,"alias":"devtools","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"downloadsPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"If specified, accepted downloads are downloaded into this directory. Otherwise, temporary directory is created and is↵deleted when browser is closed. In either case, the downloads are deleted when the browser context they were created in↵is closed."}],"required":false,"comment":"If specified, accepted downloads are downloaded into this directory. Otherwise, temporary directory is created and\nis deleted when browser is closed. In either case, the downloads are deleted when the browser context they were\ncreated in is closed.","async":false,"alias":"downloadsPath","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"env","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Specify environment variables that will be visible to the browser. Defaults to `process.env`."}],"required":false,"comment":"Specify environment variables that will be visible to the browser. Defaults to `process.env`.","async":false,"alias":"env","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"env","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Specify environment variables that will be visible to the browser. Defaults to `process.env`."}],"required":false,"comment":"Specify environment variables that will be visible to the browser. Defaults to `process.env`.","async":false,"alias":"env","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"executablePath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to a browser executable to run instead of the bundled one. If `executablePath` is a relative path, then↵it is resolved relative to the current working directory. Note that Playwright only works with the bundled Chromium,↵Firefox or WebKit, use at your own risk."}],"required":false,"comment":"Path to a browser executable to run instead of the bundled one. If `executablePath` is a relative path, then it is\nresolved relative to the current working directory. Note that Playwright only works with the bundled Chromium,\nFirefox or WebKit, use at your own risk.","async":false,"alias":"executablePath","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"extraHTTPHeaders","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object containing additional HTTP headers to be sent with every request. Defaults to none."}],"required":false,"comment":"An object containing additional HTTP headers to be sent with every request. Defaults to none.","async":false,"alias":"extraHTTPHeaders","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.40","name":"firefoxUserPrefs","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Firefox user preferences. Learn more about the Firefox user preferences at↵[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox)."},{"type":"text","text":"You can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via `PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable."}],"required":false,"comment":"Firefox user preferences. Learn more about the Firefox user preferences at\n[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox).\n\nYou can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via\n`PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable.","async":false,"alias":"firefoxUserPrefs","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.40","name":"firefoxUserPrefs","type":{"name":"Object","templates":[{"name":"string"},{"name":"any"}],"expression":"[Object]<[string], [any]>"},"spec":[{"type":"text","text":"Firefox user preferences. Learn more about the Firefox user preferences at↵[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox)."},{"type":"text","text":"You can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via `PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable."}],"required":false,"comment":"Firefox user preferences. Learn more about the Firefox user preferences at\n[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox).\n\nYou can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via\n`PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable.","async":false,"alias":"firefoxUserPrefs","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"forcedColors","type":{"name":"","union":[{"name":"null"},{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""}]}],"expression":"null|[ForcedColors]<\"active\"|\"none\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"forcedColors","type":{"name":"ForcedColors","union":[{"name":"\"active\""},{"name":"\"none\""},{"name":"\"null\""}],"expression":"[ForcedColors]<\"active\"|\"none\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'none'`."}],"required":false,"comment":"Emulates `'forced-colors'` media feature, supported values are `'active'`, `'none'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'none'`.","async":false,"alias":"forcedColors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"geolocation","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"latitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Latitude between -90 and 90."}],"required":true,"comment":"Latitude between -90 and 90.","async":false,"alias":"latitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"longitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Longitude between -180 and 180."}],"required":true,"comment":"Longitude between -180 and 180.","async":false,"alias":"longitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"accuracy","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Non-negative accuracy value. Defaults to `0`."}],"required":false,"comment":"Non-negative accuracy value. Defaults to `0`.","async":false,"alias":"accuracy","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"geolocation","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGHUP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on SIGHUP. Defaults to `true`."}],"required":false,"comment":"Close the browser process on SIGHUP. Defaults to `true`.","async":false,"alias":"handleSIGHUP","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGINT","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on Ctrl-C. Defaults to `true`."}],"required":false,"comment":"Close the browser process on Ctrl-C. Defaults to `true`.","async":false,"alias":"handleSIGINT","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGTERM","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on SIGTERM. Defaults to `true`."}],"required":false,"comment":"Close the browser process on SIGTERM. Defaults to `true`.","async":false,"alias":"handleSIGTERM","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"hasTouch","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Specifies if viewport supports touch events. Defaults to false. Learn more about [mobile emulation](../emulation.md#devices)."}],"required":false,"comment":"Specifies if viewport supports touch events. Defaults to false. Learn more about\n[mobile emulation](../emulation.md#devices).","async":false,"alias":"hasTouch","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"headless","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to run browser in headless mode. More details for↵[Chromium](https://developers.google.com/web/updates/2017/04/headless-chrome) and↵[Firefox](https://hacks.mozilla.org/2017/12/using-headless-mode-in-firefox/). Defaults to `true` unless the↵`devtools` option is `true`."}],"required":false,"comment":"Whether to run browser in headless mode. More details for\n[Chromium](https://developers.google.com/web/updates/2017/04/headless-chrome) and\n[Firefox](https://hacks.mozilla.org/2017/12/using-headless-mode-in-firefox/). Defaults to `true` unless the\n`devtools` option is `true`.","async":false,"alias":"headless","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"httpCredentials","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"password","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Restrain sending http credentials on specific origin (scheme://host:port)."}],"required":false,"comment":"Restrain sending http credentials on specific origin (scheme://host:port).","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"send","type":{"name":"HttpCredentialsSend","union":[{"name":"\"unauthorized\""},{"name":"\"always\""}],"expression":"[HttpCredentialsSend]<\"unauthorized\"|\"always\">"},"spec":[{"type":"text","text":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests sent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with the each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with `WWW-Authenticate` header is received. Defaults to `'unauthorized'`."}],"required":false,"comment":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests\nsent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with\nthe each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with\n`WWW-Authenticate` header is received. Defaults to `'unauthorized'`.","async":false,"alias":"send","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication).↵If no origin is specified, the username and password are sent to any servers upon unauthorized responses."}],"required":false,"comment":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication). If no\norigin is specified, the username and password are sent to any servers upon unauthorized responses.","async":false,"alias":"httpCredentials","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"ignoreAllDefaultArgs","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`.↵Dangerous option; use with care. Defaults to `false`."}],"required":false,"comment":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. Dangerous\noption; use with care. Defaults to `false`.","async":false,"alias":"ignoreAllDefaultArgs","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"ignoreDefaultArgs","type":{"name":"","union":[{"name":"boolean"},{"name":"Array","templates":[{"name":"string"}]}],"expression":"[boolean]|[Array]<[string]>"},"spec":[{"type":"text","text":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. If an↵array is given, then filters out the given default arguments. Dangerous option; use with care. Defaults to `false`."}],"required":false,"comment":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. If an array is\ngiven, then filters out the given default arguments. Dangerous option; use with care. Defaults to `false`.","async":false,"alias":"ignoreDefaultArgs","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"ignoreDefaultArgs","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`.↵Dangerous option; use with care."}],"required":false,"comment":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. Dangerous\noption; use with care.","async":false,"alias":"ignoreDefaultArgs","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"isMobile","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device, so you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more about [mobile emulation](../emulation.md#ismobile)."}],"required":false,"comment":"Whether the `meta viewport` tag is taken into account and touch events are enabled. isMobile is a part of device,\nso you don't actually need to set it manually. Defaults to `false` and is not supported in Firefox. Learn more\nabout [mobile emulation](../emulation.md#ismobile).","async":false,"alias":"isMobile","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"javaScriptEnabled","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about [disabling JavaScript](../emulation.md#javascript-enabled)."}],"required":false,"comment":"Whether or not to enable JavaScript in the context. Defaults to `true`. Learn more about\n[disabling JavaScript](../emulation.md#javascript-enabled).","async":false,"alias":"javaScriptEnabled","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"locale","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value, `Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default locale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone)."}],"required":false,"comment":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value,\n`Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default\nlocale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone).","async":false,"alias":"locale","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging."}],"required":false,"comment":"Logger sink for Playwright logging.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"noViewport","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Does not enforce fixed viewport, allows resizing window in the headed mode."}],"required":false,"comment":"Does not enforce fixed viewport, allows resizing window in the headed mode.","async":false,"alias":"noViewport","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"offline","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to emulate network being offline. Defaults to `false`. Learn more about [network emulation](../emulation.md#offline)."}],"required":false,"comment":"Whether to emulate network being offline. Defaults to `false`. Learn more about\n[network emulation](../emulation.md#offline).","async":false,"alias":"offline","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"permissions","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"A list of permissions to grant to all pages in this context. See↵[`method: BrowserContext.grantPermissions`] for more details. Defaults to none."}],"required":false,"comment":"A list of permissions to grant to all pages in this context. See [`method: BrowserContext.grantPermissions`] for\nmore details. Defaults to none.","async":false,"alias":"permissions","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"proxy","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"server","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example↵`http://myproxy.com:3128` or `socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP↵proxy."}],"required":true,"comment":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example `http://myproxy.com:3128` or\n`socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy.","async":false,"alias":"server","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypass","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org,↵.domain.com\"`."}],"required":false,"comment":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`.","async":false,"alias":"bypass","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional username to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional username to use if HTTP proxy requires authentication.","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional password to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional password to use if HTTP proxy requires authentication.","async":false,"alias":"password","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Network proxy settings."}],"required":false,"comment":"Network proxy settings.","async":false,"alias":"proxy","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"recordHar","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"omitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to↵`false`. Deprecated, use `content` policy instead."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`. Deprecated, use\n`content` policy instead.","async":false,"alias":"omitContent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"content","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is specified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output files and to `embed` for all other file extensions."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is\nspecified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output\nfiles and to `embed` for all other file extensions.","async":false,"alias":"content","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by default."}],"required":true,"comment":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by\ndefault.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"mode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"mode","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"urlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was provided and the passed URL is a path, it gets merged via the [`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none."}],"required":false,"comment":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was\nprovided and the passed URL is a path, it gets merged via the\n[`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none.","async":false,"alias":"urlFilter","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file. If not↵specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be↵saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file.\nIf not specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be\nsaved.","async":false,"alias":"recordHar","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_content"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarContent","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files and all of these files are archived along with the HAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files and all of these files are archived along with the\nHAR file. Defaults to `embed`, which stores content inline the HAR file as per HAR specification.","async":false,"alias":"recordHarContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_mode"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarMode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"recordHarMode","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_omit_content"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarOmitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`.","async":false,"alias":"recordHarOmitContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_path"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the↵specified HAR file on the filesystem. If not specified, the HAR is not recorded. Make sure to↵call [`method: BrowserContext.close`] for the HAR to be saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the specified HAR file\non the filesystem. If not specified, the HAR is not recorded. Make sure to call [`method: BrowserContext.close`]\nfor the HAR to be saved.","async":false,"alias":"recordHarPath","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_url_filter"},"types":{},"overrides":{}},"since":"v1.8","name":"recordHarUrlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[],"required":false,"comment":"","async":false,"alias":"recordHarUrlFilter","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideo","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"dir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the directory to put videos into."}],"required":true,"comment":"Path to the directory to put videos into.","async":false,"alias":"dir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"size","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to\nfit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of\neach page will be scaled down if necessary to fit the specified size.","async":false,"alias":"size","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded. Make↵sure to await [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded.\nMake sure to await [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideo","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_dir"},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideoDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables video recording for all pages into the specified directory. If not specified videos are↵not recorded. Make sure to call [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into the specified directory. If not specified videos are not recorded. Make\nsure to call [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideoDir","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_size"},"types":{},"overrides":{}},"since":"v1.8","name":"recordVideoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to fit into\n800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of each page\nwill be scaled down if necessary to fit the specified size.","async":false,"alias":"recordVideoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"reducedMotion","type":{"name":"","union":[{"name":"null"},{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""}]}],"expression":"null|[ReducedMotion]<\"reduce\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"reducedMotion","type":{"name":"ReducedMotion","union":[{"name":"\"reduce\""},{"name":"\"no-preference\""},{"name":"\"null\""}],"expression":"[ReducedMotion]<\"reduce\"|\"no-preference\"|\"null\">"},"spec":[{"type":"text","text":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See [`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to `'no-preference'`."}],"required":false,"comment":"Emulates `'prefers-reduced-motion'` media feature, supported values are `'reduce'`, `'no-preference'`. See\n[`method: Page.emulateMedia`] for more details. Passing `'null'` resets emulation to system defaults. Defaults to\n`'no-preference'`.","async":false,"alias":"reducedMotion","overloadIndex":0},{"kind":"property","langs":{"aliases":{"java":"screenSize","csharp":"screenSize"},"types":{},"overrides":{}},"since":"v1.8","name":"screen","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the↵`viewport` is set."}],"required":false,"comment":"Emulates consistent window screen size available inside web page via `window.screen`. Is only used when the\n`viewport` is set.","async":false,"alias":"screen","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"serviceWorkers","type":{"name":"ServiceWorkerPolicy","union":[{"name":"\"allow\""},{"name":"\"block\""}],"expression":"[ServiceWorkerPolicy]<\"allow\"|\"block\">"},"spec":[{"type":"text","text":"Whether to allow sites to register Service workers. Defaults to `'allow'`."},{"type":"li","text":"`'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be registered.","liType":"bullet"},{"type":"li","text":"`'block'`: Playwright will block all registration of Service Workers.","liType":"bullet"}],"required":false,"comment":"Whether to allow sites to register Service workers. Defaults to `'allow'`.\n- `'allow'`: [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) can be\n  registered.\n- `'block'`: Playwright will block all registration of Service Workers.","async":false,"alias":"serviceWorkers","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"slowMo","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you can see what is going on."}],"required":false,"comment":"Slows down Playwright operations by the specified amount of milliseconds. Useful so that you can see what is going\non.","async":false,"alias":"slowMo","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"strictSelectors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations↵on selectors that imply single target DOM element will throw when more than one element matches the selector.↵This option does not affect any Locator APIs (Locators are always strict). Defaults to `false`.↵See `Locator` to learn more about the strict mode."}],"required":false,"comment":"If set to true, enables strict selectors mode for this context. In the strict selectors mode all operations on\nselectors that imply single target DOM element will throw when more than one element matches the selector. This\noption does not affect any Locator APIs (Locators are always strict). Defaults to `false`. See `Locator` to learn\nmore about the strict mode.","async":false,"alias":"strictSelectors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the browser instance to start. Defaults to `30000` (30 seconds). Pass `0` to↵disable timeout."}],"required":false,"comment":"Maximum time in milliseconds to wait for the browser instance to start. Defaults to `30000` (30 seconds). Pass `0`\nto disable timeout.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"timezoneId","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Changes the timezone of the context. See [ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)↵for a list of supported timezone IDs. Defaults to the system timezone."}],"required":false,"comment":"Changes the timezone of the context. See\n[ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)\nfor a list of supported timezone IDs. Defaults to the system timezone.","async":false,"alias":"timezoneId","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"tracesDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"If specified, traces are saved into this directory."}],"required":false,"comment":"If specified, traces are saved into this directory.","async":false,"alias":"tracesDir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"userAgent","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specific user agent to use in this context."}],"required":false,"comment":"Specific user agent to use in this context.","async":false,"alias":"userAgent","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"Use `recordVideo` instead.","name":"videoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videoSize","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"Use `recordVideo` instead.","name":"videosPath","type":{"name":"path","expression":"[path]"},"spec":[],"required":false,"comment":"","async":false,"alias":"videosPath","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{"java":"viewportSize"},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `null` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `null` value opts out from the default presets, makes viewport depend on the↵host window size defined by the operating system. It makes the execution of the↵tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `null` to disable the consistent\nviewport emulation. Learn more about [viewport emulation](../emulation#viewport).\n\n**NOTE** The `null` value opts out from the default presets, makes viewport depend on the host window size defined\nby the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{"csharp":"viewportSize"},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport.↵Use `ViewportSize.NoViewport` to disable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport)."},{"type":"note","noteType":"note","children":[{"type":"text","text":"The `ViewportSize.NoViewport` value opts out from the default presets,↵makes viewport depend on the host window size defined by the operating system.↵It makes the execution of the tests non-deterministic."}]}],"required":false,"comment":"Emulates consistent viewport for each page. Defaults to an 1280x720 viewport. Use `ViewportSize.NoViewport` to\ndisable the consistent viewport emulation. Learn more about [viewport emulation](../emulation.md#viewport).\n\n**NOTE** The `ViewportSize.NoViewport` value opts out from the default presets, makes viewport depend on the host\nwindow size defined by the operating system. It makes the execution of the tests non-deterministic.\n","async":false,"alias":"viewport","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"viewport","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page width in pixels."}],"required":true,"comment":"page width in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"page height in pixels."}],"required":true,"comment":"page height in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed viewport. Learn more about [viewport emulation](../emulation.md#viewport)."}],"required":false,"comment":"Sets a consistent viewport for each page. Defaults to an 1280x720 viewport. `no_viewport` disables the fixed\nviewport. Learn more about [viewport emulation](../emulation.md#viewport).","async":false,"alias":"viewport","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"launchServer","type":{"name":"BrowserServer","expression":"[BrowserServer]"},"spec":[{"type":"text","text":"Returns the browser app instance. You can connect to it via [`method: BrowserType.connect`], which requires the major/minor client/server version to match (1.2.3 → is compatible with 1.2.x)."},{"type":"text","text":"**Usage**"},{"type":"text","text":"Launches browser server that client can connect to. An example of launching a browser executable and connecting to it↵later:"},{"type":"code","lines":["const { chromium } = require('playwright');  // Or 'webkit' or 'firefox'.","","(async () => {","  const browserServer = await chromium.launchServer();","  const wsEndpoint = browserServer.wsEndpoint();","  // Use web socket endpoint later to establish a connection.","  const browser = await chromium.connect(wsEndpoint);","  // Close browser instance.","  await browserServer.close();","})();"],"codeLang":"js"}],"required":true,"comment":"Returns the browser app instance. You can connect to it via [`method: BrowserType.connect`], which requires the\nmajor/minor client/server version to match (1.2.3 → is compatible with 1.2.x).\n\n**Usage**\n\nLaunches browser server that client can connect to. An example of launching a browser executable and connecting to\nit later:\n\n```js\nconst { chromium } = require('playwright');  // Or 'webkit' or 'firefox'.\n\n(async () => {\n  const browserServer = await chromium.launchServer();\n  const wsEndpoint = browserServer.wsEndpoint();\n  // Use web socket endpoint later to establish a connection.\n  const browser = await chromium.connect(wsEndpoint);\n  // Close browser instance.\n  await browserServer.close();\n})();\n```\n","async":true,"alias":"launchServer","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"args","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"note","noteType":"warning","children":[{"type":"text","text":"Use custom browser args at your own risk, as some of them may break Playwright functionality."}]},{"type":"text","text":"Additional arguments to pass to the browser instance. The list of Chromium flags can be found↵[here](https://peter.sh/experiments/chromium-command-line-switches/)."}],"required":false,"comment":"**NOTE** Use custom browser args at your own risk, as some of them may break Playwright functionality.\n\nAdditional arguments to pass to the browser instance. The list of Chromium flags can be found\n[here](https://peter.sh/experiments/chromium-command-line-switches/).","async":false,"alias":"args","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"channel","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Browser distribution channel."},{"type":"text","text":"Use \"chromium\" to [opt in to new headless mode](../browsers.md#chromium-new-headless-mode)."},{"type":"text","text":"Use \"chrome\", \"chrome-beta\", \"chrome-dev\", \"chrome-canary\", \"msedge\", \"msedge-beta\", \"msedge-dev\", or \"msedge-canary\" to use branded [Google Chrome and Microsoft Edge](../browsers.md#google-chrome--microsoft-edge)."}],"required":false,"comment":"Browser distribution channel.\n\nUse \"chromium\" to [opt in to new headless mode](../browsers.md#chromium-new-headless-mode).\n\nUse \"chrome\", \"chrome-beta\", \"chrome-dev\", \"chrome-canary\", \"msedge\", \"msedge-beta\", \"msedge-dev\", or\n\"msedge-canary\" to use branded [Google Chrome and Microsoft Edge](../browsers.md#google-chrome--microsoft-edge).","async":false,"alias":"channel","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"chromiumSandbox","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Enable Chromium sandboxing. Defaults to `false`."}],"required":false,"comment":"Enable Chromium sandboxing. Defaults to `false`.","async":false,"alias":"chromiumSandbox","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"Use [debugging tools](../debug.md) instead.","name":"devtools","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"**Chromium-only** Whether to auto-open a Developer Tools panel for each tab. If this option is `true`, the↵`headless` option will be set `false`."}],"required":false,"comment":"**Chromium-only** Whether to auto-open a Developer Tools panel for each tab. If this option is `true`, the\n`headless` option will be set `false`.","async":false,"alias":"devtools","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"downloadsPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"If specified, accepted downloads are downloaded into this directory. Otherwise, temporary directory is created and is↵deleted when browser is closed. In either case, the downloads are deleted when the browser context they were created in↵is closed."}],"required":false,"comment":"If specified, accepted downloads are downloaded into this directory. Otherwise, temporary directory is created and\nis deleted when browser is closed. In either case, the downloads are deleted when the browser context they were\ncreated in is closed.","async":false,"alias":"downloadsPath","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"env","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Specify environment variables that will be visible to the browser. Defaults to `process.env`."}],"required":false,"comment":"Specify environment variables that will be visible to the browser. Defaults to `process.env`.","async":false,"alias":"env","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"env","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Specify environment variables that will be visible to the browser. Defaults to `process.env`."}],"required":false,"comment":"Specify environment variables that will be visible to the browser. Defaults to `process.env`.","async":false,"alias":"env","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"executablePath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to a browser executable to run instead of the bundled one. If `executablePath` is a relative path, then↵it is resolved relative to the current working directory. Note that Playwright only works with the bundled Chromium,↵Firefox or WebKit, use at your own risk."}],"required":false,"comment":"Path to a browser executable to run instead of the bundled one. If `executablePath` is a relative path, then it is\nresolved relative to the current working directory. Note that Playwright only works with the bundled Chromium,\nFirefox or WebKit, use at your own risk.","async":false,"alias":"executablePath","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"firefoxUserPrefs","type":{"name":"Object","templates":[{"name":"string"},{"name":"","union":[{"name":"string"},{"name":"float"},{"name":"boolean"}]}],"expression":"[Object]<[string], [string]|[float]|[boolean]>"},"spec":[{"type":"text","text":"Firefox user preferences. Learn more about the Firefox user preferences at↵[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox)."},{"type":"text","text":"You can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via `PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable."}],"required":false,"comment":"Firefox user preferences. Learn more about the Firefox user preferences at\n[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox).\n\nYou can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via\n`PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable.","async":false,"alias":"firefoxUserPrefs","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"firefoxUserPrefs","type":{"name":"Object","templates":[{"name":"string"},{"name":"any"}],"expression":"[Object]<[string], [any]>"},"spec":[{"type":"text","text":"Firefox user preferences. Learn more about the Firefox user preferences at↵[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox)."},{"type":"text","text":"You can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via `PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable."}],"required":false,"comment":"Firefox user preferences. Learn more about the Firefox user preferences at\n[`about:config`](https://support.mozilla.org/en-US/kb/about-config-editor-firefox).\n\nYou can also provide a path to a custom [`policies.json` file](https://mozilla.github.io/policy-templates/) via\n`PLAYWRIGHT_FIREFOX_POLICIES_JSON` environment variable.","async":false,"alias":"firefoxUserPrefs","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGHUP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on SIGHUP. Defaults to `true`."}],"required":false,"comment":"Close the browser process on SIGHUP. Defaults to `true`.","async":false,"alias":"handleSIGHUP","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGINT","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on Ctrl-C. Defaults to `true`."}],"required":false,"comment":"Close the browser process on Ctrl-C. Defaults to `true`.","async":false,"alias":"handleSIGINT","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"handleSIGTERM","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Close the browser process on SIGTERM. Defaults to `true`."}],"required":false,"comment":"Close the browser process on SIGTERM. Defaults to `true`.","async":false,"alias":"handleSIGTERM","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"headless","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to run browser in headless mode. More details for↵[Chromium](https://developers.google.com/web/updates/2017/04/headless-chrome) and↵[Firefox](https://hacks.mozilla.org/2017/12/using-headless-mode-in-firefox/). Defaults to `true` unless the↵`devtools` option is `true`."}],"required":false,"comment":"Whether to run browser in headless mode. More details for\n[Chromium](https://developers.google.com/web/updates/2017/04/headless-chrome) and\n[Firefox](https://hacks.mozilla.org/2017/12/using-headless-mode-in-firefox/). Defaults to `true` unless the\n`devtools` option is `true`.","async":false,"alias":"headless","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.45","name":"host","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Host to use for the web socket. It is optional and if it is omitted, the server will accept connections on the unspecified IPv6 address (::) when IPv6 is available, or the unspecified IPv4 address (0.0.0.0) otherwise. Consider hardening it with picking a specific interface."}],"required":false,"comment":"Host to use for the web socket. It is optional and if it is omitted, the server will accept connections on the\nunspecified IPv6 address (::) when IPv6 is available, or the unspecified IPv4 address (0.0.0.0) otherwise. Consider\nhardening it with picking a specific interface.","async":false,"alias":"host","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"ignoreDefaultArgs","type":{"name":"","union":[{"name":"boolean"},{"name":"Array","templates":[{"name":"string"}]}],"expression":"[boolean]|[Array]<[string]>"},"spec":[{"type":"text","text":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. If an↵array is given, then filters out the given default arguments. Dangerous option; use with care. Defaults to `false`."}],"required":false,"comment":"If `true`, Playwright does not pass its own configurations args and only uses the ones from `args`. If an array is\ngiven, then filters out the given default arguments. Dangerous option; use with care. Defaults to `false`.","async":false,"alias":"ignoreDefaultArgs","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","deprecated":"The logs received by the logger are incomplete. Please use tracing instead.","name":"logger","type":{"name":"Logger","expression":"[Logger]"},"spec":[{"type":"text","text":"Logger sink for Playwright logging."}],"required":false,"comment":"Logger sink for Playwright logging.","async":false,"alias":"logger","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"port","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Port to use for the web socket. Defaults to 0 that picks any available port."}],"required":false,"comment":"Port to use for the web socket. Defaults to 0 that picks any available port.","async":false,"alias":"port","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"proxy","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"server","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example↵`http://myproxy.com:3128` or `socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP↵proxy."}],"required":true,"comment":"Proxy to be used for all requests. HTTP and SOCKS proxies are supported, for example `http://myproxy.com:3128` or\n`socks5://myproxy.com:3128`. Short form `myproxy.com:3128` is considered an HTTP proxy.","async":false,"alias":"server","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"bypass","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org,↵.domain.com\"`."}],"required":false,"comment":"Optional comma-separated domains to bypass proxy, for example `\".com, chromium.org, .domain.com\"`.","async":false,"alias":"bypass","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional username to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional username to use if HTTP proxy requires authentication.","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Optional password to use if HTTP proxy requires authentication."}],"required":false,"comment":"Optional password to use if HTTP proxy requires authentication.","async":false,"alias":"password","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Network proxy settings."}],"required":false,"comment":"Network proxy settings.","async":false,"alias":"proxy","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the browser instance to start. Defaults to `30000` (30 seconds). Pass `0` to↵disable timeout."}],"required":false,"comment":"Maximum time in milliseconds to wait for the browser instance to start. Defaults to `30000` (30 seconds). Pass `0`\nto disable timeout.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"tracesDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"If specified, traces are saved into this directory."}],"required":false,"comment":"If specified, traces are saved into this directory.","async":false,"alias":"tracesDir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","name":"wsPath","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Path at which to serve the Browser Server. For security, this defaults to an↵unguessable string."},{"type":"note","noteType":"warning","children":[{"type":"text","text":"Any process or web page (including those running in Playwright) with knowledge↵of the `wsPath` can take control of the OS user. For this reason, you should↵use an unguessable token when using this option."}]}],"required":false,"comment":"Path at which to serve the Browser Server. For security, this defaults to an unguessable string.\n\n**NOTE** Any process or web page (including those running in Playwright) with knowledge of the `wsPath` can take\ncontrol of the OS user. For this reason, you should use an unguessable token when using this option.\n","async":false,"alias":"wsPath","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns browser name. For example: `'chromium'`, `'webkit'` or `'firefox'`."}],"required":true,"comment":"Returns browser name. For example: `'chromium'`, `'webkit'` or `'firefox'`.","async":false,"alias":"name","overloadIndex":0,"args":[]}]},{"name":"CDPSession","spec":[{"type":"text","text":"The `CDPSession` instances are used to talk raw Chrome Devtools Protocol:"},{"type":"li","text":"protocol methods can be called with `session.send` method.","liType":"bullet"},{"type":"li","text":"protocol events can be subscribed to with `session.on` method.","liType":"bullet"},{"type":"text","text":"Useful links:"},{"type":"li","text":"Documentation on DevTools Protocol can be found here:↵[DevTools Protocol Viewer](https://chromedevtools.github.io/devtools-protocol/).","liType":"bullet"},{"type":"li","text":"Getting Started with DevTools Protocol:↵https://github.com/aslushnikov/getting-started-with-cdp/blob/master/README.md","liType":"bullet"},{"type":"code","lines":["const client = await page.context().newCDPSession(page);","await client.send('Animation.enable');","client.on('Animation.animationCreated', () => console.log('Animation created!'));","const response = await client.send('Animation.getPlaybackRate');","console.log('playback rate is ' + response.playbackRate);","await client.send('Animation.setPlaybackRate', {","  playbackRate: response.playbackRate / 2","});"],"codeLang":"js"},{"type":"code","lines":["client = await page.context.new_cdp_session(page)","await client.send(\"Animation.enable\")","client.on(\"Animation.animationCreated\", lambda: print(\"animation created!\"))","response = await client.send(\"Animation.getPlaybackRate\")","print(\"playback rate is \" + str(response[\"playbackRate\"]))","await client.send(\"Animation.setPlaybackRate\", {","    \"playbackRate\": response[\"playbackRate\"] / 2","})"],"codeLang":"python async"},{"type":"code","lines":["client = page.context.new_cdp_session(page)","client.send(\"Animation.enable\")","client.on(\"Animation.animationCreated\", lambda: print(\"animation created!\"))","response = client.send(\"Animation.getPlaybackRate\")","print(\"playback rate is \" + str(response[\"playbackRate\"]))","client.send(\"Animation.setPlaybackRate\", {","    \"playbackRate\": response[\"playbackRate\"] / 2","})"],"codeLang":"python sync"},{"type":"code","lines":["var client = await Page.Context.NewCDPSessionAsync(Page);","await client.SendAsync(\"Runtime.enable\");","client.Event(\"Animation.animationCreated\").OnEvent += (_, _) => Console.WriteLine(\"Animation created!\");","var response = await client.SendAsync(\"Animation.getPlaybackRate\");","var playbackRate = response.Value.GetProperty(\"playbackRate\").GetDouble();","Console.WriteLine(\"playback rate is \" + playbackRate);","await client.SendAsync(\"Animation.setPlaybackRate\", new() { { \"playbackRate\", playbackRate / 2 } });"],"codeLang":"csharp"},{"type":"code","lines":["CDPSession client = page.context().newCDPSession(page);","client.send(\"Runtime.enable\");","","client.on(\"Animation.animationCreated\", (event) -> System.out.println(\"Animation created!\"));","","JsonObject response = client.send(\"Animation.getPlaybackRate\");","double playbackRate = response.get(\"playbackRate\").getAsDouble();","System.out.println(\"playback rate is \" + playbackRate);","","JsonObject params = new JsonObject();","params.addProperty(\"playbackRate\", playbackRate / 2);","client.send(\"Animation.setPlaybackRate\", params);"],"codeLang":"java"}],"langs":{},"comment":"The `CDPSession` instances are used to talk raw Chrome Devtools Protocol:\n- protocol methods can be called with `session.send` method.\n- protocol events can be subscribed to with `session.on` method.\n\nUseful links:\n- Documentation on DevTools Protocol can be found here:\n  [DevTools Protocol Viewer](https://chromedevtools.github.io/devtools-protocol/).\n- Getting Started with DevTools Protocol:\n  https://github.com/aslushnikov/getting-started-with-cdp/blob/master/README.md\n\n```js\nconst client = await page.context().newCDPSession(page);\nawait client.send('Animation.enable');\nclient.on('Animation.animationCreated', () => console.log('Animation created!'));\nconst response = await client.send('Animation.getPlaybackRate');\nconsole.log('playback rate is ' + response.playbackRate);\nawait client.send('Animation.setPlaybackRate', {\n  playbackRate: response.playbackRate / 2\n});\n```\n\n```py\nclient = await page.context.new_cdp_session(page)\nawait client.send(\"Animation.enable\")\nclient.on(\"Animation.animationCreated\", lambda: print(\"animation created!\"))\nresponse = await client.send(\"Animation.getPlaybackRate\")\nprint(\"playback rate is \" + str(response[\"playbackRate\"]))\nawait client.send(\"Animation.setPlaybackRate\", {\n    \"playbackRate\": response[\"playbackRate\"] / 2\n})\n```\n\n```py\nclient = page.context.new_cdp_session(page)\nclient.send(\"Animation.enable\")\nclient.on(\"Animation.animationCreated\", lambda: print(\"animation created!\"))\nresponse = client.send(\"Animation.getPlaybackRate\")\nprint(\"playback rate is \" + str(response[\"playbackRate\"]))\nclient.send(\"Animation.setPlaybackRate\", {\n    \"playbackRate\": response[\"playbackRate\"] / 2\n})\n```\n\n```csharp\nvar client = await Page.Context.NewCDPSessionAsync(Page);\nawait client.SendAsync(\"Runtime.enable\");\nclient.Event(\"Animation.animationCreated\").OnEvent += (_, _) => Console.WriteLine(\"Animation created!\");\nvar response = await client.SendAsync(\"Animation.getPlaybackRate\");\nvar playbackRate = response.Value.GetProperty(\"playbackRate\").GetDouble();\nConsole.WriteLine(\"playback rate is \" + playbackRate);\nawait client.SendAsync(\"Animation.setPlaybackRate\", new() { { \"playbackRate\", playbackRate / 2 } });\n```\n\n```java\nCDPSession client = page.context().newCDPSession(page);\nclient.send(\"Runtime.enable\");\n\nclient.on(\"Animation.animationCreated\", (event) -> System.out.println(\"Animation created!\"));\n\nJsonObject response = client.send(\"Animation.getPlaybackRate\");\ndouble playbackRate = response.get(\"playbackRate\").getAsDouble();\nSystem.out.println(\"playback rate is \" + playbackRate);\n\nJsonObject params = new JsonObject();\nparams.addProperty(\"playbackRate\", playbackRate / 2);\nclient.send(\"Animation.setPlaybackRate\", params);\n```\n","since":"v1.8","members":[{"kind":"method","langs":{},"since":"v1.8","name":"detach","type":{"name":"void"},"spec":[{"type":"text","text":"Detaches the CDPSession from the target. Once detached, the CDPSession object won't emit any events and can't be used to↵send messages."}],"required":true,"comment":"Detaches the CDPSession from the target. Once detached, the CDPSession object won't emit any events and can't be\nused to send messages.","async":true,"alias":"detach","overloadIndex":0,"args":[]},{"kind":"method","langs":{"types":{"csharp":{"name":"JsonElement?","expression":"[JsonElement?]"},"java":{"name":"JsonObject","expression":"[JsonObject]"}}},"since":"v1.8","name":"send","type":{"name":"Object","expression":"[Object]"},"spec":[],"required":true,"comment":"","async":true,"alias":"send","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"method","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Protocol method name."}],"required":true,"comment":"Protocol method name.","async":false,"alias":"method","overloadIndex":0},{"kind":"property","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"params","type":{"name":"Object","expression":"[Object]"},"spec":[{"type":"text","text":"Optional method parameters."}],"required":false,"comment":"Optional method parameters.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{"csharp":"args"},"types":{},"overrides":{}},"since":"v1.30","name":"params","type":{"name":"Map","templates":[{"name":"string"},{"name":"Object"}],"expression":"[Map<string, Object>]"},"spec":[{"type":"text","text":"Optional method parameters."}],"required":false,"comment":"Optional method parameters.","async":false,"alias":"params","overloadIndex":0},{"kind":"property","langs":{"only":["java"],"aliases":{"java":"args"},"types":{},"overrides":{}},"since":"v1.37","name":"params","type":{"name":"JsonObject","expression":"[JsonObject]"},"spec":[{"type":"text","text":"Optional method parameters."}],"required":false,"comment":"Optional method parameters.","async":false,"alias":"params","overloadIndex":0}]},{"kind":"method","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v.1.30","name":"event","type":{"name":"CDPSessionEvent","expression":"[CDPSessionEvent]"},"spec":[{"type":"text","text":"Returns an event emitter for the given CDP event name."}],"required":true,"comment":"Returns an event emitter for the given CDP event name.","async":false,"alias":"event","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.30","name":"eventName","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"CDP event name."}],"required":true,"comment":"CDP event name.","async":false,"alias":"eventName","overloadIndex":0}]},{"kind":"method","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.37","name":"on","type":{"name":"void"},"spec":[{"type":"text","text":"Register an event handler for events with the specified event name.↵The given handler will be called for every event with the given name."}],"required":true,"comment":"Register an event handler for events with the specified event name. The given handler will be called for every\nevent with the given name.","async":false,"alias":"on","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.37","name":"eventName","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"CDP event name."}],"required":true,"comment":"CDP event name.","async":false,"alias":"eventName","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.37","name":"handler","type":{"name":"function","args":[{"name":"JsonObject"}],"expression":"[function]([JsonObject])"},"spec":[{"type":"text","text":"Event handler."}],"required":true,"comment":"Event handler.","async":false,"alias":"handler","overloadIndex":0}]},{"kind":"method","langs":{"only":["java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.37","name":"off","type":{"name":"void"},"spec":[{"type":"text","text":"Unregister an event handler for events with the specified event name.↵The given handler will not be called anymore for events with the given name."}],"required":true,"comment":"Unregister an event handler for events with the specified event name. The given handler will not be called anymore\nfor events with the given name.","async":false,"alias":"off","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.37","name":"eventName","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"CDP event name."}],"required":true,"comment":"CDP event name.","async":false,"alias":"eventName","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.37","name":"handler","type":{"name":"function","args":[{"name":"JsonObject"}],"expression":"[function]([JsonObject])"},"spec":[{"type":"text","text":"Event handler."}],"required":true,"comment":"Event handler.","async":false,"alias":"handler","overloadIndex":0}]}]},{"name":"CDPSessionEvent","spec":[{"type":"text","text":"`CDPSessionEvent` objects are returned by page via the [`method: CDPSession.event`] method."},{"type":"text","text":"Each object represents a named event and allows handling of the event when it is raised."}],"langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"comment":"`CDPSessionEvent` objects are returned by page via the [`method: CDPSession.event`] method.\n\nEach object represents a named event and allows handling of the event when it is raised.","since":"v1.30","members":[{"kind":"event","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.30","name":"onEvent","type":{"name":"JsonElement?","expression":"[JsonElement?]"},"spec":[],"required":true,"comment":"","async":false,"alias":"onEvent","overloadIndex":0,"args":[]},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"1.30","name":"eventName","type":{"name":"string","expression":"[string]"},"spec":[],"required":true,"comment":"","async":false,"alias":"eventName","overloadIndex":0,"args":[]}]},{"name":"Clock","spec":[{"type":"text","text":"Accurately simulating time-dependent behavior is essential for verifying the correctness of applications. Learn more about [clock emulation](../clock.md)."},{"type":"text","text":"Note that clock is installed for the entire `BrowserContext`, so the time↵in all the pages and iframes is controlled by the same clock."}],"langs":{},"comment":"Accurately simulating time-dependent behavior is essential for verifying the correctness of applications. Learn\nmore about [clock emulation](../clock.md).\n\nNote that clock is installed for the entire `BrowserContext`, so the time in all the pages and iframes is\ncontrolled by the same clock.","since":"v1.45","members":[{"kind":"method","langs":{},"since":"v1.45","name":"fastForward","type":{"name":"void"},"spec":[{"type":"text","text":"Advance the clock by jumping forward in time. Only fires due timers at most once. This is equivalent to user closing the laptop lid for a while and↵reopening it later, after given time."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await page.clock.fastForward(1000);","await page.clock.fastForward('30:00');"],"codeLang":"js"},{"type":"code","lines":["await page.clock.fast_forward(1000)","await page.clock.fast_forward(\"30:00\")"],"codeLang":"python async"},{"type":"code","lines":["page.clock.fast_forward(1000)","page.clock.fast_forward(\"30:00\")"],"codeLang":"python sync"},{"type":"code","lines":["page.clock().fastForward(1000);","page.clock().fastForward(\"30:00\");"],"codeLang":"java"},{"type":"code","lines":["await page.Clock.FastForwardAsync(1000);","await page.Clock.FastForwardAsync(\"30:00\");"],"codeLang":"csharp"}],"required":true,"comment":"Advance the clock by jumping forward in time. Only fires due timers at most once. This is equivalent to user\nclosing the laptop lid for a while and reopening it later, after given time.\n\n**Usage**\n\n```js\nawait page.clock.fastForward(1000);\nawait page.clock.fastForward('30:00');\n```\n\n```py\nawait page.clock.fast_forward(1000)\nawait page.clock.fast_forward(\"30:00\")\n```\n\n```py\npage.clock.fast_forward(1000)\npage.clock.fast_forward(\"30:00\")\n```\n\n```java\npage.clock().fastForward(1000);\npage.clock().fastForward(\"30:00\");\n```\n\n```csharp\nawait page.Clock.FastForwardAsync(1000);\nawait page.Clock.FastForwardAsync(\"30:00\");\n```\n","async":true,"alias":"fastForward","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.45","name":"ticks","type":{"name":"","union":[{"name":"long"},{"name":"string"}],"expression":"[long]|[string]"},"spec":[{"type":"text","text":"Time may be the number of milliseconds to advance the clock by or a human-readable string. Valid string formats are \"08\" for eight seconds, \"01:00\" for one minute and \"02:34:10\" for two hours, 34 minutes and ten seconds."}],"required":true,"comment":"Time may be the number of milliseconds to advance the clock by or a human-readable string. Valid string formats are\n\"08\" for eight seconds, \"01:00\" for one minute and \"02:34:10\" for two hours, 34 minutes and ten seconds.","async":false,"alias":"ticks","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.45","name":"install","type":{"name":"void"},"spec":[{"type":"text","text":"Install fake implementations for the following time-related functions:"},{"type":"li","text":"`Date`","liType":"bullet"},{"type":"li","text":"`setTimeout`","liType":"bullet"},{"type":"li","text":"`clearTimeout`","liType":"bullet"},{"type":"li","text":"`setInterval`","liType":"bullet"},{"type":"li","text":"`clearInterval`","liType":"bullet"},{"type":"li","text":"`requestAnimationFrame`","liType":"bullet"},{"type":"li","text":"`cancelAnimationFrame`","liType":"bullet"},{"type":"li","text":"`requestIdleCallback`","liType":"bullet"},{"type":"li","text":"`cancelIdleCallback`","liType":"bullet"},{"type":"li","text":"`performance`","liType":"bullet"},{"type":"text","text":"Fake timers are used to manually control the flow of time in tests. They allow you to advance time, fire timers, and control the behavior of time-dependent functions. See [`method: Clock.runFor`] and [`method: Clock.fastForward`] for more information."}],"required":true,"comment":"Install fake implementations for the following time-related functions:\n- `Date`\n- `setTimeout`\n- `clearTimeout`\n- `setInterval`\n- `clearInterval`\n- `requestAnimationFrame`\n- `cancelAnimationFrame`\n- `requestIdleCallback`\n- `cancelIdleCallback`\n- `performance`\n\nFake timers are used to manually control the flow of time in tests. They allow you to advance time, fire timers,\nand control the behavior of time-dependent functions. See [`method: Clock.runFor`] and\n[`method: Clock.fastForward`] for more information.","async":true,"alias":"install","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.45","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"long"},{"name":"string"},{"name":"Date"}],"expression":"[long]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to initialize with, current system time by default."}],"required":false,"comment":"Time to initialize with, current system time by default.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"float"},{"name":"string"},{"name":"Date"}],"expression":"[float]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to initialize with, current system time by default."}],"required":false,"comment":"Time to initialize with, current system time by default.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"string"},{"name":"Date"}],"expression":"[string]|[Date]"},"spec":[{"type":"text","text":"Time to initialize with, current system time by default."}],"required":false,"comment":"Time to initialize with, current system time by default.","async":false,"alias":"time","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.45","name":"runFor","type":{"name":"void"},"spec":[{"type":"text","text":"Advance the clock, firing all the time-related callbacks."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await page.clock.runFor(1000);","await page.clock.runFor('30:00');"],"codeLang":"js"},{"type":"code","lines":["await page.clock.run_for(1000);","await page.clock.run_for(\"30:00\")"],"codeLang":"python async"},{"type":"code","lines":["page.clock.run_for(1000);","page.clock.run_for(\"30:00\")"],"codeLang":"python sync"},{"type":"code","lines":["page.clock().runFor(1000);","page.clock().runFor(\"30:00\");"],"codeLang":"java"},{"type":"code","lines":["await page.Clock.RunForAsync(1000);","await page.Clock.RunForAsync(\"30:00\");"],"codeLang":"csharp"}],"required":true,"comment":"Advance the clock, firing all the time-related callbacks.\n\n**Usage**\n\n```js\nawait page.clock.runFor(1000);\nawait page.clock.runFor('30:00');\n```\n\n```py\nawait page.clock.run_for(1000);\nawait page.clock.run_for(\"30:00\")\n```\n\n```py\npage.clock.run_for(1000);\npage.clock.run_for(\"30:00\")\n```\n\n```java\npage.clock().runFor(1000);\npage.clock().runFor(\"30:00\");\n```\n\n```csharp\nawait page.Clock.RunForAsync(1000);\nawait page.Clock.RunForAsync(\"30:00\");\n```\n","async":true,"alias":"runFor","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.45","name":"ticks","type":{"name":"","union":[{"name":"long"},{"name":"string"}],"expression":"[long]|[string]"},"spec":[{"type":"text","text":"Time may be the number of milliseconds to advance the clock by or a human-readable string. Valid string formats are \"08\" for eight seconds, \"01:00\" for one minute and \"02:34:10\" for two hours, 34 minutes and ten seconds."}],"required":true,"comment":"Time may be the number of milliseconds to advance the clock by or a human-readable string. Valid string formats are\n\"08\" for eight seconds, \"01:00\" for one minute and \"02:34:10\" for two hours, 34 minutes and ten seconds.","async":false,"alias":"ticks","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.45","name":"pauseAt","type":{"name":"void"},"spec":[{"type":"text","text":"Advance the clock by jumping forward in time and pause the time. Once this method is called, no timers↵are fired unless [`method: Clock.runFor`], [`method: Clock.fastForward`], [`method: Clock.pauseAt`] or [`method: Clock.resume`] is called."},{"type":"text","text":"Only fires due timers at most once.↵This is equivalent to user closing the laptop lid for a while and reopening it at the specified time and↵pausing."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await page.clock.pauseAt(new Date('2020-02-02'));","await page.clock.pauseAt('2020-02-02');"],"codeLang":"js"},{"type":"code","lines":["await page.clock.pause_at(datetime.datetime(2020, 2, 2))","await page.clock.pause_at(\"2020-02-02\")"],"codeLang":"python async"},{"type":"code","lines":["page.clock.pause_at(datetime.datetime(2020, 2, 2))","page.clock.pause_at(\"2020-02-02\")"],"codeLang":"python sync"},{"type":"code","lines":["SimpleDateFormat format = new SimpleDateFormat(\"yyy-MM-dd\");","page.clock().pauseAt(format.parse(\"2020-02-02\"));","page.clock().pauseAt(\"2020-02-02\");"],"codeLang":"java"},{"type":"code","lines":["await page.Clock.PauseAtAsync(DateTime.Parse(\"2020-02-02\"));","await page.Clock.PauseAtAsync(\"2020-02-02\");"],"codeLang":"csharp"},{"type":"text","text":"For best results, install the clock before navigating the page and set it to a time slightly before the intended test time. This ensures that all timers run normally during page loading, preventing the page from getting stuck. Once the page has fully loaded, you can safely use [`method: Clock.pauseAt`] to pause the clock."},{"type":"code","lines":["// Initialize clock with some time before the test time and let the page load","// naturally. `Date.now` will progress as the timers fire.","await page.clock.install({ time: new Date('2024-12-10T08:00:00') });","await page.goto('http://localhost:3333');","await page.clock.pauseAt(new Date('2024-12-10T10:00:00'));"],"codeLang":"js"},{"type":"code","lines":["# Initialize clock with some time before the test time and let the page load","# naturally. `Date.now` will progress as the timers fire.","await page.clock.install(time=datetime.datetime(2024, 12, 10, 8, 0, 0))","await page.goto(\"http://localhost:3333\")","await page.clock.pause_at(datetime.datetime(2024, 12, 10, 10, 0, 0))"],"codeLang":"python async"},{"type":"code","lines":["# Initialize clock with some time before the test time and let the page load","# naturally. `Date.now` will progress as the timers fire.","page.clock.install(time=datetime.datetime(2024, 12, 10, 8, 0, 0))","page.goto(\"http://localhost:3333\")","page.clock.pause_at(datetime.datetime(2024, 12, 10, 10, 0, 0))"],"codeLang":"python sync"},{"type":"code","lines":["// Initialize clock with some time before the test time and let the page load","// naturally. `Date.now` will progress as the timers fire.","SimpleDateFormat format = new SimpleDateFormat(\"yyy-MM-dd'T'HH:mm:ss\");","page.clock().install(new Clock.InstallOptions().setTime(format.parse(\"2024-12-10T08:00:00\")));","page.navigate(\"http://localhost:3333\");","page.clock().pauseAt(format.parse(\"2024-12-10T10:00:00\"));"],"codeLang":"java"}],"required":true,"comment":"Advance the clock by jumping forward in time and pause the time. Once this method is called, no timers are fired\nunless [`method: Clock.runFor`], [`method: Clock.fastForward`], [`method: Clock.pauseAt`] or\n[`method: Clock.resume`] is called.\n\nOnly fires due timers at most once. This is equivalent to user closing the laptop lid for a while and reopening it\nat the specified time and pausing.\n\n**Usage**\n\n```js\nawait page.clock.pauseAt(new Date('2020-02-02'));\nawait page.clock.pauseAt('2020-02-02');\n```\n\n```py\nawait page.clock.pause_at(datetime.datetime(2020, 2, 2))\nawait page.clock.pause_at(\"2020-02-02\")\n```\n\n```py\npage.clock.pause_at(datetime.datetime(2020, 2, 2))\npage.clock.pause_at(\"2020-02-02\")\n```\n\n```java\nSimpleDateFormat format = new SimpleDateFormat(\"yyy-MM-dd\");\npage.clock().pauseAt(format.parse(\"2020-02-02\"));\npage.clock().pauseAt(\"2020-02-02\");\n```\n\n```csharp\nawait page.Clock.PauseAtAsync(DateTime.Parse(\"2020-02-02\"));\nawait page.Clock.PauseAtAsync(\"2020-02-02\");\n```\n\nFor best results, install the clock before navigating the page and set it to a time slightly before the intended\ntest time. This ensures that all timers run normally during page loading, preventing the page from getting stuck.\nOnce the page has fully loaded, you can safely use [`method: Clock.pauseAt`] to pause the clock.\n\n```js\n// Initialize clock with some time before the test time and let the page load\n// naturally. `Date.now` will progress as the timers fire.\nawait page.clock.install({ time: new Date('2024-12-10T08:00:00') });\nawait page.goto('http://localhost:3333');\nawait page.clock.pauseAt(new Date('2024-12-10T10:00:00'));\n```\n\n```py\n# Initialize clock with some time before the test time and let the page load\n# naturally. `Date.now` will progress as the timers fire.\nawait page.clock.install(time=datetime.datetime(2024, 12, 10, 8, 0, 0))\nawait page.goto(\"http://localhost:3333\")\nawait page.clock.pause_at(datetime.datetime(2024, 12, 10, 10, 0, 0))\n```\n\n```py\n# Initialize clock with some time before the test time and let the page load\n# naturally. `Date.now` will progress as the timers fire.\npage.clock.install(time=datetime.datetime(2024, 12, 10, 8, 0, 0))\npage.goto(\"http://localhost:3333\")\npage.clock.pause_at(datetime.datetime(2024, 12, 10, 10, 0, 0))\n```\n\n```java\n// Initialize clock with some time before the test time and let the page load\n// naturally. `Date.now` will progress as the timers fire.\nSimpleDateFormat format = new SimpleDateFormat(\"yyy-MM-dd'T'HH:mm:ss\");\npage.clock().install(new Clock.InstallOptions().setTime(format.parse(\"2024-12-10T08:00:00\")));\npage.navigate(\"http://localhost:3333\");\npage.clock().pauseAt(format.parse(\"2024-12-10T10:00:00\"));\n```\n","async":true,"alias":"pauseAt","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"long"},{"name":"string"},{"name":"Date"}],"expression":"[long]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to pause at."}],"required":true,"comment":"Time to pause at.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"float"},{"name":"string"},{"name":"Date"}],"expression":"[float]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to pause at."}],"required":true,"comment":"Time to pause at.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"Date"},{"name":"string"}],"expression":"[Date]|[string]"},"spec":[{"type":"text","text":"Time to pause at."}],"required":true,"comment":"Time to pause at.","async":false,"alias":"time","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.45","name":"resume","type":{"name":"void"},"spec":[{"type":"text","text":"Resumes timers. Once this method is called, time resumes flowing, timers are fired as usual."}],"required":true,"comment":"Resumes timers. Once this method is called, time resumes flowing, timers are fired as usual.","async":true,"alias":"resume","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.45","name":"setFixedTime","type":{"name":"void"},"spec":[{"type":"text","text":"Makes `Date.now` and `new Date()` return fixed fake time at all times,↵keeps all the timers running."},{"type":"text","text":"Use this method for simple scenarios where you only need to test with a predefined time. For more advanced scenarios, use [`method: Clock.install`] instead. Read docs on [clock emulation](../clock.md) to learn more."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await page.clock.setFixedTime(Date.now());","await page.clock.setFixedTime(new Date('2020-02-02'));","await page.clock.setFixedTime('2020-02-02');"],"codeLang":"js"},{"type":"code","lines":["await page.clock.set_fixed_time(datetime.datetime.now())","await page.clock.set_fixed_time(datetime.datetime(2020, 2, 2))","await page.clock.set_fixed_time(\"2020-02-02\")"],"codeLang":"python async"},{"type":"code","lines":["page.clock.set_fixed_time(datetime.datetime.now())","page.clock.set_fixed_time(datetime.datetime(2020, 2, 2))","page.clock.set_fixed_time(\"2020-02-02\")"],"codeLang":"python sync"},{"type":"code","lines":["page.clock().setFixedTime(new Date());","page.clock().setFixedTime(new SimpleDateFormat(\"yyy-MM-dd\").parse(\"2020-02-02\"));","page.clock().setFixedTime(\"2020-02-02\");"],"codeLang":"java"},{"type":"code","lines":["await page.Clock.SetFixedTimeAsync(DateTime.Now);","await page.Clock.SetFixedTimeAsync(new DateTime(2020, 2, 2));","await page.Clock.SetFixedTimeAsync(\"2020-02-02\");"],"codeLang":"csharp"}],"required":true,"comment":"Makes `Date.now` and `new Date()` return fixed fake time at all times, keeps all the timers running.\n\nUse this method for simple scenarios where you only need to test with a predefined time. For more advanced\nscenarios, use [`method: Clock.install`] instead. Read docs on [clock emulation](../clock.md) to learn more.\n\n**Usage**\n\n```js\nawait page.clock.setFixedTime(Date.now());\nawait page.clock.setFixedTime(new Date('2020-02-02'));\nawait page.clock.setFixedTime('2020-02-02');\n```\n\n```py\nawait page.clock.set_fixed_time(datetime.datetime.now())\nawait page.clock.set_fixed_time(datetime.datetime(2020, 2, 2))\nawait page.clock.set_fixed_time(\"2020-02-02\")\n```\n\n```py\npage.clock.set_fixed_time(datetime.datetime.now())\npage.clock.set_fixed_time(datetime.datetime(2020, 2, 2))\npage.clock.set_fixed_time(\"2020-02-02\")\n```\n\n```java\npage.clock().setFixedTime(new Date());\npage.clock().setFixedTime(new SimpleDateFormat(\"yyy-MM-dd\").parse(\"2020-02-02\"));\npage.clock().setFixedTime(\"2020-02-02\");\n```\n\n```csharp\nawait page.Clock.SetFixedTimeAsync(DateTime.Now);\nawait page.Clock.SetFixedTimeAsync(new DateTime(2020, 2, 2));\nawait page.Clock.SetFixedTimeAsync(\"2020-02-02\");\n```\n","async":true,"alias":"setFixedTime","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"long"},{"name":"string"},{"name":"Date"}],"expression":"[long]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to be set in milliseconds."}],"required":true,"comment":"Time to be set in milliseconds.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"float"},{"name":"string"},{"name":"Date"}],"expression":"[float]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to be set."}],"required":true,"comment":"Time to be set.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"string"},{"name":"Date"}],"expression":"[string]|[Date]"},"spec":[{"type":"text","text":"Time to be set."}],"required":true,"comment":"Time to be set.","async":false,"alias":"time","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.45","name":"setSystemTime","type":{"name":"void"},"spec":[{"type":"text","text":"Sets system time, but does not trigger any timers. Use this to test how the web page reacts to a time shift, for example switching from summer to winter time, or changing time zones."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await page.clock.setSystemTime(Date.now());","await page.clock.setSystemTime(new Date('2020-02-02'));","await page.clock.setSystemTime('2020-02-02');"],"codeLang":"js"},{"type":"code","lines":["await page.clock.set_system_time(datetime.datetime.now())","await page.clock.set_system_time(datetime.datetime(2020, 2, 2))","await page.clock.set_system_time(\"2020-02-02\")"],"codeLang":"python async"},{"type":"code","lines":["page.clock.set_system_time(datetime.datetime.now())","page.clock.set_system_time(datetime.datetime(2020, 2, 2))","page.clock.set_system_time(\"2020-02-02\")"],"codeLang":"python sync"},{"type":"code","lines":["page.clock().setSystemTime(new Date());","page.clock().setSystemTime(new SimpleDateFormat(\"yyy-MM-dd\").parse(\"2020-02-02\"));","page.clock().setSystemTime(\"2020-02-02\");"],"codeLang":"java"},{"type":"code","lines":["await page.Clock.SetSystemTimeAsync(DateTime.Now);","await page.Clock.SetSystemTimeAsync(new DateTime(2020, 2, 2));","await page.Clock.SetSystemTimeAsync(\"2020-02-02\");"],"codeLang":"csharp"}],"required":true,"comment":"Sets system time, but does not trigger any timers. Use this to test how the web page reacts to a time shift, for\nexample switching from summer to winter time, or changing time zones.\n\n**Usage**\n\n```js\nawait page.clock.setSystemTime(Date.now());\nawait page.clock.setSystemTime(new Date('2020-02-02'));\nawait page.clock.setSystemTime('2020-02-02');\n```\n\n```py\nawait page.clock.set_system_time(datetime.datetime.now())\nawait page.clock.set_system_time(datetime.datetime(2020, 2, 2))\nawait page.clock.set_system_time(\"2020-02-02\")\n```\n\n```py\npage.clock.set_system_time(datetime.datetime.now())\npage.clock.set_system_time(datetime.datetime(2020, 2, 2))\npage.clock.set_system_time(\"2020-02-02\")\n```\n\n```java\npage.clock().setSystemTime(new Date());\npage.clock().setSystemTime(new SimpleDateFormat(\"yyy-MM-dd\").parse(\"2020-02-02\"));\npage.clock().setSystemTime(\"2020-02-02\");\n```\n\n```csharp\nawait page.Clock.SetSystemTimeAsync(DateTime.Now);\nawait page.Clock.SetSystemTimeAsync(new DateTime(2020, 2, 2));\nawait page.Clock.SetSystemTimeAsync(\"2020-02-02\");\n```\n","async":true,"alias":"setSystemTime","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"long"},{"name":"string"},{"name":"Date"}],"expression":"[long]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to be set in milliseconds."}],"required":true,"comment":"Time to be set in milliseconds.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"float"},{"name":"string"},{"name":"Date"}],"expression":"[float]|[string]|[Date]"},"spec":[{"type":"text","text":"Time to be set."}],"required":true,"comment":"Time to be set.","async":false,"alias":"time","overloadIndex":0},{"kind":"property","langs":{"only":["csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.45","name":"time","type":{"name":"","union":[{"name":"string"},{"name":"Date"}],"expression":"[string]|[Date]"},"spec":[{"type":"text","text":"Time to be set."}],"required":true,"comment":"Time to be set.","async":false,"alias":"time","overloadIndex":0}]}]},{"name":"ConsoleMessage","spec":[{"type":"text","text":"`ConsoleMessage` objects are dispatched by page via the [`event: Page.console`] event.↵For each console message logged in the page there will be corresponding event in the Playwright↵context."},{"type":"code","lines":["// Listen for all console logs","page.on('console', msg => console.log(msg.text()));","","// Listen for all console events and handle errors","page.on('console', msg => {","  if (msg.type() === 'error')","    console.log(`Error text: \"${msg.text()}\"`);","});","","// Get the next console log","const msgPromise = page.waitForEvent('console');","await page.evaluate(() => {","  console.log('hello', 42, { foo: 'bar' });  // Issue console.log inside the page","});","const msg = await msgPromise;","","// Deconstruct console log arguments","await msg.args()[0].jsonValue(); // hello","await msg.args()[1].jsonValue(); // 42"],"codeLang":"js"},{"type":"code","lines":["// Listen for all console messages and print them to the standard output.","page.onConsoleMessage(msg -> System.out.println(msg.text()));","","// Listen for all console messages and print errors to the standard output.","page.onConsoleMessage(msg -> {","  if (\"error\".equals(msg.type()))","    System.out.println(\"Error text: \" + msg.text());","});","","// Get the next console message","ConsoleMessage msg = page.waitForConsoleMessage(() -> {","  // Issue console.log inside the page","  page.evaluate(\"console.log('hello', 42, { foo: 'bar' });\");","});","","// Deconstruct console.log arguments","msg.args().get(0).jsonValue(); // hello","msg.args().get(1).jsonValue(); // 42"],"codeLang":"java"},{"type":"code","lines":["# Listen for all console logs","page.on(\"console\", lambda msg: print(msg.text))","","# Listen for all console events and handle errors","page.on(\"console\", lambda msg: print(f\"error: {msg.text}\") if msg.type == \"error\" else None)","","# Get the next console log","async with page.expect_console_message() as msg_info:","    # Issue console.log inside the page","    await page.evaluate(\"console.log('hello', 42, { foo: 'bar' })\")","msg = await msg_info.value","","# Deconstruct print arguments","await msg.args[0].json_value() # hello","await msg.args[1].json_value() # 42"],"codeLang":"python async"},{"type":"code","lines":["# Listen for all console logs","page.on(\"console\", lambda msg: print(msg.text))","","# Listen for all console events and handle errors","page.on(\"console\", lambda msg: print(f\"error: {msg.text}\") if msg.type == \"error\" else None)","","# Get the next console log","with page.expect_console_message() as msg_info:","    # Issue console.log inside the page","    page.evaluate(\"console.log('hello', 42, { foo: 'bar' })\")","msg = msg_info.value","","# Deconstruct print arguments","msg.args[0].json_value() # hello","msg.args[1].json_value() # 42"],"codeLang":"python sync"},{"type":"code","lines":["// Listen for all console messages and print them to the standard output.","page.Console += (_, msg) => Console.WriteLine(msg.Text);","","// Listen for all console messages and print errors to the standard output.","page.Console += (_, msg) =>","{","    if (\"error\".Equals(msg.Type))","        Console.WriteLine(\"Error text: \" + msg.Text);","};","","// Get the next console message","var waitForMessageTask = page.WaitForConsoleMessageAsync();","await page.EvaluateAsync(\"console.log('hello', 42, { foo: 'bar' });\");","var message = await waitForMessageTask;","// Deconstruct console.log arguments","await message.Args.ElementAt(0).JsonValueAsync<string>(); // hello","await message.Args.ElementAt(1).JsonValueAsync<int>(); // 42"],"codeLang":"csharp"}],"langs":{},"comment":"`ConsoleMessage` objects are dispatched by page via the [`event: Page.console`] event. For each console message\nlogged in the page there will be corresponding event in the Playwright context.\n\n```js\n// Listen for all console logs\npage.on('console', msg => console.log(msg.text()));\n\n// Listen for all console events and handle errors\npage.on('console', msg => {\n  if (msg.type() === 'error')\n    console.log(`Error text: \"${msg.text()}\"`);\n});\n\n// Get the next console log\nconst msgPromise = page.waitForEvent('console');\nawait page.evaluate(() => {\n  console.log('hello', 42, { foo: 'bar' });  // Issue console.log inside the page\n});\nconst msg = await msgPromise;\n\n// Deconstruct console log arguments\nawait msg.args()[0].jsonValue(); // hello\nawait msg.args()[1].jsonValue(); // 42\n```\n\n```java\n// Listen for all console messages and print them to the standard output.\npage.onConsoleMessage(msg -> System.out.println(msg.text()));\n\n// Listen for all console messages and print errors to the standard output.\npage.onConsoleMessage(msg -> {\n  if (\"error\".equals(msg.type()))\n    System.out.println(\"Error text: \" + msg.text());\n});\n\n// Get the next console message\nConsoleMessage msg = page.waitForConsoleMessage(() -> {\n  // Issue console.log inside the page\n  page.evaluate(\"console.log('hello', 42, { foo: 'bar' });\");\n});\n\n// Deconstruct console.log arguments\nmsg.args().get(0).jsonValue(); // hello\nmsg.args().get(1).jsonValue(); // 42\n```\n\n```py\n# Listen for all console logs\npage.on(\"console\", lambda msg: print(msg.text))\n\n# Listen for all console events and handle errors\npage.on(\"console\", lambda msg: print(f\"error: {msg.text}\") if msg.type == \"error\" else None)\n\n# Get the next console log\nasync with page.expect_console_message() as msg_info:\n    # Issue console.log inside the page\n    await page.evaluate(\"console.log('hello', 42, { foo: 'bar' })\")\nmsg = await msg_info.value\n\n# Deconstruct print arguments\nawait msg.args[0].json_value() # hello\nawait msg.args[1].json_value() # 42\n```\n\n```py\n# Listen for all console logs\npage.on(\"console\", lambda msg: print(msg.text))\n\n# Listen for all console events and handle errors\npage.on(\"console\", lambda msg: print(f\"error: {msg.text}\") if msg.type == \"error\" else None)\n\n# Get the next console log\nwith page.expect_console_message() as msg_info:\n    # Issue console.log inside the page\n    page.evaluate(\"console.log('hello', 42, { foo: 'bar' })\")\nmsg = msg_info.value\n\n# Deconstruct print arguments\nmsg.args[0].json_value() # hello\nmsg.args[1].json_value() # 42\n```\n\n```csharp\n// Listen for all console messages and print them to the standard output.\npage.Console += (_, msg) => Console.WriteLine(msg.Text);\n\n// Listen for all console messages and print errors to the standard output.\npage.Console += (_, msg) =>\n{\n    if (\"error\".Equals(msg.Type))\n        Console.WriteLine(\"Error text: \" + msg.Text);\n};\n\n// Get the next console message\nvar waitForMessageTask = page.WaitForConsoleMessageAsync();\nawait page.EvaluateAsync(\"console.log('hello', 42, { foo: 'bar' });\");\nvar message = await waitForMessageTask;\n// Deconstruct console.log arguments\nawait message.Args.ElementAt(0).JsonValueAsync<string>(); // hello\nawait message.Args.ElementAt(1).JsonValueAsync<int>(); // 42\n```\n","since":"v1.8","members":[{"kind":"method","langs":{},"since":"v1.8","name":"args","type":{"name":"Array","templates":[{"name":"JSHandle"}],"expression":"[Array]<[JSHandle]>"},"spec":[{"type":"text","text":"List of arguments passed to a `console` function call. See also [`event: Page.console`]."}],"required":true,"comment":"List of arguments passed to a `console` function call. See also [`event: Page.console`].","async":false,"alias":"args","overloadIndex":0,"args":[]},{"kind":"method","langs":{"only":["js","python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"location","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"URL of the resource."}],"required":true,"comment":"URL of the resource.","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"lineNumber","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"0-based line number in the resource."}],"required":true,"comment":"0-based line number in the resource.","async":false,"alias":"lineNumber","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"columnNumber","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"0-based column number in the resource."}],"required":true,"comment":"0-based column number in the resource.","async":false,"alias":"columnNumber","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":true,"comment":"","async":false,"alias":"location","overloadIndex":0,"args":[]},{"kind":"method","langs":{"only":["csharp","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"location","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"URL of the resource followed by 0-based line and column numbers in the resource formatted as `URL:line:column`."}],"required":true,"comment":"URL of the resource followed by 0-based line and column numbers in the resource formatted as `URL:line:column`.","async":false,"alias":"location","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.34","name":"page","type":{"name":"","union":[{"name":"null"},{"name":"Page"}],"expression":"[null]|[Page]"},"spec":[{"type":"text","text":"The page that produced this console message, if any."}],"required":true,"comment":"The page that produced this console message, if any.","async":false,"alias":"page","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"text","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"The text of the console message."}],"required":true,"comment":"The text of the console message.","async":false,"alias":"text","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"type","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"One of the following values: `'log'`, `'debug'`, `'info'`, `'error'`, `'warning'`, `'dir'`, `'dirxml'`, `'table'`,↵`'trace'`, `'clear'`, `'startGroup'`, `'startGroupCollapsed'`, `'endGroup'`, `'assert'`, `'profile'`, `'profileEnd'`,↵`'count'`, `'timeEnd'`."}],"required":true,"comment":"One of the following values: `'log'`, `'debug'`, `'info'`, `'error'`, `'warning'`, `'dir'`, `'dirxml'`, `'table'`,\n`'trace'`, `'clear'`, `'startGroup'`, `'startGroupCollapsed'`, `'endGroup'`, `'assert'`, `'profile'`,\n`'profileEnd'`, `'count'`, `'timeEnd'`.","async":false,"alias":"type","overloadIndex":0,"args":[]}]},{"name":"Coverage","spec":[{"type":"text","text":"Coverage gathers information about parts of JavaScript and CSS that were used by the page."},{"type":"text","text":"An example of using JavaScript coverage to produce Istanbul report for page load:"},{"type":"note","noteType":"note","children":[{"type":"text","text":"Coverage APIs are only supported on Chromium-based browsers."}]},{"type":"code","lines":["const { chromium } = require('playwright');","const v8toIstanbul = require('v8-to-istanbul');","","(async () => {","  const browser = await chromium.launch();","  const page = await browser.newPage();","  await page.coverage.startJSCoverage();","  await page.goto('https://chromium.org');","  const coverage = await page.coverage.stopJSCoverage();","  for (const entry of coverage) {","    const converter = v8toIstanbul('', 0, { source: entry.source });","    await converter.load();","    converter.applyCoverage(entry.functions);","    console.log(JSON.stringify(converter.toIstanbul()));","  }","  await browser.close();","})();"],"codeLang":"js"}],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"comment":"Coverage gathers information about parts of JavaScript and CSS that were used by the page.\n\nAn example of using JavaScript coverage to produce Istanbul report for page load:\n\n**NOTE** Coverage APIs are only supported on Chromium-based browsers.\n\n```js\nconst { chromium } = require('playwright');\nconst v8toIstanbul = require('v8-to-istanbul');\n\n(async () => {\n  const browser = await chromium.launch();\n  const page = await browser.newPage();\n  await page.coverage.startJSCoverage();\n  await page.goto('https://chromium.org');\n  const coverage = await page.coverage.stopJSCoverage();\n  for (const entry of coverage) {\n    const converter = v8toIstanbul('', 0, { source: entry.source });\n    await converter.load();\n    converter.applyCoverage(entry.functions);\n    console.log(JSON.stringify(converter.toIstanbul()));\n  }\n  await browser.close();\n})();\n```\n","since":"v1.11","members":[{"kind":"method","langs":{},"since":"v1.11","name":"startCSSCoverage","type":{"name":"void"},"spec":[{"type":"text","text":"Returns coverage is started"}],"required":true,"comment":"Returns coverage is started","async":true,"alias":"startCSSCoverage","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.11","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"resetOnNavigation","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to reset coverage on every navigation. Defaults to `true`."}],"required":false,"comment":"Whether to reset coverage on every navigation. Defaults to `true`.","async":false,"alias":"resetOnNavigation","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.11","name":"startJSCoverage","type":{"name":"void"},"spec":[{"type":"text","text":"Returns coverage is started"},{"type":"note","noteType":"note","children":[{"type":"text","text":"Anonymous scripts are ones that don't have an associated url. These are scripts that are dynamically created↵on the page using `eval` or `new Function`. If `reportAnonymousScripts` is set to `true`, anonymous scripts↵will have `__playwright_evaluation_script__` as their URL."}]}],"required":true,"comment":"Returns coverage is started\n\n**NOTE** Anonymous scripts are ones that don't have an associated url. These are scripts that are dynamically\ncreated on the page using `eval` or `new Function`. If `reportAnonymousScripts` is set to `true`, anonymous scripts\nwill have `__playwright_evaluation_script__` as their URL.\n","async":true,"alias":"startJSCoverage","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.11","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"reportAnonymousScripts","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether anonymous scripts generated by the page should be reported. Defaults to `false`."}],"required":false,"comment":"Whether anonymous scripts generated by the page should be reported. Defaults to `false`.","async":false,"alias":"reportAnonymousScripts","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"resetOnNavigation","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to reset coverage on every navigation. Defaults to `true`."}],"required":false,"comment":"Whether to reset coverage on every navigation. Defaults to `true`.","async":false,"alias":"resetOnNavigation","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.11","name":"stopCSSCoverage","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"StyleSheet URL"}],"required":true,"comment":"StyleSheet URL","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"text","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"StyleSheet content, if available."}],"required":false,"comment":"StyleSheet content, if available.","async":false,"alias":"text","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"ranges","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"start","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"A start offset in text, inclusive"}],"required":true,"comment":"A start offset in text, inclusive","async":false,"alias":"start","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"end","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"An end offset in text, exclusive"}],"required":true,"comment":"An end offset in text, exclusive","async":false,"alias":"end","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"StyleSheet ranges that were used. Ranges are sorted and non-overlapping."}],"required":true,"comment":"StyleSheet ranges that were used. Ranges are sorted and non-overlapping.","async":false,"alias":"ranges","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"Returns the array of coverage reports for all stylesheets"},{"type":"note","noteType":"note","children":[{"type":"text","text":"CSS Coverage doesn't include dynamically injected style tags without sourceURLs."}]}],"required":true,"comment":"Returns the array of coverage reports for all stylesheets\n\n**NOTE** CSS Coverage doesn't include dynamically injected style tags without sourceURLs.\n","async":true,"alias":"stopCSSCoverage","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.11","name":"stopJSCoverage","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Script URL"}],"required":true,"comment":"Script URL","async":false,"alias":"url","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"scriptId","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Script ID"}],"required":true,"comment":"Script ID","async":false,"alias":"scriptId","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"source","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Script content, if applicable."}],"required":false,"comment":"Script content, if applicable.","async":false,"alias":"source","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"functions","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"functionName","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"functionName","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"isBlockCoverage","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"isBlockCoverage","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"ranges","type":{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"count","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"count","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"startOffset","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"startOffset","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"endOffset","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"endOffset","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"ranges","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"V8-specific coverage format."}],"required":true,"comment":"V8-specific coverage format.","async":false,"alias":"functions","overloadIndex":0}]}],"expression":"[Array]<[Object]>"},"spec":[{"type":"text","text":"Returns the array of coverage reports for all scripts"},{"type":"note","noteType":"note","children":[{"type":"text","text":"JavaScript Coverage doesn't include anonymous scripts by default. However, scripts with sourceURLs are↵reported."}]}],"required":true,"comment":"Returns the array of coverage reports for all scripts\n\n**NOTE** JavaScript Coverage doesn't include anonymous scripts by default. However, scripts with sourceURLs are\nreported.\n","async":true,"alias":"stopJSCoverage","overloadIndex":0,"args":[]}]},{"name":"Dialog","spec":[{"type":"text","text":"`Dialog` objects are dispatched by page via the [`event: Page.dialog`] event."},{"type":"text","text":"An example of using `Dialog` class:"},{"type":"code","lines":["const { chromium } = require('playwright');  // Or 'firefox' or 'webkit'.","","(async () => {","  const browser = await chromium.launch();","  const page = await browser.newPage();","  page.on('dialog', async dialog => {","    console.log(dialog.message());","    await dialog.dismiss();","  });","  await page.evaluate(() => alert('1'));","  await browser.close();","})();"],"codeLang":"js"},{"type":"code","lines":["import com.microsoft.playwright.*;","","public class Example {","  public static void main(String[] args) {","    try (Playwright playwright = Playwright.create()) {","      BrowserType chromium = playwright.chromium();","      Browser browser = chromium.launch();","      Page page = browser.newPage();","      page.onDialog(dialog -> {","        System.out.println(dialog.message());","        dialog.dismiss();","      });","      page.evaluate(\"alert('1')\");","      browser.close();","    }","  }","}"],"codeLang":"java"},{"type":"code","lines":["import asyncio","from playwright.async_api import async_playwright, Playwright","","async def handle_dialog(dialog):","    print(dialog.message)","    await dialog.dismiss()","","async def run(playwright: Playwright):","    chromium = playwright.chromium","    browser = await chromium.launch()","    page = await browser.new_page()","    page.on(\"dialog\", handle_dialog)","    page.evaluate(\"alert('1')\")","    await browser.close()","","async def main():","    async with async_playwright() as playwright:","        await run(playwright)","asyncio.run(main())"],"codeLang":"python async"},{"type":"code","lines":["from playwright.sync_api import sync_playwright, Playwright","","def handle_dialog(dialog):","    print(dialog.message)","    dialog.dismiss()","","def run(playwright: Playwright):","    chromium = playwright.chromium","    browser = chromium.launch()","    page = browser.new_page()","    page.on(\"dialog\", handle_dialog)","    page.evaluate(\"alert('1')\")","    browser.close()","","with sync_playwright() as playwright:","    run(playwright)"],"codeLang":"python sync"},{"type":"code","lines":["using Microsoft.Playwright;","using System.Threading.Tasks;","","class DialogExample","{","    public static async Task Run()","    {","        using var playwright = await Playwright.CreateAsync();","        await using var browser = await playwright.Chromium.LaunchAsync();","        var page = await browser.NewPageAsync();","","        page.Dialog += async (_, dialog) =>","        {","            System.Console.WriteLine(dialog.Message);","            await dialog.DismissAsync();","        };","","        await page.EvaluateAsync(\"alert('1');\");","    }","}"],"codeLang":"csharp"},{"type":"note","noteType":"note","children":[{"type":"text","text":"Dialogs are dismissed automatically, unless there is a [`event: Page.dialog`] listener.↵When listener is present, it **must** either [`method: Dialog.accept`] or [`method: Dialog.dismiss`] the dialog - otherwise the page will [freeze](https://developer.mozilla.org/en-US/docs/Web/JavaScript/EventLoop#never_blocking) waiting for the dialog, and actions like click will never finish."}]}],"langs":{},"comment":"`Dialog` objects are dispatched by page via the [`event: Page.dialog`] event.\n\nAn example of using `Dialog` class:\n\n```js\nconst { chromium } = require('playwright');  // Or 'firefox' or 'webkit'.\n\n(async () => {\n  const browser = await chromium.launch();\n  const page = await browser.newPage();\n  page.on('dialog', async dialog => {\n    console.log(dialog.message());\n    await dialog.dismiss();\n  });\n  await page.evaluate(() => alert('1'));\n  await browser.close();\n})();\n```\n\n```java\nimport com.microsoft.playwright.*;\n\npublic class Example {\n  public static void main(String[] args) {\n    try (Playwright playwright = Playwright.create()) {\n      BrowserType chromium = playwright.chromium();\n      Browser browser = chromium.launch();\n      Page page = browser.newPage();\n      page.onDialog(dialog -> {\n        System.out.println(dialog.message());\n        dialog.dismiss();\n      });\n      page.evaluate(\"alert('1')\");\n      browser.close();\n    }\n  }\n}\n```\n\n```py\nimport asyncio\nfrom playwright.async_api import async_playwright, Playwright\n\nasync def handle_dialog(dialog):\n    print(dialog.message)\n    await dialog.dismiss()\n\nasync def run(playwright: Playwright):\n    chromium = playwright.chromium\n    browser = await chromium.launch()\n    page = await browser.new_page()\n    page.on(\"dialog\", handle_dialog)\n    page.evaluate(\"alert('1')\")\n    await browser.close()\n\nasync def main():\n    async with async_playwright() as playwright:\n        await run(playwright)\nasyncio.run(main())\n```\n\n```py\nfrom playwright.sync_api import sync_playwright, Playwright\n\ndef handle_dialog(dialog):\n    print(dialog.message)\n    dialog.dismiss()\n\ndef run(playwright: Playwright):\n    chromium = playwright.chromium\n    browser = chromium.launch()\n    page = browser.new_page()\n    page.on(\"dialog\", handle_dialog)\n    page.evaluate(\"alert('1')\")\n    browser.close()\n\nwith sync_playwright() as playwright:\n    run(playwright)\n```\n\n```csharp\nusing Microsoft.Playwright;\nusing System.Threading.Tasks;\n\nclass DialogExample\n{\n    public static async Task Run()\n    {\n        using var playwright = await Playwright.CreateAsync();\n        await using var browser = await playwright.Chromium.LaunchAsync();\n        var page = await browser.NewPageAsync();\n\n        page.Dialog += async (_, dialog) =>\n        {\n            System.Console.WriteLine(dialog.Message);\n            await dialog.DismissAsync();\n        };\n\n        await page.EvaluateAsync(\"alert('1');\");\n    }\n}\n```\n\n**NOTE** Dialogs are dismissed automatically, unless there is a [`event: Page.dialog`] listener. When listener is\npresent, it **must** either [`method: Dialog.accept`] or [`method: Dialog.dismiss`] the dialog - otherwise the page\nwill [freeze](https://developer.mozilla.org/en-US/docs/Web/JavaScript/EventLoop#never_blocking) waiting for the\ndialog, and actions like click will never finish.\n","since":"v1.8","members":[{"kind":"method","langs":{},"since":"v1.8","name":"accept","type":{"name":"void"},"spec":[{"type":"text","text":"Returns when the dialog has been accepted."}],"required":true,"comment":"Returns when the dialog has been accepted.","async":true,"alias":"accept","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"promptText","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A text to enter in prompt. Does not cause any effects if the dialog's `type` is not prompt. Optional."}],"required":false,"comment":"A text to enter in prompt. Does not cause any effects if the dialog's `type` is not prompt. Optional.","async":false,"alias":"promptText","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"defaultValue","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"If dialog is prompt, returns default prompt value. Otherwise, returns empty string."}],"required":true,"comment":"If dialog is prompt, returns default prompt value. Otherwise, returns empty string.","async":false,"alias":"defaultValue","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"dismiss","type":{"name":"void"},"spec":[{"type":"text","text":"Returns when the dialog has been dismissed."}],"required":true,"comment":"Returns when the dialog has been dismissed.","async":true,"alias":"dismiss","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"message","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A message displayed in the dialog."}],"required":true,"comment":"A message displayed in the dialog.","async":false,"alias":"message","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.34","name":"page","type":{"name":"","union":[{"name":"null"},{"name":"Page"}],"expression":"[null]|[Page]"},"spec":[{"type":"text","text":"The page that initiated this dialog, if available."}],"required":true,"comment":"The page that initiated this dialog, if available.","async":false,"alias":"page","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"type","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns dialog's type, can be one of `alert`, `beforeunload`, `confirm` or `prompt`."}],"required":true,"comment":"Returns dialog's type, can be one of `alert`, `beforeunload`, `confirm` or `prompt`.","async":false,"alias":"type","overloadIndex":0,"args":[]}]},{"name":"Download","spec":[{"type":"text","text":"`Download` objects are dispatched by page via the [`event: Page.download`] event."},{"type":"text","text":"All the downloaded files belonging to the browser context are deleted when the↵browser context is closed."},{"type":"text","text":"Download event is emitted once the download starts. Download path becomes available once download completes."},{"type":"code","lines":["// Start waiting for download before clicking. Note no await.","const downloadPromise = page.waitForEvent('download');","await page.getByText('Download file').click();","const download = await downloadPromise;","","// Wait for the download process to complete and save the downloaded file somewhere.","await download.saveAs('/path/to/save/at/' + download.suggestedFilename());"],"codeLang":"js"},{"type":"code","lines":["// Wait for the download to start","Download download = page.waitForDownload(() -> {","    // Perform the action that initiates download","    page.getByText(\"Download file\").click();","});","","// Wait for the download process to complete and save the downloaded file somewhere","download.saveAs(Paths.get(\"/path/to/save/at/\", download.suggestedFilename()));"],"codeLang":"java"},{"type":"code","lines":["# Start waiting for the download","async with page.expect_download() as download_info:","    # Perform the action that initiates download","    await page.get_by_text(\"Download file\").click()","download = await download_info.value","","# Wait for the download process to complete and save the downloaded file somewhere","await download.save_as(\"/path/to/save/at/\" + download.suggested_filename)"],"codeLang":"python async"},{"type":"code","lines":["# Start waiting for the download","with page.expect_download() as download_info:","    # Perform the action that initiates download","    page.get_by_text(\"Download file\").click()","download = download_info.value","","# Wait for the download process to complete and save the downloaded file somewhere","download.save_as(\"/path/to/save/at/\" + download.suggested_filename)"],"codeLang":"python sync"},{"type":"code","lines":["// Start the task of waiting for the download before clicking","var waitForDownloadTask = page.WaitForDownloadAsync();","await page.GetByText(\"Download file\").ClickAsync();","var download = await waitForDownloadTask;","","// Wait for the download process to complete and save the downloaded file somewhere","await download.SaveAsAsync(\"/path/to/save/at/\" + download.SuggestedFilename);"],"codeLang":"csharp"}],"langs":{},"comment":"`Download` objects are dispatched by page via the [`event: Page.download`] event.\n\nAll the downloaded files belonging to the browser context are deleted when the browser context is closed.\n\nDownload event is emitted once the download starts. Download path becomes available once download completes.\n\n```js\n// Start waiting for download before clicking. Note no await.\nconst downloadPromise = page.waitForEvent('download');\nawait page.getByText('Download file').click();\nconst download = await downloadPromise;\n\n// Wait for the download process to complete and save the downloaded file somewhere.\nawait download.saveAs('/path/to/save/at/' + download.suggestedFilename());\n```\n\n```java\n// Wait for the download to start\nDownload download = page.waitForDownload(() -> {\n    // Perform the action that initiates download\n    page.getByText(\"Download file\").click();\n});\n\n// Wait for the download process to complete and save the downloaded file somewhere\ndownload.saveAs(Paths.get(\"/path/to/save/at/\", download.suggestedFilename()));\n```\n\n```py\n# Start waiting for the download\nasync with page.expect_download() as download_info:\n    # Perform the action that initiates download\n    await page.get_by_text(\"Download file\").click()\ndownload = await download_info.value\n\n# Wait for the download process to complete and save the downloaded file somewhere\nawait download.save_as(\"/path/to/save/at/\" + download.suggested_filename)\n```\n\n```py\n# Start waiting for the download\nwith page.expect_download() as download_info:\n    # Perform the action that initiates download\n    page.get_by_text(\"Download file\").click()\ndownload = download_info.value\n\n# Wait for the download process to complete and save the downloaded file somewhere\ndownload.save_as(\"/path/to/save/at/\" + download.suggested_filename)\n```\n\n```csharp\n// Start the task of waiting for the download before clicking\nvar waitForDownloadTask = page.WaitForDownloadAsync();\nawait page.GetByText(\"Download file\").ClickAsync();\nvar download = await waitForDownloadTask;\n\n// Wait for the download process to complete and save the downloaded file somewhere\nawait download.SaveAsAsync(\"/path/to/save/at/\" + download.SuggestedFilename);\n```\n","since":"v1.8","members":[{"kind":"method","langs":{},"since":"v1.13","name":"cancel","type":{"name":"void"},"spec":[{"type":"text","text":"Cancels a download. Will not fail if the download is already finished or canceled.↵Upon successful cancellations, `download.failure()` would resolve to `'canceled'`."}],"required":true,"comment":"Cancels a download. Will not fail if the download is already finished or canceled. Upon successful cancellations,\n`download.failure()` would resolve to `'canceled'`.","async":true,"alias":"cancel","overloadIndex":0,"args":[]},{"kind":"method","langs":{"only":["java","js","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"createReadStream","type":{"name":"Readable","expression":"[Readable]"},"spec":[{"type":"text","text":"Returns a readable stream for a successful download, or throws for a failed/canceled download."}],"required":true,"comment":"Returns a readable stream for a successful download, or throws for a failed/canceled download.","async":true,"alias":"createReadStream","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"delete","type":{"name":"void"},"spec":[{"type":"text","text":"Deletes the downloaded file. Will wait for the download to finish if necessary."}],"required":true,"comment":"Deletes the downloaded file. Will wait for the download to finish if necessary.","async":true,"alias":"delete","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"failure","type":{"name":"","union":[{"name":"null"},{"name":"string"}],"expression":"[null]|[string]"},"spec":[{"type":"text","text":"Returns download error if any. Will wait for the download to finish if necessary."}],"required":true,"comment":"Returns download error if any. Will wait for the download to finish if necessary.","async":true,"alias":"failure","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.12","name":"page","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Get the page that the download belongs to."}],"required":true,"comment":"Get the page that the download belongs to.","async":false,"alias":"page","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Returns path to the downloaded file for a successful download, or throws for a failed/canceled download. The method will wait for the download to finish if necessary. The method throws when connected remotely."},{"type":"text","text":"Note that the download's file name is a random GUID, use [`method: Download.suggestedFilename`]↵to get suggested file name."}],"required":true,"comment":"Returns path to the downloaded file for a successful download, or throws for a failed/canceled download. The method\nwill wait for the download to finish if necessary. The method throws when connected remotely.\n\nNote that the download's file name is a random GUID, use [`method: Download.suggestedFilename`] to get suggested\nfile name.","async":true,"alias":"path","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"saveAs","type":{"name":"void"},"spec":[{"type":"text","text":"Copy the download to a user-specified path. It is safe to call this method while the download↵is still in progress. Will wait for the download to finish if necessary."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await download.saveAs('/path/to/save/at/' + download.suggestedFilename());"],"codeLang":"js"},{"type":"code","lines":["download.saveAs(Paths.get(\"/path/to/save/at/\", download.suggestedFilename()));"],"codeLang":"java"},{"type":"code","lines":["await download.save_as(\"/path/to/save/at/\" + download.suggested_filename)"],"codeLang":"python async"},{"type":"code","lines":["download.save_as(\"/path/to/save/at/\" + download.suggested_filename)"],"codeLang":"python sync"},{"type":"code","lines":["await download.SaveAsAsync(\"/path/to/save/at/\" + download.SuggestedFilename);"],"codeLang":"csharp"}],"required":true,"comment":"Copy the download to a user-specified path. It is safe to call this method while the download is still in progress.\nWill wait for the download to finish if necessary.\n\n**Usage**\n\n```js\nawait download.saveAs('/path/to/save/at/' + download.suggestedFilename());\n```\n\n```java\ndownload.saveAs(Paths.get(\"/path/to/save/at/\", download.suggestedFilename()));\n```\n\n```py\nawait download.save_as(\"/path/to/save/at/\" + download.suggested_filename)\n```\n\n```py\ndownload.save_as(\"/path/to/save/at/\" + download.suggested_filename)\n```\n\n```csharp\nawait download.SaveAsAsync(\"/path/to/save/at/\" + download.SuggestedFilename);\n```\n","async":true,"alias":"saveAs","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path where the download should be copied."}],"required":true,"comment":"Path where the download should be copied.","async":false,"alias":"path","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"suggestedFilename","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns suggested filename for this download. It is typically computed by the browser from the↵[`Content-Disposition`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Disposition) response header↵or the `download` attribute. See the spec on [whatwg](https://html.spec.whatwg.org/#downloading-resources). Different↵browsers can use different logic for computing it."}],"required":true,"comment":"Returns suggested filename for this download. It is typically computed by the browser from the\n[`Content-Disposition`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Disposition) response\nheader or the `download` attribute. See the spec on [whatwg](https://html.spec.whatwg.org/#downloading-resources).\nDifferent browsers can use different logic for computing it.","async":false,"alias":"suggestedFilename","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"url","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns downloaded url."}],"required":true,"comment":"Returns downloaded url.","async":false,"alias":"url","overloadIndex":0,"args":[]}]},{"name":"Electron","spec":[{"type":"text","text":"Playwright has **experimental** support for Electron automation. You can access electron namespace via:"},{"type":"code","lines":["const { _electron } = require('playwright');"],"codeLang":"js"},{"type":"text","text":"An example of the Electron automation script would be:"},{"type":"code","lines":["const { _electron: electron } = require('playwright');","","(async () => {","  // Launch Electron app.","  const electronApp = await electron.launch({ args: ['main.js'] });","","  // Evaluation expression in the Electron context.","  const appPath = await electronApp.evaluate(async ({ app }) => {","    // This runs in the main Electron process, parameter here is always","    // the result of the require('electron') in the main app script.","    return app.getAppPath();","  });","  console.log(appPath);","","  // Get the first window that the app opens, wait if necessary.","  const window = await electronApp.firstWindow();","  // Print the title.","  console.log(await window.title());","  // Capture a screenshot.","  await window.screenshot({ path: 'intro.png' });","  // Direct Electron console to Node terminal.","  window.on('console', console.log);","  // Click button.","  await window.click('text=Click me');","  // Exit app.","  await electronApp.close();","})();"],"codeLang":"js"},{"type":"text","text":"**Supported Electron versions are:**"},{"type":"li","text":"v12.2.0+","liType":"bullet"},{"type":"li","text":"v13.4.0+","liType":"bullet"},{"type":"li","text":"v14+","liType":"bullet"},{"type":"text","text":"**Known issues:**"},{"type":"text","text":"If you are not able to launch Electron and it will end up in timeouts during launch, try the following:"},{"type":"li","text":"Ensure that `nodeCliInspect` ([FuseV1Options.EnableNodeCliInspectArguments](https://www.electronjs.org/docs/latest/tutorial/fuses#nodecliinspect)) fuse is **not** set to `false`.","liType":"bullet"}],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"comment":"Playwright has **experimental** support for Electron automation. You can access electron namespace via:\n\n```js\nconst { _electron } = require('playwright');\n```\n\nAn example of the Electron automation script would be:\n\n```js\nconst { _electron: electron } = require('playwright');\n\n(async () => {\n  // Launch Electron app.\n  const electronApp = await electron.launch({ args: ['main.js'] });\n\n  // Evaluation expression in the Electron context.\n  const appPath = await electronApp.evaluate(async ({ app }) => {\n    // This runs in the main Electron process, parameter here is always\n    // the result of the require('electron') in the main app script.\n    return app.getAppPath();\n  });\n  console.log(appPath);\n\n  // Get the first window that the app opens, wait if necessary.\n  const window = await electronApp.firstWindow();\n  // Print the title.\n  console.log(await window.title());\n  // Capture a screenshot.\n  await window.screenshot({ path: 'intro.png' });\n  // Direct Electron console to Node terminal.\n  window.on('console', console.log);\n  // Click button.\n  await window.click('text=Click me');\n  // Exit app.\n  await electronApp.close();\n})();\n```\n\n**Supported Electron versions are:**\n- v12.2.0+\n- v13.4.0+\n- v14+\n\n**Known issues:**\n\nIf you are not able to launch Electron and it will end up in timeouts during launch, try the following:\n- Ensure that `nodeCliInspect`\n  ([FuseV1Options.EnableNodeCliInspectArguments](https://www.electronjs.org/docs/latest/tutorial/fuses#nodecliinspect))\n  fuse is **not** set to `false`.","since":"v1.9","members":[{"kind":"method","langs":{},"since":"v1.9","name":"launch","type":{"name":"ElectronApplication","expression":"[ElectronApplication]"},"spec":[{"type":"text","text":"Launches electron application specified with the `executablePath`."}],"required":true,"comment":"Launches electron application specified with the `executablePath`.","async":true,"alias":"launch","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.12","name":"acceptDownloads","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted."}],"required":false,"comment":"Whether to automatically download all the attachments. Defaults to `true` where all the downloads are accepted.","async":false,"alias":"acceptDownloads","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"args","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"Additional arguments to pass to the application when launching. You typically pass the main↵script name here."}],"required":false,"comment":"Additional arguments to pass to the application when launching. You typically pass the main script name here.","async":false,"alias":"args","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"bypassCSP","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`."}],"required":false,"comment":"Toggles bypassing page's Content-Security-Policy. Defaults to `false`.","async":false,"alias":"bypassCSP","overloadIndex":0},{"kind":"property","langs":{"only":["js","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.12","name":"colorScheme","type":{"name":"","union":[{"name":"null"},{"name":"ColorScheme","union":[{"name":"\"light\""},{"name":"\"dark\""},{"name":"\"no-preference\""}]}],"expression":"null|[ColorScheme]<\"light\"|\"dark\"|\"no-preference\">"},"spec":[{"type":"text","text":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media feature, supported values are `'light'` and `'dark'`. See↵[`method: Page.emulateMedia`] for more details. Passing `null` resets emulation to system defaults. Defaults to `'light'`."}],"required":false,"comment":"Emulates [prefers-colors-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme)\nmedia feature, supported values are `'light'` and `'dark'`. See [`method: Page.emulateMedia`] for more details.\nPassing `null` resets emulation to system defaults. Defaults to `'light'`.","async":false,"alias":"colorScheme","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"cwd","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Current working directory to launch application from."}],"required":false,"comment":"Current working directory to launch application from.","async":false,"alias":"cwd","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"env","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"Specifies environment variables that will be visible to Electron. Defaults to `process.env`."}],"required":false,"comment":"Specifies environment variables that will be visible to Electron. Defaults to `process.env`.","async":false,"alias":"env","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"executablePath","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Launches given Electron application. If not specified, launches the default Electron↵executable installed in this package, located at `node_modules/.bin/electron`."}],"required":false,"comment":"Launches given Electron application. If not specified, launches the default Electron executable installed in this\npackage, located at `node_modules/.bin/electron`.","async":false,"alias":"executablePath","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"extraHTTPHeaders","type":{"name":"Object","templates":[{"name":"string"},{"name":"string"}],"expression":"[Object]<[string], [string]>"},"spec":[{"type":"text","text":"An object containing additional HTTP headers to be sent with every request. Defaults to none."}],"required":false,"comment":"An object containing additional HTTP headers to be sent with every request. Defaults to none.","async":false,"alias":"extraHTTPHeaders","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"geolocation","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.12","name":"latitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Latitude between -90 and 90."}],"required":true,"comment":"Latitude between -90 and 90.","async":false,"alias":"latitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"longitude","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Longitude between -180 and 180."}],"required":true,"comment":"Longitude between -180 and 180.","async":false,"alias":"longitude","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"accuracy","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Non-negative accuracy value. Defaults to `0`."}],"required":false,"comment":"Non-negative accuracy value. Defaults to `0`.","async":false,"alias":"accuracy","overloadIndex":0}],"expression":"[Object]"},"spec":[],"required":false,"comment":"","async":false,"alias":"geolocation","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"httpCredentials","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.12","name":"username","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"username","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"password","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"password","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"origin","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Restrain sending http credentials on specific origin (scheme://host:port)."}],"required":false,"comment":"Restrain sending http credentials on specific origin (scheme://host:port).","async":false,"alias":"origin","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"send","type":{"name":"HttpCredentialsSend","union":[{"name":"\"unauthorized\""},{"name":"\"always\""}],"expression":"[HttpCredentialsSend]<\"unauthorized\"|\"always\">"},"spec":[{"type":"text","text":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests sent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with the each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with `WWW-Authenticate` header is received. Defaults to `'unauthorized'`."}],"required":false,"comment":"This option only applies to the requests sent from corresponding `APIRequestContext` and does not affect requests\nsent from the browser. `'always'` - `Authorization` header with basic authentication credentials will be sent with\nthe each API request. `'unauthorized` - the credentials are only sent when 401 (Unauthorized) response with\n`WWW-Authenticate` header is received. Defaults to `'unauthorized'`.","async":false,"alias":"send","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication).↵If no origin is specified, the username and password are sent to any servers upon unauthorized responses."}],"required":false,"comment":"Credentials for [HTTP authentication](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication). If no\norigin is specified, the username and password are sent to any servers upon unauthorized responses.","async":false,"alias":"httpCredentials","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"ignoreHTTPSErrors","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`."}],"required":false,"comment":"Whether to ignore HTTPS errors when sending network requests. Defaults to `false`.","async":false,"alias":"ignoreHTTPSErrors","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"locale","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value, `Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default locale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone)."}],"required":false,"comment":"Specify user locale, for example `en-GB`, `de-DE`, etc. Locale will affect `navigator.language` value,\n`Accept-Language` request header value as well as number and date formatting rules. Defaults to the system default\nlocale. Learn more about emulation in our [emulation guide](../emulation.md#locale--timezone).","async":false,"alias":"locale","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"offline","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to emulate network being offline. Defaults to `false`. Learn more about [network emulation](../emulation.md#offline)."}],"required":false,"comment":"Whether to emulate network being offline. Defaults to `false`. Learn more about\n[network emulation](../emulation.md#offline).","async":false,"alias":"offline","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.12","name":"recordHar","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.12","name":"omitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to↵`false`. Deprecated, use `content` policy instead."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`. Deprecated, use\n`content` policy instead.","async":false,"alias":"omitContent","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"content","type":{"name":"HarContentPolicy","union":[{"name":"\"omit\""},{"name":"\"embed\""},{"name":"\"attach\""}],"expression":"[HarContentPolicy]<\"omit\"|\"embed\"|\"attach\">"},"spec":[{"type":"text","text":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If `attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is specified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output files and to `embed` for all other file extensions."}],"required":false,"comment":"Optional setting to control resource content management. If `omit` is specified, content is not persisted. If\n`attach` is specified, resources are persisted as separate files or entries in the ZIP archive. If `embed` is\nspecified, content is stored inline the HAR file as per HAR specification. Defaults to `attach` for `.zip` output\nfiles and to `embed` for all other file extensions.","async":false,"alias":"content","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by default."}],"required":true,"comment":"Path on the filesystem to write the HAR file to. If the file name ends with `.zip`, `content: 'attach'` is used by\ndefault.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"mode","type":{"name":"HarMode","union":[{"name":"\"full\""},{"name":"\"minimal\""}],"expression":"[HarMode]<\"full\"|\"minimal\">"},"spec":[{"type":"text","text":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page, cookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`."}],"required":false,"comment":"When set to `minimal`, only record information necessary for routing from HAR. This omits sizes, timing, page,\ncookies, security and other types of HAR information that are not used when replaying from HAR. Defaults to `full`.","async":false,"alias":"mode","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"urlFilter","type":{"name":"","union":[{"name":"string"},{"name":"RegExp"}],"expression":"[string]|[RegExp]"},"spec":[{"type":"text","text":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was provided and the passed URL is a path, it gets merged via the [`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none."}],"required":false,"comment":"A glob or regex pattern to filter requests that are stored in the HAR. When a `baseURL` via the context options was\nprovided and the passed URL is a path, it gets merged via the\n[`new URL()`](https://developer.mozilla.org/en-US/docs/Web/API/URL/URL) constructor. Defaults to none.","async":false,"alias":"urlFilter","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file. If not↵specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be↵saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into `recordHar.path` file.\nIf not specified, the HAR is not recorded. Make sure to await [`method: BrowserContext.close`] for the HAR to be\nsaved.","async":false,"alias":"recordHar","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_omit_content"},"types":{},"overrides":{}},"since":"v1.12","name":"recordHarOmitContent","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`."}],"required":false,"comment":"Optional setting to control whether to omit request content from the HAR. Defaults to `false`.","async":false,"alias":"recordHarOmitContent","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_har_path"},"types":{},"overrides":{}},"since":"v1.12","name":"recordHarPath","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the↵specified HAR file on the filesystem. If not specified, the HAR is not recorded. Make sure to↵call [`method: BrowserContext.close`] for the HAR to be saved."}],"required":false,"comment":"Enables [HAR](http://www.softwareishard.com/blog/har-12-spec) recording for all pages into the specified HAR file\non the filesystem. If not specified, the HAR is not recorded. Make sure to call [`method: BrowserContext.close`]\nfor the HAR to be saved.","async":false,"alias":"recordHarPath","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.12","name":"recordVideo","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.12","name":"dir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Path to the directory to put videos into."}],"required":true,"comment":"Path to the directory to put videos into.","async":false,"alias":"dir","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"size","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.12","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Optional dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to\nfit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of\neach page will be scaled down if necessary to fit the specified size.","async":false,"alias":"size","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded. Make↵sure to await [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into `recordVideo.dir` directory. If not specified videos are not recorded.\nMake sure to await [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideo","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_dir"},"types":{},"overrides":{}},"since":"v1.12","name":"recordVideoDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"Enables video recording for all pages into the specified directory. If not specified videos are↵not recorded. Make sure to call [`method: BrowserContext.close`] for videos to be saved."}],"required":false,"comment":"Enables video recording for all pages into the specified directory. If not specified videos are not recorded. Make\nsure to call [`method: BrowserContext.close`] for videos to be saved.","async":false,"alias":"recordVideoDir","overloadIndex":0},{"kind":"property","langs":{"only":["csharp","java","python"],"aliases":{"python":"record_video_size"},"types":{},"overrides":{}},"since":"v1.12","name":"recordVideoSize","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.12","name":"width","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame width."}],"required":true,"comment":"Video frame width.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"height","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Video frame height."}],"required":true,"comment":"Video frame height.","async":false,"alias":"height","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport`↵scaled down to fit into 800x800. If `viewport` is not configured explicitly the video size defaults to 800x450.↵Actual picture of each page will be scaled down if necessary to fit the specified size."}],"required":false,"comment":"Dimensions of the recorded videos. If not specified the size will be equal to `viewport` scaled down to fit into\n800x800. If `viewport` is not configured explicitly the video size defaults to 800x450. Actual picture of each page\nwill be scaled down if necessary to fit the specified size.","async":false,"alias":"recordVideoSize","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds to wait for the application to start. Defaults to `30000` (30 seconds). Pass `0` to disable timeout."}],"required":false,"comment":"Maximum time in milliseconds to wait for the application to start. Defaults to `30000` (30 seconds). Pass `0` to\ndisable timeout.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.12","name":"timezoneId","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Changes the timezone of the context. See [ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)↵for a list of supported timezone IDs. Defaults to the system timezone."}],"required":false,"comment":"Changes the timezone of the context. See\n[ICU's metaZones.txt](https://cs.chromium.org/chromium/src/third_party/icu/source/data/misc/metaZones.txt?rcl=faee8bc70570192d82d2978a71e2a615788597d1)\nfor a list of supported timezone IDs. Defaults to the system timezone.","async":false,"alias":"timezoneId","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.36","name":"tracesDir","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"If specified, traces are saved into this directory."}],"required":false,"comment":"If specified, traces are saved into this directory.","async":false,"alias":"tracesDir","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]}]},{"name":"ElectronApplication","spec":[{"type":"text","text":"Electron application representation. You can use [`method: Electron.launch`] to↵obtain the application instance. This instance you can control main electron process↵as well as work with Electron windows:"},{"type":"code","lines":["const { _electron: electron } = require('playwright');","","(async () => {","  // Launch Electron app.","  const electronApp = await electron.launch({ args: ['main.js'] });","","  // Evaluation expression in the Electron context.","  const appPath = await electronApp.evaluate(async ({ app }) => {","    // This runs in the main Electron process, parameter here is always","    // the result of the require('electron') in the main app script.","    return app.getAppPath();","  });","  console.log(appPath);","","  // Get the first window that the app opens, wait if necessary.","  const window = await electronApp.firstWindow();","  // Print the title.","  console.log(await window.title());","  // Capture a screenshot.","  await window.screenshot({ path: 'intro.png' });","  // Direct Electron console to Node terminal.","  window.on('console', console.log);","  // Click button.","  await window.click('text=Click me');","  // Exit app.","  await electronApp.close();","})();"],"codeLang":"js"}],"langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"comment":"Electron application representation. You can use [`method: Electron.launch`] to obtain the application instance.\nThis instance you can control main electron process as well as work with Electron windows:\n\n```js\nconst { _electron: electron } = require('playwright');\n\n(async () => {\n  // Launch Electron app.\n  const electronApp = await electron.launch({ args: ['main.js'] });\n\n  // Evaluation expression in the Electron context.\n  const appPath = await electronApp.evaluate(async ({ app }) => {\n    // This runs in the main Electron process, parameter here is always\n    // the result of the require('electron') in the main app script.\n    return app.getAppPath();\n  });\n  console.log(appPath);\n\n  // Get the first window that the app opens, wait if necessary.\n  const window = await electronApp.firstWindow();\n  // Print the title.\n  console.log(await window.title());\n  // Capture a screenshot.\n  await window.screenshot({ path: 'intro.png' });\n  // Direct Electron console to Node terminal.\n  window.on('console', console.log);\n  // Click button.\n  await window.click('text=Click me');\n  // Exit app.\n  await electronApp.close();\n})();\n```\n","since":"v1.9","members":[{"kind":"event","langs":{},"since":"v1.9","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"This event is issued when the application process has been terminated."}],"required":true,"comment":"This event is issued when the application process has been terminated.","async":false,"alias":"close","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.42","name":"console","type":{"name":"ConsoleMessage","expression":"[ConsoleMessage]"},"spec":[{"type":"text","text":"Emitted when JavaScript within the Electron main process calls one of console API methods, e.g. `console.log` or `console.dir`."},{"type":"text","text":"The arguments passed into `console.log` are available on the `ConsoleMessage` event handler argument."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["electronApp.on('console', async msg => {","  const values = [];","  for (const arg of msg.args())","    values.push(await arg.jsonValue());","  console.log(...values);","});","await electronApp.evaluate(() => console.log('hello', 5, { foo: 'bar' }));"],"codeLang":"js"}],"required":true,"comment":"Emitted when JavaScript within the Electron main process calls one of console API methods, e.g. `console.log` or\n`console.dir`.\n\nThe arguments passed into `console.log` are available on the `ConsoleMessage` event handler argument.\n\n**Usage**\n\n```js\nelectronApp.on('console', async msg => {\n  const values = [];\n  for (const arg of msg.args())\n    values.push(await arg.jsonValue());\n  console.log(...values);\n});\nawait electronApp.evaluate(() => console.log('hello', 5, { foo: 'bar' }));\n```\n","async":false,"alias":"console","overloadIndex":0,"args":[]},{"kind":"event","langs":{},"since":"v1.9","name":"window","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"This event is issued for every window that is created **and loaded** in Electron. It contains a `Page` that can↵be used for Playwright automation."}],"required":true,"comment":"This event is issued for every window that is created **and loaded** in Electron. It contains a `Page` that can be\nused for Playwright automation.","async":false,"alias":"window","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.11","name":"browserWindow","type":{"name":"JSHandle","expression":"[JSHandle]"},"spec":[{"type":"text","text":"Returns the BrowserWindow object that corresponds to the given Playwright page."}],"required":true,"comment":"Returns the BrowserWindow object that corresponds to the given Playwright page.","async":true,"alias":"browserWindow","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.11","name":"page","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Page to retrieve the window for."}],"required":true,"comment":"Page to retrieve the window for.","async":false,"alias":"page","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"close","type":{"name":"void"},"spec":[{"type":"text","text":"Closes Electron application."}],"required":true,"comment":"Closes Electron application.","async":true,"alias":"close","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"context","type":{"name":"BrowserContext","expression":"[BrowserContext]"},"spec":[{"type":"text","text":"This method returns browser context that can be used for setting up context-wide routing, etc."}],"required":true,"comment":"This method returns browser context that can be used for setting up context-wide routing, etc.","async":false,"alias":"context","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"evaluate","type":{"name":"Serializable","expression":"[Serializable]"},"spec":[{"type":"text","text":"Returns the return value of `expression`."},{"type":"text","text":"If the function passed to the [`method: ElectronApplication.evaluate`] returns a [Promise], then↵[`method: ElectronApplication.evaluate`] would wait for the promise to resolve and return its value."},{"type":"text","text":"If the function passed to the [`method: ElectronApplication.evaluate`] returns a non-[Serializable] value, then↵[`method: ElectronApplication.evaluate`] returns `undefined`. Playwright also supports transferring↵some additional values that are not serializable by `JSON`: `-0`, `NaN`, `Infinity`, `-Infinity`."}],"required":true,"comment":"Returns the return value of `expression`.\n\nIf the function passed to the [`method: ElectronApplication.evaluate`] returns a [Promise], then\n[`method: ElectronApplication.evaluate`] would wait for the promise to resolve and return its value.\n\nIf the function passed to the [`method: ElectronApplication.evaluate`] returns a non-[Serializable] value, then\n[`method: ElectronApplication.evaluate`] returns `undefined`. Playwright also supports transferring some additional\nvalues that are not serializable by `JSON`: `-0`, `NaN`, `Infinity`, `-Infinity`.","async":true,"alias":"evaluate","overloadIndex":0,"args":[{"kind":"property","langs":{"overrides":{"js":{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"expression","type":{"name":"","union":[{"name":"function"},{"name":"Electron"}],"expression":"[function]|[Electron]"},"spec":[{"type":"text","text":"Function to be evaluated in the main Electron process."}],"argsArray":[],"required":true,"comment":"Function to be evaluated in the main Electron process.","args":{},"clazz":null,"async":false,"alias":"pageFunction","overloadIndex":0}}},"since":"v1.9","name":"expression","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"JavaScript expression to be evaluated in the browser context. If the expression evaluates↵to a function, the function is automatically invoked."}],"required":true,"comment":"JavaScript expression to be evaluated in the browser context. If the expression evaluates to a function, the\nfunction is automatically invoked.","async":false,"alias":"expression","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"arg","type":{"name":"EvaluationArgument","expression":"[EvaluationArgument]"},"spec":[{"type":"text","text":"Optional argument to pass to `expression`."}],"required":false,"comment":"Optional argument to pass to `expression`.","async":false,"alias":"arg","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"evaluateHandle","type":{"name":"JSHandle","expression":"[JSHandle]"},"spec":[{"type":"text","text":"Returns the return value of `expression` as a `JSHandle`."},{"type":"text","text":"The only difference between [`method: ElectronApplication.evaluate`] and [`method: ElectronApplication.evaluateHandle`] is that [`method: ElectronApplication.evaluateHandle`] returns `JSHandle`."},{"type":"text","text":"If the function passed to the [`method: ElectronApplication.evaluateHandle`] returns a [Promise], then↵[`method: ElectronApplication.evaluateHandle`] would wait for the promise to resolve and return its value."}],"required":true,"comment":"Returns the return value of `expression` as a `JSHandle`.\n\nThe only difference between [`method: ElectronApplication.evaluate`] and\n[`method: ElectronApplication.evaluateHandle`] is that [`method: ElectronApplication.evaluateHandle`] returns\n`JSHandle`.\n\nIf the function passed to the [`method: ElectronApplication.evaluateHandle`] returns a [Promise], then\n[`method: ElectronApplication.evaluateHandle`] would wait for the promise to resolve and return its value.","async":true,"alias":"evaluateHandle","overloadIndex":0,"args":[{"kind":"property","langs":{"overrides":{"js":{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"expression","type":{"name":"","union":[{"name":"function"},{"name":"Electron"}],"expression":"[function]|[Electron]"},"spec":[{"type":"text","text":"Function to be evaluated in the main Electron process."}],"argsArray":[],"required":true,"comment":"Function to be evaluated in the main Electron process.","args":{},"clazz":null,"async":false,"alias":"pageFunction","overloadIndex":0}}},"since":"v1.9","name":"expression","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"JavaScript expression to be evaluated in the browser context. If the expression evaluates↵to a function, the function is automatically invoked."}],"required":true,"comment":"JavaScript expression to be evaluated in the browser context. If the expression evaluates to a function, the\nfunction is automatically invoked.","async":false,"alias":"expression","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"arg","type":{"name":"EvaluationArgument","expression":"[EvaluationArgument]"},"spec":[{"type":"text","text":"Optional argument to pass to `expression`."}],"required":false,"comment":"Optional argument to pass to `expression`.","async":false,"alias":"arg","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"firstWindow","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Convenience method that waits for the first application window to be opened."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const electronApp = await electron.launch({","  args: ['main.js']","});","const window = await electronApp.firstWindow();","// ..."],"codeLang":"js"}],"required":true,"comment":"Convenience method that waits for the first application window to be opened.\n\n**Usage**\n\n```js\nconst electronApp = await electron.launch({\n  args: ['main.js']\n});\nconst window = await electronApp.firstWindow();\n// ...\n```\n","async":true,"alias":"firstWindow","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.33","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds).↵Pass `0` to disable timeout. The default value can be changed by using the↵[`method: BrowserContext.setDefaultTimeout`]."}],"required":false,"comment":"Maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: BrowserContext.setDefaultTimeout`].","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.21","name":"process","type":{"name":"ChildProcess","expression":"[ChildProcess]"},"spec":[{"type":"text","text":"Returns the main process for this Electron Application."}],"required":true,"comment":"Returns the main process for this Electron Application.","async":false,"alias":"process","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.9","name":"waitForEvent","type":{"name":"any","expression":"[any]"},"spec":[{"type":"text","text":"Waits for event to fire and passes its value into the predicate function. Returns when the predicate returns truthy value. Will throw an error if the application is closed before the event is fired. Returns the event data value."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const windowPromise = electronApp.waitForEvent('window');","await mainWindow.click('button');","const window = await windowPromise;"],"codeLang":"js"}],"required":true,"comment":"Waits for event to fire and passes its value into the predicate function. Returns when the predicate returns truthy\nvalue. Will throw an error if the application is closed before the event is fired. Returns the event data value.\n\n**Usage**\n\n```js\nconst windowPromise = electronApp.waitForEvent('window');\nawait mainWindow.click('button');\nconst window = await windowPromise;\n```\n","async":true,"alias":"waitForEvent","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["js","python","java"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"event","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Event name, same one typically passed into `*.on(event)`."}],"required":true,"comment":"Event name, same one typically passed into `*.on(event)`.","async":false,"alias":"event","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"optionsOrPredicate","type":{"name":"","union":[{"name":"function"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.9","name":"predicate","type":{"name":"function","expression":"[function]"},"spec":[{"type":"text","text":"receives the event data and resolves to truthy value when the waiting should resolve."}],"required":true,"comment":"receives the event data and resolves to truthy value when the waiting should resolve.","async":false,"alias":"predicate","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to↵disable timeout. The default value can be changed by using the [`method: BrowserContext.setDefaultTimeout`]."}],"required":false,"comment":"maximum time to wait for in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The\ndefault value can be changed by using the [`method: BrowserContext.setDefaultTimeout`].","async":false,"alias":"timeout","overloadIndex":0}]}],"expression":"[function]|[Object]"},"spec":[{"type":"text","text":"Either a predicate that receives an event or an options object. Optional."}],"required":false,"comment":"Either a predicate that receives an event or an options object. Optional.","async":false,"alias":"optionsOrPredicate","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.9","name":"windows","type":{"name":"Array","templates":[{"name":"Page"}],"expression":"[Array]<[Page]>"},"spec":[{"type":"text","text":"Convenience method that returns all the opened windows."}],"required":true,"comment":"Convenience method that returns all the opened windows.","async":false,"alias":"windows","overloadIndex":0,"args":[]}]},{"name":"ElementHandle","spec":[{"type":"li","text":"extends: `JSHandle`","liType":"bullet"},{"type":"text","text":"ElementHandle represents an in-page DOM element. ElementHandles can be created with the [`method: Page.querySelector`] method."},{"type":"note","noteType":"warning[Discouraged]","children":[{"type":"text","text":"The use of ElementHandle is discouraged, use `Locator` objects and web-first assertions instead."}]},{"type":"code","lines":["const hrefElement = await page.$('a');","await hrefElement.click();"],"codeLang":"js"},{"type":"code","lines":["ElementHandle hrefElement = page.querySelector(\"a\");","hrefElement.click();"],"codeLang":"java"},{"type":"code","lines":["href_element = await page.query_selector(\"a\")","await href_element.click()"],"codeLang":"python async"},{"type":"code","lines":["href_element = page.query_selector(\"a\")","href_element.click()"],"codeLang":"python sync"},{"type":"code","lines":["var handle = await page.QuerySelectorAsync(\"a\");","await handle.ClickAsync();"],"codeLang":"csharp"},{"type":"text","text":"ElementHandle prevents DOM element from garbage collection unless the handle is disposed with↵[`method: JSHandle.dispose`]. ElementHandles are auto-disposed when their origin frame gets navigated."},{"type":"text","text":"ElementHandle instances can be used as an argument in [`method: Page.evalOnSelector`] and [`method: Page.evaluate`] methods."},{"type":"text","text":"The difference between the `Locator` and ElementHandle is that the ElementHandle points to a particular element, while `Locator` captures the logic of how to retrieve an element."},{"type":"text","text":"In the example below, handle points to a particular DOM element on page. If that element changes text or is used by React to render an entirely different component, handle is still pointing to that very DOM element. This can lead to unexpected behaviors."},{"type":"code","lines":["const handle = await page.$('text=Submit');","// ...","await handle.hover();","await handle.click();"],"codeLang":"js"},{"type":"code","lines":["ElementHandle handle = page.querySelector(\"text=Submit\");","handle.hover();","handle.click();"],"codeLang":"java"},{"type":"code","lines":["handle = await page.query_selector(\"text=Submit\")","await handle.hover()","await handle.click()"],"codeLang":"python async"},{"type":"code","lines":["handle = page.query_selector(\"text=Submit\")","handle.hover()","handle.click()"],"codeLang":"python sync"},{"type":"code","lines":["var handle = await page.QuerySelectorAsync(\"text=Submit\");","await handle.HoverAsync();","await handle.ClickAsync();"],"codeLang":"csharp"},{"type":"text","text":"With the locator, every time the `element` is used, up-to-date DOM element is located in the page using the selector. So in the snippet below, underlying DOM element is going to be located twice."},{"type":"code","lines":["const locator = page.getByText('Submit');","// ...","await locator.hover();","await locator.click();"],"codeLang":"js"},{"type":"code","lines":["Locator locator = page.getByText(\"Submit\");","locator.hover();","locator.click();"],"codeLang":"java"},{"type":"code","lines":["locator = page.get_by_text(\"Submit\")","await locator.hover()","await locator.click()"],"codeLang":"python async"},{"type":"code","lines":["locator = page.get_by_text(\"Submit\")","locator.hover()","locator.click()"],"codeLang":"python sync"},{"type":"code","lines":["var locator = page.GetByText(\"Submit\");","await locator.HoverAsync();","await locator.ClickAsync();"],"codeLang":"csharp"}],"extends":"JSHandle","langs":{},"comment":"- extends: `JSHandle`\n\nElementHandle represents an in-page DOM element. ElementHandles can be created with the\n[`method: Page.querySelector`] method.\n\n**NOTE** The use of ElementHandle is discouraged, use `Locator` objects and web-first assertions instead.\n\n```js\nconst hrefElement = await page.$('a');\nawait hrefElement.click();\n```\n\n```java\nElementHandle hrefElement = page.querySelector(\"a\");\nhrefElement.click();\n```\n\n```py\nhref_element = await page.query_selector(\"a\")\nawait href_element.click()\n```\n\n```py\nhref_element = page.query_selector(\"a\")\nhref_element.click()\n```\n\n```csharp\nvar handle = await page.QuerySelectorAsync(\"a\");\nawait handle.ClickAsync();\n```\n\nElementHandle prevents DOM element from garbage collection unless the handle is disposed with\n[`method: JSHandle.dispose`]. ElementHandles are auto-disposed when their origin frame gets navigated.\n\nElementHandle instances can be used as an argument in [`method: Page.evalOnSelector`] and [`method: Page.evaluate`]\nmethods.\n\nThe difference between the `Locator` and ElementHandle is that the ElementHandle points to a particular element,\nwhile `Locator` captures the logic of how to retrieve an element.\n\nIn the example below, handle points to a particular DOM element on page. If that element changes text or is used by\nReact to render an entirely different component, handle is still pointing to that very DOM element. This can lead\nto unexpected behaviors.\n\n```js\nconst handle = await page.$('text=Submit');\n// ...\nawait handle.hover();\nawait handle.click();\n```\n\n```java\nElementHandle handle = page.querySelector(\"text=Submit\");\nhandle.hover();\nhandle.click();\n```\n\n```py\nhandle = await page.query_selector(\"text=Submit\")\nawait handle.hover()\nawait handle.click()\n```\n\n```py\nhandle = page.query_selector(\"text=Submit\")\nhandle.hover()\nhandle.click()\n```\n\n```csharp\nvar handle = await page.QuerySelectorAsync(\"text=Submit\");\nawait handle.HoverAsync();\nawait handle.ClickAsync();\n```\n\nWith the locator, every time the `element` is used, up-to-date DOM element is located in the page using the\nselector. So in the snippet below, underlying DOM element is going to be located twice.\n\n```js\nconst locator = page.getByText('Submit');\n// ...\nawait locator.hover();\nawait locator.click();\n```\n\n```java\nLocator locator = page.getByText(\"Submit\");\nlocator.hover();\nlocator.click();\n```\n\n```py\nlocator = page.get_by_text(\"Submit\")\nawait locator.hover()\nawait locator.click()\n```\n\n```py\nlocator = page.get_by_text(\"Submit\")\nlocator.hover()\nlocator.click()\n```\n\n```csharp\nvar locator = page.GetByText(\"Submit\");\nawait locator.HoverAsync();\nawait locator.ClickAsync();\n```\n","since":"v1.8","members":[{"kind":"method","langs":{},"since":"v1.8","name":"boundingBox","type":{"name":"","union":[{"name":"null"},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"the x coordinate of the element in pixels."}],"required":true,"comment":"the x coordinate of the element in pixels.","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"the y coordinate of the element in pixels."}],"required":true,"comment":"the y coordinate of the element in pixels.","async":false,"alias":"y","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"width","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"the width of the element in pixels."}],"required":true,"comment":"the width of the element in pixels.","async":false,"alias":"width","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"height","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"the height of the element in pixels."}],"required":true,"comment":"the height of the element in pixels.","async":false,"alias":"height","overloadIndex":0}]}],"expression":"[null]|[Object]"},"spec":[{"type":"text","text":"This method returns the bounding box of the element, or `null` if the element is not visible. The bounding box is↵calculated relative to the main frame viewport - which is usually the same as the browser window."},{"type":"text","text":"Scrolling affects the returned bounding box, similarly to↵[Element.getBoundingClientRect](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect). That↵means `x` and/or `y` may be negative."},{"type":"text","text":"Elements from child frames return the bounding box relative to the main frame, unlike the↵[Element.getBoundingClientRect](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect)."},{"type":"text","text":"Assuming the page is static, it is safe to use bounding box coordinates to perform input. For example, the following↵snippet should click the center of the element."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const box = await elementHandle.boundingBox();","await page.mouse.click(box.x + box.width / 2, box.y + box.height / 2);"],"codeLang":"js"},{"type":"code","lines":["BoundingBox box = elementHandle.boundingBox();","page.mouse().click(box.x + box.width / 2, box.y + box.height / 2);"],"codeLang":"java"},{"type":"code","lines":["box = await element_handle.bounding_box()","await page.mouse.click(box[\"x\"] + box[\"width\"] / 2, box[\"y\"] + box[\"height\"] / 2)"],"codeLang":"python async"},{"type":"code","lines":["box = element_handle.bounding_box()","page.mouse.click(box[\"x\"] + box[\"width\"] / 2, box[\"y\"] + box[\"height\"] / 2)"],"codeLang":"python sync"},{"type":"code","lines":["var box = await elementHandle.BoundingBoxAsync();","await page.Mouse.ClickAsync(box.X + box.Width / 2, box.Y + box.Height / 2);"],"codeLang":"csharp"}],"required":true,"comment":"This method returns the bounding box of the element, or `null` if the element is not visible. The bounding box is\ncalculated relative to the main frame viewport - which is usually the same as the browser window.\n\nScrolling affects the returned bounding box, similarly to\n[Element.getBoundingClientRect](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect).\nThat means `x` and/or `y` may be negative.\n\nElements from child frames return the bounding box relative to the main frame, unlike the\n[Element.getBoundingClientRect](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect).\n\nAssuming the page is static, it is safe to use bounding box coordinates to perform input. For example, the\nfollowing snippet should click the center of the element.\n\n**Usage**\n\n```js\nconst box = await elementHandle.boundingBox();\nawait page.mouse.click(box.x + box.width / 2, box.y + box.height / 2);\n```\n\n```java\nBoundingBox box = elementHandle.boundingBox();\npage.mouse().click(box.x + box.width / 2, box.y + box.height / 2);\n```\n\n```py\nbox = await element_handle.bounding_box()\nawait page.mouse.click(box[\"x\"] + box[\"width\"] / 2, box[\"y\"] + box[\"height\"] / 2)\n```\n\n```py\nbox = element_handle.bounding_box()\npage.mouse.click(box[\"x\"] + box[\"width\"] / 2, box[\"y\"] + box[\"height\"] / 2)\n```\n\n```csharp\nvar box = await elementHandle.BoundingBoxAsync();\nawait page.Mouse.ClickAsync(box.X + box.Width / 2, box.Y + box.Height / 2);\n```\n","async":true,"alias":"boundingBox","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.check`] instead. Read more about [locators](../locators.md).","name":"check","type":{"name":"void"},"spec":[{"type":"text","text":"This method checks the element by performing the following steps:"},{"type":"li","text":"Ensure that element is a checkbox or a radio input. If not, this method throws. If the element is already↵checked, this method returns immediately.","liType":"ordinal"},{"type":"li","text":"Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.","liType":"ordinal"},{"type":"li","text":"Scroll the element into view if needed.","liType":"ordinal"},{"type":"li","text":"Use [`property: Page.mouse`] to click in the center of the element.","liType":"ordinal"},{"type":"li","text":"Ensure that the element is now checked. If not, this method throws.","liType":"ordinal"},{"type":"text","text":"If the element is detached from the DOM at any moment during the action, this method throws."},{"type":"text","text":"When all steps combined have not finished during the specified `timeout`, this method throws a↵`TimeoutError`. Passing zero timeout disables this."}],"required":true,"comment":"This method checks the element by performing the following steps:\n1. Ensure that element is a checkbox or a radio input. If not, this method throws. If the element is already\n   checked, this method returns immediately.\n1. Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.\n1. Scroll the element into view if needed.\n1. Use [`property: Page.mouse`] to click in the center of the element.\n1. Ensure that the element is now checked. If not, this method throws.\n\nIf the element is detached from the DOM at any moment during the action, this method throws.\n\nWhen all steps combined have not finished during the specified `timeout`, this method throws a `TimeoutError`.\nPassing zero timeout disables this.","async":true,"alias":"check","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"position","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of the↵element."}],"required":false,"comment":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of\nthe element.","async":false,"alias":"position","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"trial","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults to `false`. Useful to wait until the element is ready for the action without performing it."}],"required":false,"comment":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults\nto `false`. Useful to wait until the element is ready for the action without performing it.","async":false,"alias":"trial","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.click`] instead. Read more about [locators](../locators.md).","name":"click","type":{"name":"void"},"spec":[{"type":"text","text":"This method clicks the element by performing the following steps:"},{"type":"li","text":"Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.","liType":"ordinal"},{"type":"li","text":"Scroll the element into view if needed.","liType":"ordinal"},{"type":"li","text":"Use [`property: Page.mouse`] to click in the center of the element, or the specified `position`.","liType":"ordinal"},{"type":"li","text":"Wait for initiated navigations to either succeed or fail, unless `noWaitAfter` option is set.","liType":"ordinal"},{"type":"text","text":"If the element is detached from the DOM at any moment during the action, this method throws."},{"type":"text","text":"When all steps combined have not finished during the specified `timeout`, this method throws a↵`TimeoutError`. Passing zero timeout disables this."}],"required":true,"comment":"This method clicks the element by performing the following steps:\n1. Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.\n1. Scroll the element into view if needed.\n1. Use [`property: Page.mouse`] to click in the center of the element, or the specified `position`.\n1. Wait for initiated navigations to either succeed or fail, unless `noWaitAfter` option is set.\n\nIf the element is detached from the DOM at any moment during the action, this method throws.\n\nWhen all steps combined have not finished during the specified `timeout`, this method throws a `TimeoutError`.\nPassing zero timeout disables this.","async":true,"alias":"click","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"button","type":{"name":"MouseButton","union":[{"name":"\"left\""},{"name":"\"right\""},{"name":"\"middle\""}],"expression":"[MouseButton]<\"left\"|\"right\"|\"middle\">"},"spec":[{"type":"text","text":"Defaults to `left`."}],"required":false,"comment":"Defaults to `left`.","async":false,"alias":"button","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"clickCount","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"defaults to 1. See [UIEvent.detail]."}],"required":false,"comment":"defaults to 1. See [UIEvent.detail].","async":false,"alias":"clickCount","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"delay","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Time to wait between `mousedown` and `mouseup` in milliseconds. Defaults to 0."}],"required":false,"comment":"Time to wait between `mousedown` and `mouseup` in milliseconds. Defaults to 0.","async":false,"alias":"delay","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"modifiers","type":{"name":"Array","templates":[{"name":"KeyboardModifier","union":[{"name":"\"Alt\""},{"name":"\"Control\""},{"name":"\"ControlOrMeta\""},{"name":"\"Meta\""},{"name":"\"Shift\""}]}],"expression":"[Array]<[KeyboardModifier]<\"Alt\"|\"Control\"|\"ControlOrMeta\"|\"Meta\"|\"Shift\">>"},"spec":[{"type":"text","text":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores current↵modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to \"Control\" on Windows↵and Linux and to \"Meta\" on macOS."}],"required":false,"comment":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores\ncurrent modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to\n\"Control\" on Windows and Linux and to \"Meta\" on macOS.","async":false,"alias":"modifiers","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option will default to `true` in the future.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Actions that initiate navigations are waiting for these navigations to happen and for pages to start loading. You can↵opt out of waiting via setting this flag. You would only need this option in the exceptional cases such as navigating↵to inaccessible pages. Defaults to `false`."}],"required":false,"comment":"Actions that initiate navigations are waiting for these navigations to happen and for pages to start loading. You\ncan opt out of waiting via setting this flag. You would only need this option in the exceptional cases such as\nnavigating to inaccessible pages. Defaults to `false`.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"position","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of the↵element."}],"required":false,"comment":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of\nthe element.","async":false,"alias":"position","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"trial","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults to `false`. Useful to wait until the element is ready for the action without performing it."}],"required":false,"comment":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults\nto `false`. Useful to wait until the element is ready for the action without performing it.","async":false,"alias":"trial","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"contentFrame","type":{"name":"","union":[{"name":"null"},{"name":"Frame"}],"expression":"[null]|[Frame]"},"spec":[{"type":"text","text":"Returns the content frame for element handles referencing iframe nodes, or `null` otherwise"}],"required":true,"comment":"Returns the content frame for element handles referencing iframe nodes, or `null` otherwise","async":true,"alias":"contentFrame","overloadIndex":0,"args":[]},{"kind":"method","langs":{"aliases":{"csharp":"DblClickAsync"},"types":{},"overrides":{}},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.dblclick`] instead. Read more about [locators](../locators.md).","name":"dblclick","type":{"name":"void"},"spec":[{"type":"text","text":"This method double clicks the element by performing the following steps:"},{"type":"li","text":"Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.","liType":"ordinal"},{"type":"li","text":"Scroll the element into view if needed.","liType":"ordinal"},{"type":"li","text":"Use [`property: Page.mouse`] to double click in the center of the element, or the specified `position`.","liType":"ordinal"},{"type":"text","text":"If the element is detached from the DOM at any moment during the action, this method throws."},{"type":"text","text":"When all steps combined have not finished during the specified `timeout`, this method throws a↵`TimeoutError`. Passing zero timeout disables this."},{"type":"note","noteType":"note","children":[{"type":"text","text":"`elementHandle.dblclick()` dispatches two `click` events and a single `dblclick` event."}]}],"required":true,"comment":"This method double clicks the element by performing the following steps:\n1. Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.\n1. Scroll the element into view if needed.\n1. Use [`property: Page.mouse`] to double click in the center of the element, or the specified `position`.\n\nIf the element is detached from the DOM at any moment during the action, this method throws.\n\nWhen all steps combined have not finished during the specified `timeout`, this method throws a `TimeoutError`.\nPassing zero timeout disables this.\n\n**NOTE** `elementHandle.dblclick()` dispatches two `click` events and a single `dblclick` event.\n","async":true,"alias":"dblclick","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"button","type":{"name":"MouseButton","union":[{"name":"\"left\""},{"name":"\"right\""},{"name":"\"middle\""}],"expression":"[MouseButton]<\"left\"|\"right\"|\"middle\">"},"spec":[{"type":"text","text":"Defaults to `left`."}],"required":false,"comment":"Defaults to `left`.","async":false,"alias":"button","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"delay","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Time to wait between `mousedown` and `mouseup` in milliseconds. Defaults to 0."}],"required":false,"comment":"Time to wait between `mousedown` and `mouseup` in milliseconds. Defaults to 0.","async":false,"alias":"delay","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"modifiers","type":{"name":"Array","templates":[{"name":"KeyboardModifier","union":[{"name":"\"Alt\""},{"name":"\"Control\""},{"name":"\"ControlOrMeta\""},{"name":"\"Meta\""},{"name":"\"Shift\""}]}],"expression":"[Array]<[KeyboardModifier]<\"Alt\"|\"Control\"|\"ControlOrMeta\"|\"Meta\"|\"Shift\">>"},"spec":[{"type":"text","text":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores current↵modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to \"Control\" on Windows↵and Linux and to \"Meta\" on macOS."}],"required":false,"comment":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores\ncurrent modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to\n\"Control\" on Windows and Linux and to \"Meta\" on macOS.","async":false,"alias":"modifiers","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"position","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of the↵element."}],"required":false,"comment":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of\nthe element.","async":false,"alias":"position","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"trial","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults to `false`. Useful to wait until the element is ready for the action without performing it."}],"required":false,"comment":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults\nto `false`. Useful to wait until the element is ready for the action without performing it.","async":false,"alias":"trial","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.dispatchEvent`] instead. Read more about [locators](../locators.md).","name":"dispatchEvent","type":{"name":"void"},"spec":[{"type":"text","text":"The snippet below dispatches the `click` event on the element. Regardless of the visibility state of the element, `click`↵is dispatched. This is equivalent to calling↵[element.click()](https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/click)."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await elementHandle.dispatchEvent('click');"],"codeLang":"js"},{"type":"code","lines":["elementHandle.dispatchEvent(\"click\");"],"codeLang":"java"},{"type":"code","lines":["await element_handle.dispatch_event(\"click\")"],"codeLang":"python async"},{"type":"code","lines":["element_handle.dispatch_event(\"click\")"],"codeLang":"python sync"},{"type":"code","lines":["await elementHandle.DispatchEventAsync(\"click\");"],"codeLang":"csharp"},{"type":"text","text":"Under the hood, it creates an instance of an event based on the given `type`, initializes it with↵`eventInit` properties and dispatches it on the element. Events are `composed`, `cancelable` and bubble by↵default."},{"type":"text","text":"Since `eventInit` is event-specific, please refer to the events documentation for the lists of initial↵properties:"},{"type":"li","text":"[DeviceMotionEvent](https://developer.mozilla.org/en-US/docs/Web/API/DeviceMotionEvent/DeviceMotionEvent)","liType":"bullet"},{"type":"li","text":"[DeviceOrientationEvent](https://developer.mozilla.org/en-US/docs/Web/API/DeviceOrientationEvent/DeviceOrientationEvent)","liType":"bullet"},{"type":"li","text":"[DragEvent](https://developer.mozilla.org/en-US/docs/Web/API/DragEvent/DragEvent)","liType":"bullet"},{"type":"li","text":"[Event](https://developer.mozilla.org/en-US/docs/Web/API/Event/Event)","liType":"bullet"},{"type":"li","text":"[FocusEvent](https://developer.mozilla.org/en-US/docs/Web/API/FocusEvent/FocusEvent)","liType":"bullet"},{"type":"li","text":"[KeyboardEvent](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/KeyboardEvent)","liType":"bullet"},{"type":"li","text":"[MouseEvent](https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/MouseEvent)","liType":"bullet"},{"type":"li","text":"[PointerEvent](https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/PointerEvent)","liType":"bullet"},{"type":"li","text":"[TouchEvent](https://developer.mozilla.org/en-US/docs/Web/API/TouchEvent/TouchEvent)","liType":"bullet"},{"type":"li","text":"[WheelEvent](https://developer.mozilla.org/en-US/docs/Web/API/WheelEvent/WheelEvent)","liType":"bullet"},{"type":"text","text":"You can also specify `JSHandle` as the property value if you want live objects to be passed into the event:"},{"type":"code","lines":["// Note you can only create DataTransfer in Chromium and Firefox","const dataTransfer = await page.evaluateHandle(() => new DataTransfer());","await elementHandle.dispatchEvent('dragstart', { dataTransfer });"],"codeLang":"js"},{"type":"code","lines":["// Note you can only create DataTransfer in Chromium and Firefox","JSHandle dataTransfer = page.evaluateHandle(\"() => new DataTransfer()\");","Map<String, Object> arg = new HashMap<>();","arg.put(\"dataTransfer\", dataTransfer);","elementHandle.dispatchEvent(\"dragstart\", arg);"],"codeLang":"java"},{"type":"code","lines":["# note you can only create data_transfer in chromium and firefox","data_transfer = await page.evaluate_handle(\"new DataTransfer()\")","await element_handle.dispatch_event(\"#source\", \"dragstart\", {\"dataTransfer\": data_transfer})"],"codeLang":"python async"},{"type":"code","lines":["# note you can only create data_transfer in chromium and firefox","data_transfer = page.evaluate_handle(\"new DataTransfer()\")","element_handle.dispatch_event(\"#source\", \"dragstart\", {\"dataTransfer\": data_transfer})"],"codeLang":"python sync"},{"type":"code","lines":["var dataTransfer = await page.EvaluateHandleAsync(\"() => new DataTransfer()\");","await elementHandle.DispatchEventAsync(\"dragstart\", new Dictionary<string, object>","{","    { \"dataTransfer\", dataTransfer }","});"],"codeLang":"csharp"}],"required":true,"comment":"The snippet below dispatches the `click` event on the element. Regardless of the visibility state of the element,\n`click` is dispatched. This is equivalent to calling\n[element.click()](https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/click).\n\n**Usage**\n\n```js\nawait elementHandle.dispatchEvent('click');\n```\n\n```java\nelementHandle.dispatchEvent(\"click\");\n```\n\n```py\nawait element_handle.dispatch_event(\"click\")\n```\n\n```py\nelement_handle.dispatch_event(\"click\")\n```\n\n```csharp\nawait elementHandle.DispatchEventAsync(\"click\");\n```\n\nUnder the hood, it creates an instance of an event based on the given `type`, initializes it with `eventInit`\nproperties and dispatches it on the element. Events are `composed`, `cancelable` and bubble by default.\n\nSince `eventInit` is event-specific, please refer to the events documentation for the lists of initial properties:\n- [DeviceMotionEvent](https://developer.mozilla.org/en-US/docs/Web/API/DeviceMotionEvent/DeviceMotionEvent)\n- [DeviceOrientationEvent](https://developer.mozilla.org/en-US/docs/Web/API/DeviceOrientationEvent/DeviceOrientationEvent)\n- [DragEvent](https://developer.mozilla.org/en-US/docs/Web/API/DragEvent/DragEvent)\n- [Event](https://developer.mozilla.org/en-US/docs/Web/API/Event/Event)\n- [FocusEvent](https://developer.mozilla.org/en-US/docs/Web/API/FocusEvent/FocusEvent)\n- [KeyboardEvent](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/KeyboardEvent)\n- [MouseEvent](https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/MouseEvent)\n- [PointerEvent](https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/PointerEvent)\n- [TouchEvent](https://developer.mozilla.org/en-US/docs/Web/API/TouchEvent/TouchEvent)\n- [WheelEvent](https://developer.mozilla.org/en-US/docs/Web/API/WheelEvent/WheelEvent)\n\nYou can also specify `JSHandle` as the property value if you want live objects to be passed into the event:\n\n```js\n// Note you can only create DataTransfer in Chromium and Firefox\nconst dataTransfer = await page.evaluateHandle(() => new DataTransfer());\nawait elementHandle.dispatchEvent('dragstart', { dataTransfer });\n```\n\n```java\n// Note you can only create DataTransfer in Chromium and Firefox\nJSHandle dataTransfer = page.evaluateHandle(\"() => new DataTransfer()\");\nMap<String, Object> arg = new HashMap<>();\narg.put(\"dataTransfer\", dataTransfer);\nelementHandle.dispatchEvent(\"dragstart\", arg);\n```\n\n```py\n# note you can only create data_transfer in chromium and firefox\ndata_transfer = await page.evaluate_handle(\"new DataTransfer()\")\nawait element_handle.dispatch_event(\"#source\", \"dragstart\", {\"dataTransfer\": data_transfer})\n```\n\n```py\n# note you can only create data_transfer in chromium and firefox\ndata_transfer = page.evaluate_handle(\"new DataTransfer()\")\nelement_handle.dispatch_event(\"#source\", \"dragstart\", {\"dataTransfer\": data_transfer})\n```\n\n```csharp\nvar dataTransfer = await page.EvaluateHandleAsync(\"() => new DataTransfer()\");\nawait elementHandle.DispatchEventAsync(\"dragstart\", new Dictionary<string, object>\n{\n    { \"dataTransfer\", dataTransfer }\n});\n```\n","async":true,"alias":"dispatchEvent","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"type","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"DOM event type: `\"click\"`, `\"dragstart\"`, etc."}],"required":true,"comment":"DOM event type: `\"click\"`, `\"dragstart\"`, etc.","async":false,"alias":"type","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"eventInit","type":{"name":"EvaluationArgument","expression":"[EvaluationArgument]"},"spec":[{"type":"text","text":"Optional event-specific initialization properties."}],"required":false,"comment":"Optional event-specific initialization properties.","async":false,"alias":"eventInit","overloadIndex":0}]},{"kind":"method","langs":{"aliases":{"python":"eval_on_selector","js":"$eval"},"types":{},"overrides":{}},"since":"v1.9","discouraged":"This method does not wait for the element to pass actionability↵checks and therefore can lead to the flaky tests. Use [`method: Locator.evaluate`],↵other `Locator` helper methods or web-first assertions instead.","name":"evalOnSelector","type":{"name":"Serializable","expression":"[Serializable]"},"spec":[{"type":"text","text":"Returns the return value of `expression`."},{"type":"text","text":"The method finds an element matching the specified selector in the `ElementHandle`s subtree and passes it as a first↵argument to `expression`. If no elements match the selector, the method throws an error."},{"type":"text","text":"If `expression` returns a [Promise], then [`method: ElementHandle.evalOnSelector`] would wait for the promise to resolve and return its↵value."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["const tweetHandle = await page.$('.tweet');","expect(await tweetHandle.$eval('.like', node => node.innerText)).toBe('100');","expect(await tweetHandle.$eval('.retweets', node => node.innerText)).toBe('10');"],"codeLang":"js"},{"type":"code","lines":["ElementHandle tweetHandle = page.querySelector(\".tweet\");","assertEquals(\"100\", tweetHandle.evalOnSelector(\".like\", \"node => node.innerText\"));","assertEquals(\"10\", tweetHandle.evalOnSelector(\".retweets\", \"node => node.innerText\"));"],"codeLang":"java"},{"type":"code","lines":["tweet_handle = await page.query_selector(\".tweet\")","assert await tweet_handle.eval_on_selector(\".like\", \"node => node.innerText\") == \"100\"","assert await tweet_handle.eval_on_selector(\".retweets\", \"node => node.innerText\") == \"10\""],"codeLang":"python async"},{"type":"code","lines":["tweet_handle = page.query_selector(\".tweet\")","assert tweet_handle.eval_on_selector(\".like\", \"node => node.innerText\") == \"100\"","assert tweet_handle.eval_on_selector(\".retweets\", \"node => node.innerText\") == \"10\""],"codeLang":"python sync"},{"type":"code","lines":["var tweetHandle = await page.QuerySelectorAsync(\".tweet\");","Assert.AreEqual(\"100\", await tweetHandle.EvalOnSelectorAsync(\".like\", \"node => node.innerText\"));","Assert.AreEqual(\"10\", await tweetHandle.EvalOnSelectorAsync(\".retweets\", \"node => node.innerText\"));"],"codeLang":"csharp"}],"required":true,"comment":"Returns the return value of `expression`.\n\nThe method finds an element matching the specified selector in the `ElementHandle`s subtree and passes it as a\nfirst argument to `expression`. If no elements match the selector, the method throws an error.\n\nIf `expression` returns a [Promise], then [`method: ElementHandle.evalOnSelector`] would wait for the promise to\nresolve and return its value.\n\n**Usage**\n\n```js\nconst tweetHandle = await page.$('.tweet');\nexpect(await tweetHandle.$eval('.like', node => node.innerText)).toBe('100');\nexpect(await tweetHandle.$eval('.retweets', node => node.innerText)).toBe('10');\n```\n\n```java\nElementHandle tweetHandle = page.querySelector(\".tweet\");\nassertEquals(\"100\", tweetHandle.evalOnSelector(\".like\", \"node => node.innerText\"));\nassertEquals(\"10\", tweetHandle.evalOnSelector(\".retweets\", \"node => node.innerText\"));\n```\n\n```py\ntweet_handle = await page.query_selector(\".tweet\")\nassert await tweet_handle.eval_on_selector(\".like\", \"node => node.innerText\") == \"100\"\nassert await tweet_handle.eval_on_selector(\".retweets\", \"node => node.innerText\") == \"10\"\n```\n\n```py\ntweet_handle = page.query_selector(\".tweet\")\nassert tweet_handle.eval_on_selector(\".like\", \"node => node.innerText\") == \"100\"\nassert tweet_handle.eval_on_selector(\".retweets\", \"node => node.innerText\") == \"10\"\n```\n\n```csharp\nvar tweetHandle = await page.QuerySelectorAsync(\".tweet\");\nAssert.AreEqual(\"100\", await tweetHandle.EvalOnSelectorAsync(\".like\", \"node => node.innerText\"));\nAssert.AreEqual(\"10\", await tweetHandle.EvalOnSelectorAsync(\".retweets\", \"node => node.innerText\"));\n```\n","async":true,"alias":"evalOnSelector","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A selector to query for."}],"required":true,"comment":"A selector to query for.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{"overrides":{"js":{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"expression","type":{"name":"","union":[{"name":"function","args":[{"name":"Element"}]},{"name":"string"}],"expression":"[function]([Element])|[string]"},"spec":[{"type":"text","text":"Function to be evaluated in the page context."}],"argsArray":[],"required":true,"comment":"Function to be evaluated in the page context.","args":{},"clazz":null,"async":false,"alias":"pageFunction","overloadIndex":0}}},"since":"v1.9","name":"expression","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"JavaScript expression to be evaluated in the browser context. If the expression evaluates↵to a function, the function is automatically invoked."}],"required":true,"comment":"JavaScript expression to be evaluated in the browser context. If the expression evaluates to a function, the\nfunction is automatically invoked.","async":false,"alias":"expression","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"arg","type":{"name":"EvaluationArgument","expression":"[EvaluationArgument]"},"spec":[{"type":"text","text":"Optional argument to pass to `expression`."}],"required":false,"comment":"Optional argument to pass to `expression`.","async":false,"alias":"arg","overloadIndex":0}]},{"kind":"method","langs":{"aliases":{"python":"eval_on_selector_all","js":"$$eval"},"types":{},"overrides":{}},"since":"v1.9","discouraged":"In most cases, [`method: Locator.evaluateAll`],↵other `Locator` helper methods and web-first assertions do a better job.","name":"evalOnSelectorAll","type":{"name":"Serializable","expression":"[Serializable]"},"spec":[{"type":"text","text":"Returns the return value of `expression`."},{"type":"text","text":"The method finds all elements matching the specified selector in the `ElementHandle`'s subtree and passes an array of↵matched elements as a first argument to `expression`."},{"type":"text","text":"If `expression` returns a [Promise], then [`method: ElementHandle.evalOnSelectorAll`] would wait for the promise to resolve and return its↵value."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["<div class=\"feed\">","  <div class=\"tweet\">Hello!</div>","  <div class=\"tweet\">Hi!</div>","</div>"],"codeLang":"html"},{"type":"code","lines":["const feedHandle = await page.$('.feed');","expect(await feedHandle.$$eval('.tweet', nodes =>","  nodes.map(n => n.innerText))).toEqual(['Hello!', 'Hi!'],",");"],"codeLang":"js"},{"type":"code","lines":["ElementHandle feedHandle = page.querySelector(\".feed\");","assertEquals(Arrays.asList(\"Hello!\", \"Hi!\"), feedHandle.evalOnSelectorAll(\".tweet\", \"nodes => nodes.map(n => n.innerText)\"));"],"codeLang":"java"},{"type":"code","lines":["feed_handle = await page.query_selector(\".feed\")","assert await feed_handle.eval_on_selector_all(\".tweet\", \"nodes => nodes.map(n => n.innerText)\") == [\"hello!\", \"hi!\"]"],"codeLang":"python async"},{"type":"code","lines":["feed_handle = page.query_selector(\".feed\")","assert feed_handle.eval_on_selector_all(\".tweet\", \"nodes => nodes.map(n => n.innerText)\") == [\"hello!\", \"hi!\"]"],"codeLang":"python sync"},{"type":"code","lines":["var feedHandle = await page.QuerySelectorAsync(\".feed\");","Assert.AreEqual(new [] { \"Hello!\", \"Hi!\" }, await feedHandle.EvalOnSelectorAllAsync<string[]>(\".tweet\", \"nodes => nodes.map(n => n.innerText)\"));"],"codeLang":"csharp"}],"required":true,"comment":"Returns the return value of `expression`.\n\nThe method finds all elements matching the specified selector in the `ElementHandle`'s subtree and passes an array\nof matched elements as a first argument to `expression`.\n\nIf `expression` returns a [Promise], then [`method: ElementHandle.evalOnSelectorAll`] would wait for the promise to\nresolve and return its value.\n\n**Usage**\n\n```html\n<div class=\"feed\">\n  <div class=\"tweet\">Hello!</div>\n  <div class=\"tweet\">Hi!</div>\n</div>\n```\n\n```js\nconst feedHandle = await page.$('.feed');\nexpect(await feedHandle.$$eval('.tweet', nodes =>\n  nodes.map(n => n.innerText))).toEqual(['Hello!', 'Hi!'],\n);\n```\n\n```java\nElementHandle feedHandle = page.querySelector(\".feed\");\nassertEquals(Arrays.asList(\"Hello!\", \"Hi!\"), feedHandle.evalOnSelectorAll(\".tweet\", \"nodes => nodes.map(n => n.innerText)\"));\n```\n\n```py\nfeed_handle = await page.query_selector(\".feed\")\nassert await feed_handle.eval_on_selector_all(\".tweet\", \"nodes => nodes.map(n => n.innerText)\") == [\"hello!\", \"hi!\"]\n```\n\n```py\nfeed_handle = page.query_selector(\".feed\")\nassert feed_handle.eval_on_selector_all(\".tweet\", \"nodes => nodes.map(n => n.innerText)\") == [\"hello!\", \"hi!\"]\n```\n\n```csharp\nvar feedHandle = await page.QuerySelectorAsync(\".feed\");\nAssert.AreEqual(new [] { \"Hello!\", \"Hi!\" }, await feedHandle.EvalOnSelectorAllAsync<string[]>(\".tweet\", \"nodes => nodes.map(n => n.innerText)\"));\n```\n","async":true,"alias":"evalOnSelectorAll","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A selector to query for."}],"required":true,"comment":"A selector to query for.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{"overrides":{"js":{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.9","name":"expression","type":{"name":"","union":[{"name":"function","args":[{"name":"Array","templates":[{"name":"Element"}]}]},{"name":"string"}],"expression":"[function]([Array]<[Element]>)|[string]"},"spec":[{"type":"text","text":"Function to be evaluated in the page context."}],"argsArray":[],"required":true,"comment":"Function to be evaluated in the page context.","args":{},"clazz":null,"async":false,"alias":"pageFunction","overloadIndex":0}}},"since":"v1.9","name":"expression","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"JavaScript expression to be evaluated in the browser context. If the expression evaluates↵to a function, the function is automatically invoked."}],"required":true,"comment":"JavaScript expression to be evaluated in the browser context. If the expression evaluates to a function, the\nfunction is automatically invoked.","async":false,"alias":"expression","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.9","name":"arg","type":{"name":"EvaluationArgument","expression":"[EvaluationArgument]"},"spec":[{"type":"text","text":"Optional argument to pass to `expression`."}],"required":false,"comment":"Optional argument to pass to `expression`.","async":false,"alias":"arg","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.fill`] instead. Read more about [locators](../locators.md).","name":"fill","type":{"name":"void"},"spec":[{"type":"text","text":"This method waits for [actionability](../actionability.md) checks, focuses the element, fills it and triggers an `input` event after filling. Note that you can pass an empty string to clear the input field."},{"type":"text","text":"If the target element is not an `<input>`, `<textarea>` or `[contenteditable]` element, this method throws an error. However, if the element is inside the `<label>` element that has an associated [control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), the control will be filled instead."},{"type":"text","text":"To send fine-grained keyboard events, use [`method: Locator.pressSequentially`]."}],"required":true,"comment":"This method waits for [actionability](../actionability.md) checks, focuses the element, fills it and triggers an\n`input` event after filling. Note that you can pass an empty string to clear the input field.\n\nIf the target element is not an `<input>`, `<textarea>` or `[contenteditable]` element, this method throws an\nerror. However, if the element is inside the `<label>` element that has an associated\n[control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), the control will be filled\ninstead.\n\nTo send fine-grained keyboard events, use [`method: Locator.pressSequentially`].","async":true,"alias":"fill","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Value to set for the `<input>`, `<textarea>` or `[contenteditable]` element."}],"required":true,"comment":"Value to set for the `<input>`, `<textarea>` or `[contenteditable]` element.","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.13","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.focus`] instead. Read more about [locators](../locators.md).","name":"focus","type":{"name":"void"},"spec":[{"type":"text","text":"Calls [focus](https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/focus) on the element."}],"required":true,"comment":"Calls [focus](https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/focus) on the element.","async":true,"alias":"focus","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.getAttribute`] instead. Read more about [locators](../locators.md).","name":"getAttribute","type":{"name":"","union":[{"name":"null"},{"name":"string"}],"expression":"[null]|[string]"},"spec":[{"type":"text","text":"Returns element attribute value."}],"required":true,"comment":"Returns element attribute value.","async":true,"alias":"getAttribute","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Attribute name to get the value for."}],"required":true,"comment":"Attribute name to get the value for.","async":false,"alias":"name","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.hover`] instead. Read more about [locators](../locators.md).","name":"hover","type":{"name":"void"},"spec":[{"type":"text","text":"This method hovers over the element by performing the following steps:"},{"type":"li","text":"Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.","liType":"ordinal"},{"type":"li","text":"Scroll the element into view if needed.","liType":"ordinal"},{"type":"li","text":"Use [`property: Page.mouse`] to hover over the center of the element, or the specified `position`.","liType":"ordinal"},{"type":"text","text":"If the element is detached from the DOM at any moment during the action, this method throws."},{"type":"text","text":"When all steps combined have not finished during the specified `timeout`, this method throws a↵`TimeoutError`. Passing zero timeout disables this."}],"required":true,"comment":"This method hovers over the element by performing the following steps:\n1. Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.\n1. Scroll the element into view if needed.\n1. Use [`property: Page.mouse`] to hover over the center of the element, or the specified `position`.\n\nIf the element is detached from the DOM at any moment during the action, this method throws.\n\nWhen all steps combined have not finished during the specified `timeout`, this method throws a `TimeoutError`.\nPassing zero timeout disables this.","async":true,"alias":"hover","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"modifiers","type":{"name":"Array","templates":[{"name":"KeyboardModifier","union":[{"name":"\"Alt\""},{"name":"\"Control\""},{"name":"\"ControlOrMeta\""},{"name":"\"Meta\""},{"name":"\"Shift\""}]}],"expression":"[Array]<[KeyboardModifier]<\"Alt\"|\"Control\"|\"ControlOrMeta\"|\"Meta\"|\"Shift\">>"},"spec":[{"type":"text","text":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores current↵modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to \"Control\" on Windows↵and Linux and to \"Meta\" on macOS."}],"required":false,"comment":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores\ncurrent modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to\n\"Control\" on Windows and Linux and to \"Meta\" on macOS.","async":false,"alias":"modifiers","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.28","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"position","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of the↵element."}],"required":false,"comment":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of\nthe element.","async":false,"alias":"position","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"trial","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults to `false`. Useful to wait until the element is ready for the action without performing it."}],"required":false,"comment":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults\nto `false`. Useful to wait until the element is ready for the action without performing it.","async":false,"alias":"trial","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.innerHTML`] instead. Read more about [locators](../locators.md).","name":"innerHTML","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns the `element.innerHTML`."}],"required":true,"comment":"Returns the `element.innerHTML`.","async":true,"alias":"innerHTML","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.innerText`] instead. Read more about [locators](../locators.md).","name":"innerText","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns the `element.innerText`."}],"required":true,"comment":"Returns the `element.innerText`.","async":true,"alias":"innerText","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.13","discouraged":"Use locator-based [`method: Locator.inputValue`] instead. Read more about [locators](../locators.md).","name":"inputValue","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Returns `input.value` for the selected `<input>` or `<textarea>` or `<select>` element."},{"type":"text","text":"Throws for non-input elements. However, if the element is inside the `<label>` element that has an associated [control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), returns the value of the control."}],"required":true,"comment":"Returns `input.value` for the selected `<input>` or `<textarea>` or `<select>` element.\n\nThrows for non-input elements. However, if the element is inside the `<label>` element that has an associated\n[control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), returns the value of the\ncontrol.","async":true,"alias":"inputValue","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.13","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.13","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.13","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.isChecked`] instead. Read more about [locators](../locators.md).","name":"isChecked","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Returns whether the element is checked. Throws if the element is not a checkbox or radio input."}],"required":true,"comment":"Returns whether the element is checked. Throws if the element is not a checkbox or radio input.","async":true,"alias":"isChecked","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.isDisabled`] instead. Read more about [locators](../locators.md).","name":"isDisabled","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Returns whether the element is disabled, the opposite of [enabled](../actionability.md#enabled)."}],"required":true,"comment":"Returns whether the element is disabled, the opposite of [enabled](../actionability.md#enabled).","async":true,"alias":"isDisabled","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.isEditable`] instead. Read more about [locators](../locators.md).","name":"isEditable","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Returns whether the element is [editable](../actionability.md#editable)."}],"required":true,"comment":"Returns whether the element is [editable](../actionability.md#editable).","async":true,"alias":"isEditable","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.isEnabled`] instead. Read more about [locators](../locators.md).","name":"isEnabled","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Returns whether the element is [enabled](../actionability.md#enabled)."}],"required":true,"comment":"Returns whether the element is [enabled](../actionability.md#enabled).","async":true,"alias":"isEnabled","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.isHidden`] instead. Read more about [locators](../locators.md).","name":"isHidden","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Returns whether the element is hidden, the opposite of [visible](../actionability.md#visible)."}],"required":true,"comment":"Returns whether the element is hidden, the opposite of [visible](../actionability.md#visible).","async":true,"alias":"isHidden","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.isVisible`] instead. Read more about [locators](../locators.md).","name":"isVisible","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Returns whether the element is [visible](../actionability.md#visible)."}],"required":true,"comment":"Returns whether the element is [visible](../actionability.md#visible).","async":true,"alias":"isVisible","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"ownerFrame","type":{"name":"","union":[{"name":"null"},{"name":"Frame"}],"expression":"[null]|[Frame]"},"spec":[{"type":"text","text":"Returns the frame containing the given element."}],"required":true,"comment":"Returns the frame containing the given element.","async":true,"alias":"ownerFrame","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.press`] instead. Read more about [locators](../locators.md).","name":"press","type":{"name":"void"},"spec":[{"type":"text","text":"Focuses the element, and then uses [`method: Keyboard.down`] and [`method: Keyboard.up`]."},{"type":"text","text":"`key` can specify the intended↵[keyboardEvent.key](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key) value or a single character to↵generate the text for. A superset of the `key` values can be found↵[here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values). Examples of the keys are:"},{"type":"text","text":"`F1` - `F12`, `Digit0`- `Digit9`, `KeyA`- `KeyZ`, `Backquote`, `Minus`, `Equal`, `Backslash`, `Backspace`, `Tab`,↵`Delete`, `Escape`, `ArrowDown`, `End`, `Enter`, `Home`, `Insert`, `PageDown`, `PageUp`, `ArrowRight`, `ArrowUp`, etc."},{"type":"text","text":"Following modification shortcuts are also supported: `Shift`, `Control`, `Alt`, `Meta`, `ShiftLeft`, `ControlOrMeta`."},{"type":"text","text":"Holding down `Shift` will type the text that corresponds to the `key` in the upper case."},{"type":"text","text":"If `key` is a single character, it is case-sensitive, so the values `a` and `A` will generate different↵respective texts."},{"type":"text","text":"Shortcuts such as `key: \"Control+o\"`, `key: \"Control++` or `key: \"Control+Shift+T\"` are supported as well. When specified with the↵modifier, modifier is pressed and being held while the subsequent key is being pressed."}],"required":true,"comment":"Focuses the element, and then uses [`method: Keyboard.down`] and [`method: Keyboard.up`].\n\n`key` can specify the intended\n[keyboardEvent.key](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key) value or a single character\nto generate the text for. A superset of the `key` values can be found\n[here](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values). Examples of the keys are:\n\n`F1` - `F12`, `Digit0`- `Digit9`, `KeyA`- `KeyZ`, `Backquote`, `Minus`, `Equal`, `Backslash`, `Backspace`, `Tab`,\n`Delete`, `Escape`, `ArrowDown`, `End`, `Enter`, `Home`, `Insert`, `PageDown`, `PageUp`, `ArrowRight`, `ArrowUp`,\netc.\n\nFollowing modification shortcuts are also supported: `Shift`, `Control`, `Alt`, `Meta`, `ShiftLeft`,\n`ControlOrMeta`.\n\nHolding down `Shift` will type the text that corresponds to the `key` in the upper case.\n\nIf `key` is a single character, it is case-sensitive, so the values `a` and `A` will generate different respective\ntexts.\n\nShortcuts such as `key: \"Control+o\"`, `key: \"Control++` or `key: \"Control+Shift+T\"` are supported as well. When\nspecified with the modifier, modifier is pressed and being held while the subsequent key is being pressed.","async":true,"alias":"press","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"key","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Name of the key to press or a character to generate, such as `ArrowLeft` or `a`."}],"required":true,"comment":"Name of the key to press or a character to generate, such as `ArrowLeft` or `a`.","async":false,"alias":"key","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"delay","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Time to wait between `keydown` and `keyup` in milliseconds. Defaults to 0."}],"required":false,"comment":"Time to wait between `keydown` and `keyup` in milliseconds. Defaults to 0.","async":false,"alias":"delay","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option will default to `true` in the future.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Actions that initiate navigations are waiting for these navigations to happen and for pages to start loading. You can↵opt out of waiting via setting this flag. You would only need this option in the exceptional cases such as navigating↵to inaccessible pages. Defaults to `false`."}],"required":false,"comment":"Actions that initiate navigations are waiting for these navigations to happen and for pages to start loading. You\ncan opt out of waiting via setting this flag. You would only need this option in the exceptional cases such as\nnavigating to inaccessible pages. Defaults to `false`.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{"aliases":{"python":"query_selector","js":"$"},"types":{},"overrides":{}},"since":"v1.9","discouraged":"Use locator-based [`method: Page.locator`] instead. Read more about [locators](../locators.md).","name":"querySelector","type":{"name":"","union":[{"name":"null"},{"name":"ElementHandle"}],"expression":"[null]|[ElementHandle]"},"spec":[{"type":"text","text":"The method finds an element matching the specified selector in the `ElementHandle`'s subtree. If no elements match the selector,↵returns `null`."}],"required":true,"comment":"The method finds an element matching the specified selector in the `ElementHandle`'s subtree. If no elements match\nthe selector, returns `null`.","async":true,"alias":"querySelector","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A selector to query for."}],"required":true,"comment":"A selector to query for.","async":false,"alias":"selector","overloadIndex":0}]},{"kind":"method","langs":{"aliases":{"python":"query_selector_all","js":"$$"},"types":{},"overrides":{}},"since":"v1.9","discouraged":"Use locator-based [`method: Page.locator`] instead. Read more about [locators](../locators.md).","name":"querySelectorAll","type":{"name":"Array","templates":[{"name":"ElementHandle"}],"expression":"[Array]<[ElementHandle]>"},"spec":[{"type":"text","text":"The method finds all elements matching the specified selector in the `ElementHandle`s subtree. If no elements match the selector,↵returns empty array."}],"required":true,"comment":"The method finds all elements matching the specified selector in the `ElementHandle`s subtree. If no elements match\nthe selector, returns empty array.","async":true,"alias":"querySelectorAll","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.9","name":"selector","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A selector to query for."}],"required":true,"comment":"A selector to query for.","async":false,"alias":"selector","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.screenshot`] instead. Read more about [locators](../locators.md).","name":"screenshot","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"This method captures a screenshot of the page, clipped to the size and position of this particular element. If the element is covered by other elements, it will not be actually visible on the screenshot. If the element is a scrollable container, only the currently scrolled content will be visible on the screenshot."},{"type":"text","text":"This method waits for the [actionability](../actionability.md) checks, then scrolls element into view before taking a↵screenshot. If the element is detached from DOM, the method throws an error."},{"type":"text","text":"Returns the buffer with the captured screenshot."}],"required":true,"comment":"This method captures a screenshot of the page, clipped to the size and position of this particular element. If the\nelement is covered by other elements, it will not be actually visible on the screenshot. If the element is a\nscrollable container, only the currently scrolled content will be visible on the screenshot.\n\nThis method waits for the [actionability](../actionability.md) checks, then scrolls element into view before taking\na screenshot. If the element is detached from DOM, the method throws an error.\n\nReturns the buffer with the captured screenshot.","async":true,"alias":"screenshot","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"animations","type":{"name":"ScreenshotAnimations","union":[{"name":"\"disabled\""},{"name":"\"allow\""}],"expression":"[ScreenshotAnimations]<\"disabled\"|\"allow\">"},"spec":[{"type":"text","text":"When set to `\"disabled\"`, stops CSS animations, CSS transitions and Web Animations. Animations get different treatment depending on their duration:"},{"type":"li","text":"finite animations are fast-forwarded to completion, so they'll fire `transitionend` event.","liType":"bullet"},{"type":"li","text":"infinite animations are canceled to initial state, and then played over after the screenshot.","liType":"bullet"},{"type":"text","text":"Defaults to `\"allow\"` that leaves animations untouched."}],"required":false,"comment":"When set to `\"disabled\"`, stops CSS animations, CSS transitions and Web Animations. Animations get different\ntreatment depending on their duration:\n- finite animations are fast-forwarded to completion, so they'll fire `transitionend` event.\n- infinite animations are canceled to initial state, and then played over after the screenshot.\n\nDefaults to `\"allow\"` that leaves animations untouched.","async":false,"alias":"animations","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"caret","type":{"name":"ScreenshotCaret","union":[{"name":"\"hide\""},{"name":"\"initial\""}],"expression":"[ScreenshotCaret]<\"hide\"|\"initial\">"},"spec":[{"type":"text","text":"When set to `\"hide\"`, screenshot will hide text caret. When set to `\"initial\"`, text caret behavior will not be changed.  Defaults to `\"hide\"`."}],"required":false,"comment":"When set to `\"hide\"`, screenshot will hide text caret. When set to `\"initial\"`, text caret behavior will not be\nchanged.  Defaults to `\"hide\"`.","async":false,"alias":"caret","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"mask","type":{"name":"Array","templates":[{"name":"Locator"}],"expression":"[Array]<[Locator]>"},"spec":[{"type":"text","text":"Specify locators that should be masked when the screenshot is taken. Masked elements will be overlaid with↵a pink box `#FF00FF` (customized by `maskColor`) that completely covers its bounding box.↵The mask is also applied to invisible elements, see [Matching only visible elements](../locators.md#matching-only-visible-elements) to disable that."}],"required":false,"comment":"Specify locators that should be masked when the screenshot is taken. Masked elements will be overlaid with a pink\nbox `#FF00FF` (customized by `maskColor`) that completely covers its bounding box. The mask is also applied to\ninvisible elements, see [Matching only visible elements](../locators.md#matching-only-visible-elements) to disable\nthat.","async":false,"alias":"mask","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.35","name":"maskColor","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Specify the color of the overlay box for masked elements, in [CSS color format](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value). Default color is pink `#FF00FF`."}],"required":false,"comment":"Specify the color of the overlay box for masked elements, in\n[CSS color format](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value). Default color is pink `#FF00FF`.","async":false,"alias":"maskColor","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"omitBackground","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Hides default white background and allows capturing screenshots with transparency. Not applicable to `jpeg` images.↵Defaults to `false`."}],"required":false,"comment":"Hides default white background and allows capturing screenshots with transparency. Not applicable to `jpeg` images.\nDefaults to `false`.","async":false,"alias":"omitBackground","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"path","type":{"name":"path","expression":"[path]"},"spec":[{"type":"text","text":"The file path to save the image to. The screenshot type will be inferred from file extension. If `path` is a↵relative path, then it is resolved relative to the current working directory. If no path is provided, the image won't be↵saved to the disk."}],"required":false,"comment":"The file path to save the image to. The screenshot type will be inferred from file extension. If `path` is a\nrelative path, then it is resolved relative to the current working directory. If no path is provided, the image\nwon't be saved to the disk.","async":false,"alias":"path","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"quality","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"The quality of the image, between 0-100. Not applicable to `png` images."}],"required":false,"comment":"The quality of the image, between 0-100. Not applicable to `png` images.","async":false,"alias":"quality","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"scale","type":{"name":"ScreenshotScale","union":[{"name":"\"css\""},{"name":"\"device\""}],"expression":"[ScreenshotScale]<\"css\"|\"device\">"},"spec":[{"type":"text","text":"When set to `\"css\"`, screenshot will have a single pixel per each css pixel on the page. For high-dpi devices, this will keep screenshots small. Using `\"device\"` option will produce a single pixel per each device pixel, so screenshots of high-dpi devices will be twice as large or even larger."},{"type":"text","text":"Defaults to `\"device\"`."}],"required":false,"comment":"When set to `\"css\"`, screenshot will have a single pixel per each css pixel on the page. For high-dpi devices, this\nwill keep screenshots small. Using `\"device\"` option will produce a single pixel per each device pixel, so\nscreenshots of high-dpi devices will be twice as large or even larger.\n\nDefaults to `\"device\"`.","async":false,"alias":"scale","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.41","name":"style","type":{"name":"string","expression":"string"},"spec":[{"type":"text","text":"Text of the stylesheet to apply while making the screenshot. This is where you can hide dynamic elements, make elements invisible↵or change their properties to help you creating repeatable screenshots. This stylesheet pierces the Shadow DOM and applies↵to the inner frames."}],"required":false,"comment":"Text of the stylesheet to apply while making the screenshot. This is where you can hide dynamic elements, make\nelements invisible or change their properties to help you creating repeatable screenshots. This stylesheet pierces\nthe Shadow DOM and applies to the inner frames.","async":false,"alias":"style","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"type","type":{"name":"ScreenshotType","union":[{"name":"\"png\""},{"name":"\"jpeg\""}],"expression":"[ScreenshotType]<\"png\"|\"jpeg\">"},"spec":[{"type":"text","text":"Specify screenshot type, defaults to `png`."}],"required":false,"comment":"Specify screenshot type, defaults to `png`.","async":false,"alias":"type","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.scrollIntoViewIfNeeded`] instead. Read more about [locators](../locators.md).","name":"scrollIntoViewIfNeeded","type":{"name":"void"},"spec":[{"type":"text","text":"This method waits for [actionability](../actionability.md) checks, then tries to scroll element into view, unless it is↵completely visible as defined by↵[IntersectionObserver](https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API)'s `ratio`."},{"type":"text","text":"Throws when `elementHandle` does not point to an element↵[connected](https://developer.mozilla.org/en-US/docs/Web/API/Node/isConnected) to a Document or a ShadowRoot."},{"type":"text","text":"See [scrolling](../input.md#scrolling) for alternative ways to scroll."}],"required":true,"comment":"This method waits for [actionability](../actionability.md) checks, then tries to scroll element into view, unless\nit is completely visible as defined by\n[IntersectionObserver](https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API)'s `ratio`.\n\nThrows when `elementHandle` does not point to an element\n[connected](https://developer.mozilla.org/en-US/docs/Web/API/Node/isConnected) to a Document or a ShadowRoot.\n\nSee [scrolling](../input.md#scrolling) for alternative ways to scroll.","async":true,"alias":"scrollIntoViewIfNeeded","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.selectOption`] instead. Read more about [locators](../locators.md).","name":"selectOption","type":{"name":"Array","templates":[{"name":"string"}],"expression":"[Array]<[string]>"},"spec":[{"type":"text","text":"This method waits for [actionability](../actionability.md) checks, waits until all specified options are present in the `<select>` element and selects these options."},{"type":"text","text":"If the target element is not a `<select>` element, this method throws an error. However, if the element is inside the `<label>` element that has an associated [control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), the control will be used instead."},{"type":"text","text":"Returns the array of option values that have been successfully selected."},{"type":"text","text":"Triggers a `change` and `input` event once all the provided options have been selected."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["// Single selection matching the value or label","handle.selectOption('blue');","","// single selection matching the label","handle.selectOption({ label: 'Blue' });","","// multiple selection","handle.selectOption(['red', 'green', 'blue']);"],"codeLang":"js"},{"type":"code","lines":["// Single selection matching the value or label","handle.selectOption(\"blue\");","// single selection matching the label","handle.selectOption(new SelectOption().setLabel(\"Blue\"));","// multiple selection","handle.selectOption(new String[] {\"red\", \"green\", \"blue\"});"],"codeLang":"java"},{"type":"code","lines":["# Single selection matching the value or label","await handle.select_option(\"blue\")","# single selection matching the label","await handle.select_option(label=\"blue\")","# multiple selection","await handle.select_option(value=[\"red\", \"green\", \"blue\"])"],"codeLang":"python async"},{"type":"code","lines":["# Single selection matching the value or label","handle.select_option(\"blue\")","# single selection matching both the label","handle.select_option(label=\"blue\")","# multiple selection","handle.select_option(value=[\"red\", \"green\", \"blue\"])"],"codeLang":"python sync"},{"type":"code","lines":["// Single selection matching the value or label","await handle.SelectOptionAsync(new[] { \"blue\" });","// single selection matching the label","await handle.SelectOptionAsync(new[] { new SelectOptionValue() { Label = \"blue\" } });","// multiple selection","await handle.SelectOptionAsync(new[] { \"red\", \"green\", \"blue\" });","// multiple selection for blue, red and second option","await handle.SelectOptionAsync(new[] {","    new SelectOptionValue() { Label = \"blue\" },","    new SelectOptionValue() { Index = 2 },","    new SelectOptionValue() { Value = \"red\" }});"],"codeLang":"csharp"}],"required":true,"comment":"This method waits for [actionability](../actionability.md) checks, waits until all specified options are present in\nthe `<select>` element and selects these options.\n\nIf the target element is not a `<select>` element, this method throws an error. However, if the element is inside\nthe `<label>` element that has an associated\n[control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), the control will be used\ninstead.\n\nReturns the array of option values that have been successfully selected.\n\nTriggers a `change` and `input` event once all the provided options have been selected.\n\n**Usage**\n\n```js\n// Single selection matching the value or label\nhandle.selectOption('blue');\n\n// single selection matching the label\nhandle.selectOption({ label: 'Blue' });\n\n// multiple selection\nhandle.selectOption(['red', 'green', 'blue']);\n```\n\n```java\n// Single selection matching the value or label\nhandle.selectOption(\"blue\");\n// single selection matching the label\nhandle.selectOption(new SelectOption().setLabel(\"Blue\"));\n// multiple selection\nhandle.selectOption(new String[] {\"red\", \"green\", \"blue\"});\n```\n\n```py\n# Single selection matching the value or label\nawait handle.select_option(\"blue\")\n# single selection matching the label\nawait handle.select_option(label=\"blue\")\n# multiple selection\nawait handle.select_option(value=[\"red\", \"green\", \"blue\"])\n```\n\n```py\n# Single selection matching the value or label\nhandle.select_option(\"blue\")\n# single selection matching both the label\nhandle.select_option(label=\"blue\")\n# multiple selection\nhandle.select_option(value=[\"red\", \"green\", \"blue\"])\n```\n\n```csharp\n// Single selection matching the value or label\nawait handle.SelectOptionAsync(new[] { \"blue\" });\n// single selection matching the label\nawait handle.SelectOptionAsync(new[] { new SelectOptionValue() { Label = \"blue\" } });\n// multiple selection\nawait handle.SelectOptionAsync(new[] { \"red\", \"green\", \"blue\" });\n// multiple selection for blue, red and second option\nawait handle.SelectOptionAsync(new[] {\n    new SelectOptionValue() { Label = \"blue\" },\n    new SelectOptionValue() { Index = 2 },\n    new SelectOptionValue() { Value = \"red\" }});\n```\n","async":true,"alias":"selectOption","overloadIndex":0,"args":[{"kind":"property","langs":{"only":["java","js","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"values","type":{"name":"","union":[{"name":"null"},{"name":"string"},{"name":"ElementHandle"},{"name":"Array","templates":[{"name":"string"}]},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Matches by `option.value`. Optional."}],"required":false,"comment":"Matches by `option.value`. Optional.","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"label","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Matches by `option.label`. Optional."}],"required":false,"comment":"Matches by `option.label`. Optional.","async":false,"alias":"label","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"index","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Matches by the index. Optional."}],"required":false,"comment":"Matches by the index. Optional.","async":false,"alias":"index","overloadIndex":0}]},{"name":"Array","templates":[{"name":"ElementHandle"}]},{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"value","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Matches by `option.value`. Optional."}],"required":false,"comment":"Matches by `option.value`. Optional.","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"label","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"Matches by `option.label`. Optional."}],"required":false,"comment":"Matches by `option.label`. Optional.","async":false,"alias":"label","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"index","type":{"name":"int","expression":"[int]"},"spec":[{"type":"text","text":"Matches by the index. Optional."}],"required":false,"comment":"Matches by the index. Optional.","async":false,"alias":"index","overloadIndex":0}]}]}],"expression":"[null]|[string]|[ElementHandle]|[Array]<[string]>|[Object]|[Array]<[ElementHandle]>|[Array]<[Object]>"},"spec":[{"type":"text","text":"Options to select. If the `<select>` has the `multiple` attribute, all matching options are selected, otherwise only the↵first option matching one of the passed options is selected. String values are matching both values and labels. Option↵is considered matching if all specified properties match."}],"required":true,"comment":"Options to select. If the `<select>` has the `multiple` attribute, all matching options are selected, otherwise\nonly the first option matching one of the passed options is selected. String values are matching both values and\nlabels. Option is considered matching if all specified properties match.","async":false,"alias":"values","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.13","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"element","type":{"name":"","union":[{"name":"ElementHandle"},{"name":"Array","templates":[{"name":"ElementHandle"}]}],"expression":"[ElementHandle]|[Array]<[ElementHandle]>"},"spec":[{"type":"text","text":"Option elements to select. Optional."}],"required":false,"comment":"Option elements to select. Optional.","async":false,"alias":"element","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"index","type":{"name":"","union":[{"name":"int"},{"name":"Array","templates":[{"name":"int"}]}],"expression":"[int]|[Array]<[int]>"},"spec":[{"type":"text","text":"Options to select by index. Optional."}],"required":false,"comment":"Options to select by index. Optional.","async":false,"alias":"index","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"value","type":{"name":"","union":[{"name":"string"},{"name":"Array","templates":[{"name":"string"}]}],"expression":"[string]|[Array]<[string]>"},"spec":[{"type":"text","text":"Options to select by value. If the `<select>` has the `multiple` attribute, all given options are selected, otherwise↵only the first option matching one of the passed options is selected. Optional."}],"required":false,"comment":"Options to select by value. If the `<select>` has the `multiple` attribute, all given options are selected,\notherwise only the first option matching one of the passed options is selected. Optional.","async":false,"alias":"value","overloadIndex":0},{"kind":"property","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"label","type":{"name":"","union":[{"name":"string"},{"name":"Array","templates":[{"name":"string"}]}],"expression":"[string]|[Array]<[string]>"},"spec":[{"type":"text","text":"Options to select by label. If the `<select>` has the `multiple` attribute, all given options are selected, otherwise↵only the first option matching one of the passed options is selected. Optional."}],"required":false,"comment":"Options to select by label. If the `<select>` has the `multiple` attribute, all given options are selected,\notherwise only the first option matching one of the passed options is selected. Optional.","async":false,"alias":"label","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.selectText`] instead. Read more about [locators](../locators.md).","name":"selectText","type":{"name":"void"},"spec":[{"type":"text","text":"This method waits for [actionability](../actionability.md) checks, then focuses the element and selects all its text↵content."},{"type":"text","text":"If the element is inside the `<label>` element that has an associated [control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), focuses and selects text in the control instead."}],"required":true,"comment":"This method waits for [actionability](../actionability.md) checks, then focuses the element and selects all its\ntext content.\n\nIf the element is inside the `<label>` element that has an associated\n[control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), focuses and selects text in\nthe control instead.","async":true,"alias":"selectText","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.13","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.15","discouraged":"Use locator-based [`method: Locator.setChecked`] instead. Read more about [locators](../locators.md).","name":"setChecked","type":{"name":"void"},"spec":[{"type":"text","text":"This method checks or unchecks an element by performing the following steps:"},{"type":"li","text":"Ensure that element is a checkbox or a radio input. If not, this method throws.","liType":"ordinal"},{"type":"li","text":"If the element already has the right checked state, this method returns immediately.","liType":"ordinal"},{"type":"li","text":"Wait for [actionability](../actionability.md) checks on the matched element, unless `force` option is↵set. If the element is detached during the checks, the whole action is retried.","liType":"ordinal"},{"type":"li","text":"Scroll the element into view if needed.","liType":"ordinal"},{"type":"li","text":"Use [`property: Page.mouse`] to click in the center of the element.","liType":"ordinal"},{"type":"li","text":"Ensure that the element is now checked or unchecked. If not, this method throws.","liType":"ordinal"},{"type":"text","text":"When all steps combined have not finished during the specified `timeout`, this method throws a↵`TimeoutError`. Passing zero timeout disables this."}],"required":true,"comment":"This method checks or unchecks an element by performing the following steps:\n1. Ensure that element is a checkbox or a radio input. If not, this method throws.\n1. If the element already has the right checked state, this method returns immediately.\n1. Wait for [actionability](../actionability.md) checks on the matched element, unless `force` option is set. If\n   the element is detached during the checks, the whole action is retried.\n1. Scroll the element into view if needed.\n1. Use [`property: Page.mouse`] to click in the center of the element.\n1. Ensure that the element is now checked or unchecked. If not, this method throws.\n\nWhen all steps combined have not finished during the specified `timeout`, this method throws a `TimeoutError`.\nPassing zero timeout disables this.","async":true,"alias":"setChecked","overloadIndex":0,"args":[{"kind":"property","langs":{"aliases":{"csharp":"checkedState"},"types":{},"overrides":{}},"since":"v1.15","name":"checked","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to check or uncheck the checkbox."}],"required":true,"comment":"Whether to check or uncheck the checkbox.","async":false,"alias":"checked","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.15","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","name":"position","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.15","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of the↵element."}],"required":false,"comment":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of\nthe element.","async":false,"alias":"position","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.15","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.15","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","name":"trial","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults to `false`. Useful to wait until the element is ready for the action without performing it."}],"required":false,"comment":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults\nto `false`. Useful to wait until the element is ready for the action without performing it.","async":false,"alias":"trial","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.setInputFiles`] instead. Read more about [locators](../locators.md).","name":"setInputFiles","type":{"name":"void"},"spec":[{"type":"text","text":"Sets the value of the file input to these file paths or files. If some of the `filePaths` are relative paths, then they↵are resolved relative to the current working directory. For empty array, clears the selected files.↵For inputs with a `[webkitdirectory]` attribute, only a single directory path is supported."},{"type":"text","text":"This method expects `ElementHandle` to point to an↵[input element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input). However, if the element is inside the `<label>` element that has an associated [control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), targets the control instead."}],"required":true,"comment":"Sets the value of the file input to these file paths or files. If some of the `filePaths` are relative paths, then\nthey are resolved relative to the current working directory. For empty array, clears the selected files. For inputs\nwith a `[webkitdirectory]` attribute, only a single directory path is supported.\n\nThis method expects `ElementHandle` to point to an\n[input element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input). However, if the element is inside\nthe `<label>` element that has an associated\n[control](https://developer.mozilla.org/en-US/docs/Web/API/HTMLLabelElement/control), targets the control instead.","async":true,"alias":"setInputFiles","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"files","type":{"name":"","union":[{"name":"path"},{"name":"Array","templates":[{"name":"path"}]},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]},{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]}]}],"expression":"[path]|[Array]<[path]>|[Object]|[Array]<[Object]>"},"spec":[],"required":true,"comment":"","async":false,"alias":"files","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.tap`] instead. Read more about [locators](../locators.md).","name":"tap","type":{"name":"void"},"spec":[{"type":"text","text":"This method taps the element by performing the following steps:"},{"type":"li","text":"Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.","liType":"ordinal"},{"type":"li","text":"Scroll the element into view if needed.","liType":"ordinal"},{"type":"li","text":"Use [`property: Page.touchscreen`] to tap the center of the element, or the specified `position`.","liType":"ordinal"},{"type":"text","text":"If the element is detached from the DOM at any moment during the action, this method throws."},{"type":"text","text":"When all steps combined have not finished during the specified `timeout`, this method throws a↵`TimeoutError`. Passing zero timeout disables this."},{"type":"note","noteType":"note","children":[{"type":"text","text":"`elementHandle.tap()` requires that the `hasTouch` option of the browser context be set to true."}]}],"required":true,"comment":"This method taps the element by performing the following steps:\n1. Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.\n1. Scroll the element into view if needed.\n1. Use [`property: Page.touchscreen`] to tap the center of the element, or the specified `position`.\n\nIf the element is detached from the DOM at any moment during the action, this method throws.\n\nWhen all steps combined have not finished during the specified `timeout`, this method throws a `TimeoutError`.\nPassing zero timeout disables this.\n\n**NOTE** `elementHandle.tap()` requires that the `hasTouch` option of the browser context be set to true.\n","async":true,"alias":"tap","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"modifiers","type":{"name":"Array","templates":[{"name":"KeyboardModifier","union":[{"name":"\"Alt\""},{"name":"\"Control\""},{"name":"\"ControlOrMeta\""},{"name":"\"Meta\""},{"name":"\"Shift\""}]}],"expression":"[Array]<[KeyboardModifier]<\"Alt\"|\"Control\"|\"ControlOrMeta\"|\"Meta\"|\"Shift\">>"},"spec":[{"type":"text","text":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores current↵modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to \"Control\" on Windows↵and Linux and to \"Meta\" on macOS."}],"required":false,"comment":"Modifier keys to press. Ensures that only these modifiers are pressed during the operation, and then restores\ncurrent modifiers back. If not specified, currently pressed modifiers are used. \"ControlOrMeta\" resolves to\n\"Control\" on Windows and Linux and to \"Meta\" on macOS.","async":false,"alias":"modifiers","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"position","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of the↵element."}],"required":false,"comment":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of\nthe element.","async":false,"alias":"position","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"trial","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults to `false`. Useful to wait until the element is ready for the action without performing it."}],"required":false,"comment":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults\nto `false`. Useful to wait until the element is ready for the action without performing it.","async":false,"alias":"trial","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.textContent`] instead. Read more about [locators](../locators.md).","name":"textContent","type":{"name":"","union":[{"name":"null"},{"name":"string"}],"expression":"[null]|[string]"},"spec":[{"type":"text","text":"Returns the `node.textContent`."}],"required":true,"comment":"Returns the `node.textContent`.","async":true,"alias":"textContent","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","deprecated":"In most cases, you should use [`method: Locator.fill`] instead. You only need to press keys one by one if there is special keyboard handling on the page - in this case use [`method: Locator.pressSequentially`].","name":"type","type":{"name":"void"},"spec":[{"type":"text","text":"Focuses the element, and then sends a `keydown`, `keypress`/`input`, and `keyup` event for each character in the text."},{"type":"text","text":"To press a special key, like `Control` or `ArrowDown`, use [`method: ElementHandle.press`]."},{"type":"text","text":"**Usage**"}],"required":true,"comment":"Focuses the element, and then sends a `keydown`, `keypress`/`input`, and `keyup` event for each character in the\ntext.\n\nTo press a special key, like `Control` or `ArrowDown`, use [`method: ElementHandle.press`].\n\n**Usage**","async":true,"alias":"type","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"text","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A text to type into a focused element."}],"required":true,"comment":"A text to type into a focused element.","async":false,"alias":"text","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"delay","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Time to wait between key presses in milliseconds. Defaults to 0."}],"required":false,"comment":"Time to wait between key presses in milliseconds. Defaults to 0.","async":false,"alias":"delay","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use locator-based [`method: Locator.uncheck`] instead. Read more about [locators](../locators.md).","name":"uncheck","type":{"name":"void"},"spec":[{"type":"text","text":"This method checks the element by performing the following steps:"},{"type":"li","text":"Ensure that element is a checkbox or a radio input. If not, this method throws. If the element is already↵unchecked, this method returns immediately.","liType":"ordinal"},{"type":"li","text":"Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.","liType":"ordinal"},{"type":"li","text":"Scroll the element into view if needed.","liType":"ordinal"},{"type":"li","text":"Use [`property: Page.mouse`] to click in the center of the element.","liType":"ordinal"},{"type":"li","text":"Ensure that the element is now unchecked. If not, this method throws.","liType":"ordinal"},{"type":"text","text":"If the element is detached from the DOM at any moment during the action, this method throws."},{"type":"text","text":"When all steps combined have not finished during the specified `timeout`, this method throws a↵`TimeoutError`. Passing zero timeout disables this."}],"required":true,"comment":"This method checks the element by performing the following steps:\n1. Ensure that element is a checkbox or a radio input. If not, this method throws. If the element is already\n   unchecked, this method returns immediately.\n1. Wait for [actionability](../actionability.md) checks on the element, unless `force` option is set.\n1. Scroll the element into view if needed.\n1. Use [`property: Page.mouse`] to click in the center of the element.\n1. Ensure that the element is now unchecked. If not, this method throws.\n\nIf the element is detached from the DOM at any moment during the action, this method throws.\n\nWhen all steps combined have not finished during the specified `timeout`, this method throws a `TimeoutError`.\nPassing zero timeout disables this.","async":true,"alias":"uncheck","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"force","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`."}],"required":false,"comment":"Whether to bypass the [actionability](../actionability.md) checks. Defaults to `false`.","async":false,"alias":"force","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","deprecated":"This option has no effect.","name":"noWaitAfter","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"This option has no effect."}],"required":false,"comment":"This option has no effect.","async":false,"alias":"noWaitAfter","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"position","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.11","name":"x","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"x","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"y","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":""}],"required":true,"comment":"","async":false,"alias":"y","overloadIndex":0}],"expression":"[Object]"},"spec":[{"type":"text","text":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of the↵element."}],"required":false,"comment":"A point to use relative to the top-left corner of element padding box. If not specified, uses some visible point of\nthe element.","async":false,"alias":"position","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.11","name":"trial","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults to `false`. Useful to wait until the element is ready for the action without performing it."}],"required":false,"comment":"When set, this method only performs the [actionability](../actionability.md) checks and skips the action. Defaults\nto `false`. Useful to wait until the element is ready for the action without performing it.","async":false,"alias":"trial","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","name":"waitForElementState","type":{"name":"void"},"spec":[{"type":"text","text":"Returns when the element satisfies the `state`."},{"type":"text","text":"Depending on the `state` parameter, this method waits for one of the [actionability](../actionability.md) checks↵to pass. This method throws when the element is detached while waiting, unless waiting for the `\"hidden\"` state."},{"type":"li","text":"`\"visible\"` Wait until the element is [visible](../actionability.md#visible).","liType":"bullet"},{"type":"li","text":"`\"hidden\"` Wait until the element is [not visible](../actionability.md#visible) or↵not attached. Note that waiting for hidden does not throw when the element detaches.","liType":"bullet"},{"type":"li","text":"`\"stable\"` Wait until the element is both [visible](../actionability.md#visible) and↵[stable](../actionability.md#stable).","liType":"bullet"},{"type":"li","text":"`\"enabled\"` Wait until the element is [enabled](../actionability.md#enabled).","liType":"bullet"},{"type":"li","text":"`\"disabled\"` Wait until the element is [not enabled](../actionability.md#enabled).","liType":"bullet"},{"type":"li","text":"`\"editable\"` Wait until the element is [editable](../actionability.md#editable).","liType":"bullet"},{"type":"text","text":"If the element does not satisfy the condition for the `timeout` milliseconds, this method will throw."}],"required":true,"comment":"Returns when the element satisfies the `state`.\n\nDepending on the `state` parameter, this method waits for one of the [actionability](../actionability.md) checks to\npass. This method throws when the element is detached while waiting, unless waiting for the `\"hidden\"` state.\n- `\"visible\"` Wait until the element is [visible](../actionability.md#visible).\n- `\"hidden\"` Wait until the element is [not visible](../actionability.md#visible) or not attached. Note that\n  waiting for hidden does not throw when the element detaches.\n- `\"stable\"` Wait until the element is both [visible](../actionability.md#visible) and\n  [stable](../actionability.md#stable).\n- `\"enabled\"` Wait until the element is [enabled](../actionability.md#enabled).\n- `\"disabled\"` Wait until the element is [not enabled](../actionability.md#enabled).\n- `\"editable\"` Wait until the element is [editable](../actionability.md#editable).\n\nIf the element does not satisfy the condition for the `timeout` milliseconds, this method will throw.","async":true,"alias":"waitForElementState","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"state","type":{"name":"ElementState","union":[{"name":"\"visible\""},{"name":"\"hidden\""},{"name":"\"stable\""},{"name":"\"enabled\""},{"name":"\"disabled\""},{"name":"\"editable\""}],"expression":"[ElementState]<\"visible\"|\"hidden\"|\"stable\"|\"enabled\"|\"disabled\"|\"editable\">"},"spec":[{"type":"text","text":"A state to wait for, see below for more details."}],"required":true,"comment":"A state to wait for, see below for more details.","async":false,"alias":"state","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]},{"kind":"method","langs":{},"since":"v1.8","discouraged":"Use web assertions that assert visibility or a locator-based [`method: Locator.waitFor`] instead.","name":"waitForSelector","type":{"name":"","union":[{"name":"null"},{"name":"ElementHandle"}],"expression":"[null]|[ElementHandle]"},"spec":[{"type":"text","text":"Returns element specified by selector when it satisfies `state` option. Returns `null` if waiting for `hidden`↵or `detached`."},{"type":"text","text":"Wait for the `selector` relative to the element handle to satisfy `state` option (either↵appear/disappear from dom, or become visible/hidden). If at the moment of calling the method `selector` already↵satisfies the condition, the method will return immediately. If the selector doesn't satisfy the condition for the↵`timeout` milliseconds, the function will throw."},{"type":"text","text":"**Usage**"},{"type":"code","lines":["await page.setContent(`<div><span></span></div>`);","const div = await page.$('div');","// Waiting for the 'span' selector relative to the div.","const span = await div.waitForSelector('span', { state: 'attached' });"],"codeLang":"js"},{"type":"code","lines":["page.setContent(\"<div><span></span></div>\");","ElementHandle div = page.querySelector(\"div\");","// Waiting for the \"span\" selector relative to the div.","ElementHandle span = div.waitForSelector(\"span\", new ElementHandle.WaitForSelectorOptions()","  .setState(WaitForSelectorState.ATTACHED));"],"codeLang":"java"},{"type":"code","lines":["await page.set_content(\"<div><span></span></div>\")","div = await page.query_selector(\"div\")","# waiting for the \"span\" selector relative to the div.","span = await div.wait_for_selector(\"span\", state=\"attached\")"],"codeLang":"python async"},{"type":"code","lines":["page.set_content(\"<div><span></span></div>\")","div = page.query_selector(\"div\")","# waiting for the \"span\" selector relative to the div.","span = div.wait_for_selector(\"span\", state=\"attached\")"],"codeLang":"python sync"},{"type":"code","lines":["await page.SetContentAsync(\"<div><span></span></div>\");","var div = await page.QuerySelectorAsync(\"div\");","// Waiting for the \"span\" selector relative to the div.","var span = await page.WaitForSelectorAsync(\"span\", WaitForSelectorState.Attached);"],"codeLang":"csharp"},{"type":"note","noteType":"note","children":[{"type":"text","text":"This method does not work across navigations, use [`method: Page.waitForSelector`] instead."}]}],"required":true,"comment":"Returns element specified by selector when it satisfies `state` option. Returns `null` if waiting for `hidden` or\n`detached`.\n\nWait for the `selector` relative to the element handle to satisfy `state` option (either appear/disappear from dom,\nor become visible/hidden). If at the moment of calling the method `selector` already satisfies the condition, the\nmethod will return immediately. If the selector doesn't satisfy the condition for the `timeout` milliseconds, the\nfunction will throw.\n\n**Usage**\n\n```js\nawait page.setContent(`<div><span></span></div>`);\nconst div = await page.$('div');\n// Waiting for the 'span' selector relative to the div.\nconst span = await div.waitForSelector('span', { state: 'attached' });\n```\n\n```java\npage.setContent(\"<div><span></span></div>\");\nElementHandle div = page.querySelector(\"div\");\n// Waiting for the \"span\" selector relative to the div.\nElementHandle span = div.waitForSelector(\"span\", new ElementHandle.WaitForSelectorOptions()\n  .setState(WaitForSelectorState.ATTACHED));\n```\n\n```py\nawait page.set_content(\"<div><span></span></div>\")\ndiv = await page.query_selector(\"div\")\n# waiting for the \"span\" selector relative to the div.\nspan = await div.wait_for_selector(\"span\", state=\"attached\")\n```\n\n```py\npage.set_content(\"<div><span></span></div>\")\ndiv = page.query_selector(\"div\")\n# waiting for the \"span\" selector relative to the div.\nspan = div.wait_for_selector(\"span\", state=\"attached\")\n```\n\n```csharp\nawait page.SetContentAsync(\"<div><span></span></div>\");\nvar div = await page.QuerySelectorAsync(\"div\");\n// Waiting for the \"span\" selector relative to the div.\nvar span = await page.WaitForSelectorAsync(\"span\", WaitForSelectorState.Attached);\n```\n\n**NOTE** This method does not work across navigations, use [`method: Page.waitForSelector`] instead.\n","async":true,"alias":"waitForSelector","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"selector","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"A selector to query for."}],"required":true,"comment":"A selector to query for.","async":false,"alias":"selector","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"options","type":{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"state","type":{"name":"WaitForSelectorState","union":[{"name":"\"attached\""},{"name":"\"detached\""},{"name":"\"visible\""},{"name":"\"hidden\""}],"expression":"[WaitForSelectorState]<\"attached\"|\"detached\"|\"visible\"|\"hidden\">"},"spec":[{"type":"text","text":"Defaults to `'visible'`. Can be either:"},{"type":"li","text":"`'attached'` - wait for element to be present in DOM.","liType":"bullet"},{"type":"li","text":"`'detached'` - wait for element to not be present in DOM.","liType":"bullet"},{"type":"li","text":"`'visible'` - wait for element to have non-empty bounding box and no `visibility:hidden`. Note that element without↵any content or with `display:none` has an empty bounding box and is not considered visible.","liType":"bullet"},{"type":"li","text":"`'hidden'` - wait for element to be either detached from DOM, or have an empty bounding box or `visibility:hidden`.↵This is opposite to the `'visible'` option.","liType":"bullet"}],"required":false,"comment":"Defaults to `'visible'`. Can be either:\n- `'attached'` - wait for element to be present in DOM.\n- `'detached'` - wait for element to not be present in DOM.\n- `'visible'` - wait for element to have non-empty bounding box and no `visibility:hidden`. Note that element\n  without any content or with `display:none` has an empty bounding box and is not considered visible.\n- `'hidden'` - wait for element to be either detached from DOM, or have an empty bounding box or\n  `visibility:hidden`. This is opposite to the `'visible'` option.","async":false,"alias":"state","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.15","name":"strict","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"When true, the call requires selector to resolve to a single element. If given selector resolves to more↵than one element, the call throws an exception."}],"required":false,"comment":"When true, the call requires selector to resolve to a single element. If given selector resolves to more than one\nelement, the call throws an exception.","async":false,"alias":"strict","overloadIndex":0},{"kind":"property","langs":{"only":["python","java","csharp"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can be changed by↵using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `30000` (30 seconds). Pass `0` to disable timeout. The default value can\nbe changed by using the [`method: BrowserContext.setDefaultTimeout`] or [`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0},{"kind":"property","langs":{"only":["js"],"aliases":{},"types":{},"overrides":{}},"since":"v1.8","name":"timeout","type":{"name":"float","expression":"[float]"},"spec":[{"type":"text","text":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout` option in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or↵[`method: Page.setDefaultTimeout`] methods."}],"required":false,"comment":"Maximum time in milliseconds. Defaults to `0` - no timeout. The default value can be changed via `actionTimeout`\noption in the config, or by using the [`method: BrowserContext.setDefaultTimeout`] or\n[`method: Page.setDefaultTimeout`] methods.","async":false,"alias":"timeout","overloadIndex":0}]},"required":false,"comment":"","async":false,"alias":"options","overloadIndex":0}]}]},{"name":"Error","spec":[{"type":"li","text":"extends: [Exception]","liType":"bullet"},{"type":"text","text":"Error is raised whenever certain operations are terminated abnormally, e.g.↵browser closes while [`method: Page.evaluate`] is running. All Playwright exceptions↵inherit from this class."}],"extends":"Exception","langs":{"only":["python"],"aliases":{},"types":{},"overrides":{}},"comment":"- extends: [Exception]\n\nError is raised whenever certain operations are terminated abnormally, e.g. browser closes while\n[`method: Page.evaluate`] is running. All Playwright exceptions inherit from this class.","since":"v1.11","members":[{"kind":"property","langs":{},"since":"v1.11","name":"message","type":{"name":"str","expression":"[str]"},"spec":[{"type":"text","text":"Message of the error."}],"required":true,"comment":"Message of the error.","async":false,"alias":"message","overloadIndex":0,"args":[]},{"kind":"property","langs":{},"since":"v1.11","name":"name","type":{"name":"str","expression":"[str]"},"spec":[{"type":"text","text":"Name of the error which got thrown inside the browser. Optional."}],"required":false,"comment":"Name of the error which got thrown inside the browser. Optional.","async":false,"alias":"name","overloadIndex":0,"args":[]},{"kind":"property","langs":{},"since":"v1.11","name":"stack","type":{"name":"str","expression":"[str]"},"spec":[{"type":"text","text":"Stack of the error which got thrown inside the browser. Optional."}],"required":false,"comment":"Stack of the error which got thrown inside the browser. Optional.","async":false,"alias":"stack","overloadIndex":0,"args":[]}]},{"name":"FileChooser","spec":[{"type":"text","text":"`FileChooser` objects are dispatched by the page in the [`event: Page.fileChooser`] event."},{"type":"code","lines":["// Start waiting for file chooser before clicking. Note no await.","const fileChooserPromise = page.waitForEvent('filechooser');","await page.getByText('Upload file').click();","const fileChooser = await fileChooserPromise;","await fileChooser.setFiles(path.join(__dirname, 'myfile.pdf'));"],"codeLang":"js"},{"type":"code","lines":["FileChooser fileChooser = page.waitForFileChooser(() -> page.getByText(\"Upload file\").click());","fileChooser.setFiles(Paths.get(\"myfile.pdf\"));"],"codeLang":"java"},{"type":"code","lines":["async with page.expect_file_chooser() as fc_info:","    await page.get_by_text(\"Upload file\").click()","file_chooser = await fc_info.value","await file_chooser.set_files(\"myfile.pdf\")"],"codeLang":"python async"},{"type":"code","lines":["with page.expect_file_chooser() as fc_info:","    page.get_by_text(\"Upload file\").click()","file_chooser = fc_info.value","file_chooser.set_files(\"myfile.pdf\")"],"codeLang":"python sync"},{"type":"code","lines":["var fileChooser = await page.RunAndWaitForFileChooserAsync(async () =>","{","    await page.GetByText(\"Upload file\").ClickAsync();","});","await fileChooser.SetFilesAsync(\"temp.txt\");"],"codeLang":"csharp"}],"langs":{},"comment":"`FileChooser` objects are dispatched by the page in the [`event: Page.fileChooser`] event.\n\n```js\n// Start waiting for file chooser before clicking. Note no await.\nconst fileChooserPromise = page.waitForEvent('filechooser');\nawait page.getByText('Upload file').click();\nconst fileChooser = await fileChooserPromise;\nawait fileChooser.setFiles(path.join(__dirname, 'myfile.pdf'));\n```\n\n```java\nFileChooser fileChooser = page.waitForFileChooser(() -> page.getByText(\"Upload file\").click());\nfileChooser.setFiles(Paths.get(\"myfile.pdf\"));\n```\n\n```py\nasync with page.expect_file_chooser() as fc_info:\n    await page.get_by_text(\"Upload file\").click()\nfile_chooser = await fc_info.value\nawait file_chooser.set_files(\"myfile.pdf\")\n```\n\n```py\nwith page.expect_file_chooser() as fc_info:\n    page.get_by_text(\"Upload file\").click()\nfile_chooser = fc_info.value\nfile_chooser.set_files(\"myfile.pdf\")\n```\n\n```csharp\nvar fileChooser = await page.RunAndWaitForFileChooserAsync(async () =>\n{\n    await page.GetByText(\"Upload file\").ClickAsync();\n});\nawait fileChooser.SetFilesAsync(\"temp.txt\");\n```\n","since":"v1.8","members":[{"kind":"method","langs":{},"since":"v1.8","name":"element","type":{"name":"ElementHandle","expression":"[ElementHandle]"},"spec":[{"type":"text","text":"Returns input element associated with this file chooser."}],"required":true,"comment":"Returns input element associated with this file chooser.","async":false,"alias":"element","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"isMultiple","type":{"name":"boolean","expression":"[boolean]"},"spec":[{"type":"text","text":"Returns whether this file chooser accepts multiple files."}],"required":true,"comment":"Returns whether this file chooser accepts multiple files.","async":false,"alias":"isMultiple","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"page","type":{"name":"Page","expression":"[Page]"},"spec":[{"type":"text","text":"Returns page this file chooser belongs to."}],"required":true,"comment":"Returns page this file chooser belongs to.","async":false,"alias":"page","overloadIndex":0,"args":[]},{"kind":"method","langs":{},"since":"v1.8","name":"setFiles","type":{"name":"void"},"spec":[{"type":"text","text":"Sets the value of the file input this chooser is associated with. If some of the `filePaths` are relative paths, then↵they are resolved relative to the current working directory. For empty array, clears the selected files."}],"required":true,"comment":"Sets the value of the file input this chooser is associated with. If some of the `filePaths` are relative paths,\nthen they are resolved relative to the current working directory. For empty array, clears the selected files.","async":true,"alias":"setFiles","overloadIndex":0,"args":[{"kind":"property","langs":{},"since":"v1.8","name":"files","type":{"name":"","union":[{"name":"path"},{"name":"Array","templates":[{"name":"path"}]},{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"alias":"name","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"mimeType","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File type"}],"required":true,"comment":"File type","async":false,"alias":"mimeType","overloadIndex":0},{"kind":"property","langs":{},"since":"v1.8","name":"buffer","type":{"name":"Buffer","expression":"[Buffer]"},"spec":[{"type":"text","text":"File content"}],"required":true,"comment":"File content","async":false,"alias":"buffer","overloadIndex":0}]},{"name":"Array","templates":[{"name":"Object","properties":[{"kind":"property","langs":{},"since":"v1.8","name":"name","type":{"name":"string","expression":"[string]"},"spec":[{"type":"text","text":"File name"}],"required":true,"comment":"File name","async":false,"