[![MetaCPAN Release](https://badge.fury.io/pl/Art-World.svg)](https://metacpan.org/release/Art-World) [![Gitlab pipeline](https://gitlab.com/smonff/art-world/badges/master/pipeline.svg)](https://gitlab.com/smonff/art-world/-/commits/master) [![Gitlab coverage](https://gitlab.com/smonff/art-world/badges/master/coverage.svg)](https://gitlab.com/smonff/art-world/-/commits/master)
# NAME

Art::World - Agents interactions modeling  🎨

# SYNOPSIS

    use Art::World;

# OBJECTIVES

Art::World is an attempt to model and simulate a system describing the interactions and influences between the various _agents_ of the art world.

If a correct API is reached, we'll try to build a "game of art" frontend.

# DESCRIPTION

<div>
    <p>
      <img alt="Some illustrations sticked on a wall" src="https://gitlab.com/smonff/art-world/-/raw/master/spec/schema_v2.png"
        width="600px">
    </p>
</div>

- 01 Idea is the first step of process
- 02 Idea is inserted in the file (through process)
- 03 Idea comes from discourse (given about project)
- 04 Idea come when there is no time left
- 05 Ideas constitue the project

- 06 Process allows ideas to evolve
- 07 Process allows to fill the file (with ideas + discourse)
- 08 Process allows to generate some discourse
- 09 Process allows to save time
- 10 Process allows to set up the project

- 11 File is made of ideas
- 12 File is filled and emptied with the process
- 13 File is made of discourse
- 14 File archive ideas, that makes possible to forget them
- 15 File generate a project

- 16 Discourse steers ideas
- 17 Discourse analyze process
- 18 Discourse talks about the file
- 19 Discourse allows to link various stages of the projet
- 20 Discourse is a constituent of the project

- 21 From time to time, ideas appears
- 22 Time needed to apply the process
- 23 Time is suspended into file, process is off there
- 24 Discourse's time (reading time)
- 25 Various times contained in project give it's shape

- 26 Project is updated by new ideas
- 27 Project is constantly updated by the process
- 28 Project is set up when file is updated
- 29 Project and discourse are inseparable
- 30 Project is what takes the longuest time to set up

# HISTORY

This is a long term continuation of an art project started circa 2006.

# AUTHOR

Sébastien Feugère <sebastien@feugere.net>
Seb. Hu-Rillettes <shr@balik.network>

# COPYRIGHT AND LICENSE

Copyright 2006-2020 Seb. Hu-Rillettes

This library is free software; you can redistribute it and/or modify it under the Artistic License 2.0.
