use strict;
use warnings FATAL => 'all';
use Test::More tests => 82;
use Data::Printer;
use feature qw(say);
use IPC::Cmd qw[can_run run];
# This is not necessary, but a simple test, see Ovid's Book
use Dependencies::Searcher;

my $use_pattern = "^use ";
my $requires_pattern = "^requires ";

# Parameters for Ack2 :
    #  * Only pm files
    #  * No filename
    #  * Ignore case
    #  * use or requires
my @params_for_use = ('--perl', '-hi', $use_pattern);
my @params_for_require = ('--perl', '-hi', $requires_pattern);

my $requester = Dependencies::Searcher->new();
ok($requester, "Requester should be created");

can_ok($requester, 'ack');
can_ok($requester, 'build_cmd');
can_ok($requester, 'get_path');

my $ack_path = $requester->get_path();
ok($ack_path =~ /ack/, 'Ack path contains the command name');
ok(can_run($ack_path), "Ack is installed");

my $cmd_use = $requester->build_cmd(@params_for_use);
ok($cmd_use, 'Cmd building for uses');

my $cmd_require = $requester->build_cmd(@params_for_require);
ok($cmd_require, 'Cmd building for requires');

my @ack_result_use = $requester->ack($cmd_use);
foreach (@ack_result_use) {
  ok( $_ =~ /use/, "Array element contain a use");
}


my @ack_result_require = $requester->ack($cmd_require);
# Return nothing as long this distribution includes no requires
ok(not(exists $ack_result_require[0]), 'This module should not return any requires');

my @ack_results = (@ack_result_use, @ack_result_require);

