#!/usr/bin/perl -w

use strict;
use Config;
use File::Spec::Functions;
use File::Temp ();
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );;

use Test::More;

plan tests => 23; # FIXME

$ENV{PAR_TMPDIR} = File::Temp::tempdir(TMPDIR => 1, CLEANUP => 1);

my $EXE = File::Spec->catfile($ENV{PAR_TMPDIR},"rt101800$Config{_exe}");
my $PP = File::Spec->catfile(qw( blib script pp ));

my $tmpfile1 = File::Spec->catfile($ENV{PAR_TMPDIR}, 'check1.txt');
my $tmpdir1  = File::Spec->catdir($ENV{PAR_TMPDIR}, 'checkdir1');
my $tmpfile2 = File::Spec->catfile($tmpdir1,  'check2.txt');

mkdir $tmpdir1;
foreach my $file ($tmpfile1, $tmpfile2) {
    open my $fh, '>', $file or die "Cannot open $file to write to";
    print $fh "this is $file\n\n";  #  contents doesn't matter for this test
    close $fh;
}

{
    no strict 'refs';
    my $tb = ref(Test::More->builder); 
    diag("--- Test::More ---\n"
         ."Test::More => $Test::More::VERSION\n"
         ."$tb => ".${$tb."::VERSION"});
}
my $file = "myldr/par";
use Data::Dumper;
use File::Basename;
if ($^O =~ /linux|solaris|freebsd|openbsd/i) 
{
    my $out = qx(ldd $file);
    if ($? == 0)
    {
        my %dlls = $out =~ /^ \s* (\S+) \s* => \s* (\S+) /gmx;

        diag("--- ldd $file ---\n"
                    .$out
                    ."--- %dlls ---\n"
                    .Dumper(\%dlls));
    }
    else { diag(qq["ldd $file" failed]) }
}
elsif (/darwin/i)
{
    my $out = qx(otool -L $file 2>&1);
    if ($? == 0)
    {
        my %dlls = map { basename($_) => $_ }
                       $out =~ /^ \s+ (\S+) /gmx;
        diag("--- otool -L $file ---\n"
                    .$out
                    ."--- %dlls ---\n"
                    .Dumper(\%dlls));
    } else { diag(qq["otool -L $file" failed: $out"]) }
}

system $^X, $PP, 
    -o => $EXE, 
    -a => "$tmpfile1;check1.txt",
    -a => "$tmpdir1;checkdir1",
    -e => "print q[regression test for rt104560]";
ok( $? == 0 && -f $EXE, qq[successfully packed "$EXE"] ) 
    or die qq[couldn't pack "$EXE"];

my $zip = Archive::Zip->new();
$zip->read($EXE) == AZ_OK 
    or die qq[can't open zip file "$EXE"];
my $manifest = $zip->contents("MANIFEST")
    or die qq[can't read MANIFEST member];
like($manifest, qr{^\Qcheck1.txt\E$}m,           "MANIFEST lists check1.txt (like)");
ok($manifest =~ m{^\Qcheck1.txt\E$}m,            "MANIFEST lists check1.txt (ok)");
like($manifest, qr{(?m)^\Qcheck1.txt\E$},        "MANIFEST lists check1.txt (like (?m))");
like($manifest, qr{^\Qcheckdir1/check2.txt\E$}m, "MANIFEST lists checkdir1/check2.txt (like)");
ok($manifest =~ m{^\Qcheckdir1/check2.txt\E$}m,  "MANIFEST lists checkdir1/check2.txt (ok)");
like($manifest, qr{(?m)^\Qcheckdir1/check2.txt\E$}, "MANIFEST lists checkdir1/check2.txt (like (?m))");

my $meta = "foo\nbar\nquux";
like($meta, qr/^bar/m, 'qr/^bar/m');
like($meta, qr/(?m:^bar)/, 'qr/(?m:^bar)/');
like($meta, qr/^\Qbar\E/m, 'qr/^\Qbar\E/m');
like($meta, qr/(?m:^\Qbar\E)/, 'qr/(?m:^\Qbar\E)/');
like($meta, qr{^bar}m, 'qr{^bar}m');
like($meta, qr{(?m:^bar)}, 'qr{(?m:^bar)}');
like($meta, qr{^\Qbar\E}m, 'qr{^\Qbar\E}m');
like($meta, qr{(?m:^\Qbar\E)}, 'qr{(?m:^\Qbar\E)}');

$meta = "foo\nbar.bar\nquux";
like($meta, qr/^bar\.bar/m, 'qr/^bar\.bar/m');
like($meta, qr/(?m:^bar\.bar)/, 'qr/(?m:^bar\.bar)/');
like($meta, qr/^\Qbar.bar\E/m, 'qr/^\Qbar.bar\E/m');
like($meta, qr/(?m:^\Qbar.bar\E)/, 'qr/(?m:^\Qbar.bar\E)/');
like($meta, qr{^bar\.bar}m, 'qr{^bar\.bar}m');
like($meta, qr{(?m:^bar\.bar)}, 'qr{(?m:^bar\.bar)}');
like($meta, qr{^\Qbar.bar\E}m, 'qr{^\Qbar.bar\E}m');
like($meta, qr{(?m:^\Qbar.bar\E)}, 'qr{(?m:^\Qbar.bar\E)}');
