### OPEN SOURCE LICENSE - GNU AFFERO PUBLIC LICENSE Version 3.0 #######
#
#    Net::FullAuto - Powerful Network Process Automation Software
#    Copyright © 2000-2015  Brian M. Kelly
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but **WITHOUT ANY WARRANTY**; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public
#    License along with this program.  If not, see:
#    <http://www.gnu.org/licenses/agpl.html>.
#
#######################################################################

################################################################
#
#  Makefile.PL for Net::FullAuto
#
################################################################

#BEGIN {

   $main::VERSION='0.9999999999999915';print "LINE=".__LINE__."\n";

   if ($ENV{'AUTOMATED_TESTING'}) {
   #if (1) {

      my $message=<<'END';print "LINE=".__LINE__."\n";

      DEAR CPAN TESTERS:

      First of all, THANK YOU for your selfless service to the Perl
      Community. Your generosity is appreciated more than is communicated,
      let me assure you.

      It has come to my attention, that this module is causing "problems"
      for CPAN Testers. It is not my desire to cause ANYONE "problems".

      Since no one has detailed just what those problems are, or expressed
      any interest in working with me to resolve them, I am disabling
      CPAN testing for the foreseeable future.

      Of course you are welcome and invited to test or use Net::FullAuto at
      any time, - simply comment out the AUTOMATED_TESTING environment
      variable conditional at the top of Makefile.PL and replace it with:
    
         if (1) {

      To avoid "problems" - I suggest testing on a virgin virtual machine.
      Net::FullAuto installs on an Amazon Free Tier micro server without
      issue. Just launch one up, and install cpan with this command:

      sudo yum -y install cpan  (on FreeBSD: 'su' then 'pkg_add -r perl')
                                (See instructions at line 1529 for openSuSe)

      run cpan and at the cpan command prompt type "install Net::FullAuto".

      Be sure $ENV{'AUTOMATED_TESTING'}==0.

      Net::FullAuto will install successfully on any Linux flavor or FreeBSD
      server in Amazon EC2. It will also install with Cygwin on Windows.

      I am willing and eager to work with anyone who is curious or
      interested in the Net::FullAuto project.

      Documentation is admittedly poor - that will be rectified soon.

      Thank you again,
      Brian Kelly

      Brian.Kelly@FullAuto.com

END

      print $message; 
      exit 0;print "LINE=".__LINE__."\n";

   }

BEGIN {

   if (exists $ENV{PAR_TEMP} && $^O ne 'cygwin') {
      chdir "$ENV{PAR_TEMP}\\\\inc\\\\lib";print "LINE=".__LINE__."\n";
      my $partmp=`set`;print "LINE=".__LINE__."\n";
      my $partemp=$partmp;print "LINE=".__LINE__."\n";
      my $windir=$partmp;print "LINE=".__LINE__."\n";
      if ($partmp=~s/^.*PAR_TEMP=(.*?)\n.*$/$1/s) {
         $windir=~s/^.*windir=(.*?)\n.*$/$1/s;print "LINE=".__LINE__."\n";
         $windir=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
         $partmp=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
         my $cpancfg="$partmp\\\\inc\\\\lib\\\\CPAN\\\\Config.pm";print "LINE=".__LINE__."\n";
         my $ch=$partmp."\\\\inc\\\\cpan";print "LINE=".__LINE__."\n";
         my $cfg=`cmd /c type $cpancfg`;print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*cpan_home[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$ch$2/s;print "LINE=".__LINE__."\n";
         my $ksw='keep_source_where';print "LINE=".__LINE__."\n";
         my $chi=$ch."\\\\sources";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*$ksw[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$ch."\\\\prefs";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*prefs_dir[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$ch."\\\\build";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*build_dir[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$ch."\\\\histfile";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*histfile[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*use_sqlite[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/${1}0$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\tar.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*tar[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\wget.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*wget[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\dmake.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*make[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\less.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*pager[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\unzip.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*unzip[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\bzip2.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*bzip2[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\patch.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*patch[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $chi=$partmp."\\\\inc\\\\tools\\\\gzip.exe";print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*gzip[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$chi$2/s;print "LINE=".__LINE__."\n";
         $cfg=~s/^(.*gpg[']?\s*[=][>]\s*q[[])[^]]+([]].*)$/$1$2/s;print "LINE=".__LINE__."\n";
         open(CF,">$cpancfg");print "LINE=".__LINE__."\n";
         print CF $cfg;print "LINE=".__LINE__."\n";
         close CF;print "LINE=".__LINE__."\n";
      }
   }
   if (exists $ENV{PAR_TEMP} && $^O eq 'cygwin') {
      my $cygpar=`/usr/bin/cygpath -u $ENV{PAR_TEMP} 2>&1`;
      foreach my $lib (@INC) {
         next if $lib eq $cygpar;
         push @TMPINC,$lib;
      }
      @INC=@TMPINC;
   }
};print "LINE=".__LINE__."\n";

use Config;print "LINE=".__LINE__."\n";
use CPAN;print "LINE=".__LINE__."\n";
use subs qw/version name sign author license perl_version/;print "LINE=".__LINE__."\n";
use inc::Module::Install;print "LINE=".__LINE__."\n";

#   require Config;print "LINE=".__LINE__."\n";
#   import Config;print "LINE=".__LINE__."\n";
#   require CPAN;print "LINE=".__LINE__."\n";
#   import CPAN;print "LINE=".__LINE__."\n";

   use if (($^O eq 'cygwin' && eval { require 'Win32::RunAsAdmin' })
      || $^O eq 'MSWin32' || $^O eq 'MSWin64'),
      'Win32::RunAsAdmin';print "LINE=".__LINE__."\n";
   if ((($^O eq 'cygwin' && eval { require 'Win32::RunAsAdmin' })
         || $^O eq 'MSWin32' || $^O eq 'MSWin64') &&
         not Win32::RunAsAdmin::check()) {
      my $name=substr($0,(rindex $0,'\\')+1);print "LINE=".__LINE__."\n";
      $name=$ENV{SESSIONNAME} unless exists $ENV{PAR_TEMP};print "LINE=".__LINE__."\n";
      my $message=<<END;print "LINE=".__LINE__."\n";


   FATAL ERROR! - Windows Administrator privileges are needed in
                  order to install FullAuto or OpenSSH.
  
   If you have Administrator Rights, be sure to Right Click on the

      $name

   icon and select  -->  "Run as administrator"

   or, contact your Windows System Administrator to resolve.


END
      print $message;print "LINE=".__LINE__."\n";
      if (exists $ENV{PAR_TEMP}) {
         print "   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
         <STDIN>;print "LINE=".__LINE__."\n";
      } exit 1;print "LINE=".__LINE__."\n";

   }

#};print "LINE=".__LINE__."\n";

#use subs qw/version name sign author license perl_version/;print "LINE=".__LINE__."\n";
#use inc::Module::Install;print "LINE=".__LINE__."\n";

#BEGIN {

   # ASCII BANNER Courtesy of:  http://www.network-science.de/ascii/
   # When FullAuto is installed, run:  fa --figlet  to view multiple fonts.

   my $c=($^O ne 'MSWin32' && $^O ne 'MSWin64')?'©':'(C)';print "LINE=".__LINE__."\n";
   my $fa_banner=<<END;print "LINE=".__LINE__."\n";



    __       __)
   (, )  |  /      /)
      | /| /   _  // _  ______    _    _/_ ___
      |/ |/  _(/_(/_(__(_) // (__(/_   (__(_)
      /  |



           _   _      _         _____      _ _    _         _
          | \\ | | ___| |_      |  ___|   _| | |  / \\  _   _| |_  |  
          |  \\| |/ _ \\ __| o o | |_ | | | | | | / _ \\| | | | __/ | \\
          | |\\  |  __/ |_  o o |  _|| |_| | | |/ ___ \\ |_| | ||     |
          |_| \\_|\\___|\\__|     |_|   \\__,_|_|_/_/   \\_\\__,_|\\__\\___/ $c 



   Copyright $c 2000-2015  Brian M. Kelly  Brian.Kelly\@FullAuto.com


END

   %main::amazon=();print "LINE=".__LINE__."\n";
   if ($ARGV[0]=~/\.pem/) {
      push @{$main::amazon{argv}},$ARGV[0];print "LINE=".__LINE__."\n";
   }
   %main::system_type='';print "LINE=".__LINE__."\n";
   if ($^O eq 'linux' || $^O eq 'freebsd') {
      if ((-e "/etc/system-release-cpe") &&
            (-1<index `cat /etc/system-release-cpe`,'amazon:linux')) {

         # Manual Setup Amazon AMI host before CPAN:
         #
         # sudo yum -y install cpan

         $main::amazon{'ami'}='';print "LINE=".__LINE__."\n";
         $main::system_type='ami';print "LINE=".__LINE__."\n";
      } elsif ((-e "/etc/os-release") &&
            (-1<index `cat /etc/os-release`,'ubuntu')) {
         if (-e "/usr/bin/ec2metadata") {
            $main::amazon{'ubuntu'}='';print "LINE=".__LINE__."\n";
         }
         $main::system_type='ubuntu';print "LINE=".__LINE__."\n";
      } elsif ($^O eq 'freebsd') {

         # Manual Setup FreeBSD host before CPAN:
         #
         # su
         # pkg_add -r perl

         if ((-e "/usr/local/bin/aws") &&
               (-1<index `cat /usr/local/bin/aws`,'aws.amazon')) {
            $main::amazon{'freebsd'}='';print "LINE=".__LINE__."\n";
         }
         $main::system_type='freebsd';print "LINE=".__LINE__."\n";
      } elsif (-e "/etc/SuSE-release") {
         if (-e "/etc/profile.d/amazonEC2.sh") {
            $main::amazon{'suse'}='';print "LINE=".__LINE__."\n";
         }
         $main::system_type='suse';print "LINE=".__LINE__."\n";
      } elsif ((-e "/etc/system-release-cpe") &&
            (-1<index `cat /etc/system-release-cpe`,
            'fedoraproject')) {
         if (-e "/etc/yum/pluginconf.d/amazon-id.conf") {
            $main::amazon{'fedora'}='';print "LINE=".__LINE__."\n";
         }
         $main::system_type='fedora';print "LINE=".__LINE__."\n";
      } elsif ((-e "/etc/system-release-cpe") &&
            (-1<index `cat /etc/system-release-cpe`,
            'redhat:enterprise_linux')) {

         # Manual Setup Redhat host before CPAN:
         #
         # sudo yum -y install cpan

         if (-e "/etc/yum/pluginconf.d/amazon-id.conf") {
            $main::amazon{'rhel'}='';print "LINE=".__LINE__."\n";
         }
         $main::system_type='rhel';print "LINE=".__LINE__."\n";
      } elsif ((-e "/etc/system-release-cpe") &&
            (-1<index `cat /etc/system-release-cpe`,
            'centos:linux')) {

         # Manual Setup CentOS host before CPAN:
         #
         # sudo yum -y groupinstall "Development tools"
         # sudo yum -y install cpan 

         if ((-e "/sys/hypervisor/compilation/compiled_by") &&
               (-1<index `cat /sys/hypervisor/compilation/compiled_by`,
               'amazon')) {
            $main::amazon{'centos'}='';print "LINE=".__LINE__."\n";
         }
         $main::system_type='centos';print "LINE=".__LINE__."\n";
      } elsif (-e "/etc/gentoo-release") {

         # Manual Setup CentOS host before CPAN:
         #

         if ((-e "/sys/hypervisor/compilation/compiled_by") &&
               (-1<index `cat /sys/hypervisor/compilation/compiled_by`,
               'amazon')) {
            $main::amazon{'gentoo'}='';print "LINE=".__LINE__."\n";
         }
         $main::system_type='gentoo';print "LINE=".__LINE__."\n";
      }
   } else { $main::system_type=$^O }

   sub msw64bit {
      return 0 if $^O ne 'cygwin' && $^O ne 'MSWin32' && $^O ne 'MSWin64';print "LINE=".__LINE__."\n";
      my $bitout=`wmic os get osarchitecture`;print "LINE=".__LINE__."\n";
      return 1 if -1<index $bitout,'64';print "LINE=".__LINE__."\n";
      return 0;print "LINE=".__LINE__."\n";
   } 

   sub get_cygwin_location {
      my $cygwin_query=
            `REG QUERY HKEY_LOCAL_MACHINE\\SOFTWARE\\Cygwin\\setup 2>&1`;print "LINE=".__LINE__."\n";
      my $showcq=$cygwin_query;print "LINE=".__LINE__."\n";
      my $sep='\\';print "LINE=".__LINE__."\n";
      if ((-1<index $showcq,'unable to find') && msw64bit()) {
         $cygwin_query="$ENV{windir}\\sysnative\\cmd.exe /c ".
            "REG QUERY HKEY_LOCAL_MACHINE\\SOFTWARE\\Cygwin\\setup 2>&1";print "LINE=".__LINE__."\n";
         $showcq=$cygwin_query=`$cygwin_query`;print "LINE=".__LINE__."\n";
      } elsif ((-1<index $showcq,'Invalid key name') ||
            (-1<index $showcq,'cannot find the path') ||
            (-1<index $showcq,'unable to find')) {
         $cygwin_query=
            `REG QUERY HKEY_LOCAL_MACHINE\\\\SOFTWARE\\\\Cygwin 2>&1`;print "LINE=".__LINE__."\n";
         $showcq=$cygwin_query;print "LINE=".__LINE__."\n";
         $sep='\\\\';print "LINE=".__LINE__."\n";
      }
      $showcq=~s/^/   /mg;chomp $showcq;print "LINE=".__LINE__."\n";
      my $cygwin_query_success=0;print "LINE=".__LINE__."\n";
      if (-1<index $cygwin_query,'REG_SZ') {
         $cygwin_query_success=1;print "LINE=".__LINE__."\n";
      } else {
         my $rcmd="REG QUERY HKEY_LOCAL_MACHINE${sep}SOFTWARE$sep".
                  "Wow6432Node${sep}Cygwin${sep}setup 2>&1";print "LINE=".__LINE__."\n";
         $cygwin_query=`$rcmd`;print "LINE=".__LINE__."\n";
         $showcq=$cygwin_query;print "LINE=".__LINE__."\n";
         $showcq=~s/^/   /mg;chomp $showcq;print "LINE=".__LINE__."\n";
         if (-1<index $cygwin_query,'REG_SZ') {
            $cygwin_query_success=1;print "LINE=".__LINE__."\n";
         }
      }
      if ($cygwin_query_success) {
         #print "\n   REG QUERY RESULT:\n\n   $showcq";print "LINE=".__LINE__."\n";
         $cygwin_query=~s/^.*REG_SZ\s+(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
         $cygwin_query=~s/^\s*//s;print "LINE=".__LINE__."\n";
         $cygwin_query=~s/\s*$//s;print "LINE=".__LINE__."\n";
         unless (-W $cygwin_query) {
            unless (-d $cygwin_query) {
               # The cygwin directory indicated in the Registry does not
               # exist - let's delete the Registry entry
               if (-1<$cygwin_query,'Wow6432') {
                  my $rcmd="REG DELETE HKEY_LOCAL_MACHINE${sep}SOFTWARE${sep}".
                           "Wow6432Node${sep}Cygwin /f 2>&1";print "LINE=".__LINE__."\n";
                  my $regout=`$rcmd`;print "LINE=".__LINE__."\n";
                  return 0;print "LINE=".__LINE__."\n";
               } else {
                  my $rcmd='REG DELETE HKEY_LOCAL_MACHINE'.
                           "${sep}SOFTWARE${sep}Cygwin /f 2>&1";print "LINE=".__LINE__."\n";
                  my $regout=`$rcmd`;print "LINE=".__LINE__."\n";
                  return 0;print "LINE=".__LINE__."\n";
               }
            }
            if (-1<index $0,'Setup-FullAuto') {
               my $name=substr($0,(rindex $0,'\\'));print "LINE=".__LINE__."\n";
               print "\n\n".
                  "   Fatal Error! - Write Access to $cygwin_query\n".
                  "   is needed in order to install FullAuto or OpenSSH.\n\n".
                  "   If you have Administrator Rights, be sure to Right\n".
                  "   Click on the $name\n   icon and select ".
                  "\"Run as administrator\"\n\n".
                  "   Or, contact your Windows System Administrator\n".
                  "   to resolve.\n\n   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
            } else {
               print "\n\n".
                  "   Fatal Error! - Write Access to $cygwin_query\n".
                  "   is needed in order to install FullAuto or OpenSSH.\n\n".
                  "   Please contact your Windows System Administrator\n".
                  "   to resolve.\n\n   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
            }
            <STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
         my $getver='';print "LINE=".__LINE__."\n";
         if ($^O eq 'cygwin') {
            $getver='cygcheck -c cygwin 2>&1';print "LINE=".__LINE__."\n";
         } else {
            $getver='SET CYGWIN=nodosfilewarning & '.
                "cmd /c $cygwin_query${sep}bin${sep}bash -lc ".
                '"cygcheck -c cygwin" 2>&1';print "LINE=".__LINE__."\n";
         }
         my $cygver=`$getver`;print "LINE=".__LINE__."\n";
         if ($cygver=~/(1.7.11-1)/) {
            print "\n\n   Fatal Error! - The current Cygwin version: $1\n".
                  "   (Base Cygwin cygwin1.dll) is incompatible with\n".
                  "   FullAuto. Please update to either a newer or older\n".
                  "   version of Base Cygwin before again attempting to\n".
                  "   to install FullAuto.\n\n".
                  "   You may need to contact your Windows System\n".
                  "   Administrator to resolve.\n\n".
                  "   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
            <STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
         if (-e "$cygwin_query/bin/bash.exe") {
            my $getid='';print "LINE=".__LINE__."\n";
            if ($^O eq 'cygwin') {
               $getid='id 2>&1';print "LINE=".__LINE__."\n";
            } else {
               $getid='SET CYGWIN=nodosfilewarning & '.
                   "cmd /c $cygwin_query${sep}bin${sep}bash -lc ".
                   '"id"';print "LINE=".__LINE__."\n";
            }
            my $groups=`$getid`;print "LINE=".__LINE__."\n";
            my $adm_gr=`net localgroup Administrators`;print "LINE=".__LINE__."\n";
            $adm_gr=~s/^.*---\s*(.*)\s*The command.*$/$1/s;print "LINE=".__LINE__."\n";
            my @adm_gr=split /\n/, $adm_gr;print "LINE=".__LINE__."\n";
            my $admin_flag=0;print "LINE=".__LINE__."\n";
            foreach my $id (@adm_gr) {
               chomp($id);print "LINE=".__LINE__."\n";
               $id=~s/^.*\\(.*)$/$1/;print "LINE=".__LINE__."\n";
               if (-1<index $groups,"($id)" ||
                     ($ENV{'USERNAME'} eq 'Administrator')) {
                  $admin_flag=1;print "LINE=".__LINE__."\n";
                  last;print "LINE=".__LINE__."\n";
               }
            }
            unless ($admin_flag) {
               print "\n\n",
                     "   Fatal Error! - The User $ENV{'USERNAME'} needs to\n",
                     "   be a member of the Administrator's group in order\n",
                     "   to install FullAuto or OpenSSH.\n\n",
                     "   Please contact your Windows System Administrator\n",
                     "   to resolve.\n\n   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
               <STDIN> if exists $ENV{PAR_TEMP};print "LINE=".__LINE__."\n";
               exit 1;print "LINE=".__LINE__."\n";
            }
         }
         if ($_[0]) {
            my $getpath='';print "LINE=".__LINE__."\n";
            $cygwin_query=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
            if ($^O eq 'cygwin') {
               $getpath="/usr/bin/cygpath -u $cygwin_query 2>&1";print "LINE=".__LINE__."\n";
            } else {
               $getpath='SET CYGWIN=nodosfilewarning & '.
                   "cmd /c $cygwin_query${sep}bin${sep}bash -lc ".
                   "\"/usr/bin/cygpath -u $cygwin_query\" 2>&1";print "LINE=".__LINE__."\n";
            }
            $cygwin_query=`$getpath`;print "LINE=".__LINE__."\n";
            chomp $cygwin_query;print "LINE=".__LINE__."\n";
            return '' if $cygwin_query eq '/';print "LINE=".__LINE__."\n";
         }
         return $cygwin_query;print "LINE=".__LINE__."\n";
      } return 0
   }

   $SIG{ INT } = sub{ eval { require Term::ReadKey };print "LINE=".__LINE__."\n";
                      unless ($@) { Term::ReadKey::ReadMode(0) };print "LINE=".__LINE__."\n";
                      print "\n";print "LINE=".__LINE__."\n";
                      exit };print "LINE=".__LINE__."\n";
   use Cwd qw/cwd/;print "LINE=".__LINE__."\n";
   use File::stat;print "LINE=".__LINE__."\n";
   eval {
      CPAN::HandleConfig->load;print "LINE=".__LINE__."\n";
   };print "LINE=".__LINE__."\n";
   if ($@) {
      if ((-x "/usr/local/bin/perl") && ($^X ne "/usr/local/bin/perl")) {
         my $timeout=300;my $a='';print "LINE=".__LINE__."\n";
         my $toperror=$@;print "LINE=".__LINE__."\n";
         eval {
            local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
            alarm $timeout;print "LINE=".__LINE__."\n";
            my $message=<<END;print "LINE=".__LINE__."\n";

   ERROR!:  $toperror

            It appears that the perl installation used to run
            Makefile.PL is an old system installation, and not
            the intended one.

            Another perl installation using /usr/local/bin/perl
            as the primary executable has been discovered.

            Would you like Makefile.PL to be run against that
            installation?

END

            my $fae="No   (FullAuto Setup will exit)";print "LINE=".__LINE__."\n";
            my $menu1 = [
                        $message,
                        [ "Yes", sub{ return 'Yes' } ],
                        [ $fae, sub{ return 'No' } ],
                        ];print "LINE=".__LINE__."\n";
            my $selection=&menu($menu1);print "LINE=".__LINE__."\n";
            exit 0 if $selection eq ']quit[';print "LINE=".__LINE__."\n";
            exit 0 if -1<index $selection, 'No   (';print "LINE=".__LINE__."\n";
            my $argvs=join " ", @ARGV;print "LINE=".__LINE__."\n";
            exec "/usr/local/bin/perl Makefile.PL $argvs";print "LINE=".__LINE__."\n";
            alarm 0;print "LINE=".__LINE__."\n";
         };print "LINE=".__LINE__."\n";
         die "$@: $!\n" if $@;print "LINE=".__LINE__."\n";
      } else {
         die "$@: $!\n" if $@;print "LINE=".__LINE__."\n";
      }
   }
   use POSIX qw/strftime/;print "LINE=".__LINE__."\n";
   my $mycpantest=0; 
   $main::curdir=&cwd;print "LINE=".__LINE__."\n";
   $main::PARdir=$main::curdir;print "LINE=".__LINE__."\n";
   $main::domain_gr_flag=0;print "LINE=".__LINE__."\n";
   my $exec_cnt=0;print "LINE=".__LINE__."\n";
   foreach my $dir (@INC) {
      my $incdir=$dir;print "LINE=".__LINE__."\n";
      $mycpantest=1 if -e $incdir."/CPAN/MyConfig.pm";print "LINE=".__LINE__."\n";
      if ((substr($incdir,-3) eq 'inc') &&
            (1<index $incdir,'par-')) {
         $main::PARdir=substr($incdir,0,-4);print "LINE=".__LINE__."\n";
      }
   }
   chdir $main::PARdir;print "LINE=".__LINE__."\n";
   $INC{'Module/Install.pm'}=$main::PARdir.'/inc/inc/Module/Install.pm';print "LINE=".__LINE__."\n";
   unless (exists $ENV{FA_EDITOR} || grep { /Encrypted|SKIP/i } @ARGV) {
      print $fa_banner;print "LINE=".__LINE__."\n";
      sleep 2;print "LINE=".__LINE__."\n";
   } elsif (grep { /SKIP/i } @ARGV) {
      $exec_cnt=$ARGV[$#ARGV];print "LINE=".__LINE__."\n";
      $exec_cnt++;print "LINE=".__LINE__."\n";
      my $module_fail=$ARGV[$#ARGV-1];print "LINE=".__LINE__."\n";
      my $mod_info='';print "LINE=".__LINE__."\n";
      eval {
         require CPAN;print "LINE=".__LINE__."\n";
         {
            local *STDOUT;print "LINE=".__LINE__."\n";
            open(STDOUT, ">", \$mod_info);print "LINE=".__LINE__."\n";
            CPAN::Shell->m($module_fail);print "LINE=".__LINE__."\n";
         }
      };print "LINE=".__LINE__."\n";
      my $instfile='';print "LINE=".__LINE__."\n";
      ($instfile=$mod_info)=~s/^.*INST_FILE\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
      my $instver='';print "LINE=".__LINE__."\n";
      ($instver=$mod_info)=~s/^.*INST_VERSION\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
      my $cpanver='';print "LINE=".__LINE__."\n";
      ($cpanver=$mod_info)=~s/^.*CPAN_VERSION\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
      if ($exec_cnt==1 && $cpanver ne $instver) {
            # && $instfile=~/vendor_perl/) { # &&
            #((exists $main::amazon{'ami'}) ||
            #(exists $main::amazon{'rhel'}))
            #&& $module_fail eq 'Pod::Man') {
         # Amazon's AMI has Pod::Man installed in the vendor_perl
         # directory which has precedence over the system directory
         # this module actually belongs in. The only solution is to
         # delete it from the vendor_perl area before we attempt to
         # install Pod::Man. We are doing this ONLY on Amazaon AMI
         # systems currently.
         system("sudo echo y | /bin/rm -rf \"$instfile\"");print "LINE=".__LINE__."\n";
      } elsif (2<$exec_cnt) {
         my $timeout=300;my $a='';print "LINE=".__LINE__."\n";
         eval {
            local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
            alarm $timeout;print "LINE=".__LINE__."\n";
            $mod_info=~s/^.*?(CPAN.*)$/$1/s;print "LINE=".__LINE__."\n";
            $mod_info=~s/^\s*/      /mg;print "LINE=".__LINE__."\n";
            print "\n\n   Fatal Error!: The following Perl CPAN ",
                  "module could\n                 ",
                  "not be installed on your system:",
                  "\n\n      $module_fail\n\n$mod_info\n",
                  "   The FullAuto installation will not",
                  "\n   succeed without this module installed",
                  "\n   and loaded.",
                  "\n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n   Press ANY key to exit.";<STDIN>;print "LINE=".__LINE__."\n";
                  return;print "LINE=".__LINE__."\n";
         };print "LINE=".__LINE__."\n";
         alarm 0;print "LINE=".__LINE__."\n";
         exit 1;print "LINE=".__LINE__."\n";
      }
   }

   my $demo_banner=<<'END';print "LINE=".__LINE__."\n";

                              ___     _ _   _       _
                             | __|  _| | | /_\ _  _| |_  | 
   (   /_ /_   _  _          | _| || | | |/ _ \ || |  _/ | \
   |/|/(-(( ()//)(-  To The  |_| \_,_|_|_/_/ \_\_,_|\__\___/©
    ___                        _            _   _
   |   \ ___ _ __  ___ _ _  __| |_ _ _ __ _| |_(_)___ _ _
   | |) / -_) '  \/ _ \ ' \(_-<  _| '_/ _` |  _| / _ \ ' \
   |___/\___|_|_|_\___/_||_/__/\__|_| \__,_|\__|_\___/_||_|
   --------------------------------------------------------

   If you are new to FullAuto, and would like a better idea of what it
   is and what it does, please explore the brief introduction before
   running the demonstration. You can access the introduction by just
   pressing [ENTER]

   Otherwise, use the DOWN ARROW [v] key to move the arrow to item 2
   and press [ENTER] - or just type 2 and press [ENTER] to start the
   demonstration.

END

   my $demo_banner_1=<<'END';print "LINE=".__LINE__."\n";

    ___     _ _   _       _
   | __|  _| | | /_\ _  _| |_  | 
   | _| || | | |/ _ \ || |  _/ | \
   |_| \_,_|_|_/_/ \_\_,_|\__\___/©
    ___     _               _         _   _
   |_ _|_ _| |_ _ _ ___  __| |_  _ __| |_(_)___ _ _
    | || ' \  _| '_/ _ \/ _` | || / _|  _| / _ \ ' \
   |___|_||_\__|_| \___/\__,_|\_,_\__|\__|_\___/_||_|
   --------------------------------------------------

   FullAuto is a breakthrough innovation in Network Process Automation.
   Any time a process involves more than one device, it is a "networked"
   process. Anyone who uses the Internet, engages in "network processing"
   - otherwise known as SURFING!

   The KEY <~[] to process **AUTOMATION**, is secure, persistent access
   to the command-line environments of connected devices. The Internet
   is in fact BILLIONS of connected devices.

   Browsers however, do NOT have direct access to the command-line
   functionality of remote devices, nor are they supposed to.
END

   my $demo_banner_2=<<'END';print "LINE=".__LINE__."\n";

   This is precisely why you are *not* reading this in a browser.
   -------------------------------------------------------------

   FullAuto is an Automation and High Productivity Framework - it is *NOT*
   a browser - nor is it "supposed" to be. But that doesn't mean it has to 
   be ...
               .-'''-.                                        ___
              '   _    \                                   .'/   \
   /|       /   /` '.   \         .--.   _..._            / /     \
   ||      .   |     \  '         |__| .'     '.   .--./) | |     |
   ||      |   '      |  '.-,.--. .--..   .-.   . /.''\\  | |     |
   ||  __  \    \     / / |  .-. ||  ||  '   '  || |  | | |/`.   .'
   ||/'__ '.`.   ` ..' /  | |  | ||  ||  |   |  | \`-' /   `.|   |
   |:/`  '. '  '-...-'`   | |  | ||  ||  |   |  | /("'`     ||___|
   ||     | |             | |  '- |  ||  |   |  | \ '---.   |/___/
   ||\    / '             | |     |__||  |   |  |  /'""'.\  .'.--.
   |/\'..' /              | |         |  |   |  | ||     ||| |    |
   '  `'-'`               |_|         |  |   |  | \'. __// \_\    /
                                      '--'   '--'  `'---'   `''--'
END

   my $demo_banner_3=<<'END';print "LINE=".__LINE__."\n";

                        (                   (        )   ____
                        )\ )   (     (      )\ )  ( /(  |   /
                       (()/(   )\    )\    (()/(  )\()) |  /
                        /(_))(((_)((((_)(   /(_))((_)\  | /
                       (_))  )\___ )\ _ )\ (_)) __ ((_) |/
           ___ _ _     / __|((/ __|(_)_\(_)| _ \\ \ / /(
          / _ \ '_|    \__ \ | (__  / _ \  |   / \ V / )\
          \___/_|      |___/  \___|/_/ \_\ |_|_\  |_| ((_)


 BECAUSE you don't have to . . .

  ____ ____ ____ ____ ____ ____ ____ ____     ___     _ _   _       _
 ||R |||E |||M |||E |||M |||B |||E |||R ||   | __|  _| | | /_\ _  _| |_  | 
 ||__|||__|||__|||__|||__|||__|||__|||__||   | _| || | | |/ _ \ || |  _/ | \
 |/__\|/__\|/__\|/__\|/__\|/__\|/__\|/__\|   |_| \_,_|_|_/_/ \_\_,_|\__\___/©
  ____ ____ ____ ____ ____ ____ ____ ____
 ||C |||O |||M |||M |||A |||N |||D |||S ||    _  _  __ __  ______   _
 ||__|||__|||__|||__|||__|||__|||__|||__||   | \/ \|_ (_    |  |   |_||  |  
 |/__\|/__\|/__\|/__\|/__\|/__\|/__\|/__\|   |_/\_/|____)  _|_ |   | ||__|__
END

   my $demo_banner_4=<<'END';print "LINE=".__LINE__."\n";

    ___     _ _   _       _
   | __|  _| | | /_\ _  _| |_  | 
   | _| || | | |/ _ \ || |  _/ | \
   |_| \_,_|_|_/_/ \_\_,_|\__\___/©

      _  _   _ _____ ___  __  __   _ _____ ___ ___
     /_\| | | |_   _/ _ \|  \/  | /_\_   _| __/ __|
    / _ \ |_| | | || (_) | |\/| |/ _ \| | | _|\__ \
   /_/ \_\___/  |_| \___/|_|  |_/_/ \_\_| |___|___/  THE

    #####   ###     #####   ##  ## #####     FASTER,
   #######  ###    ### ### ### ###  #####    EASIER,
   ### # #  ###    ### ### ### ###  ## ###   with more,
   ##      ###     ##   ## ##  ###  ##  ##   VISIBILITY,
   ##      ###     ##   ## ###  ## ###  ##   more PRECISION,
   ### # # ### ### ### ### ### ### ### ###   more CUSTOMIZABLE,
   ####### ####### ####### ####### ######    LESS COST, and MORE RESULTS than
    #####   #####   #####   #####  #####     any other technology AVAILABLE!!

END

   my $demo_banner_5=<<'END';print "LINE=".__LINE__."\n";


     __    _____ _____ / __    '########::'########::::'###::::'##:::::::
     ||    ||==   ||    ((      ##.... ##: ##.....::::'## ##::: ##:::::::
     ||__| ||___  ||   \_))     ##:::: ##: ##::::::::'##:. ##:: ##:::::::
                                ########:: ######:::'##:::. ##: ##:::::::
      ____  _____ _____         ##.. ##::: ##...:::: #########: ##:::::::
     (( ___ ||==   ||           ##::. ##:: ##::::::: ##.... ##: ##:::::::
      \\_|| ||___  ||           ##:::. ##: ########: ##:::: ##: ########:
                               ..:::::..::........::..:::::..::........:: 

   The *CLOUD* is nothing more than REMOTE DEVICES. FULL Automation of
   the *CLOUD* means FULL remote control of these devices. To achieve
   that, a tool requires FULL, PERSISTENT and SECURE access to a remote
   device's command-line environment. Computer Professionals typically
   use tools like SSH (Secure Shell) and SFTP (Secure FTP) to gain full
   access to remote command-line environments. These utilities are already
   installed on billions of devices globally, or can be easily installed
   for FREE on nearly EVERY network connected device in existence -
   including smart phones and tablets!
END

   my $demo_banner_6=<<'END';print "LINE=".__LINE__."\n";

        ___     _ _   _       _
       | __|  _| | | /_\ _  _| |_  | 
       | _| || | | |/ _ \ || |  _/ | \
   THE |_| \_,_|_|_/_/ \_\_,_|\__\___/©
    ______                    _           _                            _
   (____  \                  | |      _  | |                          | |
    ____)  ) ____ _____ _____| |  _ _| |_| |__   ____ ___  _   _  ____| |__
   |  __  ( / ___) ___ (____ | |_/ |_   _)  _ \ / ___) _ \| | | |/ _  |  _ \
   | |__)  ) |   | ____/ ___ |  _ (  | |_| | | | |  | |_| | |_| ( (_| | | | |
   |______/|_|   |_____)_____|_| \_)  \__)_| |_|_|   \___/|____/ \___ |_| |_|
                                                                (_____|

   Current automation technologies do not typically use generic and readily
   available utilities designed for human interaction - like the command
   shell you are now using for this demonstration. Rather they rely on an
   architecture known as client-server. The problem with client-server is
   that special (and often VERY costly) software needs to be installed on
   *EVERY* device BEFORE it can be accessed and automated. This very
   requirement is one of the biggest productivity obstables to rapid
   automation implementation. Additionally, client-server setups are much
   more complex, fragile, and challenging to code and maintain than FullAuto!
END

   my $demo_banner_7=<<'END';print "LINE=".__LINE__."\n";

        ___     _ _   _       _
       | __|  _| | | /_\ _  _| |_  |
       | _| || | | |/ _ \ || |  _/ | \
   THE |_| \_,_|_|_/_/ \_\_,_|\__\___/©
       ____  _ ________
      / __ \(_) __/ __/__  ________  ____  ________
     / / / / / /_/ /_/ _ \/ ___/ _ \/ __ \/ ___/ _ \
    / /_/ / / __/ __/  __/ /  /  __/ / / / /__/  __/
   /_____/_/_/ /_/  \___/_/   \___/_/ /_/\___/\___/

   FullAuto uses already available SSH and SFTP services to FULLY automate
   command operations on remote devices. The DIFFERENCE lies in *HOW* FullAuto
   connects to and uses these services. Unlike any other technology, FullAuto
   creates and maintains a PERSISENT connection via these protocols, and
   even older ones like TELNET and FTP. Current SSH 2.0 implementations can
   be configured to allow similar behavior, but it varies from device to
   device, and is not widely available. FullAuto has NO such dependency. If
   a SSH client (or TELNET or SFTP or FTP) of ANY kind can connect to the
   device, FUllAuto can connect to it as well - PERSISTENTLY.

END

   my $demo_banner_8=<<'END';print "LINE=".__LINE__."\n";

    ___     _ _   _       _
   | __|  _| | | /_\ _  _| |_  |
   | _| || | | |/ _ \ || |  _/ | \
   |_| \_,_|_|_/_/ \_\_,_|\__\___/©
    __    __ _              _____ _                  _   _
   / / /\ \ \ |__  _   _    \_   \ |_    /\/\   __ _| |_| |_ ___ _ __ ___
   \ \/  \/ / '_ \| | | |    / /\/ __|  /    \ / _` | __| __/ _ \ '__/ __|
    \  /\  /| | | | |_| | /\/ /_ | |_  / /\/\ \ (_| | |_| ||  __/ |  \__ \
     \/  \/ |_| |_|\__, | \____/  \__| \/    \/\__,_|\__|\__\___|_|  |___/
                   |___/
 
   For the very first time, there is now an automation tool that works just
   like computer professionals do. The very same commands and work-flows
   that professionals use every day can now be introduced almost verbatim
   into a FullAuto custom code file, and work precisely the same as if
   performed manually. FullAuto leverages the skillsets and legacy tools
   and scripts already in place in countless organizations all over the
   world - and simply connects them ALL together like never before. The
   result is faster automation implementation, eaiser maintainability, and
   significantly lower costs. Staff will spend less time on repetitive
   tasks, and more time on innovation.
END

   my $demo_banner_9=<<'END';print "LINE=".__LINE__."\n";

    ___     _ _   _       _
   | __|  _| | | /_\ _  _| |_  |
   | _| || | | |/ _ \ || |  _/ | \
   |_| \_,_|_|_/_/ \_\_,_|\__\___/©
      _             _   __    __ _                 __               ___
     /_\  _ __   __| | / / /\ \ \ |__  _   _    /\ \ \_____      __/ _ \
    //_\\| '_ \ / _` | \ \/  \/ / '_ \| | | |  /  \/ / _ \ \ /\ / /\// /
   /  _  \ | | | (_| |  \  /\  /| | | | |_| | / /\  / (_) \ V  V /   \/
   \_/ \_/_| |_|\__,_|   \/  \/ |_| |_|\__, | \_\ \/ \___/ \_/\_/    ()
                                       |___/

   False assumptions. The "experts" thought a tool like FullAuto was not
   possible. The assumption was because output from a generic connection
   could have INFINITE variation (TRUE), that there was "no way" to create
   a solution that could successfully separate transmission noise from
   valid command-line output and error output (which makes unpredictable
   appearances in the output). Running one command programmatically has
   never been an issue - but the goal of running MULTIPLE commands
   INTERACTIVELY over a PERSISENT "generic" (i.e., not client-server)
   connection - was assumed to be **impossible**. (FALSE!!)

END

   my $demo_banner_10=<<'END';print "LINE=".__LINE__."\n";

    ___     _ _   _       _
   | __|  _| | | /_\ _  _| |_  |      ___    __   __     _  __ _ ___ __ 
   | _| || | | |/ _ \ || |  _/ | \     | |_||_   |_  \/ |_)|_ |_) | (_
   |_| \_,_|_|_/_/ \_\_,_|\__\___/©    | | ||__  |__ /\ |  |__| \ | __)

   __      _____ ___ ___     _      _____  ____  _  _______  __ 
   \ \    / / __| _ \ __|   | | /| / / _ \/ __ \/ |/ / ___/ / /
    \ \/\/ /| _||   / _|    | |/ |/ / , _/ /_/ /    / (_-- /_/
     \_/\_/ |___|_|_\___|   |__/|__/_/|_|\____/_/|_/\____/(_)


   Not the first time in history this has happened. There is no technical
   reason that a tool like FullAuto could not have been created 30 years
   ago, but for the false belief that it wasn't possible. Experts will
   generally not spend their time trying to solve "impossible" problems.
   Not until Brian Kelly has anyone apparently thought any differently.
   Brian conceived of FullAuto as early as 1998, and began active
   development in 2000. However, it would take 15 LONG years to make it
   a reality. The experts were wrong - but they weren't crazy. The
   problem was not trivial, and the solution is not either!

END

   my $demo_banner_11=<<'END';print "LINE=".__LINE__."\n";

   People typically use utilities like SSH and SFTP to access the
   command-line environments of remote devices. These utilities are
   already installed on millions of devices globally, or can be easily
   installed for FREE on mearly EVERY networked device - including phones
   and tablets.

   Programs however, typically rely on client-server architecture,
   which requires that special software be installed on *EVERY*
   device BEFORE it can be accessed and automated.

   "Technically", ssh and sftp are also "client-server". The critical
   difference is that these programs are *NOT* "special".



   As long as a device can be remotely connected to via ssh, sftp,
   telnet, ftp, http or really, ANY remote computing protocol,
   FullAuto can completely automate any and all activities on that
   device, and other devices all simultaneously and persistently.

   Essentially, whatever a person can do on and with a device
   "manually" - FullAuto can do PROGRAMMATICALLY ... securely.

END

   my %fullauto_demo_10=(

      Name => 'fullauto_demo_10',
      Banner => $demo_banner_10,
      Result => sub { return '{fullauto_demo}<' },

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_9=(

      Name => 'fullauto_demo_9',
      Banner => $demo_banner_9,
      Result => \%fullauto_demo_10,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_8=(

      Name => 'fullauto_demo_8',
      Banner => $demo_banner_8,
      Result => \%fullauto_demo_9,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_7=(

      Name => 'fullauto_demo_7',
      Banner => $demo_banner_7,
      Result => \%fullauto_demo_8,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_6=(

      Name => 'fullauto_demo_6',
      Banner => $demo_banner_6,
      Result => \%fullauto_demo_7,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_5=(

      Name => 'fullauto_demo_5',
      Banner => $demo_banner_5,
      Result => \%fullauto_demo_6,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_4=(

      Name => 'fullauto_demo_4',
      Banner => $demo_banner_4,
      Result => \%fullauto_demo_5,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_3=(

      Name => 'fullauto_demo_3',
      Banner => $demo_banner_3,
      Result => \%fullauto_demo_4,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_2=(

      Name => 'fullauto_demo_2',
      Banner => $demo_banner_2,
      Result => \%fullauto_demo_3,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo_1=(

      Name => 'fullauto_demo_1',
      Banner => $demo_banner_1,
      Result => \%fullauto_demo_2,

   );print "LINE=".__LINE__."\n";

   my %fullauto_demo=(

      Name => 'fullauto_demo',
      Item_1 => {
     
         Text => "FullAuto Introduction",
         Result => \%fullauto_demo_1,

      },
      Item_2 => {

         Text => "FullAuto Demonstration",

      },
      Scroll => 1,
      Banner => $demo_banner,

   );print "LINE=".__LINE__."\n";

   if (-1<index lc($0), 'demo') {

      my $demo_out=Menu(\%fullauto_demo);print "LINE=".__LINE__."\n";
      print "DONE WITH DEMO\n";<STDIN>;print "LINE=".__LINE__."\n";
      exit;print "LINE=".__LINE__."\n";
   }

   my $cryptography_banner=<<'END';print "LINE=".__LINE__."\n";
   __      __             _           _
   \ \    / /_ _ _ _ _ _ (_)_ _  __ _| |
    \ \/\/ / _` | '_| ' \| | ' \/ _` |_|
     \_/\_/\__,_|_| |_||_|_|_||_\__, (_)
                                |___/

   Exporting, importing and/or using cryptography software, or even
   communicating technical details about cryptography software, is illegal
   in some parts of the world. You are strongly advised to investigate and
   adhere to any export/import and use laws which apply to you when you
   import a release of Net::FullAuto including cryptography modules like
   Crypt::CBC, Crypt::DES and Crypt::Rijndael to your country or
   re-distribute source code from them in any way.

   This website may be a helpful resource:   http://www.cryptolaw.org

   It surveys cryptography laws from around the world. However, consult
   local legal experts before engaging in any potentially risky activity. 
END

   my $cryptography=sub {

      my %cryptography=(

         Name => 'cryptography',
         Result => sub { return '{license_agree}<' },
         Banner => $cryptography_banner,

      );print "LINE=".__LINE__."\n";
      return \%cryptography

   };print "LINE=".__LINE__."\n";

   my $license_banner=<<END;print "LINE=".__LINE__."\n";

   *THANK YOU* For Trying FullAuto!   Net::FullAuto INSTALLATION PROGRAM

   Copyright (C) 2000-2015   Brian M. Kelly   Brian.Kelly\@FullAuto.com

   This program comes with ABSOLUTELY NO WARRANTY; for details select  2.
   This is free software, and you are welcome to redistribute it under certain
   conditions; select  3  for details. FullAuto uses  Crypt::DES  which is
   software developed by Systemics Ltd (http://www.systemics.com/). FullAuto
   uses the  Net::SSLeay  module which is software developed by the OpenSSL
   Project for use in the OpenSSL Toolkit. (http://www.openssl.org/) and
   includes cryptographic software written by Eric Young (eay\@cryptsoft.com)
   and Tim Hudson (tjh\@cryptsoft.com)

END

   if (-e "dependencies/CPAN/authors" &&
         !(grep {
         /(?:use[-_]?)?internet|online|connect_to_internet_ok/i } @ARGV)) {
      opendir(DH,"dependencies/CPAN/authors/id/F/FR/FREW") ||
         die "Cannot open dir dependencies/CPAN/authors/id/F/FR/FREW: $1\n";print "LINE=".__LINE__."\n";
      my $filenames_not_trunced=0;my $got_sub=0;print "LINE=".__LINE__."\n";
      while (my $line=readdir(DH)) {
         $line=~tr/\0-\11\13-\37\177-\377//d; 
         chomp($line);print "LINE=".__LINE__."\n";
         if ($line=~/Sub-Exporter-Progressive-.*gz$/) {
            $filenames_not_trunced=1;print "LINE=".__LINE__."\n";
            last;print "LINE=".__LINE__."\n";
         }
         if (-1<index $line,'Sub-') {
            $got_sub=1;print "LINE=".__LINE__."\n";
         }
      }
      close DH;print "LINE=".__LINE__."\n";
      unless ($filenames_not_trunced) {
         if ($got_sub) {
            if ($^O eq 'solaris' && (-e '/usr/sfw/bin/gtar')) {
               my $message=<<END;print "LINE=".__LINE__."\n";

   FullAuto Setup ERROR!:  It appears that the solaris system tar
                           command was used to expand
                           Net-FullAuto-Complete-$main::VERSION.tar.gz,
                           which is a problem. The solaris tar utility
                           has a limit on the length of directory depth
                           and filename that is exceeded by some of the
                           dependencies bundled with FullAuto Setup.

                           Use the tar utility /usr/sfw/bin/gtar to
                           expand Net-FullAuto-Complete-$main::VERSION.tar.gz.

END
               print $message;exit 1;print "LINE=".__LINE__."\n";
            } else {
               my $message=<<END;print "LINE=".__LINE__."\n";

   FullAuto Setup ERROR!:  It appears that the tar command used to expand
                           Net-FullAuto-Complete-$main::VERSION.tar.gz,
                           has a problem. Some tar utilities have a limit
                           on the length of directory depth and filename
                           that is exceeded by some of the dependencies
                           bundled with FullAuto Setup.

                           Hint: Install and use GNU tar to untar (expand)
                                 Net-FullAuto-Complete-$main::VERSION.tar.gz.

END
               print $message;exit 1;print "LINE=".__LINE__."\n";
            }
         } else {
              my $message=<<END;print "LINE=".__LINE__."\n";

   FullAuto Setup ERROR!:  It appears that there are missing dependencies
                           in the dependencies/CPAN/authors folder of this
                           Net-FullAuto-Complete distribution.

END
               print $message;exit 1;print "LINE=".__LINE__."\n";
         }
      }
      my $loc="$main::curdir/dependencies/CPAN";print "LINE=".__LINE__."\n";
      $CPAN::Config->{keep_source_where}=$loc;print "LINE=".__LINE__."\n";
      $CPAN::Config->{connect_to_internet_ok}=0;print "LINE=".__LINE__."\n";
      $CPAN::Config->{index_expire}=1000;print "LINE=".__LINE__."\n";
   }
   use File::Path;print "LINE=".__LINE__."\n";

   $main::root_dir=$main::curdir;print "LINE=".__LINE__."\n";

   my $incflag=0;my @drive_options=();print "LINE=".__LINE__."\n";
   $main::uname_a='';print "LINE=".__LINE__."\n";
   my $perl_version=$^V;print "LINE=".__LINE__."\n";
   $perl_version=~s/^v//;print "LINE=".__LINE__."\n";
   $main::uname_a=`/bin/uname -a` if $^O eq 'linux' || $^O eq 'freebsd';print "LINE=".__LINE__."\n";
   if ($^O eq 'cygwin') {
      my $cygcheck=`/bin/cygcheck -c` || die $!;print "LINE=".__LINE__."\n";
      my $uname=`/bin/uname` || die $!;print "LINE=".__LINE__."\n";
      my $uname_all=`/bin/uname -a` || die $!;print "LINE=".__LINE__."\n";
      $uname_all.=$uname;print "LINE=".__LINE__."\n";
      my %need_packages=();print "LINE=".__LINE__."\n";
      if ($uname_all=~/x86_64/) {
         foreach my $package ('gcc-core','gcc-g++','make','openssh','openssl',
                              'openssl-devel','perl','db','libdb-devel',
                              'ncurses','cron','inetutils','procps','vim',
                              'unzip','libmpfr4','libcrypt-devel','nano',
                              'perl-libwww-perl','perl-LWP-Protocol-https',
                              'wget','git','figlet') {
            unless (-1<index $cygcheck, "$package ") {
               $need_packages{$package}='';print "LINE=".__LINE__."\n";
            }
         }
      } else {
         foreach my $package ('gcc-core','gcc-g++','make','openssh','openssl',
                              'openssl-devel','perl','perl-Win32','db4.8',
                              'libdb4.8-devel','ncurses','cron','inetutils',
                              'procps','vim','unzip','libmpfr4','nano',
                              'wget','git','figlet') {
            unless (-1<index $cygcheck, "$package ") {
               $need_packages{$package}='';print "LINE=".__LINE__."\n";
            }
         }
      }
      if (keys %need_packages) {
         my $packs='';print "LINE=".__LINE__."\n";
         foreach my $pack (sort keys %need_packages) {
            $packs.="$pack ";print "LINE=".__LINE__."\n";
         }
         if ($packs) {
            print "\n\n   Fatal Error!: The following Cygwin",
                  "\n                 packages are missing from",
                  "\n                 your installation:",
                  "\n\n   $packs",
                  "\n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n";print "LINE=".__LINE__."\n";
                  <STDIN> if $ENV{PAR_TEMP};print "LINE=".__LINE__."\n";
                  exit 1;print "LINE=".__LINE__."\n";
         }
      }
      my $services=`ps -e` || die $!;print "LINE=".__LINE__."\n";
      my @required_cygwin_services=();print "LINE=".__LINE__."\n";
      foreach my $cygwin_service ('cygserver') {
         push @required_cygwin_services, $cygwin_service
            if -1==index $services,$cygwin_service;print "LINE=".__LINE__."\n";
      } 
      if (-1<$#required_cygwin_services) {
         my $services='';print "LINE=".__LINE__."\n";
         foreach my $service (sort @required_cygwin_services) {
            $services.="      $service\n";print "LINE=".__LINE__."\n";
         }
         if ($services) {
            print "\n\n   Fatal Error!: The following Cygwin ".
                  "services are not running on your system:".
                  "\n\n$services".
                  "\n\n   The FullAuto installation will not".
                  "\n   succeed without these services installed".
                  "\n   and running.".
                  "\n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n";print "LINE=".__LINE__."\n";
                  <STDIN> if $ENV{PAR_TEMP};print "LINE=".__LINE__."\n";
                  exit 1;print "LINE=".__LINE__."\n";
         }
      }
      if (!check_for_compiler()) {
         if ($Config{cc} && $Config{cc}=~/gcc-4/) {
            `cd /usr/bin;ln -s gcc.exe gcc-4`;print "LINE=".__LINE__."\n";
            `cd /usr/bin;ln -s g++.exe g++-4;cd $main::cwd`;print "LINE=".__LINE__."\n";
         } else {
            my $stup='setup-x86.exe';print "LINE=".__LINE__."\n";
            $stup='setup-x86_64.exe' if $uname=~/WOW64/ || msw64bit();print "LINE=".__LINE__."\n";
            my $die=<<END;print "LINE=".__LINE__."\n";

       FATAL ERROR! : The Gnu C Compiler 'gcc': gcc-core
                      & gcc-g++ as provided by Cygwin
                      is required to install FullAuto
                      on Windows.

       ( Hint: Run Cygwin $stup and install 'gcc-core'
               and 'gcc-g++' under the Category 'Devel' ).

END
            die $die;print "LINE=".__LINE__."\n";
         }
      }
   } elsif ($^O eq 'MSWin32' || $^O eq 'MSWin64') {
      unless ($ENV{PAR_TEMP}) {
         my $die=<<'END';print "LINE=".__LINE__."\n";

       FATAL ERROR! : Cygwin Linux Emulation Layer
                      is required to use FullAuto
                      on Windows - goto www.cygwin.com.

           Be sure to install the following programs in
           addition to the base package:

           inetutils and openssh [as provided by Cygwin]
           perl [as provided by Cygwin] (*NOT* CPAN)
           perl-Win32 [as provided by Cygwin] (*NOT* CPAN)
           ncurses, cron, and procps [as provided by Cygwin]
           gcc-core and gcc-g++ [as provided by Cygwin]
           Oracle Berkeley DB [as provided by Cygwin or Oracle]

           **IMPORTANT** - the FullAuto install, either manual
           or via CPAN, must be run *inside* a Cygwin bash shell
           when installing FullAuto on Microsoft Windows.

END
         print $die;print "LINE=".__LINE__."\n";
         exit 1;print "LINE=".__LINE__."\n";
      }
      $incflag=1 if -e './inc';print "LINE=".__LINE__."\n";
      use if ($^O eq 'MSWin32' || $^O eq 'MSWin64'), "Win32::DriveInfo";print "LINE=".__LINE__."\n";
      use if ($^O eq 'MSWin32' || $^O eq 'MSWin64'), "Term::Menus";print "LINE=".__LINE__."\n";

      my %read_license=(

         Label => 'read_license',
         Item_1 => {
            Text => "I accept the license provisions",
         },
         Item_2 => {
            Text => "I do *NOT* accept the license provisions ".
                    "(Install will Exit)",
         },
         Item_3 => {

            Text => "]C[",
            Convey => sub {

               my $endcount=30;print "LINE=".__LINE__."\n";
               my @content=();my $tl=0;print "LINE=".__LINE__."\n";
               my $linenumber="]P[";print "LINE=".__LINE__."\n";
               $linenumber||=1;print "LINE=".__LINE__."\n";
               $linenumber=~s/["]//g;print "LINE=".__LINE__."\n";
               my $choice=$linenumber;print "LINE=".__LINE__."\n";
               if (-1==index $linenumber,'Review') {
                  if ($linenumber=~/Next|Previous/) {
                     $linenumber=~s/^(?:Next|Previous) Page\s*//;print "LINE=".__LINE__."\n";
                  }
                  ($linenumber,$endcount)=split '-', $linenumber;print "LINE=".__LINE__."\n";
                  open (FH,"<$main::PARdir/inc/LICENSE")
                     or die "Cannot open $main::PARdir/inc/LICENSE: $!\n";print "LINE=".__LINE__."\n";
                  @content=<FH>;print "LINE=".__LINE__."\n";
                  close FH;print "LINE=".__LINE__."\n";
                  $tl=$#content+1;print "LINE=".__LINE__."\n";
                  my $lt=$linenumber+13;print "LINE=".__LINE__."\n";
                  $endcount=($lt<$tl)?$lt:$tl;print "LINE=".__LINE__."\n";
               } elsif (-1<index $linenumber,'WARRANTY') {
                  $linenumber=588;print "LINE=".__LINE__."\n";
                  $endcount=597;print "LINE=".__LINE__."\n";
               } else { $linenumber=1 }
               my $ec=$endcount-1;print "LINE=".__LINE__."\n";
               if (-1==index $choice,'WARRANTY') {
                  if ($ec == $#content) {
                     my $lm=$linenumber-13;print "LINE=".__LINE__."\n";
                     return ("Previous Page $lm-$linenumber");print "LINE=".__LINE__."\n";
                  } elsif ($linenumber==1) {
                     my $lo=$linenumber+13;print "LINE=".__LINE__."\n";
                     my $ln=$lo+13;print "LINE=".__LINE__."\n";
                     return ("Next Page $lo-$ln");print "LINE=".__LINE__."\n";
                  } else {
                     my $lo=$linenumber+13;print "LINE=".__LINE__."\n";
                     my $ln=$lo+29;print "LINE=".__LINE__."\n";
                     my $el=$linenumber-1;print "LINE=".__LINE__."\n";
                     my $pl=$linenumber-13;print "LINE=".__LINE__."\n";
                     return ("Next Page $lo-$ln","Previous Page $pl-$el");print "LINE=".__LINE__."\n";
                  }
               }
            },
            Result => { 'read_license'=>'recurse' },

         },
         Item_4 => {
            Text => "Return to previous screen",
            Result => sub { return '{license_agree}<' },
         },
         Banner => sub {
               my $linenumber="]P[";print "LINE=".__LINE__."\n";
               $linenumber||=1;print "LINE=".__LINE__."\n";
               $linenumber=~s/["]//g;print "LINE=".__LINE__."\n";
               open (FH,"<$main::PARdir/inc/LICENSE")
                  or die "Cannot open $main::PARdir/inc/LICENSE: $!\n";print "LINE=".__LINE__."\n";
               my @content=<FH>;print "LINE=".__LINE__."\n";
               close FH;print "LINE=".__LINE__."\n";
               my $co=$#content+1;print "LINE=".__LINE__."\n";
               my $endcount=(13<$co)?13:$co;print "LINE=".__LINE__."\n";
               if (-1==index $linenumber,'Review') {
                  if ($linenumber=~/Next|Previous/) {
                     $linenumber=~s/^(?:Next|Previous) Page\s*//;print "LINE=".__LINE__."\n";
                  }
                  ($linenumber,$endcount)=split '-', $linenumber;print "LINE=".__LINE__."\n";
                  my $tl=$#content+1;print "LINE=".__LINE__."\n";
                  my $lt=$linenumber+13;print "LINE=".__LINE__."\n";
                  $endcount=($lt<$tl)?$lt:$tl;print "LINE=".__LINE__."\n";
               } elsif (-1<index $linenumber,'WARRANTY') {
                  $linenumber=588;print "LINE=".__LINE__."\n";
                  $endcount=597;print "LINE=".__LINE__."\n";
               } else { $linenumber=1 }
               $linenumber=0 if $linenumber==1;print "LINE=".__LINE__."\n";
               --$endcount;print "LINE=".__LINE__."\n";
               my $banner=join "", @content[$linenumber..$endcount];print "LINE=".__LINE__."\n";
               $banner=~s/^/   /mg;print "LINE=".__LINE__."\n";
               return $banner;print "LINE=".__LINE__."\n";
            }

      );print "LINE=".__LINE__."\n";

      my %license_agree=(

         Name => 'license_agree',
         Item_1 => {

            Text => "I agree to the license provisions\n\n",

         },
         Item_2 => {

            Text => "Review GNU Affero Public License WARRANTY DISCLAIMER\n",
            Result => \%read_license,

         },
         Item_3 => {

            Text => "*IMPORTANT* STRONG CRYPTOGRAPHY WARNING!",
            Result => $cryptography,

         },
         Item_4 => {

            Text => "I DO NOT AGREE to the license provisions\n".
                    "                   ( FullAuto Install will EXIT )",
         },
         Scroll => 1,
         Banner => $license_banner,

      );print "LINE=".__LINE__."\n";

      my $lic_sel=Menu(\%license_agree);print "LINE=".__LINE__."\n";
      chomp($lic_sel);print "LINE=".__LINE__."\n";
      exit if $lic_sel eq ']quit[';print "LINE=".__LINE__."\n";
      if (-1<index $lic_sel, 'NOT') {
         print "\n\n   You have elected *NOT* to install FullAuto.",
               "\n\n   Please report any bugs and send any",
               "\n   questions, thoughts or feedback to:",
               "\n\n      Brian.Kelly\@FullAuto.com.",
               "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
         exit;print "LINE=".__LINE__."\n";
      }
      my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
      if ($cygwin_loc) {
         my $drv=substr($cygwin_loc,0,1);print "LINE=".__LINE__."\n";
         my $dt=Win32::DriveInfo::DriveType($drv);print "LINE=".__LINE__."\n";
         my $FileSystemName=(Win32::DriveInfo::VolumeInfo($drv))[3];print "LINE=".__LINE__."\n";
         my $file_size = (Win32::DriveInfo::DriveSpace("$drv:"))[6];print "LINE=".__LINE__."\n";
         my $banner=<<'END';print "LINE=".__LINE__."\n";

    ___                     _            _     _
   |_ _|_ __  _ __  ___ _ _| |_ __ _ _ _| |_  | |
    | || '  \| '_ \/ _ \ '_|  _/ _` | ' \  _| |_|
   |___|_|_|_| .__/\___/_|  \__\__,_|_||_\__| (_)
             |_|
END
   my $size_file=&size_fmt($file_size);print "LINE=".__LINE__."\n";
         $banner.=<<END;print "LINE=".__LINE__."\n";

   FullAuto Setup has detected a Cygwin installation at $cygwin_loc.
   Setup has also determined that there is $size_file Free Space on
   the Drive $drv Volume. It is IMPORTANT TO NOTE that FullAuto Setup
   will attempt to use this installation. If this is undesirable, then
   select choice '2' and FullAuto Setup will EXIT. It is recommended
   that you use the cpan utility to install or update FullAuto, if
   there is more than one Cygwin installation on your system.

   If you're sure you wish to proceed with your $cygwin_loc setup,
   then select choice '1' and FullAuto Setup will continue . . .

END
         my %cygchoice=(

               Label => 'cygchoice',
               Item_1 => {
                  Text => 'Continue with FullAuto Setup',
               },
               Item_2 => {
                  Text => 'CANCEL FullAuto Setup and EXIT',
               },
               Scroll => 1,
               Banner => $banner,
         );print "LINE=".__LINE__."\n";
         my $selection=Menu(\%cygchoice);print "LINE=".__LINE__."\n";
         chomp($selection);print "LINE=".__LINE__."\n";
         if (-1<index $selection,'Continue') {
            my $cwd=cwd();print "LINE=".__LINE__."\n";
            my $p='/usr/bin/perl -MCPAN -e';print "LINE=".__LINE__."\n";
            my $b="$cygwin_loc/bin/bash -lc";print "LINE=".__LINE__."\n";
            exec "$b \"$p 'install Net::FullAuto'\";'fa --new-user'";print "LINE=".__LINE__."\n";
         }
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
         exit if $selection eq 'CANCEL FullAuto Setup and EXIT';print "LINE=".__LINE__."\n";
         $main::root_dir=$cygwin_loc;print "LINE=".__LINE__."\n";
      } else {
         my $drv='';print "LINE=".__LINE__."\n";
         foreach my $d (Win32::DriveInfo::DrivesInUse()) {
            my $dt=Win32::DriveInfo::DriveType($d);print "LINE=".__LINE__."\n";
            next if $dt == 5 || $dt == 4 || !$dt;print "LINE=".__LINE__."\n";
            my $FileSystemName=(Win32::DriveInfo::VolumeInfo($d))[3];print "LINE=".__LINE__."\n";
            next if $FileSystemName ne 'NTFS';print "LINE=".__LINE__."\n";
            my $file_size = (Win32::DriveInfo::DriveSpace("$d:"))[6];print "LINE=".__LINE__."\n";
            my $one_gb=1024*1024*1024;print "LINE=".__LINE__."\n";
            if ($one_gb<$file_size) {
               $drv=$d;print "LINE=".__LINE__."\n";
               if ($dt == 3) {
                  push @drive_options, "Drive $d NTFS Fixed Disk ".
                                        &size_fmt($file_size)." Free Space";print "LINE=".__LINE__."\n";
               } elsif ($dt == 2) {
                  push @drive_options, "Drive $d NTFS Removeable Disk ".
                                        &size_fmt($file_size)." Free Space";print "LINE=".__LINE__."\n";
               } else {
                  push @drive_options, "Drive $d NTFS Volume ".
                                        &size_fmt($file_size)." Free Space";print "LINE=".__LINE__."\n";
               }
            }
         }
         if (-1<$#drive_options) {
            if (0==$#drive_options) {
               if ($^O eq 'MSWin64' || msw64bit()) {
                  $main::root_dir="$drv:\\cygwin64";print "LINE=".__LINE__."\n";
               } else {
                  $main::root_dir="$drv:\\cygwin";print "LINE=".__LINE__."\n";
               }
            } else{
               my $banner="\n\n   Please select the Drive/Volume where you ".
                          "would like\n   Cygwin and FullAuto Installed.\n".
                          "\n   ( If you don't see the Drive/Volume you ".
                          "desire,\n     it is probably because the Drive/".
                          "Volume lacks\n     sufficient disk space. At ".
                          "least One Gigabyte\n     of free space is needed ".
                          "for a Windows based\n     Cygwin/FullAuto ".
                          "Installation. )\n\n";print "LINE=".__LINE__."\n";
               my %menu_drives=(

                  Label => 'menu_drives',
                  Item_1 => {

                     Text => "]C[",
                     Convey => \@drive_options,

                  },
                  Banner => $banner,

               );print "LINE=".__LINE__."\n";
               my $selection=Menu(\%menu_drives);print "LINE=".__LINE__."\n";
               chomp($selection);print "LINE=".__LINE__."\n";
               exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
               $selection=~s/^\s*Drive\s+([A-Z])\s+NTFS.*$/$1/s;print "LINE=".__LINE__."\n";
               if ($^O eq 'MSWin64' || msw64bit()) {
                  $main::root_dir="$selection:\\cygwin64";print "LINE=".__LINE__."\n";
               } else {
                  $main::root_dir="$selection:\\cygwin";print "LINE=".__LINE__."\n";
               }
            }
         } else {
            print "\n\n   Fatal Error! - Insufficient Disk Space.\n".
                  "                 At least One Gigabyte (1.0 GB) of\n".
                  "                 Free Disk Space is needed to install\n".
                  "                 Cygwin and FullAuto on this Windows\n".
                  "                 host.".
                  "n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
      }
   } elsif (!check_for_compiler() && ((exists $main::amazon{'ami'}) ||
         (exists $main::amazon{'rhel'}) ||
         (exists $main::amazon{'centos'}))) {

      my $grpi=`sudo yum grouplist`;print "LINE=".__LINE__."\n";
      if (-1<index $grpi,'no installed groups file') {
         my $out=`sudo yum groups mark convert`;print "LINE=".__LINE__."\n";
         $grpi=`sudo yum grouplist`;print "LINE=".__LINE__."\n";
      }
      my %groups=();my $group_type='';print "LINE=".__LINE__."\n";
      foreach my $ln (split "\n",$grpi) {
         if ($ln=~/^(.*) [Gg]roups:$/) {
            $group_type=$1;print "LINE=".__LINE__."\n";
            $groups{$group_type}={};print "LINE=".__LINE__."\n";
         } else {
            $ln=~/^\s*(.*)$/;print "LINE=".__LINE__."\n";
            $groups{$group_type}->{$1}='';print "LINE=".__LINE__."\n";
         }
      }
      my $yins=`sudo yum list installed`;print "LINE=".__LINE__."\n";
      unless (exists $groups{'Installed'}->{'Development tools'}) {
         open(AG,"sudo yum -y update|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
         open(AG,"sudo yum -y clean all|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
         open(AG,"sudo yum -y groupinstall 'Development tools'|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
      }
      unless (-1<index $yins,'openssl-devel') {
         open(LD,"sudo yum -y install 'openssl-devel'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      if ((exists $main::amazon{'rhel'}) ||
            (exists $main::amazon{'centos'})) {
         unless (-1<index $yins,'wget') {
            open(LD,"sudo yum -y install 'wget'|");print "LINE=".__LINE__."\n";
            while (my $line=<LD>) {
               print $line;print "LINE=".__LINE__."\n";
            }
            close LD;print "LINE=".__LINE__."\n";
         }
         my $wget_url='http://pkgs.repoforge.org/rpmforge-release/'.
                      'rpmforge-release-0.5.3-1.el6.rf.x86_64.rpm';print "LINE=".__LINE__."\n";
         #my=$wget_url='http://dl.fedoraproject.org/pub/epel/beta/7'.
         #             '/x86_64/epel-release-7-0.2.noarch.rpm';print "LINE=".__LINE__."\n";
         open(LD,"sudo wget $wget_url|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
         #my $rpm='epel-release-7-0.2.noarch.rpm';print "LINE=".__LINE__."\n";
         my $rpm='rpmforge-release-0.5.3-1.el6.rf.x86_64.rpm';print "LINE=".__LINE__."\n";
         open(LD,"sudo rpm -ivh $rpm|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
         open(LD,"sudo rpm --import http://apt.sw.be/RPM-GPG-KEY.dag.txt|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      unless (-1<index $yins,'figlet') {
         open(LD,"sudo yum -y install 'figlet'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      unless (-1<index $yins,'nano') {
         open(LD,"sudo yum -y install 'nano'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      my $argvs=join " ", @ARGV;print "LINE=".__LINE__."\n";
      exec "sudo $^X Makefile.PL $argvs";print "LINE=".__LINE__."\n";
   } elsif (exists $main::amazon{'centos'}) {

      my $yins=`yum list installed`;print "LINE=".__LINE__."\n";
      unless (-1<index $yins,'openssl-devel') {
         open(LD,"sudo yum -y install 'openssl-devel'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            if (-1<index $line,"allocate") {
print "YEP MEMORY=$line\n";<STDIN>;print "LINE=".__LINE__."\n";
            }
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      my $new_wget=0;print "LINE=".__LINE__."\n";
      unless (-1<index $yins,'wget') {
         $new_wget=1;print "LINE=".__LINE__."\n";
         open(LD,"sudo yum -y install 'wget'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      if ($new_wget) {
         my $wget_url='http://pkgs.repoforge.org/rpmforge-release/'.
                      'rpmforge-release-0.5.3-1.el6.rf.x86_64.rpm';print "LINE=".__LINE__."\n";
         #my=$wget_url='http://dl.fedoraproject.org/pub/epel/beta/7'.
         #             '/x86_64/epel-release-7-0.2.noarch.rpm';print "LINE=".__LINE__."\n";
         open(LD,"sudo wget $wget_url|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
         #my $rpm='epel-release-7-0.2.noarch.rpm';print "LINE=".__LINE__."\n";
         my $rpm='rpmforge-release-0.5.3-1.el6.rf.x86_64.rpm';print "LINE=".__LINE__."\n";
         open(LD,"sudo rpm -ivh $rpm|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
         open(LD,"sudo rpm --import http://apt.sw.be/RPM-GPG-KEY.dag.txt|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      unless (-1<index $yins,'figlet') {
         open(LD,"sudo yum -y install 'figlet'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      unless (-1<index $yins,'nano') {
         open(LD,"sudo yum -y install 'nano'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      my $argvs=join " ", @ARGV;print "LINE=".__LINE__."\n";
      exec "sudo $^X Makefile.PL $argvs";print "LINE=".__LINE__."\n";

   } elsif (!check_for_compiler() && (exists $main::amazon{'suse'})) {

      # Manual Setup openSuSE host before CPAN:
      #
      # zypper ar -f -n openSUSE:13.1 http://download.opensuse.org/distribution/13.1/repo/oss/ openSUSE:13.1
      # zypper -n --gpg-auto-import-keys install --force-resolution wget
      # zypper -n --gpg-auto-import-keys install --force-resolution figlet
      # zypper -n --gpg-auto-import-keys install --force-resolution nano
      # zypper -n install --type pattern Basis-Devel
      # zypper -n install openssl-devel
      # wget http://www.cpan.org/src/5.0/perl-5.20.0.tar.gz
      # tar zxvf perl-5.20.0.tar.gz
      # cd perl-5.20.0
      # ./Configure -d -Dnoextensions=ODBM_File
      # make install
      # cpan
      #

      my $zypper=`/bin/zypper packages -i`;print "LINE=".__LINE__."\n";
      if (0 && -1==index $zypper,'gcc') {
         open(ZP,"zypper -n install --type pattern Basis-Devel|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close ZP;print "LINE=".__LINE__."\n";
         open(ZP,"zypper -n install openssl-devel|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close ZP;print "LINE=".__LINE__."\n";
         my $repos='zypper ar -f -n openSUSE:13.1 '.
                   'openSUSE:13.1 http://download.'.
                   'opensuse.org/distribution/13.1'.
                   '/repo/oss/  openSUSE:13.1';print "LINE=".__LINE__."\n";
         open(ZP,"$repos|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close ZP;print "LINE=".__LINE__."\n";
         my $figlet="zypper -n --gpg-auto-import-keys install".
                    " --force-resolution figlet";print "LINE=".__LINE__."\n";
         open(ZP,"$figlet|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close ZP;print "LINE=".__LINE__."\n";
         my $nano="zypper -n --gpg-auto-import-keys install".
                    " --force-resolution nano";print "LINE=".__LINE__."\n";
         open(ZP,"$nano|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close ZP;print "LINE=".__LINE__."\n";
      }
         
   } elsif (!check_for_compiler() && (exists $main::amazon{'ubuntu'})) {

      my $dpkg=`/bin/dpckg -l`;print "LINE=".__LINE__."\n";
      my $update_flag=0;print "LINE=".__LINE__."\n";
      if (-1==index $dpkg,'build-essential') {
         open(AG,"sudo apt-get -y update|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
         $update_flag==1;print "LINE=".__LINE__."\n";
         open(AG,"sudo apt-get -y install 'build-essential'|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
      }
      if (-1==index $dpkg,'libssl-dev') {
         unless ($update_flag) {
            open(AG,"sudo apt-get -y update|");print "LINE=".__LINE__."\n";
            while (my $line=<AG>) {
               print $line;print "LINE=".__LINE__."\n";
            }
         }
         open(LD,"sudo apt-get -y install 'libssl-dev'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      if (-1==index $dpkg,'figlet') {
         open(LD,"sudo apt-get -y install 'figlet'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      if (-1==index $dpkg,'nano') {
         open(LD,"sudo apt-get -y install 'nano'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }
      if (-1==index $dpkg,'perl-doc') {
         open(LD,"sudo apt-get -y install 'perl-doc'|");print "LINE=".__LINE__."\n";
         while (my $line=<LD>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close LD;print "LINE=".__LINE__."\n";
      }

   } elsif (!check_for_compiler()) {

      my $moreinfo='';my $s='          ';print "LINE=".__LINE__."\n";
      if ($Config{cc} and $Config{cc}!~/^\s*$/) {
         $moreinfo="\n\n$s            You are running $^X version $].\n".
              "\n$s            The Config.pm file for this perl installation".
              "\n$s            contains \"$Config{cc}\" as the compiler used".
              "\n$s            to build this perl, but this compiler does not".
              "\n$s            exist in the PATH and may not be installed on".
              "\n$s            this host.\n".
              "\n$s            Retrofitting an existing perl installation to".
              "\n$s            work properly with a new compiler for building".
              "\n$s            CPAN modules, is tricky and NOT recommended.".
              "\n$s            Often the available perl (especially on Unix".
              "\n$s            systems) is highly integrated with the host".
              "\n$s            OS and many of its features and utilities.".
              "\n$s            Upgrading the system perl, but not the overall".
              "\n$s            OS is risky and may result in more than a".
              "\n$s            few system problems and instabilities.\n".
              "\n$s            The recommended approach is build a NEW perl".
              "\n$s            from source with your choice of newly installed".
              "\n$s            compiler (such as gcc) in a different location".
              "\n$s            (such as /usr/local/lib) or your home directory".
              "\n$s            if you lack root/admin privileges."
      }
      my $die="\n       FATAL ERROR! : A C Compiler (such as cc or gcc)".
              "\n                      is required to install FullAuto".
              $moreinfo.
              "\n                      (Hint: goto www.gnu.org for gcc).".
              "\n\n";print "LINE=".__LINE__."\n";
      die $die;print "LINE=".__LINE__."\n";

   } elsif (exists $main::amazon{'freebsd'}) {
      unless (-e '/usr/local/bin/figlet') {
         open(AG,"pkg_add -r figlet|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
      }
      unless (-e '/usr/local/bin/nano') {
         open(AG,"pkg_add -r nano|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
      }
   } elsif (exists $main::amazon{'gentoo'}) {
      unless (-e '/usr/local/bin/figlet') {
         my $fs='ftp://ftp.figlet.org/pub/figlet/program'.
                '/unix/figlet-2.2.5.tar.gz';print "LINE=".__LINE__."\n";
         open(AG,"(wget $fs;tar zxvf fig*gz;cd figlet-2.2.5;make install)|");print "LINE=".__LINE__."\n";
         while (my $line=<AG>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close AG;print "LINE=".__LINE__."\n";
      }
   }
   if ($incflag && ($main::PARdir ne $main::curdir)) {
      open(PD,">$main::PARdir/inc_exists.txt")
         or die "Cannot open $main::PARdir/inc_exists.txt: $!\n";print "LINE=".__LINE__."\n";
      print PD cwd()."/inc\n";print "LINE=".__LINE__."\n";
      close(PD);print "LINE=".__LINE__."\n";
   }
   my $cpantest=0;print "LINE=".__LINE__."\n";
   $cpantest=1 unless $mycpantest;print "LINE=".__LINE__."\n";
   use if ($mycpantest), "CPAN::MyConfig";print "LINE=".__LINE__."\n";
   use if ($cpantest), "CPAN::Config";print "LINE=".__LINE__."\n";
   
   sub fa_err_exit {
      die "$_[0]\n\n*** Please manually install $_[1]".
          " from cpan.org first...\n"
   }

   sub fa_find_latest {
      my $temp=0;print "LINE=".__LINE__."\n";
      my $look=shift||'';print "LINE=".__LINE__."\n";
      unless ($look) {
         die "ERROR - No argument provided to &fa_find_latest().\n";print "LINE=".__LINE__."\n";
      }
      $look=~s/::/-/g;print "LINE=".__LINE__."\n";
      if ($look eq 'LWP') {
         $look='libwww-perl';print "LINE=".__LINE__."\n";
      } elsif ($look eq 'Compress-Zlib') {
         $look='IO-Compress';print "LINE=".__LINE__."\n";
      } elsif ($look eq 'MIME-Entity') {
         $look='MIME-tools';print "LINE=".__LINE__."\n";
      } elsif ($look eq 'Term-ReadKey') {
         $look='TermReadKey';print "LINE=".__LINE__."\n";
      } elsif ($look eq 'IO-Pty') {
         $look='IO-Tty';print "LINE=".__LINE__."\n";
      } elsif ($look eq 'Mail-Internet') {
         $look='MailTools' ;print "LINE=".__LINE__."\n";
      } elsif ($look eq 'Mail-Header') {
         $look='MailTools' ;print "LINE=".__LINE__."\n";
      } elsif ($look eq 'Mail-Field') {
         $look='MailTools' ;print "LINE=".__LINE__."\n";
      } elsif ($look eq 'Date-Format') {
         $look='TimeDate';print "LINE=".__LINE__."\n";
      } elsif ($look eq 'Pod-Man') {
         $look='podlators';print "LINE=".__LINE__."\n";
      } elsif ($look eq 'List-Util') {
         $look='Scalar-List-Utils';print "LINE=".__LINE__."\n";
      }
      print "***** Looking for Most Recent \"$look Dir\" \n";print "LINE=".__LINE__."\n";
      CPAN::HandleConfig->load;print "LINE=".__LINE__."\n";
      my $d = $CPAN::Config->{build_dir};print "LINE=".__LINE__."\n";
      if (!(defined $d) || !(-d $d)) {
         $d=(getpwuid $>)[7].'/.cpan/build';print "LINE=".__LINE__."\n";
         unless (-d $d) {
            unless (-d "/root/.cpan/build") {
               die "ERROR - Can't locate .cpan/build directory";print "LINE=".__LINE__."\n";
            } else {
               $d='/root/.cpan/build';print "LINE=".__LINE__."\n";
            }
         }
      }
      my $new='';my $file='';print "LINE=".__LINE__."\n";
      opendir(DH,$d) or
         die "ERROR - Can't read Directory $d: $!\n";print "LINE=".__LINE__."\n";
      while ($_ = readdir(DH)) {
         next if ($_ eq ".") || ($_ eq "..") || (/\.yml$/);print "LINE=".__LINE__."\n";
         if ($_!~/^$look[-][vV]?\d/) {
            if (-d $d.'/'.$_) {
               my $dr=$d.'/'.$_;print "LINE=".__LINE__."\n";
               $new=&look_inside_dir($dr,$look);print "LINE=".__LINE__."\n";
               #last if $new;print "LINE=".__LINE__."\n";
            } next
         }
         $file=sprintf("%s/%s",$CPAN::Config->{build_dir},$_);print "LINE=".__LINE__."\n";
         my $attrs = stat $file;print "LINE=".__LINE__."\n";
         my $diff = time()-$attrs->[9];print "LINE=".__LINE__."\n";
         if ($temp == 0 && $_=~/^$look[-][vV]?\d/) {
           $temp=$diff;print "LINE=".__LINE__."\n";
           $new=$file;print "LINE=".__LINE__."\n";
         }
         if ($diff<$temp) {
            $temp=$diff;print "LINE=".__LINE__."\n";
            $new=$_;print "LINE=".__LINE__."\n";
         }
      }
      close(DH);print "LINE=".__LINE__."\n";
      $new=$file if !$new && $file;print "LINE=".__LINE__."\n";
      print "***** Module Directory ",$new,"\n";print "LINE=".__LINE__."\n";
      return $new; 
   }

   sub look_inside_dir {

      my $d=$_[0];print "LINE=".__LINE__."\n";
      my $look=$_[1];print "LINE=".__LINE__."\n";
      my $found='';print "LINE=".__LINE__."\n";
      opendir(LI,$d) or
         die "ERROR - Can't read Directory $d: $!\n";print "LINE=".__LINE__."\n";
      my $tar='';print "LINE=".__LINE__."\n";
      while ($_ = readdir(LI)) {
         next if ($_ eq ".") || ($_ eq "..");print "LINE=".__LINE__."\n";
         if ($_=~/[.]tar$/ && $_=~/^$look[-][vV]?\d/) {
            $tar=$_;print "LINE=".__LINE__."\n";
            next;print "LINE=".__LINE__."\n";
         }
         if ($_=~/^$look[-][vV]?\d/ && -d $_) {
            $tar='';print "LINE=".__LINE__."\n";
            last;print "LINE=".__LINE__."\n";
         }
      }
      close(LI);print "LINE=".__LINE__."\n";
      if ($tar) {
         unless ($CPAN::Config->{tar}) {
            if (-e '/usr/sfw/bin/gtar') {
               $CPAN::Config->{tar}='/usr/sfw/bin/gtar';print "LINE=".__LINE__."\n";
            } elsif (-e '/usr/bin/tar') {
               $CPAN::Config->{tar}='/usr/bin/tar';print "LINE=".__LINE__."\n";
            } elsif (-e '/usr/local/bin/tar') {
               $CPAN::Config->{tar}='/usr/local/bin/tar';print "LINE=".__LINE__."\n";
            } else {
               print "\n\n   Fatal Error!: The 'tar' utility is".
                  " missing.\n".
                  "\n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
                  exit 1;print "LINE=".__LINE__."\n";
            }
         }
         chdir $d;print "LINE=".__LINE__."\n";
         if (($main::system_type eq 'ami') ||
               ($main::system_type eq 'ubuntu') ||
               ($main::system_type eq 'rhel') ||
               ($main::system_type eq 'centos')) {
            print "***** Untar: sudo ",$CPAN::Config->{tar}," xvf $tar\n";print "LINE=".__LINE__."\n";
            open(FH, "sudo ".$CPAN::Config->{tar}." xvf $tar|");print "LINE=".__LINE__."\n";
         } else {
            print "***** Untar: ",$CPAN::Config->{tar}," xvf $tar\n";print "LINE=".__LINE__."\n";
            open(FH, $CPAN::Config->{tar}." xvf $tar|");print "LINE=".__LINE__."\n";
         }
         while (my $line=<FH>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close FH;print "LINE=".__LINE__."\n";
         chdir $CPAN::Config->{build_dir};print "LINE=".__LINE__."\n";
         $tar=~s/[.]tar$//;print "LINE=".__LINE__."\n";
         return "$d/$tar";print "LINE=".__LINE__."\n";
      }
      return '';print "LINE=".__LINE__."\n";

   }
   
   sub fa_install_mod {
   
      my $p=$_[0];print "LINE=".__LINE__."\n";
      my $task=$_[1];print "LINE=".__LINE__."\n";
      my $butil=$_[2]||'';print "LINE=".__LINE__."\n";
      my $force=$_[3]||'';print "LINE=".__LINE__."\n";
      my $version=$_[4]||'';print "LINE=".__LINE__."\n";
      my $echo=$_[5]||'';print "LINE=".__LINE__."\n";
      my $dir='';print "LINE=".__LINE__."\n";
      my $cpan_error='';print "LINE=".__LINE__."\n";
      eval {
         require CPAN::Mini;print "LINE=".__LINE__."\n";
         import CPAN::Mini;print "LINE=".__LINE__."\n";
      };print "LINE=".__LINE__."\n";
      if (!$@ && grep { /-*add[-_]?dependencies/i } @ARGV) {
         my $distribution = CPAN::Shell->expand(
               "Module",$p 
            )->distribution()->pretty_id();print "LINE=".__LINE__."\n";
         my $let=unpack('a1',$distribution);print "LINE=".__LINE__."\n";
         my $lett=unpack('a2',$distribution);print "LINE=".__LINE__."\n";
         my $minicpan=CPAN::Mini->new(

            #remote => "http://www.cpan.org",
            remote => "http://www.perl.com/CPAN",
            local  => cwd()."/dependencies/CPAN",
            log_level => 'debug',
            exact_mirror => 1,
            
         );print "LINE=".__LINE__."\n";
         $minicpan->mirror_file(
            "authors/id/$let/$lett/$distribution");print "LINE=".__LINE__."\n";
      }
      my $mod_info='';my $instfile='';print "LINE=".__LINE__."\n";
      if (!$version || (grep {
            /(?:use[-_]?)?internet|online|connect_to_internet_ok/i
            } @ARGV)) {
         CPAN::Shell->m($p);print "LINE=".__LINE__."\n";
         eval {
            require CPAN;print "LINE=".__LINE__."\n";
            {
               local *STDOUT;print "LINE=".__LINE__."\n";
               open(STDOUT, ">", \$mod_info);print "LINE=".__LINE__."\n";
               CPAN::Shell->m($p);print "LINE=".__LINE__."\n";
            }
         };print "LINE=".__LINE__."\n";
         my $instver='';my $cpanver='';print "LINE=".__LINE__."\n";
         if ($mod_info) {
            ($instfile=$mod_info)=~s/^.*INST_FILE\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
            ($instver=$mod_info)=~s/^.*INST_VERSION\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
            ($cpanver=$mod_info)=~s/^.*CPAN_VERSION\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
         }
         if (!$version && ($instver<$cpanver)) {
            unlink $instfile if $exec_cnt;print "LINE=".__LINE__."\n";
            $version=$cpanver;print "LINE=".__LINE__."\n";
         }
      }
      eval "require $p;1";print "LINE=".__LINE__."\n";
      my $ver='';print "LINE=".__LINE__."\n";
      my $testp=$p;print "LINE=".__LINE__."\n";
      $testp=~s/::/\//g;print "LINE=".__LINE__."\n";
      unless ($@) {
         if ($version) {
            my $ttmp='$ver=$'.$p.'::VERSION';print "LINE=".__LINE__."\n";
            eval $ttmp;print "LINE=".__LINE__."\n";
            $ver=eval $ver;print "LINE=".__LINE__."\n";
            $force=($ver<$version)?1:0;print "LINE=".__LINE__."\n";
         } else { $force=0 } 
      } elsif ((-1<index $@,"Can't locate") &&
            (-1==index $@,$testp)) {
         print "\n\n";print "LINE=".__LINE__."\n";
         print "   Fatal Error: $@\n\n";print "LINE=".__LINE__."\n";
         exit 1;print "LINE=".__LINE__."\n";
      }
      if ($@ || $instfile eq '(not' || $force) {
         if ($ENV{'AUTOMATED_TESTING'}) {
            print "Automated Testing Detected: FullAuto needs $p\n",
                  "   to continue, but $p was not detected on this\n",
                  "   host.\n\n";print "LINE=".__LINE__."\n";
                  "FullAuto Install will EXIT.";print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
         if ($version && $p eq 'Term::Menus') {
            $p="REEDFISH/Term-Menus-$version.tar.gz";print "LINE=".__LINE__."\n";
         } elsif ($version && $p eq 'Term::RawInput') {
            $p="REEDFISH/Term-RawInput-$version.tar.gz";print "LINE=".__LINE__."\n";
         }
         print "==> $p required."
         and print "*** Installing $p via CPAN\n"
         and
         eval {
            require CPAN;print "LINE=".__LINE__."\n";
            CPAN::Shell->notest('get',$p);print "LINE=".__LINE__."\n";
         };print "LINE=".__LINE__."\n";
         if ($@) {
            $cpan_error="$@ $!";print "LINE=".__LINE__."\n";
            die "CPAN Error: $cpan_error\n";print "LINE=".__LINE__."\n";
         }
         if ($version && (-1<index $p,'Term-Menus')) {
            $p='Term::Menus';print "LINE=".__LINE__."\n";
         } elsif ($version && (-1<index $p,'Term-RawInput')) {
            $p='Term::RawInput';print "LINE=".__LINE__."\n";
         }
         if (lc($task) eq 'install') {
            my $sudo='';print "LINE=".__LINE__."\n";
            if (($main::system_type eq 'ami') ||
                  ($main::system_type eq 'ubuntu') ||
                  ($main::system_type eq 'rhel') ||
                  ($main::system_type eq 'centos')) {
               $sudo='sudo ';print "LINE=".__LINE__."\n";
            }
            $dir||=&fa_find_latest($p);print "LINE=".__LINE__."\n";
            print "*** Running $sudo$^X $butil.PL\n";print "LINE=".__LINE__."\n";
            print "*** cd to $dir\n";print "LINE=".__LINE__."\n";
            if ($p eq 'Archive::Tar') {
               my @MakefilePL=();print "LINE=".__LINE__."\n";
               open(FH,"<$dir/Makefile.PL");print "LINE=".__LINE__."\n";
               @MakefilePL=<FH>;print "LINE=".__LINE__."\n";
               close FH;print "LINE=".__LINE__."\n";
               my $newfile='';print "LINE=".__LINE__."\n";
               foreach my $line (@MakefilePL) {
                  if ($line=~/sleep 10/) {
                     $newfile.="#$line";print "LINE=".__LINE__."\n";
                  } else {
                     $newfile.=$line;print "LINE=".__LINE__."\n";
                  }
               }
               unlink "$dir/Makefile.PL";print "LINE=".__LINE__."\n";
               open(FH,">$dir/Makefile.PL");print "LINE=".__LINE__."\n";
               print FH $newfile;print "LINE=".__LINE__."\n";
               close FH;print "LINE=".__LINE__."\n";
            } elsif ($p eq 'Win32::API') {
               open(FH,"<$dir/Callback/Callback.xs");print "LINE=".__LINE__."\n";
               my @callback=<FH>;print "LINE=".__LINE__."\n";
               close FH;print "LINE=".__LINE__."\n";
               my $new_callback=join '', @callback;print "LINE=".__LINE__."\n";
               my $newfile='';print "LINE=".__LINE__."\n";
               unless (-1<index $new_callback,'stricmp') {
                  foreach my $line (@callback) {
                     if ($line=~/WIN32_LEAN_AND_MEAN/) {
                        $newfile.="\n#ifndef WIN32"
                                ."\n#       define stricmp strcasecmp"
                                ."\n#       define strnicmp strncasecmp"
                                ."\n#endif\n";print "LINE=".__LINE__."\n";
                     }
                     $newfile.=$line;print "LINE=".__LINE__."\n";
                  }
                  open(FH,">$dir/Callback/Callback.xs");print "LINE=".__LINE__."\n";
                  print $newfile;print "LINE=".__LINE__."\n";
                  close FH;print "LINE=".__LINE__."\n";
               }
            } elsif ($p eq 'Win32::OLE') {
               open(FH,"<$dir/OLE.xs");print "LINE=".__LINE__."\n";
               my @ole=<FH>;print "LINE=".__LINE__."\n";
               close FH;print "LINE=".__LINE__."\n";
               my $newole=join '', @ole;print "LINE=".__LINE__."\n";
               $newole=~s/stricmp/strcasecmp/sg;print "LINE=".__LINE__."\n";
               open(FH,">$dir/OLE.xs");print "LINE=".__LINE__."\n";
               print $newole;print "LINE=".__LINE__."\n";
               close FH;print "LINE=".__LINE__."\n";
            }
            if ($echo) {
               system("cd \"$dir\";echo $echo | $sudo$^X $butil.PL");print "LINE=".__LINE__."\n";
            } else {
               system("cd \"$dir\";$sudo$^X $butil.PL");print "LINE=".__LINE__."\n";
            }
            if ($butil eq 'Makefile') {
               print "*** Running ${sudo}make install\n";print "LINE=".__LINE__."\n";
               system("cd \"$dir\";${sudo}make install");print "LINE=".__LINE__."\n";
            } else {
               print "*** Running ${sudo}Build install\n";print "LINE=".__LINE__."\n";
               system("cd \"$dir\";./Build build;${sudo}./Build install");print "LINE=".__LINE__."\n";
            }
         }
         chdir $main::curdir;print "LINE=".__LINE__."\n";
         my $_p=$p;print "LINE=".__LINE__."\n";
         $_p=~s/::/\//g;print "LINE=".__LINE__."\n";
         $_p.='.pm';print "LINE=".__LINE__."\n";
         unless (exists $INC{$_p}) {
            eval {
               require $_p;print "LINE=".__LINE__."\n";
            };print "LINE=".__LINE__."\n";
            if ($@ && -1==index $@,'Attempt to reload') {
               warn $@;print "LINE=".__LINE__."\n";
            } else {
               print "*** $p Loaded Successfully\n";print "LINE=".__LINE__."\n";
               $exec_cnt=0;print "LINE=".__LINE__."\n";
            }
         } elsif (lc($task) eq 'install') {
            my $sudo=0;print "LINE=".__LINE__."\n";
            if (($main::system_type eq 'ami') ||
                  ($main::system_type eq 'ubuntu') ||
                  ($main::system_type eq 'rhel') ||
                  ($main::system_type eq 'centos')) {
               $sudo=1;print "LINE=".__LINE__."\n";
            }
            my $argvs=join " ", @ARGV;print "LINE=".__LINE__."\n";
            if ($sudo) {
               exec "cd \"$dir\";sudo $^X Makefile.PL $argvs SKIP $p $exec_cnt";print "LINE=".__LINE__."\n";
            } else {
               exec "cd \"$dir\";$^X Makefile.PL SKIP $argvs $p $exec_cnt";print "LINE=".__LINE__."\n";
            }
         }
      } else {
         print "*** $p Loaded Successfully\n";print "LINE=".__LINE__."\n";
         $exec_cnt=0;print "LINE=".__LINE__."\n";
      }
      return '';print "LINE=".__LINE__."\n";
   }
   
   sub fa_install_module {
       my $stdout='';my $stderr='';print "LINE=".__LINE__."\n";
       eval { require IO::CaptureOutput };print "LINE=".__LINE__."\n";
       if ($@) {
          eval { &fa_install_mod(@_) };print "LINE=".__LINE__."\n";
          if ($@) {
             &fa_err_exit($@,$_[0]);print "LINE=".__LINE__."\n";
          }
       } else {
          eval {
             require IO::CaptureOutput;print "LINE=".__LINE__."\n";
             IO::CaptureOutput::capture {
                &fa_install_mod(@_)
             } \$stdout, \$stderr;print "LINE=".__LINE__."\n";
          };print "LINE=".__LINE__."\n";
          print $stdout if $stdout;print "LINE=".__LINE__."\n";
          &fa_err_exit($stderr,$_[0]) if $stderr;print "LINE=".__LINE__."\n";
       }
   }
   
   sub menu {
      my $m = shift;print "LINE=".__LINE__."\n";
      my $choice;print "LINE=".__LINE__."\n";
      while (1) {
         print "$m->[0]\n";print "LINE=".__LINE__."\n";
         print map { "\t$_. $m->[$_][0]\n" } (1..$#$m);print "LINE=".__LINE__."\n";
         print "\n\n   PLEASE ENTER A CHOICE: ";print "LINE=".__LINE__."\n";
         chomp ($choice = <>);print "LINE=".__LINE__."\n";
         last if ( ($choice > 0) && ($choice <= $#$m ));print "LINE=".__LINE__."\n";
         print "You chose '$choice'.  That is not a valid option.\n\n";print "LINE=".__LINE__."\n";
      }
      &{$m->[$choice][1]};print "LINE=".__LINE__."\n";
   }

   sub size_fmt {
      my $size = shift(@_);print "LINE=".__LINE__."\n";

      if ($size < 1024) {
         return $size . " bytes";print "LINE=".__LINE__."\n";
      }
      if ($size < (1024*1024)) {
         return sprintf("%.2f KB",$size / 1024);print "LINE=".__LINE__."\n";
      }
      if ($size < (1024*1024*1024)) {
         return sprintf("%.2f MB",$size / (1024*1024));print "LINE=".__LINE__."\n";
      }
      if ($size < (1024*1024*1024*1024)) {
         return sprintf("%.2f GB",$size / (1024*1024*1024));print "LINE=".__LINE__."\n";
      }
      return sprintf("%.2f TB",$size / (1024*1024*1024*1024));print "LINE=".__LINE__."\n";
   }

   my $stdout='';my $stderr='';print "LINE=".__LINE__."\n";
   if ($^O ne 'MSWin32' && $^O ne 'MSWin64') {
      &fa_install_mod('ExtUtils::MakeMaker','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('File::Which','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Term::ReadKey','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Perl::OSType','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Locale::Maketext::Simple','install','Makefile');print "LINE=".__LINE__."\n";
      eval { require Test::Tester };print "LINE=".__LINE__."\n";
      if ($@) {
         &fa_install_mod('Test::Simple','install','Makefile');print "LINE=".__LINE__."\n";
      } else {
         &fa_install_mod('Test::Simple','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Test::Tester','install','Makefile');print "LINE=".__LINE__."\n";
      }
      &fa_install_mod('Params::Check','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('version','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Module::CoreList','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Module::Load','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('parent','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Module::Metadata','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Module::Load::Conditional','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('IPC::Cmd','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('ExtUtils::CBuilder','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('YAML','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('YAML::Tiny','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Algorithm::Diff','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Text::Diff','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('PAR::Dist','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Compress::Raw::Bzip2','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Compress::Raw::Zlib','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Compress::Zlib','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('CPAN::Meta::YAML','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('Parse::CPAN::Meta','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('CPAN::Meta::Requirements','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('JSON::PP','install','Makefile');print "LINE=".__LINE__."\n";
      if (0) {
      my $mod_info='';my $mod_build_version=0.3601;print "LINE=".__LINE__."\n";
      unless (-e "dependencies/CPAN/authors" &&
            !(grep {
            /(?:use[-_]?)?internet|online|connect_to_internet_ok/i } @ARGV)) {
         eval {
            require CPAN;print "LINE=".__LINE__."\n";
            {
               local *STDOUT;print "LINE=".__LINE__."\n";
               open(STDOUT, ">", \$mod_info);print "LINE=".__LINE__."\n";
               CPAN::Shell->m('Module::Build');print "LINE=".__LINE__."\n";
            }
         };print "LINE=".__LINE__."\n";
         unless ($@) {
            my $instfile='';my $instver='';my $cpanver='';print "LINE=".__LINE__."\n";
            if ($mod_info) {
               ($instfile=$mod_info)=~s/^.*INST_FILE\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
               ($instver=$mod_info)=~s/^.*INST_VERSION\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
               ($cpanver=$mod_info)=~s/^.*CPAN_VERSION\s+([^\s]+).*$/$1/s;print "LINE=".__LINE__."\n";
            }
            if ($instver<$cpanver) {
               $mod_build_version=$cpanver;print "LINE=".__LINE__."\n";
            }
         }
      }
      eval { require Module::Build };print "LINE=".__LINE__."\n";
      if ((!($@) && $Module::Build::VERSION<=$mod_build_version) || $@
            || grep { /-*add[-_]?dependencies/i } @ARGV) {
         &fa_install_mod('CPAN::Meta','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('ExtUtils::ParseXS','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Compress::Raw::Bzip2','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Compress::Raw::Zlib','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('IO::Zlib','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Archive::Tar','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('inc::latest','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Regexp::Common','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Pod::Checker','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Pod::Parser','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Pod::Man','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_mod('Module::Build','install','Makefile','force');print "LINE=".__LINE__."\n";
      }
      }
      &fa_install_mod('Module::Build','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_mod('IO::CaptureOutput','install','Makefile');print "LINE=".__LINE__."\n";
      if (grep { /-*add[-_]?dependencies/i } @ARGV) {
         &fa_install_module('IO::Pty','install','Makefile');print "LINE=".__LINE__."\n";
         unless (grep { /-*add[-_]?dependencies/i } @ARGV) {
            my $argv0=$ARGV[0]||'';print "LINE=".__LINE__."\n";
            exit if $argv0 eq 'install_IO_Pty_from_CPAN';print "LINE=".__LINE__."\n";
         }
      }
      &fa_install_module('HTML::Tagset','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('HTML::Parser','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('URI','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('HTTP::Date','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Digest::MD5','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('LWP::MediaTypes','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Encode::Locale','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('IO::HTML','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('HTTP::Message','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('File::Listing','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('HTTP::Cookies','install','Makefile');print "LINE=".__LINE__."\n";
      if ($^O ne 'cygwin'
            || grep { /-*add[-_]?dependencies/i } @ARGV) {
         &fa_install_module('HTTP::Daemon','install','Makefile');print "LINE=".__LINE__."\n";
      }
      &fa_install_module('Encode::Locale','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('WWW::RobotRules','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Date::Format','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Date::Parse','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Mail::Internet','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Mail::Header','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Mail::Field','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Test::NoWarnings','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Convert::BinHex','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Test::Deep','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('MIME::Base64','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('MIME::Entity','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('LWP::MediaTypes','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('HTTP::Negotiate','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Net::HTTP','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Data::Dump','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('File::HomeDir','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('LWP','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('CPAN::Mini','install','Makefile');print "LINE=".__LINE__."\n";
      eval { require Net::SSLeay };print "LINE=".__LINE__."\n";
      if ($@) {
         my $ssleay_error_banner=<<END;print "LINE=".__LINE__."\n";

         *** THIS SCREEN WILL TIMEOUT AND FULLAUTO SETUP WILL EXIT
                    IN 5 MINUTES IF NO CHOICE IS MADE ***

      FullAuto Setup ERROR: Missing dependency 'openssl-devel'

   The CPAN module Net::SSLeay requires the 'openssl-devel' system package to
   be installed. Would you like FullAuto Setup to attempt installing this
   package?
END

         &fa_install_module('Net::SSLeay','get');print "LINE=".__LINE__."\n";
         my $dir=&fa_find_latest('Net-SSLeay');print "LINE=".__LINE__."\n";
         open(FH, "(cd \"$dir\";echo n | $^X Makefile.PL) 2>&1|");print "LINE=".__LINE__."\n";
         while (my $line=<FH>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close FH;print "LINE=".__LINE__."\n";
         SSL: while (1) {
            open(FH, "(cd \"$dir\";make install) 2>&1|");print "LINE=".__LINE__."\n";
            while (my $line=<FH>) {
               if (-1<index $line,
                     'error: openssl/err.h: No such file or directory') {
                  my $timeout=300;my $selection='';print "LINE=".__LINE__."\n";
                  eval {
                     local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
                     alarm $timeout;print "LINE=".__LINE__."\n";
                     my $fae="No   (FullAuto Setup will exit)";print "LINE=".__LINE__."\n";
                     my $menu1 = [
                                 $ssleay_error_banner,
                                 [ "Yes", sub{ return 'Yes' } ],
                                 [ $fae, sub{ return 'No' } ],
                                 ];print "LINE=".__LINE__."\n";
                     $selection=&menu($menu1);print "LINE=".__LINE__."\n";
                     exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
                     alarm 0;print "LINE=".__LINE__."\n";
                  };print "LINE=".__LINE__."\n";
                  if ($@) {
                     # timed out
                     $selection = 'No';print "LINE=".__LINE__."\n";
                  }
                  if ($selection=~/No/) {
                     exit;print "LINE=".__LINE__."\n";
                  } alarm 0;print "LINE=".__LINE__."\n";
                  if (($main::system_type eq 'rhel') ||
                        ($main::system_type eq 'centos') ||
                        ($main::system_type eq 'fedora')) {
                     open(LD,"sudo yum -y install 'openssl-devel'|");print "LINE=".__LINE__."\n";
                     while (my $line=<LD>) {
                        print $line;print "LINE=".__LINE__."\n";
                     }
                     close LD;print "LINE=".__LINE__."\n";
                     next SSL;print "LINE=".__LINE__."\n";
                  } elsif ($main::system_type eq 'suse') {
                     open(ZP,"zypper -n install openssl-devel|");print "LINE=".__LINE__."\n";
                     while (my $line=<AG>) {
                        print $line;print "LINE=".__LINE__."\n";
                     }
                     close ZP;print "LINE=".__LINE__."\n";
                     next SSL;print "LINE=".__LINE__."\n";
                  } elsif ($main::system_type eq 'ubuntu') {
                     open(LD,"sudo apt-get -y install 'libssl-dev'|");print "LINE=".__LINE__."\n";
                     while (my $line=<LD>) {
                        print $line;print "LINE=".__LINE__."\n";
                     }
                     close LD;print "LINE=".__LINE__."\n";
                     next SSL;print "LINE=".__LINE__."\n";
                  }
               }
               print $line;print "LINE=".__LINE__."\n";
            } last;print "LINE=".__LINE__."\n";
         }
         close FH;print "LINE=".__LINE__."\n";
      } elsif (grep { /-*add[-_]?dependencies/i } @ARGV) {
         &fa_install_module('Net::SSLeay','get');print "LINE=".__LINE__."\n";
      }
      &fa_install_module('IO::Socket::SSL','install','Makefile','','','n');print "LINE=".__LINE__."\n";
      &fa_install_module('Mozilla::CA','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('LWP::Protocol::https','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Task::Weaken','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('ExtUtils::Depends','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('B::Utils','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('ExtUtils::Config','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('ExtUtils::InstallPaths','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('ExtUtils::Helpers','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Test::Harness','install','Makefile','','3.33');print "LINE=".__LINE__."\n";
      &fa_install_module('CPAN::Meta','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Module::Build::Tiny','install','Build');print "LINE=".__LINE__."\n";
      &fa_install_module('Class::Method::Modifiers','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('common::sense','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Types::Serialiser','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Term::RawInput','install','Makefile');print "LINE=".__LINE__."\n";
      if ($^O eq 'cygwin' || grep { /-*add[-_]?dependencies/i } @ARGV) {
         &fa_install_module('Encode::compat','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_module('Win32::API','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_module('Win32::DriveInfo','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_module('Devel::PL_origargv','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_module('Win32::OLE','install','Makefile');print "LINE=".__LINE__."\n";
         &fa_install_module('Win32::RunAsAdmin','install','Makefile');print "LINE=".__LINE__."\n";
      }
      my $cpanvalue=$ENV{PERL5_CPAN_IS_RUNNING}||'';print "LINE=".__LINE__."\n";
      my $cpanmvalue=$ENV{PERL5_CPANM_IS_RUNNING}||'';print "LINE=".__LINE__."\n";
      undef $ENV{PERL5_CPAN_IS_RUNNING};print "LINE=".__LINE__."\n";
      undef $ENV{PERL5_CPANM_IS_RUNNING};print "LINE=".__LINE__."\n";
      &fa_install_module('JSON::XS','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('JSON','install','Makefile');print "LINE=".__LINE__."\n";
      $ENV{PERL5_CPAN_IS_RUNNING}=$cpanvalue if $cpanvalue;print "LINE=".__LINE__."\n";
      $ENV{PERL5_CPANM_IS_RUNNING}=$cpanmvalue if $cpanmvalue;print "LINE=".__LINE__."\n";
      &fa_install_module('Devel::Symdump','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('PadWalker','install','Makefile');print "LINE=".__LINE__."\n";
      eval { require Data::Dump::Streamer };print "LINE=".__LINE__."\n";
      if ($@ || grep { /-*add[-_]?dependencies/i } @ARGV) {
         &fa_install_module('Data::Dump::Streamer','get');print "LINE=".__LINE__."\n";
         unless (grep { /-*add[-_]?dependencies/i } @ARGV) {
            my $dir=&fa_find_latest('Data-Dump-Streamer');print "LINE=".__LINE__."\n";
            system("cd \"$dir\";$^X Build.PL NODDS;");print "LINE=".__LINE__."\n";
            system("cd \"$dir\";./Build install;");print "LINE=".__LINE__."\n";
         }
      }
      &fa_install_module('Term::Menus','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('IO::String','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Crypt::CBC','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Crypt::DES','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Test::Manifest','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Crypt::Rijndael','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Clone','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('File::Remove','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Exporter::Tiny','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('List::MoreUtils','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Params::Util','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Test::Object','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Hook::LexWrap','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Test::SubCalls','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Class::Inspector','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('PPI','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Tie::Cache','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('String::Random','install','Build');print "LINE=".__LINE__."\n";
      &fa_install_module('Net::Telnet','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Sort::Versions','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Capture::Tiny','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('IO::Capture','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Pod::Man','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Sub::Exporter::Progressive','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('MRO::Compat','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Sub::Install','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Data::OptList','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('B::Hooks::OP::Check','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Lexical::SealRequireHints','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('multidimensional','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('bareword::filehandles','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('indirect','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('strictures','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Role::Tiny','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Devel::GlobalDestruction','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Module::Runtime','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Import::Into','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Try::Tiny','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Sub::Exporter','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Sub::Exporter::Util','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Moo','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Test::Fatal','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('MooX::Types::MooseLike','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('MooX::Types::MooseLike::Base','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Devel::StackTrace','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Throwable','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Email::Date::Format','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Email::Simple','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Email::Address','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Module::Pluggable','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Email::Abstract','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Email::Sender','install','Makefile');print "LINE=".__LINE__."\n";
      &fa_install_module('Data::Password::Check','install','Makefile');print "LINE=".__LINE__."\n";

   }
#};print "LINE=".__LINE__."\n";

my %cygsrvs=();print "LINE=".__LINE__."\n";
my @output=();print "LINE=".__LINE__."\n";
my $hostname=`hostname`;print "LINE=".__LINE__."\n";
chomp($hostname);print "LINE=".__LINE__."\n";

sub ws_info {
   my $selection='';print "LINE=".__LINE__."\n";
   if ($_[0]) {
      print "\nRunning command: net user /domain ->".
            " This may take a couple of minutes\n\n";print "LINE=".__LINE__."\n";
   }
   # Do we have Cygwin?
   my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
   my $clo=$cygwin_loc;print "LINE=".__LINE__."\n";
   $clo=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
   my %userlist=();my %passlins=();print "LINE=".__LINE__."\n";
   my @newpassw=();my $modflag=0;print "LINE=".__LINE__."\n";
   if (-e $cygwin_loc."/bin") {
      my $pasen='SET CYGWIN=nodosfilewarning & '.
                "cmd /c $cygwin_loc\\bin\\bash -lc ".
                '"cat /etc/passwd"';print "LINE=".__LINE__."\n";
      my $passe=`$pasen`;my $cnt=0;my %passlins=();print "LINE=".__LINE__."\n";
      foreach my $en (split "\n",$passe) {
         chomp($en);print "LINE=".__LINE__."\n";
         push @{$passlins{$en}},$cnt++;print "LINE=".__LINE__."\n";
         push @newpassw,$en;print "LINE=".__LINE__."\n";
      }
      foreach my $lin (keys %passlins) {
         my $linn=$lin;print "LINE=".__LINE__."\n";
         my @pl=@{$passlins{$linn}};print "LINE=".__LINE__."\n";
         if (0<$#pl) {
            my %asklin=(
               Label => 'asklin',
               Item_1 => {
                  Text => "]C[",
                  Convey => sub {

                     my @ret=();print "LINE=".__LINE__."\n";
                     foreach my $p (@pl) {
                        push @ret, "\n                $linn\n".
                                   "\n                Line: $p\n\n";print "LINE=".__LINE__."\n";
                     }
                     return @ret;print "LINE=".__LINE__."\n";

                  },
               },
               Item_2 => {
                  Text => "Skip this operation",
               },
               Banner => "   Duplicate Lines in /etc/passwd found!\n\n".
                         "   The following lines are all duplicates, ".
                         "the only one being utilized is\n   the first ".
                         "one found. It is recommended that the ".
                         "others be removed.\n\n".
                         "   Select the one you wish to keep, or choose ".
                         "'Skip this operation' and\n   FullAuto Setup ".
                         "will continue.\n\n",
            );print "LINE=".__LINE__."\n";
            my $select=Menu(\%asklin);print "LINE=".__LINE__."\n";
            chomp($select);print "LINE=".__LINE__."\n";
            exit if $select eq ']quit[';print "LINE=".__LINE__."\n";
            my $s=0;print "LINE=".__LINE__."\n";
            ($s=$select)=~s/^.*\n\s+Line: (\d+).*$/$1/s;print "LINE=".__LINE__."\n";
            my $adjust=0;print "LINE=".__LINE__."\n";
            foreach my $i (@pl) {
               my $ii=$i;print "LINE=".__LINE__."\n";
               my $n=0;print "LINE=".__LINE__."\n";
               ($n=$ii)=~s/^.*\n\s+Line: (\d+).*$/$1/s;print "LINE=".__LINE__."\n";
               next if $s eq $n;print "LINE=".__LINE__."\n";
               $n-=$adjust;print "LINE=".__LINE__."\n";
               splice(@newpassw,$n,1);print "LINE=".__LINE__."\n";
               $modflag=1;print "LINE=".__LINE__."\n";
               $adjust++;print "LINE=".__LINE__."\n";
            }
         }
      }
      if ($modflag) {
         my $npass=join "\n",@newpassw;print "LINE=".__LINE__."\n";
         open(NP,">$cygwin_loc/etc/passwd");print "LINE=".__LINE__."\n";
         foreach my $l (@newpassw) {
            print NP "$l\n";print "LINE=".__LINE__."\n";
         }
         close NP;print "LINE=".__LINE__."\n";
      } $modflag=0;print "LINE=".__LINE__."\n";
      my $users='SET CYGWIN=nodosfilewarning & '.
                "cmd /c $cygwin_loc\\bin\\bash -lc ".
                '"cat /etc/passwd |grep '.
                '\\"/bin/bash\\" |grep '.
                '\\"[5-9][0-9][0-9]\\""';print "LINE=".__LINE__."\n";
      my $userlist=`$users`;print "LINE=".__LINE__."\n";
      my %ulist=();my $cyguser='';print "LINE=".__LINE__."\n";
      foreach my $us (split "\n",$userlist) {
         chomp($us);print "LINE=".__LINE__."\n";
         $cyguser=substr($us,0,(index $us,':'));print "LINE=".__LINE__."\n";
         next if $cyguser ne 'cyg_server';print "LINE=".__LINE__."\n";
         push @{$ulist{$cyguser}}, $us;print "LINE=".__LINE__."\n";
      }
      my @u=@{$ulist{cyg_server}};print "LINE=".__LINE__."\n";
      my @list=();my @retrn=();print "LINE=".__LINE__."\n";
      my $domain_id_flag=0;print "LINE=".__LINE__."\n";
      my $local_id_flag=0;print "LINE=".__LINE__."\n";
      my %cygsrvs=();print "LINE=".__LINE__."\n";
      if (-1<$#u) {
         foreach my $e (@u) {
            my @it=split ':',$e;print "LINE=".__LINE__."\n";
            my $info=(split ',',$it[4])[1];print "LINE=".__LINE__."\n";
            my $d='';my $i='';print "LINE=".__LINE__."\n";
            if (-1<index $info,'\\') {
               ($d,$i)=split /\\/,$info;print "LINE=".__LINE__."\n";
               $d=~s/^.*-(.*)$/$1/;print "LINE=".__LINE__."\n";
               $d="DOMAIN: $d";print "LINE=".__LINE__."\n";
               $domain_id_flag=1;print "LINE=".__LINE__."\n";
            } else {
               $d="LOCAL: $hostname";print "LINE=".__LINE__."\n";
               $local_id_flag=1;print "LINE=".__LINE__."\n";
            }
            push @retrn,"cyg_server -> $d";print "LINE=".__LINE__."\n";
            $cygsrvs{"cyg_server -> $d"}=$e;print "LINE=".__LINE__."\n";
         }
      }
      if (0<$#retrn) {
         my %askcyg=(

            Label => 'askcyg',
            Item_1 => {

               Text => "]C[",
               Convey => \@retrn,

            },
            Banner => "   More than one instance of the user 'cyg_server'\n" .
                      "   have been located in the /etc/passwd file. However".
                      ",\n   only one can be used. Please choose one:\n",
         );print "LINE=".__LINE__."\n";
         my $select=Menu(\%askcyg);print "LINE=".__LINE__."\n";
         chomp($select);print "LINE=".__LINE__."\n";
         exit if $select eq ']quit[';print "LINE=".__LINE__."\n";
         delete $cygsrvs{$select};print "LINE=".__LINE__."\n";
         my $pasen='SET CYGWIN=nodosfilewarning & '.
                   "cmd /c $cygwin_loc\\bin\\bash -lc ".
                   '"cat /etc/passwd"';print "LINE=".__LINE__."\n";
         my $passe=`$pasen`;my $cnt=0;my %passlins=();print "LINE=".__LINE__."\n";
         foreach my $en (split "\n",$passe) {
            chomp($en);print "LINE=".__LINE__."\n";
            push @{$passlins{$en}},$cnt++;print "LINE=".__LINE__."\n";
            push @newpassw,$en;print "LINE=".__LINE__."\n";
         }
         my $ct=0;my $n=0;my $modflag=0;print "LINE=".__LINE__."\n";
         foreach my $lin (keys %passlins) {
            my $linn=$lin;print "LINE=".__LINE__."\n";
            $lin=~s/\s*$//;print "LINE=".__LINE__."\n";
            foreach my $i (values %cygsrvs) {
               my $ii=$i;print "LINE=".__LINE__."\n";
               $ii=~s/\s*$//;print "LINE=".__LINE__."\n";
               if ($lin eq $ii) {
                  splice(@newpassw,$n,1);print "LINE=".__LINE__."\n";
                  $ct++;print "LINE=".__LINE__."\n";
                  $modflag=1;print "LINE=".__LINE__."\n";
                  next;print "LINE=".__LINE__."\n";
               }
               $ct++;$n++;print "LINE=".__LINE__."\n";
            }
         }
         if ($modflag) {
            open(NP,">$cygwin_loc/etc/passwd");print "LINE=".__LINE__."\n";
            foreach my $l (@newpassw) {
               print NP "$l\n";print "LINE=".__LINE__."\n";
            }
            close NP;print "LINE=".__LINE__."\n";
         }
         test_windows_user_rights('cyg_server');print "LINE=".__LINE__."\n";
      }
   }
   my $found_dotted=0;print "LINE=".__LINE__."\n";
   my $domain='';print "LINE=".__LINE__."\n";
   $domain=' /domain' if $_[0];print "LINE=".__LINE__."\n";
   my $server='';print "LINE=".__LINE__."\n";
   foreach my $line (split "\n", `net user$domain 2>&1`) {
      unless ($found_dotted) {
         if (-1<index $line,'-------') {
            $found_dotted=1;print "LINE=".__LINE__."\n";
         } elsif (-1<index $line,' for domain ') {
            ($domain=$line)=~s/^.* for domain (.*)[.]\s*$/$1/s;print "LINE=".__LINE__."\n";
         } elsif (-1<index $line,' accounts for ') {
            ($server=$line)=~s/^.* accounts for\s+(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
         }
         next;print "LINE=".__LINE__."\n";
      }
      push @output, $line;print "LINE=".__LINE__."\n";
   }
   my $limit=9;print "LINE=".__LINE__."\n";
   $limit=$#output if $#output<9;print "LINE=".__LINE__."\n";
   my @test=@output[0..$limit];print "LINE=".__LINE__."\n";
   my %testone=();print "LINE=".__LINE__."\n";
   my %testtwo=();print "LINE=".__LINE__."\n";
   while (my $line=shift @test) {
      $line=~tr/\0-\11\13-\37\177-\377//d;print "LINE=".__LINE__."\n";
      chomp($line);print "LINE=".__LINE__."\n";
      $line=~s/\s*$//s;print "LINE=".__LINE__."\n";
      my $ln2=rindex $line, ' ';print "LINE=".__LINE__."\n";
      $testtwo{$ln2}++;print "LINE=".__LINE__."\n";
      substr($line,$ln2)='';print "LINE=".__LINE__."\n";
      $line=~s/\s*$//s;print "LINE=".__LINE__."\n";
      my $ln1=rindex $line, ' ';print "LINE=".__LINE__."\n";
      $testone{$ln1}++;print "LINE=".__LINE__."\n";
   }
   my $two=0;print "LINE=".__LINE__."\n";
   foreach my $key (keys %testtwo) {
      $two=$key if $two<$key;print "LINE=".__LINE__."\n";
   }
   my $one=0;print "LINE=".__LINE__."\n";
   foreach my $key (keys %testone) {
      $one=$key if $one<$key;print "LINE=".__LINE__."\n";
   }
   $one++;print "LINE=".__LINE__."\n";
   my $mid=$two-$one+1;print "LINE=".__LINE__."\n";
   my @users=();my $cyg_id='';print "LINE=".__LINE__."\n";
   my $success_flag=0;print "LINE=".__LINE__."\n";
   foreach my $line (@output) {
      my ($on,$tw,$th)=unpack("a$one a$mid a$two",$line);print "LINE=".__LINE__."\n";
      $on=~s/\s*$//;$tw=~s/\s*$//;$th=~s/\s*$//;print "LINE=".__LINE__."\n";
      if (-1<index $on,'The command compl') {
         $success_flag=1;print "LINE=".__LINE__."\n";
         last;print "LINE=".__LINE__."\n";
      }
      push @users, $on if $on;print "LINE=".__LINE__."\n";
      $cyg_id='cyg_server' if $on eq 'cyg_server';print "LINE=".__LINE__."\n";
      push @users, $tw if $tw;print "LINE=".__LINE__."\n";
      $cyg_id='cyg_server' if $tw eq 'cyg_server';print "LINE=".__LINE__."\n";
      push @users, $th if $th;print "LINE=".__LINE__."\n";
      $cyg_id='cyg_server' if $th eq 'cyg_server';print "LINE=".__LINE__."\n";

   }

   my $dom=(defined $_[0] && $_[0])?$_[0]:'Local';print "LINE=".__LINE__."\n";

   if ($dom ne 'Local' && !$success_flag) {

      my $banner='';my $op=join '', @output;print "LINE=".__LINE__."\n";
      if ((-1<$#output) && ($op!~/^\s*$/s)) {
         my $op=join "\n",@output;print "LINE=".__LINE__."\n";
         $banner=<<END;print "LINE=".__LINE__."\n";

   IMPORTANT! - The Windows command: net user /domain -> ERROR!

      $op
      
   If you intend to use a Windows Domain Account for the Cygwin sshd
      service it is helpful that the FullAuto Installer be able to query
      the $dom Domain Controller. You may proceed if the ID
      you intend to use exists, or if you wish to use a Local account.

   (If you wish to use a Windows Domain User ID, *make sure it exists*
      and that your computer or device is properly connected to the
      $dom Windows Domain.)

END
      } else {
         $banner=<<END;print "LINE=".__LINE__."\n";

   IMPORTANT! - The Windows command: net user /domain  had no output.

   If you intend to use a Windows Domain Account for the Cygwin sshd
      service it is helpful that the FullAuto Installer be able to query
      the $dom Domain Controller. You may proceed if the ID
      you intend to use exists, or if you wish to use a Local account.

   (If you wish to use a Windows Domain User ID, *make sure it exists*
      and that your computer or device is properly connected to the
      $dom Windows Domain.)

END
      } 
      unless ($success_flag) {
         my %_cygservnf=(
            Label => '_cygservnf',
            Item_1 =>  {
                  Text   => "]C[",
                  Convey => [ "Use a Local account for the sshd service\n\n",
                              "Use Domain ID \'cyg_server\'\n           ".
                              "     ( You need to know the password! )\n\n",
                              "Enter a different User ID" ],
            },
            Scroll => 1,
            Banner => $banner,
         );print "LINE=".__LINE__."\n";
         $selection=Menu(\%_cygservnf);print "LINE=".__LINE__."\n";
         chomp $selection;print "LINE=".__LINE__."\n";
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
         $selection='UsE_separate_login_id_for_sshd'
            if -1<index $selection,'Use a Local';print "LINE=".__LINE__."\n";
         if (-1<index $selection,'Enter a different') {
            while (1) {
               print "\n\n\n   Please enter the $domain User ID you",
                     "   intend to use for the sshd service: ".
                     "\n\n\n",
                     "   Please TYPE the User ID: ";print "LINE=".__LINE__."\n";
               $cyg_id=<STDIN>;print "LINE=".__LINE__."\n";
               chomp $selection;print "LINE=".__LINE__."\n";
               print "\n\n\n   You entered ==> $cyg_id\n\n".
                     "   is this correct? (Y|N): ";print "LINE=".__LINE__."\n";
               my $yn=<STDIN>;print "LINE=".__LINE__."\n";
               last if lc($yn) eq 'y' || 'yes';print "LINE=".__LINE__."\n";
            }
         }
      } elsif ($cyg_id eq 'cyg_server') {
         my $o=`net user cyg_server 2>&1`;print "LINE=".__LINE__."\n";
         if (-1==index $o,'user name could not be found') {
            my %_cygserv=(
   
               Label => '_cygserv',
               Item_1 =>  {
                     Text   => "]C[",
                     Convey => [ "Use Domain ID \'cyg_server\'\n".
                                 '                '.
                                 '( You need to know the password! )',
                                 'Select ID from All Domain ID\'s',
                                 'Use a Local account' ],
               },
               Scroll => 1,
               Banner=> "   The Domain User 'cyg_server' has been located,\n".
                        "   do you wish to use it, or would you rather\n".
                        "   select from all Domain Users, or use a Local\n".
                        "   account for the sshd service?\n\n".
                        "   (If you wish to use a Domain User ID, please\n".
                        "   *make sure it exists* in the current Domain: $dom".
                        "\n   before".
                        " running FullAuto Setup. If you wish to use\n".
                        "   a Local account, FullAuto can use an existing\n".
                        "   one, or create a new one.)",
            );print "LINE=".__LINE__."\n";
            $selection=Menu(\%_cygserv);print "LINE=".__LINE__."\n";
            chomp $selection;print "LINE=".__LINE__."\n";
            exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
            $selection='UsE_separate_login_id_for_sshd'
               if -1<index $selection,'Use a Local';print "LINE=".__LINE__."\n";
         } else {
            test_windows_user_rights('cyg_server') if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
            $selection='cyg_server'; 
         }         
      } else {
         my %_cygserv=(

            Label => '_cygserv',
            Item_1 =>  {
                  Text   => "]C[",
                  Convey => [ 'Select ID from All Domain ID\'s',
                              'Use a Local account' ],
            },
            Banner=> "   'cyg_server' has *NOT* been located in the $dom ".
                     "Domain.\n".
                     "   If you wish to use the 'cyg_server' id as a Domain".
                     " ID\n".
                     "   for the OpenSSH sshd service on this host: ".
                     $hostname."\n".
                     "   type 'quit', exit FullAuto Setup, create the\n".
                     "   'cyg_server' User in the $dom Domain, and *then*\n".
                     "   run FullAuto Setup again.\n\n",
                     "   Or, would you rather select from all Domain Users,".
                     "   or use a Local account for the sshd service?\n\n".
                     "   (If you wish to use a Local account, FullAuto\n".
                     "    can use an existing one, or create a new one.)",
         );print "LINE=".__LINE__."\n";
         $selection=Menu(\%_cygserv);print "LINE=".__LINE__."\n";
         chomp($selection);print "LINE=".__LINE__."\n";
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
         $selection='UsE_separate_login_id_for_sshd'
            if -1<index $selection,'Use a Local';print "LINE=".__LINE__."\n";
      }
      if (-1<index $selection, 'All Domain' || !$cyg_id) {
         my %_users=(

            Label => '_users',
            Item_1 =>  {
                           Text   => "]C[",
                           Convey => \@users,
                       },
            Banner=> "   Select the $dom User to Run the sshd Service\n\n".
                     "   Hit <ENTER> or user ARROW keys to scroll\n\n".
                     "   List can be searched by typing  /[string]\n".
                     "   (forward slash key followed by text to search for).", 
         );print "LINE=".__LINE__."\n";
         $selection=Menu(\%_users);print "LINE=".__LINE__."\n";
         chomp($selection);print "LINE=".__LINE__."\n";
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
         test_windows_user_rights($selection) if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
      } elsif (-1<index $selection, 'Use Domain') {
         test_windows_user_rights('cyg_server') if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
         $selection='cyg_server'; 
      }
   }
   return $selection;print "LINE=".__LINE__."\n";

}

sub clean_mswin {
   my $rmdir_out=rmdir $main::curdir.'/inc/.author';print "LINE=".__LINE__."\n";
   print "ERROR $main::curdir/inc/.author: $!\n" unless $rmdir_out;print "LINE=".__LINE__."\n";
   my $un_out=unlink $main::curdir.'/inc/Module/Install/Base.pm';print "LINE=".__LINE__."\n";
   print "ERROR $main::curdir/inc/Module/Install/Base.pm: $!\n"
      unless $un_out;print "LINE=".__LINE__."\n";
   $un_out=unlink $main::curdir.'/inc/Module/Install/Metadata.pm';print "LINE=".__LINE__."\n";
   print "ERROR $main::curdir/inc/Module/Install.pm: $!\n" unless $un_out;print "LINE=".__LINE__."\n";
   $un_out=unlink $main::curdir.'/inc/Module/Install.pm';print "LINE=".__LINE__."\n";
   print "ERROR $main::curdir/inc/Module/Install.pm: $!\n" unless $un_out;print "LINE=".__LINE__."\n";
   $rmdir_out=rmdir $main::curdir.'/inc/Module/Install';print "LINE=".__LINE__."\n";
   print "ERROR /inc/Module/Install: $!\n" unless $rmdir_out;print "LINE=".__LINE__."\n";
   $rmdir_out=rmdir $main::curdir.'/inc/Module';print "LINE=".__LINE__."\n";
   print "ERROR $main::curdir/inc/Module: $!\n" unless $rmdir_out;print "LINE=".__LINE__."\n";
   unless (-e $main::PARdir.'/inc_exists.txt') {
      $rmdir_out=rmdir $main::curdir.'/inc';print "LINE=".__LINE__."\n";
      print "ERROR $main::curdir/inc: $!\n" unless $rmdir_out;print "LINE=".__LINE__."\n";
   } else {
      $un_out=unlink $main::PARdir.'/inc_exists.txt';print "LINE=".__LINE__."\n";
      print "ERROR $main::PARdir/inc_exists.txt: $!\n" unless $un_out;print "LINE=".__LINE__."\n";
   }

}

sub check_for_compiler
{

    # Borrowed from version module: version-0.9912

    # IMPORTANT NOTE:  This is NOT used to determine how to compile
    # extensions properly; EU::MM does that for us.  This is only
    # intended to see if that is likely to succeed.  We do not try
    # to do anything here except compile (not even link).  If you
    # want this to be a full featured test, feel free to submit a
    # patch or do something useful.

    print "Testing if you have a C compiler\n";

    eval { require ExtUtils::CBuilder };
    if ($@)
    {
        return _check_for_compiler_manually();
    }
    else
    {
        return _check_for_compiler_with_cbuilder();
    }
}

sub _check_for_compiler_with_cbuilder
{
    my $cb = ExtUtils::CBuilder->new( quiet => 1 );

    return $cb->have_compiler;
}

sub _check_for_compiler_manually
{
    unless ( open F, ">test.c" )
    {
        warn "Cannot write test.c, skipping test compilation.\n";
        return 0;
    }

    print F <<'EOF';
int main() { return 0; }
EOF

    close F or return 0;

    my ($cc, $ccflags, $obj_ext) = map { $Config{$_} } qw/cc ccflags obj_ext/;

    my $command;
    if ($^O =~ /(dos|win32)/i && $Config{'cc'} =~ /^cl/) {
        $command = "$cc $ccflags /c test.c";
    }
    elsif ($Config{gccversion}) {
        $command = "$cc $ccflags -o test$obj_ext test.c";
    }
    else {
        return 0;
    }

    my $retval = system( $command );
    map { unlink $_ if -f $_ } ('test.c',"test$obj_ext");

    return not($retval); # system returns -1
}

# Define metadata
if ($^O ne 'MSWin32' && $^O ne 'MSWin64') {

version         $main::VERSION;print "LINE=".__LINE__."\n";
name            'Net-FullAuto';print "LINE=".__LINE__."\n";
sign;print "LINE=".__LINE__."\n";
author          'Brian M. Kelly <Brian.Kelly@FullAuto.com>';print "LINE=".__LINE__."\n";
license         'gpl-3.0';print "LINE=".__LINE__."\n";
perl_version    '5.006';print "LINE=".__LINE__."\n";

}

require Mozilla::CA;print "LINE=".__LINE__."\n";
require Term::Menus;print "LINE=".__LINE__."\n";
require Term::ReadKey;print "LINE=".__LINE__."\n";
require Term::RawInput;print "LINE=".__LINE__."\n";
my $last_known_good_location=
      "http://download.oracle.com/berkeley-db/db-5.2.28.tar.gz";print "LINE=".__LINE__."\n";

if ($^O eq 'cygwin' || $^O eq 'MSWin32' || $^O eq 'MSWin64') {
   $ENV{'CYGWIN'}='nodosfilewarning' if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
}

BEGIN {
   unshift @ExtUtils::MakeMaker::Overridable, 'pm_to_blib';print "LINE=".__LINE__."\n";
};print "LINE=".__LINE__."\n";

my $process_id='';my $PREFIX='';print "LINE=".__LINE__."\n";
$process_id=pop @ARGV if $ARGV[$#ARGV-1]=~/^\d+$/;print "LINE=".__LINE__."\n";
my $install_cygwin_without_asking=0;print "LINE=".__LINE__."\n";
$main::cygwin_berkeley_db_mode=777;print "LINE=".__LINE__."\n";
if (exists $ENV{FA_BERKELEY} &&
      (-1<index $ENV{FA_BERKELEY},'Owner Group')) {
   $main::cygwin_berkeley_db_mode=770;print "LINE=".__LINE__."\n";
}
$main::mozrepl_file='mozrepl-1.1-fx.xpi';print "LINE=".__LINE__."\n";
$main::install_firefox_without_asking=0;print "LINE=".__LINE__."\n";
$main::install_firefox=0;print "LINE=".__LINE__."\n";
$main::install_firefox=$ENV{FA_MOZREPL} if exists $ENV{FA_MOZREPL};print "LINE=".__LINE__."\n";

if (exists $Config{prefix} &&
      $Config{prefix}) {
   $PREFIX=$Config{prefix};print "LINE=".__LINE__."\n";
}

foreach my $arg (@ARGV) {
   if ($arg=~/INSTALL_*CYGWIN\s*=\*1/i) {
      $install_cygwin_without_asking=1;print "LINE=".__LINE__."\n";
   } elsif ($arg=~/INSTALL_*FIREFOX\s*=\*1/i) {
      $main::install_firefox_without_asking=1;print "LINE=".__LINE__."\n";
   } elsif ($arg=~/-*-PREFIX=/i) {
      $PREFIX=$arg;print "LINE=".__LINE__."\n";
      $PREFIX=~s/^-*-[Pp][Rr][Ee][Ff][Ii][Xx]=//;print "LINE=".__LINE__."\n";
      $PREFIX=~s/^["']//;print "LINE=".__LINE__."\n";
      $PREFIX=~s/["']$//;print "LINE=".__LINE__."\n";
   }
}

$PREFIX='' if $PREFIX='/usr';print "LINE=".__LINE__."\n";

my $editor='';my $selection='';my $berkeleydb='';print "LINE=".__LINE__."\n";
if ($^O eq 'MSWin32' || $^O eq 'MSWin64') {

   my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";

   if ($cygwin_loc) {

      my %Menu_update_cyg=(

         Label  => 'Menu_update_cyg',
         Item_1 => {

            Text => "Update Cygwin Linux ".
                    "Emulation Layer for Windows at $cygwin_loc\n".
                    "                and ".
                    "INSTALL FullAuto:\n\n                ( FullAuto ".
                    "Install will download and utilize a number of ".
                    "\n                  development utilities including the".
                    " gcc compiler ).\n\n\n",
                    #"                -------------------------------".
                    #"---------------------------\n",

         },
         Item_2 => {

            Text => "Update Cygwin Linux ".
                    "Emulation Layer for Windows at $cygwin_loc\n            ".
                    "    and Install OpenSSH *ONLY*:\n\n              ".
                    "  ( This will update and configure Base Cygwin and ".
                    "OpenSSH only\n                  so that remote FullAuto ".
                    "processes can connect and interact\n                  ".
                    "with this host; but FullAuto itself will NOT be ".
                    "installed ).\n\n\n",

         },
         Item_3 => {

            Text    => "DO *NOT* Update Cygwin ( FullAuto Install will END )".
                       ".\n\n",

         },
         Banner => "   There are two types of installations available:\n\n",

      );print "LINE=".__LINE__."\n";
      if ($install_cygwin_without_asking) {
         $selection='Install';print "LINE=".__LINE__."\n";
      } else {
         $selection=Term::Menus::Menu(\%Menu_update_cyg);print "LINE=".__LINE__."\n";
         chomp($selection);print "LINE=".__LINE__."\n";
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
      }
   } else {

      my %Menu_win_to_cyg=(

         Label  => 'Menu_win_to_cyg',
         Item_1 => {

            Text => "INSTALL or Update Cygwin Linux ".
                    "Emulation Layer for Windows\n                and ".
                    "INSTALL FullAuto:\n\n                ( FullAuto ".
                    "Install will download and utilize a number of ".
                    "\n                  development utilities including the".
                    " gcc compiler ).\n\n\n",
                    #"                -------------------------------".
                    #"---------------------------\n",

         },
         Item_2 => {

            Text => "Install a *MINIMAL* Cygwin Linux ".
                    "Emulation Layer\n                for Windows and ".
                    "  DO *NOT*   Install FullAuto:\n\n                ( This ".
                    "will install and configure Base Cygwin and OpenSSH only".
                    "\n                  so that remote FullAuto ".
                    "processes can connect and interact\n                  ".
                    "with this host; but FullAuto itself will NOT be ".
                    "installed ).\n\n\n",

         },
         Item_3 => {

            Text    => "DO *NOT* Install Cygwin ( FullAuto Install will END ).",

         },
         Scroll => 1,
         Banner => "   There are two types of installations available:\n\n\n",

      );print "LINE=".__LINE__."\n";
      if ($install_cygwin_without_asking) {
         $selection='Install';print "LINE=".__LINE__."\n";
      } else {
         $selection=Term::Menus::Menu(\%Menu_win_to_cyg);print "LINE=".__LINE__."\n";
         chomp($selection);print "LINE=".__LINE__."\n";
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
      }
   }
   if ($selection!~/will END/s) {
      if ($selection!~/MINIMAL/s) {
         # http://pen-testing.sans.org/blog/2012/06/06/ \
         # escaping-restricted-linux-shells/comment-page-1/
         my @editors=('vim     ( ViIMproved - enhanced vi editor )',
                      'nano    ( Easiest - Recommended for Beginners )',
                      "emacs   ( The extensible, customizable,\n           ".
                      "               self-documenting real-time\n         ".
                      "                display editor )",
                      "joe     ( Fast and simple editor that\n             ".
                      '             emulates 5 other editors )', 
                     );print "LINE=".__LINE__."\n";
         my $tp='';print "LINE=".__LINE__."\n";
         unless ($tp=&fa_find_editor('TextPad.exe')) {
            if (-e ${ENV}{SystemDrive}.
                  "\\Program Files\\TextPad 5\\TextPad.exe") {
               $tp='default';print "LINE=".__LINE__."\n";
            }
         }
         if ($tp) {
            push @editors, 'TextPad (The Text Editor for Windows)';print "LINE=".__LINE__."\n";
         }

         my $banner="   In order to use the integrated edit features\n".
                    "   you will need to choose an editor.";print "LINE=".__LINE__."\n";
         my %Menu_select_editor=();print "LINE=".__LINE__."\n";
         if (-e ${ENV}{SystemDrive}.
                  "\\Program Files\\Windows NT\\Accessories\\wordpad.exe") {
            $banner="   In order is use the integrated edit features\n".
                    "   you will need to choose an editor. 'vim' (or 'vi')\n".
                    "   is set as the default - but it is recommended \n".
                    "   you try 'nano' if you do not know the vim or vi\n".
                    "   editor.\n\n";print "LINE=".__LINE__."\n";
            %Menu_select_editor=(

                  Label  => 'Menu_select_editor',
                  Item_1 => {

                     Text    => "]C[",
                     Convey  => \@editors,

                  },
                  Item_2 => {

                     Text => "Wordpad (Microsoft Wordpad -\n               ".
                             "        Available on all Windows Systems)",

                  },
                  Scroll => 1,
                  Banner => $banner,

            );print "LINE=".__LINE__."\n";
         } else {
            %Menu_select_editor=(

                  Label  => 'Menu_select_editor',
                  Item_1 => {

                     Text    => "]C[",
                     Convey  => \@editors,

                  },
                  Scroll => 1,
                  Banner => $banner,

            );print "LINE=".__LINE__."\n";
         }
      
         if ($install_cygwin_without_asking) {
            my $look_for_wordpad=${ENV}{SystemDrive}.
                  "\\Program Files\\Windows NT\\Accessories\\wordpad.exe";print "LINE=".__LINE__."\n";
            if (-e $look_for_wordpad) {
               $selection='wordpad';print "LINE=".__LINE__."\n";
               my $sysdr=`cmd /c echo %SystemDrive%`;print "LINE=".__LINE__."\n";
               $sysdr=~s/^\s*(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
               my $let=substr($sysdr,0,1);print "LINE=".__LINE__."\n";
               my $lt=lc($let);print "LINE=".__LINE__."\n";
               $editor='/cygdrive/'.$lt.'/Program Files/Windows NT/'.
                       'Accessories/wordpad.exe';print "LINE=".__LINE__."\n";
            }
         } elsif (0<$#editors) {
            $selection=Term::Menus::Menu(\%Menu_select_editor);print "LINE=".__LINE__."\n";
            chomp($selection);print "LINE=".__LINE__."\n";
            exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
         } elsif (0==$#editors) {
            $selection=$editors[0];print "LINE=".__LINE__."\n";
         }
         if ($selection=~/([Ww]ordpad)/) {
            $selection=$1;print "LINE=".__LINE__."\n";
            my $sysdr=`cmd /c echo %SystemDrive%`;print "LINE=".__LINE__."\n";
            $sysdr=~s/^\s*(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
            my $let=substr($sysdr,0,1);print "LINE=".__LINE__."\n";
            my $lt=lc($let);print "LINE=".__LINE__."\n";
            $editor='/cygdrive/'.$lt.
               '/Program Files/Windows NT/Accessories/wordpad.exe';print "LINE=".__LINE__."\n";
         } elsif ($selection=~/(TextPad)/) {
            $selection=$1;print "LINE=".__LINE__."\n";
            if ($tp eq 'default') {
               my $sysdr=`cmd /c echo %SystemDrive%`;print "LINE=".__LINE__."\n";
               $sysdr=~s/^\s*(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
               my $let=substr($sysdr,0,1);print "LINE=".__LINE__."\n";
               my $lt=lc($let);print "LINE=".__LINE__."\n";
               $editor='/cygdrive/'.$lt.
                  '/Program Files/TextPad 5/TextPad.exe';print "LINE=".__LINE__."\n";
            } else {
               $tp=~s/\\/\//g;print "LINE=".__LINE__."\n";
               $tp=~s/^([A-Za-z]):(.*)/$1$2/;print "LINE=".__LINE__."\n";
               $editor='/cygdrive/'.$tp;print "LINE=".__LINE__."\n";
            }
         } elsif ($selection=~/(vim)/) {
            $selection=$1;print "LINE=".__LINE__."\n";
            $editor='/bin/vim.exe';print "LINE=".__LINE__."\n";
         } elsif ($selection=~/(emacs)/) {
            $selection=$1;print "LINE=".__LINE__."\n";
            $editor='/bin/emacs.exe';print "LINE=".__LINE__."\n";
         } elsif ($selection=~/(joe)/) {
            $selection=$1;print "LINE=".__LINE__."\n";
            $editor='/bin/joe.exe';print "LINE=".__LINE__."\n";
         } elsif ($selection=~/(nano)/) {
            $selection=$1;print "LINE=".__LINE__."\n";
            $editor='/bin/nano.exe';print "LINE=".__LINE__."\n";
         }

         my $p_one='Install with Full Access Permissions (Default)';print "LINE=".__LINE__."\n";
         my $p_two='Install with Owner Group Permissions';print "LINE=".__LINE__."\n";
         my $p_banner="\n\n   FullAuto Security:\n".
                      "\n   Owner Group is more secure - but choose".
                      "\n   this only if security is important, and".
                      "\n   you know how to work with OS permissions\n\n".
                      "\n   Choose a Permission Setting :\n\n";print "LINE=".__LINE__."\n";
         my %Menu_select_permissions=(

            Label  => 'Menu_select_permissions',
            Item_1 => {
                         Text => $p_one,
                      },
            Item_2 => { Text => $p_two },
            Scroll => 1,
            Banner => $p_banner,

         );print "LINE=".__LINE__."\n";
         $selection=Term::Menus::Menu(\%Menu_select_permissions);print "LINE=".__LINE__."\n";
         chomp($selection);print "LINE=".__LINE__."\n";
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
         $main::cygwin_berkeley_db_mode=$selection;print "LINE=".__LINE__."\n";

         &find_windows_app() if 
            (-1==index $main::install_firefox,'Install') &&
            (-1==index $main::install_firefox,'NOT');print "LINE=".__LINE__."\n";

      }

      my $url='http://www.cygwin.com/setup-x86.exe';print "LINE=".__LINE__."\n";
      $url='http://www.cygwin.com/setup-x86_64.exe'
         if $^O eq 'MSWin64' || msw64bit();print "LINE=".__LINE__."\n";
      if ($CPAN::META->has_usable('LWP')) {
         FA::LWP::UserAgent->config;print "LINE=".__LINE__."\n";
         print "Fetching with LWP:\n  $url\n";print "LINE=".__LINE__."\n";
         my $Ua;print "LINE=".__LINE__."\n";
         eval { $Ua = FA::LWP::UserAgent->new(
                timeout=>300,show_progress=>1) };print "LINE=".__LINE__."\n";
         if ($@) {
            $CPAN::Frontend->mywarn(
               "ERROR: FA::LWP::UserAgent->new dies with $@\n");print "LINE=".__LINE__."\n";
         } else {
            my($var);print "LINE=".__LINE__."\n";
            $Ua->proxy('http', $var)
               if $var = $CPAN::Config->{http_proxy} ||
               $ENV{http_proxy};print "LINE=".__LINE__."\n";
            $Ua->no_proxy($var)
               if $var = $CPAN::Config->{no_proxy} || $ENV{no_proxy};print "LINE=".__LINE__."\n";
         }
         my $req = HTTP::Request->new(GET => $url);print "LINE=".__LINE__."\n";
         $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
         my $res = $Ua->request($req);print "LINE=".__LINE__."\n";
         if ($res->is_success) {
            print " + request successful.\n"
               if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
            mkpath($main::root_dir,1) unless -d $main::root_dir;print "LINE=".__LINE__."\n";
            unless (-w $main::root_dir) {
               print "\n\n   Fatal Error! - The current Cygwin directory: ".
                        "\n\n      ".$main::root_dir."\n\n".
                        "   is not writable. Please change the permissions\n".
                        "   to writable before installing FullAuto.\n";print "LINE=".__LINE__."\n";
               print "\n   PRESS ANY KEY TO EXIT SETUP\n\n";print "LINE=".__LINE__."\n";
               <STDIN>;print "LINE=".__LINE__."\n";
               exit 1;print "LINE=".__LINE__."\n";
            }
            if ($^O eq 'MSWin64' || msw64bit()) {
               open(CP,">$main::root_dir\\setup-x86_64.exe") || die $!;print "LINE=".__LINE__."\n";
            } else {
               open(CP,">$main::root_dir\\setup-x86.exe") || die $!;print "LINE=".__LINE__."\n";
            }
            binmode(CP);print "LINE=".__LINE__."\n";
            print CP $res->content;print "LINE=".__LINE__."\n";
            my $cyghome=$Ua->get('http://www.cygwin.com');print "LINE=".__LINE__."\n";
            if ($^O ne 'cygwin' && $cyghome->is_success) {
               my $content=$cyghome->content;print "LINE=".__LINE__."\n";
               my $cygver='';print "LINE=".__LINE__."\n";
               ($cygver=$content)=~
                  s/^.*of the Cygwin DLL is ([\d|.|-]). In.*$/$1/s;print "LINE=".__LINE__."\n";
               if ($cygver=~/(1.7.11-1)/) {
                  print "\n\n   Fatal Error! - The current Cygwin version: $1".
                        "\n   (Base Cygwin cygwin1.dll) at cygwin.com is\n".
                        "   incompatible with FullAuto. Please manually\n".
                        "   download the setup utility from www.cygwin.com,\n".
                        "   and install an\n   older version of Base Cygwin.\n".
                        "   Only then can\n   successfully install FullAuto.\n".
                        "   Optionally, you\n   can also manually install\n".
                        "   Perl when setting up\n   a compatible version of\n".
                        "   Cygwin, and afterwards\n   use the bundled cpan\n".
                        "   utility to install FullAuto\n   You may need to\n".
                        "   contact your Windows System\n   Administrator to\n".
                        "   resolve.\n\n".
                        "   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
                  <STDIN>;print "LINE=".__LINE__."\n";
                  exit 1;print "LINE=".__LINE__."\n";
               }
            } 
         } elsif ($res->status_line=~/403/) {
            if ($^O eq 'MSWin64' || msw64bit()) { 
               $url='http://www.FullAuto.com/download/setup-x86_64.exe';print "LINE=".__LINE__."\n";
            } else {
               $url='http://www.FullAuto.com/download/setup-x86.exe';print "LINE=".__LINE__."\n";
            }
            $req = HTTP::Request->new(GET => $url);print "LINE=".__LINE__."\n";
            $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
            $res = $Ua->request($req);print "LINE=".__LINE__."\n";
            if ($res->is_success) {
               print " + request successful.\n"
                  if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
               mkpath($main::root_dir,1) unless -d $main::root_dir;print "LINE=".__LINE__."\n";
               if ($^O eq 'MSWin64' || msw64bit()) {
                  open(CP,">$main::root_dir\\setup-x86_64.exe") || die $!;print "LINE=".__LINE__."\n";
               } else {
                  open(CP,">$main::root_dir\\setup-x86.exe") || die $!;print "LINE=".__LINE__."\n";
               }
               binmode(CP);print "LINE=".__LINE__."\n";
               print CP $res->content;print "LINE=".__LINE__."\n";
            } elsif ($res->status_line=~/403/) {
               $url='http://www.FullAuto.com/download/setup.tar.gz';print "LINE=".__LINE__."\n";
               $req = HTTP::Request->new(GET => $url);print "LINE=".__LINE__."\n";
               $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
               $res = $Ua->request($req);print "LINE=".__LINE__."\n";
               if ($res->is_success) {
                  print " + request successful.\n"
                     if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
                  open(CP,">$main::PARdir\\setup.tar.gz") || die $!;print "LINE=".__LINE__."\n";
                  binmode(CP);print "LINE=".__LINE__."\n";
                  print CP $res->content;print "LINE=".__LINE__."\n";
               } else {
                  print $res->status_line;print "LINE=".__LINE__."\n";
                  sleep 10;print "LINE=".__LINE__."\n";
                  die $res->status_line;print "LINE=".__LINE__."\n";
               }
            } else {
               print $res->status_line;print "LINE=".__LINE__."\n";
               sleep 10;print "LINE=".__LINE__."\n";
               die $res->status_line;print "LINE=".__LINE__."\n";
            }
         } else {
            print $res->status_line;print "LINE=".__LINE__."\n";
            sleep 10;print "LINE=".__LINE__."\n";
            die $res->status_line;print "LINE=".__LINE__."\n";
         }
         close(CP) || die $!;print "LINE=".__LINE__."\n";
         if ($^O eq 'MSWin64' || msw64bit()) {
            chmod 0755, "$main::root_dir\\setup-x86_64.exe";print "LINE=".__LINE__."\n";
         } else {
            chmod 0755, "$main::root_dir\\setup-x86.exe";print "LINE=".__LINE__."\n";
         }
        
         my $mirror_url='http://www.cygwin.com/mirrors.html';print "LINE=".__LINE__."\n";
         $req = HTTP::Request->new(GET => $mirror_url);print "LINE=".__LINE__."\n";
         $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
         $res = $Ua->request($req);print "LINE=".__LINE__."\n";
         my $href='';my @urls=();print "LINE=".__LINE__."\n";
         $mirror_url='http://cygwin.mirrors.pair.com';print "LINE=".__LINE__."\n";
         if ($res->is_success) {
            print " + request successful.\n"
               if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
            my $mirrors=$res->content;print "LINE=".__LINE__."\n";
            foreach my $href ($mirrors=~/href="(.*?)"/mg) {
               next if -1==index $href,'://';print "LINE=".__LINE__."\n";
               next if -1<index $href,'html';print "LINE=".__LINE__."\n";
               next if -1==index $href,'http';print "LINE=".__LINE__."\n";
               push @urls, $href;print "LINE=".__LINE__."\n";
            }
            $mirror_url=$urls[int(rand($#urls))];print "LINE=".__LINE__."\n";
         }
         my $setup_cmd='';print "LINE=".__LINE__."\n";
         my $drlet=substr($main::root_dir,0,2);print "LINE=".__LINE__."\n";
         if ($selection!~/[Ww]ordpad|MINIMAL/s) {
            if ($selection eq 'vim') {
               $selection='';print "LINE=".__LINE__."\n";
            } else {
               $selection=",$selection";print "LINE=".__LINE__."\n";
            }
            if ($^O eq 'MSWin64' || msw64bit()) {
               $setup_cmd="$drlet & cd \"$main::root_dir\" & "
                      .'setup-x86_64.exe -P gcc-core,perl-libwww-perl,'
                      .'gcc-g++,make,openssh,openssl,openssl-devel,perl,'
                      .'procps,vim,unzip,libmpfr4,figlet,wget,get,'
                      .'db,libdb-devel,ncurses,cron,inetutils,'
                      .'git,libcrypt-devel,perl-LWP-Protocol-https,nano,'
                      .$selection.' -X -A -q '."-R $main::root_dir "
                      .'-s '.$mirror_url;print "LINE=".__LINE__."\n";
            } else {
               $setup_cmd="$drlet & cd \"$main::root_dir\" & "
                      .'setup-x86.exe -P gcc-core,nano,'
                      .'gcc-g++,make,openssh,openssl,openssl-devel,perl,'
                      .'perl-Win32,db4.8,libdb4.8-devel,ncurses,cron,'
                      .'inetutils,procps,vim,unzip,libmpfr4,figlet,git,'
                      .'wget -X -A -q '."-R $main::root_dir "
                      .'-s '.$mirror_url;print "LINE=".__LINE__."\n";
            }
         } elsif ($selection!~/MINIMAL/s) {
            if ($^O eq 'MSWin64' || msw64bit()) {
               $setup_cmd="$drlet & cd \"$main::root_dir\" & "
                      .'setup-x86_64.exe -P gcc-core,perl-libwww-perl,'
                      .'gcc-g++,make,openssh,openssl,openssl-devel,perl,'
                      .'procps,vim,unzip,libmpfr4,figlet,wget,get,'
                      .'db,libdb-devel,ncurses,cron,inetutils,'
                      .'git,libcrypt-devel,perl-LWP-Protocol-https,nano,'
                      .$selection.' -X -A -q '."-R $main::root_dir "
                      .'-s '.$mirror_url;print "LINE=".__LINE__."\n";
            } else {
               $setup_cmd="$drlet & cd \"$main::root_dir\" & "
                      .'setup-x86.exe -P gcc-core,nano,'
                      .'gcc-g++,make,openssh,openssl,openssl-devel,perl,'
                      .'perl-Win32,db4.8,libdb4.8-devel,ncurses,cron,'
                      .'inetutils,procps,vim,unzip,libmpfr4,figlet,git,'
                      .'wget -X -A -q '."-R $main::root_dir "
                      .'-s '.$mirror_url;print "LINE=".__LINE__."\n";
            }
         } else {
            if ($^O eq 'MSWin64' || msw64bit()) {
               $setup_cmd="$drlet & cd \"$main::root_dir\" & "
                      .'setup-x86_64.exe -P openssh,ncurses,inetutils,'
                      .'procps,git,vim,nano,libmpfr4,figlet,wget '
                      .'-X -A -q '."-R $main::root_dir ".'-s '.$mirror_url;print "LINE=".__LINE__."\n";
            } else {
               $setup_cmd="$drlet & cd \"$main::root_dir\" & "
                      .'setup-x86.exe -P openssh,ncurses,inetutils,'
                      .'procps,vim,nano,libmpfr4,figlet,git,wget '
                      .'-X -A -q '."-R $main::root_dir ".'-s '.$mirror_url;print "LINE=".__LINE__."\n";
            }
         }
         
         my $wver=&windows_ver;print "LINE=".__LINE__."\n";
         my $account_type='separate';print "LINE=".__LINE__."\n";
         my @sshd_password=();print "LINE=".__LINE__."\n";
         my $sshd_account='cyg_server';print "LINE=".__LINE__."\n";
         my $privl='';print "LINE=".__LINE__."\n";
         my $domain_user='';my $domain='';print "LINE=".__LINE__."\n";
         if ($wver!~/95|98|ME/) {
            my $domain=`net config workstation`;print "LINE=".__LINE__."\n";
            $domain=~/^.*Workstation domain\s+(.+)\s*$/m;print "LINE=".__LINE__."\n";
            $domain=$1||'';print "LINE=".__LINE__."\n";
            $domain=~tr/\0-\37\177-\377//d;print "LINE=".__LINE__."\n";
            chomp($domain);print "LINE=".__LINE__."\n";
            if ($wver=~/XP|2000|NT/) {
               my $banner="   For $wver, you have a choice of using\n"
                         ."   either the LocalSystem account for the\n"
                         ."   REQUIRED sshd (Secure Shell Daemon/Service\n"
                         ."   supplied by OpenSSH) or a separate user\n"
                         ."   account. The LocalSystem account is less\n"
                         ."   maintenance and you won't need to manage or\n"
                         ."   remember a separate account and password -\n"
                         ."   BUT IT IS LESS SECURE. Using a separate user\n"
                         ."   account is *HIGHLY* recommended!:";print "LINE=".__LINE__."\n";
               my %Menu_select_account_type=(
         
                   Label  => 'Menu_select_account_type',
                   Item_1 => {
        
                      Text => "Use LocalSystem account for sshd service", 
         
                   },
                   Item_2 => {

                      Text => "Use separate user account for sshd service", 
         
                   },
                   Banner => $banner,
         
               );print "LINE=".__LINE__."\n";
               $account_type=Term::Menus::Menu(\%Menu_select_account_type);print "LINE=".__LINE__."\n";
               chomp($account_type);print "LINE=".__LINE__."\n";
               exit if $account_type eq ']quit[';print "LINE=".__LINE__."\n";
               $privl=' --privileged' if -1<index $account_type,'separate';print "LINE=".__LINE__."\n";
            }
            $domain_user=&ws_info($domain) unless $wver=~/XP|2000|NT/;print "LINE=".__LINE__."\n";
            my $setup_cyg_server=0;print "LINE=".__LINE__."\n";
            if ($domain_user eq 'UsE_separate_login_id_for_sshd') {
               $account_type='separate';print "LINE=".__LINE__."\n";
               $domain_user='';print "LINE=".__LINE__."\n";
               $setup_cyg_server=1 if (-1==index `net user`,'cyg_server');print "LINE=".__LINE__."\n";
            }
            if ($domain_user) {
               print "\n\n\n   Please enter the Password for the $domain ",
                     "account $domain_user,\n   and take steps to insure ".
                     "it's security and recoverability\n   ",
                     "(i.e. - store a copy in a SAFE ",
                     "place where you can find\n   it if necessary.)\n\n\n",
                     "   Please TYPE the Password\n   for ",
                     "$domain domain account \'$domain_user\': ";print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
               my $pas=<STDIN>;print "LINE=".__LINE__."\n";
               $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
               $sshd_password[0]=$1;print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
               chomp($sshd_password[0]);print "LINE=".__LINE__."\n";
               print "\n\n   Please verify the $domain_user Password: ";print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
               $pas=<STDIN>;print "LINE=".__LINE__."\n";
               $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
               $sshd_password[1]=$1;print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
               chomp($sshd_password[1]);print "LINE=".__LINE__."\n";
               if ($sshd_password[0] ne $sshd_password[1]) {
                  @sshd_password=();print "LINE=".__LINE__."\n";
                  my $cc=2;print "LINE=".__LINE__."\n";
                  while ($cc--) {
                     print "\n\n";print "LINE=".__LINE__."\n";
                     print "   Your Password entries do NOT match!\n\n",
                           "   Please carefully type the\n",
                           "   $domain_user Password: ";print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
                     $pas=<STDIN>;print "LINE=".__LINE__."\n";
                     $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
                     $sshd_password[0]=$1;print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
                     chomp($sshd_password[0]);print "LINE=".__LINE__."\n";
                     print "\n\n   Please verify the $domain_user Password: ";print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
                     $pas=<STDIN>;print "LINE=".__LINE__."\n";
                     $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
                     $sshd_password[1]=$1;print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
                     chomp($sshd_password[1]);print "LINE=".__LINE__."\n";
                     last if $sshd_password[0] eq $sshd_password[1];print "LINE=".__LINE__."\n";
                  }
               }
               if ($sshd_password[0] ne $sshd_password[1]) {
                  print "\n\n";print "LINE=".__LINE__."\n";
                  print "Fatal Error: Unable to verify Password entries!\n\n";print "LINE=".__LINE__."\n";
                  print "Press any key to exit FullAuto Setup.\n";print "LINE=".__LINE__."\n";
                  <STDIN>;exit 1;print "LINE=".__LINE__."\n";
               }
               print "\n";print "LINE=".__LINE__."\n";
            } elsif (((-1<index $account_type,'separate') &&
                     (&test_windows_user($sshd_account))) ||
                      $setup_cyg_server) {
               my $banner="   OpenSsh's sshd service running via Cygwin is ".
                  "recommended for\n   FullAuto running on MS Windows. Two ".
                  "separate user accounts\n   are needed - one for the ".
                  "service itself, and one for \"privilege\n   separation\"".
                  " The id 'sshd' will be created for the privilege\n".
                  "   separation purpose. For more info,\n".
                  "   read /usr/share/doc/openssh/README.privsep.\n\n".
                  "   Unless you indicate otherwise, the account 'cyg_server'".
                  " will be\n   utilized by the sshd service and will be ".
                  "automatically created\n   if needed.\n\n   Please make ".
                  "a selection:\n\n";print "LINE=".__LINE__."\n";
               my $sa=$sshd_account;print "LINE=".__LINE__."\n";
               my %Menu_select_account=(

                  Label  => 'Menu_select_account',
                  Item_1 => {

                    Text => "Use the account \'$sa\' for the sshd service",

                  },
                  Item_2 => {

                    Text => "Use a different account ( You will be prompted. )",

                  },
                  Scroll => 1,
                  Banner => $banner,

               );print "LINE=".__LINE__."\n";
               $selection=Term::Menus::Menu(\%Menu_select_account);print "LINE=".__LINE__."\n";
               chomp($selection);print "LINE=".__LINE__."\n";
               exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
               if (-1<index $selection,'different') {
                  print "\n       Please type the name of the $wver\n",
                        "        user account that will be used by the sshd\n",
                        "        service: ";print "LINE=".__LINE__."\n";
                  $sshd_account=<STDIN>;print "LINE=".__LINE__."\n";
                  print "\n";print "LINE=".__LINE__."\n";
               }
               print "\n\n\n   Now is the time to CAREFULLY select a ",
                     "password for the\n   $sshd_account account, and",
                     " take steps to insure it's security\n   and ",
                     "recoverability (i.e. - store a copy in a SAFE ",
                     "place where\n   you can find it if necessary.)\n\n\n",
                     "   Please TYPE your new Password\n   for ",
                     "account \'$sshd_account\': ";print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
               my $pas=<STDIN>;print "LINE=".__LINE__."\n";
               $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
               $sshd_password[0]=$1;print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
               chomp($sshd_password[0]);print "LINE=".__LINE__."\n";
               print "\n\n   Please verify your new Password: ";print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
               $pas=<STDIN>;print "LINE=".__LINE__."\n";
               $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
               $sshd_password[1]=$1;print "LINE=".__LINE__."\n";
               Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
               chomp($sshd_password[1]);print "LINE=".__LINE__."\n";
               if ($sshd_password[0] ne $sshd_password[1]) {
                  @sshd_password=();print "LINE=".__LINE__."\n";
                  my $cc=2;print "LINE=".__LINE__."\n";
                  while ($cc--) {
                     print "\n\n";print "LINE=".__LINE__."\n";
                     print "   Your Password entries do NOT match!\n\n",
                           "   Please carefully type your\n",
                           "   new Password: ";print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
                     $pas=<STDIN>;print "LINE=".__LINE__."\n";
                     $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
                     $sshd_password[0]=$1;print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
                     chomp($sshd_password[0]);print "LINE=".__LINE__."\n";
                     print "\n\n   Please verify your new Password: ";print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(2);print "LINE=".__LINE__."\n";
                     $pas=<STDIN>;print "LINE=".__LINE__."\n";
                     $pas=~/^(.*)$/;print "LINE=".__LINE__."\n";
                     $sshd_password[1]=$1;print "LINE=".__LINE__."\n";
                     Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
                     chomp($sshd_password[1]);print "LINE=".__LINE__."\n";
                     last if $sshd_password[0] eq $sshd_password[1];print "LINE=".__LINE__."\n";
                  }
               }
               if ($sshd_password[0] ne $sshd_password[1]) {
                  print "\n\n";print "LINE=".__LINE__."\n";
                  print "Fatal Error: Unable to verify Password entries!\n\n";print "LINE=".__LINE__."\n";
                  print "Press any key to exit FullAuto Setup.\n";print "LINE=".__LINE__."\n";
                  <STDIN>;exit 1;print "LINE=".__LINE__."\n";
               }
            } else {
               my $netuser=`net user`;print "LINE=".__LINE__."\n";
               $netuser=~s/^.*----(.*)The command comp.*$/$1/s;print "LINE=".__LINE__."\n";
               $netuser=~s/^\s*//s;print "LINE=".__LINE__."\n";
               $netuser=~s/\s*$//s;print "LINE=".__LINE__."\n";
               $netuser=~s/\n/         /g;print "LINE=".__LINE__."\n";
               my @netuser=split /    \s*/, $netuser;print "LINE=".__LINE__."\n";
               @netuser=grep { $_ ne 'sshd' } @netuser;print "LINE=".__LINE__."\n";
               my %sshd_account=();print "LINE=".__LINE__."\n";
               if (grep { 'cyg_server' eq $_ } @netuser) {
                  my $cs_info=`net user cyg_server`;print "LINE=".__LINE__."\n";
                  my $pwls='';my $ll='';print "LINE=".__LINE__."\n";
                  ($pwls=$cs_info)
                     =~s/^.*(Password last set\s*.*?(?:PM|AM)).*/$1/s;print "LINE=".__LINE__."\n";
                  ($ll=$cs_info)
                     =~s/^.*(Last logon\s*.*?(?:PM|AM)).*/$1/s;print "LINE=".__LINE__."\n";
                  %sshd_account=(

                     Label => 'sshd_account',
                     Item_1 => {

                        Text => 'Remove and recreate local \'cyg_server\''.
                                ' account.'.
                                "\n                 ( Recommended )\n\n",
                     },
                     Item_2 => {

                        Text => 'Use the pre-existing local \'cyg_server\''.
                                " account.\n\n",

                     },
                     Item_3 => {

                        Text => 'Use or create a different local account.',

                     },
                     Banner => "\n   Cygwin's sshd service requires a".
                               "\n   dedicated Windows user account.".
                               "\n   A pre-existing local \'cyg_server\' ID ".
                               "\n   was found with the following properies:".
                               "\n\n      $pwls\n      $ll".
                               "\n\n   Please select an action:",


                  );print "LINE=".__LINE__."\n";
               }
               my $selection=Menu(\%sshd_account);print "LINE=".__LINE__."\n";
               if (-1<index $selection, 'Remove') {
                  my $ndout=`net user sshd /DELETE 2>&1`;print "LINE=".__LINE__."\n";
                  my $cgout=`net user cyg_server /DELETE 2>&1`;print "LINE=".__LINE__."\n";
               } elsif (-1==index $selection, 'pre-existing') {
                  @netuser=grep { $_ ne 'cyg_server' } @netuser;print "LINE=".__LINE__."\n";
                  %sshd_account=(

                     Label => 'sshd_account',
                     Item_1 => {

                        Text => 'Create a new dedicated Windows user account'.
                                "\n                   (You will be prompted)".
                                "\n\n",

                     },
                     Item_2 => {

                        Text => 'Use the pre-existing \']C[\' local account.',
                        Convey => \@netuser,

                     },
                     Banner => "\n   Cygwin's sshd service requires a".
                               "\n   dedicated Windows user account.".
                               "\n   You can select a pre-existing one,".
                               "\n   or elect to use a different one.".
                               "\n\n   Please select an action:",


                  );print "LINE=".__LINE__."\n";
                  $selection=Menu(\%sshd_account);print "LINE=".__LINE__."\n";
                  chomp($selection);print "LINE=".__LINE__."\n";
                  exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
                  if (-1<index $selection,'pre-exist') {
                     $selection=~s/^.*?['](.*?)['].*$/$1/;print "LINE=".__LINE__."\n";
                     $sshd_account=$selection;print "LINE=".__LINE__."\n";
                  } else {


                  }
               }
# Check if cyg_server exists but is bad
# Then either remove and ask or just ask if cyg_server or other id
            }
            # Let's see if Cygwin remnants remain that could mess
            # up the installation
            my $check_for_orphaned_sshd_service=`sc qc sshd 2>&1`;              
            unless (-1<index $check_for_orphaned_sshd_service,'does not') {
               my $cygpath=~s/^.*H_NAME\s+:\s+(.*exe).*$/$1/s;print "LINE=".__LINE__."\n";
               $cygpath=~s/\\/\//g;print "LINE=".__LINE__."\n";
               unless (-e $cygpath) {
                  # cygrunsrv does not exist - let's see if its running?
                  my $chkrun=`sc query sshd 2>&1`;print "LINE=".__LINE__."\n";
                  if (-1<index $chkrun,'RUNNING') {
                     # Its running - let's stop it
                     my $stopout=`net stop sshd 2>&1`;print "LINE=".__LINE__."\n";
                     unless (-1<index $stopout,'stopped suc') {
                        print "FATAL ERROR - cannot stop sshd: $stopout\n";print "LINE=".__LINE__."\n";
                        exit 1;print "LINE=".__LINE__."\n";
                     } 
                  }
                  # Now let's delete sshd 
                  my $sc_out=`sc delete sshd 2>&1`;print "LINE=".__LINE__."\n";
                  unless (-1<$sc_out,'SUCCESS') {
                     print "FATAL ERROR - cannot delete sshd: $sc_out\n";print "LINE=".__LINE__."\n";
                     exit 1;print "LINE=".__LINE__."\n";
                  }
               }
            }
            my $check_for_orphaned_cygserver_service=`sc qc cygserver 2>&1`;print "LINE=".__LINE__."\n";
            unless (-1<index $check_for_orphaned_cygserver_service,'does not') {
               my $cygpath=~s/^.*H_NAME\s+:\s+(.*exe).*$/$1/s;print "LINE=".__LINE__."\n";
               $cygpath=~s/\\/\//g;print "LINE=".__LINE__."\n";
               unless (-e $cygpath) {
                  # cygrunsrv does not exist - let's see if its running?
                  my $chkrun=`sc query cygserver 2>&1`;print "LINE=".__LINE__."\n";
                  if (-1<index $chkrun,'RUNNING') {
                     # Its running - let's stop it
                     my $stopout=`net stop cygserver 2>&1`;print "LINE=".__LINE__."\n";
                     unless (-1<index $stopout,'stopped suc') {
                        print "FATAL ERROR - cannot stop cygserver: $stopout\n";print "LINE=".__LINE__."\n";
                        exit 1;print "LINE=".__LINE__."\n";
                     }
                  }
                  # Now let's delete cygserver
                  my $sc_out=`sc delete cygserver 2>&1`;print "LINE=".__LINE__."\n";
                  unless (-1<$sc_out,'SUCCESS') {
                     print "FATAL ERROR - cannot delete cygserver: $sc_out\n";print "LINE=".__LINE__."\n";
                     exit 1;print "LINE=".__LINE__."\n";
                  }
               }
            }
         }
         
         my $pwd=`cmd /c chdir`;print "LINE=".__LINE__."\n";
         chmod($pwd);print "LINE=".__LINE__."\n";
         my $cygpath=$pwd;print "LINE=".__LINE__."\n";
         $cygpath=~s/^(.):/\/cygdrive\/$1/;print "LINE=".__LINE__."\n";
         $cygpath=~s/\\/\//g;print "LINE=".__LINE__."\n";
         system($setup_cmd);print "LINE=".__LINE__."\n";

         if ($^O eq 'cygwin') {
            my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
            my $clo=$cygwin_loc;print "LINE=".__LINE__."\n";
            $clo=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
            my $srvcmd='export CYGWIN=nodosfilewarning & '.
                       "cmd /c $clo\\\\bin\\\\bash -lc ".
                       '"/usr/bin/cygrunsrv -L"';print "LINE=".__LINE__."\n";
            my $cygsrvs=`$srvcmd 2>&1`;print "LINE=".__LINE__."\n";
            if (-1==index $cygsrvs,'sshd') {
               if ($domain_user) {
                  system('export CYGWIN=nodosfilewarning & '.
                         "cmd /c $clo\\\\bin\\\\bash -lc ".
                         '"/usr/bin/mkpasswd -u \"'.$domain_user.'\" '.
                         '-d \"'.$domain.'\" >> /etc/passwd"');print "LINE=".__LINE__."\n";
                  system('export CYGWIN=nodosfilewarning & '.
                         "cmd /c $clo\\\\bin\\\\bash -lc ".
                         '"/usr/bin/mkgroup -d \"'.$domain.'\" '.
                         '-g  \"Domain Users\" '.
                         '>> /etc/group"');print "LINE=".__LINE__."\n";
                  $main::domain_gr_flag=1;print "LINE=".__LINE__."\n";
                  $sshd_account=$domain_user;print "LINE=".__LINE__."\n";
               }
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/ssh-host-config -y '.
                      '-u \"'.$sshd_account.'\" -w \"'.
                      $sshd_password[0].'\" '.
                      '-c \"ntsec\"'.$privl.'"');print "LINE=".__LINE__."\n";
               print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/ssh-user-config -n"');print "LINE=".__LINE__."\n";
               print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
            }
            if (-1==index $cygsrvs,'cygserver') {
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/cygserver-config -y"');print "LINE=".__LINE__."\n";
            }
            #system('export CYGWIN=nodosfilewarning & '.
            #       "cmd /c $clo\\\\bin\\\\bash -lc ".
            #       '"/usr/bin/cron-config"');print "LINE=".__LINE__."\n";
            if (-1==index $cygsrvs,'sshd') {
               my $netstart="cmd /c $clo\\\\bin\\\\bash -lc ".
                    '"net start sshd 2>&1"';print "LINE=".__LINE__."\n";
               my $netout=`$netstart`;print "LINE=".__LINE__."\n";
            }
            if (-1==index $cygsrvs,'cygserver') {
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"net start cygserver 2>&1"');print "LINE=".__LINE__."\n";
            }
            #system('export CYGWIN=nodosfilewarning & '.
            #       "cmd /c $clo\\\\bin\\\\bash -lc ".
            #       '"net start cron 2>&1"');print "LINE=".__LINE__."\n";
         } else {
            my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
            my $clo=$cygwin_loc;print "LINE=".__LINE__."\n";
            $clo=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
print "CLO=$clo\n";print "LINE=".__LINE__."\n";
            my $srvcmd='SET CYGWIN=nodosfilewarning & '.
                       "cmd /c $clo\\\\bin\\\\bash -lc ".
                       '"/usr/bin/cygrunsrv -L 2>&1"';print "LINE=".__LINE__."\n";
            my $cygsrvs=`$srvcmd 2>&1`;print "LINE=".__LINE__."\n";
print "CYGSRVS=$cygsrvs\n";print "LINE=".__LINE__."\n";
            if (-1<index $cygsrvs,'system cannot find') {
               $url='http://www.cygwin.com/mirrors.html';print "LINE=".__LINE__."\n";
               $req = HTTP::Request->new(GET => $url);print "LINE=".__LINE__."\n";
               $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
               $res = $Ua->request($req);print "LINE=".__LINE__."\n";
               my $href='';my @urls=();my $mirror_url2='';print "LINE=".__LINE__."\n";
               if ($res->is_success) {
                  print " + request successful.\n"
                     if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
                  my $mirrors=$res->content;print "LINE=".__LINE__."\n";
                  foreach my $href ($mirrors=~/href="(.*?)"/mg) {
                     next if -1==index $href,'://';print "LINE=".__LINE__."\n";
                     next if -1<index $href,'html';print "LINE=".__LINE__."\n";
                     next if -1==index $href,'http';print "LINE=".__LINE__."\n";
                     next if -1<index $href,$mirror_url;print "LINE=".__LINE__."\n";
                     push @urls, $href;print "LINE=".__LINE__."\n";
                  }
                  $mirror_url2=$urls[int(rand($#urls))];print "LINE=".__LINE__."\n";
                  $setup_cmd=~s/-s .*$/-s $mirror_url2/; 
                  system($setup_cmd);print "LINE=".__LINE__."\n";
                  my $srvcmd='SET CYGWIN=nodosfilewarning & '.
                             "cmd /c $clo\\\\bin\\\\bash -lc ".
                             '"/usr/bin/cygrunsrv -L 2>&1"';print "LINE=".__LINE__."\n";
                  my $cygsrvs=`$srvcmd 2>&1`;print "LINE=".__LINE__."\n";
                  if (-1<index $cygsrvs,'system cannot find') {
                     print "\n\n".
                        "   Fatal Error! (1) - Cannot install Cygwin\n".
                        "   There were two attempts from two different\n\n".
                        "   Cygwin mirror sites:\n\n".
                        "   $mirror_url\n".
                        "   $mirror_url2\n\n";print "LINE=".__LINE__."\n";
                        "   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
                     <STDIN>;print "LINE=".__LINE__."\n";
                     exit 1;print "LINE=".__LINE__."\n";
                  }
               } else {
                  print "\n\n".
                     "   Fatal Error! (2) - Cannot install Cygwin\n".
                     "   There were two attempts from two different\n\n".
                     "   Cygwin mirror sites:\n\n".
                     "   $mirror_url\n".
                     "   $mirror_url2\n\n";print "LINE=".__LINE__."\n";
                     "   PRESS ANY KEY to Exit Setup\n\n";print "LINE=".__LINE__."\n";
                  <STDIN>;print "LINE=".__LINE__."\n";
                  exit 1;print "LINE=".__LINE__."\n";
               }
            } elsif (-1==index $cygsrvs,'sshd') {
               if ($domain_user) {
                  system('SET CYGWIN=nodosfilewarning & '.
                         "cmd /c $clo\\bin\\bash -lc ".
                         '"/usr/bin/mkpasswd -u \"'.$domain_user.'\" '.
                         '-d \"'.$domain.'\" >> /etc/passwd"');print "LINE=".__LINE__."\n";
                  unless ($main::domain_gr_flag) {
                     system('SET CYGWIN=nodosfilewarning & '.
                         "cmd /c $clo\\bin\\bash -lc ".
                         '"/usr/bin/mkgroup -d \"'.$domain.'\" '.
                         '-g  \"Domain Users\" '.
                         '>> /etc/group"');print "LINE=".__LINE__."\n";
                     $main::domain_gr_flag=1;print "LINE=".__LINE__."\n";
                  }
                  $sshd_account=$domain_user;print "LINE=".__LINE__."\n";
               }
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"/usr/bin/ssh-host-config -y '.
                      '-u \"'.$sshd_account.'\" -w \"'
                      .$sshd_password[0].'\" '.
                      '-c \"ntsec\"'.$privl.'"');print "LINE=".__LINE__."\n";
               print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"/usr/bin/ssh-user-config -n"');print "LINE=".__LINE__."\n";
               print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
            }
            if (-1==index $cygsrvs,'cygserver') {
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"/usr/bin/cygserver-config -y"');print "LINE=".__LINE__."\n";
            }
            #system('SET CYGWIN=nodosfilewarning & '.
            #       "cmd /c $cygwin_loc\\bin\\bash -lc ".
            #       '"/usr/bin/cron-config"');print "LINE=".__LINE__."\n";
            if (0<length $cygsrvs) {
               system('SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $cygwin_loc\\bin\\bash -lc ".
                    '"net stop sshd 2>&1"');print "LINE=".__LINE__."\n";
               system('SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $cygwin_loc\\bin\\bash -lc ".
                    '"net stop cygserver 2>&1"');print "LINE=".__LINE__."\n";
               system('SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $cygwin_loc\\bin\\dash -lc ".
                    '"/bin/rebaseall -v"');print "LINE=".__LINE__."\n";
               #system('SET CYGWIN=nodosfilewarning & '.
               #     "cmd /c $cygwin_loc\\bin\\dash -lc ".
               #     '"/bin/perlrebase"');print "LINE=".__LINE__."\n";
               my $netstart='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\bin\\bash -lc ".
                    '"net start sshd 2>&1"';print "LINE=".__LINE__."\n";
               my $netout=`$netstart`;print "LINE=".__LINE__."\n";
               if (-1<index $netout,'System error') {
                  my $netdel='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\bin\\bash -lc ".
                    '"net user sshd /DELETE 2>&1"';print "LINE=".__LINE__."\n";
                  my $ndout=`$netdel`;print "LINE=".__LINE__."\n";
                  my $cygdel='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\bin\\bash -lc ".
                    '"net user cyg_server /DELETE 2>&1"';print "LINE=".__LINE__."\n";
                  my $cgout=`$cygdel`;print "LINE=".__LINE__."\n";
                  my $netrm='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\bin\\bash -lc ".
                    '"/usr/bin/cygrunsrv -R sshd 2>&1"';print "LINE=".__LINE__."\n";
                  my $rmout=`$netrm`;print "LINE=".__LINE__."\n";
                  if ($domain_user) {
                     system('SET CYGWIN=nodosfilewarning & '.
                         "cmd /c $clo\\bin\\bash -lc ".
                         '"/usr/bin/mkpasswd -u \"'.$domain_user.'\" '.
                         '-d \"'.$domain.'\" >> /etc/passwd"');print "LINE=".__LINE__."\n";
                     unless ($main::domain_gr_flag) {
                        system('SET CYGWIN=nodosfilewarning & '.
                            "cmd /c $clo\\bin\\bash -lc ".
                            '"/usr/bin/mkgroup -d \"'.$domain.'\" '.
                            '-g  \"Domain Users\" '.
                            '>> /etc/group"');print "LINE=".__LINE__."\n";
                        $main::domain_gr_flag=1;print "LINE=".__LINE__."\n";
                     }
                  }
                  system('SET CYGWIN=nodosfilewarning & '.
                         "cmd /c $cygwin_loc\\bin\\bash -lc ".
                         '"/usr/bin/ssh-host-config -y '.
                         '-u \"'.$sshd_account.'\" -w \"'.
                         $sshd_password[0].'\" '.
                         '-c \"ntsec\"'.$privl.'"');print "LINE=".__LINE__."\n";
                  print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
                  system('SET CYGWIN=nodosfilewarning & '.
                         "cmd /c $cygwin_loc\\bin\\bash -lc ".
                         '"/usr/bin/ssh-user-config -n"');print "LINE=".__LINE__."\n";
                  print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
                  my $net_start='SET CYGWIN=nodosfilewarning & '.
                       "cmd /c $clo\\\\bin\\\\bash -lc ".
                       '"net start sshd 2>&1"';print "LINE=".__LINE__."\n";
                  my $netot=`$net_start`;print "LINE=".__LINE__."\n";
               }
               system('SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $cygwin_loc\\bin\\bash -lc ".
                    '"net start cygserver 2>&1"');print "LINE=".__LINE__."\n";
            } else {
               #system('SET CYGWIN=nodosfilewarning & '.
               #     "cmd /c $cygwin_loc\\bin\\dash -lc ".
               #     '"/bin/perlrebase"');print "LINE=".__LINE__."\n";
            }
            if (-1==index $cygsrvs,'sshd') {
               my $nettstart='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\\\bin\\\\bash -lc ".
                    '"net start sshd 2>&1"';print "LINE=".__LINE__."\n";
               my $netut=`$nettstart`;print "LINE=".__LINE__."\n";
               if (-1<index $netut,'System error') {
                  my $netdel='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\\\bin\\\\bash -lc ".
                    '"net user sshd /DELETE 2>&1"';print "LINE=".__LINE__."\n";
                  my $ndout=`$netdel`;print "LINE=".__LINE__."\n";
                  my $netrm='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\\\bin\\\\bash -lc ".
                    '"/usr/bin/cygrunsrv -R sshd 2>&1"';print "LINE=".__LINE__."\n";
                  my $rmout=`$netrm`;print "LINE=".__LINE__."\n";
                  system('SET CYGWIN=nodosfilewarning & '.
                         "cmd /c $cygwin_loc\\bin\\bash -lc ".
                         '"/usr/bin/ssh-host-config -y '.
                         '-u \"'.$sshd_account.'\" -w \"'.
                         $sshd_password[0].'\" '.
                         '-c \"ntsec\"'.$privl.'"');print "LINE=".__LINE__."\n";
                  print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
                  system('SET CYGWIN=nodosfilewarning & '.
                         "cmd /c $cygwin_loc\\bin\\bash -lc ".
                         '"/usr/bin/ssh-user-config -n"');print "LINE=".__LINE__."\n";
                  print "\n   FullAuto Install continues . . . \n\n";print "LINE=".__LINE__."\n";
                  my $net_start='SET CYGWIN=nodosfilewarning & '.
                       "cmd /c $clo\\\\bin\\\\bash -lc ".
                       '"net start sshd 2>&1"';print "LINE=".__LINE__."\n";
                  my $netot=`$net_start`;print "LINE=".__LINE__."\n";
               }
            }
            if (-1==index $cygsrvs,'cygserver') {
               system('SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $cygwin_loc\\bin\\bash -lc ".
                    '"net start cygserver 2>&1"');print "LINE=".__LINE__."\n";
            }
            #system('SET CYGWIN=nodosfilewarning & '.
            #       "cmd /c $cygwin_loc\\bin\\bash -lc ".
            #       '"net start cron 2>&1"');print "LINE=".__LINE__."\n";
         }
         if ($selection!~/MINIMAL/) {
            my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
            my $clo=$cygwin_loc;print "LINE=".__LINE__."\n";
            $clo=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
            my $incpath=$INC[0];print "LINE=".__LINE__."\n";
            $incpath=~s/\\/\//g;print "LINE=".__LINE__."\n";
            if ($^O eq 'cygwin') {
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"echo y | /usr/bin/perl -e \"eval { require IO::Pty;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\',\'IO::Pty\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require HTML::Tagset;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'HTML::Tagset\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require HTML::Parser;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'HTML::Parser\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require URI;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'URI\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval {require ExtUtils::Depends;1}'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'ExtUtils::Depends\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require Task::Weaken;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Task::Weaken\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require Digest::MD5;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Digest::MD5\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require B::Utils;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'B::Utils\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require Algorithm::Diff;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Algorithm::Diff\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { '.
                      'require Data::Dump::Streamer;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Data::Dump::Streamer\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require Encode::compat;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Encode::compat\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require Win32::API;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Win32::API\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require Win32::DriveInfo;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Win32::DriveInfo\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require JSON::XS;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'JSON::XS\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require JSON;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'JSON\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require Term::ReadKey;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Term::ReadKey\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { '.
                      'require Term::RawInput;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Term::RawInput\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { '.
                      'require Term::Menus;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Term::Menus\')}\""');print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { '.
                      'require Mozilla::CA;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\','.
                      '\'Mozilla::CA\')}\""');print "LINE=".__LINE__."\n";
               my $par_dir='export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/cygpath -lm \"'.$main::PARdir.'\""';print "LINE=".__LINE__."\n";
               my $pardir=`$par_dir`;print "LINE=".__LINE__."\n";
               chomp($pardir);print "LINE=".__LINE__."\n";
               system('export CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"export PERL_MM_USE_DEFAULT=1;'.
                      'export FA_EDITOR=\\"'.$editor.'\\";'.
                      'export FA_BERKELEY=\\"'.
                         $main::cygwin_berkeley_db_mode.'\\";'.
                      'export FA_MOZREPL=\\"'.$main::install_firefox.'\\";'.
                      'export PARdir=\\"'.$pardir.'\\";'.
                      '/usr/bin/echo y|/usr/bin/cpan -i '.
                      "REEDFISH/Net-FullAuto-$main::VERSION.tar.gz\"");print "LINE=".__LINE__."\n";
            } else {
               my $build_dir='SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"echo y | /usr/bin/perl -e '.
                      '\"require CPAN and CPAN::HandleConfig-^^^>load;'.
                      'print \$CPAN::Config-^^^>{build_dir}\" 2>&1"';print "LINE=".__LINE__."\n";
               my $bd=`$build_dir`;print "LINE=".__LINE__."\n";
               if ($bd=~/^\s*$|Can\'t locate/s) {
                  my $rmdir='SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e '.
                      '\"foreach my \$f (@INC) { my \$e=\$f;'.
                      'if (-e \$e.\'/CPAN/Config.pm\') {'.
                      'rm -f \$e.\'/CPAN/Config.pm\';'.
                      'rm -f \$e.\'/CPAN/Config.pm~\';'.
                      'last}print \'done\'}\" 2>&1"';print "LINE=".__LINE__."\n";
                  my $rmd=`$rmdir`;print "LINE=".__LINE__."\n";
                  system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"/usr/bin/echo y | /usr/bin/cpan"');print "LINE=".__LINE__."\n";
               }
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { require IO::Pty;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'install\',\'IO::Pty\')}\""');print "LINE=".__LINE__."\n";
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"/usr/bin/perl -e \"eval { '.
                      'require Data::Dump::Streamer;1 }'.
                      ' or do {require CPAN and '.
                      'CPAN::Shell-^^^>notest(\'get\','.
                      '\'Win32::OLE\')}\""');print "LINE=".__LINE__."\n";
               my $streamdir='SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e '.
                      '\"require CPAN and CPAN::HandleConfig-^^^>load;'.
                      'print \$CPAN::Config-^^^>{build_dir}\""';print "LINE=".__LINE__."\n";
               my $stmout=`$streamdir`;print "LINE=".__LINE__."\n";
               $stmout=~s/\s*$//s;print "LINE=".__LINE__."\n";
               $stmout=~s/^\s*//s;print "LINE=".__LINE__."\n";
               $streamdir='SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/cygpath -lm \"'.$stmout.'\""';print "LINE=".__LINE__."\n";
               $stmout=`$streamdir`;print "LINE=".__LINE__."\n";
               $stmout=~s/\s*$//s;print "LINE=".__LINE__."\n";
               $stmout=~s/^\s*//s;print "LINE=".__LINE__."\n";
               $streamdir='SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/perl -e '.
                      '\"opendir(DIR,\''.$stmout.'\') or die \$!;'.
                      'my\$t=0;my\$n=\'\';my\$f=\'\';my \$e;'.
                      'while(\$e=readdir(DIR)){'.
                      'next if \$e eq \'.\';'.
                      'next if \$e eq \'..\';'.
                      'next if \$e!~/^Win32-OLE/;'.
                      'next if substr(\$e,-3) eq \'yml\';'.
                      '\$f=\''.$stmout.'\'.\'/\'.\$e;'.
                      'my \$a=(stat(\$f))[9];'.
                      'my \$d=time() - \$a;'.
                      'if(\$t==0 and \$e=~/^Win32-OLE/){'.
                      '\$t=\$d;\$n=\$f;}if(\$d^^^<\$t){'.
                      '\$t=\$d;\$n=\$f;}}\$n=\$f if !\$n and \$f;'.
                      'print \$f\""';print "LINE=".__LINE__."\n";
               my $sdir=`$streamdir`;print "LINE=".__LINE__."\n";
               $sdir=~s/\s*$//s;print "LINE=".__LINE__."\n";
               $sdir=~s/^\s*//s;print "LINE=".__LINE__."\n";
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"cd \"'.$sdir.'\";/usr/bin/sed -i '.
                      '\'s/stricmp/strcasecmp/\' OLE.xs;"');print "LINE=".__LINE__."\n";
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"cd \"'.$sdir.'\";/usr/bin/perl Makefile.PL;"');print "LINE=".__LINE__."\n";
               system('SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"cd \"'.$sdir.'\";/usr/bin/make install;"');print "LINE=".__LINE__."\n";
               my $par_dir='SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $clo\\\\bin\\\\bash -lc ".
                      '"/usr/bin/cygpath -lm \"'.$main::PARdir.'\""';print "LINE=".__LINE__."\n";
               my $pardir=`$par_dir`;print "LINE=".__LINE__."\n";
               chomp($pardir);print "LINE=".__LINE__."\n";
               exec   'SET CYGWIN=nodosfilewarning & '.
                      "cmd /c $cygwin_loc\\bin\\bash -lc ".
                      '"export PERL_MM_USE_DEFAULT=1;'.
                      'export FA_EDITOR=\\"'.$editor.'\\";'.
                      'export FA_BERKELEY=\\"'.
                         $main::cygwin_berkeley_db_mode.'\\";'.
                      'export FA_MOZREPL=\\"'.$main::install_firefox.'\\";'.
                      'export PARdir=\\"'.$pardir.'\\";'.
                      '/usr/bin/echo y|/usr/bin/cpan -i '.
                      "REEDFISH/Net-FullAuto-$main::VERSION.tar.gz\"";print "LINE=".__LINE__."\n";
            }
         }
         my $rmdir_out=rmdir $main::curdir.'/inc/.author'; 
         my $un_out=unlink $main::curdir.'/inc/Module/Install/Base.pm';print "LINE=".__LINE__."\n";
         $un_out=unlink $main::curdir.'/inc/Module/Install/Metadata.pm';print "LINE=".__LINE__."\n";
         $un_out=unlink $main::curdir.'/inc/Module/Install.pm';print "LINE=".__LINE__."\n";
         $rmdir_out=rmdir $main::curdir.'/inc/Module/Install';print "LINE=".__LINE__."\n";
         $rmdir_out=rmdir $main::curdir.'/inc/Module';print "LINE=".__LINE__."\n";
         unless ((exists $ENV{PARdir} && (-f $ENV{PARdir}.'/inc_exists.txt'))) {
            $rmdir_out=rmdir $main::curdir.'/inc';print "LINE=".__LINE__."\n";
         } else {
            $un_out=unlink $ENV{PARdir}.'/inc_exists.txt';print "LINE=".__LINE__."\n";
         }
         opendir(CD,$main::curdir)
            or die "Cannot open ".$main::curdir.": $!\n";print "LINE=".__LINE__."\n";
         while (my $file = readdir(CD) ) {
            chomp($file);print "LINE=".__LINE__."\n";
            if (-1<index $file,'http%3a%2f%2f') {
               $un_out=unlink $main::curdir."/$file/setup.ini";print "LINE=".__LINE__."\n";
               print "ERROR: $!\n" unless $un_out;print "LINE=".__LINE__."\n";
               if (-e $main::curdir."/$file/release/_update-info-dir") {
                  opendir(OD,"$main::curdir/$file/release/_update-info-dir")
                        or die $!;print "LINE=".__LINE__."\n";
                  while (my $fil = readdir(OD) ) {
                     chomp($fil);print "LINE=".__LINE__."\n";
                     $un_out=unlink $main::curdir.
                                "/$file/release/_update-info-dir/$fil";print "LINE=".__LINE__."\n";
                     my $cnt=0;print "LINE=".__LINE__."\n";
                     while (-e $main::curdir.
                           "/$file/release/_update-info-dir/$fil") {
                         sleep 1;print "LINE=".__LINE__."\n";
                         last if ++$cnt==100; 
                     }
                     print "ERROR: $!\n" unless $un_out;print "LINE=".__LINE__."\n";
                  }
                  close(OD);print "LINE=".__LINE__."\n";
                  $rmdir_out=rmdir $main::curdir.
                        "/$file/release/_update-info-dir";print "LINE=".__LINE__."\n";
                  print "ERROR $main::curdir/$file/release/_update-info-dir:",
                        " $!\n" unless $rmdir_out;print "LINE=".__LINE__."\n";
                  $rmdir_out=rmdir $main::curdir."/$file/release";print "LINE=".__LINE__."\n";
                  print "ERROR $main::curdir/$file/release:",
                        " $!\n" unless $rmdir_out;print "LINE=".__LINE__."\n";
               }
               $rmdir_out=rmdir $main::curdir."/$file";print "LINE=".__LINE__."\n";
               print "ERROR: $!\n" unless $rmdir_out;print "LINE=".__LINE__."\n";
               last;print "LINE=".__LINE__."\n";
            }
         }
         close(CD);print "LINE=".__LINE__."\n";
         &install_firefox() if -1<index $main::install_firefox,'Install';print "LINE=".__LINE__."\n";
         print "\n\n   FullAuto Installation has completed",
               "\n\n   Thank you!",
               "\n\n   Please report any bugs and send any",
               "\n   questions, thoughts or feedback to:",
               "\n\n      Brian.Kelly\@FullAuto.com.",
               "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
         exit 0;print "LINE=".__LINE__."\n";
      }
   } elsif ($process_id) {
      exit;print "LINE=".__LINE__."\n";
   }
   my $die=<<'END';print "LINE=".__LINE__."\n";

       FATAL ERROR! : Cygwin Linux Emulation Layer
                      is required to use FullAuto
                      on Windows - goto www.cygwin.com.

           Be sure to install the following programs in
           addition to the base package:

           inetutils and openssh [as provided by Cygwin]
           perl [as provided by Cygwin] (*NOT* CPAN)
           perl-Win32 [as provided by Cygwin] (*NOT* CPAN)
           ncurses, cron, and procps [as provided by Cygwin]
           gcc-core and gcc-g++ [as provided by Cygwin]
           Oracle Berkeley DB [as provided by Cygwin or Oracle]

           **IMPORTANT** - the FullAuto install, either manual
           or via CPAN, must be run *inside* a Cygwin bash shell
           when installing FullAuto on Microsoft Windows.

END
   die $die;print "LINE=".__LINE__."\n";
}

unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
   my @editors=();print "LINE=".__LINE__."\n";
   my $banner="\n   ".
           "*** THIS SCREEN WILL TIMEOUT IN 2 MINUTES ***\n\n".
           "   In order is use the integrated edit features\n".
           "   you will need to choose an editor.\n\n".
           "   ( '>' points to default selection )\n\n";print "LINE=".__LINE__."\n";
   unless ($editor) {
      if ($^O eq 'cygwin') {
         if (exists $ENV{FA_EDITOR} and $ENV{FA_EDITOR}) {
            $editor=$ENV{FA_EDITOR};print "LINE=".__LINE__."\n";
         } else {
            my $tp='';print "LINE=".__LINE__."\n";
            my $mount=`/bin/mount -p`;print "LINE=".__LINE__."\n";
            $mount=~s/^.*(\/\S+).*$/$1/s;print "LINE=".__LINE__."\n";
            unless ($tp=&fa_find_editor('TextPad.exe')) {
               my $sysdr=`cmd /c echo %SystemDrive%`;print "LINE=".__LINE__."\n";
               $sysdr=~s/^\s*(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
               my $let=substr($sysdr,0,1);print "LINE=".__LINE__."\n";
               my $lt=lc($let);print "LINE=".__LINE__."\n";
               if (-e $mount."/$lt/Program Files/TextPad 5/TextPad.exe") {
                  $tp='default';print "LINE=".__LINE__."\n";
               }
            }
            if ($tp) {
               push @editors, 'TextPad (Will not work from remote ssh)';print "LINE=".__LINE__."\n";
            }
            my $sysdr=`cmd /c echo %SystemDrive%`;print "LINE=".__LINE__."\n";
            $sysdr=~s/^\s*(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
            my $let=substr($sysdr,0,1);print "LINE=".__LINE__."\n";
            my $lt=lc($let);print "LINE=".__LINE__."\n";
            if (-e $mount.
                  "/$lt/Program Files/Windows NT/Accessories/wordpad.exe") {
               unshift @editors,
                  'Microsoft WordPad (Will not work from remote ssh)';print "LINE=".__LINE__."\n";
            }
            if (-e '/bin/nano.exe') {
               unshift @editors, 'nano (Recommended for Beginners)';print "LINE=".__LINE__."\n";
            }
            if ((-e '/bin/vim.exe') ||
                  (-e '/bin/vim-nox.exe')) {
               unshift @editors, 'vim';print "LINE=".__LINE__."\n";
            }
            if ((-e '/bin/emacs.exe') ||
                  (-e '/bin/emacs-nox.exe')) {
               push @editors, 'emacs';print "LINE=".__LINE__."\n";
            }
            if (-e '/bin/joe.exe') {
               push @editors, 'joe';print "LINE=".__LINE__."\n";
            }
            my %Menu_select_editor=(

                  Label  => 'Menu_select_editor',
                  Item_1 => {

                     Text    => "]C[",
                     Convey  => \@editors,

                  },
                  Scroll => 1,
                  Banner => $banner,

            );print "LINE=".__LINE__."\n";
            eval {
               local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
               alarm 120;print "LINE=".__LINE__."\n";
               $selection=Term::Menus::Menu(\%Menu_select_editor);print "LINE=".__LINE__."\n";
               alarm 0;print "LINE=".__LINE__."\n";
            };print "LINE=".__LINE__."\n";
            if ($@) {
               $selection=$editors[0];print "LINE=".__LINE__."\n";
            } else {
               chomp($selection);print "LINE=".__LINE__."\n";
               exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
               if ($selection=~/TextPad/) {
                  if ($tp eq 'default') {
                     my $sysdr=`cmd /c echo %SystemDrive%`;print "LINE=".__LINE__."\n";
                     $sysdr=~s/^\s*(.*)\s*$/$1/s;print "LINE=".__LINE__."\n";
                     my $let=substr($sysdr,0,1);print "LINE=".__LINE__."\n";
                     my $lt=lc($let);print "LINE=".__LINE__."\n";
                     $editor=$mount.
                        "/$lt/Program Files/TextPad 5/TextPad.exe";print "LINE=".__LINE__."\n";
                  } else {
                     $tp=~s/\\/\//g;print "LINE=".__LINE__."\n";
                     $tp=~s/^([A-Za-z]):(.*)/$1$2/;print "LINE=".__LINE__."\n";
                     $editor="$mount/$tp";print "LINE=".__LINE__."\n";
                  }
               } elsif ($selection=~s/(wordpad)/$1/i) {
                  $editor=$mount.
                     "/$lt/Program Files/Windows NT/Accessories/wordpad.exe";print "LINE=".__LINE__."\n";
               } elsif ($selection=~s/(vim)/$1/i) {
                  if (-e '/bin/vim-nox.exe') {
                     $editor='/bin/vim-nox.exe';print "LINE=".__LINE__."\n";
                  } else {
                     $editor='/bin/vim.exe';print "LINE=".__LINE__."\n";
                  }
               } elsif ($selection=~s/(emacs)/$1/) {
                  if (-e '/bin/emacs-nox.exe') {
                     $editor='/bin/emacs-nox.exe';print "LINE=".__LINE__."\n";
                  } else {
                     $editor='/bin/emacs.exe';print "LINE=".__LINE__."\n";
                  }
               } elsif ($selection=~s/(joe)/$1/) {
                  $editor='/bin/joe.exe';print "LINE=".__LINE__."\n";
               } elsif ($selection=~s/(nano)/$1/) {
                  $editor='/bin/nano.exe';print "LINE=".__LINE__."\n";
               }
               exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
            }
         }
      } else {
         if ((-e '/usr/bin/vi') || (-e '/bin/vi')) {
            push @editors, 'vi';   
         }
         if (-e '/usr/bin/emacs') {
            push @editors, 'emacs';print "LINE=".__LINE__."\n";
         }
         if (1<$#editors) {
            my %Menu_select_editor=(

               Label  => 'Menu_select_editor',
               Item_1 => {

                  Text    => "]C[",
                  Convey  => \@editors,

               },
               Scroll => 1,
               Banner => $banner,

            );print "LINE=".__LINE__."\n";
            $selection=Term::Menus::Menu(\%Menu_select_editor);print "LINE=".__LINE__."\n";
            chomp($selection);print "LINE=".__LINE__."\n";
            exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
            if ($selection=~s/(vi)/$1/) {
               if (-e '/usr/bin/vi') {
                  $editor='/usr/bin/vi';print "LINE=".__LINE__."\n";
               } else {
                  $editor='/bin/vi';print "LINE=".__LINE__."\n";
               }
            } elsif ($selection=~s/(emacs)/$1/) {
               $editor='/usr/bin/emacs';print "LINE=".__LINE__."\n";
            }
         } elsif (1==$#editors) {
            $editor=$editors[0];print "LINE=".__LINE__."\n";
         } else {
            $editor='';print "LINE=".__LINE__."\n";
         }
      }
   }
} else {
   chmod 0755, $Config{installsitelib}."/Net/FullAuto/Distro";print "LINE=".__LINE__."\n";
   chmod 0755, $Config{installsitelib}."/Net/FullAuto/Cloud";print "LINE=".__LINE__."\n";
   chmod 0755, $Config{installsitelib}."/Net/FullAuto/ISets";print "LINE=".__LINE__."\n";
}

&find_windows_app() if $^O eq 'cygwin' &&
   ((-1==index $main::install_firefox,'Install') &&
   (-1==index $main::install_firefox,'NOT'));print "LINE=".__LINE__."\n";

if ($^O eq 'cygwin' && !check_for_compiler()) {
   my $uname=`/bin/uname`;print "LINE=".__LINE__."\n";
   my $stup='setup-x86.exe';print "LINE=".__LINE__."\n";
   $stup='setup-x86_64.exe' if $uname=~/WOW64/ || msw64bit();print "LINE=".__LINE__."\n";
   my $die="\n       FATAL ERROR! : The Gnu C Compiler 'gcc': gcc-core".
           "\n                      & gcc-g++ as provided by Cygwin".
           "\n                      is required to install FullAuto".
           "\n                      on Windows.".
           "\n(Hint: Run Cygwin $stup and install 'gcc-core' ".
           "and 'gcc-g++' under the Category 'Devel' ).".
           "\n\n";print "LINE=".__LINE__."\n";
   die $die;print "LINE=".__LINE__."\n";
} 

if ($^O eq 'cygwin' && !(can_run('/bin/ssh') || can_run('/bin/telnet'))) {
   my $timeout=120;my $a='';print "LINE=".__LINE__."\n";
   eval {
      local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
      alarm $timeout;print "LINE=".__LINE__."\n";
      my $uname=`/bin/uname`;print "LINE=".__LINE__."\n";
      my $stup='setup-x86.exe';print "LINE=".__LINE__."\n";
      $stup='setup-x86_64.exe' if $uname=~/i686/ || msw64bit();print "LINE=".__LINE__."\n";
      print "\n       *** THIS SCREEN WILL TIMEOUT IN 2 MINUTES ***\n". 
            "\n       WARNING! : The Secure Shell - 'ssh'".
            "\n                  and/or 'telnet' (via inetutils)".
            "\n                  as provided by Cygwin".
            "\n                  is required to install FullAuto".
            "\n                  on Windows.".
            "\n(Hint: Run Cygwin $stup and install OpenSSH ".
            "under the Category 'Net' ).".
            "\n\n";print "LINE=".__LINE__."\n";
      print "Press <ENTER> if you wish to continue, or 'N' to quit . . . [Y] ";print "LINE=".__LINE__."\n";
      $a=<STDIN>;print "LINE=".__LINE__."\n";
      alarm 0;print "LINE=".__LINE__."\n";
   };print "LINE=".__LINE__."\n";
   if ($@) {
      # timed out
      exit 1;print "LINE=".__LINE__."\n";
   } elsif ($a=~/^[Nn]$/s) {
      exit;print "LINE=".__LINE__."\n";
   } alarm 0;print "LINE=".__LINE__."\n";
}
if (!can_run('make') && !(($^O eq 'cygwin') && (-e "/usr/bin/make"))) {
   my $die="\n       FATAL ERROR! : Cannot locate 'make'. This program ".
           "\n                      is required to install FullAuto".
           "\n                      (Hint: goto www.gnu.org for gnumake).".
           "\n\n";print "LINE=".__LINE__."\n";
   die $die;print "LINE=".__LINE__."\n";
}
my $greppath='';print "LINE=".__LINE__."\n";
if (-e "/bin/grep") {
   $greppath="/bin/";print "LINE=".__LINE__."\n";
} elsif (-e "/usr/bin/grep") {
   $greppath="/usr/bin/";print "LINE=".__LINE__."\n";
} elsif (-e "/usr/local/bin/grep") {
   $greppath="/usr/local/bin/";print "LINE=".__LINE__."\n";
}
my $get_BerkeleyDB=0;print "LINE=".__LINE__."\n";
eval { require BerkeleyDB };print "LINE=".__LINE__."\n";
$get_BerkeleyDB=1 if $@;print "LINE=".__LINE__."\n";
my $cpan_error='';print "LINE=".__LINE__."\n";
eval {
   require CPAN::Mini;print "LINE=".__LINE__."\n";
   import CPAN::Mini;print "LINE=".__LINE__."\n";
};print "LINE=".__LINE__."\n";
if (!$@ && grep { /-*add[-_]?dependencies/i } @ARGV) {
   my $distribution = CPAN::Shell->expand(
         "Module",'BerkeleyDB'
      )->distribution()->pretty_id();print "LINE=".__LINE__."\n";
   my $let=unpack('a1',$distribution);print "LINE=".__LINE__."\n";
   my $lett=unpack('a2',$distribution);print "LINE=".__LINE__."\n";
   my $minicpan=CPAN::Mini->new(

      #remote => "http://www.cpan.org",
      remote => "http://www.perl.com/CPAN",
      local  => cwd()."/dependencies/CPAN",
      log_level => 'debug',
      exact_mirror => 1,

   );print "LINE=".__LINE__."\n";
   $minicpan->mirror_file(
      "authors/id/$let/$lett/$distribution");print "LINE=".__LINE__."\n";
}
if ($get_BerkeleyDB && $^O ne 'cygwin') {
   # Let's find if Berkeley DB is already on the system
   my $findpath='';print "LINE=".__LINE__."\n";
   if (-e "/bin/find") {
      $findpath="/bin/";print "LINE=".__LINE__."\n";
   } elsif (-e "/usr/bin/find") {
      $findpath="/usr/bin/";print "LINE=".__LINE__."\n";
   } elsif (-e "/usr/local/bin/find") {
      $findpath="/usr/local/bin/";print "LINE=".__LINE__."\n";
   }
   my $xargspath='';print "LINE=".__LINE__."\n";
   if (-e "/bin/xargs") {
      $xargspath="/bin/";print "LINE=".__LINE__."\n";
   } elsif (-e "/usr/bin/xargs") {
      $xargspath="/usr/bin/";print "LINE=".__LINE__."\n";
   } elsif (-e "/usr/local/bin/xargs") {
      $xargspath="/usr/local/bin/";print "LINE=".__LINE__."\n";
   }
   if ($findpath && $xargspath && $greppath) {
      my @output=();print "LINE=".__LINE__."\n";
      my $testgrep =`${greppath}grep -H 2>&1`;print "LINE=".__LINE__."\n";
      my $testgrep2=`${greppath}grep 2>&1`;print "LINE=".__LINE__."\n";
      my $grepopt='';print "LINE=".__LINE__."\n";
      if ((-1==index $testgrep,'illegal option')
            && (-1==index $testgrep2,'-insvxbhwyu')) {
         $grepopt='-H ';print "LINE=".__LINE__."\n";
      }
      my $testfind =`find -help 2>&1`;print "LINE=".__LINE__."\n";
      my $maxdepth=(-1<index $testfind,'[-P]')?
            " -maxdepth 4":'';print "LINE=".__LINE__."\n";
      my $find_cmd1="${findpath}find ";print "LINE=".__LINE__."\n";
      my $find_cmd2="$maxdepth -name \'*.h\' ".
                   "| ${xargspath}xargs ${greppath}grep ".
                   "${grepopt}DB_VERSION_STRING";print "LINE=".__LINE__."\n";
      print "\nSearching for latest verison of Berkeley DB.\n".
            "This may take up to five minutes ...\n\n";print "LINE=".__LINE__."\n";
      FE: foreach my $dir ('/usr/','/opt/',(getpwuid $>)[7].'/') {
         next if unpack('a1',$dir) eq '.';print "LINE=".__LINE__."\n";
         next unless -d $dir;print "LINE=".__LINE__."\n";
         opendir(DIR, $dir) or die $!;print "LINE=".__LINE__."\n";
         while (my $file = readdir(DIR) ) {
            next if ($file eq "." or $file eq ".." or $file eq "doc" or
                     $file eq "X11R6" or $file eq "docs" or
                     $file eq "man" or $file eq "ssl" or
                     $file eq "license" or $file eq "logfile" or
                     $file eq "bin" or ($^O eq 'cygwin' &&
                     ($file eq "Application Data" or
                      $file eq "Favorites" or $file eq
                      "Local Settings" or $file eq "Recent" or
                      $file eq "Start Menu" or $file eq "SendTo" or
                      $file eq "NetHood" or $file eq "PrintHood")));print "LINE=".__LINE__."\n";
            if (-d $dir.$file) {
               print "Searching $dir$file ...\n";print "LINE=".__LINE__."\n";
               my @subout=`$find_cmd1\"$dir$file\"$find_cmd2`;      
               push @output, @subout;print "LINE=".__LINE__."\n";
            }
            last FE if $dir.$file eq "/usr/local";print "LINE=".__LINE__."\n";
         }
      }
      my @vers=();my %verhash=(); 
      if (-1<$#output) {
         foreach my $version (@output) {
            next if (-1<index $version, $CPAN::Config->{cpan_home}) || 
                    (-1<index $version, 'Net-FullAuto-') ||
                    $version!~/db.h:.*DB_VERSION_STRING/;print "LINE=".__LINE__."\n";
            my @fileparts=split 'db.h:', $version;print "LINE=".__LINE__."\n";
            $fileparts[1]=~s/^.*DB (\d+[^:]+):.*\s*$/$1/s;print "LINE=".__LINE__."\n";
            $verhash{$fileparts[1]}=$fileparts[0]; 
         }
      }
      my $header_to_use='';my $ver='';print "LINE=".__LINE__."\n";
      foreach my $vr (reverse sort keys %verhash) {
         $header_to_use=$verhash{$vr};print "LINE=".__LINE__."\n";
         $vr=~/^((^\d+[.]\d+)[.]?\d*).*$/;print "LINE=".__LINE__."\n";
         $vr=$1;$ver=$2;print "LINE=".__LINE__."\n";
         chomp($vr);chomp($ver);print "LINE=".__LINE__."\n";
         my $find_cmd="${findpath}find /usr -name \"libdb-".$ver.".a\"";print "LINE=".__LINE__."\n";
         my @lib=`$find_cmd`;print "LINE=".__LINE__."\n";
         chomp($lib[0]);$berkeleydb=$lib[0];last;print "LINE=".__LINE__."\n";
      }
      my $major_minor_ver=substr($ver,0,(rindex $ver,'.'));print "LINE=".__LINE__."\n";
      $major_minor_ver=$ver if -1==index $major_minor_ver,'.';print "LINE=".__LINE__."\n";
      if ($^O eq 'cygwin' && !(grep { /build_berkeleydb/i } @ARGV)) {
         if ($berkeleydb && $major_minor_ver>=4.5) {
            $berkeleydb=~s/^(.*)\/.*$/$1/;print "LINE=".__LINE__."\n";
            $ENV{'BERKELEYDB_INCLUDE'}=$header_to_use;print "LINE=".__LINE__."\n";
            $ENV{'BERKELEYDB_LIB'}=$berkeleydb;print "LINE=".__LINE__."\n";
            $ENV{'BERKELEYDB_NAME'}="-ldb-$ver";print "LINE=".__LINE__."\n";
            $ENV{'DB_FILE_INCLUDE'}=$header_to_use;print "LINE=".__LINE__."\n";
            $ENV{'DB_FILE_LIB'}=$berkeleydb;print "LINE=".__LINE__."\n";
            $ENV{'DB_FILE_NAME'}="-ldb-$ver";print "LINE=".__LINE__."\n";
            $ENV{'LD_LIBRARY_PATH'}=$berkeleydb;print "LINE=".__LINE__."\n";
            $ENV{'LD_RUN_PATH'}=$ENV{'LD_LIBRARY_PATH'};print "LINE=".__LINE__."\n";
         } else {
            my $uname=`/bin/uname`;print "LINE=".__LINE__."\n";
            my $uname_all=`/bin/uname -a`;print "LINE=".__LINE__."\n";
            $uname_all.=$uname;print "LINE=".__LINE__."\n";
            my $dbdev="libdb${major_minor_ver}-devel";print "LINE=".__LINE__."\n";
            $dbdev='libdb-devel' if $uname=~/WOW64|x86_64/;print "LINE=".__LINE__."\n";
            print "\n\n   Fatal Error!: The \'$dbdev\' package is".
                  " missing from your Cygwin installation.\n".
                  "\n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
                  exit 1;print "LINE=".__LINE__."\n";
         }
      } elsif ($ENV{AUTOMATED_TESTING} ||
            ($berkeleydb && $major_minor_ver>=5.1)) {
         $berkeleydb=~s/^(.*)\/.*$/$1/;print "LINE=".__LINE__."\n";
         $ENV{'BERKELEYDB_INCLUDE'}=$header_to_use;print "LINE=".__LINE__."\n";
         $ENV{'BERKELEYDB_LIB'}=$berkeleydb;print "LINE=".__LINE__."\n";
         $ENV{'BERKELEYDB_NAME'}="-ldb-$ver";print "LINE=".__LINE__."\n";
         $ENV{'DB_FILE_INCLUDE'}=$header_to_use;print "LINE=".__LINE__."\n";
         $ENV{'DB_FILE_LIB'}=$berkeleydb;print "LINE=".__LINE__."\n";
         $ENV{'DB_FILE_NAME'}="-ldb-$ver";print "LINE=".__LINE__."\n";
         $ENV{'LD_LIBRARY_PATH'}=$berkeleydb;print "LINE=".__LINE__."\n";
         $ENV{'LD_RUN_PATH'}=$ENV{'LD_LIBRARY_PATH'};print "LINE=".__LINE__."\n";
      } else {
         if (-e "dependencies/BerkeleyDB" && !(grep {
               /(?:use[-_]?)?internet|online|connect_to_internet_ok/i
               } @ARGV)) {
            cpan_gunzip_and_untar();print "LINE=".__LINE__."\n";
            my $dir=&cwd.'/dependencies/BerkeleyDB';print "LINE=".__LINE__."\n";
            opendir(DIR,$dir);print "LINE=".__LINE__."\n";
            my @files = readdir(DIR);print "LINE=".__LINE__."\n";
            closedir(DIR);print "LINE=".__LINE__."\n";
            my $file='';my $filename='';print "LINE=".__LINE__."\n";
            foreach my $f (@files) {
               next if $f eq '.';print "LINE=".__LINE__."\n";
               next if $f eq '..';print "LINE=".__LINE__."\n";
               if (-1==index $f,'.md5') {
                  $file=$f;print "LINE=".__LINE__."\n";
                  last;print "LINE=".__LINE__."\n";
               }
            }
            my $filenm=$file;print "LINE=".__LINE__."\n";
            $file=~s/.tar.gz$//;print "LINE=".__LINE__."\n";
            $filename="${file}_${$}.tar.gz";print "LINE=".__LINE__."\n";
            File::Copy::copy("$dir/$filenm",&cwd."/$filename");print "LINE=".__LINE__."\n";
            my $so=system($CPAN::Config->{gzip}." -d $filename");print "LINE=".__LINE__."\n";
            if ($so==-1) {
               die "Cannot gunzip $filename: $!\n";print "LINE=".__LINE__."\n";
            }
            $filename=~s/\.gz$//;print "LINE=".__LINE__."\n";
            print "***** Untar4: ",
               $CPAN::Config->{tar}," xvf $filename\n";print "LINE=".__LINE__."\n";
            open(FH, $CPAN::Config->{tar}." xvf $filename|");print "LINE=".__LINE__."\n";
            while (my $line=<FH>) {
               print $line;print "LINE=".__LINE__."\n";
            }
            close FH;print "LINE=".__LINE__."\n";
            $filename=~/^(.*)_(\d+).tar$/;print "LINE=".__LINE__."\n";
            $filename=$1;print "LINE=".__LINE__."\n";
            my $uniq=$2;print "LINE=".__LINE__."\n";
            File::Copy::move("$filename.NC","$filename.NC_$uniq");print "LINE=".__LINE__."\n";
            my $ver=$filenm;print "LINE=".__LINE__."\n";
            $ver=~s/_.*$//;print "LINE=".__LINE__."\n";
            $ver=~s/^.*db-(\d+[.]\d+).*$/$1/;print "LINE=".__LINE__."\n";
            my $pre="/usr/local/BerkeleyDB.$ver";print "LINE=".__LINE__."\n";
            $pre=$PREFIX."BerkeleyDB$ver" if $PREFIX;print "LINE=".__LINE__."\n";
            build_berkeleydb($filename,$uniq,$pre,$PREFIX,'');print "LINE=".__LINE__."\n";
         } else {
            download_berkeleydb();print "LINE=".__LINE__."\n";
         }
         unless (exists $ENV{'BERKELEYDB_INCLUDE'} &&
               $ENV{'BERKELEYDB_INCLUDE'}) {
            my $BerkDownload='http://www.oracle.com/technetwork/products/'.
                             'berkeleydb/downloads/index.html';print "LINE=".__LINE__."\n";
            my $PackManagers='http://en.wikipedia.org/wiki/'.
                             'List_of_software_package_management_systems';print "LINE=".__LINE__."\n";
            my $w='      ';print "LINE=".__LINE__."\n";
            my $die="\n$w ".
               "FATAL ERROR! : Cannot locate 'Berkeley DB'. This C Library".
               " \n$w                is required to install FullAuto".
               "\n$w                (Hint: goto\n".
               "\n$w $BerkDownload\n".
               "\n$w                 for Berkeley DB Source Code. Binary".
               " versions".
               "\n$w                 of the Library are widely available via".
               "\n$w                 package managers such as yum and apt-get".
               "\n$w                 See:\n".
               "\n$w $PackManagers).".
               "\n\n";print "LINE=".__LINE__."\n";
            die $die;print "LINE=".__LINE__."\n";
         }
      }
   }
} elsif ($^O eq 'cygwin') {
   my $uname=`/bin/uname` || die $!;print "LINE=".__LINE__."\n";
   my $uname_all=`/bin/uname -a` || die $!;print "LINE=".__LINE__."\n";
   $uname_all.=$uname;print "LINE=".__LINE__."\n";
   $ENV{'BERKELEYDB_INCLUDE'}='/usr/include';print "LINE=".__LINE__."\n";
   $ENV{'BERKELEYDB_LIB'}='/usr/lib';print "LINE=".__LINE__."\n";
   if ($uname_all=~/WOW64|x86_64/) {
      $ENV{'BERKELEYDB_NAME'}='-ldb';print "LINE=".__LINE__."\n";
      $ENV{'DB_FILE_NAME'}='-ldb';print "LINE=".__LINE__."\n";
   } else {
      $ENV{'BERKELEYDB_NAME'}='-ldb-4.8';print "LINE=".__LINE__."\n";
      $ENV{'DB_FILE_NAME'}='-ldb-4.8';print "LINE=".__LINE__."\n";
   }
   $ENV{'DB_FILE_INCLUDE'}='/usr/include';print "LINE=".__LINE__."\n";
   $ENV{'DB_FILE_LIB'}='/usr/lib';print "LINE=".__LINE__."\n";
}

if (grep { /-*add[-_]?dependencies/i } @ARGV) {
   my @download=download_berkeleydb();print "LINE=".__LINE__."\n";
   `mkdir -p 'dependencies/BerkeleyDB'` unless
      -e 'dependencies/BerkeleyDB';print "LINE=".__LINE__."\n";
   `rm -rf dependencies/BerkeleyDB/*`;print "LINE=".__LINE__."\n";
   File::Copy::move($download[0],
      "dependencies/BerkeleyDB/$download[2].tar.gz");print "LINE=".__LINE__."\n";
   File::Copy::move($download[1],
      "dependencies/BerkeleyDB/$download[2].tar.gz.md5");print "LINE=".__LINE__."\n";
   require File::Copy;print "LINE=".__LINE__."\n";
   open(MO,"<MANIFEST");print "LINE=".__LINE__."\n";
   open(MN,">MANIFEST_NEW");print "LINE=".__LINE__."\n";
   while (my $file=<MO>) {
      next if $file=~/dependencies\/CPAN/s;print "LINE=".__LINE__."\n";
      next if $file=~/dependencies\/BerkeleyDB/s;print "LINE=".__LINE__."\n";
      next if $file=~/demo.*exe/s;print "LINE=".__LINE__."\n";
      print MN $file;print "LINE=".__LINE__."\n";
   }
   close MO;close MN;print "LINE=".__LINE__."\n";
   File::Copy::move('MANIFEST_NEW','MANIFEST');print "LINE=".__LINE__."\n";
   open(MF,">>MANIFEST") || die "Cannot open MANIFEST: $!\n";print "LINE=".__LINE__."\n";
   my $found=`find dependencies/CPAN -type f`;print "LINE=".__LINE__."\n";
   $found.=`find dependencies/BerkeleyDB -type f`;print "LINE=".__LINE__."\n";
   my @found=split "\n",$found;print "LINE=".__LINE__."\n";
   open(MF,">>MANIFEST") || die "Cannot open MANIFEST: $!\n";print "LINE=".__LINE__."\n";
   foreach my $fnd (@found) {
      print MF "$fnd\n";print "LINE=".__LINE__."\n";
   }
   print MF "demo/pscp.exe\n";print "LINE=".__LINE__."\n";
   print MF "demo/putty.exe\n";print "LINE=".__LINE__."\n";
   print MF "demo/puttygen.exe\n";print "LINE=".__LINE__."\n";
   print MF "demo/runputty.exe\n";print "LINE=".__LINE__."\n";
   print MF "demo/puttykey.exe\n";print "LINE=".__LINE__."\n";
   print MF "demo/engine.exe\n";print "LINE=".__LINE__."\n";
   print MF "demo/puttycfg.exe\n";print "LINE=".__LINE__."\n";
   print MF "demo/puttyyes.exe\n";print "LINE=".__LINE__."\n";
   close MF;print "LINE=".__LINE__."\n";
} else {
   require File::Copy;print "LINE=".__LINE__."\n";
   open(MO,"<MANIFEST");print "LINE=".__LINE__."\n";
   open(MN,">MANIFEST_NEW");print "LINE=".__LINE__."\n";
   while (my $file=<MO>) {
      next if $file=~/dependencies\/CPAN/s;print "LINE=".__LINE__."\n";
      next if $file=~/dependencies\/BerkeleyDB/s;print "LINE=".__LINE__."\n";
      print MN $file;print "LINE=".__LINE__."\n";
   }
   close MO;close MN;print "LINE=".__LINE__."\n";
   File::Copy::move('MANIFEST_NEW','MANIFEST');print "LINE=".__LINE__."\n";
}

chdir $main::curdir;print "LINE=".__LINE__."\n";

if ($get_BerkeleyDB) {

   do {
      my $p='BerkeleyDB';print "LINE=".__LINE__."\n";
      eval "use $p;1" or
      do {
         print"==> $p required."
         and print "*** Installing $p\n"
         and
         do {
            eval{
               require CPAN;print "LINE=".__LINE__."\n";
               CPAN::Shell->force('install',$p);print "LINE=".__LINE__."\n";
            };print "LINE=".__LINE__."\n";
            eval "use $p;1" ||
               die "$@ *** Please manually install $p from cpan.org first...\n"
         }
      }
   }
}

chdir $main::curdir;print "LINE=".__LINE__."\n";

my $B_flag=1;print "LINE=".__LINE__."\n";
while (1) {
   eval {
      my %hash=();print "LINE=".__LINE__."\n";
      require BerkeleyDB;print "LINE=".__LINE__."\n";
      my $db = tie %hash, "BerkeleyDB::Btree",
          -Filename => "fullauto_test_for_db_creation.db",
          -Flags =>  BerkeleyDB::DB_CREATE()
      or die "Cannot tie fullauto_test_for_db_creation.db: $!";print "LINE=".__LINE__."\n";
      undef $db;print "LINE=".__LINE__."\n";
      untie %hash;print "LINE=".__LINE__."\n";
      unlink "fullauto_test_for_db_creation.db";print "LINE=".__LINE__."\n";
   };print "LINE=".__LINE__."\n";
   if ($@) {
      if (-1<index $@,'libgcc_s.so.1' && $B_flag) {
         if (-e '/usr/local/lib/libgcc_s.so.1') {
            `ln -s /usr/local/lib/libgcc_s.so.1 /usr/lib/libgcc_s.so.1`;print "LINE=".__LINE__."\n";
            # Flush inheritance caches
            @{BerkeleyDB::ISA} = ();print "LINE=".__LINE__."\n";
            my $symtab = 'BerkeleyDB::';print "LINE=".__LINE__."\n";
            # Delete all symbols except other namespaces
            for my $symbol (keys %$symtab) {
               next if $symbol =~ /\A[^:]+::\z/;print "LINE=".__LINE__."\n";
               delete $symtab->{$symbol};print "LINE=".__LINE__."\n";
            }
            delete $INC{'BerkeleyDB.pm'};print "LINE=".__LINE__."\n";
            $B_flag=0;print "LINE=".__LINE__."\n";
            next;print "LINE=".__LINE__."\n";
         }
      }
      my $die=<<END;print "LINE=".__LINE__."\n";
$@
   FATAL ERROR! : Cannot create 'fullauto_test_for_db_creation.db'
                  You may be missing the Berkeley DB 'c' library.
                  This 'c' library is required to install FullAuto.
END
      if ($^O eq 'cygwin') {
         my $uname=`/bin/uname`;print "LINE=".__LINE__."\n";
         my $stup='setup-x86.exe';print "LINE=".__LINE__."\n";
         $stup='setup-x86_64.exe' if $uname=~/i686/ || msw64bit();print "LINE=".__LINE__."\n";
         $die.="\n(Hint: Run Cygwin $stup and install Oracle Berkley ".
               "DB under the Category 'Database' ).";print "LINE=".__LINE__."\n";
      } else {
         $die.="\n(Hint: goto ->  http://www.oracle.com/technetwork/".
               "products/berkeleydb/downloads/index.html ).";print "LINE=".__LINE__."\n";
      }
      $die.="\n\n";print "LINE=".__LINE__."\n";
      die $die;print "LINE=".__LINE__."\n";
   }
   last
}

sub download_berkeleydb {

   my $url=
      'http://www.oracle.com/technetwork/'.
      'products/berkeleydb/downloads/index.html';print "LINE=".__LINE__."\n";
   if ($CPAN::META->has_usable('LWP')) {
      FA::LWP::UserAgent->config;print "LINE=".__LINE__."\n";
      print "Fetching with LWP:\n  $url\n";print "LINE=".__LINE__."\n";
      my $Ua;print "LINE=".__LINE__."\n";
      eval { $Ua = FA::LWP::UserAgent->new(
             timeout=>300,show_progress=>1) };print "LINE=".__LINE__."\n";
      if ($@) {
         $CPAN::Frontend->mywarn(
            "ERROR: FA::LWP::UserAgent->new dies with $@\n");print "LINE=".__LINE__."\n";
      } else {
         my($var);print "LINE=".__LINE__."\n";
         $Ua->proxy('http', $var)
            if $var = $CPAN::Config->{http_proxy} ||
            $ENV{http_proxy};print "LINE=".__LINE__."\n";
         $Ua->no_proxy($var)
            if $var = $CPAN::Config->{no_proxy} || $ENV{no_proxy};print "LINE=".__LINE__."\n";
      }
      my $req = HTTP::Request->new(GET => $url);print "LINE=".__LINE__."\n";
      $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
      my $res = $Ua->request($req);print "LINE=".__LINE__."\n";
      my $BDB_selection='NON-ENCRYPTED';print "LINE=".__LINE__."\n";
      if ($res->is_success) {
         print " + request successful.\n"
            if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
         my $source=$res->content;print "LINE=".__LINE__."\n";
         my $site='download.oracle.com';print "LINE=".__LINE__."\n";
         $source=~
           s/^.*?(http:\/\/$site\/)(?:otn\/)*(b.*?\d.tar.gz).*$/$1$2/s;print "LINE=".__LINE__."\n";
         my $file=$2;print "LINE=".__LINE__."\n";
         my $file=substr($file,(index $file,'/')+1,-7);print "LINE=".__LINE__."\n";
         my $ver=$file;print "LINE=".__LINE__."\n";
         $ver=~s/_.*$//;print "LINE=".__LINE__."\n";
         $ver=~s/^.*db-(\d+[.]\d+).*$/$1/;print "LINE=".__LINE__."\n";
         my $timeout=120;my $a='';my $w="      ";print "LINE=".__LINE__."\n";
         my $pre="/usr/local/BerkeleyDB.$ver";print "LINE=".__LINE__."\n";
         $pre=$PREFIX."BerkeleyDB$ver" if $PREFIX;print "LINE=".__LINE__."\n";
         my $berkeley_banner=<<END;print "LINE=".__LINE__."\n";

         *** THIS SCREEN WILL TIMEOUT AND PROCEED WITH Berkeley DB
                      INSTALLATION in 5 MINUTES ***

   Berkeley DB is a file-based (lightweight) database that FullAuto uses for
   storing and retrieving credentials and persistence data. Berkeley DB is
   maintained by Oracle Corporation and hosted at Oracle.com. It has the same
   open source license as FullAuto: GNU Affero General Public License V3.0.
   The default version of Berkeley DB that FullAuto will install and use is
   the latest **NON-ENCRYPTED** version. There is an option to choose
   Encrypted on the next screen.

         There is **NO WARRANTY** for Berkeley DB. USE AT YOUR RISK!

   FullAuto setup will download source code from Oracle.com and build it. It
   will be installed into:   $pre
END

               my $berkeleybanner=<<END;print "LINE=".__LINE__."\n";

         *** THIS SCREEN WILL TIMEOUT AND PROCEED WITH Berkeley DB
                      INSTALLATION in 5 MINUTES ***







END

               my $encrypted_banner=<<END;print "LINE=".__LINE__."\n";

   From http://http://docs.oracle.com/cd/E17076_03/html/index.html:

   "Berkeley DB releases optionally include strong cryptographic support;print "LINE=".__LINE__."\n";
   this release DOES contain cryptographic support. Export/import and/or
   use of cryptography software, or even communicating technical details
   about cryptography software, is illegal in some parts of the world. You
   are strongly advised to pay close attention to any export/import and/or
   use laws which apply to you when you import a release of Berkeley DB
   including cryptography to your country or re-distribute source code
   from it in any way."

   FullAuto does *NOT* utilize the encrypted features of Berkeley DB, and
   only offers to install the encrypted version as a courtesy. You are
   advised to install the NON-ENCRYPTED version unless you have specific
   reasons for needing the encrypted one.
END

         my %encryted_berkeley=(

            Name => 'encrypted_berkeley',
            Item_1 => {

               Text => "Install NON-ENCRYPTED Berkeley DB".
                       " ( Recommended! )",

            },

            Item_2 => {

               Text => "Install Encrypted Berkeley DB",

            },
            Banner => $encrypted_banner,

         );print "LINE=".__LINE__."\n";

         my %berkeleymenu=(

             Name => 'berkeleymenu',
             Item_1 => {

                Text => "Install NON-ENCRYPTED Berkeley DB",

             },
             Item_2 => {

                Text => "Install Encrypted Berkeley DB",
                Result => \%encryted_berkeley,

             },
             Item_3 => {

                Text => "Exit FullAuto Setup",

             },
             Scroll => 1,
             Banner => $berkeleybanner,

         );print "LINE=".__LINE__."\n";
         my %berkeley_menu=(

            Name   => 'berkeley_menu',
            Result => \%berkeleymenu,
            Banner => $berkeley_banner,

         );print "LINE=".__LINE__."\n";
         my $already_downloaded=0;print "LINE=".__LINE__."\n";
         my $filename='';print "LINE=".__LINE__."\n";
         unless (grep { /Encrypted/i } @ARGV) {
            unless (keys %main::amazon) { 
               eval {
                  local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
                  alarm $timeout;print "LINE=".__LINE__."\n";
                  $BDB_selection=Menu(\%berkeley_menu);print "LINE=".__LINE__."\n";
                  alarm 0;print "LINE=".__LINE__."\n";
               };print "LINE=".__LINE__."\n";
               if ($@) {
                  # timed out
                  $BDB_selection='NON-ENCRYPTED';print "LINE=".__LINE__."\n";
                  $source=~s/tar.gz/NC.tar.gz/;print "LINE=".__LINE__."\n";
               } elsif ($BDB_selection=~/\]quit\[|Exit/s) {
                  print "\n";print "LINE=".__LINE__."\n";
                  exit;print "LINE=".__LINE__."\n";
               } elsif (-1<index $BDB_selection,'Encrypted') {
                  $BDB_selection='Encrypted';print "LINE=".__LINE__."\n";
               } else {
                  $source=~s/tar.gz/NC.tar.gz/;print "LINE=".__LINE__."\n";
               } alarm 0;print "LINE=".__LINE__."\n";
            } else {
               $BDB_selection='NON-ENCRYPTED';print "LINE=".__LINE__."\n";
               $source=~s/tar.gz/NC.tar.gz/;print "LINE=".__LINE__."\n";
            }
         } elsif (grep  { /Encrypted/ } @ARGV) {
            $BDB_selection='Encrypted';print "LINE=".__LINE__."\n";
            $already_downloaded=1;print "LINE=".__LINE__."\n";
            $filename=$ARGV[$#ARGV];print "LINE=".__LINE__."\n";
         } else {
            $source=~s/tar.gz/NC.tar.gz/;print "LINE=".__LINE__."\n";
            $already_downloaded=1;print "LINE=".__LINE__."\n";
            $filename=$ARGV[$#ARGV];print "LINE=".__LINE__."\n";
         }
         my $fh='';print "LINE=".__LINE__."\n";
         my $suffix=($BDB_selection eq 'Encrypted')?
               '.tar.gz':'.NC.tar.gz';print "LINE=".__LINE__."\n";
         unless ($already_downloaded) {
            ($fh,$filename)=get_temp_file($file,$suffix);print "LINE=".__LINE__."\n";
            my $end_flag=0;my $md5filename='';print "LINE=".__LINE__."\n";
            my %errors = ('500'=>'Bad hostname supplied',
                          '404'=>'URL not found',
                          '403'=>'URL forbidden',
                          '401'=>'Authorization failed',
                          '400'=>'Bad request found',
                          '302'=>'Redirected URL'
            );print "LINE=".__LINE__."\n";
            while (1) {
               $req = HTTP::Request->new(GET => $source);print "LINE=".__LINE__."\n";
               $req->header('Accept-Encoding' => 'gzip, compress');print "LINE=".__LINE__."\n";
               $res = $Ua->request($req);print "LINE=".__LINE__."\n";
               my $success=1;print "LINE=".__LINE__."\n";
               if ($res->is_success) {
                  print " + request successful.\n"
                     if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
                  print $fh $res->content;print "LINE=".__LINE__."\n";
                  close $fh;print "LINE=".__LINE__."\n";
               } else {
                  my $status_line=$res->status_line;print "LINE=".__LINE__."\n";
                  ($status_line) = ($status_line =~ /(\d+)/);print "LINE=".__LINE__."\n";
                  if (defined($errors{$status_line})) {
                     print(
                        "LWP failed with code $status_line, ",
                        "message $errors{$status_line}\n".
                        "Please check your connection to the Internet!\n",
                        $status_line,
                        $res->message,
                     );print "LINE=".__LINE__."\n";
                     if (!$end_flag && ($status_line eq '404')) {
                        $source=$last_known_good_location;print "LINE=".__LINE__."\n";
                        $end_flag=1;my $rt=qr/b.*?\d.tar.gz/;print "LINE=".__LINE__."\n";
                        my $h=qr/http:\/\/$site\//;print "LINE=".__LINE__."\n";
                        $source=~s/^.*?($h)(?:otn\/)*($rt).*$/$1$2/s;print "LINE=".__LINE__."\n";
                        $file=$2;print "LINE=".__LINE__."\n";
                        $file=substr($file,(index $file,'/')+1,-7);print "LINE=".__LINE__."\n";
                        $ver=$file;print "LINE=".__LINE__."\n";
                        $ver=~s/_.*$//;print "LINE=".__LINE__."\n";
                        $ver=~s/^.*db-(\d+[.]\d+).*$/$1/;print "LINE=".__LINE__."\n";
                        next;print "LINE=".__LINE__."\n";
                     }
                  } else {
                     print(
                        "LWP failed with an Unknown Error\n".
                        "Please check your connection to the Internet!\n",
                     );print "LINE=".__LINE__."\n";
                  }
                  $success = 0;print "LINE=".__LINE__."\n";
                  close $fh;print "LINE=".__LINE__."\n";
                  last;print "LINE=".__LINE__."\n";
               }
               print(qq{ + saved content to $filename \n})
                  if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
               my $md5fh='';print "LINE=".__LINE__."\n";
               ($md5fh,$md5filename)=get_temp_file($file,$suffix.'.md5');print "LINE=".__LINE__."\n";
               $req = HTTP::Request->new(GET => $source.'.md5');print "LINE=".__LINE__."\n";
               $req->header('Accept-Encoding' => 'gzip, compress');print "LINE=".__LINE__."\n";
               $res = $Ua->request($req);print "LINE=".__LINE__."\n";
               if ($res->is_success) {
                  print " + request successful.\n"
                     if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
                  print $md5fh $res->content;print "LINE=".__LINE__."\n";
                  close $md5fh;print "LINE=".__LINE__."\n";
               } else {
                  my $status_line=$res->status_line;print "LINE=".__LINE__."\n";
                  ($status_line) = ($status_line =~ /(\d+)/);print "LINE=".__LINE__."\n";
                  if (defined($errors{$status_line})) {
                     print(
                        "LWP failed with code $status_line, ",
                        "message $errors{$status_line}\n".
                        "Please check your connection to the Internet!\n",
                        $status_line,
                        $res->message,
                     );print "LINE=".__LINE__."\n";
                     if (!$end_flag && ($status_line eq '404')) {
                        $source=$last_known_good_location;print "LINE=".__LINE__."\n";
                        $end_flag=1;my $rt=qr/b.*?\d.tar.gz/;print "LINE=".__LINE__."\n";
                        my $h=qr/http:\/\/$site\//;print "LINE=".__LINE__."\n";
                        $source=~s/^.*?($h)(?:otn\/)*($rt).*$/$1$2/s;print "LINE=".__LINE__."\n";
                        $file=$2;print "LINE=".__LINE__."\n";
                        $file=substr($file,(index $file,'/')+1,-7);print "LINE=".__LINE__."\n";
                        $ver=$file;print "LINE=".__LINE__."\n";
                        $ver=~s/_.*$//;print "LINE=".__LINE__."\n";
                        $ver=~s/^.*db-(\d+[.]\d+).*$/$1/;print "LINE=".__LINE__."\n";
                        next;print "LINE=".__LINE__."\n";
                     }
                  } else {
                     print(
                        "LWP failed with an Unknown Error\n".
                        "Please check your connection to the Internet!\n",
                     );print "LINE=".__LINE__."\n";
                  }
                  $success = 0;print "LINE=".__LINE__."\n";
                  close $fh;print "LINE=".__LINE__."\n";
                  last;print "LINE=".__LINE__."\n";
               }
               print(qq{ + saved md5 content to $md5filename \n})
                  if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
               open(MH,"<$md5filename") || die $!;print "LINE=".__LINE__."\n";
               my $mhf=<MH>;print "LINE=".__LINE__."\n";
               close(MH);print "LINE=".__LINE__."\n";
               my $checksum=$mhf;print "LINE=".__LINE__."\n";
               $checksum=~s/^\s*(\S+)\s+.*$/$1/s;print "LINE=".__LINE__."\n";
               open(FILE, $filename) or die "Can't open '$file': $!";print "LINE=".__LINE__."\n";
               binmode(FILE);print "LINE=".__LINE__."\n";
               require Digest::MD5;print "LINE=".__LINE__."\n";
               import Digest::MD5;print "LINE=".__LINE__."\n";
               my $digestmd5=Digest::MD5->new->addfile(*FILE)->hexdigest;print "LINE=".__LINE__."\n";
               if ($checksum eq $digestmd5) {
                  print(qq{ + CHECKSUM Test for $filename *PASSED* \n})
                     if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
               } else {
                  print "CHECKSUM test for $filename *FAILED*\n";print "LINE=".__LINE__."\n";
                  print "CALCULATED=$digestmd5 and ",
                        "DOWNLOADED=$checksum\n";print "LINE=".__LINE__."\n";
                  print "\nPress ANY key to terminate FullAuto ",
                        "installation ...\n";print "LINE=".__LINE__."\n";
                  <STDIN>;print "LINE=".__LINE__."\n";
                  die "FATAL ERROR! : ".
                      "CHECKSUM Test for $filename *FAILED*\n";print "LINE=".__LINE__."\n";
               }
               close(FILE);print "LINE=".__LINE__."\n";
               last;print "LINE=".__LINE__."\n";
            }
            if (grep { /-*add[-_]?dependencies/i } @ARGV) {
               Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
               return $filename,$md5filename,$file;print "LINE=".__LINE__."\n";
            } else {
               cpan_gunzip_and_untar();print "LINE=".__LINE__."\n";
               unless (keys %main::amazon) {
                  my $so=system($CPAN::Config->{gzip}." -d $filename");print "LINE=".__LINE__."\n";
                  if ($so==-1) {
                     die "Cannot gunzip $filename: $!\n";print "LINE=".__LINE__."\n";
                  }
               }
               $filename=~s/\.gz$//;print "LINE=".__LINE__."\n";
            }
         }
         if (keys %main::amazon) {
            unless (exists $main::amazon{'freebsd'}) {
               unless ($already_downloaded) {
                  if (grep { /-*add[-_]?dependencies/i } @ARGV) {
                     exec 'sudo',$^X,'Makefile.PL','add_dependencies',
                          $BDB_selection,$filename;print "LINE=".__LINE__."\n";
                  } else {
                     exec 'sudo',$^X,'Makefile.PL',$BDB_selection,
                          $filename;print "LINE=".__LINE__."\n";
                  }
               }
               my $so=system($CPAN::Config->{gzip}." -d $filename");print "LINE=".__LINE__."\n";
               if ($so==-1) {
                  die "Cannot gunzip $filename: $!\n";print "LINE=".__LINE__."\n";
               }
               print "***** Untar1: sudo ",
                  $CPAN::Config->{tar}," xvf $filename\n";print "LINE=".__LINE__."\n";
               open(FH, "sudo ".$CPAN::Config->{tar}." xvf $filename|");print "LINE=".__LINE__."\n";
            } else {
               unless ($already_downloaded) {
                  if (grep { /-*add[-_]?dependencies/i } @ARGV) {
                     exec 'sudo',$^X,'Makefile.PL','add_dependencies',
                          $BDB_selection,$filename;print "LINE=".__LINE__."\n";
                  } else {
                     exec 'sudo',$^X,'Makefile.PL',$BDB_selection,
                          $filename;print "LINE=".__LINE__."\n";
                  }
               }
               my $so=system($CPAN::Config->{gzip}." -d $filename");print "LINE=".__LINE__."\n";
               if ($so==-1) {
                  die "Cannot gunzip $filename: $!\n";print "LINE=".__LINE__."\n";
               }
               print "***** Untar2: ",
                  $CPAN::Config->{tar}," xvf $filename\n";print "LINE=".__LINE__."\n";
               open(FH, $CPAN::Config->{tar}." xvf $filename|");print "LINE=".__LINE__."\n";
            }
         } else {
            print "***** Untar3: ",
               $CPAN::Config->{tar}," xvf $filename\n";print "LINE=".__LINE__."\n";
            open(FH, $CPAN::Config->{tar}." xvf $filename|");print "LINE=".__LINE__."\n";
         }
         while (my $line=<FH>) {
            print $line;print "LINE=".__LINE__."\n";
         }
         close FH;print "LINE=".__LINE__."\n";
         my $uniq='';print "LINE=".__LINE__."\n";
         if ($BDB_selection eq 'Encrypted') {
            $filename=~/^.*(......).tar$/;print "LINE=".__LINE__."\n";
            $uniq=$1;print "LINE=".__LINE__."\n";
            $filename=~s/........tar$//;print "LINE=".__LINE__."\n";
            `mv -f $filename ${filename}_$uniq`;print "LINE=".__LINE__."\n";
         } else {
            $filename=~/^.*(......).NC.tar$/;print "LINE=".__LINE__."\n";
            $uniq=$1;print "LINE=".__LINE__."\n";
            $filename=~s/........NC.tar$//;print "LINE=".__LINE__."\n";
            `mv -f $filename.NC $filename.NC_$uniq`;print "LINE=".__LINE__."\n";
         }
         build_berkeleydb($filename,$uniq,$pre,$PREFIX,$BDB_selection);print "LINE=".__LINE__."\n";
      } else {
         if ($res->is_error(500)) {
            print(sprintf(
               "LWP failed with code[%s], message[%s]\n".
               "Please check your connection to the Internet!\n",
               $res->code,
               $res->message,
            ));print "LINE=".__LINE__."\n";
         } else {
            print(sprintf(
               "LWP failed with code[%s], message[%s]\n",
               $res->code,
               $res->message,
            ));print "LINE=".__LINE__."\n";
         }
      }
   } else {
      $CPAN::Frontend->mywarn("  LWP not available\n");print "LINE=".__LINE__."\n";
   }

}

sub build_berkeleydb {

   my $filename=$_[0];print "LINE=".__LINE__."\n";
   my $uniq=$_[1];print "LINE=".__LINE__."\n";
   my $pre=$_[2]||'';print "LINE=".__LINE__."\n";
   my $PREFIX=$_[3]||'';print "LINE=".__LINE__."\n";
   my $BDB_selection=$_[4]||'';print "LINE=".__LINE__."\n";
   my $args=' --enable-sql --enable-sql_compat';print "LINE=".__LINE__."\n";
   if ($PREFIX) {
      $args.=' --prefix="'.$PREFIX.'"';print "LINE=".__LINE__."\n";
   }
   my $one=1;print "LINE=".__LINE__."\n";
   WH: while ($one) {
      if ($BDB_selection eq 'Encrypted') {
         open(FH,
            "cd ${filename}_$uniq/build_unix;".
            "../dist/configure$args 2>&1|")
         || warn $!;print "LINE=".__LINE__."\n";
      } else {
         open(FH,
            "cd ${filename}.NC_$uniq/build_unix;".
            "../dist/configure$args 2>&1|")
         || warn $!;print "LINE=".__LINE__."\n";
      }
      while (my $line=<FH>) {
         print "THISSSS=$line<==\n";print "LINE=".__LINE__."\n";
         if (-1<index $line,'C compiler cannot create executables') {
print "AWESOME!!\n";print "LINE=".__LINE__."\n";
            #if ($main::os64bit) {
            #   $ENV{'CC'}='gcc -m64';print "LINE=".__LINE__."\n";
            #} else {
               $ENV{'CC'}='gcc';print "LINE=".__LINE__."\n";
            #}
            next WH;print "LINE=".__LINE__."\n";
         }
      }
      last;print "LINE=".__LINE__."\n";
   }
   close FH;print "LINE=".__LINE__."\n";
   unless ($CPAN::Config->{make}) {
      if (-e '/usr/bin/make') {
         $CPAN::Config->{make}='/usr/bin/make';print "LINE=".__LINE__."\n";
      } elsif (-e '/usr/local/bin/make') {
         $CPAN::Config->{make}='/usr/local/bin/make';print "LINE=".__LINE__."\n";
      }
   }
   if ($BDB_selection eq 'Encrypted') {
      print "*** Starting Encrypted BerkeleyDB build\n";print "LINE=".__LINE__."\n";
      system("(cd ${filename}_$uniq/build_unix;".
            $CPAN::Config->{make}." install) 2>&1")
         || warn $!;print "LINE=".__LINE__."\n";
      print "*** Completed Encrypted BerkeleyDB build\n";print "LINE=".__LINE__."\n";
   } else {
      print "*** Starting Non-Encrypted BerkeleyDB build\n";print "LINE=".__LINE__."\n";
      system("(cd ${filename}.NC_$uniq/build_unix;".
         $CPAN::Config->{make}." install) 2>&1")
         || warn $!;print "LINE=".__LINE__."\n";
      print "*** Completed Non-Encrypted BerkeleyDB build\n";print "LINE=".__LINE__."\n";
   }
   my $ver=$filename;print "LINE=".__LINE__."\n";
   $ver=~s/^.*db-(\d+[.]\d+).*$/$1/;print "LINE=".__LINE__."\n";
   $berkeleydb=$pre.'/lib';print "LINE=".__LINE__."\n";
   my $header_to_use=$pre.'/include';print "LINE=".__LINE__."\n";
   $ENV{'BERKELEYDB_INCLUDE'}=$header_to_use;print "LINE=".__LINE__."\n";
   $ENV{'BERKELEYDB_LIB'}=$berkeleydb;print "LINE=".__LINE__."\n";
   $ENV{'BERKELEYDB_NAME'}="-ldb-$ver";print "LINE=".__LINE__."\n";
   $ENV{'DB_FILE_INCLUDE'}=$header_to_use;print "LINE=".__LINE__."\n";
   $ENV{'DB_FILE_LIB'}=$berkeleydb;print "LINE=".__LINE__."\n";
   $ENV{'DB_FILE_NAME'}="-ldb-$ver";print "LINE=".__LINE__."\n";
   $ENV{'LD_LIBRARY_PATH'}=$berkeleydb;print "LINE=".__LINE__."\n";
   $ENV{'LD_RUN_PATH'}=$ENV{'LD_LIBRARY_PATH'};print "LINE=".__LINE__."\n";

}

sub get_temp_file {

   my $file=$_[0];print "LINE=".__LINE__."\n";
   my $suffix=$_[1];print "LINE=".__LINE__."\n";
   my $fh='';my $filename='';print "LINE=".__LINE__."\n";
   if ($CPAN::META->has_usable("File::Temp")) {
      $fh = File::Temp->new(
            dir      => cwd(),
            template => "${file}_XXXXXX",
            suffix => $suffix,
            unlink => 0,
           );print "LINE=".__LINE__."\n";
      $filename = $fh->filename;print "LINE=".__LINE__."\n";
   } else {
      $fh = FileHandle->new;print "LINE=".__LINE__."\n";
      $filename = "${file}_${$}$suffix";print "LINE=".__LINE__."\n";
   }
   chomp($filename);print "LINE=".__LINE__."\n";
   return $fh,$filename;print "LINE=".__LINE__."\n";

}

sub cpan_gunzip_and_untar {

   unless ($CPAN::Config->{gzip}) {
      if (-e '/usr/bin/gzip') {
         $CPAN::Config->{gzip}='/usr/bin/gzip';print "LINE=".__LINE__."\n";
      } elsif (-e '/usr/local/bin/gzip') {
         $CPAN::Config->{gzip}='/usr/local/bin/gzip';print "LINE=".__LINE__."\n";
      } else {
         print "\n\n   Fatal Error!: The 'gzip' utility is".
            " missing.\n".
            "\n\n   Please report any bugs and send any",
            "\n   questions, thoughts or feedback to:",
            "\n\n      Brian.Kelly\@FullAuto.com.",
            "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
      }
   }
   unless ($CPAN::Config->{tar}) {
      if (-e '/usr/sfw/bin/gtar') {
         $CPAN::Config->{tar}='/usr/sfw/bin/gtar';print "LINE=".__LINE__."\n";
      } elsif (-e '/usr/bin/tar') {
         $CPAN::Config->{tar}='/usr/bin/tar';print "LINE=".__LINE__."\n";
      } elsif (-e '/usr/local/bin/tar') {
         $CPAN::Config->{tar}='/usr/local/bin/tar';print "LINE=".__LINE__."\n";
      } else {
         print "\n\n   Fatal Error!: The 'tar' utility is".
            " missing.\n".
            "\n\n   Please report any bugs and send any",
            "\n   questions, thoughts or feedback to:",
            "\n\n      Brian.Kelly\@FullAuto.com.",
            "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
      }
   }

}

sub find_windows_app {

   # Let's look for Firefox
   my $firefox='REG QUERY "HKEY_LOCAL_MACHINE\\SOFTWARE\\'.
               'Mozilla\\Mozilla Firefox" 2>&1';print "LINE=".__LINE__."\n";
   $firefox=`$firefox`;print "LINE=".__LINE__."\n";
   $firefox=~tr/\0-\11\13-\37\177-\377//d;print "LINE=".__LINE__."\n";
   chomp($firefox);print "LINE=".__LINE__."\n";
   $firefox=~s/^.*CurrentVersion\s*REG_SZ\s*(.*?)\n.*$/$1/s;print "LINE=".__LINE__."\n";
   $firefox='REG QUERY "HKEY_LOCAL_MACHINE\\SOFTWARE\\'.
            "Mozilla\\Mozilla Firefox\\$firefox\\Main\" 2>&1";print "LINE=".__LINE__."\n";
   open (FF,"$firefox|");print "LINE=".__LINE__."\n";
   while (my $line=<FF>) {
      $firefox.=$line;print "LINE=".__LINE__."\n";
   }
   close FF;print "LINE=".__LINE__."\n";
   $firefox=~tr/\0-\11\13-\37\177-\377//d;print "LINE=".__LINE__."\n";
   chomp($firefox);print "LINE=".__LINE__."\n";
   $firefox=~s/^.*Path(?:To)*Exe\s*REG_SZ\s*(.*\.exe).*$/$1/s;print "LINE=".__LINE__."\n";
   $firefox=~s/\s*$//s;print "LINE=".__LINE__."\n";
   my $fftest=substr($firefox,0,2) if 1<length $firefox;print "LINE=".__LINE__."\n";
   $fftest||='';print "LINE=".__LINE__."\n";
   my $selection='';print "LINE=".__LINE__."\n";
   if ($fftest=~/\w:|\/\w/) {
      $fftest=substr($firefox,0,(rindex $firefox,'\\'));print "LINE=".__LINE__."\n";
   } else {
      $fftest='';print "LINE=".__LINE__."\n";
   }
   if (-1<index $firefox,'unable to find') {
      unless ($main::install_firefox_without_asking) {
         # Ask if we should install
         my $one="YES - Install Mozilla Firefox & MozRepl\n\n";print "LINE=".__LINE__."\n";
         my %_askfirefox=(

            Label => '_askfirefox',
            Item_1 =>  {
                           Text   => "]C[",
                           Convey => [ $one,
                                       'NO  - DO *NOT* INSTALL Firefox' ],
                       },
            Scroll => 2,
            Banner=> "   *** THIS SCREEN WILL TIMEOUT IN 2 MINUTES ***\n\n".
                     "   Mozilla Firefox has an available add-on called ".
                     "MozRepl.\n\n   With Firefox equipped with MozRepl, ".
                     "FullAuto can do\n   extremely powerful WEB ".
                     "Automation!\n\n   Would you like the FullAuto ".
                     "installer to install Firefox\n   and MozRepl?\n\n",
         );print "LINE=".__LINE__."\n";
         eval {
            local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
            alarm 120;print "LINE=".__LINE__."\n";
            $selection=Term::Menus::Menu(\%_askfirefox);print "LINE=".__LINE__."\n";
            alarm 0;print "LINE=".__LINE__."\n";
         };print "LINE=".__LINE__."\n";
         if ($@) {
            $selection='DO_NOT_INSTALL';print "LINE=".__LINE__."\n";
         } else {
            chomp($selection);print "LINE=".__LINE__."\n";
            $selection='Install_Mozilla_Firefox'
               if -1<index $selection,'Install Mozilla Firefox';print "LINE=".__LINE__."\n";
            $selection='DO_NOT_INSTALL'
               if -1<index $selection,'*NOT* INSTALL';print "LINE=".__LINE__."\n";
            exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
         }
      } else { $selection='Install_Mozilla_Firefox' }
      $main::install_firefox=$selection;print "LINE=".__LINE__."\n";
   } else { # Look for MozRepl
      my $up=$ENV{'USERPROFILE'};print "LINE=".__LINE__."\n";
      if (-1<index $up,'Documents') {
         $up.="\\Application Data\\Mozilla\\Firefox\\Profiles\\";print "LINE=".__LINE__."\n";
      } else {
         $up.="\\AppData\\Roaming\\Mozilla\\Firefox\\Profiles\\";print "LINE=".__LINE__."\n";
      }
      my @dirs=();print "LINE=".__LINE__."\n";
      if (-e $up) {
         opendir(DIR,$up);print "LINE=".__LINE__."\n";
         @dirs = readdir(DIR);print "LINE=".__LINE__."\n";
         closedir(DIR);print "LINE=".__LINE__."\n";
      }
      if (-1<$#dirs) {
         foreach my $profile (@dirs) {
            opendir(DIR,$up."\\$profile\\extensions");print "LINE=".__LINE__."\n";
            my @files = readdir(DIR);print "LINE=".__LINE__."\n";
            closedir(DIR);print "LINE=".__LINE__."\n";
            foreach my $file (@files) {
               if (-1<index $file,'mozrepl') {
                  return 0;print "LINE=".__LINE__."\n";
               }
            }
         }
      }
      unless ($main::install_firefox_without_asking) {
         # Ask if we should install
         my $one="YES - Install MozRepl Plugin for Firefox\n\n";print "LINE=".__LINE__."\n";
         my %_askfirefox=(

            Label => '_askfirefox',
            Item_1 =>  {
                           Text   => "]C[",
                           Convey => [ $one,'NO  - DO *NOT* INSTALL MozRepl' ],
                        },
            Scroll => 2,
            Banner=> "   Mozilla Firefox has an available add-on ".
                     "called MozRepl.\n\n   With Firefox equipped ".
                     "with MozRepl, FullAuto can do\n   extremely ".
                     "powerful WEB Automation!\n\n   Would you ".
                     "like the FullAuto installer to install ".
                     "the\n   MozRepl plugin?\n\n",
         );print "LINE=".__LINE__."\n";
         $selection=Term::Menus::Menu(\%_askfirefox);print "LINE=".__LINE__."\n";
         chomp($selection);print "LINE=".__LINE__."\n";
         $selection='Install_MozRepl'
            if -1<index $selection,'Install MozRepl Plugin';print "LINE=".__LINE__."\n";
         $selection='DO_NOT_INSTALL'
            if -1<index $selection,'*NOT* INSTALL';print "LINE=".__LINE__."\n";
         exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
      } else { $selection='Install_MozRepl' }
      $main::install_firefox=$selection;print "LINE=".__LINE__."\n";
   }
}

sub install_firefox {

   my $Ua;print "LINE=".__LINE__."\n";
   $ENV{PERL_LWP_SSL_VERIFY_HOSTNAME}=0;print "LINE=".__LINE__."\n";
   if ($CPAN::META->has_usable('LWP')) {
      FA::LWP::UserAgent->config;print "LINE=".__LINE__."\n";
      eval { $Ua = FA::LWP::UserAgent->new(
             timeout=>300,show_progress=>1) };print "LINE=".__LINE__."\n";
      if ($@) {
         $CPAN::Frontend->mywarn(
         "ERROR: FA::LWP::UserAgent->new dies with $@\n");print "LINE=".__LINE__."\n";
      } else {
         my($var);print "LINE=".__LINE__."\n";
         $Ua->proxy('http', $var)
            if $var = $CPAN::Config->{http_proxy} ||
            $ENV{http_proxy};print "LINE=".__LINE__."\n";
         $Ua->no_proxy($var)
            if $var = $CPAN::Config->{no_proxy} || $ENV{no_proxy};print "LINE=".__LINE__."\n";
      }
      $Ua->ssl_opts( SSL_verify_mode => 'SSL_VERIFY_NONE' );print "LINE=".__LINE__."\n";
   } else {
      die "Unable to install Firefox due to no LWP availability";print "LINE=".__LINE__."\n";
   }
   my $fftest='';print "LINE=".__LINE__."\n";
   unless ($main::install_firefox eq 'Install_MozRepl') {
      my $url='http://www.mozilla.org/en-US/firefox/all/';print "LINE=".__LINE__."\n";
      print "Fetching with LWP:\n  $url\n";print "LINE=".__LINE__."\n";
      my $req = HTTP::Request->new(GET => $url);print "LINE=".__LINE__."\n";
      $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
      my $res = $Ua->request($req);print "LINE=".__LINE__."\n";
      my $href='';print "LINE=".__LINE__."\n";
      if ($res->is_success) {
         print " + request successful.\n"
            if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
         my $count=0;print "LINE=".__LINE__."\n";
         my $content = $res->decoded_content();print "LINE=".__LINE__."\n";
         if (utf8::is_utf8($content)) {
            binmode STDOUT,':utf8';print "LINE=".__LINE__."\n";
         } else {
            binmode STDOUT,':raw';print "LINE=".__LINE__."\n";
         }
         foreach my $line (split "\n", $content) {
            if ((-1<index $line, 'english (us) english (us)') ||
                  ((0<$count) && ($count<5))) {
               if ($count==3) {
                  $href=$line;print "LINE=".__LINE__."\n";
                  last;print "LINE=".__LINE__."\n";
               }
               $count++;print "LINE=".__LINE__."\n";
            }
         }
      }
      $href=~s/^.*href=["](.*?)["].*$/$1/;print "LINE=".__LINE__."\n";
      $href=~s/https/http/;print "LINE=".__LINE__."\n";
      $href=~s/&amp;/&/g;print "LINE=".__LINE__."\n";
      my $exe_name=substr($href,(rindex $href,'/'));print "LINE=".__LINE__."\n";
      $exe_name=~s/^.*?product=(.*?)[&].*$/$1/;print "LINE=".__LINE__."\n";
      $exe_name=~s/firefox-/Firefox Setup /;print "LINE=".__LINE__."\n";
      $req = HTTP::Request->new(GET => $href);print "LINE=".__LINE__."\n";
      $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
      $res = $Ua->request($req);print "LINE=".__LINE__."\n";
      if ($res->is_success) {
         print " + request successful.\n"
         if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
         mkpath($main::root_dir,1) unless -d $main::root_dir;print "LINE=".__LINE__."\n";
         unless (-w $main::root_dir) {
            print "\n\n   Fatal Error! - The current Cygwin directory: ".
                  "\n\n      ".$main::root_dir."\n\n".
                  "   is not writable. Please change the permissions\n".
                  "   to writable before installing FullAuto.\n";print "LINE=".__LINE__."\n";
            print "\n   PRESS ANY KEY TO EXIT SETUP\n\n";print "LINE=".__LINE__."\n";
            <STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
         open(CP,">$main::root_dir/${exe_name}.exe") || die $!;print "LINE=".__LINE__."\n";
         binmode(CP);print "LINE=".__LINE__."\n";
         print CP $res->content;print "LINE=".__LINE__."\n";
         close CP;print "LINE=".__LINE__."\n";
         if ($^O eq 'cygwin') {
            `/usr/bin/chmod 777 \"$main::root_dir/${exe_name}.exe\"`;print "LINE=".__LINE__."\n";
         } else {
            my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
            system('SET CYGWIN=nodosfilewarning & '.
                "cmd /c $cygwin_loc\\bin\\bash -lc ".
                "/usr/bin/chmod 777 \"$main::root_dir/${exe_name}.exe\"");print "LINE=".__LINE__."\n";
         }
         `"$main::root_dir/${exe_name}.exe" -ms`;print "LINE=".__LINE__."\n";
         # Let's look for Firefox
         my $firefox='REG QUERY "HKEY_LOCAL_MACHINE\\SOFTWARE\\'.
                     'Mozilla\\Mozilla Firefox" 2>&1';print "LINE=".__LINE__."\n";
         $firefox=`$firefox`;print "LINE=".__LINE__."\n";
         $firefox=~tr/\0-\11\13-\37\177-\377//d;print "LINE=".__LINE__."\n";
         chomp($firefox);print "LINE=".__LINE__."\n";
         $firefox=~s/^.*CurrentVersion\s*REG_SZ\s*(.*?)\n.*$/$1/s;print "LINE=".__LINE__."\n";
         $firefox='REG QUERY "HKEY_LOCAL_MACHINE\\SOFTWARE\\'.
                  "Mozilla\\Mozilla Firefox\\$firefox\\Main\" 2>&1";print "LINE=".__LINE__."\n";
         open (FF,"$firefox|");print "LINE=".__LINE__."\n";
         while (my $line=<FF>) {
            $firefox.=$line;print "LINE=".__LINE__."\n";
         }
         close FF;print "LINE=".__LINE__."\n";
         $firefox=~tr/\0-\11\13-\37\177-\377//d;print "LINE=".__LINE__."\n";
         chomp($firefox);print "LINE=".__LINE__."\n";
         $firefox=~s/^.*Path(?:To)*Exe\s*REG_SZ\s*(.*\.exe).*$/$1/s;print "LINE=".__LINE__."\n";
         $firefox=~s/\s*$//s;print "LINE=".__LINE__."\n";
         $fftest=substr($firefox,0,2) if 1<length $firefox;print "LINE=".__LINE__."\n";
         $fftest||='';print "LINE=".__LINE__."\n";
         my $selection='';print "LINE=".__LINE__."\n";
         if ($fftest=~/\w:|\/\w/) {
            $fftest=substr($firefox,0,(rindex $firefox,'\\'));print "LINE=".__LINE__."\n";
         } else {
            $fftest='';print "LINE=".__LINE__."\n";
         }
      }
   } else {
      # Let's look for Firefox
      my $firefox='REG QUERY "HKEY_LOCAL_MACHINE\\SOFTWARE\\'.
                  'Mozilla\\Mozilla Firefox" 2>&1';print "LINE=".__LINE__."\n";
      $firefox=`$firefox`;print "LINE=".__LINE__."\n";
      $firefox=~tr/\0-\11\13-\37\177-\377//d;print "LINE=".__LINE__."\n";
      chomp($firefox);print "LINE=".__LINE__."\n";
      $firefox=~s/^.*CurrentVersion\s*REG_SZ\s*(.*?)\n.*$/$1/s;print "LINE=".__LINE__."\n";
      $firefox='REG QUERY "HKEY_LOCAL_MACHINE\\SOFTWARE\\'.
               "Mozilla\\Mozilla Firefox\\$firefox\\Main\" 2>&1";print "LINE=".__LINE__."\n";
      open (FF,"$firefox|");print "LINE=".__LINE__."\n";
      while (my $line=<FF>) {
         $firefox.=$line;print "LINE=".__LINE__."\n";
      }
      close FF;print "LINE=".__LINE__."\n";
      $firefox=~tr/\0-\11\13-\37\177-\377//d; 
      chomp($firefox);print "LINE=".__LINE__."\n";
      $firefox=~s/^.*Path(?:To)*Exe\s*REG_SZ\s*(.*\.exe).*$/$1/s;print "LINE=".__LINE__."\n";
      $firefox=~s/\s*$//s;print "LINE=".__LINE__."\n";
      $fftest=substr($firefox,0,2) if 1<length $firefox;print "LINE=".__LINE__."\n";
      $fftest||='';print "LINE=".__LINE__."\n";
      my $selection='';print "LINE=".__LINE__."\n";
      if ($fftest=~/\w:|\/\w/) {
         $fftest=substr($firefox,0,(rindex $firefox,'\\'));print "LINE=".__LINE__."\n";
      } else {
         $fftest='';print "LINE=".__LINE__."\n";
      }
   }
   my $url='https://addons.mozilla.org/firefox/downloads/file/'.
        "138898/$main::mozrepl_file?src=dp-btn-primary";print "LINE=".__LINE__."\n";
   my $req = HTTP::Request->new(GET => $url);print "LINE=".__LINE__."\n";
   $req->header('Accept' => 'text/html');print "LINE=".__LINE__."\n";
   my $res = $Ua->request($req);print "LINE=".__LINE__."\n";
   my $href='';print "LINE=".__LINE__."\n";
   my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
   my $clo=$cygwin_loc;print "LINE=".__LINE__."\n";
   my $mz="$clo\\$main::mozrepl_file";print "LINE=".__LINE__."\n";
   if ($res->is_success) {
      print " + request successful.\n"
         if $CPAN::DEBUG;print "LINE=".__LINE__."\n";
      open(CP,">$mz") || die $!;print "LINE=".__LINE__."\n";
      binmode(CP);print "LINE=".__LINE__."\n";
      print CP $res->content;print "LINE=".__LINE__."\n";
      close CP;print "LINE=".__LINE__."\n";
      my $ff=$fftest.'\\firefox';print "LINE=".__LINE__."\n";
      my $mP=$main::PARdir;print "LINE=".__LINE__."\n";
      if ($^O eq 'cygwin') {
         $mz=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
         my $chmod_out=
               `chmod -v 777 \"$mP/bin/install_mozrepl_plugin\" 2>&1`;print "LINE=".__LINE__."\n";
         print "CYGCHMOD=$chmod_out\n" if $chmod_out;print "LINE=".__LINE__."\n";
         print "MOZREPL COMMAND=\"$mP/bin/install_mozrepl_plugin\" ".
               "\"$ff\" \"$mz\" 2>&1\n";print "LINE=".__LINE__."\n";
         my $output=
               `\"$mP/bin/install_mozrepl_plugin\" \"$ff\" \"$mz\" 2>&1`;print "LINE=".__LINE__."\n";
         print "CYGOUTPUT=$output\n" if $output;print "LINE=".__LINE__."\n";
      } else {
         my $output=
               `\"$mP\\bin\\install_mozrepl_plugin\" \"$ff\" \"$mz\" 2>&1`;print "LINE=".__LINE__."\n";
         print "WINOUTPUT=$output\n" if $output;print "LINE=".__LINE__."\n";
      }
   }
}

sub remove_sshd {
   my $sshd_account=$_[0];print "LINE=".__LINE__."\n";
   my $cygwin_loc=get_cygwin_location();print "LINE=".__LINE__."\n";
   my $clo=$cygwin_loc;print "LINE=".__LINE__."\n";
   $clo=~s/\\/\\\\/g;print "LINE=".__LINE__."\n";
   if (-e $cygwin_loc) {
      if ($^O eq 'cygwin') {
         my $srvcmd='export CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\\\bin\\\\bash -lc ".
                    '"/usr/bin/cygrunsrv --verbose --query sshd"';print "LINE=".__LINE__."\n";
         my $cygout=`$srvcmd 2>&1`;print "LINE=".__LINE__."\n";
         if ($cygout=~/^Account\s+: .\\$sshd_account$/m) {
            my $srvcmd='export CYGWIN=nodosfilewarning & '.
                       "cmd /c $clo\\\\bin\\\\bash -lc ".
                       '"/usr/bin/cygrunsrv --remove sshd"';print "LINE=".__LINE__."\n";
            my $cygout=`$srvcmd 2>&1`;print "LINE=".__LINE__."\n";
         } elsif (-1==index $cygout,'service does not exist') {
            return 0;print "LINE=".__LINE__."\n";
         }
      } else {
         my $srvcmd='SET CYGWIN=nodosfilewarning & '.
                    "cmd /c $clo\\\\bin\\\\bash -lc ".
                    '"/usr/bin/cygrunsrv --verbose --query sshd"';print "LINE=".__LINE__."\n";
         my $cygout=`$srvcmd 2>&1`;print "LINE=".__LINE__."\n";
         if ($cygout=~/^Account\s+: .\\$sshd_account$/m) {
            my $srvcmd='SET CYGWIN=nodosfilewarning & '.
                       "cmd /c $clo\\\\bin\\\\bash -lc ".
                       '"/usr/bin/cygrunsrv --remove sshd"';print "LINE=".__LINE__."\n";
            my $cygout=`$srvcmd 2>&1`;print "LINE=".__LINE__."\n";
         } elsif (-1==index $cygout,'service does not exist') {
            return 0;print "LINE=".__LINE__."\n";
         }
      }
      my $remove_out=`net user /delete sshd 2>&1`;print "LINE=".__LINE__."\n";
      if (-e "$cygwin_loc\\etc\\passwd") {
         do {
            local $^I='.bak'; # see perlvar(1)
            local @ARGV=("$cygwin_loc\\etc\\passwd");print "LINE=".__LINE__."\n";
            while(<>){
               s/^$sshd_account:.*\s*$//;print "LINE=".__LINE__."\n";
               s/^sshd:.*\s*$//;print "LINE=".__LINE__."\n";
               print;print "LINE=".__LINE__."\n";
            }
         };print "LINE=".__LINE__."\n";
      }
   }
   return 1;print "LINE=".__LINE__."\n";
}

sub test_windows_user_rights {

   my $user=$_[0];print "LINE=".__LINE__."\n";

   # Is Cygwin installed?
   my $cygwin_location=get_cygwin_location();print "LINE=".__LINE__."\n";

   # Adjust memory quotas for a process             (SeIncreaseQuotaPrivilege)
   # Create a token object                          (SeCreateTokenPrivilege)
   # Log on as a service                            (SeServiceLogonRight)
   # Replace a process level token
   #                                           (SeAssignPrimaryTokenPrivilege)

   # Act as part of the operating system            (SeTcbPrivilege)

   # >  And for security.....

   # Deny log on locally                         (SeDenyInteractiveLogonRight)
   # Deny access to this computer from the network   (SeDenyNetworkLogonRight)
   # Deny log on through Terminal Services
   #                                       (SeDenyRemoteInteractiveLogonRight)

   my $rights=`$cygwin_location\\bin\\editrights -u $user -l`;print "LINE=".__LINE__."\n";
   my $output='';print "LINE=".__LINE__."\n";
   if ((-1==index $rights,'SeServiceLogonRight') ||
         (-1==index $rights,'SeTcbPrivilege') ||
         (-1==index $rights,'SeCreateTokenPrivilege') ||
         (-1==index $rights,'SeAssignPrimaryTokenPrivilege') || 1) {
      my $die='DYING';print "LINE=".__LINE__."\n";
      my @missing_rights=();print "LINE=".__LINE__."\n";
      if (-1==index $rights,'SeTcbPrivilege') {
         unless ($output=
               `/bin/editrights -a SeTcbPrivilege -u $user`) {
            push @missing_rights, 'SeTcbPrivilege';print "LINE=".__LINE__."\n";
         }
      }
      if (-1==index $rights,'SeCreateTokenPrivilege') {
         my $prv='SeCreateTokenPrivilege';print "LINE=".__LINE__."\n";
         unless (`/bin/editrights -a $prv -u $user`) {
            push @missing_rights, 'SeCreateTokenPrivilege';print "LINE=".__LINE__."\n";
         }
      }
      if (-1==index $rights,'SeAssignPrimaryTokenPrivilege') {
         my $prv='SeAssignPrimaryTokenPrivilege';print "LINE=".__LINE__."\n";
         unless (`/bin/editrights -a $prv -u $user`) {
            push @missing_rights, 'SeAssignPrimaryTokenPrivilege';print "LINE=".__LINE__."\n";
         }
      }
      if (-1==index $rights,'SeServiceLogonRight') {
         my $prv='SeServiceLogonRight';print "LINE=".__LINE__."\n";
         unless (`/bin/editrights -a $prv -u $user`) {
            push @missing_rights, 'SeServiceLogonRight';print "LINE=".__LINE__."\n";
         }
      }
      if (-1<$#missing_rights) {
         my $mis=join "\n",map { "               $_" } @missing_rights;print "LINE=".__LINE__."\n";
         my $die="   Fatal Error! - The following priviliges are\n   ".
                 "               missing from the ID '".$user."':\n\n".
                 $mis."\n\n   An attempt was made to add these rights,\n".
                 "   but was not successul. Please contact your\n".
                 "   your Domain and Server Administrators for\n".
                 "   assistance.\n\n   PRESS ANY KEY to EXIT FullAuto".
                 " Setup.\n\n";print "LINE=".__LINE__."\n";
         print $die;<STDIN>;print "LINE=".__LINE__."\n";
         exit 1;print "LINE=".__LINE__."\n";
      }
      my $gpout=`gpupdate 2>&1`;print "LINE=".__LINE__."\n";
      if (-1<index $gpout,'completed successfully') {
         @missing_rights=();print "LINE=".__LINE__."\n";
         if (-1==index $rights,'SeTcbPrivilege') {
            push @missing_rights, 'SeTcbPrivilege';print "LINE=".__LINE__."\n";
         }
         if (-1==index $rights,'SeCreateTokenPrivilege') {
            push @missing_rights, 'SeCreateTokenPrivilege';print "LINE=".__LINE__."\n";
         }
         if (-1==index $rights,'SeAssignPrimaryTokenPrivilege') {
            push @missing_rights, 'SeAssignPrimaryTokenPrivilege';print "LINE=".__LINE__."\n";
         }
         if (-1==index $rights,'SeServiceLogonRight') {
            push @missing_rights, 'SeServiceLogonRight';print "LINE=".__LINE__."\n";
         }
         if (-1<$#missing_rights) {
            my $mis=join "\n",map { "               $_" } @missing_rights;print "LINE=".__LINE__."\n";
            my $die="   Fatal Error! - The following priviliges were\n".
                    "                  added to the ID '".$user."':\n\n".
                    $mis."\n\n   However, these priviliges were\n".
                    "   subsequently removed by a Domain Global\n".
                    "   Policy Update. Please contact your Windows\n".
                    "   Domain and Server Administrators to have the\n".
                    "   Global Domain Policy changed for this ID.\n\n".
                    "   PRESS ANY KEY to EXIT FullAuto".
                    " Setup.\n\n";print "LINE=".__LINE__."\n";
            print $die;<STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
      }
   }
}

sub test_windows_user {
   my $sshd_account=$_[0];print "LINE=".__LINE__."\n";
   my $test_user=`net user $sshd_account 2>&1`;print "LINE=".__LINE__."\n";
   if (-1<index $test_user,'not be found') {
      my $return=&remove_sshd($sshd_account); 
      return 1;print "LINE=".__LINE__."\n";
   }
   # Is Cygwin installed?
   my $cygwin_location=get_cygwin_location();print "LINE=".__LINE__."\n";

   # Adjust memory quotas for a process             (SeIncreaseQuotaPrivilege)
   # Create a token object                          (SeCreateTokenPrivilege)
   # Log on as a service                            (SeServiceLogonRight)
   # Replace a process level token
   #                                           (SeAssignPrimaryTokenPrivilege)

   # Act as part of the operating system            (SeTcbPrivilege)

   # > 	And for security.....

   # Deny log on locally                         (SeDenyInteractiveLogonRight)
   # Deny access to this computer from the network   (SeDenyNetworkLogonRight)
   # Deny log on through Terminal Services 
   #                                       (SeDenyRemoteInteractiveLogonRight)

   if ($cygwin_location) {
      my $rights=`$cygwin_location\\bin\\editrights -u $sshd_account -l`;print "LINE=".__LINE__."\n";
      print "RIGHTS for $sshd_account ======>\n$rights\n<=======\n";print "LINE=".__LINE__."\n";
      if ((-1==index $rights,'SeServiceLogonRight') || 
            ((-1==index $rights,'SeDenyRemoteInteractiveLogonRight') &&
            (-1==index $rights,'SeDenyInteractiveLogonRight'))) {
         print "\n\n   FullAuto Install has determined that the current",
               "\n   \"$sshd_account\" user ID, lacks sufficient privileges",
               "\n   to act as the sshd service ID.",
               "\n\n      The needed privileges are:",
               "\n\n         SeServiceLogonRight  SeCreateTokenPrivilege",
               "\n         SeDenyInteractiveLogonRight  SeTcbPrivilege",
               "\n         SeAssignPrimaryTokenPrivilege",
               "\n\n   Use:  /bin/editrights -u $sshd_account -l",
               "\n\n   to manually inspect these privileges.",
               "\n\n   Some corporate environments enforce strict group",
               "\n   rights from the Domain Controller, and these",
               "\n   privileges may be surreptiously removed from the",
               "\n   $sshd_account account without notice. Check with your",
               "\n   Microsoft Infrastructure Admins if you suspect this",
               "\n   may be a possibility with your setup. You will need",
               "\n   to get an exception added to their configuration.\n\n";print "LINE=".__LINE__."\n";
         print "   Press ANY key to continue . . . ";<STDIN>;print "LINE=".__LINE__."\n";
         my $remove_out=`net user /delete cyg_server 2>&1`;print "LINE=".__LINE__."\n";
         if (-1<index $remove_out,"command completed successfully") {
            my $return=&remove_sshd($sshd_account);print "LINE=".__LINE__."\n";
            return $return;print "LINE=".__LINE__."\n";
         } else {
            print "\n      FullAuto Install attempted to remove the ID ",
                  "before",
                  "\n   trying a re-install but was unsuccessful:",
                  "\n\n   $remove_out",
                  "\n\n   Please remedy the situtation before trying FullAuto",
                  "\n     Install again.",
                  "\n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
      }
      unless (-e "$cygwin_location\\var\\empty") {
         my $remove_out=`net user /delete $sshd_account 2>&1`;print "LINE=".__LINE__."\n";
         if (-1<index $remove_out,"command completed successfully") {
            my $return=&remove_sshd($sshd_account);print "LINE=".__LINE__."\n";
            return $return;print "LINE=".__LINE__."\n";
         } else {
            print "\n\n   FullAuto Install has determined that the.",
                  "\n   current sshd service setup was not completed",
                  "\n   correctly with the user ID \"cyg_server\":",
                  "\n\n      The directory: $cygwin_location\\var\\empty",
                  "\n\n      does NOT exist.", 
                  "\n\n      FullAuto Install attempted to remove",
                  "\n   the ID before trying a re-install but",
                  "\n   was unsuccessful:\n\n   $remove_out.\n\n",
                  "\n\n   Please remedy the situtation before trying.",
                  "\n   FullAuto Install again.",
                  "\n\n   Please report any bugs and send any",
                  "\n   questions, thoughts or feedback to:",
                  "\n\n      Brian.Kelly\@FullAuto.com.",
                  "\n\n   Press ANY key to exit.\n\n";<STDIN>;print "LINE=".__LINE__."\n";
            exit 1;print "LINE=".__LINE__."\n";
         }
      }
      return 0;print "LINE=".__LINE__."\n";
   } else {
      return 0;print "LINE=".__LINE__."\n";
   }
}

sub windows_ver {
   # Thanks - http://ss64.org/viewtopic.php?id=879
   # and    - http://en.wikipedia.org/wiki/Ver_(command)
   my $output=`cmd /c ver`;print "LINE=".__LINE__."\n";
   if (-1<index $output,'4.0.950') {
      return 'Windows 95';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'4.0.950') {
      return 'Windows 98';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'4.10.2222') {
      return 'Windows 98 SE';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'4.90.3000') {
      return 'Windows ME';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'NT') {
      return 'Windows NT';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'5.0.2195') {
      return 'Windows 2000';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'5.1.2600') {
      return 'Windows XP';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'5.2.3790') {
      return 'Windows Server 2003';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'5.2.4500') {
      return 'Windows Home Server'; # aka Windows XP 64-Bit Edition
   } elsif (-1<index $output,'6.0.6001') {
      return 'Windows Vista';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'6.0.6002') {
      return 'Windows Server 2008';print "LINE=".__LINE__."\n";
   } elsif (-1<index $output,'6.1.7600') {
      return 'Windows Server 2008 R2'
   } elsif (-1<index $output,'6.1.7601') {
      return 'Windows 7 SP1';print "LINE=".__LINE__."\n";
   } else {
      $output=~s/\s*\[.*$//s;print "LINE=".__LINE__."\n";
      return $output;print "LINE=".__LINE__."\n";
   }
}

if ($^O eq 'cygwin' && &windows_ver=~/XP|2000|NT/) {
   my $regc='regtool -v check "/HKLM/Software/Microsoft/'.
            'Windows/CurrentVersion/Explorer/AlwaysUnloadDLL" 2>&1';print "LINE=".__LINE__."\n";
   my $outp=`$regc`;print "LINE=".__LINE__."\n";
   my $notthere=0;print "LINE=".__LINE__."\n";
   if ($outp=~/key\s+exists/s) {
      my $regc='regtool -v list "/HKLM/Software/Microsoft/'.
            'Windows/CurrentVersion/Explorer/AlwaysUnloadDLL" 2>&1';print "LINE=".__LINE__."\n";
      my $outp=`$regc`;print "LINE=".__LINE__."\n";
      if ($outp!~/\(REG_SZ\) = \"1\"/) {
         $notthere=1; 
      }
   } else { $notthere=1 }
   if ($notthere) {
      eval {
         my $timeout=120;print "LINE=".__LINE__."\n";
         local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
         alarm $timeout;print "LINE=".__LINE__."\n";
         print "\n       *** THIS SCREEN WILL TIMEOUT IN 2 MINUTES ***\n".
               "\n       IMPORTANT! : FullAuto is VERY Memory Intensive.".
               "\n                  Setup has detected that a recommended".
               "\n                  Windows XP registry setting does NOT".
               "\n                  exist. As a result, Windows XP does".
               "\n                  not remove DLL's from memory when an".
               "\n                  an application exits, but keeps them".
               "\n                  in memory for a time in order to speed".
               "\n                  up application startup *in case* the".
               "\n                  the app is restarted. Cygwin and ssh".
               "\n                  load DLLs and with repeated invocation".
               "\n                  (which is common FullAuto usage),".
               "\n                  memory can 'max' out and cause all".
               "\n                  active FullAuto and Cygwin processes".
               "\n                  to freeze and hang.".
               "\n\n       Therefore, it is *HIGHLY* recommended that this".
               "\n       registry setting exist:\n".
               "\n       /HKLM/Software/Microsoft/Windows/CurrentVersion/".
               "Explorer/AlwaysUnload DLL\n".
               "\n       FullAuto setup can do this for you, but only with".
               "\n       your approval. Would you like FullAuto setup to".
               "\n       attempt to insert this registry setting?".
               "\n\n       (If you do not wish FullAuto setup to".
               "\n       perform this step, type 'N' and setup will".
               "\n       continue WITHOUT modifying the Windows registry.)".
               "\n\n";print "LINE=".__LINE__."\n";
         print "Type <Y> if you wish to FullAuto setup to modify ",
               "the registry,\nor 'N' to proceed without this step ",
               ". . . [N] ";print "LINE=".__LINE__."\n";
         $a=<STDIN>;print "LINE=".__LINE__."\n";
         alarm 0;print "LINE=".__LINE__."\n";
      };print "LINE=".__LINE__."\n";
      if ($@) {
         # timed out
         # exit;print "LINE=".__LINE__."\n";
      } elsif ($a=~/^[Yy]$/s) {
         $regc='cmd /c "REG ADD HKLM\\Software\\Microsoft\\Windows\\'.
               'CurrentVersion\\Explorer\\AlwaysUnloadDLL '.
               '/ve /t REG_SZ /d 1" 2>&1';print "LINE=".__LINE__."\n";
         $outp=`$regc`;print "LINE=".__LINE__."\n";
         print $outp."\n";print "LINE=".__LINE__."\n";
      } alarm 0;print "LINE=".__LINE__."\n";

   }
}

#Specific dependencies for web caching functionality
#requires        'Cache::Cache'              => 0;print "LINE=".__LINE__."\n";
#requires        'CHI'                       => 0;print "LINE=".__LINE__."\n";

auto_install();print "LINE=".__LINE__."\n";

my $c_file='';print "LINE=".__LINE__."\n";
my $date=strftime('%D',localtime);print "LINE=".__LINE__."\n";

my $banner='';my $perllibdir='';my $perlsitebin='';print "LINE=".__LINE__."\n";
if (exists $ENV{PERL_LOCAL_LIB_ROOT}) {
   $perllibdir=$ENV{PERL_LOCAL_LIB_ROOT};print "LINE=".__LINE__."\n";
   $perlsitebin=$ENV{PERL_LOCAL_LIB_ROOT}.'/bin';print "LINE=".__LINE__."\n";
} else {
   unless (-e $Config{installsitelib}) {
      `mkdir -p $Config{installsitelib}`;print "LINE=".__LINE__."\n";
   }
   unless (-w $Config{installsitelib}) {
      $banner=
           "\n   *** THIS SCREEN WILL TIMEOUT AND CHOOSE 'NO' IN 2 MINUTES ***\n".
           "\n   WARNING!: You do not have permission to install FullAuto".
           "\n   to the default location -> $Config{installsitelib}.\n".
           "\n   Hint 1: You can use the PREFIX and LIB attributes to".
           "\n   set several attributes at once. The quickest way to".
           "\n   install FullAuto in a non-default location might be".
           "\n   setting PREFIX to '~'. You can do this by selecting".
           "\n   'Yes' below, or by re-running Makefile.PL with the".
           "\n   the following argument:\n".
           "\n   perl Makefile.PL PREFIX=~\n".
           "\n   This will install all FullAuto files under your home".
           "\n   directory, with man pages and libraries going into the".
           "\n   appropriate place (most likely ~/man and ~/lib)\n".
           "\n   You may also consider using the LIB attribute:\n".
           "\n   perl Makefile.PL LIB=~/lib\n".
           "\n   See the MakeMaker.pm module documetation for more".
           "\n   information:\n".
           "\n   http://search.cpan.org/~mschwern/ExtUtils-MakeMaker-6.56".
           "/lib/ExtUtils/MakeMaker.pm#PREFIX_and_LIB_attribute\n".
           "\n   Hint 2: Run perl MakeMaker.PL with an appropriate user".
           "\n   (such as root) or with a utility such as sudo if you".
           "\n   are authorized to use it (sudo perl Makefile.PL).".
           "\n   The same is true if you are attempting to install".
           "\n   FullAuto via the CPAN resposiory (i.e. 'sudo cpan')\n".
           "\n   Would like to install FullAuto to your home (~) directory?\n\n"
   }
   $perllibdir=$Config{installsitelib};print "LINE=".__LINE__."\n";
   $perlsitebin=$Config{installsitebin};print "LINE=".__LINE__."\n";
}

if ($banner) {

   my $timeout=120;my $selection='';print "LINE=".__LINE__."\n";
   eval {
      local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
      alarm $timeout;print "LINE=".__LINE__."\n";
      my $menu1 = [
                  $banner,
                  [ "Yes", sub{ return 'Yes' } ],
                  [ "No   (FullAuto install will exit)", sub{ return 'No' } ],
                  #[ "Quit", sub {exit;} ],
                  ];print "LINE=".__LINE__."\n";
      $selection=&menu($menu1);print "LINE=".__LINE__."\n";
      exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
      alarm 0;print "LINE=".__LINE__."\n";
   };print "LINE=".__LINE__."\n";
   if ($@) {
      # timed out
      $selection = 'No';print "LINE=".__LINE__."\n";
   }
   if ($selection=~/No/) {
      exit;print "LINE=".__LINE__."\n";
   } alarm 0;print "LINE=".__LINE__."\n";
}

print "$main::curdir\n";print "LINE=".__LINE__."\n";
chdir $main::curdir;print "LINE=".__LINE__."\n";

open(FH,">fullauto.c");print "LINE=".__LINE__."\n";

print FH '/* program: fullauto'."\n".
"   author:  Brian Kelly\n".
"   date:    $date\n".
"\n".
"   purpose: C program wrapper that calls $perlsitebin/fullauto.pl script\n".
"   WARNING: This file is auto-generated by Makefile.PL, please change Makefile.PL.\n".
"            Any modifications made to this source file will be lost!\n".
'*/'."\n".
"\n".
'#define REAL_PL '.'"'.$perlsitebin."/fullauto.pl\"\n".
"main(int argc, char *argv[])\n".
'{'."\n".
"\tsetuid(0);\n".
"\tseteuid(0);\n".
"\texecv(REAL_PL, argv);\n".
'}'."\n";print "LINE=".__LINE__."\n";

close FH;print "LINE=".__LINE__."\n";

my $timeout=120;my $selection='';print "LINE=".__LINE__."\n";
if (keys %main::amazon) {
   $selection='Install with Full Access Permissions (Recommended Default)';print "LINE=".__LINE__."\n";
} elsif (!exists $ENV{FA_BERKELEY}) {
   eval {
      local $SIG{ALRM} = sub { die "alarm\n" }; # NB: \n required
      alarm $timeout;print "LINE=".__LINE__."\n";
      my @list=();print "LINE=".__LINE__."\n";
      my %perms_menu=();print "LINE=".__LINE__."\n";
      unless ($^O eq 'cygwin') {
         @list=('Install with Full Access Permissions (Recommended Default)',
                'Install with Setuid Permissions',
                'Install with Setgid Permissions',
                'Install with Owner Group Permissions');print "LINE=".__LINE__."\n";
         my $banner="\n   *** THIS SCREEN WILL TIMEOUT AND CHOOSE ".
               "\'Full Access\' IN 2 MINUTES ***\n".
               "\n   Choose a Permission Setting :\n\n";print "LINE=".__LINE__."\n";
         %perms_menu=(

            Name => 'perms_menu',
            Item_1 => {

               Text => ']C[',
               Convey => \@list,

            },
            Scroll => 1,
            Banner => $banner,

         ); 
      } else {
         @list=('Install with Full Access Permissions (Default)',
                'Install with Owner Group Permissions');print "LINE=".__LINE__."\n";
         my $banner="\n   *** THIS SCREEN WILL TIMEOUT AND CHOOSE ".
               "\'Full-Access\' IN 2 MINUTES ***\n".
               "\n   Choose a Permission Setting :\n\n";print "LINE=".__LINE__."\n";
         %perms_menu=(

            Name => 'perms_menu',
            Item_1 => {

               Text => ']C[',
               Convey => \@list,

            },
            Scroll => 1,
            Banner => $banner,

         );print "LINE=".__LINE__."\n";
      }
      $selection=Term::Menus::Menu(\%perms_menu);print "LINE=".__LINE__."\n";
      alarm 0;print "LINE=".__LINE__."\n";
   };print "LINE=".__LINE__."\n";
   exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
   if ($@) {
      # timed out
      print "\n";print "LINE=".__LINE__."\n";
      $selection = 'Full Access';print "LINE=".__LINE__."\n";
      Term::ReadKey::ReadMode(0);print "LINE=".__LINE__."\n";
   } alarm 0;print "LINE=".__LINE__."\n";
} elsif (-1<index $ENV{FA_BERKELEY},'Owner Group') {
   $selection='Install with Owner Group Permissions';print "LINE=".__LINE__."\n";
} elsif (-1<index $ENV{FA_BERKELEY},'Full Access') {
   $selection='Install with Full Access Permissions (Default)';print "LINE=".__LINE__."\n";
}

my $permission = 'Full Access';print "LINE=".__LINE__."\n";
if (-1<index $selection,'Setuid') {
   $permission = 'Setuid';print "LINE=".__LINE__."\n";
} elsif (-1<index $selection,'Setgid') {
   $permission = 'Setgid';print "LINE=".__LINE__."\n";
} elsif (-1<index $selection,'Owner Group') {
   $permission = 'Owner-Group';print "LINE=".__LINE__."\n";
   $main::cygwin_berkeley_db_mode=770 if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
} elsif (-1<index $selection,'Full Access') {
   $permission = 'Full-Access';print "LINE=".__LINE__."\n";
   $main::cygwin_berkeley_db_mode=777  if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
} elsif (-1<index $selection,'quit') {
   exit;print "LINE=".__LINE__."\n";
} print "\n";print "LINE=".__LINE__."\n";

if ($^O eq 'cygwin') {
   open(FH,">bin/fullauto.exe");print "LINE=".__LINE__."\n";
   print FH "\n";print "LINE=".__LINE__."\n";
   close FH;print "LINE=".__LINE__."\n";
   install_script('bin/fullauto.exe');print "LINE=".__LINE__."\n";
   install_script('bin/install_mozrepl_plugin.exe');print "LINE=".__LINE__."\n";
   unlink "bin/fullauto.exe";print "LINE=".__LINE__."\n";
   &install_firefox() if -1<index $main::install_firefox,'Install';print "LINE=".__LINE__."\n";
} else {
   open(FH,">bin/fullauto");print "LINE=".__LINE__."\n";
   print FH "\n";print "LINE=".__LINE__."\n";
   close FH;print "LINE=".__LINE__."\n";
   install_script('bin/fullauto');print "LINE=".__LINE__."\n";
   unlink "bin/fullauto";print "LINE=".__LINE__."\n";
}
install_script('bin/fullauto.pl');print "LINE=".__LINE__."\n";

my $good_choice=<<'END';print "LINE=".__LINE__."\n";

     ___               _     ___ _        _        _ 
    / __| ___  ___  __| |   / __| |_  ___(_)__ ___| |
   | (_ |/ _ \/ _ \/ _` |  | (__| ' \/ _ \ / _/ -_)_|
    \___|\___/\___/\__,_|   \___|_||_\___/_\__\___(_)


   The Nano Editor is widely considered to be the easiest Terminal Editor to
   learn. Here are a couple of important things to remember. When you look at
   at the bottom of the screen, you will see character combinations like this:

   ^E ^W ^O  -->  the caret symbol (for Ctrl key) followed by a letter.

   Ctrl key is pressed with letter next to it. For example, to exit Nano (^E)
    ________     ____                    _______     ____ 
   || Ctrl ||   ||E ||                  || Alt ||   ||C ||
   ||______|| + ||__||  M-C  is  alt c  ||_____|| + ||__||
   |/______\|   |/__\|                  |/_____\|   |/__\|

END

my $nano_banner=<<END;print "LINE=".__LINE__."\n";

   .e.f8 ee.     88**8.  e888 88**8. .d88b.   GNU
   i '8f'  Q,    88  88 88 88 88  88 88  88
      8.   8:    88  88 "t888 88  88 "t88P"   Text Editor
      8.   8:
      W.   8:    In Terminal Environments, Documentation
           8:    for Nano can be seen anytime by typing:
           8:    
           tD    man nano    at the command line.


   You can also see online documentation at:

   http://www.nano-editor.org/docs.php
END

my $learn_nano=sub {

   my %learn_nano=(

      Name => 'learn_nano',
      Item_1 => {

         Text => "Go to Nano man page (type q to return)",
         Result => sub { system('man nano');return '<' },

      },
      Item_2 => {

         Text   => "Launch and explore Nano (type ctrl + e to return)",
         Result => sub { system('nano');return '<' },

      },
      Item_3 => {

         Text => "Continue Installing FullAuto",

      },
      Scroll => 3,
      Banner => $nano_banner,

   );print "LINE=".__LINE__."\n";
   return \%learn_nano;print "LINE=".__LINE__."\n";

};print "LINE=".__LINE__."\n";

my $goodchoice=sub {

   my %goodchoice=(

      Name => 'goodchoice',
      Item_1 => {

         Text   => "Learn more about Nano",
         Result => $learn_nano, 

      },
      Item_2 => {

         Text   => "Continue Installing FullAuto",

      },
      Scroll => 2,
      Banner => $good_choice,

   );print "LINE=".__LINE__."\n";
   return \%goodchoice;print "LINE=".__LINE__."\n";

};print "LINE=".__LINE__."\n";

sub fa_license {

   use if ($^O eq 'linux' || $^O eq 'freebsd'), "Term::Menus";print "LINE=".__LINE__."\n";

   my %read_license=(

      Name => 'read_license',
      Item_1 => {
         Text => "I accept the license provisions",
      },
      Item_2 => {
         Text => "I do *NOT* accept the license provisions ".
                 "(Install will Exit)",
      },
      Item_3 => {
         Text => "Review GNU Affero Public License Version 3\n".
                 "                   in its entirety".
                 " (type 'q' to return)",
         Result => sub { system('less LICENSE');return '<' },
      },
      Item_4 => {
         Text => "Return to previous screen",
         Result => sub { return '{license_agree}<' },
      },
      Scroll => 1,
      Banner => sub {
            my $linenumber="]P[";print "LINE=".__LINE__."\n";
            open (FH,"<LICENSE")
               or die "Cannot open LICENSE: $!\n";print "LINE=".__LINE__."\n";
            my @content=<FH>;print "LINE=".__LINE__."\n";
            close FH;print "LINE=".__LINE__."\n";
            my $co=$#content+1;print "LINE=".__LINE__."\n";
            my $endcount=(13<$co)?13:$co;print "LINE=".__LINE__."\n";
            if (-1==index $linenumber,'Review') {
               if ($linenumber=~/Next|Previous/) {
                  $linenumber=~s/^(?:Next|Previous) Page\s*//;print "LINE=".__LINE__."\n";
                }
               ($linenumber,$endcount)=split '-', $linenumber;print "LINE=".__LINE__."\n";
               my $tl=$#content+1;print "LINE=".__LINE__."\n";
               my $lt=$linenumber+13;print "LINE=".__LINE__."\n";
               $endcount=($lt<$tl)?$lt:$tl;print "LINE=".__LINE__."\n";
            } elsif (-1<index $linenumber,'WARRANTY') {
               $linenumber=588;print "LINE=".__LINE__."\n";
               $endcount=597;print "LINE=".__LINE__."\n";
            } else { $linenumber=1 }
            $linenumber=0 if $linenumber==1;print "LINE=".__LINE__."\n";
            --$endcount;print "LINE=".__LINE__."\n";
            my $banner=join "", @content[$linenumber..$endcount];print "LINE=".__LINE__."\n";
            $banner=~s/^/   /mg;print "LINE=".__LINE__."\n";
            return $banner;print "LINE=".__LINE__."\n";
         }

   );print "LINE=".__LINE__."\n";

   my $cryptography_banner=<<'END';print "LINE=".__LINE__."\n";
   __      __             _           _ 
   \ \    / /_ _ _ _ _ _ (_)_ _  __ _| |
    \ \/\/ / _` | '_| ' \| | ' \/ _` |_|
     \_/\_/\__,_|_| |_||_|_|_||_\__, (_)
                                |___/  

   Exporting, importing and/or using cryptography software, or even
   communicating technical details about cryptography software, is illegal
   in some parts of the world. You are strongly advised to investigate and
   adhere to any export/import and use laws which apply to you when you
   import a release of Net::FullAuto including cryptography modules like
   Crypt::CBC, Crypt::DES and Crypt::Rijndael to your country or
   re-distribute source code from them in any way.
END

   my $cryptography=sub {

      my %cryptography=(

         Name => 'cryptography',
         Result => sub { return '{license_agree}<' },
         Banner => $cryptography_banner,      

      );print "LINE=".__LINE__."\n";
      return \%cryptography

   };print "LINE=".__LINE__."\n";

   my $license_banner=<<END;print "LINE=".__LINE__."\n";

   *THANK YOU* For Trying FullAuto!   Net::FullAuto INSTALLATION PROGRAM

   Copyright (C) 2000-2015   Brian M. Kelly   Brian.Kelly\@FullAuto.com

   This program comes with ABSOLUTELY NO WARRANTY; for details select 2.
   This is free software, and you are welcome to redistribute it under certain
   conditions. Select 2 for full license. FullAuto uses  Crypt::DES  which is
   software developed by Systemics Ltd (http://www.systemics.com/). FullAuto
   uses the  Net::SSLeay  module which is software developed by the OpenSSL
   Project for use in the OpenSSL Toolkit. (http://www.openssl.org/) and
   includes cryptographic software written by Eric Young (eay\@cryptsoft.com)
   and Tim Hudson (tjh\@cryptsoft.com)

END

   my %license_agree=(

      Name => 'license_agree',
      Item_1 => {

         Text => "I agree to the license provisions\n\n",

      },
      Item_2 => {

         Text => "Review GNU Affero Public License WARRANTY DISCLAIMER\n",
         Result => \%read_license,
      },
      Item_3 => {

         Text => "*IMPORTANT* STRONG CRYPTOGRAPHY WARNING!",
         Result => $cryptography,

      },
      Item_4 => {

         Text => "I DO NOT AGREE to the license provisions\n".
                 "                   ( FullAuto Install will EXIT )",
      },
      Scroll => 1,
      Banner => $license_banner,

   );print "LINE=".__LINE__."\n";
   my $lic_sel='';print "LINE=".__LINE__."\n";
   unless (exists $ENV{PERL5_CPAN_IS_RUNNING}
         && $ENV{PERL5_CPAN_IS_RUNNING}) {
      $lic_sel=Menu(\%license_agree);print "LINE=".__LINE__."\n";
      chomp($lic_sel);print "LINE=".__LINE__."\n";
      exit if $lic_sel eq ']quit[';print "LINE=".__LINE__."\n";
      if (-1<index $lic_sel, 'NOT') {
         my $exitmsg=<<END;print "LINE=".__LINE__."\n";

   You have elected *NOT* to install FullAuto.
   Please report any bugs and send any
   questions, thoughts or feedback to:

      Brian.Kelly\@FullAuto.com.

   Press ANY key to exit.

END
         print $exitmsg;print "LINE=".__LINE__."\n";
         exit;print "LINE=".__LINE__."\n";
      }
   }

}

if (0) {
#if (keys %main::amazon) {
   fa_license();print "LINE=".__LINE__."\n";
   my @editors=('vim     ( ViIMproved - enhanced vi editor )',
                "emacs   ( The extensible, customizable, ".
                "self-documenting\n           ".
                "               real-time display editor )",
                "joe     ( Fast and simple editor that emulates".
                "\n             ".
                '             5 other editors )',
               );print "LINE=".__LINE__."\n";
   my $banner=<<'END';print "LINE=".__LINE__."\n";
    ___      _        _      ___    _ _ _
   / __| ___| |___ __| |_   | __|__| (_) |_ ___ _ _
   \__ \/ -_) / -_) _|  _|  | _|/ _` | |  _/ _ \ '_|
   |___/\___|_\___\__|\__|  |___\__,_|_|\__\___/_|

   In order to use the integrated edit features you will need to choose
   an editor. You can later change the selection in the Admin menu.

END

   my %Menu_select_editor=();print "LINE=".__LINE__."\n";
   %Menu_select_editor=(

         Label  => 'Menu_select_editor',
         Item_1 => {
            Text    => "nano    ( Easiest - Recommended for Beginners )",
            Result  => $goodchoice,
         },
         Item_2 => {

            Text    => "]C[",
            Convey  => \@editors,

         },
         Scroll => 1,
         Banner => $banner,

   );print "LINE=".__LINE__."\n";
   my $selection=Term::Menus::Menu(\%Menu_select_editor);print "LINE=".__LINE__."\n";
   exit if $selection eq ']quit[';print "LINE=".__LINE__."\n";
   $editor='nano';print "LINE=".__LINE__."\n";
   if ($selection=~/joe/) {
      open(AG,"sudo apt-get -y install 'joe'|");print "LINE=".__LINE__."\n";
      while (my $line=<AG>) {
         print $line;print "LINE=".__LINE__."\n";
      }
      close AG;print "LINE=".__LINE__."\n";
      $editor='joe';print "LINE=".__LINE__."\n";
   } elsif ($selection=~/emacs/) {
      open(AG,"sudo apt-get -y install 'e3'|");print "LINE=".__LINE__."\n";
      while (my $line=<AG>) {
         print $line;print "LINE=".__LINE__."\n";
      }
      close AG;print "LINE=".__LINE__."\n";
      $editor='emacs';print "LINE=".__LINE__."\n";
   } elsif ($selection=~/vim/) {
      $editor='vi';print "LINE=".__LINE__."\n";
   }

}

WriteAll();print "LINE=".__LINE__."\n";

if (keys %main::amazon) {
   system('sudo make install');print "LINE=".__LINE__."\n";
   if (exists $main::amazon{argv}) {
      my $p=$main::amazon{argv}->[0];print "LINE=".__LINE__."\n";
      my $username=getlogin || getpwuid($<);print "LINE=".__LINE__."\n";
      exec "/usr/local/bin/fa",'-i',$p,
           '--iset-amazon','--login',
           $username,'--log';print "LINE=".__LINE__."\n";
   }
}

sub fa_find_editor {
   my $editor=$_[0];print "LINE=".__LINE__."\n";
   $editor=~s/^.*\///;print "LINE=".__LINE__."\n";
   $editor=~s/[.]exe$//;print "LINE=".__LINE__."\n";
   return 0 unless $editor;print "LINE=".__LINE__."\n";
   foreach my $path (split ':', $ENV{PATH}) {
      $path=~s/[\/]*$/\//;print "LINE=".__LINE__."\n";
      if ($^O eq 'cygwin' && (-e $path.$editor.'.exe')) {
         return $path.$editor.'.exe';print "LINE=".__LINE__."\n";
      } elsif (-e $path.$editor) {
         return $path.$editor;print "LINE=".__LINE__."\n";
      }
   } return 0;print "LINE=".__LINE__."\n";
}

package MY; # so that "SUPER" works right
sub MY::top_targets {

   my $inherited = shift->SUPER::top_targets(@_);print "LINE=".__LINE__."\n";

   $inherited =~ s/pure_all :: /pure_all :: fullauto\$(EXE_EXT) /;print "LINE=".__LINE__."\n";
   $inherited =~ s/ linkext//;print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::makefile {

   use Config;print "LINE=".__LINE__."\n";

   my $inherited = shift->SUPER::makefile(@_);print "LINE=".__LINE__."\n";

   $inherited .= "fullauto\$(EXE_EXT): fullauto.c\n\t\$(CC) fullauto.c -o \$@".
                 "\n\t\$(CP) \$@ bin\n\n";print "LINE=".__LINE__."\n";

   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_host.pm") {
      $inherited .= "lib/Net/FullAuto/Custom/fa_host.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_host.pm \$@\n\n";print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*FullAuto.*fa_host.pm.*)$//m;print "LINE=".__LINE__."\n";
      $inherited .= "lib/Net/FullAuto/Custom/fa_host.pm:".
                    "\n\t\$(NOECHO)\n\n";print "LINE=".__LINE__."\n";
      unlink "lib/Net/FullAuto/Custom/fa_host.pm";print "LINE=".__LINE__."\n";
      unlink "blib/lib/Net/FullAuto/Custom/fa_host.pm";print "LINE=".__LINE__."\n";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
      $editor=~s/\//\\\//g;print "LINE=".__LINE__."\n";
      $inherited .= "lib/Net/FullAuto/Custom/fa_conf.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_conf.pm \$@\n\n";print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_conf.pm.*)$//m;print "LINE=".__LINE__."\n";
      $inherited .= "lib/Net/FullAuto/Custom/fa_conf.pm:".
                    "\n\t\$(NOECHO)\n\n";print "LINE=".__LINE__."\n";
      unlink "lib/Net/FullAuto/Custom/fa_conf.pm";print "LINE=".__LINE__."\n";
      unlink "blib/Net/FullAuto/Custom/fa_conf.pm";print "LINE=".__LINE__."\n";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_menu.pm") {
      $inherited .= "lib/Net/FullAuto/Custom/fa_menu.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_menu.pm \$@\n\n";print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_menu.pm.*)$//m;print "LINE=".__LINE__."\n";
      $inherited .= "lib/Net/FullAuto/Custom/fa_menu.pm:".
                    "\n\t\$(NOECHO)\n\n";print "LINE=".__LINE__."\n";
      unlink "lib/Net/FullAuto/Custom/fa_menu.pm";print "LINE=".__LINE__."\n";
      unlink "blib/lib/Net/FullAuto/Custom/fa_menu.pm";print "LINE=".__LINE__."\n";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_code.pm") {
      $inherited .= "lib/Net/FullAuto/Custom/fa_code.pm:".
                    "\n\t\$(CP) lib/Net/FullAuto/Distro/fa_code.pm \$@\n\n";print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_code.pm.*)$//m;print "LINE=".__LINE__."\n";
      $inherited .= "lib/Net/FullAuto/Custom/fa_code.pm:".
                    "\n\t\$(NOECHO)\n\n";print "LINE=".__LINE__."\n";
      unlink "lib/Net/FullAuto/Custom/fa_code.pm";print "LINE=".__LINE__."\n";
      unlink "blib/lib/Net/FullAuto/Custom/fa_code.pm";print "LINE=".__LINE__."\n";
   }
   if (-1<index $main::install_firefox,'Install') {
      my $cygwin_loc=main::get_cygwin_location(1);print "LINE=".__LINE__."\n";
      $cygwin_loc=~s/\\/\//;print "LINE=".__LINE__."\n";
      $inherited .= "$Config{installsitelib}/Net/FullAuto/$main::mozrepl_file:".
                    "\n\t\$(CP) $cygwin_loc/$main::mozrepl_file \$@\n\n";print "LINE=".__LINE__."\n";
   }

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::dist {

   use Config;print "LINE=".__LINE__."\n";

   my $inherited = shift->SUPER::dist(@_);print "LINE=".__LINE__."\n";

   if (grep { /-*add[-_]?dependencies/i } @ARGV) {

      $inherited =~ s/^(DISTVNAME.*Net-FullAuto)(.*)$/$1-Complete$2/m;print "LINE=".__LINE__."\n";

   }

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::tools_other {

   use Config;print "LINE=".__LINE__."\n";

   my $inherited = shift->SUPER::tools_other(@_);print "LINE=".__LINE__."\n";

   $inherited =~
      s/^MV.*$/MV = mv -f/m;print "LINE=".__LINE__."\n";

   $inherited =~
      s/^(MV.*)$/$1\nSED = sed/m;print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::constants {

   use Config;print "LINE=".__LINE__."\n";

   my $inherited = shift->SUPER::constants(@_);print "LINE=".__LINE__."\n";

   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_host.pm") {
      my $fa_h="\tlib\/Net\/FullAuto\/Custom\/fa_host.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_host.pm \\";print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+lib.*Distro\/fa_host.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_host.pm \\/m; 
      $inherited =~
         s/(\s+blib.*Distro\/fa_host.pm \\)/$1\n$fa_h/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_host.pm.*)$//;print "LINE=".__LINE__."\n";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
      my $fa_g="\tlib\/Net\/FullAuto\/Custom\/fa_conf.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_conf.pm \\";print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+lib.*Distro\/fa_conf.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_conf.pm \\/m;print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+blib.*Distro\/fa_conf.pm \\)/$1\n$fa_g/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_conf.pm.*)$//;print "LINE=".__LINE__."\n";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_menu.pm") {
      my $fa_m="\tlib\/Net\/FullAuto\/Custom\/fa_menu.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_menu.pm \\";print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+lib.*Distro\/fa_menu.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_menu.pm \\/m;print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+blib.*Distro\/fa_menu.pm \\)/$1\n$fa_m/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_menu.pm.*)$//;print "LINE=".__LINE__."\n";
   }
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_code.pm") {
      my $fa_c="\tlib\/Net\/FullAuto\/Custom\/fa_code.pm ".
               "\\\n\tblib\/Net\/FullAuto\/Custom\/fa_code.pm \\";print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+lib.*Distro\/fa_code.pm \\)/$1\n\tlib\/Net\/FullAuto\/Custom\/fa_code.pm \\/m;print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+blib.*Distro\/fa_code.pm \\)/$1\n$fa_c/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/^(.*Custom\/fa_code.pm.*)$//;print "LINE=".__LINE__."\n";
   }

   $inherited =~ 
      s/(PERM_RWX = \d+)/$1\nPERM_S_X = 4511\nPERM_G_X = 2551/m;print "LINE=".__LINE__."\n";
   $inherited =~
      s/(PERM_G_X = \d+)/$1\nPERM_S+X = 4555\n/m;print "LINE=".__LINE__."\n";
   $inherited =~
      s/(PERM_S[+]X = \d+)/$1\nPERM_R+X = 555\nPERM_R-X = 550\nPERM_R_X = 511/m;print "LINE=".__LINE__."\n";
   $inherited =~
      s/(PERM_R_X = \d+)/$1\nPERM_D-X = 750\nPERM_D_X = 700\nPERM_WRX = 777/m;print "LINE=".__LINE__."\n";
   $inherited =~
      s/(PERM_WRX = \d+)/$1\nPERM_OG_ = 770/m;print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER works right
sub MY::installbin {

   my $inherited = shift->SUPER::installbin(@_);print "LINE=".__LINE__."\n";

   $inherited =~ s/RM_F\) \\/RM_F\) bin\/fullauto\$(EXE_EXT) fullauto.c fullauto\$(EXE_EXT)\\/;print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::install {

   use Config;print "LINE=".__LINE__."\n";
   my $inherited = shift->SUPER::install(@_);print "LINE=".__LINE__."\n";

   if ($permission eq 'Setuid') {
      $inherited =~ s/(install ::.*)$/$1 setuid_permissions/m;print "LINE=".__LINE__."\n";
   } elsif ($permission eq 'Setgid') {
      $inherited =~ s/(install ::.*)$/$1 setgid_permissions/m;print "LINE=".__LINE__."\n";
   } elsif ($permission eq 'Owner-Group') {
      if (-1<index $main::install_firefox,'Install') {
         my $mz="$Config{installsitelib}/Net/FullAuto/$main::mozrepl_file";print "LINE=".__LINE__."\n";
         $inherited =~
            s/(install ::.*)$/$1 owner_group_permissions $mz/m;print "LINE=".__LINE__."\n";
      } else {
         $inherited =~ s/(install ::.*)$/$1 owner_group_permissions/m;print "LINE=".__LINE__."\n";
      }
   } else {
      if (-1<index $main::install_firefox,'Install') {
         my $mz="$Config{installsitelib}/Net/FullAuto/$main::mozrepl_file";print "LINE=".__LINE__."\n";
         $inherited =~
            s/(install ::.*)$/$1 full_access_permissions $mz/m;print "LINE=".__LINE__."\n";
      } else {
         $inherited =~ s/(install ::.*)$/$1 full_access_permissions/m;print "LINE=".__LINE__."\n";
      }
   }

   if (-e '/usr/share/figlet') {
      $inherited =~ s/(install ::.*)$/$1 figlet_fonts/m;print "LINE=".__LINE__."\n";
   }

   my $link='';print "LINE=".__LINE__."\n";
   my $lnpath='';print "LINE=".__LINE__."\n";
   if (-e "/bin/ln") {
      $lnpath="/bin/ln";print "LINE=".__LINE__."\n";
   } elsif (-e "/usr/bin/ln") {
      $lnpath="/usr/bin/ln";print "LINE=".__LINE__."\n";
   } elsif (-e "/usr/local/bin/ln") {
      $lnpath="/usr/local/bin/ln";print "LINE=".__LINE__."\n";
   }

   if ($lnpath) {
      $link="\t\$(NOECHO) $lnpath -f -s ".
            "\$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT) ".
            "\$(DESTINSTALLSITESCRIPT)\/fa\n"; 
   }

   $inherited .= "\nsetuid_permissions ::\n".
     "\t\$(NOECHO) \$(ECHO) \"Applying Setuid Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_S+X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_D_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n".
      $link;print "LINE=".__LINE__."\n";
   $inherited .= "\nsetgid_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Setgid Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_G_X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_D-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n".
      $link;print "LINE=".__LINE__."\n";
   $inherited .= "\nowner_group_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Owner-Group Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_OG_) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_OG_) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/Custom\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_OG_) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/Custom\/*\n".
      $link.
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_OG_) /var\n".
      "\t\$(NOECHO) if [ -d /var/db ];".
      "then \$(CHMOD) \$(PERM_OG_) /var/db; fi\n";print "LINE=".__LINE__."\n";
      "\t\$(NOECHO) if [ -d /var/db/Berkeley ];".
      "then \$(CHMOD) \$(PERM_OG_) /var/db/Berkeley; fi\n";print "LINE=".__LINE__."\n";
      "\t\$(NOECHO) if [ -d /var/db/Berkeley/FullAuto ];".
      "then \$(CHMOD) \$(PERM_OG_) /var/db/Berkeley/FullAuto; fi\n";print "LINE=".__LINE__."\n";
   $inherited .= "\t\$(SED) \'s/^[ ]*our[ ]*\\(.\\)".
      "cygwin_berkeley_db_mode[ ]*[=].*/".'our \\1'.
      "cygwin_berkeley_db_mode = \$(PERM_OG_);/g\' ".
      "\$(DESTINSTALLSITELIB)/Net/FullAuto/FA_Core.pm >tmp_fa_core.pm\n".
      "\t\$(MV) ./tmp_fa_core.pm \$(DESTINSTALLSITELIB)".
      "/Net/FullAuto/FA_Core.pm\n"
      if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
   $inherited .= "\nfull_access_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Full-Access Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_WRX) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_WRX) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/Custom\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_WRX) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/Custom\/*\n".
      $link.
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_WRX) /var\n".
      "\t\$(NOECHO) if [ -d /var/db ];".
      "then \$(CHMOD) \$(PERM_WRX) /var/db; fi\n";print "LINE=".__LINE__."\n";
      "\t\$(NOECHO) if [ -d /var/db/Berkeley ];".
      "then \$(CHMOD) \$(PERM_WRX) /var/db/Berkeley; fi\n";print "LINE=".__LINE__."\n";
      "\t\$(NOECHO) if [ -d /var/db/Berkeley/FullAuto ];".
      "then \$(CHMOD) \$(PERM_WRX) /var/db/Berkeley/FullAuto; fi\n";print "LINE=".__LINE__."\n";
   $inherited .= "\t\$(SED) \'s/^[ ]*our[ ]*\\(.\\)".
      "cygwin_berkeley_db_mode[ ]*[=].*/".'our \\1'.
      "cygwin_berkeley_db_mode = \$(PERM_WRX);/g\' ".
      "\$(DESTINSTALLSITELIB)/Net/FullAuto/FA_Core.pm >tmp_fa_core.pm\n".
      "\t\$(MV) ./tmp_fa_core.pm \$(DESTINSTALLSITELIB)".
      "/Net/FullAuto/FA_Core.pm\n"
      if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
   $inherited .= "\nfiglet_fonts ::\n".
      "\t\$(NOECHO) \$(CP) dependencies/FIGlet_fonts/* /usr/share/figlet";print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::dist_core {

   my $inherited = shift->SUPER::dist_core(@_);print "LINE=".__LINE__."\n";

   $inherited =~ s/tar$/tar\n\t\$(MV) \$(DISTVNAME).tar\$(SUFFIX) dist/m;print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::clean {

   my $inherited = shift->SUPER::clean(@_);print "LINE=".__LINE__."\n";

   $inherited =~ s/blib\s*$/blib setup\$(EXE_EXT) /m;print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::distdir {

   my $inherited = shift->SUPER::distdir(@_);print "LINE=".__LINE__."\n";

   $inherited =~ s/^(distdir .*)$/$1 distsignature/m;print "LINE=".__LINE__."\n";

   $inherited; #

}

package MY; # so that "SUPER" works right
sub MY::pm_to_blib {

   use Config;print "LINE=".__LINE__."\n";

   my $inherited = shift->SUPER::pm_to_blib(@_);print "LINE=".__LINE__."\n";

   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_host.pm") &&
         ($inherited !~ /Custom\/fa_host.pm/)) {
      my $fa_h="\t  lib\/Net\/FullAuto\/Custom\/fa_host.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_host.pm";print "LINE=".__LINE__."\n";
      my $wrap='';print "LINE=".__LINE__."\n";
      $inherited =~ /\s+blib.*Distro\/fa_host.pm( \\)/m;print "LINE=".__LINE__."\n";
      $wrap=$1;print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+blib.*Distro\/fa_host.pm).*/$1 \\\n$fa_h$wrap/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/.*Custom\/fa_host.pm.*\n//m;print "LINE=".__LINE__."\n";
   }
   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") &&
         ($inherited !~ /Custom\/fa_conf.pm/)) {
      my $fa_g="\t  lib\/Net\/FullAuto\/Custom\/fa_conf.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_conf.pm";print "LINE=".__LINE__."\n";
      my $wrap='';print "LINE=".__LINE__."\n";
      $inherited =~ /\s+blib.*Distro\/fa_conf.pm( \\)/m;print "LINE=".__LINE__."\n";
      $wrap=$1;print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+blib.*Distro\/fa_conf.pm).*/$1 \\\n$fa_g$wrap/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/.*Custom\/fa_conf.pm.*\n//m;print "LINE=".__LINE__."\n";
   }
   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_menu.pm") &&
         ($inherited !~ /Custom\/fa_menu.pm/)) {
      my $fa_m="\t  lib\/Net\/FullAuto\/Custom\/fa_menu.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_menu.pm";print "LINE=".__LINE__."\n";
      my $wrap='';print "LINE=".__LINE__."\n";
      $inherited =~ /\s+blib.*Distro\/fa_menu.pm( \\)/m;print "LINE=".__LINE__."\n";
      $wrap=$1;print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+blib.*Distro\/fa_menu.pm).*/$1 \\\n$fa_m$wrap/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/.*Custom\/fa_menu.pm.*\n//m;print "LINE=".__LINE__."\n";
   }
   unless ((-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_code.pm") &&
         ($inherited !~ /Custom\/fa_code.pm/)) {
      my $fa_c="\t  lib\/Net\/FullAuto\/Custom\/fa_code.pm ".
               "blib\/lib\/Net\/FullAuto\/Custom\/fa_code.pm";print "LINE=".__LINE__."\n";
      my $wrap='';print "LINE=".__LINE__."\n";
      $inherited =~ /\s+blib.*Distro\/fa_code.pm( \\)/m;print "LINE=".__LINE__."\n";
      $wrap=$1;print "LINE=".__LINE__."\n";
      $inherited =~
         s/(\s+blib.*Distro\/fa_code.pm).*/$1 \\\n$fa_c$wrap/m;print "LINE=".__LINE__."\n";
   } else {
      $inherited =~ s/.*Custom\/fa_code.pm.*\n//m;print "LINE=".__LINE__."\n";
   }
   
   $inherited =~ s/\s+\\(\s*[$][(]NOE)/$1/s;print "LINE=".__LINE__."\n";
   $inherited =~ s/([\$][(]NOECHO[)] [\$])/-$1/s;print "LINE=".__LINE__."\n";
   my $newline_flag=0;print "LINE=".__LINE__."\n";
   unless (-e $Config{installsitelib}."/Net/FullAuto/Custom/fa_conf.pm") {
      $inherited .= "\t\$(SED) \'s/^#[ ]*our[ ]*\\(.\\)editor[ ]*[=].*/".
         'our \\1'."editor = \"$editor\";/g\' ".
         "blib/lib/Net/FullAuto/Custom/fa_conf.pm >tmp_conf.pm\n".
         "\t\$(MV) tmp_conf.pm blib/lib/Net/FullAuto/Custom/fa_conf.pm\n\n"
         if defined $editor and $editor;print "LINE=".__LINE__."\n";
   } else {
      $newline_flag=1;print "LINE=".__LINE__."\n";
      $inherited .= "\n";print "LINE=".__LINE__."\n";
   }

   unless (-e $Config{installsitelib}."/Net/FullAuto/FA_Core.pm") {
      $inherited .= "\t\$(SED) \'s/^[ ]*our[ ]*\\(.\\)".
         "cygwin_berkeley_db_mode[ ]*[=].*/".'our \\1'.
         "cygwin_berkeley_db_mode = $main::cygwin_berkeley_db_mode;/g\' ".
         "blib/lib/Net/FullAuto/FA_Core.pm >tmp_fa_core.pm\n".
         "\t\$(MV) ./tmp_fa_core.pm blib/lib".
         "/Net/FullAuto/FA_Core.pm\n\n"
         if $^O eq 'cygwin';print "LINE=".__LINE__."\n";
   } elsif (!$newline_flag) {
      $inherited .= "\n";print "LINE=".__LINE__."\n";
   }

   $inherited; #

}

package FA::LWP::UserAgent;print "LINE=".__LINE__."\n";
use strict;print "LINE=".__LINE__."\n";
our @ISA = qw(LWP::UserAgent); # inherits from LWP::UserAgent
use vars qw(@ISA $USER $PASSWD $SETUPDONE);print "LINE=".__LINE__."\n";
# we delay requiring LWP::UserAgent and setting up inheritance until we need it

$FA::LWP::UserAgent::VERSION = "1.94";print "LINE=".__LINE__."\n";

sub config {
    return if $SETUPDONE;print "LINE=".__LINE__."\n";
    if ($CPAN::META->has_usable('LWP::UserAgent')) {
        require LWP::UserAgent;print "LINE=".__LINE__."\n";
        @ISA = qw(Exporter LWP::UserAgent); ## no critic
        $SETUPDONE++;print "LINE=".__LINE__."\n";
    } else {
        $CPAN::Frontend->mywarn("  LWP::UserAgent not available\n");print "LINE=".__LINE__."\n";
    }
}

sub get_basic_credentials {
    my($self, $realm, $uri, $proxy) = @_;print "LINE=".__LINE__."\n";
    if ($USER && $PASSWD) {
        return ($USER, $PASSWD);print "LINE=".__LINE__."\n";
    }
    if ( $proxy ) {
        ($USER,$PASSWD) = $self->get_proxy_credentials();print "LINE=".__LINE__."\n";
    } else {
        ($USER,$PASSWD) = $self->get_non_proxy_credentials();print "LINE=".__LINE__."\n";
    }
    return($USER,$PASSWD);print "LINE=".__LINE__."\n";
}

sub get_proxy_credentials {
    my $self = shift;print "LINE=".__LINE__."\n";
    my ($user, $password);print "LINE=".__LINE__."\n";
    if ( defined $CPAN::Config->{proxy_user} ) {
        $user = $CPAN::Config->{proxy_user};print "LINE=".__LINE__."\n";
        $password = $CPAN::Config->{proxy_pass} || "";print "LINE=".__LINE__."\n";
        return ($user, $password);print "LINE=".__LINE__."\n";
    }
    my $username_prompt = "\nProxy authentication needed!
 (Note: to permanently configure username and password run
   o conf proxy_user your_username
   o conf proxy_pass your_password
     )\nUsername:";print "LINE=".__LINE__."\n";
    ($user, $password) =
        _get_username_and_password_from_user($username_prompt);print "LINE=".__LINE__."\n";
    return ($user,$password);print "LINE=".__LINE__."\n";
}

sub get_non_proxy_credentials {
    my $self = shift;print "LINE=".__LINE__."\n";
    my ($user,$password);print "LINE=".__LINE__."\n";
    if ( defined $CPAN::Config->{username} ) {
        $user = $CPAN::Config->{username};print "LINE=".__LINE__."\n";
        $password = $CPAN::Config->{password} || "";print "LINE=".__LINE__."\n";
        return ($user, $password);print "LINE=".__LINE__."\n";
    }
    my $username_prompt = "\nAuthentication needed!
     (Note: to permanently configure username and password run
       o conf username your_username
       o conf password your_password
     )\nUsername:";print "LINE=".__LINE__."\n";

    ($user, $password) =
        _get_username_and_password_from_user($username_prompt);print "LINE=".__LINE__."\n";
    return ($user,$password);print "LINE=".__LINE__."\n";
}

sub _get_username_and_password_from_user {
    my $username_message = shift;print "LINE=".__LINE__."\n";
    my ($username,$password);print "LINE=".__LINE__."\n";

    ExtUtils::MakeMaker->import(qw(prompt));print "LINE=".__LINE__."\n";
    $username = prompt($username_message);print "LINE=".__LINE__."\n";
        if ($CPAN::META->has_inst("Term::ReadKey")) {
            Term::ReadKey::ReadMode("noecho");print "LINE=".__LINE__."\n";
        }
    else {
        $CPAN::Frontend->mywarn(
            "Warning: Term::ReadKey seems not to be available, ".
            "your password will be echoed to the terminal!\n"
        );print "LINE=".__LINE__."\n";
    }
    $password = prompt("Password:");print "LINE=".__LINE__."\n";

        if ($CPAN::META->has_inst("Term::ReadKey")) {
            Term::ReadKey::ReadMode("restore");print "LINE=".__LINE__."\n";
        }
        $CPAN::Frontend->myprint("\n\n");print "LINE=".__LINE__."\n";
    return ($username,$password);print "LINE=".__LINE__."\n";
}

# mirror(): Its purpose is to deal with proxy authentication. When we
# call SUPER::mirror, we relly call the mirror method in
# LWP::UserAgent. LWP::UserAgent will then call
# $self->get_basic_credentials or some equivalent and this will be
# $self->dispatched to our own get_basic_credentials method.

# Our own get_basic_credentials sets $USER and $PASSWD, two globals.

# 407 stands for HTTP_PROXY_AUTHENTICATION_REQUIRED. Which means
# although we have gone through our get_basic_credentials, the proxy
# server refuses to connect. This could be a case where the username or
# password has changed in the meantime, so I'm trying once again without
# $USER and $PASSWD to give the get_basic_credentials routine another
# chance to set $USER and $PASSWD.

# mirror(): Its purpose is to deal with proxy authentication. When we
# call SUPER::mirror, we relly call the mirror method in
# LWP::UserAgent. LWP::UserAgent will then call
# $self->get_basic_credentials or some equivalent and this will be
# $self->dispatched to our own get_basic_credentials method.

# Our own get_basic_credentials sets $USER and $PASSWD, two globals.

# 407 stands for HTTP_PROXY_AUTHENTICATION_REQUIRED. Which means
# although we have gone through our get_basic_credentials, the proxy
# server refuses to connect. This could be a case where the username or
# password has changed in the meantime, so I'm trying once again without
# $USER and $PASSWD to give the get_basic_credentials routine another
# chance to set $USER and $PASSWD.

sub mirror {
    my($self,$url,$aslocal) = @_;print "LINE=".__LINE__."\n";
    my $result = $self->SUPER::mirror($url,$aslocal);print "LINE=".__LINE__."\n";
    if ($result->code == 407) {
        undef $USER;print "LINE=".__LINE__."\n";
        undef $PASSWD;print "LINE=".__LINE__."\n";
        $result = $self->SUPER::mirror($url,$aslocal);print "LINE=".__LINE__."\n";
    }
    $result;print "LINE=".__LINE__."\n";
}

1;print "LINE=".__LINE__."\n";
