#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;

unless ( $ENV{RELEASE_TESTING} && $ENV{RELEASE_TESTING} == 2) {
        plan( skip_all => "Author tests not required for installation" );
}

use Firewall::PaloAlto::Panorama;

my $pa;
my $pa_host = 'panorama.local';

ok( $pa = Firewall::PaloAlto::Panorama->new(host => $pa_host, username => 'admin', password => 'admin', ssl => 0 ) );
ok( $pa->connect() );

#Adding a new device
ok ( $pa->managed_device('set', serial => '12345678') );
ok ( $pa->managed_device('delete', serial => '12345678') );

#Set and get templates
ok ( $pa->template('set', name => "TT", description => "Description") );
ok ( $pa->template('set', name => "TT1", description => "Description") );

ok ( $pa->template('get', name => "TT") );
ok ( $pa->template('get', name => "TT1") );

#Set and get template-stack
ok ( $pa->template_stack('set', name => "TS", templates => [ 'TT', 'TT1'], description => "Description") );
ok ( $pa->template_stack('get', name => "TS") );

#Delete the template stack
ok ( $pa->template_stack('delete', name => "TS") );

#Create a new vsys through one of the templates
ok ( $pa->vsys('set', template => 'TT', name => 'TVsys', max_sessions => 100, max_rules => 100) );

#Create a new sub-interface
# TODO: Fix the parent interface argument ok ( $pa->subinterface('set', template => 'TT', parent => 'ae1', tag => 10, comment => 'Test Subint') );

#Create a new virtual router
ok ( $pa->virtual_router('set', template => 'TT', name => 'TVR', interface => [ 'ae1.10' ]) );

#Delete the templates
#ok ( $pa->template('delete', name => "TT") );
ok ( $pa->template('delete', name => "TT1") );

#Create, get and set a device group
ok ( $pa->devicegroup('set', name => 'TestDG', description => 'Test DG Description') );
ok ( $pa->devicegroup('get', name => 'TestDG') );
ok ( $pa->devicegroup('delete', name => 'TestDG') );

done_testing();

