#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;

unless ( $ENV{RELEASE_TESTING} ) {
        plan( skip_all => "Author tests not required for installation" );
}

plan tests => 16;

use Firewall::PaloAlto;

my $pa;
my $pa_host = 'pa.local';

ok( $pa = Firewall::PaloAlto->new(host => $pa_host, username => 'admin', password => 'admin', ssl => 0 ) );
ok( $pa->connect() );

#Create addresses
ok( $pa->address('set', name => 'TestAddress1', 'ip-netmask' => '1.1.1.1/32') );
ok( $pa->address('set', name => 'TestAddress2', 'ip-range' => '1.1.1.0-1.1.1.15') );

#Create address-group with addresses as well as explicity
ok( $pa->address_group('set', name => 'TestAddressGroup', static => [ 'TestAddress1', 'TestAddress2' ]) );

#Create two zones with no interfaces
ok( $pa->zone('set', zone => 'TestZone1', layer3 => []) );
ok( $pa->zone('set', zone => 'TestZone2', layer3 => []) );

#Create a virtual router
ok( $pa->virtual_router('set', vr_name => 'TestVirtualRouter1', interface => []) );

#Create a static IPv4 and IPv6 route
ok( $pa->ipv4_static_route('set', vr_name => 'TestVirtualRouter1', route_name => 'TestRouteIPv4', destination => '8.8.8.0/24', nexthop => { 'ip-address' => '1.1.1.1/32' } ) );
ok( $pa->ipv6_static_route('set', vr_name => 'TestVirtualRouter1', route_name => 'TestRouteIPv6', destination => '2002:8:8:8::/64', nexthop => { 'ipv6-address' => '2002::1' } ) );

#Delete a static IPv4 and IPv6 route
ok( $pa->ipv4_static_route('delete', vr_name => 'TestVirtualRouter1', route_name => 'TestRouteIPv4') );
ok( $pa->ipv6_static_route('delete', vr_name => 'TestVirtualRouter1', route_name => 'TestRouteIPv6') );

#Delete the virtual router
ok( $pa->virtual_router('delete', vr_name => 'TestVirtualRouter1') );

#Delete the address-group
ok( $pa->address_group('delete', name => 'TestAddressGroup') );

#Delete the addresses
ok( $pa->address('delete', name => 'TestAddress1') );
ok( $pa->address('delete', name => 'TestAddress2') );
